/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./_AnnotationHelperBasics','sap/ui/base/BindingParser','sap/ui/base/ManagedObject','sap/ui/core/format/DateFormat','sap/ui/model/odata/ODataUtils'],function(q,B,a,M,D,O){'use strict';var A="sap.ui.model.odata.AnnotationHelper",d="\\d{4}-(?:0[1-9]|1[0-2])-(?:0[1-9]|[12]\\d|3[01])",s="[-+]?\\d+(?:\\.\\d+)?",m="9007199254740991",b="-"+m,p=[A],P=A+"/getExpression",t="(?:[01]\\d|2[0-3]):[0-5]\\d(?::[0-5]\\d(\\.\\d{1,12})?)?",E={Bool:/^true$|^false$/i,Float:new RegExp("^"+s+"(?:[eE][-+]?\\d+)?$|^NaN$|^-INF$|^INF$"),Date:new RegExp("^"+d+"$"),DateTimeOffset:new RegExp("^"+d+"T"+t+"(?:Z|[-+](?:0\\d|1[0-3]):[0-5]\\d|[-+]14:00)$","i"),Decimal:new RegExp("^"+s+"$"),Guid:/^[A-F0-9]{8}-(?:[A-F0-9]{4}-){3}[A-F0-9]{12}$/i,Int:/^[-+]?\d{1,19}$/,TimeOfDay:new RegExp("^"+t+"$")},c,r=/^\{@i18n>[^\\\{\}:]+\}$/,f=/^\d+$/,o={And:"&&",Eq:"===",Ge:">=",Gt:">",Le:"<=",Lt:"<",Ne:"!==",Not:"!",Or:"||"},g=/^(\/dataServices\/schema\/\d+)(?:\/|$)/,T={"Edm.Boolean":"boolean","Edm.Byte":"number","Edm.Date":"date","Edm.DateTime":"datetime","Edm.DateTimeOffset":"datetime","Edm.Decimal":"decimal","Edm.Double":"number","Edm.Float":"number","Edm.Guid":"string","Edm.Int16":"number","Edm.Int32":"number","Edm.Int64":"decimal","Edm.SByte":"number","Edm.Single":"number","Edm.String":"string","Edm.Time":"time","Edm.TimeOfDay":"time"},h={Bool:"Edm.Boolean",Float:"Edm.Double",Date:"Edm.Date",DateTimeOffset:"Edm.DateTimeOffset",Decimal:"Edm.Decimal",Guid:"Edm.Guid",Int:"Edm.Int64",String:"Edm.String",TimeOfDay:"Edm.TimeOfDay"},j={"boolean":false,"date":true,"datetime":true,"decimal":true,"number":false,"string":false,"time":true};c={adjustOperands:function(e,i){if(e.result!=="constant"&&e.category==="number"&&i.result==="constant"&&i.type==="Edm.Int64"){i.category="number";}if(e.result!=="constant"&&e.category==="decimal"&&i.result==="constant"&&i.type==="Edm.Int32"){i.category="decimal";i.type=e.type;}if(e.result==="constant"&&e.category==="date"&&i.result!=="constant"&&i.category==="datetime"){i.category="date";}},apply:function(i,e){var n=B.descend(e,"Name","string"),k=B.descend(e,"Parameters");switch(n.value){case"odata.concat":return c.concat(i,k);case"odata.fillUriTemplate":return c.fillUriTemplate(i,k);case"odata.uriEncode":return c.uriEncode(i,k);default:B.error(n,"unknown function: "+n.value);}},concat:function(I,e){var k=e.asExpression,l=[],R,n=[];B.expectType(e,"array");e.value.forEach(function(u,i){R=c.parameter(I,e,i);k=k||R.result==="expression";n.push(R);});n.forEach(function(R){if(k){c.wrapExpression(R);}if(R.type!=='edm:Null'){l.push(B.resultToString(R,k,e.withType));}});R=k?{result:"expression",value:l.join("+")}:{result:"composite",value:l.join("")};R.type="Edm.String";return R;},conditional:function(i,e){var C=c.parameter(i,e,0,"Edm.Boolean"),k=c.parameter(i,e,1),l=c.parameter(i,e,2),n=k.type,w=e.withType;if(k.type==="edm:Null"){n=l.type;}else if(l.type!=="edm:Null"&&k.type!==l.type){B.error(e,"Expected same type for second and third parameter, types are '"+k.type+"' and '"+l.type+"'");}return{result:"expression",type:n,value:B.resultToString(c.wrapExpression(C),true,false)+"?"+B.resultToString(c.wrapExpression(k),true,w)+":"+B.resultToString(c.wrapExpression(l),true,w)};},constant:function(i,e,k){var v=e.value;B.expectType(e,"string");if(k==="String"){if(r.test(v)){return{ignoreTypeInPath:true,result:"binding",type:"Edm.String",value:v.slice(1,-1)};}else if(i.getSetting&&i.getSetting("bindTexts")){return{result:"binding",type:"Edm.String",ignoreTypeInPath:true,value:"/##"+c.replaceIndexes(i.getModel(),e.path)};}k="Edm.String";}else if(!E[k].test(v)){B.error(e,"Expected "+k+" value but instead saw '"+v+"'");}else{k=h[k];if(k==="Edm.Int64"&&O.compare(v,b,true)>=0&&O.compare(v,m,true)<=0){k="Edm.Int32";}}return{result:"constant",type:k,value:v};},expression:function(i,e){var R=e.value,S,k;B.expectType(e,"object");if(R.hasOwnProperty("Type")){k=B.property(e,"Type","string");S=B.descend(e,"Value");}else{["And","Apply","Bool","Date","DateTimeOffset","Decimal","Float","Eq","Ge","Gt","Guid","If","Int","Le","Lt","Ne","Not","Null","Or","Path","PropertyPath","String","TimeOfDay"].forEach(function(l){if(R.hasOwnProperty(l)){k=l;S=B.descend(e,l);}});}switch(k){case"Apply":return c.apply(i,S);case"If":return c.conditional(i,S);case"Path":case"PropertyPath":return c.path(i,S);case"Bool":case"Date":case"DateTimeOffset":case"Decimal":case"Float":case"Guid":case"Int":case"String":case"TimeOfDay":return c.constant(i,S,k);case"And":case"Eq":case"Ge":case"Gt":case"Le":case"Lt":case"Ne":case"Or":return c.operator(i,S,k);case"Not":return c.not(i,S);case"Null":return{result:"constant",value:"null",type:"edm:Null"};default:B.error(e,"Unsupported OData expression");}},formatOperand:function(e,i,R,w){var k;if(R.result==="constant"){switch(R.category){case"boolean":case"number":return R.value;case"date":k=c.parseDate(R.value);if(!k){B.error(B.descend(e,i),"Invalid Date "+R.value);}return String(k.getTime());case"datetime":k=c.parseDateTimeOffset(R.value);if(!k){B.error(B.descend(e,i),"Invalid DateTime "+R.value);}return String(k.getTime());case"time":return String(c.parseTimeOfDay(R.value).getTime());}}if(w){c.wrapExpression(R);}return B.resultToString(R,true);},getExpression:function(i,R,w){var k;if(R===undefined){return undefined;}q.sap.measure.average(P,"",p);if(!c.simpleParserWarningLogged&&M.bindingParser===a.simpleParser){q.sap.log.warning("Complex binding syntax not active",null,A);c.simpleParserWarningLogged=true;}try{k=c.expression(i,{asExpression:false,path:i.getPath(),value:R,withType:w});q.sap.measure.end(P);return B.resultToString(k,false,w);}catch(e){q.sap.measure.end(P);if(e instanceof SyntaxError){return"Unsupported: "+a.complexParser.escape(B.toErrorString(R));}throw e;}},fillUriTemplate:function(I,e){var i,n,k=[],l="",u,v=e.value,R,w=c.parameter(I,e,0,"Edm.String");k.push('odata.fillUriTemplate(',B.resultToString(w,true),',{');for(i=1;i<v.length;i+=1){u=B.descend(e,i,"object");n=B.property(u,"Name","string");R=c.expression(I,B.descend(u,"Value"),true);k.push(l,B.toJSON(n),":",B.resultToString(R,true));l=",";}k.push("})");return{result:"expression",value:k.join(""),type:"Edm.String"};},not:function(i,e){var k;e.asExpression=true;k=c.expression(i,e);return{result:"expression",value:"!"+B.resultToString(c.wrapExpression(k),true),type:"Edm.Boolean"};},operator:function(i,e,k){var l=k==="And"||k==="Or"?"Edm.Boolean":undefined,n=c.parameter(i,e,0,l),u=c.parameter(i,e,1,l),v,N,V,w;if(n.type!=="edm:Null"&&u.type!=="edm:Null"){n.category=T[n.type];u.category=T[u.type];c.adjustOperands(n,u);c.adjustOperands(u,n);if(n.category!==u.category){B.error(e,"Expected two comparable parameters but instead saw "+n.type+" and "+u.type);}v=n.category==="decimal"?",true":"";N=j[n.category];}V=c.formatOperand(e,0,n,!N);w=c.formatOperand(e,1,u,!N);return{result:"expression",value:N?"odata.compare("+V+","+w+v+")"+o[k]+"0":V+o[k]+w,type:"Edm.Boolean"};},parameter:function(i,e,I,k){var l=B.descend(e,I),R;l.asExpression=true;R=c.expression(i,l);if(k&&k!==R.type){B.error(l,"Expected "+k+" but instead saw "+R.type);}return R;},parseDate:function(v){return D.getDateInstance({pattern:"yyyy-MM-dd",strictParsing:true,UTC:true}).parse(v);},parseDateTimeOffset:function(v){var e=E.DateTimeOffset.exec(v);if(e&&e[1]&&e[1].length>4){v=v.replace(e[1],e[1].slice(0,4));}return D.getDateTimeInstance({pattern:"yyyy-MM-dd'T'HH:mm:ss.SSSX",strictParsing:true}).parse(v.toUpperCase());},parseTimeOfDay:function(v){if(v.length>12){v=v.slice(0,12);}return D.getTimeInstance({pattern:"HH:mm:ss.SSS",strictParsing:true,UTC:true}).parse(v);},path:function(i,e){var k=e.value,C={},I,l=i.getModel(),n={getModel:function(){return l;},getPath:function(){return e.path;}},u,R={result:"binding",value:k},v;B.expectType(e,"string");v=B.followPath(n,{"Path":k});if(v&&v.resolvedPath){u=l.getProperty(v.resolvedPath);R.type=u.type;switch(u.type){case"Edm.DateTime":C.displayFormat=u["sap:display-format"];break;case"Edm.Decimal":C.precision=u.precision;C.scale=u.scale;break;case"Edm.String":C.maxLength=u.maxLength;I=u["com.sap.vocabularies.Common.v1.IsDigitSequence"];if(I){C.isDigitSequence=I.Bool?I.Bool:"true";}break;}if(u.nullable==="false"){C.nullable=u.nullable;}R.constraints=C;}else{q.sap.log.warning("Could not find property '"+k+"' starting from '"+e.path+"'",null,A);}return R;},replaceIndexes:function(e,k){var l,n=k.split('/'),u,R;function v(w,i){var x=e.getProperty(u+"/"+w);if(typeof x==="string"){n[i]="[${"+w+"}==="+B.toJSON(x)+"]";return true;}return false;}l=g.exec(k);if(!l){return k;}u=l[1];if(!v("namespace",3)){return k;}for(var i=4;i<n.length;i++){u=u+"/"+n[i];if(f.test(n[i])&&!v("name",i)){R=e.getProperty(u+"/RecordType");if(R){if(R==="com.sap.vocabularies.UI.v1.DataFieldForAction"){v("Action/String",i);}else if(R==="com.sap.vocabularies.UI.v1.DataFieldForAnnotation"){v("Target/AnnotationPath",i);}else if(R.indexOf("com.sap.vocabularies.UI.v1.DataField")===0){v("Value/Path",i);}}}}return n.join('/');},simpleParserWarningLogged:false,uriEncode:function(i,e){var R=c.parameter(i,e,0);if(R.result==="constant"){if(R.type==="Edm.Date"){R.type="Edm.DateTime";R.value=R.value+"T00:00:00Z";}else if(R.type==="Edm.TimeOfDay"){R.type="Edm.Time";R.value="PT"+R.value.slice(0,2)+"H"+R.value.slice(3,5)+"M"+R.value.slice(6,8)+"S";}}return{result:"expression",value:'odata.uriEncode('+B.resultToString(R,true)+","+B.toJSON(R.type)+")",type:"Edm.String"};},wrapExpression:function(R){if(R.result==="expression"){R.value="("+R.value+")";}return R;}};return c;},false);
