/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/Object','sap/ui/Device','./library','./TableUtils'],function(q,B,D,l,T){"use strict";var C=T.CELLTYPES;var S=l.SelectionMode;var M={CTRL:1,SHIFT:2,ALT:4};var H=5;var a="1em";function s(i){if(!(i instanceof window.HTMLInputElement)){return;}i.select();}var b=B.extend("sap.ui.table.TableKeyboardDelegate2",{constructor:function(t){B.call(this);},destroy:function(){B.prototype.destroy.apply(this,arguments);},getInterface:function(){return this;}});b._restoreFocusOnLastFocusedDataCell=function(t,e){var c=T.getFocusedItemInfo(t);var L=t._getKeyboardExtension()._getLastFocusedCellInfo();T.focusItem(t,c.cellInRow+(c.columnCount*L.row),e);};b._setFocusOnColumnHeaderOfLastFocusedDataCell=function(t,e){var c=T.getFocusedItemInfo(t);T.focusItem(t,c.cellInRow,e);};b._forwardFocusToTabDummy=function(t,c){t._getKeyboardExtension()._setSilentFocus(t.$().find("."+c));};b._isKeyCombination=function(e,k,m){if(m==null){m=0;}var c=typeof k==="string"?String.fromCharCode(e.charCode):e.keyCode;var d=0;d|=(D.os.macintosh?e.metaKey:e.ctrlKey)&&k!==q.sap.KeyCodes.CONTROL?M.CTRL:0;d|=e.shiftKey&&k!==q.sap.KeyCodes.SHIFT?M.SHIFT:0;d|=e.altKey&&k!==q.sap.KeyCodes.ALT?M.ALT:0;var v=k==null||c===k;var V=m===d;return v&&V;};b._handleSpaceAndEnter=function(t,e){var c=T.getCellInfo(e.target)||{};if(c.type===C.COLUMNROWHEADER){t._toggleSelectAll();}else if(b._isElementGroupToggler(t,e.target)){T.Grouping.toggleGroupHeaderByRef(t,e.target);}else if(c.type===C.ROWHEADER){T.toggleRowSelection(t,e.target);}else if(c.type===C.DATACELL){var E=!t.hasListeners("cellClick");if(!t._findAndfireCellEvent(t.fireCellClick,e)){if(T.isRowSelectionAllowed(t)){T.toggleRowSelection(t,e.target);E=false;}}if(E){var i=b._getInteractiveElements(e.target);if(i!==null){t._getKeyboardExtension().setActionMode(true);}}}};b._moveColumn=function(c,n){var t=c.getParent();var v=t._getVisibleColumns();var i=v.indexOf(c);var d;if(n&&i<v.length-1){d=t.indexOfColumn(v[i+1])+1;}else if(!n&&i>0){d=t.indexOfColumn(v[i-1]);}if(d!=null){T.Column.moveColumnTo(c,d);}};b._getVisibleAndGroupedColumns=function(t){return t.getColumns().filter(function(c){return c.getVisible()||c.getGrouped();});};b._getColumnIndexInVisibleAndGroupedColumns=function(t,c){var v=b._getVisibleAndGroupedColumns(t);for(var i=0;i<v.length;i++){var V=v[i];if(V===c){return i;}}return-1;};b._focusRowSelector=function(t,r){t._getKeyboardExtension()._setFocus(t.getDomRef("rowsel"+r));};b._isElementGroupToggler=function(t,e){return T.Grouping.isInGroupingRow(e)||(T.Grouping.isTreeMode(t)&&e.classList.contains("sapUiTableTdFirst"))||e.classList.contains("sapUiTableTreeIcon");};b._isElementInteractive=function(e){if(e==null){return false;}return q(e).is(":sapTabbable, input:sapFocusable, .sapUiTableTreeIcon");};b._getInteractiveElements=function(c){if(c==null){return null;}var $=q(c);var o=T.getCellInfo($);if(o!==null&&o.type===T.CELLTYPES.DATACELL){var i=$.find(":sapTabbable, input:sapFocusable, .sapUiTableTreeIcon");if(i.length>0){return i;}}return null;};b._getFirstInteractiveElement=function(r){if(r==null){return null;}var t=r.getParent();var c=r.getCells();for(var i=0;i<c.length;i++){var o=c[i].getDomRef();var $=T.getParentDataCell(t,o);var I=this._getInteractiveElements($);if(I!==null){return I.first();}}return null;};b._getLastInteractiveElement=function(r){if(r==null){return null;}var t=r.getParent();var c=r.getCells();for(var i=c.length-1;i>=0;i--){var o=c[i].getDomRef();var $=T.getParentDataCell(t,o);var I=this._getInteractiveElements($);if(I!==null){return I.last();}}return null;};b._getPreviousInteractiveElement=function(t,e){if(t==null||e==null){return null;}var E=q(e);if(!this._isElementInteractive(E)){return null;}var c=T.getParentDataCell(t,e);var d=T.getDataCellInfo(t,c);var r=t.getRows()[d.rowIndex];var f=r.getCells();var I;I=this._getInteractiveElements(c);if(I[0]!==E[0]){return I.eq(I.index(e)-1);}var o=t.getColumns()[d.columnIndex];var g=b._getColumnIndexInVisibleAndGroupedColumns(t,o);for(var i=g-1;i>=0;i--){var h=f[i].getDomRef();c=T.getParentDataCell(t,h);I=this._getInteractiveElements(c);if(I!==null){return I.last();}}return null;};b._getNextInteractiveElement=function(t,e){if(t==null||e==null){return null;}var E=q(e);if(!this._isElementInteractive(E)){return null;}var c=T.getParentDataCell(t,e);var d=T.getDataCellInfo(t,c);var r=t.getRows()[d.rowIndex];var f=r.getCells();var I;I=this._getInteractiveElements(c);if(I.get(-1)!==E[0]){return I.eq(I.index(e)+1);}var o=t.getColumns()[d.columnIndex];var g=b._getColumnIndexInVisibleAndGroupedColumns(t,o);for(var i=g+1;i<f.length;i++){var h=f[i].getDomRef();c=T.getParentDataCell(t,h);I=this._getInteractiveElements(c);if(I!==null){return I.first();}}return null;};b.prototype.enterActionMode=function(){var k=this._getKeyboardExtension();var A=document.activeElement;var i=b._getInteractiveElements(A);var p=T.getParentDataCell(this,A);if(i!==null){k._suspendItemNavigation();A.tabIndex=-1;k._setSilentFocus(i[0]);s(i[0]);return true;}else if(p!==null){this._getKeyboardExtension()._suspendItemNavigation();var L=this._getKeyboardExtension()._getLastFocusedCellInfo();if(L!=null){var r=this.getRows()[L.row-(sap.ui.table.TableUtils.hasRowHeader(this)?1:0)];if(r!=null){var c=r.getCells()[L.cellInRow-sap.ui.table.TableUtils.getHeaderRowCount(this)];if(c!=null){var d=T.getParentDataCell(this,c.getDomRef());if(d!==null){d[0].tabIndex=-1;}}}}return true;}return false;};b.prototype.leaveActionMode=function(){var k=this._getKeyboardExtension();var A=document.activeElement;k._resumeItemNavigation();var p=T.getParentDataCell(this,A);if(p!==null){k._setSilentFocus(p);}else{A.blur();k._setSilentFocus(A);}};b.prototype.onfocusin=function(e){if(e.isMarked("sapUiTableIgnoreFocusIn")){return;}var t=q(e.target);if(t.hasClass("sapUiTableOuterBefore")||t.hasClass("sapUiTableOuterAfter")||(e.target!=this.getDomRef("overlay")&&this.getShowOverlay())){this.$("overlay").focus();}else if(t.hasClass("sapUiTableCtrlBefore")){var n=T.isNoDataVisible(this);if(!n||n&&this.getColumnHeaderVisible()){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,e);}else{this._getKeyboardExtension()._setSilentFocus(this.$("noDataCnt"));}}else if(t.hasClass("sapUiTableCtrlAfter")){if(!T.isNoDataVisible(this)){b._restoreFocusOnLastFocusedDataCell(this,e);}}var p=T.getParentDataCell(this,t);var i=p!==null&&b._isElementInteractive(t);if(this._getKeyboardExtension().isInActionMode()){var c=T.getCellInfo(e.target)||{};var I=c.type===C.ROWHEADER&&T.Grouping.isInGroupingRow(e.target);var d=c.type===C.ROWHEADER&&!I&&T.isRowSelectorSelectionAllowed(this);if(!I&&!d&&!i){this._getKeyboardExtension().setActionMode(false);}}else if(i){this._getKeyboardExtension().setActionMode(true);}};b.prototype.onkeydown=function(e){var k=this._getKeyboardExtension();if(b._isKeyCombination(e,q.sap.KeyCodes.F2)){var i=k.isInActionMode();k.setActionMode(!i);return;}else if(b._isKeyCombination(e,q.sap.KeyCodes.F4)&&b._isElementGroupToggler(this,e.target)){T.Grouping.toggleGroupHeaderByRef(this,e.target);return;}if(this._getKeyboardExtension().isInActionMode()){return;}var t=q(e.target);var c=T.getCellInfo(t)||{};if(b._isKeyCombination(e,q.sap.KeyCodes.SHIFT)&&this.getSelectionMode()===S.MultiToggle&&(c.type===C.ROWHEADER&&T.isRowSelectorSelectionAllowed(this)||c.type===C.DATACELL&&T.isRowSelectionAllowed(this))){var f=T.getRowIndexOfFocusedCell(this);var d=this.getRows()[f].getIndex();this._oRangeSelection={startIndex:d,selected:this.isIndexSelected(d)};}else if(b._isKeyCombination(e,q.sap.KeyCodes.A,M.CTRL)){e.preventDefault();if((c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNROWHEADER)&&this.getSelectionMode()===S.MultiToggle){this._toggleSelectAll();}}else if(b._isKeyCombination(e,q.sap.KeyCodes.A,M.CTRL+M.SHIFT)){if((c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNROWHEADER)){this.clearSelection();}}else if(b._isKeyCombination(e,q.sap.KeyCodes.F4)){if(c.type===C.DATACELL){k.setActionMode(true);}}else if(b._isKeyCombination(e,q.sap.KeyCodes.F10,M.SHIFT)){e.preventDefault();T.Menu.openContextMenu(this,e.target,true);}};b.prototype.onkeypress=function(e){var k=this._getKeyboardExtension();var c=T.getCellInfo(e.target)||{};if(b._isKeyCombination(e,"+")){if(b._isElementGroupToggler(this,e.target)){T.Grouping.toggleGroupHeaderByRef(this,e.target,true);}else if(c.type===C.DATACELL){k.setActionMode(true);}}else if(b._isKeyCombination(e,"-")){if(b._isElementGroupToggler(this,e.target)){T.Grouping.toggleGroupHeaderByRef(this,e.target,false);}else if(c.type===C.DATACELL){k.setActionMode(true);}}};b.prototype.oncontextmenu=function(e){if(e.isMarked("handledByPointerExtension")){return;}e.preventDefault();var c=T.getCell(this,e.target);var o=T.getCellInfo(c)||{};if(o.type===C.COLUMNHEADER||o.type===C.DATACELL){T.Menu.openContextMenu(this,e.target,true);}};b.prototype.onkeyup=function(e){var c=T.getCellInfo(e.target)||{};if(b._isKeyCombination(e,q.sap.KeyCodes.SHIFT)){delete this._oRangeSelection;}if(b._isKeyCombination(e,q.sap.KeyCodes.SPACE)){e.preventDefault();if(c.type===C.COLUMNHEADER){T.Menu.openContextMenu(this,e.target,true);}else{b._handleSpaceAndEnter(this,e);}}if(b._isKeyCombination(e,q.sap.KeyCodes.ENTER)){if(c.type===C.COLUMNHEADER){T.Menu.openContextMenu(this,e.target,true);}}};b.prototype.onsaptabnext=function(e){var k=this._getKeyboardExtension();var c=T.getCellInfo(e.target)||{};if(k.isInActionMode()){var $=T.getParentDataCell(this,e.target);var r;var i=false;var I;if($===null){if(c.type===C.ROWHEADER){$=q(e.target);r=$.data("sap-ui-rowindex");i=true;}else{return;}}else{r=T.getDataCellInfo(this,$).rowIndex;}var R=this.getRows()[r];var L=b._getLastInteractiveElement(R);var d=L===null||L[0]===e.target;if(d){var A=R.getIndex();var f=T.isLastScrollableRow(this,$);var g=this._getRowCount()-1===A;var t=T.isRowSelectorSelectionAllowed(this);var h=false;if(!g&&f){h=this._getScrollExtension().scroll(true,null,true);}if(g){e.preventDefault();k.setActionMode(false);}else if(h){e.preventDefault();this.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){var o=T.Grouping.isGroupingRow(R.getDomRef());if(t||o){b._focusRowSelector(this,r);}else{I=b._getFirstInteractiveElement(R);I.focus();s(I[0]);}}.bind(this),0);}.bind(this));}else{e.preventDefault();var n=r+1;var N=this.getRows()[n];var j=T.Grouping.isGroupingRow(N.getDomRef());if(t||j){b._focusRowSelector(this,n);}else{I=b._getFirstInteractiveElement(N);I.focus();s(I[0]);}}}else if(i){e.preventDefault();I=b._getFirstInteractiveElement(R);I.focus();s(I[0]);}else{e.preventDefault();I=b._getNextInteractiveElement(this,e.target);I.focus();s(I[0]);}}else if(c.type===C.COLUMNHEADER||c.type===C.COLUMNROWHEADER){if(T.isNoDataVisible(this)){this.$("noDataCnt").focus();}else{b._restoreFocusOnLastFocusedDataCell(this,e);}e.preventDefault();}else if(c.type===C.DATACELL||c.type===C.ROWHEADER){b._forwardFocusToTabDummy(this,"sapUiTableCtrlAfter");}else if(e.target===this.getDomRef("overlay")){k._setSilentFocus(this.$().find(".sapUiTableOuterAfter"));}else if(Object.keys(c).length===0){var m=T.getParentDataCell(this,e.target);if(m!==null){e.preventDefault();m.focus();}}};b.prototype.onsaptabprevious=function(e){var k=this._getKeyboardExtension();var c=T.getCellInfo(e.target)||{};if(k.isInActionMode()){var $=T.getParentDataCell(this,e.target);var r;var i=false;var I;if($===null){if(c.type===C.ROWHEADER){$=q(e.target);r=parseInt($.data("sap-ui-rowindex"),10);i=true;}else{return;}}else{r=T.getDataCellInfo(this,$).rowIndex;}var R=this.getRows()[r];var A=R.getIndex();var f=b._getFirstInteractiveElement(R);var d=f!==null&&f[0]===e.target;var t=T.isRowSelectorSelectionAllowed(this);var g=T.Grouping.isGroupingRow(R);var h=t||g;if(d&&h){e.preventDefault();b._focusRowSelector(this,r);}else if((d&&!h)||i){var j=T.isFirstScrollableRow(this,$);var m=A===0;var n=false;if(!m&&j){n=this._getScrollExtension().scroll(false,null,true);}if(m){e.preventDefault();k.setActionMode(false);}else if(n){e.preventDefault();this.attachEventOnce("_rowsUpdated",function(){setTimeout(function(){var v=T.Grouping.isGroupingRow(R.getDomRef());if(v){b._focusRowSelector(this,r);}else{I=b._getLastInteractiveElement(R);I.focus();s(I[0]);}}.bind(this),0);}.bind(this));}else{e.preventDefault();var p=r-1;var P=this.getRows()[p];var o=T.Grouping.isGroupingRow(P.getDomRef());if(o){b._focusRowSelector(this,p);}else{I=b._getLastInteractiveElement(P);I.focus();s(I[0]);}}}else{e.preventDefault();I=b._getPreviousInteractiveElement(this,e.target);I.focus();s(I[0]);}}else if(c.type===C.DATACELL||c.type===C.ROWHEADER||e.target===this.getDomRef("noDataCnt")){if(this.getColumnHeaderVisible()){b._setFocusOnColumnHeaderOfLastFocusedDataCell(this,e);e.preventDefault();}else{b._forwardFocusToTabDummy(this,"sapUiTableCtrlBefore");}}else if(e.target===this.getDomRef("overlay")){this._getKeyboardExtension()._setSilentFocus(this.$().find(".sapUiTableOuterBefore"));}else if(Object.keys(c).length===0){var u=T.getParentDataCell(this,e.target);if(u!==null){e.preventDefault();u.focus();}}};b.prototype.onsapdown=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}var c=T.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER){if(T.isLastScrollableRow(this,e.target)){var d=this._getScrollExtension().scroll(true,false,true);if(d){e.setMarked("sapUiTableSkipItemNavigation");}}}else if(c.type===C.COLUMNHEADER||c.type===C.COLUMNROWHEADER){var h=T.getHeaderRowCount(this);if(T.isNoDataVisible(this)){var f=T.getFocusedItemInfo(this);if(f.row-h<=1){e.setMarked("sapUiTableSkipItemNavigation");}}else if(c.type===C.COLUMNROWHEADER&&h>1){e.setMarked("sapUiTableSkipItemNavigation");T.focusItem(this,h*(T.getVisibleColumnCount(this)+1),e);}}};b.prototype.onsapdownmodifiers=function(e){var k=this._getKeyboardExtension();if(b._isKeyCombination(e,null,M.ALT)&&b._isElementGroupToggler(this,e.target)){e.setMarked("sapUiTableSkipItemNavigation");T.Grouping.toggleGroupHeaderByRef(this,e.target,true);return;}if(k.isInActionMode()){return;}var c=T.getCellInfo(e.target)||{};if(b._isKeyCombination(e,null,M.SHIFT)){e.preventDefault();if(c.type===C.ROWHEADER||c.type===C.DATACELL){if(!this._oRangeSelection){e.setMarked("sapUiTableSkipItemNavigation");return;}var f=T.getRowIndexOfFocusedCell(this);var d=this.getRows()[f].getIndex();if(d===this._getRowCount()-1){return;}if(T.isLastScrollableRow(this,e.target)){var g=this._getScrollExtension().scroll(true,false,true);if(g){e.setMarked("sapUiTableSkipItemNavigation");}}if(this._oRangeSelection.startIndex<=d){d++;if(this._oRangeSelection.selected){T.toggleRowSelection(this,d,true);}else{T.toggleRowSelection(this,d,false);}}else{T.toggleRowSelection(this,d,false);}}else{e.setMarked("sapUiTableSkipItemNavigation");}}if(b._isKeyCombination(e,null,M.ALT)){if(c.type===C.DATACELL){k.setActionMode(true);}e.setMarked("sapUiTableSkipItemNavigation");}};b.prototype.onsapup=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}var c=T.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER){if(T.isFirstScrollableRow(this,e.target)){var d=this._getScrollExtension().scroll(false,false,true);if(d){e.setMarked("sapUiTableSkipItemNavigation");}}}};b.prototype.onsapupmodifiers=function(e){var k=this._getKeyboardExtension();if(b._isKeyCombination(e,null,M.ALT)&&b._isElementGroupToggler(this,e.target)){e.setMarked("sapUiTableSkipItemNavigation");T.Grouping.toggleGroupHeaderByRef(this,e.target,false);return;}if(k.isInActionMode()){return;}var c=T.getCellInfo(e.target)||{};if(b._isKeyCombination(e,null,M.SHIFT)){e.preventDefault();if(c.type===C.ROWHEADER||c.type===C.DATACELL){if(!this._oRangeSelection){e.setMarked("sapUiTableSkipItemNavigation");return;}var f=T.getRowIndexOfFocusedCell(this);var d=this.getRows()[f].getIndex();if(d===0){e.setMarked("sapUiTableSkipItemNavigation");return;}if(T.isFirstScrollableRow(this,e.target)){var g=this._getScrollExtension().scroll(false,false,true);if(g){e.setMarked("sapUiTableSkipItemNavigation");}}if(this._oRangeSelection.startIndex>=d){d--;if(this._oRangeSelection.selected){T.toggleRowSelection(this,d,true);}else{T.toggleRowSelection(this,d,false);}}else{T.toggleRowSelection(this,d,false);}}else{e.setMarked("sapUiTableSkipItemNavigation");}}if(b._isKeyCombination(e,null,M.ALT)){if(c.type===C.DATACELL){k.setActionMode(true);}e.setMarked("sapUiTableSkipItemNavigation");}};b.prototype.onsapleftmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}var c=T.getCellInfo(e.target)||{};var I=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(e,null,M.SHIFT)){e.preventDefault();if(c.type===C.DATACELL){if(!this._oRangeSelection){e.setMarked("sapUiTableSkipItemNavigation");return;}var f=T.getFocusedItemInfo(this);var F=T.hasRowHeader(this)&&f.cellInRow===1;if(F&&!T.isRowSelectorSelectionAllowed(this)){e.setMarked("sapUiTableSkipItemNavigation");}}else if(c.type===C.ROWHEADER&&I){if(!T.isRowSelectionAllowed(this)){e.setMarked("sapUiTableSkipItemNavigation");}}else if(c.type===C.COLUMNROWHEADER&&I){e.setMarked("sapUiTableSkipItemNavigation");}else if(c.type===C.COLUMNHEADER){var r=-this._CSSSizeToPixel(a);if(I){r=r*-1;}var o=T.getColumnHeaderCellInfo(e.target);var d=0;for(var i=o.index;i<o.index+o.span;i++){d+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,o.index,d+r,true,o.span);e.setMarked("sapUiTableSkipItemNavigation");}}else if(b._isKeyCombination(e,null,M.CTRL)){if(c.type===C.COLUMNHEADER){e.preventDefault();e.stopImmediatePropagation();var g=T.getColumnHeaderCellInfo(e.target).index;var h=this.getColumns()[g];b._moveColumn(h,I);}}};b.prototype.onsaprightmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}var c=T.getCellInfo(e.target)||{};var I=sap.ui.getCore().getConfiguration().getRTL();if(b._isKeyCombination(e,null,M.SHIFT)){e.preventDefault();if(c.type===C.DATACELL){if(!this._oRangeSelection){e.setMarked("sapUiTableSkipItemNavigation");}}else if(c.type===C.ROWHEADER){if(!T.isRowSelectionAllowed(this)){e.setMarked("sapUiTableSkipItemNavigation");}}else if(c.type===C.COLUMNHEADER){var r=this._CSSSizeToPixel(a);if(I){r=r*-1;}var o=T.getColumnHeaderCellInfo(e.target);var d=0;for(var i=o.index;i<o.index+o.span;i++){d+=T.Column.getColumnWidth(this,i);}T.Column.resizeColumn(this,o.index,d+r,true,o.span);e.setMarked("sapUiTableSkipItemNavigation");}else if(c.type===C.COLUMNROWHEADER){e.setMarked("sapUiTableSkipItemNavigation");}}else if(b._isKeyCombination(e,null,M.CTRL)){if(c.type===C.COLUMNHEADER){e.preventDefault();e.stopImmediatePropagation();var f=T.getColumnHeaderCellInfo(e.target).index;var g=this.getColumns()[f];b._moveColumn(g,!I);}}};b.prototype.onsaphome=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(T.Grouping.isInGroupingRow(e.target)){e.setMarked("sapUiTableSkipItemNavigation");return;}var c=T.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.COLUMNHEADER){var f=T.getFocusedItemInfo(this);var F=f.cell;var i=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;if(T.hasFixedColumns(this)&&i>this.getFixedColumnCount()+r){e.setMarked("sapUiTableSkipItemNavigation");T.focusItem(this,F-i+this.getFixedColumnCount()+r,null);}else if(h&&i>1){e.setMarked("sapUiTableSkipItemNavigation");T.focusItem(this,F-i+r,null);}}};b.prototype.onsapend=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(T.Grouping.isInGroupingRow(e.target)){e.setMarked("sapUiTableSkipItemNavigation");return;}var c=T.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNHEADER||c.type===C.COLUMNROWHEADER){var f=T.getFocusedItemInfo(this);var F=f.cell;var i=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var I=false;if(c.type===C.COLUMNHEADER&&T.hasFixedColumns(this)){var d=parseInt(c.cell.attr("colspan")||1,10);if(d>1&&i+d-r===this.getFixedColumnCount()){I=true;}}if(h&&i===0){e.setMarked("sapUiTableSkipItemNavigation");T.focusItem(this,F+1,null);}else if(T.hasFixedColumns(this)&&i<this.getFixedColumnCount()-1+r&&!I){e.setMarked("sapUiTableSkipItemNavigation");T.focusItem(this,F+this.getFixedColumnCount()-i,null);}}};b.prototype.onsaphomemodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,null,M.CTRL)){e.preventDefault();var c=T.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNHEADER){e.setMarked("sapUiTableSkipItemNavigation");var f=T.getFocusedItemInfo(this);var F=f.row;if(F>0){var i=f.cell;var d=f.columnCount;var h=T.getHeaderRowCount(this);if(F<h+this.getFixedRowCount()){T.focusItem(this,i-d*F,e);}else if(F>=h+this.getFixedRowCount()&&F<h+T.getNonEmptyVisibleRowCount(this)-this.getFixedBottomRowCount()){this._getScrollExtension().scrollMax(false,true);if(this.getFixedRowCount()>0){T.focusItem(this,i-d*(F-h),e);}else{T.focusItem(this,i-d*F,e);}}else{this._getScrollExtension().scrollMax(false,true);T.focusItem(this,i-d*(F-h-this.getFixedRowCount()),e);}}}}};b.prototype.onsapendmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,null,M.CTRL)){e.preventDefault();var c=T.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNHEADER||c.type===C.COLUMNROWHEADER){e.setMarked("sapUiTableSkipItemNavigation");var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var n=T.getNonEmptyVisibleRowCount(this);if(this.getFixedBottomRowCount()===0||F<h+n-1||(T.isNoDataVisible(this)&&F<h-1)){var i=f.cell;var d=f.columnCount;if(T.isNoDataVisible(this)){T.focusItem(this,i+d*(h-F-1),e);}else if(F<h){if(this.getFixedRowCount()>0){T.focusItem(this,i+d*(h+this.getFixedRowCount()-F-1),e);}else{this._getScrollExtension().scrollMax(true,true);T.focusItem(this,i+d*(h+n-this.getFixedBottomRowCount()-F-1),e);}}else if(F>=h&&F<h+this.getFixedRowCount()){this._getScrollExtension().scrollMax(true,true);T.focusItem(this,i+d*(h+n-this.getFixedBottomRowCount()-F-1),e);}else if(F>=h+this.getFixedRowCount()&&F<h+n-this.getFixedBottomRowCount()){this._getScrollExtension().scrollMax(true,true);T.focusItem(this,i+d*(h+n-F-1),e);}else{T.focusItem(this,i+d*(h+n-F-1),e);}}}}};b.prototype.onsappageup=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}var c=T.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNHEADER){var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);if(this.getFixedRowCount()===0&&F>=h||this.getFixedRowCount()>0&&F>h){e.setMarked("sapUiTableSkipItemNavigation");var i=f.cell;var d=f.columnCount;if(F<h+this.getFixedRowCount()){T.focusItem(this,i-d*(F-h),e);}else if(F===h+this.getFixedRowCount()){var p=T.getNonEmptyVisibleRowCount(this)-this.getFixedRowCount()-this.getFixedBottomRowCount();var r=this._getSanitizedFirstVisibleRow();this._getScrollExtension().scroll(false,true,true);if(r<p){if(this.getFixedRowCount()>0){T.focusItem(this,i-d*(F-h),e);}else{T.focusItem(this,i-d*h,e);}}}else if(F>h+this.getFixedRowCount()&&F<h+T.getNonEmptyVisibleRowCount(this)){T.focusItem(this,i-d*(F-h-this.getFixedRowCount()),e);}else{T.focusItem(this,i-d*(F-h-T.getNonEmptyVisibleRowCount(this)+1),e);}}}};b.prototype.onsappagedown=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}var c=T.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNHEADER||c.type===C.COLUMNROWHEADER){e.setMarked("sapUiTableSkipItemNavigation");var f=T.getFocusedItemInfo(this);var F=f.row;var h=T.getHeaderRowCount(this);var n=T.getNonEmptyVisibleRowCount(this);if((T.isNoDataVisible(this)&&F<h-1)||this.getFixedBottomRowCount()===0||F<h+n-1){var i=f.cell;var d=f.columnCount;if(F<h-1&&c.type!==C.COLUMNROWHEADER){T.focusItem(this,i+d*(h-F-1),e);}else if(F<h){if(!T.isNoDataVisible(this)){T.focusItem(this,i+d*(h-F),e);}}else if(F>=h&&F<h+n-this.getFixedBottomRowCount()-1){T.focusItem(this,i+d*(h+n-this.getFixedBottomRowCount()-F-1),e);}else if(F===h+n-this.getFixedBottomRowCount()-1){var p=T.getNonEmptyVisibleRowCount(this)-this.getFixedRowCount()-this.getFixedBottomRowCount();var r=this._getRowCount()-this.getFixedBottomRowCount()-this._getSanitizedFirstVisibleRow()-p*2;this._getScrollExtension().scroll(true,true,true);if(r<p&&this.getFixedBottomRowCount()>0){T.focusItem(this,i+d*(h+n-F-1),e);}}else{T.focusItem(this,i+d*(h+n-F-1),e);}}}};b.prototype.onsappageupmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,null,M.ALT)){var c=T.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.COLUMNHEADER){var f=T.getFocusedItemInfo(this);var F=f.cell;var i=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var p=H;e.setMarked("sapUiTableSkipItemNavigation");if(h&&(T.Grouping.isInGroupingRow(e.target)||i===1)){T.focusItem(this,F-i,null);}else if(i-r<p){T.focusItem(this,F-i+r,null);}else{T.focusItem(this,F-p,null);}}}};b.prototype.onsappagedownmodifiers=function(e){if(this._getKeyboardExtension().isInActionMode()){return;}if(b._isKeyCombination(e,null,M.ALT)){var c=T.getCellInfo(e.target)||{};if(c.type===C.DATACELL||c.type===C.ROWHEADER||c.type===C.COLUMNHEADER||c.type===C.COLUMNROWHEADER){var f=T.getFocusedItemInfo(this);var F=f.cellInRow;var h=T.hasRowHeader(this);var r=h?1:0;var v=T.getVisibleColumnCount(this);var i=parseInt(c.cell.attr("colspan")||1,10);e.setMarked("sapUiTableSkipItemNavigation");if(F+i-r<v){var d=f.cell;var p=H;if(h&&F===0){T.focusItem(this,d+1,null);}else if(i>p){T.focusItem(this,d+i,null);}else if(F+i-r+p>v){T.focusItem(this,d+v-F-1+r,null);}else if(!T.Grouping.isInGroupingRow(e.target)){T.focusItem(this,d+p,null);}}}}};b.prototype.onsapenter=function(e){b._handleSpaceAndEnter(this,e);};return b;});
