/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/ResizeHandler','./TableGrouping','./TableColumnUtils','./TableMenuUtils','sap/ui/Device','./library'],function(q,C,R,T,a,b,D,l){"use strict";var S=l.SelectionBehavior;var c=l.SelectionMode;var d=1;var e={Grouping:T,Column:a,Menu:b,CELLTYPES:{DATACELL:"DATACELL",COLUMNHEADER:"COLUMNHEADER",ROWHEADER:"ROWHEADER",COLUMNROWHEADER:"COLUMNROWHEADER"},DEFAULT_ROW_HEIGHT:{sapUiSizeCondensed:24+d,sapUiSizeCompact:32+d,sapUiSizeCozy:48+d,undefined:32+d},hasRowHeader:function(t){return(t.getSelectionMode()!==c.None&&t.getSelectionBehavior()!==S.RowOnly)||T.isGroupMode(t);},isRowSelectionAllowed:function(t){return t.getSelectionMode()!==c.None&&(t.getSelectionBehavior()===S.Row||t.getSelectionBehavior()===S.RowOnly);},isRowSelectorSelectionAllowed:function(t){return t.getSelectionMode()!==c.None&&e.hasRowHeader(t);},areAllRowsSelected:function(t){if(t==null){return false;}var s=t._getSelectableRowCount();return s>0&&s===t._getSelectedIndicesCount();},isNoDataVisible:function(t){if(!t.getShowNoData()){return false;}return!e.hasData(t);},hasData:function(t){var B=t.getBinding("rows"),i=t._getRowCount(),h=B?!!i:false;if(B&&B.providesGrandTotal){var H=B.providesGrandTotal()&&B.hasTotaledMeasures();h=(H&&i<2)||(!H&&i===0)?false:true;}return h;},isBusyIndicatorVisible:function(t){if(t==null||t.getDomRef()==null){return false;}return t.getDomRef().querySelector(".sapUiLocalBusyIndicator")!=null;},isInstanceOf:function(o,t){if(!o||!t){return false;}var f=sap.ui.require(t);return!!(f&&(o instanceof f));},toggleRowSelection:function(t,r,s){if(t==null||t.getBinding("rows")==null||t.getSelectionMode()===c.None||r==null){return false;}function f(A){if(!t._isRowSelectable(A)){return false;}t._iSourceRowIndex=A;if(t.isIndexSelected(A)){if(s!=null&&s){return false;}t.removeSelectionInterval(A,A);}else{if(s!=null&&!s){return false;}t.addSelectionInterval(A,A);}delete t._iSourceRowIndex;return true;}if(typeof r==="number"){if(r<0||r>=t._getRowCount()){return false;}return f(r);}else{var $=q(r);var o=this.getCellInfo($[0]);if(o!==null&&!e.Grouping.isInGroupingRow($[0])&&((o.type===this.CELLTYPES.DATACELL&&this.isRowSelectionAllowed(t))||(o.type===this.CELLTYPES.ROWHEADER&&this.isRowSelectorSelectionAllowed(t)))){var A;if(o.type===this.CELLTYPES.DATACELL){A=t.getRows()[parseInt($.closest("tr",t.getDomRef()).attr("data-sap-ui-rowindex"),10)].getIndex();}else{A=t.getRows()[parseInt($.attr("data-sap-ui-rowindex"),10)].getIndex();}return f(A);}return false;}},getNoDataText:function(t){var n=t.getNoData();if(n instanceof C){return null;}else if(typeof n==="string"||t.getNoData()instanceof String){return n;}else{return t._oResBundle.getText("TBL_NO_DATA");}},getVisibleColumnCount:function(t){return t._getVisibleColumns().length;},getHeaderRowCount:function(t){if(!t.getColumnHeaderVisible()){return 0;}var h=1;var f=t.getColumns();for(var i=0;i<f.length;i++){if(f[i].shouldRender()){h=Math.max(h,f[i].getMultiLabels().length);}}return h;},isVariableRowHeightEnabled:function(t){return t._bVariableRowHeightEnabled&&t.getFixedRowCount()<=0&&t.getFixedBottomRowCount()<=0;},getTotalRowCount:function(t,i){var r=t._getRowCount();if(i){r=Math.max(r,t.getVisibleRowCount());}return r;},getNonEmptyVisibleRowCount:function(t){return Math.min(t.getVisibleRowCount(),t._getRowCount());},getFocusedItemInfo:function(t){var i=t._getItemNavigation();if(!i){return null;}return{cell:i.getFocusedIndex(),columnCount:i.iColumns,cellInRow:i.getFocusedIndex()%i.iColumns,row:Math.floor(i.getFocusedIndex()/i.iColumns),cellCount:i.getItemDomRefs().length,domRef:i.getFocusedDomRef()};},getColumnIndexOfFocusedCell:function(t){var i=e.getFocusedItemInfo(t);return i.cellInRow-(e.hasRowHeader(t)?1:0);},getRowIndexOfFocusedCell:function(t){var i=e.getFocusedItemInfo(t);return i.row-e.getHeaderRowCount(t);},isFixedColumn:function(t,i){return i<t.getFixedColumnCount();},hasFixedColumns:function(t){return t.getFixedColumnCount()>0;},focusItem:function(t,i,E){var I=t._getItemNavigation();if(I){I.focusItem(i,E);}},getCellInfo:function(o){if(!o){return null;}var $=q(o);if($.hasClass("sapUiTableTd")){return{type:e.CELLTYPES.DATACELL,cell:$};}else if($.hasClass("sapUiTableCol")){return{type:e.CELLTYPES.COLUMNHEADER,cell:$};}else if($.hasClass("sapUiTableRowHdr")){return{type:e.CELLTYPES.ROWHEADER,cell:$};}else if($.hasClass("sapUiTableColRowHdr")){return{type:e.CELLTYPES.COLUMNROWHEADER,cell:$};}return null;},getColumnHeaderCellInfo:function(o){if(o==null){return null;}var $=q(o);var f=this.getCellInfo($);if(f!==null&&f.type===e.CELLTYPES.COLUMNHEADER){return{index:parseInt($.data("sap-ui-colindex"),10),span:parseInt($.attr("colspan")||1,10)};}else{return null;}},getDataCellInfo:function(t,o){if(o==null){return null;}var $=q(o);var f=this.getCellInfo($);if(f!==null&&f.type===e.CELLTYPES.DATACELL){var r=parseInt($.parent().data("sap-ui-rowindex"),10);var s=$.data("sap-ui-colid");if(r>=0&&s){var g=sap.ui.getCore().byId(s);if(g){var i=t.indexOfColumn(g);if(i>=0){return{rowIndex:r,columnIndex:i};}}}}return null;},getRowColCell:function(t,r,f,I){var o=r>=0&&r<t.getRows().length?t.getRows()[r]:null;var g=I?t.getColumns():t._getVisibleColumns();var h=f>=0&&f<g.length?g[f]:null;var j=null;if(o&&h){if(I){if(h.shouldRender()){var v=t._getVisibleColumns();for(var i=0;i<v.length;i++){if(v[i]===h){j=o.getCells()[i];break;}}}}else{j=o.getCells()[f];}if(j&&j.data("sap-ui-colid")!=h.getId()){var k=o.getCells();for(var i=0;i<k.length;i++){if(k[i].data("sap-ui-colid")===h.getId()){j=k[i];break;}}}}return{row:o,column:h,cell:j};},getParentDataCell:function(t,E){if(t==null||E==null){return null;}var $=q(E);var p=$.parent().closest(".sapUiTableTd",t.getDomRef());if(p.length>0){return p;}return null;},getCell:function(t,E){if(t==null||E==null){return null;}var $=q(E);var f;var o=t.getDomRef();f=$.closest(".sapUiTableTd",o);if(f.length>0){return f;}f=$.closest(".sapUiTableCol",o);if(f.length>0){return f;}f=$.closest(".sapUiTableRowHdr",o);if(f.length>0){return f;}f=$.closest(".sapUiTableColRowHdr",o);if(f.length>0){return f;}return null;},registerResizeHandler:function(t,i,h,r){var o;if(typeof i=="string"){o=t.getDomRef(i);}else{q.sap.log.error("sIdSuffix must be a string",t);return;}if(typeof h!=="function"){q.sap.log.error("fnHandler must be a function",t);return;}this.deregisterResizeHandler(t,i);if(!t._mResizeHandlerIds){t._mResizeHandlerIds={};}if(r&&o){o=o.parentNode;}if(o){t._mResizeHandlerIds[i]=R.register(o,h);}return t._mResizeHandlerIds[i];},deregisterResizeHandler:function(t,I){var f;if(!t._mResizeHandlerIds){return;}if(typeof I=="string"){f=[I];}else if(I===undefined){f=[];for(var k in t._mResizeHandlerIds){if(typeof k=="string"&&t._mResizeHandlerIds.hasOwnProperty(k)){f.push(k);}}}else if(q.isArray(I)){f=I;}for(var i=0;i<f.length;i++){var s=f[i];if(t._mResizeHandlerIds[s]){R.deregister(t._mResizeHandlerIds[s]);t._mResizeHandlerIds[s]=undefined;}}},isFirstScrollableRow:function(t,r){var $=q(r);var i=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").data("sap-ui-rowindex"),10);var f=t.getFixedRowCount()||0;return i==f;},isLastScrollableRow:function(t,r){var $=q(r);var i=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").data("sap-ui-rowindex"),10);var f=t.getFixedBottomRowCount()||0;return i==t.getVisibleRowCount()-f-1;},getContentDensity:function(o){var s;var f=["sapUiSizeCompact","sapUiSizeCondensed","sapUiSizeCozy"];var g=function(F,O){if(!O[F]){return;}for(var i=0;i<f.length;i++){if(O[F](f[i])){return f[i];}}};var $=o.$();if($.length>0){s=g("hasClass",$);}else{s=g("hasStyleClass",o);}if(s){return s;}var p=null;var P=o.getParent();if(P){do{s=g("hasStyleClass",P);if(s){return s;}if(P.getDomRef){p=P.getDomRef();}else if(P.getRootNode){p=P.getRootNode();}if(!p&&P.getParent){P=P.getParent();}else{P=null;}}while(P&&!p);}$=q(p||document.body);s=g("hasClass",$.closest("."+f.join(",.")));return s;},sanitizeSelectionMode:function(t,s){if(s===c.Multi){s=c.MultiToggle;q.sap.log.warning("The selection mode 'Multi' is deprecated and must not be used anymore. Your setting was defaulted to selection mode 'MultiToggle'");}return s;},isVariableWidth:function(w){return!w||w=="auto"||w.toString().match(/%$/);},getFirstFixedButtomRowIndex:function(t){var f=t.getFixedBottomRowCount();var B=t.getBinding("rows");var F=-1;if(B&&f>0){var v=t.getVisibleRowCount();var i=t._getSanitizedFirstVisibleRow();if(t._iBindingLength>=v){F=v-f;}else{var I=t._iBindingLength-f-i;if(I>=0&&(i+I)<t._iBindingLength){F=I;}}}return F;}};T.TableUtils=e;a.TableUtils=e;b.TableUtils=e;return e;},true);
