/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./Calendar','./calendar/Header','./calendar/Month','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,b,H,M,c,d,Y,U,l){"use strict";var e=b.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}}}});var i=1000*3600*24;e.prototype.init=function(){b.prototype.init.apply(this,arguments);var m=this.getAggregation("monthPicker");m.setColumns(0);m.setMonths(3);m.attachEvent("pageChange",f,this);var y=this.getAggregation("yearPicker");y.setColumns(0);y.setYears(3);y.attachEvent("pageChange",g,this);this._iDaysMonthHead=35;};e.prototype._getDaysLarge=function(){return 10;};e.prototype._createMonth=function(I){var m=new c(I);return m;};e.prototype.setStartDate=function(s){if(!(s instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getStartDate(),s)){return this;}var y=s.getFullYear();if(y<1||y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}var m=this.getMinDate();var o=this.getMaxDate();if((m&&s.getTime()<m.getTime())||(o&&s.getTime()>o.getTime())){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}if(m&&s.getTime()<m.getTime()){q.sap.log.warning("startDate < minDate -> minDate as startDate set",this);s=new Date(m);}if(o&&s.getTime()>o.getTime()){q.sap.log.warning("startDate > maxDate -> maxDate as startDate set",this);s=new Date(o);}var u=a._createUniversalUTCDate(s,this.getPrimaryCalendarType());this.setProperty("startDate",s,true);this._oUTCStartDate=u;var h=this.getAggregation("month")[0];h.setStartDate(s);this._updateHeader(u);var j=a._createLocalDate(this._getFocusedDate(true));if(!h.checkDateFocusable(j)){this._setFocusedDate(u);h.displayDate(s);}return this;};e.prototype.getStartDate=function(){return this.getProperty("startDate");};e.prototype.setDays=function(h){this.setProperty("days",h,true);h=this._getDays();var o=this.getAggregation("month")[0];o.setDays(h);if(!this.getPickerPopup()){var m=this.getAggregation("monthPicker");var j=Math.ceil(h/3);if(j>12){j=12;}m.setMonths(j);var y=this.getAggregation("yearPicker");var k=Math.floor(h/2);if(k>20){k=20;}y.setYears(k);}var s=this._getStartDate();this._updateHeader(s);if(this.getDomRef()){if(h>this._getDaysLarge()){this.$().addClass("sapUiCalIntLarge");}else{this.$().removeClass("sapUiCalIntLarge");}if(h>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};e.prototype._getDays=function(){var h=this.getDays();if(sap.ui.Device.system.phone&&h>8){return 8;}else{return h;}};e.prototype.setShowDayNamesLine=function(s){this.setProperty("showDayNamesLine",s,true);var o=this.getAggregation("month")[0];o.setShowDayNamesLine(s);return this;};e.prototype._getShowMonthHeader=function(){var h=this._getDays();if(h>this._iDaysMonthHead){return true;}else{return false;}};e.prototype._getFocusedDate=function(F){if(!this._oFocusedDate||F){this._oFocusedDate=null;b.prototype._getFocusedDate.apply(this,arguments);var s=this.getStartDate();var o=this.getAggregation("month")[0];if(!s){this._setStartDate(this._oFocusedDate,false,true);}else if(!o.checkDateFocusable(a._createLocalDate(this._oFocusedDate))){this._oFocusedDate=a._createUniversalUTCDate(s,this.getPrimaryCalendarType());}}return this._oFocusedDate;};e.prototype.setMonths=function(m){if(m==1){return this.setProperty("months",m,false);}else{throw new Error("Property months not supported "+this);}};e.prototype.setFirstDayOfWeek=function(F){if(F==-1){return this.setProperty("firstDayOfWeek",F,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};e.prototype.focusDate=function(o){var h=this.getAggregation("month")[0];if(!h.checkDateFocusable(o)){var u=a._createUniversalUTCDate(o,this.getPrimaryCalendarType());this._focusDateExtend(u,true,true);}b.prototype.focusDate.apply(this,arguments);return this;};e.prototype._focusDateExtend=function(o,O,n){if(O){var h=this._getFocusedDate();var j=this._getStartDate();var k=Math.ceil((h.getTime()-j.getTime())/(i));var N=this._newUniversalDate(o);N.setUTCDate(N.getUTCDate()-k);this._setStartDate(N,false,true);if(!n){return true;}}return false;};e.prototype._setMinMaxDateExtend=function(o){if(this._oUTCStartDate){if(this._oUTCStartDate.getTime()<this._oMinDate.getTime()){q.sap.log.warning("start date < minDate -> minDate will be start date",this);this._setStartDate(this._newUniversalDate(this._oMinDate),true,true);}else{var E=new U(this._oUTCStartDate.getTime());E.setUTCDate(E.getUTCDate()+this._getDays()-1);if(E.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("end date > maxDate -> start date will be changed",this);var s=new U(this._oMaxDate.getTime());s.setUTCDate(s.getUTCDate()-this._getDays()+1);this._setStartDate(s,true,true);}}}};e.prototype.setPickerPopup=function(p){this.setProperty("pickerPopup",p,true);var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");if(p){m.setColumns(3);m.setMonths(12);y.setColumns(4);y.setYears(20);}else{m.setColumns(0);m.setMonths(6);y.setColumns(0);y.setYears(6);}return this;};e.prototype._togglePrevNext=function(o,h){if(this._iMode>1||(this._iMode==1&&this.getPickerPopup())){return b.prototype._togglePrevNext.apply(this,arguments);}var y=this._oMaxDate.getJSDate().getUTCFullYear();var j=this._oMinDate.getJSDate().getUTCFullYear();var m=this._oMaxDate.getJSDate().getUTCMonth();var k=this._oMinDate.getJSDate().getUTCMonth();var n=this._oMinDate.getJSDate().getUTCDate();var p=this._oMaxDate.getJSDate().getUTCDate();var r=this.getAggregation("header");var s=this._getDays();var t;if(this._iMode==1&&!h){var u=this.getAggregation("monthPicker");var v=u.getMonths();var S=u.getStartMonth();var E=S+v-1;t=o.getJSDate().getUTCFullYear();if(S==0||(t==j&&S<=k)){r.setEnabledPrevious(false);}else{r.setEnabledPrevious(true);}if(E>10||(t==y&&E>=m)){r.setEnabledNext(false);}else{r.setEnabledNext(true);}return;}var w=this._getStartDate();var x=this._newUniversalDate(w);x.setUTCDate(x.getUTCDate()+s-1);if(o.getTime()<w.getTime()||o.getTime()>x.getTime()){w=this._newUniversalDate(o);x=this._newUniversalDate(w);x.setUTCDate(x.getUTCDate()+s-1);}t=w.getJSDate().getUTCFullYear();var z=w.getJSDate().getUTCMonth();var A=w.getJSDate().getUTCDate();if(t<j||(t==j&&(!h||z<k||(z==k&&A<=n)))){r.setEnabledPrevious(false);}else{r.setEnabledPrevious(true);}t=x.getJSDate().getUTCFullYear();z=x.getJSDate().getUTCMonth();A=x.getJSDate().getUTCDate();if(t>y||(t==y&&(!h||z>m||(z==m&&A>=p)))){r.setEnabledNext(false);}else{r.setEnabledNext(true);}};e.prototype._shiftStartFocusDates=function(s,F,h){s.setUTCDate(s.getUTCDate()+h);F.setUTCDate(F.getUTCDate()+h);this._setFocusedDate(F);this._setStartDate(s,true);};e.prototype._handlePrevious=function(E){var F=this._newUniversalDate(this._getFocusedDate());var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");var s=this._newUniversalDate(this._getStartDate());var h=this._getDays();switch(this._iMode){case 0:this._shiftStartFocusDates(s,F,(h*-1));break;case 1:if(m.getMonths()<12){m.previousPage();this._togglePrevNext(F);}else{F.setUTCFullYear(F.getUTCFullYear()-1);var j=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getUTCFullYear());if(j){this.fireStartDateChange();}}break;case 2:y.previousPage();this._togglePrevNexYearPicker();break;}};e.prototype._handleNext=function(E){var F=this._newUniversalDate(this._getFocusedDate());var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");var s=this._newUniversalDate(this._getStartDate());var h=this._getDays();switch(this._iMode){case 0:this._shiftStartFocusDates(s,F,h);break;case 1:if(m.getMonths()<12){m.nextPage();this._togglePrevNext(F);}else{F.setUTCFullYear(F.getUTCFullYear()+1);var j=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getUTCFullYear());if(j){this.fireStartDateChange();}}break;case 2:y.nextPage();this._togglePrevNexYearPicker();break;}};e.prototype._getDisplayedMonths=function(o){var m=[];var h=o.getUTCMonth();var j=this._getDays();m.push(h);if(j>this._getDaysLarge()){var E=this._newUniversalDate(o);E.setUTCDate(E.getUTCDate()+j-1);var k=E.getUTCMonth();while(h!=k){h=(h+1)%12;m.push(h);}}return m;};e.prototype._getDisplayedSecondaryMonths=function(p,s){var h=this._getDays();var S=this._getStartDate();S=U.getInstance(S.getJSDate(),s);var j=S.getUTCMonth();var E=this._newUniversalDate(S);E.setUTCDate(E.getUTCDate()+h-1);E=U.getInstance(E.getJSDate(),s);var k=E.getUTCMonth();return{start:j,end:k};};e.prototype._openPickerPopup=function(p){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(_,this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(p);var h=this.getAggregation("header");var j=sap.ui.core.Popup.Dock;this._oPopup.open(0,j.CenterTop,j.CenterBottom,h,null,"flipfit",true);};e.prototype._setStartDate=function(s,S,n){var m=this._newUniversalDate(this._oMaxDate);m.setUTCDate(m.getUTCDate()-this._getDays()+1);if(m.getTime()<this._oMinDate.getTime()){m=new U(this._oMinDate.getTime());m.setUTCDate(m.getUTCDate()+this._getDays()-1);}if(s.getTime()<this._oMinDate.getTime()){s=this._newUniversalDate(this._oMinDate);}else if(s.getTime()>m.getTime()){s=m;}var o=a._createLocalDate(s);this.setProperty("startDate",o,true);this._oUTCStartDate=s;var h=this.getAggregation("month")[0];h.setStartDate(o);this._updateHeader(s);if(S){var j=a._createLocalDate(this._getFocusedDate());if(!h.checkDateFocusable(j)){this._setFocusedDate(s);h.setDate(o);}else{h.setDate(j);}}if(!n){this.fireStartDateChange();}};e.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=this._getFocusedDate();}return this._oUTCStartDate;};function _(E){this._closedPickers();}function f(E){var F=this._newUniversalDate(this._getFocusedDate());this._togglePrevNext(F);}function g(E){this._togglePrevNexYearPicker();}return e;},true);
