/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2016 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/CustomData","sap/ui/core/Icon","sap/ui/Device","sap/m/Breadcrumbs","./ObjectPageHeaderActionButton","sap/ui/core/ResizeHandler","sap/m/Text","sap/m/Button","sap/m/ActionSheet","sap/m/Image","./library"],function(C,I,a,b,D,B,O,R,T,c,A,d,l){"use strict";var e=C.extend("sap.uxap.ObjectPageHeader",{metadata:{library:"sap.uxap",properties:{objectImageURI:{type:"string",defaultValue:null},objectImageAlt:{type:"string",defaultValue:''},objectImageDensityAware:{type:"boolean",defaultValue:false},objectTitle:{type:"string",defaultValue:null},objectSubtitle:{type:"string",defaultValue:null},objectImageShape:{type:"sap.uxap.ObjectPageHeaderPictureShape",defaultValue:sap.uxap.ObjectPageHeaderPictureShape.Square},isObjectIconAlwaysVisible:{type:"boolean",defaultValue:false},isObjectTitleAlwaysVisible:{type:"boolean",defaultValue:true},isObjectSubtitleAlwaysVisible:{type:"boolean",defaultValue:true},isActionAreaAlwaysVisible:{type:"boolean",defaultValue:true},headerDesign:{type:"sap.uxap.ObjectPageHeaderDesign",defaultValue:sap.uxap.ObjectPageHeaderDesign.Light},showTitleSelector:{type:"boolean",group:"Misc",defaultValue:false},markFavorite:{type:"boolean",group:"Misc",defaultValue:false},markFlagged:{type:"boolean",group:"Misc",defaultValue:false},showMarkers:{type:"boolean",group:"Misc",defaultValue:false},markLocked:{type:"boolean",group:"Misc",defaultValue:false},showPlaceholder:{type:"boolean",group:"Misc",defaultValue:false},markChanges:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"actions",aggregations:{_breadCrumbs:{type:"sap.m.Breadcrumbs",multiple:false,visibility:"hidden"},breadCrumbsLinks:{type:"sap.m.Link",multiple:true,singularName:"breadCrumbLink"},_overflowButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_objectImage:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_lockIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_lockIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_titleArrowIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_favIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_flagIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_overflowActionSheet:{type:"sap.m.ActionSheet",multiple:false,visibility:"hidden"},_changesIconCont:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_changesIcon:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_sideContentBtn:{type:"sap.m.Button",multiple:false,visibility:"hidden"},navigationBar:{type:"sap.m.Bar",multiple:false},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},sideContentButton:{type:"sap.m.Button",multiple:false}},events:{titleSelectorPress:{parameters:{domRef:{type:"string"}}},markLockedPress:{parameters:{domRef:{type:"string"}}},markChangesPress:{parameters:{domRef:{type:"string"}}}}}});e.prototype._iAvailablePercentageForActions=0.3;e.prototype.init=function(){if(!this.oLibraryResourceBundle){this.oLibraryResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");}if(!this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=l.i18nModel.getResourceBundle();}this._oOverflowActionSheet=this._getInternalAggregation("_overflowActionSheet");this._oOverflowButton=this._getInternalAggregation("_overflowButton").attachPress(this._handleOverflowButtonPress,this);this._oExpandButton=this._getInternalAggregation("_expandButton");this._oActionSheetButtonMap={};this._oFlagIcon=this._getInternalAggregation("_flagIcon");this._oFavIcon=this._getInternalAggregation("_favIcon");this._oTitleArrowIcon=this._getInternalAggregation("_titleArrowIcon").attachPress(this._handleArrowPress,this);this._oTitleArrowIconCont=this._getInternalAggregation("_titleArrowIconCont").attachPress(this._handleArrowPress,this);this._oLockIcon=this._getInternalAggregation("_lockIcon").attachPress(this._handleLockPress,this);this._oLockIconCont=this._getInternalAggregation("_lockIconCont").attachPress(this._handleLockPress,this);this._oChangesIcon=this._getInternalAggregation("_changesIcon").attachPress(this._handleChangesPress,this);this._oChangesIconCont=this._getInternalAggregation("_changesIconCont").attachPress(this._handleChangesPress,this);};e.prototype._handleOverflowButtonPress=function(E){this._oOverflowActionSheet.openBy(this._oOverflowButton);};e.prototype._handleArrowPress=function(E){this.fireTitleSelectorPress({domRef:E.getSource().getDomRef()});};e.prototype._handleLockPress=function(E){this.fireMarkLockedPress({domRef:E.getSource().getDomRef()});};e.prototype._handleChangesPress=function(E){this.fireMarkChangesPress({domRef:E.getSource().getDomRef()});};e._internalAggregationFactory={"_objectImage":function(P){var h,s=P.getObjectImageURI();if(s.indexOf("sap-icon://")==0){h=new b();h.addStyleClass("sapUxAPObjectPageHeaderObjectImageIcon");}else{h=new d({densityAware:P.getObjectImageDensityAware(),alt:P.getObjectImageAlt(),decorative:false});h.addStyleClass("sapUxAPObjectPageHeaderObjectImage");}h.setSrc(s);if(P.getObjectImageAlt()){h.setTooltip(P.getObjectImageAlt());}return h;},"_overflowActionSheet":function(){return new A({placement:sap.m.PlacementType.Bottom});},"_lockIconCont":function(P){return this._getButton(P,"sap-icon://private","lock-cont");},"_breadCrumbs":function(P){return new B({links:P.getAggregation("breadCrumbLinks")});},"_lockIcon":function(P){return this._getButton(P,"sap-icon://private","lock",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_LOCK_MARK_VALUE"));},"_titleArrowIconCont":function(P){return this._getButton(P,"sap-icon://arrow-down","titleArrow-cont",P.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_titleArrowIcon":function(P){return this._getButton(P,"sap-icon://arrow-down","titleArrow",P.oLibraryResourceBundleOP.getText("OP_SELECT_ARROW_TOOLTIP"));},"_favIcon":function(P){return this._getIcon(P,"favorite",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FAVORITE_MARK_VALUE"));},"_flagIcon":function(P){return this._getIcon(P,"flag",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_FLAG_MARK_VALUE"));},"_overflowButton":function(P){return this._getButton(P,"sap-icon://overflow","overflow");},"_expandButton":function(P){return this._getButton(P,"sap-icon://slim-arrow-down","expand",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_EXPAND_HEADER_BTN"));},"_changesIconCont":function(P){return this._getButton(P,"sap-icon://user-edit","changes-cont",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},"_changesIcon":function(P){return this._getButton(P,"sap-icon://user-edit","changes",P.oLibraryResourceBundleOP.getText("TOOLTIP_OP_CHANGES_MARK_VALUE"));},_getIcon:function(P,i,t){return I.createControlByURI({id:this._getParentAugmentedId(P,i),tooltip:t,src:I.getIconURI(i),visible:false});},_getButton:function(P,i,s,t){return new c({id:this._getParentAugmentedId(P,s),tooltip:t,icon:i,type:sap.m.ButtonType.Transparent});},_getParentAugmentedId:function(P,s){return P.getId()+"-"+s;}};e.prototype._getInternalAggregation=function(s){if(!this.getAggregation(s)){this.setAggregation(s,e._internalAggregationFactory[s](this));}return this.getAggregation(s);};e.prototype._applyActionProperty=function(P,h){var n=h[0];if(this.getProperty(P)!==n){h.unshift(P);this.setProperty.apply(this,h);this._notifyParentOfChanges();}return this;};e.prototype._applyObjectImageProperty=function(P,h){var n=h[0];if(this.getProperty(P)!==n){h.unshift(P);this.setProperty.apply(this,h);this._destroyObjectImage();this._notifyParentOfChanges();}return this;};e.prototype._proxyMethodToBreadCrumbControl=function(F,h){var i=this._getInternalAggregation("_breadCrumbs"),r=i[F].apply(i,h);this.invalidate();return r;};e.prototype.setHeaderDesign=function(h){this.setProperty("headerDesign",h);if(this.getParent()){this.getParent().invalidate();}return this;};e.prototype._shiftHeaderTitle=function(){var P=this.getParent(),s,$,i;if(!P||(typeof P._calculateShiftOffset!=="function")){return;}s=P._calculateShiftOffset();$=this.$().find(".sapUxAPObjectPageHeaderIdentifierActions");i=parseInt($.css(s.sStyleAttribute),10);$.css(s.sStyleAttribute,i+"px");if(typeof P._shiftHeader==="function"){P._shiftHeader(s.sStyleAttribute,s.iMarginalsOffset+"px");}};e.prototype.setObjectTitle=function(n){var s=this.getProperty("objectTitle"),h=s!==n;this._applyActionProperty("objectTitle",Array.prototype.slice.call(arguments));if(h&&this.mEventRegistry["_titleChange"]){this.fireEvent("_titleChange",{"id":this.getId(),"name":"objectTitle","oldValue":s,"newValue":n});}return this;};var p=["objectSubtitle","showTitleSelector","markLocked","markFavorite","markFlagged","showMarkers","showPlaceholder","markChanges"],o=["objectImageURI","objectImageAlt","objectImageDensityAware","objectImageShape"];var g=function(P){var s="set"+P.charAt(0).toUpperCase()+P.slice(1);e.prototype[s]=function(){var h=Array.prototype.slice.call(arguments);this._applyActionProperty.call(this,P,h);};};var G=function(P){var s="set"+P.charAt(0).toUpperCase()+P.slice(1);e.prototype[s]=function(){var h=Array.prototype.slice.call(arguments);this._applyObjectImageProperty.call(this,P,h);};};var f=function(P,s,t){var h="set"+P.charAt(0).toUpperCase()+P.slice(1);s[h]=function(){var i=Array.prototype.slice.call(arguments);i.unshift(P);t.setProperty.apply(t,i);return this.setProperty.apply(this,i);};};p.forEach(g);o.forEach(G);e.prototype.getBreadCrumbsLinks=function(){return this._getInternalAggregation("_breadCrumbs").getLinks();};e.prototype.addBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("addLink",arguments);};e.prototype.indexOfBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("indexOfLink",arguments);};e.prototype.insertBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("insertLink",arguments);};e.prototype.removeBreadCrumbLink=function(){return this._proxyMethodToBreadCrumbControl("removeLink",arguments);};e.prototype.removeAllBreadCrumbsLinks=function(){return this._proxyMethodToBreadCrumbControl("removeAllLinks",arguments);};e.prototype.destroyBreadCrumbsLinks=function(){return this._proxyMethodToBreadCrumbControl("destroyLinks",arguments);};e.prototype._destroyObjectImage=function(){var s="_objectImage",h=this.getAggregation(s);if(h){h.destroy();this.setAggregation(s,null);}};e.prototype.onBeforeRendering=function(){if(this.getShowPlaceholder()){this._oPlaceholder=I.createControlByURI({src:I.getIconURI("picture"),visible:true});}var s=this.getSideContentButton();if(s&&!s.getTooltip()){s.setTooltip(this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SHOW_SIDE_CONTENT"));}var h=this.getActions()||[];this._oOverflowActionSheet.removeAllButtons();this._oActionSheetButtonMap={};if(h.length>1||this._hasOneButtonShowText(h)){h.forEach(function(i){if(i instanceof c&&!(i instanceof O)){i._bInternalVisible=i.getVisible();i._getInternalVisible=function(){return this._bInternalVisible;};i._setInternalVisible=function(v,k){this.$().toggle(v);if(v!=this._bInternalVisible){this._bInternalVisible=v;if(k){this.invalidate();}}};i.onAfterRendering=function(){if(!this._getInternalVisible()){this.$().hide();}};}if(i instanceof c&&(i.getType()==="Default"||i.getType()==="Unstyled")){i.setProperty("type",sap.m.ButtonType.Transparent,false);}if(i instanceof c&&i.getVisible()){var j=this._createActionSheetButton(i);this._oActionSheetButtonMap[i.getId()]=j;this._oOverflowActionSheet.addButton(j);f("text",i,j);f("icon",i,j);f("enabled",i,j);}},this);}this._oTitleArrowIcon.setVisible(this.getShowTitleSelector());this._oFavIcon.setVisible(this.getMarkFavorite());this._oFlagIcon.setVisible(this.getMarkFlagged());this._attachDetachActionButtonsHandler(false);};e.prototype._createActionSheetButton=function(h){return new c({press:jQuery.proxy(this._onSeeMoreContentSelect,this),enabled:h.getEnabled(),text:h.getText(),icon:h.getIcon(),tooltip:h.getTooltip(),customData:new a({key:"originalId",value:h.getId()})});};e.prototype._handleImageNotFoundError=function(){var h=this._getInternalAggregation("_objectImage"),P=this.getParent(),$=P?P.$():this.$();if(this.getShowPlaceholder()){$.find(".sapMImg.sapUxAPObjectPageHeaderObjectImage").hide();$.find(".sapUxAPObjectPageHeaderPlaceholder").removeClass("sapUxAPHidePlaceholder");}else{h.addStyleClass("sapMNoImg");}};e.prototype._clearImageNotFoundHandler=function(){this._getInternalAggregation("_objectImage").$().off("error");};e.prototype.onAfterRendering=function(){var $=this._getInternalAggregation("_objectImage").$();this._adaptLayout();this._clearImageNotFoundHandler();$.error(this._handleImageNotFoundError.bind(this));if(!this.getObjectImageURI()){this._handleImageNotFoundError();}if(!this._iResizeId){this._iResizeId=R.register(this,this._onHeaderResize.bind(this));}this._shiftHeaderTitle();this._attachDetachActionButtonsHandler(true);};e.prototype._onHeaderResize=function(){this._adaptLayout();if(this.getParent()&&typeof this.getParent()._adjustHeaderHeights==="function"){this.getParent()._adjustHeaderHeights();}};e.prototype._attachDetachActionButtonsHandler=function(h){var i=this.getActions()||[];if(i.length<1){return;}i.forEach(function(j){if(j instanceof c){var k=this._oActionSheetButtonMap[j.getId()];if(h){j.attachEvent("_change",this._adaptLayout,this);if(k){k.attachEvent("_change",this._adaptOverflow,this);}}else{j.detachEvent("_change",this._adaptLayout,this);if(k){k.detachEvent("_change",this._adaptOverflow,this);}}}},this);};e.prototype._onSeeMoreContentSelect=function(E){var P=E.getSource(),h=sap.ui.getCore().byId(P.data("originalId"));if(h.firePress){h.firePress({overflowButtonId:this._oOverflowButton.getId()});}this._oOverflowActionSheet.close();};e._actionImportanceMap={"Low":3,"Medium":2,"High":1};e._sortActionsByImportance=function(h,i){var s=(h instanceof O)?h.getImportance():sap.uxap.Importance.High,j=(i instanceof O)?i.getImportance():sap.uxap.Importance.High,k=e._actionImportanceMap[s]-e._actionImportanceMap[j];if(k===0){return h.position-i.position;}return k;};e.prototype._hasOneButtonShowText=function(h){var i=false;if(h.length!==1){return i;}if(h[0]instanceof O){i=(!h[0].getHideText()&&h[0].getText()!="");}else if(h[0]instanceof c){i=(h[0].getText()!="");}return i;};e.prototype._adaptLayout=function(E){var i=this.$("identifierLine").width(),h=this._getActionsWidth(),j=h/i,k=this._iAvailablePercentageForActions*i,$=this._oOverflowButton.$(),m=this.$("actions").find(".sapMBtn").not(".sapUxAPObjectPageHeaderExpandButton");if(j>this._iAvailablePercentageForActions){this._adaptActions(k);}else if(E&&E.getSource()instanceof O){E.getSource()._setInternalVisible(true);}if(sap.ui.Device.system.phone){m.css("visibility","visible");}if(m.filter(":visible").length===m.length){$.hide();}this._adaptObjectPageHeaderIndentifierLine();};e.prototype._adaptObjectPageHeaderIndentifierLine=function(){var i=this.$("identifierLine").width(),$=this.$("subtitle"),h=this.$("identifierLineContainer"),s,t,j=this.$("actions").width()+this.$().find(".sapUxAPObjectPageHeaderObjectImageContainer").width(),P=this.$().parents().hasClass('sapUiSizeCompact')?7:3;if($.length){if($.hasClass("sapOPHSubtitleBlock")){$.removeClass("sapOPHSubtitleBlock");}s=$.outerHeight()+$.position().top;t=this.$("innerTitle").outerHeight()+this.$("innerTitle").position().top;if(Math.abs(s-t)>P){$.addClass("sapOPHSubtitleBlock");}}h.width((0.95-(j/i))*100+"%");};e.prototype._adaptActions=function(h){var m=jQuery("html").hasClass("sapUiMedia-Std-Phone")||D.system.phone,v=this._oOverflowButton.$().show().width(),j=this.getActions(),k=j.length,n;for(var i=0;i<k;i++){j[i].position=i;}j.sort(e._sortActionsByImportance);j.forEach(function(q){n=this._oActionSheetButtonMap[q.getId()];if(n){v+=q.$().width();if(h>v&&!m){this._setActionButtonVisibility(q,true);}else{this._setActionButtonVisibility(q,false);}}},this);};e.prototype._adaptOverflow=function(){var h=this._oOverflowActionSheet.getButtons();var H=h.some(function(i){return i.getVisible();});this._oOverflowButton.$().toggle(H);};e.prototype._setActionButtonVisibility=function(h,v){var i=this._oActionSheetButtonMap[h.getId()];if(i){if(h.getVisible()){h._setInternalVisible(v);i.setVisible(!v);}else{i.setVisible(false);}}};e.prototype._getActionsWidth=function(){var w=0;this.getActions().forEach(function(h){if(h instanceof c){h.$().show();if(sap.ui.Device.system.phone){h.$().css("visibility","hidden");}w+=h.$().outerWidth(true);}});return w;};e.prototype._notifyParentOfChanges=function(){if(this.getParent()&&typeof this.getParent()._headerTitleChangeHandler==="function"){this.getParent()._headerTitleChangeHandler();}};e.prototype._getActionsPaddingStatus=function(){return this.$("actions").hasClass("sapUxAPObjectPageHeaderIdentifierActionsNoPadding");};e.prototype._setActionsPaddingStatus=function(s){return this.$("actions").toggleClass("sapUxAPObjectPageHeaderIdentifierActionsNoPadding",s);};e.prototype.exit=function(){this._clearImageNotFoundHandler();if(this._iResizeId){R.deregister(this._iResizeId);}};e.prototype.setNavigationBar=function(h){this.setAggregation("navigationBar",h);if(h&&this.mEventRegistry["_adaptableContentChange"]){this.fireEvent("_adaptableContentChange",{"parent":this,"adaptableContent":h});}return this;};e.prototype._getAdaptableContent=function(){return this.getNavigationBar();};return e;});
