/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/f/Avatar',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/IconPool"],function(q,l,C,I){"use strict";
var A=C.extend("sap.f.Avatar",{metadata:{library:"sap.f",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},displayShape:{type:"sap.f.AvatarShape",group:"Appearance",defaultValue:sap.f.AvatarShape.Circle},displaySize:{type:"sap.f.AvatarSize",group:"Appearance",defaultValue:sap.f.AvatarSize.S},customDisplaySize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"3rem"},customFontSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"1.125rem"},imageFitType:{type:"sap.f.AvatarImageFitType",group:"Appearance",defaultValue:sap.f.AvatarImageFitType.Cover}},events:{press:{}}}});
A.DEFAULT_CIRCLE_PLACEHOLDER="sap-icon://person-placeholder";A.DEFAULT_SQUARE_PLACEHOLDER="sap-icon://product";
A.prototype.init=function(){this._sActualType=null;this._bIsDefaultIcon=true;};
A.prototype.exit=function(){if(this._icon){this._icon.destroy();}};
A.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};
A.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");if(this.getDecorative()){this.$().attr("role","presentation");}else{this.$().removeAttr("role");}}return this;};
A.prototype.ontap=function(e){this.firePress({});};
A.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){this.firePress({});e.stopPropagation();}};
A.prototype._areInitialsValid=function(i){var v=/^[a-zA-Z]{1,2}$/;if(!v.test(i)){q.sap.log.warning("Initials should consist of only 1 or 2 latin letters",this);this._sActualType=sap.f.AvatarType.Icon;this._bIsDefaultIcon=true;return false;}return true;};
A.prototype._validateSrc=function(s){if(I.isIconURI(s)){this._sActualType=sap.f.AvatarType.Icon;this._bIsDefaultIcon=false;}else{this._sActualType=sap.f.AvatarType.Image;}return this;};
A.prototype._getActualDisplayType=function(){var s=this.getSrc(),i=this.getInitials();if(s){this._validateSrc(s);}else if(i&&this._areInitialsValid(i)){this._sActualType=sap.f.AvatarType.Initials;}else{q.sap.log.warning("No src and initials were provided",this);this._sActualType=sap.f.AvatarType.Icon;this._bIsDefaultIcon=true;}return this._sActualType;};
A.prototype._getDefaultIconPath=function(d){var D=null;if(d===sap.f.AvatarShape.Circle){D=A.DEFAULT_CIRCLE_PLACEHOLDER;}else if(d===sap.f.AvatarShape.Square){D=A.DEFAULT_SQUARE_PLACEHOLDER;}return D;};
A.prototype._getIcon=function(){var s=this.getSrc(),d=this.getDisplayShape();if(this._bIsDefaultIcon){s=this._getDefaultIconPath(d);}if(!this._icon){this._icon=I.createControlByURI({alt:"Image placeholder",src:s});}else if(this._icon.getSrc()!==s){this._icon.setSrc(s);}return this._icon;};
A.prototype.getAccessibilityInfo=function(){var h=this.hasListeners("press");if(!h){return null;}return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),focusable:h};};
return A;},true);
sap.ui.predefine('sap/f/AvatarRenderer',[],function(){"use strict";var A={};
A.render=function(r,a){var i=a.getInitials(),s=a._getActualDisplayType(),d=a.getDisplaySize(),D=a.getDisplayShape(),I=a.getImageFitType(),c=a.getCustomDisplaySize(),C=a.getCustomFontSize(),S=a.getSrc(),b="sapFAvatar";r.write("<span");r.writeControlData(a);r.addClass(b);r.addClass(b+d);r.addClass(b+s);r.addClass(b+D);if(a.hasListeners("press")){r.addClass("sapMPointer");r.addClass("sapFAvatarFocusable");r.writeAccessibilityState(a,{"role":"button"});r.writeAttribute("tabIndex",0);}if(s===sap.f.AvatarType.Image){r.addClass(b+s+I);r.addStyle("background-image","url('"+jQuery.sap.encodeHTML(S)+"')");}if(d===sap.f.AvatarSize.Custom){r.addStyle("width",c);r.addStyle("height",c);r.addStyle("font-size",C);}r.writeClasses();r.writeStyles();r.write(">");if(s===sap.f.AvatarType.Icon){r.renderControl(a._getIcon());}else if(s===sap.f.AvatarType.Initials){r.write("<span");r.addClass(b+"InitialsHolder");r.writeClasses();r.write(">");r.writeEscaped(i);r.write("</span>");}r.write("</span>");};
return A;},true);
sap.ui.predefine('sap/f/DynamicPage',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/ScrollBar","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device"],function(q,l,C,S,R,a,D){"use strict";
var b=C.extend("sap.f.DynamicPage",{metadata:{library:"sap.f",properties:{preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},fitContent:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{title:{type:"sap.f.DynamicPageTitle",multiple:false},header:{type:"sap.f.DynamicPageHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.m.IBar",multiple:false},_scrollBar:{type:"sap.ui.core.ScrollBar",multiple:false,visibility:"hidden"}}}});
function e(o){if(arguments.length===1){return o&&("length"in o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(O){return e(O);});}
var u=sap.ui.getCore().getConfiguration().getAnimation();b.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE=0.6;b.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;b.FOOTER_ANIMATION_DURATION=350;b.BREAK_POINTS={TABLET:1024,PHONE:600};b.EVENTS={TITLE_PRESS:"_titlePress",PIN_UNPIN_PRESS:"_pinUnpinPress"};b.MEDIA={INVISIBLE:"sapUiHidden",PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};b.RESIZE_HANDLER_ID={PAGE:"_sResizeHandlerId",TITLE:"_sTitleResizeHandlerId",CONTENT:"_sContentResizeHandlerId"};
b.prototype.init=function(){this._bPinned=false;this._bHeaderInTitleArea=false;this._bExpandingWithAClick=false;this._headerBiggerThanAllowedHeight=false;this._oScrollHelper=new a(this,this.getId()+"-content",{horizontal:false,vertical:true});};
b.prototype.onBeforeRendering=function(){if(!this._preserveHeaderStateOnScroll()){this._attachPinPressHandler();}this._attachTitlePressHandler();this._detachScrollHandler();};
b.prototype.onAfterRendering=function(){if(this._preserveHeaderStateOnScroll()){q.sap.delayedCall(0,this,this._overridePreserveHeaderStateOnScroll);}this._bPinned=false;this._cacheDomElements();this._detachResizeHandlers();this._attachResizeHandlers();this._updateMedia(this._getWidth(this));this._attachScrollHandler();this._updateScrollBar();this._attachPageChildrenAfterRenderingDelegates();this._resetPinButtonState();};
b.prototype.exit=function(){this._detachResizeHandlers();if(this._oScrollHelper){this._oScrollHelper.destroy();}};
b.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};
b.prototype.setHeaderExpanded=function(h){if(this.getHeaderExpanded()===h){return this;}this._titleExpandCollapseWhenAllowed();return this;};
b.prototype.setPreserveHeaderStateOnScroll=function(p){var r=this.setProperty("preserveHeaderStateOnScroll",p,false);if(p||this._shouldExpand()){this.setHeaderExpanded(true);}return r;};
b.prototype.setToggleHeaderOnTitleClick=function(t){var r=this.setProperty("toggleHeaderOnTitleClick",t,true);this.$().toggleClass("sapFDynamicPageTitleClickEnabled",t);return r;};
b.prototype.setFitContent=function(f){var r=this.setProperty("fitContent",f,true);if(e(this.$())){this._updateFitContainer();}return r;};
b.prototype.getScrollDelegate=function(){return this._oScrollHelper;};
b.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._headerBiggerThanAllowedHeight=false;return;}this._headerBiggerThanAllowedHeight=true;this._moveHeaderToContentArea();this._updateScrollBar();};
b.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed()&&this._preserveHeaderStateOnScroll();};
b.prototype._toggleFooter=function(s){var f=this.getFooter();if(!e(this.$())){return;}if(!e(f)){return;}f.toggleStyleClass("sapFDynamicPageActualFooterControlShow",s);f.toggleStyleClass("sapFDynamicPageActualFooterControlHide",!s);this._toggleFooterSpacer(s);if(u){if(!s){q.sap.delayedCall(b.FOOTER_ANIMATION_DURATION,this,function(){this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());});}else{this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());}q.sap.delayedCall(b.FOOTER_ANIMATION_DURATION,this,function(){f.removeStyleClass("sapFDynamicPageActualFooterControlShow");});}this._updateScrollBar();};
b.prototype._toggleFooterSpacer=function(t){var $=this.$("spacer");if(e($)){$.toggleClass("sapFDynamicPageContentWrapperSpacer",t);}if(e(this.$contentFitContainer)){this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainerFooterVisible",t);}};
b.prototype._toggleHeader=function(){if(this._preserveHeaderStateOnScroll()){return;}if(this._shouldSnap()){this._snapHeader(true);this._updateHeaderARIAState(false);}else if(this._shouldExpand()){this._expandHeader();this._updateHeaderARIAState(true);}else if(!this._bPinned&&this._bHeaderInTitleArea){this._moveHeaderToContentArea();}};
b.prototype._snapHeader=function(A){var d=this.getTitle();if(this._bPinned){q.sap.log.debug("DynamicPage :: aborted snapping, header is pinned",this);return;}q.sap.log.debug("DynamicPage :: snapped header",this);if(e(d)){if(e(d.getExpandedContent())){d._setShowExpandContent(false);}if(e(d.getSnappedContent())){d._setShowSnapContent(true);}if(A){this._moveHeaderToContentArea();}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't snap header. There's no title.",this);return;}this.setProperty("headerExpanded",false,true);this.$titleArea.addClass("sapFDynamicPageTitleSnapped");};
b.prototype._expandHeader=function(A){var d=this.getTitle();q.sap.log.debug("DynamicPage :: expand header",this);if(e(d)){if(e(d.getExpandedContent())){d._setShowExpandContent(true);}if(e(d.getSnappedContent())){d._setShowSnapContent(false);}if(A){this._moveHeaderToTitleArea();}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't expand header. There's no title.",this);return;}this.setProperty("headerExpanded",true,true);this.$titleArea.removeClass("sapFDynamicPageTitleSnapped");};
b.prototype._toggleHeaderVisibility=function(s){var E=this.getHeaderExpanded(),d=this.getTitle(),o=this.getHeader();if(this._bPinned){q.sap.log.debug("DynamicPage :: header toggle aborted, header is pinned",this);return;}if(e(d)){d._setShowExpandContent(E);d._setShowSnapContent(!E);}if(e(o)){o.$().toggleClass("sapFDynamicPageHeaderHidden",!s);this._updateScrollBar();}};
b.prototype._moveHeaderToContentArea=function(){var d=this.getHeader();if(e(d)){d.$().prependTo(this.$wrapper);this._bHeaderInTitleArea=false;}};
b.prototype._moveHeaderToTitleArea=function(){var d=this.getHeader();if(e(d)){d.$().appendTo(this.$titleArea);this._bHeaderInTitleArea=true;}};
b.prototype._scrollToSnapHeader=function(){this._setScrollPosition(this._getSnappingHeight()+1);};
b.prototype._pin=function(){if(!this._bPinned){this._bPinned=true;this._moveHeaderToTitleArea();this._updateScrollBar();this._togglePinButtonARIAState(this._bPinned);}};
b.prototype._unPin=function(){if(this._bPinned){this._bPinned=false;this._togglePinButtonARIAState(this._bPinned);}};
b.prototype._togglePinButtonVisibility=function(t){var d=this.getHeader();if(e(d)){d._setShowPinBtn(t);}};
b.prototype._togglePinButtonPressedState=function(p){var d=this.getHeader();if(e(d)){d._togglePinButton(p);}};
b.prototype._togglePinButtonARIAState=function(p){var d=this.getHeader();if(e(d)){d._updateARIAPinButtonState(p);}};
b.prototype._resetPinButtonState=function(){if(this._preserveHeaderStateOnScroll()){this._togglePinButtonVisibility(false);}else{this._togglePinButtonPressedState(false);this._togglePinButtonARIAState(false);}};
b.prototype._restorePinButtonFocus=function(){this.getHeader()._focusPinButton();};
b.prototype._getScrollPosition=function(){if(D.system.desktop){return this._getScrollBar().getScrollPosition();}return e(this.$wrapper)?this.$wrapper.scrollTop():0;};
b.prototype._setScrollPosition=function(n){if(e(this.$wrapper)){this.$wrapper.scrollTop(n);D.system.desktop&&this._getScrollBar().setScrollPosition(n);}};
b.prototype._shouldSnap=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()>this._getSnappingHeight()&&this.getHeaderExpanded()&&!this._bPinned;};
b.prototype._shouldExpand=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()<this._getSnappingHeight()&&!this.getHeaderExpanded()&&!this._bPinned;};
b.prototype._headerScrolledOut=function(){return this._getScrollPosition()>this._getSnappingHeight();};
b.prototype._headerSnapAllowed=function(){return!this._preserveHeaderStateOnScroll()&&this.getHeaderExpanded()&&!this._bPinned;};
b.prototype._canSnapHeaderOnScroll=function(){return this._getMaxScrollPosition()>(this._getSnappingHeight()+1);};
b.prototype._getSnappingHeight=function(){return this._getHeaderHeight()||this._getTitleHeight();};
b.prototype._getMaxScrollPosition=function(){var $;if(e(this.$wrapper)){$=this.$wrapper[0];return $.scrollHeight-Math.ceil($.getBoundingClientRect().height);}return 0;};
b.prototype._needsVerticalScrollBar=function(){return this._getMaxScrollPosition()>0;};
b.prototype._getOwnHeight=function(){return this._getHeight(this);};
b.prototype._getEntireHeaderHeight=function(){var t=0,h=0,d=this.getTitle(),o=this.getHeader();if(e(d)){t=d.$().outerHeight();}if(e(o)){h=o.$().outerHeight();}return t+h;};
b.prototype._headerBiggerThanAllowedToPin=function(c){if(!(typeof c==="number"&&!isNaN(parseInt(c,10)))){c=this._getOwnHeight();}return this._getEntireHeaderHeight()>b.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE*c;};
b.prototype._headerBiggerThanAllowedToBeFixed=function(){var c=this._getOwnHeight();return this._getEntireHeaderHeight()>b.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*c;};
b.prototype._measureScrollBarOffsetHeight=function(){var h=0,s=!this.getHeaderExpanded();if(this._preserveHeaderStateOnScroll()||this._bPinned){h=this._getTitleAreaHeight();q.sap.log.debug("DynamicPage :: preserveHeaderState is enabled or header pinned :: title area height"+h,this);return h;}if(s||!e(this.getTitle())||!this._canSnapHeaderOnScroll()){h=this._getTitleHeight();q.sap.log.debug("DynamicPage :: header snapped :: title height "+h,this);return h;}this._snapHeader(true);h=this._getTitleHeight();if(this._shouldExpand()&&!s){this._expandHeader();}q.sap.log.debug("DynamicPage :: snapped mode :: title height "+h,this);return h;};
b.prototype._updateScrollBar=function(){var s,c,n;if(!D.system.desktop||!e(this.$wrapper)){return;}s=this._getScrollBar();s.setContentSize(this._measureScrollBarOffsetHeight()+this.$wrapper[0].scrollHeight+"px");c=this._needsVerticalScrollBar();n=this.bHasScrollbar!==c;if(n){s.toggleStyleClass("sapUiHidden",!c);this.toggleStyleClass("sapFDynamicPageWithScroll",c);this.bHasScrollbar=c;q.sap.delayedCall(0,this,this._updateFitContainer);}q.sap.delayedCall(0,this,this._updateScrollBarOffset);};
b.prototype._updateFitContainer=function(n){var N=typeof n!=='undefined'?!n:!this._needsVerticalScrollBar(),f=this.getFitContent(),t=f||N;this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainer",t);};
b.prototype._updateScrollBarOffset=function(){var s=sap.ui.getCore().getConfiguration().getRTL()?"left":"right",o=this._needsVerticalScrollBar()?q.sap.scrollbarSize().width+"px":0,f=this.getFooter();this.$titleArea.css("padding-"+s,o);if(e(f)){f.$().css(s,o);}};
b.prototype._updateHeaderARIAState=function(E){var d=this.getHeader();if(e(d)){d._updateARIAState(E);}};
b.prototype._updateMedia=function(w){if(w===0){this._updateMediaStyle(b.MEDIA.INVISIBLE);}else if(w<=b.BREAK_POINTS.PHONE){this._updateMediaStyle(b.MEDIA.PHONE);}else if(w<=b.BREAK_POINTS.TABLET){this._updateMediaStyle(b.MEDIA.TABLET);}else{this._updateMediaStyle(b.MEDIA.DESKTOP);}};
b.prototype._updateMediaStyle=function(c){Object.keys(b.MEDIA).forEach(function(m){var E=c===b.MEDIA[m];this.toggleStyleClass(b.MEDIA[m],E);},this);};
b.prototype._getHeight=function(c){return!(c instanceof C)?0:c.$().outerHeight()||0;};
b.prototype._getWidth=function(c){return!(c instanceof C)?0:c.$().outerWidth()||0;};
b.prototype._getTitleAreaHeight=function(){return e(this.$titleArea)?this.$titleArea.outerHeight()||0:0;};
b.prototype._getTitleHeight=function(){return this._getHeight(this.getTitle());};
b.prototype._getHeaderHeight=function(){return this._getHeight(this.getHeader());};
b.prototype._preserveHeaderStateOnScroll=function(){return this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedHeight;};
b.prototype._getScrollBar=function(){if(!e(this.getAggregation("_scrollBar"))){var v=new S(this.getId()+"-vertSB",{vertical:true,size:"100%",scrollPosition:0,scroll:this._onScrollBarScroll.bind(this)});this.setAggregation("_scrollBar",v,true);}return this.getAggregation("_scrollBar");};
b.prototype._cacheDomElements=function(){var f=this.getFooter();if(e(f)){this.$footer=f.$();this.$footerWrapper=this.$("footerWrapper");}this.$wrapper=this.$("contentWrapper");this.$contentFitContainer=this.$("contentFitContainer");this.$titleArea=this.$("header");this._cacheTitleDom();};
b.prototype._cacheTitleDom=function(){var t=this.getTitle();if(e(t)){this.$title=t.$();}};
b.prototype.ontouchmove=function(E){E.setMarked();};
b.prototype._onChildControlAfterRendering=function(E){if(E.srcControl instanceof sap.f.DynamicPageTitle){this._cacheTitleDom();this._deRegisterResizeHandler(b.RESIZE_HANDLER_ID.TITLE);this._registerResizeHandler(b.RESIZE_HANDLER_ID.TITLE,this.$title[0],this._onChildControlsHeightChange.bind(this));}q.sap.delayedCall(0,this,this._updateScrollBar);};
b.prototype._onChildControlsHeightChange=function(E){var n=this._needsVerticalScrollBar();if(n){this._updateFitContainer(n);}if(!this._bExpandingWithAClick){this._updateScrollBar();}this._bExpandingWithAClick=false;};
b.prototype._onResize=function(E){var d=this.getHeader();if(!this._preserveHeaderStateOnScroll()&&d){if(this._headerBiggerThanAllowedToPin(E.size.height)||D.system.phone){this._unPin();this._togglePinButtonVisibility(false);this._togglePinButtonPressedState(false);}else{this._togglePinButtonVisibility(true);}}this._updateScrollBar();this._updateMedia(E.size.width);};
b.prototype._onWrapperScroll=function(E){if(!D.system.desktop||!this._bExpandingWithAClick){this._toggleHeader();}if(D.system.desktop){if(this.allowCustomScroll===true&&E.target.scrollTop>0){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getScrollBar().setScrollPosition(E.target.scrollTop);this.toggleStyleClass("sapFDynamicPageWithScroll",this._needsVerticalScrollBar());}};
b.prototype._onScrollBarScroll=function(){this._toggleHeader();if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;this.$wrapper.scrollTop(this._getScrollBar().getScrollPosition());};
b.prototype._onTitlePress=function(){if(this.getToggleHeaderOnTitleClick()){this._titleExpandCollapseWhenAllowed();}};
b.prototype._titleExpandCollapseWhenAllowed=function(){if(this._preserveHeaderStateOnScroll()||!this._needsVerticalScrollBar()){if(!this.getHeaderExpanded()){this._expandHeader(false);this._toggleHeaderVisibility(true);}else{this._snapHeader(false);this._toggleHeaderVisibility(false);}}else if(!this.getHeaderExpanded()){this._bExpandingWithAClick=true;this._expandHeader(true);}else if(this._headerSnapAllowed()){if(this._headerScrolledOut()){this._snapHeader(true);}else if(this._canSnapHeaderOnScroll()){this._scrollToSnapHeader();}else{q.sap.log.warning("DynamicPage :: couldn't snap header. There isn't enough content to be scrolled",this);}}};
b.prototype._onPinUnpinButtonPress=function(E){if(this._bPinned){this._unPin(E);}else{this._pin(E);this._restorePinButtonFocus();}};
b.prototype._attachResizeHandlers=function(){var c=this._onChildControlsHeightChange.bind(this);this._registerResizeHandler(b.RESIZE_HANDLER_ID.PAGE,this,this._onResize.bind(this));if(e(this.$title)){this._registerResizeHandler(b.RESIZE_HANDLER_ID.TITLE,this.$title[0],c);}if(e(this.$contentFitContainer)){this._registerResizeHandler(b.RESIZE_HANDLER_ID.CONTENT,this.$contentFitContainer[0],c);}};
b.prototype._registerResizeHandler=function(h,o,H){if(!this[h]){this[h]=R.register(o,H);}};
b.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(b.RESIZE_HANDLER_ID.PAGE);this._deRegisterResizeHandler(b.RESIZE_HANDLER_ID.TITLE);this._deRegisterResizeHandler(b.RESIZE_HANDLER_ID.CONTENT);};
b.prototype._deRegisterResizeHandler=function(h){if(this[h]){R.deregister(this[h]);this[h]=null;}};
b.prototype._attachPageChildrenAfterRenderingDelegates=function(){var t=this.getTitle(),c=this.getContent(),p={onAfterRendering:this._onChildControlAfterRendering.bind(this)};if(e(t)){t.addEventDelegate(p);}if(e(c)){c.addEventDelegate(p);}};
b.prototype._attachTitlePressHandler=function(){var t=this.getTitle();if(e(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(b.EVENTS.TITLE_PRESS,this._onTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};
b.prototype._attachPinPressHandler=function(){var h=this.getHeader();if(e(h)&&!this._bAlreadyAttachedPinPressHandler){h.attachEvent(b.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};
b.prototype._attachScrollHandler=function(){this.$wrapper.on("scroll",this._onWrapperScroll.bind(this));};
b.prototype._detachScrollHandler=function(){if(this.$wrapper){this.$wrapper.unbind("scroll");}};
return b;},true);
sap.ui.predefine('sap/f/DynamicPageHeader',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/m/ButtonType","sap/m/ToggleButton"],function(q,l,C,I,B,T){"use strict";
var D=C.extend("sap.f.DynamicPageHeader",{metadata:{library:"sap.f",properties:{pinnable:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_pinButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}}}});
D._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};
D.ARIA={ARIA_CONTROLS:"aria-controls",ARIA_EXPANDED:"aria-expanded",ARIA_LABEL:"aria-label",LABEL_EXPANDED:D._getResourceBundle().getText("EXPANDED_HEADER"),LABEL_SNAPPED:D._getResourceBundle().getText("SNAPPED_HEADER"),LABEL_PINNED:D._getResourceBundle().getText("PIN_HEADER"),LABEL_UNPINNED:D._getResourceBundle().getText("UNPIN_HEADER"),STATE_TRUE:"true",STATE_FALSE:"false"};
D.prototype.onAfterRendering=function(){this._initARIAState();this._initPinButtonARIAState();};
D.prototype._togglePinButton=function(v){this._getPinButton().setPressed(v);};
D.prototype._setShowPinBtn=function(v){this._getPinButton().$().toggleClass("sapUiHidden",!v);};
D.prototype._pinUnpinFireEvent=function(){this.fireEvent("_pinUnpinPress");};
D.prototype._initARIAState=function(){var $=this.$();$.attr(D.ARIA.ARIA_EXPANDED,D.ARIA.STATE_TRUE);$.attr(D.ARIA.ARIA_LABEL,D.ARIA.LABEL_EXPANDED);};
D.prototype._initPinButtonARIAState=function(){var $;if(this.getPinnable()){$=this._getPinButtonJQueryRef();$.attr(D.ARIA.ARIA_CONTROLS,this.getId());}};
D.prototype._updateARIAState=function(e){var $=this.$();if(e){$.attr(D.ARIA.ARIA_EXPANDED,D.ARIA.STATE_TRUE);$.attr(D.ARIA.ARIA_LABEL,D.ARIA.LABEL_EXPANDED);}else{$.attr(D.ARIA.ARIA_EXPANDED,D.ARIA.STATE_FALSE);$.attr(D.ARIA.ARIA_LABEL,D.ARIA.LABEL_SNAPPED);}};
D.prototype._updateARIAPinButtonState=function(p){var P=this._getPinButton();if(p){P.setTooltip(D.ARIA.LABEL_UNPINNED);}else{P.setTooltip(D.ARIA.LABEL_PINNED);}};
D.prototype._getPinButton=function(){if(!this.getAggregation("_pinButton")){var p=new T({id:this.getId()+"-pinBtn",icon:"sap-icon://pushpin-off",tooltip:D.ARIA.LABEL_PINNED,type:B.Transparent,press:this._pinUnpinFireEvent.bind(this)});this.setAggregation("_pinButton",p,true);}return this.getAggregation("_pinButton");};
D.prototype._focusPinButton=function(){this._getPinButtonJQueryRef().focus();};
D.prototype._getPinButtonJQueryRef=function(){return this._getPinButton().$();};
return D;},false);
sap.ui.predefine('sap/f/DynamicPageHeaderRenderer',[],function(){"use strict";var D={};
D.render=function(r,d){var c=d.getContent(),h=c.length>0,p=sap.ui.Device.system.phone,H=d.getPinnable()&&h&&!p;r.write("<header");r.writeControlData(d);r.writeAccessibilityState({role:"region"});r.addClass("sapContrastPlus");r.addClass("sapFDynamicPageHeader");if(H){r.addClass("sapFDynamicPageHeaderPinnable");}if(h){r.addClass("sapFDynamicPageHeaderWithContent");}r.writeClasses();r.write(">");if(h){r.write("<div");r.addClass("sapFDynamicPageHeaderContent");r.writeClasses();r.write(">");c.forEach(r.renderControl);r.write("</div>");if(H){D._renderPinUnpinArea(d,r);}}r.write("</header>");};
D._renderPinUnpinArea=function(d,r){r.write("<div");r.addClass("sapFDynamicPageHeaderPinButtonArea");r.writeClasses();r.write(">");r.renderControl(d._getPinButton());r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/f/DynamicPageRenderer',["sap/ui/Device"],function(D){"use strict";var a={};
a.render=function(r,d){var o=d.getTitle(),b=d.getHeader(),c=d.getFooter(),e=d.getContent(),h=b?b.getContent():[],H=h.length>0,f=d.getHeaderExpanded(),s=d.getShowFooter(),p=d._preserveHeaderStateOnScroll();r.write("<article");r.writeControlData(d);r.addClass("sapFDynamicPage");if(d.getToggleHeaderOnTitleClick()){r.addClass("sapFDynamicPageTitleClickEnabled");}r.writeClasses();r.write(">");if(D.system.desktop){r.renderControl(d._getScrollBar().addStyleClass("sapFDynamicPageScrollBar"));}r.write("<header");r.writeAttributeEscaped("id",d.getId()+"-header");r.addClass("sapContrastPlus");r.addClass("sapFDynamicPageTitleWrapper");if(!f){r.addClass("sapFDynamicPageTitleSnapped");}if(!H){r.addClass("sapFDynamicPageTitleOnly");}r.writeClasses();r.write(">");r.renderControl(o);if(p){r.renderControl(b);}r.write("</header>");r.write("<div");r.writeAttributeEscaped("id",d.getId()+"-contentWrapper");r.addClass("sapFDynamicPageContentWrapper");r.writeClasses();r.write(">");if(!p){r.renderControl(b);}r.write("<div");r.writeAttributeEscaped("id",d.getId()+"-content");r.addClass("sapFDynamicPageContent");r.writeClasses();r.write(">");r.write("<div");r.writeAttributeEscaped("id",d.getId()+"-contentFitContainer");if(d.getFitContent()){r.addClass("sapFDynamicPageContentFitContainer");}if(c&&s){r.addClass("sapFDynamicPageContentFitContainerFooterVisible");}r.writeClasses();r.write(">");r.renderControl(e);a.renderFooterSpacer(r,d,c,s);r.write("</div>");r.write("</div>");r.write("</div>");a.renderFooter(r,d,c,s);r.write("</article>");};
a.renderFooter=function(r,d,o,s){if(o){r.write("<footer");r.writeAttributeEscaped("id",d.getId()+"-footerWrapper");r.addClass("sapContrast sapContrastPlus sapFDynamicPageFooter sapFFooter-CTX");if(!s){r.addClass("sapUiHidden");}r.writeClasses();r.write(">");o.addStyleClass("sapFDynamicPageActualFooterControl");r.renderControl(o);r.write("</footer>");}};
a.renderFooterSpacer=function(r,d,o,s){if(o){r.write("<div");r.writeAttributeEscaped("id",d.getId()+"-spacer");if(s){r.addClass("sapFDynamicPageContentWrapperSpacer");}r.writeClasses();r.write(">");r.write("</div>");}};
return a;},true);
sap.ui.predefine('sap/f/DynamicPageTitle',["jquery.sap.global","./library","sap/ui/core/Control","sap/m/OverflowToolbar"],function(q,l,C,O){"use strict";
var D=C.extend("sap.f.DynamicPageTitle",{metadata:{library:"sap.f",aggregations:{heading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},snappedContent:{type:"sap.ui.core.Control",multiple:true},expandedContent:{type:"sap.ui.core.Control",multiple:true},_overflowToolbar:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
function i(o){return typeof o==="function";}
D.prototype.init=function(){this._bShowSnappedContent=false;this._bShowExpandContent=true;this._fnActionSubstituteParentFunction=function(){return this;}.bind(this);};
D.prototype.onBeforeRendering=function(){this._getOverflowToolbar();};
D.prototype.onAfterRendering=function(){this._cacheDomElements();this._setShowSnapContent(this._getShowSnapContent());this._setShowExpandContent(this._getShowExpandContent());};
D.prototype.ontap=function(e){if(e.srcControl===this||this.getAggregation("_overflowToolbar")===e.srcControl){this.fireEvent("_titlePress");}};
D.prototype._cacheDomElements=function(){this.$snappedWrapper=this.$("snapped-wrapper");this.$expandWrapper=this.$("expand-wrapper");};
D.prototype._getOverflowToolbar=function(){if(!this.getAggregation("_overflowToolbar")){this.setAggregation("_overflowToolbar",new O({id:this.getId()+"-overflowToolbar"}).addStyleClass("sapFDynamicPageTitleOverflowToolbar"));}return this.getAggregation("_overflowToolbar");};
D.prototype._preProcessAction=function(a){if(i(a._fnOriginalGetParent)){return;}a._fnOriginalGetParent=a.getParent;a.getParent=this._fnActionSubstituteParentFunction;};
D.prototype._postProcessAction=function(a){if(!i(a._fnOriginalGetParent)){return;}a.getParent=a._fnOriginalGetParent;};
["addAction","insertAction","removeAction","indexOfAction","removeAllActions","destroyActions","getActions"].forEach(function(m){D.prototype[m]=function(c){var t=this._getOverflowToolbar(),T=m.replace(/Actions?/,"Content"),r;if(m==="addAction"||m==="insertAction"){r=t[T].apply(t,arguments);this._preProcessAction(c);return r;}else if(m==="removeAction"){this._postProcessAction(c);}else if(m==="removeAllActions"||m==="destroyActions"){this.getActions().forEach(this._postProcessAction,this);}return t[T].apply(t,arguments);};});
D.prototype._setShowSnapContent=function(v){this._bShowSnappedContent=v;this.$snappedWrapper.toggleClass("sapUiHidden",!v);this.$snappedWrapper.parent().toggleClass("sapFDynamicPageSnapContentVisible",v);};
D.prototype._getShowSnapContent=function(){return this._bShowSnappedContent;};
D.prototype._setShowExpandContent=function(v){this._bShowExpandContent=v;this.$expandWrapper.toggleClass("sapUiHidden",!v);this.$snappedWrapper.parent().toggleClass("sapFDynamicPageExpandContentVisible",v);};
D.prototype._getShowExpandContent=function(){return this._bShowExpandContent;};
return D;},false);
sap.ui.predefine('sap/f/DynamicPageTitleRenderer',[],function(){"use strict";var D={};
D.render=function(r,d){var a=d._getOverflowToolbar(),l=d.getHeading(),s=d.getSnappedContent(),e=d.getExpandedContent();r.write("<div");r.writeControlData(d);r.writeAccessibilityState({role:"heading",level:2});r.addClass("sapFDynamicPageTitle");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapFDynamicPageTitleLeft");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapFDynamicPageTitleLeftInner");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapFDynamicPageTitleLeftHeading");r.writeClasses();r.write(">");r.renderControl(l);r.write("</div>");if(s.length>0||e.length>0){r.write("<div");r.addClass("sapFDynamicPageTitleLeftSnappedExpandContent");r.writeClasses();r.write(">");D._renderSnappedContent(r,d,s);D._renderExpandContent(r,d,e);r.write("</div>");}r.write("</div>");r.write("</div>");r.write("<div");r.addClass("sapFDynamicPageTitleRight");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapFDynamicPageTitleRightActions");r.writeClasses();r.write(">");if(a.getContent().length>0){r.renderControl(a);}r.write("</div>");r.write("</div>");r.write("</div>");};
D._renderExpandContent=function(r,d,e){if(e.length>0){r.write("<div");r.writeAttributeEscaped("id",d.getId()+"-expand-wrapper");r.writeClasses();r.write(">");e.forEach(r.renderControl);r.write("</div>");}};
D._renderSnappedContent=function(r,d,s){if(s.length>0){r.write("<div");r.writeAttributeEscaped("id",d.getId()+"-snapped-wrapper");if(!d._getShowSnapContent()){r.addClass("sapUiHidden");}r.addClass("sapFDynamicPageTitleSnapped");r.writeClasses();r.write(">");s.forEach(r.renderControl);r.write("</div>");}};
return D;},true);
sap.ui.predefine('sap/f/FlexibleColumnLayout',["jquery.sap.global","./library","./LayoutType","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/m/Button","sap/m/NavContainer"],function(q,l,L,D,R,C,I,B,N){"use strict";
var F=C.extend("sap.f.FlexibleColumnLayout",{metadata:{properties:{layout:{type:"sap.f.LayoutType",defaultValue:sap.f.LayoutType.OneColumn},defaultTransitionNameBeginColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameMidColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameEndColumn:{type:"string",group:"Appearance",defaultValue:"slide"}},aggregations:{beginColumnPages:{type:"sap.ui.core.Control",multiple:true},midColumnPages:{type:"sap.ui.core.Control",multiple:true},endColumnPages:{type:"sap.ui.core.Control",multiple:true},_beginColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_midColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_endColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_beginColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_endColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{initialBeginColumnPage:{type:"sap.ui.core.Control",multiple:false},initialMidColumnPage:{type:"sap.ui.core.Control",multiple:false},initialEndColumnPage:{type:"sap.ui.core.Control",multiple:false}},events:{stateChange:{parameters:{layout:{type:"sap.f.LayoutType"},maxColumnsCount:{type:"int"},isNavigationArrow:{type:"boolean"},isResize:{type:"boolean"}}},beginColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterBeginColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},midColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterMidColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},endColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterEndColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}}}});
F.prototype.init=function(){this._initNavContainers();this._initButtons();this._oLayoutHistory=new a();};
F.prototype._createNavContainer=function(c){var s=c.charAt(0).toUpperCase()+c.slice(1);return new N(this.getId()+"-"+c+"ColumnNav",{navigate:function(e){this._handleNavigationEvent(e,false,c);}.bind(this),afterNavigate:function(e){this._handleNavigationEvent(e,true,c);}.bind(this),defaultTransitionName:this["getDefaultTransitionName"+s+"Column"]()});};
F.prototype._handleNavigationEvent=function(e,A,c){var E,b;if(A){E="after"+(c.charAt(0).toUpperCase()+c.slice(1))+"ColumnNavigate";}else{E=c+"ColumnNavigate";}b=this.fireEvent(E,e.mParameters,true);if(!b){e.preventDefault();}};
F.prototype._getBeginColumn=function(){return this.getAggregation("_beginColumnNav");};
F.prototype._getMidColumn=function(){return this.getAggregation("_midColumnNav");};
F.prototype._getEndColumn=function(){return this.getAggregation("_endColumnNav");};
F.prototype._flushColumnContent=function(c){var o=this.getAggregation("_"+c+"ColumnNav"),r=sap.ui.getCore().createRenderManager();r.renderControl(o);r.flush(this._$columns[c].find(".sapFFCLColumnContent")[0],undefined,true);r.destroy();};
F.prototype.setLayout=function(n){n=this.validateProperty("layout",n);var c=this.getLayout();if(c===n){return this;}var r=this.setProperty("layout",n,true);this._oLayoutHistory.addEntry(n);this._resizeColumns();this._hideShowArrows();return r;};
F.prototype.onBeforeRendering=function(){this._deregisterResizeHandler();};
F.prototype.onAfterRendering=function(){this._registerResizeHandler();this._cacheDOMElements();this._hideShowArrows();this._resizeColumns();this._flushColumnContent("begin");this._flushColumnContent("mid");this._flushColumnContent("end");this._fireStateChange(false,false);};
F.prototype._getControlWidth=function(){return this.$().width();};
F.prototype.exit=function(){this._deregisterResizeHandler();};
F.prototype._registerResizeHandler=function(){this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};
F.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};
F.prototype._initNavContainers=function(){this.setAggregation("_beginColumnNav",this._createNavContainer("begin"),true);this.setAggregation("_midColumnNav",this._createNavContainer("mid"),true);this.setAggregation("_endColumnNav",this._createNavContainer("end"),true);};
F.prototype._initButtons=function(){var b=new B(this.getId()+"-beginBack",{icon:"sap-icon://slim-arrow-left",tooltip:F._getResourceBundle().getText("FCL_BEGIN_COLUMN_BACK_ARROW"),press:this._onArrowClick.bind(this,"left")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_beginColumnBackArrow",b,true);var m=new B(this.getId()+"-midForward",{icon:"sap-icon://slim-arrow-right",tooltip:F._getResourceBundle().getText("FCL_MID_COLUMN_FORWARD_ARROW"),press:this._onArrowClick.bind(this,"right")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_midColumnForwardArrow",m,true);var M=new B(this.getId()+"-midBack",{icon:"sap-icon://slim-arrow-left",tooltip:F._getResourceBundle().getText("FCL_MID_COLUMN_BACK_ARROW"),press:this._onArrowClick.bind(this,"left")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_midColumnBackArrow",M,true);var e=new B(this.getId()+"-endForward",{icon:"sap-icon://slim-arrow-right",tooltip:F._getResourceBundle().getText("FCL_END_COLUMN_FORWARD_ARROW"),press:this._onArrowClick.bind(this,"right")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_endColumnForwardArrow",e,true);};
F.prototype._cacheDOMElements=function(){this._cacheColumns();if(!D.system.phone){this._cacheArrows();}};
F.prototype._cacheColumns=function(){this._$columns={begin:this.$("beginColumn"),mid:this.$("midColumn"),end:this.$("endColumn")};};
F.prototype._cacheArrows=function(){this._$columnButtons={beginBack:this.$("beginBack"),midForward:this.$("midForward"),midBack:this.$("midBack"),endForward:this.$("endForward")};};
F.prototype._getVisibleColumnsCount=function(){return["begin","mid","end"].filter(function(c){return this._getColumnSize(c)>0;},this).length;};
F.prototype._resizeColumns=function(){var p,n,s,t,A,b=false,c=["begin","mid","end"],r=sap.ui.getCore().getConfiguration().getRTL(),d,v;if(!this.isActive()){return;}v=this._getVisibleColumnsCount();if(v===0){return;}t=(v-1)*F.COLUMN_MARGIN;A=this._getControlWidth()-t;c.forEach(function(e){p=this._getColumnSize(e);this._$columns[e].toggleClass("sapFFCLColumnMargin",b&&p>0);this._$columns[e].toggleClass("sapFFCLColumnActive",p>0);this._$columns[e].removeClass("sapFFCLColumnOnlyActive");this._$columns[e].removeClass("sapFFCLColumnLastActive");this._$columns[e].removeClass("sapFFCLColumnFirstActive");n=Math.round(A*(p/100));if([100,0].indexOf(p)!==-1){s=p+"%";}else{s=n+"px";}this._$columns[e].width(s);if(!D.system.phone){this._updateColumnContextualSettings(e,n);this._updateColumnCSSClasses(e,n);}if(p>0){b=true;}},this);d=c.filter(function(e){return this._getColumnSize(e)>0;},this);if(r){c.reverse();}if(d.length===1){this._$columns[d[0]].addClass("sapFFCLColumnOnlyActive");}if(d.length>1){this._$columns[d[0]].addClass("sapFFCLColumnFirstActive");this._$columns[d[d.length-1]].addClass("sapFFCLColumnLastActive");}};
F.prototype._propagateContextualSettings=function(){};
F.prototype._updateColumnContextualSettings=function(c,w){var o,b;o=this.getAggregation("_"+c+"ColumnNav");if(!o){return;}b=o._getContextualSettings();if(!b||b.contextualWidth!==w){o._applyContextualSettings({contextualWidth:w});}};
F.prototype._updateColumnCSSClasses=function(c,w){var n="";this._$columns[c].removeClass("sapUiContainer-Narrow sapUiContainer-Medium sapUiContainer-Wide sapUiContainer-ExtraWide");if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0]){n="Narrow";}else if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1]){n="Medium";}else if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2]){n="Wide";}else{n="ExtraWide";}this._$columns[c].addClass("sapUiContainer-"+n);};
F.prototype._getColumnSize=function(c){var s=this.getLayout(),b=this._getColumnWidthDistributionForLayout(s),S=b.split("/"),m={begin:0,mid:1,end:2},d=S[m[c]];return parseInt(d,10);};
F.prototype.getMaxColumnsCount=function(){return this._getMaxColumnsCountForWidth(this._getControlWidth());};
F.prototype._getMaxColumnsCountForWidth=function(w){if(w>=F.DESKTOP_BREAKPOINT){return 3;}if(w>=F.TABLET_BREAKPOINT&&w<F.DESKTOP_BREAKPOINT){return 2;}if(w>0){return 1;}return 0;};
F.prototype._onResize=function(e){var o=e.oldSize.width,n=e.size.width,O,m;if(n===0){return;}O=this._getMaxColumnsCountForWidth(o);m=this._getMaxColumnsCountForWidth(n);this._resizeColumns();if(m!==O){this._hideShowArrows();this._fireStateChange(false,true);}};
F.prototype._onArrowClick=function(s){var b=this.getLayout(),m={TwoColumnsBeginExpanded:{"left":L.TwoColumnsMidExpanded},TwoColumnsMidExpanded:{"right":L.TwoColumnsBeginExpanded},ThreeColumnsMidExpanded:{"left":L.ThreeColumnsEndExpanded,"right":L.ThreeColumnsMidExpandedEndHidden},ThreeColumnsEndExpanded:{"right":L.ThreeColumnsMidExpanded},ThreeColumnsMidExpandedEndHidden:{"left":L.ThreeColumnsMidExpanded,"right":L.ThreeColumnsBeginExpandedEndHidden},ThreeColumnsBeginExpandedEndHidden:{"left":L.ThreeColumnsMidExpandedEndHidden}};b=typeof m[b]!=="undefined"&&typeof m[b][s]!=="undefined"?m[b][s]:L.OneColumn;this.setLayout(b);this._fireStateChange(true,false);};
F.prototype._hideShowArrows=function(){var s=this.getLayout(),m={},n=[],M;if(!this.isActive()||D.system.phone){return;}M=this.getMaxColumnsCount();if(M>1){m[L.TwoColumnsBeginExpanded]=["beginBack"];m[L.TwoColumnsMidExpanded]=["midForward"];m[L.ThreeColumnsMidExpanded]=["midForward","midBack"];m[L.ThreeColumnsEndExpanded]=["endForward"];m[L.ThreeColumnsMidExpandedEndHidden]=["midForward","midBack"];m[L.ThreeColumnsBeginExpandedEndHidden]=["beginBack"];if(typeof m[s]==="object"){n=m[s];}}this._toggleButton("beginBack",n.indexOf("beginBack")!==-1);this._toggleButton("midForward",n.indexOf("midForward")!==-1);this._toggleButton("midBack",n.indexOf("midBack")!==-1);this._toggleButton("endForward",n.indexOf("endForward")!==-1);};
F.prototype._toggleButton=function(b,s){this._$columnButtons[b].toggle(s);};
F.prototype._fireStateChange=function(i,b){if(this._getControlWidth()===0){return;}this.fireStateChange({isNavigationArrow:i,isResize:b,layout:this.getLayout(),maxColumnsCount:this.getMaxColumnsCount()});};
F.prototype.getBeginColumnPages=function(){return this._getBeginColumn().getPages();};
F.prototype.addBeginColumnPage=function(p){this._getBeginColumn().addPage(p);return this;};
F.prototype.insertBeginColumnPage=function(p,i){this._getBeginColumn().insertPage(p,i);return this;};
F.prototype.removeBeginColumnPage=function(p){this._getBeginColumn().removePage(p);return this;};
F.prototype.removeAllBeginColumnPages=function(){return this._getBeginColumn().removeAllPages();};
F.prototype.getMidColumnPages=function(){return this._getMidColumn().getPages();};
F.prototype.addMidColumnPage=function(p){this._getMidColumn().addPage(p);return this;};
F.prototype.insertMidColumnPage=function(p,i){this._getMidColumn().insertPage(p,i);return this;};
F.prototype.removeMidColumnPage=function(p){this._getMidColumn().removePage(p);return this;};
F.prototype.removeAllMidColumnPages=function(){return this._getMidColumn().removeAllPages();};
F.prototype.getEndColumnPages=function(){return this._getEndColumn().getPages();};
F.prototype.addEndColumnPage=function(p){this._getEndColumn().addPage(p);return this;};
F.prototype.insertEndColumnPage=function(p,i){this._getEndColumn().insertPage(p,i);return this;};
F.prototype.removeEndColumnPage=function(p){this._getEndColumn().removePage(p);return this;};
F.prototype.removeAllEndColumnPages=function(){return this._getEndColumn().removeAllPages();};
F.prototype.setInitialBeginColumnPage=function(p){this._getBeginColumn().setInitialPage(p);this.setAssociation('initialBeginColumnPage',p,true);return this;};
F.prototype.setInitialMidColumnPage=function(p){this._getMidColumn().setInitialPage(p);this.setAssociation('initialMidColumnPage',p,true);return this;};
F.prototype.setInitialEndColumnPage=function(p){this._getEndColumn().setInitialPage(p);this.setAssociation('initialEndColumnPage',p,true);return this;};
F.prototype.to=function(p,t,d,T){if(this._getBeginColumn().getPage(p)){this._getBeginColumn().to(p,t,d,T);}else if(this._getMidColumn().getPage(p)){this._getMidColumn().to(p,t,d,T);}else{this._getEndColumn().to(p,t,d,T);}};
F.prototype.backToPage=function(p,b,t){if(this._getBeginColumn().getPage(p)){this._getBeginColumn().backToPage(p,b,t);}else if(this._getMidColumn().getPage(p)){this._getMidColumn().backToPage(p,b,t);}else{this._getEndColumn().backToPage(p,b,t);}};
F.prototype._safeBackToPage=function(p,t,b,T){if(this._getBeginColumn().getPage(p)){this._getBeginColumn()._safeBackToPage(p,t,b,T);}else if(this._getMidColumn().getPage(p)){this._getMidColumn()._safeBackToPage(p,t,b,T);}else{this._getEndColumn()._safeBackToPage(p,t,b,T);}};
F.prototype.toBeginColumnPage=function(p,t,d,T){this._getBeginColumn().to(p,t,d,T);};
F.prototype.toMidColumnPage=function(p,t,d,T){this._getMidColumn().to(p,t,d,T);};
F.prototype.toEndColumnPage=function(p,t,d,T){this._getEndColumn().to(p,t,d,T);};
F.prototype.backBeginColumn=function(b,t){return this._getBeginColumn().back(b,t);};
F.prototype.backMidColumn=function(b,t){return this._getMidColumn().back(b,t);};
F.prototype.backEndColumn=function(b,t){return this._getEndColumn().back(b,t);};
F.prototype.backBeginColumnToPage=function(p,b,t){return this._getBeginColumn().backToPage(p,b,t);};
F.prototype.backMidColumnToPage=function(p,b,t){return this._getMidColumn().backToPage(p,b,t);};
F.prototype.backEndColumnToPage=function(p,b,t){return this._getEndColumn().backToPage(p,b,t);};
F.prototype.backToTopBeginColumn=function(b,t){this._getBeginColumn().backToTop(b,t);};
F.prototype.backToTopMidColumn=function(b,t){this._getMidColumn().backToTop(b,t);};
F.prototype.backToTopEndColumn=function(b,t){this._getEndColumn().backToTop(b,t);};
F.prototype.getCurrentBeginColumnPage=function(){return this._getBeginColumn().getCurrentPage();};
F.prototype.getCurrentMidColumnPage=function(){return this._getMidColumn().getCurrentPage();};
F.prototype.getCurrentEndColumnPage=function(){return this._getEndColumn().getCurrentPage();};
F.prototype.setDefaultTransitionNameBeginColumn=function(t){this.setProperty("defaultTransitionNameBeginColumn",t,true);this._getBeginColumn().setDefaultTransitionName(t);return this;};
F.prototype.setDefaultTransitionNameMidColumn=function(t){this.setProperty("defaultTransitionNameMidColumn",t,true);this._getMidColumn().setDefaultTransitionName(t);return this;};
F.prototype.setDefaultTransitionNameEndColumn=function(t){this.setProperty("defaultTransitionNameEndColumn",t,true);this._getEndColumn().setDefaultTransitionName(t);return this;};
F.prototype._getLayoutHistory=function(){return this._oLayoutHistory;};
F.prototype._getColumnWidthDistributionForLayout=function(s,A){var m=this.getMaxColumnsCount(),M={},r;if(m===0){r="0/0/0";}else{M[L.OneColumn]="100/0/0";M[L.MidColumnFullScreen]="0/100/0";M[L.EndColumnFullScreen]="0/0/100";if(m===1){M[L.TwoColumnsBeginExpanded]="0/100/0";M[L.TwoColumnsMidExpanded]="0/100/0";M[L.ThreeColumnsMidExpanded]="0/0/100";M[L.ThreeColumnsEndExpanded]="0/0/100";M[L.ThreeColumnsMidExpandedEndHidden]="0/0/100";M[L.ThreeColumnsBeginExpandedEndHidden]="0/0/100";}else{M[L.TwoColumnsBeginExpanded]="67/33/0";M[L.TwoColumnsMidExpanded]="33/67/0";M[L.ThreeColumnsMidExpanded]=m===2?"0/67/33":"25/50/25";M[L.ThreeColumnsEndExpanded]=m===2?"0/33/67":"25/25/50";M[L.ThreeColumnsMidExpandedEndHidden]="33/67/0";M[L.ThreeColumnsBeginExpandedEndHidden]="67/33/0";}r=M[s];}if(A){r=r.split("/").map(function(c){return parseInt(c,10);});}return r;};
F.COLUMN_MARGIN=8;F.DESKTOP_BREAKPOINT=1280;F.TABLET_BREAKPOINT=960;
F._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};
F._getAriaLabels=function(){if(!F._sAriaFlexibleColumnLayoutLabels){F._sAriaFlexibleColumnLayoutLabels={beginColumnLabel:F._getARIAInvisibleTextId("FCL_BEGIN_COLUMN_REGION_TEXT"),midColumnLabel:F._getARIAInvisibleTextId("FCL_MID_COLUMN_REGION_TEXT"),endColumnLabel:F._getARIAInvisibleTextId("FCL_END_COLUMN_REGION_TEXT")};}return F._sAriaFlexibleColumnLayoutLabels;};
F._getARIAInvisibleTextId=function(r){return new I({text:F._getResourceBundle().getText(r)}).toStatic().getId();};
function a(){this._aLayoutHistory=[];}
a.prototype.addEntry=function(s){if(typeof s!=="undefined"){this._aLayoutHistory.push(s);}};
a.prototype.getClosestEntryThatMatches=function(b){var i;for(i=this._aLayoutHistory.length-1;i>=0;i--){if(b.indexOf(this._aLayoutHistory[i])!==-1){return this._aLayoutHistory[i];}}};
return F;},true);
sap.ui.predefine('sap/f/FlexibleColumnLayoutRenderer',["sap/f/FlexibleColumnLayout","sap/ui/Device"],function(F,D){"use strict";var a={};
a.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapFFCL");r.writeClasses();r.write(">");a.renderBeginColumn(r,c);a.renderMidColumn(r,c);a.renderEndColumn(r,c);r.write("</div>");};
a.renderBeginColumn=function(r,c){var b=c.getAggregation("_beginColumnBackArrow");r.write("<div");r.writeAttribute("id",c.getId()+"-beginColumn");r.writeAccessibilityState(c,{role:"region",labelledBy:F._getAriaLabels().beginColumnLabel});r.addClass("sapFFCLColumn").addClass("sapFFCLColumnBegin").addClass("sapFFCLColumnActive");r.writeClasses();r.writeStyles();r.write(">");a.renderColumnContentWrapper(r);a.renderArrow(r,b);r.write("</div>");};
a.renderMidColumn=function(r,c){var m=c.getAggregation("_midColumnForwardArrow"),M=c.getAggregation("_midColumnBackArrow");r.write("<div");r.writeAttribute("id",c.getId()+"-midColumn");r.writeAccessibilityState(c,{role:"region",labelledBy:F._getAriaLabels().midColumnLabel});r.addClass("sapFFCLColumn").addClass("sapFFCLColumnMid");r.writeClasses();r.writeStyles();r.write(">");a.renderArrow(r,m);a.renderColumnContentWrapper(r);a.renderArrow(r,M);r.write("</div>");};
a.renderEndColumn=function(r,c){var e=c.getAggregation("_endColumnForwardArrow");r.write("<div");r.writeAttribute("id",c.getId()+"-endColumn");r.writeAccessibilityState(c,{role:"region",labelledBy:F._getAriaLabels().endColumnLabel});r.addClass("sapFFCLColumn").addClass("sapFFCLColumnEnd");r.writeClasses();r.writeStyles();r.write(">");a.renderArrow(r,e);a.renderColumnContentWrapper(r);r.write("</div>");};
a.renderArrow=function(r,A){if(!D.system.phone){A.addStyleClass("sapContrastPlus");r.renderControl(A);}};
a.renderColumnContentWrapper=function(r){r.write("<div");r.addClass("sapFFCLColumnContent");r.writeClasses();r.write("></div>");};
return a;},true);
sap.ui.predefine('sap/f/FlexibleColumnLayoutSemanticHelper',["jquery.sap.global","./library","./LayoutType","./FlexibleColumnLayout"],function(q,l,L,F){"use strict";var a=function(f,s){this._oFCL=f;this._mode="Normal";this._defaultLayoutType=L.OneColumn;this._defaultTwoColumnLayoutType=L.TwoColumnsBeginExpanded;this._defaultThreeColumnLayoutType=[L.ThreeColumnsMidExpanded,L.ThreeColumnsEndExpanded].indexOf(s.defaultThreeColumnLayoutType)!==-1?s.defaultThreeColumnLayoutType:L.ThreeColumnsMidExpanded;};a._oInstances={};
a.getInstanceFor=function(f,s){var i=f.getId();if(typeof a._oInstances[i]==="undefined"){a._oInstances[i]=new a(f,s);}return a._oInstances[i];};
a.prototype.getCurrentUIState=function(){var c=this._oFCL.getLayout();return this._getUIStateForLayout(c);};
a.prototype.getNextUIState=function(n){var c=this._oFCL.getLayout(),N;if(n===0){N=L.OneColumn;}if(n===1){if([L.TwoColumnsBeginExpanded,L.TwoColumnsMidExpanded].indexOf(c)!==-1){N=c;}else if([L.MidColumnFullScreen,L.EndColumnFullScreen].indexOf(c)!==-1){N=L.MidColumnFullScreen;}else{N=this._defaultTwoColumnLayoutType;}}if(n===2){if(this._mode==="MasterDetail"){N=L.EndColumnFullScreen;}else{if([L.ThreeColumnsMidExpandedEndHidden,L.ThreeColumnsBeginExpandedEndHidden].indexOf(c)!==-1){N=this._defaultThreeColumnLayoutType;}else if([L.ThreeColumnsMidExpanded,L.ThreeColumnsEndExpanded].indexOf(c)!==-1){N=c;}else if([L.MidColumnFullScreen,L.EndColumnFullScreen].indexOf(c)!==-1){N=L.EndColumnFullScreen;}else{N=this._defaultThreeColumnLayoutType;}}}if(n>2){N=L.EndColumnFullScreen;}return this._getUIStateForLayout(N);};
a.prototype._getUIStateForLayout=function(s){var S=this._oFCL._getColumnWidthDistributionForLayout(s,true),c=S.join("/"),m=this._oFCL.getMaxColumnsCount();return{layout:s,maxColumnsCount:m,columnsSizes:this._getColumnsSizes(S),columnsVisibility:this._getColumnsVisibility(S),isFullScreen:this._getIsFullScreen(S),isLogicallyFullScreen:this._getIsLogicallyFullScreen(s),actionButtonsInfo:this._getActionButtonsInfo(c,m)};};
a.prototype._getColumnsSizes=function(s){return{beginColumn:s[0],midColumn:s[1],endColumn:s[2]};};
a.prototype._getColumnsVisibility=function(s){return{beginColumn:s[0]!==0,midColumn:s[1]!==0,endColumn:s[2]!==0};};
a.prototype._getIsFullScreen=function(s){return s.indexOf(100)!==-1;};
a.prototype._getIsLogicallyFullScreen=function(s){return[L.OneColumn,L.MidColumnFullScreen,L.EndColumnFullScreen].indexOf(s)!==-1;};
a.prototype._getActionButtonsInfo=function(c,m){var M={fullScreen:null,exitFullScreen:null,closeColumn:null},e={fullScreen:null,exitFullScreen:null,closeColumn:null},E,s;if(m===1){M.closeColumn=this._defaultLayoutType;e.closeColumn=this._defaultTwoColumnLayoutType;}else{if(c==="67/33/0"||c==="33/67/0"){M.fullScreen=L.MidColumnFullScreen;M.closeColumn=this._defaultLayoutType;}if(c==="25/50/25"||c==="25/25/50"||c==="0/67/33"){e.fullScreen=L.EndColumnFullScreen;e.closeColumn=this._defaultTwoColumnLayoutType;}if(c==="0/100/0"){E=[L.TwoColumnsBeginExpanded,L.TwoColumnsMidExpanded,L.ThreeColumnsBeginExpandedEndHidden,L.ThreeColumnsMidExpandedEndHidden];s=this._oFCL._getLayoutHistory().getClosestEntryThatMatches(E)||this._defaultTwoColumnLayoutType;M.exitFullScreen=s;M.closeColumn=this._defaultLayoutType;}if(c==="0/0/100"){if(this._mode!=="MasterDetail"){E=[L.ThreeColumnsMidExpanded,L.ThreeColumnsEndExpanded];s=this._oFCL._getLayoutHistory().getClosestEntryThatMatches(E)||this._defaultThreeColumnLayoutType;e.exitFullScreen=s;e.closeColumn=this._defaultTwoColumnLayoutType;}}}return{midColumn:M,endColumn:e};};
a.prototype.getDefaultLayouts=function(){return{defaultLayoutType:this._defaultLayoutType,defaultTwoColumnLayoutType:this._defaultTwoColumnLayoutType,defaultThreeColumnLayoutType:this._defaultThreeColumnLayoutType};};
return a;},true);
sap.ui.predefine('sap/f/library',["jquery.sap.global","sap/ui/core/library","sap/m/library"],function(){"use strict";sap.ui.getCore().initLibrary({name:"sap.f",version:"1.46.10",dependencies:["sap.ui.core","sap.m"],types:["sap.f.LayoutType"],controls:["sap.f.Avatar","sap.f.DynamicPage","sap.f.DynamicPageHeader","sap.f.DynamicPageTitle","sap.f.FlexibleColumnLayout","sap.f.semantic.SemanticPage"],elements:["sap.f.semantic.AddAction","sap.f.semantic.CloseAction","sap.f.semantic.CopyAction","sap.f.semantic.DeleteAction","sap.f.semantic.DiscussInJamAction","sap.f.semantic.ExitFullScreenAction","sap.f.semantic.FavoriteAction","sap.f.semantic.FlagAction","sap.f.semantic.FooterMainAction","sap.f.semantic.FullScreenAction","sap.f.semantic.MessagesIndicator","sap.f.semantic.NegativeAction","sap.f.semantic.PositiveAction","sap.f.semantic.PrintAction","sap.f.semantic.SemanticButton","sap.f.semantic.SemanticControl","sap.f.semantic.SemanticToggleButton","sap.f.semantic.SendEmailAction","sap.f.semantic.SendMessageAction","sap.f.semantic.ShareInJamAction","sap.f.semantic.TitleMainAction"]});sap.f.LayoutType={OneColumn:"OneColumn",TwoColumnsBeginExpanded:"TwoColumnsBeginExpanded",TwoColumnsMidExpanded:"TwoColumnsMidExpanded",MidColumnFullScreen:"MidColumnFullScreen",ThreeColumnsMidExpanded:"ThreeColumnsMidExpanded",ThreeColumnsEndExpanded:"ThreeColumnsEndExpanded",ThreeColumnsMidExpandedEndHidden:"ThreeColumnsMidExpandedEndHidden",ThreeColumnsBeginExpandedEndHidden:"ThreeColumnsBeginExpandedEndHidden",EndColumnFullScreen:"EndColumnFullScreen"};sap.ui.lazyRequire("sap.f.routing.Router");sap.ui.lazyRequire("sap.f.routing.Target");sap.ui.lazyRequire("sap.f.routing.TargetHandler");sap.ui.lazyRequire("sap.f.routing.Targets");sap.f.AvatarShape={Circle:"Circle",Square:"Square"};sap.f.AvatarSize={XS:"XS",S:"S",M:"M",L:"L",XL:"XL",Custom:"Custom"};sap.f.AvatarType={Icon:"Icon",Image:"Image",Initials:"Initials"};sap.f.AvatarImageFitType={Cover:"Cover",Contain:"Contain"};return sap.f;});
sap.ui.predefine('sap/f/routing/Router',['sap/ui/core/routing/Router','./TargetHandler','./Targets'],function(R,T,a){"use strict";
var M=R.extend("sap.f.routing.Router",{
constructor:function(){this._oTargetHandler=new T();R.prototype.constructor.apply(this,arguments);},
destroy:function(){R.prototype.destroy.apply(this,arguments);this._oTargetHandler.destroy();this._oTargetHandler=null;},
getTargetHandler:function(){return this._oTargetHandler;},
_createTargets:function(c,t){return new a({views:this._oViews,config:c,targets:t,targetHandler:this._oTargetHandler});},
fireRouteMatched:function(A){var r=this.getRoute(A.name),t;if(r._oTarget){t=r._oTarget._oOptions;this._oTargetHandler.addNavigation({navigationIdentifier:A.name,transition:t.transition,transitionParameters:t.transitionParameters,eventData:A.arguments,targetControl:A.targetControl,view:A.view,layout:r._oConfig.layout});}return R.prototype.fireRouteMatched.apply(this,arguments);},
fireRoutePatternMatched:function(A){var r=A.name,v;if(this._oTargets&&this._oTargets._oLastDisplayedTarget){v=this._oTargets._getViewLevel(this._oTargets._oLastDisplayedTarget);}this._oTargetHandler.navigate({navigationIdentifier:r,viewLevel:v,askHistory:true});return R.prototype.fireRoutePatternMatched.apply(this,arguments);}
});
return M;},true);
sap.ui.predefine('sap/f/routing/Target',['sap/ui/core/routing/Target','sap/f/FlexibleColumnLayout','./async/Target'],function(T,F,a){"use strict";
var M=T.extend("sap.f.routing.Target",{
constructor:function(o,v,p,t){this._oTargetHandler=t;T.prototype.constructor.apply(this,arguments);var b=a;this._super={};for(var f in b){this._super[f]=this[f];this[f]=b[f];}},
_beforePlacingViewIntoContainer:function(A){var c=A.container;var r=A.data&&A.data.routeConfig;if(c instanceof F&&r&&r.layout){c.setLayout(r.layout);}T.prototype._beforePlacingViewIntoContainer.apply(this,arguments);}
});
return M;},true);
sap.ui.predefine('sap/f/routing/TargetHandler',['jquery.sap.global','sap/m/InstanceManager','sap/ui/base/Object','sap/ui/core/routing/History'],function($,I,B,H){"use strict";
var T=B.extend("sap.f.routing.TargetHandler",{constructor:function(c){this._aQueue=[];this._oNavigationOrderPromise=Promise.resolve();if(c===undefined){this._bCloseDialogs=true;}else{this._bCloseDialogs=!!c;}}});
T.prototype.setCloseDialogs=function(c){this._bCloseDialogs=!!c;return this;};
T.prototype.getCloseDialogs=function(){return this._bCloseDialogs;};
T.prototype.addNavigation=function(p){this._aQueue.push(p);};
T.prototype.navigate=function(d){var r=this._createResultingNavigations(d.navigationIdentifier),c=false,b=this._getDirection(d),n;while(r.length){n=this._applyNavigationResult(r.shift().oParams,b);c=c||n;}if(c){this._closeDialogs();}};
T.prototype._chainNavigation=function(n){this._oNavigationOrderPromise=this._oNavigationOrderPromise.then(n);return this._oNavigationOrderPromise;};
T.prototype._getDirection=function(d){var t=d.viewLevel,h=H.getInstance(),b=false;if(d.direction==="Backwards"){b=true;}else if(isNaN(t)||isNaN(this._iCurrentViewLevel)||t===this._iCurrentViewLevel){if(d.askHistory){b=h.getDirection()==="Backwards";}}else{b=t<this._iCurrentViewLevel;}this._iCurrentViewLevel=t;return b;};
T.prototype._createResultingNavigations=function(n){var i,c,C,o,r=[],R;while(this._aQueue.length){c=this._aQueue.shift();C=c.targetControl;o={oContainer:C,oParams:c};for(i=0;i<r.length;i++){R=r[i];if(R.oContainer!==C){continue;}}r.push(o);}return r;};
T.prototype._applyNavigationResult=function(p,b){var t=p.targetControl,a=p.eventData,s=p.transition||"",o=p.transitionParameters,v=p.view.getId();$.sap.log.info("navigation to view with id: "+v+" the targetControl is "+t.getId()+" backwards is "+b);if(b){t._safeBackToPage(v,s,a,o);}else{t.to(v,s,a,o);}return true;};
T.prototype._closeDialogs=function(){if(!this._bCloseDialogs){return;}if(I.hasOpenPopover()){I.closeAllPopovers();}if(I.hasOpenDialog()){I.closeAllDialogs();}if(I.hasOpenLightBox()){I.closeAllLightBoxes();}};
return T;},true);
sap.ui.predefine('sap/f/routing/Targets',['sap/ui/core/routing/Targets','./TargetHandler','./Target','./async/Targets'],function(T,a,b,c){"use strict";
var M=T.extend("sap.f.routing.Targets",{
constructor:function(o){o.config._async=true;if(o.targetHandler){this._oTargetHandler=o.targetHandler;}else{this._oTargetHandler=new a();this._bHasOwnTargetHandler=true;}T.prototype.constructor.apply(this,arguments);var d=c;this._super={};for(var f in d){this._super[f]=this[f];this[f]=d[f];}},
destroy:function(){T.prototype.destroy.apply(this,arguments);if(this._bHasOwnTargetHandler){this._oTargetHandler.destroy();}this._oTargetHandler=null;},
getTargetHandler:function(){return this._oTargetHandler;},
_constructTarget:function(o,p){return new b(o,this._oViews,p,this._oTargetHandler);},
_getViewLevel:function(t){var v;do{v=t._oOptions.viewLevel;if(v!==undefined){return v;}t=t._oParent;}while(t);return v;}
});
return M;},true);
sap.ui.predefine('sap/f/routing/async/Target',[],function(){"use strict";return{_place:function(d){var p=this._super._place.apply(this,arguments),r=d&&d.routeConfig||{},t=this;return this._oTargetHandler._chainNavigation(function(){return p.then(function(v){t._oTargetHandler.addNavigation({navigationIdentifier:t._oOptions.name,transition:t._oOptions.transition,transitionParameters:t._oOptions.transitionParameters,eventData:d,targetControl:v.control,view:v.view,layout:r.layout});return v;});});}};},true);
sap.ui.predefine('sap/f/routing/async/Targets',[],function(){"use strict";return{display:function(){var v,n;this._oLastDisplayedTarget=null;var p=this._super.display.apply(this,arguments);return p.then(function(V){if(this._oLastDisplayedTarget){v=this._getViewLevel(this._oLastDisplayedTarget);n=this._oLastDisplayedTarget._oOptions.name;}this._oTargetHandler.navigate({viewLevel:v,navigationIdentifier:n});return V;}.bind(this));},_displaySingleTarget:function(n){var t=this.getTarget(n);return this._super._displaySingleTarget.apply(this,arguments).then(function(v){if(t){this._oLastDisplayedTarget=t;}return v;}.bind(this));}};},true);
sap.ui.predefine('sap/f/semantic/AddAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var A=S.extend("sap.f.semantic.AddAction",{metadata:{library:"sap.f"}});
return A;},true);
sap.ui.predefine('sap/f/semantic/CloseAction',['./SemanticButton'],function(S){"use strict";
var C=S.extend("sap.f.semantic.CloseAction",{metadata:{library:"sap.f"}});
return C;},true);
sap.ui.predefine('sap/f/semantic/CopyAction',['./SemanticButton'],function(S){"use strict";
var C=S.extend("sap.f.semantic.CopyAction",{metadata:{library:"sap.f"}});
return C;},true);
sap.ui.predefine('sap/f/semantic/DeleteAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var D=S.extend("sap.f.semantic.DeleteAction",{metadata:{library:"sap.f"}});
return D;},true);
sap.ui.predefine('sap/f/semantic/DiscussInJamAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var D=S.extend("sap.f.semantic.DiscussInJamAction",{metadata:{library:"sap.f"}});
return D;},true);
sap.ui.predefine('sap/f/semantic/ExitFullScreenAction',['./SemanticButton'],function(S){"use strict";
var E=S.extend("sap.f.semantic.ExitFullScreenAction",{metadata:{library:"sap.f"}});
return E;},true);
sap.ui.predefine('sap/f/semantic/FavoriteAction',['./SemanticToggleButton'],function(S){"use strict";
var F=S.extend("sap.f.semantic.FavoriteAction",{metadata:{library:"sap.f"}});
return F;},true);
sap.ui.predefine('sap/f/semantic/FlagAction',['./SemanticToggleButton'],function(S){"use strict";
var F=S.extend("sap.f.semantic.FlagAction",{metadata:{library:"sap.f"}});
return F;},true);
sap.ui.predefine('sap/f/semantic/FooterMainAction',["./MainAction"],function(M){"use strict";
var F=M.extend("sap.f.semantic.FooterMainAction",{metadata:{library:"sap.f"}});
return F;},true);
sap.ui.predefine('sap/f/semantic/FullScreenAction',['./SemanticButton'],function(S){"use strict";
var F=S.extend("sap.f.semantic.FullScreenAction",{metadata:{library:"sap.f"}});
return F;},true);
sap.ui.predefine('sap/f/semantic/MainAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var M=S.extend("sap.f.semantic.MainAction",{metadata:{library:"sap.f",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
return M;},false);
sap.ui.predefine('sap/f/semantic/MessagesIndicator',['./SemanticButton'],function(S){"use strict";
var M=S.extend("sap.f.semantic.MessagesIndicator",{metadata:{library:"sap.f"}});
return M;},true);
sap.ui.predefine('sap/f/semantic/NegativeAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var N=S.extend("sap.f.semantic.NegativeAction",{metadata:{library:"sap.f",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
return N;},true);
sap.ui.predefine('sap/f/semantic/PositiveAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var P=S.extend("sap.f.semantic.PositiveAction",{metadata:{library:"sap.f",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
return P;},true);
sap.ui.predefine('sap/f/semantic/PrintAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var P=S.extend("sap.f.semantic.PrintAction",{metadata:{library:"sap.f"}});
return P;},true);
sap.ui.predefine('sap/f/semantic/SemanticButton',["./SemanticControl","./SemanticConfiguration","sap/m/Button","sap/m/OverflowToolbarButton"],function(S,a,B,O){"use strict";
var b=S.extend("sap.f.semantic.SemanticButton",{metadata:{library:"sap.f","abstract":true,properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true}},events:{press:{}}}});
b.prototype._getControl=function(){var c=this.getAggregation('_control'),C=this._getConfiguration(),o,n;if(!C){return null;}if(!c){o=C&&C.constraints==="IconOnly"?O:B;n=this._createInstance(o);n.applySettings(C.getSettings());if(typeof C.getEventDelegates==="function"){n.addEventDelegate(C.getEventDelegates(n));}this.setAggregation('_control',n,true);c=this.getAggregation('_control');}return c;};
b.prototype._createInstance=function(c){return new c({id:this.getId()+"-button",press:jQuery.proxy(this.firePress,this)});};
return b;},false);
sap.ui.predefine('sap/f/semantic/SemanticConfiguration',["jquery.sap.global","sap/ui/base/Metadata","sap/ui/core/IconPool","sap/m/ButtonType","sap/m/OverflowToolbarLayoutData","sap/m/OverflowToolbarPriority"],function(q,M,I,B,O,a){"use strict";var S=M.createClass("sap.f.semantic.SemanticConfiguration",{});S._Placement={titleText:"titleText",titleIcon:"titleIcon",footerLeft:"footerLeft",footerRight:"footerRight",shareMenu:"shareMenu"};
S.isKnownSemanticType=function(t){return S.getConfiguration(t)!==null;};
S.getConfiguration=function(t){return S._oTypeConfigs[t]||null;};
S.getSettings=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].getSettings();}return null;};
S.getConstraints=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].constraints||null;}return null;};
S.getPlacement=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].placement;}return null;};
S.getOrder=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].order;}return null;};
S.isMainAction=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].mainAction||false;}return false;};
S.isNavigationAction=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].navigation||false;}return false;};
S._oTypeConfigs=(function(){var t={},b=sap.ui.getCore().getLibraryResourceBundle("sap.f");t["sap.f.semantic.TitleMainAction"]={placement:S._Placement.titleText,order:0,mainAction:true,getSettings:function(){return{type:B.Emphasized,layoutData:new O({priority:a.NeverOverflow})};}};t["sap.f.semantic.AddAction"]={placement:S._Placement.titleText,order:1,getSettings:function(){return{text:b.getText("SEMANTIC_CONTROL_ADD"),tooltip:b.getText("SEMANTIC_CONTROL_ADD"),type:B.Transparent};}};t["sap.f.semantic.DeleteAction"]={placement:S._Placement.titleText,order:2,getSettings:function(){return{text:b.getText("SEMANTIC_CONTROL_DELETE"),type:B.Transparent};}};t["sap.f.semantic.CopyAction"]={placement:S._Placement.titleText,order:3,getSettings:function(){return{text:b.getText("SEMANTIC_CONTROL_COPY"),type:B.Transparent};}};t["sap.f.semantic.FavoriteAction"]={placement:S._Placement.titleIcon,order:0,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("favorite"),text:b.getText("SEMANTIC_CONTROL_FAVORITE"),type:B.Transparent};}};t["sap.f.semantic.FlagAction"]={placement:S._Placement.titleIcon,order:1,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("flag"),text:b.getText("SEMANTIC_CONTROL_FLAG"),type:B.Transparent};}};t["sap.f.semantic.FullScreenAction"]={placement:S._Placement.titleIcon,order:3,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:I.getIconURI("full-screen"),tooltip:b.getText("SEMANTIC_CONTROL_FULL_SCREEN"),layoutData:new O({priority:a.NeverOverflow}),type:B.Transparent};}};t["sap.f.semantic.ExitFullScreenAction"]={placement:S._Placement.titleIcon,order:4,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:I.getIconURI("exit-full-screen"),tooltip:b.getText("SEMANTIC_CONTROL_EXIT_FULL_SCREEN"),layoutData:new O({priority:a.NeverOverflow}),type:B.Transparent};}};t["sap.f.semantic.CloseAction"]={placement:S._Placement.titleIcon,order:5,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:I.getIconURI("decline"),tooltip:b.getText("SEMANTIC_CONTROL_CLOSE"),layoutData:new O({priority:a.NeverOverflow}),type:B.Transparent};}};t["sap.f.semantic.MessagesIndicator"]={placement:S._Placement.footerLeft,order:0,mainAction:false,getSettings:function(){return{icon:I.getIconURI("message-popup"),text:{path:"message>/",formatter:function(m){return m.length||0;}},tooltip:b.getText("SEMANTIC_CONTROL_MESSAGES_INDICATOR"),type:B.Emphasized,visible:{path:"message>/",formatter:function(m){return m&&m.length>0;}},models:{message:sap.ui.getCore().getMessageManager().getMessageModel()},layoutData:new O({priority:a.NeverOverflow})};}};t["sap.m.DraftIndicator"]={placement:S._Placement.footerLeft,order:1,mainAction:false,getSettings:function(){return{layoutData:new O({shrinkable:false})};}};t["sap.f.semantic.FooterMainAction"]={placement:S._Placement.footerRight,order:0,mainAction:true,getSettings:function(){return{type:B.Emphasized,text:b.getText("SEMANTIC_CONTROL_SAVE"),layoutData:new O({priority:a.NeverOverflow})};}};t["sap.f.semantic.PositiveAction"]={placement:S._Placement.footerRight,order:1,mainAction:false,getSettings:function(){return{type:B.Accept,text:b.getText("SEMANTIC_CONTROL_ACCEPT"),layoutData:new O({priority:a.NeverOverflow})};}};t["sap.f.semantic.NegativeAction"]={placement:S._Placement.footerRight,order:2,mainAction:false,getSettings:function(){return{type:B.Reject,text:b.getText("SEMANTIC_CONTROL_REJECT"),layoutData:new O({priority:a.NeverOverflow})};}};t["sap.f.semantic.SendEmailAction"]={placement:S._Placement.shareMenu,order:0,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("email"),text:b.getText("SEMANTIC_CONTROL_SEND_EMAIL"),type:B.Transparent};}};t["sap.f.semantic.DiscussInJamAction"]={placement:S._Placement.shareMenu,order:1,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("discussion-2"),text:b.getText("SEMANTIC_CONTROL_DISCUSS_IN_JAM"),type:B.Transparent};}};t["sap.f.semantic.ShareInJamAction"]={placement:S._Placement.shareMenu,order:2,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("share-2"),text:b.getText("SEMANTIC_CONTROL_SHARE_IN_JAM"),type:B.Transparent};}};t["sap.f.semantic.SendMessageAction"]={placement:S._Placement.shareMenu,order:3,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("discussion"),text:b.getText("SEMANTIC_CONTROL_SEND_MESSAGE"),type:B.Transparent};}};t["saveAsTileAction"]={placement:S._Placement.shareMenu,order:4,constraints:"IconOnly"};t["sap.f.semantic.PrintAction"]={placement:S._Placement.shareMenu,order:5,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("print"),text:b.getText("SEMANTIC_CONTROL_PRINT"),type:B.Transparent};}};return t;})();return S;},false);
sap.ui.predefine('sap/f/semantic/SemanticContainer',["jquery.sap.global","sap/ui/base/Metadata","sap/ui/core/CustomData","sap/m/ToolbarSpacer","./SemanticConfiguration"],function(q,M,C,T,S){"use strict";var a=M.createClass("sap.f.semantic.SemanticContainer",{constructor:function(c,p){if(!c){q.sap.log.error("SemanticContainer :: missing argument - container reference",this);return;}this._oContainer=c;this._oParent=p;}});
a.prototype._getContainer=function(){return this._oContainer;};
a.prototype._getParent=function(){return this._oParent;};
a.prototype._getControlOrder=function(c){var t=(c._getType&&c._getType())||c.getMetadata().getName();return S.getOrder(t);};
a.prototype._getConstraints=function(c){return S.getConstraints(c.getMetadata().getName());};
a.prototype._getControl=function(c){return c._getControl?c._getControl():c;};
a.prototype._isMainAction=function(c){return S.isMainAction(c.getMetadata().getName());};
a.prototype._isNavigationAction=function(c){return S.isNavigationAction(c.getMetadata().getName());};
a.prototype._callContainerAggregationMethod=function(m){return this._getContainer()[m].apply(this._getContainer(),Array.prototype.slice.call(arguments).slice(1));};
a.prototype._sortControlByOrder=function(c,o){return this._getControlOrder(c)-this._getControlOrder(o);};
a.prototype.destroy=function(){this._oParent=null;this._oContainer=null;};
return a;},false);
sap.ui.predefine('sap/f/semantic/SemanticControl',['jquery.sap.global',"sap/ui/base/ManagedObject","sap/ui/core/Element","./SemanticConfiguration"],function(q,M,E,S){"use strict";
var a=E.extend("sap.f.semantic.SemanticControl",{metadata:{library:"sap.f","abstract":true,properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{_control:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
a.prototype.setProperty=function(k,v,s){M.prototype.setProperty.call(this,k,v,true);this._applyProperty(k,v,s);return this;};
a.prototype.updateAggregation=function(n){this._getControl().updateAggregation(n);};
a.prototype.refreshAggregation=function(n){this._getControl().refreshAggregation(n);};
a.prototype.setAggregation=function(A,o,s){if(A==='_control'){return M.prototype.setAggregation.call(this,A,o,s);}return this._getControl().setAggregation(A,o,s);};
a.prototype.getAggregation=function(A,d){if(A==='_control'){return M.prototype.getAggregation.call(this,A,d);}return this._getControl().getAggregation(A,d);};
a.prototype.indexOfAggregation=function(A,o){return this._getControl().indexOfAggregation(A,o);};
a.prototype.insertAggregation=function(A,o,i,s){return this._getControl().insertAggregation(A,o,i,s);};
a.prototype.addAggregation=function(A,o,s){return this._getControl().addAggregation(A,o,s);};
a.prototype.removeAggregation=function(A,o,s){return this._getControl().removeAggregation(A,o,s);};
a.prototype.removeAllAggregation=function(A,s){return this._getControl().removeAllAggregation(A,s);};
a.prototype.destroyAggregation=function(A,s){return this._getControl().destroyAggregation(A,s);};
a.prototype.bindAggregation=function(n,b){return this._getControl().bindAggregation(n,b);};
a.prototype.unbindAggregation=function(n,s){return this._getControl().unbindAggregation(n,s);};
a.prototype.clone=function(i,l){var C=E.prototype.clone.apply(this,arguments);var p=this._getControl().clone(i,l);C.setAggregation('_control',p);return C;};
a.prototype.destroy=function(){var r=E.prototype.destroy.apply(this,arguments);if(this.getAggregation("_control")){this.getAggregation("_control").destroy();}return r;};
a.prototype.getDomRef=function(s){return this._getControl().getDomRef(s);};
a.prototype.addEventDelegate=function(d,t){q.each(d,function(e,C){if(typeof C==='function'){d[e]=function(o){o.srcControl=this;C.call(t,o);}.bind(this);}}.bind(this));this._getControl().addEventDelegate(d,t);return this;};
a.prototype.removeEventDelegate=function(d){this._getControl().removeEventDelegate(d);return this;};
a.prototype._getConfiguration=function(){return S.getConfiguration(this.getMetadata().getName());};
a.prototype._applyProperty=function(k,v,s){var C=this._getControl(),b;if(C){b="set"+c(k);this._getControl()[b](v,s);}};
function c(n){return n.charAt(0).toUpperCase()+n.slice(1);}
return a;},false);
sap.ui.predefine('sap/f/semantic/SemanticFooter',["jquery.sap.global","sap/m/ToolbarSpacer","sap/m/ButtonType","./SemanticConfiguration","./SemanticContainer"],function(q,T,B,S,a){"use strict";
var b=a.extend("sap.f.semantic.SemanticFooter",{constructor:function(c,p){a.call(this,c,p);this._aCustomContent=[];this._aSemanticLeftContent=[];this._aSemanticRightContent=[];this._iSemanticLeftContentCount=1;this._fnParentSubstitute=function(){return this._oParent;}.bind(this);this._insertSpacer();}});
b.mPlacementMethodMap={footerLeft:"LeftContent",footerRight:"RightContent"};
b.prototype.addCustomAction=function(c){c.setType(B.Transparent);this._callContainerAggregationMethod("addContent",c);this._aCustomContent.push(c);return this;};
b.prototype.insertCustomAction=function(c,i){var C=this._getCustomContentInsertIndex(i);c.setType(B.Transparent);this._callContainerAggregationMethod("insertContent",c,C);this._aCustomContent.splice(i,0,c);return this;};
b.prototype.getCustomActions=function(){return this._aCustomContent;};
b.prototype.indexOfCustomAction=function(c){return this._aCustomContent.indexOf(c);};
b.prototype.removeCustomAction=function(c){var r=this._callContainerAggregationMethod("removeContent",c);this._aCustomContent.splice(this._aCustomContent.indexOf(c),1);return r;};
b.prototype.removeAllCustomActions=function(){var r=[];this._aCustomContent.forEach(function(c){var R=this._callContainerAggregationMethod("removeContent",c);if(R){r.push(c);}},this);this._aCustomContent=[];return r;};
b.prototype.destroyCustomActions=function(){this.removeAllCustomActions(true).forEach(function(c){c.destroy();});return this;};
b.prototype.addContent=function(s,p){this["_insertSemantic"+b.mPlacementMethodMap[p]].call(this,s);return this;};
b.prototype.removeContent=function(s,p){this["_removeSemantic"+b.mPlacementMethodMap[p]].call(this,s);return this;};
b.prototype.destroy=function(){this._aCustomContent=null;this._aSemanticLeftContent=null;this._aSemanticRightContent=null;this._oSpacer=null;return a.prototype.destroy.call(this);};
b.prototype._insertSemanticLeftContent=function(s){var c=this._getControl(s),C=this._getControlOrder(s),i=this._getSemanticLeftContentInsertIndex(C);this._callContainerAggregationMethod("insertContent",c,i);this._iSemanticLeftContentCount++;this._aSemanticLeftContent.push(s);this._preProcessControl(c);return this;};
b.prototype._insertSemanticRightContent=function(s){var c=this._getControl(s);this._aSemanticRightContent.push(s);this._callContainerAggregationMethod("insertContent",c,this._getSemanticRightContentInsertIndex(s));return this;};
b.prototype._removeSemanticLeftContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeContent",c);this._iSemanticLeftContentCount--;this._aSemanticLeftContent.splice(this._aSemanticLeftContent.indexOf(c),1);this._postProcessControl(c);return s;};
b.prototype._removeSemanticRightContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeContent",c);this._aSemanticRightContent.splice(this._aSemanticRightContent.indexOf(s),1);return s;};
b.prototype._getSemanticLeftContentInsertIndex=function(c){return this._iSemanticLeftContentCount>1?c:0;};
b.prototype._getSemanticRightContentInsertIndex=function(s){this._aSemanticRightContent.sort(this._sortControlByOrder.bind(this));return this._iSemanticLeftContentCount+this._aSemanticRightContent.indexOf(s);};
b.prototype._getCustomContentInsertIndex=function(i){return i+this._iSemanticLeftContentCount+this._aSemanticRightContent.length;};
b.prototype._insertSpacer=function(){this._callContainerAggregationMethod("addContent",this._getSpacer());return this;};
b.prototype._getSpacer=function(){if(!this._oSpacer){this._oSpacer=new T();}return this._oSpacer;};
b.prototype._preProcessControl=function(c){if(!(typeof c._fnOriginalGetParent==="function")){c._fnOriginalGetParent=c.getParent;c.getParent=this._fnParentSubstitute;}};
b.prototype._postProcessControl=function(c){if(c._fnOriginalGetParent){c.getParent=c._fnOriginalGetParent;delete c._fnOriginalGetParent;}};
return b;},false);
sap.ui.predefine('sap/f/semantic/SemanticPage',["jquery.sap.global","sap/ui/core/Control","sap/ui/base/ManagedObject","sap/f/library","sap/f/DynamicPage","sap/f/DynamicPageTitle","sap/f/DynamicPageHeader","sap/m/OverflowToolbar","sap/m/ActionSheet","./SemanticTitle","./SemanticFooter","./SemanticShareMenu","./SemanticConfiguration"],function(q,C,M,l,D,a,b,O,A,S,c,d,e){"use strict";
var f=C.extend("sap.f.semantic.SemanticPage",{metadata:{library:"sap.f",properties:{headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},headerPinnable:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{titleHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},titleSnappedContent:{type:"sap.ui.core.Control",multiple:true},titleExpandedContent:{type:"sap.ui.core.Control",multiple:true},titleMainAction:{type:"sap.f.semantic.TitleMainAction",multiple:false},addAction:{type:"sap.f.semantic.AddAction",multiple:false},deleteAction:{type:"sap.f.semantic.DeleteAction",multiple:false},copyAction:{type:"sap.f.semantic.CopyAction",multiple:false},flagAction:{type:"sap.f.semantic.FlagAction",multiple:false},favoriteAction:{type:"sap.f.semantic.FavoriteAction",multiple:false},fullScreenAction:{type:"sap.f.semantic.FullScreenAction",multiple:false},exitFullScreenAction:{type:"sap.f.semantic.ExitFullScreenAction",multiple:false},closeAction:{type:"sap.f.semantic.CloseAction",multiple:false},titleCustomTextActions:{type:"sap.m.Button",multiple:true},titleCustomIconActions:{type:"sap.m.OverflowToolbarButton",multiple:true},headerContent:{type:"sap.ui.core.Control",multiple:true},content:{type:"sap.ui.core.Control",multiple:false},footerMainAction:{type:"sap.f.semantic.FooterMainAction",multiple:false},messagesIndicator:{type:"sap.f.semantic.MessagesIndicator",multiple:false},draftIndicator:{type:"sap.m.DraftIndicator",multiple:false},positiveAction:{type:"sap.f.semantic.PositiveAction",multiple:false},negativeAction:{type:"sap.f.semantic.NegativeAction",multiple:false},footerCustomActions:{type:"sap.m.Button",multiple:true},discussInJamAction:{type:"sap.f.semantic.DiscussInJamAction",multiple:false},saveAsTileAction:{type:"sap.m.Button",multiple:false},shareInJamAction:{type:"sap.f.semantic.ShareInJamAction",multiple:false},sendMessageAction:{type:"sap.f.semantic.SendMessageAction",multiple:false},sendEmailAction:{type:"sap.f.semantic.SendEmailAction",multiple:false},printAction:{type:"sap.f.semantic.PrintAction",multiple:false},customShareActions:{type:"sap.m.Button",multiple:true},_dynamicPage:{type:"sap.f.DynamicPage",multiple:false,visibility:"hidden"}}}});
f._EVENTS={SHARE_MENU_CONTENT_CHANGED:"_shareMenuContentChanged"};f._SAVE_AS_TILE_ACTION="saveAsTileAction";
f.prototype.init=function(){this._bSPBeingDestroyed=false;this._initDynamicPage();this._attachShareMenuButtonChange();this._fnActionSubstituteParentFunction=function(){return this;}.bind(this);};
f.prototype.exit=function(){this._bSPBeingDestroyed=true;this._cleanMemory();};
f.prototype.setHeaderExpanded=function(h){this._getPage().setHeaderExpanded(h);return this;};
f.prototype.getHeaderExpanded=function(){return this._getPage().getHeaderExpanded();};
f.prototype.setHeaderPinnable=function(h){var o=this._getPage(),g=o.getHeader();g.setPinnable(h);return this.setProperty("headerPinnable",g.getPinnable(),true);};
f.prototype.setPreserveHeaderStateOnScroll=function(p){var o=this._getPage();o.setPreserveHeaderStateOnScroll(p);return this.setProperty("preserveHeaderStateOnScroll",o.getPreserveHeaderStateOnScroll(),true);};
f.prototype.setToggleHeaderOnTitleClick=function(t){this._getPage().setToggleHeaderOnTitleClick(t);return this.setProperty("toggleHeaderOnTitleClick",t,true);};
f.prototype.setShowFooter=function(s){this._getPage().setShowFooter(s);return this.setProperty("showFooter",s,true);};
f.prototype.setAggregation=function(s,o,g){var h=this.mAggregations[s],t,p;if(h===o){return this;}o=this.validateAggregation(s,o,false);if(s===f._SAVE_AS_TILE_ACTION){t=f._SAVE_AS_TILE_ACTION;}else{t=this.getMetadata().getManagedAggregation(s).type;}if(e.isKnownSemanticType(t)){p=e.getPlacement(t);if(h){this._onRemoveAggregation(h,t);this._getSemanticContainer(p).removeContent(h,p);}if(o){o._getType=function(){return t;};this._getSemanticContainer(p).addContent(o,p);this._onAddAggregation(o,t);}return M.prototype.setAggregation.call(this,s,o,true);}return M.prototype.setAggregation.call(this,s,o,g);};
f.prototype.destroyAggregation=function(s,g){var o=this.getMetadata().getAggregations()[s],h,p,t;if(s===f._SAVE_AS_TILE_ACTION){t=f._SAVE_AS_TILE_ACTION;}else{t=o&&o.type;}if(t&&e.isKnownSemanticType(t)){h=M.prototype.getAggregation.call(this,s);if(h){p=e.getPlacement(t);this._onRemoveAggregation(h,t);!this._bSPBeingDestroyed&&this._getSemanticContainer(p).removeContent(h,p);}}return M.prototype.destroyAggregation.call(this,s,g);};
["getTitleHeading","setTitleHeading","destroyTitleHeading"].forEach(function(m){f.prototype[m]=function(o){var g=this._getTitle(),t=m.replace(/TitleHeading?/,"Heading");return g[t].apply(g,arguments);};},this);["addTitleExpandedContent","insertTitleExpandedContent","removeTitleExpandedContent","indexOfTitleExpandedContent","removeAllTitleExpandedContent","destroyTitleExpandedContent","getTitleExpandedContent"].forEach(function(m){f.prototype[m]=function(o){var g=this._getTitle(),t=m.replace(/TitleExpandedContent?/,"ExpandedContent");return g[t].apply(g,arguments);};});["addTitleSnappedContent","insertTitleSnappedContent","removeTitleSnappedContent","indexOfTitleSnappedContent","removeAllTitleSnappedContent","destroyTitleSnappedContent","getTitleSnappedContent"].forEach(function(m){f.prototype[m]=function(o){var g=this._getTitle(),t=m.replace(/TitleSnappedContent?/,"SnappedContent");return g[t].apply(g,arguments);};});["addHeaderContent","insertHeaderContent","removeHeaderContent","indexOfHeaderContent","removeAllHeaderContent","destroyHeaderContent","getHeaderContent"].forEach(function(m){f.prototype[m]=function(o){var g=this._getHeader(),h=m.replace(/HeaderContent?/,"Content");return g[h].apply(g,arguments);};});["getContent","setContent","destroyContent"].forEach(function(m){f.prototype[m]=function(o){var g=this._getPage();return g[m].apply(g,arguments);};},this);["addTitleCustomTextAction","insertTitleCustomTextAction","indexOfTitleCustomTextAction","removeTitleCustomTextAction","removeAllTitleCustomTextActions","destroyTitleCustomTextActions","getTitleCustomTextActions"].forEach(function(m){f.prototype[m]=function(){var s=this._getSemanticTitle(),g=m.replace(/TitleCustomTextAction?/,"CustomTextAction");return s[g].apply(s,arguments);};},this);["addTitleCustomIconAction","insertTitleCustomIconAction","indexOfTitleCustomIconAction","removeTitleCustomIconAction","removeAllTitleCustomIconActions","destroyTitleCustomIconActions","getTitleCustomIconActions"].forEach(function(m){f.prototype[m]=function(){var s=this._getSemanticTitle(),g=m.replace(/TitleCustomIconAction?/,"CustomIconAction");return s[g].apply(s,arguments);};},this);["addFooterCustomAction","insertFooterCustomAction","indexOfFooterCustomAction","removeFooterCustomAction","removeAllFooterCustomActions","destroyFooterCustomActions","getFooterCustomActions"].forEach(function(m){f.prototype[m]=function(){var s=this._getSemanticFooter(),g=m.replace(/FooterCustomAction?/,"CustomAction");return s[g].apply(s,arguments);};},this);["addCustomShareAction","insertCustomShareAction","indexOfCustomShareAction","removeCustomShareAction","removeAllCustomShareActions","destroyCustomShareActions","getCustomShareActions"].forEach(function(m){f.prototype[m]=function(){var s=this._getShareMenu(),g=m.replace(/CustomShareAction?/,"CustomAction");return s[g].apply(s,arguments);};},this);
f.prototype._onAddAggregation=function(o,t){if(t===f._SAVE_AS_TILE_ACTION){this._replaceParent(o);}};
f.prototype._onRemoveAggregation=function(o,t){if(t===f._SAVE_AS_TILE_ACTION){this._restoreParent(o);}if(o._getType){delete o._getType;}};
f.prototype._replaceParent=function(o){if(o._fnOriginalGetParent){return;}o._fnOriginalGetParent=o.getParent;o.getParent=this._fnActionSubstituteParentFunction;};
f.prototype._restoreParent=function(o){if(o&&o._fnOriginalGetParent){o.getParent=o._fnOriginalGetParent;}};
f.prototype._attachShareMenuButtonChange=function(){this.attachEvent(f._EVENTS.SHARE_MENU_CONTENT_CHANGED,this._onShareMenuContentChanged,this);};
f.prototype._onShareMenuContentChanged=function(E){var s=E.getParameter("bEmpty"),o=this._getSemanticTitle(),g=this._getShareMenu(),h=g._getShareMenuButton();if(!h.getParent()){o.addContent(h,"shareIcon");return;}h.setVisible(!s);};
f.prototype._getPage=function(){if(!this.getAggregation("_dynamicPage")){this._initDynamicPage();}return this.getAggregation("_dynamicPage");};
f.prototype._initDynamicPage=function(){this.setAggregation("_dynamicPage",new D(this.getId()+"-page",{title:this._getTitle(),header:this._getHeader(),footer:this._getFooter()}),true);};
f.prototype._getTitle=function(){if(!this._oDynamicPageTitle){this._oDynamicPageTitle=this._getSemanticTitle()._getContainer();}return this._oDynamicPageTitle;};
f.prototype._getHeader=function(){if(!this._oDynamicPageHeader){this._oDynamicPageHeader=new b(this.getId()+"-pageHeader");}return this._oDynamicPageHeader;};
f.prototype._getFooter=function(){if(!this._oDynamicPageFooter){this._oDynamicPageFooter=this._getSemanticFooter()._getContainer();}return this._oDynamicPageFooter;};
f.prototype._getSemanticTitle=function(){if(!this._oSemanticTitle){this._oSemanticTitle=new S(new a(this.getId()+"-pageTitle"),this);}return this._oSemanticTitle;};
f.prototype._getShareMenu=function(){if(!this._oShareMenu){this._oShareMenu=new d(this._getActionSheet(),this);}return this._oShareMenu;};
f.prototype._getActionSheet=function(){if(!this._oActionSheet){this._oActionSheet=new A(this.getId()+"-shareMenu");}return this._oActionSheet;};
f.prototype._getSemanticFooter=function(){if(!this._oSemanticFooter){this._oSemanticFooter=new c(this._getOverflowToolbar(),this);}return this._oSemanticFooter;};
f.prototype._getOverflowToolbar=function(){if(!this._oOverflowToolbar){this._oOverflowToolbar=new O(this.getId()+"-pageFooter");}return this._oOverflowToolbar;};
f.prototype._getSemanticContainer=function(p){var P=e._Placement;if(p===P.titleText||p===P.titleIcon){return this._getSemanticTitle();}else if(p===P.footerLeft||p===P.footerRight){return this._getSemanticFooter();}else if(p===P.shareMenu){return this._getShareMenu();}return null;};
f.prototype._cleanMemory=function(){if(this._oShareMenu){this._oShareMenu.destroy();this._oShareMenu=null;}if(this._oActionSheet){this._oActionSheet.destroy();this._oActionSheet=null;}if(this._oSemanticTitle){this._oSemanticTitle.destroy();this._oSemanticTitle=null;}if(this._oDynamicPageTitle){this._oDynamicPageTitle.destroy();this._oDynamicPageTitle=null;}if(this._oDynamicPageHeader){this._oDynamicPageHeader.destroy();this._oDynamicPageHeader=null;}if(this._oSemanticFooter){this._oSemanticFooter.destroy();this._oSemanticFooter=null;}if(this._oDynamicPageFooter){this._oDynamicPageFooter.destroy();this._oDynamicPageFooter=null;}if(this._oOverflowToolbar){this._oOverflowToolbar.destroy();this._oOverflowToolbar=null;}};
return f;},true);
sap.ui.predefine("sap/f/semantic/SemanticPageRenderer",[],function(){"use strict";var S={};
S.render=function(r,s){r.write("<div");r.writeControlData(s);r.addClass("sapFSemanticPage");r.writeClasses();r.write(">");r.renderControl(s._getPage());r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/f/semantic/SemanticShareMenu',["jquery.sap.global","sap/ui/core/IconPool","sap/ui/base/EventProvider","sap/m/Button","sap/m/ButtonType","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","./SemanticConfiguration","./SemanticContainer"],function(q,I,E,B,a,O,b,S,c){"use strict";
var d=c.extend("sap.f.semantic.SemanticShareMenu",{constructor:function(C,p){c.call(this,C,p);this._aShareMenuActions=[];this._aCustomShareActions=[];this._setMode(d._Mode.initial);}});
d._Mode={initial:"initial",menu:"menu"};
d.prototype.addCustomAction=function(C){this._onControlAdded(C);this._callContainerAggregationMethod("insertButton",C,this._getCustomActionInsertIndex());this._aCustomShareActions.push(C);return this;};
d.prototype.insertCustomAction=function(C,i){this._onControlAdded(C);this._callContainerAggregationMethod("insertButton",C,this._getCustomActionInsertIndex(i));this._aCustomShareActions.splice(i,0,C);return this;};
d.prototype.getCustomActions=function(){return this._aCustomShareActions;};
d.prototype.indexOfCustomAction=function(C){return this._aCustomShareActions.indexOf(C);};
d.prototype.removeCustomAction=function(C){var r=this._callContainerAggregationMethod("removeButton",C);this._aCustomShareActions.splice(this._aCustomShareActions.indexOf(C),1);this._onControlRemoved();return r;};
d.prototype.removeAllCustomActions=function(){var r=[];this._aCustomShareActions.forEach(function(C){var R=this._callContainerAggregationMethod("removeButton",C);if(R){r.push(C);}},this);this._aCustomShareActions=[];this._onControlRemoved();return r;};
d.prototype.destroyCustomActions=function(){this.removeAllCustomActions(true).forEach(function(C){C.destroy();});return this;};
d.prototype.addContent=function(s){var C=this._getControl(s);this._onControlAdded(C);this._aShareMenuActions.push(s);this._preProcessOverflowToolbarButton(C);this._callContainerAggregationMethod("insertButton",C,this._getSemanticActionInsertIndex(s));return this;};
d.prototype.removeContent=function(s){var C=this._getControl(s);this._callContainerAggregationMethod("removeButton",C);this._aShareMenuActions.splice(this._aShareMenuActions.indexOf(s),1);this._postProcessOverflowToolbarButton(s);this._onControlRemoved();return this;};
d.prototype.destroy=function(){this._oShareMenuBtn=null;this._aShareMenuActions=null;this._aCustomShareActions=null;return c.prototype.destroy.call(this);};
d.prototype._getMode=function(){return this._mode;};
d.prototype._setMode=function(m){if(this._getMode()===m){return this;}if(m===d._Mode.initial){if(this._getMode()){this._fireContentChanged(true);}this._mode=d._Mode.initial;return this;}if(m===d._Mode.menu){this._mode=d._Mode.menu;this._fireContentChanged(false);}return this;};
d.prototype._fireContentChanged=function(e){E.prototype.fireEvent.call(this._getParent(),"_shareMenuContentChanged",{"bEmpty":e});};
d.prototype._getShareMenuButton=function(){var C=this._getContainer();if(!this._oShareMenuBtn){this._oShareMenuBtn=new O(C.getId()+"-shareButton",{icon:I.getIconURI("action"),tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("SEMANTIC_CONTROL_ACTION_SHARE"),layoutData:new b({closeOverflowOnInteraction:false}),text:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("SEMANTIC_CONTROL_ACTION_SHARE"),type:a.Transparent,press:function(){C.openBy(this._oShareMenuBtn);}.bind(this)});this._oShareMenuBtn.addEventDelegate({onAfterRendering:function(){this._oShareMenuBtn.$().attr("aria-haspopup",true);}.bind(this)},this);}return this._oShareMenuBtn;};
d.prototype._getCustomActionInsertIndex=function(i){var C=this._aCustomShareActions.length;if(i===undefined){return this._aShareMenuActions.length+C;}i=i>=C?C:i;i+=this._aShareMenuActions.length;return i;};
d.prototype._getSemanticActionInsertIndex=function(s){this._aShareMenuActions.sort(this._sortControlByOrder.bind(this));return this._aShareMenuActions.indexOf(s);};
d.prototype._onControlAdded=function(C){if(this._isInitialMode()){this._setMode(d._Mode.menu,C);}};
d.prototype._onControlRemoved=function(){var A=this._aShareMenuActions.length,C=this._aCustomShareActions.length,e=(A+C)===0;if(this._isMenuMode()&&e){this._setMode(d._Mode.initial);}};
d.prototype._preProcessOverflowToolbarButton=function(o){if(o instanceof O){o._bInOverflow=true;}};
d.prototype._postProcessOverflowToolbarButton=function(o){if(o instanceof O){delete o._bInOverflow;}};
d.prototype._isInitialMode=function(){return this._getMode()===d._Mode.initial;};
d.prototype._isMenuMode=function(){return this._getMode()===d._Mode.menu;};
return d;},false);
sap.ui.predefine('sap/f/semantic/SemanticTitle',["jquery.sap.global","sap/m/ButtonType","sap/m/ToolbarSeparator","sap/m/ToolbarSpacer","./SemanticConfiguration","./SemanticContainer"],function(q,B,T,a,S,b){"use strict";
var c=b.extend("sap.f.semantic.SemanticTitle",{constructor:function(C,p){b.call(this,C,p);this._iMainActionCount=0;this._aSemanticTextActions=[];this._aSemanticSimpleIconActions=[];this._aSemanticNavIconActions=[];this._aCustomTextActions=[];this._aCustomIconActions=[];this._insertSeparator();this._attachContainerWidthChange();}});
c.mPlacementMethodMap={titleText:"TextContent",titleIcon:"IconContent",shareIcon:"ShareContent"};
c.prototype.addContent=function(s,p){this["_insertSemantic"+c.mPlacementMethodMap[p]].call(this,s);return this;};
c.prototype.removeContent=function(s,p){this["_removeSemantic"+c.mPlacementMethodMap[p]].call(this,s);return this;};
c.prototype.destroy=function(){this._aSemanticSimpleIconActions=null;this._aSemanticTextActions=null;this._aCustomTextActions=null;this._aCustomIconActions=null;this._aSemanticNavIconActions=null;this._oSeparator=null;return b.prototype.destroy.call(this);};
c.prototype.addCustomTextAction=function(C){C.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",C,this._getCustomTextActionInsertIndex());this._aCustomTextActions.push(C);return this;};
c.prototype.insertCustomTextAction=function(C,i){C.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",C,this._getCustomTextActionInsertIndex(i));this._aCustomTextActions.splice(i,0,C);return this;};
c.prototype.indexOfCustomTextAction=function(C){return this._aCustomTextActions.indexOf(C);};
c.prototype.removeCustomTextAction=function(C){var i=this._aCustomTextActions.indexOf(C),r=this._callContainerAggregationMethod("removeAction",C);this._aCustomTextActions.splice(i,1);return r;};
c.prototype.removeAllCustomTextActions=function(){var r=[];this._aCustomTextActions.forEach(function(C){var R=this._callContainerAggregationMethod("removeAction",C);if(R){r.push(C);}},this);this._aCustomTextActions=[];return r;};
c.prototype.destroyCustomTextActions=function(){this.removeAllCustomTextActions().forEach(function(C){C.destroy();});return this;};
c.prototype.getCustomTextActions=function(){return this._aCustomTextActions;};
c.prototype.addCustomIconAction=function(C){C.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",C,this._getCustomIconActionInsertIndex());this._aCustomIconActions.push(C);return this;};
c.prototype.insertCustomIconAction=function(C,i){C.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",C,this._getCustomIconActionInsertIndex(i));this._aCustomIconActions.splice(i,0,C);return this;};
c.prototype.indexOfCustomIconAction=function(C){return this._aCustomIconActions.indexOf(C);};
c.prototype.removeCustomIconAction=function(C){var i=this._aCustomIconActions.indexOf(C),r=this._callContainerAggregationMethod("removeAction",C);this._aCustomIconActions.splice(i,1);return r;};
c.prototype.removeAllCustomIconActions=function(){var r=[];this._aCustomIconActions.forEach(function(C){var R=this._callContainerAggregationMethod("removeAction",C);if(R){r.push(C);}},this);this._aCustomIconActions=[];return r;};
c.prototype.destroyCustomIconActions=function(){this.removeAllCustomIconActions().forEach(function(C){C.destroy();});return this;};
c.prototype.getCustomIconActions=function(){return this._aCustomIconActions;};
c.prototype._insertSemanticTextContent=function(s){var C=this._getControl(s),i=this._isMainAction(s),I;this._aSemanticTextActions.push(s);if(i){this._iMainActionCount++;I=this._getSemanticTextMainActionInsertIndex();}else{I=this._getSemanticTextActionInsertIndex(s);}this._callContainerAggregationMethod("insertAction",C,I);return this;};
c.prototype._removeSemanticTextContent=function(s){var C=this._getControl(s),i=this._aSemanticTextActions.indexOf(s),I=this._isMainAction(s);if(I){this._iMainActionCount--;}this._aSemanticTextActions.splice(i,1);this._callContainerAggregationMethod("removeAction",C);return this;};
c.prototype._insertSemanticIconContent=function(s){var C=this._getControl(s),i=0;if(this._isNavigationAction(s)){this._aSemanticNavIconActions.push(s);i=this._getSemanticNavIconActionInsertIndex(s);}else{this._aSemanticSimpleIconActions.push(s);i=this._getSemanticSimpleIconActionInsertIndex(s);}this._callContainerAggregationMethod("insertAction",C,i);return this;};
c.prototype._removeSemanticIconContent=function(s){var C=this._getControl(s),i;if(this._isNavigationAction(s)){i=this._aSemanticNavIconActions.indexOf(s);this._aSemanticNavIconActions.splice(i,1);}else{i=this._aSemanticTextActions.indexOf(s);this._aSemanticSimpleIconActions.splice(i,1);}this._callContainerAggregationMethod("removeAction",C);return this;};
c.prototype._insertSemanticShareContent=function(s){var C=this._getControl(s),i=this._getSemanticShareMenuInsertIndex();this._callContainerAggregationMethod("insertAction",C,i);return this;};
c.prototype._removeSemanticShareContent=function(s){var C=this._getControl(s);this._callContainerAggregationMethod("removeAction",C);return this;};
c.prototype._getSemanticTextMainActionInsertIndex=function(){return 0;};
c.prototype._getCustomTextActionInsertIndex=function(i){var C=this._aCustomTextActions.length;if(i===undefined){return this._iMainActionCount+C;}i=i>=C?C:i;i+=this._iMainActionCount;return i;};
c.prototype._getSemanticTextActionInsertIndex=function(s){this._aSemanticTextActions.sort(this._sortControlByOrder.bind(this));return this._getCustomTextActionInsertIndex()+this._aSemanticTextActions.indexOf(s)-this._iMainActionCount;};
c.prototype._getCustomIconActionInsertIndex=function(i){var C=this._aCustomIconActions.length,p=this._aCustomTextActions.length+this._aSemanticTextActions.length;if(i===undefined){return p+C;}i=i>=C?C:i;i+=p;return i;};
c.prototype._getSemanticSimpleIconActionInsertIndex=function(s){this._aSemanticSimpleIconActions.sort(this._sortControlByOrder.bind(this));return this._getCustomIconActionInsertIndex()+this._aSemanticSimpleIconActions.indexOf(s);};
c.prototype._getSemanticNavIconActionInsertIndex=function(s){this._aSemanticNavIconActions.sort(this._sortControlByOrder.bind(this));return this._getSeparatorIndex()+this._aSemanticNavIconActions.indexOf(s)+1;};
c.prototype._getSemanticShareMenuInsertIndex=function(){return this._getSeparatorIndex();};
c.prototype._getSeparatorIndex=function(){return this._callContainerAggregationMethod("indexOfAction",this._oSeparator);};
c.prototype._updateSeparatorVisibility=function(){var C=this._getContainerBar(),v;if(!C){return;}v=C._getVisibleAndNonOverflowContent();if(v.length>0){this._toggleSeparator(this._shouldSeparatorBeVisible(v));}};
c.prototype._shouldSeparatorBeVisible=function(v){var f=v[0],l=v[v.length-1];return!(f instanceof T||l instanceof T);};
c.prototype._toggleSeparator=function(s){var $=this._getSeparator().$();if($.length>0){$.toggleClass("sapUiHidden",!s);}};
c.prototype._insertSeparator=function(){this._callContainerAggregationMethod("addAction",this._getSeparator());return this;};
c.prototype._getSeparator=function(){if(!this._oSeparator){this._oSeparator=new T();this._oSeparator.addStyleClass("sapUiHidden");}return this._oSeparator;};
c.prototype._attachContainerWidthChange=function(){var C=this._getContainerBar();if(C){C.attachEvent("_controlWidthChanged",this._onContainerWidthChanged,this);}};
c.prototype._onContainerWidthChanged=function(){q.sap.delayedCall(0,this,this._updateSeparatorVisibility);};
c.prototype._getContainerBar=function(){var C=this._getContainer();if(C){return C.getAggregation("_overflowToolbar");}return null;};
return c;},false);
sap.ui.predefine('sap/f/semantic/SemanticToggleButton',['./SemanticButton','./SemanticControl','sap/m/ButtonType'],function(S,a,B){"use strict";
var b=S.extend("sap.f.semantic.SemanticToggleButton",{metadata:{library:"sap.f","abstract":true,properties:{pressed:{type:"boolean",group:"Data",defaultValue:false}}}});
b.prototype._onTap=function(e){e.setMarked();if(this.getEnabled()){this.setPressed(!this.getPressed());this.firePress({pressed:this.getPressed()});}};
b.prototype._onKeydown=function(e){if(e.which===jQuery.sap.KeyCodes.SPACE||e.which===jQuery.sap.KeyCodes.ENTER){this._onTap(e);}};
b.prototype._applyProperty=function(p,v,s){if(p==='pressed'){this._setPressed(v,s);}else{S.prototype._applyProperty.apply(this,arguments);}};
b.prototype._setPressed=function(p,s){var o=p?B.Emphasized:B.Transparent;this._getControl().setType(o,s);};
b.prototype._createInstance=function(c){var i=new c({id:this.getId()+"-toggleButton"});i.addEventDelegate({ontap:this._onTap,onkeydown:this._onKeydown},this);return i;};
return b;},false);
sap.ui.predefine('sap/f/semantic/SendEmailAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var a=S.extend("sap.f.semantic.SendEmailAction",{metadata:{library:"sap.f"}});
return a;},true);
sap.ui.predefine('sap/f/semantic/SendMessageAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var a=S.extend("sap.f.semantic.SendMessageAction",{metadata:{library:"sap.f"}});
return a;},true);
sap.ui.predefine('sap/f/semantic/ShareInJamAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var a=S.extend("sap.f.semantic.ShareInJamAction",{metadata:{library:"sap.f"}});
return a;},true);
sap.ui.predefine('sap/f/semantic/TitleMainAction',["./MainAction"],function(M){"use strict";
var T=M.extend("sap.f.semantic.TitleMainAction",{metadata:{library:"sap.f"}});
return T;},true);
jQuery.sap.registerPreloadedModules({
"name":"sap/f/library-preload",
"version":"2.0",
"modules":{
	"sap/f/manifest.json":'{\n  "_version": "1.2.0",\n  "sap.app": {\n    "_version": "1.2.0",\n    "id": "sap.f",\n    "type": "library",\n    "embeds": [],\n    "applicationVersion": {\n      "version": "1.46.10"\n    },\n    "title": "SAPUI5 library with Fiori controls.",\n    "description": "SAPUI5 library with Fiori controls.",\n    "ach": "CA-UI5-CTR",\n    "resources": "resources.json",\n    "offline": true\n  },\n  "sap.ui": {\n    "_version": "1.1.0",\n    "technology": "UI5",\n    "supportedThemes": [\n      "base",\n      "sap_hcb"\n    ]\n  },\n  "sap.ui5": {\n    "_version": "1.1.0",\n    "dependencies": {\n      "minUI5Version": "1.46",\n      "libs": {\n        "sap.ui.core": {\n          "minVersion": "1.46.10"\n        },\n        "sap.m": {\n          "minVersion": "1.46.10"\n        }\n      }\n    }\n  }\n}'
}});
//# sourceMappingURL=library-preload.js.map