/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','./DatePicker','./library'],function(q,D,a,l){"use strict";var b=a.extend("sap.m.DateRangeSelection",{metadata:{library:"sap.m",properties:{delimiter:{type:"string",group:"Misc",defaultValue:'-'},secondDateValue:{type:"object",group:"Data",defaultValue:null},from:{type:"object",group:"Misc",defaultValue:null,deprecated:true},to:{type:"object",group:"Misc",defaultValue:null,deprecated:true}}}});b.prototype.init=function(){a.prototype.init.apply(this,arguments);this._bIntervalSelection=true;};b.prototype.onkeypress=function(E){if(!E.charCode||E.metaKey||E.ctrlKey){return;}var f=e.call(this);var s=d.call(this);var A=f.sAllowedCharacters+s+" ";var C=String.fromCharCode(E.charCode);if(C&&f.sAllowedCharacters&&A.indexOf(C)<0){E.preventDefault();}};b.prototype._getPlaceholder=function(){var p=this.getPlaceholder();if(!p){p=this.getDisplayFormat();if(!p){p="medium";}if(this._checkStyle(p)){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);p=o.getDatePattern(p);}var s=d.call(this);if(s&&s!==""){p=p+" "+s+" "+p;}}return p;};b.prototype.setValue=function(v){if(v!==this.getValue()){this._lastValue=v;}else{return this;}this.setProperty("value",v,true);this._bValid=true;var f=[undefined,undefined];if(v){f=this._parseValue(v);this._oWantedDate=f[0];this._oWantedSecondDate=f[1];f=c.call(this,f[0],f[1]);if(!f[0]){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid dates",this);}}if(this._bValid){this.setProperty("dateValue",f[0],true);this.setProperty("secondDateValue",f[1],true);this._oWantedDate=undefined;this._oWantedSecondDate=undefined;}if(this.getDomRef()){var o=this._formatValue(f[0],f[1]);if(this._$input.val()!==o){this._$input.val(o);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};b.prototype.setValueFormat=function(v){this.setProperty("valueFormat",v,true);q.sap.log.warning("Property valueFormat is not supported in sap.m.DateRangeSelection control.",this);return this;};b.prototype.setDisplayFormat=function(s){this.setProperty("displayFormat",s,true);var o=this._formatValue(this.getDateValue(),this.getSecondDateValue());this.setProperty("value",o,true);if(this.getDomRef()&&(this._$input.val()!==o)){this._$input.val(o);this._curpos=this._$input.cursorPos();}return this;};b.prototype.setFrom=function(f){this.setDateValue(f);return this;};b.prototype.getFrom=function(){return this.getDateValue();};b.prototype.setTo=function(t){this.setSecondDateValue(t);return this;};b.prototype.getTo=function(){return this.getSecondDateValue();};b.prototype.setDateValue=function(o){if(o&&!(o instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getDateValue(),o)){return this;}if(o&&(o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime())){this._bValid=false;this._oWantedDate=o;o=undefined;}else{this._bValid=true;this.setProperty("dateValue",o,true);this._oWantedDate=undefined;}var s=this.getSecondDateValue();var v=this._formatValue(o,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var O=this._formatValue(o,s);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};b.prototype.setSecondDateValue=function(s){if(s&&!(s instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(q.sap.equal(this.getSecondDateValue(),s)){return this;}if(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime())){this._bValid=false;this._oWantedSecondDate=s;s=undefined;}else{this._bValid=true;this.setProperty("secondDateValue",s,true);this._oWantedSecondDate=undefined;}var o=this.getDateValue();var v=this._formatValue(o,s);if(v!==this.getValue()){this._lastValue=v;}this.setProperty("value",v,true);if(this.getDomRef()){var O=this._formatValue(o,s);if(this._$input.val()!==O){this._$input.val(O);this._setLabelVisibility();this._curpos=this._$input.cursorPos();}}return this;};b.prototype.setMinDate=function(o){a.prototype.setMinDate.apply(this,arguments);if(o){var s=this.getSecondDateValue();if(s&&s.getTime()<this._oMinDate.getTime()){q.sap.log.warning("SecondDateValue not in valid date -> changed to minDate",this);this.setSecondDateValue(new Date(this._oMinDate.getTime()));}}return this;};b.prototype.setMaxDate=function(o){a.prototype.setMaxDate.apply(this,arguments);if(o){var s=this.getSecondDateValue();if(s&&s.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("SecondDateValue not in valid date -> changed to maxDate",this);this.setSecondDateValue(new Date(this._oMaxDate.getTime()));}}return this;};b.prototype._checkMinMaxDate=function(){a.prototype._checkMinMaxDate.apply(this,arguments);if(this._oWantedSecondDate&&this._oWantedSecondDate.getTime()>=this._oMinDate.getTime()&&this._oWantedSecondDate.getTime()<=this._oMaxDate.getTime()){this.setSecondDateValue(this._oWantedSecondDate);}};b.prototype._parseValue=function(v){var f;var g=[];var o,h;var s=d.call(this);if((s&&s!=="")&&v){g=v.split(s);if(g.length===2){if(g[0].slice(g[0].length-1,g[0].length)==" "){g[0]=g[0].slice(0,g[0].length-1);}if(g[1].slice(0,1)==" "){g[1]=g[1].slice(1);}}else{g=v.split(" "+s+" ");}if(g.length<2){var i=v.split(" ");if(i.length===2){g=i;}}}if(v&&g.length<=2){f=e.call(this);if((!s||s==="")||g.length===1){o=f.parse(v);}else if(g.length===2){o=f.parse(g[0]);h=f.parse(g[1]);if(!o||!h){o=undefined;h=undefined;}}}return[o,h];};b.prototype._formatValue=function(o,s){var v="";var f=d.call(this);if(o){var F;F=e.call(this);if(f&&f!==""&&s){v=F.format(o)+" "+f+" "+F.format(s);}else{v=F.format(o);}}return v;};b.prototype.onChange=function(){if(!this.getEditable()||!this.getEnabled()){return;}var v=this._$input.val();var f=[undefined,undefined];this._oWantedDate=undefined;this._oWantedSecondDate=undefined;this._bValid=true;if(v!=""){f=this._parseValue(v);f=c.call(this,f[0],f[1]);if(f[0]){v=this._formatValue(f[0],f[1]);}else{this._bValid=false;}}if(v!==this._lastValue){if(this.getDomRef()&&(this._$input.val()!==v)){this._$input.val(v);this._curpos=this._$input.cursorPos();}this._lastValue=v;this.setProperty("value",v,true);if(this._bValid){this.setProperty("dateValue",f[0],true);this.setProperty("secondDateValue",f[1],true);}this._setLabelVisibility();if(this._oPopup&&this._oPopup.isOpen()){var s=this.getDateValue();if(s){if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!==s.getTime()){this._oDateRange.setStartDate(new Date(s.getTime()));this._oCalendar.focusDate(s);}}else{if(this._oDateRange.getStartDate()){this._oDateRange.setStartDate(undefined);}}var E=this.getSecondDateValue();if(E){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));this._oCalendar.focusDate(E);}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}}_.call(this,this._bValid);}};b.prototype._getInputValue=function(v){v=(typeof v=="undefined")?this._$input.val():v.toString();var f=this._parseValue(v);v=this._formatValue(f[0],f[1]);return v;};b.prototype.updateDomValue=function(v){this._bCheckDomValue=true;v=(typeof v=="undefined")?this._$input.val():v.toString();this._curpos=this._$input.cursorPos();var f=this._parseValue(v);v=this._formatValue(f[0],f[1]);if(this.isActive()&&(this._$input.val()!==v)){this._$input.val(v);this._$input.cursorPos(this._curpos);}this._setLabelVisibility();return this;};b.prototype.onsappageup=function(){};b.prototype.onsappageupmodifiers=function(){};b.prototype.onsappagedown=function(){};b.prototype.onsappagedownmodifiers=function(){};b.prototype._fillDateRange=function(){a.prototype._fillDateRange.apply(this,arguments);var E=this.getSecondDateValue();if(E){if(!this._oDateRange.getEndDate()||this._oDateRange.getEndDate().getTime()!==E.getTime()){this._oDateRange.setEndDate(new Date(E.getTime()));}}else{if(this._oDateRange.getEndDate()){this._oDateRange.setEndDate(undefined);}}};b.prototype._selectDate=function(E){var s=this._oCalendar.getSelectedDates();if(s.length>0){var o=s[0].getStartDate();var f=s[0].getEndDate();if(o&&f){var g=this.getDateValue();var h=this.getSecondDateValue();var v;if(!q.sap.equal(o,g)||!q.sap.equal(f,h)){if(q.sap.equal(f,h)){this.setDateValue(o);}else{this.setProperty("dateValue",o,true);this.setSecondDateValue(f);}v=this.getValue();_.call(this,true);if(!D.support.touch&&!q.sap.simulateMobileOnDesktop){this._curpos=v.length;this._$input.cursorPos(this._curpos);}}else if(!this._bValid){v=this._formatValue(o,f);if(v!=this._$input.val()){this._bValid=true;if(this.getDomRef()){this._$input.val(v);}_.call(this,true);}}this._oPopup.close();}}};b.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var i=a.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var o=this.getDateValue();if(o){v=this._formatValue(o,this.getSecondDateValue());}}i.description=[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim();return i;};function _(v){this.fireChangeEvent(this.getValue(),{from:this.getDateValue(),to:this.getSecondDateValue(),valid:v});}function c(o,s){if(o&&s&&o.getTime()>s.getTime()){var t=o;o=s;s=t;}if((o&&(o.getTime()<this._oMinDate.getTime()||o.getTime()>this._oMaxDate.getTime()))||(s&&(s.getTime()<this._oMinDate.getTime()||s.getTime()>this._oMaxDate.getTime()))){return[undefined,undefined];}else{return[o,s];}}function d(){var s=this.getDelimiter();if(!s){if(!this._sLocaleDelimiter){var L=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var o=sap.ui.core.LocaleData.getInstance(L);var p=o.getIntervalPattern();var i=p.indexOf("{0}")+3;var I=p.indexOf("{1}");s=p.slice(i,I);if(s.length>1){if(s.slice(0,1)==" "){s=s.slice(1);}if(s.slice(s.length-1,s.length)==" "){s=s.slice(0,s.length-1);}}this._sLocaleDelimiter=s;}else{s=this._sLocaleDelimiter;}}return s;}function e(){var p=(this.getDisplayFormat()||"medium");var f;var C=this.getDisplayFormatType();if(p==this._sUsedDisplayPattern&&C==this._sUsedDisplayCalendarType){f=this._oDisplayFormat;}else{if(this._checkStyle(p)){f=sap.ui.core.format.DateFormat.getInstance({style:p,strictParsing:true,calendarType:C});}else{f=sap.ui.core.format.DateFormat.getInstance({pattern:p,strictParsing:true,calendarType:C});}this._sUsedDisplayPattern=p;this._sUsedDisplayCalendarType=C;this._oDisplayFormat=f;}return f;}return b;},true);
