/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/IconPool','sap/ui/core/delegate/ScrollEnablement','./IconTabBarSelectList','./Button','./ResponsivePopover','./IconTabFilter'],function(q,l,C,E,I,a,S,b,B,R,c){"use strict";var d=C.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:sap.m.IconTabHeaderMode.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:sap.m.BackgroundDesign.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item"}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"}}}}}});E.apply(d.prototype,[true]);d.ANIMATION_DURATION=sap.ui.getCore().getConfiguration().getAnimation()?200:0;d.SCROLL_STEP=264;d.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iCurrentScrollLeft=0;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this.startScrollX=0;this.startTouchX=0;this._scrollable=null;this._aTabKeys=[];this._oItemNavigation=new I().setCycling(false);this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.addDelegate(this._oItemNavigation);this._oScroller=new S(this,this.getId()+"-head",{horizontal:true,vertical:false,nonTouchScrolling:true});};d.prototype._getSelectList=function(){var t=this;if(!this._oSelectList){this._oSelectList=new b({selectionChange:function(e){var T=e.getParameter('selectedItem');t.setSelectedItem(T._tabFilter);}});this._oSelectList._iconTabHeader=this;}return this._oSelectList;};d.prototype._getOverflowButton=function(){if(!this._oOverflowButton){this._oOverflowButton=new B({id:this.getId()+'-overflow',icon:"sap-icon://overflow",type:sap.m.ButtonType.Transparent,press:this._overflowButtonPress.bind(this)});}return this._oOverflowButton;};d.prototype._overflowButtonPress=function(e){if(!this._oPopover){this._oPopover=new R({showArrow:false,showHeader:false,placement:sap.m.PlacementType.Vertical,offsetX:0,offsetY:0}).addStyleClass('sapMITBPopover');if(sap.ui.Device.system.phone){this._oPopover._oControl.addButton(this._createPopoverCloseButton());}}var s=this._getSelectList();this._setSelectListItems();this._oPopover.removeAllContent();this._oPopover.addContent(s);this._oPopover.setInitialFocus(s.getSelectedItem());this._oPopover.openBy(this._getOverflowButton());};d.prototype._createPopoverCloseButton=function(){var t=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("SELECT_CANCEL_BUTTON"),press:function(){t._closeOverflow();}});};d.prototype._closeOverflow=function(){if(!sap.ui.Device.system.desktop){this._oPopover.close();}if(this.oSelectedItem){this.oSelectedItem.$().focus();}};d.prototype._setSelectListItems=function(){if(!this.getShowOverflowSelectList()){return;}var s,t,o=this._getSelectList(),T=this.getTabFilters();o.removeAllItems();for(var i=0;i<T.length;i++){t=T[i];s=t.clone();s._tabFilter=t;o.addItem(s);if(t==this.oSelectedItem){o.setSelectedItem(s);}}};d.prototype._findSelectItem=function(t){var s=this._getSelectList(),e=s.getItems(),o;for(var i=0;i<e.length;i++){o=e[i];if(o._tabFilter==t){return o;}}};d.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return;}var e=this.getItems();var f=-1;var o;for(var i=0;i<e.length;i++){o=e[i];if(o instanceof sap.m.IconTabFilter==false){continue;}f++;if(this.oSelectedItem==o){break;}}this._oItemNavigation.setFocusedIndex(f);};d.prototype._onItemNavigationAfterFocus=function(e){var h=this.getDomRef("head"),i=e.getParameter("index"),$=e.getParameter('event');if($.keyCode===undefined){return;}this._iCurrentScrollLeft=h.scrollLeft;this._checkOverflow();if(i!==null&&i!==undefined){this._scrollIntoView(this.getTabFilters()[i],0);}};d.prototype.getTabFilters=function(){var i=this.getItems();var t=[];i.forEach(function(o){if(o instanceof sap.m.IconTabFilter){t.push(o);}});return t;};d.prototype.exit=function(){if(this._oArrowLeft){this._oArrowLeft.destroy();}if(this._oArrowRight){this._oArrowRight.destroy();}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._aTabKeys){this._aTabKeys=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}if(this._oOverflowButton){this._oOverflowButton.destroy();this._oOverflowButton=null;}};d.prototype.onBeforeRendering=function(){var e=this.getItems(),s=this.getSelectedKey(),i=0;if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(e.length>0){if(!this.oSelectedItem||s&&s!==this.oSelectedItem._getNonEmptyKey()){if(s){for(;i<e.length;i++){if(!(e[i]instanceof sap.m.IconTabSeparator)&&e[i]._getNonEmptyKey()===s){this.oSelectedItem=e[i];break;}}}if(!this.oSelectedItem){for(i=0;i<e.length;i++){if(!(e[i]instanceof sap.m.IconTabSeparator)&&e[i].getVisible()){this.oSelectedItem=e[i];break;}}}}if(this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<e.length;i++){if(!(e[i]instanceof sap.m.IconTabSeparator)&&e[i].getVisible()){this.oSelectedItem=e[i];break;}}}if(this.oSelectedItem){this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);}}if(this._sResizeListenerNoFlexboxSupportId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerNoFlexboxSupportId);this._sResizeListenerNoFlexboxSupportId=null;}};d.prototype.setSelectedKey=function(k){var e=this.getTabFilters(),i=0;if(e.length>0){k=k||e[0]._getNonEmptyKey();}if(this.$().length){for(;i<e.length;i++){if(e[i]._getNonEmptyKey()===k){this.setSelectedItem(e[i],true);break;}}}this.setProperty("selectedKey",k,true);return this;};d.prototype.setSelectedItem=function(i,A){if(!i||!i.getEnabled()){return this;}if(this.getShowOverflowSelectList()){var s=this._findSelectItem(i);if(s){this._getSelectList().setSelectedItem(s);}}var p=this.getParent();var e=p instanceof sap.m.IconTabBar;var f=false;if(i.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){f=true;}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(e&&p.getExpandable()||this.oSelectedItem!==i)){this.oSelectedItem.$().removeClass("sapMITBSelected").attr('aria-selected',false).removeAttr('aria-expanded');}if(i.getVisible()){if(this.oSelectedItem===i){if(!A&&e&&p.getExpandable()){p._toggleExpandCollapse();}}else{if(e){p.$("content").attr('aria-labelledby',i.sId);}this.oSelectedItem=i;this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(!e){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}if(e&&(p.getExpandable()||p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});var o=this.oSelectedItem.getContent();if(o.length>0){p._rerenderContent(o);}else{if(!f){p._rerenderContent(p.getContent());}}if(!A&&p.getExpandable()&&!p.getExpanded()){p._toggleExpandCollapse(true);}}}if(this.oSelectedItem.$().length>0){this._scrollIntoView(i,500);}else{this._scrollAfterRendering=true;}}var g=this.oSelectedItem._getNonEmptyKey();this.oSelectedItem=i;this.setProperty("selectedKey",g,true);if(e){p.setProperty("selectedKey",g,true);}if(!A){if(e){p.fireSelect({selectedItem:this.oSelectedItem,selectedKey:g,item:this.oSelectedItem,key:g});}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:g,item:this.oSelectedItem,key:g});}}return this;};d.prototype._getFirstVisibleItem=function(e){for(var i=0;i<e.length;i++){if(e[i].getVisible()){return e[i];}}return null;};d.prototype._initItemNavigation=function(){var t=this,h=this.getDomRef("head"),i=this.getItems(),T=[],s=-1;i.forEach(function(o){if(o instanceof sap.m.IconTabFilter){var e=t.getFocusDomRef(o);q(e).attr("tabindex","-1");T.push(e);if(o===t.oSelectedItem){s=T.indexOf(e);}}});if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(h);this._oItemNavigation.setItemDomRefs(T);this._oItemNavigation.setSelectedIndex(s);};d.prototype.onAfterRendering=function(){if(this._oScroller){this._oScroller.setIconTabBar(this,q.proxy(this._afterIscroll,this),q.proxy(this._scrollPreparation,this));}var p=this.getParent();var i=p instanceof sap.m.IconTabBar;if(this.oSelectedItem&&(!i||i&&p.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}q.sap.delayedCall(350,this,"_checkOverflow");if(this.oSelectedItem){if(!this._bDoThisOnlyOnce){q.sap.delayedCall(1000,this,"_scrollIntoView",[this.oSelectedItem,0]);this._bDoThisOnlyOnce=true;}else if(this._scrollAfterRendering){this._scrollIntoView(this.oSelectedItem,500);this._scrollAfterRendering=false;}}this._initItemNavigation();if(this.getShowOverflowSelectList()){this.$('overflow').attr('tabindex',-1);}this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef(),q.proxy(this._fnResize,this));if(!q.support.newFlexBoxLayout&&i&&p.getStretchContentHeight()){this._sResizeListenerNoFlexboxSupportId=sap.ui.core.ResizeHandler.register(p.getDomRef(),q.proxy(this._fnResizeNoFlexboxSupport,this));this._fnResizeNoFlexboxSupport();}};d.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");};d.prototype.addItem=function(i){if(!(i instanceof sap.m.IconTabSeparator)){var k=i.getKey();if(this._aTabKeys.indexOf(k)!==-1){q.sap.log.warning("sap.m.IconTabHeader: duplicate key '"+k+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(k);}this.addAggregation("items",i);};d.prototype.insertItem=function(i,e){if(!(i instanceof sap.m.IconTabSeparator)){var k=i.getKey();if(this._aTabKeys.indexOf(k)!==-1){q.sap.log.warning("sap.m.IconTabHeader: duplicate key '"+k+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(k);}this.insertAggregation("items",i,e);};d.prototype.removeAllItems=function(){this._aTabKeys=[];this.removeAllAggregation("items");};d.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i&&!(i instanceof sap.m.IconTabSeparator)){var k=i.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(k),1);}return i;};d.prototype.updateAggregation=function(){this.oSelectedItem=null;return C.prototype.updateAggregation.apply(this,arguments);};d.prototype.removeAggregation=function(A,o,s){var i=this.getTabFilters();var e=C.prototype.removeAggregation.apply(this,arguments);if(this._oDragContext){return e;}if(e&&e==this.oSelectedItem&&A=='items'){var f=q.inArray(e,i);i=this.getTabFilters();f=Math.max(0,Math.min(f,i.length-1));var g=i[f];if(g){this.setSelectedItem(g,true);}else{var h=this.getParent();if(h instanceof sap.m.IconTabBar&&h.getExpanded()){h.$("content").children().remove();}}}return e;};d.prototype.removeAllAggregation=function(A,s){if(A=='items'){var i=this.getParent();if(i instanceof sap.m.IconTabBar&&i.getExpanded()){i.$("content").children().remove();}}return C.prototype.removeAllAggregation.apply(this,arguments);};d.prototype._getDisplayText=function(i){var t=i.getText();if(this.isInlineMode()){var s=i.getCount();if(s){if(this._bRtl){t='('+s+') '+t;}else{t+=' ('+s+')';}}}return t;};d.prototype.isInlineMode=function(){return this._bTextOnly&&this.getMode()==sap.m.IconTabHeaderMode.Inline;};d.prototype._checkTextOnly=function(e){if(e.length>0){for(var i=0;i<e.length;i++){if(!(e[i]instanceof sap.m.IconTabSeparator)){if(e[i].getIcon()){this._bTextOnly=false;return false;}}}}this._bTextOnly=true;return true;};d.prototype._checkNoText=function(e){if(e.length>0){for(var i=0;i<e.length;i++){if(!(e[i]instanceof sap.m.IconTabSeparator)){if(e[i].getText().length>0){return false;}}}}return true;};d.prototype._checkInLine=function(e){var o;if(e.length>0){for(var i=0;i<e.length;i++){o=e[i];if(!(o instanceof sap.m.IconTabSeparator)){if(o.getIcon()||o.getCount()){this._bInLine=false;return false;}}}}this._bInLine=true;return true;};d.prototype._checkScrolling=function(h){var $=this.$();var s=false;var e=this.getDomRef("scrollContainer");var f=this.getDomRef("head");if(f&&e){if(f.offsetWidth>e.offsetWidth){s=true;}}if(this._scrollable!==s){$.toggleClass("sapMITBScrollable",s);$.toggleClass("sapMITBNotScrollable",!s);this._scrollable=s;}return s;};d.prototype._getScrollingArrow=function(n){var s=a.getIconURI("slim-arrow-"+n);var p={src:s,useIconTooltip:false};var e=this._bTextOnly?"TextOnly":"";var L="sapMITBArrowScrollLeft"+e;var r="sapMITBArrowScrollRight"+e;var f=["sapMITBArrowScroll",L];var g=["sapMITBArrowScroll",r];if(this._bInLine){f.push('sapMITBArrowScrollLeftInLine');g.push('sapMITBArrowScrollRightInLine');}if(n==="left"){if(!this._oArrowLeft){this._oArrowLeft=sap.m.ImageHelper.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,p,f);}return this._oArrowLeft;}if(n==="right"){if(!this._oArrowRight){this._oArrowRight=sap.m.ImageHelper.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,p,g);}return this._oArrowRight;}};d.prototype._checkOverflow=function(){var o=this.getDomRef("head");var $=this.$();if(this._checkScrolling(o)&&o){var s=false;var e=false;var f=this.getDomRef("scrollContainer");var g=this.getDomRef("head");if(this._oScroller.getScrollLeft()>0){s=true;}if((this._oScroller.getScrollLeft()+f.offsetWidth)<g.offsetWidth){e=true;}if((e!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){this._bPreviousScrollForward=e;this._bPreviousScrollBack=s;$.toggleClass("sapMITBScrollBack",s);$.toggleClass("sapMITBNoScrollBack",!s);$.toggleClass("sapMITBScrollForward",e);$.toggleClass("sapMITBNoScrollForward",!e);}}else{this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;}};d.prototype._handleActivation=function(e){var t=e.target.id,o=e.srcControl,s;if(this._oDragContext&&this._oDragContext.movedTabIndexes.length){return;}if(o instanceof B){return;}var $=q.sap.byId(t);if(q.inArray(this.$("content")[0],$.parents())>-1){}else{if(t){var i=this.getId();e.preventDefault();if(t==i+"-arrowScrollLeft"&&sap.ui.Device.system.desktop){var f=this._oScroller.getScrollLeft()-d.SCROLL_STEP;if(f<0){f=0;}this._scrollPreparation();q.sap.delayedCall(0,this._oScroller,"scrollTo",[f,0,500]);q.sap.delayedCall(500,this,"_afterIscroll");}else if(t==i+"-arrowScrollRight"&&sap.ui.Device.system.desktop){var f=this._oScroller.getScrollLeft()+d.SCROLL_STEP;var g=this.$("scrollContainer").width();var h=this.$("head").width();if(f>(h-g)){f=h-g;}this._scrollPreparation();q.sap.delayedCall(0,this._oScroller,"scrollTo",[f,0,500]);q.sap.delayedCall(500,this,"_afterIscroll");}else{if(o instanceof sap.ui.core.Icon||o instanceof sap.m.Image){s=e.srcControl.getId().replace(/-icon$/,"");o=sap.ui.getCore().byId(s);if(o.getMetadata().isInstanceOf("sap.m.IconTab")&&!(o instanceof sap.m.IconTabSeparator)){this.setSelectedItem(o);}}else if(o.getMetadata().isInstanceOf("sap.m.IconTab")&&!(o instanceof sap.m.IconTabSeparator)){this.setSelectedItem(o);}}}else{if(o.getMetadata().isInstanceOf("sap.m.IconTab")&&!(o instanceof sap.m.IconTabSeparator)){this.setSelectedItem(o);}}}};d.prototype._scrollIntoView=function(i,D){var $=i.$(),s,n,e;if($.length>0){var f=this.$('head');var h=f.innerWidth()-f.width();var g=$.outerWidth(true);var j=$.position().left-h/2;s=this._oScroller.getScrollLeft();e=this.$("scrollContainer").width();n=0;if(j-s<0||j-s>e-g){if(j-s<0){n+=j;}else{n+=j+g-e;}this._scrollPreparation();this._iCurrentScrollLeft=n;q.sap.delayedCall(0,this._oScroller,"scrollTo",[n,0,D]);q.sap.delayedCall(D,this,"_afterIscroll");}}return this;};d.prototype._scroll=function(D,i){this._scrollPreparation();var o=this.getDomRef("head");var s=o.scrollLeft;var e=sap.ui.Device.browser.internet_explorer||sap.ui.Device.browser.edge;if(!e&&this._bRtl){D=-D;}var f=s+D;q(o).stop(true,true).animate({scrollLeft:f},i,q.proxy(this._adjustAndShowArrow,this));this._iCurrentScrollLeft=f;};d.prototype._adjustAndShowArrow=function(){this._$bar&&this._$bar.toggleClass("sapMITBScrolling",false);this._$bar=null;if(sap.ui.Device.system.desktop){this._checkOverflow();}};d.prototype._scrollPreparation=function(){if(!this._$bar){this._$bar=this.$().toggleClass("sapMITBScrolling",true);}};d.prototype._afterIscroll=function(){this._checkOverflow();this._adjustAndShowArrow();};d.prototype._fnResize=function(){this._checkOverflow();};d.prototype._fnResizeNoFlexboxSupport=function(){var $=this.getParent().$("containerContent"),D=$.outerHeight(true)-$.height();$.height(this.getParent().$().height()-$.position().top-D);};d.prototype.onExit=function(){if(this._sResizeListenerNoFlexboxSupportId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerNoFlexboxSupportId);this._sResizeListenerNoFlexboxSupportId=null;}};d.prototype.getFocusDomRef=function(f){var t=f||this.oSelectedItem;if(!t){return null;}return t.getDomRef();};d.prototype.applyFocusInfo=function(f){if(f.focusDomRef){q(f.focusDomRef).focus();}};d.prototype.ontouchstart=function(e){var t=e.targetTouches[0];this._iActiveTouch=t.identifier;this._iTouchStartPageX=t.pageX;this._iTouchDragX=0;var $=q(e.target);if($.hasClass('sapMITBArrowScroll')){e.preventDefault();}if(sap.ui.Device.browser.internet_explorer){if($.hasClass('sapMITBFilterIcon')||$.hasClass('sapMITBCount')||$.hasClass('sapMITBText')||$.hasClass('sapMITBTab')||$.hasClass('sapMITBContentArrow')||$.hasClass('sapMITBSep')||$.hasClass('sapMITBSepIcon')){e.preventDefault();}}};d.prototype.ontouchmove=function(e){if(this._iActiveTouch===undefined){return;}var t=sap.m.touch.find(e.changedTouches,this._iActiveTouch);if(!t||t.pageX===this._iTouchStartPageX){return;}this._iTouchDragX+=Math.abs(this._iTouchStartPageX-t.pageX);this._iTouchStartPageX=t.pageX;};d.prototype.ontouchend=function(e){if(this._iActiveTouch===undefined){return;}if(this._scrollable&&this._iTouchDragX>(sap.ui.Device.system.desktop?5:15)){return;}var M=0;var L=1;var f;if(e.which===f||e.which===M||e.which===L){this._handleActivation(e);}this._iActiveTouch=undefined;};d.prototype.ontouchcancel=d.prototype.ontouchend;d.prototype.onsapselect=function(e){this._handleActivation(e);};d.prototype.onmousedown=function(e){if(!this.getEnableTabReordering()){return;}var i=!!e.originalEvent["touches"];if(i){return;}var $=q(e.target);var f=$.closest(".sapMITBFilter, .sapMITBAll");if(f.length===1){this._onTabMoveStart(f,e);}};d.prototype._onTabMoveStart=function($,e){var i=this._getItemIndex($),f=this.$().find('.sapMITBHead').children(),w=$.outerWidth(true),g=q(document);e.preventDefault();$.zIndex(this.$().zIndex()+10);this._oDragContext={index:q.inArray($[0],f),tabIndex:i,startX:e.pageX,$tab:$,tab:this.getItems()[i],tabWidth:w,tabCenter:$.position().left+w/2,movedTabIndexes:[]};this._oScroller.setHorizontal(false);g.mousemove(q.proxy(this._onTabMove,this));g.mouseup(q.proxy(this._onTabMoved,this));};d.prototype._onTabMove=function(e){var D=this._oDragContext;if(!D){return;}var p=e.pageX,f=p-D.startX,$,x,o,r,g=this.$().find('.sapMITBHead').children(),m=D.movedTabIndexes,h=sap.ui.getCore().getConfiguration().getRTL();D.$tab.css({left:f});for(var i=0;i<g.length;i++){if(i==D.index){continue;}$=q(g[i]);x=$.position().left;o=parseFloat($.css('left'));if(!isNaN(o)){x-=o;}if(i<D.index!=h){r=x+$.outerWidth(true)>D.tabCenter+f;this._onAnimateTab($,D.tabWidth,r,m,i);}else{r=x<D.tabCenter+f;this._onAnimateTab($,-D.tabWidth,r,m,i);}}};d.prototype._onAnimateTab=function($,D,r,m,i){var e=q.inArray(i,m),f=e!=-1;if(r&&!f){$.stop(true,true);$.animate({left:D},d.ANIMATION_DURATION);m.push(i);}else if(!r&&f){$.stop(true,true);$.animate({left:0},d.ANIMATION_DURATION);m.splice(e,1);}};d.prototype._onTabMoved=function(e){var D=this._oDragContext;if(!D){return;}var m=D.movedTabIndexes;if(m.length>0){var $=D.$tab,f=this.$().find('.sapMITBHead').children(),n=m[m.length-1],N=this._getItemIndex(q(f[n]));this.removeAggregation('items',D.tab,true);this.insertAggregation('items',D.tab,N,true);if(n>D.index){$.insertAfter(q(f[n]));}else{$.insertBefore(q(f[n]));}this._initItemNavigation();q.sap.delayedCall(100,this,function(){$.focus();});}this._stopMoving();};d.prototype._stopMoving=function(){var D=this._oDragContext,$=D.$tab,e=this.$().find('.sapMITBHead').children();$.css('z-index','');e.stop(true,true);e.css('left','');this._oDragContext=null;var f=q(document);f.off("mousemove",this._onTabMove);f.off("mouseup",this._onTabMoved);this._oScroller.setHorizontal(true);this._enableTextSelection();};d.prototype._getItemIndex=function($){var s=$.attr('id'),t=this.getItems();for(var i=0;i<t.length;i++){if(t[i].getId()==s){return i;}}return-1;};d.prototype._disableTextSelection=function(e){q(e||document.body).attr("unselectable","on").addClass('sapMITBNoSelection').bind("selectstart",function(o){o.preventDefault();return false;});};d.prototype._enableTextSelection=function(e){q(e||document.body).attr("unselectable","off").removeClass('sapMITBNoSelection').unbind("selectstart");};return d;},true);
