/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','./ListItemBase','./Text','./Image','./OverflowToolbar','sap/ui/core/Icon'],function(q,l,C,L,T,I,O,a){'use strict';var N=L.extend('sap.m.NotificationListBase',{metadata:{library:'sap.m',properties:{priority:{type:'sap.ui.core.Priority',group:'Appearance',defaultValue:sap.ui.core.Priority.None},title:{type:'string',group:'Appearance',defaultValue:''},datetime:{type:'string',group:'Appearance',defaultValue:''},showButtons:{type:'boolean',group:'Behavior',defaultValue:true},showCloseButton:{type:'boolean',group:'Behavior',defaultValue:true},authorName:{type:'string',group:'Appearance',defaultValue:''},authorPicture:{type:'sap.ui.core.URI',multiple:false}},aggregations:{buttons:{type:'sap.m.Button',multiple:true},_headerTitle:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_dateTime:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_authorName:{type:'sap.m.Text',multiple:false,visibility:"hidden"},_authorImage:{type:'sap.ui.core.Control',multiple:false,visibility:"hidden"},_overflowToolbar:{type:'sap.m.OverflowToolbar',multiple:false,visibility:"hidden"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"},_collapseButton:{type:'sap.m.Button',multiple:false,visibility:"hidden"}},events:{close:{}}}});N.prototype.init=function(){this.setAggregation('_overflowToolbar',new O());};N.prototype.setTitle=function(t){var r=this.setProperty('title',t);this._getHeaderTitle().setText(t);return r;};N.prototype.setDatetime=function(d){var r=this.setProperty('datetime',d);this._getDateTimeText().setText(d);return r;};N.prototype.setAuthorName=function(b){var r=this.setProperty('authorName',b);this._getAuthorName().setText(b);return r;};N.prototype.clone=function(){var c=C.prototype.clone.apply(this,arguments);var o=this.getAggregation('_overflowToolbar');c.setAggregation("_overflowToolbar",o.clone(),true);return c;};N.prototype.close=function(){var p=this.getParent();this.fireClose();if(p&&p instanceof sap.ui.core.Element){var d={onAfterRendering:function(){p.getDomRef().focus();p.removeEventDelegate(d);}};p.addEventDelegate(d);}};N.prototype.bindAggregation=function(b,c){if(b=='buttons'){this.getAggregation('_overflowToolbar').bindAggregation('content',c);return this;}else{return sap.ui.core.Control.prototype.bindAggregation.call(this,b,c);}};N.prototype.validateAggregation=function(b,o,m){if(b=='buttons'){this.getAggregation('_overflowToolbar').validateAggregation('content',o,m);return this;}else{return sap.ui.core.Control.prototype.validateAggregation.call(this,b,o,m);}};N.prototype.setAggregation=function(b,o,s){if(b=='buttons'){this.getAggregation('_overflowToolbar').setAggregation('content',o,s);return this;}else{return sap.ui.core.Control.prototype.setAggregation.call(this,b,o,s);}};N.prototype.getAggregation=function(b,d){if(b=='buttons'){var t=this.getAggregation('_overflowToolbar');return t.getContent().filter(function(c){return c instanceof sap.m.Button;});}else{return sap.ui.core.Control.prototype.getAggregation.call(this,b,d);}};N.prototype.indexOfAggregation=function(b,o){if(b=='buttons'){return this.getAggregation('_overflowToolbar').indexOfAggregation('content',o);}else{return sap.ui.core.Control.prototype.indexOfAggregation.call(this,b,o);}};N.prototype.insertAggregation=function(b,o,c,s){if(b=='buttons'){this.getAggregation('_overflowToolbar').insertAggregation('content',o,c,s);return this;}else{return sap.ui.core.Control.prototype.insertAggregation.call(this,o,c,s);}};N.prototype.addAggregation=function(b,o,s){if(b=='buttons'){var t=this.getAggregation('_overflowToolbar');return t.addAggregation('content',o,s);}else{return sap.ui.core.Control.prototype.addAggregation.call(this,b,o,s);}};N.prototype.removeAggregation=function(b,o,s){if(b=='buttons'){return this.getAggregation('_overflowToolbar').removeAggregation('content',o,s);}else{return sap.ui.core.Control.prototype.removeAggregation.call(this,b,o,s);}};N.prototype.removeAllAggregation=function(b,s){if(b=='buttons'){return this.getAggregation('_overflowToolbar').removeAllAggregation('content',s);}else{return sap.ui.core.Control.prototype.removeAllAggregation.call(this,b,s);}};N.prototype.destroyAggregation=function(b,s){if(b=='buttons'){return this.getAggregation('_overflowToolbar').destroyAggregation('content',s);}else{return sap.ui.core.Control.prototype.destroyAggregation.call(this,b,s);}};N.prototype.getBinding=function(b){if(b=='buttons'){return this.getAggregation('_overflowToolbar').getBinding('content');}else{return sap.ui.core.Control.prototype.getBinding.call(this,b);}};N.prototype.getBindingInfo=function(b){if(b=='buttons'){return this.getAggregation('_overflowToolbar').getBindingInfo('content');}else{return sap.ui.core.Control.prototype.getBindingInfo.call(this,b);}};N.prototype.getBindingPath=function(b){if(b=='buttons'){return this.getAggregation('_overflowToolbar').getBindingPath('content');}else{return sap.ui.core.Control.prototype.getBindingPath.call(this,b);}};N.prototype._getHeaderTitle=function(){var t=this.getAggregation("_headerTitle");if(!t){t=new T({id:this.getId()+'-title',text:this.getTitle(),maxLines:2});this.setAggregation("_headerTitle",t,true);}return t;};N.prototype._getDateTimeText=function(){var d=this.getAggregation('_dateTime');if(!d){d=new sap.m.Text({id:this.getId()+'-datetime',text:this.getDatetime()}).addStyleClass('sapMNLI-Datetime');this.setAggregation('_dateTime',d,true);}return d;};N.prototype._getAuthorName=function(){var b=this.getAggregation('_authorName');if(!b){b=new T({text:this.getAuthorName()}).addStyleClass('sapMNLI-Text');this.setAggregation('_authorName',b,true);}return b;};N.prototype._getAuthorImage=function(){var b=this.getAggregation('_authorImage');if(!b){var c=this.getAuthorPicture();var d=this.getAuthorName();if(i(c)){b=new a({src:c,alt:d});}else{b=new I({src:c,alt:d});}this.setAggregation('_authorImage',b,true);}return b;};N.prototype._getToolbar=function(){var t=this.getAggregation("_overflowToolbar");if(!t){t=new O();this.setAggregation("_overflowToolbar",t,true);}return t;};function i(s){if(!s){return false;}var r=window.URI.parse(s);return(r.protocol&&r.protocol=='sap-icon');}return N;},true);
