/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/format/DateFormat','sap/ui/core/format/NumberFormat','sap/ui/core/IconPool'],function(q,a,C,D,N,I){"use strict";var P=C.extend("sap.m.P13nConditionPanel",{metadata:{library:"sap.m",properties:{maxConditions:{type:"string",group:"Misc",defaultValue:'-1'},exclude:{type:"boolean",group:"Misc",defaultValue:false},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},autoAddNewRow:{type:"boolean",group:"Misc",defaultValue:false},disableFirstRemoveIcon:{type:"boolean",group:"Misc",defaultValue:false},alwaysShowAddIcon:{type:"boolean",group:"Misc",defaultValue:true},usePrevConditionSetting:{type:"boolean",group:"Misc",defaultValue:true},autoReduceKeyFieldItems:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Misc",defaultValue:false},displayFormat:{type:"string",group:"Misc",defaultValue:null},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{dataChange:{}}},renderer:function(r,c){r.write("<section");r.writeControlData(c);r.addClass("sapMConditionPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMConditionPanelContent");r.addClass("sapMConditionPanelBG");r.writeClasses();r.write(">");var b=c.getAggregation("content");var l=b.length;for(var i=0;i<l;i++){r.renderControl(b[i]);}r.write("</div>");r.write("</section>");}});P.prototype.setConditions=function(c){if(!c){q.sap.log.error("sap.m.P13nConditionPanel : aCondition is not defined");}if(this._bIgnoreSetConditions){return;}this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;for(var i=0;i<c.length;i++){this._addCondition2Map(c[i]);}this._clearConditions();this._fillConditions();};P.prototype.removeAllConditions=function(){this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._clearConditions();this._fillConditions();};P.prototype.addCondition=function(c){if(this._bIgnoreSetConditions){return;}c.index=this._iConditions;this._addCondition2Map(c);this._addCondition(c);};P.prototype.insertCondition=function(c,i){if(this._bIgnoreSetConditions){return;}if(i!==undefined){c.index=i;}this._addCondition2Map(c);this._addCondition(c);};P.prototype.removeCondition=function(c){this._clearConditions();if(typeof c=="string"){this._removeConditionFromMap(c);}if(typeof c=="object"){this._removeConditionFromMap(c.key);}this._fillConditions();};P.prototype._addCondition2Map=function(c){if(!c.key){c.key="condition_"+this._iConditions;if(this.getExclude()){c.key="x"+c.key;}}this._iConditions++;this._oConditionsMap[c.key]=c;this._aConditionKeys.push(c.key);};P.prototype._removeConditionFromMap=function(k){this._iConditions--;delete this._oConditionsMap[k];var i=this._aConditionKeys.indexOf(k);if(i>=0){this._aConditionKeys.splice(i,1);}};P.prototype.getConditions=function(){var c;var b=[];if(this._oConditionsMap){for(var d in this._oConditionsMap){c=this._oConditionsMap[d];var v=c.value;if(!v){v=this._getFormatedConditionText(c.operation,c.value1,c.value2,c.exclude,c.keyField,c.showIfGrouped);}if(!c._oGrid||c._oGrid.select.getSelected()){b.push({"key":d,"text":v,"exclude":c.exclude,"operation":c.operation,"keyField":c.keyField,"value1":c.value1,"value2":c.operation===sap.m.P13nConditionOperation.BT?c.value2:null,"showIfGrouped":c.showIfGrouped});}}}return b;};P.prototype.setOperations=function(o,t){t=t||"default";this._oTypeOperations[t]=o;this._updateAllOperations();};P.prototype.setValues=function(v,t){t=t||"default";this._oTypeValues[t]=v;};P.prototype.addOperation=function(o,t){t=t||"default";this._oTypeOperations[t].push(o);this._updateAllOperations();};P.prototype.removeAllOperations=function(t){t=t||"default";this._oTypeOperations[t]=[];this._updateAllOperations();};P.prototype.getOperations=function(t){t=t||"default";return this._oTypeOperations[t];};P.prototype.setKeyFields=function(k){this._aKeyFields=k;this._updateKeyFieldItems(this._oConditionsGrid,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};P.prototype.addKeyField=function(k){this._aKeyFields.push(k);this._updateKeyFieldItems(this._oConditionsGrid,true,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};P.prototype.removeAllKeyFields=function(){this._aKeyFields=[];this._updateKeyFieldItems(this._oConditionsGrid,true);};P.prototype.getKeyFields=function(){return this._aKeyFields;};P.prototype.setAlwaysShowAddIcon=function(e){this.setProperty("alwaysShowAddIcon",e);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");}return this;};P.prototype.setLayoutMode=function(l){this.setProperty("layoutMode",l);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",l!=="Desktop");}this._updateConditionFieldSpans(l);this._clearConditions();this._fillConditions();return this;};P.prototype.setContainerQuery=function(e){this._unregisterResizeHandler();this.setProperty("containerQuery",e);this._registerResizeHandler();this._clearConditions();this._fillConditions();return this;};P.prototype._updateConditionFieldSpans=function(m){if(this._aConditionsFields){var d=m==="Desktop";if(d){this._aConditionsFields[2].SpanFilter="L3 M3 S3";this._aConditionsFields[4].SpanFilter="L2 M2 S2";this._aConditionsFields[5].SpanFilter="L3 M3 S3";this._aConditionsFields[6].SpanFilter="L2 M2 S2";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}var t=m==="Tablet";if(t){this._aConditionsFields[2].SpanFilter="L5 M5 S5";this._aConditionsFields[4].SpanFilter="L5 M5 S5";this._aConditionsFields[5].SpanFilter="L10 M10 S10";this._aConditionsFields[6].SpanFilter="L10 M10 S10";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}}};P.prototype.init=function(){sap.ui.getCore().loadLibrary("sap.ui.layout");q.sap.require("sap.ui.layout.Grid");sap.ui.layout.Grid.prototype.init.apply(this);this.addStyleClass("sapMConditionPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sFromLabelText=this._oRb.getText("CONDITIONPANEL_LABELFROM");this._sToLabelText=this._oRb.getText("CONDITIONPANEL_LABELTO");this._sValueLabelText=this._oRb.getText("CONDITIONPANEL_LABELVALUE");this._sShowIfGroupedLabelText=this._oRb.getText("CONDITIONPANEL_LABELGROUPING");this._sValidationDialogFieldMessage=this._oRb.getText("CONDITIONPANEL_FIELDMESSAGE");this._oTypeOperations={"default":[]};this._oTypeValues={"default":[]};this._aKeyFields=[];this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._sLayoutMode="Desktop";this._sConditionType="Filter";this._sAddRemoveIconTooltip="FILTER";this._iBreakPointTablet=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD].points[0];this._iBreakPointDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD].points[1];this._oConditionsGrid=new sap.ui.layout.Grid({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:0,vSpacing:0}).toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");this._iFirstConditionIndex=0;this._iConditionPageSize=10;this._oInvisibleTextField=new sap.ui.core.InvisibleText({text:this._oRb.getText("CONDITIONPANEL_FIELD_LABEL")});this._oInvisibleTextOperator=new sap.ui.core.InvisibleText({text:this._oRb.getText("CONDITIONPANEL_OPERATOR_LABEL")});this.addAggregation("content",this._oInvisibleTextField);this.addAggregation("content",this._oInvisibleTextOperator);this.addAggregation("content",this._oConditionsGrid);this._registerResizeHandler();this._aConditionsFields=[{"ID":"select","Label":"","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"CheckBox","Value":""},{"ID":"keyFieldLabel","Text":"Sort By","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"keyField","Label":"","SpanFilter":"L3 M5 S10","SpanSort":"L5 M5 S12","SpanGroup":"L4 M4 S12","Control":"ComboBox"},{"ID":"operationLabel","Text":"Sort Order","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"operation","Label":"","SpanFilter":"L2 M5 S10","SpanSort":sap.ui.Device.system.phone?"L5 M5 S8":"L5 M5 S9","SpanGroup":"L2 M5 S10","Control":"ComboBox"},{"ID":"value1","Label":this._sFromLabelText,"SpanFilter":"L3 M10 S10","SpanSort":"L3 M10 S10","SpanGroup":"L3 M10 S10","Control":"TextField","Value":""},{"ID":"value2","Label":this._sToLabelText,"SpanFilter":"L2 M10 S10","SpanSort":"L2 M10 S10","SpanGroup":"L2 M10 S10","Control":"TextField","Value":""},{"ID":"showIfGrouped","Label":this._sShowIfGroupedLabelText,"SpanFilter":"L1 M10 S10","SpanSort":"L1 M10 S10","SpanGroup":"L3 M4 S9","Control":"CheckBox","Value":"false"}];this._oButtonGroupSpan={"SpanFilter":"L1 M2 S2","SpanSort":sap.ui.Device.system.phone?"L2 M2 S4":"L2 M2 S3","SpanGroup":"L2 M2 S3"};this._updateConditionFieldSpans(this.getLayoutMode());this._fillConditions();};P.prototype._createPaginatorToolbar=function(){this._bPaginatorButtonsVisible=false;var t=this;this._oPrevButton=new sap.m.Button({icon:sap.ui.core.IconPool.getIconURI("navigation-left-arrow"),tooltip:this._oRb.getText("WIZARD_FINISH"),visible:true,press:function(e){t._iFirstConditionIndex=Math.max(0,t._iFirstConditionIndex-t._iConditionPageSize);t._clearConditions();t._fillConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow})});this._oNextButton=new sap.m.Button({icon:sap.ui.core.IconPool.getIconURI("navigation-right-arrow"),tooltip:this._oRb.getText("WIZARD_NEXT"),visible:true,press:function(e){t._iFirstConditionIndex+=t._iConditionPageSize;t._clearConditions();t._fillConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow})});this._oRemoveAllButton=new sap.m.Button({text:this._oRb.getText("CONDITIONPANEL_REMOVE_ALL"),visible:true,press:function(e){t._aConditionKeys.forEach(function(k,i){if(i>=0){this.fireDataChange({key:k,index:i,operation:"remove",newData:null});}},t);this._iFirstConditionIndex=0;t.removeAllConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.Low})});this._oAddButton=new sap.m.Button({icon:sap.ui.core.IconPool.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),visible:true,press:function(e){var c=t._createConditionRow(t._oConditionsGrid,undefined,null,0);t._changeField(c);setTimeout(function(){c.keyField.focus();});t._updatePaginatorToolbar();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.Low})});this._oHeaderText=new sap.m.Text({wrapping:false,layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow})});this._oPageText=new sap.m.Text({wrapping:false,textAlign:sap.ui.core.TextAlign.Center,layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.NeverOverflow})});this._oFilterField=new sap.m.SearchField({width:"12rem",layoutData:new sap.m.OverflowToolbarLayoutData({priority:sap.m.OverflowToolbarPriority.High})});this._oPaginatorToolbar=new sap.m.OverflowToolbar({height:"3rem",design:sap.m.ToolbarDesign.Transparent,content:[this._oHeaderText,new sap.m.ToolbarSpacer(),this._oFilterField,this._oPrevButton,this._oPageText,this._oNextButton,this._oRemoveAllButton,this._oAddButton]});};P.prototype._updatePaginatorToolbar=function(){if(this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"){return;}var i=this._aConditionKeys.length;var p=1+Math.floor(Math.max(0,i-1)/this._iConditionPageSize);var b=1+Math.floor(this._iFirstConditionIndex/this._iConditionPageSize);var o=this.getParent();if(!this._oPaginatorToolbar){if(i>this._iConditionPageSize){this._createPaginatorToolbar();this.insertAggregation("content",this._oPaginatorToolbar,0);this._onGridResize();}else{if(o&&o.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=o.getHeaderText();}o.setHeaderText(this._sOrgHeaderText+(i>0?" ("+i+")":""));}return;}}this._oPrevButton.setEnabled(this._iFirstConditionIndex>0);this._oNextButton.setEnabled(this._iFirstConditionIndex+this._iConditionPageSize<i);if(o&&o.setHeaderToolbar){if(!o.getHeaderToolbar()){this.removeAggregation("content",this._oPaginatorToolbar);o.setHeaderToolbar(this._oPaginatorToolbar);o.attachExpand(function(e){this._setToolbarElementVisibility(e.getSource().getExpanded()&&this._bPaginatorButtonsVisible);}.bind(this));}}if(o&&o.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=o.getHeaderText();}var h=this._sOrgHeaderText+(i>0?" ("+i+")":"");o.setHeaderText(h);this._oHeaderText.setText(h);}else{this._oHeaderText.setText(i+" Conditions");}this._oPageText.setText(b+"/"+p);this._bPaginatorButtonsVisible=this._bPaginatorButtonsVisible||p>1;this._setToolbarElementVisibility(this._bPaginatorButtonsVisible);if(b>p){this._iFirstConditionIndex-=Math.max(0,this._iConditionPageSize);this._clearConditions();this._fillConditions();}var n=0;this._oConditionsGrid.getContent().forEach(function(g){if(g.select.getSelected()){n++;}},this);if(p==b&&(i-this._iFirstConditionIndex)>n){this._clearConditions();this._fillConditions();}};P.prototype._setToolbarElementVisibility=function(v){this._oPrevButton.setVisible(v);this._oNextButton.setVisible(v);this._oPageText.setVisible(v);this._oFilterField.setVisible(false);this._oAddButton.setVisible(v);this._oRemoveAllButton.setVisible(v);};P.prototype.exit=function(){this._clearConditions();this._unregisterResizeHandler();this._aConditionsFields=null;this._aKeys=null;this._aKeyFields=null;this._oTypeOperations=null;this._oRb=null;this._sFromLabelText=null;this._sToLabelText=null;this._sValueLabelText=null;this._sValidationDialogFieldMessage=null;this._oConditionsMap=null;this._aConditionKeys=[];};P.prototype._clearConditions=function(){var g=this._oConditionsGrid.getContent();g.forEach(function(G){for(var f in this._aConditionsFields){var b=this._aConditionsFields[f];if(G[b["ID"]]&&G.getContent().indexOf(G[b["ID"]])===-1){G[b["ID"]].destroy();}}},this);this._oConditionsGrid.destroyContent();};P.prototype._fillConditions=function(){var c,s;var i=0,m=this._getMaxConditionsAsNumber(),n=this._aConditionKeys.length;if(this._oConditionsMap){var p=this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"?9999:this._iConditionPageSize;n=Math.min(n,Math.min(m,this._iFirstConditionIndex+p));for(i=this._iFirstConditionIndex;i<n;i++){s=this._aConditionKeys[i];c=this._oConditionsMap[s];this._createConditionRow(this._oConditionsGrid,c,s);}}this._updatePaginatorToolbar();if((this.getAutoAddNewRow()||this._oConditionsGrid.getContent().length===0)&&this._oConditionsGrid.getContent().length<m){this._createConditionRow(this._oConditionsGrid);}};P.prototype._addCondition=function(c){var i=0;var m=this._getMaxConditionsAsNumber();if(this._oConditionsMap){for(var b in this._oConditionsMap){if(i<m&&c===this._oConditionsMap[b]){this._createConditionRow(this._oConditionsGrid,c,b,i);}i++;}}this._updatePaginatorToolbar();};P.prototype._getMaxConditionsAsNumber=function(){return this.getMaxConditions()==="-1"?9999:parseInt(this.getMaxConditions(),10);};P.prototype.onAfterRendering=function(){if(this.getLayoutMode()){this._sLayoutMode=this.getLayoutMode();return;}};P.prototype._handleMediaChange=function(p){this._sLayoutMode=p.name;this._updateLayout(p);};P.prototype._unregisterResizeHandler=function(){if(this._sContainerResizeListener){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}sap.ui.Device.media.detachHandler(this._handleMediaChange,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);};P.prototype._registerResizeHandler=function(){if(this.getContainerQuery()){this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(this._oConditionsGrid,q.proxy(this._onGridResize,this));this._onGridResize();}else{sap.ui.Device.media.attachHandler(this._handleMediaChange,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);}};P.prototype._getKeyFromConditionGrid=function(c){var k=c.data("_key");if(!k){k=this._createConditionKey();}return k;};P.prototype._createConditionKey=function(){var i=0;var k;do{k="condition_"+i;if(this.getExclude()){k="x"+k;}i++;}while(this._oConditionsMap[k]);return k;};P.prototype._createConditionRow=function(t,c,k,p){var b=null;var g;var d=this;if(p===undefined){p=t.getContent().length;}var o=new sap.ui.layout.Grid({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:1,vSpacing:0,containerQuery:this.getContainerQuery()}).data("_key",k);for(var f in this._aConditionsFields){var e;var h=this._aConditionsFields[f];switch(h["Control"]){case"CheckBox":e=new sap.m.CheckBox({enabled:false,visible:false,layoutData:new sap.ui.layout.GridData({span:h["Span"+this._sConditionType]})});if(h["ID"]==="showIfGrouped"){e.setEnabled(true);e.setText(h["Label"]);e.attachSelect(function(){d._changeField(o);});e.setSelected(c?c.showIfGrouped:true);}else{if(c){e.setSelected(true);e.setEnabled(true);}}break;case"ComboBox":if(h["ID"]==="keyField"){e=new sap.m.ComboBox({width:"100%",ariaLabelledBy:this._oInvisibleTextField});var O=q.proxy(e.setSelectedKey,e);e.setSelectedKey=function(k){O(k);var m=d.getValidationExecutor();if(m){m();}};var i=q.proxy(e.setSelectedItem,e);e.setSelectedItem=function(m){i(m);var n=d.getValidationExecutor();if(n){n();}};e.setLayoutData(new sap.ui.layout.GridData({span:h["Span"+this._sConditionType]}));this._fillKeyFieldListItems(e,this._aKeyFields);if(e.attachSelectionChange){e.attachSelectionChange(function(E){var m=d.getValidationExecutor();if(m){m();}d._handleSelectionChangeOnKeyField(t,o);});}if(e.attachChange){e.attachChange(function(E){o.keyField.close();d._handleChangeOnKeyField(t,o);});}if(e.setSelectedItem){if(c){e.setSelectedKey(c.keyField);this._aKeyFields.forEach(function(K,m){var n=K.key;if(n===undefined){n=K;}if(c.keyField===n){e.setSelectedItem(e.getItems()[m]);}},this);}else{if(this.getUsePrevConditionSetting()&&!this.getAutoReduceKeyFieldItems()){if(p>0&&!k){g=t.getContent()[p-1];e.setSelectedKey(g.keyField.getSelectedKey());}else{this._aKeyFields.some(function(K,m){if(K.isDefault){e.setSelectedItem(e.getItems()[m]);return true;}if(!e.getSelectedItem()&&K.type!=="boolean"){e.setSelectedItem(e.getItems()[m]);}},this);if(!e.getSelectedItem()&&e.getItems().length>0){e.setSelectedItem(e.getItems()[0]);}}}else{this._aKeyFields.forEach(function(K,m){if(K.isDefault){e.setSelectedItem(e.getItems()[m]);}},this);}}}}if(h["ID"]==="operation"){e=new sap.m.Select({width:"100%",ariaLabelledBy:this._oInvisibleTextOperator,layoutData:new sap.ui.layout.GridData({span:h["Span"+this._sConditionType]})});e.attachChange(function(){d._handleChangeOnOperationField(t,o);});o[h["ID"]]=e;this._updateOperationItems(t,o);if(c){var K=this._getCurrentKeyFieldItem(o.keyField);var j=this._oTypeOperations["default"];if(K){if(K.type&&this._oTypeOperations[K.type]){j=this._oTypeOperations[K.type];}if(K.operations){j=K.operations;}}j.some(function(m,n){if(c.operation===m){e.setSelectedKey(m);return true;}},this);}else{if(this.getUsePrevConditionSetting()){if(p>0&&k===null){var g=t.getContent()[p-1];e.setSelectedKey(g.operation.getSelectedKey());}}}}if(e.getSelectedItem&&e.getSelectedItem()){e.setTooltip(e.getSelectedItem().getTooltip()||e.getSelectedItem().getText());}break;case"TextField":var l=this._getCurrentKeyFieldItem(o.keyField);e=this._createValueField(l,h,o);e.oTargetGrid=t;if(c&&c[h["ID"]]!==undefined){var v=c[h["ID"]];var V;if(e instanceof sap.m.Select){if(typeof v==="string"&&l.type==="boolean"){v=v==="true";}if(typeof v==="boolean"){e.setSelectedIndex(v?2:1);}else{e.setSelectedItem(e.getItemByKey(v.toString()));}}else{if(typeof v==="string"&&o.oFormatter instanceof sap.ui.core.format.NumberFormat){V=parseFloat(v);v=o.oFormatter.format(V);}if(typeof v==="string"&&o.oFormatter){V=o.oFormatter.parse(v);}else{V=v;}if(!isNaN(V)&&V!==null&&o.oFormatter){v=o.oFormatter.format(V);e.setValue(v);}else{if(!V&&v&&o.oFormatter instanceof sap.ui.core.format.DateFormat){V=new Date(v);v=o.oFormatter.format(V);e.setValue(v);}else{e.setValue(V);}}}}break;case"Label":e=new sap.m.Label({text:h["Text"]+":",visible:this.getShowLabel(),layoutData:new sap.ui.layout.GridData({span:h["Span"+this._sConditionType]})}).addStyleClass("conditionLabel");e.oTargetGrid=t;break;}o[h["ID"]]=e;o.addContent(e);}b=new sap.ui.layout.HorizontalLayout({layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L2 M2 S2":this._oButtonGroupSpan["Span"+this._sConditionType]})}).addStyleClass("floatRight");o.addContent(b);o["ButtonContainer"]=b;var r=new sap.m.Button({type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI("sys-cancel"),tooltip:this._oRb.getText("CONDITIONPANEL_REMOVE"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){d._handleRemoveCondition(this.oTargetGrid,o);},layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M2 S2"})});r.oTargetGrid=t;b.addContent(r);o["remove"]=r;var A=new sap.m.Button({type:sap.m.ButtonType.Transparent,icon:sap.ui.core.IconPool.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){d._handleAddCondition(this.oTargetGrid,o);},layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M10 S10"})});A.oTargetGrid=t;A.addStyleClass("conditionAddBtnFloatRight");b.addContent(A);o["add"]=A;t.insertContent(o,p);this._updateOperationItems(t,o);this._changeOperationValueFields(t,o);this._updateAllConditionsEnableStates();this._updateConditionButtons(t);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false);}if(this._sLayoutMode){this._updateLayout({name:this._sLayoutMode});}if(c){var s=this._getFormatedConditionText(c.operation,c.value1,c.value2,c.exclude,c.keyField,c.showIfGrouped);c._oGrid=o;c.value=s;this._oConditionsMap[k]=c;}return o;};P.prototype._handleRemoveCondition=function(t,c){var i=t.getContent().indexOf(c);this._removeCondition(t,c);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false);}if(i>=0){i=Math.min(i,t.getContent().length-1);var c=t.getContent()[i];setTimeout(function(){c.remove.focus();});}this._updatePaginatorToolbar();};P.prototype._handleAddCondition=function(t,s){var p=t.getContent().indexOf(s);var c=this._createConditionRow(t,undefined,null,p+1);this._changeField(c);setTimeout(function(){c.keyField.focus();});this._updatePaginatorToolbar();};P.prototype._getCurrentKeyFieldItem=function(k){if(k.getSelectedKey&&k.getSelectedKey()){var K=k.getSelectedKey();var i=this._aKeyFields;for(var b in i){var o=i[b];if(o.key===K){return o;}}}return null;};P.prototype._createValueField=function(c,f,o){var b;var s=c?c.type:"";var t=this;var p={value:f["Value"],width:"100%",placeholder:f["Label"],change:function(e){t._validateFormatFieldValue(e);t._changeField(o);},layoutData:new sap.ui.layout.GridData({span:f["Span"+this._sConditionType]})};switch(s){case"boolean":case"enum":var d=[];var v=c.values||this._oTypeValues[s]||["",false,true];v.forEach(function(V,i){d.push(new sap.ui.core.Item({key:s==="boolean"?(i===v.length-1).toString():V.toString(),text:V.toString()}));});p={width:"100%",items:d,change:function(){t._changeField(o);},layoutData:new sap.ui.layout.GridData({span:f["Span"+this._sConditionType]})};o.oFormatter=null;b=new sap.m.Select(p);break;case"numeric":var F;if(c.precision||c.scale){F={};if(c.precision){F["maxIntegerDigits"]=parseInt(c.precision,10);}if(c.scale){F["maxFractionDigits"]=parseInt(c.scale,10);}}o.oFormatter=N.getFloatInstance(F);b=new sap.m.Input(p);break;case"date":o.oFormatter=D.getDateInstance();b=new sap.m.DatePicker(p);break;case"time":o.oFormatter=D.getTimeInstance();b=new sap.m.TimePicker(p);break;default:o.oFormatter=null;b=new sap.m.Input(p);if(this._fSuggestCallback){var c=this._getCurrentKeyFieldItem(o.keyField);if(c&&c.key){var S=this._fSuggestCallback(b,c.key);if(S){b._oSuggestProvider=S;}}}}if(s!=="boolean"&&s!=="enum"){b.onpaste=function(e){var O;if(window.clipboardData){O=window.clipboardData.getData("Text");}else{O=e.originalEvent.clipboardData.getData('text/plain');}var o=e.srcControl.getParent();var g=O.split(/\r\n|\r|\n/g);if(g){setTimeout(function(){var L=g?g.length:0;if(L>1){var k=t._getCurrentKeyFieldItem(o.keyField);var h=o.operation;for(var i=0;i<L;i++){if(t._aConditionKeys.length>=t._getMaxConditionsAsNumber()){break;}if(g[i]){var j={"key":t._createConditionKey(),"exclude":t.getExclude(),"operation":h.getSelectedKey(),"keyField":k.key,"value1":g[i],"value2":null};t._addCondition2Map(j);t.fireDataChange({key:j.key,index:j.index,operation:"add",newData:j});}}t._clearConditions();t._fillConditions();}},0);}};}if(c&&c.maxLength&&b.setMaxLength){var l=-1;if(typeof c.maxLength==="string"){l=parseInt(c.maxLength,10);}if(typeof c.maxLength==="number"){l=c.maxLength;}if(l>0&&(!b.getShowSuggestion||!b.getShowSuggestion())){b.setMaxLength(l);}}return b;};P.prototype._fillOperationListItems=function(c,o,t){if(t==="_STRING_"){t="";}if(t==="_TIME_"){t="_DATE_";}if(t==="_BOOLEAN_"){t="";}c.destroyItems();for(var O in o){var T=this._oRb.getText("CONDITIONPANEL_OPTION"+t+o[O]);if(q.sap.startsWith(T,"CONDITIONPANEL_OPTION")){T=this._oRb.getText("CONDITIONPANEL_OPTION"+o[O]);}c.addItem(new sap.ui.core.ListItem({key:o[O],text:T,tooltip:T}));}};P.prototype._fillKeyFieldListItems=function(c,i){c.destroyItems();for(var b in i){var o=i[b];c.addItem(new sap.ui.core.ListItem({key:o.key,text:o.text,tooltip:o.tooltip?o.tooltip:o.text}));}};P.prototype._handleChangeOnOperationField=function(t,c){this._changeOperationValueFields(t,c);this._changeField(c);};P.prototype._handleSelectionChangeOnKeyField=function(t,c){if(this._sConditionType==="Filter"){this._updateOperationItems(t,c);this._createAndUpdateValueFields(t,c);this._changeOperationValueFields(t,c);}this._changeField(c);};P.prototype._handleChangeOnKeyField=function(t,c){if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false,false,c.keyField);}};P.prototype._createAndUpdateAllKeyFields=function(){var c=this._oConditionsGrid.getContent();c.forEach(function(o){this._createAndUpdateValueFields(this._oConditionsGrid,o);this._changeOperationValueFields(this._oConditionsGrid,o);},this);};P.prototype._createAndUpdateValueFields=function(t,c){var o=this._getCurrentKeyFieldItem(c.keyField);var f=function(c,b,i){var O=b.getValue?b.getValue():"";var d=c.indexOfContent(b);c.removeContent(b);if(b._oSuggestProvider){b._oSuggestProvider.destroy();b._oSuggestProvider=null;}b.destroy();var e=this._aConditionsFields[i];b=this._createValueField(o,e,c);c[e["ID"]]=b;c.insertContent(b,d);var v,V;if(c.oFormatter&&O){v=c.oFormatter.parse(O);if(!isNaN(v)&&v!==null){V=c.oFormatter.format(v);b.setValue(V);}}if(!V){b.setValue(O);}};q.proxy(f,this)(c,c.value1,5);q.proxy(f,this)(c,c.value2,6);};P.prototype._updateAllOperations=function(){var c=this._oConditionsGrid.getContent();c.forEach(function(o){this._updateOperationItems(this._oConditionsGrid,o);this._changeOperationValueFields(this._oConditionsGrid,o);},this);};P.prototype._updateOperationItems=function(t,c){var T="";var k=this._getCurrentKeyFieldItem(c.keyField);var o=c.operation;var O=this._oTypeOperations["default"];var b=o.getSelectedItem();if(k&&!this.getExclude()){if(k.type&&k.type!==""&&this._oTypeOperations[k.type]){T=k.type;O=this._oTypeOperations[T];}if(k.operations){O=k.operations;}}this._fillOperationListItems(o,O,T?"_"+T.toUpperCase()+"_":"");if(b&&o.getItemByKey(b.getKey())){o.setSelectedKey(b.getKey());}else{o.setSelectedItem(o.getItems()[0]);}this._sConditionType="Filter";if(O[0]===sap.m.P13nConditionOperation.Ascending||O[0]===sap.m.P13nConditionOperation.Descending){this._sConditionType="Sort";}if(O[0]===sap.m.P13nConditionOperation.GroupAscending||O[0]===sap.m.P13nConditionOperation.GroupDescending){this._sConditionType="Group";}this._adjustValue1Span(c);};P.prototype._updateKeyFieldItems=function(t,f,A,o){var n=t.getContent().length;var i;var u={};if(!f){for(i=0;i<n;i++){var k=t.getContent()[i].keyField;var K=k.getSelectedKey();if(K!=null&&K!==""){u[K]=true;}}}for(i=0;i<n;i++){var k=t.getContent()[i].keyField;var s=t.getContent()[i].select;var O=k.getSelectedKey();var j=0;var b=this._aKeyFields;if(k!==o){if(A){j=b.length-1;}else{k.destroyItems();}for(j;j<b.length;j++){var c=b[j];if(c.key==null||c.key===""||!u[c.key]||c.key===O){k.addItem(new sap.ui.core.ListItem({key:c.key,text:c.text,tooltip:c.tooltip?c.tooltip:c.text}));}}}if(O){k.setSelectedKey(O);}else if(k.getItems().length>0){k.setSelectedItem(k.getItems()[0]);}if(!s.getSelected()){this._aKeyFields.some(function(d,e){if(d.isDefault){k.setSelectedItem(k.getItems()[e]);return true;}if(!k.getSelectedItem()){if(d.type!=="boolean"){k.setSelectedItem(k.getItems()[e]);}}},this);}if(k.getSelectedItem()){k.setTooltip(k.getSelectedItem().getTooltip()||k.getSelectedItem().getText());}}};P.prototype._changeOperationValueFields=function(t,c){var o=c.operation;var O=o.getSelectedKey();var v=c.value1;var V=c.value2;var s=c.showIfGrouped;if(!O){return;}if(O===sap.m.P13nConditionOperation.BT){if(v.setPlaceholder&&v.getPlaceholder()!==this._sFromLabelText){v.setPlaceholder(this._sFromLabelText);}if(!v.getVisible()){v.setVisible(true);c.insertContent(v,c.getContent().length-1);}if(V.setPlaceholder&&V.getPlaceholder()!==this._sToLabelText){V.setPlaceholder(this._sToLabelText);}if(!V.getVisible()){V.setVisible(true);c.insertContent(V,c.getContent().length-1);}}else{if(O===sap.m.P13nConditionOperation.GroupAscending||O===sap.m.P13nConditionOperation.GroupDescending){if(v.getVisible()){v.setVisible(false);c.removeContent(v);}if(V.getVisible()){V.setVisible(false);c.removeContent(V);}if(o.getVisible()){o.setVisible(false);c.removeContent(o);}s.setVisible(this._getMaxConditionsAsNumber()!=1);}else{if(O===sap.m.P13nConditionOperation.NotEmpty||O===sap.m.P13nConditionOperation.Empty||O===sap.m.P13nConditionOperation.Initial||O===sap.m.P13nConditionOperation.Ascending||O===sap.m.P13nConditionOperation.Descending||O===sap.m.P13nConditionOperation.Total||O===sap.m.P13nConditionOperation.Average||O===sap.m.P13nConditionOperation.Minimum||O===sap.m.P13nConditionOperation.Maximum){if(v.getVisible()){v.setVisible(false);c.removeContent(v);}if(V.getVisible()){V.setVisible(false);c.removeContent(V);}c.removeContent(s);}else{if(v.setPlaceholder&&v.getPlaceholder()!==this._sValueLabelText){v.setPlaceholder(this._sValueLabelText);}if(!v.getVisible()){v.setVisible(true);c.insertContent(v,c.getContent().length-1);}if(V.getVisible()){V.setVisible(false);c.removeContent(V);}}}}this._adjustValue1Span(c);};P.prototype._adjustValue1Span=function(c){if(this._sConditionType==="Filter"&&c.value1&&c.operation){var o=c.operation;var n=this._aConditionsFields[5]["Span"+this._sConditionType];if(o.getSelectedKey()!=="BT"){n="L5 M10 S10";}var l=c.value1.getLayoutData();if(l.getSpan()!==n){l.setSpan(n);}}};P.prototype._getIndexOfCondition=function(c){var i=-1;c.getParent().getContent().some(function(g){if(g.select.getSelected()){i++;}return(g===c);},this);return i+this._iFirstConditionIndex;};P.prototype._makeFieldValid=function(c,v){if(v){c.setValueState(sap.ui.core.ValueState.None);c.setValueStateText("");}else{c.setValueState(sap.ui.core.ValueState.Warning);c.setValueStateText(this._sValidationDialogFieldMessage);}};P.prototype._validateFormatFieldValue=function(e){var c=e.oSource;var o=c.getParent();var v;if(c.getDateValue&&e){v=e.getParameter("value");var V=e.getParameter("valid");this._makeFieldValid(c,V);return;}else{v=c.getValue&&c.getValue();}if(!o){return;}if(this.getDisplayFormat()==="UpperCase"&&v){v=v.toUpperCase();c.setValue(v);}if(o.oFormatter&&v){var b=o.oFormatter.parse(v);var V=!isNaN(b)&&b!==null;this._makeFieldValid(c,V);if(V){v=o.oFormatter.format(b);c.setValue(v);}}else{this._makeFieldValid(c,true);}};P.prototype._changeField=function(c,e){var k=c.keyField.getSelectedKey();if(c.keyField.getSelectedItem()){c.keyField.setTooltip(c.keyField.getSelectedItem().getTooltip()||c.keyField.getSelectedItem().getText());}else{c.keyField.setTooltip(null);}var o=c.operation.getSelectedKey();if(c.operation.getSelectedItem()){c.operation.setTooltip(c.operation.getSelectedItem().getTooltip()||c.operation.getSelectedItem().getText());}else{c.operation.setTooltip(null);}var v=this._getValueTextFromField(c.value1,c.oFormatter);var V=v;if(c.oFormatter&&v){V=c.oFormatter.parse(v);if(isNaN(V)||V===null){v="";}}var s=this._getValueTextFromField(c.value2,c.oFormatter);var b=s;if(c.oFormatter&&s){b=c.oFormatter.parse(s);if(isNaN(b)||b===null){s="";}}var d=this._getCurrentKeyFieldItem(c.keyField);var f=d?d.type:"";if(f==="boolean"){var g=d.values||this._oTypeValues[f]||["",false,true];var t=g[g.length-1].toString();V=v===t;b=null;}var S=c.showIfGrouped.getSelected();var E=this.getExclude();var h=c.select;var i="";var K;if(k===""||k==null){k=null;K=this._getKeyFromConditionGrid(c);this._removeConditionFromMap(K);this._enableCondition(c,false);var j=this._getIndexOfCondition(c);if(h.getSelected()){h.setSelected(false);h.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:K,index:j,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}return;}this._enableCondition(c,true);i=this._getFormatedConditionText(o,v,s,E,k,S);var l={"value":i,"exclude":E,"operation":o,"keyField":k,"value1":V,"value2":o===sap.m.P13nConditionOperation.BT?b:null,"showIfGrouped":S};K=this._getKeyFromConditionGrid(c);if(i!==""){h.setSelected(true);h.setEnabled(true);var o="update";if(!this._oConditionsMap[K]){o="add";}this._oConditionsMap[K]=l;if(o==="add"){this._aConditionKeys.splice(this._getIndexOfCondition(c),0,K);}c.data("_key",K);this.fireDataChange({key:K,index:this._getIndexOfCondition(c),operation:o,newData:l});}else if(this._oConditionsMap[K]!==undefined){this._removeConditionFromMap(K);c.data("_key",null);var j=this._getIndexOfCondition(c);if(h.getSelected()){h.setSelected(false);h.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:K,index:j,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}}this._updatePaginatorToolbar();};P.prototype._getValueTextFromField=function(c,f){if(c.getDateValue&&c.getDateValue()){return f.format(c.getDateValue());}if(c instanceof sap.m.Select){return c.getSelectedItem()?c.getSelectedItem().getText():"";}return c.getValue();};P.prototype._updateAllConditionsEnableStates=function(){var c=this._oConditionsGrid.getContent();c.forEach(function(o){var k=this._getCurrentKeyFieldItem(o.keyField);var K=k&&k.key!==undefined?k.key:k;var e=K!==""&&K!==null;this._enableCondition(o,e);},this);};P.prototype._enableCondition=function(c,e){c.operation.setEnabled(e);c.value1.setEnabled(e);c.value2.setEnabled(e);c.showIfGrouped.setEnabled(e);};P.prototype._removeCondition=function(t,c){var k=this._getKeyFromConditionGrid(c);var i=-1;if(c.select.getSelected()){i=this._getIndexOfCondition(c);}this._removeConditionFromMap(k);c.destroy();if(t.getContent().length<1){this._createConditionRow(t);}else{this._updateConditionButtons(t);}if(i>=0){this.fireDataChange({key:k,index:i,operation:"remove",newData:null});}};P.prototype._updateConditionButtons=function(t){var m=this._getMaxConditionsAsNumber();var n=t.getContent().length;for(var i=0;i<n;i++){var A=t.getContent()[i].add;if((this.getAlwaysShowAddIcon()&&(n<m))||(i===n-1&&i<m-1)){A.removeStyleClass("displayNone");}else{A.addStyleClass("displayNone");}var r=t.getContent()[i].remove;if(m===1||(i===0&&n===1&&this.getDisableFirstRemoveIcon())){r.addStyleClass("displayNone");}else{r.removeStyleClass("displayNone");}}};P.prototype.validateConditions=function(){var t=this;var c=function(g){var v=true;for(var i=0;i<g.length;i++){var G=g[i];var b=t._checkCondition(G,i===g.length-1);v=v&&b;}return v;};return c(this._oConditionsGrid.getContent());};P.prototype.removeValidationErrors=function(){this._oConditionsGrid.getContent().forEach(function(c){var v=c.value1;var V=c.value2;v.setValueState(sap.ui.core.ValueState.None);v.setValueStateText("");V.setValueState(sap.ui.core.ValueState.None);V.setValueStateText("");},this);};P.prototype.removeInvalidConditions=function(){var i=[];this._oConditionsGrid.getContent().forEach(function(c){if(c.value1.getValueState()!==sap.ui.core.ValueState.None||c.value2.getValueState()!==sap.ui.core.ValueState.None){i.push(c);}},this);i.forEach(function(c){this._removeCondition(this._oConditionsGrid,c);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(this._oConditionsGrid,false);}},this);};P.prototype._checkCondition=function(c,i){var v=true;var b=c.value1;var d=c.value2;var V=b&&(b.getVisible()&&!this._getValueTextFromField(b,c.oFormatter));var e=b&&b.getVisible()&&b.getValueState?b.getValueState():sap.ui.core.ValueState.None;var f=d&&(d.getVisible()&&!this._getValueTextFromField(d,c.oFormatter));var g=d&&d.getVisible()&&d.getValueState?d.getValueState():sap.ui.core.ValueState.None;var o=c.operation.getSelectedKey();if(o===sap.m.P13nConditionOperation.BT){if(!V?f:!f){if(V){b.setValueState(sap.ui.core.ValueState.Warning);b.setValueStateText(this._sValidationDialogFieldMessage);}if(f){d.setValueState(sap.ui.core.ValueState.Warning);d.setValueStateText(this._sValidationDialogFieldMessage);}v=false;}else if(e!==sap.ui.core.ValueState.None||g!==sap.ui.core.ValueState.None){v=false;}else{b.setValueState(sap.ui.core.ValueState.None);b.setValueStateText("");d.setValueState(sap.ui.core.ValueState.None);d.setValueStateText("");}}if((b.getVisible()&&b.getValueState&&b.getValueState()!==sap.ui.core.ValueState.None)||(d.getVisible()&&d.getValueState&&d.getValueState()!==sap.ui.core.ValueState.None)){v=false;}return v;};P.prototype._getFormatedConditionText=function(o,v,V,e,k,s){var c="";var K=null;if(this._aKeyFields&&this._aKeyFields.length>1){for(var i=0;i<this._aKeyFields.length;i++){var b=this._aKeyFields[i];if(typeof b!=="string"){if(b.key===k&&b.text){K=b.text;}}}}switch(o){case sap.m.P13nConditionOperation.EQ:if(v!==""&&v!==undefined){c="="+v;}break;case sap.m.P13nConditionOperation.GT:if(v!==""&&v!==undefined){c=">"+v;}break;case sap.m.P13nConditionOperation.GE:if(v!==""&&v!==undefined){c=">="+v;}break;case sap.m.P13nConditionOperation.LT:if(v!==""&&v!==undefined){c="<"+v;}break;case sap.m.P13nConditionOperation.LE:if(v!==""&&v!==undefined){c="<="+v;}break;case sap.m.P13nConditionOperation.Contains:if(v!==""&&v!==undefined){c="*"+v+"*";}break;case sap.m.P13nConditionOperation.StartsWith:if(v!==""&&v!==undefined){c=v+"*";}break;case sap.m.P13nConditionOperation.EndsWith:if(v!==""&&v!==undefined){c="*"+v;}break;case sap.m.P13nConditionOperation.BT:if(v!==""&&v!==undefined){if(V!==""){c=v+"..."+V;}}break;case sap.m.P13nConditionOperation.Initial:c="=''";break;case sap.m.P13nConditionOperation.Empty:c="''";break;case sap.m.P13nConditionOperation.NotEmpty:c="!''";break;case sap.m.P13nConditionOperation.Ascending:c="ascending";break;case sap.m.P13nConditionOperation.GroupAscending:c="ascending";c+=" showIfGrouped:"+s;break;case sap.m.P13nConditionOperation.Descending:c="descending";break;case sap.m.P13nConditionOperation.GroupDescending:c="descending";c+=" showIfGrouped:"+s;break;case sap.m.P13nConditionOperation.Total:c="total";break;case sap.m.P13nConditionOperation.Average:c="average";break;case sap.m.P13nConditionOperation.Minimum:c="minimum";break;case sap.m.P13nConditionOperation.Maximum:c="maximum";break;}if(e&&c!==""){c="!("+c+")";}if(K&&c!==""){c=K+": "+c;}return c;};P.prototype._updateLayout=function(r){if(!this._oConditionsGrid){return;}var g=this._oConditionsGrid.getContent();var n=this._aConditionsFields.length;var b=n;if(r.name==="Tablet"){b=5;}if(r.name==="Phone"){b=3;}if(this._sConditionType==="Filter"){for(var i=0;i<g.length;i++){var c=g[i];c.ButtonContainer.removeStyleClass("floatRight");c.removeContent(c.ButtonContainer);c.insertContent(c.ButtonContainer,b);if(!this.getAlwaysShowAddIcon()){if(b!==n){c.ButtonContainer.removeContent(c.add);c.addContent(c.add);}else{c.removeContent(c.add);c.ButtonContainer.addContent(c.add);}}}}};P.prototype._onGridResize=function(){if(this._oPaginatorToolbar&&this._oConditionsGrid&&this._oConditionsGrid.getContent().length>0){var g=this._oConditionsGrid.getContent()[0];if(g.remove&&g.remove.$().position()){var w=0;if(this._oPaginatorToolbar.getParent()&&this._oPaginatorToolbar.getParent().getExpandable&&this._oPaginatorToolbar.getParent().getExpandable()){w=48-4;}var t=g.remove.$().position().left-w+g.remove.$().width();this._oPaginatorToolbar.setWidth(t+"px");}}var d=this._oConditionsGrid.getDomRef();if(!d){return;}if(!q(d).is(":visible")){return;}var w=d.clientWidth;var r={};if(w<=this._iBreakPointTablet){r.name="Phone";}else if((w>this._iBreakPointTablet)&&(w<=this._iBreakPointDesktop)){r.name="Tablet";}else{r.name="Desktop";}if(r.name==="Phone"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}if(r.name==="Tablet"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}if(r.name==="Desktop"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}};sap.m.P13nConditionOperation={BT:"BT",EQ:"EQ",Contains:"Contains",StartsWith:"StartsWith",EndsWith:"EndsWith",LT:"LT",LE:"LE",GT:"GT",GE:"GE",Initial:"Initial",Empty:"Empty",NotEmpty:"NotEmpty",Ascending:"Ascending",Descending:"Descending",GroupAscending:"GroupAscending",GroupDescending:"GroupDescending",Total:"Total",Average:"Average",Minimum:"Minimum",Maximum:"Maximum"};return P;},true);
