/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','./PlanningCalendarRow','./library','sap/ui/unified/library','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarWeekInterval','sap/ui/unified/CalendarOneMonthInterval'],function(q,C,L,P,l,u,a,b,c,d){"use strict";var e=C.extend("sap.m.PlanningCalendar",{metadata:{library:"sap.m",properties:{startDate:{type:"object",group:"Data"},viewKey:{type:"string",group:"Appearance",defaultValue:sap.ui.unified.CalendarIntervalType.Hour},singleSelection:{type:"boolean",group:"Misc",defaultValue:true},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showRowHeaders:{type:"boolean",group:"Appearance",defaultValue:true},noDataText:{type:"string",group:"Misc",defaultValue:null},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:sap.ui.unified.CalendarAppointmentVisualization.Standard},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{rows:{type:"sap.m.PlanningCalendarRow",multiple:true,singularName:"row"},views:{type:"sap.m.PlanningCalendarView",multiple:true,singularName:"view"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},toolbarContent:{type:"sap.ui.core.Control",multiple:true,singularName:"toolbarContent"},table:{type:"sap.m.Table",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{appointmentSelect:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"},row:{type:"sap.m.PlanningCalendarRow"}}},rowSelectionChange:{parameters:{rows:{type:"sap.m.PlanningCalendarRow[]"}}},startDateChange:{},viewChange:{},rowHeaderClick:{row:{type:"sap.m.PlanningCalendarRow"}}}}});var I=["_oTimeInterval","_oDateInterval","_oMonthInterval","_oWeekInterval","_oOneMonthInterval"],f={};f[sap.ui.unified.CalendarIntervalType.Day]={sInstanceName:"_oDateInterval",sIdSuffix:"-DateInt",oClass:b};f[sap.ui.unified.CalendarIntervalType.Week]={sInstanceName:"_oWeekInterval",sIdSuffix:"-WeekInt",oClass:c};f[sap.ui.unified.CalendarIntervalType.OneMonth]={sInstanceName:"_oOneMonthInterval",sIdSuffix:"-OneMonthInt",oClass:d};var A=sap.m.ScreenSize.Desktop;var g=sap.ui.core.Control.extend("CalendarHeader",{metadata:{aggregations:{"toolbar":{type:"sap.m.Toolbar",multiple:false},"allCheckBox":{type:"sap.m.CheckBox",multiple:false}}},renderer:function(R,H){R.write("<div");R.writeControlData(H);R.addClass("sapMPlanCalHead");R.writeClasses();R.write(">");var T=H.getToolbar();if(T){R.renderControl(T);}var i=H.getAllCheckBox();if(i){R.renderControl(i);}R.write("</div>");}});e.prototype.init=function(){this._iBreakPointTablet=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];if(sap.ui.Device.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){this._iSize=0;this._iSizeScreen=0;}else if(sap.ui.Device.system.tablet||q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSize=1;this._iSizeScreen=1;}else{this._iSize=2;this._iSizeScreen=2;}this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=this.getId();this._oIntervalTypeSelect=new sap.m.Select(i+"-IntType",{maxWidth:"15rem",ariaLabelledBy:i+"-SelDescr"});this._oIntervalTypeSelect.attachEvent("change",_,this);this._oTodayButton=new sap.m.Button(i+"-Today",{text:this._oRB.getText("PLANNINGCALENDAR_TODAY"),type:sap.m.ButtonType.Transparent});this._oTodayButton.attachEvent("press",this._handleTodayPress,this);this._oHeaderToolbar=new sap.m.Toolbar(i+"-HeaderToolbar",{design:sap.m.ToolbarDesign.Transparent,content:[this._oIntervalTypeSelect,this._oTodayButton]});this._oCalendarHeader=new g(i+"-CalHead",{toolbar:this._oHeaderToolbar});this._oInfoToolbar=new sap.m.Toolbar(i+"-InfoToolbar",{height:"auto",design:sap.m.ToolbarDesign.Transparent,content:[this._oCalendarHeader,this._oTimeInterval]});var T=new sap.m.Table(i+"-Table",{infoToolbar:this._oInfoToolbar,mode:sap.m.ListMode.SingleSelectMaster,columns:[new sap.m.Column({styleClass:"sapMPlanCalRowHead"}),new sap.m.Column({width:"80%",styleClass:"sapMPlanCalAppRow",minScreenWidth:A,demandPopin:true})],ariaLabelledBy:i+"-Descr"});T.attachEvent("selectionChange",n,this);T.addDelegate({onBeforeRendering:function(){if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();}},onAfterRendering:function(){this._rowHeaderClickEvent=T.$().find(".sapMPlanCalRowHead > div.sapMLIB").click(function(E){var R=q(E.currentTarget).control(0),j=sap.ui.getCore().byId(R.getAssociation("parentRow"));this.fireRowHeaderClick({row:j});}.bind(this));}},false,this);this.setAggregation("table",T,true);this.setStartDate(new Date());this._resizeProxy=q.proxy(k,this);};e.prototype.exit=function(){if(this._sResizeListener){sap.ui.core.ResizeHandler.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}var T=this.getAggregation("table");T.removeAllItems();I.forEach(function(j){if(this[j]){this[j]._oPlanningCalendar=undefined;this[j].destroy();this[j]=undefined;}},this);if(this._aViews){for(var i=0;i<this._aViews.length;i++){this._aViews[i].destroy();}}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.destroy();}if(this.getToolbarContent().length==0&&this._oToolbar){this._oToolbar.destroy();this._oToolbar=undefined;}if(this._rowHeaderClickEvent){this._rowHeaderClickEvent.off();this._rowHeaderClickEvent=null;}};e.prototype.onBeforeRendering=function(){this._bBeforeRendering=true;if((!this._oTimeInterval&&!this._oDateInterval&&!this._oMonthInterval&&!this._oWeekInterval&&!this._oOneMonthInterval)||this._bCheckView){this.setViewKey(this.getViewKey());this._bCheckView=undefined;}s.call(this);if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}this._updateTodayButtonState();this._bBeforeRendering=undefined;};e.prototype._updateTodayButtonState=function(){if(this._oTodayButton){this._oTodayButton.setEnabled(!this._dateMatchesVisibleRange(new Date(),this.getViewKey()));}};e.prototype._dateMatchesVisibleRange=function(i,V){var j=this._getView(V,!this._bBeforeRendering);if(!j){return false;}var E=j.getIntervalType(),F=f[E],G=F?this[F.sInstanceName]:null,R=false;if(G&&G._dateMatchesVisibleRange){R=G._dateMatchesVisibleRange(i);}return R;};e.prototype.onAfterRendering=function(E){E.size={width:this.getDomRef().offsetWidth};k.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=sap.ui.core.ResizeHandler.register(this,this._resizeProxy);}this._updateCurrentTimeVisualization(false);};e.prototype.setStartDate=function(S){var F,i;if(!S){S=new Date();}if(!(S instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}if(this.getViewKey()===sap.ui.unified.CalendarIntervalType.Week){F=a.getFirstDateOfWeek(a._createUniversalUTCDate(S,undefined,true));S.setTime(a._createLocalDate(F,true).getTime());}if(this.getViewKey()===sap.ui.unified.CalendarIntervalType.OneMonth){i=a.getFirstDateOfMonth(a._createUniversalUTCDate(S,undefined,true));S.setTime(a._createLocalDate(i,true).getTime());}if(q.sap.equal(S,this.getStartDate())){this._updateTodayButtonState();return this;}var Y=S.getFullYear();if(Y<1||Y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}var M=this.getMinDate();if(M&&M.getTime()>S.getTime()){q.sap.log.warning("StartDate < minDate -> StartDate set to minDate",this);S=new Date(M.getTime());}else{var j=this.getMaxDate();if(j&&j.getTime()<S.getTime()){q.sap.log.warning("StartDate > maxDate -> StartDate set to minDate",this);if(M){S=new Date(M.getTime());}else{S=new Date(1,0,1);S.setFullYear(1);}}}this.setProperty("startDate",S,true);I.forEach(function(E){if(this[E]){this[E].setStartDate(new Date(S.getTime()));}},this);this._setRowsStartDate(new Date(S.getTime()));if(this.getViewKey()===sap.ui.unified.CalendarIntervalType.Week||this.getViewKey()===sap.ui.unified.CalendarIntervalType.OneMonth){this._updateTodayButtonState();}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);}return this;};e.prototype.setMinDate=function(i){if(q.sap.equal(i,this.getMinDate())){return this;}var M=this.getMaxDate();if(i){if(!(i instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var Y=i.getFullYear();if(Y<1||Y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this.setProperty("minDate",i,true);this._bNoStartDateChange=true;I.forEach(function(j){if(this[j]){this[j].setMinDate(new Date(i.getTime()));}},this);if(M&&M.getTime()<i.getTime()){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);M=new Date(i.getTime());M.setMonth(M.getMonth()+1,0);M.setHours(23);M.setMinutes(59);M.setSeconds(59);M.setMilliseconds(0);this.setMaxDate(M);}this._bNoStartDateChange=undefined;var S=this.getStartDate();if(S&&S.getTime()<i.getTime()){q.sap.log.warning("StartDate < minDate -> StartDate set to minDate",this);S=new Date(i.getTime());this.setStartDate(S);}}else{this.setProperty("minDate",undefined,true);I.forEach(function(j){if(this[j]){this[j].setMinDate();}},this);}var T=new Date();if(i&&T.getTime()<i.getTime()){this._oTodayButton.setVisible(false);}else if(!M||T.getTime()<M.getTime()){this._oTodayButton.setVisible(true);}return this;};e.prototype.setMaxDate=function(i){if(q.sap.equal(i,this.getMaxDate())){return this;}var M=this.getMinDate();if(i){if(!(i instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}var Y=i.getFullYear();if(Y<1||Y>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}this.setProperty("maxDate",i,true);this._bNoStartDateChange=true;I.forEach(function(j){if(this[j]){this[j].setMaxDate(new Date(i.getTime()));}},this);if(M&&M.getTime()>i.getTime()){q.sap.log.warning("maxDate < minDate -> maxDate set to begin of the month",this);M=new Date(i.getTime());M.setUTCDate(1);M.setHours(0);M.setMinutes(0);M.setSeconds(0);M.setMilliseconds(0);this.setMinDate(M);}this._bNoStartDateChange=undefined;var S=this.getStartDate();if(S&&S.getTime()>i.getTime()){q.sap.log.warning("StartDate > maxDate -> StartDate set to minDate",this);if(M){S=new Date(M.getTime());}else{S=new Date(1,0,1);S.setFullYear(1);}this.setStartDate(S);}}else{this.setProperty("maxDate",undefined,true);I.forEach(function(j){if(this[j]){this[j].setMaxDate();}},this);}var T=new Date();if(i&&T.getTime()>i.getTime()){this._oTodayButton.setVisible(false);}else if(!M||T.getTime()>M.getTime()){this._oTodayButton.setVisible(true);}return this;};e.prototype.setViewKey=function(K){var j,O,E,F=this.getViewKey(),S;this.setProperty("viewKey",K,true);this._oIntervalTypeSelect.setSelectedKey(K);if(this._oInfoToolbar.getContent().length>1){this._oInfoToolbar.removeContent(1);}if(K===sap.ui.unified.CalendarIntervalType.Week||K===sap.ui.unified.CalendarIntervalType.OneMonth){O=this.getStartDate();this.setStartDate(new Date(O.getTime()));if(O.getTime()!==this.getStartDate().getTime()){this.fireStartDateChange();}}var G=this.getStartDate();var M=this.getMinDate();var H=this.getMaxDate();var V=this._getView(K,!this._bBeforeRendering);if(!V){this._bCheckView=true;this.invalidate();}else{var J=V.getIntervalType();var N=this._getIntervals(V);this._bCheckView=false;switch(J){case sap.ui.unified.CalendarIntervalType.Hour:if(!this._oTimeInterval){this._oTimeInterval=new sap.ui.unified.CalendarTimeInterval(this.getId()+"-TimeInt",{startDate:new Date(G.getTime()),items:N,pickerPopup:true});this._oTimeInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oTimeInterval.attachEvent("select",this._handleCalendarSelect,this);this._oTimeInterval._oPlanningCalendar=this;this._oTimeInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(M){this._oTimeInterval.setMinDate(new Date(M.getTime()));}if(H){this._oTimeInterval.setMaxDate(new Date(H.getTime()));}}else if(this._oTimeInterval.getItems()!=N){this._oTimeInterval.setItems(N);}this._oInfoToolbar.addContent(this._oTimeInterval);break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:E=f[J];j=this[E.sInstanceName];if(!j){j=new E.oClass(this.getId()+E.sIdSuffix,{startDate:new Date(G.getTime()),days:N,showDayNamesLine:false,pickerPopup:true});j.attachEvent("startDateChange",this._handleStartDateChange,this);j.attachEvent("select",this._handleCalendarSelect,this);if(K===sap.ui.unified.CalendarIntervalType.OneMonth){j._setRowsStartDate=this._setRowsStartDate.bind(this);}j._oPlanningCalendar=this;j.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(M){j.setMinDate(new Date(M.getTime()));}if(H){j.setMaxDate(new Date(H.getTime()));}}else if(j.getDays()!==N){j.setDays(N);}this._oInfoToolbar.addContent(j);this[E.sInstanceName]=j;break;case sap.ui.unified.CalendarIntervalType.Month:if(!this._oMonthInterval){this._oMonthInterval=new sap.ui.unified.CalendarMonthInterval(this.getId()+"-MonthInt",{startDate:new Date(G.getTime()),months:N,pickerPopup:true});this._oMonthInterval.attachEvent("startDateChange",this._handleStartDateChange,this);this._oMonthInterval.attachEvent("select",this._handleCalendarSelect,this);this._oMonthInterval._oPlanningCalendar=this;this._oMonthInterval.getSpecialDates=function(){return this._oPlanningCalendar.getSpecialDates();};if(M){this._oMonthInterval.setMinDate(new Date(M.getTime()));}if(H){this._oMonthInterval.setMaxDate(new Date(H.getTime()));}}else if(this._oMonthInterval.setMonths()!=N){this._oMonthInterval.setMonths(N);}this._oInfoToolbar.addContent(this._oMonthInterval);break;default:throw new Error("Unknown IntervalType: "+J+"; "+this);}var R=this.getRows();for(var i=0;i<R.length;i++){var Q=R[i];var T=Q.getCalendarRow();T.setIntervalType(J);T.setIntervals(N);T.setShowSubIntervals(V.getShowSubIntervals());}if(this.getDomRef()){this._updateCurrentTimeVisualization(false);}}if(this._oOneMonthInterval&&K===sap.ui.unified.CalendarIntervalType.OneMonth){this._oOneMonthInterval._setDisplayMode(this._iSize);this._oOneMonthInterval._adjustSelectedDate(O);if(this._iSize<2){this._setRowsStartDate(O);}}else if(this._oOneMonthInterval&&F===sap.ui.unified.CalendarIntervalType.OneMonth&&this._oOneMonthInterval.getSelectedDates().length){S=this._oOneMonthInterval.getSelectedDates()[0].getStartDate();if(S){this.setStartDate(S);}}this._updateTodayButtonState();return this;};e.prototype.setShowIntervalHeaders=function(S){this.setProperty("showIntervalHeaders",S,true);var R=this.getRows();for(var i=0;i<R.length;i++){var j=R[i];j.getCalendarRow().setShowIntervalHeaders(S);}return this;};e.prototype.setShowEmptyIntervalHeaders=function(S){this.setProperty("showEmptyIntervalHeaders",S,true);var R=this.getRows();for(var i=0;i<R.length;i++){var j=R[i];j.getCalendarRow().setShowEmptyIntervalHeaders(S);}return this;};e.prototype.setAppointmentsReducedHeight=function(j){this.setProperty("appointmentsReducedHeight",j,true);var R=this.getRows();for(var i=0;i<R.length;i++){var E=R[i];E.getCalendarRow().setAppointmentsReducedHeight(j);}return this;};e.prototype.setAppointmentsVisualization=function(j){this.setProperty("appointmentsVisualization",j,true);var R=this.getRows();for(var i=0;i<R.length;i++){var E=R[i];E.getCalendarRow().setAppointmentsVisualization(j);}return this;};e.prototype.setShowRowHeaders=function(S){this.setProperty("showRowHeaders",S,true);var T=this.getAggregation("table");T.getColumns()[0].setVisible(S);this._toggleAppointmentsColumnPopinState(S);this.$().toggleClass("sapMPlanCalNoHead",!S);y.call(this);B.call(this);return this;};e.prototype.addRow=function(R){this.addAggregation("rows",R,true);R.attachEvent("_change",z,this);var T=this.getAggregation("table");T.addItem(R.getColumnListItem());var i=R.getCalendarRow();i.setStartDate(this.getStartDate());i.setShowIntervalHeaders(this.getShowIntervalHeaders());i.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());i.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());i.setLegend(this.getLegend());i.setAppointmentsVisualization(this.getAppointmentsVisualization());i.attachEvent("select",m,this);i.attachEvent("startDateChange",this._handleStartDateChange,this);i.attachEvent("leaveRow",w,this);i.attachEvent("intervalSelect",h,this);x.call(this);if(D.call(this)){var K=this.getViewKey();var V=this._getView(K);var j=V.getIntervalType();var E=this._getIntervals(V);i.setIntervalType(j);i.setIntervals(E);i.setShowSubIntervals(V.getShowSubIntervals());}B.call(this);return this;};e.prototype.insertRow=function(R,i){this.insertAggregation("rows",R,i);R.attachEvent("_change",z,this);var T=this.getAggregation("table");T.insertItem(R.getColumnListItem(),i,true);var j=R.getCalendarRow();j.setStartDate(this.getStartDate());j.setShowIntervalHeaders(this.getShowIntervalHeaders());j.setShowEmptyIntervalHeaders(this.getShowEmptyIntervalHeaders());j.setAppointmentsReducedHeight(this.getAppointmentsReducedHeight());j.setLegend(this.getLegend());j.setAppointmentsVisualization(this.getAppointmentsVisualization());j.attachEvent("select",m,this);j.attachEvent("startDateChange",this._handleStartDateChange,this);j.attachEvent("leaveRow",w,this);j.attachEvent("intervalSelect",h,this);x.call(this);if(D.call(this)){var K=this.getViewKey();var V=this._getView(K);var E=V.getIntervalType();var F=this._getIntervals(V);j.setIntervalType(E);j.setIntervals(F);j.setShowSubIntervals(V.getShowSubIntervals());}B.call(this);return this;};e.prototype.removeRow=function(O){var R=this.removeAggregation("rows",O,true);R.detachEvent("_change",z,this);var T=this.getAggregation("table");T.removeItem(R.getColumnListItem(),true);var i=R.getCalendarRow();i.detachEvent("select",m,this);i.detachEvent("startDateChange",this._handleStartDateChange,this);i.detachEvent("leaveRow",w,this);i.detachEvent("intervalSelect",h,this);x.call(this);B.call(this);return R;};e.prototype.removeAllRows=function(){var R=this.removeAllAggregation("rows",true);var T=this.getAggregation("table");T.removeAllItems(true);for(var i=0;i<R.length;i++){var j=R[i];j.detachEvent("_change",z,this);var E=j.getCalendarRow();E.detachEvent("select",m,this);E.detachEvent("startDateChange",this._handleStartDateChange,this);E.detachEvent("leaveRow",w,this);E.detachEvent("intervalSelect",h,this);}x.call(this);B.call(this);return R;};e.prototype.destroyRows=function(){var i=this.destroyAggregation("rows",true);var T=this.getAggregation("table");T.destroyItems(true);x.call(this);B.call(this);return i;};e.prototype.addToolbarContent=function(i){this.addAggregation("toolbarContent",i,true);o.call(this);return this;};e.prototype.insertToolbarContent=function(i,j){this.insertAggregation("toolbarContent",i,j);o.call(this);return this;};e.prototype.removeToolbarContent=function(O){var R=this.removeAggregation("toolbarContent",O,true);o.call(this);return R;};e.prototype.removeAllToolbarContent=function(){var R=this.removeAllAggregation("toolbarContent",true);o.call(this);return R;};e.prototype.destroyToolbarContent=function(){var i=this.destroyAggregation("toolbarContent",true);o.call(this);return i;};e.prototype.indexOfContent=function(i){return this.indexOfToolbarContent(i);};e.prototype.setSingleSelection=function(S){this.setProperty("singleSelection",S,true);y.call(this);B.call(this);if(S){this.selectAllRows(false);}else{x.call(this);}this.$().toggleClass("sapMPlanCalMultiSel",!S);return this;};e.prototype.setNoDataText=function(N){this.setProperty("noDataText",N,true);var T=this.getAggregation("table");T.setNoDataText(N);return this;};e.prototype.setLegend=function(j){this.setAssociation("legend",j,true);var R=this.getRows();for(var i=0;i<R.length;i++){var E=R[i];E.getCalendarRow().setLegend(j);}return this;};e.prototype.addAriaLabelledBy=function(i){this.addAssociation("ariaLabelledBy",i,true);var T=this.getAggregation("table");T.addAriaLabelledBy(i);return this;};e.prototype.removeAriaLabelledBy=function(O){this.removeAssociation("ariaLabelledBy",O,true);var T=this.getAggregation("table");T.removeAriaLabelledBy(O);return this;};e.prototype.removeAllAriaLabelledBy=function(){this.removeAllAssociation("ariaLabelledBy",true);var T=this.getAggregation("table");T.removeAllAriaLabelledBy();T.addAriaLabelledBy(this.getId()+"-Descr");return this;};e.prototype.invalidate=function(O){if(this._bDateRangeChanged||(O&&O instanceof sap.ui.unified.DateRange)){if(this.getDomRef()){var K=this.getViewKey();var V=this._getView(K);var i=V.getIntervalType();switch(i){case sap.ui.unified.CalendarIntervalType.Hour:if(this._oTimeInterval){this._oTimeInterval.invalidate(arguments);}break;case sap.ui.unified.CalendarIntervalType.Day:if(this._oDateInterval){this._oDateInterval.invalidate(arguments);}break;case sap.ui.unified.CalendarIntervalType.Month:if(this._oMonthInterval){this._oMonthInterval.invalidate(arguments);}break;case sap.ui.unified.CalendarIntervalType.OneMonth:if(this._oOneMonthInterval){this._oOneMonthInterval.invalidate(arguments);}break;case sap.ui.unified.CalendarIntervalType.Week:if(this._oWeekInterval){this._oWeekInterval.invalidate(arguments);}break;default:throw new Error("Unknown IntervalType: "+i+"; "+this);}}this._bDateRangeChanged=undefined;}else{if(O&&O instanceof sap.m.PlanningCalendarView){this._bCheckView=true;}C.prototype.invalidate.apply(this,arguments);}};e.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};e.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};e.prototype.removeAllViews=function(){this._bCheckView=true;var R=this.removeAllAggregation("views");return R;};e.prototype.destroyViews=function(){this._bCheckView=true;var i=this.destroyAggregation("views");return i;};e.prototype.getSelectedRows=function(){return this.getRows().filter(function(R){return R.getSelected();});};e.prototype.selectAllRows=function(S){var R=this.getRows();if(!(S&&this.getSingleSelection())){for(var i=0;i<R.length;i++){var j=R[i];j.setSelected(S);}if(this._oSelectAllCheckBox){this._oSelectAllCheckBox.setSelected(S);}}return this;};e.prototype.onsaphomemodifiers=function(E){if((E.metaKey||E.ctrlKey)&&!E.altKey&&!E.shiftKey){var R=this.getRows();var i=R[0];var N=new q.Event("saphome");N._bPlanningCalendar=true;i.getCalendarRow().onsaphome(N);E.preventDefault();E.stopPropagation();}};e.prototype.onsapendmodifiers=function(E){if((E.metaKey||E.ctrlKey)&&!E.altKey&&!E.shiftKey){var R=this.getRows();var i=R[R.length-1];var N=new q.Event("sapend");N._bPlanningCalendar=true;i.getCalendarRow().onsapend(N);E.preventDefault();E.stopPropagation();}};e.prototype._getIntervals=function(V){var i=0;switch(this._iSize){case 0:i=V.getIntervalsS();break;case 1:i=V.getIntervalsM();break;default:i=V.getIntervalsL();break;}return i;};e.prototype._getView=function(K,N){var V=r.call(this);var j;for(var i=0;i<V.length;i++){j=V[i];if(j.getKey()!=K){j=undefined;}else{break;}}if(!j&&!N){throw new Error("PlanningCalendarView with key "+K+"not assigned "+this);}return j;};e.prototype._changeStartDate=function(S){if(this._bNoStartDateChange){return;}this.setStartDate(new Date(S.getTime()));this.fireStartDateChange();};e.prototype._updateCurrentTimeVisualization=function(U){if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}if(U){var R=this.getRows();for(var i=0;i<R.length;i++){var j=R[i];j.getCalendarRow().updateCurrentTimeVisualization();}}var N=new Date();var S=this.getStartDate();var K=this.getViewKey();var V=this._getView(K);var E=V.getIntervalType();var F=this._getIntervals(V);var T=0;var G=0;var H=0;switch(E){case sap.ui.unified.CalendarIntervalType.Hour:T=60000;G=S.getTime()-3600000;H=S.getTime()+F*3600000;break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:T=1800000;G=S.getTime()-3600000;H=S.getTime()+F*86400000;break;default:T=-1;break;}if(N.getTime()<=H&&N.getTime()>=G&&T>0){this._sUpdateCurrentTime=q.sap.delayedCall(T,this,'_updateCurrentTimeVisualization',[true]);}};function _(E){this.setViewKey(E.getParameter("selectedItem").getKey());this.fireViewChange();}e.prototype._handleTodayPress=function(E){var i=new Date(),S,V=this.getViewKey();if(V===sap.ui.unified.CalendarIntervalType.OneMonth){S=a.getFirstDateOfMonth(a._createUniversalUTCDate(i,undefined,true));this._oOneMonthInterval._adjustSelectedDate(a._createUniversalUTCDate(i,undefined,true),false);i=a._createLocalDate(S,true);}if(V===sap.ui.unified.CalendarIntervalType.Week){S=this.getStartDate();i.setHours(S.getHours());i.setMinutes(S.getMinutes());i.setSeconds(S.getSeconds());}this.setStartDate(i);this.fireStartDateChange();};e.prototype._handleStartDateChange=function(E){var S=E.oSource.getStartDate();this._changeStartDate(S);};e.prototype._handleCalendarSelect=function(E){var S=E.oSource.getSelectedDates();var i=new Date(S[0].getStartDate());var j=a._createUniversalUTCDate(i,undefined,true);var K=this.getViewKey();var V=this._getView(K);var F=V.getIntervalType();if(F!==sap.ui.unified.CalendarIntervalType.OneMonth||this._iSize>1){S[0].setStartDate();}switch(F){case sap.ui.unified.CalendarIntervalType.Hour:j.setUTCHours(j.getUTCHours()+1);break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:j.setUTCDate(j.getUTCDate()+1);break;case sap.ui.unified.CalendarIntervalType.OneMonth:if(this._iSize<2){var G=new Date(i.getTime());if(a.monthsDiffer(this.getStartDate(),i)){this.setStartDate(i);}this._setRowsStartDate(G);this._oOneMonthInterval.getAggregation('month')[0]._focusDate(a._createUniversalUTCDate(G),true);}else if(this._isNextMonth(i)){this._oOneMonthInterval._handleNext();return;}j.setUTCDate(j.getUTCDate()+1);break;case sap.ui.unified.CalendarIntervalType.Month:j.setUTCMonth(j.getUTCMonth()+1);break;default:throw new Error("Unknown IntervalType: "+F+"; "+this);}j.setUTCMilliseconds(j.getUTCMilliseconds()-1);j=a._createLocalDate(j,true);this.fireIntervalSelect({startDate:i,endDate:j,subInterval:false,row:undefined});};function h(E){var S=E.getParameter("startDate");var K=this.getViewKey();var V=this._getView(K);var i=V.getIntervalType();if(i===sap.ui.unified.CalendarIntervalType.OneMonth&&this._isNextMonth(S)){this._oOneMonthInterval._handleNext();return;}var j=E.getParameter("endDate");var F=E.getParameter("subInterval");var R=E.oSource._oPlanningCalendarRow;this.fireIntervalSelect({startDate:S,endDate:j,subInterval:F,row:R});}e.prototype._isNextMonth=function(i){return(i.getMonth()>this.getStartDate().getMonth()&&i.getFullYear()===this.getStartDate().getFullYear())||i.getFullYear()>this.getStartDate().getFullYear();};e.prototype._applyContextualSettings=function(){return C.prototype._applyContextualSettings.call(this,{contextualWidth:this.$().width()});};function k(E,N){this._applyContextualSettings();if(E.size.width<=0){return;}var R=this.getRows();var j;var i=0;var O=this._iSize;p.call(this,E.size.width);if(O!=this._iSize){t.call(this,this._iSize);var K=this.getViewKey();var V=this._getView(K);var F=V.getIntervalType();var G=this._getIntervals(V);for(i=0;i<R.length;i++){j=R[i];var H=j.getCalendarRow();if(G!=H.getIntervals()){H.setIntervals(G);}else{H.handleResize();}}switch(F){case sap.ui.unified.CalendarIntervalType.Hour:if(this._oTimeInterval&&this._oTimeInterval.getItems()!=G){this._oTimeInterval.setItems(G);}break;case sap.ui.unified.CalendarIntervalType.Day:if(this._oDateInterval&&this._oDateInterval.getDays()!=G){this._oDateInterval.setDays(G);}break;case sap.ui.unified.CalendarIntervalType.Month:if(this._oMonthInterval&&this._oMonthInterval.getMonths()!=G){this._oMonthInterval.setMonths(G);}break;case sap.ui.unified.CalendarIntervalType.Week:if(this._oWeekInterval&&this._oWeekInterval.getDays()!=G){this._oWeekInterval.setDays(G);}break;case sap.ui.unified.CalendarIntervalType.OneMonth:if(this._oOneMonthInterval&&this._oOneMonthInterval.getDays()!=G){this._oOneMonthInterval.setDays(G);if(this._iSize>1){this._setRowsStartDate(new Date(this.getStartDate().getTime()));}}break;default:throw new Error("Unknown IntervalType: "+F+"; "+this);}y.call(this);}else if(!N){for(i=0;i<R.length;i++){j=R[i];j.getCalendarRow().handleResize();}}if(this._oOneMonthInterval){this._oOneMonthInterval._setDisplayMode(this._iSize);}}function m(E){var F=E.getParameter("appointment");var M=E.getParameter("multiSelect");var G=E.getParameter("appointments");if(!M){var R=this.getRows();for(var i=0;i<R.length;i++){var H=R[i];var J=H.getCalendarRow();if(E.oSource!=J){var K=H.getAppointments();for(var j=0;j<K.length;j++){var N=K[j];N.setSelected(false);}}}}this.fireAppointmentSelect({appointment:F,appointments:G,multiSelect:M});}e.prototype._setRowsStartDate=function(j){var R=this.getRows(),E,i;for(i=0;i<R.length;i++){E=R[i];E.getCalendarRow().setStartDate(j);}};e.prototype._toggleAppointmentsColumnPopinState=function(i){var T=this.getAggregation("table"),j=T.getColumns()[1];j.setDemandPopin(i);j.setMinScreenWidth(i?A:"");};function n(E){var j=[];var R=this.getRows();for(var i=0;i<R.length;i++){var F=R[i];var G=F.getColumnListItem();var S=G.getSelected();if(F.getSelected()!=S){F.setProperty("selected",S,true);j.push(F);}}if(!this.getSingleSelection()){x.call(this);}if(j.length>0){this.fireRowSelectionChange({rows:j});}}function o(){var T=this.getAggregation("table");if(this.getToolbarContent().length>0){if(!this._oToolbar){this._oToolbar=new sap.m.OverflowToolbar(this.getId()+"-Toolbar",{design:sap.m.ToolbarDesign.Transpaent});this._oToolbar._oPlanningCalendar=this;this._oToolbar.getContent=function(){return this._oPlanningCalendar.getToolbarContent();};}if(!T.getHeaderToolbar()){T.setHeaderToolbar(this._oToolbar);}}else if(T.getHeaderToolbar()){T.setHeaderToolbar();}this._oToolbar.invalidate();}function p(W){if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else{this._iSize=2;}if(q('html').hasClass("sapUiMedia-Std-Phone")){this._iSizeScreen=0;}else if(q('html').hasClass("sapUiMedia-Std-Tablet")){this._iSizeScreen=1;}else{this._iSizeScreen=2;}}function t(S){var j='sapMSize'+S,R=this.$(),i,E;if(R){for(i=0;i<3;i++){E='sapMSize'+i;if(E===j){R.addClass(E);}else{R.removeClass(E);}}}}function r(){var V=this.getViews();if(V.length==0){if(!this._aViews){this._aViews=[];var i=new sap.m.PlanningCalendarView(this.getId()+"-HourView",{key:sap.ui.unified.CalendarIntervalType.Hour,intervalType:sap.ui.unified.CalendarIntervalType.Hour,description:this._oRB.getText("PLANNINGCALENDAR_HOURS"),intervalsS:6,intervalsM:6,intervalsL:12});this._aViews.push(i);var j=new sap.m.PlanningCalendarView(this.getId()+"-DayView",{key:sap.ui.unified.CalendarIntervalType.Day,intervalType:sap.ui.unified.CalendarIntervalType.Day,description:this._oRB.getText("PLANNINGCALENDAR_DAYS"),intervalsS:7,intervalsM:7,intervalsL:14});this._aViews.push(j);var E=new sap.m.PlanningCalendarView(this.getId()+"-MonthView",{key:sap.ui.unified.CalendarIntervalType.Month,intervalType:sap.ui.unified.CalendarIntervalType.Month,description:this._oRB.getText("PLANNINGCALENDAR_MONTHS"),intervalsS:3,intervalsM:6,intervalsL:12});this._aViews.push(E);var F=new sap.m.PlanningCalendarView(this.getId()+"-WeekView",{key:sap.ui.unified.CalendarIntervalType.Week,intervalType:sap.ui.unified.CalendarIntervalType.Week,description:this._oRB.getText("PLANNINGCALENDAR_WEEK"),intervalsS:7,intervalsM:7,intervalsL:7});this._aViews.push(F);var G=new sap.m.PlanningCalendarView(this.getId()+"-OneMonthView",{key:sap.ui.unified.CalendarIntervalType.OneMonth,intervalType:sap.ui.unified.CalendarIntervalType.OneMonth,description:this._oRB.getText("PLANNINGCALENDAR_ONE_MONTH"),intervalsS:1,intervalsM:1,intervalsL:31});this._aViews.push(G);}V=this._aViews;}return V;}function s(){var V=r.call(this);var j=this._oIntervalTypeSelect.getItems();var i=0;var E;if(V.length<j.length){for(i=V.length;i<j.length;i++){E=j[i];this._oIntervalTypeSelect.removeItem(E);E.destroy();}}for(i=0;i<V.length;i++){var F=V[i];E=j[i];if(E){if(E.getKey()!=F.getKey()||E.getText()!=F.getDescription()){E.setKey(F.getKey());E.setText(F.getDescription());E.setTooltip(F.getTooltip());}}else{E=new sap.ui.core.Item(this.getId()+"-"+i,{key:F.getKey(),text:F.getDescription(),tooltip:F.getTooltip()});this._oIntervalTypeSelect.addItem(E);}}this._oIntervalTypeSelect.setVisible(!(V.length===1));}function v(E){var i=E.getParameter("selected");var R=this.getRows();if(i){R=this.getRows().filter(function(j){return!j.getSelected();});}this.selectAllRows(i);this.fireRowSelectionChange({rows:R});}function w(E){var j=E.oSource;var T=E.getParameter("type");var R=this.getRows();var F;var N;var G;var H;var i=0;var J=0;var K;for(i=0;i<R.length;i++){F=R[i];if(F.getCalendarRow()==j){J=i;break;}}switch(T){case"sapup":G=j.getFocusedAppointment();H=G.getStartDate();if(J>0){J--;}N=R[J];N.getCalendarRow().focusNearestAppointment(H);break;case"sapdown":G=j.getFocusedAppointment();H=G.getStartDate();if(J<R.length-1){J++;}N=R[J];N.getCalendarRow().focusNearestAppointment(H);break;case"saphome":if(J>0){N=R[0];K=new q.Event(T);K._bPlanningCalendar=true;N.getCalendarRow().onsaphome(K);}break;case"sapend":if(J<R.length-1){N=R[R.length-1];K=new q.Event(T);K._bPlanningCalendar=true;N.getCalendarRow().onsapend(K);}break;default:break;}}function x(){if(this._oSelectAllCheckBox){var R=this.getRows();var S=this.getSelectedRows();if(R.length==S.length&&S.length>0){this._oSelectAllCheckBox.setSelected(true);}else{this._oSelectAllCheckBox.setSelected(false);}}}function y(){if(this.getSingleSelection()){if(this._oCalendarHeader.getAllCheckBox()){this._oCalendarHeader.setAllCheckBox();}else if(this._oInfoToolbar.getContent().length>2){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}}else{if(!this._oSelectAllCheckBox){this._oSelectAllCheckBox=new sap.m.CheckBox(this.getId()+"-All",{text:this._oRB.getText("COLUMNSPANEL_SELECT_ALL")});this._oSelectAllCheckBox.attachEvent("select",v,this);}if(this._iSizeScreen<2||!this.getShowRowHeaders()){var i=this._oInfoToolbar.indexOfContent(this._oSelectAllCheckBox);if(this._iSizeScreen<2){if(i<this._oInfoToolbar.getContent().length-1){this._oInfoToolbar.addContent(this._oSelectAllCheckBox);}}else if(i<0||i>1){if(i>1){this._oInfoToolbar.removeContent(this._oSelectAllCheckBox);}this._oInfoToolbar.insertContent(this._oSelectAllCheckBox,1);}}else{this._oCalendarHeader.setAllCheckBox(this._oSelectAllCheckBox);}}}function z(E){if(E.getParameter("name")=="selected"){x.call(this);}}function B(){var T=this.getAggregation("table");var M=T.getMode();var i;if(this.getSingleSelection()){if(!this.getShowRowHeaders()&&this.getRows().length==1){i=sap.m.ListMode.None;}else{i=sap.m.ListMode.SingleSelectMaster;}}else{i=sap.m.ListMode.MultiSelect;}if(M!=i){T.setMode(i);}}function D(){return this._oTimeInterval||this._oDateInterval||this._oMonthInterval||this._oWeekInterval||this._oOneMonthInterval;}return e;},true);
