/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ListBase','./TreeItemBase','./library','sap/ui/core/Element','sap/ui/model/ClientTreeBindingAdapter','sap/ui/model/TreeBindingCompatibilityAdapter','sap/ui/base/ManagedObjectMetadata','sap/ui/model/odata/ODataTreeBinding','sap/ui/model/odata/v2/ODataTreeBinding','sap/ui/model/ClientTreeBinding'],function(q,L,T,l,E,C,a,M,O,V,b){"use strict";var c=L.extend("sap.m.Tree",{metadata:{library:"sap.m"}});c.prototype.init=function(){L.prototype.init.apply(this,arguments);this.setEnableBusyIndicator(false);};c.prototype.isTreeBinding=function(n){return(n=="items");};c.prototype.getBinding=function(n){n=n||"items";var B=L.prototype.getBinding.call(this,n);if(B&&n==="items"&&!B.getLength){if(O&&B instanceof O){a(B,this);}else if(V&&B instanceof V){B.applyAdapterInterface();}else if(b&&B instanceof b){C.apply(B);}else{q.sap.log.error("TreeBinding is not supported for the control "+this);}}return B;};c.prototype.updateAggregation=function(n){if(n!="items"){return L.prototype.updateAggregation.apply(this,arguments);}var B=this.getBindingInfo("items"),o=this.getBinding("items"),f=B.factory,d;function u(e,d){var g=e.getItems()||[],h,j;if(g.length>d.length){for(var i=d.length;i<g.length;i++){e.removeItem(g[i]);g[i].destroy("KeepDom");}}for(var i=0;i<d.length;i++){h=d[i];j=g[i];if(j){j.setBindingContext(h,B.model);}else{j=f(e.getId()+"-"+i,h);j.setBindingContext(h,B.model);e.addItem(j);}}}d=o.getContexts(0,Number.MAX_SAFE_INTEGER);if(!B.template){this.destroyItems();}u(this,d);};c.prototype.validateAggregation=function(A,o,m){var r=L.prototype.validateAggregation.apply(this,arguments);if(A==="items"&&!(o instanceof T)){throw new Error(o+" is not a valid items aggregation of "+this+". Items aggregation in Tree control only supports TreeItemBase-based objects, e.g. StandardTreeItem.");}return r;};c.prototype.onItemExpanderPressed=function(i,e){var I=this.indexOfItem(i);var B=this.getBindingInfo("items");if(B&&i&&i.getBindingContext(B.model)){if(e==undefined){this.getBinding("items").toggleIndex(I);}else if(e){this.getBinding("items").expand(I);}else{this.getBinding("items").collapse(I);}}};c.prototype.setGrowing=function(){q.sap.log.error("Growing feature of "+this+" is not supported!");return this;};c.prototype.setGrowingThreshold=function(){q.sap.log.error("GrowingThreshold of "+this+" is not supported!");return this;};c.prototype.setGrowingTriggerText=function(){q.sap.log.error("GrowingTriggerText of "+this+" is not supported!");return this;};c.prototype.setGrowingScrollToLoad=function(){q.sap.log.error("GrowingScrollToLoad of "+this+" is not supported!");return this;};c.prototype.setGrowingDirection=function(){q.sap.log.error("GrowingDirection of "+this+" is not supported!");return this;};c.prototype.setEnableBusyIndicator=function(e){if(e){q.sap.log.error("enableBusyIndicator property is not supported for control "+this);}return this;};c.prototype.expandToLevel=function(i){var B=this.getBinding("items");if(B&&B.expandToLevel&&B.getNumberOfExpandedLevels){if(B.getNumberOfExpandedLevels()>i){B.collapseToLevel(0);}B.expandToLevel(i);}return this;};c.prototype.collapseAll=function(){var B=this.getBinding("items");if(B){B.collapseToLevel(0);}return this;};c.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_TREE");};c.prototype.getAccessbilityPosition=function(i){var s=0,p=0,n=i.getItemNodeContext();s=n.parent.children.length;p=n.positionInParent+1;return{setSize:s,posInset:p};};return c;},true);
