/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ListItemBase','./library','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','sap/ui/core/Icon'],function(q,L,l,E,I,a){"use strict";var T=L.extend("sap.m.TreeItemBase",{metadata:{library:"sap.m"}});T.prototype.ExpandedIconURI=I.getIconURI("navigation-down-arrow");T.prototype.CollapsedIconURI=I.getIconURI("navigation-right-arrow");T.prototype.getTree=function(){var p=this.getParent();if(p instanceof sap.m.Tree){return p;}};T.prototype.getList=T.prototype.getTree;T.prototype.informTree=T.prototype.informList;T.prototype.getItemNodeContext=function(){var t=this.getTree();var c=null;var b=null;if(t){b=t.getBinding("items");c=b.getNodeByIndex(t.indexOfItem(this));}return c;};T.prototype.getParentNode=function(){if(this.isTopLevel()){return;}var t=this.getTree(),n=this.getLevel(),p=null,i=t.indexOfItem(this)-1,b=t.getItems(),c;while(i>=0){c=b[i].getLevel();if(c===n-1){p=b[i];break;}i--;}return p;};T.prototype.getParentNodeContext=function(){return this.getItemNodeContext().parent;};T.prototype.isLeaf=function(){return(this.getItemNodeContext()||{}).isLeaf;};T.prototype.isTopLevel=function(){return(this.getLevel()===0);};T.prototype.getLevel=function(){return(this.getItemNodeContext()||{}).level;};T.prototype.getExpanded=function(){var e=false;if(this.getItemNodeContext()&&this.getItemNodeContext().nodeState){e=this.getItemNodeContext().nodeState.expanded;}return e;};T.prototype.setSelected=function(s){L.prototype.setSelected.apply(this,arguments);var t=this.getTree();var b=null;var i=-1;if(t){b=t.getBinding("items");i=t.indexOfItem(this);if(t.getMode()===sap.m.ListMode.SingleSelect){b.setSelectedIndex(i);}if(t.getMode()===sap.m.ListMode.MultiSelect){if(s){b.addSelectionInterval(i,i);}else{b.removeSelectionInterval(i,i);}}}return this;};T.prototype._getExpanderControl=function(){var s="";if(!this.isLeaf()){s=this.getExpanded()?this.ExpandedIconURI:this.CollapsedIconURI;}if(this._oExpanderControl){this._oExpanderControl.setSrc(s);return this._oExpanderControl;}this._oExpanderControl=new a({id:this.getId()+"-expander",src:s,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMTreeItemBaseExpander").attachPress(function(e){this.informTree("ExpanderPressed");},this);return this._oExpanderControl;};T.prototype._updateExpander=function(){if(this._oExpanderControl){var s="";if(!this.isLeaf()){s=this.getExpanded()?this.ExpandedIconURI:this.CollapsedIconURI;}this._oExpanderControl.setSrc(s);}};T.prototype.setBindingContext=function(){L.prototype.setBindingContext.apply(this,arguments);this._updateExpander();return this;};T.prototype._getLevelIndentCSS=function(){return this.getLevel();};T.prototype.onsapplus=function(e){this.informTree("ExpanderPressed",true);};T.prototype.onsapminus=function(e){this.informTree("ExpanderPressed",false);};T.prototype.onsapright=function(e){if(this.isLeaf()){return;}if(!this.getExpanded()){this.informTree("ExpanderPressed",true);}else{e.keyCode=q.sap.KeyCodes.ARROW_DOWN;}};T.prototype.onsapleft=function(e){if(this.isTopLevel()&&!this.getExpanded()){return;}if(!this.isLeaf()){if(this.getExpanded()){this.informTree("ExpanderPressed",false);}else{this.getParentNode().focus();}}else{this.getParentNode().focus();}};T.prototype.onsapbackspace=function(e){if(!this.isTopLevel()){this.getParentNode().focus();}};T.prototype.getAccessibilityType=function(b){return b.getText("ACC_CTR_TYPE_TREEITEM");};T.prototype.exit=function(){L.prototype.exit.apply(this,arguments);this.destroyControls(["Expander"]);};return T;},true);
