/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./MessageBox','./Dialog','./library','sap/ui/core/Control','sap/ui/core/Icon','sap/m/Text','sap/m/List','sap/ui/unified/FileUploaderParameter',"sap/ui/unified/FileUploader",'sap/ui/core/format/FileSizeFormat','sap/m/Link','sap/m/OverflowToolbar','./ObjectAttribute','./ObjectStatus',"./UploadCollectionItem","sap/ui/core/HTML","./BusyIndicator","./CustomListItem","sap/ui/core/ResizeHandler","sap/ui/Device","./CustomListItemRenderer","sap/ui/core/HTMLRenderer","./LinkRenderer","./ObjectAttributeRenderer","./ObjectStatusRenderer","./ObjectMarkerRenderer","./TextRenderer","./DialogRenderer"],function(q,M,D,L,C,I,T,a,F,b,c,d,O,f,g,U,H,B,h,R,k){"use strict";var l=C.extend("sap.m.UploadCollection",{constructor:function(i,s){var j;if(s&&s.instantUpload===false){j=s.instantUpload;delete s.instantUpload;}else if(i&&i.instantUpload===false){j=i.instantUpload;delete i.instantUpload;}if(s&&s.mode===sap.m.ListMode.MultiSelect&&j===false){s.mode=sap.m.ListMode.None;q.sap.log.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Upload Pending scenario. Value has been resetted to 'None'");}else if(i&&i.mode===sap.m.ListMode.MultiSelect&&j===false){i.mode=sap.m.ListMode.None;q.sap.log.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Upload Pending scenario. Value has been resetted to 'None'");}try{C.apply(this,arguments);if(j===false){this.bInstantUpload=j;this._oFormatDecimal=c.getInstance({binaryFilesize:false,maxFractionDigits:1,maxIntegerDigits:3});}}catch(e){this.destroy();throw e;}},metadata:{library:"sap.m",properties:{fileType:{type:"string[]",group:"Data",defaultValue:null},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},maximumFileSize:{type:"float",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},noDataText:{type:"string",group:"Appearance",defaultValue:null},noDataDescription:{type:"string",group:"Appearance",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:sap.m.ListSeparators.All},uploadEnabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"string",group:"Data",defaultValue:"../../../upload"},instantUpload:{type:"boolean",group:"Behavior",defaultValue:true},numberOfAttachmentsText:{type:"string",group:"Appearance",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:"None"},uploadButtonInvisible:{type:"boolean",group:"Appearance",defaultValue:false},terminationEnabled:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.UploadCollectionItem",multiple:true,singularName:"item",bindable:"bindable"},headerParameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"headerParameter"},parameters:{type:"sap.m.UploadCollectionParameter",multiple:true,singularName:"parameter"},toolbar:{type:"sap.m.OverflowToolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false},_list:{type:"sap.m.List",multiple:false,visibility:"hidden"},_noDataIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_dragDropIcon:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},_dragDropText:{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{change:{parameters:{documentId:{type:"string"},files:{type:"object[]"}}},fileDeleted:{parameters:{documentId:{type:"string"},item:{type:"sap.m.UploadCollectionItem"}}},filenameLengthExceed:{parameters:{documentId:{type:"string"},files:{type:"object[]"}}},fileRenamed:{parameters:{documentId:{type:"string"},fileName:{type:"string"},item:{type:"sap.m.UploadCollectionItem"}}},fileSizeExceed:{parameters:{documentId:{type:"string"},fileSize:{type:"string"},files:{type:"object[]"}}},typeMissmatch:{parameters:{documentId:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"},files:{type:"object[]"}}},uploadComplete:{parameters:{readyStateXHR:{type:"string"},response:{type:"string"},status:{type:"string"},files:{type:"object[]"}}},uploadTerminated:{parameters:{fileName:{type:"string"},getHeaderParameter:{type:"function",parameters:{headerParameterName:{type:"string"}}}}},beforeUploadStarts:{parameters:{fileName:{type:"string"},addHeaderParameter:{type:"function",parameters:{headerParameter:{type:"sap.m.UploadCollectionParameter"}}},getHeaderParameter:{type:"function",parameters:{headerParameterName:{type:"string"}}}}},selectionChange:{parameters:{selectedItem:{type:"sap.m.UploadCollectionItem"},selectedItems:{type:"sap.m.UploadCollectionItem[]"},selected:{type:"boolean"}}}}}});l._uploadingStatus="uploading";l._displayStatus="display";l._toBeDeletedStatus="toBeDeleted";l._pendingUploadStatus="pendingUploadStatus";l._placeholderCamera='sap-icon://camera';l._markerMargin=8;if(k.system.phone){l._resizeTimeoutInterval=500;}else{l._resizeTimeoutInterval=100;}l.prototype.init=function(){l.prototype._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._headerParamConst={requestIdName:"requestId"+q.now(),fileNameRequestIdName:"fileNameRequestId"+q.now()};this._requestIdValue=0;this._iFUCounter=0;this._oList=new a(this.getId()+"-list",{selectionChange:[this._handleSelectionChange,this]});this.setAggregation("_list",this._oList,true);this._oList.addStyleClass("sapMUCList");this.setAggregation("_noDataIcon",new I(this.getId()+"-no-data-icon",{src:"sap-icon://document",size:"6rem",noTabStop:true}),true);this.setAggregation("_dragDropIcon",new I(this.getId()+"-drag-drop-icon",{src:"sap-icon://upload-to-cloud",size:"4rem",noTabStop:true}),true);this.setAggregation("_dragDropText",new T(this.getId()+"-drag-drop-text",{text:this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR")}),true);this._iUploadStartCallCounter=0;this.aItems=[];this._aDeletedItemForPendingUpload=[];this._aFileUploadersForPendingUpload=[];this._aFilesFromDragAndDropForPendingUpload=[];this._iFileUploaderPH=null;this._oListEventDelegate=null;this._oItemToUpdate=null;this._sReziseHandlerId=null;};l.prototype.setFileType=function(e){if(!e){return this;}if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change fileType at runtime.");}else{var j=e.length;for(var i=0;i<j;i++){e[i]=e[i].toLowerCase();}this.setProperty("fileType",e);if(this._getFileUploader().getFileType()!==e){this._getFileUploader().setFileType(e);}}return this;};l.prototype.setMaximumFilenameLength=function(m){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change maximumFilenameLength at runtime.");}else{this.setProperty("maximumFilenameLength",m,true);if(this._getFileUploader().getMaximumFilenameLength()!==m){this._getFileUploader().setMaximumFilenameLength(m);}}return this;};l.prototype.setMaximumFileSize=function(m){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change maximumFileSize at runtime.");}else{this.setProperty("maximumFileSize",m,true);if(this._getFileUploader().getMaximumFileSize()!==m){this._getFileUploader().setMaximumFileSize(m);}}return this;};l.prototype.setMimeType=function(m){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change mimeType at runtime.");}else{this.setProperty("mimeType",m);if(this._getFileUploader().getMimeType()!==m){this._getFileUploader().setMimeType(m);}return this;}};l.prototype.setMultiple=function(m){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change multiple at runtime.");}else{this.setProperty("multiple",m);if(this._getFileUploader().getMultiple()!==m){this._getFileUploader().setMultiple(m);}return this;}};l.prototype.setShowSeparators=function(s){this.setProperty("showSeparators",s);if(this._oList.getShowSeparators()!==s){this._oList.setShowSeparators(s);}return this;};l.prototype.setUploadEnabled=function(u){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change uploadEnabled at runtime.");}else{this.setProperty("uploadEnabled",u);if(this._getFileUploader().getEnabled()!==u){this._getFileUploader().setEnabled(u);}}return this;};l.prototype.setUploadUrl=function(u){if(!this.getInstantUpload()){q.sap.log.info("As property instantUpload is false it is not allowed to change uploadUrl at runtime.");}else{this.setProperty("uploadUrl",u);if(this._getFileUploader().getUploadUrl()!==u){this._getFileUploader().setUploadUrl(u);}}return this;};l.prototype.setInstantUpload=function(){q.sap.log.error("It is not supported to change the behavior at runtime.");return this;};l.prototype.setMode=function(m){if(m===sap.m.ListMode.Delete){this._oList.setMode(sap.m.ListMode.None);q.sap.log.info("sap.m.ListMode.Delete is not supported by UploadCollection. Value has been resetted to 'None'");}else if(m===sap.m.ListMode.MultiSelect&&!this.getInstantUpload()){this._oList.setMode(sap.m.ListMode.None);q.sap.log.info("sap.m.ListMode.MultiSelect is not supported by UploadCollection for Pending Upload. Value has been resetted to 'None'");}else{this._oList.setMode(m);}return this;};l.prototype.getMode=function(){return this._oList.getMode();};l.prototype.getToolbar=function(){return this._oHeaderToolbar;};l.prototype.getInfoToolbar=function(){return this._oList.getAggregation("infoToolbar");};l.prototype.getNoDataText=function(){var n=this.getProperty("noDataText");n=n||this._oRb.getText("UPLOADCOLLECTION_NO_DATA_TEXT");return n;};l.prototype.getNoDataDescription=function(){var n=this.getProperty("noDataDescription");n=n||this._oRb.getText("UPLOADCOLLECTION_NO_DATA_DESCRIPTION");return n;};l.prototype.setInfoToolbar=function(i){if(this.getInfoToolbar()!==i){this._oList.setAggregation("infoToolbar",i,false);}};l.prototype.setUploadButtonInvisible=function(u){if(this.getUploadButtonInvisible()===u){return this;}this.setProperty("uploadButtonInvisible",u,true);if(this.getInstantUpload()){this._getFileUploader().setVisible(!u);}else{this._setFileUploaderVisibility(u);}if(this._bDragDropEnabled){this._unbindDragEnterLeave();this._bDragDropEnabled=false;}else{this._bindDragEnterLeave();}return this;};l.prototype.upload=function(){if(this.getInstantUpload()){q.sap.log.error("Not a valid API call. 'instantUpload' should be set to 'false'.");}var e=this._aFileUploadersForPendingUpload.length;for(var i=0;i<e;i++){this._iUploadStartCallCounter=0;if(this._aFileUploadersForPendingUpload[i].getValue()){this._aFileUploadersForPendingUpload[i].upload();}}if(this._aFilesFromDragAndDropForPendingUpload.length>0){this._oFileUploader._sendFilesFromDragAndDrop(this._aFilesFromDragAndDropForPendingUpload);this._aFilesFromDragAndDropForPendingUpload=[];}};l.prototype.getSelectedItems=function(){var s=this._oList.getSelectedItems();return this._getUploadCollectionItemsByListItems(s);};l.prototype.getSelectedItem=function(){var s=this._oList.getSelectedItem();if(s){return this._getUploadCollectionItemByListItem(s);}};l.prototype.setSelectedItemById=function(i,s){this._oList.setSelectedItemById(i+"-cli",s);this._setSelectedForItems([this._getUploadCollectionItemById(i)],s);return this;};l.prototype.setSelectedItem=function(u,s){this.setSelectedItemById(u.getId(),s);return this;};l.prototype.selectAll=function(){var s=this._oList.selectAll();if(s.getItems().length!==this.getItems().length){q.sap.log.info("Internal 'List' and external 'UploadCollection' are not in sync.");}this._setSelectedForItems(this.getItems(),true);return this;};l.prototype.downloadItem=function(u,e){if(!this.getInstantUpload()){q.sap.log.info("Download is not possible on Pending Upload mode");return false;}else{return u.download(e);}};l.prototype.openFileDialog=function(i){if(this._oFileUploader){if(i){if(!this._oFileUploader.getMultiple()){this._oItemToUpdate=i;this._oFileUploader.$().find("input[type=file]").trigger("click");}else{q.sap.log.warning("Version Upload cannot be used in multiple upload mode");}}else{this._oFileUploader.$().find("input[type=file]").trigger("click");}}return this;};l.prototype.removeAggregation=function(A,o,s){var e,i;if(!this.getInstantUpload()&&A==="items"&&o){e=o._internalFileIdWithinDragDropArray;if(e){i=this._aFilesFromDragAndDropForPendingUpload.indexOf(e);if(i!==-1){this._aFilesFromDragAndDropForPendingUpload.splice(i,1);}}else{this._aDeletedItemForPendingUpload.push(o);}}if(C.prototype.removeAggregation){return C.prototype.removeAggregation.apply(this,arguments);}};l.prototype.removeAllAggregation=function(A,s){if(!this.getInstantUpload()&&A==="items"){if(this._aFileUploadersForPendingUpload){for(var i=0;i<this._aFileUploadersForPendingUpload.length;i++){this._aFileUploadersForPendingUpload[i].destroy();this._aFileUploadersForPendingUpload[i]=null;}this._aFileUploadersForPendingUpload=[];}}if(C.prototype.removeAllAggregation){return C.prototype.removeAllAggregation.apply(this,arguments);}};l.prototype.onBeforeRendering=function(){this._RenderManager=this._RenderManager||sap.ui.getCore().createRenderManager();var i,e;if(this._oListEventDelegate){this._oList.removeEventDelegate(this._oListEventDelegate);this._oListEventDelegate=null;}this._deregisterSizeHandler();this._unbindDragEnterLeave();j.bind(this)();if(!this.getInstantUpload()){this.aItems=this.getItems();this._getListHeader(this.aItems.length);this._clearList();this._fillList(this.aItems);this._oList.setHeaderToolbar(this._oHeaderToolbar);return;}if(this.aItems.length>0){e=this.aItems.length;var u=[];for(i=0;i<e;i++){if(this.aItems[i]&&this.aItems[i]._status===l._uploadingStatus){u.push(this.aItems[i]);}else if(this.aItems[i]&&this.aItems[i]._status!==l._uploadingStatus&&this.aItems[i]._percentUploaded===100&&this.getItems().length===0){u.push(this.aItems[i]);}}if(u.length!==0){this.aItems=[];this.aItems=this.getItems();this.aItems=u.concat(this.aItems);}else{this.aItems=this.getItems();}}else{this.aItems=this.getItems();}this._getListHeader(this.aItems.length);this._clearList();this._fillList(this.aItems);this._oList.setAggregation("headerToolbar",this._oHeaderToolbar,true);if((k.browser.msie&&k.browser.version<=9)&&this.aItems.length>0&&this.aItems[0]._status===l._uploadingStatus){this._oFileUploader.setEnabled(false);}else{if(this.sErrorState!=="Error"){if(this.getUploadEnabled()!==this._oFileUploader.getEnabled()){this._oFileUploader.setEnabled(this.getUploadEnabled());}}else{this._oFileUploader.setEnabled(false);}}if(this.sDeletedItemId){q(document.activeElement).blur();}function j(){if(this.bInstantUpload===false){this.setProperty("instantUpload",this.bInstantUpload,true);delete this.bInstantUpload;}}};l.prototype.onAfterRendering=function(){this._bindDragEnterLeave();var t=this;if(this.getInstantUpload()){if(this.aItems||(this.aItems===this.getItems())){if(this.editModeItem){var $=q.sap.byId(this.editModeItem+"-ta_editFileName-inner");if($){var i=this.editModeItem;if(!k.os.ios){$.focus(function(){$.selectText(0,$.val().length);});}$.focus();this._oListEventDelegate={onclick:function(e){sap.m.UploadCollection.prototype._handleClick(e,t,i);}};this._oList.addDelegate(this._oListEventDelegate);}}else if(this.sFocusId){sap.m.UploadCollection.prototype._setFocus2LineItem(this.sFocusId);this.sFocusId=null;}else if(this.sDeletedItemId){sap.m.UploadCollection.prototype._setFocusAfterDeletion(this.sDeletedItemId,t);}}}else{if(this.sFocusId){sap.m.UploadCollection.prototype._setFocus2LineItem(this.sFocusId);this.sFocusId=null;}}};l.prototype.exit=function(){var i,p;this._unbindDragEnterLeave();if(this._$RootNode){this._$RootNode=null;}if(this._oFileUploader){this._oFileUploader.destroy();this._oFileUploader=null;}if(this._oHeaderToolbar){this._oHeaderToolbar.destroy();this._oHeaderToolbar=null;}if(this._oNumberOfAttachmentsTitle){this._oNumberOfAttachmentsTitle.destroy();this._oNumberOfAttachmentsTitle=null;}if(this._RenderManager){this._RenderManager.destroy();}if(this._aFileUploadersForPendingUpload){p=this._aFileUploadersForPendingUpload.length;for(i=0;i<p;i++){this._aFileUploadersForPendingUpload[i].destroy();this._aFileUploadersForPendingUpload[i]=null;}this._aFileUploadersForPendingUpload=null;}this._deregisterSizeHandler();};l.prototype._bindDragEnterLeave=function(){this._bDragDropEnabled=this._isDragAndDropAllowed();if(!this._bDragDropEnabled){return;}if(!this._oDragDropHandler){this._oDragDropHandler={dragEnterUIArea:this._onDragEnterUIArea.bind(this),dragLeaveUIArea:this._onDragLeaveUIArea.bind(this),dragOverUIArea:this._onDragOverUIArea.bind(this),dropOnUIArea:this._onDropOnUIArea.bind(this),dragEnterUploadCollection:this._onDragEnterUploadCollection.bind(this),dragLeaveUploadCollection:this._onDragLeaveUploadCollection.bind(this),dragOverUploadCollection:this._onDragOverUploadCollection.bind(this),dropOnUploadCollection:this._onDropOnUploadCollection.bind(this)};}this._$RootNode=q(document.body);this._$RootNode.bind("dragenter",this._oDragDropHandler.dragEnterUIArea);this._$RootNode.bind("dragleave",this._oDragDropHandler.dragLeaveUIArea);this._$RootNode.bind("dragover",this._oDragDropHandler.dragOverUIArea);this._$RootNode.bind("drop",this._oDragDropHandler.dropOnUIArea);this._$DragDropArea=this.$("drag-drop-area");this.$().bind("dragenter",this._oDragDropHandler.dragEnterUploadCollection);this.$().bind("dragleave",this._oDragDropHandler.dragLeaveUploadCollection);this.$().bind("dragover",this._oDragDropHandler.dragOverUploadCollection);this.$().bind("drop",this._oDragDropHandler.dropOnUploadCollection);};l.prototype._unbindDragEnterLeave=function(){if(!this._bDragDropEnabled&&!this._oDragDropHandler){return;}if(this._$RootNode){this._$RootNode.unbind("dragenter",this._oDragDropHandler.dragEnterUIArea);this._$RootNode.unbind("dragleave",this._oDragDropHandler.dragLeaveUIArea);this._$RootNode.unbind("dragover",this._oDragDropHandler.dragOverUIArea);this._$RootNode.unbind("drop",this._oDragDropHandler.dropOnUIArea);}this.$().unbind("dragenter",this._oDragDropHandler.dragEnterUploadCollection);this.$().unbind("dragleave",this._oDragDropHandler.dragLeaveUploadCollection);this.$().unbind("dragover",this._oDragDropHandler.dragOverUploadCollection);this.$().unbind("drop",this._oDragDropHandler.dropOnUploadCollection);};l.prototype._onDragEnterUIArea=function(e){if(!this._checkForFiles(e)){return;}this._oLastEnterUIArea=e.target;this._$DragDropArea.removeClass("sapMUCDragDropOverlayHide");this._adjustDragDropIcon();};l.prototype._onDragOverUIArea=function(e){e.preventDefault();if(!this._checkForFiles(e)){return;}this._$DragDropArea.removeClass("sapMUCDragDropOverlayHide");};l.prototype._onDragLeaveUIArea=function(e){if(this._oLastEnterUIArea===e.target){this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");}};l.prototype._onDropOnUIArea=function(e){this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");};l.prototype._onDragEnterUploadCollection=function(e){if(!this._checkForFiles(e)){return;}if(e.target===this._$DragDropArea[0]){this._$DragDropArea.addClass("sapMUCDropIndicator");this._adjustDragDropIcon();this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DROP_FILE_INDICATOR"));}};l.prototype._onDragOverUploadCollection=function(e){e.preventDefault();};l.prototype._onDragLeaveUploadCollection=function(e){if(e.target===this._$DragDropArea[0]){this._$DragDropArea.removeClass("sapMUCDropIndicator");this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR"));}};l.prototype._checkForFiles=function(e){var t=e.originalEvent.dataTransfer.types;if(t){for(var i=0;i<t.length;i++){if(t[i]==="Files"){return true;}}}return false;};l.prototype._isDragAndDropAllowed=function(){return this.getUploadEnabled()&&!this.getUploadButtonInvisible();};l.prototype._onDropOnUploadCollection=function(e){if(!this._checkForFiles(e)){e.preventDefault();return;}if(e.target===this._$DragDropArea[0]){e.preventDefault();this._$DragDropArea.removeClass("sapMUCDropIndicator");this._$DragDropArea.addClass("sapMUCDragDropOverlayHide");this.getAggregation("_dragDropText").setText(this._oRb.getText("UPLOADCOLLECTION_DRAG_FILE_INDICATOR"));var j=e.originalEvent.dataTransfer.files;if(j.length>1&&!this.getMultiple()){var m=this._oRb.getText("UPLOADCOLLECTION_MULTIPLE_FALSE");M.error(m);return;}if(!this._oFileUploader._areFilesAllowed(j)){return;}if(!this.getInstantUpload()){for(var i=0;i<j.length;i++){this._oFileUploader.fireChange({files:[j[i]],fromDragDrop:true});this._aFilesFromDragAndDropForPendingUpload.push(j[i]);}}else{this._oFileUploader.fireChange({files:j});this._oFileUploader._sendFilesFromDragAndDrop(j);}}};l.prototype._adjustDragDropIcon=function(){if(this._$DragDropArea[0].offsetHeight<160){this.getAggregation("_dragDropIcon").$().hide();}};l.prototype._deregisterSizeHandler=function(){k.orientation.detachHandler(this._onResize,this);R.deregister(this._sReziseHandlerId);};l.prototype._hideFileUploaders=function(){var t,i;if(!this.getInstantUpload()){t=this._oHeaderToolbar.getContent().length;if(this._aFileUploadersForPendingUpload.length){for(i=0;i<t;i++){if(this._oHeaderToolbar.getContent()[i]instanceof sap.ui.unified.FileUploader){if(i===this._iFileUploaderPH&&this._bFocusFileUploader){this._oHeaderToolbar.getContent()[i].$().find("button").focus();}else{this._oHeaderToolbar.getContent()[i].$().hide();}}}}return;}};l.prototype._truncateFileName=function(o){if(o._status==="Edit"){var s=o.getId()+"-cli";this.$().find("#"+s).find(".sapMUCObjectMarkerContainer").attr("style","display: none");return;}var m=0;var e=o.getMarkers();var S;for(var i=0;i<e.length;i++){m=m+e[i].$().width()+l._markerMargin;}if(m>0){var $=this.$().find("#"+o.getId()+"-ta_filenameHL");if($){S="max-width: calc(100% - "+m+"px)";if($.attr("style")!==S){$.attr("style",S);}}}};l.prototype._getListHeader=function(e){var o,i;this._setNumberOfAttachmentsTitle(e);if(!this._oHeaderToolbar){if(!!this._oFileUploader&&!this.getInstantUpload()){this._oFileUploader.destroy();}o=this._getFileUploader();this._oHeaderToolbar=this.getAggregation("toolbar");if(!this._oHeaderToolbar){this._oHeaderToolbar=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{content:[this._oNumberOfAttachmentsTitle,new sap.m.ToolbarSpacer(),o]}).addEventDelegate({onAfterRendering:this._hideFileUploaders},this);this._iFileUploaderPH=2;}else{this._oHeaderToolbar.addEventDelegate({onAfterRendering:this._hideFileUploaders},this);this._iFileUploaderPH=this._getFileUploaderPlaceHolderPosition(this._oHeaderToolbar);if(this._oHeaderToolbar&&this._iFileUploaderPH>-1){this._setFileUploaderInToolbar(o);}else{q.sap.log.info("A place holder of type 'sap.m.UploadCollectionPlaceholder' needs to be provided.");}}}else if(!this.getInstantUpload()){var p=this._aFileUploadersForPendingUpload.length;for(i=p-1;i>=0;i--){if(this._aFileUploadersForPendingUpload[i].getId()==this._oFileUploader.getId()){o=this._getFileUploader();this._oHeaderToolbar.insertAggregation("content",o,this._iFileUploaderPH,true);break;}}}};l.prototype._getFileUploaderPlaceHolderPosition=function(t){for(var i=0;i<t.getContent().length;i++){if(t.getContent()[i]instanceof sap.m.UploadCollectionToolbarPlaceholder){return i;}}return-1;};l.prototype._setFileUploaderInToolbar=function(o){this._oHeaderToolbar.getContent()[this._iFileUploaderPH].setVisible(false);this._oHeaderToolbar.insertContent(o,this._iFileUploaderPH);};l.prototype._mapItemToListItem=function(i){if(!i||(this._oItemToUpdate&&i.getId()===this._oItemToUpdate.getId())){return null;}var s,S,e,o,j,m,$,n,p,t=this;s=i.getId();S=i._status;e=i.getFileName();if(S===l._uploadingStatus){o=new sap.m.BusyIndicator(s+"-ia_indicator",{visible:true}).addStyleClass("sapMUCloadingIcon");}else{p=this._createIcon(i,s,e,t);}m=s+"-container";$=q.sap.byId(m);if(!!$){$.remove();$=null;}n=new sap.ui.core.HTML({content:"<span id="+m+" class= sapMUCTextButtonContainer> </span>",afterRendering:function(){t._renderContent(i,m,t);}});j=new sap.m.CustomListItem(s+"-cli",{content:[o,p,n],selected:i.getSelected()});j._oUploadCollectionItem=i;j._status=S;j.addStyleClass("sapMUCItem");return j;};l.prototype._renderContent=function(o,s,t){var e,i,A,S,m,p,j,n,r,u,v;p=o._percentUploaded;j=o.getAllAttributes();n=o.getStatuses();v=o.getMarkers();e=o.getId();A=j.length;S=n.length;m=v.length;u=o._status;r=t._RenderManager;r.write('<div class="sapMUCTextContainer ');if(u==="Edit"){r.write('sapMUCEditMode ');}r.write('" >');r.renderControl(this._getFileNameControl(o,t));if(u===l._uploadingStatus&&!(k.browser.msie&&k.browser.version<=9)){r.renderControl(this._createProgressLabel(e,p));}else{if(m>0){r.write('<div class="sapMUCObjectMarkerContainer">');for(i=0;i<m;i++){r.renderControl(v[i].addStyleClass("sapMUCObjectMarker"));}r.write('</div>');}if(A>0){r.write('<div class="sapMUCAttrContainer">');for(i=0;i<A;i++){j[i].addStyleClass("sapMUCAttr");r.renderControl(j[i]);if((i+1)<A){r.write('<div class="sapMUCSeparator">&nbsp&#x00B7&#160</div>');}}r.write('</div>');}if(S>0){r.write('<div class="sapMUCStatusContainer">');for(i=0;i<S;i++){n[i].detachBrowserEvent("hover");r.renderControl(n[i]);if((i+1)<S){r.write('<div class="sapMUCSeparator">&nbsp&#x00B7&#160</div>');}}r.write('</div>');}}r.write('</div>');this._renderButtons(r,o,u,e,t);r.flush(q.sap.byId(s)[0],true);this._truncateFileName(o);this._sReziseHandlerId=R.register(this,this._onResize.bind(this));k.orientation.attachHandler(this._onResize,this);};l.prototype._renderButtons=function(r,o,s,e,t){var j,m;j=this._getButtons(o,s,e,t);if(!!j){m=j.length;}if(m>0){r.write('<div class="sapMUCButtonContainer">');for(var i=0;i<m;i++){if((i+1)<m){j[i].addStyleClass("sapMUCFirstButton");}r.renderControl(j[i]);}r.write('</div>');}};l.prototype._getFileNameControl=function(i,t){var e,o,j,s,m,n,S,p,v,r,u,V;m=i.getFileName();n=i.getId();S=i._status;if(S!=="Edit"){e=true;if(this.sErrorState==="Error"||!q.trim(i.getUrl())){e=false;}o=sap.ui.getCore().byId(n+"-ta_filenameHL");if(o){o.destroy();}o=new sap.m.Link(n+"-ta_filenameHL",{enabled:e,press:[t,this._triggerLink,this]}).addStyleClass("sapMUCFileName");o.setModel(i.getModel());o.setText(m);return o;}else{j=t._splitFilename(m);p=t.getMaximumFilenameLength();v="None";r=false;s=j.name;if(i.errorState==="Error"){r=true;v="Error";s=i.changedFileName;if(s.length===0){V=this._oRb.getText("UPLOADCOLLECTION_TYPE_FILENAME");}else{V=this._oRb.getText("UPLOADCOLLECTION_EXISTS");}}u=sap.ui.getCore().byId(n+"-ta_editFileName");if(!u){u=new sap.m.Input(n+"-ta_editFileName",{type:sap.m.InputType.Text,fieldWidth:"75%",valueState:v,valueStateText:V,showValueStateMessage:r,description:j.extension}).addStyleClass("sapMUCEditBox");u.setModel(i.getModel());u.setValue(s);}else{u.setModel(i.getModel());u.setValueState(v);u.setFieldWidth("75%");u.setValueStateText(V);u.setValue(s);u.setDescription(j.extension);u.setShowValueStateMessage(r);}if((p-j.extension.length)>0){u.setProperty("maxLength",p-j.extension.length,true);}return u;}};l.prototype._createProgressLabel=function(i,p){var P;P=sap.ui.getCore().byId(i+"-ta_progress");if(!P){P=new sap.m.Label(i+"-ta_progress",{text:this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[p])}).addStyleClass("sapMUCProgress");}else{P.setText(this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[p]));}return P;};l.prototype._createIcon=function(i,s,e,t){var j,m,o;j=i.getThumbnailUrl();if(j){o=new sap.m.Image(s+"-ia_imageHL",{src:sap.m.UploadCollection.prototype._getThumbnail(j,e),decorative:false,alt:this._getAriaLabelForPicture(i)}).addStyleClass("sapMUCItemImage");}else{m=sap.m.UploadCollection.prototype._getThumbnail(undefined,e);var S;o=new sap.ui.core.Icon(s+"-ia_iconHL",{src:m,decorative:false,useIconTooltip:false,alt:this._getAriaLabelForPicture(i)});if(this.sErrorState!=="Error"&&q.trim(i.getProperty("url"))){S="sapMUCItemIcon";}else{S="sapMUCItemIconInactive";}if(m===l._placeholderCamera){if(this.sErrorState!=="Error"&&q.trim(i.getProperty("url"))){S=S+" sapMUCItemPlaceholder";}else{S=S+" sapMUCItemPlaceholderInactive";}}o.addStyleClass(S);}if(this.sErrorState!=="Error"&&q.trim(i.getProperty("url"))){o.attachPress(function(E){sap.m.UploadCollection.prototype._triggerLink(E,t);});}return o;};l.prototype._getButtons=function(i,s,e,t){var j,o,m,n,p,E,r;j=[];if(!this.getInstantUpload()){n="deleteButton";p=this._createDeleteButton(e,n,i,this.sErrorState,t);j.push(p);return j;}if(s==="Edit"){o=sap.ui.getCore().byId(e+"-okButton");if(!o){o=new sap.m.Button({id:e+"-okButton",text:this._oRb.getText("UPLOADCOLLECTION_OKBUTTON_TEXT"),type:sap.m.ButtonType.Transparent}).addStyleClass("sapMUCOkBtn");}m=sap.ui.getCore().byId(e+"-cancelButton");if(!m){m=new sap.m.Button({id:e+"-cancelButton",text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),type:sap.m.ButtonType.Transparent}).addStyleClass("sapMUCCancelBtn");}j.push(o);j.push(m);return j;}else if(s===l._uploadingStatus&&!(k.browser.msie&&k.browser.version<=9)){n="terminateButton";p=this._createDeleteButton(e,n,i,this.sErrorState,t);j.push(p);return j;}else{E=i.getEnableEdit();if(this.sErrorState==="Error"){E=false;}r=sap.ui.getCore().byId(e+"-editButton");if(!r){if(i.getVisibleEdit()){r=new sap.m.Button({id:e+"-editButton",icon:"sap-icon://edit",type:sap.m.ButtonType.Standard,enabled:E,visible:i.getVisibleEdit(),tooltip:this._oRb.getText("UPLOADCOLLECTION_EDITBUTTON_TEXT"),press:[i,this._handleEdit,this]}).addStyleClass("sapMUCEditBtn");j.push(r);}}else if(!i.getVisibleEdit()){r.destroy();r=null;}else{r.setEnabled(E);r.setVisible(i.getVisibleEdit());j.push(r);}n="deleteButton";if(i.getVisibleDelete()){p=this._createDeleteButton(e,n,i,this.sErrorState,t);j.push(p);}else{p=sap.ui.getCore().byId(e+"-"+n);if(!!p){p.destroy();p=null;}}return j;}};l.prototype._createDeleteButton=function(i,s,o,e,t){var E,j;E=o.getEnableDelete();if(e==="Error"){E=false;}j=sap.ui.getCore().byId(i+"-"+s);if(j){j.destroy();}j=new sap.m.Button({id:i+"-"+s,icon:"sap-icon://sys-cancel",type:sap.m.ButtonType.Standard,enabled:E,tooltip:this._oRb.getText("UPLOADCOLLECTION_TERMINATEBUTTON_TEXT"),visible:o.getVisibleDelete()}).addStyleClass("sapMUCDeleteBtn");if(s==="deleteButton"){j.setTooltip(this._oRb.getText("UPLOADCOLLECTION_DELETEBUTTON_TEXT"));j.attachPress(function(m){this._handleDelete(m,t);}.bind(t));}else if(s==="terminateButton"){if(!this.getTerminationEnabled()){j.setVisible(false);}j.attachPress(function(m){this._handleTerminate.bind(this)(m,o);}.bind(t));}return j;};l.prototype._fillList=function(i){var t=this;var m=i.length-1;q.each(i,function(e,o){if(!o._status){o._status=l._displayStatus;}else if(t.getInstantUpload()&&t._oItemForDelete&&t._oItemForDelete._status===l._toBeDeletedStatus&&o.getDocumentId()===t._oItemForDelete.documentId){return false;}if(!o._percentUploaded&&o._status===l._uploadingStatus){o._percentUploaded=0;}var j=t._mapItemToListItem(o);if(j){if(e===0&&m===0){j.addStyleClass("sapMUCListSingleItem");}else if(e===0){j.addStyleClass("sapMUCListFirstItem");}else if(e===m){j.addStyleClass("sapMUCListLastItem");}else{j.addStyleClass("sapMUCListItem");}t._oList.addAggregation("items",j,true);o.attachEvent("selected",t._handleItemSetSelected,t);}});};l.prototype._clearList=function(){if(this._oList){this._oList.destroyAggregation("items",true);}};l.prototype._setNumberOfAttachmentsTitle=function(i){var n=i||0;var t;if(this._oItemToUpdate){n--;}if(this.getNumberOfAttachmentsText()){t=this.getNumberOfAttachmentsText();}else{t=this._oRb.getText("UPLOADCOLLECTION_ATTACHMENTS",[n]);}if(!this._oNumberOfAttachmentsTitle){this._oNumberOfAttachmentsTitle=new sap.m.Title(this.getId()+"-numberOfAttachmentsTitle",{text:t});}else{this._oNumberOfAttachmentsTitle.setText(t);}};l.prototype._setFileUploaderVisibility=function(u){var t=this._oHeaderToolbar.getContent();if(t){var p=t[this._iFileUploaderPH];if(p instanceof sap.ui.unified.FileUploader){p.setVisible(!u);}}};l.prototype._handleDelete=function(e,o){var p=e.getParameters();var j=o.getItems();var s=p.id.split("-deleteButton")[0];var m;var n;var r="";var t;var u;o.sDeletedItemId=s;for(var i=0;i<j.length;i++){if(j[i].sId===s){n=i;m={documentId:j[i].getDocumentId(),_iLineNumber:n};break;}}if(q.sap.byId(o.sId).hasClass("sapUiSizeCompact")){r="sapUiSizeCompact";}if(o.editModeItem){sap.m.UploadCollection.prototype._handleOk(e,o,o.editModeItem,true);if(o.sErrorState==="Error"){return this;}}if(j[n]&&j[n].getEnableDelete()){t=j[n].getFileName();if(!t){u=this._oRb.getText("UPLOADCOLLECTION_DELETE_WITHOUT_FILENAME_TEXT");}else{u=this._oRb.getText("UPLOADCOLLECTION_DELETE_TEXT",t);}o._oItemForDelete=m;sap.m.MessageBox.show(u,{title:this._oRb.getText("UPLOADCOLLECTION_DELETE_TITLE"),actions:[sap.m.MessageBox.Action.OK,sap.m.MessageBox.Action.CANCEL],onClose:o._onCloseMessageBoxDeleteItem.bind(o),dialogId:"messageBoxDeleteFile",styleClass:r});}};l.prototype._onCloseMessageBoxDeleteItem=function(A){var e=this.getItems();var o;if(this.getInstantUpload()){for(var i=0;i<e.length;i++){if(e[i].getDocumentId()===this._oItemForDelete.documentId){o=e[i];}}}else{o=e[this._oItemForDelete._iLineNumber];}if(A===sap.m.MessageBox.Action.OK){this._oItemForDelete._status=l._toBeDeletedStatus;if(this.getInstantUpload()){this.fireFileDeleted({documentId:this._oItemForDelete.documentId,item:o});this._oItemForDelete=null;}else{if(this.aItems.length===1){this.sFocusId=this._oFileUploader.$().find(":button")[0].id;}else{if(this._oItemForDelete._iLineNumber<this.aItems.length-1){this.sFocusId=this.aItems[this._oItemForDelete._iLineNumber+1].getId()+"-cli";}else{this.sFocusId=this.aItems[0].getId()+"-cli";}}this._aDeletedItemForPendingUpload.push(o);this.aItems.splice(this._oItemForDelete._iLineNumber,1);this.removeAggregation("items",o,false);}}};l.prototype._handleTerminate=function(e,o){var j,m;j=new sap.m.List({items:[new sap.m.StandardListItem({title:o.getFileName(),icon:this._getIconFromFilename(o.getFileName())})]});m=new sap.m.Dialog({id:this.getId()+"deleteDialog",title:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TITLE"),content:[new sap.m.Text({text:this._oRb.getText("UPLOADCOLLECTION_TERMINATE_TEXT")}),j],buttons:[new sap.m.Button({text:this._oRb.getText("UPLOADCOLLECTION_OKBUTTON_TEXT"),press:[n,this]}),new sap.m.Button({text:this._oRb.getText("UPLOADCOLLECTION_CANCELBUTTON_TEXT"),press:function(){m.close();}})],afterClose:function(){m.destroy();}}).open();function n(){var A=false;for(var i=0;i<this.aItems.length;i++){if(this.aItems[i]._status===l._uploadingStatus&&this.aItems[i]._requestIdName===o._requestIdName){A=true;break;}else if(o.getFileName()===this.aItems[i].getFileName()&&this.aItems[i]._status===l._displayStatus){this.aItems[i]._status=l._toBeDeletedStatus;this.fireFileDeleted({documentId:this.aItems[i].getDocumentId(),item:this.aItems[i]});break;}}if(A){this._getFileUploader().abort(this._headerParamConst.fileNameRequestIdName,this._encodeToAscii(o.getFileName())+this.aItems[i]._requestIdName);}m.close();this.invalidate();}};l.prototype._handleEdit=function(e,o){var i,s=o.getId(),j=this.aItems.length;if(this.editModeItem){sap.m.UploadCollection.prototype._handleOk(e,this,this.editModeItem,false);}if(this.sErrorState!=="Error"){for(i=0;i<j;i++){if(this.aItems[i].getId()===s){this.aItems[i]._status="Edit";break;}}o._status="Edit";this.editModeItem=e.getSource().getId().split("-editButton")[0];this.invalidate();}};l.prototype._handleClick=function(e,o,s){if(e.target.id.lastIndexOf("editButton")<0){if(e.target.id.lastIndexOf("cancelButton")>0){sap.m.UploadCollection.prototype._handleCancel(e,o,s);}else if(e.target.id.lastIndexOf("ia_imageHL")<0&&e.target.id.lastIndexOf("ia_iconHL")<0&&e.target.id.lastIndexOf("deleteButton")<0&&e.target.id.lastIndexOf("ta_editFileName-inner")<0){if(e.target.id.lastIndexOf("cli")>0){o.sFocusId=e.target.id;}sap.m.UploadCollection.prototype._handleOk(e,o,s,true);}}};l.prototype._handleOk=function(e,o,s,t){var E=document.getElementById(s+"-ta_editFileName-inner");var n;var S=l._findById(s,o.aItems);var i=S.getProperty("fileName");var j=l.prototype._splitFilename(i);var m=sap.ui.getCore().byId(s+"-ta_editFileName");var p=S.errorState;var r=S.changedFileName;if(E!==null){n=E.value.replace(/^\s+/,"");}o.sFocusId=s+"-cli";if(!n||n.length===0){if(E!==null){this._setErrorStateOnItem(o,S,n,r,p);}return;}S._status=l._displayStatus;if(j.name===n){this._removeErrorStateFromItem(o,S);if(t){o.invalidate();}return;}if(o.getSameFilenameAllowed()){this._removeErrorStateFromItem(o,S);o._oItemForRename=S;o._onEditItemOk.bind(o)(n+j.extension);return;}if(sap.m.UploadCollection.prototype._checkDoubleFileName(n+j.extension,o.aItems)){m.setProperty("valueState","Error",true);this._setErrorStateOnItem(o,S,n,r,p);}else{m.setProperty("valueState","None",true);S.changedFileName=null;this._removeErrorStateFromItem(o,S);if(t){o.invalidate();}o._oItemForRename=S;o._onEditItemOk.bind(o)(n+j.extension);}};l.prototype._setErrorStateOnItem=function(o,s,n,e,E){s._status="Edit";s.errorState="Error";o.sErrorState="Error";s.changedFileName=n;if(E!=="Error"||e!==n){o.invalidate();}};l.prototype._removeErrorStateFromItem=function(o,s){s.errorState=null;o.sErrorState=null;o.editModeItem=null;};l.prototype._onEditItemOk=function(n){if(this._oItemForRename){this._oItemForRename.setFileName(n);this.fireFileRenamed({documentId:this._oItemForRename.getProperty("documentId"),fileName:n,item:this._oItemForRename});}delete this._oItemForRename;};l.prototype._handleCancel=function(e,o,s){var S=l._findById(s,o.aItems);S._status=l._displayStatus;S.errorState=null;S.changedFileName=sap.ui.getCore().byId(s+"-ta_editFileName").getProperty("value");o.sFocusId=o.editModeItem+"-cli";o.sErrorState=null;o.editModeItem=null;o.invalidate();};l.prototype._onChange=function(e){if(e){var t=this;var r,j,i,s,o,S,m,A;if(k.browser.msie&&k.browser.version<=9){var n=e.getParameter("newValue");if(!n){return;}s=n.split(/\" "/)[0];if(s.length===0){return;}}else{j=e.getParameter("files").length;if(j===0){return;}this._oFileUploader.removeAllAggregation("headerParameters",true);this.removeAllAggregation("headerParameters",true);}this._oFileUploader.removeAllAggregation("parameters",true);this.removeAllAggregation("parameters",true);if(k.browser.msie&&k.browser.version<=9){var p={name:e.getParameter("newValue")};var P={files:[p]};this.fireChange({getParameter:function(w){if(w==="files"){return[p];}},getParameters:function(){return P;},mParameters:P,files:[p]});}else{this.fireChange({getParameter:function(w){if(w){return e.getParameter(w);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:e.getParameter("files")});}var u=this.getAggregation("parameters");if(u){q.each(u,function(w,x){var y=new sap.ui.unified.FileUploaderParameter({name:x.getProperty("name"),value:x.getProperty("value")});t._oFileUploader.addParameter(y);});}if(!this.getInstantUpload()){this._bFocusFileUploader=true;S=l._pendingUploadStatus;}else{S=l._uploadingStatus;}if(k.browser.msie&&k.browser.version<=9){o=new sap.m.UploadCollectionItem({fileName:s});o._status=S;o._internalFileIndexWithinFileUploader=1;if(!this.getInstantUpload()){o.setAssociation("fileUploader",this._oFileUploader,true);this.insertItem(o);this._aFileUploadersForPendingUpload.push(this._oFileUploader);}else{o._percentUploaded=0;}this.aItems.unshift(o);}else{this._requestIdValue=this._requestIdValue+1;r=this._requestIdValue.toString();var v=this.getAggregation("headerParameters");if(!this.getInstantUpload()){this._aFileUploadersForPendingUpload.push(this._oFileUploader);}for(i=0;i<j;i++){o=new L.UploadCollectionItem({fileName:e.getParameter("files")[i].name});if(e.getParameter("fromDragDrop")){o._internalFileIdWithinDragDropArray=e.getParameter("files")[i];}o._status=S;o._internalFileIndexWithinFileUploader=i+1;o._requestIdName=r;if(!this.getInstantUpload()){o.setAssociation("fileUploader",this._oFileUploader,true);m=this._oFormatDecimal.format(e.getParameter("files")[i].size);A=new f({text:m});o.insertAggregation("attributes",A,true);this.insertItem(o);}else{o._percentUploaded=0;}this.aItems.unshift(o);}if(v){q.each(v,function(w,x){t._oFileUploader.addHeaderParameter(new sap.ui.unified.FileUploaderParameter({name:x.getProperty("name"),value:x.getProperty("value")}));});}t._oFileUploader.addHeaderParameter(new sap.ui.unified.FileUploaderParameter({name:this._headerParamConst.requestIdName,value:r}));}}};l.prototype._onFilenameLengthExceed=function(e){var o={name:e.getParameter("fileName")};var i=[o];this.fireFilenameLengthExceed({getParameter:function(p){if(p){return e.getParameter(p);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:i});};l.prototype._onFileSizeExceed=function(e){var o;if(k.browser.msie&&k.browser.version<=9){var s=e.getParameter("newValue");o={name:s};var p={newValue:s,files:[o]};this.fireFileSizeExceed({getParameter:function(P){if(P==="files"){return[o];}else if(P==="newValue"){return s;}},getParameters:function(){return p;},mParameters:p,files:[o]});}else{o={name:e.getParameter("fileName"),fileSize:e.getParameter("fileSize")};this.fireFileSizeExceed({getParameter:function(P){if(P){return e.getParameter(P);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:[o]});}};l.prototype._onTypeMissmatch=function(e){var o={name:e.getParameter("fileName"),fileType:e.getParameter("fileType"),mimeType:e.getParameter("mimeType")};var i=[o];this.fireTypeMissmatch({getParameter:function(p){if(p){return e.getParameter(p);}},getParameters:function(){return e.getParameters();},mParameters:e.getParameters(),files:i});};l.prototype._onUploadTerminated=function(e){var i;var r=this._getRequestId(e);var s=e.getParameter("fileName");var j=this.aItems.length;for(i=0;i<j;i++){if(this.aItems[i]&&this.aItems[i].getFileName()===s&&this.aItems[i]._requestIdName===r&&this.aItems[i]._status===l._uploadingStatus){this.aItems.splice(i,1);this.removeItem(i);break;}}this.fireUploadTerminated({fileName:s,getHeaderParameter:this._getHeaderParameterWithinEvent.bind(e)});};l.prototype._onUploadComplete=function(e){if(e){var i,r,u,j,m=o();r=this._getRequestId(e);u=e.getParameter("fileName");if(!u){var n=(e.getSource().getProperty("value")).split(/\" "/);u=n[0];}j=this.aItems.length;for(i=0;i<j;i++){if(!r){if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._status===l._uploadingStatus&&m){this.aItems[i]._percentUploaded=100;this.aItems[i]._status=l._displayStatus;this._oItemToUpdate=null;break;}else if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._status===l._uploadingStatus){this.aItems.splice(i,1);this._oItemToUpdate=null;break;}}else if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._requestIdName===r&&this.aItems[i]._status===l._uploadingStatus&&m){this.aItems[i]._percentUploaded=100;this.aItems[i]._status=l._displayStatus;this._oItemToUpdate=null;break;}else if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._requestIdName===r&&this.aItems[i]._status===l._uploadingStatus||this.aItems[i]._status===l._pendingUploadStatus){this.aItems.splice(i,1);this._oItemToUpdate=null;break;}}this.fireUploadComplete({getParameter:e.getParameter,getParameters:e.getParameters,mParameters:e.getParameters(),files:[{fileName:e.getParameter("fileName")||u,responseRaw:e.getParameter("responseRaw"),reponse:e.getParameter("response"),status:e.getParameter("status"),headers:e.getParameter("headers")}]});}this.invalidate();function o(){var s=e.getParameter("status").toString()||"200";if(s[0]==="2"||s[0]==="3"){return true;}else{return false;}}};l.prototype._onUploadProgress=function(e){if(e){var i,u,p,P,r,j,o,s,$;u=e.getParameter("fileName");r=this._getRequestId(e);P=Math.round(e.getParameter("loaded")/e.getParameter("total")*100);if(P===100){p=this._oRb.getText("UPLOADCOLLECTION_UPLOAD_COMPLETED");}else{p=this._oRb.getText("UPLOADCOLLECTION_UPLOADING",[P]);}j=this.aItems.length;for(i=0;i<j;i++){if(this.aItems[i].getProperty("fileName")===u&&this.aItems[i]._requestIdName==r&&this.aItems[i]._status===l._uploadingStatus){o=sap.ui.getCore().byId(this.aItems[i].getId()+"-ta_progress");if(!!o){o.setText(p);this.aItems[i]._percentUploaded=P;s=this.aItems[i].getId();$=q.sap.byId(s+"-ia_indicator");if(P===100){$.attr("aria-label",p);}else{$.attr("aria-valuenow",P);}break;}}}}};l.prototype._getRequestId=function(e){var o;o=e.getParameter("requestHeaders");if(!o){return null;}for(var j=0;j<o.length;j++){if(o[j].name===this._headerParamConst.requestIdName){return o[j].value;}}};l.prototype._getFileUploader=function(){var t=this,u=this.getInstantUpload();if(!u||!this._oFileUploader){var s=(k.browser.msie&&k.browser.version<=9)?false:true,e=this.getInstantUpload()?this._oRb.getText("UPLOADCOLLECTION_UPLOAD"):this._oRb.getText("UPLOADCOLLECTION_ADD");this._iFUCounter=this._iFUCounter+1;this._oFileUploader=new sap.ui.unified.FileUploader(this.getId()+"-"+this._iFUCounter+"-uploader",{buttonOnly:true,buttonText:e,tooltip:e,iconOnly:true,enabled:this.getUploadEnabled(),fileType:this.getFileType(),icon:"sap-icon://add",iconFirst:false,style:"Transparent",maximumFilenameLength:this.getMaximumFilenameLength(),maximumFileSize:this.getMaximumFileSize(),mimeType:this.getMimeType(),multiple:this.getMultiple(),name:"uploadCollection",uploadOnChange:u,sameFilenameAllowed:true,uploadUrl:this.getUploadUrl(),useMultipart:false,sendXHR:s,change:function(E){t._onChange(E);},filenameLengthExceed:function(E){t._onFilenameLengthExceed(E);},fileSizeExceed:function(E){t._onFileSizeExceed(E);},typeMissmatch:function(E){t._onTypeMissmatch(E);},uploadAborted:function(E){t._onUploadTerminated(E);},uploadComplete:function(E){t._onUploadComplete(E);},uploadProgress:function(E){if(t.getInstantUpload()){t._onUploadProgress(E);}},uploadStart:function(E){t._onUploadStart(E);},visible:!this.getUploadButtonInvisible()});}return this._oFileUploader;};l.prototype._onUploadStart=function(e){var r={},i,s,p,j,G;this._iUploadStartCallCounter++;p=e.getParameter("requestHeaders").length;for(i=0;i<p;i++){if(e.getParameter("requestHeaders")[i].name===this._headerParamConst.requestIdName){s=e.getParameter("requestHeaders")[i].value;break;}}j=e.getParameter("fileName");r={name:this._headerParamConst.fileNameRequestIdName,value:this._encodeToAscii(j)+s};e.getParameter("requestHeaders").push(r);for(i=0;i<this._aDeletedItemForPendingUpload.length;i++){if(this._aDeletedItemForPendingUpload[i].getAssociation("fileUploader")===e.oSource.sId&&this._aDeletedItemForPendingUpload[i].getFileName()===j&&this._aDeletedItemForPendingUpload[i]._internalFileIndexWithinFileUploader===this._iUploadStartCallCounter){e.getSource().abort(this._headerParamConst.fileNameRequestIdName,this._encodeToAscii(j)+s);return;}}this.fireBeforeUploadStarts({fileName:j,addHeaderParameter:m,getHeaderParameter:n.bind(this)});if(q.isArray(G)){for(i=0;i<G.length;i++){if(e.getParameter("requestHeaders")[i].name===G[i].getName()){e.getParameter("requestHeaders")[i].value=G[i].getValue();}}}else if(G instanceof sap.m.UploadCollectionParameter){for(i=0;i<e.getParameter("requestHeaders").length;i++){if(e.getParameter("requestHeaders")[i].name===G.getName()){e.getParameter("requestHeaders")[i].value=G.getValue();break;}}}function m(u){var r={name:u.getName(),value:u.getValue()};e.getParameter("requestHeaders").push(r);}function n(o){G=this._getHeaderParameterWithinEvent.bind(e)(o);return G;}};l.prototype._getIconFromFilename=function(s){var e=this._splitFilename(s).extension;if(q.type(e)==="string"){e=e.toLowerCase();}switch(e){case'.bmp':case'.jpg':case'.jpeg':case'.png':return l._placeholderCamera;case'.csv':case'.xls':case'.xlsx':return'sap-icon://excel-attachment';case'.doc':case'.docx':case'.odt':return'sap-icon://doc-attachment';case'.pdf':return'sap-icon://pdf-attachment';case'.ppt':case'.pptx':return'sap-icon://ppt-attachment';case'.txt':return'sap-icon://document-text';default:return'sap-icon://document';}};l.prototype._getThumbnail=function(t,s){if(t){return t;}else{return this._getIconFromFilename(s);}};l.prototype._triggerLink=function(e,o){var i=null;var j;if(o.editModeItem){sap.m.UploadCollection.prototype._handleOk(e,o,o.editModeItem,true);if(o.sErrorState==="Error"){return this;}o.sFocusId=e.getParameter("id");}j=e.oSource.getId().split("-");i=j[j.length-2];sap.m.URLHelper.redirect(o.aItems[i].getProperty("url"),true);};l.prototype.onkeydown=function(e){switch(e.keyCode){case q.sap.KeyCodes.F2:sap.m.UploadCollection.prototype._handleF2(e,this);break;case q.sap.KeyCodes.ESCAPE:sap.m.UploadCollection.prototype._handleESC(e,this);break;case q.sap.KeyCodes.DELETE:sap.m.UploadCollection.prototype._handleDEL(e,this);break;case q.sap.KeyCodes.ENTER:sap.m.UploadCollection.prototype._handleENTER(e,this);break;default:return;}e.setMarked();};l.prototype._setFocusAfterDeletion=function(e,o){if(!e){return;}var i=o.aItems.length;var s=null;if(i===0){var j=q.sap.byId(o._oFileUploader.sId);var m=j.find(":button");q.sap.focus(m);}else{var n=e.split("-").pop();if((i-1)>=n){s=e+"-cli";}else{s=o.aItems.pop().sId+"-cli";}sap.m.UploadCollection.prototype._setFocus2LineItem(s);this.sDeletedItemId=null;}};l.prototype._setFocus2LineItem=function(s){q.sap.byId(s).focus();};l.prototype._handleENTER=function(e,o){var t;var s;var i;if(o.editModeItem){t=e.target.id.split(o.editModeItem).pop();}else{t=e.target.id.split("-").pop();}switch(t){case"-ta_editFileName-inner":case"-okButton":sap.m.UploadCollection.prototype._handleOk(e,o,o.editModeItem,true);break;case"-cancelButton":e.preventDefault();sap.m.UploadCollection.prototype._handleCancel(e,o,o.editModeItem);break;case"-ia_iconHL":case"-ia_imageHL":var j=o.editModeItem.split("-").pop();sap.m.URLHelper.redirect(o.aItems[j].getProperty("url"),true);break;case"ia_iconHL":case"ia_imageHL":case"cli":s=e.target.id.split(t)[0]+"ta_filenameHL";i=sap.ui.getCore().byId(s);if(i.getEnabled()){j=e.target.id.split("-")[2];sap.m.URLHelper.redirect(o.aItems[j].getProperty("url"),true);}break;default:return;}};l.prototype._handleDEL=function(e,o){if(!o.editModeItem){var i=q.sap.byId(e.target.id);var j=i.find("[id$='-deleteButton']");var m=sap.ui.getCore().byId(j[0].id);m.firePress();}};l.prototype._handleESC=function(e,o){if(o.editModeItem){o.sFocusId=o.editModeItem+"-cli";o.aItems[o.editModeItem.split("-").pop()]._status=l._displayStatus;sap.m.UploadCollection.prototype._handleCancel(e,o,o.editModeItem);}};l.prototype._handleF2=function(e,o){var i=sap.ui.getCore().byId(e.target.id);if(i!==undefined){if(i._status===l._displayStatus){var j=q.sap.byId(e.target.id);var m=j.find("[id$='-editButton']");var E=sap.ui.getCore().byId(m[0].id);if(E.getEnabled()){if(o.editModeItem){sap.m.UploadCollection.prototype._handleClick(e,o,o.editModeItem);}if(o.sErrorState!=="Error"){E.firePress();}}}else{sap.m.UploadCollection.prototype._handleClick(e,o,o.editModeItem);}}else if(e.target.id.search(o.editModeItem)===0){sap.m.UploadCollection.prototype._handleOk(e,o,o.editModeItem,true);}};l.prototype._getFileNames=function(s){if(this.getMultiple()&&!(k.browser.msie&&k.browser.version<=9)){return s.substring(1,s.length-2).split(/\" "/);}else{return s.split(/\" "/);}};l.prototype._checkDoubleFileName=function(s,e){if(e.length===0||!s){return false;}var j=e.length;s=s.replace(/^\s+/,"");for(var i=0;i<j;i++){if(s===e[i].getProperty("fileName")){return true;}}return false;};l.prototype._splitFilename=function(s){var r={};var n=s.split(".");if(n.length==1){r.extension="";r.name=n.pop();return r;}r.extension="."+n.pop();r.name=n.join(".");return r;};l.prototype._getAriaLabelForPicture=function(i){var t;t=(i.getAriaLabelForPicture()||i.getFileName());return t;};l.prototype._getHeaderParameterWithinEvent=function(s){var u=[];var r=this.getParameter("requestHeaders");var p=r.length;var i;if(r&&s){for(i=0;i<p;i++){if(r[i].name===s){return new sap.m.UploadCollectionParameter({name:r[i].name,value:r[i].value});}}}else{if(r){for(i=0;i<p;i++){u.push(new sap.m.UploadCollectionParameter({name:r[i].name,value:r[i].value}));}}return u;}};l.prototype._encodeToAscii=function(v){var e="";for(var i=0;i<v.length;i++){e=e+v.charCodeAt(i);}return e;};l.prototype._onResize=function(){var e=this._oList.getItems();for(var i=0;i<e.length;i++){q.sap.delayedCall(l._resizeTimeoutInterval,this,this._truncateFileName.bind(this),[e[i]._oUploadCollectionItem]);}};l.prototype._getUploadCollectionItemByListItem=function(e){var A=this.getItems();for(var i=0;i<A.length;i++){if(A[i].getId()===e.getId().replace("-cli","")){return A[i];}}return null;};l.prototype._getUploadCollectionItemById=function(u){var A=this.getItems();for(var i=0;i<A.length;i++){if(A[i].getId()===u){return A[i];}}return null;};l.prototype._getUploadCollectionItemsByListItems=function(e){var u=[];var m=this.getItems();if(e){for(var i=0;i<e.length;i++){for(var j=0;j<m.length;j++){if(e[i].getId().replace("-cli","")===m[j].getId()){u.push(m[j]);break;}}}return u;}return null;};l.prototype._setSelectedForItems=function(u,s){if(this.getMode()!==sap.m.ListMode.MultiSelect&&s){var e=this.getItems();for(var j=0;j<e.length;j++){e[j].setSelected(false);}}for(var i=0;i<u.length;i++){u[i].setSelected(s);}};l.prototype._handleItemSetSelected=function(e){var i=e.getSource();if(i instanceof sap.m.UploadCollectionItem){var o=this._getListItemById(i.getId()+"-cli");if(o){o.setSelected(i.getSelected());}}};l.prototype._handleSelectionChange=function(e){var o=e.getParameter("listItem");var s=e.getParameter("selected");var u=this._getUploadCollectionItemsByListItems(e.getParameter("listItems"));var i=this._getUploadCollectionItemByListItem(o);if(i&&o&&u){this.fireSelectionChange({selectedItem:i,selectedItems:u,selected:s});i.setSelected(o.getSelected());}};l.prototype._getListItemById=function(e){var i=this._oList.getItems();return l._findById(e,i);};l._findById=function(e,j){for(var i=0;i<j.length;i++){if(j[i].getId()===e){return j[i];}}return null;};return l;},true);
