/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/library','sap/ui/base/EventProvider','./HashChanger','./Route','./Views','./Targets','./History','sap/ui/thirdparty/crossroads'],function(q,l,E,H,R,V,T,a,c){"use strict";var r={};var b=E.extend("sap.ui.core.routing.Router",{constructor:function(o,C,O,t){E.apply(this);this._oConfig=C||{};this._oRouter=c.create();this._oRouter.ignoreState=true;this._oRoutes={};this._oOwner=O;function e(){if(q.sap.getUriParameters().get("sap-ui-xx-asyncRouting")==="true"){q.sap.log.warning("Activation of async view loading in routing via url parameter is only temporarily supported and may be removed soon","Router");return true;}return false;}this._oConfig._async=this._oConfig.async;if(this._oConfig._async===undefined){this._oConfig._async=e();}this._oViews=new V({component:O,async:this._oConfig._async});if(t){this._oTargets=this._createTargets(this._oConfig,t);}var f=this,h;if(!o){o={};}if(Array.isArray(o)){h=o;o={};h.forEach(function(i){o[i.name]=i;});}q.each(o,function(s,i){if(i.name===undefined){i.name=s;}f.addRoute(i);});this._oRouter.bypassed.add(q.proxy(this._onBypassed,this));},addRoute:function(C,p){if(!C.name){q.sap.log.error("A name has to be specified for every route",this);}if(this._oRoutes[C.name]){q.sap.log.error("Route with name "+C.name+" already exists",this);}this._oRoutes[C.name]=this._createRoute(this,C,p);},parse:function(n){if(this._oRouter){this._oRouter.parse(n);}else{q.sap.log.warning("This router has been destroyed while the hash changed. No routing events where fired by the destroyed instance.",this);}},initialize:function(){var t=this,h=this.oHashChanger=H.getInstance();if(this._bIsInitialized){q.sap.log.warning("Router is already initialized.",this);return this;}this._bIsInitialized=true;this._bLastHashReplaced=false;this._bHashChangedAfterTitleChange=false;this.fnHashChanged=function(f){t.parse(f.getParameter("newHash"));t._bHashChangedAfterTitleChange=true;};if(!h){q.sap.log.error("navTo of the router is called before the router is initialized. If you want to replace the current hash before you initialize the router you may use getUrl and use replaceHash of the Hashchanger.",this);return;}h.attachEvent("hashChanged",this.fnHashChanged);if(this._oTargets){var o=this._oRoutes[this._oConfig.homeRoute];this._oTargets.attachTitleChanged(function(f){var i=f.getParameters();if(o&&d(i.name,o._oConfig.name)){i.isHome=true;}this.fireTitleChanged(i);},this);this.fnHashReplaced=function(){this._bLastHashReplaced=true;};this.oHashChanger.attachEvent("hashReplaced",this.fnHashReplaced,this);this._aHistory=[];var e=o&&g(this._oOwner,o);if(e){this._aHistory.push(e);}}if(!h.init()){this.parse(h.getHash());}return this;},stop:function(){if(!this._bIsInitialized){q.sap.log.warning("Router is not initialized. But it got stopped",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced);}this._bIsInitialized=false;return this;},destroy:function(){E.prototype.destroy.apply(this);if(!this._bIsInitialized){q.sap.log.info("Router is not initialized, but got destroyed.",this);}if(this.fnHashChanged){this.oHashChanger.detachEvent("hashChanged",this.fnHashChanged);}if(this.fnHashReplaced){this.oHashChanger.detachEvent("hashReplaced",this.fnHashReplaced);}this._oRouter.removeAllRoutes();this._oRouter=null;q.each(this._oRoutes,function(i,o){o.destroy();});this._oRoutes=null;this._oConfig=null;if(this._oTargets){this._oTargets.destroy();this._oTargets=null;}this.bIsDestroyed=true;return this;},getURL:function(n,p){if(p===undefined){p={};}var o=this.getRoute(n);if(!o){q.sap.log.warning("Route with name "+n+" does not exist",this);return;}return o.getURL(p);},getRoute:function(n){return this._oRoutes[n];},getViews:function(){return this._oViews;},_createTargets:function(C,t){return new T({views:this._oViews,config:C,targets:t});},_createRoute:function(o,C,p){return new R(o,C,p);},getView:function(v,s,e){var o=this._oViews._getViewWithGlobalId({viewName:v,type:s,id:e});this.fireViewCreated({view:o,viewName:v,type:s});return o;},setView:function(v,o){this._oViews.setView(v,o);return this;},navTo:function(n,p,e){var u=this.getURL(n,p);if(u===undefined){q.sap.log.error("Can not navigate to route with name "+n+" because the route does not exist");}if(e){this.oHashChanger.replaceHash(u);}else{this.oHashChanger.setHash(u);}return this;},getTargets:function(){return this._oTargets;},getTarget:function(n){return this._oTargets.getTarget(n);},attachRouteMatched:function(D,f,L){this.attachEvent("routeMatched",D,f,L);return this;},detachRouteMatched:function(f,L){this.detachEvent("routeMatched",f,L);return this;},fireRouteMatched:function(A){this.fireEvent("routeMatched",A);return this;},attachBeforeRouteMatched:function(D,f,L){this.attachEvent("beforeRouteMatched",D,f,L);return this;},detachBeforeRouteMatched:function(f,L){this.detachEvent("beforeRouteMatched",f,L);return this;},fireBeforeRouteMatched:function(A){this.fireEvent("beforeRouteMatched",A);return this;},attachViewCreated:function(D,f,L){this.attachEvent("viewCreated",D,f,L);return this;},detachViewCreated:function(f,L){this.detachEvent("viewCreated",f,L);return this;},fireViewCreated:function(A){this.fireEvent("viewCreated",A);return this;},attachRoutePatternMatched:function(D,f,L){this.attachEvent("routePatternMatched",D,f,L);return this;},detachRoutePatternMatched:function(f,L){this.detachEvent("routePatternMatched",f,L);return this;},fireRoutePatternMatched:function(A){this.fireEvent("routePatternMatched",A);return this;},attachBypassed:function(D,f,L){return this.attachEvent(b.M_EVENTS.BYPASSED,D,f,L);},detachBypassed:function(f,L){return this.detachEvent(b.M_EVENTS.BYPASSED,f,L);},fireBypassed:function(A){return this.fireEvent(b.M_EVENTS.BYPASSED,A);},attachTitleChanged:function(D,f,L){this.attachEvent(b.M_EVENTS.TITLE_CHANGED,D,f,L);return this;},detachTitleChanged:function(f,L){return this.detachEvent(b.M_EVENTS.TITLE_CHANGED,f,L);},fireTitleChanged:function(A){var D=a.getInstance().getDirection(),h=this.oHashChanger.getHash(),e=l.routing.HistoryDirection,L=this._aHistory[this._aHistory.length-1],n;if(D===e.Backwards&&L&&!L.isHome){if(L&&L.title!==A.title){this._aHistory.pop();}}else if(L&&L.hash==h){L.title=A.title;this._aHistory.some(function(o,i,f){if(i<f.length-1&&q.sap.equal(o,L)){return f.splice(i,1);}});}else{if(this._bLastHashReplaced){this._aHistory.pop();}n={hash:h,title:A.title};this._aHistory.some(function(o,i,f){if(q.sap.equal(o,n)){return f.splice(i,1);}});this._aHistory.push(n);}A.history=this._aHistory.slice(0,-1);this.fireEvent(b.M_EVENTS.TITLE_CHANGED,A);this._bLastHashReplaced=false;return this;},getTitleHistory:function(){return this._aHistory||[];},register:function(n){r[n]=this;return this;},_onBypassed:function(h){var f=function(){this.fireBypassed({hash:h});}.bind(this);if(this._oConfig.bypassed){var o=this._oTargets.display(this._oConfig.bypassed.target,{hash:h});if(o instanceof Promise){o.then(f);return;}}f();},_isAsync:function(){return this._oConfig._async;},metadata:{publicMethods:["initialize","getURL","register","getRoute"]}});function d(s,h){return h&&h.indexOf(s)>-1;}function g(o,h){var s=h.getPattern(),A=o&&o.getManifestEntry("sap.app/title");if(s===""||(s!==undefined&&!/({.*})+/.test(s))){return{hash:s,isHome:true,title:A};}else{q.sap.log.error("Routes with dynamic parts cannot be resolved as home route.");}}b.M_EVENTS={BEFORE_ROUTE_MATCHED:"beforeRouteMatched",ROUTE_MATCHED:"routeMatched",ROUTE_PATTERN_MATCHED:"routePatternMatched",VIEW_CREATED:"viewCreated",BYPASSED:"bypassed",TITLE_CHANGED:"titleChanged"};b.getRouter=function(n){return r[n];};return b;});
