/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/fl/Change","sap/ui/fl/DefaultVariant","sap/ui/fl/StandardVariant","sap/ui/fl/Utils","jquery.sap.global","sap/ui/fl/LrepConnector","sap/ui/fl/Cache"],function(C,d,s,U,$,L,a){"use strict";var P=function(c,S){this._oControl=c;this._bHasLoadedChangesFromBackEnd=false;this._sStableIdPropertyName=S||'id';this._sStableId=this._getStableId();this._sComponentName=U.getComponentClassName(c);if(!this._sComponentName){U.log.error("The Control does not belong to a SAPUI5 component. Variants and Changes for this control might not work as expected.");}this._oAppDescriptor=U.getAppDescriptor(c);this._sSiteId=U.getSiteId(c);this._oChanges={};this._oMessagebundle={};this._oConnector=this._createLrepConnector();};P.prototype.getComponentName=function(){return this._sComponentName;};P.prototype.setComponentName=function(c){this._sComponentName=c;};P.prototype._createLrepConnector=function(){var x,p;x=U.getXSRFTokenFromControl(this._oControl);p={XsrfToken:x};return L.createConnector(p);};P.prototype._getStableId=function(){if(!this._oControl){return undefined;}if((this._sStableIdPropertyName)&&(this._sStableIdPropertyName!=='id')){var S;try{S=this._oControl.getProperty(this._sStableIdPropertyName);}catch(e){S="";}return S;}if(typeof this._oControl.getId!=='function'){return undefined;}return this._oControl.getId();};P.prototype._existVendorLayerChange=function(){var e=false;jQuery.each(this._oChanges,function(c,o){var O=o._oOriginDefinition;if(O.layer==="VENDOR"){e=true;return false;}});return e;};P.prototype._getOwnerComponentOfControl=function(c){if(!c){return undefined;}var o=sap.ui.core.Component.getOwnerIdFor(c);if(o){var O=sap.ui.component(o);return O;}return this._getOwnerComponentOfControl(c.getParent());};P.prototype._checkForMessagebundleBinding=function(){if(this._existVendorLayerChange()){var o=this._getOwnerComponentOfControl(this._oControl);if(o&&!o.getModel("i18nFlexVendor")){var m=new sap.ui.model.json.JSONModel(this._oMessagebundle);o.setModel(m,"i18nFlexVendor");}}};P.prototype.getChanges=function(){var t=this;var c=this._sComponentName;var p={appDescriptor:this._oAppDescriptor,siteId:this._sSiteId};if(this._bHasLoadedChangesFromBackEnd===true){if(this._oMessagebundle){this._checkForMessagebundleBinding();}return Promise.resolve(this._oChanges);}return a.getChangesFillingCache(this._oConnector,c,p).then(t._resolveFillingCacheWithChanges.bind(t));};P.prototype._resolveFillingCacheWithChanges=function(f){this._fillRelevantChanges(f);if(f&&f.changes&&f.changes.messagebundle){this._oMessagebundle=f.changes.messagebundle;this._checkForMessagebundleBinding();}this._bHasLoadedChangesFromBackEnd=true;return this._oChanges;};P.prototype.getComponentChanges=function(){var t=this;var p={appDescriptor:this._oAppDescriptor,siteId:this._sSiteId};return a.getChangesFillingCache(this._oConnector,this._sComponentName,p).then(function(f){var n=true;t._fillRelevantChanges(f,n);return t._oChanges;});};P.prototype._fillRelevantChanges=function(f,n){var c,l,o,S,b,j,e;var t=this;var g=function(k,h){U.log.error("key : "+k+" and text : "+h.value);};var A=function(i,v){if(n===true&&o.fileType==='change'||t._sStableId===v){b=new C(o);b.attachEvent(C.events.markForDeletion,t._onDeleteChange.bind(t));e=b.getId();if(b.isValid()){if(t._oChanges[e]&&b.isVariant()){U.log.error("Id collision - two or more variant files having the same id detected: "+e);jQuery.each(b.getDefinition().texts,g);U.log.error("already exists in variant : ");jQuery.each(t._oChanges[e].getDefinition().texts,g);}t._oChanges[e]=b;}return false;}};if(f&&f.changes&&f.changes.changes){c=f.changes.changes;l=c.length;for(j=0;j<l;j++){o=c[j];S=o.selector;if(S){jQuery.each(S,A);}}}};P.prototype.getChange=function(c){if(!c){U.log.error("sap.ui.fl.Persistence.getChange : sChangeId is not defined");return undefined;}return this._oChanges[c];};P.prototype.addChange=function(p){var f,i,I,c;if(!p){return undefined;}if(!p.type){U.log.error("sap.ui.fl.Persistence.addChange : type is not defined");}var b=jQuery.type(p.content);if(b!=='object'&&b!=='array'){U.log.error("mParameters.content is not of expected type object or array, but is: "+b,"sap.ui.fl.Persistence#addChange");}I={};if(typeof(p.texts)==="object"){jQuery.each(p.texts,function(g,t){I[g]={value:t,type:"XFLD"};});}var A=U.getAppDescriptor(this._oControl);var e=this._sComponentName;if(A&&A["sap.app"]){e=A["sap.app"].componentName||A["sap.app"].id;}i={changeType:p.type,service:p.ODataService,texts:I,content:p.content,reference:this._sComponentName,componentName:e,isVariant:p.isVariant,packageName:p.packageName,isUserDependent:p.isUserDependent};i.selector=this._getSelector();f=C.createInitialFileContent(i);if(p.id){f.fileName=p.id;}c=this.addChangeFile(f);return c.getId();};P.prototype.addChangeFile=function(c){var o,b;o=new C(c);o.attachEvent(C.events.markForDeletion,this._onDeleteChange.bind(this));b=o.getId();this._oChanges[b]=o;return o;};P.prototype.removeChangeFromPersistence=function(c){if(c.getPendingAction()!=='NEW'){return;}var b=c.getId();delete this._oChanges[b];};P.prototype.putChange=function(c){c.attachEvent(C.events.markForDeletion,this._onDeleteChange.bind(this));var b=c.getId();this._oChanges[b]=c;};P.prototype._getSelector=function(){var S;S={};if(this._sStableIdPropertyName){S[this._sStableIdPropertyName]=this._sStableId;}return S;};P.prototype.getExecuteOnSelect=function(){return this.getChanges().then(function(c){return s.getExecuteOnSelect(c);});};P.prototype.getExecuteOnSelectSync=function(){return s.getExecuteOnSelect(this._oChanges);};P.prototype.setExecuteOnSelectSync=function(e){var p,c;var b={};b[this._sStableIdPropertyName]=this._sStableId;p={executeOnSelect:e,reference:this._sComponentName,selector:b};c=s.updateExecuteOnSelect(this._oChanges,e);if(c){return c;}c=s.createChangeObject(p);c.attachEvent(C.events.markForDeletion,this._onDeleteChange.bind(this));var f=c.getId();this._oChanges[f]=c;return c;};P.prototype.setExecuteOnSelect=function(e){var p,c;var t=this;return this.getChanges().then(function(o){var b={};b[t._sStableIdPropertyName]=t._sStableId;p={executeOnSelect:e,reference:t._sComponentName,selector:b};c=s.updateExecuteOnSelect(o,e);if(c){return c;}c=s.createChangeObject(p);c.attachEvent(C.events.markForDeletion,t._onDeleteChange.bind(t));o[c.getId()]=c;return c;});};P.prototype.getDefaultVariantId=function(){return this.getChanges().then(function(c){return d.getDefaultVariantId(c);});};P.prototype.getDefaultVariantIdSync=function(){return d.getDefaultVariantId(this._oChanges);};P.prototype.setDefaultVariantIdSync=function(D){var p,c;var b={};b[this._sStableIdPropertyName]=this._sStableId;p={defaultVariantId:D,reference:this._sComponentName,selector:b};c=d.updateDefaultVariantId(this._oChanges,D);if(c){return c;}c=d.createChangeObject(p);c.attachEvent(C.events.markForDeletion,this._onDeleteChange.bind(this));var e=c.getId();this._oChanges[e]=c;return c;};P.prototype.setDefaultVariantId=function(D){var p,c;var t=this;return this.getChanges().then(function(o){var b={};b[t._sStableIdPropertyName]=t._sStableId;p={defaultVariantId:D,reference:t._sComponentName,selector:b};c=d.updateDefaultVariantId(o,D);if(c){return c;}c=d.createChangeObject(p);c.attachEvent(C.events.markForDeletion,t._onDeleteChange.bind(t));o[c.getId()]=c;return c;});};P.prototype.saveAll=function(){var p=[];var t=this;jQuery.each(this._oChanges,function(i,c){switch(c.getPendingAction()){case"NEW":p.push(t._oConnector.create(c.getDefinition(),c.getRequest(),c.isVariant()).then(function(r){c.setResponse(r.response);if(a.isActive()){a.addChange(c.getComponent(),r.response);}return r;}));break;case"UPDATE":p.push(t._oConnector.update(c.getDefinition(),c.getId(),c.getRequest(),c.isVariant()).then(function(r){c.setResponse(r.response);if(a.isActive()){a.updateChange(c.getComponent(),r.response);}return r;}));break;case"DELETE":p.push(t._oConnector.deleteChange({sChangeName:c.getId(),sLayer:c.getLayer(),sNamespace:c.getNamespace(),sChangelist:c.getRequest()},c.isVariant()).then(function(r){var b=c.getId();var m={id:b};c.fireEvent(C.events.markForDeletion,m);if(a.isActive()){a.deleteChange(c.getComponent(),c.getDefinition());}return r;}));break;default:break;}});return Promise.all(p);};P.prototype._onDeleteChange=function(e){var c;c=e.getParameter("id");var o=this.getChange(c);if(o.getPendingAction()==="DELETE"){delete this._oChanges[c];}};P.prototype.isVariantDownport=function(){var l,i;l=U.getCurrentLayer();i=U.isHotfixMode();return((l==='VENDOR')&&(i));};return P;},true);
