/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/fl/Cache',["sap/ui/fl/Utils"],function(U){"use strict";var C=function(){};C._isOn=true;C._entries={};C._switches={};
C.getSwitches=function(){return C._switches;};
C.isActive=function(){return C._isOn;};
C.setActive=function(a){C._isOn=a;};
C.getEntries=function(){return C._entries;};
C.getChangesFillingCache=function(l,c,p){if(!this.isActive()){return l.loadChanges(c,p);}if(p&&p.cacheKey==="<NO CHANGES>"){return Promise.resolve({changes:{changes:[],contexts:[]},componentClassName:c,dummy:true});}var o=C._entries[c];if(!o){o=C._entries[c]={};}if(o.promise){return o.promise;}var a=l.loadChanges(c,p).then(function(m){if(o.file){U.log.error('sap.ui.fl.Cache: Cached changes for component '+c+' overwritten.');}if(m&&m.changes&&m.changes.settings&&m.changes.settings.switchedOnBusinessFunctions){m.changes.settings.switchedOnBusinessFunctions.forEach(function(v){C._switches[v]=true;});}o.file=m;return o.file;},function(e){delete o.promise;throw e;});o.promise=a;return a;};
C._getChangeArray=function(c){var e=C._entries[c];if(e){if(e.file){return e.file.changes.changes;}}};
C.addChange=function(c,o){var a=C._getChangeArray(c);if(!a){return;}a.push(o);};
C.updateChange=function(c,o){var a=C._getChangeArray(c);if(!a){return;}for(var i=0;i<a.length;i++){if(a[i].fileName===o.fileName){a.splice(i,1,o);break;}}};
C.deleteChange=function(c,o){var a=C._getChangeArray(c);if(!a){return;}for(var i=0;i<a.length;i++){if(a[i].fileName===o.fileName){a.splice(i,1);break;}}};
return C;},true);
sap.ui.predefine('sap/ui/fl/Change',["sap/ui/base/EventProvider","sap/ui/fl/Utils","sap/ui/fl/registry/Settings"],function(E,U,S){"use strict";var C=function(f){E.apply(this);if(typeof(f)!=="object"){U.log.error("Constructor : sap.ui.fl.Change : oFile is not defined");}this._oDefinition=f;this._oOriginDefinition=JSON.parse(JSON.stringify(f));this._sRequest='';this._bIsDeleted=false;this._bUserDependent=(f.layer==="USER");};C.events={markForDeletion:"markForDeletion"};C.prototype=jQuery.sap.newObject(E.prototype);
C.prototype.isValid=function(){var i=true;if(typeof(this._oDefinition)!=="object"){i=false;}if(!this._oDefinition.fileType){i=false;}if(!this._oDefinition.fileName){i=false;}if(!this._oDefinition.changeType){i=false;}if(!this._oDefinition.layer){i=false;}if(!this._oDefinition.originalLanguage){i=false;}return i;};
C.prototype.isVariant=function(){return this._oDefinition.fileType==="variant";};
C.prototype.getChangeType=function(){if(this._oDefinition){return this._oDefinition.changeType;}};
C.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.originalLanguage){return this._oDefinition.originalLanguage;}return"";};
C.prototype.getContext=function(){if(this._oDefinition&&this._oDefinition.context){return this._oDefinition.context;}return"";};
C.prototype.getPackage=function(){return this._oDefinition.packageName;};
C.prototype.getNamespace=function(){return this._oDefinition.namespace;};
C.prototype.getId=function(){return this._oDefinition.fileName;};
C.prototype.getContent=function(){return this._oDefinition.content;};
C.prototype.setContent=function(c){this._oDefinition.content=c;};
C.prototype.getSelector=function(){return this._oDefinition.selector;};
C.prototype.getOwnerId=function(){return this._oDefinition.support?this._oDefinition.support.user:"";};
C.prototype.getText=function(t){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Change.getTexts : sTextId is not defined");}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){return this._oDefinition.texts[t].value;}}return"";};
C.prototype.setText=function(t,n){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Change.setTexts : sTextId is not defined");return;}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){this._oDefinition.texts[t].value=n;}}};
C.prototype.isReadOnly=function(){return this._isReadOnlyDueToLayer()||this._isReadOnlyWhenNotKeyUser();};
C.prototype._isReadOnlyWhenNotKeyUser=function(){if(this.isUserDependent()){return false;}var r=this.getDefinition().reference;if(!r){return true;}var s=S.getInstanceOrUndef(r);if(!s){return true;}return!s.isKeyUser();};
C.prototype.isLabelReadOnly=function(){if(this._isReadOnlyDueToLayer()){return true;}return this._isReadOnlyDueToOriginalLanguage();};
C.prototype._isReadOnlyDueToLayer=function(){var c;c=U.getCurrentLayer(this._bUserDependent);return(this._oDefinition.layer!==c);};
C.prototype._isReadOnlyDueToOriginalLanguage=function(){var c,o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};
C.prototype.markForDeletion=function(){this._bIsDeleted=true;};
C.prototype._isDirty=function(){var c=JSON.stringify(this._oDefinition);var o=JSON.stringify(this._oOriginDefinition);return(c!==o);};
C.prototype.setRequest=function(r){if(typeof(r)!=="string"){U.log.error("sap.ui.fl.Change.setRequest : sRequest is not defined");}this._sRequest=r;};
C.prototype.getRequest=function(){return this._sRequest;};
C.prototype.getLayer=function(){return this._oDefinition.layer;};
C.prototype.getComponent=function(){return this._oDefinition.reference;};
C.prototype.getCreation=function(){return this._oDefinition.creation;};
C.prototype.isUserDependent=function(){return(this._bUserDependent);};
C.prototype.getPendingAction=function(){if(this._bIsDeleted){return"DELETE";}else if(!this._oDefinition.creation){return"NEW";}else if(this._isDirty()===true){return"UPDATE";}return"NONE";};
C.prototype.getDefinition=function(){return this._oDefinition;};
C.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this._oOriginDefinition=JSON.parse(R);}};
C.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().fileName;var F=this.getDefinition().fileType;return l+"/"+n+"/"+f+"."+F;};
C.prototype.addDependentControl=function(c,a,p,A){if(!c){throw new Error("Parameter vControl is mandatory");}if(!a){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}if(!this._oDefinition.dependentSelector){this._oDefinition.dependentSelector={};}if(this._oDefinition.dependentSelector[a]){throw new Error("Alias '"+a+"' already exists in the change.");}var m=p.modifier;var o=p.appComponent;if(Array.isArray(c)){var s=[];c.forEach(function(b){s.push(m.getSelector(b,o,A));});this._oDefinition.dependentSelector[a]=s;}else{this._oDefinition.dependentSelector[a]=m.getSelector(c,o,A);}delete this._aDependentIdList;};
C.prototype.getDependentControl=function(a,p){var d=[];var D;if(!a){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}var m=p.modifier;var A=p.appComponent;if(!this._oDefinition.dependentSelector){return undefined;}D=this._oDefinition.dependentSelector[a];if(Array.isArray(D)){D.forEach(function(s){d.push(m.bySelector(s,A));});return d;}else{return m.bySelector(D,A);}};
C.prototype.getDependentIdList=function(a){var t=this;var i;var d=[];var D=[];if(!this._aDependentIdList){if(!this._oDefinition.dependentSelector){this._aDependentIdList=[];}else{Object.keys(this._oDefinition.dependentSelector).forEach(function(p){d.push(t._oDefinition.dependentSelector[p]);});d=[].concat.apply([],d);d.forEach(function(o){i=o.id;if(o.idIsLocal){i=a.createId(o.id);}if(D.indexOf(i)===-1){D.push(i);}});this._aDependentIdList=D;}}return this._aDependentIdList;};
C.prototype.getKey=function(){return this._oDefinition.fileName+this._oDefinition.layer+this._oDefinition.namespace;};
C.createInitialFileContent=function(p){if(!p){p={};}var n={fileName:p.id||U.createDefaultFileName(p.changeType),fileType:(p.isVariant)?"variant":"change",changeType:p.changeType||"",reference:p.reference||"",packageName:p.packageName||"",content:p.content||{},selector:p.selector||{},layer:p.layer||U.getCurrentLayer(p.isUserDependent),texts:p.texts||{},namespace:U.createNamespace(p,"changes"),creation:"",originalLanguage:U.getCurrentLanguage(),conditions:{},context:p.context||"",support:{generator:"Change.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version},dependentSelector:p.dependentSelector||{}};return n;};
return C;},true);
sap.ui.predefine('sap/ui/fl/ChangePersistence',["sap/ui/fl/Change","sap/ui/fl/Utils","jquery.sap.global","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/context/ContextManager","sap/ui/fl/registry/Settings"],function(C,U,$,L,a,b,S){"use strict";var c=function(s,l){this._sComponentName=s;this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};if(!this._sComponentName){U.log.error("The Control does not belong to a SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.");}this._oConnector=l||this._createLrepConnector();this._aDirtyChanges=[];};c.NOTAG="<NoTag>";
c.prototype.getComponentName=function(){return this._sComponentName;};
c.prototype._createLrepConnector=function(){return L.createConnector();};
c.prototype.getCacheKey=function(){return a.getChangesFillingCache(this._oConnector,this._sComponentName,undefined).then(function(w){if(w&&w.etag){return w.etag;}return c.NOTAG;});};
c.prototype._preconditionsFulfilled=function(A,o){if(o.fileType!=="change"){return false;}if(o.changeType==="defaultVariant"){return false;}if(o.changeType!=="codeExt"&&(!o.selector||!o.selector.id)){return false;}if(!b.doesContextMatch(o,A)){return false;}return true;};
c.prototype.getChangesForComponent=function(p){return a.getChangesFillingCache(this._oConnector,this._sComponentName,p).then(function(w){this._bHasLoadedChangesFromBackEnd=true;if(!w.dummy){S._storeInstance(this._sComponentName,w);}if(!w.changes||!w.changes.changes){return[];}var e=w.changes.changes;var s=p&&p.currentLayer;if(s){var f=[];e.forEach(function(o){if(o.layer===s){f.push(o);}});e=f;}var g=w.changes.contexts||[];return new Promise(function(r){b.getActiveContexts(g).then(function(A){r(e.filter(this._preconditionsFulfilled.bind(this,A)).map(d));}.bind(this));}.bind(this));}.bind(this));function d(o){return new C(o);}};
c.prototype._addChangeIntoMap=function(o,d){var s=d.getSelector();if(s&&s.id){var e=s.id;if(s.idIsLocal){e=o.createId(e);}this._addMapEntry(e,d);if(s.idIsLocal===undefined&&e.indexOf("---")!=-1){var f=e.split("---")[0];if(f!==o.getId()){e=e.split("---")[1];e=o.createId(e);this._addMapEntry(e,d);}}}return this._mChanges;};
c.prototype._addMapEntry=function(s,o){if(!this._mChanges.mChanges[s]){this._mChanges.mChanges[s]=[];}this._mChanges.mChanges[s].push(o);};
c.prototype._addDependency=function(d,o){if(!this._mChanges.mDependencies[d.getKey()]){this._mChanges.mDependencies[d.getKey()]={changeObject:d,dependencies:[]};}this._mChanges.mDependencies[d.getKey()].dependencies.push(o.getKey());if(!this._mChanges.mDependentChangesOnMe[o.getKey()]){this._mChanges.mDependentChangesOnMe[o.getKey()]=[];}this._mChanges.mDependentChangesOnMe[o.getKey()].push(d.getKey());};
c.prototype.loadChangesMapForComponent=function(o,p){var t=this;var A=U.getAppComponentForControl(o);return this.getChangesForComponent(p).then(d);function d(e){t._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};e.forEach(function(f,I,g){t._addChangeIntoMap(o,f);var D=f.getDependentIdList(A);var P;var h;var k;var F;for(var i=I-1;i>=0;i--){P=g[i];h=g[i].getDependentIdList(A);F=false;for(var j=0;j<D.length&&!F;j++){k=h.indexOf(D[j]);if(k>-1){t._addDependency(f,P);F=true;}}}});return t.getChangesMapForComponent.bind(t);}};
c.prototype.getChangesMapForComponent=function(){return this._mChanges;};
c.prototype.getChangesForView=function(v,p){var t=this;return this.getChangesForComponent(p).then(function(e){return e.filter(d.bind(t));});function d(o){var s=o.getSelector().id;if(!s||!p){return false;}var e=s.slice(0,s.lastIndexOf("--"));var v;if(o.getSelector().idIsLocal){var A=p.appComponent;if(A){v=A.getLocalId(p.viewId);}}else{v=p.viewId;}return e===v;}};
c.prototype.addChange=function(v,o){var n;if(v instanceof C){n=v;}else{n=new C(v);}this._aDirtyChanges.push(n);this._addChangeIntoMap(o,n);return n;};
c.prototype.saveDirtyChanges=function(){var d=this._aDirtyChanges.slice(0);var D=this._aDirtyChanges;var r=this._getRequests(d);var p=this._getPendingActions(d);if(p.length===1&&r.length===1&&p[0]==="NEW"){var R=r[0];var P=this._prepareDirtyChanges(D);return this._oConnector.create(P,R).then(this._massUpdateCacheAndDirtyState(D,d));}else{return d.reduce(function(s,o){var e=s.then(this._performSingleSaveAction(o).bind(this));e.then(this._updateCacheAndDirtyState(D,o));return e;}.bind(this),Promise.resolve());}};
c.prototype._performSingleSaveAction=function(d){return function(){if(d.getPendingAction()==="NEW"){return this._oConnector.create(d.getDefinition(),d.getRequest());}if(d.getPendingAction()==="DELETE"){return this._oConnector.deleteChange({sChangeName:d.getId(),sLayer:d.getLayer(),sNamespace:d.getNamespace(),sChangelist:d.getRequest()});}};};
c.prototype._updateCacheAndDirtyState=function(d,D){var t=this;return function(){if(D.getPendingAction()==="NEW"){a.addChange(t._sComponentName,D.getDefinition());}if(D.getPendingAction()==="DELETE"){a.deleteChange(t._sComponentName,D.getDefinition());}var i=d.indexOf(D);if(i>-1){d.splice(i,1);}};};
c.prototype._massUpdateCacheAndDirtyState=function(d,D){var t=this;jQuery.each(D,function(i,o){t._updateCacheAndDirtyState(d,o)();});};
c.prototype._getRequests=function(d){var r=[];jQuery.each(d,function(i,o){var R=o.getRequest();if(r.indexOf(R)===-1){r.push(R);}});return r;};
c.prototype._getPendingActions=function(d){var p=[];jQuery.each(d,function(i,o){var P=o.getPendingAction();if(p.indexOf(P)===-1){p.push(P);}});return p;};
c.prototype._prepareDirtyChanges=function(d){var e=[];jQuery.each(d,function(i,o){e.push(o.getDefinition());});return e;};
c.prototype.getDirtyChanges=function(){return this._aDirtyChanges;};
c.prototype.deleteChange=function(o){var n=this._aDirtyChanges.indexOf(o);if(n>-1){if(o.getPendingAction()==="DELETE"){return;}this._aDirtyChanges.splice(n,1);this._deleteChangeInMap(o);return;}o.markForDeletion();this._aDirtyChanges.push(o);this._deleteChangeInMap(o);};
c.prototype._deleteChangeInMap=function(o){var t=this;Object.keys(this._mChanges.mChanges).some(function(k){var d=t._mChanges.mChanges[k];var n=d.indexOf(o);if(n!==-1){d.splice(n,1);return true;}});};
return c;},true);
sap.ui.predefine('sap/ui/fl/ChangePersistenceFactory',["jquery.sap.global","sap/ui/core/Component","sap/ui/fl/ChangePersistence","sap/ui/fl/Utils"],function(q,C,a,U){"use strict";var b={};b._instanceCache={};
b.getChangePersistenceForComponent=function(c){var o;if(!b._instanceCache[c]){o=new a(c);b._instanceCache[c]=o;}return b._instanceCache[c];};
b.getChangePersistenceForControl=function(c){var s;s=this._getComponentClassNameForControl(c);return b.getChangePersistenceForComponent(s);};
b._getComponentClassNameForControl=function(c){return U.getComponentClassName(c);};
b.registerLoadComponentEventHandler=function(){C._fnLoadComponentCallback=this._onLoadComponent.bind(this);};
b._doLoadComponent=function(c,m){var o={oChangePersistence:{},oRequestOptions:{}};var s=U.getFlexReference(m);if(c.componentData&&c.componentData.startupParameters&&c.componentData.startupParameters["sap-app-id"]&&c.componentData.startupParameters["sap-app-id"].length===1){s=c.componentData.startupParameters["sap-app-id"][0];}else{if(c){var A=c.asyncHints;if(A&&A.requests&&Array.isArray(A.requests)){var f=this._findFlAsyncHint(A.requests);if(f&&s===f.reference){o.oRequestOptions.cacheKey=f.cachebusterToken||"<NO CHANGES>";}}}}o.oRequestOptions.siteId=U.getSiteIdByComponentData(c.componentData);o.oChangePersistence=this.getChangePersistenceForComponent(s);return o;};
b._onLoadComponent=function(c,m){if(!U.isApplication(m)){return;}var o=this._doLoadComponent(c,m);o.oChangePersistence.getChangesForComponent(o.oRequestOptions);};
b._getChangesForComponentAfterInstantiation=function(c,m,o){if(!U.isApplication(m)){return Promise.resolve(function(){return{mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};});}var d=this._doLoadComponent(c,m);return d.oChangePersistence.loadChangesMapForComponent(o,d.oRequestOptions);};
b._findFlAsyncHint=function(A){var t=this;var f;q.each(A,function(n,o){if(t._flAsyncHintMatches(o)){f=o;return false;}});return f;};
b._flAsyncHintMatches=function(A){return A.name==="sap.ui.fl.changes";};
return b;},true);
sap.ui.predefine('sap/ui/fl/DefaultVariant',["jquery.sap.global","sap/ui/fl/Change"],function($,C){"use strict";var D=function(){};
D.prototype.getDefaultVariantId=function(c){var d=this.getNewestDefaultVariantChangeDeleteTheRest(c);if(d){return d.getContent().defaultVariantName;}return"";};
D.prototype.getNewestDefaultVariantChangeDeleteTheRest=function(c){var d=this.getDefaultVariantChanges(c).sort(function(a,b){var e=new Date(a.getCreation());var f=new Date(b.getCreation());if(isNaN(e.getDate())){return-1;}if(isNaN(f.getDate())){return 1;}return f-e;});var n=d.shift();d.forEach(function(o){o.markForDeletion();});return n;};
D.prototype.getDefaultVariantChanges=function(c){if(!c||typeof c!=='object'){return[];}return Object.keys(c).map(a).filter(d);function a(s){return c[s];}function d(o){return o.getChangeType()==='defaultVariant';}};
D.prototype.updateDefaultVariantId=function(c,n){var N=this.getNewestDefaultVariantChangeDeleteTheRest(c);if(N){N.getContent().defaultVariantName=n;}return N;};
D.prototype._createChangeFile=function(p){var f;p.namespace=p.component+'/changes/default';p.componentName=p.component;p.changeType='defaultVariant';f=C.createInitialFileContent(p);f.content.defaultVariantName=p.defaultVariantId;f.layer='USER';return f;};
D.prototype.createChangeObject=function(p){var f,c;f=this._createChangeFile(p);c=new C(f);return c;};
return new D();},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnector',["jquery.sap.global","sap/ui/thirdparty/URI","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Cache"],function(q,u,F,L,C){"use strict";var l=Object.create(L.prototype);var i;
function a(I){this.sInitialComponentJsonPath=I;}
for(var p in l){if(typeof l[p]==='function'){a.prototype[p]=(function(p){return function(){throw new Error('Method '+p+'() is not implemented in FakeLrepConnector.');};}(p));}}
a.prototype.loadChanges=function(c){var d=this.sInitialComponentJsonPath;return new Promise(function(r,e){q.getJSON(d).done(function(R){var f={changes:R,componentClassName:c};r(f);}).fail(function(f){e(f);});});};
a.prototype.create=function(c,d,e){if(!e){return Promise.resolve();}if(!c.creation){c.creation=new Date().toISOString();}return Promise.resolve({response:c,status:'success'});};
a.prototype.update=function(c,d,e,f){if(!f){return Promise.resolve();}return Promise.resolve({response:c,status:'success'});};
a.prototype.deleteChange=function(c,d){if(!d){return Promise.resolve();}return Promise.resolve({response:undefined,status:'nocontent'});};
a.prototype.send=function(U,m,d,o){return new Promise(function(r,c){b(U,m,d,o,r,c);h(U,m,d,o,r,c);});};
function h(U,m,d,o,r){if(U.match(/^\/sap\/bc\/lrep\/actions\/make_changes_transportable\//)&&m==='POST'){r();}}
function b(U,m,d,o,r,c){if(U.match(/^\/sap\/bc\/lrep\/actions\/gettransports\//)){r({response:{"transports":[{"transportId":"U31K008488","description":"The Ultimate Transport","owner":"Fantasy Owner","locked":false}],"localonly":false,"errorCode":""}});}}
a.enableFakeConnector=function(I){C._entries={};if(a.enableFakeConnector.original){return;}a.enableFakeConnector.original=L.createConnector;L.createConnector=function(){if(!i){i=new a(I);}return i;};};
a.disableFakeConnector=function(){if(a.enableFakeConnector.original){L.createConnector=a.enableFakeConnector.original;}};
return a;},true);
sap.ui.predefine('sap/ui/fl/FlexController',["jquery.sap.global","sap/ui/fl/Persistence","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Change","sap/ui/fl/Cache","sap/ui/fl/registry/Settings","sap/ui/fl/ChangePersistenceFactory","sap/ui/core/mvc/View","sap/ui/fl/changeHandler/JsControlTreeModifier","sap/ui/fl/changeHandler/XmlTreeModifier","sap/ui/fl/context/ContextManager"],function(q,P,C,U,L,a,b,F,c,V,J,X,d){"use strict";var e=function(s){this._oChangePersistence=undefined;this._sComponentName=s||"";if(this._sComponentName){this._createChangePersistence();}};e.appliedChangesCustomDataKey="sap.ui.fl:AppliedChanges";e.PENDING="sap.ui.fl:PendingChange";e.PROCESSING="sap.ui.fl:ProcessingChange";
e.prototype.setComponentName=function(s){this._sComponentName=s;this._createChangePersistence();};
e.prototype.getComponentName=function(){return this._sComponentName;};
e.prototype.createChange=function(o,f){var g,h,i;if(!f){throw new Error("A flexibility change cannot be created without a targeted control.");}var j=d._getContextIdsFromUrl();if(j.length>1){throw new Error("More than one DesignTime Context is currently active.");}var s=f.id||f.getId();if(!o.selector){o.selector={};}var A=f.appComponent||U.getAppComponentForControl(f);if(!A){throw new Error("No Application Component found - to offer flexibility the control with the id '"+s+"' has to have a valid relation to its owning application component.");}if(U.hasLocalIdSuffix(s,A)){var l=A.getLocalId(s);if(!l){throw new Error("Generated ID attribute found ('"+s+"'); provide a stable ID for the control as required by flexibility for assigning the changes.");}o.selector.id=l;o.selector.idIsLocal=true;}else{o.selector.id=s;o.selector.idIsLocal=false;}var k=U.getAppDescriptor(A);var m=this.getComponentName();o.reference=m;if(k&&k["sap.app"]){o.componentName=k["sap.app"].componentName||k["sap.app"].id;}else{o.componentName=m;}o.packageName="$TMP";o.context=j.length===1?j[0]:"";g=a.createInitialFileContent(o);h=new a(g);var n=f.controlType||U.getControlType(f);if(!n){throw new Error("No control type found - the change handler can not be retrieved.");}i=this._getChangeHandler(h,n);if(i){i.completeChangeContent(h,o,{modifier:J,appComponent:A});}else{throw new Error("Change handler could not be retrieved for change "+JSON.stringify(o)+".");}return h;};
e.prototype.addChange=function(o,f){var g=this.createChange(o,f);var h=U.getAppComponentForControl(f);this._oChangePersistence.addChange(g,h);return g;};
e.prototype.addPreparedChange=function(o,f){var g=U.getAppComponentForControl(f);this._oChangePersistence.addChange(o,g);return o;};
e.prototype.createAndApplyChange=function(o,f){var g=this.addChange(o,f);try{var p={modifier:J,appComponent:U.getAppComponentForControl(f)};this._checkTargetAndApplyChange(g,f,p);}catch(E){this._oChangePersistence.deleteChange(g);throw E;}};
e.prototype.saveAll=function(){return this._oChangePersistence.saveDirtyChanges();};
e.prototype.processXmlView=function(v,p){var o=sap.ui.getCore().getComponent(p.componentId);var A=U.getAppComponentForControl(o);var m=o.getManifest();p.appComponent=A;p.appDescriptor=m;p.modifier=X;p.view=v;return this.processViewByModifier(p);};
e.prototype.processViewByModifier=function(p){p.viewId=p.modifier.getId(p.view);p.siteId=U.getSiteId(p.appComponent);var g=F.getInstance(this.getComponentName(),p);return g.then(this._oChangePersistence.getChangesForView.bind(this._oChangePersistence,p.viewId,p),this._handlePromiseChainError.bind(this,p.view)).then(this._resolveGetChangesForView.bind(this,p));};
e.prototype._resolveGetChangesForView=function(p,f){if(!Array.isArray(f)){var E="No list of changes was passed for processing the flexibility on view: "+p.view+".";U.log.error(E,undefined,"sap.ui.fl.FlexController");return[];}f.forEach(function(o){try{var s=this._getSelectorOfChange(o);if(!s||!s.id){throw new Error("No selector in change found or no selector ID.");}var g=p.modifier.bySelector(s,p.appComponent,p.view);if(!g){throw new Error("A flexibility change tries to change a nonexistent control.");}this._checkTargetAndApplyChange(o,g,p);}catch(h){this._logApplyChangeError(h,o);}}.bind(this));return p.view;};
e.prototype._logApplyChangeError=function(E,o){var D=o.getDefinition();var s=D.changeType;var t=D.selector.id;var f=D.namespace+D.fileName+"."+D.fileType;var w="A flexibility change could not be applied.";w+="\nThe displayed UI might not be displayed as intedend.";if(E.message){w+="\n   occurred error message: '"+E.message+"'";}w+="\n   type of change: '"+s+"'";w+="\n   LRep location of the change: "+f;w+="\n   id of targeted control: '"+t+"'.";U.log.warning(w,undefined,"sap.ui.fl.FlexController");};
e.prototype._checkTargetAndApplyChange=function(o,f,p){var m=p.modifier;var s=m.getControlType(f);var g=this._getChangeHandler(o,s);if(!g){if(o&&f){U.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored");}return;}var h=m.getAggregation(f,"customData")||[];var i=o.getId();var A=[];var j;var k="";h.some(function(r){var K=m.getProperty(r,"key");if(K===e.appliedChangesCustomDataKey){j=r;k=m.getProperty(r,"value");A=k.split(",");return true;}});if(A.indexOf(i)===-1){try{g.applyChange(o,f,p);}catch(l){this._setMergeError(true);U.log.error("Change could not be applied. Merge error detected.");throw l;}if(j){m.setProperty(j,"value",k+","+i);}else{var n=p.appComponent;var v=p.view;j=m.createControl("sap.ui.core.CustomData",n,v);m.setProperty(j,"key",e.appliedChangesCustomDataKey);m.setProperty(j,"value",i);m.insertAggregation(f,"customData",j,0,v,true);}}};
e.prototype._handlePromiseChainError=function(v,E){U.log.error("Error processing view "+E+".");return v;};
e.prototype._getSelectorOfChange=function(o){if(!o||!o.getSelector){return undefined;}return o.getSelector();};
e.prototype.applyChange=function(o,f){var s=U.getControlType(f);var g=this._getChangeHandler(o,s);if(!g){if(o&&f){U.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored.");}return;}try{g.applyChange(o,f);}catch(h){this._setMergeError(true);U.log.error("Change could not be applied. Merge error detected.");throw h;}};
e.prototype._getChangeHandler=function(o,s){var f,g;f=this._getChangeTypeMetadata(o,s);if(!f){return undefined;}g=f.getChangeHandler();return g;};
e.prototype._getChangeTypeMetadata=function(o,s){var f,g;f=this._getChangeRegistryItem(o,s);if(!f||!f.getChangeTypeMetadata){return undefined;}g=f.getChangeTypeMetadata();return g;};
e.prototype._getChangeRegistryItem=function(o,s){var f,g,l;if(!o||!s){return undefined;}f=o.getChangeType();if(!f||!s){return undefined;}l=o.getLayer();g=this._getChangeRegistry().getRegistryItems({"changeTypeName":f,"controlType":s,"layer":l});if(g&&g[s]&&g[s][f]){return g[s][f];}else if(g&&g[s]){return g[s];}else{return g;}};
e.prototype._getChangeRegistry=function(){var i=C.getInstance();i.initSettings(this.getComponentName());return i;};
e.prototype.getComponentChanges=function(p){return this._oChangePersistence.getChangesForComponent(p);};
e.prototype.isPersonalized=function(){return this.getComponentChanges({}).then(function(f){var i=f.some(function(o){return o.isUserDependent();});return!!i;});};
e.prototype._createChangePersistence=function(){this._oChangePersistence=c.getChangePersistenceForComponent(this.getComponentName());return this._oChangePersistence;};
e.prototype.discardChanges=function(f,D){var A=U.getCurrentLayer(!!D);var i=0;var l;var o;l=f.length;while(i<f.length){o=f[i];if(o&&o.getLayer&&o.getLayer()===A){this._oChangePersistence.deleteChange(o);}if(l===f.length){i++;}else{l=f.length;}}return this._oChangePersistence.saveDirtyChanges();};
e.prototype.discardChangesForId=function(i,D){if(!i){return Promise.resolve();}var o=this._oChangePersistence.getChangesMapForComponent();var f=o.mChanges[i]||[];return this.discardChanges(f,D);};
e.prototype._setMergeError=function(){return F.getInstance(this.getComponentName()).then(function(s){s.setMergeErrorOccured(true);});};
e.prototype.applyChangesOnControl=function(g,A,o){var m=g();var f=m.mChanges;var D=m.mDependencies;var h=m.mDependentChangesOnMe;var i=f[o.getId()]||[];i.forEach(function(j){if(!D[j.getKey()]){this._checkTargetAndApplyChange(j,o,{modifier:J,appComponent:A});this._updateDependencies(D,h,j.getKey());}else{D[j.getKey()][e.PENDING]=this._checkTargetAndApplyChange.bind(this,j,o,{modifier:J,appComponent:A});}}.bind(this));this._processDependentQueue(D,h,A);};
e.prototype._updateDependencies=function(D,m,s){if(m[s]){m[s].forEach(function(k){var o=D[k];var i=o.dependencies.indexOf(s);if(i>-1){o.dependencies.splice(i,1);}});delete m[s];}};
e.prototype._processDependentQueue=function(D,m,A){var f;var g;do{f=[];g=[];for(var i=0;i<Object.keys(D).length;i++){var s=Object.keys(D)[i];var o=D[s];if(o[e.PENDING]&&o.dependencies.length===0&&!o[e.PROCESSING]){o[e.PROCESSING]=true;o[e.PENDING]();g.push(s);f.push(o.changeObject.getKey());}}for(var j=0;j<g.length;j++){delete D[g[j]];}for(var k=0;k<f.length;k++){this._updateDependencies(D,m,f[k]);}}while(f.length>0);};
return e;},true);
sap.ui.predefine('sap/ui/fl/FlexControllerFactory',["jquery.sap.global","sap/ui/fl/FlexController","sap/ui/fl/Utils","sap/ui/fl/ChangePersistenceFactory"],function(q,F,U,C){"use strict";var a={};a._instanceCache={};
a.create=function(c){var f=a._instanceCache[c];if(!f){f=new F(c);a._instanceCache[c]=f;}return f;};
a.createForControl=function(c){var s=U.getComponentClassName(c);return a.create(s);};
a.getChangesAndPropagate=function(c,v){var m=c.getManifestObject();if(U.isApplication(m)){var f=a.createForControl(c);C._getChangesForComponentAfterInstantiation(v,m,c).then(function(g){c.addPropagationListener(f.applyChangesOnControl.bind(f,g,c));});}};
return a;},true);
sap.ui.predefine('sap/ui/fl/LrepConnector',["jquery.sap.global","sap/ui/thirdparty/URI","sap/ui/fl/Utils"],function(q,u,F){"use strict";var C=function(p){this._initClientParam();this._initLanguageParam();if(p){this._sXsrfToken=p.XsrfToken;}};
C.createConnector=function(p){return new C(p);};
C.prototype.DEFAULT_CONTENT_TYPE="application/json";C.prototype._sClient=undefined;C.prototype._sLanguage=undefined;C.prototype._aSentRequestListeners=[];C.prototype._sRequestUrlPrefix="";
C.attachSentRequest=function(c){if(typeof c==="function"&&C.prototype._aSentRequestListeners.indexOf(c)===-1){C.prototype._aSentRequestListeners.push(c);}};
C.detachSentRequest=function(c){var i=C.prototype._aSentRequestListeners.indexOf(c);if(i!==-1){C.prototype._aSentRequestListeners.splice(i,1);}};
C.prototype._initClientParam=function(){var c=F.getClient();if(c){this._sClient=c;}};
C.prototype._initLanguageParam=function(){var l;l=F.getUrlParameter("sap-language")||F.getUrlParameter("sap-ui-language");if(l){this._sLanguage=l;}};
C.prototype.setRequestUrlPrefix=function(r){this._sRequestUrlPrefix=r;};
C.prototype._resolveUrl=function(r){if(!q.sap.startsWith(r,"/")){r="/"+r;}r=this._sRequestUrlPrefix+r;var U=u(r).absoluteTo("");return U.toString();};
C.prototype._getDefaultHeader=function(){var h={headers:{"X-CSRF-Token":this._sXsrfToken||"fetch"}};return h;};
C.prototype._getDefaultOptions=function(m,c,d){var o;if(!c){c=this.DEFAULT_CONTENT_TYPE;}o=q.extend(true,this._getDefaultHeader(),{type:m,async:true,contentType:c,processData:false,headers:{"Content-Type":c}});if(d&&o.contentType==="application/json"){o.dataType="json";if(typeof d==="object"){o.data=JSON.stringify(d);}else{o.data=d;}}else if(d){o.data=d;}if(m==="DELETE"){delete o.data;delete o.contentType;}return o;};
C.prototype.send=function(U,m,d,o){m=m||"GET";m=m.toUpperCase();o=o||{};U=this._resolveUrl(U);if(o.success||o.error){var e="Success and error handler are not allowed in mOptions";throw new Error(e);}var c=o.contentType||this.DEFAULT_CONTENT_TYPE;o=q.extend(true,this._getDefaultOptions(m,c,d),o);return this._sendAjaxRequest(U,o);};
C.prototype._getMessagesFromXHR=function(x){var a,m,l,i;m=[];try{a=JSON.parse(x.responseText);if(a&&a.messages&&a.messages.length>0){l=a.messages.length;for(i=0;i<l;i++){m.push({severity:a.messages[i].severity,text:a.messages[i].text});}}}catch(e){}return m;};
C.prototype._sendAjaxRequest=function(U,o){var t=this;var f="/sap/bc/lrep/actions/getcsrftoken/";var m={headers:{"X-CSRF-Token":"fetch"},type:"HEAD"};if(this._sClient){m.headers["sap-client"]=this._sClient;}return new Promise(function(r,a){function h(d,s,x){var n=x.getResponseHeader("X-CSRF-Token");t._sXsrfToken=n||t._sXsrfToken;var e=x.getResponseHeader("etag");var g={status:s,etag:e,response:d};r(g);q.each(t._aSentRequestListeners,function(i,j){j(g);});}function b(d,s,x){t._sXsrfToken=x.getResponseHeader("X-CSRF-Token");o.headers=o.headers||{};o.headers["X-CSRF-Token"]=t._sXsrfToken;q.ajax(U,o).done(h).fail(function(x,s,e){var E=new Error(e);E.status="error";E.code=x.statusCode().status;E.messages=t._getMessagesFromXHR(x);a(E);});}function c(x,s,e){if(x.status===403){q.ajax(f,m).done(b).fail(function(x,s,e){a({status:"error"});});}else{if(o&&o.type==="DELETE"&&x.status===404){r();}else{var d;d={status:"error"};d.code=x.statusCode().status;d.messages=t._getMessagesFromXHR(x);a(d);}}}var R=true;if(o&&o.type){if(o.type==="GET"||o.type==="HEAD"){R=false;}}else{if(t._sXsrfToken&&t._sXsrfToken!=="fetch"){R=false;}}if(R){q.ajax(f,m).done(b).fail(function(x,s,e){a({status:"error"});});}else{q.ajax(U,o).done(h).fail(c);}});};
C.prototype.loadChanges=function(c,p){var U,P;var o={};var t=this;if(!c){return Promise.reject(new Error("Component name not specified"));}U="/sap/bc/lrep/flex/data/";var s="";if(p){var a=p.cacheKey;if(a){o.cache=true;U+="~"+a+"~/";}if(p.appDescriptor){if(p.appDescriptor["sap.app"]){if(!o.headers){o.headers={};}o.headers={"X-LRep-AppDescriptor-Id":p.appDescriptor["sap.app"].id};}}if(p.siteId){if(!o.headers){o.headers={};}o.headers={"X-LRep-Site-Id":p.siteId};}if(p.layer){s=p.layer;}}if(c){U+=c;}if(this._sClient){U+="&sap-client="+this._sClient;}if(s){U+="&upToLayerType="+s;}U=U.replace("&","?");P=this.send(U,undefined,undefined,o);return P.then(function(r){if(r.response){return{changes:r.response,messagebundle:r.response.messagebundle,componentClassName:c};}else{return Promise.reject("response is empty");}},function(e){if(e.code===404||e.code===405){return t._loadChangesBasedOnOldRoute(c);}else{throw(e);}});};
C.prototype._loadChangesBasedOnOldRoute=function(c){var r,p;try{r=q.sap.getResourceName(c,"-changes.json");}catch(e){return Promise.reject(e);}p={async:true,dataType:"json",failOnError:true,headers:{"X-UI5-Component":c}};if(this._sClient){p.headers["sap-client"]=this._sClient;}return q.sap.loadResource(r,p).then(function(R){return{changes:R,componentClassName:c};});};
C.prototype._buildParams=function(p){if(!p){p=[];}if(this._sClient){p.push({name:"sap-client",value:this._sClient});}if(this._sLanguage){p.push({name:"sap-language",value:this._sLanguage});}var r="";var l=p.length;for(var i=0;i<l;i++){if(i===0){r+="?";}else if(i>0&&i<l){r+="&";}r+=p[i].name+"="+p[i].value;}return r;};
C.prototype._getUrlPrefix=function(i){if(i){return"/sap/bc/lrep/variants/";}return"/sap/bc/lrep/changes/";};
C.prototype.create=function(p,c,i){var r=this._getUrlPrefix(i);var P=[];if(c){P.push({name:"changelist",value:c});}r+=this._buildParams(P);return this.send(r,"POST",p,null);};
C.prototype.update=function(p,c,s,i){var r=this._getUrlPrefix(i);r+=c;var P=[];if(s){P.push({name:"changelist",value:s});}r+=this._buildParams(P);return this.send(r,"PUT",p,null);};
C.prototype.deleteChange=function(p,i){var r=this._getUrlPrefix(i);r+=p.sChangeName;var P=[];if(p.sLayer){P.push({name:"layer",value:p.sLayer});}if(p.sNamespace){P.push({name:"namespace",value:p.sNamespace});}if(p.sChangelist){P.push({name:"changelist",value:p.sChangelist});}r+=this._buildParams(P);return this.send(r,"DELETE",{},null);};
C.prototype.getStaticResource=function(n,N,t,i){var a="/sap/bc/lrep/content/";var r=a;r+=n+"/"+N+"."+t;var p=[];if(!i){p.push({name:"dt",value:"true"});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
C.prototype.getFileAttributes=function(n,N,t,l){var a="/sap/bc/lrep/content/";var r=a;r+=n+"/"+N+"."+t;var p=[];p.push({name:"metadata",value:"true"});if(l){p.push({name:"layer",value:l});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
C.prototype.upsert=function(n,N,t,l,c,s,a){var b=this;return Promise.resolve(b._fileAction("PUT",n,N,t,l,c,s,a));};
C.prototype.deleteFile=function(n,N,t,l,c){return this._fileAction("DELETE",n,N,t,l,null,null,c);};
C.prototype._fileAction=function(m,n,N,t,l,c,s,a){var A="/sap/bc/lrep/content/";var r=A;r+=n+"/"+N+"."+t;var p=[];p.push({name:"layer",value:l});if(a){p.push({name:"changelist",value:a});}r+=this._buildParams(p);var o={contentType:s||this.DEFAULT_CONTENT_TYPE};return this.send(r,m.toUpperCase(),c,o);};
C.prototype.publish=function(o,n,t,O,T,s,c){var a="/sap/bc/lrep/actions/publish/";var r=a;r+=o+"/"+n+"."+t;var p=[];if(O){p.push({name:"layer",value:O});}if(T){p.push({name:"target-layer",value:T});}if(s){p.push({name:"target-namespace",value:s});}if(c){p.push({name:"changelist",value:c});}r+=this._buildParams(p);return this.send(r,"POST",{},null);};
C.prototype.listContent=function(n,l){var r="/sap/bc/lrep/content/";r+=n;var p=[];if(l){p.push({name:"layer",value:l});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
return C;},true);
sap.ui.predefine('sap/ui/fl/Persistence',["sap/ui/fl/Change","sap/ui/fl/DefaultVariant","sap/ui/fl/StandardVariant","sap/ui/fl/Utils","jquery.sap.global","sap/ui/fl/LrepConnector","sap/ui/fl/Cache"],function(C,d,s,U,$,L,a){"use strict";var P=function(c,S){this._oControl=c;this._bHasLoadedChangesFromBackEnd=false;this._sStableIdPropertyName=S||'id';this._sStableId=this._getStableId();this._sComponentName=U.getComponentClassName(c);if(!this._sComponentName){U.log.error("The Control does not belong to a SAPUI5 component. Variants and Changes for this control might not work as expected.");}this._oAppDescriptor=U.getAppDescriptor(c);this._sSiteId=U.getSiteId(c);this._oChanges={};this._oMessagebundle={};this._oConnector=this._createLrepConnector();};
P.prototype.getComponentName=function(){return this._sComponentName;};
P.prototype.setComponentName=function(c){this._sComponentName=c;};
P.prototype._createLrepConnector=function(){var x,p;x=U.getXSRFTokenFromControl(this._oControl);p={XsrfToken:x};return L.createConnector(p);};
P.prototype._getStableId=function(){if(!this._oControl){return undefined;}if((this._sStableIdPropertyName)&&(this._sStableIdPropertyName!=='id')){var S;try{S=this._oControl.getProperty(this._sStableIdPropertyName);}catch(e){S="";}return S;}if(typeof this._oControl.getId!=='function'){return undefined;}return this._oControl.getId();};
P.prototype._existVendorLayerChange=function(){var e=false;jQuery.each(this._oChanges,function(c,o){var O=o._oOriginDefinition;if(O.layer==="VENDOR"){e=true;return false;}});return e;};
P.prototype._getOwnerComponentOfControl=function(c){if(!c){return undefined;}var o=sap.ui.core.Component.getOwnerIdFor(c);if(o){var O=sap.ui.component(o);return O;}return this._getOwnerComponentOfControl(c.getParent());};
P.prototype._checkForMessagebundleBinding=function(){if(this._existVendorLayerChange()){var o=this._getOwnerComponentOfControl(this._oControl);if(o&&!o.getModel("i18nFlexVendor")){var m=new sap.ui.model.json.JSONModel(this._oMessagebundle);o.setModel(m,"i18nFlexVendor");}}};
P.prototype.getChanges=function(){var t=this;var c=this._sComponentName;var p={appDescriptor:this._oAppDescriptor,siteId:this._sSiteId};if(this._bHasLoadedChangesFromBackEnd===true){if(this._oMessagebundle){this._checkForMessagebundleBinding();}return Promise.resolve(this._oChanges);}return a.getChangesFillingCache(this._oConnector,c,p).then(t._resolveFillingCacheWithChanges.bind(t));};
P.prototype._resolveFillingCacheWithChanges=function(f){this._fillRelevantChanges(f);if(f&&f.changes&&f.changes.messagebundle){this._oMessagebundle=f.changes.messagebundle;this._checkForMessagebundleBinding();}this._bHasLoadedChangesFromBackEnd=true;return this._oChanges;};
P.prototype.getComponentChanges=function(){var t=this;var p={appDescriptor:this._oAppDescriptor,siteId:this._sSiteId};return a.getChangesFillingCache(this._oConnector,this._sComponentName,p).then(function(f){var n=true;t._fillRelevantChanges(f,n);return t._oChanges;});};
P.prototype._fillRelevantChanges=function(f,n){var c,l,o,S,b,j,e;var t=this;var g=function(k,h){U.log.error("key : "+k+" and text : "+h.value);};var A=function(i,v){if(n===true&&o.fileType==='change'||t._sStableId===v){b=new C(o);b.attachEvent(C.events.markForDeletion,t._onDeleteChange.bind(t));e=b.getId();if(b.isValid()){if(t._oChanges[e]&&b.isVariant()){U.log.error("Id collision - two or more variant files having the same id detected: "+e);jQuery.each(b.getDefinition().texts,g);U.log.error("already exists in variant : ");jQuery.each(t._oChanges[e].getDefinition().texts,g);}t._oChanges[e]=b;}return false;}};if(f&&f.changes&&f.changes.changes){c=f.changes.changes;l=c.length;for(j=0;j<l;j++){o=c[j];S=o.selector;if(S){jQuery.each(S,A);}}}};
P.prototype.getChange=function(c){if(!c){U.log.error("sap.ui.fl.Persistence.getChange : sChangeId is not defined");return undefined;}return this._oChanges[c];};
P.prototype.addChange=function(p){var f,i,I,c;if(!p){return undefined;}if(!p.type){U.log.error("sap.ui.fl.Persistence.addChange : type is not defined");}var b=jQuery.type(p.content);if(b!=='object'&&b!=='array'){U.log.error("mParameters.content is not of expected type object or array, but is: "+b,"sap.ui.fl.Persistence#addChange");}I={};if(typeof(p.texts)==="object"){jQuery.each(p.texts,function(g,t){I[g]={value:t,type:"XFLD"};});}var A=U.getAppDescriptor(this._oControl);var e=this._sComponentName;if(A&&A["sap.app"]){e=A["sap.app"].componentName||A["sap.app"].id;}i={changeType:p.type,service:p.ODataService,texts:I,content:p.content,reference:this._sComponentName,componentName:e,isVariant:p.isVariant,packageName:p.packageName,isUserDependent:p.isUserDependent};i.selector=this._getSelector();f=C.createInitialFileContent(i);if(p.id){f.fileName=p.id;}c=this.addChangeFile(f);return c.getId();};
P.prototype.addChangeFile=function(c){var o,b;o=new C(c);o.attachEvent(C.events.markForDeletion,this._onDeleteChange.bind(this));b=o.getId();this._oChanges[b]=o;return o;};
P.prototype.removeChangeFromPersistence=function(c){if(c.getPendingAction()!=='NEW'){return;}var b=c.getId();delete this._oChanges[b];};
P.prototype.putChange=function(c){c.attachEvent(C.events.markForDeletion,this._onDeleteChange.bind(this));var b=c.getId();this._oChanges[b]=c;};
P.prototype._getSelector=function(){var S;S={};if(this._sStableIdPropertyName){S[this._sStableIdPropertyName]=this._sStableId;}return S;};
P.prototype.getExecuteOnSelect=function(){return this.getChanges().then(function(c){return s.getExecuteOnSelect(c);});};
P.prototype.getExecuteOnSelectSync=function(){return s.getExecuteOnSelect(this._oChanges);};
P.prototype.setExecuteOnSelectSync=function(e){var p,c;var b={};b[this._sStableIdPropertyName]=this._sStableId;p={executeOnSelect:e,reference:this._sComponentName,selector:b};c=s.updateExecuteOnSelect(this._oChanges,e);if(c){return c;}c=s.createChangeObject(p);c.attachEvent(C.events.markForDeletion,this._onDeleteChange.bind(this));var f=c.getId();this._oChanges[f]=c;return c;};
P.prototype.setExecuteOnSelect=function(e){var p,c;var t=this;return this.getChanges().then(function(o){var b={};b[t._sStableIdPropertyName]=t._sStableId;p={executeOnSelect:e,reference:t._sComponentName,selector:b};c=s.updateExecuteOnSelect(o,e);if(c){return c;}c=s.createChangeObject(p);c.attachEvent(C.events.markForDeletion,t._onDeleteChange.bind(t));o[c.getId()]=c;return c;});};
P.prototype.getDefaultVariantId=function(){return this.getChanges().then(function(c){return d.getDefaultVariantId(c);});};
P.prototype.getDefaultVariantIdSync=function(){return d.getDefaultVariantId(this._oChanges);};
P.prototype.setDefaultVariantIdSync=function(D){var p,c;var b={};b[this._sStableIdPropertyName]=this._sStableId;p={defaultVariantId:D,reference:this._sComponentName,selector:b};c=d.updateDefaultVariantId(this._oChanges,D);if(c){return c;}c=d.createChangeObject(p);c.attachEvent(C.events.markForDeletion,this._onDeleteChange.bind(this));var e=c.getId();this._oChanges[e]=c;return c;};
P.prototype.setDefaultVariantId=function(D){var p,c;var t=this;return this.getChanges().then(function(o){var b={};b[t._sStableIdPropertyName]=t._sStableId;p={defaultVariantId:D,reference:t._sComponentName,selector:b};c=d.updateDefaultVariantId(o,D);if(c){return c;}c=d.createChangeObject(p);c.attachEvent(C.events.markForDeletion,t._onDeleteChange.bind(t));o[c.getId()]=c;return c;});};
P.prototype.saveAll=function(){var p=[];var t=this;jQuery.each(this._oChanges,function(i,c){switch(c.getPendingAction()){case"NEW":p.push(t._oConnector.create(c.getDefinition(),c.getRequest(),c.isVariant()).then(function(r){c.setResponse(r.response);if(a.isActive()){a.addChange(c.getComponent(),r.response);}return r;}));break;case"UPDATE":p.push(t._oConnector.update(c.getDefinition(),c.getId(),c.getRequest(),c.isVariant()).then(function(r){c.setResponse(r.response);if(a.isActive()){a.updateChange(c.getComponent(),r.response);}return r;}));break;case"DELETE":p.push(t._oConnector.deleteChange({sChangeName:c.getId(),sLayer:c.getLayer(),sNamespace:c.getNamespace(),sChangelist:c.getRequest()},c.isVariant()).then(function(r){var b=c.getId();var m={id:b};c.fireEvent(C.events.markForDeletion,m);if(a.isActive()){a.deleteChange(c.getComponent(),c.getDefinition());}return r;}));break;default:break;}});return Promise.all(p);};
P.prototype._onDeleteChange=function(e){var c;c=e.getParameter("id");var o=this.getChange(c);if(o.getPendingAction()==="DELETE"){delete this._oChanges[c];}};
P.prototype.isVariantDownport=function(){var l,i;l=U.getCurrentLayer();i=U.isHotfixMode();return((l==='VENDOR')&&(i));};
return P;},true);
sap.ui.predefine('sap/ui/fl/Preprocessor',['jquery.sap.global','sap/ui/base/Object'],function(q,B){'use strict';return B.extend("sap.ui.fl.Preprocessor",{});},true);
sap.ui.predefine('sap/ui/fl/PreprocessorImpl',['jquery.sap.global','sap/ui/core/Component','sap/ui/fl/FlexControllerFactory','sap/ui/fl/Utils','sap/ui/fl/LrepConnector','sap/ui/fl/ChangePersistenceFactory'],function(jQuery,Component,FlexControllerFactory,Utils,LrepConnector,ChangePersistenceFactory){'use strict';var PreprocessorImpl=function(){};
PreprocessorImpl.prototype.getControllerExtensions=function(c,C,a){if(a){if(!C){jQuery.sap.log.warning("No component ID for determining the anchor of the code extensions was passed.");return[];}var o=sap.ui.component(C);var f=Utils.getAppComponentClassNameForComponent(o);var b=ChangePersistenceFactory.getChangePersistenceForComponent(f);return b.getChangesForComponent().then(function(d){var e=[];jQuery.each(d,function(i,g){var h=g.getDefinition();if(h.changeType==="codeExt"&&h.content&&c===h.selector.id){e.push(PreprocessorImpl.getExtensionProvider(h));}});return e;});}};
PreprocessorImpl.getExtensionProvider=function(oChange){var sConvertedAsciiCodeContent=oChange.content.code||{};var sConvertedCodeContent=Utils.asciiToString(sConvertedAsciiCodeContent);var oExtensionProvider;eval("oExtensionProvider = "+sConvertedCodeContent);return oExtensionProvider;};
return PreprocessorImpl;},true);
sap.ui.predefine('sap/ui/fl/RegistrationDelegator',["sap/ui/fl/FlexControllerFactory","sap/ui/core/Component","sap/ui/fl/registry/ChangeHandlerRegistration","sap/ui/fl/ChangePersistenceFactory","sap/ui/core/mvc/Controller","sap/ui/core/mvc/XMLView"],function(F,C,a,b,M,X){"use strict";var R={};
R.registerChangesInComponent=function(){C._fnOnInstanceCreated=F.getChangesAndPropagate;};
R.registerChangeHandlers=function(){a.getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs();};
R.registerLoadComponentEventHandler=function(){C._fnLoadComponentCallback=b._onLoadComponent.bind(b);};
R.registerExtensionProvider=function(){M.registerExtensionProvider("sap.ui.fl.PreprocessorImpl");};
R.registerXMLPreprocessor=function(){if(X.registerPreprocessor){X.registerPreprocessor("viewxml","sap.ui.fl.XmlPreprocessorImpl",true);}};
R.registerAll=function(){R.registerChangeHandlers();R.registerLoadComponentEventHandler();R.registerExtensionProvider();R.registerChangesInComponent();R.registerXMLPreprocessor();};
return R;},true);
sap.ui.predefine('sap/ui/fl/StandardVariant',["jquery.sap.global","sap/ui/fl/Change"],function($,C){"use strict";var S=function(){};
S.prototype.getExecuteOnSelect=function(c){var a=this.getNewestStandardVariantChangeDeleteTheRest(c);if(a){return a.getContent().executeOnSelect;}return null;};
S.prototype.getNewestStandardVariantChangeDeleteTheRest=function(c){var d=this.getStandardVariantChanges(c).sort(function(a,b){var D=new Date(a.getCreation());var e=new Date(b.getCreation());if(isNaN(D.getDate())){return-1;}if(isNaN(e.getDate())){return 1;}return e-D;});var n=d.shift();d.forEach(function(o){o.markForDeletion();});return n;};
S.prototype.getStandardVariantChanges=function(c){if(!c||typeof c!=='object'){return[];}return Object.keys(c).map(a).filter(b);function a(s){return c[s];}function b(o){return o.getChangeType()==='standardVariant';}};
S.prototype.updateExecuteOnSelect=function(c,n){var N=this.getNewestStandardVariantChangeDeleteTheRest(c);if(N){N.getContent().executeOnSelect=n;}return N;};
S.prototype._createChangeFile=function(p){var f;p.namespace=p.component+'/changes/standard';p.componentName=p.component;p.changeType='standardVariant';f=C.createInitialFileContent(p);f.content.executeOnSelect=p.executeOnSelect;f.layer='USER';return f;};
S.prototype.createChangeObject=function(p){var f,c;f=this._createChangeFile(p);c=new C(f);return c;};
return new S();},true);
sap.ui.predefine('sap/ui/fl/Utils',["jquery.sap.global","sap/ui/core/Component"],function(q,C){"use strict";var U={log:{error:function(m,d,c){q.sap.log.error(m,d,c);},warning:function(m,d,c){q.sap.log.warning(m,d,c);}},getXSRFTokenFromControl:function(c){var m;if(!c){return"";}if(c&&typeof c.getModel==="function"){m=c.getModel();return U._getXSRFTokenFromModel(m);}return"";},_getXSRFTokenFromModel:function(m){var h;if(!m){return"";}if(typeof m.getHeaders==="function"){h=m.getHeaders();if(h){return h["x-csrf-token"];}}return"";},getComponentClassName:function(c){var a;if(c){a=this.getAppComponentForControl(c);if(a){var v=this._getComponentStartUpParameter(a,"sap-app-id");if(v){return v;}if(a.getManifestEntry("sap.ui5")&&a.getManifestEntry("sap.ui5").appVariantId){return a.getManifestEntry("sap.ui5").appVariantId;}}}return U._getComponentName(a);},getAppComponentClassNameForComponent:function(c){return U.getComponentClassName(c);},getAppDescriptor:function(c){var m=null,o=null,a=null;if(c){o=this.getAppComponentForControl(c);if(o&&o.getMetadata){a=o.getMetadata();if(a&&a.getManifest){m=a.getManifest();}}}return m;},getSiteId:function(c){var s=null,o=null;if(c){o=this.getAppComponentForControl(c);if(o){s=this._getComponentStartUpParameter(o,"hcpApplicationId");}}return s;},getSiteIdByComponentData:function(c){var s=null;s=this._getStartUpParameter(c,"hcpApplicationId");return s;},isAppVariantMode:function(c){return(U.isVendorLayer()&&U.isApplicationVariant(c));},isBinding:function(p){var i=false;if(p&&typeof p==="string"&&p.substring(0,1)==="{"&&p.slice(-1)==="}"){i=true;}return i;},isVendorLayer:function(){if(U.getCurrentLayer(false)==="VENDOR"){return true;}return false;},isApplicationVariant:function(c){var f=U.getComponentClassName(c);var a=U.getAppComponentForControl(c);var s=U._getComponentName(a);return f!==s;},_getComponentStartUpParameter:function(c,p){var s=null;if(p){if(c&&c.getComponentData){s=this._getStartUpParameter(c.getComponentData(),p);}}return s;},_getStartUpParameter:function(c,p){if(c&&c.startupParameters&&p){if(q.isArray(c.startupParameters[p])){return c.startupParameters[p][0];}}},_getComponentName:function(c){var s="";if(c){s=c.getMetadata().getName();}if(s.length>0&&s.indexOf(".Component")<0){s+=".Component";}return s;},_getComponent:function(c){var o;if(c){o=sap.ui.getCore().getComponent(c);}return o;},_getComponentIdForControl:function(c){var s="",i=0;do{i++;s=U._getOwnerIdForControl(c);if(s){return s;}if(c&&typeof c.getParent==="function"){c=c.getParent();}else{return"";}}while(c&&i<100);return"";},getComponentForControl:function(c){return U._getComponentForControl(c);},getAppComponentForControl:function(c){var o;if(c instanceof sap.ui.core.Component){o=c;}else{o=this._getComponentForControl(c);}return this._getAppComponentForComponent(o);},_getComponentForControl:function(c){var o=null;var s=null;if(c){s=U._getComponentIdForControl(c);if(s){o=U._getComponent(s);}}return o;},_getAppComponentForComponent:function(c){var s=null;if(c&&c.getAppComponent){return c.getAppComponent();}if(c&&c.oComponentData&&c.oComponentData.appComponent){return c.oComponentData.appComponent;}if(c&&c.getManifestEntry){s=c.getManifestEntry("sap.app");}else{return c;}if(s&&s.type&&s.type!=="application"){if(c instanceof sap.ui.core.Component){c=this._getComponentForControl(c);}return this.getAppComponentForControl(c);}return c;},getViewForControl:function(c){return U.getFirstAncestorOfControlWithControlType(c,sap.ui.core.mvc.View);},getFirstAncestorOfControlWithControlType:function(c,a){if(c instanceof a){return c;}if(c&&typeof c.getParent==="function"){c=c.getParent();return U.getFirstAncestorOfControlWithControlType(c,a);}},hasControlAncestorWithId:function(c,a){var o;if(c===a){return true;}o=sap.ui.getCore().byId(c);while(o){if(o.getId()===a){return true;}if(typeof o.getParent==="function"){o=o.getParent();}else{return false;}}return false;},_isView:function(c){return c instanceof sap.ui.core.mvc.View;},_getOwnerIdForControl:function(c){return C.getOwnerIdFor(c);},getCurrentLayer:function(i){var u,l;if(i){return"USER";}u=this._getUriParameters();l=u.mParams["sap-ui-layer"];if(l&&l.length>0){return l[0];}return"CUSTOMER";},doesSharedVariantRequirePackage:function(){var c;c=U.getCurrentLayer(false);if((c==="VENDOR")||(c==="PARTNER")||(c==="CUSTOMER_BASE")){return true;}return false;},getClient:function(){var u,c;u=this._getUriParameters();c=u.mParams["sap-client"];if(c&&c.length>0){return c[0];}return undefined;},_getUriParameters:function(){return q.sap.getUriParameters();},isHotfixMode:function(){var u,i,I;u=this._getUriParameters();i=u.mParams["hotfix"];if(i&&i.length>0){I=i[0];}return(I==="true");},convertBrowserLanguageToISO639_1:function(b){if(!b||typeof b!=="string"){return"";}var n=b.indexOf("-");if((n<0)&&(b.length<=2)){return b.toUpperCase();}if(n>0&&n<=2){return b.substring(0,n).toUpperCase();}return"";},getCurrentLanguage:function(){var l=sap.ui.getCore().getConfiguration().getLanguage();return U.convertBrowserLanguageToISO639_1(l);},getControlType:function(c){var m;if(c&&typeof c.getMetadata==="function"){m=c.getMetadata();if(m&&typeof m.getElementName==="function"){return m.getElementName();}}},asciiToString:function(a){var b=a.split(",");var p="";q.each(b,function(i,c){p+=String.fromCharCode(c);});return p;},stringToAscii:function(s){var a="";for(var i=0;i<s.length;i++){a+=s.charCodeAt(i)+",";}a=a.substring(0,a.length-1);return a;},_fnCheckElementIsNoClone:function(e){var E=true;if(e.getBindingContext&&e.getBindingContext()){var b=e.getBindingContext().getPath().split("/");var l=b[b.length-1];E=isNaN(l);}return E;},checkControlId:function(c,a,s){var b=c instanceof sap.ui.base.ManagedObject?c.getId():c;if(!a){c=c instanceof sap.ui.base.ManagedObject?c:sap.ui.getCore().byId(b);a=U.getAppComponentForControl(c);}var i=sap.ui.base.ManagedObjectMetadata.isGeneratedId(b);if(!i||this.hasLocalIdSuffix(c,a)){return true;}else{var h=b.indexOf("--")!==-1;if(!s&&!h&&this._fnCheckElementIsNoClone(c)){this.log.warning("Generated id attribute found, to offer flexibility a stable control id is needed "+"to assign the changes to, but for this control the id was generated by SAPUI5",b);}return false;}},hasLocalIdSuffix:function(c,a){var s=(c instanceof sap.ui.base.ManagedObject)?c.getId():c;if(!a){this.log.error("determination of a local id suffix failed due to missing app component for "+s);return false;}return!!a.getLocalId(s);},_getAllUrlParameters:function(){return window.location.search.substring(1);},getUrlParameter:function(p){return q.sap.getUriParameters().get(p);},createDefaultFileName:function(n){var f=q.sap.uid().replace(/-/g,"_");if(n){f+='_'+n;}return f;},createNamespace:function(p,s){var r=p.reference.replace('.Component','');var n='apps/'+r+"/"+s+"/";return n;},isApplication:function(m){return(m&&m.getEntry("sap.app")&&m.getEntry("sap.app").type==="application");},getFlexReference:function(m){if(m){if(m.getEntry("sap.ui5")){if(m.getEntry("sap.ui5").appVariantId){return m.getEntry("sap.ui5").appVariantId;}if(m.getEntry("sap.ui5").componentName){return m.getEntry("sap.ui5").componentName+".Component";}}if(m.getEntry("sap.app")&&m.getEntry("sap.app").id){return m.getEntry("sap.app").id+".Component";}}this.log.warning("No Manifest received.");return"";}};return U;},true);
sap.ui.predefine('sap/ui/fl/XmlPreprocessorImpl',["jquery.sap.global","sap/ui/core/Component","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/ChangePersistence"],function(q,C,F,U,L,a,b){"use strict";var X=function(){};
X.process=function(v,p){try{if(!p||p.sync){U.log.warning("Flexibility feature for applying changes on an XML view is only available for "+"asynchronous views; merge is be done later on the JS controls.");return(v);}p.viewId=p.id;var c=sap.ui.getCore().getComponent(p.componentId);if(!c){U.log.warning("View is generated without an component. Flexibility features are not possible.");return Promise.resolve(v);}var f=U.getComponentClassName(c);var o=a.getChangePersistenceForComponent(f);var d=o.getCacheKey();if(!d||d===b.NOTAG){U.log.warning("No cache key could be determined for the view; flexibility XML view preprocessing is skipped. "+"The processing will be done later on the JS controls.");return Promise.resolve(v);}var e=F.create(f);return e.processXmlView(v,p).then(function(){q.sap.log.debug("flex processing view "+p.id+" finished");return v;});}catch(g){var E="view "+p.id+": "+g;q.sap.log.info(E);return Promise.resolve(v);}};
X.getCacheKey=function(p){var c=sap.ui.getCore().getComponent(p.componentId);var f=U.getComponentClassName(c);var o=a.getChangePersistenceForComponent(f);return o.getCacheKey();};
return X;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/Base',["sap/ui/fl/Utils","jquery.sap.global"],function(U,$){"use strict";var B={};
B.setTextInChange=function(c,k,t,T){if(!c.texts){c.texts={};}if(!c.texts[k]){c.texts[k]={};}c.texts[k].value=t;c.texts[k].type=T;};
return B;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseRename',["jquery.sap.global","./Base","sap/ui/fl/Utils"],function(q,B,U){"use strict";var a={createRenameChangeHandler:function(r){r.changePropertyName=r.changePropertyName||"newText";return{applyChange:function(c,C,p){var m=p.modifier;var P=r.propertyName;var o=c.getDefinition();var t=o.texts[r.changePropertyName];var v=t.value;if(o.texts&&t&&typeof(v)==="string"){if(U.isBinding(v)){m.setPropertyBinding(C,P,v);}else{m.setProperty(C,P,v);}return true;}else{U.log.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}},completeChangeContent:function(c,s,p){var C=c.getDefinition();var b=r.changePropertyName;var t=r.translationTextType;var o=p.modifier.bySelector(c.getSelector(),p.appComponent);C.content.originalControlType=p.modifier.getControlType(o);if(typeof(s.value)==="string"){B.setTextInChange(C,b,s.value,t);}else{throw new Error("oSpecificChangeInfo.value attribute required");}}};}};return a;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseTreeModifier',["sap/ui/fl/Utils","sap/ui/base/ManagedObject"],function(U,M){"use strict";return{bySelector:function(s,a,v){var c=this.getControlIdBySelector(s,a);return this._byId(c,v);},getControlIdBySelector:function(s,a){if(!s){return undefined;}if(typeof s==="string"){s={id:s};}var c=s.id;if(s.idIsLocal){if(a){c=a.createId(c);}else{throw new Error("App Component instance needed to get a control's id from selector");}}else{var p=/^application-[^-]*-[^-]*-component---/igm;var h=!!p.exec(s.id);if(h){c=c.replace(/^application-[^-]*-[^-]*-component---/g,"");if(a){c=a.createId(c);}else{throw new Error("App Component instance needed to get a control's id from selector");}}}return c;},getSelector:function(c,a,A){var C=c;if(c instanceof M){C=c.getId();}else{if(!a){throw new Error("App Component instance needed to get a selector from string id");}}if(A&&(A.id||A.idIsLocal)){throw new Error("A selector of control with the id '"+C+"' was requested, "+"but core properties were overwritten by the additionally passed information.");}var v=U.checkControlId(c,a);if(!v){throw new Error("Generated id attribute found - to offer flexibility a stable control id is needed to assign the changes to, but for this control the id was generated by SAPUI5 "+C);}var s=jQuery.extend(A||{},{id:"",idIsLocal:false},true);if(U.hasLocalIdSuffix(c,a)){var l=a.getLocalId(C);s.id=l;s.idIsLocal=true;}else{s.id=C;}return s;}};});
sap.ui.predefine('sap/ui/fl/changeHandler/HideControl',['jquery.sap.global','./Base'],function(q,B){"use strict";var H={};
H.applyChange=function(c,C,p){p.modifier.setVisible(C,false);return true;};
H.completeChangeContent=function(c,s){};
return H;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/JsControlTreeModifier',["sap/ui/fl/changeHandler/BaseTreeModifier","sap/ui/fl/Utils"],function(B,U){"use strict";var J={targets:"jsControlTree",setVisible:function(c,v){if(c.setVisible){this.unbindProperty(c,"visible");c.setVisible(v);}else{throw new Error("Provided control instance has no setVisible method");}},getVisible:function(c){if(c.getVisible){return c.getVisible();}else{throw new Error("Provided control instance has no getVisible method");}},setStashed:function(c,s){if(c.setStashed){if(c.setVisible){c.setVisible(!s);}c.setStashed(s);}else{throw new Error("Provided control instance has no setStashed method");}},bindProperty:function(c,p,b){c.bindProperty(p,b);},unbindProperty:function(c,p){if(c){c.unbindProperty(p,true);}},setProperty:function(c,p,P){var m=c.getMetadata().getPropertyLikeSetting(p);this.unbindProperty(c,p);if(m){var s=m._sMutator;c[s](P);}},getProperty:function(c,p){var m=c.getMetadata().getPropertyLikeSetting(p);if(m){var P=m._sGetter;return c[P]();}},setPropertyBinding:function(c,p,P){var s={};s[p]=P;c.applySettings(s);},createControl:function(c,a,v,s){if(this.bySelector(s,a)){throw new Error("Can't create a control with duplicated id "+s);}jQuery.sap.require(c);var C=jQuery.sap.getObject(c);var i=this.getControlIdBySelector(s,a);return new C(i);},byId:function(i){return this._byId(i);},_byId:function(i){return sap.ui.getCore().byId(i);},getId:function(c){return c.getId();},getParent:function(c){return c.getParent();},getControlType:function(c){return U.getControlType(c);},getAggregation:function(p,n){if(p){if(p.getMetadata){var m=p.getMetadata();var a=m.getAllAggregations();if(a){var A=a[n];if(A){return p[A._sGetter]();}}}}},insertAggregation:function(p,n,o,i){if(p){if(p.getMetadata){var m=p.getMetadata();var a=m.getAllAggregations();if(a){var A=a[n];if(A){if(A.multiple){var I=i||0;p[A._sInsertMutator](o,I);}else{p[A._sMutator](o);}}}}}},removeAggregation:function(c,n,o){if(c){if(c.getMetadata){var m=c.getMetadata();var a=m.getAllAggregations();if(a){var A=a[n];if(A){c[A._sRemoveMutator](o);}}}}},removeAllAggregation:function(c,n){if(c){if(c.getMetadata){var m=c.getMetadata();var a=m.getAllAggregations();if(a){var A=a[n];if(A){c[A._sRemoveAllMutator]();}}}}}};return jQuery.sap.extend(true,{},B,J);},true);
sap.ui.predefine('sap/ui/fl/changeHandler/MoveControls',["jquery.sap.global","./Base","sap/ui/fl/Utils"],function(q,B,F){"use strict";var M={};M.CHANGE_TYPE="moveControls";
M._checkConditions=function(c,m,v,a){if(!c){throw new Error("No change instance");}var C=c.getContent();if(!C||!C.movedElements||C.movedElements.length===0){throw new Error("Change format invalid");}if(!C.source||!C.source.selector){throw new Error("No source supplied for move");}if(!C.target||!C.target.selector){throw new Error("No target supplied for move");}if(!m.bySelector(C.source.selector,a,v)){throw new Error("Move source parent not found");}if(!m.bySelector(C.target.selector,a,v)){throw new Error("Move target parent not found");}if(!C.source.selector.aggregation){throw new Error("No source aggregation supplied for move");}if(!C.target.selector.aggregation){throw new Error("No target aggregation supplied for move");}};
M._getElementControlOrThrowError=function(m,o,a,v){if(!m.selector&&!m.id){throw new Error("Change format invalid - moveElements element has no id attribute");}if(typeof m.targetIndex!=="number"){throw new Error("Missing targetIndex for element with id '"+m.selector.id+"' in movedElements supplied");}return o.bySelector(m.selector||m.id,a,v);};
M._checkCompleteChangeContentConditions=function(s){if(!s.movedElements){throw new Error("mSpecificChangeInfo.movedElements attribute required");}if(s.movedElements.length===0){throw new Error("MovedElements array is empty");}s.movedElements.forEach(function(e){if(!e.id){throw new Error("MovedControls element has no id attribute");}if(typeof(e.sourceIndex)!=="number"){throw new Error("SourceIndex attribute at MovedElements element is no number");}if(typeof(e.targetIndex)!=="number"){throw new Error("TargetIndex attribute at MovedElements element is no number");}});};
M._getSpecificChangeInfo=function(m,s,a){delete s.source.publicAggregation;delete s.target.publicAggregation;var S=s.source.parent||m.bySelector(s.source.id,a);var t=s.target.parent||m.bySelector(s.target.id,a);var b=s.source.aggregation;var T=s.target.aggregation;var A={aggregation:s.source.aggregation,type:m.getControlType(S)};var c={aggregation:s.target.aggregation,type:m.getControlType(t)};var d={source:{id:S.getId(),aggregation:b,type:A.type,selector:m.getSelector(s.source.id,a,A)},target:{id:t.getId(),aggregation:T,type:c.type,selector:m.getSelector(s.target.id,a,c)},movedElements:s.movedElements};return d;};
M.applyChange=function(c,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;this._checkConditions(c,m,v,a);var C=c.getContent();var s=m.bySelector(C.source.selector,a,v);var t=m.bySelector(C.target.selector,a,v);var S=C.source.selector.aggregation;var T=C.target.selector.aggregation;C.movedElements.forEach(function(b){var o=this._getElementControlOrThrowError(b,m,a,v);if(!o){F.log.warning("Element to move not found");return;}m.removeAggregation(s,S,o,v);m.insertAggregation(t,T,o,b.targetIndex);},this);return true;};
M.completeChangeContent=function(c,s,p){this._checkCompleteChangeContentConditions(s);var m=p.modifier;var a=p.appComponent;var C=c.getDefinition();s=this._getSpecificChangeInfo(m,s,a);C.changeType=M.CHANGE_TYPE;C.content={movedElements:[],source:{selector:s.source.selector},target:{selector:s.target.selector}};s.movedElements.forEach(function(e){var E=e.element||m.bySelector(e.id,a);C.content.movedElements.push({selector:m.getSelector(E,a),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex});});};
return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/MoveElements',["jquery.sap.global","./Base","sap/ui/fl/Utils","sap/ui/fl/changeHandler/JsControlTreeModifier"],function(q,B,F,J){"use strict";var M={};M.CHANGE_TYPE="moveElements";
M.applyChange=function(c,s,p){function a(c,m,v,A){if(!c){throw new Error("No change instance");}var C=c.getContent();if(!C||!C.movedElements||C.movedElements.length===0){throw new Error("Change format invalid");}if(!c.getSelector().aggregation){throw new Error("No source aggregation supplied via selector for move");}if(!C.target||!C.target.selector){throw new Error("No target supplied for move");}if(!m.bySelector(C.target.selector,A,v)){throw new Error("Move target parent not found");}if(!C.target.selector.aggregation){throw new Error("No target aggregation supplied for move");}}function g(b,m,A,v){if(!b.selector&&!b.id){throw new Error("Change format invalid - moveElements element has no id attribute");}if(typeof b.targetIndex!=="number"){throw new Error("Missing targetIndex for element with id '"+b.selector.id+"' in movedElements supplied");}return m.bySelector(b.selector||b.id,A,v);}var m=p.modifier;var v=p.view;var A=p.appComponent;a(c,m,v,A);var C=c.getContent();var t=m.bySelector(C.target.selector,A,v);var S=c.getSelector().aggregation;var T=C.target.selector.aggregation;C.movedElements.forEach(function(b){var o=g(b,m,A,v);if(!o){F.log.warning("Element to move not found");return;}m.removeAggregation(s,S,o,v);m.insertAggregation(t,T,o,b.targetIndex);});return true;};
M.completeChangeContent=function(){throw new Error('Using deprecated change handler. Please consider of using \'MoveControls\' instead');};
M.getSpecificChangeInfo=function(m,s){var S=s.source.parent||m.bySelector(s.source.id);var t=s.target.parent||m.bySelector(s.target.id);var a=s.source.aggregation;var T=s.target.aggregation;var b={source:{id:S.getId(),aggregation:a,type:m.getControlType(S)},target:{id:t.getId(),aggregation:T,type:m.getControlType(t)},movedElements:s.movedElements};return b;};
return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/PropertyBindingChange',["jquery.sap.global","sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils"],function(q,B,F){"use strict";var P={};
P.applyChange=function(c,C,p){var d=c.getDefinition();var s=d.content.property;var o=d.content.newBinding;p.modifier.setPropertyBinding(C,s,o);};
P.completeChangeContent=function(c,s){var C=c.getDefinition();if(s.content){C.content=s.content;}else{throw new Error("oSpecificChangeInfo attribute required");}};
return P;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/PropertyChange',["jquery.sap.global","sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils"],function(q,B,F){"use strict";var P={};
P.applyChange=function(c,C,p){try{var d=c.getDefinition();var s=d.content.property;var o=d.content.newValue;if(F.isBinding(o)){p.modifier.setPropertyBinding(C,s,o);}else{p.modifier.setProperty(C,s,o);}}catch(e){throw new Error("Applying property changes failed: "+e);}};
P.completeChangeContent=function(c,s){var C=c.getDefinition();if(s.content){C.content=s.content;}else{throw new Error("oSpecificChangeInfo attribute required");}};
return P;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/StashControl',['jquery.sap.global','./Base'],function(q,B){"use strict";var S={};
S.applyChange=function(c,C,p){p.modifier.setVisible(C,false);p.modifier.setStashed(C,true);return true;};
S.completeChangeContent=function(c,s){};
return S;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UnhideControl',['jquery.sap.global','./Base'],function(q,B){"use strict";var U={};
U.applyChange=function(c,C,p){p.modifier.setVisible(C,true);return true;};
U.completeChangeContent=function(c,s){var C=c.getDefinition();if(!C.content){C.content={};}};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UnstashControl',['jquery.sap.global','./Base'],function(q,B){"use strict";var U={};
U.applyChange=function(c,C,p){var m=c.getContent();var M=p.modifier;M.setStashed(C,false);if(m.parentAggregationName){var t=m.parentAggregationName;var T=M.getParent(C);M.removeAggregation(T,t,C);M.insertAggregation(T,t,C,m.index);}return true;};
U.completeChangeContent=function(c,s){var C=c.getDefinition();if(s.content){C.content=s.content;}};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/XmlTreeModifier',["sap/ui/fl/changeHandler/BaseTreeModifier"],function(B){"use strict";var X={targets:"xmlTree",setVisible:function(c,p){this.setProperty(c,"visible",p);},getVisible:function(c){return this.getProperty(c,"visible");},setStashed:function(c,p){this.setProperty(c,"stashed",p);},bindProperty:function(c,p,b){c.setAttribute(p,"{"+b+"}");},setProperty:function(c,p,P){c.setAttribute(p,P);},getProperty:function(c,p){return c.getAttribute(p);},setPropertyBinding:function(c,p,P){c.setAttribute(p,P);},createControl:function(c,a,v,s){if(!this.bySelector(s,a,v)){var n=v.createElement(c);var i=this.getControlIdBySelector(s,a);if(i){n.setAttribute("id",i);}return n;}else{throw new Error("Can't create a control with duplicated id "+i);}},byId:function(i,v){return this._byId(i,v);},_byId:function(i,v){if(v){if(v.ownerDocument&&v.ownerDocument.getElementById&&v.ownerDocument.getElementById(i)){return v.ownerDocument.getElementById(i);}else if(v.getElementById&&v.getElementById(i)){return v.getElementById(i);}}var n=jQuery(v).find("#"+i);if(n.length===1){return n[0];}},getId:function(c){return c.getAttribute("id");},getParent:function(c){var p=c.parentNode;if(!this.getId(p)){p=p.parentNode;}return p;},_getLocalName:function(x){return x.localName||x.baseName||x.nodeName;},getControlType:function(c){var C=c.namespaceURI;C=(C?C+".":"");C+=this._getLocalName(c);return C;},getAggregation:function(p,n){var a=this._findAggregationNode(p,n);return Array.prototype.slice.call(this._children(a));},insertAggregation:function(p,n,o,i,v,N,a){var A=this._findAggregationNode(p,n,v,N,a);if(i>=A.childElementCount){A.appendChild(o);}else{var r=this._children(A)[i];A.insertBefore(o,r);}},removeAggregation:function(p,n,o,v){var a=this._findAggregationNode(p,n,v);a.removeChild(o);},removeAllAggregation:function(c,n,v){var a=this._findAggregationNode(c,n,v);if(c===a){var C=this._children(c);for(var i=0;i<C.length;i++){c.removeChild(C[i]);}}else{c.removeChild(a);}},_findAggregationNode:function(p,n,v,N,a){var A;if(N){A=this.createControl(n,a,v);p.appendChild(A);}else{var c=this._children(p);for(var i=0;i<c.length;i++){var o=c[i];if(o.localName===n){A=o;break;}}if(!A){A=p;}}return A;},_children:function(p){if(p.children){return p.children;}else{var c=[];for(var i=0;i<p.childNodes.length;i++){var n=p.childNodes[i];if(n.nodeType===n.ELEMENT_NODE){c.push(n);}}return c;}}};return jQuery.sap.extend(true,{},B,X);},true);
sap.ui.predefine('sap/ui/fl/codeExt/CodeExtManager',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/Change"],function(L,U,C){"use strict";var a;a={_oLrepConnector:new L(),createOrUpdateCodeExtChange:function(p,o){if(!p.content||!p.content.codeRef){throw new Error("no code reference passed for the code extension change");}if(!p.selector||!p.selector.id){throw new Error("no controller name passed for the code extension change");}if(!p.reference){throw new Error("no reference passed for the code extension change");}p.changeType=p.changeType||"codeExt";var c=C.createInitialFileContent(p);var u="/sap/bc/lrep/content/"+c.namespace+c.fileName+".change";u+="?layer="+c.layer;if(o){if(o.transportId){u+="&changelist="+o.transportId;}if(o.packageName){u+="&package="+o.packageName;}}var m="PUT";return this._oLrepConnector.send(u,m,c,{});},createCodeExtChanges:function(c,o){c=c||[];if(c.length===0){return Promise.resolve();}var p=[];c.forEach(function(b){b.changeType=b.changeType||"codeExt";b.packageName=o.packageName;b.content={codeRef:o.codeRef};p.push(C.createInitialFileContent(b));});return this._oLrepConnector.create(p,o.transportId);},deleteCodeExtChange:function(c,o){if(c.changeType!=="codeExt"||c.fileType!=="change"){throw new Error("the change is not of type 'code extension'");}if(!c.fileName){throw new Error("the extension does not contains a file name");}if(c.namespace===undefined){throw new Error("the extension does not contains a namespace");}var u="/sap/bc/lrep/content/"+c.namespace+c.fileName+".change";if(c.layer){u+="&layer="+c.layer;}if(o){if(o.transportId){u+="&changelist="+o.transportId;}if(o.packageName){u+="&package="+o.packageName;}}u=u.replace("&","?");var m="DELETE";return this._oLrepConnector.send(u,m,c,{});}};return a;},true);
sap.ui.predefine('sap/ui/fl/context/BaseContextProvider',['sap/ui/base/ManagedObject'],function(M){"use strict";
var B=M.extend("sap.ui.fl.context.BaseContextProvider",{metadata:{properties:{text:{type:"String"},description:{type:"String"}}}});
B.prototype.loadData=function(){return Promise.resolve({});};
B.prototype.getValue=function(r){return this.loadData().then(function(d){var R=r&&r.split(".")||[];var m=R.reduce(function(c,C){if(c&&c.hasOwnProperty(C)){return c[C];}return undefined;},d);return m;});};
B.prototype.getValueHelp=function(r){return Promise.resolve({});};
B.prototype.validate=function(k,v){return Promise.resolve(true);};
return B;},true);
sap.ui.predefine('sap/ui/fl/context/Context',['sap/ui/base/ManagedObject'],function(M){"use strict";
var C=M.extend("sap.ui.fl.context.Context",{metadata:{library:"sap.ui.fl",properties:{configuration:{type:"object"},content:{type:"object"}},aggregations:{contextProviders:{type:"object",multiple:true}},events:{}}});
C.prototype.getValue=function(R){return this._getProviderContent(R,"getValue");};
C.prototype.getValueHelp=function(R){return this._getProviderContent(R,"getValueHelp");};
var r=function(d,R){if(d.indexOf(R)!==-1){return undefined;}if(R.indexOf(d+".")!==-1){return R.substring(d.length+1);}throw new Error("Invalid request for sap.ui.fl.context - domain:"+d+"request:"+R);};
C.prototype._getProviderContent=function(R,p){var t=this;var P=[];var a=[];var h=function(s){var A=t._assureDomain(s);if(A){var o=t._loadProvider(A);P.push(o);a.push({domain:A,request:r(A,s)});}else{a.push({domain:undefined,request:s});}};var m=function(D){var c=t.getConfiguration();var b=false;for(var i=0;i<D.length;i++){var o=D[i];if(o){c[o.domain]=o.provider;b=true;}}if(b){t.setConfiguration(c);}};if(R instanceof Array){R.forEach(function(s){h(s);});}else if(R===undefined){for(var d in this.getConfiguration()){P.push(this._loadProvider(d));}a=Object.keys(this.getConfiguration()).map(function(d){return{domain:d,request:undefined};});}return Promise.all(P).then(m).then(function(){return t._mergeProviderContent(a,p,R);});};
C.prototype._assureDomain=function(d){var c=this.getConfiguration();if(c.hasOwnProperty(d)){return d;}else{var k=Object.keys(c);for(var i=0;i<k.length;i++){var K=k[i];if(d.indexOf(K)===0||K.indexOf(d)===0){return K;}}}return null;};
C.prototype._loadProvider=function(d,c){var a=this.getConfiguration()[d];if(typeof(a)==="string"){return new Promise(function(b,e){try{sap.ui.require([a],function(P){var p=new P();b({"domain":d,"provider":p});});}catch(E){jQuery.sap.log.error(E);b();return;}});}else{return Promise.resolve();}};
C.prototype._mergeProviderContent=function(R,p,a){var P=[];var c=this.getConfiguration();R.forEach(function(o){if(c.hasOwnProperty(o.domain)){var A=c[o.domain];if(A instanceof sap.ui.fl.context.BaseContextProvider){P.push(A[p].call(A,o.request).then(function(v){var s={};var b=o.domain;if(o.request){b=b+"."+o.request;}s[b]=v;return s;}));}}else{var s={};s[o.request]=undefined;P.push(Promise.resolve(s));}});return Promise.all(P).then(function(b){return b.reduce(function(m,d){var k=Object.keys(d)[0];m[k]=d[k];return m;},{});});};
return C;},true);
sap.ui.predefine('sap/ui/fl/context/ContextManager',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/context/Context"],function(L,U,C){"use strict";var a;a={_oContext:new C({configuration:{"device":"sap/ui/fl/context/DeviceContextProvider","switches":"sap/ui/fl/context/SwitchContextProvider"}}),_oLrepConnector:new L(),doesContextMatch:function(c,A){var s=c.context||"";if(!s){return true;}return jQuery.inArray(s,A)!==-1;},getActiveContexts:function(c){var d=this._getContextIdsFromUrl();if(d.length===0){return this._getContextParametersFromAPI(c).then(this._getActiveContextsByAPIParameters.bind(this,c));}else{return Promise.resolve(this._getActiveContextsByUrlParameters(c,d));}},_getContextParametersFromAPI:function(c){var r=[];c.forEach(function(o){o.parameters.forEach(function(b){var s=b.selector;if(r.indexOf(s)===-1){r.push(s);}});});return this._oContext.getValue(r);},_getActiveContextsByAPIParameters:function(c,r){var t=this;var A=[];c.forEach(function(o){if(t._isContextObjectActive(o,r)){A.push(o.id);}});return A;},_getActiveContextsByUrlParameters:function(c,d){var A=[];c.forEach(function(o){var b=jQuery.inArray(o.id,d)!==-1;if(b){A.push(o.id);}});return A;},_isContextObjectActive:function(c,r){var t=this;var b=true;var p=c.parameters;p.every(function(P){b=b&&t._checkContextParameter(P,r);return b;});return b;},_getContextIdsFromUrl:function(){var c=U.getUrlParameter("sap-ui-flexDesignTimeContext");if(!c){return[];}return c.split(",");},_checkContextParameter:function(p,r){var s=p.selector;var o=p.operator;var v=p.value;switch(o){case"EQ":return this._checkEquals(s,v,r);case"NE":return!this._checkEquals(s,v,r);default:jQuery.sap.log.info("A context within a flexibility change with the operator '"+o+"' could not be verified");return false;}},_checkEquals:function(s,v,r){return r[s]===v;},createOrUpdateContextObject:function(p){if(!p.reference){throw new Error("no reference passed for the context object");}if(!p.namespace){throw new Error("no namespace passed for the context object");}var i=p.id||U.createDefaultFileName();p={id:i,fileName:i,title:p.title||"",description:p.description||"",parameters:p.parameters||[],fileType:"context",reference:p.reference||"",packageName:p.packageName||"",layer:p.layer||U.getCurrentLayer(false),namespace:p.namespace,creation:p.creation||"",originalLanguage:p.originalLanguage||U.getCurrentLanguage(),support:p.support||{generator:"",service:"",user:""}};var u="/sap/bc/lrep/content/"+p.namespace+p.fileName+".context";u+="?layer="+p.layer;var m="PUT";return this._oLrepConnector.send(u,m,p,{});}};return a;},true);
sap.ui.predefine('sap/ui/fl/context/DeviceContextProvider',["sap/ui/fl/context/BaseContextProvider","sap/ui/Device"],function(B,D){"use strict";
var a=B.extend("sap.ui.fl.context.DeviceContextProvider",{metadata:{properties:{text:{type:"String",defaultValue:"Device"},description:{type:"String",defaultValue:"Returns the values of sap.ui.Device"}}}});
a.prototype.loadData=function(){return Promise.resolve(D);};
a.prototype.getValueHelp=function(){return Promise.resolve({});};
a.prototype.validate=function(k,v){return Promise.resolve(true);};
return a;},true);
sap.ui.predefine('sap/ui/fl/context/SwitchContextProvider',["sap/ui/fl/context/BaseContextProvider","sap/ui/fl/Cache"],function(B,C){"use strict";
var S=B.extend("sap.ui.fl.context.SwitchContextProvider",{metadata:{properties:{text:{type:"String",defaultValue:"Switch"},description:{type:"String",defaultValue:"Returns the values of switches recieved in the flexibility response from the back end"}}}});
S.prototype.loadData=function(){return Promise.resolve(C.getSwitches());};
S.prototype.getValueHelp=function(){return Promise.resolve({});};
S.prototype.validate=function(k,v){return Promise.resolve(true);};
return S;},true);
sap.ui.predefine('sap/ui/fl/core/EventDelegate',["jquery.sap.global","sap/ui/fl/Utils","sap/ui/base/EventProvider","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/core/FlexVisualizer"],function(q,U,E,C,F){"use strict";var a=function(c,s){if(!c){U.log.error("sap.ui.fl.core.EventDelegate: Control required");}if(!s){U.log.error("sap.ui.fl.core.EventDelegate: Supported registry items required");}E.apply(this);this._oControl=c;this._oSupportedRegistryItems=s;};a.prototype=q.sap.newObject(E.prototype);
a.registerControl=function(c){if(c){var i=0;if(c.aDelegates){for(i=0;i<c.aDelegates.length;i++){var t="";if(c.aDelegates[i].oDelegate&&c.aDelegates[i].oDelegate.getType){t=(c.aDelegates[i].oDelegate.getType());}if(t==="Flexibility"){return;}}}a.registerExplicitChanges(c);}};
a.registerExplicitChanges=function(c){var r=C.getInstance();var p={controlType:U.getControlType(c)};var s=r.getRegistryItems(p);if(Object.keys(s).length>0){c.addEventDelegate(new a(c,s));}};
a.unregisterControl=function(){};
a.prototype.onmouseover=function(e){e.stopPropagation();if(e.handled){return;}else{e.handled=true;}if(F.isPersonalizationMode()){if(this._oControl&&!q(this._oControl.getDomRef()).hasClass("sapuiflex-highlight")){F.showDialog(this._oControl);}}};
a.prototype.onmouseout=function(e){if(F.isPersonalizationMode()){if(this._oControl){F.closeDialog();}}};
return a;},true);
sap.ui.predefine('sap/ui/fl/core/FlexVisualizer',["jquery.sap.global"],function(q){"use strict";var F=function(){};
F.showDialog=function(a,i){};
F.closeDialog=function(){};
return F;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory',["sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/ChangePersistence","sap/ui/fl/Change","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/descriptorRelated/api/Settings"],function(C,a,b,U,S){"use strict";var D=function(m,i,s){this._mChangeFile=m;this._mChangeFile.packageName='$TMP';this._oInlineChange=i;this._sTransportRequest=null;this._oSettings=s;};
D.prototype.setTransportRequest=function(t){try{U.checkTransportRequest(t);}catch(e){return Promise.reject(e);}this._sTransportRequest=t;return Promise.resolve();};
D.prototype.setPackage=function(p){try{U.checkPackage(p);}catch(e){return Promise.reject(e);}this._mChangeFile.packageName=p;return Promise.resolve();};
D.prototype.submit=function(){var s=this._mChangeFile.reference;var o=C.getChangePersistenceForComponent(s);var d=this._getChangeToSubmit();o.addChange(d);return o.saveDirtyChanges();};
D.prototype._getChangeToSubmit=function(){var o=new b(this._getMap());if(this._sTransportRequest){o.setRequest(this._sTransportRequest);}else if(this._oSettings.isAtoEnabled()&&this._mChangeFile.layer=='CUSTOMER'){o.setRequest('ATO_NOTIFICATION');}return o;};
D.prototype._getMap=function(){var i=this._oInlineChange.getMap();this._mChangeFile.content=i.content;this._mChangeFile.texts=i.texts;return this._mChangeFile;};
D.prototype.getJson=function(){return jQuery.extend(true,{},this._getMap());};
var c=function(){};
c.prototype.createNew=function(r,i,l){var s=function(_,I){if(_["setHostingIdForTextKey"]){_.setHostingIdForTextKey(I);}};s(i,r);var p={};p.changeType=i._getChangeType();p.componentName=r;p.reference=r;if(!l){p.layer='CUSTOMER';}else{if(l!='VENDOR'&&l!='CUSTOMER'){throw new Error("Parameter \"sLayer\" needs to be 'VENDOR', 'CUSTOMER'");}p.layer=l;}var m=b.createInitialFileContent(p);return S.getInstance().then(function(o){return Promise.resolve(new D(m,i,o));});};
return c;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory',["sap/ui/fl/descriptorRelated/internal/Utils"],function(U){"use strict";var D=function(c,p,t){U.checkTexts(t);this._mParameters={};this._mParameters.changeType=c;this._mParameters.content=p;this._mParameters.texts=t;};
D.prototype._getChangeType=function(){return this._mParameters.changeType;};
D.prototype.getMap=function(){return this._mParameters;};
var a={};
a.getDescriptorChangeTypes=function(){return["appdescr_ovp_addNewCard","appdescr_ovp_removeCard","appdescr_app_addNewInbound","appdescr_app_changeInbound","appdescr_app_removeInbound","appdescr_app_addNewOutbound","appdescr_app_changeOutbound","appdescr_app_removeOutbound","appdescr_app_addNewDataSource","appdescr_app_changeDataSource","appdescr_app_removeDataSource","appdescr_app_addAnnotationsToOData","appdescr_app_setTitle","appdescr_app_setSubTitle","appdescr_app_setDescription","appdescr_app_setDestination","appdescr_app_setKeywords","appdescr_ui5_addNewModel","appdescr_smb_addNamespace","appdescr_smb_changeNamespace","appdescr_ui_generic_app_setMainPage"];};
a.createNew=function(c,p,t){var d=new D(c,p,t);return new Promise(function(r,b){if(d){r(d);}else{var e={};b(e);}});};
a._createDescriptorInlineChange=function(d,p,t){var o=new D(d,p,t);return new Promise(function(r,b){if(o){r(o);}else{var e={};b(e);}});};
a.createDescriptorInlineChange=function(d,p,t){return this._createDescriptorInlineChange(d,p,t);};
a.create_ovp_addNewCard=function(p,t){U.checkParameterAndType(p,"card","object");return this._createDescriptorInlineChange('appdescr_ovp_addNewCard',p,t);};
a.create_ovp_removeCard=function(p){U.checkParameterAndType(p,"cardId","string");return this._createDescriptorInlineChange('appdescr_ovp_removeCard',p);};
a.create_app_addNewInbound=function(p,t){U.checkParameterAndType(p,"inbound","object");return this._createDescriptorInlineChange('appdescr_app_addNewInbound',p,t);};
a.create_app_removeInbound=function(p){U.checkParameterAndType(p,"inboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeInbound',p);};
a.create_app_changeInbound=function(p,t){U.checkParameterAndType(p,"inboundId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeInbound',p,t);};
a.create_app_addNewOutbound=function(p){U.checkParameterAndType(p,"outbound","object");return this._createDescriptorInlineChange('appdescr_app_addNewOutbound',p);};
a.create_app_removeOutbound=function(p){U.checkParameterAndType(p,"outboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeOutbound',p);};
a.create_app_changeOutbound=function(p){U.checkParameterAndType(p,"outboundId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeOutbound',p);};
a.create_app_addNewDataSource=function(p){U.checkParameterAndType(p,"dataSource","object");return this._createDescriptorInlineChange('appdescr_app_addNewDataSource',p);};
a.create_app_removeDataSource=function(p){U.checkParameterAndType(p,"dataSourceId","string");return this._createDescriptorInlineChange('appdescr_app_removeDataSource',p);};
a.create_app_changeDataSource=function(p){U.checkParameterAndType(p,"dataSourceId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeDataSource',p);};
a.create_app_addAnnotationsToOData=function(p){U.checkParameterAndType(p,"dataSourceId","string");U.checkParameterAndType(p,"annotations","array");U.checkParameterAndType(p,"dataSource","object");return this._createDescriptorInlineChange('appdescr_app_addAnnotationsToOData',p);};
a.create_app_setTitle=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.title";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setSubTitle=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setSubTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.subTitle";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setDescription=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setDescription',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.description";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setDestination=function(p){U.checkParameterAndType(p,"destination","object");return this._createDescriptorInlineChange('appdescr_app_setDestination',p);};
a.create_app_setKeywords=function(p,t){U.checkParameterAndType(p,"keywords","array");return this._createDescriptorInlineChange('appdescr_app_setKeywords',p,t);};
a.create_ui5_addNewModel=function(p){U.checkParameterAndType(p,"model","object");return this._createDescriptorInlineChange('appdescr_ui5_addNewModel',p);};
a.create_smb_addNamespace=function(p){U.checkParameterAndType(p,"smartBusinessApp","object");return this._createDescriptorInlineChange('appdescr_smb_addNamespace',p);};
a.create_smb_changeNamespace=function(p){U.checkParameterAndType(p,"smartBusinessApp","object");return this._createDescriptorInlineChange('appdescr_smb_changeNamespace',p);};
a.create_ui_generic_app_setMainPage=function(p,t){U.checkParameterAndType(p,"page","object");return this._createDescriptorInlineChange('appdescr_ui_generic_app_setMainPage',p,t);};
return a;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory',["sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/descriptorRelated/api/Settings"],function(D,L,a,U,S){"use strict";var b=function(p,f,d,s){if(p&&d){this._id=p.id;this._mode='DELETION';this._mMap=f;}else if(p){this._id=p.id;this._reference=p.reference;this._layer=p.layer;if(typeof p.isAppVariantRoot!=undefined){this._isAppVariantRoot=p.isAppVariantRoot;}this._mode='NEW';}else if(f){this._mMap=f;this._mode='FROM_EXISTING';}this._oSettings=s;this._sTransportRequest=null;this._content=[];};
b.prototype.addDescriptorInlineChange=function(d){var t=this;return new Promise(function(r){var s=function(_,i){if(_["setHostingIdForTextKey"]){_.setHostingIdForTextKey(i);}};switch(t._mode){case'NEW':s(d,t._id);t._content.push(d.getMap());break;case'FROM_EXISTING':s(d,t._mMap.id);t._mMap.content.push(d.getMap());break;default:}r(null);});};
b.prototype.setTransportRequest=function(t){try{U.checkTransportRequest(t);}catch(e){return Promise.reject(e);}this._sTransportRequest=t;return Promise.resolve();};
b.prototype.setPackage=function(p){try{U.checkPackage(p);}catch(e){return Promise.reject(e);}this._package=p;return Promise.resolve();};
b.prototype.submit=function(){var r='/sap/bc/lrep/appdescr_variants/';var m;switch(this._mode){case'NEW':m='POST';break;case'FROM_EXISTING':m='PUT';r=r+this._getMap().id;break;case'DELETION':m='DELETE';r=r+this._id;break;default:}var M=this._getMap();if(this._sTransportRequest){r+='?changelist='+this._sTransportRequest;}else if(this._oSettings.isAtoEnabled()&&M.layer=='CUSTOMER'){r+='?changelist=ATO_NOTIFICATION';}var l=new a();return l.send(r,m,M);};
b.prototype.getJson=function(){return jQuery.extend(true,{},this._getMap());};
b.prototype._getMap=function(){switch(this._mode){case'NEW':var r={"fileName":this._getNameAndNameSpace().fileName,"fileType":"appdescr_variant","namespace":this._getNameAndNameSpace().namespace,"layer":this._layer,"packageName":this._package?this._package:"$TMP","reference":this._reference,"id":this._id,"content":this._content};if(typeof this._isAppVariantRoot!=undefined){r.isAppVariantRoot=this._isAppVariantRoot;}return r;case'FROM_EXISTING':case'DELETION':{return this._mMap;}default:}};
b.prototype._getNameAndNameSpace=function(){return U.getNameAndNameSpace(this._id,this._reference);};
var c={};
c._getDescriptorVariant=function(i){var r='/sap/bc/lrep/appdescr_variants/'+i;var l=new a();return l.send(r,'GET');};
c.createNew=function(p){U.checkParameterAndType(p,"reference","string");U.checkParameterAndType(p,"id","string");if(!p.layer){p.layer='CUSTOMER';}else{U.checkParameterAndType(p,"layer","string");if(p.layer!='VENDOR'&&p.layer!='CUSTOMER'){throw new Error("Parameter \"layer\" needs to be 'VENDOR', 'CUSTOMER'");}}if(p.isAppVariantRoot){U.checkParameterAndType(p,"isAppVariantRoot","boolean");}return S.getInstance().then(function(s){return Promise.resolve(new b(p,null,false,s));});};
c.createForExisting=function(i){if(i===undefined||typeof i!=="string"){throw new Error("Parameter \"sId\" must be provided of type string");}var _;return c._getDescriptorVariant(i).then(function(r){_=r;return S.getInstance();}).then(function(s){var d=_.response;if(!jQuery.isPlainObject(d)){d=JSON.parse(d);}return Promise.resolve(new b(null,d,false,s));});};
c.createDeletion=function(i){if(i===undefined||typeof i!=="string"){throw new Error("Parameter \"sId\" must be provided of type string");}var p={};p.id=i;var _;return c._getDescriptorVariant(i).then(function(r){_=r;return S.getInstance();}).then(function(s){var d=JSON.parse(_.response);return Promise.resolve(new b(p,d,true,s));});};
return c;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/Settings',["jquery.sap.global","sap/ui/fl/LrepConnector","sap/ui/fl/Cache"],function(q,L,C){"use strict";var S=function(s){if(!s){throw new Error("no descriptor settings provided");}this._oSettings=s;};S._cachedSettingsPromise=null;
S.getInstance=function(){if(!S._cachedSettingsPromise){S._cachedSettingsPromise=C.getChangesFillingCache(L.createConnector(),"dummy").then(function(f){var s;if(f.changes&&f.changes.settings){s=new S(f.changes.settings);}else{s=new S({});}return s;});}return S._cachedSettingsPromise;};
S.prototype.isKeyUser=function(){var i=false;if(this._oSettings.isKeyUser){i=this._oSettings.isKeyUser;}return i;};
S.prototype.isModelS=function(){var i=false;if(this._oSettings.isAtoAvailable){i=this._oSettings.isAtoAvailable;}return i;};
S.prototype.isAtoEnabled=function(){var i=false;if(this._oSettings.isAtoEnabled){i=this._oSettings.isAtoEnabled;}return i;};
S.prototype.isProductiveSystem=function(){var i=false;if(this._oSettings.isProductiveSystem){i=this._oSettings.isProductiveSystem;}return i;};
return S;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/internal/Utils',function(){"use strict";var U=function(){};
U.prototype.getNameAndNameSpace=function(i,r){return{"fileName":"manifest","namespace":"apps/"+r+"/changes/"+i+"/"};};
U.prototype.checkEntityPropertyChange=function(p){this.checkParameterAndType(p,"entityPropertyChange","object");this.checkParameterAndType(p.entityPropertyChange,"propertyPath","string");this.checkParameterAndType(p.entityPropertyChange,"operation","string");if(jQuery.inArray(p.entityPropertyChange.operation,['INSERT','UPDATE','UPSERT','DELETE'])<0){throw new Error("Parameter \"entityPropertyChange.operation\" needs to be one of 'INSERT', 'UPDATE', 'UPSERT', 'DELETE'");}if(p.entityPropertyChange.propertyValue===undefined&&p.entityPropertyChange.operation!=='DELETE'){throw new Error("No parameter \"entityPropertyChange.propertyValue\" provided");}};
U.prototype.checkParameterAndType=function(p,P,t){if(t==="array"){if(p===undefined||p[P]===undefined||!Array.isArray(p[P])){throw new Error("No parameter \""+P+"\" of type "+t+" provided");}}else{if(p===undefined||p[P]===undefined||typeof p[P]!==t){throw new Error("No parameter \""+P+"\" of type "+t+" provided");}}};
U.prototype.checkTexts=function(t){if(t!==undefined&&typeof t!=="object"){throw new Error("Wrong format for provided \"texts\" parameter");}};
U.prototype.checkTransportRequest=function(t){if(!/^[A-Z0-9]{1,20}$/.test(t)){throw new Error("Wrong format for provided \"sTransportRequest\" parameter");}};
U.prototype.checkPackage=function(p){if(!/^[A-Z0-9/_]{1,30}$/.test(p)){throw new Error("Wrong format for provided \"sPackage\" parameter");}};
return new U();},true);
sap.ui.predefine('sap/ui/fl/fieldExt/Access',["jquery.sap.storage"],function(S){"use strict";var A={};A._sStorageKey="sap.ui.fl.fieldExt.Access";A._iValidityPeriod=1*7*24*60*60*1000;
A.getBusinessContexts=function(s,e,E){var o=this._parseServiceUri(s);var b=this._buildBusinessContextRetrievalUri(o.serviceName,o.serviceVersion,e,E);var a=this._getAjaxSettings();var p=this._executeAjaxCall(b,a,o.serviceName,o.serviceVersion,e,E);return p;};
A.isServiceOutdated=function(s){if(!this._isSystemInfoAvailable()){return false;}var m=this._getServiceItem(this._createServiceItem(s));if(m){if(this._isServiceExpired(m)){this.setServiceValid(s);return false;}else{return true;}}else{return false;}};
A.setServiceValid=function(s){if(this._isSystemInfoAvailable()){var d=this._getDataFromLocalStorage();delete d[this._createServiceItem(s).serviceKey];this._setDataToLocalStorage(d);}};
A.setServiceInvalid=function(s){if(this._isSystemInfoAvailable()){var d=this._getDataFromLocalStorage();var i=this._createServiceItem(s);d[i.serviceKey]=i;this._setDataToLocalStorage(d);}};
A._parseServiceUri=function(s){var r=/.*sap\/opu\/odata\/([^\/]+)\/([^\/]+)/i;var R=/([^;]+);v=(\d{1,4})/i;var o="sap/opu/odata";var a;if(s.toLowerCase().indexOf(o)!==-1){var b=s.match(r);if(!b||b.length!==3){throw new Error("sap.ui.fl.fieldExt.Access._parseService","Malformed service URI (Invalid service name)");}if(b[1].toLowerCase()!=="sap"){a="/"+b[1]+"/"+b[2];}else{a=b[2];}}else{if(s.length>0&&s.lastIndexOf("/")+1===s.length){s=s.substring(0,s.length-1);}a=s.substring(s.lastIndexOf("/")+1);}if(a.indexOf(";v=")!==-1){var v=a.match(R);if(!v||v.length!==3){throw new Error("sap.ui.fl.fieldExt.Access._parseService","Malformed service URI (Invalid version)");}return{serviceName:v[1],serviceVersion:v[2]};}else{return{serviceName:a,serviceVersion:'0001'};}};
A._buildBusinessContextRetrievalUri=function(s,a,e,E){if(e==null){e="";}if(E==null){E="";}if(((E.length===0)&&(e.length===0))||(!(E.length===0)&&!(e.length===0))){throw new Error("sap.ui.fl.fieldExt.Access._buildBusinessContextRetrievalUri()"+"Inconsistent input parameters EntityName: "+e+" EntitySet: "+E);}var b="/sap/opu/odata/SAP/APS_CUSTOM_FIELD_MAINTENANCE_SRV/GetBusinessContextsByEntityType?"+"EntitySetName=\'"+E+"\'"+"&EntityTypeName=\'"+e+"\'"+"&ServiceName=\'"+s+"\'"+"&ServiceVersion=\'"+a+"\'"+"&$format=json";return b;};
A._executeAjaxCall=function(b,r,s,a,e,E){var t=this;var d=jQuery.Deferred();jQuery.ajax(b,r).done(function(c,f,j){var B=[];if(c){B=t._extractBusinessContexts(c);}var R={BusinessContexts:B,ServiceName:s,ServiceVersion:a};d.resolve(R);}).fail(function(j,c,f){var g=t._getMessagesFromXHR(j);var o={errorOccured:true,errorMessages:g,serviceName:s,serviceVersion:a,entityType:e,entitySet:E};d.reject(o);});return d.promise();};
A._getAjaxSettings=function(){var s={type:"GET",async:true,dataType:"json"};return s;};
A._extractBusinessContexts=function(d){var r=null;var b=[];if(d&&d.d){r=d.d.results;}if(r!==null&&r.length>0){for(var i=0;i<r.length;i++){if(r[i].BusinessContext!==null){b.push(r[i].BusinessContext);}}}return b;};
A._getMessagesFromXHR=function(x){var m=[];try{var E=JSON.parse(x.responseText);if(E&&E.error&&E.error.message&&E.error.message.value&&E.error.message.value!==''){m.push({severity:"error",text:E.error.message.value});}else{m.push({severity:"error",text:x.responseText});}}catch(e){}return m;};
A._getCurrentTime=function(){return Date.now();};
A._isServiceExpired=function(s){return s.expirationDate<=this._getCurrentTime();};
A._getLocalStorage=function(){return jQuery.sap.storage(jQuery.sap.storage.Type.local);};
A.isLocalStorageAvailable=function(){return this._getLocalStorage()&&this._getLocalStorage().isSupported();};
A._getServiceItem=function(s){return this._getDataFromLocalStorage()[s.serviceKey]||null;};
A._createServiceItem=function(s){var e=this._getCurrentTime()+this._iValidityPeriod;var m=this._getSystemInfo();var p=this._extractServiceInfo(s);return{"serviceKey":m.getName()+m.getClient()+p.serviceName+p.serviceVersion,"expirationDate":e};};
A._extractServiceInfo=function(s){if(typeof s==="string"){return this._parseServiceUri(s);}else{return s;}};
A._isSystemInfoAvailable=function(){return sap&&sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getLogonSystem;};
A._getSystemInfo=function(){return sap.ushell.Container.getLogonSystem();};
A._setDataToLocalStorage=function(d){if(this.isLocalStorageAvailable()){this._getLocalStorage().put(A._sStorageKey,JSON.stringify(d));}};
A._getDataFromLocalStorage=function(){if(!this.isLocalStorageAvailable()){return{};}var s=this._getLocalStorage().get(A._sStorageKey);if(!s){return{};}else{return JSON.parse(s);}};
return A;},true);
sap.ui.predefine('sap/ui/fl/library',["sap/ui/fl/RegistrationDelegator"],function(R){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.fl",version:"1.46.10",dependencies:["sap.ui.core","sap.m"],noLibraryCSS:true,extensions:{"sap.ui.support":{diagnosticPlugins:["sap/ui/fl/support/Flexibility"]}}});R.registerAll();return sap.ui.fl;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeHandlerRegistration',["sap/ui/fl/registry/ChangeRegistry"],function(C){"use strict";var a={getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs:function(){var t=this;var c=sap.ui.getCore();var A=c.getLoadedLibraries();jQuery.each(A,function(l,L){if(L.extensions&&L.extensions.flChangeHandlers){t.registerFlexChangeHandlers(L.extensions.flChangeHandlers);}});c.attachLibraryChanged(this.handleLibraryRegistrationAfterFlexLibraryIsLoaded.bind(this));},registerFlexChangeHandlers:function(f){if(f){var c=C.getInstance();c.registerControlsForChanges(f);}},handleLibraryRegistrationAfterFlexLibraryIsLoaded:function(l){if(l.getParameter("operation")==="add"){var L=l.getParameter("metadata");if(L&&L.extensions&&L.extensions.flChangeHandlers){var f=L.extensions.flChangeHandlers;this.registerFlexChangeHandlers(f);}}}};return a;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeRegistry',["sap/ui/fl/Utils","jquery.sap.global","sap/ui/fl/registry/ChangeRegistryItem","sap/ui/fl/registry/ChangeTypeMetadata","sap/ui/fl/registry/Settings","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl"],function(U,q,C,a,S,H,M,b,P,c,d,e,f){"use strict";var g=function(){this._registeredItems={};this.initSettings();this.initDefaultActiveHandlers();};g._instance=undefined;g.prototype._oDefaultActiveChangeHandlers={};g.prototype._oDefaultChangeHandlers={"hideControl":H,"moveElements":M,"moveControls":b,"propertyChange":P,"propertyBindingChange":c,"unhideControl":d,"stashControl":e,"unstashControl":f};
g.prototype.initDefaultHandler=function(s,o){var h={changeType:s,changeHandler:o};var i=this._createChangeRegistryItemForSimpleChange("defaultActiveForAllControls",h);this._oDefaultActiveChangeHandlers[s]=i;};
g.prototype.initDefaultActiveHandlers=function(){this.initDefaultHandler("propertyChange",P);this.initDefaultHandler("propertyBindingChange",c);};
g.getInstance=function(){if(!g._instance){g._instance=new g();}return g._instance;};
g.prototype.hasRegisteredChangeHandlersForControl=function(s){var h=Object.keys(this._registeredItems);return h.indexOf(s)!==-1;};
g.prototype.hasChangeHandlerForControlAndChange=function(s,h){if(!this.hasRegisteredChangeHandlersForControl(s)){return false;}var r=this._registeredItems[s];var i=Object.keys(r);return i.indexOf(h)!==-1;};
g.prototype.registerControlsForChanges=function(m){var t=this;q.each(m,function(s,h){if(Array.isArray(h)){var o={};h.forEach(function(i){o[i.changeType]=i.changeHandler;});t._registerChangeHandlersForControl(s,o);}else{t._registerChangeHandlersForControl(s,h);}});};
g.prototype._registerChangeHandlersForControl=function(s,o){var t=this;if(typeof o==="string"){try{o=sap.ui.requireSync(o+".flexibility");}catch(h){U.log.error("Flexibility change handler registration failed.\nControlType: "+s+"\n"+h.message);return;}}q.each(o,function(i,j){var k=t._getChangeHandler(i,j);var l={"changeType":i,"changeHandler":k};t.registerControlForSimpleChange(s,l);});};
g.prototype._getChangeHandler=function(s,h){if(h==="default"){return this._oDefaultChangeHandlers[s];}else{return h;}};
g.prototype.registerControlForSimpleChange=function(s,o){var h;if(!s){return;}if(!o||!o.changeType||!o.changeHandler){return;}h=this._createChangeRegistryItemForSimpleChange(s,o);if(h){this.addRegistryItem(h);}};
g.prototype._createChangeRegistryItemForSimpleChange=function(s,o){var p,h,i;p={name:o.changeType,changeHandler:o.changeHandler};h=new a(p);p={changeTypeMetadata:h,controlType:s};i=new C(p);return i;};
g.prototype.addRegistryItem=function(r){var s,h;if(!r){return;}s=r.getChangeTypeName();h=r.getControlType();this._registeredItems[h]=this._registeredItems[h]||{};this._registeredItems[h][s]=r;};
g.prototype.removeRegistryItem=function(p){if(!p.changeTypeName&&!p.controlType){U.log.error("sap.ui.fl.registry.ChangeRegistry: ChangeType and/or ControlType required");return;}if(p.controlType&&p.changeTypeName){if(this._registeredItems[p.controlType]){if(Object.keys(this._registeredItems[p.controlType]).length===1){delete this._registeredItems[p.controlType];}else{delete this._registeredItems[p.controlType][p.changeTypeName];}}}else if(p.controlType){if(this._registeredItems[p.controlType]){delete this._registeredItems[p.controlType];}}else if(p.changeTypeName){for(var h in this._registeredItems){var i=this._registeredItems[h];delete i[p.changeTypeName];}}};
g.prototype.getRegistryItems=function(p){var t=this;if(!p){U.log.error("sap.ui.fl.registry.ChangeRegistry: no parameters passed for getRegistryItems");}var s=p.changeTypeName;var h=p.controlType;if(!s&&!h){U.log.error("sap.ui.fl.registry.ChangeRegistry: Change Type Name and/or Control Type required");}var r=null;if(h&&s){var o=this._getOrLoadChangeHandler(h,s);if(o){r={};r[h]={};r[h][s]=o;}}else if(h){if(this._registeredItems[h]){r={};r[h]={};var i=Object.keys(this._registeredItems[h]);i.forEach(function(s){r[h][s]=t._getOrLoadChangeHandler(h,s);});}}else if(s){r={};for(h in this._registeredItems){if(this._registeredItems[h][s]){r[h]={};r[h][s]=t._getOrLoadChangeHandler(h,s);}}}this._filterChangeTypes(r,p.layer);return r;};
g.prototype._getOrLoadChangeHandler=function(s,h){var o=this._registeredItems[s];if(o){var i=o[h];if(i){var j=i.getChangeTypeMetadata();var k=j.getChangeHandler();if(typeof k==="string"){q.sap.require(k);k=sap.ui.require(k);j._changeHandler=k;}return i;}}var D=this._oDefaultActiveChangeHandlers[h];if(D){return D;}return null;};
g.prototype.initSettings=function(s){this._oSettings=S.getInstanceOrUndef(s);if(!this._oSettings){this._oSettings=new S({});}};
g.prototype._filterChangeTypes=function(r,l){if(this._oSettings&&l&&r){var t=this;q.each(r,function(s,o){q.each(o,function(h,R){var i=t._oSettings.isChangeTypeEnabled(h,l);if(!i){U.log.warning("Change type "+h+" not enabled for layer "+l);delete o[h];}});});}};
g.prototype.getDragInfo=function(s){var h=this._registeredItems[s];if(h){return h.getDragInfo();}return null;};
return g;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeRegistryItem',["sap/ui/fl/Utils","jquery.sap.global"],function(U,q){"use strict";var C=function(p){if(!p.changeTypeMetadata){U.log.error("sap.ui.fl.registry.ChangeRegistryItem: ChangeTypeMetadata required");}if(!p.controlType){U.log.error("sap.ui.fl.registry.ChangeRegistryItem: ControlType required");}this._changeTypeMetadata=p.changeTypeMetadata;this._controlType=p.controlType;if(p.permittedRoles){this._permittedRoles=p.permittedRoles;}if(p.dragTargets){this._dragTargets=p.dragTargets;}};C.prototype._changeTypeMetadata=undefined;C.prototype._controlType=undefined;C.prototype._permittedRoles={};C.prototype._dragTargets=[];
C.prototype.getChangeTypeMetadata=function(){return this._changeTypeMetadata;};
C.prototype.getChangeTypeName=function(){return this._changeTypeMetadata.getName();};
C.prototype.getControlType=function(){return this._controlType;};
C.prototype.getPermittedRoles=function(){return this._permittedRoles;};
C.prototype.getDragTargets=function(){return this._dragTargets;};
return C;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeTypeMetadata',["sap/ui/fl/Utils","jquery.sap.global"],function(U,q){"use strict";var C=function(p){if(!p.name){U.log.error("sap.ui.fl.registry.ChangeType: Name required");}if(!p.changeHandler){U.log.error("sap.ui.fl.registry.ChangeType: ChangeHandler required");}this._name=p.name;this._changeHandler=p.changeHandler;if(p.labelKey){this._labelKey=p.labelKey;}if(p.tooltipKey){this._tooltipKey=p.tooltipKey;}if(p.iconKey){this._iconKey=p.iconKey;}if(p.sortIndex){this._sortIndex=p.sortIndex;}};C.prototype._name="";C.prototype._changeHandler="";C.prototype._sortIndex=0;C.prototype._labelKey="";C.prototype._tooltipKey="";C.prototype._iconKey="";
C.prototype.getName=function(){return this._name;};
C.prototype.getChangeHandler=function(){return this._changeHandler;};
C.prototype.getLabel=function(){return this._labelKey;};
C.prototype.getTooltip=function(){return this._tooltipKey;};
C.prototype.getIcon=function(){return this._iconKey;};
C.prototype.getSortIndex=function(){return this._sortIndex;};
return C;},true);
sap.ui.predefine('sap/ui/fl/registry/Settings',["jquery.sap.global","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/Utils","sap/ui/base/EventProvider"],function(q,L,C,U,E){"use strict";var S=function(s){E.apply(this);if(!s){throw new Error("no flex settings provided");}if(!s.features){s.features={"addFields":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"addGroup":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"removeField":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"removeGroup":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"hideControl":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"unhideControl":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"stashControl":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"unstashControl":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"renameField":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"renameGroup":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"moveFields":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"moveGroups":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"moveElements":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"moveControls":["CUSTOMER","CUSTOMER_BASE","VENDOR"],"propertyChange":["CUSTOMER_BASE","VENDOR"],"propertyBindingChange":["CUSTOMER_BASE","VENDOR"]};}this._oSettings=s;this._hasMergeErrorOccured=false;};S.prototype=q.sap.newObject(E.prototype);S.events={flexibilityAdaptationButtonAllowedChanged:"flexibilityAdaptationButtonAllowedChanged",changeModeUpdated:"changeModeUpdated"};S._instances={};S._bFlexChangeMode=true;S._bFlexibilityAdaptationButtonAllowed=false;S._oEventProvider=new E();
S.fireEvent=function(e,p){S._oEventProvider.fireEvent(e,p);};
S.attachEvent=function(e,c){S._oEventProvider.attachEvent(e,c);};
S.detachEvent=function(e,c){S._oEventProvider.detachEvent(e,c);};
S.getInstance=function(c,p){if(S._instances[c]){return Promise.resolve(S._instances[c]);}return C.getChangesFillingCache(L.createConnector(),c,p).then(S._storeInstance.bind(S,c));};
S._storeInstance=function(c,f){var s;if(f.changes&&f.changes.settings){s=new S(f.changes.settings);}else{s=new S({});}S._instances[c]=s;return s;};
S.getInstanceOrUndef=function(c){var s;if(S._instances[c]){s=S._instances[c];}return s;};
S.isFlexChangeMode=function(){var f=this._isFlexChangeModeFromUrl();if(f!==undefined){return f;}return S._bFlexChangeMode;};
S._isFlexChangeModeFromUrl=function(){var f;var u=q.sap.getUriParameters();if(u&&u.mParams&&u.mParams['sap-ui-fl-changeMode']&&u.mParams['sap-ui-fl-changeMode'][0]){if(u.mParams['sap-ui-fl-changeMode'][0]==='true'){f=true;}else if(u.mParams['sap-ui-fl-changeMode'][0]==='false'){f=false;}}return f;};
S.activateFlexChangeMode=function(){var f=true;S._setFlexChangeMode(f);};
S.leaveFlexChangeMode=function(){var f=false;S._setFlexChangeMode(f);};
S._setFlexChangeMode=function(f){if(S._bFlexChangeMode===f){return;}S._bFlexChangeMode=f;var p={bFlexChangeMode:f};S.fireEvent(S.events.changeModeUpdated,p);};
S.isFlexibilityAdaptationButtonAllowed=function(){return S._bFlexibilityAdaptationButtonAllowed;};
S.allowFlexibilityAdaptationButton=function(){var f=true;S.setFlexibilityAdaptationButtonAllowed(f);};
S.disallowFlexibilityAdaptationButton=function(){var f=false;S.setFlexibilityAdaptationButtonAllowed(f);};
S.setFlexibilityAdaptationButtonAllowed=function(f){if(S._bFlexibilityAdaptationButtonAllowed===f){return;}S._bFlexibilityAdaptationButtonAllowed=f;var p={bFlexibilityAdaptationButtonAllowed:f};S.fireEvent(S.events.flexibilityAdaptationButtonAllowedChanged,p);};
S.prototype.isKeyUser=function(){var i=false;if(this._oSettings.isKeyUser){i=this._oSettings.isKeyUser;}return i;};
S.prototype.isModelS=function(){var i=false;if(this._oSettings.isAtoAvailable){i=this._oSettings.isAtoAvailable;}return i;};
S.prototype.isAtoEnabled=function(){var i=false;if(this._oSettings.isAtoEnabled){i=this._oSettings.isAtoEnabled;}return i;};
S.prototype.isChangeTypeEnabled=function(c,a){if(!a){a='USER';}var i=false;if(!this._oSettings.features[c]){i=true;}else{var A=q.inArray(a,this._oSettings.features[c]);if(A<0){i=false;}else{i=true;}}return i;};
S.prototype.isProductiveSystem=function(){var i=false;if(this._oSettings.isProductiveSystem){i=this._oSettings.isProductiveSystem;}return i;};
S.prototype.setMergeErrorOccured=function(e){this._hasMergeErrorOccoured=e;};
S.prototype.hasMergeErrorOccured=function(){return this._hasMergeErrorOccured;};
return S;},true);
sap.ui.predefine('sap/ui/fl/registry/SimpleChanges',["jquery.sap.global","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange"],function(q,H,U,S,a,M,b,P,c){"use strict";var d={hideControl:{changeType:"hideControl",changeHandler:H},unhideControl:{changeType:"unhideControl",changeHandler:U},stashControl:{changeType:"stashControl",changeHandler:S},unstashControl:{changeType:"unstashControl",changeHandler:a},moveElements:{changeType:"moveElements",changeHandler:M},moveControls:{changeType:"moveControls",changeHandler:b},propertyChange:{changeType:"propertyChange",changeHandler:P},propertyBindingChange:{changeType:"propertyBindingChange",changeHandler:c}};return d;},true);
sap.ui.predefine('sap/ui/fl/transport/TransportDialog',['jquery.sap.global',"sap/m/List","sap/m/InputListItem",'sap/m/Button','sap/m/ComboBox','sap/m/Dialog','sap/m/DialogRenderer','sap/m/Input','sap/m/Label','sap/m/MessageToast','sap/ui/core/ListItem','sap/ui/fl/transport/Transports'],function(q,L,I,B,C,D,a,b,c,M,d,T){"use strict";
var e=D.extend("sap.ui.fl.transport.TransportDialog",{
metadata:{library:"sap.ui.fl",properties:{pkg:{type:"string",group:"Misc",defaultValue:null},transports:{type:"any",group:"Misc",defaultValue:null},lrepObject:{type:"any",group:"Misc",defaultValue:null},hidePackage:{type:"boolean",group:"Misc",defaultValue:null}},events:{ok:{},cancel:{}}},
renderer:a.render
});
e.prototype.init=function(){D.prototype.init.apply(this);this._oResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE"));this._oPackageLabel=null;this._oPackage=this._createPackageField();this._oTransport=this._createTransportCombo();this.addContent(this._createContentList());this._createButtons();};
e.prototype._createContentList=function(){this._oPackageListItem=new I({label:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE"),content:[this._oPackage]});this._oTransportListItem=new I({label:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT"),content:[this._oTransport]});return new L({items:[this._oPackageListItem,this._oTransportListItem]});};
e.prototype._createButtons=function(){var t=this;this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),press:function(){t._onLocal();}}));this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_OK"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_OK"),enabled:false,press:function(){t._onOkay();}}));this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),press:function(){t.fireCancel();t.close();t.destroy();}}));};
e.prototype._onLocal=function(){this.fireOk({selectedTransport:"",selectedPackage:this.getPkg()||"$TMP",dialog:true});this.close();this.destroy();};
e.prototype._onOkay=function(){var t=this._oTransport.getSelectedKey();if(this._checkOkay(t)){this.fireOk({selectedTransport:t,selectedPackage:this.getPkg()||this._oPackage.getValue(),dialog:true});this.close();this.destroy();}else{this.getButtons()[1].setEnabled(false);this._oTransport.setValueState(sap.ui.core.ValueState.Error);this._oTransport.setValueStateText(this.getTitle());}};
e.prototype._checkOkay=function(t){if(t){return true;}return false;};
e.prototype._createTransportCombo=function(){var t=this;return new C({showSecondaryValues:true,enabled:false,tooltip:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"),width:"100%",selectionChange:function(){if(t._oPackageListItem.getVisible()&&!t._oPackage.getValue()){return;}t.getButtons()[1].setEnabled(true);t._oTransport.setValueState(sap.ui.core.ValueState.None);},change:function(E){var f=function(i){if((i&&E.mParameters.newValue!==i.getText())||!i){return true;}return false;};if(E&&E.mParameters&&E.mParameters.newValue){if(f(t._oTransport.getSelectedItem())){t.getButtons()[1].setEnabled(false);t._oTransport.setValueState(sap.ui.core.ValueState.Error);t._oTransport.setValueStateText(t._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"));}}}});};
e.prototype._createPackageField=function(){var t=this;return new b({tooltip:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE_TT"),width:"100%",change:function(){var o,p,O;O=t._createObjectInfo();o=new sap.ui.fl.transport.Transports();p=o.getTransports(O);p.then(function(r){t._onPackageChangeSuccess(r);},function(r){t._onPackageChangeError(r);});},liveChange:function(E){if(E.mParameters.liveValue&&E.mParameters.liveValue.length>3){t._oTransport.setEnabled(true);}}});};
e.prototype._createObjectInfo=function(){var o,r={"package":this._oPackage.getValue()||""};o=this.getProperty("lrepObject");if(o){if(o.name){r.name=o.name;}if(o.type){r.type=o.type;}if(o.namespace){r.namespace=o.namespace;}}return r;};
e.prototype._onPackageChangeSuccess=function(t){if(t){if(t.localonly){this._oTransport.setEnabled(false);this.getButtons()[1].setEnabled(true);}else if(t.transports&&t.transports.length>0){this._oTransport.setEnabled(true);this._setTransports(t);}else if(t.errorCode){this.getButtons()[1].setEnabled(false);this._oPackage.setValueState(sap.ui.core.ValueState.Error);this._oPackage.setValueStateText(this._oResources.getText("TRANSPORT_DIALOG_"+t.errorCode));this._setTransports(t);}else{M.show(this._oResources.getText("TRANSPORT_DIALOG_NO_TRANSPORTS"));}}};
e.prototype._setTransports=function(t){var l,f;l=this._hasLock(t.transports);if(l){f=[l];}else{f=t.transports;}this.setTransports(f);if(f&&f.length===1){this._oTransport.setValue(f[0].description,true);this.getButtons()[1].setEnabled(true);}if(!f||f.length===0){this._oTransport.setSelectedKey(null);this._oTransport.setValueState(sap.ui.core.ValueState.None);this.getButtons()[1].setEnabled(false);}};
e.prototype._onPackageChangeError=function(r){M.show(r);this.setTransports([]);};
e.prototype._hasLock=function(t){var o,l=t.length;while(l--){o=t[l];if(o.locked){return o;}}return null;};
e.prototype.setPkg=function(p){if(p&&!this.getProperty("pkg")){this.setProperty("pkg",p);this._oPackage.setValue(p);this._oPackage.setEnabled(false);this._oTransport.setEnabled(true);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));this.getButtons()[0].setVisible(false);}};
e.prototype.setTransports=function(s){var i,l=0,o;if(s){this.setProperty("transports",s);this._oTransport.removeAllItems();l=s.length;for(i=0;i<l;i++){o=s[i];this._oTransport.addItem(new d({key:o.transportId,text:o.transportId,additionalText:o.description}));}if(l===1){this._oTransport.setSelectedKey(s[0].transportId);this.getButtons()[1].setEnabled(true);}if(l>0){this._oTransport.setEnabled(true);}}};
e.prototype.setLrepObject=function(o){if(o&&!this.getProperty("lrepObject")){this.setProperty("lrepObject",o);}};
e.prototype.setHidePackage=function(h){this.setProperty("hidePackage",h);this._oPackageListItem.setVisible(!h);if(h){this.getButtons()[0].setEnabled(h);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));}};
return e;},true);
sap.ui.predefine('sap/ui/fl/transport/TransportSelection',["jquery.sap.global","sap/ui/fl/Utils","sap/ui/fl/transport/Transports","sap/ui/fl/transport/TransportDialog","sap/ui/fl/registry/Settings"],function(q,U,T,a,F){"use strict";var b=function(){this.oTransports=new sap.ui.fl.transport.Transports();};
b.prototype.selectTransport=function(o,O,e,c,C){var s,p;var t=this;if(o){var l=U.getCurrentLayer(false);if(C){s=U.getComponentClassName(C);p={appDescriptor:U.getAppDescriptor(C),siteId:U.getSiteId(C)};}if(s&&l&&l==='CUSTOMER'){F.getInstance(s,p).then(function(S){if(S.isAtoEnabled()){var d={transportId:"ATO_NOTIFICATION"};O(t._createEventObject(o,d));}else{t._selectTransport(o,O,e,c);}});}else{t._selectTransport(o,O,e,c);}}};
b.prototype._selectTransport=function(o,O,e,c){var t=this;if(o){this.oTransports.getTransports(o).then(function(g){var d;if(t._checkDialog(g)){t._openDialog({hidePackage:!U.doesSharedVariantRequirePackage(),pkg:o.package,transports:g.transports,lrepObject:t._toLREPObject(o)},O,e,c);}else{d=t._getTransport(g);O(t._createEventObject(o,d));}},function(r){e(r);});}};
b.prototype._createEventObject=function(o,t){return{mParameters:{selectedTransport:t.transportId,selectedPackage:o["package"],dialog:false},getParameters:function(){return this.mParameters;},getParameter:function(n){return this.mParameters[n];}};};
b.prototype._toLREPObject=function(o){var O={};if(o.namespace){O.namespace=o.namespace;}if(o.name){O.name=o.name;}if(o.type){O.type=o.type;}return O;};
b.prototype._openDialog=function(c,o,e,C){var d=new a(c);d.attachOk(o);d.attachCancel(e);if(C){d.addStyleClass("sapUiSizeCompact");}else{d.removeStyleClass("sapUiSizeCompact");}d.open();return d;};
b.prototype._getTransport=function(t){var o;if(!t.localonly){o=this._hasLock(t.transports);}else{o={transportId:""};}return o;};
b.prototype._checkDialog=function(t){if(t){if(t.localonly||this._hasLock(t.transports)){return false;}}return true;};
b.prototype._hasLock=function(t){var l=t.length;while(l--){var o=t[l];if(o.locked){return o;}}return false;};
b.prototype.setTransports=function(c,C){var i=c.length-1;var t=this;var s=function(c,i,C,d,f){if(i>=0){var o=c[i];if(f===true){if(o.getDefinition().packageName!=="$TMP"){o.setRequest(d);}i--;return s(c,i,C,d,f);}else{if(o.getDefinition().packageName!=="$TMP"){return t.openTransportSelection(o,C).then(function(e){o.setRequest(e.transport);if(e.fromDialog===true){d=e.transport;f=true;}i--;return s(c,i,C,d,f);},function(){return null;});}else{i--;return s(c,i,C,d,f);}}}else{return Promise.resolve();}};return s(c,i,C);};
b.prototype.openTransportSelection=function(c,C){var t=this;return new Promise(function(r,d){var o=function(R){if(R&&R.getParameters){var s=R.getParameters().selectedTransport;var p=R.getParameters().selectedPackage;var f=R.getParameters().dialog;var g={transport:s,packageName:p,fromDialog:f};r(g);}else{r({});}};var e=function(E){if(E.sId==='cancel'){r();}else{d(E);}};var O={};if(c){O["package"]=c.getPackage();O.namespace=c.getNamespace();O.name=c.getId();O.type=c.getDefinition().fileType;}t.selectTransport(O,o,e,false,C);});};
return b;},true);
sap.ui.predefine('sap/ui/fl/transport/Transports',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils"],function(L,F){"use strict";var T=function(){};
T.prototype.getTransports=function(p){var u,c,l,P;u='/sap/bc/lrep/actions/gettransports/';if(p['package']){u+='&package='+p['package'];}if(p.name){u+='&name='+p.name;}if(p.namespace){u+='&namespace='+p.namespace;}if(p.type){u+='&type='+p.type;}c=F.getClient();if(c){u+='&sap-client='+c;}u=u.replace('&','?');l=L.createConnector();P=l.send(u);return P.then(function(r){if(r.response){if(!r.response.localonly){r.response.localonly=false;}if(!r.response.errorCode){r.response.errorCode="";}return Promise.resolve(r.response);}else{return Promise.reject('response is empty');}});};
T.prototype.makeChangesTransportable=function(p){var u,c,l;u='/sap/bc/lrep/actions/make_changes_transportable/';c=F.getClient();if(c){u+='?sap-client='+c;}if(!p.transportId){return Promise.reject(new Error("no transportId provided as attribute of mParameters"));}if(!p.changeIds){return Promise.reject(new Error("no changeIds provided as attribute of mParameters"));}l=L.createConnector();return l.send(u,'POST',p);};
T.prototype._convertToChangeTransportData=function(l){var t=[];var a=l.length;for(var i=0;i<a;i++){var c=l[i];var d={};d.namespace=c.getNamespace();d.fileName=c.getId();d.fileType=c.getDefinition().fileType;t.push(d);}return t;};
return T;},true);
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/fl/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/fl/manifest.json":'{\n  "_version": "1.2.0",\n  "sap.app": {\n    "_version": "1.2.0",\n    "id": "sap.ui.fl",\n    "type": "library",\n    "embeds": [\n      "support/apps/contentbrowser"\n    ],\n    "applicationVersion": {\n      "version": "1.46.10"\n    },\n    "title": "SAPUI5 library with sap.ui.fl controls.",\n    "description": "SAPUI5 library with sap.ui.fl controls.",\n    "ach": "CA-UI5-FL",\n    "resources": "resources.json",\n    "offline": true\n  },\n  "sap.ui": {\n    "_version": "1.1.0",\n    "technology": "UI5",\n    "supportedThemes": []\n  },\n  "sap.ui5": {\n    "_version": "1.1.0",\n    "dependencies": {\n      "minUI5Version": "1.46",\n      "libs": {\n        "sap.ui.core": {\n          "minVersion": "1.46.10"\n        },\n        "sap.m": {\n          "minVersion": "1.46.10"\n        }\n      }\n    }\n  }\n}'
}});
//# sourceMappingURL=library-preload.js.map