/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./library'],function(q,C,l){"use strict";var G=C.extend("sap.ui.layout.Grid",{metadata:{library:"sap.ui.layout",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},vSpacing:{type:"float",group:"Dimension",defaultValue:1},hSpacing:{type:"float",group:"Dimension",defaultValue:1},position:{type:"sap.ui.layout.GridPosition",group:"Dimension",defaultValue:"Left"},defaultSpan:{type:"sap.ui.layout.GridSpan",group:"Behavior",defaultValue:"XL3 L3 M6 S12"},defaultIndent:{type:"sap.ui.layout.GridIndent",group:"Behavior",defaultValue:"XL0 L0 M0 S0"},containerQuery:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});(function(){G.prototype.init=function(){this._iBreakPointTablet=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];this._indentXLChanged=false;this._spanXLChanged=false;};G.prototype.onAfterRendering=function(){if(this.getContainerQuery()){this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(this,q.proxy(this._onParentResize,this));this._onParentResize();}else{this._attachMediaContainerWidthChange(this._handleMediaChange,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED);}};G.prototype.onBeforeRendering=function(){this._cleanup();};G.prototype.exit=function(){this._cleanup();};G.prototype._cleanup=function(){if(this._sContainerResizeListener){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}this._detachMediaContainerWidthChange(this._handleMediaChange,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED);};G.prototype._handleMediaChange=function(p){this._toggleClass(p.name);};G.prototype._setBreakPointTablet=function(b){this._iBreakPointTablet=b;};G.prototype._setBreakPointDesktop=function(b){this._iBreakPointDesktop=b;};G.prototype._setBreakPointLargeDesktop=function(b){this._iBreakPointLargeDesktop=b;};G.prototype.setDefaultIndent=function(d){if(/XL/gi.test(d)){this._setIndentXLChanged(true);}return this.setProperty("defaultIndent",d);};G.prototype._setIndentXLChanged=function(c){this._indentXLChanged=c;};G.prototype._getIndentXLChanged=function(){return this._indentXLChanged;};G.prototype.setDefaultSpan=function(d){if(/XL/gi.test(d)){this._setSpanXLChanged(true);}return this.setProperty("defaultSpan",d);};G.prototype._setSpanXLChanged=function(c){this._spanXLChanged=c;};G.prototype._getSpanXLChanged=function(){return this._spanXLChanged;};G.prototype._onParentResize=function(){var d=this.getDomRef();if(!d){this._cleanup();return;}if(!q(d).is(":visible")){return;}var c=d.clientWidth;if(c<=this._iBreakPointTablet){this._toggleClass("Phone");}else if((c>this._iBreakPointTablet)&&(c<=this._iBreakPointDesktop)){this._toggleClass("Tablet");}else if((c>this._iBreakPointDesktop)&&(c<=this._iBreakPointLargeDesktop)){this._toggleClass("Desktop");}else{this._toggleClass("LargeDesktop");}};G.prototype._toggleClass=function(m){var d=this.$();if(!d){return;}if(d.hasClass("sapUiRespGridMedia-Std-"+m)){return;}d.toggleClass("sapUiRespGridMedia-Std-"+m,true);if(m==="Phone"){d.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false);}else if(m==="Tablet"){d.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false);}else if(m==="LargeDesktop"){d.toggleClass("sapUiRespGridMedia-Std-Desktop",false).toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false);}else{d.toggleClass("sapUiRespGridMedia-Std-Phone",false).toggleClass("sapUiRespGridMedia-Std-Tablet",false).toggleClass("sapUiRespGridMedia-Std-LargeDesktop",false);}this.fireEvent("mediaChanged",{media:m});};G.prototype._getLayoutDataForControl=function(c){var L=c.getLayoutData();if(!L){return undefined;}else if(L instanceof sap.ui.layout.GridData){return L;}else if(L.getMetadata().getName()=="sap.ui.core.VariantLayoutData"){var a=L.getMultipleLayoutData();for(var i=0;i<a.length;i++){var o=a[i];if(o instanceof sap.ui.layout.GridData){return o;}}}};G.prototype.onLayoutDataChange=function(e){if(this.getDomRef()){this.invalidate();}};G.prototype._getAccessibleRole=function(){return null;};G.prototype.getAccessibilityInfo=function(){return{children:this.getContent()};};}());return G;},true);
