/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/model/Binding","sap/ui/model/ChangeReason","sap/ui/model/ContextBinding","./Context","./lib/_Cache","./lib/_Helper","./lib/_SyncPromise","./ODataParentBinding"],function(q,B,C,a,b,_,c,d,e){"use strict";var s="sap.ui.model.odata.v4.ODataContextBinding",S={change:true,dataReceived:true,dataRequested:true};var O=a.extend("sap.ui.model.odata.v4.ODataContextBinding",{constructor:function(m,p,o,P){var i=p.indexOf("(...)");a.call(this,m,p);if(p.slice(-1)==="/"){throw new Error("Invalid path: "+p);}this.oCachePromise=d.resolve();this.mCacheByContext=undefined;this.sGroupId=undefined;this.oOperation=undefined;this.sRefreshGroupId=undefined;this.sUpdateGroupId=undefined;if(i>=0){this.oOperation={bAction:undefined,oMetadataPromise:undefined,mParameters:{},sResourcePath:undefined};if(i!==this.sPath.length-5){throw new Error("The path must not continue after a deferred operation: "+this.sPath);}}this.applyParameters(q.extend(true,{},P));this.oElementContext=this.bRelative?null:b.create(this.oModel,this,p);this.setContext(o);m.bindingCreated(this);},metadata:{publicMethods:[]}});e(O.prototype);O.prototype._delete=function(g,E){var t=this;if(this.sPath===""&&this.oContext["delete"]){return this.oContext["delete"](g);}if(this.hasPendingChanges()){throw new Error("Cannot delete due to pending changes");}return this.deleteFromCache(g,E,"",function(){t.oElementContext.destroy();t.oElementContext=null;t._fireChange({reason:C.Remove});});};O.prototype._requestOperationMetadata=function(){var m=this.oModel.getMetaModel(),o,p;if(!this.oOperation.oMetadataPromise){p=this.sPath.lastIndexOf("/");o=this.sPath.slice(p+1,-5);this.oOperation.oMetadataPromise=m.requestObject("/"+o).then(function(M){if(!M){throw new Error("Unknown operation: "+o);}if(Array.isArray(M)&&M[0].$kind==="Action"){return M;}if(Array.isArray(M)&&M[0].$kind==="Function"){throw new Error("Functions without import not supported: "+o);}if(M.$kind==="ActionImport"){return m.requestObject("/"+M.$Action);}if(M.$kind==="FunctionImport"){return m.requestObject("/"+M.$Function);}throw new Error("Not an operation: "+o);}).then(function(f){if(f.length!==1){throw new Error("Unsupported operation overloading: "+o);}return f[0];});}return this.oOperation.oMetadataPromise;};O.prototype.applyParameters=function(p){var o;this.mQueryOptions=this.oModel.buildQueryOptions(undefined,p,true);o=this.oModel.buildBindingParameters(p,["$$groupId","$$updateGroupId"]);this.sGroupId=o.$$groupId;this.sUpdateGroupId=o.$$updateGroupId;this.mParameters=p;if(!this.oOperation){this.oCachePromise=this.makeCache(this.oContext);this.checkUpdate();}};O.prototype.attachEvent=function(E){if(!(E in S)){throw new Error("Unsupported event '"+E+"': v4.ODataContextBinding#attachEvent");}return a.prototype.attachEvent.apply(this,arguments);};O.prototype.checkUpdate=function(){var t=this;function u(){t.oModel.getDependentBindings(t).forEach(function(D){D.checkUpdate();});}if(arguments.length>0){throw new Error("Unsupported operation: v4.ODataContextBinding#checkUpdate "+"must not be called with parameters");}this.oCachePromise.then(function(o){if(o&&t.bRelative&&t.oContext.fetchCanonicalPath){t.oContext.fetchCanonicalPath().then(function(f){if(o.$canonicalPath!==f){t.refreshInternal();}else{u();}})["catch"](function(E){t.oModel.reportError("Failed to update "+t,s,E);});}else{u();}});};O.prototype.deleteFromCache=function(g,E,p,f){var o;if(this.oOperation){throw new Error("Cannot delete a deferred operation");}if(!this.oCachePromise.isFulfilled()){throw new Error("DELETE request not allowed");}o=this.oCachePromise.getResult();if(o){g=g||this.getUpdateGroupId();if(g!=="$auto"&&g!=="$direct"){throw new Error("Illegal update group ID: "+g);}return o._delete(g,E,p,f);}return this.oContext.getBinding().deleteFromCache(g,E,c.buildPath(this.oContext.iIndex,this.sPath,p),f);};O.prototype.deregisterChange=function(p,l){var o;if(!this.oCachePromise.isFulfilled()){return;}o=this.oCachePromise.getResult();if(o){o.deregisterChange(p,l);}else if(this.oContext){this.oContext.deregisterChange(c.buildPath(this.sPath,p),l);}};O.prototype.destroy=function(){if(this.oElementContext){this.oElementContext.destroy();}this.oModel.bindingDestroyed(this);this.oCachePromise=undefined;a.prototype.destroy.apply(this);};O.prototype.execute=function(g){var t=this;function f(o,p){var h,E,i,j,P,k;g=g||t.getGroupId();t.oOperation.bAction=o.$kind==="Action";if(t.oOperation.bAction){h=_.createSingle(t.oModel.oRequestor,(p+t.sPath).slice(1,-5),t.getQueryOptions(t.oContext),true);if(t.bRelative&&t.oContext.getBinding){i=t.sPath.lastIndexOf("/");E=t.oContext.getObject(i>=0?t.sPath.slice(0,i):"")["@odata.etag"];}k=h.post(g,t.oOperation.mParameters,E);}else{j=o.$Parameter;P=[];if(j){j.forEach(function(l){var n=l.$Name;if(n in t.oOperation.mParameters){if(l.$IsCollection){throw new Error("Unsupported: collection parameter");}P.push(encodeURIComponent(n)+"="+encodeURIComponent(c.formatLiteral(t.oOperation.mParameters[n],l.$Type)));}});}t.oOperation.sResourcePath=t.sPath.replace("...",P.join(','));h=_.createSingle(t.oModel.oRequestor,(p+t.oOperation.sResourcePath).slice(1),t.getQueryOptions(t.oContext));k=h.fetchValue(g);}t.oCachePromise=d.resolve(h);return k;}this.oModel.checkGroupId(g);if(!this.oOperation){throw new Error("The binding must be deferred: "+this.sPath);}if(this.bRelative){if(!this.oContext){throw new Error("Unresolved binding: "+this.sPath);}if(this.oContext.isTransient&&this.oContext.isTransient()){throw new Error("Execute for transient context not allowed: "+this.oModel.resolve(this.sPath,this.oContext));}if(this.oContext.getPath().indexOf("(...)")>=0){throw new Error("Nested deferred operation bindings not supported: "+this.oModel.resolve(this.sPath,this.oContext));}}return this._requestOperationMetadata().then(function(o){if(t.bRelative){if(!t.oContext.getBinding){return f(o,t.oContext.getPath()==="/"?"/":t.oContext.getPath()+"/");}return t.getContext().requestCanonicalPath().then(function(p){return f(o,p+"/");});}return f(o,"");}).then(function(r){t._fireChange({reason:C.Change});})["catch"](function(E){t.oModel.reportError("Failed to execute "+t.sPath,s,E);throw E;});};O.prototype.fetchAbsoluteValue=function(p){var t=this;return this.oCachePromise.then(function(o){var r;if(o){r=t.oModel.resolve(t.sPath,t.oContext);if(p===r||p.lastIndexOf(r+"/")===0){return t.fetchValue(p.slice(r.length+1));}}if(t.oContext&&t.oContext.fetchAbsoluteValue){return t.oContext.fetchAbsoluteValue(p);}});};O.prototype.fetchValue=function(p,l){var t=this;return this.oCachePromise.then(function(o){var D=false,g;if(o){g=t.sRefreshGroupId||t.getGroupId();t.sRefreshGroupId=undefined;return o.fetchValue(g,p,function(){D=true;t.fireDataRequested();},l).then(function(v){if(D){t.fireDataReceived();}return v;},function(E){if(D){t.oModel.reportError("Failed to read path "+t.sPath,s,E);t.fireDataReceived(E.canceled?undefined:{error:E});}throw E;});}if(t.oContext&&t.oContext.fetchValue){return t.oContext.fetchValue(c.buildPath(t.sPath,p),l);}});};O.prototype.makeCache=function(o){var v,Q,t=this;function f(p){var g=(t.oOperation&&t.oOperation.sResourcePath)||t.sPath;return _.createSingle(t.oModel.oRequestor,c.buildPath(p,g).slice(1),Q);}if(!this.bRelative){o=undefined;}else if(!o||o.fetchCanonicalPath&&!Object.keys(this.mParameters).length){return d.resolve();}Q=this.getQueryOptions(o);v=o&&(o.fetchCanonicalPath?o.fetchCanonicalPath():o.getPath());return this.createCache(f,v);};O.prototype.refreshInternal=function(g){var t=this;this.oCachePromise.then(function(o){if(!t.oElementContext){t.oElementContext=b.create(t.oModel,t,t.oModel.resolve(t.sPath,t.oContext));if(!o){t._fireChange({reason:C.Refresh});}}if(o){if(!t.oOperation||!t.oOperation.bAction){t.sRefreshGroupId=g;t.oCachePromise=t.makeCache(t.oContext);t.mCacheByContext=undefined;t._fireChange({reason:C.Refresh});}}t.oModel.getDependentBindings(t).forEach(function(D){D.refreshInternal(g);});});};O.prototype.setContext=function(o){if(this.oContext!==o){if(this.bRelative&&(this.oContext||o)){if(this.oElementContext){this.oElementContext.destroy();this.oElementContext=null;}this.oCachePromise=d.resolve();if(o){this.oElementContext=b.create(this.oModel,this,this.oModel.resolve(this.sPath,o));if(!this.oOperation&&(this.mParameters||!o.getBinding)){this.oCachePromise=this.makeCache(o);}}B.prototype.setContext.call(this,o);}else{this.oContext=o;}}};O.prototype.setParameter=function(p,v){if(!this.oOperation){throw new Error("The binding must be deferred: "+this.sPath);}if(v===undefined){throw new Error("Missing value for parameter: "+p);}this.oOperation.mParameters[p]=v;return this;};O.prototype.toString=function(){return s+": "+(this.bRelative?this.oContext+"|":"")+this.sPath;};return O;},true);
