/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/model/BindingMode","sap/ui/model/ContextBinding","sap/ui/model/Context","sap/ui/model/FilterProcessor","sap/ui/model/json/JSONListBinding","sap/ui/model/MetaModel","sap/ui/model/odata/OperationMode","sap/ui/model/odata/type/Int64","sap/ui/model/PropertyBinding","sap/ui/thirdparty/URI","./lib/_Helper","./lib/_SyncPromise","./ValueListType"],function(q,B,C,a,F,J,M,O,I,P,U,_,b,V){"use strict";var c,D=q.sap.log.Level.DEBUG,d,f,o="sap.ui.model.odata.v4.ODataMetaModel",g,r=/\([^/]*|\/-?\d+/g,h=/^-?\d+$/,s={messageChange:true},u={"Edm.Boolean":{type:"sap.ui.model.odata.type.Boolean"},"Edm.Byte":{type:"sap.ui.model.odata.type.Byte"},"Edm.Date":{type:"sap.ui.model.odata.type.Date"},"Edm.DateTimeOffset":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.DateTimeOffset"},"Edm.Decimal":{constraints:{"@Org.OData.Validation.V1.Minimum":"minimum","@Org.OData.Validation.V1.Minimum@Org.OData.Validation.V1.Exclusive":"minimumExclusive","@Org.OData.Validation.V1.Maximum":"maximum","@Org.OData.Validation.V1.Maximum@Org.OData.Validation.V1.Exclusive":"maximumExclusive","$Precision":"precision","$Scale":"scale"},type:"sap.ui.model.odata.type.Decimal"},"Edm.Double":{type:"sap.ui.model.odata.type.Double"},"Edm.Guid":{type:"sap.ui.model.odata.type.Guid"},"Edm.Int16":{type:"sap.ui.model.odata.type.Int16"},"Edm.Int32":{type:"sap.ui.model.odata.type.Int32"},"Edm.Int64":{type:"sap.ui.model.odata.type.Int64"},"Edm.SByte":{type:"sap.ui.model.odata.type.SByte"},"Edm.Single":{type:"sap.ui.model.odata.type.Single"},"Edm.String":{constraints:{"@com.sap.vocabularies.Common.v1.IsDigitSequence":"isDigitSequence","$MaxLength":"maxLength"},type:"sap.ui.model.odata.type.String"},"Edm.TimeOfDay":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.TimeOfDay"}},v="@com.sap.vocabularies.Common.v1.ValueListMapping",m={},j="@com.sap.vocabularies.Common.v1.ValueListReferences",k="@com.sap.vocabularies.Common.v1.ValueListWithFixedValues",W=q.sap.log.Level.WARNING;function l(t,e){if(t===e){return"";}if(t.indexOf(e)===0&&t[e.length]==="#"&&t.indexOf("@",e.length)<0){return t.slice(e.length+1);}}d=C.extend("sap.ui.model.odata.v4.ODataMetaContextBinding",{constructor:function(e,p,i){C.call(this,e,p,i);},initialize:function(){var e=this.oModel.createBindingContext(this.sPath,this.oContext);this.bInitial=false;if(e!==this.oElementContext){this.oElementContext=e;this._fireChange();}},setContext:function(e){if(e!==this.oContext){this.oContext=e;if(!this.bInitial){this.initialize();}}}});f=J.extend("sap.ui.model.odata.v4.ODataMetaListBinding",{applyFilter:function(){var t=this;this.aIndices=F.apply(this.aIndices,this.aFilters.concat(this.aApplicationFilters),function(R,p){return p==="@sapui.name"?R:t.oModel.getProperty(p,t.oList[R]);});this.iLength=this.aIndices.length;},constructor:function(){J.apply(this,arguments);},enableExtendedChangeDetection:function(){throw new Error("Unsupported operation");}});g=P.extend("sap.ui.model.odata.v4.ODataMetaPropertyBinding",{constructor:function(){P.apply(this,arguments);this.vValue=this.oModel.getProperty(this.sPath,this.oContext,this.mParameters);},getValue:function(){return this.vValue;},setValue:function(){throw new Error("Unsupported operation: ODataMetaPropertyBinding#setValue");}});var n=M.extend("sap.ui.model.odata.v4.ODataMetaModel",{constructor:function(R,e,A,i){M.call(this);this.aAnnotationUris=A&&!Array.isArray(A)?[A]:A;this.sDefaultBindingMode=B.OneTime;this.oMetadataPromise=null;this.oModel=i;this.oRequestor=R;this.mSupportedBindingModes={"OneTime":true};this.sUrl=e;}});n.prototype._getObject=function(p,e){var i=false,t=p==="@"||p===""&&e.getPath().slice(-2)==="/@"||p.slice(-2)==="/@",K,w,R;if(t||p==="/"){w=p;}else if(p){w=p+"/";}else{w="./";}R=this.getObject(w,e);for(K in R){if(K[0]==="$"||t===(K[0]!=="@")){if(!i){R=q.extend({},R);i=true;}delete R[K];}}return R;};n.prototype._mergeMetadata=function(e){var R=e[0],t=this;function p(E){if(E.$kind==="Schema"&&E.$Annotations){Object.keys(E.$Annotations).forEach(function(T){if(!R.$Annotations[T]){R.$Annotations[T]=E.$Annotations[T];}else{q.extend(R.$Annotations[T],E.$Annotations[T]);}});delete E.$Annotations;}}R.$Annotations=R.$Annotations||{};Object.keys(R).forEach(function(E){p(R[E]);});e.slice(1).forEach(function(A,i){Object.keys(A).forEach(function(K){var E=A[K];if(E.$kind!==undefined||Array.isArray(E)){if(R[K]){throw new Error("Overwriting '"+K+"' with the value defined in '"+t.aAnnotationUris[i]+"' is not supported");}R[K]=E;p(E);}});});return R;};n.prototype.attachEvent=function(e){if(!(e in s)){throw new Error("Unsupported event '"+e+"': v4.ODataMetaModel#attachEvent");}return M.prototype.attachEvent.apply(this,arguments);};n.prototype.bindContext=function(p,e){return new d(this,p,e);};n.prototype.bindList=function(p,e,S,i){return new f(this,p,e,S,i);};n.prototype.bindProperty=function(p,e,i){return new g(this,p,e,i);};n.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#bindTree");};n.prototype.fetchCanonicalPath=function(p){return this.fetchEntityContainer().then(function(S){var t,E=S[S.$EntityContainer],w,x,y,z,A=p.getPath().split("/");function G(e,i){var Q=p.getPath();if(i&&i!==Q){e=e+" at "+i;}q.sap.log.error(e,Q,o);throw new Error(Q+": "+e);}function H(i){if(x.$kind==="Singleton"){return b.resolve(w);}return K(i).then(function(e){return w+e;});}function K(i){var e=A.slice(0,i).join("/");return p.fetchAbsoluteValue(e).then(function(Q){return L(Q,e);});}function L(i,Q){try{return _.getKeyPredicate(y,i);}catch(e){G(e.message,Q);}}function N(i){var e,Q,R;if(i===A.length){if(t){return"/"+t;}if(x.$kind==="Singleton"){return"/"+w;}return p.fetchValue("").then(function(T){return"/"+w+L(T);});}R=A[i];if(h.test(R)){if(!x){return K(i+1).then(function(T){t+=T;return N(i+1);});}return N(i+1);}z=R.indexOf("(");Q=decodeURIComponent(z>0?R.slice(0,z):R);e=y[Q];if(!e||e.$kind!=="NavigationProperty"){G("Not a navigation property: "+Q);}if(!x||(t&&e.$ContainsTarget)){t+="/"+R;y=S[e.$Type];x=undefined;return N(i+1);}if(e.$ContainsTarget){return H(i).then(function(T){t=T+"/"+R;x=undefined;y=S[e.$Type];return N(i+1);});}w=x.$NavigationPropertyBinding[Q];x=E[w];y=S[e.$Type];w=encodeURIComponent(w);t=z>0?w+R.slice(z):undefined;return N(i+1);}z=A[1].indexOf("(");if(z>0){t=A[1];w=t.slice(0,z);}else{w=A[1];}x=E[decodeURIComponent(w)];y=S[x.$Type];return N(2);});};n.prototype.fetchEntityContainer=function(){var p,t=this;if(!this.oMetadataPromise){p=[b.resolve(this.oRequestor.read(this.sUrl))];if(this.aAnnotationUris){this.aAnnotationUris.forEach(function(A){p.push(b.resolve(t.oRequestor.read(A,true)));});}this.oMetadataPromise=b.all(p).then(function(e){return t._mergeMetadata(e);});}return this.oMetadataPromise;};n.prototype.fetchObject=function(p,t,w){var R=this.resolve(p,t),x=this;if(!R){q.sap.log.error("Invalid relative path w/o context",p,o);return b.resolve(null);}return this.fetchEntityContainer().then(function(S){var L,N,y=true,z,A,T,E=S;function G(i,p){var Y,Z=i.indexOf("@",2);if(Z>-1){return H(W,"Unsupported path after ",i.slice(0,Z));}i=i.slice(2);Y=i[0]==="."?q.sap.getObject(i.slice(1),undefined,w.scope):q.sap.getObject(i);if(typeof Y!=="function"){return H(W,i," is not a function but: "+Y);}try{E=Y(E,{context:new a(x,p),schemaChildName:A});}catch(e){H(W,"Error calling ",i,": ",e);}return false;}function H(i){var e;if(q.sap.log.isLoggable(i,o)){e=Array.isArray(L)?L.join("/"):L;q.sap.log[i===D?"debug":"warning"](Array.prototype.slice.call(arguments,1).join("")+(e?" at /"+e:""),R,o);}E=undefined;return false;}function K(e,i){if(!(e in S)){L=L||T&&T+"/"+i;return H(W,"Unknown qualified name '",e,"'");}T=N=A=e;E=z=S[A];return true;}function Q(e,i,Y){var Z,$;if(e==="$Annotations"){return H(W,"Invalid segment: $Annotations");}if(E!==S&&typeof E==="object"&&e in E){if(e[0]==="$"||h.test(e)){y=false;}}else{Z=e.indexOf("@@");if(Z<0){if(e.length>11&&e.slice(-11)==="@sapui.name"){Z=e.length-11;}else{Z=e.indexOf("@");}}if(Z>0){if(!Q(e.slice(0,Z),i,Y)){return false;}e=e.slice(Z);$=true;}if(typeof E==="string"&&!($&&e[0]==="@"&&(e==="@sapui.name"||e[1]==="@"))&&!X(E,Y.slice(0,i))){return false;}if(y){if(e[0]==="$"||h.test(e)){y=false;}else if(!$){if(e[0]!=="@"&&e.indexOf(".")>0){return K(e);}else if(E&&"$Type"in E){if(!K(E.$Type,"$Type")){return false;}}else if(E&&"$Action"in E){if(!K(E.$Action,"$Action")){return false;}}else if(E&&"$Function"in E){if(!K(E.$Function,"$Function")){return false;}}else if(i===0){T=N=A=A||S.$EntityContainer;E=z=z||S[A];if(e&&e[0]!=="@"&&!(e in z)){return H(W,"Unknown child '",e,"' of '",A,"'");}}if(Array.isArray(E)){if(E.length!==1){return H(W,"Unsupported overloads");}E=E[0].$ReturnType;T=T+"/0/$ReturnType";if(E){if(e==="value"&&!(S[E.$Type]&&S[E.$Type].value)){N=undefined;return true;}if(!K(E.$Type,"$Type")){return false;}}}}}if(!e){return i+1>=Y.length||H(W,"Invalid empty segment");}if(e[0]==="@"){if(e==="@sapui.name"){E=N;if(E===undefined){H(W,"Unsupported path before @sapui.name");}else if(i+1<Y.length){H(W,"Unsupported path after @sapui.name");}return false;}if(e[1]==="@"){if(i+1<Y.length){return H(W,"Unsupported path after ",e);}return G(e,"/"+Y.slice(0,i).join("/")+"/"+Y[i].slice(0,Z));}}if(!E||typeof E!=="object"){return H(D,"Invalid segment: ",e);}if(y&&e[0]==="@"){E=(S.$Annotations||{})[T]||{};y=false;}}if(e!=="@"){N=y||e[0]==="@"?e:undefined;T=y?T+"/"+e:undefined;E=E[e];}return true;}function X(e,i){var Y;if(L){return H(W,"Invalid recursion");}L=i;y=true;E=S;Y=e.split("/").every(Q);L=undefined;return Y;}X(R.slice(1));return E;});};n.prototype.fetchUI5Type=function(p){var e=this.getMetaContext(p),t=this;if(q.sap.endsWith(p,"/$count")){c=c||new I();return b.resolve(c);}return this.fetchObject(undefined,e).then(function(i){var w,N,T=i["$ui5.type"],x,y="sap.ui.model.odata.type.Raw";function z(K,A){if(A!==undefined){w=w||{};w[K]=A;}}if(T){return T;}if(i.$isCollection){q.sap.log.warning("Unsupported collection type, using "+y,p,o);}else{x=u[i.$Type];if(x){y=x.type;for(N in x.constraints){z(x.constraints[N],N[0]==="@"?t.getObject(N,e):i[N]);}if(i.$Nullable===false){z("nullable",false);}}else{q.sap.log.warning("Unsupported type '"+i.$Type+"', using "+y,p,o);}}T=new(q.sap.getObject(y,0))(undefined,w);i["$ui5.type"]=T;return T;});};n.prototype.fetchValueListMappings=function(e,N,p){var t=this,i=e.getMetaModel();return i.fetchEntityContainer().then(function(w){var A,x=w.$Annotations,y={},z=t===i,T;T=Object.keys(x).filter(function(E){if(_.namespace(E)===N){if(t.getObject("/"+E)===p){return true;}if(!z){throw new Error("Unexpected annotation target '"+E+"' with namespace of data service in "+e.sServiceUrl);}}return false;});if(!T.length){throw new Error("No annotation '"+v.slice(1)+"' in "+e.sServiceUrl);}A=x[T[0]];Object.keys(A).forEach(function(E){var Q=l(E,v);if(Q!==undefined){y[Q]=A[E];}else if(!z){throw new Error("Unexpected annotation '"+E.slice(1)+"' for target '"+T[0]+"' with namespace of data service in "+e.sServiceUrl);}});return y;});};n.prototype.getMetaContext=function(p){return new a(this,p.replace(r,""));};n.prototype.getOrCreateValueListModel=function(e){var A=new U(this.sUrl).absoluteTo(document.baseURI).pathname().toString(),i,p;p=new U(e).absoluteTo(A).filename("").toString();i=m[p];if(!i){i=new this.oModel.constructor({operationMode:O.Server,serviceUrl:p,synchronizationMode:"None"});i.setDefaultBindingMode(B.OneWay);m[p]=i;i.oRequestor.mHeaders["X-CSRF-Token"]=this.oModel.oRequestor.mHeaders["X-CSRF-Token"];}return i;};n.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#getOriginalProperty");};n.prototype.getObject=b.createGetMethod("fetchObject");n.prototype.getProperty=n.prototype.getObject;n.prototype.getUI5Type=b.createGetMethod("fetchUI5Type",true);n.prototype.getValueListType=function(p){var e=this.getMetaContext(p),i,t=this;i=this.fetchObject("",e).then(function(w){var A,T;if(!w){throw new Error("No metadata for "+p);}A=t.getObject("@",e);if(A[k]){return V.Fixed;}for(T in A){if(l(T,j)!==undefined||l(T,v)!==undefined){return V.Standard;}}return V.None;});if(i.isRejected()){throw i.getResult();}if(!i.isFulfilled()){throw new Error("Metadata not yet loaded");}return i.getResult();};n.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#isList");};n.prototype.refresh=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#refresh");};n.prototype.requestObject=b.createRequestMethod("fetchObject");n.prototype.requestUI5Type=b.createRequestMethod("fetchUI5Type");n.prototype.requestValueListInfo=function(p){var e=this.getMetaContext(p),t=this;return Promise.all([this.requestObject("/$EntityContainer"),this.requestObject("",e),this.requestObject("@",e),this.requestObject(k,e)]).then(function(R){var A=R[2],i=R[3],w={},N=_.namespace(R[0]),x=R[1],y={};function z(E,Q,G,H){if(w[Q]){throw new Error("Annotations '"+v.slice(1)+"' with identical qualifier '"+Q+"' for property "+p+" in "+w[Q]+" and "+G);}if(i&&y[""]){throw new Error("Annotation '"+k.slice(1)+"' but multiple '"+v.slice(1)+"' for property "+p);}w[Q]=G;y[i?"":Q]=q.extend(true,{$model:H},E);}if(!x){throw new Error("No metadata for "+p);}Object.keys(A).filter(function(T){return l(T,v)!==undefined;}).forEach(function(T){z(A[T],l(T,v),t.oModel.sServiceUrl+"$metadata",t.oModel);});return Promise.all(Object.keys(A).filter(function(T){return l(T,j)!==undefined;}).map(function(T){var E=A[T];return Promise.all(E.map(function(G){var H=t.getOrCreateValueListModel(G);return t.fetchValueListMappings(H,N,x).then(function(K){Object.keys(K).forEach(function(Q){z(K[Q],Q,G,H);});});}));})).then(function(){if(!Object.keys(y).length){throw new Error("No annotation '"+j.slice(1)+"' for "+p);}return y;});});};n.prototype.resolve=function(p,e){var i,t;if(!p){return e?e.getPath():undefined;}t=p[0];if(t==="/"){return p;}if(!e){return undefined;}if(t==="."){if(p[1]!=="/"){throw new Error("Unsupported relative path: "+p);}p=p.slice(2);}i=e.getPath();return t==="@"||i.slice(-1)==="/"?i+p:i+"/"+p;};n.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#setLegacySyntax");};n.prototype.toString=function(){return o+": "+this.sUrl;};return n;},true);
