/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/message/Message","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/model/Model","sap/ui/model/odata/OperationMode","sap/ui/thirdparty/URI","./lib/_MetadataRequestor","./lib/_Requestor","./lib/_Parser","./ODataContextBinding","./ODataListBinding","./ODataMetaModel","./ODataPropertyBinding"],function(q,M,B,a,b,O,U,_,c,d,e,f,g,h){"use strict";var C="sap.ui.model.odata.v4.ODataModel",r=/^\w+$/,i=/^(\$auto|\$direct|\w+)$/,s={messageChange:true},S={annotationURI:true,groupId:true,operationMode:true,serviceUrl:true,synchronizationMode:true,updateGroupId:true},j=["$apply","$count","$expand","$filter","$orderby","$search","$select"];var k=b.extend("sap.ui.model.odata.v4.ODataModel",{constructor:function(p){var H={"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()},P,l,u,t=this;b.apply(this);if(!p||p.synchronizationMode!=="None"){throw new Error("Synchronization mode must be 'None'");}for(P in p){if(!(P in S)){throw new Error("Unsupported parameter: "+P);}}l=p.serviceUrl;if(!l){throw new Error("Missing service root URL");}u=new U(l);if(u.path()[u.path().length-1]!=="/"){throw new Error("Service root URL must end with '/'");}if(p.operationMode&&p.operationMode!==O.Server){throw new Error("Unsupported operation mode: "+p.operationMode);}this.sOperationMode=p.operationMode;this.mUriParameters=this.buildQueryOptions(null,u.query(true),false,true);this.sServiceUrl=u.query("").toString();this.sGroupId=p.groupId;if(this.sGroupId===undefined){this.sGroupId="$auto";}if(this.sGroupId!=="$auto"&&this.sGroupId!=="$direct"){throw new Error("Group ID must be '$auto' or '$direct'");}this.checkGroupId(p.updateGroupId,false,"Invalid update group ID: ");this.sUpdateGroupId=p.updateGroupId||this.getGroupId();this.oMetaModel=new g(_.create(H,this.mUriParameters),this.sServiceUrl+"$metadata",p.annotationURI,this);this.oRequestor=c.create(this.sServiceUrl,H,this.mUriParameters,function(G){if(G==="$auto"){sap.ui.getCore().addPrerenderingTask(t._submitBatch.bind(t,G));}});this.aAllBindings=[];this.sDefaultBindingMode=B.TwoWay;this.mSupportedBindingModes={OneTime:true,OneWay:true,TwoWay:true};}});k.prototype._submitBatch=function(G){return this.oRequestor.submitBatch(G)["catch"](function(E){q.sap.log.error("$batch failed",E.message,C);throw E;});};k.prototype.attachEvent=function(E){if(!(E in s)){throw new Error("Unsupported event '"+E+"': v4.ODataModel#attachEvent");}return b.prototype.attachEvent.apply(this,arguments);};k.prototype.bindContext=function(p,o,P){return new e(this,p,o,P);};k.prototype.bindingCreated=function(o){this.aAllBindings.push(o);};k.prototype.bindingDestroyed=function(o){var I=this.aAllBindings.indexOf(o);if(I<0){throw new Error("Unknown "+o);}this.aAllBindings.splice(I,1);};k.prototype.bindList=function(p,o,v,F,P){return new f(this,p,o,v,F,P);};k.prototype.bindProperty=function(p,o,P){return new h(this,p,o,P);};k.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataModel#bindTree");};k.prototype.buildBindingParameters=function(p,A){var R={},t=this;if(p){Object.keys(p).forEach(function(K){var v=p[K];if(K.indexOf("$$")!==0){return;}if(!A||A.indexOf(K)<0){throw new Error("Unsupported binding parameter: "+K);}if(K==="$$groupId"||K==="$$updateGroupId"){t.checkGroupId(v,false,"Unsupported value for binding parameter '"+K+"': ");}else if(K==="$$operationMode"){if(v!==O.Server){throw new Error("Unsupported operation mode: "+v);}}R[K]=v;});}return R;};k.prototype.buildQueryOptions=function(m,o,l,n){var R=JSON.parse(JSON.stringify(m||{}));function v(E){var t;if(typeof E==="object"){for(t in E){p(t,E[t]);}}}function p(t,V){var P;if(!l||j.indexOf(t)<0){throw new Error("System query option "+t+" is not supported");}if(t==="$expand"){for(P in V){v(V[P]);}}}if(o){Object.keys(o).forEach(function(K){var V=o[K];if(K.indexOf("$$")===0){return;}if(K[0]==="@"){throw new Error("Parameter "+K+" is not supported");}if(K[0]==="$"){if((K==="$expand"||K==="$select")&&typeof V==="string"){V=d.parseSystemQueryOption(K+"="+V)[K];}p(K,V);}else if(!n&&K.indexOf("sap-")===0){throw new Error("Custom query option "+K+" is not supported");}R[K]=V;});}return R;};k.prototype.checkGroupId=function(G,A,E){if(!A&&G===undefined||typeof G==="string"&&(A?r:i).test(G)){return;}throw new Error((E||"Invalid group ID: ")+G);};k.prototype.createBindingContext=function(p,o){var D,m,l,R,n;if(arguments.length>2){throw new Error("Only the parameters sPath and oContext are supported");}if(o&&o.getBinding){throw new Error("Unsupported type: oContext must be of type sap.ui.model.Context, "+"but was sap.ui.model.odata.v4.Context");}R=this.resolve(p,o);if(R===undefined){throw new Error("Cannot create binding context from relative path '"+p+"' without context");}n=R.indexOf('#');if(n>=0){D=R.slice(0,n);l=R.slice(n+1);if(l[0]==="/"){l="."+l;}m=this.oMetaModel.getMetaContext(D);return this.oMetaModel.createBindingContext(l,m);}return new a(this,R);};k.prototype.destroy=function(){this.oMetaModel.destroy();return b.prototype.destroy.apply(this,arguments);};k.prototype.destroyBindingContext=function(){throw new Error("Unsupported operation: v4.ODataModel#destroyBindingContext");};k.prototype.getContext=function(){throw new Error("Unsupported operation: v4.ODataModel#getContext");};k.prototype.getDependentBindings=function(p){return this.aAllBindings.filter(function(o){return o.isRelative()&&(o.getContext()===p||o.getContext()&&o.getContext().getBinding&&o.getContext().getBinding()===p);});};k.prototype.getGroupId=function(){return this.sGroupId;};k.prototype.getMetaModel=function(){return this.oMetaModel;};k.prototype.getObject=function(){throw new Error("Unsupported operation: v4.ODataModel#getObject");};k.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getOriginalProperty");};k.prototype.getProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getProperty");};k.prototype.getUpdateGroupId=function(){return this.sUpdateGroupId;};k.prototype.hasPendingChanges=function(){return this.oRequestor.hasPendingChanges();};k.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataModel#isList");};k.prototype.refresh=function(G){this.checkGroupId(G);this.aBindings.slice().forEach(function(o){if(o.isRefreshable()){o.refresh(G);}});};k.prototype.reportError=function(l,R,E){var D=E.stack||E.message;if(D.indexOf(E.message)<0){D=E.message+"\n"+E.stack;}if(E.canceled){q.sap.log.debug(l,D,R);return;}q.sap.log.error(l,D,R);if(E.$reported){return;}E.$reported=true;sap.ui.getCore().getMessageManager().addMessages(new M({message:E.message,processor:this,technical:true,type:"Error"}));};k.prototype.requestCanonicalPath=function(E){return E.requestCanonicalPath();};k.prototype.resetChanges=function(G){G=G||this.sUpdateGroupId;this.checkGroupId(G,true);this.oRequestor.cancelChanges(G);};k.prototype.resolve=function(p,o){var R;if(p[0]==="/"){R=p;}else if(o){if(p){if(o.getPath().slice(-1)==="/"){R=o.getPath()+p;}else{R=o.getPath()+"/"+p;}}else{R=o.getPath();}}if(R&&R!=="/"&&R[R.length-1]==="/"&&R.indexOf("#")<0){R=R.slice(0,R.length-1);}return R;};k.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataModel#setLegacySyntax");};k.prototype.submitBatch=function(G){this.checkGroupId(G,true);return this._submitBatch(G);};k.prototype.toString=function(){return C+": "+this.sServiceUrl;};return k;},true);
