/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/Control","sap/m/Label"],function(C,L){"use strict";var D=C.extend("sap.m.DraftIndicator",{metadata:{properties:{state:{type:"sap.m.DraftIndicatorState",group:"Behavior",defaultValue:sap.m.DraftIndicatorState.Clear},minDisplayTime:{type:"int",group:"Behavior",defaultValue:1500}},aggregations:{_label:{type:"sap.m.Label",multiple:false,visibility:"hidden"}}}});var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");D._oTEXTS={};D._oTEXTS[sap.m.DraftIndicatorState.Saving]=b.getText("DRAFT_INDICATOR_SAVING_DRAFT");D._oTEXTS[sap.m.DraftIndicatorState.Saved]=b.getText("DRAFT_INDICATOR_DRAFT_SAVED");D._oTEXTS[sap.m.DraftIndicatorState.Clear]="";D.prototype.init=function(){this.aQueue=[];this.iDelayedCallId=null;};D.prototype.setState=function(s){this.setProperty("state",s);this._addToQueue(s);if(s===sap.m.DraftIndicatorState.Saving){this._addToQueue(sap.m.DraftIndicatorState.Clear);}return this;};D.prototype._getLabel=function(){var c=this.getAggregation('_label');if(!c){var c=new sap.m.Label({id:this.getId()+"-label"});this.setAggregation('_label',c,true);c=this.getAggregation('_label');}return c;};D.prototype.showDraftSaving=function(){this._addToQueue(sap.m.DraftIndicatorState.Saving);this._addToQueue(sap.m.DraftIndicatorState.Clear);};D.prototype.showDraftSaved=function(){this._addToQueue(sap.m.DraftIndicatorState.Saved);};D.prototype.clearDraftState=function(){this._addToQueue(sap.m.DraftIndicatorState.Clear);};D.prototype._addToQueue=function(s){this.aQueue.push(s);this._processQueue();};D.prototype._processQueue=function(){if(this.iDelayedCallId){return;}var n=this.aQueue.shift();var t=this.getMinDisplayTime();if(!n){return;}this._applyState(n);if(n===sap.m.DraftIndicatorState.Clear){this._proceed();return;}this.iDelayedCallId=jQuery.sap.delayedCall(t,this,this._proceed);};D.prototype._proceed=function(){this._resetDraftTimer();this._processQueue();};D.prototype._applyState=function(s){this._getLabel().setText(D._oTEXTS[s]);};D.prototype._resetDraftTimer=function(){jQuery.sap.clearDelayedCall(this.iDelayedCallId);this.iDelayedCallId=null;};return D;},true);
