/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Item','sap/ui/core/Renderer','sap/ui/core/IconPool','sap/ui/core/InvisibleText'],function(q,l,I,R,a,b){"use strict";var c=I.extend("sap.m.IconTabFilter",{metadata:{interfaces:["sap.m.IconTab","sap.ui.core.PopupInterface"],library:"sap.m",properties:{count:{type:"string",group:"Data",defaultValue:''},showAll:{type:"boolean",group:"Misc",defaultValue:false},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:''},iconColor:{type:"sap.ui.core.IconColor",group:"Appearance",defaultValue:sap.ui.core.IconColor.Default},iconDensityAware:{type:"boolean",group:"Appearance",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},design:{type:"sap.m.IconTabFilterDesign",group:"Appearance",defaultValue:sap.m.IconTabFilterDesign.Vertical}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});c._aAllIconColors=['sapMITBFilterCritical','sapMITBFilterPositive','sapMITBFilterNegative','sapMITBFilterDefault','sapMITBFilterNeutral'];c.prototype._getImageControl=function(C,p,d){var P={src:this.getIcon(),densityAware:this.getIconDensityAware(),useIconTooltip:false};if(P.src){this._oImageControl=sap.m.ImageHelper.getImageControl(this.getId()+"-icon",this._oImageControl,p,P,C,d);}else if(this._oImageControl){this._oImageControl.destroy();this._oImageControl=null;}return this._oImageControl;};c.prototype.exit=function(e){if(this._oImageControl){this._oImageControl.destroy();}if(I.prototype.exit){I.prototype.exit.call(this,e);}};c.prototype.invalidate=function(){var i=this.getParent(),o;if(i instanceof sap.m.IconTabHeader&&i.getParent()instanceof sap.m.IconTabBar){o=i.getParent();if(o.getParent()instanceof sap.m.ObjectHeader){var O=o.getParent();O.invalidate();}else{o.invalidate();}}};c.prototype.setProperty=function(p,v,s){switch(p){case'text':case'count':case'showAll':case'icon':case'iconColor':case'iconDensityAware':case'design':if(this.getProperty(p)===v){return this;}sap.ui.core.Control.prototype.setProperty.call(this,p,v,true);if(!s){var i=this.getParent();if(i instanceof sap.m.IconTabHeader){i.invalidate();}}break;default:sap.ui.core.Control.prototype.setProperty.apply(this,arguments);break;}return this;};c.prototype._getNonEmptyKey=function(){var k=this.getKey();if(k){return k;}return this.getId();};c.prototype.render=function(r){var t=this;if(!t.getVisible()){return;}var i=this.getParent(),d=i.getParent(),h=d instanceof sap.m.IconTabBar,e=sap.ui.getCore().getLibraryResourceBundle('sap.m'),f='role="tab"',g=t.getId(),j=t.getCount(),k=t.getText(),m=t.getIcon(),n=t.getDesign(),o=t.getIconColor(),p=o==='Positive'||o==='Critical'||o==='Negative',s=n===sap.m.IconTabFilterDesign.Horizontal,u=h&&d.getUpperCase(),v=i._bTextOnly,w=i._bInLine||i.isInlineMode();if(h){f+=' aria-controls="'+d.sId+'-content" ';}if(k.length||j!==''||m){f+='aria-labelledby="';var x=[];if(k.length){x.push(g+'-text');}if(j!==''){x.push(g+'-count');}if(m){x.push(g+'-icon');}if(p){x.push(g+'-iconColor');}f+=x.join(' ');f+='"';}r.write('<div '+f+' ');r.writeElementData(t);r.addClass('sapMITBItem');if(!j){r.addClass('sapMITBItemNoCount');}if(s){r.addClass('sapMITBHorizontal');}else{r.addClass('sapMITBVertical');}if(t.getShowAll()){r.addClass('sapMITBAll');}else{r.addClass('sapMITBFilter');r.addClass('sapMITBFilter'+o);}if(!t.getEnabled()){r.addClass('sapMITBDisabled');r.writeAttribute('aria-disabled',true);}r.writeAttribute('aria-selected',false);var T=t.getTooltip_AsString();if(T){r.writeAttributeEscaped('title',T);}r.writeClasses();r.write('>');if(!w){r.write('<div id="'+g+'-tab" class="sapMITBTab">');if(!t.getShowAll()||!m){if(p){r.write('<div id="'+g+'-iconColor" style="display: none;">'+e.getText('ICONTABBAR_ICONCOLOR_'+o.toUpperCase())+'</div>');}r.renderControl(t._getImageControl(['sapMITBFilterIcon','sapMITBFilter'+o],i,c._aAllIconColors));}if(!t.getShowAll()&&!m&&!v){r.write('<span class="sapMITBFilterNoIcon"> </span>');}if(s&&!t.getShowAll()){r.write('</div>');r.write('<div class="sapMITBHorizontalWrapper">');}r.write('<span id="'+g+'-count" ');r.addClass('sapMITBCount');r.writeClasses();r.write('>');if(j===''&&s){r.write('&nbsp;');}else{r.writeEscaped(j);}r.write('</span>');if(!s){r.write('</div>');}}if(k.length){r.write('<div id="'+g+'-text" ');r.addClass('sapMITBText');if(u){r.addClass('sapMITBTextUpperCase');}if(w){r.writeAttribute('dir','ltr');}r.writeClasses();r.write('>');r.writeEscaped(i._getDisplayText(t));r.write('</div>');}if(!w&&s){r.write('</div>');}r.write('<div class="sapMITBContentArrow"></div>');r.write('</div>');};c.prototype.renderInSelectList=function(r,s){var t=this;if(!t.getVisible()){return;}var i=true,d,e=s._iconTabHeader,f=s.getItems(),g=f.length,h=f.indexOf(t),j=sap.ui.getCore().getLibraryResourceBundle('sap.m');if(e){i=e._bTextOnly;d=s._bIconOnly;}r.write('<li');r.writeElementData(t);r.writeAttribute('tabindex','-1');r.writeAttribute('role','option');r.writeAttribute('aria-posinset',h+1);r.writeAttribute('aria-setsize',g);var k=t.getTooltip_AsString();if(k){r.writeAttributeEscaped('title',k);}if(!t.getEnabled()){r.addClass('sapMITBDisabled');r.writeAttribute('aria-disabled',true);}r.addClass('sapMITBSelectItem');if(s.getSelectedItem()==t){r.addClass('sapMITBSelectItemSelected');r.writeAttribute('aria-selected',true);}var m=t.getIconColor();r.addClass('sapMITBFilter'+m);r.writeClasses();var n=t.getId(),o,p=m=='Positive'||m=='Critical'||m=='Negative';var u=' aria-labelledby="';if(!d){u+=n+'-text ';}if(!i&&t.getIcon()){u+=n+'-icon ';}if(p){o=new b({text:j.getText('ICONTABBAR_ICONCOLOR_'+m.toUpperCase())});u+=o.getId();}u+='"';r.write(u+'>');if(o){r.renderControl(o);}if(!i){this._renderIcon(r);}if(!d){this._renderText(r);}r.write('</li>');};c.prototype._renderIcon=function(r){var i=this.getIcon();if(i){var d=a.getIconInfo(i);var e=['sapMITBSelectItemIcon'];if(d&&!d.suppressMirroring){e.push('sapUiIconMirrorInRTL');}r.writeIcon(i,e,{id:this.getId()+'-icon','aria-hidden':true});}else{r.write('<span class="sapUiIcon"></span>');}};c.prototype._renderText=function(r){var t=this.getText(),d=this.getCount(),i=sap.ui.getCore().getConfiguration().getRTL(),e=this.getTextDirection();r.write('<span');r.writeAttribute('id',this.getId()+'-text');r.writeAttribute('dir','ltr');r.addClass('sapMText');r.addClass('sapMTextNoWrap');r.addClass('sapMITBText');r.writeClasses();if(e!==sap.ui.core.TextDirection.Inherit){r.writeAttribute('dir',e.toLowerCase());}var f=R.getTextAlign(sap.ui.core.TextAlign.Begin,e);if(f){r.addStyle('text-align',f);r.writeStyles();}if(d){if(i){t='('+d+') '+t;}else{t+=' ('+d+')';}}r.write('>');r.writeEscaped(t);r.write('</span>');};return c;},true);
