/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/Control","sap/ui/core/IconPool","sap/ui/core/HTML","sap/ui/core/Icon","./Button","./Toolbar","./ToolbarSpacer","./Bar","./List","./StandardListItem","./ListType","./Text","./SegmentedButton","./Page","./NavContainer","./Link","./Popover","./MessageItem"],function(q,C,I,H,a,B,T,b,c,L,S,d,e,f,P,N,g,h,M){"use strict";var j=C.extend("sap.m.MessageView",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessageItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{}}}});var k="sapMMsgView";var l={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")};var m=["all","error","warning","success","information"];var A=["asyncDescriptionHandler","asyncURLHandler"];var D={asyncDescriptionHandler:function(i){var s=i.item.getLongtextUrl();if(s){q.ajax({type:"GET",url:s,success:function(n){i.item.setDescription(n);i.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+s;q.sap.log.error(E);i.promise.reject(E);}});}}};j.setDefaultHandlers=function(i){A.forEach(function(F){if(i.hasOwnProperty(F)){D[F]=i[F];}});};j.prototype.init=function(){var t=this;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._createNavigationPages();this._createLists();A.forEach(function(F){if(D.hasOwnProperty(F)){t.setProperty(F,D[F]);}});};j.prototype.onBeforeRendering=function(){this._clearLists();this._fillLists(this.getItems());this._clearSegmentedButton();this._fillSegmentedButton();this._fnFilterList("all");var i=this.getHeaderButton();if(i){this._oListHeader.insertContent(i,2);}if(!this.getBindingInfo("items")&&!this.getItems().length){this._makeAutomaticBinding();}};j.prototype.exit=function(){if(this._navContainer){this._navContainer.destroy();}if(this._oLists){this._destroyLists();}if(this._oMessageItemTemplate){this._oMessageItemTemplate.destroy();}this._oResourceBundle=null;this._oListHeader=null;this._oDetailsHeader=null;this._oSegmentedButton=null;this._oBackButton=null;this._navContainer=null;this._listPage=null;this._detailsPage=null;this._sCurrentList=null;};j.prototype._makeAutomaticBinding=function(){var t=this;this.setModel(sap.ui.getCore().getMessageManager().getMessageModel(),"message");this._oMessageItemTemplate=new M({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"});this.bindAggregation("items",{path:"message>/",template:t._oMessageItemTemplate});};j.prototype._onkeypress=function(E){if(E.shiftKey&&E.keyCode==q.sap.KeyCodes.ENTER){this._fnHandleBackPress();}};j.prototype._getListHeader=function(){return this._oListHeader||this._createListHeader();};j.prototype._getDetailsHeader=function(){return this._oDetailsHeader||this._createDetailsHeader();};j.prototype._createListHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDescr";var o=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var n=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_HEADING");var p=this.getId()+"-HeadingDescr";var r=new H(p,{content:"<span id=\""+p+"\" style=\"display: none;\" role=\"heading\">"+n+"</span>"});this._oSegmentedButton=new f(this.getId()+"-segmented",{}).addStyleClass("sapMSegmentedButtonNoAutoWidth");this._oListHeader=new T({content:[this._oSegmentedButton,new b(),o,r]});return this._oListHeader;};j.prototype._createDetailsHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDetDescr";var o=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var n=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON_TOOLTIP");var p=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON");var r=this.getId()+"-BackBtnDetDescr";var t=new H(r,{content:"<span id=\""+r+"\" style=\"display: none;\">"+p+"</span>"});this._oBackButton=new B({icon:l["back"],press:this._fnHandleBackPress.bind(this),ariaLabelledBy:t,tooltip:n}).addStyleClass(k+"BackBtn");this._oDetailsHeader=new T({content:[this._oBackButton,new b(),o,t]});return this._oDetailsHeader;};j.prototype._createNavigationPages=function(){this._listPage=new P(this.getId()+"listPage",{customHeader:this._getListHeader()});this._detailsPage=new P(this.getId()+"-detailsPage",{customHeader:this._getDetailsHeader()});this._detailsPage.addEventDelegate({onclick:function(E){var t=E.target;if(t.nodeName.toUpperCase()==="A"&&(t.className.indexOf("sapMMsgPopoverItemDisabledLink")!==-1||t.className.indexOf("sapMMsgPopoverItemPendingLink")!==-1)){E.preventDefault();}}});this._navContainer=new N(this.getId()+"-navContainer",{initialPage:this.getId()+"listPage",pages:[this._listPage,this._detailsPage]});return this;};j.prototype._createLists=function(){this._oLists={};m.forEach(function(s){this._oLists[s]=new L({itemPress:this._fnHandleItemPress.bind(this),visible:false});this._listPage.addAggregation("content",this._oLists[s],true);},this);return this;};j.prototype._clearLists=function(){m.forEach(function(s){if(this._oLists[s]){this._oLists[s].destroyAggregation("items",true);}},this);return this;};j.prototype._destroyLists=function(){m.forEach(function(s){this._oLists[s]=null;},this);this._oLists=null;};j.prototype._fillLists=function(i){i.forEach(function(o){var n=this._mapItemToListItem(o),p=this._mapItemToListItem(o);this._oLists["all"].addAggregation("items",n,true);this._oLists[o.getType().toLowerCase()].addAggregation("items",p,true);},this);};j.prototype._mapItemToListItem=function(o){if(!o){return null;}var t=o.getType(),i=this._getItemType(o),n=new S({title:o.getTitle(),description:o.getSubtitle(),counter:o.getCounter(),icon:this._mapIcon(t),infoState:this._mapInfoState(t),info:"\r",type:i}).addStyleClass(k+"Item").addStyleClass(k+"Item"+t);if(i!==d.Navigation){n.addEventDelegate({onAfterRendering:function(){var p=this.getDomRef().querySelector(".sapMSLITitleDiv > div");if(p.offsetWidth<p.scrollWidth){this.setType(d.Navigation);}}},n);}n._oMessageItem=o;return n;};j.prototype._mapInfoState=function(t){if(!t){return null;}var i=sap.ui.core.MessageType,V=sap.ui.core.ValueState;switch(t){case i.Warning:return V.Warning;case i.Error:return V.Error;case i.Success:return V.Success;case i.Information:case i.None:return V.None;default:q.sap.log.warning("The provided MessageType is not mapped to a specific ValueState",t);return null;}};j.prototype._mapIcon=function(i){if(!i){return null;}return l[i.toLowerCase()];};j.prototype._getItemType=function(o){return(o.getDescription()||o.getMarkupDescription()||o.getLongtextUrl())?d.Navigation:d.Inactive;};j.prototype._clearSegmentedButton=function(){if(this._oSegmentedButton){this._oSegmentedButton.destroyAggregation("buttons",true);}return this;};j.prototype._fillSegmentedButton=function(){var t=this;var p=function(s){return function(){t._fnFilterList(s);};};m.forEach(function(s){var o=this._oLists[s],i=o.getItems().length,n;if(i>0){n=new B(this.getId()+"-"+s,{text:s=="all"?this._oResourceBundle.getText("MESSAGEPOPOVER_ALL"):i,icon:l[s],press:p(s)}).addStyleClass(k+"Btn"+s.charAt(0).toUpperCase()+s.slice(1));this._oSegmentedButton.addButton(n,true);}},this);return this;};j.prototype._setIcon=function(o,i){this._previousIconTypeClass=k+"DescIcon"+o.getType();this._oMessageIcon=new a({src:i.getIcon()}).addStyleClass(k+"DescIcon").addStyleClass(this._previousIconTypeClass);this._detailsPage.addContent(this._oMessageIcon);};j.prototype._setTitle=function(o){this._oMessageTitleText=new e(this.getId()+"MessageTitleText",{text:o.getTitle()}).addStyleClass("sapMMsgViewTitleText");this._detailsPage.addAggregation("content",this._oMessageTitleText);};j.prototype._setDescription=function(o){var i=o.getLink();this._oLastSelectedItem=o;if(o.getMarkupDescription()){this._oMessageDescriptionText=new H(this.getId()+"MarkupDescription",{content:"<div class='sapMMsgViewDescriptionText'>"+o.getDescription()+"</div>"});}else{this._oMessageDescriptionText=new e(this.getId()+"MessageDescriptionText",{text:o.getDescription()}).addStyleClass("sapMMsgViewDescriptionText");}this._detailsPage.addContent(this._oMessageDescriptionText);if(i){this._detailsPage.addContent(i);i.addStyleClass("sapMMsgViewDescriptionLink");}};j.prototype._iNextValidationTaskId=0;j.prototype._validateURL=function(u){if(q.sap.validateUrl(u)){return u;}q.sap.log.warning("You have entered invalid URL");return"";};j.prototype._queueValidation=function(i){var n=this.getAsyncURLHandler();var v=++this._iNextValidationTaskId;var p={};var o=new window.Promise(function(r,s){p.resolve=r;p.reject=s;var t={url:i,id:v,promise:p};n(t);});o.id=v;return o;};j.prototype._getTagPolicy=function(){var t=this,i;var n=html.makeTagPolicy(this._validateURL());return function customTagPolicy(o,p){var r,v=false;if(o.toUpperCase()==="A"){for(i=0;i<p.length;){if(p[i]==="href"){v=true;r=p[i+1];p.splice(0,2);continue;}i+=2;}}p=n(o,p);if(v&&typeof t.getAsyncURLHandler()==="function"){p=p||[];var s="sapMMsgViewItemDisabledLink sapMMsgViewItemPendingLink";var u=p.indexOf("class");if(u>-1){p[u+1]+=s;}else{p.unshift(s);p.unshift("class");}var w=p.indexOf("id");if(w>-1){p.splice(w+1,1);p.splice(w,1);}var V=t._queueValidation(r);p.push("href");p.push(r);p.push("target");p.push("_blank");p.push("id");p.push("sap-ui-"+t.getId()+"-link-under-validation-"+V.id);V.then(function(x){var $=q.sap.byId("sap-ui-"+t.getId()+"-link-under-validation-"+x.id);if(x.allowed){q.sap.log.info("Allow link "+r);}else{q.sap.log.info("Disallow link "+r);}$.removeClass("sapMMsgViewItemPendingLink");$.toggleClass("sapMMsgViewItemDisabledLink",!x.allowed);t.fireUrlValidated();}).catch(function(){q.sap.log.warning("Async URL validation could not be performed.");});}return p;};};j.prototype._sanitizeDescription=function(o){q.sap.require("jquery.sap.encoder");q.sap.require("sap.ui.thirdparty.caja-html-sanitizer");var s=o.getDescription();if(o.getMarkupDescription()){var t=this._getTagPolicy();s=html.sanitizeWithPolicy(s,t);}o.setDescription(s);this._setDescription(o);};j.prototype._fnHandleItemPress=function(E){var o=E.getParameter("listItem"),i=o._oMessageItem,n=this._detailsPage.getContent()||[];var p=this.getAsyncDescriptionHandler();var r=function(v){this._setTitle(i);this._sanitizeDescription(i);this._setIcon(i,o);this._detailsPage.rerender();this.fireLongtextLoaded();if(!v){this._navContainer.to(this._detailsPage);}}.bind(this);this._previousIconTypeClass=this._previousIconTypeClass||"";this.fireItemSelect({item:i,messageTypeFilter:this._getCurrentMessageTypeFilter()});n.forEach(function(v){if(v instanceof g){this._oLastSelectedItem.setLink(v);v.removeAllAriaLabelledBy();}else{v.destroy();}},this);if(typeof p==="function"&&!!i.getLongtextUrl()){i.setMarkupDescription(true);var s={};var t=new window.Promise(function(v,w){s.resolve=v;s.reject=w;});var u=function(){this._detailsPage.setBusy(false);r(true);}.bind(this);t.then(u).catch(function(){q.sap.log.warning("Async description loading could not be performed.");u();});this._navContainer.to(this._detailsPage);this._detailsPage.setBusy(true);p({promise:s,item:i});}else{r();}this._listPage.$().attr("aria-hidden","true");};j.prototype._fnHandleBackPress=function(){this._listPage.$().removeAttr("aria-hidden");this._navContainer.back();};j.prototype._fnFilterList=function(s){m.forEach(function(i){if(i!=s&&this._oLists[i].getVisible()){this._oLists[i].setVisible(false);}},this);this._sCurrentList=s;this._oLists[s].setVisible(true);this._listPage.rerender();this.fireListSelect({messageTypeFilter:this._getCurrentMessageTypeFilter()});};j.prototype._getCurrentMessageTypeFilter=function(){return this._sCurrentList=="all"?"":this._sCurrentList;};j.prototype._isListPage=function(){return this._navContainer.getCurrentPage()==this._listPage;};return j;},true);
