/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ColumnListItem','./P13nPanel','./P13nSelectionItem','./SearchField','./Table','./library','sap/ui/core/Control','sap/ui/model/json/JSONModel'],function(q,C,P,c,S,T,l,d,J){"use strict";var e=P.extend("sap.m.P13nSelectionPanel",{metadata:{library:"sap.m",aggregations:{selectionItems:{type:"sap.m.P13nSelectionItem",multiple:true,singularName:"selectionItem",bindable:"bindable"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}}},renderer:function(r,o){r.write("<div");r.writeControlData(o);r.addClass("sapMP13nColumnsPanel");r.writeClasses();r.write(">");var a=o.getAggregation("content");if(a){a.forEach(function(b){r.renderControl(b);});}r.write("</div>");}});e.prototype.getOkPayload=function(){this._syncModel2Panel();return{selectionItems:this.getSelectionItems()};};e.prototype.init=function(){this._iLiveChangeTimer=0;this._iSearchTimer=0;this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._bOnAfterRenderingFirstTimeExecuted=false;this._bOnBeforeRenderingFirstTimeExecuted=false;var m=new J({linkPressMap:{},items:[],indexOfMarkedTableItem:-1,markedTableItem:null,isMoveDownButtonEnabled:false,isMoveUpButtonEnabled:false,showOnlySelectedItems:false,countOfSelectedItems:0,countOfItems:0,config:this.getConfig()});m.setDefaultBindingMode(sap.ui.model.BindingMode.TwoWay);m.setSizeLimit(1000);this.setModel(m,"$sapmP13nSelectionPanel");this.setType(sap.m.P13nPanelType.selection);};e.prototype.getConfig=function(){return{isEnabledSelectedItemsSorting:false,isEnabledSelectedButton:false,isEnabledMoveButtons:false};};e.prototype.applySettings=function(s){P.prototype.applySettings.apply(this,arguments);var t=this;this._createTable();this._createToolbar();this.setVerticalScrolling(false);var o=new sap.m.ScrollContainer({horizontal:false,vertical:true,content:[this._oTable],width:'100%',height:'100%'});this._fnHandleResize=function(){var b=false,i,a;if(t.getParent){var $=null,f,h;var p=t.getParent();var g=t._getToolbar();if(p){$=q("#"+p.getId()+"-cont");if($.children().length>0&&g.$().length>0){i=o.$()[0].clientHeight;f=$.children()[0].clientHeight;h=g?g.$()[0].clientHeight:0;a=f-h;if(i!==a){o.setHeight(a+'px');b=true;}}}}return b;};this.addAggregation("content",o);this._sContainerResizeListener=sap.ui.core.ResizeHandler.register(o,this._fnHandleResize);};e.prototype.onBeforeRendering=function(){if(!this._bOnBeforeRenderingFirstTimeExecuted){this._bOnBeforeRenderingFirstTimeExecuted=true;this._syncPanel2Model();}if(!this._getInternalModel().getData().markedTableItem){var v=this._getVisibleTableItems();this._switchMarkedTableItemTo(v[0]);}};e.prototype.onAfterRendering=function(){var t=this;if(!this._bOnAfterRenderingFirstTimeExecuted){this._bOnAfterRenderingFirstTimeExecuted=true;window.clearTimeout(this._iLiveChangeTimer);this._iLiveChangeTimer=window.setTimeout(function(){t._fnHandleResize();},0);}};e.prototype.addItem=function(i){var m=this._getInternalModel();var D=m.getData();this._bOnBeforeRenderingFirstTimeExecuted=false;this.addAggregation("items",i);this._includeModelItem(i,-1);this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);return this;};e.prototype.insertItem=function(i,I){var m=this._getInternalModel();var D=m.getData();this._bOnBeforeRenderingFirstTimeExecuted=false;this.insertAggregation("items",i,I);this._includeModelItem(i,I);this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);return this;};e.prototype.removeItem=function(i){var I=this.indexOfItem(i);if(I>-1){var m=this._getInternalModel();var D=m.getData();this._bOnBeforeRenderingFirstTimeExecuted=false;m.getData().items.splice(I,1);this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);}i=this.removeAggregation("items",i);return i;};e.prototype.removeAllItems=function(){var m=this._getInternalModel();this._bOnBeforeRenderingFirstTimeExecuted=false;var i=this.removeAllAggregation("items");m.getData().items=[];return i;};e.prototype.destroyItems=function(){var m=this._getInternalModel();this._bOnBeforeRenderingFirstTimeExecuted=false;this.destroyAggregation("items");m.getData().items=[];return this;};e.prototype.addSelectionItem=function(s){var m=this._getInternalModel();var D=m.getData();this.addAggregation("selectionItems",s);var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}M.persistentIndex=s.getIndex();M.persistentSelected=s.getSelected();this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);return this;};e.prototype.insertSelectionItem=function(s,i){var m=this._getInternalModel();var D=m.getData();this.insertAggregation("selectionItems",s,i);var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}M.persistentIndex=s.getIndex();M.persistentSelected=s.getSelected();this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);return this;};e.prototype.removeSelectionItem=function(s){var m=this._getInternalModel();var D=m.getData();s=this.removeAggregation("selectionItems",s);var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);return s;};e.prototype.removeAllSelectionItems=function(){var m=this._getInternalModel();var D=m.getData();this.getSelectionItems().forEach(function(o){var M=this._getModelItemByColumnKey(o.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;},this);this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);var s=this.removeAllAggregation("selectionItems");return s;};e.prototype.destroySelectionItems=function(){var m=this._getInternalModel();var D=m.getData();this.getSelectionItems().forEach(function(s){var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M){return;}M.persistentIndex=-1;M.persistentSelected=undefined;},this);this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);this.destroyAggregation("selectionItems");return this;};e.prototype.onBeforeNavigationFrom=function(){this._syncModel2Panel();return true;};e.prototype.exit=function(){sap.ui.core.ResizeHandler.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;this._getToolbar().destroy();this._oTable.destroy();this._oTable=null;if(this._getInternalModel()){this._getInternalModel().destroy();}window.clearTimeout(this._iLiveChangeTimer);window.clearTimeout(this._iSearchTimer);};e.prototype._syncPanel2Model=function(){var m=this._getInternalModel();var D=m.getData();this.getSelectionItems().forEach(function(s){var M=this._getModelItemByColumnKey(s.getColumnKey());if(!M||this._isSelectionItemEqualToModelItem(s,M)){return;}M.persistentIndex=s.getIndex();M.persistentSelected=s.getSelected();this._sortModelItemsByPersistentIndex(D.items);this._updateModelItemsTableIndex(D);this._updateCounts(D);},this);m.refresh();};e.prototype._syncModel2Panel=function(){if(!this._bOnBeforeRenderingFirstTimeExecuted){return;}var D=this._getInternalModel().getData();D.items.forEach(function(m){var s=this._getSelectionItemByColumnKey(m.columnKey);if(s){if(!this._isSelectionItemEqualToModelItem(s,m)){s.setProperty("selected",m.persistentSelected,true);s.setProperty("index",m.persistentIndex,true);}return;}if(!m.persistentSelected){return;}s=new sap.m.P13nSelectionItem({columnKey:m.columnKey,selected:m.persistentSelected,index:m.persistentIndex});this.addAggregation("selectionItems",s,true);},this);};e.prototype._moveMarkedTableItem=function(D){var o=this._getInternalModel().getData();if(!o.markedTableItem||o.indexOfMarkedTableItem<0){return;}var v=this._getVisibleTableItems();if(v.indexOf(o.markedTableItem)<0){return;}var f=function(){switch(D){case"Down":return o.indexOfMarkedTableItem+1;case"Bottom":return V.length-1;case"Up":return o.indexOfMarkedTableItem-1;case"Top":return 0;}};var V=this._getVisibleModelItems();var m=V[o.indexOfMarkedTableItem];var M=V[f()];if(this._moveModelItems(this._getModelItemIndexByColumnKey(m.columnKey),this._getModelItemIndexByColumnKey(M.columnKey))){this._switchMarkedTableItemTo(v[f()]);}};e.prototype._filterModelItemsBySearchText=function(){var m=this._getInternalModel();var s=this._getSearchText();s=s.replace(/(^\s+)|(\s+$)/g,'');s=s.replace(/[-\/\\^$*+?.()|[\]{}]/g,'\\$&');var r=new RegExp(s,'igm');if(!r){return;}this._getVisibleModelItems().forEach(function(M){M.visible=false;if(M.text&&M.text.match(r)){M.visible=true;}if(M.tooltip&&M.tooltip.match(r)){M.visible=true;}});m.refresh();};e.prototype._scrollToSelectedItem=function(i){var f=null;if(i){sap.ui.getCore().applyChanges();if(!!i.getDomRef()){f=document.activeElement;i.focus();if(f&&f.focus){f.focus();}}}};e.prototype._includeModelItem=function(i,I){var m=this._getInternalModel();var D=m.getData();if(I<0){I=D.items.length;}var M={columnKey:i.getColumnKey(),visible:true,text:i.getText(),href:i.getHref(),target:i.getTarget(),tooltip:i.getTooltip(),originalIndex:I,persistentIndex:-1,persistentSelected:undefined,tableIndex:undefined};D.linkPressMap[i.getText()+"---"+i.getHref()]=i.getPress();D.items.splice(I,0,M);};e.prototype._onItemPressed=function(E){this._switchMarkedTableItemTo(E.getParameter('listItem'));};e.prototype._onSelectionChange=function(E){var m=this._getInternalModel();var D=m.getData();var t=E.getParameter("listItem");this._switchMarkedTableItemTo(t);this._updateModelItemsPersistentIndex(D);this._updateCounts(D);m.refresh();this.notifyChange();};e.prototype._onSwitchButtonShowSelected=function(){var D=this._getInternalModel().getData();D.showOnlySelectedItems=!D.showOnlySelectedItems;this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(D.markedTableItem);this._updateControlLogic();this._fnHandleResize();};e.prototype._onExecuteSearch=function(){var D=this._getInternalModel().getData();this._switchVisibilityOfUnselectedModelItems();this._filterModelItemsBySearchText();this._scrollToSelectedItem(D.markedTableItem);this._updateControlLogic();};e.prototype._getSelectionItemByColumnKey=function(s){for(var i=0,a=this.getSelectionItems(),b=a.length;i<b;i++){if(a[i].getColumnKey()===s){return a[i];}}return null;};e.prototype._getModelItemIndexByColumnKey=function(s){var i=-1;this._getInternalModel().getData().items.some(function(m,I){if(m.columnKey===s){i=I;return true;}});return i;};e.prototype._getModelItemByColumnKey=function(s){var m=null;this._getInternalModel().getData().items.some(function(M){if(M.columnKey===s){m=M;return true;}});return m;};e.prototype._moveModelItems=function(i,I){var m=this._getInternalModel();var D=m.getData();if(i<0||I<0||i>D.items.length-1||I>D.items.length-1){return false;}var M=D.items.splice(i,1);D.items.splice(I,0,M[0]);this._updateModelItemsPersistentIndex(D);this._updateModelItemsTableIndex(D);this._updateCounts(D);m.refresh();return true;};e.prototype._switchVisibilityOfUnselectedModelItems=function(){var m=this._getInternalModel();var s=this._isFilteredByShowSelected();m.getData().items.forEach(function(M){if(M.persistentSelected){M.visible=true;return;}M.visible=!s;});m.refresh();};e.prototype._getVisibleTableItems=function(){var v=[];this._oTable.getItems().forEach(function(t){if(t.getVisible()){v.push(t);}});return v;};e.prototype._getVisibleModelItems=function(){var v=[];this._getInternalModel().getData().items.forEach(function(m){if(m.visible){v.push(m);}});return v;};e.prototype._getSelectedModelItems=function(){var s=[];this._getInternalModel().getData().items.forEach(function(m){if(m.persistentSelected){s.push(m);}});return s;};e.prototype._getModelItemByTableItem=function(t){var i=this._getVisibleTableItems().indexOf(t);return this._getVisibleModelItems()[i];};e.prototype._updateModelItemsTableIndex=function(D){D.items.forEach(function(m,t){m.tableIndex=t;});};e.prototype._updateModelItemsPersistentIndex=function(D){var p=-1;D.items.forEach(function(m){m.persistentIndex=-1;if(m.persistentSelected){p++;m.persistentIndex=p;}});};e.prototype._updateCounts=function(D){D.countOfSelectedItems=0;D.countOfItems=0;D.items.forEach(function(m){D.countOfItems++;if(m.persistentSelected){D.countOfSelectedItems++;}});};e.prototype._sortModelItemsByPersistentIndex=function(m){if(!this._getInternalModel().getProperty("/config/isEnabledSelectedItemsSorting")){return;}m.sort(function(a,b){if(a.persistentSelected===true&&(b.persistentSelected===false||b.persistentSelected===undefined)){return-1;}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&b.persistentSelected===true){return 1;}else if(a.persistentSelected===true&&b.persistentSelected===true){if(a.persistentIndex<b.persistentIndex){return-1;}else if(a.persistentIndex>b.persistentIndex){return 1;}else{return 0;}}else if((a.persistentSelected===false||a.persistentSelected===undefined)&&(b.persistentSelected===false||b.persistentSelected===undefined)){if(a.text<b.text){return-1;}else if(a.text>b.text){return 1;}else{return 0;}}});};e.prototype._switchMarkedTableItemTo=function(t){var D=this._getInternalModel().getData();if(D.markedTableItem===t){return;}if(D.markedTableItem){D.markedTableItem.removeStyleClass("sapMP13nColumnsPanelItemSelected");}D.indexOfMarkedTableItem=this._getVisibleTableItems().indexOf(t);D.markedTableItem=t;if(D.markedTableItem){D.markedTableItem.addStyleClass("sapMP13nColumnsPanelItemSelected");}this._scrollToSelectedItem(D.markedTableItem);this._updateControlLogic();};e.prototype._getTableColumns=function(){var t=this;return[new sap.m.Column({header:new sap.m.Text({text:{parts:[{path:'/countOfSelectedItems'},{path:'/countOfItems'}],formatter:function(i,a){return t._oRb.getText('COLUMNSPANEL_SELECT_ALL_WITH_COUNTER',[i,a]);}}})})];};e.prototype._getTableTemplate=function(){var t=this;return new sap.m.ColumnListItem({cells:[new sap.m.Link({href:"{href}",text:"{text}",target:"{target}",enabled:{path:'href',formatter:function(v){if(!v){this.addStyleClass("sapUiCompSmartLink");}return!!v;}},press:function(E){var o=t._getInternalModel().getProperty("/linkPressMap")[this.getText()+"---"+this.getHref()];if(o){o(E);}}})],visible:"{visible}",selected:"{persistentSelected}",tooltip:"{tooltip}",type:sap.m.ListType.Active});};e.prototype._createTable=function(){this._oTable=new T({mode:sap.m.ListMode.MultiSelect,rememberSelections:false,itemPress:q.proxy(this._onItemPressed,this),selectionChange:q.proxy(this._onSelectionChange,this),columns:this._getTableColumns(),items:{path:"/items",templateShareable:false,template:this._getTableTemplate()}});this._oTable.setModel(this._getInternalModel());};e.prototype._createToolbar=function(){var m=this._getInternalModel();var t=this;var s=new S(this.getId()+"-searchField",{liveChange:function(E){var v=E.getSource().getValue(),D=(v?300:0);window.clearTimeout(t._iSearchTimer);if(D){t._iSearchTimer=window.setTimeout(function(){t._onExecuteSearch();},D);}else{t._onExecuteSearch();}},search:q.proxy(this._onExecuteSearch,this),layoutData:new sap.m.OverflowToolbarLayoutData({minWidth:"12.5rem",maxWidth:"23.077rem",shrinkable:true,moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High})});var o=new sap.m.OverflowToolbar(this.getId()+"-toolbar",{active:true,design:sap.m.ToolbarDesign.Auto,content:[new sap.m.ToolbarSpacer(),s]});var a=new sap.m.Button({text:{path:'/showOnlySelectedItems',formatter:function(h){return h?t._oRb.getText('COLUMNSPANEL_SHOW_ALL'):t._oRb.getText('COLUMNSPANEL_SHOW_SELECTED');}},tooltip:this._oRb.getText('COLUMNSPANEL_SHOW_SELECTED'),type:sap.m.ButtonType.Transparent,press:q.proxy(this._onSwitchButtonShowSelected,this),layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High}),visible:{path:'/config/isEnabledSelectedButton'}});a.setModel(m);o.addContent(a);var M=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-down"),text:this._oRb.getText('COLUMNSPANEL_MOVE_DOWN'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_DOWN'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:function(){t._moveMarkedTableItem("Down");var h=t._getInternalModel().getData();if(!h.isMoveDownButtonEnabled){h.markedTableItem.focus();}},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High,group:1}),visible:{path:'/config/isEnabledMoveButtons'}});M.setModel(m);var b=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("slim-arrow-up"),text:this._oRb.getText('COLUMNSPANEL_MOVE_UP'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_UP'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:function(){t._moveMarkedTableItem("Up");var h=t._getInternalModel().getData();if(!h.isMoveUpButtonEnabled){h.markedTableItem.focus();}},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.High,group:1}),visible:{path:'/config/isEnabledMoveButtons'}});b.setModel(m);var f=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("expand-group"),text:this._oRb.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_TO_BOTTOM'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveDownButtonEnabled'},press:function(){t._moveMarkedTableItem("Bottom");var h=t._getInternalModel().getData();if(!h.isMoveDownButtonEnabled){h.markedTableItem.focus();}},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.Low,group:2}),visible:{path:'/config/isEnabledMoveButtons'}});f.setModel(m);var g=new sap.m.OverflowToolbarButton({icon:sap.ui.core.IconPool.getIconURI("collapse-group"),text:this._oRb.getText('COLUMNSPANEL_MOVE_TO_TOP'),tooltip:this._oRb.getText('COLUMNSPANEL_MOVE_TO_TOP'),type:sap.m.ButtonType.Transparent,enabled:{path:'/isMoveUpButtonEnabled'},press:function(){t._moveMarkedTableItem("Top");var h=t._getInternalModel().getData();if(!h.isMoveUpButtonEnabled){h.markedTableItem.focus();}},layoutData:new sap.m.OverflowToolbarLayoutData({moveToOverflow:true,priority:sap.m.OverflowToolbarPriority.Low,group:2}),visible:{path:'/config/isEnabledMoveButtons'}});g.setModel(m);o.addContent(g).addContent(b).addContent(M).addContent(f);this.addAggregation("content",o);};e.prototype._getToolbar=function(){return sap.ui.getCore().byId(this.getId()+"-toolbar")||null;};e.prototype._getSearchField=function(){return sap.ui.getCore().byId(this.getId()+"-searchField")||null;};e.prototype._getSearchText=function(){var s=this._getSearchField();return s?s.getValue():"";};e.prototype._isFilteredBySearchText=function(){return!!this._getSearchText().length;};e.prototype._isFilteredByShowSelected=function(){return this._getInternalModel().getData().showOnlySelectedItems;};e.prototype._isSelectionItemEqualToModelItem=function(s,m){return m.persistentIndex===s.getIndex()&&m.persistentSelected===s.getSelected();};e.prototype._updateControlLogic=function(){var m=this._getInternalModel();var D=m.getData();var i=this._isFilteredBySearchText();var s=this._isFilteredByShowSelected();var v=this._getVisibleTableItems();D.isMoveUpButtonEnabled=v.indexOf(D.markedTableItem)>-1&&D.indexOfMarkedTableItem>0;D.isMoveDownButtonEnabled=v.indexOf(D.markedTableItem)>-1&&D.indexOfMarkedTableItem<v.length-1&&D.indexOfMarkedTableItem>-1;var t=sap.ui.getCore().byId(this._oTable.getId()+'-sa');if(t){t.setEnabled(!i&&!s);}m.refresh();};e.prototype._getInternalModel=function(){return this.getModel("$sapmP13nSelectionPanel");};e.prototype.notifyChange=function(){var L=this.getChangeNotifier();if(L){L(this);}};e.prototype._showAll=function(){q.sap.log.info("ModelItems: columnKey originalIndex  tableIndex_isVisible  persistentIndex_isPersistent        TableItems: current");q.sap.log.info("--------------------------------------------------------------");var D=this._getInternalModel().getData();var t=this._oTable.getItems();var L=Math.max(D.items.length,this._oTable.getItems().length);for(var i=0;i<L;i++){var m=D.items[i];var o=t[i];q.sap.log.info(m.columnKey+": "+m.originalIndex+" "+m.tableIndex+"_"+m.visible+" "+m.persistentIndex+"_"+m.persistentSelected+";  "+o.getCells()[0].getText()+": "+o.getSelected());}};return e;},true);
