/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/theming/Parameters','sap/m/semantic/SemanticPage','sap/ui/core/InvisibleText'],function(q,l,C,I,P,S,a){"use strict";var b=C.extend("sap.m.SplitContainer",{metadata:{library:"sap.m",properties:{defaultTransitionNameDetail:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameMaster:{type:"string",group:"Appearance",defaultValue:"slide"},mode:{type:"sap.m.SplitAppMode",group:"Appearance",defaultValue:sap.m.SplitAppMode.ShowHideMode},masterButtonText:{type:"string",group:"Appearance",defaultValue:null},backgroundColor:{type:"string",group:"Appearance",defaultValue:null},backgroundImage:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},backgroundRepeat:{type:"boolean",group:"Appearance",defaultValue:false},backgroundOpacity:{type:"float",group:"Appearance",defaultValue:1}},aggregations:{masterPages:{type:"sap.ui.core.Control",multiple:true,singularName:"masterPage"},detailPages:{type:"sap.ui.core.Control",multiple:true,singularName:"detailPage"},_navMaster:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_navDetail:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_navPopover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},associations:{initialDetail:{type:"sap.ui.core.Control",multiple:false},initialMaster:{type:"sap.ui.core.Control",multiple:false}},events:{masterNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterMasterNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},masterButton:{},beforeMasterOpen:{},afterMasterOpen:{},beforeMasterClose:{},afterMasterClose:{},detailNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterDetailNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}},designTime:true}});b.prototype.init=function(){var t=this;this._isMie9=false;if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<10){this._isMie9=true;}if(sap.ui.getCore().getConfiguration().getAccessibility()&&!b._sAriaPopupLabelId){b._sAriaPopupLabelId=new a({text:''}).toStatic().getId();}this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._aMasterPages=[];this._aDetailPages=[];if(!sap.ui.Device.system.phone){this._oMasterNav=new sap.m.NavContainer(this.getId()+"-Master",{width:"",navigate:function(e){t._handleNavigationEvent(e,false,true);},afterNavigate:function(e){t._handleNavigationEvent(e,true,true);}});this._oDetailNav=new sap.m.NavContainer(this.getId()+"-Detail",{width:"",navigate:function(e){t._handleNavigationEvent(e,false,false);},afterNavigate:function(e){t._handleNavigationEvent(e,true,false);}});this.setAggregation("_navMaster",this._oMasterNav,true);this.setAggregation("_navDetail",this._oDetailNav,true);this._createShowMasterButton();this._oPopOver=new sap.m.Popover(this.getId()+"-Popover",{placement:sap.m.PlacementType.Bottom,showHeader:false,contentWidth:"320px",contentHeight:"600px",beforeOpen:function(){t.fireBeforeMasterOpen();},beforeClose:function(){t.fireBeforeMasterClose();},afterOpen:function(){t.fireAfterMasterOpen();t._bMasterisOpen=true;},afterClose:function(){t._afterHideMasterAnimation();}}).addStyleClass("sapMSplitContainerPopover");if(b._sAriaPopupLabelId){this._oPopOver.addAriaLabelledBy(b._sAriaPopupLabelId);}this.setAggregation("_navPopover",this._oPopOver,true);}else{this._oMasterNav=this._oDetailNav=new sap.m.NavContainer({width:"",navigate:function(e){t._handleNavigationEvent(e,false,true);},afterNavigate:function(e){t._handleNavigationEvent(e,true,true);}});this.setAggregation("_navMaster",this._oMasterNav,true);}this._oldIsLandscape=sap.ui.Device.orientation.landscape;this._bMasterisOpen=false;var t=this;var p=function(r,n,s){return function(c,A,e){r.apply(t[n],arguments);if(A==="pages"&&q.inArray(c,t[s])!==-1){t._removePageFromArray(t[s],c);}};};var m=this._oMasterNav._removeChild;this._oMasterNav._removeChild=p(m,"_oMasterNav","_aMasterPages");if(this._oDetailNav){var d=this._oDetailNav._removeChild;this._oDetailNav._removeChild=p(d,"_oDetailNav","_aDetailPages");}};b.prototype.onBeforeRendering=function(){if(this._fnResize){sap.ui.Device.resize.detachHandler(this._fnResize);}if(this._bMasterisOpen&&(this._portraitHide()||this._hideMode())){this._oShowMasterBtn.removeStyleClass("sapMSplitContainerMasterBtnHidden");this._bMasterisOpen=false;}};b.prototype.exit=function(){if(this._fnResize){sap.ui.Device.resize.detachHandler(this._fnResize);}delete this._aMasterPages;delete this._aDetailPages;if(this._oShowMasterBtn){this._oShowMasterBtn.destroy();this._oShowMasterBtn=null;}};b.prototype.onAfterRendering=function(){if(!sap.ui.Device.system.phone&&this._oPopOver&&this._oPopOver.isOpen()){this._oPopOver.close();}if(!this._fnResize){this._fnResize=q.proxy(this._handleResize,this);}sap.ui.Device.resize.attachHandler(this._fnResize);if(sap.ui.Device.os.windows&&sap.ui.Device.browser.internet_explorer){this._oMasterNav.$().append('<iframe class="sapMSplitContainerMasterBlindLayer" src="about:blank"></iframe>');}q.sap.delayedCall(0,this,function(){this._oMasterNav.removeStyleClass("sapMSplitContainerNoTransition");});};b.prototype.ontouchstart=function(e){if(!sap.ui.Device.system.phone){this._bIgnoreSwipe=(e.originalEvent&&e.originalEvent._sapui_handledByControl);}};b.prototype.onswiperight=function(e){if(sap.ui.Device.support.touch===false){return;}if((sap.ui.Device.system.tablet||(sap.ui.Device.os.windows&&sap.ui.Device.os.version>=8))&&(this._portraitHide()||this._hideMode())&&!this._bIgnoreSwipe&&!this._bDetailNavButton){this.showMaster();}};b.prototype.ontap=function(e){if(sap.ui.Device.system.phone){return;}var i=true,m=e.srcControl.getMetadata();if(q(e.target).closest(".sapMSplitContainerDetail").length>0){i=false;}if(((!this._oldIsLandscape&&this.getMode()=="ShowHideMode")||this.getMode()=="HideMode")&&!i&&!q.sap.containsOrEquals(this._oShowMasterBtn.getDomRef(),e.target)&&(!m.getEvent("tap")||!m.getEvent("press"))){this.hideMaster();}};b.prototype.onswipeleft=function(e){if((sap.ui.Device.system.tablet||(sap.ui.Device.os.windows&&sap.ui.Device.os.version>=8))&&(this._portraitHide()||this._hideMode())&&!this._bIgnoreSwipe){this.hideMaster();}};b.prototype._onMasterButtonTap=function(e){if(sap.ui.Device.system.phone){return;}if(!this._oldIsLandscape){if(this.getMode()=="PopoverMode"){if(!this._oPopOver.isOpen()){this._oPopOver.openBy(this._oShowMasterBtn,true);}else{this._oPopOver.close();}}else{this.showMaster();}}else{if(this.getMode()==="HideMode"){this.showMaster();}}};b.prototype.to=function(p,t,d,T){if(this._oMasterNav.getPage(p)){this._oMasterNav.to(p,t,d,T);}else{this._oDetailNav.to(p,t,d,T);}};b.prototype.backToPage=function(p,c,t){if(this._oMasterNav.getPage(p)){this._oMasterNav.backToPage(p,c,t);}else{this._oDetailNav.backToPage(p,c,t);}};b.prototype.insertPreviousPage=function(p,t,d){if(this._oMasterNav.getPage(p)){this._oMasterNav.insertPreviousPage(p,t,d);}else{this._oDetailNav.insertPreviousPage(p,t,d);}return this;};b.prototype.toMaster=function(p,t,d,T){this._oMasterNav.to(p,t,d,T);};b.prototype.backMaster=function(c,t){this._oMasterNav.back(c,t);};b.prototype.backMasterToPage=function(p,c,t){this._oMasterNav.backToPage(p,c,t);};b.prototype.toDetail=function(p,t,d,T){this._oDetailNav.to(p,t,d,T);};b.prototype.backDetail=function(c,t){this._oDetailNav.back(c,t);};b.prototype.backDetailToPage=function(p,c,t){this._oDetailNav.backToPage(p,c,t);};b.prototype.backToTopMaster=function(c,t){this._oMasterNav.backToTop(c,t);};b.prototype.backToTopDetail=function(c,t){this._oDetailNav.backToTop(c,t);};b.prototype.addMasterPage=function(p){if(this._hasPageInArray(this._aMasterPages,p)){return;}if(this._oMasterNav===this._oDetailNav&&q.inArray(p,this._oDetailNav.getPages())!==-1){this._removePageFromArray(this._aDetailPages,p);}this._oMasterNav.addPage(p);this._aMasterPages.push(p);return this;};b.prototype.addDetailPage=function(p){var t=this,r=this._getRealPage(p);if(this._hasPageInArray(this._aDetailPages,p)){return;}p.addDelegate({onBeforeShow:function(){if(r){if(!sap.ui.Device.system.phone){if(t._needShowMasterButton()){t._setMasterButton(r);}}}}});if(r){r.addDelegate({onBeforeRendering:function(){if(!sap.ui.Device.system.phone&&(t._oDetailNav.getCurrentPage()===r)){if(!r.getShowNavButton()&&t._needShowMasterButton()){t._setMasterButton(r,true);}else{t._removeMasterButton(r);}}}});if(!sap.ui.Device.system.phone){if(!r._setCustomHeaderInSC){r._setCustomHeaderInSC=r.setCustomHeader;}r.setCustomHeader=function(h){this._setCustomHeaderInSC.apply(this,arguments);if(h&&t._needShowMasterButton()){t._setMasterButton(r);}return this;};if(!r._setShowNavButtonInSC){r._setShowNavButtonInSC=r.setShowNavButton;}r.setShowNavButton=function(s){this._setShowNavButtonInSC.apply(this,arguments);if(!s&&t._needShowMasterButton()){t._setMasterButton(r);}else{t._removeMasterButton(r,true);}return this;};}}if(this._oMasterNav===this._oDetailNav&&q.inArray(p,this._oMasterNav.getPages())!==-1){this._removePageFromArray(this._aMasterPages,p);}this._oDetailNav.addPage(p);this._aDetailPages.push(p);return this;};b.prototype.getMasterPages=function(){return this._aMasterPages;};b.prototype.getDetailPages=function(){return this._aDetailPages;};b.prototype.indexOfMasterPage=function(p){return this._indexOfMasterPage(p);};b.prototype.indexOfDetailPage=function(p){return this._indexOfDetailPage(p);};b.prototype.insertMasterPage=function(p,i,s){return this._insertPage(this._aMasterPages,"masterPages",p,i,s);};b.prototype.removeMasterPage=function(p,s){return this._removePage(this._aMasterPages,"masterPages",p,s);};b.prototype.removeAllMasterPages=function(s){this._aMasterPages=[];return this.removeAllAggregation("masterPages",s);};b.prototype.insertDetailPage=function(p,i,s){return this._insertPage(this._aDetailPages,"detailPages",p,i,s);};b.prototype._restoreMethodsInPage=function(p){if(sap.ui.Device.system.phone){return;}var r=this._getRealPage(p);if(r){if(r._setCustomHeaderInSC){r.setCustomHeader=r._setCustomHeaderInSC;delete r._setCustomHeaderInSC;}if(r._setShowNavButtonInSC){r.setShowNavButton=r._setShowNavButtonInSC;delete r._setShowNavButtonInSC;}}};b.prototype.removeDetailPage=function(p,s){this._restoreMethodsInPage(p);return this._removePage(this._aDetailPages,"detailPages",p,s);};b.prototype.removeAllDetailPages=function(s){var p=this.getDetailPages();for(var i=0;i<p.length;i++){this._restoreMethodsInPage(p[i]);}this._aDetailPages=[];return this.removeAllAggregation("detailPages",s);};b.prototype.addPage=function(p,m){if(m){return this.addMasterPage(p);}else{return this.addDetailPage(p);}};b.prototype.showMaster=function(){var _=this._oMasterNav.$(),t=this,A=q.proxy(this._afterShowMasterAnimation,this),c=this._getRealPage(this._oDetailNav.getCurrentPage());function d(){this._oPopOver.detachAfterOpen(d,this);this._bMasterOpening=false;this._bMasterisOpen=true;this.fireAfterMasterOpen();}if(this._portraitPopover()){if(!this._oPopOver.isOpen()){this._oPopOver.attachAfterOpen(d,this);this.fireBeforeMasterOpen();this._oPopOver.openBy(this._oShowMasterBtn,true);this._bMasterOpening=true;}}else{if((this._portraitHide()||this._hideMode())&&(!this._bMasterisOpen||this._bMasterClosing)){if(this._isMie9){this._oMasterNav.$().css("width","320px");_.animate({left:"+=320"},{duration:300,complete:A});this._bMasterisOpen=true;t._bMasterOpening=false;this._removeMasterButton(c);}else{_.bind("webkitTransitionEnd transitionend",A);}this.fireBeforeMasterOpen();this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterVisible",true);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterHidden",false);this._bMasterOpening=true;t._removeMasterButton(c);if(sap.ui.Device.browser.webkit){var m=this._oMasterNav;window.setTimeout(function(){m.$().css("box-shadow","none");window.setTimeout(function(){m.$().css("box-shadow","");},50);},0);}}}return this;};b.prototype.hideMaster=function(){var _=this._oMasterNav.$(),A=q.proxy(this._afterHideMasterAnimation,this);if(this._portraitPopover()){if(this._oPopOver.isOpen()){this._oPopOver.close();this._bMasterClosing=true;}}else{if((this._portraitHide()||this._hideMode())&&(this._bMasterisOpen||this._oMasterNav.$().hasClass("sapMSplitContainerMasterVisible"))){if(this._isMie9){_.animate({left:"-=320"},{duration:300,complete:A});}else{_.bind("webkitTransitionEnd transitionend",A);}this.fireBeforeMasterClose();this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterVisible",false);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterHidden",true);this._bMasterClosing=true;}}return this;};b.prototype._afterShowMasterAnimation=function(){if(this._portraitHide()||this._hideMode()){if(!this._isMie9){var m=this._oMasterNav.$();m.unbind("webkitTransitionEnd transitionend",this._afterShowMasterAnimation);}this._bMasterOpening=false;this._bMasterisOpen=true;this.fireAfterMasterOpen();}};b.prototype._afterHideMasterAnimation=function(){if(this._portraitHide()||this._hideMode()){if(!this._isMie9){var m=this._oMasterNav.$();m.unbind("webkitTransitionEnd transitionend",this._afterHideMasterAnimation);}}var c=this._getRealPage(this._oDetailNav.getCurrentPage());this._setMasterButton(c);this._bMasterClosing=false;this._bMasterisOpen=false;if(q.sap.containsOrEquals(this._oMasterNav.getDomRef(),document.activeElement)){document.activeElement.blur();}this.fireAfterMasterClose();};b.prototype.getCurrentMasterPage=function(){return this._oMasterNav.getCurrentPage();};b.prototype.getCurrentDetailPage=function(){return this._oDetailNav.getCurrentPage();};b.prototype.getCurrentPage=function(m){if(m){return this.getCurrentMasterPage();}else{return this.getCurrentDetailPage();}};b.prototype.getPreviousPage=function(m){if(m){return this._oMasterNav.getPreviousPage();}else{return this._oDetailNav.getPreviousPage();}};b.prototype.getMasterPage=function(p){return this._oMasterNav.getPage(p);};b.prototype.getDetailPage=function(p){return this._oDetailNav.getPage(p);};b.prototype.getPage=function(p,m){if(m){return this.getMasterPage(p);}else{return this.getDetailPage(p);}};b.prototype.isMasterShown=function(){if(sap.ui.Device.system.phone){var c=this._oMasterNav.getCurrentPage();return this._indexOfMasterPage(c)!==-1;}else{var m=this.getMode();switch(m){case sap.m.SplitAppMode.StretchCompressMode:return true;case sap.m.SplitAppMode.HideMode:return this._bMasterisOpen;case sap.m.SplitAppMode.PopoverMode:case sap.m.SplitAppMode.ShowHideMode:return sap.ui.Device.orientation.landscape||this._bMasterisOpen;default:return false;}}};b.prototype.setInitialMaster=function(p){this._oMasterNav.setInitialPage(p);this.setAssociation('initialMaster',p,true);return this;};b.prototype.setInitialDetail=function(p){if(!sap.ui.Device.system.phone){this._oDetailNav.setInitialPage(p);}this.setAssociation('initialDetail',p,true);return this;};b.prototype.setDefaultTransitionNameDetail=function(t){this.setProperty("defaultTransitionNameDetail",t,true);this._oDetailNav.setDefaultTransitionName(t);return this;};b.prototype.setDefaultTransitionNameMaster=function(t){this.setProperty("defaultTransitionNameMaster",t,true);this._oMasterNav.setDefaultTransitionName(t);return this;};b.prototype.setMasterButtonText=function(t){if(!sap.ui.Device.system.phone){if(!t){t=this._rb.getText("SplitContainer_NAVBUTTON_TEXT");}this._oShowMasterBtn.setText(t);}this.setProperty("masterButtonText",t,true);return this;};b.prototype.setMode=function(m){var o=this.getMode();if(o===m){return this;}this.setProperty("mode",m,true);if(!sap.ui.Device.system.phone&&this.getDomRef()){if(o==="HideMode"&&this._oldIsLandscape){this._removeMasterButton(this._oDetailNav.getCurrentPage());if(this._isMie9){this._oMasterNav.$().css({left:0,width:""});}}if(m!=="PopoverMode"&&this._oPopOver.getContent().length>0){this._updateMasterPosition("landscape");}else if(m=="PopoverMode"){if(!this._oldIsLandscape){if(this._oPopOver.getContent().length===0){this._updateMasterPosition("popover");}this._setMasterButton(this._oDetailNav.getCurrentPage());}this.toggleStyleClass("sapMSplitContainerShowHide",false);this.toggleStyleClass("sapMSplitContainerStretchCompress",false);this.toggleStyleClass("sapMSplitContainerHideMode",false);this.toggleStyleClass("sapMSplitContainerPopover",true);}if(m=="StretchCompressMode"){this.toggleStyleClass("sapMSplitContainerShowHide",false);this.toggleStyleClass("sapMSplitContainerPopover",false);this.toggleStyleClass("sapMSplitContainerHideMode",false);this.toggleStyleClass("sapMSplitContainerStretchCompress",true);this._removeMasterButton(this._oDetailNav.getCurrentPage());}if(m=="ShowHideMode"){this.toggleStyleClass("sapMSplitContainerPopover",false);this.toggleStyleClass("sapMSplitContainerStretchCompress",false);this.toggleStyleClass("sapMSplitContainerHideMode",false);this.toggleStyleClass("sapMSplitContainerShowHide",true);if(!sap.ui.Device.orientation.landscape){this._setMasterButton(this._oDetailNav.getCurrentPage());}}if(m==="HideMode"){this.toggleStyleClass("sapMSplitContainerPopover",false);this.toggleStyleClass("sapMSplitContainerStretchCompress",false);this.toggleStyleClass("sapMSplitContainerShowHide",false);this.toggleStyleClass("sapMSplitContainerHideMode",true);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterVisible",false);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterHidden",true);this._bMasterisOpen=false;this._setMasterButton(this._oDetailNav.getCurrentPage());if(this._isMie9){this._oMasterNav.$().css({left:"",width:"auto"});}}}return this;};b.prototype.setBackgroundOpacity=function(o){if(o>1||o<0){q.sap.log.warning("Invalid value "+o+" for SplitContainer.setBackgroundOpacity() ignored. Valid values are: floats between 0 and 1.");return this;}this.$("BG").css("opacity",o);return this.setProperty("backgroundOpacity",o,true);};b.prototype._indexOfMasterPage=function(p){return q.inArray(p,this._aMasterPages);};b.prototype._indexOfDetailPage=function(p){return q.inArray(p,this._aDetailPages);};b.prototype._insertPage=function(p,A,o,c,s){this.insertAggregation(A,o,c,s);var i;if(c<0){i=0;}else if(c>p.length){i=p.length;}else{i=c;}var O=q.inArray(o,p);p.splice(i,0,o);if(O!=-1){this._removePageFromArray(p,o);}return this;};b.prototype._removePage=function(p,A,o,s){var r=this.removeAggregation(A,o,s);if(r){this._removePageFromArray(p,r);}return r;};b.prototype._removePageFromArray=function(p,o){var i=q.inArray(o,p);if(i!=-1){p.splice(i,1);if(p===this._aDetailPages){this._restoreMethodsInPage(o);}}};b.prototype._handleNavigationEvent=function(e,A,m){var E=(A?"After":"")+(m?"Master":"Detail")+"Navigate",c;E=E.charAt(0).toLowerCase()+E.slice(1);c=this.fireEvent(E,e.mParameters,true);if(!c){e.preventDefault();}};b.prototype._handleResize=function(){var i=sap.ui.Device.orientation.landscape,_=this._oDetailNav.getCurrentPage(),m=this.getMode();if(this._oldIsLandscape!==i){this._oldIsLandscape=i;if(!sap.ui.Device.system.phone){this.toggleStyleClass("sapMSplitContainerPortrait",!i);if(m==="HideMode"){return;}if(m==="ShowHideMode"){if(i){this.fireBeforeMasterOpen();}else{this.fireBeforeMasterClose();}}if(this._isMie9){if(i){this._oMasterNav.$().css({left:0,width:""});}else{if(m==="ShowHideMode"||m==="PopoverMode"){this._oMasterNav.$().css({left:-320,width:"auto"});}}}if(m==="ShowHideMode"||m==="PopoverMode"){this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterVisible",i);this._oMasterNav.toggleStyleClass("sapMSplitContainerMasterHidden",!i);}if(m==="ShowHideMode"){if(i){this._bMasterisOpen=true;this.fireAfterMasterOpen();}else{this._bMasterisOpen=false;this.fireAfterMasterClose();}}if(m=="PopoverMode"){if(this._oPopOver.isOpen()){this._oPopOver.attachAfterClose(this._handlePopClose,this);this._oPopOver.close();}else{this._handlePopClose();}}_=this._getRealPage(_);if(!this._oldIsLandscape&&m!="StretchCompressMode"){this._setMasterButton(_);}else{this._removeMasterButton(_);}}if(this._onOrientationChange){this._onOrientationChange();}}};b.prototype._handlePopClose=function(e){this._oPopOver.detachAfterClose(this._handlePopClose,this);if(this._oldIsLandscape){this._updateMasterPosition("landscape");}else{this._updateMasterPosition("popover");}};b.prototype._getRealPage=function(p){var r=p,c;while(r){if(r instanceof sap.m.Page){return r;}if(r instanceof sap.m.MessagePage){return r;}if(r instanceof S){return r;}if(r instanceof sap.ui.core.mvc.View){c=r.getContent();if(c.length===1){r=c[0];continue;}}else if(r instanceof sap.m.NavContainer){r=r.getCurrentPage();continue;}r=null;}return r;};b.prototype._updateMasterPosition=function(p){var t=this;if(p=="popover"){this.removeAggregation("_navMaster",this._oMasterNav,true);this._oMasterNav.$().remove();this._oPopOver.addContent(this._oMasterNav);this._bMasterisOpen=false;}if(p=="landscape"){var r=function(){t._oPopOver.removeAggregation("content",t._oMasterNav,false);t.setAggregation("_navMaster",t._oMasterNav,true);var $=t.$();if($[0]){var c=sap.ui.getCore().createRenderManager();c.renderControl(t._oMasterNav.addStyleClass("sapMSplitContainerMaster"));c.flush($[0],false,(t.$("BG")[0])?1:0);c.destroy();}};if(this._oPopOver.isOpen()){var A=function(){this._oPopOver.detachAfterClose(A,this);this._bMasterisOpen=false;r();};this._oPopOver.attachAfterClose(A,this);this._oPopOver.close();}else{r();}}};b.prototype._portraitHide=function(){if(!this._oldIsLandscape&&!sap.ui.Device.system.phone&&this.getMode()==="ShowHideMode"){return true;}else{return false;}};b.prototype._portraitPopover=function(){if(!this._oldIsLandscape&&!sap.ui.Device.system.phone&&this.getMode()==="PopoverMode"){return true;}else{return false;}};b.prototype._hideMode=function(){return this.getMode()==="HideMode"&&!sap.ui.Device.system.phone;};b.prototype._needShowMasterButton=function(){return(this._portraitHide()||this._hideMode()||this._portraitPopover())&&(!this._bMasterisOpen||this._bMasterClosing);};b.prototype._createShowMasterButton=function(){if(this._oShowMasterBtn&&!this._oShowMasterBtn.bIsDestroyed){return;}this._oShowMasterBtn=new sap.m.Button(this.getId()+"-MasterBtn",{icon:I.getIconURI("menu2"),tooltip:this._rb.getText('SPLITCONTAINER_NAVBUTTON_TOOLTIP'),type:sap.m.ButtonType.Default,press:q.proxy(this._onMasterButtonTap,this)}).addStyleClass("sapMSplitContainerMasterBtn");};b.prototype._setMasterButton=function(p,c,s){if(!p){return;}if(typeof c==='boolean'){s=c;c=undefined;}p=this._getRealPage(p);if(!p){return;}var h=b._getHeaderButtonAggregation(p),H=h.sAggregationName,d=h.aAggregationContent;for(var i=0;i<d.length;i++){if(d[i]instanceof sap.m.Button&&d[i].getVisible()&&(d[i].getType()==sap.m.ButtonType.Back||(d[i].getType()==sap.m.ButtonType.Up&&d[i]!==this._oShowMasterBtn))){this._bDetailNavButton=true;return;}}this._bDetailNavButton=false;var o=p._getAnyHeader();var e=false;for(var i=0;i<d.length;i++){if(d[i]===this._oShowMasterBtn){e=true;}}if(!e){this._createShowMasterButton();this._oShowMasterBtn.removeStyleClass("sapMSplitContainerMasterBtnHidden");if(o){o.insertAggregation(H,this._oShowMasterBtn,0,s);}}else{if(this._isMie9){this._oShowMasterBtn.$().fadeIn();}this._oShowMasterBtn.$().parent().toggleClass("sapMSplitContainerMasterBtnHide",false);this._oShowMasterBtn.removeStyleClass("sapMSplitContainerMasterBtnHidden");this._oShowMasterBtn.$().parent().toggleClass("sapMSplitContainerMasterBtnShow",true);}if(c){c(p);}this.fireMasterButton({show:true});};b._getHeaderButtonAggregation=function(p){var h=p._getAnyHeader(),A,s;if(!h){return;}if(h.getContentLeft){A=h.getContentLeft();s="contentLeft";}if(h.getContent){A=h.getContent();s="content";}return{aAggregationContent:A,sAggregationName:s};};b.prototype._removeMasterButton=function(p,c,n){if(!p){return;}var t=this,h=this._oShowMasterBtn.$().is(":hidden"),H;if(typeof c==="boolean"){n=c;c=undefined;}if(!h&&!n){p=this._getRealPage(p);if(!p){return;}H=p._getAnyHeader();if(H){var d=b._getHeaderButtonAggregation(p).aAggregationContent;for(var i=0;i<d.length;i++){if(d[i]===this._oShowMasterBtn){if(this._isMie9){this._oShowMasterBtn.$().fadeOut();if(c){c(p);}}this._oShowMasterBtn.destroy();this._oShowMasterBtn.$().parent().bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");t._oShowMasterBtn.addStyleClass("sapMSplitContainerMasterBtnHidden");if(c){c(p);}});return;}}}this.fireMasterButton({show:false});}else{this._oShowMasterBtn.addStyleClass("sapMSplitContainerMasterBtnHidden");if(c){c(p);}if(!h){this.fireMasterButton({show:false});}}};b.prototype._callMethodInManagedObject=function(f,A){var c=Array.prototype.slice.call(arguments);if(A==="masterPages"){if(f==="indexOfAggregation"){return this._indexOfMasterPage.apply(this,c.slice(2));}else{return this._callNavContainerMethod(f,this._oMasterNav,c);}}else if(A==="detailPages"){if(f==="indexOfAggregation"){return this._indexOfDetailPage.apply(this,c.slice(2));}else{return this._callNavContainerMethod(f,this._oDetailNav,c);}}else{return sap.ui.base.ManagedObject.prototype[f].apply(this,c.slice(1));}};b.prototype._callNavContainerMethod=function(f,n,A){A[1]="pages";A=A.slice(1);var r=b._mFunctionMapping[f];if(r){A.shift();f=r;}return n[f].apply(n,A);};b.prototype._hasPageInArray=function(c,p){return c.some(function(A){return p&&(p===A);});};b.prototype.validateAggregation=function(A,o,m){return this._callMethodInManagedObject("validateAggregation",A,o,m);};b.prototype.setAggregation=function(A,o,s){this._callMethodInManagedObject("setAggregation",A,o,s);return this;};b.prototype.getAggregation=function(A,d){return this._callMethodInManagedObject("getAggregation",A,d);};b.prototype.indexOfAggregation=function(A,o){return this._callMethodInManagedObject("indexOfAggregation",A,o);};b.prototype.insertAggregation=function(A,o,i,s){this._callMethodInManagedObject("insertAggregation",A,o,i,s);return this;};b.prototype.addAggregation=function(A,o,s){this._callMethodInManagedObject("addAggregation",A,o,s);return this;};b.prototype.removeAggregation=function(A,o,s){return this._callMethodInManagedObject("removeAggregation",A,o,s);};b.prototype.removeAllAggregation=function(A,s){return this._callMethodInManagedObject("removeAllAggregation",A,s);};b.prototype.destroyAggregation=function(A,s){this._callMethodInManagedObject("destroyAggregation",A,s);return this;};b._mFunctionMapping={"getAggregation":"getPage","addAggregation":"addPage","insertAggregation":"insertPage","removeAggregation":"removePage","removeAllAggregation":"removeAllPages"};return b;},true);
