/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/Global','sap/ui/base/BindingParser','sap/ui/base/DataType','sap/ui/base/EventProvider','sap/ui/base/Interface','sap/ui/base/Object','sap/ui/base/ManagedObject','./Component','./Configuration','./Control','./Element','./ElementMetadata','./FocusHandler','./RenderManager','./ResizeHandler','./ThemeCheck','./UIArea','./message/MessageManager','jquery.sap.act','jquery.sap.dom','jquery.sap.events','jquery.sap.mobile','jquery.sap.properties','jquery.sap.resources','jquery.sap.script'],function(q,D,G,B,a,E,I,c,M,C,d,f,g,h,F,R,k,T,U,r){"use strict";function s(o,m){var b=sap.ui.require(m);return typeof b==='function'&&(o instanceof b);}var t=U._oRenderLog;var L={};var u={};var _;var w=c.extend("sap.ui.core.Core",{constructor:function(){if(sap.ui.getCore&&sap.ui.getCore()){return sap.ui.getCore();}var b=this,l=q.sap.log,e="sap.ui.core.Core";c.call(this);_=new E();["attachEvent","detachEvent","getEventingParent"].forEach(function(v){w.prototype[v]=_[v].bind(_);});this.bBooted=false;this.bInitialized=false;this.bDomReady=false;this.aPlugins=[];this.mLibraries={};this.mResourceBundles={};this.mUIAreas={};this.oModels={};this.oEventBus=null;this.mElements={};this.mObjects={"component":{},"template":{}};this.oRootComponent=null;this.aInitListeners=[];this.bInitLegacyLib=false;this._sRerenderTimer=this;this.aPrerenderingTasks=[];l.info("Creating Core",null,e);q.sap.measure.start("coreComplete","Core.js - complete");q.sap.measure.start("coreBoot","Core.js - boot");q.sap.measure.start("coreInit","Core.js - init");this.oConfiguration=new d(this);var o=this.oConfiguration["frameOptionsConfig"]||{};o.mode=this.oConfiguration.getFrameOptions();o.whitelistService=this.oConfiguration.getWhitelistService();this.oFrameOptions=new q.sap.FrameOptions(o);if(this.oConfiguration["bindingSyntax"]==="complex"){M.bindingParser=B.complexParser;}if(this.oConfiguration["xx-designMode"]==true){B._keepBindingStrings=true;}this._grantFriendAccess();var m=this.oConfiguration.modules;if(this.oConfiguration.getDebug()){m.unshift("sap.ui.debug.DebugEnv");}var i=m.indexOf("sap.ui.core.library");if(i!=0){if(i>0){m.splice(i,1);}m.unshift("sap.ui.core.library");}if(this.oConfiguration["xx-lesssupport"]&&m.indexOf("sap.ui.core.plugin.LessSupport")==-1){l.info("Including LessSupport into declared modules");m.push("sap.ui.core.plugin.LessSupport");}var p=this.oConfiguration.preload;if(window["sap-ui-debug"]===true){p="";}if(p==="auto"){p=(window["sap-ui-optimized"]&&!this.oConfiguration['xx-loadAllMode'])?"sync":"";}this.oConfiguration.preload=p;var j=p==="async";this.oConfiguration['xx-libraryPreloadFiles'].forEach(function(v){var j1=String(v).trim().split(/\s*:\s*/),k1=j1[0],l1=j1[1];if(j1.length===1){l1=k1;k1='';}if(/^(?:none|js|json|both)$/.test(l1)){x[k1]=l1;}});l.info("Declared modules: "+m,e);this._setupThemes();this._setupContentDirection();var $=q("html");this._setupBrowser($);this._setupOS($);this._setupLang($);this._setupAnimation($);sap.ui.getCore=q.sap.getter(this.getInterface());this.oRenderManager=new R();var n=q.sap.syncPoint("UI5 Document Ready",function(v,j1){b.bDomReady=true;b.init();});var N=n.startTask("document.ready");var O=n.startTask("preload and boot");q(function(){l.trace("document is ready");n.finishTask(N);});var P=q.sap.syncPoint("UI5 Core Preloads and Bootstrap Script",function(v,j1){l.trace("Core loaded: open="+v+", failures="+j1);b._boot(j,function(){n.finishTask(O);q.sap.measure.end("coreBoot");});});var Q=P.startTask("create sp2 tasks task");if(this.oConfiguration["versionedLibCss"]){var V=P.startTask("load version info");var W=function(v){if(v){l.trace("Loaded \"sap-ui-version.json\".");}else{l.error("Could not load \"sap-ui-version.json\".");}P.finishTask(V);};var X=sap.ui.getVersionInfo({async:j,failOnError:false});if(X instanceof Promise){X.then(W,function(v){l.error("Unexpected error when loading \"sap-ui-version.json\": "+v);P.finishTask(V);});}else{W(X);}}var Y=this.oConfiguration["xx-bootTask"];if(Y){var Z=P.startTask("custom boot task");Y(function(v){P.finishTask(Z,typeof v==="undefined"||v===true);});}this._polyfillFlexbox();var a1=P.startTask("bootstrap script");this.boot=function(){if(this.bBooted){return;}this.bBooted=true;P.finishTask(a1);};if(p==="sync"||p==="async"){var b1=m.reduce(function(v,j1){var k1=j1.search(/\.library$/);if(k1>=0){v.push(j1.slice(0,k1));}return v;},[]);var c1=this.loadLibraries(b1,{async:j,preloadOnly:true});if(j){var d1=P.startTask("preload bootstrap libraries");c1.then(function(){P.finishTask(d1);},function(){P.finishTask(d1,false);});}}var e1=this.oConfiguration.getAppCacheBuster();if(e1&&e1.length>0){var f1=sap.ui.requireSync('sap/ui/core/AppCacheBuster');f1.boot(P);}if(this.oConfiguration.getSupportMode()!==null){var g1=P.startTask("support info script");var h1=function(v){v.initSupportRules(b.oConfiguration.getSupportMode());P.finishTask(g1);};var i1=function(v){v.initializeSupportMode(b.oConfiguration.getSupportMode(),j);if(j){sap.ui.require(["sap/ui/support/Bootstrap"],h1);}else{h1(sap.ui.requireSync("sap/ui/support/Bootstrap"));}};if(j){sap.ui.require(["sap/ui/core/support/Support"],i1);}else{i1(sap.ui.requireSync("sap/ui/core/support/Support"));}}P.finishTask(Q);},metadata:{publicMethods:["boot","isInitialized","isThemeApplied","attachInitEvent","attachInit","getRenderManager","createRenderManager","getConfiguration","setRoot","createUIArea","getUIArea","getUIDirty","getElementById","getCurrentFocusedControlId","getControl","getComponent","getTemplate","lock","unlock","isLocked","attachEvent","detachEvent","applyChanges","getEventBus","applyTheme","setThemeRoot","attachThemeChanged","detachThemeChanged","getStaticAreaRef","attachThemeScopingChanged","detachThemeScopingChanged","fireThemeScopingChanged","registerPlugin","unregisterPlugin","getLibraryResourceBundle","byId","getLoadedLibraries","loadLibrary","loadLibraries","initLibrary","includeLibraryTheme","setModel","getModel","hasModel","isMobile","attachControlEvent","detachControlEvent","attachIntervalTimer","detachIntervalTimer","attachParseError","detachParseError","fireParseError","attachValidationError","detachValidationError","fireValidationError","attachFormatError","detachFormatError","fireFormatError","attachValidationSuccess","detachValidationSuccess","fireValidationSuccess","attachLocalizationChanged","detachLocalizationChanged","attachLibraryChanged","detachLibraryChanged","isStaticAreaRef","createComponent","getRootComponent","getApplication","setMessageManager","getMessageManager","byFieldGroupId","addPrerenderingTask"]}});w.M_EVENTS={ControlEvent:"ControlEvent",UIUpdated:"UIUpdated",ThemeChanged:"ThemeChanged",ThemeScopingChanged:"themeScopingChanged",LocalizationChanged:"localizationChanged",LibraryChanged:"libraryChanged",ValidationError:"validationError",ParseError:"parseError",FormatError:"formatError",ValidationSuccess:"validationSuccess"};var S="sap-ui-static";w.prototype._grantFriendAccess=function(){var b=this;h.prototype.register=function(m){b.registerElementClass(m);};g.prototype.register=function(){b.registerElement(this);};g.prototype.deregister=function(){b.deregisterElement(this);};g._updateFocusInfo=function(e){if(b.oFocusHandler){b.oFocusHandler.updateControlFocusInfo(e);}};C.prototype.register=function(){b.registerObject(this);};C.prototype.deregister=function(){var e=this.sId;for(var i in b.mElements){var o=b.mElements[i];if(o._sapui_candidateForDestroy&&o._sOwnerId===e&&!o.getParent()){q.sap.log.debug("destroying dangling template "+o+" when destroying the owner component");o.destroy();}}b.deregisterObject(this);};};w.prototype._setupThemes=function(){var l=q.sap.log,b="sap.ui.core.Core";var o=window["sap-ui-config"];if(this.oConfiguration.themeRoot){o=o||{};o.themeroots=o.themeroots||{};o.themeroots[this.oConfiguration.getTheme()]=this.oConfiguration.themeRoot;}if(o){if(o.themeroots){for(var e in o.themeroots){var i=o.themeroots[e];if(typeof i==="string"){this.setThemeRoot(e,i);}else{for(var j in i){if(j.length>0){this.setThemeRoot(e,[j],i[j]);}else{this.setThemeRoot(e,i[j]);}}}}}}this.sTheme=this.oConfiguration.getTheme();q(document.documentElement).addClass("sapUiTheme-"+this.sTheme);l.info("Declared theme "+this.sTheme,null,b);};w.prototype._setupContentDirection=function(){var l=q.sap.log,b="sap.ui.core.Core",e=this.oConfiguration.getRTL()?"rtl":"ltr";q(document.documentElement).attr("dir",e);l.info("Content direction set to '"+e+"'",null,b);};w.prototype._setupBrowser=function($){var l=q.sap.log,e="sap.ui.core.Core";$=$||q("html");var b=D.browser;var i=b.name;if(i===b.BROWSER.CHROME){q.browser.safari=false;q.browser.chrome=true;}else if(i===b.BROWSER.SAFARI){q.browser.safari=true;q.browser.chrome=false;if(b.mobile){i="m"+i;}}if(i){q.browser.fVersion=b.version;q.browser.mobile=b.mobile;i=i+(b.version===-1?"":Math.floor(b.version));$.attr("data-sap-ui-browser",i);l.debug("Browser-Id: "+i,null,e);}};w.prototype._setupOS=function($){$=$||q("html");$.attr("data-sap-ui-os",D.os.name+D.os.versionStr);var o=null;switch(D.os.name){case D.os.OS.IOS:o="sap-ios";break;case D.os.OS.ANDROID:o="sap-android";break;case D.os.OS.BLACKBERRY:o="sap-bb";break;case D.os.OS.WINDOWS_PHONE:o="sap-winphone";break;}if(o){$.addClass(o);}};w.prototype._setupLang=function($){$=$||q("html");var b=function(){var l=this.oConfiguration.getLocale();if(l){$.attr("lang",l.toString());}else{$.removeAttr("lang");}};b.call(this);this.attachLocalizationChanged(b,this);};w.prototype._setupAnimation=function($){$=$||q("html");var b=this.oConfiguration.getAnimation();$.attr("data-sap-ui-animation",b?"on":"off");q.fx.off=!b;};w.prototype._polyfillFlexbox=function(){var b=new q.sap.Version(this.oConfiguration.getCompatibilityVersion("flexBoxPolyfill"));if(b.compareTo("1.16")>=0){q.support.useFlexBoxPolyfill=false;}else if(!q.support.flexBoxLayout&&!q.support.newFlexBoxLayout&&!q.support.ie10FlexBoxLayout){q.support.useFlexBoxPolyfill=true;}else{q.support.useFlexBoxPolyfill=false;}};w.prototype._boot=function(b,e){var i=this.oConfiguration['preloadLibCss'];if(i&&i.length>0&&!i.appManaged){this.includeLibraryTheme("sap-ui-merged",undefined,"?l="+i.join(","));}if(b){return this._requireModulesAsync().then(function(){e();});}var j=this;this.oConfiguration.modules.forEach(function(l){var m=l.match(/^(.*)\.library$/);if(m){j.loadLibrary(m[1]);}else{q.sap.require(l);}});e();};w.prototype._requireModulesAsync=function(){var l=[],b=[];this.oConfiguration.modules.forEach(function(e){var m=e.match(/^(.*)\.library$/);if(m){l.push(m[1]);}else{b.push(q.sap.getResourceName(e));}});return Promise.all([this.loadLibraries(l),new Promise(function(e){sap.ui.require(b,function(){e(Array.prototype.slice.call(arguments));});})]);};w.prototype.applyTheme=function(b,e){b=this.oConfiguration._normalizeTheme(b,e);if(e){this.setThemeRoot(b,e);}if(b&&this.sTheme!=b){var i=this.sTheme;this._updateThemeUrls(b);this.sTheme=b;this.oConfiguration._setTheme(b);q(document.documentElement).removeClass("sapUiTheme-"+i).addClass("sapUiTheme-"+b);if(this.oThemeCheck){this.oThemeCheck.fireThemeChangedEvent(false);}}};w.prototype._updateThemeUrls=function(b){var e=this,i=this.oConfiguration.getRTL()?"-RTL":"";q("link[id^=sap-ui-theme-]").each(function(){var l=this.id.slice(13),j=this.href.slice(this.href.lastIndexOf("/")+1),m="library",n,p;if((p=l.indexOf("-["))>0){m+=l.slice(p+2,-1);l=l.slice(0,p);}if(j===(m+".css")||j===(m+"-RTL.css")){j=m+i+".css";}n=e._getThemePath(l,b)+j;if(n!=this.href){q.sap.includeStyleSheet(n,this.id);}});};w.prototype._ensureThemeRoot=function(l,b){if(this._mThemeRoots){var p=this._mThemeRoots[b+" "+l]||this._mThemeRoots[b];if(p){p=p+l.replace(/\./g,"/")+"/themes/"+b+"/";q.sap.registerModulePath(l+".themes."+b,p);}}};w.prototype._getThemePath=function(l,b){this._ensureThemeRoot(l,b);return q.sap.getModulePath(l+".themes."+b,"/");};w.prototype.setThemeRoot=function(b,l,e){if(!this._mThemeRoots){this._mThemeRoots={};}if(e===undefined){e=l;l=undefined;}e=e+(e.slice(-1)=="/"?"":"/");if(l){for(var i=0;i<l.length;i++){var j=l[i];this._mThemeRoots[b+" "+j]=e;}}else{this._mThemeRoots[b]=e;}return this;};w.prototype.init=function(){if(this.bInitialized){return;}var l=q.sap.log,b="sap.ui.core.Core.init()";this.boot();l.info("Initializing",null,b);this.oFocusHandler=new F(document.body,this);this.oRenderManager._setFocusHandler(this.oFocusHandler);this.oResizeHandler=new k(this);this.oThemeCheck=new T(this);l.info("Initialized",null,b);q.sap.measure.end("coreInit");this.bInitialized=true;l.info("Starting Plugins",null,b);this.startPlugins();l.info("Plugins started",null,b);this._createUIAreas();this.oThemeCheck.fireThemeChangedEvent(true);this._executeOnInit();this._setupRootComponent();this._setBodyAccessibilityRole();this._executeInitListeners();if(this.isThemeApplied()||!this.oConfiguration['xx-waitForTheme']){this.renderPendingUIUpdates("during Core init");}else{t.debug("delay initial rendering until theme has been loaded");_.attachEventOnce(w.M_EVENTS.ThemeChanged,function(){setTimeout(this.renderPendingUIUpdates.bind(this,"after theme has been loaded"),D.browser.safari?50:0);},this);}q.sap.measure.end("coreComplete");};w.prototype._createUIAreas=function(){var o=this.oConfiguration;if(o.areas){for(var i=0,l=o.areas.length;i<l;i++){this.createUIArea(o.areas[i]);}o.areas=undefined;}};w.prototype._executeOnInit=function(){var o=this.oConfiguration;if(o.onInit){if(typeof o.onInit==="function"){o.onInit();}else{q.sap.globalEval(o.onInit);}o.onInit=undefined;}};w.prototype._setupRootComponent=function(){var l=q.sap.log,b="sap.ui.core.Core.init()",o=this.oConfiguration;var e=o.getRootComponent();if(e){l.info("Loading Root Component: "+e,null,b);var i=sap.ui.component({name:e});this.oRootComponent=i;var j=o["xx-rootComponentNode"];if(j&&s(i,'sap/ui/core/UIComponent')){var m=q.sap.domById(j);if(m){l.info("Creating ComponentContainer for Root Component: "+e,null,b);var n=sap.ui.requireSync('sap/ui/core/ComponentContainer'),p=new n({component:i,propagateModel:true});p.placeAt(m);}}}else{var v=o.getApplication();if(v){l.warning("The configuration 'application' is deprecated. Please use the configuration 'component' instead! Please migrate from sap.ui.app.Application to sap.ui.core.Component.");l.info("Loading Application: "+v,null,b);q.sap.require(v);var N=q.sap.getObject(v);var O=new N();}}};w.prototype._setBodyAccessibilityRole=function(){var o=this.oConfiguration;var $=q("body");if(o.getAccessibility()&&o.getAutoAriaBodyRole()&&!$.attr("role")){$.attr("role","application");}};w.prototype._executeInitListeners=function(){var l=q.sap.log,b="sap.ui.core.Core.init()";var e=this.aInitListeners;this.aInitListeners=undefined;if(e&&e.length>0){l.info("Fire Loaded Event",null,b);e.forEach(function(i){i();});}};w.prototype.isInitialized=function(){return this.bInitialized;};w.prototype.isThemeApplied=function(){return T.themeLoaded;};w.prototype.attachInitEvent=function(b){if(this.aInitListeners){this.aInitListeners.push(b);}};w.prototype.attachInit=function(b){if(this.aInitListeners){this.aInitListeners.push(b);}else{b();}};w.prototype.lock=function(){this.bLocked=true;};w.prototype.unlock=function(){this.bLocked=false;};w.prototype.isLocked=function(){return this.bLocked;};w.prototype.getConfiguration=function(){return this.oConfiguration;};w.prototype.getRenderManager=function(){return this.createRenderManager();};w.prototype.createRenderManager=function(){var o=new R();o._setFocusHandler(this.oFocusHandler);return o.getInterface();};w.prototype.getCurrentFocusedControlId=function(){if(!this.isInitialized()){throw new Error("Core must be initialized");}return this.oFocusHandler.getCurrentFocusedControlId();};var x={};function y(l){var b='both';if(typeof l==='object'){if(l.json===true){b='json';}else if(l.json===false){b='js';}l=l.name;}var e=x[l]||x['']||'both';if(e==='both'){e=b;}else if(e!==b&&b!=='both'){e='none';}return{name:l,fileType:e};}function z(l){l=y(l);var b=l.name,i=l.fileType,j=b.replace(/\./g,'/');if(i==='none'||q.sap.isResourceLoaded(j+'/library.js')){return Promise.resolve(true);}var m=u[b]||(u[b]={});if(m.promise){return m.promise;}m.pending=true;m.async=true;var p;if(i!=='json'){var P=j+'/library-preload.js';p=q.sap._loadJSResourceAsync(P).then(function(){return A(b);},function(e){if(i!=='js'){q.sap.log.error("failed to load '"+P+"' ("+(e&&e.message||e)+"), falling back to library-preload.json");return H(b);}});}else{p=H(b);}m.promise=p.then(function(e){if(e&&e.length){return Promise.all(e.map(z)).then(function(){m.pending=false;});}m.pending=false;});return m.promise;}function A(l){var m=l.replace(/\./g,'/')+'/manifest.json';if(q.sap.isResourceLoaded(m)){var b=q.sap.loadResource(m,{dataType:'json',async:false,failOnError:false});var e=b&&b["sap.ui5"]&&b["sap.ui5"].dependencies&&b["sap.ui5"].dependencies.libs;if(e){return Object.keys(e).reduce(function(i,j){if(!e[j].lazy){i.push(j);}return i;},[]);}}}function H(l){var b=q.sap.getModulePath(l+".library-preload",".json");return Promise.resolve(q.ajax({dataType:"json",url:b})).then(function(e){if(e){e.url=b;q.sap.registerPreloadedModules(e);var i=e.dependencies;if(Array.isArray(i)){i=i.map(function(j){return j.replace(/\.library-preload$/,'');});}return i;}},function(e,i,j){q.sap.log.error("failed to load '"+b+"': "+(j||i));});}function J(l){l=y(l);var b=l.name,i=l.fileType,j=b.replace(/\./g,'/');if(i==='none'||q.sap.isResourceLoaded(j+'/library.js')){return;}var m=u[b]||(u[b]={});if(m.pending===false){return;}if(m.pending){if(m.async){q.sap.log.warning("request to load "+b+" synchronously while async loading is pending; this causes a duplicate request and should be avoided by caller");}else{q.sap.log.warning("request to load "+b+" synchronously while sync loading is pending (cycle, ignored)");return;}}m.pending=true;m.async=false;var n;m.promise=new Promise(function(v,N){n=v;});var o;if(i!=='json'){var p=j+'/library-preload';try{sap.ui.requireSync(p);o=A(b);}catch(e){q.sap.log.error("failed to load '"+p+"' ("+(e&&e.message||e)+")");if(e&&e.loadError&&i!=='js'){o=K(b);}}}else{o=K(b);}if(o&&o.length){o.forEach(J);}m.pending=false;n();}function K(l){var b=q.sap.getModulePath(l+".library-preload",".json");var e;q.ajax({dataType:"json",async:false,url:b,success:function(i){if(i){i.url=b;q.sap.registerPreloadedModules(i);e=i.dependencies;}},error:function(i,j,m){q.sap.log.error("failed to load '"+b+"': "+(m||j));}});if(Array.isArray(e)){e=e.map(function(i){return i.replace(/\.library-preload$/,'');});}return e;}w.prototype.loadLibrary=function(l,v){if(typeof v==='boolean'){v={async:v};}if(typeof v==='object'){if(v.async){if(v.url&&u[l]==null){q.sap.registerModulePath(l,v.url);}return this.loadLibraries([l]);}v=v.url;}if(!L[l]){var m=l+".library",b;if(v){q.sap.registerModulePath(l,v);}if(this.oConfiguration['xx-loadAllMode']&&!q.sap.isDeclared(m)){b=m+"-all";q.sap.log.debug("load all-in-one file "+b);q.sap.require(b);}else if(this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async'){J(l);}q.sap.require(m);if(!L[l]){q.sap.log.warning("library "+l+" didn't initialize itself");this.initLibrary(l);}if(this.oThemeCheck&&this.isInitialized()){this.oThemeCheck.fireThemeChangedEvent(true);}}return this.mLibraries[l];};w.prototype.loadLibraries=function(l,o){o=q.extend({async:true,preloadOnly:false},o);var b=this,p=this.oConfiguration.preload==='sync'||this.oConfiguration.preload==='async',e=o.async,i=!o.preloadOnly;function j(){return l.map(function(O){if(typeof O==='object'){O=O.name;}return O.replace(/\./g,"/")+"/library";});}function m(){if(b.oThemeCheck&&b.isInitialized()){b.oThemeCheck.fireThemeChangedEvent(true);}}function n(){return new Promise(function(O,P){sap.ui.require(j(),function(){m();O();});});}function v(){j().forEach(sap.ui.requireSync);m();}if(e){var N=p?Promise.all(l.map(z)):Promise.resolve(true);return i?N.then(n):N;}else{if(p){l.forEach(J);}if(i){v();}}};w.prototype.createComponent=function(v,b,i,m){if(typeof v==="string"){v={name:v,url:b};if(typeof i==="object"){v.settings=i;}else{v.id=i;v.settings=m;}}return sap.ui.component(v);};w.prototype.getRootComponent=function(){return this.oRootComponent;};w.prototype.initLibrary=function(l){var b=typeof l==='string';if(b){l={name:l};}var e=l.name,m=q.sap.log,n="sap.ui.core.Core.initLibrary()";if(b){m.warning("[Deprecated] library "+e+" uses old fashioned initLibrary() call (rebuild with newest generator)");}if(!e||L[e]){return;}m.debug("Analyzing Library "+e,null,n);L[e]=true;function o(j,O){var P,V;for(P in O){V=O[P];if(V!==undefined){if(Array.isArray(j[P])){if(j[P].length===0){j[P]=V;}else{j[P]=q.sap.unique(j[P].concat(V));}}else if(j[P]===undefined){j[P]=V;}else if(P!="name"){q.sap.log.warning("library info setting ignored: "+P+"="+V);}}}return j;}q.sap.getObject(e,0);this.mLibraries[e]=l=o(this.mLibraries[e]||{name:e,dependencies:[],types:[],interfaces:[],controls:[],elements:[]},l);function p(){var P=q.sap.properties({url:sap.ui.resource(e,"library.properties")});l.version=P.getProperty(e+"[version]");var O=P.getProperty(e+"[dependencies]");m.debug("Required Libraries: "+O,null,n);l.dependencies=(O&&O.split(/[,;| ]/))||[];var V=P.getKeys(),W=/(.+)\.(type|interface|control|element)$/,X;for(var j=0;j<V.length;j++){var Y=P.getProperty(V[j]);if((X=Y.match(W))!==null){l[X[2]+"s"].push(V[j]);}}}if(b){p();}for(var i=0;i<l.dependencies.length;i++){var v=l.dependencies[i];m.debug("resolve Dependencies to "+v,null,n);if(L[v]!==true){m.warning("Dependency from "+e+" to "+v+" has not been resolved by library itself",null,n);this.loadLibrary(v);}}a.registerInterfaceTypes(l.interfaces);for(var i=0;i<l.types.length;i++){if(!/^(any|boolean|float|int|string|object|void)$/.test(l.types[i])){q.sap.declare(l.types[i]);}}var N=l.controls.concat(l.elements);for(var i=0;i<N.length;i++){sap.ui.lazyRequire(N[i],"new extend getMetadata");}if(!l.noLibraryCSS){this._ensureThemeRoot(e,this.sTheme);this._ensureThemeRoot(e,"base");if(this.oConfiguration['preloadLibCss'].indexOf(e)<0){var Q=this._getLibraryCssQueryParams(l);this.includeLibraryTheme(e,undefined,Q);}}l.sName=l.name;l.aControls=l.controls;if(!q.sap.isDeclared(e+".library")){m.warning("Library Module "+e+".library"+" not loaded automatically",null,n);q.sap.require(e+".library");}this.fireLibraryChanged({name:e,stereotype:"library",operation:"add",metadata:l});};w.prototype.includeLibraryTheme=function(l,v,Q){if((l!="sap.ui.legacy")&&(l!="sap.ui.classic")){if(!v){v="";}var b=(this.oConfiguration.getRTL()?"-RTL":"");var e,i=l+(v.length>0?"-["+v+"]":v);if(l&&l.indexOf(":")==-1){e="library"+v+b;}else{e=l.substring(l.indexOf(":")+1)+v;l=l.substring(0,l.indexOf(":"));}var j=this._getThemePath(l,this.sTheme)+e+".css"+(Q?Q:"");q.sap.log.info("Including "+j+" -  sap.ui.core.Core.includeLibraryTheme()");q.sap.includeStyleSheet(j,"sap-ui-theme-"+i);var P=sap.ui.require("sap/ui/core/theming/Parameters");if(P){P._addLibraryTheme(i,j);}}};w.prototype._getLibraryCssQueryParams=function(l){var Q;if(this.oConfiguration["versionedLibCss"]&&l){Q="?version="+l.version;if(G.versioninfo){Q+="&sap-ui-dist-version="+G.versioninfo.version;}}return Q;};w.prototype.getLoadedLibraries=function(){return q.extend({},this.mLibraries);};w.prototype.getLibraryResourceBundle=function(l,b){l=l||"sap.ui.core";b=b||this.getConfiguration().getLanguage();var e=l+"/"+b;if(!this.mResourceBundles[e]){var i=sap.ui.resource(l,'messagebundle.properties');this.mResourceBundles[e]=q.sap.resources({url:i,locale:b});}return this.mResourceBundles[e];};w.prototype.setRoot=function(o,b){if(b){b.placeAt(o,"only");}};w.prototype.createUIArea=function(o){var b=this;if(!o){throw new Error("oDomRef must not be null");}if(typeof(o)==="string"){var i=o;if(i==S){o=this.getStaticAreaRef();}else{o=q.sap.domById(o);if(!o){throw new Error("DOM element with ID '"+i+"' not found in page, but application tries to insert content.");}}}if(!o.id||o.id.length==0){o.id=q.sap.uid();}var e=o.id;if(!this.mUIAreas[e]){this.mUIAreas[e]=new U(this,o);if(!q.isEmptyObject(this.oModels)){var p={oModels:q.extend({},this.oModels),oBindingContexts:{},aPropagationListeners:[]};b.mUIAreas[e]._propagateProperties(true,b.mUIAreas[e],p,true);}}else{this.mUIAreas[e].setRootNode(o);}return this.mUIAreas[e];};w.prototype.getUIArea=function(o){var i="";if(typeof(o)=="string"){i=o;}else{i=o.id;}if(i){return this.mUIAreas[i];}return null;};w.prototype.addInvalidatedUIArea=function(o){if(!this._sRerenderTimer){t.debug("Registering timer for delayed re-rendering");this._sRerenderTimer=q.sap.delayedCall(0,this,"renderPendingUIUpdates");}};w.MAX_RENDERING_ITERATIONS=20;w.prototype.renderPendingUIUpdates=function(b){t.debug("Render pending UI updates: start ("+(b||"by timer")+")");q.sap.measure.start("renderPendingUIUpdates","Render pending UI updates in all UIAreas");var e=false,l=w.MAX_RENDERING_ITERATIONS>0,i=0;this._bRendering=true;do{if(l){i++;if(i>w.MAX_RENDERING_ITERATIONS){this._bRendering=false;throw new Error("Rendering has been re-started too many times ("+i+"). Add URL parameter sap-ui-xx-debugRendering=true for a detailed analysis.");}if(i>1){t.debug("Render pending UI updates: iteration "+i);}}if(this._sRerenderTimer){if(this._sRerenderTimer!==this){q.sap.clearDelayedCall(this._sRerenderTimer);}this._sRerenderTimer=undefined;}this.runPrerenderingTasks();var m=this.mUIAreas;for(var j in m){e=m[j].rerender()||e;}}while(l&&this._sRerenderTimer);this._bRendering=false;if(e){this.fireUIUpdated();}t.debug("Render pending UI updates: finished");q.sap.measure.end("renderPendingUIUpdates");};w.prototype.getUIDirty=function(){return!!(this._sRerenderTimer||this._bRendering);};w.prototype.attachUIUpdated=function(b,l){_.attachEvent(w.M_EVENTS.UIUpdated,b,l);};w.prototype.detachUIUpdated=function(b,l){_.detachEvent(w.M_EVENTS.UIUpdated,b,l);};w.prototype.fireUIUpdated=function(p){_.fireEvent(w.M_EVENTS.UIUpdated,p);};w.prototype.attachThemeChanged=function(b,l){_.attachEvent(w.M_EVENTS.ThemeChanged,b,l);};w.prototype.detachThemeChanged=function(b,l){_.detachEvent(w.M_EVENTS.ThemeChanged,b,l);};w.prototype.fireThemeChanged=function(p){q.sap.scrollbarSize(true);var P=sap.ui.require("sap/ui/core/theming/Parameters");if(P){P.reset(true);}var e=w.M_EVENTS.ThemeChanged;var o=q.Event(e);o.theme=p?p.theme:null;q.each(this.mElements,function(i,b){b._handleEvent(o);});q.sap.act.refresh();_.fireEvent(e,p);};w.prototype.attachThemeScopingChanged=function(b,l){_.attachEvent(w.M_EVENTS.ThemeScopingChanged,b,l);};w.prototype.detachThemeScopingChanged=function(b,l){_.detachEvent(w.M_EVENTS.ThemeScopingChanged,b,l);};w.prototype.fireThemeScopingChanged=function(p){_.fireEvent(w.M_EVENTS.ThemeScopingChanged,p);};w.prototype.attachLocalizationChanged=function(b,l){_.attachEvent(w.M_EVENTS.LocalizationChanged,b,l);};w.prototype.detachLocalizationChanged=function(b,l){_.detachEvent(w.M_EVENTS.LocalizationChanged,b,l);};w.prototype.fireLocalizationChanged=function(m){var e=w.M_EVENTS.LocalizationChanged,b=q.Event(e,{changes:m}),i=M._handleLocalizationChange;q.sap.log.info("localization settings changed: "+Object.keys(m).join(","),null,"sap.ui.core.Core");q.each(this.oModels,function(N,o){if(o&&o._handleLocalizationChange){o._handleLocalizationChange();}});function n(p){q.each(this.mUIAreas,function(){i.call(this,p);});q.each(this.mObjects["component"],function(){i.call(this,p);});q.each(this.mElements,function(){i.call(this,p);});}n.call(this,1);n.call(this,2);if(m.rtl!=undefined){q(document.documentElement).attr("dir",m.rtl?"rtl":"ltr");this._updateThemeUrls(this.sTheme);q.each(this.mUIAreas,function(){this.invalidate();});q.sap.log.info("RTL mode "+m.rtl?"activated":"deactivated");}q.each(this.mElements,function(j,o){this._handleEvent(b);});_.fireEvent(e,{changes:m});};w.prototype.attachLibraryChanged=function(b,l){_.attachEvent(w.M_EVENTS.LibraryChanged,b,l);};w.prototype.detachLibraryChanged=function(b,l){_.detachEvent(w.M_EVENTS.LibraryChanged,b,l);};w.prototype.fireLibraryChanged=function(p){_.fireEvent(w.M_EVENTS.LibraryChanged,p);};w.prototype.applyChanges=function(){this.renderPendingUIUpdates("forced by applyChanges");};w.prototype.registerElementClass=function(m){var n=m.getName(),l=m.getLibraryName()||"",o=this.mLibraries[l],b=f.prototype.isPrototypeOf(m.getClass().prototype)?'controls':'elements';if(!o){q.sap.getObject(l,0);o=this.mLibraries[l]={name:l,dependencies:[],types:[],interfaces:[],controls:[],elements:[]};}if(o[b].indexOf(n)<0){o[b].push(n);q.sap.log.debug("Class "+m.getName()+" registered for library "+m.getLibraryName());this.fireLibraryChanged({name:m.getName(),stereotype:m.getStereotype(),operation:"add",metadata:m});}};w.prototype.registerElement=function(e){var i=e.getId(),o=this.mElements[i];if(o&&o!==e){if(o._sapui_candidateForDestroy){q.sap.log.debug("destroying dangling template "+o+" when creating new object with same ID");o.destroy();}else{if(this.oConfiguration.getNoDuplicateIds()){q.sap.log.error("adding element with duplicate id '"+i+"'");throw new Error("Error: adding element with duplicate id '"+i+"'");}else{q.sap.log.warning("adding element with duplicate id '"+i+"'");}}}this.mElements[i]=e;};w.prototype.deregisterElement=function(e){delete this.mElements[e.getId()];};w.prototype.registerObject=function(o){var i=o.getId(),b=o.getMetadata().getStereotype(),e=this.getObject(b,i);if(e&&e!==o){q.sap.log.error("adding object \""+b+"\" with duplicate id '"+i+"'");throw new Error("Error: adding object \""+b+"\" with duplicate id '"+i+"'");}this.mObjects[b][i]=o;};w.prototype.deregisterObject=function(o){var i=o.getId(),b=o.getMetadata().getStereotype();delete this.mObjects[b][i];};w.prototype.byId=function(i){return i==null?undefined:this.mElements[i];};w.prototype.getControl=w.prototype.byId;w.prototype.getElementById=w.prototype.byId;w.prototype.getObject=function(b,i){return i==null?undefined:this.mObjects[b]&&this.mObjects[b][i];};w.prototype.getComponent=function(i){return this.getObject("component",i);};w.prototype.getTemplate=function(i){var b=sap.ui.requireSync('sap/ui/core/tmpl/Template');return b.byId(i);};w.prototype.getStaticAreaRef=function(){var o=q.sap.domById(S);if(!o){if(!this.bDomReady){throw new Error("DOM is not ready yet. Static UIArea cannot be created.");}var b={id:S};if(q("body").attr("role")!="application"){b.role="application";}var l=this.getConfiguration().getRTL()?"right":"left";o=q("<DIV/>",b).css({"height":"0","width":"0","overflow":"hidden","float":l}).prependTo(document.body)[0];this.createUIArea(o).bInitial=false;}return o;};w.prototype.isStaticAreaRef=function(o){return o&&(o.id===S);};w._I_INTERVAL=200;k.prototype.I_INTERVAL=w._I_INTERVAL;w.prototype.attachIntervalTimer=function(b,l){if(!this.oTimedTrigger){var e=sap.ui.requireSync("sap/ui/core/IntervalTrigger");this.oTimedTrigger=new e(w._I_INTERVAL);}this.oTimedTrigger.addListener(b,l);};w.prototype.detachIntervalTimer=function(b,l){if(this.oTimedTrigger){this.oTimedTrigger.removeListener(b,l);}};w.prototype.attachControlEvent=function(b,l){_.attachEvent(w.M_EVENTS.ControlEvent,b,l);};w.prototype.detachControlEvent=function(b,l){_.detachEvent(w.M_EVENTS.ControlEvent,b,l);};w.prototype.fireControlEvent=function(p){_.fireEvent(w.M_EVENTS.ControlEvent,p);};w.prototype._handleControlEvent=function(e,b){var o=q.Event(e.type);q.extend(o,e);o.originalEvent=undefined;this.fireControlEvent({"browserEvent":o,"uiArea":b});};w.prototype.getApplication=function(){return sap.ui.getApplication&&sap.ui.getApplication();};w.prototype.registerPlugin=function(p){if(!p){return;}for(var i=0,l=this.aPlugins.length;i<l;i++){if(this.aPlugins[i]===p){return;}}this.aPlugins.push(p);if(this.bInitialized&&p&&p.startPlugin){p.startPlugin(this);}};w.prototype.unregisterPlugin=function(p){if(!p){return;}var P=-1;for(var i=this.aPlugins.length;i--;i>=0){if(this.aPlugins[i]===p){P=i;break;}}if(P==-1){return;}if(this.bInitialized&&p&&p.stopPlugin){p.stopPlugin(this);}this.aPlugins.splice(P,1);};w.prototype.startPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var p=this.aPlugins[i];if(p&&p.startPlugin){p.startPlugin(this,true);}}};w.prototype.stopPlugins=function(){for(var i=0,l=this.aPlugins.length;i<l;i++){var p=this.aPlugins[i];if(p&&p.stopPlugin){p.stopPlugin(this);}}};w.prototype.setModel=function(m,n){var b=this,p;if(!m&&this.oModels[n]){delete this.oModels[n];if(q.isEmptyObject(b.oModels)&&q.isEmptyObject(b.oBindingContexts)){p=M._oEmptyPropagatedProperties;}else{p={oModels:q.extend({},b.oModels),oBindingContexts:{},aPropagationListeners:[]};}q.each(this.mUIAreas,function(i,o){if(m!=o.getModel(n)){o._propagateProperties(n,o,p,false,n);}});}else if(m&&m!==this.oModels[n]){this.oModels[n]=m;q.each(this.mUIAreas,function(i,o){if(m!=o.getModel(n)){var p={oModels:q.extend({},b.oModels),oBindingContexts:{},aPropagationListeners:[]};o._propagateProperties(n,o,p,false,n);}});}return this;};w.prototype.setMessageManager=function(m){this.oMessageManager=m;};w.prototype.getMessageManager=function(){if(!this.oMessageManager){this.oMessageManager=new r();}return this.oMessageManager;};w.prototype.byFieldGroupId=function(v){var b=[];for(var n in this.mElements){var e=this.mElements[n];if(e instanceof f&&e.checkFieldGroupIds(v)){b.push(e);}}return b;};w.prototype.getModel=function(n){return this.oModels[n];};w.prototype.hasModel=function(){return!q.isEmptyObject(this.oModels);};w.prototype.getEventBus=function(){if(!this.oEventBus){var b=sap.ui.requireSync('sap/ui/core/EventBus');this.oEventBus=new b();}return this.oEventBus;};w.prototype.attachValidationError=function(o,b,l){if(typeof(o)==="function"){l=b;b=o;o=undefined;}_.attachEvent(w.M_EVENTS.ValidationError,o,b,l);return this;};w.prototype.detachValidationError=function(b,l){_.detachEvent(w.M_EVENTS.ValidationError,b,l);return this;};w.prototype.attachParseError=function(o,b,l){if(typeof(o)==="function"){l=b;b=o;o=undefined;}_.attachEvent(w.M_EVENTS.ParseError,o,b,l);return this;};w.prototype.detachParseError=function(b,l){_.detachEvent(w.M_EVENTS.ParseError,b,l);return this;};w.prototype.attachFormatError=function(o,b,l){if(typeof(o)==="function"){l=b;b=o;o=undefined;}_.attachEvent(w.M_EVENTS.FormatError,o,b,l);return this;};w.prototype.detachFormatError=function(b,l){_.detachEvent(w.M_EVENTS.FormatError,b,l);return this;};w.prototype.attachValidationSuccess=function(o,b,l){if(typeof(o)==="function"){l=b;b=o;o=undefined;}_.attachEvent(w.M_EVENTS.ValidationSuccess,o,b,l);return this;};w.prototype.detachValidationSuccess=function(b,l){_.detachEvent(w.M_EVENTS.ValidationSuccess,b,l);return this;};w.prototype.fireParseError=function(m){_.fireEvent(w.M_EVENTS.ParseError,m);return this;};w.prototype.fireValidationError=function(m){_.fireEvent(w.M_EVENTS.ValidationError,m);return this;};w.prototype.fireFormatError=function(m){_.fireEvent(w.M_EVENTS.FormatError,m);return this;};w.prototype.fireValidationSuccess=function(m){_.fireEvent(w.M_EVENTS.ValidationSuccess,m);return this;};w.prototype.isMobile=function(){return D.browser.mobile;};w.prototype._getEventProvider=function(){return _;};w.prototype.addPrerenderingTask=function(p){this.aPrerenderingTasks.push(p);this.addInvalidatedUIArea();};w.prototype.runPrerenderingTasks=function(){var b=this.aPrerenderingTasks.slice();this.aPrerenderingTasks=[];b.forEach(function(p){p();});};w.prototype.destroy=function(){this.oFocusHandler.destroy();_.destroy();c.prototype.destroy.call(this);};sap.ui.setRoot=function(o,b){sap.ui.getCore().setRoot(o,b);};return new w().getInterface();});
