/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./_Batch","./_Helper"],function(q,_,a){"use strict";var b={"Accept":"multipart/mixed"},f={"Content-Type":"application/json;charset=UTF-8;IEEE754Compatible=true"},p={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true"},P={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true","OData-MaxVersion":"4.0","OData-Version":"4.0","X-CSRF-Token":"Fetch"},c;function d(r,G){var B=r.mBatchQueue[G];if(B[0].length===0&&B.length===1){delete r.mBatchQueue[G];}}function g(h){var r;h=h.toLowerCase();for(r in this.headers){if(r.toLowerCase()===h){return this.headers[r];}}}function R(s,h,Q,o){this.mBatchQueue={};this.mHeaders=h||{};this.fnOnCreateGroup=o;this.sQueryParams=a.buildQuery(Q);this.mRunningChangeRequests={};this.oSecurityTokenPromise=null;this.sServiceUrl=s;}R.prototype.batchRequestSent=function(G,h){if(h){if(G in this.mRunningChangeRequests){this.mRunningChangeRequests[G]+=1;}else{this.mRunningChangeRequests[G]=1;}}};R.prototype.batchResponseReceived=function(G,h){if(h){this.mRunningChangeRequests[G]-=1;if(this.mRunningChangeRequests[G]===0){delete this.mRunningChangeRequests[G];}}};R.prototype.cancelChangeRequests=function(F,G){var C=false,t=this;function e(s){var B=t.mBatchQueue[s],o,h,E,i;h=B[0];for(i=h.length-1;i>=0;i--){o=h[i];if(o.$cancel&&F(o)){o.$cancel();E=new Error("Request canceled: "+o.method+" "+o.url+"; group: "+s);E.canceled=true;o.$reject(E);h.splice(i,1);C=true;}}d(t,s);}if(G){if(this.mBatchQueue[G]){e(G);}}else{for(G in this.mBatchQueue){e(G);}}return C;};R.prototype.cancelChanges=function(G){if(this.mRunningChangeRequests[G]){throw new Error("Cannot cancel the changes for group '"+G+"', the batch request is running");}this.cancelChangeRequests(function(){return true;},G);};R.prototype.getServiceUrl=function(){return this.sServiceUrl;};R.prototype.hasPendingChanges=function(){var G,e;for(G in this.mBatchQueue){e=this.mBatchQueue[G][0].some(function(r){return r.$cancel;});if(e){return true;}}return Object.keys(this.mRunningChangeRequests).length>0;};R.prototype.refreshSecurityToken=function(){var t=this;if(!this.oSecurityTokenPromise){this.oSecurityTokenPromise=new Promise(function(r,e){q.ajax(t.sServiceUrl+t.sQueryParams,{method:"HEAD",headers:{"X-CSRF-Token":"Fetch"}}).then(function(D,T,j){t.mHeaders["X-CSRF-Token"]=j.getResponseHeader("X-CSRF-Token");t.oSecurityTokenPromise=null;r();},function(j,T,E){t.oSecurityTokenPromise=null;e(a.createError(j));});});}return this.oSecurityTokenPromise;};R.prototype.removePatch=function(o){var C=this.cancelChangeRequests(function(e){return e.$promise===o;});if(!C){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.removePost=function(G,B){var C=this.cancelChangeRequests(function(o){return o.body===B;},G);if(!C){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.request=function(m,r,G,h,o,s,C,i){var t=this,B,I=r==="$batch",e,j,k;G=G||"$direct";if(I){B=_.serializeBatchRequest(c.cleanBatch(o));e=B.body;}else{if(G!=="$direct"){j=new Promise(function(l,n){var u=t.mBatchQueue[G];if(!u){u=t.mBatchQueue[G]=[[]];if(t.fnOnCreateGroup){t.fnOnCreateGroup(G);}}k={method:m,url:r,headers:q.extend({},p,t.mHeaders,h,f),body:o,$cancel:C,$reject:n,$resolve:l,$submit:s};if(m==="GET"){u.push(k);}else{u[0].push(k);}});k.$promise=j;return j;}e=JSON.stringify(c.cleanPayload(o));if(s){s();}}return new Promise(function(l,n){q.ajax(t.sServiceUrl+r+(I?t.sQueryParams:""),{data:e,headers:q.extend({},P,t.mHeaders,h,I?B.headers:f),method:m}).then(function(o,T,u){t.mHeaders["X-CSRF-Token"]=u.getResponseHeader("X-CSRF-Token")||t.mHeaders["X-CSRF-Token"];if(I){o=_.deserializeBatchResponse(u.getResponseHeader("Content-Type"),o);}l(o);},function(u,T,E){var v=u.getResponseHeader("X-CSRF-Token");if(!i&&u.status===403&&v&&v.toLowerCase()==="required"){t.refreshSecurityToken().then(function(){l(t.request(m,r,G,h,o,undefined,undefined,true));},n);}else{n(a.createError(u));}});});};R.prototype.relocate=function(C,B,n){var r=this.mBatchQueue[C],t=this,F=r&&r[0].some(function(o,i){if(o.body===B){t.request(o.method,o.url,n,o.headers,B,o.$submit,o.$cancel).then(o.$resolve,o.$reject);r[0].splice(i,1);d(t,C);return true;}});if(!F){throw new Error("Request not found in group '"+C+"'");}};R.prototype.submitBatch=function(G){var C=[],h,o,r=this.mBatchQueue[G],t=this;function m(o,j){var B,k,s;if(o&&o.method==="PATCH"&&j.method==="PATCH"&&o.url===j.url&&q.sap.equal(o.headers,j.headers)){k=o.body;B=j.body;for(s in k){if(k[s]===null&&B[s]&&typeof B[s]==="object"){return undefined;}}return q.extend(true,k,B);}return undefined;}function v(r,j){var k;r.forEach(function(l,n){var E,s=j[n];if(Array.isArray(s)){v(l,s);}else if(!s){E=new Error("HTTP request was not processed because the previous request failed");E.cause=k;l.$reject(E);}else if(s.status>=400){s.getResponseHeader=g;k=a.createError(s);i(k,l);}else if(s.responseText){l.$resolve(JSON.parse(s.responseText));}else{l.$resolve();}});}function e(j){if(Array.isArray(j)){j.forEach(e);}else if(j.$submit){j.$submit();}}function i(E,j){if(Array.isArray(j)){j.forEach(i.bind(null,E));}else{j.$reject(E);}}if(!r){return Promise.resolve();}delete this.mBatchQueue[G];e(r);r[0].forEach(function(j){var M=m(o,j);if(M){o.body=M;j.$resolve(o.$promise);}else{C.push(j);o=j;}});if(C.length===0){r.splice(0,1);}else if(C.length===1){r[0]=C[0];}else{r[0]=C;}h=C.length>0;this.batchRequestSent(G,h);return this.request("POST","$batch",undefined,b,r).then(function(j){t.batchResponseReceived(G,h);v(r,j);}).catch(function(E){var j=new Error("HTTP request was not processed because $batch failed");function k(r){r.forEach(function(l){if(Array.isArray(l)){k(l);}else{l.$reject(j);}});}t.batchResponseReceived(G,h);j.cause=E;k(r);throw E;});};c={cleanBatch:function(r){r.forEach(function(o){if(Array.isArray(o)){c.cleanBatch(o);}else{o.body=c.cleanPayload(o.body);}});return r;},cleanPayload:function(o){var r=o;if(r){Object.keys(r).forEach(function(k){if(k.indexOf("@$ui5.")===0){if(r===o){r=q.extend({},o);}delete r[k];}});}return r;},create:function(s,h,Q,o){return new R(s,h,Q,o);}};return c;},false);
