/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,H,M,b,Y,U,l){"use strict";var c=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});c.prototype.init=function(){this._iBreakPointTablet=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=this._newUniversalDate(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=this._newUniversalDate(new Date(Date.UTC(9999,11,31)));var z=new H(this.getId()+"--Head");z.attachEvent("pressPrevious",this._handlePrevious,this);z.attachEvent("pressNext",this._handleNext,this);z.attachEvent("pressButton1",o,this);z.attachEvent("pressButton2",p,this);this.setAggregation("header",z);var A=this._createMonth(this.getId()+"--Month0");A.attachEvent("focus",this._handleFocus,this);A.attachEvent("select",s,this);A.attachEvent("_renderMonth",r,this);A.attachEvent("_bindMousemove",t,this);A.attachEvent("_unbindMousemove",u,this);A._bNoThemeChange=true;this.addAggregation("month",A);var B=new b(this.getId()+"--MP");B.attachEvent("select",v,this);B._bNoThemeChange=true;this.setAggregation("monthPicker",B);var E=new Y(this.getId()+"--YP");E.attachEvent("select",w,this);this.setAggregation("yearPicker",E);this._resizeProxy=q.proxy(x,this);};c.prototype.exit=function(){if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}if(this._sResizeListener){sap.ui.core.ResizeHandler.deregister(this._sResizeListener);this._sResizeListener=undefined;}};c.prototype._createMonth=function(i){var z=new M(i,{width:"100%"});return z;};c.prototype.onBeforeRendering=function(){var z=this.getAggregation("month");var A;var B=z[0].getDate();var F=this._getFocusedDate();if(z.length>1&&B){A=a._createUniversalUTCDate(B,this.getPrimaryCalendarType());}else if(z.length>1){A=y.call(this,this._getFocusedDate());}else{A=F;}for(var i=0;i<z.length;i++){B=this._newUniversalDate(A);if(i>0){B.setUTCDate(1);B.setUTCMonth(B.getUTCMonth()+i);}var E=B;if(F.getUTCFullYear()==B.getUTCFullYear()&&F.getUTCMonth()==B.getUTCMonth()){E=F;}z[i].displayDate(a._createLocalDate(E));}this._updateHeader(A);this._iSize=0;};c.prototype.onAfterRendering=function(E){j.call(this);if(n.call(this)>1||this._bInitMonth){E.size={width:this.getDomRef().offsetWidth};x.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=sap.ui.core.ResizeHandler.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};c.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=q.sap.delayedCall(0,this,this._invalidateMonth,[O]);}};c.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};c.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};c.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};c.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};c.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};c.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("disabledDates");return R;};c.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};c.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};c.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};c.prototype._getFocusedDate=function(){if(!this._oFocusedDate){d.call(this);}return this._oFocusedDate;};c.prototype._setFocusedDate=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=this._newUniversalDate(i);};c.prototype.focusDate=function(i){m.call(this,i,false);return this;};c.prototype.displayDate=function(i){m.call(this,i,true);return this;};c.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=a._createUniversalUTCDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=this._newUniversalDate(this._getFocusedDate());}S.setUTCDate(1);return a._createLocalDate(S);};c.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};c.prototype.setMonths=function(z){this._bDateRangeChanged=undefined;this.setProperty("months",z,false);z=n.call(this);var A=this.getAggregation("month");var i=0;var B;if(A.length<z){for(i=A.length;i<z;i++){B=this._createMonth(this.getId()+"--Month"+i);B.attachEvent("focus",this._handleFocus,this);B.attachEvent("select",s,this);B.attachEvent("_renderMonth",r,this);B.attachEvent("_bindMousemove",t,this);B.attachEvent("_unbindMousemove",u,this);B._bNoThemeChange=true;this.addAggregation("month",B);}}else if(A.length>z){for(i=A.length;i>z;i--){B=this.removeAggregation("month",i-1);B.destroy();}if(z==1){this._bInitMonth=true;}}if(z>1&&A[0].getDate()){A[0].setProperty("date",null,true);}return this;};c.prototype.setPrimaryCalendarType=function(z){var A=this.getAggregation("month");var R=false;if(A.length>1){R=true;}this.setProperty("primaryCalendarType",z,!R);this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:z});if(this._oFocusedDate){this._oFocusedDate=U.getInstance(this._oFocusedDate.getJSDate(),z);}this._oMinDate=U.getInstance(this._oMinDate.getJSDate(),z);this._oMaxDate=U.getInstance(this._oMaxDate.getJSDate(),z);for(var i=0;i<A.length;i++){var B=A[i];B.setPrimaryCalendarType(z);}var E=this.getAggregation("monthPicker");E.setPrimaryCalendarType(z);var F=this.getAggregation("yearPicker");F.setPrimaryCalendarType(z);if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(this.iMode!=1&&E.getDomRef()){E.$().remove();}if(this.iMode!=2&&F.getDomRef()){F.$().remove();}}return this;};c.prototype._newUniversalDate=function(i){var J;if((i instanceof U)){J=new Date(i.getJSDate().getTime());}else{J=new Date(i.getTime());}return U.getInstance(J,this.getPrimaryCalendarType());};c.prototype.setSecondaryCalendarType=function(z){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",z,true);this._oYearFormatSecondary=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:z});var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];B.setSecondaryCalendarType(z);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};c.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};c.prototype.setMinDate=function(i){if(q.sap.equal(i,this.getMinDate())){return this;}if(!i){this._oMinDate.getJSDate().setUTCFullYear(1);this._oMinDate.getJSDate().setUTCMonth(0);this._oMinDate.getJSDate().setUTCDate(1);}else{if(!(i instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}this._oMinDate=a._createUniversalUTCDate(i,this.getPrimaryCalendarType());var z=this._oMinDate.getUTCFullYear();if(z<1||z>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}if(this._oMaxDate.getTime()<this._oMinDate.getTime()){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=a._createUniversalUTCDate(i,this.getPrimaryCalendarType());this._oMaxDate.setUTCMonth(this._oMaxDate.getUTCMonth()+1,0);this.setProperty("maxDate",a._createLocalDate(this._oMaxDate),true);}this._setMinMaxDateExtend(i);}this.setProperty("minDate",i,false);var A=this.getAggregation("yearPicker");A._oMinDate.setUTCFullYear(this._oMinDate.getUTCFullYear());return this;};c.prototype.setMaxDate=function(i){if(q.sap.equal(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate.getJSDate().setUTCFullYear(9999);this._oMaxDate.getJSDate().setUTCMonth(11);this._oMaxDate.getJSDate().setUTCDate(31);}else{if(!(i instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}this._oMaxDate=a._createUniversalUTCDate(i,this.getPrimaryCalendarType());var z=this._oMaxDate.getUTCFullYear();if(z<1||z>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}if(this._oMinDate.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=a._createUniversalUTCDate(i,this.getPrimaryCalendarType());this._oMinDate.setUTCDate(1);this.setProperty("minDate",a._createLocalDate(this._oMinDate),true);}this._setMinMaxDateExtend(i);}this.setProperty("maxDate",i,false);var A=this.getAggregation("yearPicker");A._oMaxDate.setUTCFullYear(this._oMaxDate.getUTCFullYear());return this;};c.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){q.sap.log.warning("focused date < minDate -> minDate focused",this);this.focusDate(i);}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(i);}}};c.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var z=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(z);}return this._oLocaleData;};c.prototype._getShowMonthHeader=function(){var i=n.call(this);if(i>2){return true;}else{return false;}};c.prototype.setWidth=function(W){this.setProperty("width",W,true);if(this.getDomRef()){W=this.getWidth();this.$().css("width",W);if(W){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};c.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};c.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};c.prototype.onsapescape=function(E){if(this._iMode==0){this.fireCancel();}this._closedPickers();};c.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};c.prototype.onsaphide=c.prototype.onsapshow;c.prototype.onsaptabnext=function(E){var z=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(z.getDomRef("B1"));if(!this._bPoupupMode){var A=this.getAggregation("month");var B=this.getAggregation("monthPicker");var F=this.getAggregation("yearPicker");for(var i=0;i<A.length;i++){var G=A[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(B.getDomRef()){q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}E.preventDefault();}else if(E.target.id==z.getId()+"-B1"){q.sap.focus(z.getDomRef("B2"));E.preventDefault();}};c.prototype.onsaptabprevious=function(E){var z=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(z.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==z.getId()+"-B1"){var A=this.getAggregation("month");var B=this.getAggregation("monthPicker");var F=this.getAggregation("yearPicker");var G;switch(this._iMode){case 0:G=this._getFocusedDate();for(var i=0;i<A.length;i++){var I=A[i];var J=a._createUniversalUTCDate(I.getDate(),this.getPrimaryCalendarType());if(G.getTime()==J.getTime()){I._oItemNavigation.focusItem(I._oItemNavigation.getFocusedIndex());}else{q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:B._oItemNavigation.focusItem(B._oItemNavigation.getFocusedIndex());break;case 2:F._oItemNavigation.focusItem(F._oItemNavigation.getFocusedIndex());break;}E.preventDefault();}else if(E.target.id==z.getId()+"-B2"){q.sap.focus(z.getDomRef("B1"));E.preventDefault();}};c.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var z=this.getAggregation("header");var A=this.getAggregation("month");var B=this.getAggregation("monthPicker");var F=this.getAggregation("yearPicker");q.sap.focus(z.getDomRef("B2"));if(!this._bPoupupMode){for(var i=0;i<A.length;i++){var G=A[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(B.getDomRef()){q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};c.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var z=this.getAggregation("month");var A=this.getAggregation("monthPicker");var B=this.getAggregation("yearPicker");switch(this._iMode){case 0:for(var i=0;i<z.length;i++){var F=z[i];q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};c.prototype.getFocusDomRef=function(){var i=this.getAggregation("month");var z=i[0];return z._oItemNavigation.getItemDomRefs()[z._oItemNavigation.getFocusedIndex()];};c.prototype.onThemeChanged=function(){if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;var z=this.getAggregation("monthPicker");e.call(this,true);z._bNoThemeChange=false;z.onThemeChanged(arguments);z._bNoThemeChange=true;this._bLongMonth=z._bLongMonth;f.call(this,true);var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];B._bNoThemeChange=false;B.onThemeChanged(arguments);B._bNoThemeChange=true;}var E;if(A.length>1){E=a._createUniversalUTCDate(A[0].getDate(),this.getPrimaryCalendarType());}else{E=this._getFocusedDate();}k.call(this,E);j.call(this);};c.prototype._updateHeader=function(i){k.call(this,i);this._togglePrevNext(i,true);};c.prototype._togglePrevNext=function(i,z){var A=this._oMaxDate.getJSDate().getUTCFullYear();var B=this._oMinDate.getJSDate().getUTCFullYear();var E=this._oMaxDate.getJSDate().getUTCMonth();var F=this._oMinDate.getJSDate().getUTCMonth();var G=this.getAggregation("header");var I=n.call(this);var J=this._newUniversalDate(i);if(this._iMode==0&&I>1){J=y.call(this,i);J.setUTCMonth(J.getUTCMonth()+I,0);}else{J.setUTCMonth(J.getUTCMonth()+1,0);}var K=J.getJSDate().getUTCFullYear();var N=J.getJSDate().getUTCMonth();if(K>A||(K==A&&(!z||N>=E))||(this._iMode==1&&this.getPickerPopup&&this.getPickerPopup())){G.setEnabledNext(false);}else{G.setEnabledNext(true);}if(this._iMode==0&&I>1){J.setUTCMonth(J.getUTCMonth()-I+1,1);}else{J.setUTCDate(1);}K=J.getJSDate().getUTCFullYear();N=J.getJSDate().getUTCMonth();if(K<B||(K==B&&(!z||N<=F))||(this._iMode==1&&this.getPickerPopup&&this.getPickerPopup())){G.setEnabledPrevious(false);}else{G.setEnabledPrevious(true);}};c.prototype._togglePrevNexYearPicker=function(){var i=this.getAggregation("yearPicker");var z=i.getYears();var A=a._createUniversalUTCDate(i.getFirstRenderedDate());A.setUTCFullYear(A.getUTCFullYear()+Math.floor(z/2));var B=this.getAggregation("header");var E=this._newUniversalDate(this._oMaxDate);E.setUTCFullYear(E.getUTCFullYear()-Math.ceil(z/2));E.setUTCMonth(11,31);var F=this._newUniversalDate(this._oMinDate);F.setUTCFullYear(F.getUTCFullYear()+Math.floor(z/2)+1);F.setUTCMonth(0,1);if(A.getTime()>E.getTime()){B.setEnabledNext(false);}else{B.setEnabledNext(true);}if(A.getTime()<F.getTime()){B.setEnabledPrevious(false);}else{B.setEnabledPrevious(true);}};c.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var i=this.getAggregation("header");var z=this.getAggregation("yearPicker");var A=n.call(this);var B;var G;var N=false;switch(this._iMode){case 0:if(A>1){B=a._createUniversalUTCDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());B.setUTCDate(1);this._setFocusedDate(B);F=this._getFocusedDate();}else{F.setUTCDate(1);}F.setUTCDate(F.getUTCDate()-1);_.call(this,N,true);break;case 1:F.setUTCFullYear(F.getUTCFullYear()-1);i.setTextButton2(this._oYearFormat.format(F,true));var S=this._getSecondaryCalendarType();if(S){G=U.getInstance(new Date(F.getJSDate()),S);G.setUTCMonth(0,1);i.setAdditionalTextButton2(this._oYearFormatSecondary.format(G,true));}else{i.setAdditionalTextButton2();}this._togglePrevNext(F);this._setDisabledMonths(F.getUTCFullYear());break;case 2:z.previousPage();this._togglePrevNexYearPicker();break;}};c.prototype._handleNext=function(E){var F=this._getFocusedDate();var i=this.getAggregation("header");var z=this.getAggregation("yearPicker");var A=n.call(this);var B;var G;switch(this._iMode){case 0:if(A>1){B=a._createUniversalUTCDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(B);F=this._getFocusedDate();}F.setUTCMonth(F.getUTCMonth()+A,1);_.call(this);break;case 1:F.setUTCFullYear(F.getUTCFullYear()+1);i.setTextButton2(this._oYearFormat.format(F,true));var S=this._getSecondaryCalendarType();if(S){G=U.getInstance(new Date(F.getJSDate()),S);G.setUTCMonth(0,1);i.setAdditionalTextButton2(this._oYearFormatSecondary.format(G,true));}else{i.setAdditionalTextButton2();}this._togglePrevNext(F);this._setDisabledMonths(F.getUTCFullYear());break;case 2:z.nextPage();this._togglePrevNexYearPicker();break;}};c.prototype._getDisplayedMonths=function(z){var A=[];var B=z.getUTCMonth();var E=n.call(this);if(E>1){for(var i=0;i<E;i++){A.push((B+i)%12);}}else{A.push(B);}return A;};c.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=a._createUniversalUTCDate(i[0].getDate(),P);F.setUTCDate(1);F=U.getInstance(F.getJSDate(),S);var z=F.getUTCMonth();var A=a._createUniversalUTCDate(i[i.length-1].getDate(),P);A.setUTCMonth(A.getUTCMonth()+1,0);A=U.getInstance(A.getJSDate(),S);var E=A.getUTCMonth();return{start:z,end:E};};c.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:f.call(this);break;case 2:h.call(this);break;}};c.prototype._setDisabledMonths=function(i,z){var A=0;var B=11;if(i==this._oMinDate.getUTCFullYear()){A=this._oMinDate.getUTCMonth();}if(i==this._oMaxDate.getUTCFullYear()){B=this._oMaxDate.getUTCMonth();}if(!z){z=this.getAggregation("monthPicker");}z.setMinMax(A,B);};c.prototype._handleFocus=function(E){var i=a._createUniversalUTCDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var R=E.getParameter("restoreOldDate");if(R){if(!q.sap.equal(this._getFocusedDate(),i)){_.call(this,false,false,true);}}else{this._focusDate(i,O);}};c.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};function _(N,I,z){var A=this._getFocusedDate();var B=this.getAggregation("month");var F=false;var E;var G;var J;var i=0;for(i=0;i<B.length;i++){E=B[i];if(E.checkDateFocusable(a._createLocalDate(A))){F=true;}if(F||B.length==1){if(!N){E.setDate(a._createLocalDate(A));}else{E.displayDate(a._createLocalDate(A));}break;}}if(!F){J=this._newUniversalDate(A);if(B.length>1){J=y.call(this,J);for(i=0;i<B.length;i++){E=B[i];G=this._newUniversalDate(J);G.setUTCMonth(J.getUTCMonth()+i);if(!N&&G.getUTCFullYear()==A.getUTCFullYear()&&G.getUTCMonth()==A.getUTCMonth()){E.setDate(a._createLocalDate(A));}else{E.displayDate(a._createLocalDate(G));}}}this._updateHeader(J);if(!z){this.fireStartDateChange();}}}function d(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate(S[0].getStartDate(),i);}else{var N=new Date();this._oFocusedDate=a._createUniversalUTCDate(N,i);}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=this._newUniversalDate(this._oMinDate);}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=this._newUniversalDate(this._oMaxDate);}}function e(N){if(this._iMode==2){h.call(this,true);}var z=this._getFocusedDate();var A=this.getAggregation("monthPicker");if(!this.getPickerPopup||!this.getPickerPopup()){if(A.getDomRef()){A.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(A);R.flush($[0],false,true);R.destroy();}}else{this._openPickerPopup(A);}this.$("contentOver").css("display","");if(!N){A.setMonth(z.getUTCMonth());this._setDisabledMonths(z.getUTCFullYear(),A);if(this._iMode==0){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(z,false);}function f(N){this._iMode=0;if(!this.getPickerPopup||!this.getPickerPopup()){var z=this.getAggregation("monthPicker");z.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){_.call(this);if(n.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);}function g(){if(this._iMode==1){f.call(this,true);}var z=this._getFocusedDate();var A=this.getAggregation("yearPicker");if(!this.getPickerPopup||!this.getPickerPopup()){if(A.getDomRef()){A.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(A);R.flush($[0],false,true);R.destroy();}}else{this._openPickerPopup(A);}this.$("contentOver").css("display","");A.setDate(z.getJSDate());var B;if(n.call(this)==1){B=this.getAggregation("month")[0];var E=B.$("days").find(".sapUiCalItem");if(E.length==28){A.$().addClass("sapUiCalYearNoTop");}else{A.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var F=this.getAggregation("month");for(var i=0;i<F.length;i++){B=F[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;}function h(N){this._iMode=0;if(!this.getPickerPopup||!this.getPickerPopup()){var z=this.getAggregation("yearPicker");z.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){_.call(this);if(n.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);}function j(){if(!this._bNamesLengthChecked){e.call(this,true);f.call(this,true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var z=this.getAggregation("month");var A;if(z.length>1){A=a._createUniversalUTCDate(z[0].getDate(),this.getPrimaryCalendarType());}else{A=this._getFocusedDate();}k.call(this,A);}}else if(n.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}c.prototype._focusDate=function(i,O,N){var F;var z=false;var A=false;if(i.getTime()<this._oMinDate.getTime()){F=this._oMinDate;z=true;}else if(i.getTime()>this._oMaxDate.getTime()){F=this._oMaxDate;z=true;}else{F=i;}if(this._focusDateExtend){A=this._focusDateExtend(i,O,N);}var I=F.getTime()<this._getFocusedDate().getTime();this._setFocusedDate(F);if(z||O){_.call(this,false,I,N);}if(A){this.fireStartDateChange();}};c.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var z=this.getAggregation("month");if(z){for(var i=0;i<z.length;i++){var A=z[i];A._bDateRangeChanged=true;A._bInvalidateSync=true;if(z.length>1){A._bNoFocus=true;}A.invalidate(O);A._bInvalidateSync=undefined;}if(z.length>1){this._focusDate(this._getFocusedDate(),true,true);}}this._bDateRangeChanged=undefined;};function k(i){var z=this.getAggregation("header");var A=this._getLocaleData();var B=[];var E=[];var F=[];var G;var S=false;var T;var P;var I=this.getPrimaryCalendarType();var J=this._getSecondaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){B=A.getMonthsStandAlone("wide",I);}else{S=true;B=A.getMonthsStandAlone("abbreviated",I);E=A.getMonthsStandAlone("wide",I);}if(J){F=A.getMonthsStandAlone("abbreviated",J);var K=this._getDisplayedSecondaryMonths(I,J);if(K.start==K.end){T=F[K.start];}else{P=A.getIntervalPattern();T=P.replace(/\{0\}/,F[K.start]).replace(/\{1\}/,F[K.end]);}}z.setAdditionalTextButton1(T);var N=this._getDisplayedMonths(i);if(N.length>1&&!this._bShowOneMonth){if(!P){P=A.getIntervalPattern();}T=P.replace(/\{0\}/,B[N[0]]).replace(/\{1\}/,B[N[N.length-1]]);if(S){G=P.replace(/\{0\}/,E[N[0]]).replace(/\{1\}/,E[N[N.length-1]]);}}else{T=B[N[0]];if(S){G=E[N[0]];}}z.setTextButton1(T);if(S){z.setAriaLabelButton1(G);}var O=this._newUniversalDate(i);O.setUTCDate(1);z.setTextButton2(this._oYearFormat.format(O,true));if(J){O=U.getInstance(O.getJSDate(),J);z.setAdditionalTextButton2(this._oYearFormatSecondary.format(O,true));}else{z.setAdditionalTextButton2();}}function m(i,N){if(i&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=i.getTime())){if(!(i instanceof Date)){throw new Error("Date must be a JavaScript date object; "+this);}i=a._createUniversalUTCDate(i,this.getPrimaryCalendarType());var z=i.getUTCFullYear();if(z<1||z>9999){throw new Error("Date must not be in valid range (between 0001-01-01 and 9999-12-31); "+this);}if(i.getTime()<this._oMinDate.getTime()||i.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(i);if(this.getDomRef()&&this._iMode==0){_.call(this,N,false,true);}}}function n(){if(sap.ui.Device.system.phone){return 1;}else{return this.getMonths();}}function o(E){if(this._iMode!=1){e.call(this);}else{f.call(this);}}function p(E){if(this._iMode!=2){g.call(this);}else{h.call(this);}}function r(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function s(E){if(n.call(this)>1){var z=this.getAggregation("month");for(var i=0;i<z.length;i++){var A=z[i];if(A.getId()!=E.oSource.getId()){A._updateSelection();}}}this.fireSelect();}function t(E){if(n.call(this)>1){var z=this.getAggregation("month");for(var i=0;i<z.length;i++){var A=z[i];if(A.getId()!=E.oSource.getId()){A._bindMousemove();}}}}function u(E){if(n.call(this)>1){var z=this.getAggregation("month");for(var i=0;i<z.length;i++){var A=z[i];if(A.getId()!=E.oSource.getId()){A._unbindMousemove();}}}}function v(E){var F=this._newUniversalDate(this._getFocusedDate()),i=this.getAggregation("monthPicker"),z=i.getMonth();if(this._adjustFocusedDateUponMonthChange){this._adjustFocusedDateUponMonthChange(F,z);}else{F.setUTCMonth(z);if(z!=F.getUTCMonth()){F.setUTCDate(0);}}this._focusDate(F,true);f.call(this);}function w(E){var F=this._newUniversalDate(this._getFocusedDate());var i=this.getAggregation("yearPicker");var z=a._createUniversalUTCDate(i.getDate(),this.getPrimaryCalendarType());var A=i.getYear();var B;if(this._adjustFocusedDateUponYearChange){B=this._adjustFocusedDateUponYearChange(F,A);if(B){F=B;}}else{z.setUTCMonth(F.getUTCMonth(),F.getUTCDate());F=z;}this._focusDate(F,true);h.call(this);}function x(E){var W=E.size.width;if(W<=0){return;}var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var z=n.call(this);var A;if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:A=2;break;case 2:A=3;break;case 3:A=4;break;default:A=1;break;}if(z<A){A=z;}if(A>2&&z>A){var B=A;var F=0.0;var G=A;while(B>=2){var I=z%B;if(I==0){G=B;break;}else{var N=I/B;if(N>F){F=N;G=B;}}B--;}A=G;}var J;var K=this.getAggregation("month");if(A>1){J=100/A+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{J="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<K.length;i++){var P=K[i];P.setWidth(J);}}}function y(i){var F=this._newUniversalDate(i);F.setUTCDate(1);var z=n.call(this);if(z<=12){var A=i.getUTCMonth();A=A-A%z;if(12%z>0&&A+z>11){A=12-z;}F.setUTCMonth(A);}return F;}return c;},true);
