/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/Popup','sap/m/Text','sap/m/Button','sap/m/Image','sap/ui/core/ResizeHandler','sap/ui/Device','sap/m/MessagePage','sap/ui/core/Icon','sap/ui/layout/VerticalLayout','./InstanceManager','sap/ui/core/InvisibleText'],function(q,l,C,P,T,B,I,R,D,M,a,V,b,c){'use strict';var L=C.extend('sap.m.LightBox',{metadata:{interfaces:['sap.ui.core.PopupInterface'],library:'sap.m',aggregations:{imageContent:{type:'sap.m.LightBoxItem',multiple:true,bindable:"bindable"},_closeButton:{type:'sap.m.Button',multiple:false,visibility:'hidden'},_errorIcon:{type:'sap.ui.core.Icon',multiple:false,visibility:'hidden'},_errorTitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_errorSubtitle:{type:'sap.m.Text',multiple:false,visibility:'hidden'},_verticalLayout:{type:'sap.ui.layout.VerticalLayout',multiple:false,visibility:'hidden'},_invisiblePopupText:{type:"sap.ui.core.InvisibleText",multiple:false,visibility:"hidden"},_busy:{type:"sap.m.BusyIndicator",multiple:false,visibility:"hidden"}},events:{},defaultAggregation:'imageContent'}});L.prototype.init=function(){this._createPopup();this._width=0;this._height=0;this._isRendering=true;this._resizeListenerId=null;this._$lightBox=null;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._closeButtonText=this._rb.getText("LIGHTBOX_CLOSE_BUTTON");if(sap.ui.getCore().getConfiguration().getAccessibility()){this.setAggregation("_invisiblePopupText",new c());}};L.prototype.onBeforeRendering=function(){var i=this._getImageContent(),n=i._getNativeImage(),s=i._getImageState();this._createErrorControls();if(!n.src){n.src=i.getImageSrc();}if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}switch(s){case sap.m.LightBoxLoadingStates.Loading:this._timeoutId=setTimeout(function(){i._setImageState(sap.m.LightBoxLoadingStates.TimeOutError);},10000);break;case sap.m.LightBoxLoadingStates.Loaded:clearTimeout(this._timeoutId);this._calculateSizes(n);break;case sap.m.LightBoxLoadingStates.Error:clearTimeout(this._timeoutId);break;default:break;}var o=this.getAggregation('_invisiblePopupText');if(i&&o){o.setText(this._rb.getText("LIGHTBOX_ARIA_ENLARGED",i.getTitle()));}this._isRendering=true;};L.prototype.onAfterRendering=function(){this._isRendering=false;this._$lightBox=this.$();if(!this._resizeListenerId){D.resize.attachHandler(this._onResize.bind(this));this._resizeListenerId=R.register(this,this._onResize.bind(this));}};L.prototype.forceInvalidate=C.prototype.invalidate;L.prototype.invalidate=function(o){var i=this._getImageContent();if(this.isOpen()){if(i&&i.getImageSrc()){this.forceInvalidate(o);}else{this.close();}}return this;};L.prototype.exit=function(){if(this._oPopup){this._oPopup.detachOpened(this._fnOpened,this);this._oPopup.detachClosed(this._fnClosed,this);this._oPopup.destroy();this._oPopup=null;}if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}b.removeLightBoxInstance(this);};L.prototype.open=function(){var i=this._getImageContent();this._oPopup.setContent(this);if(i&&i.getImageSrc()){this._oPopup.open(300,'center center','center center',document.body,null);b.addLightBoxInstance(this);}return this;};L.prototype.isOpen=function(){if(this._oPopup&&this._oPopup.isOpen()){return true;}return false;};L.prototype.close=function(){if(this._resizeListenerId){D.resize.detachHandler(this._onResize);R.deregister(this._resizeListenerId);this._resizeListenerId=null;}this._oPopup.close();b.removeLightBoxInstance(this);return this;};L.prototype._getCloseButton=function(){var e=this.getAggregation('_closeButton');if(!e){e=new B({id:this.getId()+'-closeButton',text:this._closeButtonText,type:sap.m.ButtonType.Transparent,press:function(){this.close();}.bind(this)});this.setAggregation('_closeButton',e,true);}return e;};L.prototype._getBusyIndicator=function(){var o=this.getAggregation("_busy");if(!o){o=new sap.m.BusyIndicator();this.setAggregation("_busy",o,true);}return o;};L.prototype._imageStateChanged=function(n){if((n===sap.m.LightBoxLoadingStates.Loaded||n===sap.m.LightBoxLoadingStates.Error)&&!this._isRendering){this.rerender();}};L.prototype._createPopup=function(){this._oPopup=new P(this,true,true);this._oPopup.attachOpened(this._fnOpened,this);this._oPopup.attachClosed(this._fnClosed,this);};L.prototype._fnOpened=function(){var t=this;q('#sap-ui-blocklayer-popup').on("click",function(){t.close();});};L.prototype._fnClosed=function(){q('#sap-ui-blocklayer-popup').off("click");};L.prototype._createErrorControls=function(){var r=this._rb;var e;var f;if(this._getImageContent()._getImageState()===sap.m.LightBoxLoadingStates.TimeOutError){e=r.getText('LIGHTBOX_IMAGE_TIMED_OUT');f=r.getText('LIGHTBOX_IMAGE_TIMED_OUT_DETAILS');}else{e=r.getText('LIGHTBOX_IMAGE_ERROR');f=r.getText('LIGHTBOX_IMAGE_ERROR_DETAILS');}if(!this.getAggregation('_verticalLayout')){var g=new T({text:e,textAlign:sap.ui.core.TextAlign.Center}).addStyleClass("sapMLightBoxErrorTitle"),h=new T({text:f,textAlign:sap.ui.core.TextAlign.Center}).addStyleClass("sapMLightBoxErrorSubtitle"),i=new a({src:"sap-icon://picture"}).addStyleClass("sapMLightBoxErrorIcon");this.setAggregation('_verticalLayout',new V({content:[i,g,h]}).addStyleClass('sapMLightBoxVerticalLayout'));}};L.prototype._onResize=function(){var m=d()/2+'px',t=m,e=m,f='',g='',i=this._getImageContent(),h=this.getDomRef(),j,k,n=d(),o=2;if(i._getImageState()===sap.m.LightBoxLoadingStates.Loaded){this._calculateSizes(i._getNativeImage());j=this._width;k=this._height;this._$lightBox.width(j);this._$lightBox.height(k);}else{j=h.clientWidth;k=h.clientHeight;}if(window.innerWidth>j+n){e='50%';g=Math.round(-j/2);}if(window.innerHeight>k+n){t='50%';f=Math.round(-k/2);}if(sap.ui.getCore().getConfiguration().getTheme()==='sap_hcb'){f-=o;g-=o;}this._$lightBox.css({'top':t,'margin-top':f,'left':e,'margin-left':g});};L.prototype._calculateSizes=function(i){var f=this._calculateFooterHeightInPx(),e=288-f,g=this._getImageContent().getAggregation("_image"),h;this._setImageSize(g,i.naturalWidth,i.naturalHeight);this._calculateAndSetLightBoxSize(g);h=this._pxToNumber(g.getHeight());this.toggleStyleClass('sapMLightBoxMinSize',(h<e));this._isBusy=false;};L.prototype._calculateFooterHeightInPx=function(i){var e=this.$().parents().hasClass('sapUiSizeCompact');var s=this._getImageContent().getSubtitle();var f=2.5;if(!e){f+=0.5;}if(s){f+=1.5;}return f*16;};L.prototype._calculateAndSetLightBoxSize=function(i){var e,f=(20*16),g=(18*16),F=this._calculateFooterHeightInPx();e=this._pxToNumber(i.getHeight());this._width=Math.max(f,this._pxToNumber(i.getWidth()));this._height=Math.max(g,e+F);};L.prototype._setImageSize=function(i,e,f){var g=this._calculateFooterHeightInPx(),h=this._getDimensions(e,f,g);i.setWidth(h.width+'px');i.setHeight(h.height+'px');};L.prototype._getDimensions=function(i,e,f){var g=20*16,h=18*16,$=q(window),w=$.height(),j=$.width(),m=d(),k=Math.max(j-m,g),n=Math.max(w-m,h),s;n-=f;if(e<=n){if(i<=k){}else{e*=k/i;i=k;}}else{if(i<=k){i*=n/e;e=n;}else{s=Math.max(i/k,e/n);i/=s;e/=s;}}return{width:Math.round(i),height:Math.round(e)};};L.prototype._pxToNumber=function(s){return(s.substring(0,(s.length-2)))*1;};L.prototype._getImageContent=function(){var r=this.getAggregation('imageContent');return r&&r[0];};function d(){var s=sap.ui.Device.system;if(s.desktop){return 4*16;}if(s.tablet){return 2*16;}return 0;}return L;},true);
