/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/m/Text'],function(q,l,C,T){"use strict";var N=C.extend("sap.m.NewsContent",{metadata:{library:"sap.m",properties:{"size":{type:"sap.m.Size",group:"Misc",defaultValue:sap.m.Size.Auto},"contentText":{type:"string",group:"Misc",defaultValue:null},"subheader":{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"_contentText",aggregations:{"_contentText":{type:"sap.m.Text",multiple:false,visibility:"hidden"}},events:{"press":{}}}});N.prototype.init=function(){this._oContentText=new T(this.getId()+"-content-text",{maxLines:2});this._oContentText.cacheLineHeight=false;this.setAggregation("_contentText",this._oContentText,true);this.setTooltip("{AltText}");};N.prototype.onBeforeRendering=function(){this._setPointerOnContentText();this.$().unbind("mouseenter",this._addTooltip);this.$().unbind("mouseleave",this._removeTooltip);};N.prototype.onAfterRendering=function(){this.$().bind("mouseenter",this._addTooltip.bind(this));this.$().bind("mouseleave",this._removeTooltip.bind(this));};N.prototype._addTooltip=function(){this.$().attr("title",this.getTooltip_AsString());};N.prototype._removeTooltip=function(){this.$().attr("title",null);};N.prototype._setPointerOnContentText=function(){var t=this.getAggregation("_contentText");if(t&&this.hasListeners("press")){t.addStyleClass("sapMPointer");}else if(t&&t.hasStyleClass("sapMPointer")){t.removeStyleClass("sapMPointer");}};N.prototype.getAltText=function(){var a="";var i=true;if(this.getAggregation("_contentText").getText()){a+=this.getAggregation("_contentText").getText();i=false;}if(this.getSubheader()){if(i){a+=""+this.getSubheader();}else{a+="\n"+this.getSubheader();}}return a;};N.prototype.getTooltip_AsString=function(){var t=this.getTooltip();var s=this.getAltText();if(typeof t==="string"||t instanceof String){s=t.split("{AltText}").join(s).split("((AltText))").join(s);return s;}if(t){return t;}else{return"";}};N.prototype.setContentText=function(t){this._oContentText.setText(t);return this;};N.prototype.ontap=function(e){if(sap.ui.Device.browser.msie){this.$().focus();}this.firePress();};N.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.ENTER||e.which===q.sap.KeyCodes.SPACE){this.firePress();e.preventDefault();}};N.prototype.attachEvent=function(e,d,f,a){sap.ui.core.Control.prototype.attachEvent.call(this,e,d,f,a);if(this.hasListeners("press")){this.$().attr("tabindex",0).addClass("sapMPointer");this._setPointerOnContentText();}return this;};N.prototype.detachEvent=function(e,f,a){sap.ui.core.Control.prototype.detachEvent.call(this,e,f,a);if(!this.hasListeners("press")){this.$().removeAttr("tabindex").removeClass("sapMPointer");this._setPointerOnContentText();}return this;};return N;},true);
