// This file has been generated by the SAPUI5 'AllInOne' Builder
/*!
 * @copyright@
 */

sap.ui.getCore().attachInit(function () {
	"use strict";

	/*global jQuery */
	jQuery.sap.includeStyleSheet(jQuery.sap.getResourcePath("sap/ui/documentation/demoapps/css/style.css"));

	sap.ui.require(["sap/ui/core/ComponentContainer"], function (ComponentContainer) {
		new ComponentContainer({
			name : "sap.ui.documentation.demoapps"
		}).placeAt("content");
	});

});
jQuery.sap.declare('sap.ui.documentation.library-all');
jQuery.sap.declare('sap.ui.documentation.demoapps.all'); // raw module, declared by SAPUI5 'AllInOne' Builder
if ( !jQuery.sap.isDeclared('sap.ui.documentation.demoapps.model.formatter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.documentation.demoapps.model.formatter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/documentation/demoapps/model/formatter",[], function () {
	"use strict";

	return {
		/**
		 * Formats a library namespace to link to the API reference if it starts with sap.
		 *
		 * @public
		 * @param {string} sNamespace value to be formatted
		 * @returns {string} formatted link
		 */
		crossLink: function (sLink) {
			if (sLink[0] === "#") {
				sLink = document.location.href.substring(0,document.location.href.search("demoapps\.html")) + sLink;
			}
			return sLink;
		},

		/**
		 * Formats a library namespace to link to the API reference if it starts with sap.
		 *
		 * @public
		 * @param {string} sNamespace value to be formatted
		 * @returns {string} formatted link
		 */
		libraryLink: function (sNamespace) {
			if (sNamespace && sNamespace.search("sap\\.") === 0) {
				return this.formatter.crossLink("#docs/api/symbols/" + sNamespace + ".html");
			} else {
				return "";
			}
		},

		/**
		 * Formats a library namespace to true if it starts with sap.
		 *
		 * @public
		 * @param {string} sNamespace value to be formatted
		 * @returns {boolean} true or false
		 */
		libraryLinkEnabled: function (sNamespace) {
			return !!this.formatter.libraryLink.bind(this)(sNamespace);
		},

		/**
		 * Formats a category id to a category name.
		 *
		 * @public
		 * @param {string} sCategoryId the value to be formatted
		 * @returns {string} the formatted text
		 */
		categoryName: function (sCategoryId) {
			var oResourceBundle = this.getView().getModel("i18n").getResourceBundle();

			return oResourceBundle.getText("demoAppCategory" + sCategoryId);
		}
	};
});
}; // end of sap/ui/documentation/demoapps/model/formatter.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.demoapps.model.models') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.documentation.demoapps.model.models'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/demoapps/model/models",[
		"sap/ui/model/json/JSONModel",
		"sap/ui/Device"
	], function (JSONModel, Device) {
		"use strict";

		return {
			createDeviceModel : function () {
				var oModel = new JSONModel(Device);
				oModel.setDefaultBindingMode("OneWay");
				return oModel;
			}
		};

	}
);
}; // end of sap/ui/documentation/demoapps/model/models.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.demoapps.model.sourceFileDownloader') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global Promise*/
jQuery.sap.declare('sap.ui.documentation.demoapps.model.sourceFileDownloader'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/demoapps/model/sourceFileDownloader",['jquery.sap.global'], function (jQuery) {
	"use strict";

	var oCodeCache = {};
	return function (sUrl) {
		return new Promise(function (fnResolve) {
			var fnSuccess = function (result) {
				oCodeCache[sUrl] = result;
				fnResolve(result);
			};
			var fnError = function () {
				fnResolve({errorMessage: "FIle not found: '" + sUrl + "'"});
			};

			if (!(sUrl in oCodeCache)) {
				jQuery.ajax(sUrl, {
					dataType: "text",
					success: fnSuccess,
					error: fnError
				});
			} else {
				fnResolve(oCodeCache[sUrl]);
			}
		});
	};
});

}; // end of sap/ui/documentation/demoapps/model/sourceFileDownloader.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.ui.documentation.
 */
jQuery.sap.declare('sap.ui.documentation.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.util.LibraryInfo'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
jQuery.sap.require('sap.m.library'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/library",['jquery.sap.global', 'sap/ui/core/util/LibraryInfo',
	'sap/ui/core/library', 'sap/m/library'], // library dependency
	function(jQuery, LibraryInfo) {

	'use strict';

	/**
	 * SAPUI5 library with controls specialized for administrative applications.
	 *
	 * @namespace
	 * @name sap.ui.documentation
	 * @author SAP SE
	 * @version 1.48.6
	 * @public
	 */

	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : 'sap.ui.documentation',
		version: '1.48.6',
		dependencies : ['sap.ui.core','sap.m'],
		types: [],
		interfaces: [],
		controls: [
			"sap.ui.documentation.sdk.controls.Search"
		],
		elements: []
	});

	var thisLibrary = sap.ui.documentation;

	var _libraryInfoSingleton;

	thisLibrary._getAppInfo = function(fnCallback) {
		var sUrl = sap.ui.resource("", "sap-ui-version.json");

		jQuery.ajax({
			url: sUrl,
			dataType: "json",
			error: function(xhr, status, e) {
				jQuery.sap.log.error("failed to load library list from '" + sUrl + "': " + status + ", " + e);
				fnCallback(null);
			},
			success : function(oAppInfo, sStatus, oXHR) {
				if (!oAppInfo) {
					jQuery.sap.log.error("failed to load library list from '" + sUrl + "': " + sStatus + ", Data: " + oAppInfo);
					fnCallback(null);
					return;
				}

				fnCallback(oAppInfo);
			}
		});
	};

	/**
	 * Ensures that only one instance of LibraryInfo will be used across the app.
	 * This is important, because the LibraryInfo object stores internally the content of already loaded .library files
	 * @returns {*}
	 * @private
	 */
	thisLibrary._getLibraryInfoSingleton = function () {
		if (!_libraryInfoSingleton) {
			_libraryInfoSingleton = new LibraryInfo();
		}

		return _libraryInfoSingleton;
	};

	thisLibrary._loadAllLibInfo = function(sAppRoot, sInfoType, sReqVersion, fnCallback) {

		// parameter fallback for compatibility: if the version is a function
		// then it is the old signature: (sAppRoot, sInfoType, fnCallback)
		if (typeof sReqVersion === "function") {
			fnCallback = sReqVersion;
			sReqVersion = undefined;
		}

		var libInfo = thisLibrary._getLibraryInfoSingleton();

		// special case: fetching library info and release notes in one cycle
		// this will use the _getLibraryInfo functionality and
		var bFetchReleaseNotes = sInfoType == "_getLibraryInfoAndReleaseNotes";
		if (bFetchReleaseNotes) {
			sInfoType = "_getLibraryInfo";
		}

		thisLibrary._getAppInfo(function(oAppInfo) {
			if (!(oAppInfo && oAppInfo.libraries)) {
				fnCallback(null, null);
				return;
			}

			var count = 0,
				aLibraries = oAppInfo.libraries,
				len = aLibraries.length,
				oLibInfos = {},
				oLibVersions = {},
				aLibs = [],
				libName,
				libVersion;
			for (var i = 0; i < len; i++) {
				libName = aLibraries[i].name;
				libVersion = aLibraries[i].version;
				aLibs.push(libName);
				oLibVersions[libName] = libVersion;

				/*eslint-disable no-loop-func */
				libInfo[sInfoType](libName, function(oExtensionData){
					var fnDone = function() {
						count++;
						if (count == len) {
							fnCallback(aLibs, oLibInfos, oAppInfo);
						}
					};
					oLibInfos[oExtensionData.library] = oExtensionData;
					// fallback to version coming from version info file
					// (in case of ABAP we always should refer to the libVersion if available!)
					if (!oLibInfos[oExtensionData.library].version) {
						oLibInfos[oExtensionData.library].version = oLibVersions[oExtensionData.library];
					}
					// fetch the release notes if defined - in case of no version
					// is specified we fallback to the current library version
					if (bFetchReleaseNotes) {
						if (!sReqVersion) {
							sReqVersion = oLibVersions[oExtensionData.library];
						}
						libInfo._getReleaseNotes(oExtensionData.library, sReqVersion, function(oReleaseNotes) {
							oLibInfos[oExtensionData.library].relnotes = oReleaseNotes;
							fnDone();
						});
					} else {
						fnDone();
					}
				});
				/*eslint-enable no-loop-func */
			}
		});
	};

	return thisLibrary;

});

}; // end of sap/ui/documentation/library.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.ErrorHandler') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.documentation.sdk.controller.ErrorHandler'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.Object'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageBox'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/ErrorHandler",[
		"sap/ui/base/Object",
		"sap/m/MessageBox"
	], function (UI5Object, MessageBox) {
		"use strict";

		return UI5Object.extend("sap.ui.documentation.sdk.controller.ErrorHandler", {

			/**
			 * Handles application errors by automatically attaching to the model events and displaying errors when needed.
			 * @class
			 * @param {sap.ui.core.UIComponent} oComponent reference to the app's component
			 * @public
			 * @alias sap.ui.documentation.sdk.controller.ErrorHandler
			 */
			constructor : function (oComponent) {
				this._oComponent = oComponent;
				this._oModel = oComponent.getModel();
				this._bMessageOpen = false;
				this._sErrorText = "Sorry, a technical error occurred! Please try again later.";
			},

			/**
			 * Shows a {@link sap.m.MessageBox} when the metadata call has failed.
			 * The user can try to refresh the metadata.
			 * @param {string} sDetails a technical error to be displayed on request
			 * @private
			 */
			_showMetadataError : function (sDetails) {
				MessageBox.error(
					this._sErrorText,
					{
						id : "metadataErrorMessageBox",
						details : sDetails,
						styleClass : this._oComponent.getContentDensityClass(),
						actions : [MessageBox.Action.RETRY, MessageBox.Action.CLOSE],
						onClose : function (sAction) {
							if (sAction === MessageBox.Action.RETRY) {
								this._oModel.refreshMetadata();
							}
						}.bind(this)
					}
				);
			},

			/**
			 * Shows a {@link sap.m.MessageBox} when a service call has failed.
			 * Only the first error message will be display.
			 * @param {string} sDetails a technical error to be displayed on request
			 * @private
			 */
			_showServiceError : function (sDetails) {
				if (this._bMessageOpen) {
					return;
				}
				this._bMessageOpen = true;
				MessageBox.error(
					this._sErrorText,
					{
						id : "serviceErrorMessageBox",
						details : sDetails,
						styleClass : this._oComponent.getContentDensityClass(),
						actions : [MessageBox.Action.CLOSE],
						onClose : function () {
							this._bMessageOpen = false;
						}.bind(this)
					}
				);
			}

		});

	}
);

}; // end of sap/ui/documentation/sdk/controller/ErrorHandler.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.util.APIInfo') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides reuse functionality for reading documentation from api.json files (as created by the UI5 JSDoc3 template/plugin)
jQuery.sap.declare('sap.ui.documentation.sdk.controller.util.APIInfo'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/util/APIInfo",['jquery.sap.global'],
	function(jQuery) {
		"use strict";

		/**
		 * Root path to read api.json files from
		 */
		var sTestResourcesRoot;

		var oLibraryDataCache = {};
		var oAllLibrariesPromise = null;

		// Libraries that should be ommitted from the tree
		var LIBRARIES_BLACK_LIST = ["sap.ui.demokit", "sap.ui.documentation"];
		// Libraries that start with these prefixes should be ommitted from the tree
		var LIBRARY_PREFIXES_BLACK_LIST = ["themelib_"];

		function getLibraryElementsJSONSync(sLibraryName) {
			var oResponse = [];

			if ( !sLibraryName ) {
				return oResponse;
			}

			if (oLibraryDataCache[sLibraryName]) {
				return oLibraryDataCache[sLibraryName];
			}

			jQuery.ajax({
				async: false,
				url : sTestResourcesRoot + sLibraryName.replace(/\./g, '/') + '/designtime/api.json',
				dataType : 'json',
				success : function(vResponse) {
					oResponse = vResponse.symbols;
				},
				error : function () {
					oResponse = [];
					jQuery.sap.log.error("failed to load api.json for: " + sLibraryName);
				}
			});

			oLibraryDataCache[sLibraryName] = oResponse;

			return oResponse;
		}

		function getLibraryElementsJSONPromise(sLibraryName) {

			// If no library name given, resolve immediately with empty array
			if ( !sLibraryName ) {
				return Promise.resolve([]);
			}

			if (oLibraryDataCache[sLibraryName]) {
				return Promise.resolve(oLibraryDataCache[sLibraryName]);
			}

			return new Promise(function (resolve) {
				// Fetch library data, then cache it no matter the result
				jQuery.ajax({
					async: true,
					url : sTestResourcesRoot + sLibraryName.replace(/\./g, '/') + '/designtime/api.json',
					dataType : 'json',
					success : function(vResponse) {
						var aResult = vResponse.symbols || [];
						oLibraryDataCache[sLibraryName] = aResult;
						resolve(aResult);
					},
					error : function (err) {
						jQuery.sap.log.error("failed to load api.json for: " + sLibraryName);
						oLibraryDataCache[sLibraryName] = [];
						resolve([]);
					}
				});
			});

		}

		function getAllLibraryInfos() {
			var aLibraries = sap.ui.getVersionInfo().libraries;

			aLibraries = aLibraries.filter(function (oLibrary) {
				var bIsBlacklisted = LIBRARIES_BLACK_LIST.indexOf(oLibrary.name) !== -1;
				var bStartsWithBlacklistedPrefix = LIBRARY_PREFIXES_BLACK_LIST.some(function (sPrefix) {
					return oLibrary.name.indexOf(sPrefix) === 0;
				});

				return !bIsBlacklisted && !bStartsWithBlacklistedPrefix;
			});

			return aLibraries;
		}

		function getAllLibrariesElementsJSONPromise() {
			if (oAllLibrariesPromise) {
				return oAllLibrariesPromise;
			}

			var aLibraries = getAllLibraryInfos();

			// Get a list of promises for each library (these never reject, but can resolve with an empty array)
			var aPromises = aLibraries.map(function (oLibrary) {
				return getLibraryElementsJSONPromise(oLibrary.name);
			});

			oAllLibrariesPromise = Promise.all(aPromises);

			return oAllLibrariesPromise;
		}

		function setRoot(sRoot) {
			sRoot = sRoot == null ? jQuery.sap.getModulePath('', '/') + '../test-resources/' : sRoot;
			if ( sRoot.slice(-1) != '/' ) {
				sRoot += '/';
			}
			sTestResourcesRoot = sRoot;
		}

		setRoot();

		return {
			_setRoot : setRoot,
			getLibraryElementsJSONSync : getLibraryElementsJSONSync,
			getLibraryElementsJSONPromise: getLibraryElementsJSONPromise,
			getAllLibrariesElementsJSONPromise: getAllLibrariesElementsJSONPromise
		};

	});

}; // end of sap/ui/documentation/sdk/controller/util/APIInfo.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.util.ConfigUtil') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/* Utility class that facilitates route configuration handling */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.util.ConfigUtil'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.Object'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/util/ConfigUtil",[
	"sap/ui/base/Object"
], function (BaseObject) {
	"use strict";

	return BaseObject.extend("sap.ui.documentation.sdk.controller.util.ConfigUtil", {

		constructor : function (oComponent) {
			this._oComponent = oComponent;
		},

		hasMasterView: function(sRouteName) {
			var oRouteConfig = this._getRouteConfig(sRouteName),
				bIsSplitView = oRouteConfig && oRouteConfig.target.length === 2;
			return !!bIsSplitView;
		},

		getMasterView: function(sRouteName) {
			var sMasterTargetName = this._getMasterTargetName(sRouteName),
				sTargetConfig = this._getTargetConfig(sMasterTargetName),
				sViewName = sTargetConfig.viewName;

				sViewName = "sap.ui.documentation.sdk.view." + jQuery.sap.charToUpperCase(sViewName, 0);

				return this._oComponent.getRouter().getView(sViewName);
		},

		_getMasterTargetName: function(sRouteName) {
			var oRouteConfig = this._getRouteConfig(sRouteName),
				bIsSplitView = oRouteConfig && oRouteConfig.target.length === 2,
				sMasterTarget = bIsSplitView && oRouteConfig.target[0];
			return sMasterTarget;
		},

		_getRouteConfig: function(sRouteName) {
			var oConfig = this._getSapUI5ConfigEntry(),
				aRoutes = oConfig.routing.routes,
				aRoute = jQuery.grep(aRoutes, function(oRoute){return oRoute.name === sRouteName; }),
				oRoute = aRoute.length && aRoute[0];
			return oRoute;
		},

		_getSapUI5ConfigEntry: function () {
			return this._oComponent.getMetadata().getManifestObject().getEntry("sap.ui5");
		},

		_getTargetConfig: function(sTargetName) {
			return this._getSapUI5ConfigEntry().routing.targets[sTargetName];
		},

		destroy: function () {
			this._oComponent = null;
			return BaseObject.prototype.destroy.apply(this, arguments);
		}
	});
});
}; // end of sap/ui/documentation/sdk/controller/util/ConfigUtil.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.util.ControlsInfo') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides information about 'explored' samples.
jQuery.sap.declare('sap.ui.documentation.sdk.controller.util.ControlsInfo'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/util/ControlsInfo",['jquery.sap.global', 'sap/ui/documentation/library'],
	function(jQuery, library) {
		"use strict";

		var oPromise;

		var ControlsInfo = {

			loadData: function() {
				if (!oPromise) {

					oPromise = new Promise(function(resolve, reject) {
						library._loadAllLibInfo(
							"", "_getDocuIndex",
							function (aLibs, oDocIndicies) {
								var oData = ControlsInfo._getIndices(aLibs, oDocIndicies);
								resolve(oData);
							});
					});
				}
				return oPromise;
			},

			_getIndices: function (aLibs, oDocIndicies) {

				var aCategoryWhiteList = [
					"Action",
					"Application",
					"Container",
					"Display",
					"Chart",
					"Mini Chart",
					"Layout",
					"List",
					"Popup",
					"Tile",
					"User Input",
					"Testing",
					"Theming",
					"Tutorial",
					"Routing",
					"Data Binding",
					"Data Visualization",
					"Map"
				];
				var afilterProps = ["namespace", "since", "category"]; // content density are set manually
				var oFilterSets = {
					namespace: {},
					since: {},
					category: {},
					formFactors: { // content density are set manually
						"Independent": true,
						"Condensed": true,
						"Compact": true,
						"Cozy": true
					}
				};
				var mFormFactorsMap = {
					"-": "Independent",
					"S": "Condensed",
					"SM": "Condensed, Compact",
					"SL": "Condensed, Cozy",
					"SML": "Condensed, Compact, Cozy",
					"M": "Compact",
					"ML": "Compact, Cozy",
					"L": "Cozy"
				};

				// init data structures
				var data = {};
				data = {};
				data.entityCount = 0;
				data.entities = [];
				data.filter = {};
				data.samples = {};

				// iterate docu indices
				jQuery.each(oDocIndicies, function (i, oDoc) {

					// check data
					if (!oDoc.explored) {
						return;
					} else if (!oDoc.explored.samplesRef) {
						jQuery.sap.log.error("explored: cannot register lib '" + oDoc.library + "'. missing 'explored.samplesRef'");
						return;
					} else if (Array.isArray(oDoc.explored.samplesRef) && oDoc.explored.samplesRef.length !== oDoc.explored.samplesRef.filter(function (oItem) {
							return oItem.namespace && oItem.ref;
						}).length) {
						jQuery.sap.log.error("explored: cannot register lib '" + oDoc.library + "'. missing 'explored.samplesRef.namespace' or 'explored.samplesRef.ref' in one or more of the configured namespaces");
						return;
					} else if (!Array.isArray(oDoc.explored.samplesRef) && !oDoc.explored.samplesRef.namespace) {
						jQuery.sap.log.error("explored: cannot register lib '" + oDoc.library + "'. missing 'explored.samplesRef.namespace'");
						return;
					} else if (!Array.isArray(oDoc.explored.samplesRef) && !oDoc.explored.samplesRef.ref) {
						jQuery.sap.log.error("explored: cannot register lib '" + oDoc.library + "'. missing 'explored.samplesRef.ref'");
						return;
					} else if (!oDoc.explored.entities) {
						jQuery.sap.log.error("explored: cannot register lib '" + oDoc.library + "'. missing 'explored.entities'");
						return;
					} else {
						jQuery.sap.log.info("explored: now reading lib '" + oDoc.library + "'");
					}

					// register sample resources
					if (Array.isArray(oDoc.explored.samplesRef)) {
						// register an array of namespaces
						oDoc.explored.samplesRef.forEach(function (oItem) {
							jQuery.sap.registerModulePath(oItem.namespace, "" + oItem.ref);
						});
					} else {
						// register a single namespace
						jQuery.sap.registerModulePath(oDoc.explored.samplesRef.namespace, "" + oDoc.explored.samplesRef.ref);
					}

					// build sample map
					jQuery.each(oDoc.explored.samples, function (i, oSample) {
						if (!oSample.id) {
							jQuery.sap.log.error("explored: cannot register sample '?'. missing 'id'");
						} else if (!oSample.name) {
							jQuery.sap.log.error("explored: cannot register sample '" + oSample.id + "'. missing 'name'");
						} else {
							data.samples[oSample.id] = oSample;
						}
					});

					// iterate entities
					jQuery.each(oDoc.explored.entities, function (j, oEnt) {

						// check id property
						if (!oEnt.id) {
							jQuery.sap.log.error("explored: cannot register entity '?'. missing 'id'");
							return;
						}

						// apply default properties
						if (oDoc.explored.entitiesDefaults) {
							jQuery.each(oDoc.explored.entitiesDefaults, function (key, value) {
								if (!oEnt.hasOwnProperty(key)) {
									oEnt[key] = value;
								}
							});
						}

						// apply namespace property
						var iIndex = oEnt.id.lastIndexOf(".");
						var sNamespace = (iIndex !== -1) ? oEnt.id.substring(0, iIndex) : oEnt.id;
						oEnt.namespace = sNamespace;

						// check name property
						if (!oEnt.name) {
							jQuery.sap.log.error("explored: cannot register entity '" + oEnt.id + "'. missing 'name'");
							return;
						}

						// check category white list
						if (aCategoryWhiteList.indexOf(oEnt.category) === -1) {
							jQuery.sap.log.error("explored: cannot register entity '" + oEnt.id + "'. category '" + oEnt.category + "' is not allowed");
							return;
						}

						// convert content density
						if (!oEnt.formFactors) {
							jQuery.sap.log.error("explored: cannot register entity '" + oEnt.id + "'. missing 'formFactors'");
							return;
						}
						if (!mFormFactorsMap[oEnt.formFactors]) {
							jQuery.sap.log.error("explored: cannot register entity '" + oEnt.id + "'. formFactors '" + oEnt.formFactors + "' is not allowed");
							return;
						}
						oEnt.formFactors = mFormFactorsMap[oEnt.formFactors];

						// check filter properties
						var bAbortEntity = false;
						jQuery.each(afilterProps, function (i, sProp) {
							if (!oEnt[sProp]) {
								jQuery.sap.log.error("explored: cannot register entity '" + oEnt.id + "'. missing '" + sProp + "'");
								bAbortEntity = true;
								return false;
							}
						});
						if (bAbortEntity) {
							return;
						}

						// add filter properties to sets
						jQuery.each(afilterProps, function (i, sProp) {
							oFilterSets[sProp][oEnt[sProp]] = true;
						});

						// add entity
						data.entities.push(oEnt);
					});
				});

				// iterate entities one more time and add the sample data
				// (this must be done in a separate loop in order to map samples across libraries/docIndizes)
				jQuery.each(data.entities, function (sNamespace, oEnt) {
					var i = 0,
						oStep,
						fnPrependZero;

					// define search tags
					oEnt.searchTags = oEnt.name + " " + oEnt.name.replace(" ", "") + " " + oEnt.category;

					// check samples property
					if (oEnt.samples && !(oEnt.samples instanceof Array)) {
						oEnt.samples = [];
						jQuery.sap.log.error("explored: cannot register samples for entity '" + oEnt.id + "'. 'samples' is not an array");
						return;
					}
					if (!oEnt.samples) {
						oEnt.samples = [];
					}

					// add samples to entity
					if (oEnt.samplesAsSteps) {
						// step-based entities: generate a sample based on the name of the step and the position in the array
						if (!(oEnt.samplesAsSteps instanceof Array)) {
							jQuery.sap.log.error("explored: cannot register samples for entity '" + oEnt.id + "'. 'samplesAsSteps' is not an array");
							return;
						}

						// helper function to add a leading 0 for all samples (folders will start with 01)
						fnPrependZero = function (iNumber) {
							if (iNumber.toString().length === 1) {
								return "0" + iNumber;
							}
							return iNumber;
						};

						for (; i < oEnt.samplesAsSteps.length; i++) {
							oStep = {
								"id": oEnt.id + "." + fnPrependZero(i + 1),
								"name": oEnt.name + " - Step " + (i + 1) + " - " + oEnt.samplesAsSteps[i]
							};

							// dynamically add a prev / next pointer to be able to cross-navigate between the samples of the same type
							if (i > 0) {
								oStep.previousSampleId = oEnt.id + "." + fnPrependZero(i);
							}
							if (i < oEnt.samplesAsSteps.length - 1) {
								oStep.nextSampleId = oEnt.id + "." + fnPrependZero(i + 2);
							}

							// add generated sample to this entity and to the samples array
							oEnt.samples.push(oStep);
							data.samples[oStep.id] = oStep;
							oEnt.searchTags += " " + oStep.name;
						}
					} else {
						// other entities: lookup samples and build search tags
						var aSamples = [],
							oPreviousSample;

						jQuery.each(oEnt.samples, function (j, sId) {
							var oSample = data.samples[sId];

							if (!oSample) {
								jQuery.sap.log.warning("explored: cannot register sample '" + sId + "' for '" + oEnt.id + "'. not found in the available docu indizes");
							} else {
								// dynamically add a prev / next pointer to be able to cross-navigate between the samples of the same type
								oSample.previousSampleId = (oPreviousSample ? oPreviousSample.id : undefined);
								if (oPreviousSample) {
									oPreviousSample.nextSampleId = oSample.id;
								}
								oPreviousSample = oSample;

								// add the sample to the local store
								aSamples.push(oSample);
								oEnt.searchTags += " " + oSample.name;
							}
						});
						oEnt.samples = aSamples;
					}

					// set count
					oEnt.sampleCount = oEnt.samples.length;
				});

				// set count
				data.entityCount = data.entities.length;

				// convert filter sets to arrays
				jQuery.each(oFilterSets, function (setKey, setValue) {
					data.filter[setKey] = [];
					jQuery.each(setValue, function (key, value) {
						data.filter[setKey].push({id: key});
					});
				});

				// call LibraryInfo API method for collecting all component info from the .library files

				var oLibInfo = library._getLibraryInfoSingleton();
				var oLibComponents = {};
				var oLibraryComponentInfo = function (oComponent) {
					oLibComponents[oComponent.library] = oComponent.componentInfo;
				};
				for (var i = 0; i < aLibs.length; i++) {
					oLibInfo._getLibraryInfo(aLibs[i], oLibraryComponentInfo);
				}

				data.libComponentInfos = oLibComponents;

				data.groups = this.getGroups(data.entities);
				return data;
			},

			findGroup: function (groups, name) {

				var group;

				for (var i = 0; i < groups.length; i++) {

					group = groups[i];

					if (group.name == name) {
						return group;
					}
				}
			},

			getGroups : function (entities) {
				var groups = [],
					entity,
					group,
					samples,
					sample,
					i,
					j;

				for (i = 0; i < entities.length; i++) {
					entity = entities[i];
					entity.key = '#/entity/' + entity.id;

					samples = entity.samples;
					for (j = 0; j < samples.length; j++) {
						sample = samples[j];
						sample.key = '#/sample/' + sample.id + "/preview";
					}

					group = this.findGroup(groups, entity.category);
					if (!group) {
						group = {
							name: entity.category,
							key: '#/group/' + entity.category,
							controls: [entity]
						};

						groups.push(group);
					} else {
						group.controls.push(entity);
					}
				}

				return groups;
			}
		};

		return ControlsInfo;

	}, /* bExport= */ true);

}; // end of sap/ui/documentation/sdk/controller/util/ControlsInfo.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.util.EntityInfo') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides reuse functionality for reading documentation from metamodel entities
jQuery.sap.declare('sap.ui.documentation.sdk.controller.util.EntityInfo'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.documentation.sdk.thirdparty.jsanalyzer.ModuleAnalyzer'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/util/EntityInfo",['jquery.sap.global', 'sap/ui/documentation/sdk/thirdparty/jsanalyzer/ModuleAnalyzer', './APIInfo'],
	function(jQuery, analyzer, APIInfo) {
	"use strict";

	var oRootPackageInfo = {};

	function getPackageInfo(sName) {
		var aParts = sName.split('.');
		var oPackageInfo = oRootPackageInfo;
		var l = aParts.length - 1;
		for (var i = 0; i < l && !oPackageInfo.__noMetamodel && !oPackageInfo.__noSource; i++ ) {
			oPackageInfo = oPackageInfo[aParts[i]] || (oPackageInfo[aParts[i]] = {});
		}
		return oPackageInfo;
	}

	// just a hack, needs proper type resolution
	var CORE_TYPES = "boolean int float number function object string void any Element Control Component";

	function resolve(sType, sContextName) {
		if ( sType.indexOf("/") >= 0 ) {
			return sType.replace(/\//g, ".");
		} else if ( sType && sType.indexOf(".") < 0 && CORE_TYPES.indexOf(sType) >= 0 ) {
			return "sap.ui.core." + sType;
		} else {
			return sContextName.split(".").slice(0, -1).concat([sType.replace(/\//g, ".")]).join(".");
		}
	}

	function parseControlMetamodel(oData, sEntityName) {

		var $control = jQuery(oData.documentElement);
		var oEntityDoc = {
			metatype : 'control',
			baseType : undefined,
			doc : undefined,
			deprecation : undefined,
			properties : {},
			aggregations : {},
			associations : {},
			events : {},
			methods : {}
		};

		var sBaseType = $control.children("baseType").text();
		oEntityDoc.baseType = (sBaseType) ? resolve(sBaseType, sEntityName) : null;

		oEntityDoc.doc = doc($control);
		oEntityDoc.deprecation = depr($control);

		each($control, "properties/property", function($prop) {
			oEntityDoc.properties[$prop.attr("name")] = {
				kind : 0,
				type : resolve($prop.attr("type") || "string", sEntityName),
				defaultValue : $prop.attr("defaultValue") || "empty/undefined",
				doc : doc($prop),
				deprecation : depr($prop),
				since : $prop.attr("since") || null
			};
		});

		oEntityDoc.defaultAggregation = oEntityDoc.defaultAggregation || $control.children("aggregations").attr("default");
		each($control, "aggregations/aggregation", function($aggr) {
			oEntityDoc.aggregations[$aggr.attr("name")] = {
				kind : $aggr.attr("cardinality") === "0..1" ? 1 : 2,
				type : resolve($aggr.attr("type") || "sap.ui.core/Control", sEntityName),
				cardinality : $aggr.attr("cardinality") || "0..n",
				visibility : $aggr.attr("visibility") || null,
				doc : doc($aggr),
				deprecation : depr($aggr),
				since : $aggr.attr("since") || null
			};
		});

		each($control, "associations/association", function($assoc) {
			oEntityDoc.associations[$assoc.attr("name")] = {
				kind : $assoc.attr("cardinality") === "0..n" ? 4 : 3,
				type : resolve($assoc.attr("type") || "sap.ui.core/Control", sEntityName),
				cardinality : $assoc.attr("cardinality") || "0..1",
				doc : doc($assoc),
				deprecation : depr($assoc),
				since : $assoc.attr("since") || null
			};
		});

		each($control, "events/event", function($event) {
			var sName = $event.attr("name");
			oEntityDoc.events[sName] = {
				kind : 5,
				doc : doc($event),
				deprecation : depr($event),
				since : $event.attr("since") || null,
				parameters : []
			};
			each($event, "parameters/parameter", function($param) {
				oEntityDoc.events[sName].parameters[$param.attr("name")] = {
					kind : 6,
					type : resolve($param.attr("type") || "string", sEntityName),
					doc : doc($param),
					since : $param.attr("since") || null,
					deprecation : depr($param)
				};
			});
		});

		each($control, "methods/method", function($method) {
			var sName = $method.attr("name");
			oEntityDoc.methods[sName] = {
				kind : 7,
				type : resolve($method.attr("type") || "sap.ui.core/void", sEntityName),
				doc : doc($method),
				deprecation : depr($method),
				since : $method.attr("since") || null,
				parameters : []
			};
			each($method, "parameters/parameter", function($param) {
				oEntityDoc.methods[sName].parameters.push({
					kind: 8,
					name : $param.attr("name"),
					type : resolve($param.attr("type") || "sap.ui.core/Control", sEntityName),
					doc : doc($param),
					since : $param.attr("since") || null,
					deprecation : depr($param)
				});
			});
		});

		return oEntityDoc;
	}

	function parseTypeMetamodel(oData, sEntityName) {

		var $type = jQuery(oData.documentElement);
		var oEntityDoc = {
			metatype : 'type',
			doc : undefined,
			deprecation : false,
			values : {}
		};

		oEntityDoc.doc = doc($type);
		oEntityDoc.deprecation = depr($type);

		each($type, "enumeration/value", function($value) {
			var sName = $value.attr("name");
			oEntityDoc.values[sName] = {
				value : $value.attr("value") || sName,
				doc : doc($value),
				deprecation : depr($value)
			};
		});

		oEntityDoc.pattern = $type.children("pattern").text();
		oEntityDoc.baseType = resolve($type.children("baseType").text(), sEntityName);

		return oEntityDoc;
	}

	function parseJavascript(oData, sEntityName, sModuleName) {

		// delegate Javascript parsing to ModuleAnalyzer
		return analyzer.analyze(oData, sEntityName, sModuleName);

	}

	function each($,sNames,fnCallback) {
		jQuery.each(sNames.split("/"), function(i,n) {
			$ = $.children(n);
		});
		$.each(function(i,e) {
			fnCallback(jQuery(e));
		});
	}

	function doc($) {
		return $.children("documentation").text();
	}

	function depr($) {
		return $.children("deprecation").text();
	}

	function load(sName, sType, sDataType, fnParser, sEntityName) {

		var oEntityDoc;

		jQuery.ajax({
			async: false,
			url : jQuery.sap.getModulePath(sName, sType),
			dataType : sDataType,
			success : function(vResponse) {
				oEntityDoc = fnParser(vResponse, sEntityName, sName.replace(/\./g,'/'));
			},
			error : function (err) {
				jQuery.sap.log.debug("tried to load entity docu for: " + sName + sType);
			}
		});

		return oEntityDoc;

	}

	function findLibraryFromEntityName(sEntityName) {
		var oVersionInfo = sap.ui.getVersionInfo(),
			oLibrary,
			iLen,
			i;

		if ( oVersionInfo && Array.isArray(oVersionInfo.libraries) ) {
			iLen = oVersionInfo.libraries.length;
			for (i = 0; i < iLen; i++) {
				oLibrary = oVersionInfo.libraries[i];
				if ( sEntityName === oLibrary.name || sEntityName.indexOf(oLibrary.name + ".") === 0 ) {
					return oLibrary.name;
				}
			}
		}

		// fallback to core (this ensures that the extraordinary packages of sap.ui.core are found, but doesn't work as
		// soon as other libs do the same)
		return "sap.ui.core";
	}

	function get(sEntityName, sLibraryName) {

		var oPackageInfo = getPackageInfo(sEntityName);
		var oEntityDoc;

		if (!sLibraryName) {
			var oClass = jQuery.sap.getObject(sEntityName);
			if (oClass && oClass.getMetadata) {
				var oMetadata = oClass.getMetadata();
				if (oMetadata.getLibraryName) {
					sLibraryName = oMetadata.getLibraryName();
				} else {
					sLibraryName = "sap.ui.core";
				}
			} else {
				sLibraryName = findLibraryFromEntityName(sEntityName);
			}
		}

		// api.json per library
		if ( !oEntityDoc && !oPackageInfo.__noAPIJson ) {
			var oEntityCollection = APIInfo.getLibraryElementsJSONSync(sLibraryName),
				oEntity;

			// Find single entity entry
			for (var i = 0, iLen = oEntityCollection.length; i < iLen; i++) {
				if (oEntityCollection[i].name === sEntityName) {
					oEntity = oEntityCollection[i];
					break;
				}
			}

			if (oEntity) {
				// Create oEntityDoc
				oEntityDoc = {
					baseType: oEntity.extends,
					deprecation: oEntity.deprecated ? oEntity.deprecated.text : null,
					doc: oEntity.description,
					module: oEntity.module,
					name: oEntity.name,
					since: oEntity.since,
					values: oEntity.properties
				};

				oPackageInfo.__noSource = true;
				oPackageInfo.__noMetamodel = true;
			}
		} else if ( oPackageInfo.__noAPIJson ) {
			jQuery.sap.log.debug("ancestor package for " + sEntityName + " is marked with 'noMetamodel'");
		}

		// legacy metamodel files
		if ( !oEntityDoc && !oPackageInfo.__noMetamodel ) {
			oEntityDoc = load(sEntityName, ".control", "xml", parseControlMetamodel, sEntityName);
			// If not a control try to load type
			if ( !oEntityDoc) {
				oEntityDoc = load(sEntityName, ".type", "xml", parseTypeMetamodel, sEntityName);
			}
			if ( !oEntityDoc ) {
				oEntityDoc = load(sEntityName, ".js", "text", parseJavascript, sEntityName);
			}
			if ( oEntityDoc ) {
				oPackageInfo.__noSource = true;
			}
		} else if ( oPackageInfo.__noMetamodel ) {
			jQuery.sap.log.debug("ancestor package for " + sEntityName + " is marked with 'noMetamodel'");
		}

		// source code analysis
		if ( !oEntityDoc && !oPackageInfo.noSource ) {
			var sLibrary = sEntityName.replace(/\.[^.]+$/, ".library");
			oEntityDoc = load(sLibrary, ".js", "text", parseJavascript, sEntityName);
			if ( !oEntityDoc ) {
				oEntityDoc = load(sLibrary, ".js", "text", parseJavascript, sEntityName);
			}
			if ( oEntityDoc ) {
				oPackageInfo.__noMetamodel = true;
			}
		} else if ( oPackageInfo.__noSource ) {
			jQuery.sap.log.debug("ancestor package for " + sEntityName + " is marked with 'noSource'");
		}

		return oEntityDoc;

	}

	return {

		getEntityDocu : function (sEntityName, sLibraryName) {
			return get(sEntityName, sLibraryName);
		}

	};

}, /* bExport= */ true);

}; // end of sap/ui/documentation/sdk/controller/util/EntityInfo.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.util.JSDocUtil') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides reuse functionality for reading documentation from api.json files (as created by the UI5 JSDoc3 template/plugin)
jQuery.sap.declare('sap.ui.documentation.sdk.controller.util.JSDocUtil'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.strings'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/util/JSDocUtil",['jquery.sap.strings'], function(jQuery) {

	"use strict";

	function defaultLinkFormatter(target, text) {
		return "<code>" + (text || target) + "</code>";
	}

	function format(src, options) {

		options = options || {};
		var beforeParagraph = options.beforeParagraph == null ? '<p>' : options.beforeParagraph;
		var afterParagraph = options.afterParagraph == null ? '</p>' : options.afterParagraph;
		var beforeFirstParagraph = options.beforeFirstParagraph == null ? beforeParagraph : options.beforeFirstParagraph;
		var afterLastParagraph = options.afterLastParagraph == null ? afterParagraph : options.afterLastParagraph;
		var linkFormatter = typeof options.linkFormatter === 'function' ? options.linkFormatter : defaultLinkFormatter;

		/*
		 * regexp to recognize important places in the text
		 *
		 * Capturing groups of the RegExp:
		 *   group 1: begin of a pre block
		 *   group 2: end of a pre block
		 *   group 3: begin of a header, implicitly ends a paragraph
		 *   group 4: end of a header, implicitly starts a new paragraph
		 *   group 5: target portion of an inline @link tag
		 *   group 6: (optional) text portion of an inline link tag
		 *   group 7: an empty line which implicitly starts a new paragraph
		 *
		 *      [-- <pre> block -] [---- some header ----] [---- an inline [@link ...} tag ----] [---------- an empty line ---------]  */
		var r = /(<pre>)|(<\/pre>)|(<h[\d+]>)|(<\/h[\d+]>)|\{@link\s+([^}\s]+)(?:\s+([^\}]*))?\}|((?:\r\n|\r|\n)[ \t]*(?:\r\n|\r|\n))/gi;
		var inpre = false;

		src = src || '';
		linkFormatter = linkFormatter || defaultLinkFormatter;

		src = beforeFirstParagraph + src.replace(r, function(match, pre, endpre, header, endheader, linkTarget, linkText, emptyline) {
			if ( pre ) {
				inpre = true;
			} else if ( endpre ) {
				inpre = false;
			} else if ( header ) {
				if ( !inpre ) {
					return afterParagraph + match;
				}
			} else if ( endheader ) {
				if ( !inpre ) {
					return match + beforeParagraph;
				}
			} else if ( emptyline ) {
				if ( !inpre ) {
					return afterParagraph + beforeParagraph;
				}
			} else if ( linkTarget ) {
				if ( !inpre ) {
					return linkFormatter(linkTarget, linkText);
				}
			}
			return match;
		}) + afterLastParagraph;

		// remove empty paragraphs
		src = src.replace(new RegExp(jQuery.sap.escapeRegExp(beforeParagraph) + "\s*" + jQuery.sap.escapeRegExp(afterParagraph), "g"), "");

		return src;
	}

	return {
		formatTextBlock: format
	};

});

}; // end of sap/ui/documentation/sdk/controller/util/JSDocUtil.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.util.TreeUtil') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Utility class that helps find the path to a specific node in a tree
 */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.util.TreeUtil'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/documentation/sdk/controller/util/TreeUtil",[],
	function () {
		"use strict";

		/**
		 * For the class to work, it needs to know what some information about the structure of the tree
		 * @param nodeIdField - what is the name of the field that holds the unique identifier of the node
		 * @param childrenField - what is the name of the field that holds the array with children for this node
		 * @constructor
		 */
		var TreeUtil = function (nodeIdField, childrenField) {
			this.nodeIdField = nodeIdField;
			this.childrenField = childrenField;
		};

		/**
		 * Returns an array, containing the ids of all nodes from "tree" leading to node "nodeId"
		 * @param nodeId - the destination node
		 * @param tree - the tree structure to search in
		 * @returns {Array}
		 */
		TreeUtil.prototype.getPathToNode = function (nodeId, tree) {
			var stack = [];
			this._walkTree(nodeId, tree, stack);
			return stack;
		};

		TreeUtil.prototype._walkTree = function (nodeId, tree, stack) {

			var found = this._findLeaf(tree, nodeId);
			if (found) {
				stack.push(nodeId);
				return true;
			}

			for (var i = 0; i < tree.length; i++) {
				if (tree[i][this.childrenField]) {
					stack.push(tree[i][this.nodeIdField]);
					if (this._walkTree(nodeId, tree[i][this.childrenField], stack)) {
						return true;
					}
					stack.pop();
				}
			}
		};

		TreeUtil.prototype._findLeaf = function (tree, nodeId) {
			for (var i = 0; i < tree.length; i++) {
				if (tree[i][this.nodeIdField] === nodeId) {
					return tree[i];
				}
			}
			return null;
		};

		return TreeUtil;

	});

}; // end of sap/ui/documentation/sdk/controller/util/TreeUtil.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.util.XML2JSONUtils') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.documentation.sdk.controller.util.XML2JSONUtils'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/util/XML2JSONUtils",['jquery.sap.global'],
	function(jQuery) {
		"use strict";

		function buildDocuJSON(xml, oConfig) {
			var xmlDom = xml2dom(xml, oConfig);
			var aSingles = ["topictitle1", "shortdesc"];

			var processSingleNode = function(className, xmlDOMObj) {
				var oXMLDOM = xmlDOMObj || xmlDom;
				var oNodes = oXMLDOM.getElementsByClassName(className);
				if (oNodes.length === 0) {
					return '';
				}
				var nodeText = jQuery("<div/>").html(removeHTMLTags(oNodes[0].innerHTML)).text();
				return oNodes && oNodes.length > 0 && ("innerHTML" in oNodes[0]) && nodeText || '';
			};

			var removeHTMLTags = function(txt) {
				return txt.replace(/<[^>]*>/g, " ")
						.replace(/\s{2,}/g, ' ');
			};

			/**
			 * Adjusts link href values
			 * @param element The DOM element which may contain cross reference links
			 */
			var fixLinks = function(element) {
				var links = element.querySelectorAll("a.xref, a.link, area"),
					i,
					link,
					href,
					startsWithHash,
					startsWithHTTP;

				for (i = 0; i < links.length; i++) {
					link = links[i];
					href = link.getAttribute("href");
					startsWithHash = href.indexOf("#") == 0;
					startsWithHTTP = href.indexOf("http") == 0;

					// absolute links should open in a new window
					if (startsWithHTTP) {
						link.setAttribute('target', '_blank');
					}
					// absolute links and links starting with # are ok and should not be modified
					if (startsWithHTTP || startsWithHash) {
						continue;
					}

					// API reference are recognized by "/docs/api/" string
					if (href.indexOf("/docs/api/") > -1) {
						href = href.substr(0, href.lastIndexOf(".html"));
						href = href.substr(href.lastIndexOf('/') + 1);
						href = "#/api/" + href;
					} else if (href.indexOf("explored.html") > -1) { // explored app links have explored.html in them
						href = href.split("../").join("");
						href = oConfig.exploredURI + href;
					} else { // we assume all other links are links to other documentation pages
						href = href.substr(0, href.lastIndexOf(".html"));
						href = "#/topic/" + href;
					}

					link.setAttribute("href", href);
				}
			};

			var fixImgLocation = function(element) {
				var images = element.querySelectorAll("img");

				for (var i = 0; i < images.length; i++) {
					images[i].setAttribute("src", oConfig.docuPath + images[i].getAttribute("src"));
				}

				return element.innerHTML;
			};

			var processSections = function() {
				/* "Invalid DOM Elements" (ones that should not be added to the body) are:
					- all scripts
					- element with class topictitle1 (this is used as title)
					- element with class shortdesc (this is used as subtitle)
					- element with id local-navigation (this is the left-side navigation which we already have)
					- element with tag header
					- element with id footer-container
					- element with id nav.mobile-nav
					- element with id breadcrumb-container
					- element with id content-toolbar (it contains info about the previous page)
					- element with class related-links (it contains the related links info and should have a custom position)
				 */
				var wrapperContainer = xmlDom,
					invalidChildren = wrapperContainer.querySelectorAll("script, .topictitle1, .shortdesc, #local-navigation, header, #footer-container, nav.mobile-nav, #breadcrumb-container, #content-toolbar"),
					invalidChildParent, i;

				for (var i = 0; i < invalidChildren.length; i++) {
					invalidChildParent = invalidChildren[i].parentElement;
					invalidChildParent.removeChild(invalidChildren[i]);
				}

				fixLinks(wrapperContainer);
				fixImgLocation(wrapperContainer);

				json['html'] =  wrapperContainer.innerHTML;
			};

			var json = {};
			aSingles.forEach(function(singleNode, idx){
				json[singleNode] = processSingleNode(singleNode);
			});

			processSections();

			return json;

		}

		function xml2dom(xml, oConfig) {
			var dom = jQuery.parseHTML(xml);
			var mainDivName = oConfig.topicHtmlMainDivId;
			for (var i = 0; i < dom.length; i++) {
				if (dom[i].getAttribute && dom[i].getAttribute("id") === mainDivName) {
					var newHTML = '<div id ="' + mainDivName + '">' + dom[i].innerHTML + '</div>';
					dom[i].innerHTML = newHTML;
					return dom[i];
				}
			}
		}

		return {
			DomXml2JSON : buildDocuJSON,
			XML2DOM: xml2dom,
			XML2JSON: buildDocuJSON
		};

	});
}; // end of sap/ui/documentation/sdk/controller/util/XML2JSONUtils.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controls.ParamText') ) {

/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.documentation.sdk.controls.ParamText'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.Text'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controls/ParamText",[
	'sap/m/Text'
], function(Text) {
	"use strict";

	/**
	 * @class
	 * Provides the parameters texts in the API Reference with a custom CSS class so that the texts are displayed indented.
	 * @extends sap.m.Text
	 */
	var ParamText = Text.extend("sap.ui.documentation.sdk.controls.ParamText", {
		metadata: {
			properties: {
				/**
				 * Defines the custom CSS class needed for the parameter's text in the tables.
				 */
				customClass : {type : "string", group : "Behavior", defaultValue : "sapUiDocumentationParamBold"}
			}
		},

		onAfterRendering: function () {
			this.$().addClass(this.getCustomClass());
		},

		renderer: Text.prototype.getRenderer().render
	});

	return ParamText;
});
}; // end of sap/ui/documentation/sdk/controls/ParamText.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controls.Search') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.documentation.sdk.controls.Search'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
jQuery.sap.require('sap.m.SearchField'); // unlisted dependency retained
jQuery.sap.require('sap.m.library'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controls/Search",['jquery.sap.global', 'sap/ui/core/Control', 'sap/m/Button', 'sap/m/SearchField', 'sap/m/library'],
    function(jQuery, Control, Button, SearchField, mobileLibrary) {
    "use strict";


        var Search = sap.ui.core.Control.extend("sap.ui.documentation.sdk.controls.Search", {
            metadata : {
                properties : {
                    isOpen : {type : "boolean", group : "Appearance", defaultValue : false},
                    width : {type : "sap.ui.core.CSSSize", group : "Appearance", defaultValue : null}
                },
                aggregations : {
                    _openingButton : {type: "sap.m.Button", multiple: false},
                    _closingButton : {type: "sap.m.Button", multiple: false},
                    _searchField : {type: "sap.m.SearchField", multiple: false}
                },
                events : {
                    /**
                     * Event which is fired when the user triggers a search.
                     */
                    toggle: {
                        isOpen: {type: "boolean"}
                    },
                    search: {
                        parameters: {

                            /**
                             * The search query string.
                             */
                            query: {type: "string"},

                            /**
                             * Suggestion list item in case if the user has selected an item from the suggestions list.
                             * @since 1.34
                             */
                            suggestionItem: {type: "sap.m.SuggestionItem"},

                            /**
                             * Indicates if the user pressed the refresh icon.
                             * @since 1.16
                             */
                            refreshButtonPressed: {type: "boolean"},
                            /**
                             * Indicates if the user pressed the clear icon.
                             * @since 1.34
                             */
                            clearButtonPressed: {type: "boolean"}
                        }
                    }
                }
            },
            renderer: function(rm, oControl) {

                var sWidth = oControl.getWidth(),
                    oOpeningBtn,
                    oClosingButton,
                    oSearchField;

                rm.write("<div");
                rm.writeControlData(oControl);
                if (sWidth) { rm.writeAttribute("style", "width:" + sWidth + ";"); }
                rm.addClass("sapUiDocumentationSearch");
                rm.writeClasses();
                rm.write(">");

                if (oControl.getIsOpen()) {
                    oSearchField = oControl._lazyLoadSearchField(true);
                    oClosingButton = oControl._lazyLoadClosingButton(true);
                    rm.renderControl(oSearchField);
                    rm.renderControl(oClosingButton);
                } else {
                    oOpeningBtn = oControl._lazyLoadOpeningButton(true);
                    rm.renderControl(oOpeningBtn);
                }
                rm.write("</div>");
            }
        });

        Search.prototype.onAfterRendering = function() {
            if (this.getIsOpen()) {
                this._maximizeSearchField();
            }
        };

        Search.prototype._maximizeSearchField = function() {
            return this._resizeSearchField("100%");
        };

        Search.prototype._minimizeSearchField = function() {
            return this._resizeSearchField("10%");
        };

        /**
         * Changes the size of the aggregated searchField input control
         * The size will be changed with an animation, as the css declares a transition for "max-width"
         * @private
         * @returns {Promise} promise that will be resolved when the requested size is achieved
         */
        Search.prototype._resizeSearchField = function(sWidth) {

            return new Promise(function(resolve, reject) {
                var $searchField = this.$("searchField");

                if (!$searchField.length) {
                    reject();
                }

                if ($searchField.css("max-width") === sWidth) {
                    resolve();
                }

                // the css declares a transition for "max-width", so resolve at transition end
                $searchField.one("webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend", function() {
                    resolve();
                });
                $searchField.css("max-width", sWidth);

            }.bind(this));
        };

        Search.prototype._toggleOpen = function(bOpen) {
            this.setIsOpen(bOpen);
            this.fireToggle({isOpen: bOpen});
        };

        Search.prototype._lazyLoadOpeningButton = function(bSuppressInvalidate) {
            if (!this.getAggregation("_openingButton")) {
                var oBtn = new Button(this.getId() + "-openingBtn", {
                    icon: "sap-icon://search",
                    type: mobileLibrary.ButtonType.Transparent,
                    press: function() {
                        this._toggleOpen(true);
                    }.bind(this)
                });
                oBtn.addStyleClass("sdkHeaderSearchButton"); //TODO
                this.setAggregation("_openingButton", oBtn, bSuppressInvalidate);
            }
            return this.getAggregation("_openingButton");
        };

        Search.prototype._lazyLoadClosingButton = function(bSuppressInvalidate) {
            if (!this.getAggregation("_closingButton")) {
                var oBtn = new Button(this.getId() + "-closingBtn", {
                    text: "Close", //TODO localize
                    type: mobileLibrary.ButtonType.Transparent,
                    press: function() {

                        this._minimizeSearchField().then(function() {
                            this._toggleOpen(false);
                        }.bind(this));

                    }.bind(this)
                });
                this.setAggregation("_closingButton", oBtn, bSuppressInvalidate);
            }
            return this.getAggregation("_closingButton");
        };

        Search.prototype._lazyLoadSearchField = function(bSuppressInvalidate) {
            if (!this.getAggregation("_searchField")) {
                var oSrch = new SearchField(this.getId() + "-searchField", {
                    showSearchButton: true,
                    search: function(oEvent) {

                        var oParameters = oEvent.getParameters();
                        oParameters.id = this.getId();
                        this.fireSearch(oParameters);
                    }.bind(this)
                });
                oSrch.addStyleClass("sdkHeaderSearchField");
                this.setAggregation("_searchField", oSrch, bSuppressInvalidate);
            }
            return this.getAggregation("_searchField");
        };

        return Search;
});
}; // end of sap/ui/documentation/sdk/controls/Search.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controls.TitleLink') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.documentation.sdk.controls.TitleLink'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.m.Toolbar'); // unlisted dependency retained
jQuery.sap.require('sap.m.Title'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controls/TitleLink",[
	'sap/ui/core/library',
	'sap/ui/Device',
	'sap/m/Toolbar',
	'sap/m/Title'
], function(coreLibrary, Device, Toolbar, Title) {
	"use strict";

	/**
	 * @class
	 * Adds link functionality and wrapping to the existing title control for display in the demo kit application
	 * @extends sap.m.Title
	 */
	var TitleLink = Title.extend("sap.ui.documentation.sdk.controls.TitleLink", {
		metadata: {
			properties: {
				/**
				 * Options are the standard values for window.open() supported by browsers: _self, _top, _blank, _parent, _search. Alternatively, a frame name can be entered. This property is only used when the href property is set.
				 */
				target : {type : "string", group : "Behavior", defaultValue : null},

				/**
				 * The link target URI. Supports standard hyperlink behavior. If a JavaScript action should be triggered, this should not be set, but instead an event handler for the "press" event should be registered.
				 */
				href : {type : "sap.ui.core.URI", group : "Data", defaultValue : null},

				/**
				 * Stores a text that can be different to the text property for filtering purposes
				 */
				filter : {type : "string", group : "Data", defaultValue : ""},

				/**
				 * If set to true, the text will wrap to multiple lines, if not it will truncate on a single line
				 */
				wrap : {type : "boolean", group : "Behavior", defaultValue : true}
			},
			events: {
				/**
				 * Event is fired when the user triggers the link control.
				 */
				press : {allowPreventDefault : true}
			}
		},

		init: function () {
			if (Device.support.touch) {
				this.ontap = this._handlePress;
			} else {
				this.onclick = this._handlePress;
			}

			/**
			 * Handles the touch event on mobile devices.
			 *
			 * @param {jQuery.Event} oEvent
			 */
			this.ontouchstart = function(oEvent) {
				if (this.getHref()) {
					// for controls which need to know whether they should handle events bubbling from here
					oEvent.setMarked();
				}
			};
		},

		/**
		 * Triggers link activation when space key is pressed on the focused control.
		 *
		 * @param {jQuery.Event} oEvent
		 */
		onsapspace : function(oEvent) {
			this._handlePress(oEvent); // this calls any JS event handlers
			// _handlePress() checks the return value of the event handler and prevents default if required or of the Link is disabled
			if (this.getHref() && !oEvent.isDefaultPrevented()) {
				// Normal browser link, the browser does the job. According to the keyboard spec, Space should do the same as Enter/Click.
				// To make the browser REALLY do the same (history, referrer, frames, target,...), create a new "click" event and let the browser "do the needful".

				// first disarm the Space key event
				oEvent.preventDefault(); // prevent any scrolling which the browser might do because from its perspective the Link does not handle the "space" key
				oEvent.setMarked();

				// then create the click event
				var oClickEvent = document.createEvent('MouseEvents');
				oClickEvent.initEvent('click' /* event type */, false, true); // non-bubbling, cancelable
				this.getDomRef().dispatchEvent(oClickEvent);
			}
		},

		/**
		 * Handler for the "press" event of the link.
		 *
		 * @param {jQuery.Event} oEvent
		 * @private
		 */
		_handlePress : function(oEvent) {
			oEvent.setMarked();

			if (!this.firePress() || !this.getHref()) { // fire event and check return value whether default action should be prevented
				oEvent.preventDefault();
			}
		},

		setHref : function(sUri){
			this.setProperty("href", sUri, true);
			sUri = this.getProperty("href");
			this.$().attr("href", sUri);
			return this;
		},

		setTarget : function(sTarget){
			this.setProperty("target", sTarget, true);
			if (!sTarget) {
				this.$().removeAttr("target");
			} else {
				this.$().attr("target", sTarget);
			}
			return this;
		},

		/**
		 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
		 * @param {sap.ui.core.RenderManager} oRm the RenderManager that can be used for writing to the Render-Output-Buffer
		 * @param {sap.ui.core.Control} oTitle an object representation of the control that should be rendered
		 */
		renderer: function (oRm, oTitle) {
			var oAssoTitle = oTitle._getTitle(),
				sLevel = (oAssoTitle ? oAssoTitle.getLevel() : oTitle.getLevel()) || coreLibrary.TitleLevel.Auto,
				bAutoLevel = sLevel == sap.ui.core.TitleLevel.Auto,
				sTag = bAutoLevel ? "div" : sLevel;

			oRm.write("<", sTag);
			oRm.writeControlData(oTitle);
			oRm.addClass("sapUiDocTitleLink");
			oRm.addClass("sapMTitle");
			oRm.addClass("sapMTitleStyle" + (oTitle.getTitleStyle() || coreLibrary.TitleLevel.Auto));
			oRm.addClass("sapUiSelectable");

			// adding wrap functionality begin
			if (oTitle.getWrap()) {
				oRm.addClass("wrap");
			} else {
				oRm.addClass("sapMTitleNoWrap");
			}
			// adding wrap functionality end

			var sWidth = oTitle.getWidth();
			if (!sWidth) {
				oRm.addClass("sapMTitleMaxWidth");
			} else {
				oRm.addStyle("width", sWidth);
			}

			var sTextAlign = oTitle.getTextAlign();
			if (sTextAlign && sTextAlign != sap.ui.core.TextAlign.Initial) {
				oRm.addClass("sapMTitleAlign" + sTextAlign);
			}

			if (oTitle.getParent() instanceof Toolbar) {
				oRm.addClass("sapMTitleTB");
			}

			var sTooltip = oAssoTitle ? oAssoTitle.getTooltip_AsString() : oTitle.getTooltip_AsString();
			if (sTooltip) {
				oRm.writeAttributeEscaped("title", sTooltip);
			}

			if (bAutoLevel) {
				oRm.writeAttribute("role", "heading");
			}

			oRm.writeClasses();
			oRm.writeStyles();

			oRm.write(">");

			// adding link functionality begin
			oRm.write("<a");
			oRm.addClass("sapMLnk");
			if (oTitle.getText()) {
				oRm.writeAttribute("tabIndex", "0");
			} else {
				oRm.writeAttribute("tabIndex", "-1");
			}
			oRm.writeAttributeEscaped("href", oTitle.getHref());
			if (oTitle.getTarget()) {
				oRm.writeAttributeEscaped("target", oTitle.getTarget());
			}
			oRm.writeClasses();
			oRm.write(">");
			// adding link functionality end

			oRm.write("<span");
			oRm.writeAttribute("id", oTitle.getId() + "-inner");
			oRm.write(">");
			oRm.writeEscaped(oAssoTitle ? oAssoTitle.getText() : oTitle.getText());
			oRm.write("</span></", sTag, ">");

			oRm.write("</a>");
		}
	});

	return TitleLink;
});
}; // end of sap/ui/documentation/sdk/controls/TitleLink.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.model.models') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.documentation.sdk.model.models'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/model/models",[
		"sap/ui/model/json/JSONModel",
		"sap/ui/Device"
	], function (JSONModel, Device) {
		"use strict";

		return {
			createDeviceModel : function () {
				var oModel = new JSONModel(Device);
				oModel.setDefaultBindingMode("OneWay");
				return oModel;
			}
		};

	}
);
}; // end of sap/ui/documentation/sdk/model/models.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.util.DocumentationRouter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides a customized router class for the 'documentation' app.
jQuery.sap.declare('sap.ui.documentation.sdk.util.DocumentationRouter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.m.routing.Router'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.routing.History'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/util/DocumentationRouter",[
	'jquery.sap.global',
	'sap/m/routing/Router',
	'sap/ui/core/routing/History'
], function (jQuery, Router, History) {
	"use strict";

	var DocumentationRouter = Router.extend("sap.ui.documentation.sdk.util.DocumentationRouter", {

		/**
		 * mobile nav back handling
		 */
		myNavBack: function (sRoute, oData) {
			var oHistory = History.getInstance();
			var oPrevHash = oHistory.getPreviousHash();
			if (oPrevHash !== undefined) {
				window.history.go(-1);
			} else {
				var bReplace = true; // otherwise we go backwards with a forward history
				this.navTo(sRoute, oData, bReplace);
			}
		},

		/**
		 * a nav to method that does not write hashes but load the views properly
		 */
		myNavToWithoutHash: function (viewName, viewType, master, data) {
			var oComponent = this._getOwnerComponent(),
				oRootView = oComponent.byId(oComponent.getManifestEntry("/sap.ui5/rootView").id),
				oApp = oRootView.byId("splitApp"),
				oView = this.getView(viewName, viewType);

			oApp.addPage(oView, master);
			oApp.toDetail(oView.getId(), "show", data);
		},

		/**
		 * Getter for the owner component
		 *
		 * <b>Note:</b> In the router we have no getter to retrieve the owner component. This should be improved in the
		 * future.
		 * @returns {sap.ui.core.UIComponent} Owner component of the router instance
		 * @private
		 */
		_getOwnerComponent: function () {
			return this._oOwner; // Accessing owner component from reference on the instance object.
		}
	});

	return DocumentationRouter;

}, /* bExport= */ true);

}; // end of sap/ui/documentation/sdk/util/DocumentationRouter.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.util.ToggleFullScreenHandler') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides a simple search feature
jQuery.sap.declare('sap.ui.documentation.sdk.util.ToggleFullScreenHandler'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/util/ToggleFullScreenHandler",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	var ToggleFullScreenHandler = {

		updateMode : function(oEvt, oView, oController) {
			var bSwitchToFullScreen = (this._getSplitApp(oController).getMode() === "ShowHideMode");
			if (bSwitchToFullScreen) {
				this._getSplitApp(oController).setMode('HideMode');
			} else {
				this._getSplitApp(oController).setMode('ShowHideMode');
			}
			this.updateControl(oEvt.getSource(), oView, bSwitchToFullScreen, oController);
		},


		_getSplitApp : function (oController) {
			if (!this._oSplitApp) {
				this._oSplitApp = oController.getSplitApp();
			}
			return this._oSplitApp;
		},

		updateControl : function (oButton, oView, bFullScreen, oController) {
			if (arguments.length === 2) {
				bFullScreen = !(this._getSplitApp(oController).getMode() === "ShowHideMode");
			}
			if (!bFullScreen) {
				oButton.setTooltip("Show this sample in full screen mode");
				oButton.setIcon('sap-icon://full-screen');
			} else {
				oButton.setTooltip("Show this sample in the detail view of a split container.");
				oButton.setIcon('sap-icon://exit-full-screen');
			}
		},

		cleanUp : function() {
			this._oSplitApp = null;
		}
	};

	return ToggleFullScreenHandler;

}, /* bExport= */ true);

}; // end of sap/ui/documentation/sdk/util/ToggleFullScreenHandler.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.demoapps.controller.App.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global Promise*/
jQuery.sap.declare('sap.ui.documentation.demoapps.controller.App.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageBox'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageToast'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.FilterOperator'); // unlisted dependency retained
jQuery.sap.require('sap.m.library'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/demoapps/controller/App.controller",[
	"sap/ui/core/mvc/Controller",
	"sap/ui/Device",
	"sap/ui/model/json/JSONModel",
	"jquery.sap.global",
	"sap/ui/documentation/demoapps/model/sourceFileDownloader",
	"sap/ui/documentation/demoapps/model/formatter",
	"sap/m/MessageBox",
	"sap/m/MessageToast",
	"sap/ui/model/Filter",
	"sap/ui/model/FilterOperator",
	"sap/m/library"
], function (Controller, Device, JSONModel, $, sourceFileDownloader, formatter, MessageBox, MessageToast, Filter, FilterOperator) {
	"use strict";

	return Controller.extend("sap.ui.documentation.demoapps.controller.App", {

		formatter: formatter,

		/* =========================================================== */
		/* event handlers                                              */
		/* =========================================================== */

		/**
		 * Called when the controller is instantiated.
		 * @public
		 */
		onInit: function() {
			var oVersionInfo = sap.ui.getVersionInfo(),
				oViewModel = new JSONModel({
					isOpenUI5: oVersionInfo && oVersionInfo.gav && /openui5/i.test(oVersionInfo.gav)
				});

			this.getView().setModel(oViewModel, "appView");

			// manually call the handler once at startup as device API won't do this for us
			this._onOrientationChange({
				landscape: Device.orientation.landscape
			});
			this._onResize({
				name: (Device.resize.width <= 600 ? "Phone" : "NoPhone")
			});
		},

		/**
		 * Called before the view is rendered.
		 * @public
		 */
		onBeforeRendering: function() {
			this._deregisterOrientationChange();
		},

		/**
		 * Called after the view is rendered.
		 * @public
		 */
		onAfterRendering: function() {
			this._registerOrientationChange();
			this._registerResize();
		},

		/**
		 * Called when the controller is destroyed.
		 * @public
		 */
		onExit: function() {
			this._deregisterOrientationChange();
			this._deregisterResize();
		},

		/**
		 * Registers an event listener on device orientation change
		 * @private
		 */
		_registerOrientationChange: function () {
			Device.orientation.attachHandler(this._onOrientationChange, this);
		},

		/**
		 * Deregisters the event listener for device orientation change
		 * @private
		 */
		_deregisterOrientationChange: function () {
			Device.media.detachHandler(this._onOrientationChange, this);
		},

		/**
		 * Registers an event listener on device resize
		 * @private
		 */
		_registerResize: function () {
			Device.media.attachHandler(this._onResize, this);
		},

		/**
		 * Deregisters the event listener for device resize
		 * @private
		 */
		_deregisterResize: function () {
			Device.orientation.detachHandler(this._onResize, this);
		},

		/**
		 * Switches the maximum height of the phone image for optimal display in landscape mode
		 * @param {sap.ui.base.Event} oEvent Device orientation change event
		 * @private
		 */
		_onOrientationChange: function(oEvent) {
			this.byId("phoneImage").toggleStyleClass("phoneHeaderImageLandscape", oEvent.landscape);
		},

		/**
		* Switches the image to phone and hides the download icon when decreasing the window size
		* @param {sap.ui.base.Event} oEvent Device media change event
		* @private
		*/
		_onResize: function(oEvent) {
			this.byId("phoneImage").setVisible(oEvent.name === "Phone");
			this.byId("desktopImage").setVisible(oEvent.name !== "Phone");
			this.byId("phoneImage").toggleStyleClass("phoneHeaderImageDesktop", oEvent.name === "Phone");
		},

		/**
		 * Opens the download dialog
		 * @param {sap.ui.base.Event} oEvent the Button press event
		 * @public
		 */
		onDownloadButtonPress: function (oEvent) {
			var oDownloadDialog = this.byId("downloadDialog");
			this._oDownloadButton = oEvent.getSource();

			oDownloadDialog.getBinding("items").filter([]);
			oDownloadDialog.open();
			// hack: override of the SelectDialog's internal dialog height
			oDownloadDialog._oDialog.setContentHeight("");
		},

		/**
		 * Filters the download dialog
		 * @param {sap.ui.base.Event} oEvent the SearchField liveChange event
		 * @public
		 */
		onSearch: function (oEvent) {
			oEvent.getParameters().itemsBinding.filter([
				new Filter("name", FilterOperator.Contains, oEvent.getParameters().value)
			]);
		},

		/**
		 * Downloads a demo app
		 * @param {sap.ui.base.Event} oEvent the Button press event
		 * @public
		 */
		onDownloadPress: function (oEvent) {
			var oSelectedItem = oEvent.getParameters().selectedItem,
				oListItem = oSelectedItem ? oSelectedItem : oEvent.getSource().getParent();

			this._oDownloadButton.setBusy(true);
			sap.ui.require([
				"sap/ui/core/util/File",
				"sap/ui/thirdparty/jszip"
			], function (File, JSZip) {
				var oZipFile = new JSZip();

				// load the config file from the custom data attached to the list item
				$.getJSON(oListItem.data("config"), function (oConfig) {
					var aFiles = oConfig.files,
						aPromises = [],
						aFails = [];

					// add extra download files
					aFiles.forEach(function(sFilePath) {
						var oPromise = sourceFileDownloader(oConfig.cwd + sFilePath);

						oPromise.then(function (oContent) {
							if (oContent.errorMessage) {
								// promise gets resolved in error case since Promise.all will not wait for all fails
								aFails.push(oContent.errorMessage);
							} else {
								oZipFile.file(sFilePath, oContent, { base64: false, binary: true });
							}
						});
						aPromises.push(oPromise);
					});

					Promise.all(aPromises).then(function () {
						// collect errors and show them
						if (aFails.length) {
							var sCompleteErrorMessage = aFails.reduce(function (sErrorMessage, sError) {
								return sErrorMessage + sError + "\n";
							}, "Could not locate the following download files:\n");
							this._handleError(sCompleteErrorMessage);
						}

						// show success message
						this._oDownloadButton.setBusy(false);
						MessageToast.show("Downloading for app \"" + oListItem.getLabel() + "\" has been started");

						// still make the available files ready for download
						var oContent = oZipFile.generate({type:"blob"});
						this._createArchive(File, oContent, oListItem.getLabel());
					}.bind(this));
				}.bind(this));
			}.bind(this));
		},

		/* =========================================================== */
		/* lifecycle methods                                           */
		/* =========================================================== */

		/**
		 * Factory function for creating the demo app cells
		 *
		 * @param {string} sId the id for the current cell
		 * @param {sap.ui.model.Context} oBindingContext the context for the current cell
		 * @return {sap.ui.layout.BlockLayoutCell} either a header cell or a demo app cell based on the metadata in the model
		 * @public
		 */
		createDemoAppRow: function (sId, oBindingContext) {
			var oBlockLayoutCell;
			if (!oBindingContext.getObject().categoryId) { // demo app tile
				if (oBindingContext.getObject().teaser) { // teaser cell (loads fragment from demo app)
					try {
						jQuery.sap.registerResourcePath("test-resources","test-resources");
						var sRelativePath = jQuery.sap.getResourcePath(oBindingContext.getObject().teaser);
						var oTeaser = sap.ui.xmlfragment(sId, sRelativePath);
						oBlockLayoutCell = sap.ui.xmlfragment(sId, "sap.ui.documentation.demoapps.view.BlockLayoutTeaserCell", this);
						oBlockLayoutCell.getContent()[0].addContent(oTeaser);
						jQuery.sap.registerResourcePath("test-resources",null);
					} catch (oException) {
						jQuery.sap.log.warning("Teaser for demo app \"" + oBindingContext.getObject().name + "\" could not be loaded: " + oException);
						oBlockLayoutCell = sap.ui.xmlfragment(sId, "sap.ui.documentation.demoapps.view.BlockLayoutCell", this);
					}
				} else { // normal cell
					oBlockLayoutCell = sap.ui.xmlfragment(sId, "sap.ui.documentation.demoapps.view.BlockLayoutCell", this);
				}
			} else { // headline tile
				oBlockLayoutCell = sap.ui.xmlfragment(sId, "sap.ui.documentation.demoapps.view.BlockLayoutHeadlineCell", this);
			}
			oBlockLayoutCell.setBindingContext(oBindingContext);

			return oBlockLayoutCell;
		},

		/* =========================================================== */
		/* helper methods                                              */
		/* =========================================================== */

		/**
		 * Archive creation function that can be stubbed easily in tests
		 * @param {object} File the jszip file handle
		 * @param {object} oContent the blob for the zip file
		 * @param {string} sFilename the file name
		 * @private
		 */
		_createArchive: function (File, oContent, sFilename) {
			File.save(oContent, sFilename, "zip", "application/zip");
		},

		/**
		 * Error handler function that can be stubbed easily in tests
		 * @param {string} sError the error message
		 * @private
		 */
		_handleError: function (sError) {
			MessageBox.error(sError);
		},

		/**
		 * Handles landing image load event and makes landing image headline visible
		 * when the image has loaded.
		 */
		handleLandingImageLoad: function () {
			this.getView().byId("landingImageHeadline").setVisible(true);
		}
	});
});

}; // end of sap/ui/documentation/demoapps/controller/App.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.demoapps.model.libraryData') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.documentation.demoapps.model.libraryData'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/demoapps/model/libraryData",[
	'jquery.sap.global',
	'sap/ui/documentation/library'
],function (jQuery, library) {
	"use strict";

	// function to compute the app objects for a demo object
	function createDemoAppData(oDemoAppMetadata, sLibUrl, sLibNamespace) {
		// transform simple demo app link to a configuration object
		var aLinks = [];
		// transform link object to a bindable array of objects
		if (jQuery.isPlainObject(oDemoAppMetadata.links)) {
			aLinks = Object.keys(oDemoAppMetadata.links).map(function (sKey) {
				return {
					name: sKey,
					ref: oDemoAppMetadata.links[sKey]
				};
			});
		}

		var oApp = {
			lib : oDemoAppMetadata.namespace || sLibNamespace,
			name : oDemoAppMetadata.text,
			icon : oDemoAppMetadata.icon,
			desc : oDemoAppMetadata.desc,
			config : oDemoAppMetadata.config,
			teaser : oDemoAppMetadata.teaser,
			category : oDemoAppMetadata.category,
			ref : (oDemoAppMetadata.resolve === "lib" ? sLibUrl : "") + oDemoAppMetadata.ref,
			links : aLinks
		};

		return oApp;
	}

	/**
	 * Creates a JSON model structure for both all demo apps in a flat list and demo apps by category
	 * Each library contains a metadata section for demo apps with the following structure (example):
	 * demo: {
	 * 	text: "sap.m", // legacy entry, name of the library
	 * 	links: {
	 *		icon: an index of the icon font
	 *		text: the name of the app
	 *		description: a short description text
	 *		ref: a link to the demo app entry point
	 *		links: an object of links with a key (title) and value (link) each
	 *		category: one of the demo app categories (Showcase/Tool/Tutorial/Template/RTA/Misc)
	 *		config: the URL to the demo app configuration for downloading the app
	 * 	}
	 *
	 * Under path /demoApps the following properties can be found: lib, name, icon, desc, type, ref
	 * Under path /demoApps by category the apps are structured by the entry "category" and grouped in batches
	 * of 4 items so that they can be bound to the BlockLayoutRow control directly
	 * @param {array} aLibs an array of the currently loaded UI5 libraries
	 * @param {object} oDocIndicies an object of the currently loaded UI5 library docu metadata
	 * @private
	 */
	function createModelData (aLibs, oDocIndicies) {
		// generate the global model structure
		var aCategories = ["Showcase", "Tool", "Tutorial", "Template", "RTA", "Misc"];
		var oDemoAppsByCategory = {};

		// create a helper structure for demo apps by category
		aCategories.forEach(function (sCategoryName) {
			oDemoAppsByCategory[sCategoryName] = [];
		});

		// create a model structure that can be bound in the view
		var oData = {
			// all demo apps in the order they were read by the metadata
			demoApps: [],
			// generated rows and cells matching for for the BlockLayout
			demoAppsByCategory: []
		};

		// loop over all libraries and add model data for each demo app
		for (var i = 0; i < aLibs.length; i++) {
			var oDemo = oDocIndicies[aLibs[i]].demo;
			if (!oDemo) {
				continue;
			}

			if (oDemo.links && oDemo.links.length > 0) {
				for (var j = 0; j < oDemo.links.length; j++) {
					var oDemoAppData = createDemoAppData(oDemo.links[j], oDocIndicies[aLibs[i]].libraryUrl, oDemo.text);
					oData.demoApps.push(oDemoAppData);

					// push demo app into helper structure
					if (aCategories.indexOf(oDemoAppData.category) < 0) {
						jQuery.sap.log.warning("Demo app category \"" + oDemoAppData.category + "\" not found, correcting demo app \"" + oDemoAppData.name + "\" to \"Misc\"");
						oDemoAppData.category = "Misc";
					}
					oDemoAppsByCategory[oDemoAppData.category].push(oDemoAppData);
				}
			}
		}

		// create a structure in the model data that can be bound to the block layout (an array of rows)
		// each row contains an array with a headline or a maximum of 4 demo apps
		Object.keys(oDemoAppsByCategory).forEach(function (sKey) {
			// early out if category is empty
			if (oDemoAppsByCategory[sKey].length === 0) {
				return;
			}

			// push a row for the headline
			oData.demoAppsByCategory.push([{
				categoryId : sKey
			}]);
			// push n rows for the demo apps itself (start a new row every 4 cells)
			var iCurrentLength = oData.demoAppsByCategory.push([]);
			var iCellCounter = 0;
			for (var i = 0; i < oDemoAppsByCategory[sKey].length; i++) {
				iCellCounter++;
				if (oDemoAppsByCategory[sKey][i].teaser) { // teaser apps take two cells
					iCellCounter++;
				}
				if (iCellCounter > 4) {
					iCurrentLength = oData.demoAppsByCategory.push([]);
					iCellCounter = 0;
				}
				oData.demoAppsByCategory[iCurrentLength - 1].push(oDemoAppsByCategory[sKey][i]);
			}
		});

		return oData;
	}

	return {
		/**
		 * Fills a JSON model with the demo apps metadata of all available libraries
		 * under path /demoApps the following properties can be found: lib, name, icon, desc, config, category, refs
		 * @param {sap.ui.model.json.JSONModel} oModel the helper JSON model passed in as a reference
		 * @public
		 */
		fillJSONModel: function (oModel) {
			function fnHandleLibInfoLoaded  (aLibs, oDocIndicies) {
				oModel.setProperty("/bFooterVisible", true);
				if (!aLibs) {
					return;
				}

				// set model
				var oModelData = oModel.getData();
				oModel.setData(jQuery.extend(oModelData, createModelData(aLibs, oDocIndicies)));
			}

			// load and process all lib info
			oModel.setProperty("/bFooterVisible", false);
			library._loadAllLibInfo("", "_getDocuIndex", fnHandleLibInfoLoaded);
		}
	};


});

}; // end of sap/ui/documentation/demoapps/model/libraryData.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.Component') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.documentation.sdk.Component'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.UIComponent'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.m.ColumnListItem'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/Component",[
		"sap/ui/core/UIComponent",
		"sap/ui/Device",
		"sap/ui/documentation/sdk/model/models",
		"sap/ui/documentation/sdk/controller/ErrorHandler",
		"sap/ui/model/json/JSONModel",
		"sap/ui/documentation/sdk/util/DocumentationRouter",
		"sap/ui/documentation/sdk/controller/util/ConfigUtil",
		"sap/ui/documentation/sdk/controller/util/APIInfo",
		"sap/m/ColumnListItem"
	], function (UIComponent, Device, models, ErrorHandler, JSONModel, DocumentationRouter, ConfigUtil, APIInfo, ColumnListItem) {
		"use strict";

		var aTreeContent = [],
			oLibsData = {},
			iTreeModelLimit = 1000000;

		return UIComponent.extend("sap.ui.documentation.sdk.Component", {

			metadata : {
				manifest : "json",
				includes : [
					"css/style.css",
					"thirdparty/google-code-prettify/prettify.css",
					"thirdparty/google-code-prettify/prettify.js",
					"thirdparty/google-code-prettify/lang-css.js"
				]
			},

			/**
			 * The component is initialized by UI5 automatically during the startup of the app and calls the init method once.
			 * In this method, the device models are set and the router is initialized.
			 * @public
			 * @override
			 */
			init : function () {

				// This promise will be resolved when the api-based models (libsData, treeData) have been loaded
				this._modelsPromise = null;

				this._oErrorHandler = new ErrorHandler(this);

				// set the device model
				this.setModel(models.createDeviceModel(), "device");

				// set the global tree data
				this.setModel(new JSONModel(), "treeData");

				// set the global libs data
				this.setModel(new JSONModel(), "libsData");

				// call the base component's init function and create the App view
				UIComponent.prototype.init.apply(this, arguments);

				// create the views based on the url/hash
				this.getRouter().initialize();

				// Preload API Info on desktop for faster startup
				if (Device.system.desktop) {
					this.fetchAPIInfoAndBindModels();
				}

				// Prevents inappropriate focus change which causes ObjectPage to scroll,
				// thus text can be selected and copied
				sap.m.TablePopin.prototype.onfocusin = function () {};
			},

			/**
			 * The component is destroyed by UI5 automatically.
			 * In this method, the ListSelector and ErrorHandler are destroyed.
			 * @public
			 * @override
			 */
			destroy : function () {
				this._oErrorHandler.destroy();
				this._oConfigUtil.destroy();
				this._oConfigUtil = null;
				// call the base component's destroy function
				UIComponent.prototype.destroy.apply(this, arguments);
			},

			/**
			 * This method can be called to determine whether the sapUiSizeCompact or sapUiSizeCozy
			 * design mode class should be set, which influences the size appearance of some controls.
			 * @public
			 * @return {string} css class, either 'sapUiSizeCompact' or 'sapUiSizeCozy' - or an empty string if no css class should be set
			 */
			getContentDensityClass : function() {
				if (this._sContentDensityClass === undefined) {
					// check whether FLP has already set the content density class; do nothing in this case
					if (jQuery(document.body).hasClass("sapUiSizeCozy") || jQuery(document.body).hasClass("sapUiSizeCompact")) {
						this._sContentDensityClass = "";
					} else if (!Device.support.touch) { // apply "compact" mode if touch is not supported
						this._sContentDensityClass = "sapUiSizeCompact";
					} else {
						// "cozy" in case of touch support; default for most sap.m controls, but needed for desktop-first controls like sap.ui.table.Table
						this._sContentDensityClass = "sapUiSizeCozy";
					}
				}
				return this._sContentDensityClass;
			},
			getConfigUtil: function() {
				if (!this._oConfigUtil) {
					this._oConfigUtil = new ConfigUtil(this);
				}
				return this._oConfigUtil;
			},


			// MODELS

			fetchAPIInfoAndBindModels: function () {

				if (this._modelsPromise) {
					return this._modelsPromise;
				}

				this._modelsPromise = new Promise(function (resolve) {
					APIInfo.getAllLibrariesElementsJSONPromise().then(function(aLibsData) {
						aLibsData.forEach(this._parseLibraryElements, this);

						if (aTreeContent.length > 0) {
							aTreeContent.push({
								isSelected: false,
								name : "experimental",
								ref: "#/api/experimental",
								text: "Experimental APIs"
							}, {
								isSelected: false,
								name : "deprecated",
								ref: "#/api/deprecated",
								text: "Deprecated APIs"
							});
						}

						this._addDeprecatedAndExperimentalData(oLibsData);

						this._bindAllLibsModel(oLibsData);
						this._bindTreeModel(aTreeContent);
						resolve();
					}.bind(this));
				}.bind(this));

				return this._modelsPromise;
			},

			isInternalVersion : function() {
				return /internal/i.test(sap.ui.getVersionInfo().name);
			},

			_parseLibraryElements : function (aLibraryElementsJSON) {

				for (var i = 0; i < aLibraryElementsJSON.length; i++) {
					if (!aLibraryElementsJSON[i].children) {
						oLibsData[aLibraryElementsJSON[i].name] = aLibraryElementsJSON[i];
					}

					this._addElementToTreeData(aLibraryElementsJSON[i]);

					if (aLibraryElementsJSON[i].children) {
						this._parseLibraryElements(aLibraryElementsJSON[i].children, true);
					}
				}
			},

			_addElementToTreeData : function (oJSONElement) {
				if (oJSONElement.visibility === "public") {
					if (oJSONElement.kind !== "namespace") {
						var oTreeNode = this._createTreeNode(oJSONElement.basename, oJSONElement.name, oJSONElement.name === this._topicId);
						var sNodeNamespace = oJSONElement.name.substring(0, (oJSONElement.name.indexOf(oJSONElement.basename) - 1));
						var oExistingNodeNamespace = this._findNodeNamespaceInTreeStructure(sNodeNamespace);
						if (oExistingNodeNamespace) {
							if (!oExistingNodeNamespace.nodes) {
								oExistingNodeNamespace.nodes = [];
							}
							oExistingNodeNamespace.nodes.push(oTreeNode);
						} else {
							var oNewNodeNamespace = this._createTreeNode(sNodeNamespace, sNodeNamespace, sNodeNamespace === this._topicId);
							oNewNodeNamespace.nodes = [];
							oNewNodeNamespace.nodes.push(oTreeNode);
							aTreeContent.push(oNewNodeNamespace);

							this._removeDuplicatedNodeFromTree(sNodeNamespace);
						}
					} else {
						var oNewNodeNamespace = this._createTreeNode(oJSONElement.name, oJSONElement.name, oJSONElement.name === this._topicId );
						aTreeContent.push(oNewNodeNamespace);
					}
				}
			},

			_createTreeNode : function (text, name, isSelected) {
				var oTreeNode = {};
				oTreeNode.text = text;
				oTreeNode.name = name;
				oTreeNode.ref = "#/api/" + name;
				oTreeNode.isSelected = isSelected;
				return oTreeNode;
			},

			_findNodeNamespaceInTreeStructure : function (sNodeNamespace, aTreeStructure) {
				aTreeStructure = aTreeStructure || aTreeContent;
				for (var i = 0; i < aTreeStructure.length; i++) {
					var oTreeNode = aTreeStructure[i];
					if (oTreeNode.name === sNodeNamespace) {
						return oTreeNode;
					}
					if (oTreeNode.nodes) {
						var oChildNode = this._findNodeNamespaceInTreeStructure(sNodeNamespace, oTreeNode.nodes);
						if (oChildNode) {
							return oChildNode;
						}
					}
				}
			},

			_removeNodeFromNamespace : function (sNode, oNamespace) {
				for (var i = 0; i < oNamespace.nodes.length; i++) {
					if (oNamespace.nodes[i].text === sNode) {
						oNamespace.nodes.splice(i, 1);
						return;
					}
				}
			},

			_removeDuplicatedNodeFromTree : function (sNodeFullName) {
				if (oLibsData[sNodeFullName]) {
					var sNodeNamespace = sNodeFullName.substring(0, sNodeFullName.lastIndexOf("."));
					var oNamespace = this._findNodeNamespaceInTreeStructure(sNodeNamespace);
					var sNode = sNodeFullName.substring(sNodeFullName.lastIndexOf(".") + 1, sNodeFullName.lenght);
					this._removeNodeFromNamespace(sNode, oNamespace);
				}
			},


			_bindAllLibsModel : function (oAllLibsData) {
				var oLibsModel = this.getModel("libsData");
				oLibsModel.setSizeLimit(iTreeModelLimit);
				oLibsModel.setData(oAllLibsData, false /* mo merge with previous data */);
			},

			_bindTreeModel : function (aTreeContent) {
				var treeModel = this.getModel("treeData");
				treeModel.setSizeLimit(iTreeModelLimit);
				treeModel.setData(aTreeContent, false);
			},

			_addDeprecatedAndExperimentalData : function(oLibsData) {
				var sWithoutVersion = "Without Version",
					bIsInternalVersion = this.isInternalVersion();

				oLibsData.deprecated = {
					noVersion : {
						name : sWithoutVersion,
						apis : []
					}
				};

				oLibsData.experimental = {
					noVersion : {
						name : sWithoutVersion,
						apis : []
					}
				};

				/**
				 * @param {String} oDataType - "deprecated" or "experimental"
				 * @param {Object} oEntityObject - the object which contains the data
				 * @param {String} sObjectType - "method" or "event"
				 * @param {String} sSymbolName - the name of the class or namespace to which the data is relevant
				 */
				function addData(oDataType, oEntityObject, sObjectType, sSymbolName) {
					var oData = {
						control : sSymbolName,
						entityName : oEntityObject.name,
						text : oEntityObject[oDataType].text || oEntityObject.description,
						type : sObjectType,
						"static" : !!oEntityObject.static
					};

					if (oEntityObject[oDataType].since) {
						var aSince = oEntityObject[oDataType].since.split(".");
						var sVersion = aSince[0] + "." + aSince[1]; // take only major and minor versions

						oData.since = oEntityObject[oDataType].since;

						if (!oLibsData[oDataType][sVersion]) {
							oLibsData[oDataType][sVersion] = {
								name : sVersion,
								apis : []
							};
						}

						oLibsData[oDataType][sVersion].apis.push(oData);
					} else {
						oLibsData[oDataType].noVersion.apis.push(oData);
					}
				}

				/* Iterate over the oLibsData object, gather information about all deprecated and experimental
				entities and aggregate it in new properties in oLibsData.
				 */
				Object.keys(oLibsData).forEach(function(sLibName) {
					var sLib = oLibsData[sLibName];

					sLib.methods && sLib.methods.forEach(function(oMethod) {
						var bIsMethodRestricted = oMethod.visibility === "restricted";

						if (bIsMethodRestricted && !bIsInternalVersion) {
							return; /* exclude restricted methods from non-internal version */
						}

						if (oMethod.deprecated) {
							addData("deprecated", oMethod, "methods", sLib.name);
						}

						if (oMethod.experimental) {
							addData("experimental", oMethod, "methods", sLib.name);
						}
					});

					sLib.events && sLib.events.forEach(function(oEvent) {
						if (oEvent.deprecated) {
							addData("deprecated", oEvent, "events", sLib.name);
						}

						if (oEvent.experimental) {
							addData("experimental", oEvent, "events", sLib.name);
						}
					});
				});
			}
		});
	}
);
}; // end of sap/ui/documentation/sdk/Component.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.BaseController') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global history */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.BaseController'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.routing.History'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/BaseController",[
		"sap/ui/documentation/library",
		"sap/ui/core/mvc/Controller",
		"sap/ui/core/routing/History",
		"sap/ui/documentation/sdk/controller/util/ControlsInfo",
		"sap/ui/documentation/sdk/controller/util/JSDocUtil",
		"sap/ui/Device"
	], function (library, Controller, History, ControlsInfo, JSDocUtil, Device) {
		"use strict";

		return Controller.extend("sap.ui.documentation.sdk.controller.BaseController", {

			// Prerequisites
			_oCore: sap.ui.getCore(),

			hideMasterSide : function() {
				var splitApp = this.getSplitApp();
				splitApp.setMode(sap.m.SplitAppMode.HideMode);
			},

			showMasterSide : function() {
				var splitApp = this.getSplitApp();
				splitApp.setMode(sap.m.SplitAppMode.ShowHideMode);
			},

			getSplitApp: function() {
				return this.getView().getParent().getParent();
			},

			/**
			 * Convenience method for accessing the router in every controller of the application.
			 * @public
			 * @returns {sap.ui.core.routing.Router} the router for this component
			 */
			getRouter : function () {
				return this.getOwnerComponent().getRouter();
			},

			/**
			 * Convenience method for getting the view model by name in every controller of the application.
			 * @public
			 * @param {string} sName the model name
			 * @returns {sap.ui.model.Model} the model instance
			 */
			getModel : function (sName) {
				return this.getView().getModel(sName);
			},

			/**
			 * Convenience method for setting the view model in every controller of the application.
			 * @public
			 * @param {sap.ui.model.Model} oModel the model instance
			 * @param {string} sName the model name
			 * @returns {sap.ui.mvc.View} the view instance
			 */
			setModel : function (oModel, sName) {
				return this.getView().setModel(oModel, sName);
			},

			/**
			 * Convenience method for getting the application configuration located in manifest.json.
			 * @public
			 * @returns {object} the configuration of the component
			 */
			getConfig : function () {
				return this.getOwnerComponent().getMetadata().getConfig();
			},

			/**
			 * Event handler  for navigating back.
			 * It checks if there is a history entry. If yes, history.go(-1) will happen.
			 * If not, it will replace the current entry of the browser history with the master route.
			 * @public
			 */
			onNavBack : function(event) {
				var sPreviousHash = History.getInstance().getPreviousHash();

				if (sPreviousHash !== undefined) {
					// The history contains a previous entry
					history.go(-1);
				} else {
					var sCurrentHash = window.location.hash;

					if (sCurrentHash.indexOf("#/topic/") == 0) {
						this.getRouter().navTo("topic", {}, true);
					} else if (sCurrentHash.indexOf("#/api/") == 0) {
						this.getRouter().navTo("api", {}, true);
					}
				}
			},

			searchResultsButtonVisibilitySwitch : function(oButton) {
				var sPreviousHash = History.getInstance().getPreviousHash();
				if (sPreviousHash && sPreviousHash.indexOf("search/") === 0) {
					oButton.setVisible(true);
				} else {
					oButton.setVisible(false);
				}
			},

			/**
			 * Getter for the application root view
			 * @return {sap.ui.core.mvc.View} Application root view
			 */
			getRootView: function () {
				var oComponent = this.getOwnerComponent();
				return oComponent.byId(oComponent.getManifestEntry("/sap.ui5/rootView").id);
			},

			/**
			 * Retrieves the actual component for the control.
			 * @param {string} sControlName
			 * @return {string} the actual component
			 */
			_getControlComponent: function (sControlName, oControlsData) {
				var oLibComponentModel = oControlsData.libComponentInfos,
					oLibInfo = library._getLibraryInfoSingleton();
				return oLibInfo._getActualComponent(oLibComponentModel, sControlName);
			},

			/**
			 * This function wraps a text in a span tag so that it can be represented in an HTML control.
			 * @param {string} sText
			 * @returns {string}
			 * @private
			 */
			_wrapInSpanTag: function (sText) {

				var sFormattedTextBlock = JSDocUtil.formatTextBlock(sText, {
					linkFormatter: function (target, text) {

						var p;

						// If the link has a protocol, do not modify, but open in a new window
						if (target.match("://")) {
							return '<a target="_blank" href="' + target + '">' + (text || target) + '</a>';
						}

						target = target.trim().replace(/\.prototype\./g, "#");
						p = target.indexOf("#");
						if ( p === 0 ) {
							// a relative reference - we can't support that
							return "<code>" + target.slice(1) + "</code>";
						}

						if ( p > 0 ) {
							text = text || target; // keep the full target in the fallback text
							target = target.slice(0, p);
						}

						return "<a class=\"jsdoclink\" href=\"javascript:void(0);\" data-sap-ui-target=\"" + target + "\">" + (text || target) + "</a>";

					}
				});

				return '<span class="sapUiDocumentationJsDoc">' + sFormattedTextBlock + '</span>';
			},

			/**
			 * Switches the maximum height of the phone image for optimal display in landscape mode
			 * @param {sap.ui.base.Event} oEvent Device orientation change event
			 * @private
			 */
			_onOrientationChange: function(oEvent) {
				if (Device.system.phone) {
					this.byId("phoneImage").toggleStyleClass("phoneHeaderImageLandscape", oEvent.landscape);
				}
			},

			/**
			 * Registers an event listener on device orientation change
			 * @private
			 */
			_registerOrientationChange: function () {
				Device.orientation.attachHandler(this._onOrientationChange, this);
			},

			/**
			 * Deregisters the event listener for device orientation change
			 * @private
			 */
			_deregisterOrientationChange: function () {
				Device.orientation.detachHandler(this._onOrientationChange, this);
			},

			/**
			 * Handles landing image load event and makes landing image headline visible
			 * when the image has loaded.
			 */
			handleLandingImageLoad: function () {
				this.getView().byId("landingImageHeadline").setVisible(true);
			}
		});

	}
);

}; // end of sap/ui/documentation/sdk/controller/BaseController.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.Code.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global history */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.Code.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageToast'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/Code.controller",[
		"jquery.sap.global",
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/ui/documentation/sdk/controller/util/ControlsInfo",
		'sap/ui/Device',
		'sap/m/MessageToast',
		"sap/ui/model/json/JSONModel"
	], function (jQuery, BaseController, ControlsInfo, Device, MessageToast, JSONModel) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.Code", {

			_aMockFiles : ["products.json", "supplier.json", "img.json"],

			/**
			 * Called when the controller is instantiated.
			 * @public
			 */
			onInit : function () {
				this.oModel = new JSONModel();
				this.getView().setModel(this.oModel);

				this.router = this.getRouter();
				this.router.getRoute("code").attachPatternMatched(this.onRouteMatched, this);
				this.router.getRoute("code_file").attachPatternMatched(this.onRouteMatched, this);
				this._codeCache = {};

				this._bFirstLoad = true;
			},

			/**
			 * Handles "code" routing
			 * @function
			 * @private
			 */
			onRouteMatched: function (oEvt) {
				this.showMasterSide();
				this._sId = oEvt.getParameter("arguments").id;
				this._sFileName = decodeURIComponent(oEvt.getParameter("arguments").fileName);

				ControlsInfo.loadData().then(function(oData) {
					this._loadCode(oData);
				}.bind(this));

			},

			_loadCode: function (oData) {

				var sFileName = this._sFileName;

				// retrieve sample object
				var oSample = oData.samples[this._sId];
				if (!oSample) {
					this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound", "XML", false, { path: this._sId });
					return;
				}

				// cache the data to be reused
				if (!this._oData || oSample.id !== this._oData.id) {

					// get component and data when sample is changed or nothing exists so far
					var sCompId = 'sampleComp-' + this._sId;
					var sCompName = this._sId;
					var oComp = sap.ui.component(sCompId);
					if (!oComp) {
						oComp = sap.ui.getCore().createComponent({
							id : sCompId,
							name : sCompName
						});
					}

					// create data object
					var oMetadata = oComp.getMetadata();
					var oConfig = (oMetadata) ? oMetadata.getConfig() : null;
					this._oData = {
						id : oSample.id,
						title : "Code: " + oSample.name,
						name : oSample.name,
						stretch : oConfig.sample ? oConfig.sample.stretch : false,
						files : [],
						iframe : oConfig.sample.iframe,
						fileName: sFileName,
						includeInDownload: oConfig.sample.additionalDownloadFiles
					};

					// retrieve files
					// (via the 'Orcish maneuver': Use XHR to retrieve and cache code)
					if (oConfig && oConfig.sample && oConfig.sample.files) {
						var sRef = jQuery.sap.getModulePath(oSample.id);
						for (var i = 0 ; i < oConfig.sample.files.length ; i++) {
							var sFile = oConfig.sample.files[i];
							var sContent = this.fetchSourceFile(sRef, sFile);

							this._oData.files.push({
								name : sFile,
								raw : sContent,
								code : this._convertCodeToHtml(sContent)
							});
						}
					}
				} else {
					this._oData.fileName = sFileName;
				}

				// set model data
				this.oModel.setData(this._oData);

				if (sFileName === "undefined") {
					sFileName = this._getInitialFileName();
				}

				// update <code>CodeEditor</code> content and the selected tab
				this._updateCodeEditor(sFileName);
				this._getTabHeader().setSelectedKey(sFileName);

				// scroll to the top of the page
				var page = this.getView().byId("page");
				page.scrollTo(0);
			},

			fetchSourceFile : function (sRef, sFile) {
				var that = this;
				var sUrl = sRef + "/" + sFile;

				var fnSuccess = function (result) {
					that._codeCache[sUrl] = result;
				};
				var fnError = function (result) {
					that._codeCache[sUrl] = "not found: '" + sUrl + "'";
				};

				if (!(sUrl in this._codeCache)) {
					this._codeCache[sUrl] = "";
					jQuery.ajax(sUrl, {
						async: false,
						dataType: "text",
						success: fnSuccess,
						error: fnError
					});
				}

				return that._codeCache[sUrl];
			},

			onDownload : function (evt) {

				jQuery.sap.require("sap.ui.thirdparty.jszip");
				var JSZip = sap.ui.require("sap/ui/thirdparty/jszip");
				var oZipFile = new JSZip();

				// zip files
				var oData = this.oModel.getData();
				for (var i = 0 ; i < oData.files.length ; i++) {
					var oFile = oData.files[i],
						sRawFileContent = oFile.raw;

					// change the bootstrap URL to the current server for all HTML files of the sample
					if (oFile.name && (oFile.name === oData.iframe || oFile.name.split(".").pop() === "html")) {
						sRawFileContent = this._changeIframeBootstrapToCloud(sRawFileContent);
					}

					oZipFile.file(oFile.name, sRawFileContent);

					// mock files
					for (var j = 0; j < this._aMockFiles.length; j++) {
						var sMockFile = this._aMockFiles[j];
						if (oFile.raw.indexOf(sMockFile) > -1){
							oZipFile.file("mockdata/" + sMockFile, this.downloadMockFile(sMockFile));
						}
					}
				}

				var sRef = jQuery.sap.getModulePath(this._sId),
					aExtraFiles = oData.includeInDownload || [],
					that = this;

				// iframe examples have a separate index file and a component file to describe it
				if (!oData.iframe) {
					oZipFile.file("Component.js", this.fetchSourceFile(sRef, "Component.js"));
					oZipFile.file("index.html", this._changeIframeBootstrapToCloud(this.createIndexFile(oData)));
				}

				// add extra download files
				aExtraFiles.forEach(function(sFileName) {
					oZipFile.file(sFileName, that.fetchSourceFile(sRef, sFileName));
				});

				var oContent = oZipFile.generate({type:"blob"});

				this._openGeneratedFile(oContent);
			},

			_openGeneratedFile : function (oContent) {
				jQuery.sap.require("sap.ui.core.util.File");
				var File = sap.ui.require("sap/ui/core/util/File");
				File.save(oContent, this._sId, "zip", "application/zip");
			},

			createIndexFile : function(oData) {

				var sHeight,
					bScrolling;

				var sRef = jQuery.sap.getModulePath("sap.ui.documentation.sdk.tmpl");
				var sIndexFile = this.fetchSourceFile(sRef, "index.html.tmpl");

				sIndexFile = sIndexFile.replace(/{{TITLE}}/g, oData.name);
				sIndexFile = sIndexFile.replace(/{{SAMPLE_ID}}/g, oData.id);

				sHeight = oData.stretch ? 'height : "100%", ' : "";
				sIndexFile = sIndexFile.replace(/{{HEIGHT}}/g, sHeight);

				bScrolling = !oData.stretch;
				sIndexFile = sIndexFile.replace(/{{SCROLLING}}/g, bScrolling);

				return sIndexFile;
			},

			downloadMockFile : function(sFile) {

				var sRef = jQuery.sap.getModulePath("sap.ui.demo.mock");
				var sWrongPath = "test-resources/sap/ui/documentation/sdk/images/";
				var sCorrectPath = "https://openui5.hana.ondemand.com/test-resources/sap/ui/documentation/sdk/images/";
				var oRegExp = new RegExp(sWrongPath,"g");
				var sMockData = this.fetchSourceFile(sRef, sFile);

				if (sMockData) {
					sMockData = sMockData.replace(oRegExp, sCorrectPath);
				}

				return sMockData;
			},

			onNavBack : function () {
				this.router.navTo("sample", { id : this._sId }, true);
			},

			/**
			 *
			 */
			_convertCodeToHtml : function (code) {

				jQuery.sap.require("jquery.sap.encoder");

				code = code.toString();

				// Get rid of function around code
				code = code.replace(/^function.+{/, "");

				code = code.replace(/}[!}]*$/, "");

				// Get rid of unwanted code if CODESNIP tags are used
				code = code.replace(/^[\n\s\S]*\/\/\s*CODESNIP_START\n/, "");
				code = code.replace(/\/\/\s*CODESNIP_END[\n\s\S]*$/, "");

				// Improve indentation for display
				code = code.replace(/\t/g, "  ");

				return code;
			},

			_changeIframeBootstrapToCloud : function (sRawIndexFileHtml) {

				jQuery.sap.require("sap.ui.thirdparty.URI");
				var URI = sap.ui.require("sap/ui/thirdparty/URI");

				var rReplaceIndex = /src=(?:"[^"]*\/sap-ui-core\.js"|'[^']*\/sap-ui-core\.js')/;
				var oCurrentURI = new URI(window.location.href).search("");
				var oRelativeBootstrapURI = new URI(jQuery.sap.getResourcePath("", "/sap-ui-core.js"));
				var sBootstrapURI = oRelativeBootstrapURI.absoluteTo(oCurrentURI).toString();

				// replace the bootstrap path of the sample with the current to the core
				return sRawIndexFileHtml.replace(rReplaceIndex, 'src="' + sBootstrapURI + '"');
			},

			handleTabSelectEvent: function(oEvent) {
				var sFileName = oEvent.getParameter("selectedKey");

				this._bFirstLoad = false;
				this.router.navTo("code_file", {
					id : this._sId,
					fileName: encodeURIComponent(sFileName)
				}, false);
			},

			_updateCodeEditor : function(sFileName) {
				var oCodeEditor = this._getCodeEditor(),
					oAceInstance = oCodeEditor._getEditorInstance(),
					oAceRenderer = oAceInstance.renderer;

				// set the <code>CodeEditor</code> new code base and its type - xml, js, json or css.
				oCodeEditor.setValue(this._getCode(sFileName));
				oCodeEditor.setType(this._getFileType(sFileName));

				// set the <code>CodeEditor</code> scroll pos to line 0
				oAceInstance.gotoLine(/*line*/0, /*column*/0, /*animate*/false);

				if (this._bFirstLoad) {
					jQuery.sap.delayedCall(0, this, function(){
						oAceRenderer.onResize();
					});
				}
			},

			_getCode : function (sFileName) {
				var aFiles = this.getModel().getData().files,
					sCode = "";

				aFiles.forEach(function(oFile) {
					if (oFile.name === sFileName) {
						sCode = oFile.raw;
						return true;
					}
				});

				return sCode;
			},

			_getFileType : function (sFileName) {
				var sFileExtension = sFileName.split('.').pop();
				return sFileExtension === "js" ? "javascript" : sFileExtension;
			},

			_getInitialFileName : function() {
				return (this._oData
						&& this._oData.files
						&& this._oData.files.length > 0
						&& this._oData.files[0].name) || null;
			},

			_getCodeEditor : function() {
				if (!this.oCodeEditor) {
					this.oCodeEditor = this.getView().byId("codeEditor");
				}

				return this.oCodeEditor;
			},

			_getTabHeader : function() {
				if (!this.oTabHeader) {
					this.oTabHeader = this.getView().byId("tabHeader");
				}

				return this.oTabHeader;
			}
		});
	}
);
}; // end of sap/ui/documentation/sdk/controller/Code.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.Controls.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global history */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.Controls.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/Controls.controller",[
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/ui/Device"
	], function (BaseController, Device) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.Controls", {

			/**
			 * Called when the controller is instantiated.
			 * @public
			 */
			onInit: function () {
				// manually call the handler once at startup as device API won't do this for us
				this._onOrientationChange({
					landscape: Device.orientation.landscape
				});
			},

			/**
			 * Called before the view is rendered.
			 * @public
			 */
			onBeforeRendering: function() {
				this._deregisterOrientationChange();
			},

			/**
			 * Called after the view is rendered.
			 * @public
			 */
			onAfterRendering: function() {
				this._registerOrientationChange();
			},

			/**
			 * Called when the controller is destroyed.
			 * @public
			 */
			onExit: function() {
				this._deregisterOrientationChange();
			},

			/**
			 * Filter for controls in the master search field when the title of a control section was pressed
 			 */
			onPress: function(oEvent) {
				var sFilter = oEvent.oSource.getFilter();
				var oSearchField = this.getOwnerComponent().byId("controlsMaster").byId("searchField");
				oSearchField.setValue(sFilter);
				oSearchField.fireLiveChange({
					newValue: sFilter
				});
				// tablet or small screen devices: show master page
				setTimeout(function () {
					this.getSplitApp().showMaster();
				}.bind(this), 0);
				// phone: navigate to master list
				if (Device.system.phone) {
					this.getRouter().navTo("controlsMaster", {});
				}
			}
		});
	}
);
}; // end of sap/ui/documentation/sdk/controller/Controls.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.ControlsMaster.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.documentation.sdk.controller.ControlsMaster.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.m.GroupHeaderListItem'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Sorter'); // unlisted dependency retained
jQuery.sap.require('jquery.sap.storage'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/ControlsMaster.controller",[
		"jquery.sap.global",
		"sap/ui/Device",
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/ui/documentation/sdk/controller/util/APIInfo",
		"sap/ui/model/json/JSONModel",
		"sap/ui/documentation/sdk/controller/util/ControlsInfo",
		"sap/m/GroupHeaderListItem",
		"sap/ui/core/Component",
		"sap/ui/model/Filter",
		"sap/ui/model/Sorter",
		"jquery.sap.storage"
	], function (jQuery, Device, BaseController, APIInfo, JSONModel, ControlsInfo, GroupHeaderListItem, Component,
				 Filter, Sorter, jQueryStorage) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.ControlsMaster", {

			_oStorage: jQueryStorage.sap.storage(jQueryStorage.sap.storage.Type.local),
			_sStorageKey: "UI5_EXPLORED_LIST_SETTINGS_FROM_1_48",
			_oViewSettings: {
				compactOn: false,
				themeActive: "sap_belize",
				rtl: false
			},
			_oDefaultSettings: {
				compactOn: false,
				themeActive: "sap_belize",
				rtl: false
			},
			_oListSettings: {
				filter: {},
				groupProperty: "category",
				groupDescending: false,
				version: jQuery.sap.Version(sap.ui.version).getMajor() + "." + jQuery.sap.Version(sap.ui.version).getMinor()
			},
			_mGroupFunctions: {
				"name": function (oContext) {
					var sKey = oContext.getProperty("name").charAt(0);
					return {
						key: sKey,
						text: sKey
					};
				},
				"namespace": true,
				"category": true,
				"since": true,
				"formFactors": true
			},
			_sFilterValue: "",

			/* =========================================================== */
			/* lifecycle methods                                           */
			/* =========================================================== */

			/**
			 * Called when the master list controller is instantiated.
			 * It sets up the event handling for the master/detail communication and other lifecycle tasks.
			 * @public
			 */
			onInit : function () {
				var oEntityModel, oDeviceModel, oFilterModel,
					fnOnDataReady = function (oControlsData) {
						this._oView.getModel().setData({
							entityCount : oControlsData.entityCount,
							entities : oControlsData.entities
						});
						this.getModel("filter").setData(oControlsData.filter);
						this._toggleListItem(this._getItemToSelect(), true);
					}.bind(this);

				this._oRouter = this.getRouter();

				// Keep track if navigation happens via selecting items manually within the List
				this._bNavToEntityViaList = false;

				// Cache view reference
				this._oView = this.getView();

				ControlsInfo.loadData().then(fnOnDataReady);

				oEntityModel = new JSONModel();
				oEntityModel.setSizeLimit(100000);
				this._oView.setModel(oEntityModel);

				oDeviceModel = new JSONModel({
					listMode : (Device.system.phone) ? "None" : "SingleSelectMaster",
					listItemType : (Device.system.phone) ? "Active" : "Inactive"
				});
				oDeviceModel.setDefaultBindingMode("OneWay");
				this._oView.setModel(oDeviceModel, "viewModel");

				// Init Filter model
				oFilterModel = new JSONModel();
				oFilterModel.setSizeLimit(100000);
				this.setModel(oFilterModel, "filter");

				this._vsFilterBar = this._oView.byId("vsFilterBar");
				this._vsFilterLabel = this._oView.byId("vsFilterLabel");

				this._oRouter.getRoute("group").attachPatternMatched(this._onGroupMatched, this);
				this._oRouter.getRoute("entity").attachPatternMatched(this._onEntityMatched, this);
				this._oRouter.getRoute("sample").attachPatternMatched(this._onSampleMatched, this);
				this._oRouter.getRoute("code").attachPatternMatched(this._onSampleMatched, this);
				this._oRouter.getRoute("controls").attachPatternMatched(this._onControlsMatched, this);
				this._oRouter.getRoute("controlsMaster").attachPatternMatched(this._onControlsMasterMatched, this);

				this.LIST_SCROLL_DURATION = 0; // ms

				//DOM rendering delay is used before calling scroll, to ensure scroll is applied to the final DOM
				//DOM rendering delay value is minimal by default, but some function may increase it if that function calls intensive DOM operation
				// (e.g. RTL change, that leads to new CSS to be requested and applied on entire DOM)
				this._iDomRenderingDelay = 0; // (ms)
				this._getList().addEventDelegate({
					onAfterRendering : function() {
						jQuery.sap.delayedCall(this._iDomRenderingDelay, this, this._scrollToSelectedListItem);
					}}, this);
				this._oCore.attachThemeChanged(this._scrollToSelectedListItem, this); // theme change requires us to restore scroll position
				this._oCore.attachLocalizationChanged(this._onLocalizationChange, this);

				// Subscribe to view event to apply to it the current configuration
				this._oView.addEventDelegate({
					onBeforeFirstShow: this.onBeforeFirstShow.bind(this)
				});

				// subscribe to app events
				this._oComponent = this.getOwnerComponent();
				this._oRootView = this.getRootView();

				this._oViewSettings.compactOn = this._oComponent.getContentDensityClass() === "sapUiSizeCompact" &&
					this._oRootView.hasStyleClass("sapUiSizeCompact");
				this._oViewSettings.rtl = this._oCore.getConfiguration().getRTL();

				// Keep default settings for compact mode up to date
				this._oDefaultSettings.compactOn = this._oViewSettings.compactOn;
				this._oDefaultSettings.rtl = this._oViewSettings.rtl;

				this._initListSettings();
			},

			_viewSettingsResetOnNavigation: function (oEvent) {
				var sRouteName = oEvent.getParameter("name");
				if (["group", "entity", "sample", "code", "code_file", "controls", "controlsMaster"].indexOf(sRouteName) === -1) {
					// Reset view settings
					this._applyAppConfiguration(this._oDefaultSettings.themeActive,
						this._oDefaultSettings.compactOn,
						this._oDefaultSettings.rtl);

					// When we restore the default settings we don't need the event any more
					this.getRouter().detachBeforeRouteMatched(this._viewSettingsResetOnNavigation, this);
				}
			},

			/**
			 * Initialize the list settings. At first local storage is checked. If this is empty defaults are used.
			 * @private
			 */
			_initListSettings: function () {
				var sJson = this._oStorage.get(this._sStorageKey);
				if (sJson) {
					this._oListSettings = JSON.parse(sJson);
				}
			},

			/**
			 * Apply content configuration
			 * @param {string} sThemeActive name of the theme
			 * @param {boolean} bCompactOn compact mode
			 * @private
			 */
			_applyAppConfiguration: function(sThemeActive, bCompactOn, bRTL){
				var oSampleFrameContent,
					$SampleFrame,
					oSampleRootControl,
					oSamplePage;

				// Switch theme if necessary
				this._oCore.applyTheme(sThemeActive);
				// Switch content density
				this._oRootView.toggleStyleClass("sapUiSizeCompact", bCompactOn)
					.toggleStyleClass("sapUiSizeCozy", !bCompactOn);
				this._oCore.getConfiguration().setRTL(bRTL);

				// If there is a sample page loaded try to find it's root container and invalidate it to let controls
				// adapt to compact mode changes
				if (this._oComponent._oCurrentOpenedSample) {
					oSampleRootControl = this._oComponent._oCurrentOpenedSample.getComponentInstance().getRootControl();
					// Keep in mind that getRootControl might return 'null'
					if (oSampleRootControl) {
						oSamplePage = oSampleRootControl.getContent()[0];
						if (oSamplePage) {
							oSamplePage.invalidate();
						}
					}
				}

				// Apply theme and compact mode also to iframe samples
				$SampleFrame = jQuery("#sampleFrame");
				if ($SampleFrame.length > 0) {
					oSampleFrameContent = $SampleFrame[0].contentWindow;
					if (oSampleFrameContent) {
						oSampleFrameContent.sap.ui.getCore().applyTheme(sThemeActive);
						oSampleFrameContent.sap.ui.getCore().getConfiguration().setRTL(bRTL);
						oSampleFrameContent.jQuery('body').toggleClass("sapUiSizeCompact", bCompactOn)
							.toggleClass("sapUiSizeCozy", !bCompactOn);
					}
				}
			},

			_onGroupMatched: function (event) {
				this._onMatched('#/group/', event);
			},

			_onEntityMatched: function (event) {
				this._onMatched('#/entity/', event);
			},

			_onSampleMatched: function (event) {
				this._onMatched('#/sample/', event);
			},

			_onMatched: function(sName, oEvent) {
				var oEntityModel = this._getList().getModel(),
					sEntityId = oEvent.getParameter("arguments").id;

				this.showMasterSide();
				this._topicId = sName + sEntityId;
				this._entityId = sEntityId;

				oEntityModel.refresh();

				this._updateListSelection();
			},

			_onControlsMasterMatched: function(event) {
				this.showMasterSide();
				if (!Device.system.phone) {
					this.getRouter().navTo("controls");
				}
			},

			_onControlsMatched: function() {
				this.showMasterSide();
				this._resetListSelection();
			},

			/* =========================================================== */
			/* Event handlers                                              */
			/* =========================================================== */

			_onLocalizationChange: function(oEvent) {
				this._iDomRenderingDelay = 3000; //RTL change requires longer DOM computations as new CSS is requested and applied on the entire DOM
				jQuery.sap.delayedCall(this._iDomRenderingDelay, this, function() {
					this._iDomRenderingDelay = 0;
				});
			},

			onNavToEntity : function (oEvt) {
				var oItemParam = oEvt.getParameter("listItem"),
					oItem = (oItemParam) ? oItemParam : oEvt.getSource(),
					sPath = oItem.getBindingContext().getPath(),
					oEntity = this.getView().getModel().getProperty(sPath),
					bReplace = !Device.system.phone;

				this._bNavToEntityViaList = true;
				this.getRouter().navTo("entity", {id: oEntity.id, part: "samples"}, bReplace);
			},

			getGroupHeader: function (oGroup) {
				return new GroupHeaderListItem({
					title: oGroup.key,
					upperCase: false
				});
			},

			/**
			* Updates the <code>List</code> selection, based on the loaded sample,
			* after the model is loaded.
			* <code>Note</code>:
			* The method scrolls the page to the given item,
			* if the navigation happens not by selecting items from the <code>List</code>,
			* but using links from other pages.
			*/
			_updateListSelection : function() {
				var oItemToSelect = this._getItemToSelect();

				if (!oItemToSelect) {
					return;
				}

				this._toggleListItem(oItemToSelect, true);

				if (!this._bNavToEntityViaList) {
					jQuery.sap.delayedCall(0, this, this._scrollToSelectedListItem);
				}
				this._bNavToEntityViaList = false;
			},

			/**
			* Resets the given <code>List</code> selection
			* and scrolls to the top.
			*/
			_resetListSelection : function() {
				var oSelectedItem = this._getList().getSelectedItem();

				if (oSelectedItem) {
					this._toggleListItem(oSelectedItem, false);
					jQuery.sap.delayedCall(0, this, this._scrollPageTo, [0, 0]);
				}
			},

			/**
			* Selects or deselects the given <code>ListItemBase</code>.
			*
			* @param {sap.m.ListItemBase} oItemToSelect
			* @param {boolean} bSelect Sets selected status of the list item.
			*/
			_toggleListItem : function(oItemToSelect, bSelect) {
				this._getList().setSelectedItem(oItemToSelect, bSelect, false);
			},

			/**
			* Scrolls to the currently selected <code>ListItemBase</code>
			*
			*/
			_scrollToSelectedListItem : function() {
				var oItemToScroll = this._getList().getSelectedItem();
				if (oItemToScroll) {
					this._getPage().scrollToElement(oItemToScroll, this.LIST_SCROLL_DURATION);
				}
			},

			/**
			* Scrolls the <code>sap.m.Page</code> to the given position.
			*
			* @param {int} iPos The vertical pixel position to scroll to.
			* @param {int} iDuration The duration of animated scrolling.
			*/
			_scrollPageTo : function (iPos, iDuration) {
				this._getPage().scrollTo(iPos, iDuration);
			},

			/**
			* Retrieves the <code>sap.m.ListItem</code>, that should be selected within the List,
			* based on the loaded sample or null, if it does not exist.
			* @returns {sap.m.ListItemBase | null}
			*/
			_getItemToSelect : function () {
				var oList = this._getList(),
					oEntityModel = oList.getModel(),
					oEntity,
					oItemBindingContext,
					sItemBindingContextPath,
					sLoadedEntityId = this._entityId,
					oItemToSelect = null;

				oList.getItems().forEach(function (oItem) {
					oItemBindingContext = oItem.getBindingContext();
					if (oItemBindingContext) {
						sItemBindingContextPath = oItemBindingContext.getPath();
						oEntity = oEntityModel.getProperty(sItemBindingContextPath);
						if (oEntity.id === sLoadedEntityId) {
							oItemToSelect = oItem;
							return false;
						}
					}
				});

				return oItemToSelect;
			},

			/**
			 * Retrieves the <code>sap.m.Page</code>, based on its ID.
			 * @returns {sap.m.Page || undefined}
			 */
			_getPage : function() {
				if (!this.oPage) {
					this.oPage = this.byId("exploredMasterPage");
				}

				return this.oPage;
			},

			/**
			 * Retrieves the <code>sap.m.List</code>, based on its ID.
			 * @returns {sap.m.List || undefined}
			 */
			_getList : function() {
				if (!this.oList) {
					this.oList = this.byId("exploredMasterList");
				}

				return this.oList;
			},

			/**
			 * Called on before first show of the view
			 * @override
			 */
			onBeforeFirstShow: function () {
				this._updateView();
			},

			/**
			 * Called upon destruction of the view
			 * @override
			 */
			onExit: function() {
				this._oCore.detachThemeChanged(this._scrollToSelectedListItem, this);
				this._oCore.detachLocalizationChanged(this._onLocalizationChange, this);
			},

			onConfirmViewSettings: function (oEvent) {
				var oGroupItem = oEvent.getParameter("groupItem");

				// store filter settings
				this._oListSettings.filter = oEvent.getParameter("filterCompoundKeys");

				// store group settings
				this._oListSettings.groupProperty = oGroupItem ? oGroupItem.getKey() : null;
				this._oListSettings.groupDescending = oEvent.getParameter("groupDescending");

				// update local storage
				this._oStorage.put(this._sStorageKey, JSON.stringify(this._oListSettings));

				// update view
				this._updateView();
			},

			handleListSettings: function () {
				// create dialog on demand
				if (!this._oVSDialog) {
					this._oVSDialog = sap.ui.xmlfragment(this.getView().getId(), "sap.ui.documentation.sdk.view.viewSettingsDialog", this);
					this.getView().addDependent(this._oVSDialog);
				}

				this._oVSDialog.setSelectedFilterCompoundKeys(this._oListSettings.filter);
				this._oVSDialog.setSelectedGroupItem(this._oListSettings.groupProperty);
				this._oVSDialog.setGroupDescending(this._oListSettings.groupDescending);

				// Apply cozy/compact mode to the dialog
				this._oVSDialog
					.toggleStyleClass("sapUiSizeCompact", this._oViewSettings.compactOn)
					.toggleStyleClass("sapUiSizeCozy", !this._oViewSettings.compactOn);

				// open
				this._oVSDialog.open();

			},

			handleListFilter: function (oEvent) {
				this._sFilterValue = oEvent.getParameter("newValue").trim();
				this._updateView();
			},

			_updateListBinding: function () {

				var oFilter,
					oSorter,
					aFilters = [],
					aSorters = [],
					bFilterChanged = false,
					bGroupChanged = false,
					oList = this._oView.byId("exploredMasterList"),
					oBinding = oList.getBinding("items");

				bFilterChanged = true;
				aFilters.push(new Filter("searchTags", "Contains", this._sFilterValue));

				// add filters for view settings
				jQuery.each(this._oListSettings.filter, function (sProperty, oValues) {
					var aPropertyFilters = [];

					jQuery.each(oValues, function (sKey, bValue) {
						var sOperator = (sProperty === "formFactors") ? "Contains" : "EQ";
						aPropertyFilters.push(new Filter(sProperty, sOperator, sKey));
					});

					bFilterChanged = true;
					aFilters.push(new Filter(aPropertyFilters, false)); // second parameter stands for "or"
				});

				// filter
				if (bFilterChanged && aFilters.length === 0) {
					oBinding.filter(aFilters, "Application");
				} else if (bFilterChanged && aFilters.length > 0) {
					oFilter = new Filter(aFilters, true); // second parameter stands for "and"
					oBinding.filter(oFilter, "Application");
				}

				if (this._oListSettings.groupProperty && this._oListSettings.groupProperty !== this._sCurrentGroup) {
					bGroupChanged = true;
				} else if (this._oListSettings.groupProperty && this._oListSettings.groupDescending !== this._bCurrentlyGroupedDescending) {
					bGroupChanged = true;
				}

				// group
				if (bGroupChanged) {
					oSorter = new Sorter(
						this._oListSettings.groupProperty,
						this._oListSettings.groupDescending,
						this._mGroupFunctions[this._oListSettings.groupProperty]);
					aSorters.push(oSorter);
					aSorters.push(new Sorter("name", false));
					oBinding.sort(aSorters);
				}

				this._sCurrentGroup = this._oListSettings.groupProperty;
				this._bCurrentlyGroupedDescending = this._oListSettings.groupDescending;

				// memorize that this function was executed at least once
				this._bIsViewUpdatedAtLeastOnce = true;
			},

			/**
			 * Makes sure the view settings are initialized and updates the filter bar dispay and list binding
			 */
			_updateView: function () {
				// update the filter bar
				this._updateFilterBarDisplay();

				// update the master list binding
				this._updateListBinding();
			},

			_updateFilterBarDisplay: function () {
				// calculate text
				var aFilterTexts = [];

				jQuery.each(this._oListSettings.filter, function (sProperty, oValues) {
					aFilterTexts = aFilterTexts.concat(Object.keys(oValues));
				});

				if (aFilterTexts.length > 0) {
					this._vsFilterBar.setVisible(true);
					this._vsFilterLabel.setText(aFilterTexts.join(", "));
				} else {
					this._vsFilterBar.setVisible(false);
				}
			},

			/**
			 * Opens the View settings dialog
			 * @public
			 */
			handleSettings: function () {
				if (!this._oSettingsDialog) {
					this._oSettingsDialog = new sap.ui.xmlfragment("sap.ui.documentation.sdk.view.appSettingsDialog", this);
					this._oView.addDependent(this._oSettingsDialog);
				}

				jQuery.sap.delayedCall(0, this, function () {
					var oAppSettings = this._oCore.getConfiguration(),
						oThemeSelect = this._oCore.byId("ThemeSelect"),
						sUriParamTheme = jQuery.sap.getUriParameters().get("sap-theme"),
						bCompactMode = this._oViewSettings.compactOn;

					// Theme select
					oThemeSelect.setSelectedKey(sUriParamTheme ? sUriParamTheme : oAppSettings.getTheme());

					// RTL
					this._oCore.byId("RTLSwitch").setState(oAppSettings.getRTL());

					// Compact mode select
					this._oCore.byId("CompactModeSwitch").setState(bCompactMode);
					this._oSettingsDialog
						.toggleStyleClass("sapUiSizeCompact", bCompactMode)
						.toggleStyleClass("sapUiSizeCozy", !bCompactMode);
					this._oSettingsDialog.open();
				});
			},

			/**
			 * Closes the View settings dialog
			 * @public
			 */
			handleCloseAppSettings: function () {
				this._oSettingsDialog.close();
			},

			/**
			 * Saves settings from the view settings dialog
			 * @public
			 */
			handleSaveAppSettings: function () {
				var BusyDialog,
					bCompact = this._oCore.byId('CompactModeSwitch').getState(),
					sTheme = this._oCore.byId('ThemeSelect').getSelectedKey(),
					bRTL = this._oCore.byId('RTLSwitch').getState();

				this._oSettingsDialog.close();

				// Lazy loading of busy dialog
				if (!this._oBusyDialog) {
					jQuery.sap.require("sap.m.BusyDialog");
					BusyDialog = sap.ui.require("sap/m/BusyDialog");
					this._oBusyDialog = new BusyDialog();
					this.getView().addDependent(this._oBusyDialog);
				}

				// Handle busy dialog
				this._oBusyDialog.open();
				jQuery.sap.delayedCall(1000, this, function () {
					this._oBusyDialog.close();
				});

				this._oViewSettings.compactOn = bCompact;
				this._oViewSettings.themeActive = sTheme;
				this._oViewSettings.rtl = bRTL;

				// handle settings change
				this._applyAppConfiguration(sTheme, bCompact, bRTL);

				// If we are navigating outside the Explored App section: view settings should be reset
				this.getRouter().attachBeforeRouteMatched(this._viewSettingsResetOnNavigation, this);
			}
		});
	}
);
}; // end of sap/ui/documentation/sdk/controller/ControlsMaster.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.DemoApps.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global history */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.DemoApps.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/documentation/sdk/controller/DemoApps.controller",[
		"sap/ui/documentation/sdk/controller/BaseController"
	], function (BaseController) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.DemoApps", {

			/**
			 * Called when the controller is instantiated.
			 * @public
			 */
			onInit: function () {
				this.getRouter().getRoute("demoapps").attachPatternMatched(this._onMatched, this);
			},

			/**
			 * Handles "demoapps" routing
			 * @function
			 * @private
			 */
			_onMatched: function () {
				try {
					this.hideMasterSide();
				} catch (e) {
					// try-catch due to a bug in UI5 SplitApp, CL 1898264 should fix it
					jQuery.sap.log.error(e);
				}
			}
		});
	}
);
}; // end of sap/ui/documentation/sdk/controller/DemoApps.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.Downloads.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global history */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.Downloads.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/documentation/sdk/controller/Downloads.controller",[
		"sap/ui/documentation/sdk/controller/BaseController"
	], function (BaseController) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.Downloads", {

			/**
			 * Called when the controller is instantiated.
			 * @public
			 */
			onInit : function () {
				this.getRouter().getRoute("downloads").attachPatternMatched(this._onMatched, this);
			},

			/**
			 * Handles "downloads" routing
			 * @function
			 * @private
			 */
			_onMatched: function () {
				this.hideMasterSide();
			}
		});
	}
);
}; // end of sap/ui/documentation/sdk/controller/Downloads.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.Entity.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global location */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.Entity.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ComponentContainer'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/Entity.controller",[
		"sap/ui/model/json/JSONModel",
		"sap/ui/core/ComponentContainer",
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/ui/documentation/sdk/controller/util/ControlsInfo",
		"sap/ui/documentation/sdk/controller/util/EntityInfo",
		"sap/ui/documentation/sdk/util/ToggleFullScreenHandler"
	], function (JSONModel, ComponentContainer, BaseController, ControlsInfo,
				 EntityInfo, ToggleFullScreenHandler) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.Entity", {

			/* =========================================================== */
			/* lifecycle methods										   */
			/* =========================================================== */

			onInit: function () {

				this.router = this.getRouter();
				this.router.getRoute("entity").attachPatternMatched(this.onRouteMatched, this);

				this._oObjectPage = this.getView().byId("ObjectPageLayout");

				// click handler for @link tags in JSdoc fragments
				this.getView().attachBrowserEvent("click", this.onJSDocLinkClick, this);

				this.getView().setModel(new JSONModel());
			},

			onExit: function () {
				this.getView().detachBrowserEvent("click", this.onJSDocLinkClick, this);
			},

			/* =========================================================== */
			/* begin: internal methods									 */
			/* =========================================================== */

			onTypeLinkPress: function (oEvt) {
				// navigate to entity
				var sType = oEvt.getSource().data("type");
				this.getRouter().navTo("entity", {id: sType}, false);
			},

			onAPIRefPress: function (oEvt) {
				var sEntityName = oEvt.getSource().data("name");
				this.getRouter().navTo("apiId", {id: sEntityName}, false);
			},

			onIntroLinkPress: function (oEvt) {
				// remove explored.html from URL
				var aParts = document.location.pathname.split("/"),
					sBaseLink = document.location.origin + aParts.splice(0, aParts.length - 1).join("/") + "/";

				// open a relative documentation window
				window.open(sBaseLink + this.getView().getModel().getProperty("/docuLink"), "_blank");
			},

			onTabSelect: function (oEvt) {
				// update URL without updating history
				var sTab = oEvt.getParameter("key");
				this.router.navTo("entity", {
					id: this._sId,
					part: sTab
				}, true);
			},

			onNavBack: function (oEvt) {
				this.router.myNavBack("home", {});
			},

			onNavToSample: function (oEvt) {
				var sPath = oEvt.getSource().getBindingContext().getPath();
				var oSample = this.getView().getModel().getProperty(sPath);
				this.router.navTo("sample", {
					id: oSample.id
				});
			},

			onJSDocLinkClick: function (oEvent) {
				var sRoute = "entity",
					oComponent = this.getOwnerComponent(),
					aLibsData = oComponent.getModel("libsData").getData(),
					sTarget = oEvent.target.getAttribute("data-sap-ui-target"),
					aNavInfo;

				if (!sTarget) {
					return;
				}

				if (sTarget.indexOf('/') >= 0) {
					// link refers to a method or event data-sap-ui-target="<class name>/methods/<method name>" OR
					// data-sap-ui-target="<class name>/events/<event name>
					aNavInfo = sTarget.split('/');

					if (aNavInfo[0] !== this._sTopicid) {
						oComponent.getRouter().navTo(sRoute, {id: aNavInfo[0]}, false);
					}
				} else if (!aLibsData[sTarget]) {
					sTarget = sTarget.slice(0, sTarget.lastIndexOf("."));

					oComponent.getRouter().navTo(sRoute, {id: sTarget}, false);
				} else {
					oComponent.getRouter().navTo(sRoute, {id: sTarget}, false);
				}

				oEvent.preventDefault();
			},

			_TAB_KEYS: ["samples", "about"],

			_loadSample: function (oControlsData) {

				var sNewId = this._sNewId;

				var aFilteredEntities = oControlsData.entities.filter(function (entity) {
					return entity.id === sNewId;
				});
				var oEntity = aFilteredEntities.length ? aFilteredEntities[0] : undefined;

				// set data model
				var oData;
				if (this._sId !== sNewId) {

					// retrieve entity docu from server
					var oDoc = EntityInfo.getEntityDocu(sNewId, oEntity && oEntity.namespace);

					// route to not found page IF there is NO index entry AND NO docu from server
					if (!oEntity && !oDoc) {
						this.router.myNavToWithoutHash("sap.ui.documentation.sdk.view.NotFound", "XML", false, {path: sNewId});
						return;
					}

					// get view data
					oData = this._getViewData(sNewId, oDoc, oEntity, oControlsData);

					// set view model
					this.getView().getModel().setData(oData, false /* no merge with previous data */);


					// done, we can now switch the id
					this._sId = sNewId;

				} else {
					// get existing data model
					oData = this.getView().getModel().getData();
				}

				// handle unknown tab
				if (this._TAB_KEYS.indexOf(this._sNewTab) === -1) {
					this._sNewTab = "samples";
				}

				// handle invisible tab
				if (!oData.show[this._sNewTab]) {
					this._sNewTab = "samples";
				}

				this._switchPageTab();

			},


			onRouteMatched: function (oEvt) {

				this._sNewId = oEvt.getParameter("arguments").id;
				this._sNewTab = oEvt.getParameter("arguments").sectionTab;

				ControlsInfo.loadData().then(function (oData) {
					this._loadSample(oData);
				}.bind(this));

				this.searchResultsButtonVisibilitySwitch(this.getView().byId("entityBackToSearch"));
			},

			onToggleFullScreen: function (oEvt) {
				ToggleFullScreenHandler.updateMode(oEvt, this.getView(), this);
			},

			// ========= internal ===========================================================================
			_getViewData: function (sId, oDoc, oEntity, oControlsData) {

				// convert docu
				var oData = this._convertEntityInfo(sId, oDoc, oControlsData),
					bShouldShowSamplesSection = false,
					iSamplesCount = 0;

				if (oEntity) {

					// show the description as intro text if the entity is not deprecated
					if (!oData.shortDescription && oEntity.description) {
						oData.shortDescription = oEntity.description;
					}

					// make intro text active if a documentation link is set
					if (oEntity.docuLink) {
						oData.show.introLink = true;
						oData.docuLink = oEntity.docuLink;
					}

					bShouldShowSamplesSection = oEntity.samples.length > 0;
					iSamplesCount = oEntity.samples.length;
				}

				// apply entity related stuff
				oData.show.samples = bShouldShowSamplesSection;
				oData.count.samples = iSamplesCount;
				oData.entity = oEntity;

				// done
				return oData;
			},

			_convertEntityInfo: function (sId, oDoc, oControlsData) {

				// create skeleton data structure
				var oData = {
					name: sId,
					deprecated: (oDoc) ? this._formatDeprecated(oDoc.deprecation) : null,
					deprecatedMark: (oDoc) ? this._createDeprecatedMark(oDoc.deprecation) : null,
					baseType: (oDoc) ? this._formatType(oDoc.baseType) : null,
					baseTypeText: (oDoc) ? this._formatTypeText(oDoc.baseType) : "-",
					baseTypeNav: (oDoc) ? this._formatTypeNav(oDoc.baseType) : null,
					shortDescription: (oDoc) ? this._formatDeprecatedDescription(oDoc.deprecation) : null,
					description: (oDoc) ? this._wrapInSpanTag(oDoc.doc) : null,
					docuLink: null,
					values: oDoc ? oDoc.values : [],
					show: {
						baseType: (oDoc) ? !!oDoc.baseType : false,
						about: !!oDoc,
						values: false,
						introActive: false
					},
					count: {
						samples: 0
					},
					appComponent: this._getControlComponent(sId, oControlsData)
				};

				// no documentation !
				if (!oDoc) {
					return oData;
				}

				// determine if the parts shall be shown
				oData.show.values = Array.isArray(oData.values) && oData.values.length > 0;

				return oData;
			},

			/**
			 * Sets the boolean-as-string flag
			 */
			_formatDeprecated: function (sDeprecation) {
				return (sDeprecation && sDeprecation.length > 0) ? "true" : "false";
			},

			/**
			 * Adds the string "Deprecated" in front of the deprecation description.
			 */
			_formatDeprecatedDescription: function (sDeprecation) {
				return (sDeprecation && sDeprecation.length > 0 ) ? (this._createDeprecatedMark(sDeprecation) + ": " + sDeprecation) : null;
			},

			/**
			 * Converts the type to navigable type
			 */
			_formatType: function (sType) {
				if (!sType) {
					return null;
				} else {
					// remove arrays
					return sType.replace("[]", "");
				}
			},

			/**
			 * Converts the type to a friendly readable text
			 */
			_formatTypeText: function (sType) {
				if (!sType) {
					return null;
				} else {
					// remove core prefix
					sType = sType.replace("sap.ui.core.", "");
					// only take text after last dot
					var index = sType.lastIndexOf(".");
					return (index !== -1) ? sType.substr(index + 1) : sType;
				}
			},

			/**
			 * Converts the deprecated boolean to a human readable text
			 */
			_createDeprecatedMark: function (sDeprecated) {
				return (sDeprecated) ? "Deprecated" : "";
			},

			_switchPageTab: function () {

				var oSection = this.getView().byId(this._sNewTab);
				if (!oSection) {
					return;
				}
				if (this._oObjectPage) {
					this._oObjectPage.setSelectedSection(oSection.getId());
				}
			},

			backToSearch: function () {
				this.onNavBack();
			},

			/**
			 * Determines if the type can be navigated to
			 */
			_baseTypes: [
				"sap.ui.core.any",
				"sap.ui.core.object",
				"sap.ui.core.function",
				"sap.ui.core.number", // TODO discuss with Thomas, type does not exist
				"sap.ui.core.float",
				"sap.ui.core.int",
				"sap.ui.core.boolean",
				"sap.ui.core.string",
				"sap.ui.core.URI", // TODO discuss with Thomas, type is not a base type (it has documentation)
				"sap.ui.core.ID", // TODO discuss with Thomas, type is not a base type (it has documentation)
				"sap.ui.core.void",
				"sap.ui.core.CSSSize", // TODO discuss with Thomas, type is not a base type (it has documentation)
				"any",
				"object",
				"function",
				"float",
				"int",
				"boolean",
				"string"
			],
			_formatTypeNav: function (sType) {
				return this._baseTypes.indexOf(sType) === -1;
			}
		});
	}
);
}; // end of sap/ui/documentation/sdk/controller/Entity.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.Group.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global location */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.Group.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/Group.controller",[
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/ui/Device"
	], function (BaseController, Device) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.Group", {

			/* =========================================================== */
			/* lifecycle methods										   */
			/* =========================================================== */

			onInit: function () {
				this.getRouter().getRoute("group").attachPatternMatched(this._onGroupMatched, this);
			},

			/* =========================================================== */
			/* begin: internal methods									 */
			/* =========================================================== */

			_onGroupMatched: function (event) {
				this._id = event.getParameter("arguments").id;
			}
		});
	}
);
}; // end of sap/ui/documentation/sdk/controller/Group.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.MasterTreeBaseController') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Common controller for the API Reference & Documentation master controllers (as they both use a tree)
 */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.MasterTreeBaseController'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.FilterOperator'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/MasterTreeBaseController",[
		"jquery.sap.global",
		"./BaseController",
		"./util/TreeUtil",
		"sap/ui/model/Filter",
		"sap/ui/model/FilterOperator"
	], function (jQuery, BaseController, TreeUtil, Filter, FilterOperator) {
		"use strict";

		var TREE_SCROLL_DURATION = 300; // The time in "ms" to scroll the tree in order to move an element to view

		var MasterTreeBaseController = BaseController.extend("sap.ui.documentation.sdk.controller.MasterTreeBaseController", {

			/**
			 * This method tells the utility class that walks the model what are the names of the fields in the model
			 * @param nodeIdField - the field which holds the unique tree node id
			 * @param childrenField - the field which holds the array with the node's children
			 * @private
			 */
			_initTreeUtil: function (nodeIdField, childrenField) {
				this._oTreeUtil = new TreeUtil(nodeIdField, childrenField);
			},

			/**
			 * Makes the tree open all nodes up to the node with "sTopicId" and then selects it
			 * @private
			 */
			_expandTreeToNode: function (sTopicId, oModel) {
				var oTree = this.byId("tree"),
					oData = oModel.getData();

				// Find the path to the new node, traversing the model
				var aTopicIds = this._oTreeUtil.getPathToNode(sTopicId, oData);

				// Expand all nodes on the path to the target node
				var oLastItem;
				aTopicIds.forEach(function(sId) {
					var oItem = this._findTreeItem(sId);
					if (oItem) {
						oTree.getBinding("items").expand(oTree.indexOfItem(oItem));
						oLastItem = oItem;
					}
				}, this);

				// Select the target node and scroll to it
				if (oLastItem) {
					oLastItem.setSelected(true);

					// Only scroll after the dom is ready
					jQuery.sap.delayedCall(0, this, function () {
						if (oLastItem.getDomRef() && !isInViewport(oLastItem.getDomRef())) {
							this._scrollTreeItemIntoView(oLastItem);
						}
					});
				}
			},

			/**
			 * Scans the items aggregation of a sap.m.Tree for an item that has custom data with key="topicId" and value=sId
			 * Note: It's important to always fetch the items before searching as they change dynamically when nodes expand/collapse
			 * @param {string} sId
			 * @returns {null}
			 * @private
			 */
			_findTreeItem: function (sId) {
				var oTree = this.byId("tree");
				var oItems = oTree.getItems();

				for (var i = 0; i < oItems.length; i++) {
					var oCustomData = oItems[i].getCustomData()[0]; // assumes one custom data element only
					if (oCustomData.getKey() === "nodeId" && oCustomData.getValue() === sId) {
						return oItems[i];
					}
				}
				return null;
			},

			_scrollTreeItemIntoView: function (oItem) {
				var oPage = this.byId("page");
				oPage.scrollToElement(oItem.getDomRef(), TREE_SCROLL_DURATION);
			},

			/**
			 * Handler for the SearchField
			 * @param oEvent
			 */
			onTreeFilter: function (oEvent, sFilterPath) {
				var oTree = this.byId("tree");
				var sFilterArgument = oEvent.getParameter("newValue").trim();
				var oBinding = oTree.getBinding("items");

				if (this._filterTimeout) {
					jQuery.sap.clearDelayedCall(this._filterTimeout);
				}

				this._filterTimeout = jQuery.sap.delayedCall(250, this, function () {

					// 0 characters - clear filters and collapse all nodes
					if (sFilterArgument.length === 0) {
						oBinding.filter([]);
						this._collapseAllNodes();
						return;
					}

					var aFilters = [];
					if (sFilterArgument) {
						var oNameFilter = new Filter(sFilterPath, FilterOperator.Contains, sFilterArgument);
						aFilters.push(oNameFilter);
					}

					oBinding.filter(aFilters);
					this._expandAllNodes();

					this._filterTimeout = null;
				});

			},

			_expandAllNodes: function () {
				var oTree = this.byId("tree");
				oTree.expandToLevel(10);
			},

			_collapseAllNodes: function () {
				var oTree = this.byId("tree");
				oTree.collapseAll();
			},

			_expandFirstNodeOnly: function () {
				var oTree = this.byId("tree");
				this._collapseAllNodes();
				oTree.getBinding("items").expand(0);
			},

			/**
			 * Handler for the Expand all button
			 * @param oEvent
			 */
			onTreeExpandAll: function (oEvent) {
				this._expandAllNodes();
			},

			/**
			 * Handler for the Collapse all button
			 * @param oEvent
			 */
			onTreeCollapseAll: function (oEvent) {
				this._collapseAllNodes();
			}
		});

		function isInViewport (oDomElement) {

			var oRect = oDomElement.getBoundingClientRect();

			return (
				oRect.top >= 0 &&
				oRect.left >= 0 &&
				oRect.bottom <= jQuery(document).height() &&
				oRect.right <= jQuery(document).width()
			);
		}

		return MasterTreeBaseController;
	}
);
}; // end of sap/ui/documentation/sdk/controller/MasterTreeBaseController.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.Sample.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global location */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.Sample.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ComponentContainer'); // unlisted dependency retained
jQuery.sap.require('sap.m.Text'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.HTML'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.routing.History'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/Sample.controller",[
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/ui/model/json/JSONModel",
		"sap/ui/core/ComponentContainer",
		"sap/ui/documentation/sdk/controller/util/ControlsInfo",
		"sap/ui/documentation/sdk/util/ToggleFullScreenHandler",
		"sap/m/Text",
		"sap/ui/core/HTML",
		"sap/ui/Device",
		"sap/ui/core/routing/History"
	], function (BaseController, JSONModel, ComponentContainer, ControlsInfo, ToggleFullScreenHandler, Text, HTML, Device, History) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.Sample", {

			/* =========================================================== */
			/* lifecycle methods										   */
			/* =========================================================== */

			onInit: function () {
				this.getRouter().getRoute("sample").attachPatternMatched(this._onSampleMatched, this);

				this._viewModel = new JSONModel({
					showNavButton : true,
					showNewTab: false
				});

				// Load runtime authoring asynchronously
				Promise.all([
					sap.ui.getCore().loadLibrary("sap.ui.fl", {async: true}),
					sap.ui.getCore().loadLibrary("sap.ui.rta", {async: true})
				]).then(this._loadRTA.bind(this));

				this.getView().setModel(this._viewModel);
			},

			/* =========================================================== */
			/* begin: internal methods									 */
			/* =========================================================== */

			_onSampleMatched: function (event) {
				this._sId = event.getParameter("arguments").id;

				ControlsInfo.loadData().then(function (oData) {
					this._loadSample(oData);
				}.bind(this));
			},

			_loadSample: function(oData) {
				var oSample = oData.samples[this._sId],
					oContent;

				if (!oSample) {
					return;
				}

				// set nav button visibility
				var oPage = this.getView().byId("page");
				var oHistory = History.getInstance();
				var oPrevHash = oHistory.getPreviousHash();
				var oModelData = this._viewModel.getData();
				oModelData.showNavButton = Device.system.phone || !!oPrevHash;
				oModelData.previousSampleId = oSample.previousSampleId;
				oModelData.nextSampleId = oSample.nextSampleId;

				// set page title
				oPage.setTitle("Sample: " + oSample.name);

				try {
					oContent = this._createComponent();
				} catch (ex) {
					oPage.removeAllContent();
					oPage.addContent(new Text({ text : "Error while loading the sample: " + ex }));
					return;
				}

				// Store a reference to the currently opened sample on the application component
				this.getOwnerComponent()._oCurrentOpenedSample = oContent ? oContent : undefined;

				//get config
				var oConfig = (this._oComp.getMetadata()) ? this._oComp.getMetadata().getConfig() : null;
				var oSampleConfig = oConfig && oConfig.sample || {};

				// only have the option to run standalone if there is an iframe
				oModelData.showNewTab = !!oSampleConfig.iframe;

				if (oSampleConfig.iframe) {
					oContent = this._createIframe(oContent, oSampleConfig.iframe);
				} else {
					this.sIFrameUrl = null;
				}

				// handle stretch content
				var bStretch = !!oSampleConfig.stretch;
				var sHeight = bStretch ? "100%" : null;
				oPage.setEnableScrolling(!bStretch);
				if (oContent.setHeight) {
					oContent.setHeight(sHeight);
				}
				// add content
				oPage.removeAllContent();
				oPage.addContent(oContent);

				// scroll to top of page
				oPage.scrollTo(0);
				this._viewModel.setData(oModelData);
			},


			onNewTab : function () {
				sap.m.URLHelper.redirect(this.sIFrameUrl, true);
			},

			onPreviousSample: function (oEvent) {
				this.getRouter().navTo("sample", {
					id: this._viewModel.getProperty("/previousSampleId")
				}, true);
			},

			onNextSample: function (oEvent) {
				this.getRouter().navTo("sample", {
					id: this._viewModel.getProperty("/nextSampleId")
				}, true);
			},

			_createIframe : function (oIframeContent, vIframe) {
				var sSampleId = this._sId,
					rExtractFilename = /\/([^\/]*)$/,// extracts everything after the last slash (e.g. some/path/index.html -> index.html)
					rStripUI5Ending = /\..+$/,// removes everything after the first dot in the filename (e.g. someFile.qunit.html -> .qunit.html)
					aFileNameMatches,
					sFileName,
					sFileEnding;

				if (typeof vIframe === "string") {
					// strip the file extension to be able to use jQuery.sap.getModulePath
					aFileNameMatches = rExtractFilename.exec(vIframe);
					sFileName = (aFileNameMatches && aFileNameMatches.length > 1 ? aFileNameMatches[1] : vIframe);
					sFileEnding = rStripUI5Ending.exec(sFileName)[0];
					var sIframeWithoutUI5Ending = vIframe.replace(rStripUI5Ending, "");

					// combine namespace with the file name again
					this.sIFrameUrl = jQuery.sap.getModulePath(sSampleId + "." + sIframeWithoutUI5Ending, sFileEnding || ".html");
				} else {
					jQuery.sap.log.error("no iframe source was provided");
					return;
				}

				if (!this._oHtmlControl) {
					this._oHtmlControl = new HTML({
						id : "sampleFrame",
						content : '<iframe src="' + this.sIFrameUrl + '" id="sampleFrame" frameBorder="0"></iframe>'
					}).addEventDelegate({
						onAfterRendering : function () {

							// Do not attach on "load" event on every onAfterRendering of the HTML control
							if (!this._oHtmlControl._jQueryHTMLControlLoadEventAttached) {
								this._oHtmlControl.$().on("load", function () {
									var oSampleFrame = this._oHtmlControl.$()[0].contentWindow;

									// Apply theme settings to iframe sample
									oSampleFrame.sap.ui.getCore().attachInit(function () {
										var bCompact = this.getRootView().hasStyleClass("sapUiSizeCompact");

										oSampleFrame.sap.ui.getCore().applyTheme(this._oCore.getConfiguration().getTheme());
										oSampleFrame.sap.ui.getCore().getConfiguration().setRTL(this._oCore.getConfiguration().getRTL());
										oSampleFrame.jQuery('body')
											.toggleClass("sapUiSizeCompact", bCompact)
											.toggleClass("sapUiSizeCozy", bCompact);
									}.bind(this));
								}.bind(this));

								this._oHtmlControl._jQueryHTMLControlLoadEventAttached = true;
							}

						}.bind(this)
					});
				} else {
					// If we already have the control just navigate to the new URL
					this._oHtmlControl.getDomRef().src = this.sIFrameUrl;
				}

				return this._oHtmlControl;

			},

			_createComponent : function () {
				// create component only once
				var sCompId = 'sampleComp-' + this._sId;
				var sCompName = this._sId;

				this._oComp = sap.ui.component(sCompId);

				if (this._oComp) {
					this._oComp.destroy();
				}

				this._oComp = sap.ui.getCore().createComponent({
					id : sCompId,
					name : sCompName
				});
				// create component container
				return new ComponentContainer({
					component: this._oComp
				});
			},

			onNavBack : function (oEvt) {
				this.getRouter().myNavBack("home", {});
			},

			onNavToCode : function (evt) {
				this.getRouter().navTo("code", {
					id : this._sId
				}, false);
			},

			onToggleFullScreen : function (oEvt) {
				ToggleFullScreenHandler.updateMode(oEvt, this.getView(), this);
			},

			_oRTA : null,

			_loadRTA: function () {
				sap.ui.require([
					"sap/ui/fl/Utils",
					"sap/ui/fl/FakeLrepConnectorLocalStorage"
				], function (
					Utils,
					FakeLrepConnectorLocalStorage
				) {

					// fake stable IDs
					Utils.checkControlId = function() {
						return true;
					};

					FakeLrepConnectorLocalStorage.enableFakeConnector({
						"isProductiveSystem": true
					});
					this.getView().byId("toggleRTA").setVisible(true);

					this.getRouter().attachRouteMatched(function () {
						if (this._oRTA) {
							this._oRTA.destroy();
							this._oRTA = null;
						}
					}, this);
				}.bind(this));
			},

			onToggleAdaptationMode : function (oEvt) {
				sap.ui.require([
					"sap/ui/rta/RuntimeAuthoring"
				], function (
					RuntimeAuthoring
				) {
					if (!this._oRTA) {
						this._oRTA = new RuntimeAuthoring();
						this._oRTA.setRootControl(this.getView().byId("page").getContent()[0]);
						this._oRTA.start();
					}
				}.bind(this));
			}
		});
	}
);
}; // end of sap/ui/documentation/sdk/controller/Sample.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.SearchPage.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global location */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.SearchPage.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.m.GroupHeaderListItem'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/SearchPage.controller",[
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/ui/model/json/JSONModel",
		"sap/m/GroupHeaderListItem"
	], function (BaseController, JSONModel, GroupHeaderListItem) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.SearchPage", {

			/* =========================================================== */
			/* lifecycle methods										   */
			/* =========================================================== */

			onInit: function () {
				this.setModel(new JSONModel());
				this.bindListResults();
				this.getRouter().getRoute("search").attachPatternMatched(this._onTopicMatched, this);
			},

			bindListResults: function () {
				this.dataObject = {data:[]};
				this.getModel().setData(this.dataObject);
			},

			/* =========================================================== */
			/* begin: internal methods									 */
			/* =========================================================== */

			/**
			 * Binds the view to the object path and expands the aggregated line items.
			 * @function
			 * @param {sap.ui.base.Event} event pattern match event in route 'topicId'
			 * @private
			 */
			_onTopicMatched: function (event) {
				var that = this,
					sQuery = event.getParameter("arguments").searchParam;
				this.dataObject.searchTerm = sQuery;
				this.getModel().refresh();

				try {
					this.hideMasterSide();
				} catch (e) {
					// try-catch due to a bug in UI5 SplitApp, CL 1898264 should fix it
					jQuery.sap.log.error(e);
				}

				// Build the full query strings, escape special characters
				var sQueryDoc = "(category:topics) AND (" + encodeURIComponent(sQuery) + ")";
				var sQueryApi = "(category:apiref) AND (" + encodeURIComponent(sQuery) + ")";
				var sQueryExplored = "(category:entity) AND (" + encodeURIComponent(sQuery) + ")";

				var PromiseDoc = new Promise(function (resolve) {
					jQuery.ajax({
						url: "search?q=" + sQueryDoc,
						dataType : "json",
						success : function(oData, sStatus, xhr) {
							resolve(oData, sStatus, xhr);
						},
						error : function() {
							resolve([]);
						}
					});
				});

				var PromiseApi = new Promise(function (resolve) {
					jQuery.ajax({
						url: "search?q=" + sQueryApi,
						dataType : "json",
						success : function(oData, sStatus, xhr) {
							resolve(oData, sStatus, xhr);
						},
						error : function() {
							resolve([]);
						}
					});
				});

				var PromiseExplored = new Promise(function (resolve) {
					jQuery.ajax({
						url: "search?q=" + sQueryExplored,
						dataType : "json",
						success : function(oData, sStatus, xhr) {
							resolve(oData, sStatus, xhr);
						},
						error : function() {
							resolve([]);
						}
					});
				});

				Promise.all([PromiseDoc, PromiseApi, PromiseExplored]).then(function(result) {
					var oData = {},
						oResultDoc = result[0][0] || {},
						oResultApi = result[1][0] || {},
						oResultExplored = result[2][0] || {};

					oResultDoc.matches = oResultDoc.matches || [];
					oResultApi.matches = oResultApi.matches || [];
					oResultExplored.matches = oResultExplored.matches || [];

					oData.success = oResultDoc.success || oResultApi.success || oResultExplored.success || false;
					oData.totalHits = (oResultDoc.totalHits + oResultApi.totalHits + oResultExplored.totalHits) || 0;
					oData.matches = oResultDoc.matches.concat(oResultApi.matches).concat(oResultExplored.matches);
					that.processResult(oData);
				 }).catch(function(reason) {
					 // implement catch function to prevent uncaught errors message
				 });
			},

			processResult : function (oData) {
				this.dataObject.data = [];
				this.dataObject.dataAPI = [];
				this.dataObject.dataDoc = [];
				this.dataObject.dataExplored = [];
				this.dataObject.AllLength = 0;
				this.dataObject.APILength = 0;
				this.dataObject.DocLength = 0;
				this.dataObject.ExploredLength = 0;
				if ( oData && oData.success ) {
					if ( oData.totalHits == 0 ) {
						jQuery(".sapUiRrNoData").html("No matches found.");
					} else {
						for (var i = 0; i < oData.matches.length; i++) {
							var oDoc = oData.matches[i];
							//TODO: Find a nicer Date formatting procedure
							oDoc.modifiedStr = oDoc.modified + "";
							var sModified = oDoc.modifiedStr.substring(0,4) + "/" + oDoc.modifiedStr.substring(4,6) + "/" + oDoc.modifiedStr.substring(6,8) + ", " + oDoc.modifiedStr.substring(8,10) + ":" + oDoc.modifiedStr.substring(10),
								sNavURL = oDoc.path,
								bShouldAddToSearchResults = false,
								sCategory;
							if (sNavURL.indexOf("topic/") === 0) {
								sNavURL = sNavURL.substring("topic/".length, sNavURL.lastIndexOf(".html"));
								sNavURL = "topicId/" + sNavURL;
								bShouldAddToSearchResults = true;
								sCategory = "Documentation";
								this.dataObject.dataDoc.push({
									index: this.dataObject.DocLength,
									title: oDoc.title ? oDoc.title : "Untitled",
									path: sNavURL,
									summary: oDoc.summary ? (oDoc.summary + "...") : "",
									score: oDoc.score,
									modified: sModified,
									category: sCategory
								});
								this.dataObject.DocLength++;
							} else if (sNavURL.indexOf("entity/") === 0 ) {
								bShouldAddToSearchResults = true;
								sCategory = "Samples";
								this.dataObject.dataExplored.push({
									index: this.dataObject.ExploredLength,
									title: oDoc.title ? oDoc.title : "Untitled",
									path: sNavURL,
									summary: oDoc.summary ? (oDoc.summary + "...") : "",
									score: oDoc.score,
									modified: sModified,
									category: sCategory
								});
								this.dataObject.ExploredLength++;
							} else if (sNavURL.indexOf("docs/api/symbols/") === 0) {
								sNavURL = sNavURL.substring("docs/api/symbols/".length, sNavURL.lastIndexOf(".html"));
								sNavURL = "apiId/" + sNavURL;
								bShouldAddToSearchResults = true;
								sCategory = "API Reference";
								this.dataObject.dataAPI.push({
									index: this.dataObject.APILength,
									title: oDoc.title ? oDoc.title : "Untitled",
									path: sNavURL,
									summary: oDoc.summary ? (oDoc.summary + "...") : "",
									score: oDoc.score,
									modified: sModified,
									category: sCategory
								});
								this.dataObject.APILength++;
							}

							if (bShouldAddToSearchResults) {
								this.dataObject.data.push({
									index: i,
									title: oDoc.title ? oDoc.title : "Untitled",
									path: sNavURL,
									summary: oDoc.summary ? (oDoc.summary + "...") : "",
									score: oDoc.score,
									modified: sModified,
									category: sCategory
								});
								this.dataObject.AllLength++;
							}
						}
					}
				} else {
					jQuery(".sapUiRrNoData").html("Search failed, please retry ...");
				}
				this.getModel().refresh();
			},

			getGroupHeader : function (oGroup) {
				return new GroupHeaderListItem( {
					title: oGroup.key,
					upperCase: false
				} );
			},

			categoryAPIFormatter : function (sCategory) {
				return sCategory === "API Reference";
			},

			categoryDocFormatter : function (sCategory) {
				return sCategory === "Documentation";
			},

			categoryExploredFormatter : function (sCategory) {
				return sCategory === "Samples";
			},

			onAllLoadMore : function (oEvent) {
				this.dataObject.visibleAllLength = oEvent.getParameter("actual");
				this.getModel().refresh();
			},

			onAPILoadMore : function (oEvent) {
				this.dataObject.visibleAPILength = oEvent.getParameter("actual");
				this.getModel().refresh();
			},

			onDocLoadMore : function (oEvent) {
				this.dataObject.visibleDocLength = oEvent.getParameter("actual");
				this.getModel().refresh();
			},

			onExploredLoadMore : function (oEvent) {
				this.dataObject.visibleExploredLength = oEvent.getParameter("actual");
				this.getModel().refresh();
			},

			openSearchResult : function (oControlEvent) {
				var aNavParams,
					oCustomData = oControlEvent.getSource().getCustomData()[0];
				if (oCustomData.getKey() === "path") {
					aNavParams = oCustomData.getValue().split("/");
				}
				this.getRouter().navTo(aNavParams[0], {id: aNavParams[1]}, false);
			}

		});

	}
);
}; // end of sap/ui/documentation/sdk/controller/SearchPage.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.TopicDetail.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global location */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.TopicDetail.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/TopicDetail.controller",[
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/ui/model/json/JSONModel",
		"sap/ui/documentation/sdk/controller/util/XML2JSONUtils",
		"sap/ui/Device",
		"sap/ui/documentation/sdk/util/ToggleFullScreenHandler"
	], function (BaseController, JSONModel, XML2JSONUtils, Device, ToggleFullScreenHandler) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.TopicDetail", {


			/* =========================================================== */
			/* lifecycle methods										   */
			/* =========================================================== */

			onInit: function () {
				this.oPage = this.byId("topicDetailPage");
				this.oPage.addStyleClass('docuPage');

				if ( !window.prettyPrint ) {
					jQuery.sap.require("sap.ui.documentation.sdk.thirdparty.google-code-prettify.prettify");
				}

				this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched, this);
				this._oConfig = this.getConfig();

				this.jsonDefModel = new JSONModel();
				this.getView().setModel(this.jsonDefModel);
			},

			onBeforeRendering: function() {
				Device.orientation.detachHandler(this._onOrientationChange, this);
			},

			onAfterRendering: function() {
				Device.orientation.attachHandler(this._onOrientationChange, this);
			},

			onExit: function() {
				Device.orientation.detachHandler(this._onOrientationChange, this);
			},

			/* =========================================================== */
			/* begin: internal methods									 */
			/* =========================================================== */

			/**
			 * Binds the view to the object path and expands the aggregated line items.
			 * @function
			 * @param {sap.ui.base.Event} event pattern match event in route 'topicId'
			 * @private
			 */
			_onTopicMatched: function (event) {
				var topicId = event.getParameter("arguments").id,
					topicURL = this._oConfig.docuPath + topicId + (topicId.match(/\.html/) ? "" : ".html"),
					htmlContent = jQuery.sap.syncGetText(topicURL).data,
					jsonObj;

				if (!htmlContent) {
					return;
				}

				jsonObj = XML2JSONUtils.XML2JSON(htmlContent, this._oConfig);
				jsonObj.topicURL = topicURL;


				this.jsonDefModel.setData(jsonObj);

				this._scrollContentToTop();

				setTimeout(window.prettyPrint, 0);

				this.searchResultsButtonVisibilitySwitch(this.getView().byId("topicDetailBackToSearch"));

				if (this.extHookonTopicMatched) {
					this.extHookonTopicMatched(topicId);
				}
			},

			_scrollContentToTop: function () {
				if (this.oPage && this.oPage.$().length > 0) {
					this.oPage.getScrollDelegate().scrollTo(0, 1);
				}
			},

			_formatHTML: function(html) {
				return '<div>' + html + '</div>';
			},

			_onOrientationChange: function(e) {
				var page = this.getView().byId("topicDetailPage");

				if (e.landscape) {
					page.setShowHeader(false);
				} else {
					page.setShowHeader(true);
				}
			},

			backToSearch: function (text) {
				this.onNavBack();
			},

			onToggleFullScreen: function(oEvent) {
				ToggleFullScreenHandler.updateMode(oEvent, this.getView(), this);
			}

		});

	}
);
}; // end of sap/ui/documentation/sdk/controller/TopicDetail.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.TopicDetailInitial.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global location */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.TopicDetailInitial.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/TopicDetailInitial.controller",[
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/ui/Device"
	], function (BaseController, Device) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.TopicDetailInitial", {

			/**
			 * Called when the controller is instantiated.
			 * @public
			 */
			onInit: function () {
				// manually call the handler once at startup as device API won't do this for us
				this._onOrientationChange({
					landscape: Device.orientation.landscape
				});
			},

			/**
			 * Called before the view is rendered.
			 * @public
			 */
			onBeforeRendering: function() {
				this._deregisterOrientationChange();
			},

			/**
			 * Called after the view is rendered.
			 * @public
			 */
			onAfterRendering: function() {
				this._registerOrientationChange();
			},

			/**
			 * Called when the controller is destroyed.
			 * @public
			 */
			onExit: function() {
				this._deregisterOrientationChange();
			}

		});

	}
);
}; // end of sap/ui/documentation/sdk/controller/TopicDetailInitial.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.TopicMaster.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global history */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.TopicMaster.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/TopicMaster.controller",[
		"sap/ui/documentation/sdk/controller/MasterTreeBaseController",
		"sap/ui/documentation/sdk/controller/util/APIInfo",
		"sap/ui/model/json/JSONModel"
	], function (MasterTreeBaseController, APIInfo, JSONModel) {
		"use strict";

		return MasterTreeBaseController.extend("sap.ui.documentation.sdk.controller.TopicMaster", {

			/**
			 * Called when the master list controller is instantiated. It sets up the event handling for the master/detail communication and other lifecycle tasks.
			 * @public
			 */
			onInit : function () {
				this.oJSONContent = this._fetchDocuIndex();
				var oModel = new JSONModel(this.oJSONContent);
				this.getView().setModel(oModel);

				this._initTreeUtil("key", "links");

				this.getRouter().getRoute("topic").attachPatternMatched(this._onMatched, this);
				this.getRouter().getRoute("topicId").attachPatternMatched(this._onTopicMatched, this);
			},

			_onTopicMatched: function (event) {

				try {
					this.showMasterSide();
				} catch (e) {
					// try-catch due to a bug in UI5 SplitApp, CL 1898264 should fix it
					jQuery.sap.log.error(e);
				}

				this._topicId = event.getParameter("arguments").id;

				this._expandTreeToNode(this._topicId, this.getModel());
			},

			_onMatched: function () {
				var splitApp = this.getView().getParent().getParent();
				splitApp.setMode(sap.m.SplitAppMode.ShowHideMode);

				// When no particular topic is selected, expand the first node of the tree only
				this._expandFirstNodeOnly();
			},

			_fetchDocuIndex : function () {
				var oResponse = jQuery.sap.syncGetJSON(this.getConfig().docuPath + "index.json");
				if (oResponse.data === undefined) {
					return [];
				}

				var oData = oResponse.data.links;
				return this._preProcessDocuIndex(oData);
			},

			_preProcessDocuIndex: function (oData) {
				var sMainSectionId = "95d113be50ae40d5b0b562b84d715227",
					sTestPagesSectionId = "1b4124400a764ec0a8623d0d5c585321",
					oProcessedData,
					iTestPagesSectionIndex,
					oTestPagesSection,
					oMainSection;

				// Remove dummy top-level elements (either empty text, or key=index)
				oProcessedData = oData.filter(function (oEntry) {
					return oEntry.text !== "" && oEntry.key !== "index";
				});

				// Search for the sections that we're interested in (main and test pages)
				for (var i = 0; i < oProcessedData.length; i++) {
					if (oProcessedData[i].key === sMainSectionId) {
						oMainSection = oProcessedData[i];
					} else if (oProcessedData[i].key === sTestPagesSectionId) {
						oTestPagesSection = oProcessedData[i];
						iTestPagesSectionIndex = i;
					}
				}

				// If there is a "Test Pages" section, move it as the last element of the main section
				if (oMainSection && oTestPagesSection) {
					oProcessedData.splice(iTestPagesSectionIndex, 1);
					oMainSection.links.push(oTestPagesSection);
				}

				return oProcessedData;
			},

			onNodeSelect : function (oEvent) {
				var oNode = oEvent.getParameter("listItem"),
					sTopicId = oNode.getCustomData()[0].getValue(),
					oRouter;

				if (!sTopicId) {
					jQuery.sap.log.warning("Missing key for entity: " + oNode.getId() + " - cannot navigate to topic");
					return;
				}

				oRouter = this.getRouter();

				// Special case for release notes - we need to navigate to a different route
				if (sTopicId === "a6a78b7e104348b4bb94fb8bcf003480") {
					oRouter.navTo("releaseNotes");
					return;
				}

				oRouter.navTo("topicId", {id : sTopicId}, false);
			},

			onTreeFilter: function (oEvent) {
				MasterTreeBaseController.prototype.onTreeFilter.apply(this, [oEvent, "text"]);
			}

		});
	}
);
}; // end of sap/ui/documentation/sdk/controller/TopicMaster.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.Welcome.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global history */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.Welcome.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.m.library'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/Welcome.controller",[
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/m/library",
		"sap/ui/Device"
	], function (BaseController, mobileLibrary, Device) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.Welcome", {

			/**
			 * Called when the controller is instantiated.
			 * @public
			 */
			onInit: function () {
				this.getRouter().getRoute("welcome").attachPatternMatched(this._onMatched, this);

				// manually call the handler once at startup as device API won't do this for us
				this._onOrientationChange({
					landscape: Device.orientation.landscape
				});
			},

			/**
			 * Called before the view is rendered.
			 * @public
			 */
			onBeforeRendering: function() {
				this._deregisterOrientationChange();
			},

			/**
			 * Called after the view is rendered.
			 * @public
			 */
			onAfterRendering: function() {
				this._registerOrientationChange();
			},

			/**
			 * Called when the controller is destroyed.
			 * @public
			 */
			onExit: function() {
				this._deregisterOrientationChange();
			},

			/**
			 * Opens the control's details page
			 * @param event
			 */
			navigateToDetails: function (event) {
				var href = event.oSource.getHref() || event.oSource.getTarget();
				href = href.replace("#/", "").split('/');
				/** @type string */
				var page = href[0];
				/** @type string */
				var parameter = href[1];

				event.preventDefault();
				this.getRouter().navTo(page, {id: parameter}, true);
			},

			/**
			 * Navigates to the tutorial overview
			 */
			onGetStarted: function () {
				mobileLibrary.URLHelper.redirect("#/topic/8b49fc198bf04b2d9800fc37fecbb218");
			},

			/**
			 * Handles "welcome" routing
			 * @function
			 * @private
			 */
			_onMatched: function () {
				try {
					this.hideMasterSide();
				} catch (e) {
					// try-catch due to a bug in UI5 SplitApp, CL 1898264 should fix it
					jQuery.sap.log.error(e);
				}
			}
		});
	}
);
}; // end of sap/ui/documentation/sdk/controller/Welcome.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.demoapps.Component') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.documentation.demoapps.Component'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.UIComponent'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/demoapps/Component",[
	'sap/ui/core/UIComponent',
	'sap/ui/model/json/JSONModel',
	'sap/ui/documentation/demoapps/model/libraryData',
	"sap/ui/documentation/demoapps/model/models"
], function(UIComponent, JSONModel, libraryData, models) {
	"use strict";

	return UIComponent.extend("sap.ui.documentation.demoapps.Component", {
		metadata : {
			manifest:"json"
		},

		init : function () {
			// call base class constructor
			UIComponent.prototype.init.apply(this, arguments);

			// set the device model
			this.setModel(models.createDeviceModel(), "device");

			// load demo app metadata from docuindex of all available libraries
			var oModel = new JSONModel();
			libraryData.fillJSONModel(oModel);
			this.setModel(oModel);
		}
	});
});

}; // end of sap/ui/documentation/demoapps/Component.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.ApiDetail.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global location */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.ApiDetail.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.uxap.ObjectPageSubSection'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/ApiDetail.controller",[
		"jquery.sap.global",
		"sap/ui/Device",
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/ui/model/json/JSONModel",
		"sap/ui/documentation/sdk/controller/util/ControlsInfo",
		"sap/ui/documentation/sdk/util/ToggleFullScreenHandler",
		"sap/uxap/ObjectPageSubSection",
		"sap/ui/documentation/sdk/controller/util/JSDocUtil"
	], function (jQuery, Device, BaseController, JSONModel, ControlsInfo, ToggleFullScreenHandler, ObjectPageSubSection, JSDocUtil) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.ApiDetail", {

			METHOD: 'method',
			EVENT: 'event',
			PARAM: 'param',
			NOT_AVAILABLE: 'N/A',
			ANNOTATIONS_LINK: 'http://docs.oasis-open.org/odata/odata/v4.0/odata-v4.0-part3-csdl.html',
			ANNOTATIONS_NAMESPACE_LINK: 'http://docs.oasis-open.org/odata/odata/v4.0/errata02/os/complete/vocabularies/',
			ANNOTATION_DESCRIPTION_STRIP_REGEX: /<i>XML[\s\S].*Example/,

			/**
			 * Determines if the type can be navigated to
			 */
			_baseTypes: [
				"sap.ui.core.any",
				"sap.ui.core.object",
				"sap.ui.core.function",
				"sap.ui.core.number", // TODO discuss with Thomas, type does not exist
				"sap.ui.core.float",
				"sap.ui.core.int",
				"sap.ui.core.boolean",
				"sap.ui.core.string",
				"sap.ui.core.URI", // TODO discuss with Thomas, type is not a base type (it has documentation)
				"sap.ui.core.ID", // TODO discuss with Thomas, type is not a base type (it has documentation)
				"sap.ui.core.void",
				"sap.ui.core.CSSSize", // TODO discuss with Thomas, type is not a base type (it has documentation)
				"null",
				"any",
				"object",
				"object[]",
				"object|object[]",
				"function",
				"float",
				"int",
				"boolean",
				"string",
				"string[]",
				"number"
			],

			/* =========================================================== */
			/* lifecycle methods										   */
			/* =========================================================== */

			onInit: function () {
				this._objectPage = this.byId("apiDetailObjectPage");
				this.getRouter().getRoute("apiId").attachPatternMatched(this._onTopicMatched, this);

				// click handler for @link tags in JSdoc fragments
				this.getView().attachBrowserEvent("click", this.onJSDocLinkClick, this);

				this.setModel(new JSONModel(), "topics");
				this.setModel(new JSONModel(), "constructorParams");
				this.setModel(new JSONModel(), 'methods');
				this.setModel(new JSONModel(), 'events');
				this.setModel(new JSONModel(), "entity");
				this.setModel(new JSONModel(), "borrowedMethods");
				this.setModel(new JSONModel(), "borrowedEvents");

				this.getView().byId("apiDetailObjectPage").attachEvent("onAfterRenderingDOMReady", function () {
					jQuery.sap.delayedCall(250, this, function () {
						this._scrollToEntity(this._sEntityType, this._sEntityId);
					});
				}, this);
			},

			onAfterRendering: function () {
				this._createMethodsSummary();
				this._createEventsSummary();
				this._createAnnotationsSummary();
			},

			onExit: function () {
				this.getView().detachBrowserEvent("click", this.onJSDocLinkClick, this);
			},

			onSampleLinkPress: function (oEvent) {
				// Navigate to Control Sample section
				var sEntityName = oEvent.getSource().data("name");
				this.getRouter().navTo("entity", {id: sEntityName, part: "samples"}, true);
			},

			onToggleFullScreen: function (oEvent) {
				ToggleFullScreenHandler.updateMode(oEvent, this.getView(), this);
			},

			onJSDocLinkClick: function (oEvent) {
				var sRoute = "apiId",
					oComponent = this.getOwnerComponent(),
					aLibsData = oComponent.getModel("libsData").getData(),
					sTarget = oEvent.target.getAttribute("data-sap-ui-target"),
					sMethodName = "",
					aNavInfo;

				if (!sTarget) {
					return;
				}

				if (sTarget.indexOf('/') >= 0) {
					// link refers to a method or event data-sap-ui-target="<class name>/methods/<method name>" OR
					// data-sap-ui-target="<class name>/events/<event name>
					aNavInfo = sTarget.split('/');

					if (aNavInfo[0] === this._sTopicid && aNavInfo[1] === this._sEntityType && aNavInfo[2] === this._sEntityId) {
						this._scrollToEntity(aNavInfo[1], aNavInfo[2]);
					} else {
						oComponent.getRouter().navTo(sRoute, {
							id: aNavInfo[0],
							entityType: aNavInfo[1],
							entityId: aNavInfo[2]
						}, false);
					}
				} else if (!aLibsData[sTarget]) {
					// link refers to a method
					sMethodName = sTarget.slice(sTarget.lastIndexOf('.') + 1);
					sTarget = sTarget.slice(0, sTarget.lastIndexOf("."));

					oComponent.getRouter().navTo(sRoute, {
						id: sTarget,
						entityType: "methods",
						entityId: sMethodName
					}, false);
				} else {
					oComponent.getRouter().navTo(sRoute, {id: sTarget}, false);
				}

				oEvent.preventDefault();
			},

			/* =========================================================== */
			/* begin: internal methods									 */
			/* =========================================================== */

			/**
			 * Binds the view to the object path and expands the aggregated line items.
			 * @function
			 * @param {sap.ui.base.Event} oEvent pattern match event in route 'api'
			 * @private
			 */
			_onTopicMatched: function (oEvent) {
				var oApiDetailObjectPage = this.byId("apiDetailObjectPage");

				this._sTopicid = oEvent.getParameter("arguments").id;
				this._sEntityType = oEvent.getParameter("arguments").entityType;
				this._sEntityId = oEvent.getParameter("arguments").entityId;

				this.getOwnerComponent().fetchAPIInfoAndBindModels().then(function () {

					oApiDetailObjectPage._suppressLayoutCalculations();
					this._bindData(this._sTopicid);
					this._bindEntityData(this._sTopicid);
					this._createMethodsSummary();
					this._createEventsSummary();
					this._createAnnotationsSummary();
					oApiDetailObjectPage._resumeLayoutCalculations();

					if (this._sEntityType) {
						this._scrollToEntity(this._sEntityType, this._sEntityId);
					} else {
						this._scrollContentToTop();
					}

					setTimeout(this._prettify, 0);

					this.searchResultsButtonVisibilitySwitch(this.getView().byId("apiDetailBackToSearch"));

				}.bind(this));

			},

			_prettify: function () {
				// Google Prettify requires this class
				jQuery('pre').addClass('prettyprint');

				window.prettyPrint();
			},

			_createMethodsSummary: function () {
				var oSummaryTable = sap.ui.xmlfragment(this.getView().getId() + "-methodsSummary", "sap.ui.documentation.sdk.view.ApiDetailMethodsSummary", this);
				var oSection = this.getView().byId("methods");

				var aSubSections = oSection.getSubSections();
				if (aSubSections.length > 0 && aSubSections[0].getTitle() === "Summary") {
					return;
				}

				oSection.insertSubSection(new ObjectPageSubSection({
					title: "Summary",
					blocks: [
						oSummaryTable
					]
				}), 0);
			},

			_createEventsSummary: function () {
				var oSummaryTable = sap.ui.xmlfragment(this.getView().getId() + "-eventsSummary", "sap.ui.documentation.sdk.view.ApiDetailEventsSummary", this);
				var oSection = this.getView().byId("events");

				var aSubSections = oSection.getSubSections();
				if (aSubSections.length > 0 && aSubSections[0].getTitle() === "Summary") {
					return;
				}

				oSection.insertSubSection(new ObjectPageSubSection({
					title: "Summary",
					blocks: [
						oSummaryTable
					]
				}), 0);
			},

			_createAnnotationsSummary: function () {
				var oSummaryTable = sap.ui.xmlfragment(this.getView().getId() + "-annotationsSummary", "sap.ui.documentation.sdk.view.ApiDetailAnnotationsSummary", this);
				var oSection = this.getView().byId("annotations");

				var aSubSections = oSection.getSubSections();
				if (aSubSections.length > 0 && aSubSections[0].getTitle() === "Summary") {
					return;
				}

				oSection.insertSubSection(new ObjectPageSubSection({
					title: "Summary",
					blocks: [
						oSummaryTable
					]
				}), 0);
			},

			scrollToMethod: function (oEvent) {
				var oLink = oEvent.getSource();
				this._scrollToEntity("methods", oLink.getText());
			},

			scrollToEvent: function (oEvent) {
				var oLink = oEvent.getSource();
				this._scrollToEntity("events", oLink.getText());
			},

			scrollToAnnotation: function (oEvent) {
				var oLink = oEvent.getSource();
				this._scrollToEntity("annotations", oLink.getText());
			},

			_scrollToEntity: function (sSectionId, sSubSectionTitle) {

				var oSection = this.getView().byId(sSectionId);
				if (!oSection) {
					return;
				}

				var aSubSections = oSection.getSubSections();
				var aFilteredSubSections = aSubSections.filter(function (oSubSection) {
					return oSubSection.getTitle() === sSubSectionTitle;
				});

				if (aFilteredSubSections.length) {
					this.getView().byId("apiDetailObjectPage").scrollToSection(aFilteredSubSections[0].getId(), 250);
				}
			},

			_scrollContentToTop: function () {
				if (this._objectPage && this._objectPage.$().length > 0) {
					this._objectPage.getScrollDelegate().scrollTo(0, 0);
				}
			},

			/**
			 * Creates the <code>Entity</code> model,
			 * based on the <code>ControlsInfo</code> data.
			 * <b>Note:</b>
			 * The method is called in the <code>_onControlsInfoLoaded</code> callBack
			 * just once, when the <code>ControlsInfo</code> is loaded.
			 * After that, the method is called in <code>_onTopicMatched</code>,
			 * whenever a different topic has been selected.
			 */
			_bindEntityData: function (sTopicId) {

				ControlsInfo.loadData().then(function (oControlsData) {
					var oEntityData = this._getEntityData(sTopicId, oControlsData);

					this.getModel("entity").setData(oEntityData, false);
				}.bind(this));

			},

			_bindData: function (sTopicId) {
				var aLibsData = this.getOwnerComponent().getModel("libsData").getData(),
					oControlData = aLibsData[sTopicId],
					aTreeData = this.getOwnerComponent().getModel("treeData").getData(),
					aControlChildren = this._getControlChildren(aTreeData, sTopicId),
					oModel,
					oConstructorParamsModel = {parameters: []},
					oBorrowedMethodsModel,
					oMethodsModelData = {methods: []},
					oMethodsModel,
					oEventsModel = {events: []},
					oUi5Metadata;


				if (aControlChildren) {
					if (!oControlData) {
						oControlData = {};
					}
					oControlData.controlChildren = aControlChildren;
					this._addChildrenDescription(aLibsData, oControlData.controlChildren);
				}

				oUi5Metadata = oControlData['ui5-metadata'];

				this.getView().byId('apiDetailPage').setBusy(false);
				this.getView().byId('apiDetailObjectPage').setVisible(true);

				if (oControlData.controlChildren) {
					oControlData.hasChildren = true;
				} else {
					oControlData.hasChildren = false;
				}

				if (oControlData.hasOwnProperty('properties') && this.hasPublicElement(oControlData.properties)) {
					oControlData.hasProperties = true;
				} else {
					oControlData.hasProperties = false;
				}

				oControlData.hasConstructor = oControlData.hasOwnProperty('constructor');

				if (oUi5Metadata && oUi5Metadata.properties && this.hasPublicElement(oUi5Metadata.properties)) {
					oControlData.hasControlProperties = true;
				} else {
					oControlData.hasControlProperties = false;
				}

				if (oControlData && oControlData.events) {
					oControlData.hasEvents = true;
				} else {
					oControlData.hasEvents = false;
				}

				oControlData.hasMethods = oControlData.hasOwnProperty('methods') &&
					this.hasPublicElement(oControlData.methods);

				if (oUi5Metadata && oUi5Metadata.associations && this.hasPublicElement(oUi5Metadata.associations)) {
					oControlData.hasAssociations = true;
				} else {
					oControlData.hasAssociations = false;
				}

				if (oUi5Metadata && oUi5Metadata.aggregations && this.hasPublicElement(oUi5Metadata.aggregations)) {
					oControlData.hasAggregations = true;
				} else {
					oControlData.hasAggregations = false;
				}

				if (oUi5Metadata && oUi5Metadata.specialSettings && this.hasPublicElement(oUi5Metadata.specialSettings)) {
					oControlData.hasSpecialSettings = true;
				} else {
					oControlData.hasSpecialSettings = false;
				}

				if (oUi5Metadata && oUi5Metadata.annotations && Object.keys(oUi5Metadata.annotations).length > 0) {
					if (!oControlData.hasAnnotations) {
						oUi5Metadata.annotations.unshift({});
					}
					oControlData.hasAnnotations = true;
				} else {
					oControlData.hasAnnotations = false;
				}

				if (oControlData.hasConstructor && oControlData.constructor.parameters) {
					for (var i = 0; i < oControlData.constructor.parameters.length; i++) {
						this.subParamPhoneName = oControlData.constructor.parameters[i].name;
						oConstructorParamsModel.parameters =
							oConstructorParamsModel.parameters.concat(this._getParameters(oControlData.constructor.parameters[i]));
					}
					this.subParamPhoneName = '';
				}

				if (oControlData.hasMethods) {
					oMethodsModelData.methods = this.buildMethodsModel(oControlData.methods);
				}

				if (oControlData.hasEvents) {
					oEventsModel.events = this.buildEventsModel(oControlData.events);
				}

				oControlData.borrowed = this.buildBorrowedModel(sTopicId, aLibsData);

				if (oControlData.implements && oControlData.implements.length) {
					oControlData.implementsParsed = oControlData.implements.map(function (item, idx, array) {
						var aDisplayNameArr = item.split("."),
							sDisplayName = aDisplayNameArr[aDisplayNameArr.length - 1];
						return {
							href: item,
							name: sDisplayName,
							isLast: idx === array.length - 1
						};
					});
					oControlData.hasImplementsData = true;
				} else {
					oControlData.hasImplementsData = false;
				}

				oControlData.isClass = oControlData.kind === "class";
				oControlData.isDerived = !!oControlData.extends;
				oControlData.extendsText = oControlData.extends || this.NOT_AVAILABLE;
				oControlData.sinceText = oControlData.since || this.NOT_AVAILABLE;
				oControlData.module = oControlData.module || this.NOT_AVAILABLE;


				oMethodsModel = this.getModel("methods");
				oBorrowedMethodsModel = this.getModel("borrowedMethods");

				// BPC: 1780339157 - There are cases where we have more than 100 method entries so we need to increase
				// the default model size limit for the methods and the borrowed methods model.
				oMethodsModel.setSizeLimit(1000);
				oBorrowedMethodsModel.setSizeLimit(1000);

				this.getModel("topics").setSizeLimit(1000);
				this.getModel("topics").setData(oControlData, false /* no merge with previous data */);
				this.getModel("constructorParams").setData(oConstructorParamsModel, false /* no merge with previous data */);
				oMethodsModel.setData(oMethodsModelData, false /* no merge with previous data */);
				oMethodsModel.setDefaultBindingMode("OneWay");
				this.getModel('events').setData(oEventsModel, false /* no merge with previous data */);
				this.getModel('events').setDefaultBindingMode("OneWay");
				oBorrowedMethodsModel.setData(oControlData.borrowed.methods, false);
				this.getModel('borrowedEvents').setData(oControlData.borrowed.events, false);

				if (this.extHookbindData) {
					this.extHookbindData(sTopicId, oModel);
				}

				// TODO: This is a temporary solution
				// It's executed here where we have all instances of the CodeEditor created
				this.getView().findAggregatedObjects(true, function (oElement) {
					if (oElement instanceof sap.ui.codeeditor.CodeEditor) {
						// We are replacing the "focus" on the editor instance method as it is
						// triggering the unwanted scroll
						oElement._getEditorInstance().focus = function () {
						};
					}
				});
			},

			_getControlChildren: function (aTreeData, sTopicId) {
				for (var i = 0; i < aTreeData.length; i++) {
					if (aTreeData[i].name === sTopicId) {
						return aTreeData[i].nodes;
					}
				}
			},

			_addChildrenDescription: function (aLibsData, aControlChildren) {
				for (var i = 0; i < aControlChildren.length; i++) {
					aControlChildren[i].description = aLibsData[aControlChildren[i].name].description;
					aControlChildren[i].link = "{@link " + aControlChildren[i].name + "}";
				}
			},

			/**
			 * Retrieves the <code>Entity</code> model data.
			 * @param {Object} oLibData
			 * @return {Object}
			 */
			_getEntityData: function (sEntityName, oControlsData) {
				var aFilteredEntities = oControlsData.entities.filter(function (entity) {
					return entity.id === sEntityName;
				});
				var oEntity = aFilteredEntities.length ? aFilteredEntities[0] : undefined;

				var sAppComponent = this._getControlComponent(sEntityName, oControlsData);

				return {
					appComponent: sAppComponent || this.NOT_AVAILABLE,
					sample: (oEntity && sEntityName) || this.NOT_AVAILABLE,
					hasSample: !!(oEntity && oEntity.sampleCount > 0)
				};
			},

			/**
			 * Adjusts methods info so that it can be easily displayed in a table
			 * @param methods - the methods array initially coming from the server
			 * @returns {Array} - the adjusted array
			 */
			buildMethodsModel: function (methods) {
				var bIsInternalVersion = this.getOwnerComponent().isInternalVersion();

				// No methods, do nothing
				if (!methods.length) {
					return methods;
				}

				var result = methods.filter(function (method) {
					return bIsInternalVersion ? true : method.visibility !== "restricted";
				}).map(function (method) {
					var subParameters = [];
					method.parameters = method.parameters || [];

					// Handle multiple values
					method.parameters = method.parameters.map(function (param) {
						var paramProperties, paramTypes;
						var types = (param.type || "").split("|");
						param.types = [];
						for (var i = 0; i < types.length; i++) {
							param.types.push({
								value: types[i],
								isLast: i === types.length - 1
							});
						}

						if (param.parameterProperties && !method.subParametersInjected) {
							paramProperties = param.parameterProperties;
							for (var prop in paramProperties) {
								paramTypes = (paramProperties[prop].type || "").split("|");
								paramProperties[prop].types = [];
								paramProperties[prop].types = paramTypes.map(function (currentType, idx, array) {
									return {
										value: currentType,
										isLast: idx === array.length - 1
									};
								});
								paramProperties[prop].isSubProperty = true;
								paramProperties[prop].phoneName = param.name + '.' + paramProperties[prop].name;
								subParameters.push(paramProperties[prop]);
							}
						}

						return param;
					});

					// Format return value
					if (method.returnValue) {
						var types = (method.returnValue.type || "").split("|");
						method.returnValue.types = [];
						for (var i = 0; i < types.length; i++) {
							method.returnValue.types.push({
								value: types[i],
								isLast: i === types.length - 1
							});
						}
					}

					if (!method.subParametersInjected) {
						method.parameters = method.parameters.concat(subParameters);
						method.subParametersInjected = true;
					}

					return method;

				});

				// Prepend an empty item so that it is replaced by the summary subsection
				result.unshift({});

				return result;
			},

			buildBorrowedModel: function (sTopicId, aLibsData) {
				var aBaseClassMethods,
					aBaseClassEvents,
					sBaseClass,
					aBorrowChain,
					oBaseClass;

				aBorrowChain = {
					methods: [],
					events: []
				};
				sBaseClass = aLibsData[sTopicId] ? aLibsData[sTopicId].extends : "";

				var fnVisibilityFilter = function (item) {
					return item.visibility === "public";
				};

				var fnMethodsMapper = function (item) {
					return {
						name: item.name,
						link: "#/api/" + sBaseClass + "/methods/" + item.name
					};
				};

				var fnEventsMapper = function (item) {
					return {
						name: item.name,
						link: "#/api/" + sBaseClass + "/events/" + item.name
					};
				};

				while (sBaseClass) {
					oBaseClass = aLibsData[sBaseClass];
					if (!oBaseClass) {
						break;
					}

					aBaseClassMethods = (oBaseClass.methods || []).filter(fnVisibilityFilter).map(fnMethodsMapper);
					if (aBaseClassMethods.length) {
						aBorrowChain.methods.push({
							name: sBaseClass,
							methods: aBaseClassMethods
						});
					}

					aBaseClassEvents = (oBaseClass.events || []).filter(fnVisibilityFilter).map(fnEventsMapper);
					if (aBaseClassEvents.length) {
						aBorrowChain.events.push({
							name: sBaseClass,
							events: aBaseClassEvents
						});
					}

					sBaseClass = oBaseClass.extends;
				}

				return aBorrowChain;
			},

			/**
			 * Adjusts events info so that it can be easily displayed in a table
			 * @param events - the events array initially coming from the server
			 * @returns {Array} - the adjusted array
			 */
			buildEventsModel: function (events) {
				// No events, do nothing
				if (events.length === 0) {
					return events;
				}

				// Transform the key-value pairs of event parameters into an array
				var result = events.map(function (event) {
					if (event.parameters && !event.subParametersInjected) {
						var aParameters = [];
						event.parameters.map(function (oParam) {
							this.subParamPhoneName = oParam.name;
							aParameters = aParameters.concat(this._getParameters(oParam));
						}, this);
						this.subParamPhoneName = '';

						event.parameters = aParameters;
						event.subParametersInjected = true;
					}

					return event;
				}, this);

				// Prepend an empty item so that it is replaced by the summary subsection
				result.unshift({});

				return result;
			},

			subParamLevel: 0,
			subParamPhoneName: '',

			_getParameters: function (oParam) {
				var result = [oParam];

				var types = (oParam.type || "").split("|"),
					paramTypes;

				oParam.types = [];
				for (var i = 0; i < types.length; i++) {
					oParam.types.push({
						value: types[i],
						isLast: i === types.length - 1
					});
				}

				if (oParam.parameterProperties) {
					this.subParamLevel++;
					for (var subParam in oParam.parameterProperties) {
						var subPropertyString = 'is';

						for (var i = 0; i < this.subParamLevel; i++) {
							subPropertyString += 'Sub';
						}

						subPropertyString += 'Property';

						this.subParamPhoneName += '.' + subParam;

						oParam.parameterProperties[subParam][subPropertyString] = true;
						oParam.parameterProperties[subParam].phoneName = this.subParamPhoneName;

						paramTypes = (oParam.parameterProperties[subParam].type || "").split("|");
						oParam.parameterProperties[subParam].types = [];
						oParam.parameterProperties[subParam].types = paramTypes.map(function (currentType, idx, array) {
							return {
								value: currentType,
								isLast: idx === array.length - 1
							};
						});

						result = result.concat(this._getParameters(oParam.parameterProperties[subParam]));

						if (this.subParamPhoneName.indexOf('.') > -1) {
							this.subParamPhoneName = this.subParamPhoneName.substring(0, this.subParamPhoneName.lastIndexOf('.'));
						} else {
							this.subParamPhoneName = '';
						}
					}
					this.subParamLevel--;
				}

				return result;
			},

			/**
			 * Adds "deprecated" information if such exists to the header area
			 * @param deprecated - object containing information about deprecation
			 * @returns {string} - the deprecated text to display
			 */
			formatSubtitle: function (deprecated) {
				var result = "";

				if (deprecated) {
					result += "Deprecated in version: " + deprecated.since;
				}

				return result;
			},

			/**
			 * Formats the constructor of the class
			 * @param name
			 * @param params
			 * @returns string - The code needed to create an object of that class
			 */
			formatConstructor: function (name, params) {
				var result = 'new ';

				if (name) {
					result += name + '(';
				}

				if (params) {
					params.forEach(function (element, index, array) {
						result += element.name;

						if (element.optional) {
							result += '?';
						}

						if (index < array.length - 1) {
							result += ', ';
						}
					});
				}

				if (name) {
					result += ')';
				}

				return result;
			},

			_formatChildDescription: function (description) {
				if (description) {
					description = this._extractFirstSentence(description);
					description = this._wrapInSpanTag(description);
					return "<div>" + description + "<\div>";
				}
			},

			_extractFirstSentence: function (description) {
				var descriptionCopy = description.slice(), iSkipPosition;

				//Control description is not properly formatted and should be skipped.
				if (description.lastIndexOf("}") > description.lastIndexOf(".")) {
					return "";
				}

				descriptionCopy = this._sliceSpecialTags(descriptionCopy, "{", "}");
				descriptionCopy = this._sliceSpecialTags(descriptionCopy, "<code>", "</code>");
				iSkipPosition = description.length - descriptionCopy.length;
				description = description.slice(0, descriptionCopy.indexOf(".") + ".".length + iSkipPosition);
				return description;
			},

			_sliceSpecialTags: function (descriptionCopy, startSymbol, endSymbol) {
				var startIndex, endIndex;
				while (descriptionCopy.indexOf(startSymbol) !== -1 && descriptionCopy.indexOf(startSymbol) < descriptionCopy.indexOf(".")) {
					startIndex = descriptionCopy.indexOf(startSymbol);
					endIndex = descriptionCopy.indexOf(endSymbol);
					descriptionCopy = descriptionCopy.slice(0, startIndex) + descriptionCopy.slice(endIndex + endSymbol.length, descriptionCopy.length);
				}
				return descriptionCopy;
			},

			/**
			 * Formats the default value of the property as a string.
			 * @param defaultValue - the default value of the property
			 * @returns string - The default value of the property formatted as a string.
			 */
			formatDefaultValue: function (defaultValue) {
				switch (defaultValue) {
					case null:
						return '';
					case undefined:
						return '';
					case '':
						return 'empty string';
					default:
						return defaultValue;
				}
			},

			/**
			 * Formats the name of a property or a method depending on if it's static or not
			 * @param sName {string} - Name
			 * @param sClassName {string} - Name of the class
			 * @param bStatic {boolean} - If it's static
			 * @returns {string} - Formatted name
			 */
			formatEntityName: function (sName, sClassName, bStatic) {
				return (bStatic === true) ? sClassName + "." + sName : sName;
			},

			/**
			 * Formats the description of the property
			 * @param description - the description of the property
			 * @param deprecatedText - the text explaining this property is deprecated
			 * @param deprecatedSince - the verstion when this property was deprecated
			 * @returns string - the formatted description
			 */
			formatDescription: function (description, deprecatedText, deprecatedSince) {
				if (!description && !deprecatedText && !deprecatedSince) {
					return "";
				}

				var result = description || "";

				if (deprecatedSince || deprecatedText) {
					result += "<span class=\"sapUiDocumentationDeprecated\">";

					if (deprecatedSince) {
						result += '<br/>Deprecated since version ' + deprecatedSince + '.';
					}

					if (deprecatedText) {
						if (deprecatedSince) {
							result += ' ' + deprecatedText;
						} else {
							result += '<br/>' + deprecatedText;
						}
					}

					result += "</span>";
				}

				result = this._wrapInSpanTag(result);
				return result;
			},

			/**
			 * Formats the description of control properties
			 * @param description - the description of the property
			 * @param since - the since version information of the property
			 * @returns string - the formatted description
			 */
			formatDescriptionSince: function (description, since) {
				var result = description || "";

				if (since) {
					result += '<br/><br/><i>Since: ' + since + '.</i>';
				}

				result = this._wrapInSpanTag(result);
				return result;
			},

			/**
			 * Formats the description of annotations
			 * @param description - the description of the annotation
			 * @param since - the since version information of the annotation
			 * @returns string - the formatted description
			 */
			formatAnnotationDescription: function (description, since) {
				var result = description || "";

				result += '<br/>For more information, see ' + '<a target="_blank" href="' + this.ANNOTATIONS_LINK + '">OData v4 Annotations</a>';

				if (since) {
					result += '<br/><br/><i>Since: ' + since + '.</i>';
				}

				result = this._wrapInSpanTag(result);
				return result;
			},

			/**
			 * Formats the description of annotations in summary table
			 * @param description - the description of the annotation
			 * @returns string - the formatted description
			 */
			formatAnnotationDescriptionSummary: function (description) {
				var result = description || "";

				result = result.split(this.ANNOTATION_DESCRIPTION_STRIP_REGEX)[0];

				result = this._wrapInSpanTag(result);
				return result;
			},

			/**
			 * Formats the target and applies to texts of annotations
			 * @param target - the array of texts to be formatted
			 * @returns string - the formatted text
			 */
			formatAnnotationTarget: function (target) {
				var result = "";

				if (target) {
					target.forEach(function (element) {
						result += element + '<br/>';
					});
				}

				result = this._wrapInSpanTag(result);
				return result;
			},

			/**
			 * Formats the namespace of annotations
			 * @param namespace - the namespace to be formatted
			 * @returns string - the formatted text
			 */
			formatAnnotationNamespace: function (namespace) {
				var result,
					aNamespaceParts = namespace.split(".");

				if (aNamespaceParts[0] === "Org" && aNamespaceParts[1] === "OData") {
					result = '<a target="_blank" href="' + this.ANNOTATIONS_NAMESPACE_LINK + namespace + '.xml">' + namespace + '</a>';
				} else {
					result = namespace;
				}

				result = this._wrapInSpanTag(result);
				return result;
			},

			/**
			 * Checks if the list has elements that have public visibility
			 * @param elements - a list of properties/methods/aggregations/associations etc.
			 * @returns {boolean} - true if the list has at least one public element
			 */
			hasPublicElement: function (elements) {
				for (var i = 0; i < elements.length; i++) {
					if (elements[i].visibility === 'public') {
						return true;
					}
				}

				return false;
			},

			/**
			 * Formats event or event parameter name
			 * @param eventInfo - object containing information about the event
			 * @returns {string} - the name of the event or if eventInfo is a event param - empty string
			 */
			formatEventsName: function (eventInfo) {

				return eventInfo ? eventInfo.name : "";

			},

			/**
			 * Helper function retrieving event parameter name
			 * @param eventInfo - object containing information about the event or the event parameter
			 * @returns {string} - Returns the name of the parameter or empty string
			 */
			formatEventsParam: function (eventInfo) {
				if (eventInfo && eventInfo.type != this.EVENT) {
					return eventInfo.name;
				} else {
					return "";
				}
			},

			formatMethodCode: function (sName, aParams, aReturnValue) {
				var result = sName + '(';

				if (aParams && aParams.length > 0) {
					aParams.forEach(function (element, index, array) {
						if (element.isSubProperty || element.isSubSubProperty) {
							return;
						}

						result += element.name;

						if (element.optional) {
							result += '?';
						}

						if (index < array.length - 1) {
							result += ', ';
						}
					});
				}

				result += ') : ';

				if (aReturnValue) {
					result += aReturnValue.type;
				} else {
					result += 'void';
				}


				return result;
			},

			/**
			 * Helper function retrieving method parameter name
			 * @param methodInfo - object containing information about the method or the method parameter
			 * @returns {string} - the name of the parameter or empty string
			 */
			formatMethodsParam: function (methodInfo) {
				if (methodInfo && methodInfo.type != this.METHOD) {
					return methodInfo.name;
				} else {
					return "";
				}
			},

			/**
			 * Helper function that checks if a link points to a base type (e.g. int, string, object etc)
			 * @param linkText - the text of the link
			 * @returns {boolean} - False if link points to a base type
			 */
			formatLinkEnabled: function (linkText) {
				return this._baseTypes.indexOf(linkText) === -1;
			},

			formatEventClassName: function (isSubProperty, isSubSubProperty, bPhoneSize) {
				if (bPhoneSize && (isSubProperty || isSubSubProperty)) {
					return "sapUiDocumentationParamPhone";
				} else if (isSubSubProperty) {
					return "sapUiDocumentationParamSubSub";
				} else if (isSubProperty) {
					return "sapUiDocumentationParamSub";
				} else {
					return "sapUiDocumentationParamBold";
				}
			},

			formatMethodClassName: function (isSubProperty, bPhoneSize) {
				if (bPhoneSize && isSubProperty) {
					return "sapUiDocumentationParamPhone";
				} else if (isSubProperty) {
					return "sapUiDocumentationParamSub";
				} else {
					return "sapUiDocumentationParamBold";
				}
			},

			/**
			 * Event handler when a link pointing to a non-base type is pressed
			 * @param e
			 */
			onTypeLinkPress: function (e) {
				var type = e.getSource().getText();
				type = type.replace('[]', ''); // remove array brackets before navigation
				this.getRouter().navTo("apiId", {id: type}, true);
			},

			onAnnotationsLinkPress: function (oEvent) {
				this._scrollToEntity("annotations", "Summary");
			},

			backToSearch: function () {
				this.onNavBack();
			},

			/**
			 * This function wraps a text in a span tag so that it can be represented in an HTML control.
			 * @param {string} sText
			 * @returns {string}
			 * @private
			 */
			_wrapInSpanTag: function (sText) {
				var topicsData = this.getModel('topics').oData,
					topicName = topicsData.name || "",
					topicMethods = topicsData.methods || [];

				var sFormattedTextBlock = JSDocUtil.formatTextBlock(sText, {
					linkFormatter: function (target, text) {

						var iHashIndex, // indexOf('#')
							iHashDotIndex, // indexOf('#.')
							iHashEventIndex; // indexOf('#event:')

						// If the link has a protocol, do not modify, but open in a new window
						if (target.match("://")) {
							return '<a target="_blank" href="' + target + '">' + (text || target) + '</a>';
						}

						target = target.trim().replace(/\.prototype\./g, "#");

						iHashIndex = target.indexOf('#');
						iHashDotIndex = target.indexOf('#.');
						iHashEventIndex = target.indexOf('#event:');

						if (iHashIndex === -1) {
							var lastDotIndex = target.lastIndexOf('.'),
								entityName = target.substring(lastDotIndex + 1),
								targetMethod = topicMethods.filter(function (method) {
									if (method.name === entityName) {
										return method;
									}
								})[0];

							if (targetMethod) {
								text = text || target;

								if (targetMethod.static === true) {
									target = topicName + '/methods/' + target;
								} else {
									target = topicName + '/methods/' + entityName;
								}
							}
						}

						if (iHashDotIndex === 0) {
							// clear '#.' from target string
							target = target.slice(2);

							// if no text is defined for the link, display the method name only
							text = text || target;

							target = topicName + '/methods/' + topicName + '.' + target;
						} else if (iHashEventIndex === 0) {
							// clear '#event:' from target string
							target = target.slice('#event:'.length);

							// if no text is defined for the link, display the method name only
							text = text || target;

							target = topicName + '/events/' + target;
						} else if (iHashIndex === 0) {
							// clear '#' from target string
							target = target.slice(1);

							// if no text is defined for the link, display the method name only
							text = text || target;

							target = topicName + '/methods/' + target;
						}

						if (iHashIndex > 0) {
							text = text || target; // keep the full target in the fallback text
							target = target.slice(0, iHashIndex);
						}

						return "<a class=\"jsdoclink\" href=\"javascript:void(0);\" data-sap-ui-target=\"" + target + "\">" + (text || target) + "</a>";

					}
				});

				return '<span class="sapUiDocumentationJsDoc">' + sFormattedTextBlock + '</span>';
			}
		});

	}
);

}; // end of sap/ui/documentation/sdk/controller/ApiDetail.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.ApiDetailDeprecatedExperimental.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global location */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.ApiDetailDeprecatedExperimental.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/ApiDetailDeprecatedExperimental.controller",[
		"jquery.sap.global",
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/ui/model/json/JSONModel",
		"sap/ui/documentation/sdk/controller/util/JSDocUtil"
	], function (jQuery, BaseController, JSONModel, JSDocUtil) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.ApiDetailDeprecatedExperimental", {

			/* =========================================================== */
			/* lifecycle methods										   */
			/* =========================================================== */

			onInit: function () {
				this.setModel(new JSONModel(), "deprecatedAPIs");
				this.setModel(new JSONModel(), "experimentalAPIs");

				this.getRouter().getRoute("deprecated").attachPatternMatched(this._onTopicMatched, this);
				this.getRouter().getRoute("experimental").attachPatternMatched(this._onTopicMatched, this);

				// click handler for @link tags in JSdoc fragments
				this.getView().attachBrowserEvent("click", this.onJSDocLinkClick, this);

				this._currentMedia = this.getView()._getCurrentMediaContainerRange();

				this._hasMatched = false;
			},

			onBeforeRendering: function () {
				this.getView()._detachMediaContainerWidthChange(this._resizeMessageStrip, this);
			},

			onAfterRendering: function () {
				this._resizeMessageStrip();
				this.getView()._attachMediaContainerWidthChange(this._resizeMessageStrip, this);
			},

			onExit: function () {
				this.getView().detachBrowserEvent("click", this.onJSDocLinkClick, this);
				this.getView()._detachMediaContainerWidthChange(this._resizeMessageStrip, this);
			},

			_onTopicMatched: function (oEvent) {
				if (this._hasMatched) {
					return;
				}

				this._hasMatched = true;

				this.getOwnerComponent().fetchAPIInfoAndBindModels().then(function () {
					var aLibsData = this.getOwnerComponent().getModel("libsData").getData();

					this.getModel("deprecatedAPIs").setData(aLibsData.deprecated);
					this.getModel("experimentalAPIs").setData(aLibsData.experimental);

					setTimeout(this._prettify, 0);
				}.bind(this));
			},

			_prettify: function () {
				// Google Prettify requires this class
				jQuery('pre').addClass('prettyprint');

				window.prettyPrint();
			},

			compareVersions: function (version1, version2) {
				var sWithoutVersion = "WITHOUT VERSION";
				if (version1 === sWithoutVersion) {
					return -1;
				}

				if (version2 === sWithoutVersion) {
					return 1;
				}

				var version1Arr = version1.split(".");
				var version2Arr = version2.split(".");
				var version1Major = parseInt(version1Arr[0], 10);
				var version1Minor = parseInt(version1Arr[1], 10);
				var version2Major = parseInt(version2Arr[0], 10);
				var version2Minor = parseInt(version2Arr[1], 10);

				if (version1Major > version2Major ||
					(version1Major === version2Major && version1Minor > version2Minor)) {
					return -1;
				}

				if (version2Major > version1Major ||
					(version2Major === version1Major && version2Minor > version1Minor)) {
					return 1;
				}

				return 0;
			},

			formatTitle: function (sTitle) {
				if (sTitle === "Without Version") {
					return sTitle;
				} else {
					return "As of " + sTitle;
				}
			},

			formatDescription: function (sText, sSince) {
				if (sSince) {
					sText = "As of version " + sSince + ", " + sText;
				}

				sText = this.formatLinks(sText);
				sText = sText.replace("<p>", '');
				sText = sText.replace("</p>", '');

				return sText;
			},

			formatSenderLink: function (sControlName, sEntityName, sEntityType) {
				if (sEntityType === "methods") {
					return sControlName + "#" + sEntityName;
				}

				if (sEntityType === "events") {
					return sControlName + "#events:" + sEntityName;
				}

				return "";
			},

			onApiPress: function (oControlEvent) {
				var oCustomData = oControlEvent.getSource().getCustomData(),
					sClassName = oCustomData[0].getValue(),
					sEntityId = oCustomData[1].getValue();

				// oCustomData[3].getValue() is true if method is static, else it is false
				if (oCustomData[3].getValue()) {
					sEntityId = sClassName + "." + sEntityId;
				}

				this.getRouter().navTo("apiId", {
					id: sClassName,
					entityId: sEntityId,
					entityType: oCustomData[2].getValue()
				}, false);
			},

			/**
			 * This function wraps a text in a span tag so that it can be represented in an HTML control.
			 * @param {string} sText
			 * @returns {string}
			 * @private
			 */
			formatLinks: function (sText) {
				var aLibsData = this.getOwnerComponent().getModel('libsData').getData();

				var sFormattedTextBlock = JSDocUtil.formatTextBlock(sText, {
					linkFormatter: function (target, text) {

						var iHashIndex;

						// If the link has a protocol, do not modify, but open in a new window
						if (target.match("://")) {
							return '<a target="_blank" href="' + target + '">' + (text || target) + '</a>';
						}

						target = target.trim().replace(/\.prototype\./g, "#");
						iHashIndex = target.indexOf("#");

						text = text || target; // keep the full target in the fallback text

						if (iHashIndex < 0 && !aLibsData[target]) {
							var iLastDotIndex = target.lastIndexOf("."),
								sClassName = target.substring(0, iLastDotIndex),
								sMethodName = target.substring(iLastDotIndex + 1),
								targetMethod = aLibsData[sClassName].methods.filter(function(oMethod) {
									if (oMethod.name === sMethodName) {
										return oMethod;
									}
								})[0];

							if (targetMethod) {
								if (targetMethod.static === true) {
									target = sClassName + '/methods/' + sClassName + '.' + sMethodName;
								} else {
									target = sClassName + '/methods/' + sMethodName;
								}
							}
						}

						if (iHashIndex === 0) {
							// a relative reference - we can't support that
							return "<code>" + target.slice(1) + "</code>";
						}

						if (iHashIndex > 0) {
							target = target.slice(0, iHashIndex) + '/methods/' + target.slice(iHashIndex + 1);
						}

						return "<a class=\"jsdoclink\" href=\"javascript:void(0);\" target=\"" + target + "\">" + text + "</a>";

					}
				});

				return sFormattedTextBlock;
			},

			onJSDocLinkClick: function (oEvent) {
				// get target
				var sRoute = "apiId",
					bJSDocLink = oEvent.target.classList.contains("jsdoclink"),
					oComponent = this.getOwnerComponent(),
					sTarget = oEvent.target.getAttribute("target"),
					aNavInfo;

				if (!bJSDocLink || !sTarget) {
					return;
				}

				if (sTarget.indexOf('/') >= 0) {
					// link refers to a method or event target="<class name>/methods/<method name>" OR
					// target="<class name>/events/<event name>
					aNavInfo = sTarget.split('/');

					oComponent.getRouter().navTo(sRoute, {
						id: aNavInfo[0],
						entityType: aNavInfo[1],
						entityId: aNavInfo[2]
					}, false);
				} else {
					oComponent.getRouter().navTo(sRoute, { id: sTarget }, false);
				}

				oEvent.preventDefault();
			},

			_resizeMessageStrip: function (oMedia) {
				var oView = this.getView();

				oMedia = oMedia || oView._getCurrentMediaContainerRange();

				var sName = oMedia.name,
					oMessageStripContainer = this.getView().byId("deprecatedAPIStripContainer")
						|| this.getView().byId("experimentalAPIStripContainer");

				if (!oMessageStripContainer) {
					return;
				}

				if (sName === "Desktop" || sName === "LargeDesktop") {
					oMessageStripContainer.setWidth("calc(100% - 3rem)");
				} else if (sName === "Tablet" || sName === "Phone") {
					oMessageStripContainer.setWidth("calc(100% - 2rem)");
				}
			}
		});

	}
);

}; // end of sap/ui/documentation/sdk/controller/ApiDetailDeprecatedExperimental.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.ApiDetailInitial.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global location */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.ApiDetailInitial.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/ApiDetailInitial.controller",[
	"sap/ui/Device",
	"sap/ui/documentation/sdk/controller/BaseController"
], function (Device, BaseController) {
	"use strict";

	return BaseController.extend("sap.ui.documentation.sdk.controller.ApiDetailInitial", {

		/* =========================================================== */
		/* lifecycle methods										   */
		/* =========================================================== */

		/**
		 * Called when the controller is instantiated.
		 * @public
		 */
		onInit: function () {
			// manually call the handler once at startup as device API won't do this for us
			this._onOrientationChange({
				landscape: Device.orientation.landscape
			});
		},

		/**
		 * Called before the view is rendered.
		 * @public
		 */
		onBeforeRendering: function() {
			this._deregisterOrientationChange();
		},

		/**
		 * Called after the view is rendered.
		 * @public
		 */
		onAfterRendering: function() {
			this._registerOrientationChange();
		},

		/**
		 * Called when the controller is destroyed.
		 * @public
		 */
		onExit: function() {
			this._deregisterOrientationChange();
		}

	});
});
}; // end of sap/ui/documentation/sdk/controller/ApiDetailInitial.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.ApiMaster.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global history */
jQuery.sap.declare('sap.ui.documentation.sdk.controller.ApiMaster.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/ApiMaster.controller",[
		"sap/ui/documentation/sdk/controller/MasterTreeBaseController",
		"sap/ui/model/json/JSONModel"
	], function (MasterTreeBaseController, JSONModel) {
		"use strict";



		return MasterTreeBaseController.extend("sap.ui.documentation.sdk.controller.ApiMaster", {

			/**
			 * Called when the master list controller is instantiated. It sets up the event handling for the master/detail communication and other lifecycle tasks.
			 * @public
			 */
			onInit : function () {
				this.getOwnerComponent().fetchAPIInfoAndBindModels().then(function () {
					this._expandTreeToNode(this._topicId, this.getOwnerComponent().getModel("treeData"));
				}.bind(this));

				this._initTreeUtil("name", "nodes");

				this.getRouter().getRoute("api").attachPatternMatched(this._onMatched, this);
				this.getRouter().getRoute("apiId").attachPatternMatched(this._onTopicMatched, this);
				this.getRouter().getRoute("deprecated").attachPatternMatched(this._onTopicMatched, this);
				this.getRouter().getRoute("experimental").attachPatternMatched(this._onTopicMatched, this);
			},

			/* =========================================================== */
			/* begin: internal methods                                     */
			/* =========================================================== */

			/**
			 * Handles "apiId" routing
			 * @function
			 * @param {sap.ui.base.Event} event pattern match event in route 'apiId'
			 * @private
			 */
			_onTopicMatched: function (event) {

				try {
					this.showMasterSide();
				} catch (e) {
					// try-catch due to a bug in UI5 SplitApp, CL 1898264 should fix it
					jQuery.sap.log.error(e);
				}

				this._topicId = event.getParameter("arguments").id || event.getParameter("name");

				this._expandTreeToNode(this._topicId, this.getOwnerComponent().getModel("treeData"));
			},

			_onMatched: function () {
				var splitApp = this.getView().getParent().getParent(),
					masterTree = this.byId('tree'),
					selectedItem;

				splitApp.setMode(sap.m.SplitAppMode.ShowHideMode);

				if (masterTree) {
					selectedItem = masterTree.getSelectedItem();
					selectedItem && selectedItem.setSelected(false);
				}
			},

			compareTreeNodes: function (sNode1, sNode2) {
				if (sNode1 === "EXPERIMENTAL") {
					return 1;
				}

				if (sNode2 === "EXPERIMENTAL") {
					return -1;
				}

				if (sNode1 === "DEPRECATED") {
					return 1;
				}

				if (sNode2 === "DEPRECATED") {
					return -1;
				}

				if (sNode1 < sNode2) {
					return -1;
				}

				if (sNode1 > sNode2) {
					return 1;
				}

				if (sNode1 === sNode2) {
					return 0;
				}
			},

			onNodeSelect : function (oEvent) {
				var node = oEvent.getParameter("listItem");
				var apiId = node.getCustomData()[0].getValue();

				if (!apiId) {
					jQuery.sap.log.warning("Missing name for entity: " + node.getId() + " - cannot navigate to API ref");
					return;
				}

				this.getRouter().navTo("apiId", {id : apiId}, false);
			},

			onTreeFilter: function (oEvent) {
				MasterTreeBaseController.prototype.onTreeFilter.apply(this, [oEvent, "name"]);
			}

		});
	}
);
}; // end of sap/ui/documentation/sdk/controller/ApiMaster.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.documentation.sdk.controller.App.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.documentation.sdk.controller.App.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ResizeHandler'); // unlisted dependency retained
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Fragment'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IconPool'); // unlisted dependency retained
jQuery.sap.require('sap.m.SplitAppMode'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageBox'); // unlisted dependency retained
sap.ui.define("sap/ui/documentation/sdk/controller/App.controller",[
		"sap/ui/documentation/sdk/controller/BaseController",
		"sap/ui/model/json/JSONModel",
		"sap/ui/core/ResizeHandler",
		"sap/ui/Device",
		"sap/ui/core/Component",
		"sap/ui/core/Fragment",
		"sap/ui/documentation/library",
		"sap/ui/core/IconPool",
		"sap/m/SplitAppMode",
		"sap/m/MessageBox"
	], function (BaseController, JSONModel, ResizeHandler, Device, Component, Fragment, library, IconPool, SplitAppMode, MessageBox) {
		"use strict";

		return BaseController.extend("sap.ui.documentation.sdk.controller.App", {
			onInit : function () {
				var oVersionInfo = sap.ui.getVersionInfo(),
					sVersion = oVersionInfo.version,
					oViewModel = new JSONModel({
						busy : false,
						delay : 0,
						bPhoneSize: false,
						bLandscape: Device.orientation.landscape,
						bHasMaster: false,
						bSearchMode: false,
						version: jQuery.sap.Version(sap.ui.version).getMajor() + "." + jQuery.sap.Version(sap.ui.version).getMinor(),
						fullVersion: sap.ui.version,
						isOpenUI5: oVersionInfo && oVersionInfo.gav && /openui5/i.test(oVersionInfo.gav),
						isSnapshotVersion: oVersionInfo && oVersionInfo.gav && /snapshot/i.test(oVersionInfo.gav),
						isDevVersion: sVersion.indexOf("SNAPSHOT") > -1 || (sVersion.split(".").length > 1 && parseInt(sVersion.split(".")[1], 10) % 2 === 1)
					});
				this.MENU_LINKS_MAP = {
					"Legal": "https://www.sap.com/corporate/en/legal/impressum.html",
					"Privacy": "https://www.sap.com/corporate/en/legal/privacy.html",
					"Terms of Use": "https://www.sap.com/corporate/en/legal/terms-of-use.html",
					"Copyright": "https://www.sap.com/corporate/en/legal/copyright.html",
					"Trademark": "https://www.sap.com/corporate/en/legal/copyright.html#trademark",
					"Disclaimer": "http://help-legacy.sap.com/disclaimer-full"
				};
				this.FEEDBACK_SERVICE_URL = "https://feedback-sapuisofiaprod.hana.ondemand.com:443/api/v2/apps/5bb7d7ff-bab9-477a-a4c7-309fa84dc652/posts";
				this.OLD_DOC_LINK_SUFFIX = ".html";

				// Cache view reference
				this._oView = this.getView();

				this.setModel(oViewModel, "appView");

				this.oTabNavigation = this._oView.byId("tabHeader");
				this.oHeader = this._oView.byId("headerToolbar");
				this.oRouter = this.getRouter();

				ResizeHandler.register(this.oHeader, this.onHeaderResize.bind(this));
				this.oRouter.attachRouteMatched(this.onRouteChange.bind(this));

				this.getRouter().getRoute("topicIdLegacyRoute").attachPatternMatched(this._onTopicOldRouteMatched, this);
				this.getRouter().getRoute("apiIdLegacyRoute").attachPatternMatched(this._onApiOldRouteMatched, this);

				this.oRouter.getRoute("entitySamplesLegacyRoute").attachPatternMatched(this._onEntityOldRouteMatched, this);
				this.oRouter.getRoute("entityAboutLegacyRoute").attachPatternMatched(this._onEntityOldRouteMatched, this);
				this.oRouter.getRoute("entityPropertiesLegacyRoute").attachPatternMatched({entityType: "properties"}, this._forwardToAPIRef, this);
				this.oRouter.getRoute("entityAggregationsLegacyRoute").attachPatternMatched({entityType: "aggregations"}, this._forwardToAPIRef, this);
				this.oRouter.getRoute("entityAssociationsLegacyRoute").attachPatternMatched({entityType: "associations"}, this._forwardToAPIRef, this);
				this.oRouter.getRoute("entityEventsLegacyRoute").attachPatternMatched({entityType:"events"}, this._forwardToAPIRef, this);
				this.oRouter.getRoute("entityMethodsLegacyRoute").attachPatternMatched({entityType:"methods"}, this._forwardToAPIRef, this);

				// apply content density mode to root view
				this._oView.addStyleClass(this.getOwnerComponent().getContentDensityClass());

				// register Feedback rating icons
				this._registerFeedbackRatingIcons();
			},

			onBeforeRendering: function() {
				Device.orientation.detachHandler(this._onOrientationChange, this);
			},

			onAfterRendering: function() {
				Device.orientation.attachHandler(this._onOrientationChange, this);
			},

			onExit: function() {
				Device.orientation.detachHandler(this._onOrientationChange, this);
			},

			_onTopicOldRouteMatched: function(oEvent) {

				var sId = oEvent.getParameter("arguments").id;
				if (sId) {
					sId = this._trimOldDocSuffix(sId);
				}
				this.getRouter().navTo("topicId", {id: sId});
			},

			_onApiOldRouteMatched: function(oEvent) {

				var sId = oEvent.getParameter("arguments").id,
					sEntityType,
					sEntityId,
					aSplit;

				if (sId) {

					aSplit = sId.split("#");
					if (aSplit.length === 2) {
						sId = aSplit[0];
						sEntityType = aSplit[1];

						aSplit = sEntityType.split(":");
						if (aSplit.length === 2) {
							sEntityType = aSplit[0];
							sEntityId = aSplit[1];
						}
					}

					sId = this._trimOldDocSuffix(sId);

					if (sEntityType === 'event') { // legacy keyword is singular
						sEntityType = "events";
					}
				}

				this.getRouter().navTo("apiId", {id: sId, entityType: sEntityType, entityId: sEntityId});
			},

			_trimOldDocSuffix: function(sLink) {
				if (sLink && sLink.endsWith(this.OLD_DOC_LINK_SUFFIX)) {
					sLink = sLink.slice(0, -this.OLD_DOC_LINK_SUFFIX.length);
				}
				return sLink;
			},

			_forwardToAPIRef: function(oEvent, oData) {
				oData || (oData = {});
				oData['id'] = oEvent.getParameter("arguments").id;
				this.oRouter.navTo("apiId", oData);
			},

			_onEntityOldRouteMatched: function(oEvent) {
				this.oRouter.navTo("entity", {
					id: oEvent.getParameter("arguments").id
				});
			},

			onRouteChange: function (oEvent) {

				if (!this.oRouter.getRoute(oEvent.getParameter("name"))._oConfig.target) {
					return;
				}

				var sRouteName = oEvent.getParameter("name"),
					sTabId = this.oRouter.getRoute(sRouteName)._oConfig.target[0] + "Tab",
					oTabToSelect = this._oView.byId(sTabId),
					sKey = oTabToSelect ? oTabToSelect.getKey() : "home",
					bPhone = Device.system.phone,
					oViewModel = this.getModel("appView"),
					bHasMaster = this.getOwnerComponent().getConfigUtil().hasMasterView(sRouteName),
					oMasterView,
					sMasterViewId;

				this.oTabNavigation.setSelectedKey(sKey);

				oViewModel.setProperty("/bHasMaster", bHasMaster);

				this._toggleTabHeaderClass();

				if (bPhone && bHasMaster) { // on phone we need the id of the master view (for mavigation)
					oMasterView = this.getOwnerComponent().getConfigUtil().getMasterView(sRouteName);
					sMasterViewId = oMasterView && oMasterView.getId();
					oViewModel.setProperty("/sMasterViewId", sMasterViewId);
				}

				// hide master on route change
				this.getView().byId("splitApp").hideMaster();
				oViewModel.setProperty("/bIsShownMaster", false);
			},

			toggleMaster: function(oEvent) {
				var bPressed = oEvent.getParameter("pressed"),
					bPhone = Device.system.phone,
					oSplitApp = this.getView().byId("splitApp"),
					isShowHideMode = oSplitApp.getMode() === SplitAppMode.ShowHideMode,
					isHideMode = oSplitApp.getMode() === SplitAppMode.HideMode,
					sMasterViewId = this.getModel("appView").getProperty("/sMasterViewId"),
					fnToggle;

				if (!bPhone && (isShowHideMode || isHideMode)) {
					fnToggle = (bPressed) ? oSplitApp.showMaster : oSplitApp.hideMaster;
					fnToggle.call(oSplitApp);
					return;
				}

				/* on phone there is no master-detail pair, but a single navContainer => so navigate within this navContainer: */
				if (bPhone) {
					if (bPressed) {
						oSplitApp.to(sMasterViewId);
					} else {
						oSplitApp.backDetail();
					}
				}
			},

			navigateToSection : function (oEvent) {
				var sKey = oEvent.getParameter("key");

				oEvent.preventDefault();
				if (sKey && sKey !== "home") {
					this.getRouter().navTo(sKey, {}, true);
				} else {
					this.getRouter().navTo("", {}, true);
					this.oTabNavigation.setSelectedKey("home");
				}
			},

			handleMenuItemClick: function (oEvent) {
				var sTargetText = oEvent.getParameter("item").getText(),
					sTarget = this.MENU_LINKS_MAP[sTargetText];

				if (sTargetText === "About") {
					this.aboutDialogOpen();
				} else if (sTargetText === "Feedback") {
					this.feedbackDialogOpen();
				} else if (sTarget) {
					sap.m.URLHelper.redirect(sTarget, true);
				}
			},

			aboutDialogOpen: function () {
				if (!this._oAboutDialog) {
					this._oAboutDialog = new sap.ui.xmlfragment("aboutDialogFragment", "sap.ui.documentation.sdk.view.AboutDialog", this);
					this._oView.addDependent(this._oAboutDialog);
				}
				this._oAboutDialog.open();
			},

			aboutDialogClose: function (oEvent) {
				this._oAboutDialog.close();
			},

			onAboutVersionDetails: function (oEvent) {
				var oViewModel = this.getModel("appView"),
					oViewModelData = oViewModel.getData(),
					that = this;

				library._loadAllLibInfo("", "_getLibraryInfo","", function(aLibs, oLibInfos) {
					var data = {};
					var oLibInfo = library._getLibraryInfoSingleton();

					for (var i = 0, l = aLibs.length; i < l; i++) {
						aLibs[i] = oLibInfos[aLibs[i]];
						aLibs[i].libDefaultComponent = oLibInfo._getDefaultComponent(aLibs[i]);
					}

					data.libs = aLibs;
					oViewModelData.oVersionInfo = data;
					oViewModel.setData(oViewModelData);
					that.setModel(oViewModel, "appView");
				});

				var oNavCon = Fragment.byId("aboutDialogFragment", "aboutNavCon"),
					oDetailPage = Fragment.byId("aboutDialogFragment", "aboutDetail");
				oNavCon.to(oDetailPage);
			},

			onAboutThirdParty: function (oEvent) {
				var oViewModel = this.getModel("appView"),
					oViewModelData = oViewModel.getData(),
					that = this;

				library._loadAllLibInfo("", "_getThirdPartyInfo", function(aLibs, oLibInfos){
					if (!aLibs){
						return;
					}
					var data = {};
					data.thirdparty = [];
					for (var j = 0; j < aLibs.length; j++) {
						var oData = oLibInfos[aLibs[j]];
						for (var i = 0; i < oData.libs.length; i++) {
							var oOpenSourceLib = oData.libs[i];
							oOpenSourceLib._lib = aLibs[j];
							data.thirdparty.push(oOpenSourceLib);
						}
					}

					data.thirdparty.sort(function(a,b){
						var aName = (a.displayName || "").toUpperCase();
						var bName = (b.displayName || "").toUpperCase();

						if (aName > bName){
							return 1;
						} else if (aName < bName){
							return -1;
						} else {
							return 0;
						}
					});

					oViewModelData.oThirdPartyInfo = data;
					oViewModel.setData(oViewModelData);
					that.setModel(oViewModel, "appView");
				});

				var oNavCon = Fragment.byId("aboutDialogFragment", "aboutNavCon"),
					oDetailPage = Fragment.byId("aboutDialogFragment", "aboutThirdParty");
				oNavCon.to(oDetailPage);
			},

			onReleaseDialogOpen: function (oEvent) {
				var oLibInfo = library._getLibraryInfoSingleton(),
					sVersion = oEvent.getSource().data("version"),
					sLibrary = oEvent.getSource().data("library"),
					oNotesModel = new JSONModel(),
					oDialogModel = new JSONModel(),
					that = this;

				if (!this._oReleaseDialog) {
					this._oReleaseDialog = new sap.ui.xmlfragment("releaseDialogFragment", "sap.ui.documentation.sdk.view.ReleaseDialog", this);
					this._oView.addDependent(this._oReleaseDialog);
				}

				if (!this._oNotesView) {
					this._oNotesView = sap.ui.view({id:"notesView", viewName:"sap.ui.documentation.sdk.view.ReleaseNotesView", type:"Template"});
					this._oNotesView.setModel(oNotesModel);
				}

				oLibInfo._getReleaseNotes(sLibrary, sVersion, function(oRelNotes, sVersion) {
					var oDialogData = {};

					if (oRelNotes && oRelNotes[sVersion] && oRelNotes[sVersion].notes && oRelNotes[sVersion].notes.length > 0) {
						that._oNotesView.getModel().setData(oRelNotes);
						that._oNotesView.bindObject("/" + sVersion);
					} else {
						oDialogData.noDataMessage = "No changes for this library!";
					}
					oDialogData.library = sLibrary;
					oDialogModel.setData(oDialogData);
				});

				this._oReleaseDialog.setModel(oDialogModel);
				this._oReleaseDialog.addContent(this._oNotesView);
				this._oReleaseDialog.open();
			},

			onReleaseDialogClose: function (oEvent) {
				this._oReleaseDialog.close();
			},

			onAboutNavBack: function (oEvent) {
				var oNavCon = Fragment.byId("aboutDialogFragment", "aboutNavCon");
				oNavCon.back();
			},

			/**
			 * Opens a dialog to give feedback on the demo kit
			 */
			feedbackDialogOpen: function () {
				var that = this;

				if (!this._oFeedbackDialog) {
					this._oFeedbackDialog = new sap.ui.xmlfragment("feedbackDialogFragment", "sap.ui.documentation.sdk.view.FeedbackDialog", this);
					this._oView.addDependent(this._oFeedbackDialog);

					this._oFeedbackDialog.textInput = Fragment.byId("feedbackDialogFragment", "feedbackInput");
					this._oFeedbackDialog.contextCheckBox = Fragment.byId("feedbackDialogFragment", "pageContext");
					this._oFeedbackDialog.contextData = Fragment.byId("feedbackDialogFragment", "contextData");
					this._oFeedbackDialog.ratingStatus = Fragment.byId("feedbackDialogFragment", "ratingStatus");
					this._oFeedbackDialog.ratingStatus.value = 0;
					this._oFeedbackDialog.sendButton = Fragment.byId("feedbackDialogFragment", "sendButton");
					this._oFeedbackDialog.ratingBar = [
						{
							button : Fragment.byId("feedbackDialogFragment", "excellent"),
							status : "Excellent"
						},
						{
							button : Fragment.byId("feedbackDialogFragment", "good"),
							status : "Good"
						},
						{
							button : Fragment.byId("feedbackDialogFragment", "average"),
							status : "Average"
						},
						{
							button : Fragment.byId("feedbackDialogFragment", "poor"),
							status : "Poor"
						},
						{
							button : Fragment.byId("feedbackDialogFragment", "veryPoor"),
							status : "Very Poor"
						}
					];
					this._oFeedbackDialog.reset = function () {
						this.sendButton.setEnabled(false);
						this.textInput.setValue("");
						this.contextCheckBox.setSelected(true);
						this.ratingStatus.setText("");
						this.ratingStatus.setState("None");
						this.ratingStatus.value = 0;
						this.contextData.setVisible(false);
						this.ratingBar.forEach(function(oRatingBarElement){
							if (oRatingBarElement.button.getPressed()) {
								oRatingBarElement.button.setPressed(false);
							}
						});
					};
					this._oFeedbackDialog.updateContextData = function() {
						if (this.contextCheckBox.getSelected()) {
							this.contextData.setValue("Location: " + that._getCurrentPageRelativeURL() + "\n" + that._getUI5Distribution() + " Version: " + sap.ui.getVersionInfo().version);
						} else {
							this.contextData.setValue(that._getUI5Distribution() + " Version: " + sap.ui.getVersionInfo().version);
						}
					};

					this._oFeedbackDialog.updateContextData();
				}
				this._oFeedbackDialog.updateContextData();
				if (!this._oFeedbackDialog.isOpen()) {
					jQuery.sap.syncStyleClass("sapUiSizeCompact", this.getView(), this._oFeedbackDialog);
					this._oFeedbackDialog.open();
				}
			},

			/**
			 * Event handler for the send feedback button
			 */
			onFeedbackDialogSend: function() {
				var data = {};

				if (this._oFeedbackDialog.contextCheckBox.getSelected()) {
					data = {
						"texts": {
							"t1": this._oFeedbackDialog.textInput.getValue()
						},
						"ratings":{
							"r1": {"value" : this._oFeedbackDialog.ratingStatus.value}
						},
						"context": {"page": this._getCurrentPageRelativeURL(), "attr1": this._getUI5Distribution() + ":" + sap.ui.version}
					};
				} else {
					data = {
						"texts": {
							"t1": this._oFeedbackDialog.textInput.getValue()
						},
						"ratings":{
							"r1": {"value" : this._oFeedbackDialog.ratingStatus.value}
						},
						"context": {"attr1": this._getUI5Distribution() + ":" + sap.ui.version}
					};
				}

				// send feedback
				this._oFeedbackDialog.setBusyIndicatorDelay(0);
				this._oFeedbackDialog.setBusy(true);

				jQuery.ajax({
					url: this.FEEDBACK_SERVICE_URL,
					type: "POST",
					contentType: "application/json",
					data: JSON.stringify(data)
				}).
				done(
					function () {
						MessageBox.success("Your feedback has been sent.", {title: "Thank you!"});
						this._oFeedbackDialog.reset();
						this._oFeedbackDialog.close();
						this._oFeedbackDialog.setBusy(false);
					}.bind(this)
				).
				fail(
					function (oRequest, sStatus, sError) {
						var sErrorDetails = sError; // + "\n" + oRequest.responseText;
						MessageBox.error("An error occurred sending your feedback:\n" + sErrorDetails, {title: "Sorry!"});
						this._oFeedbackDialog.setBusy(false);
					}.bind(this)
				);

			},

			/**
			 * Event handler for the cancel feedback button
			 */
			onFeedbackDialogCancel: function () {
				this._oFeedbackDialog.reset();
				this._oFeedbackDialog.close();
			},

			/**
			 * Event handler for the toggle context link
			 */
			onShowHideContextData: function () {
				this._oFeedbackDialog.contextData.setVisible(!this._oFeedbackDialog.contextData.getVisible());
			},

			/**
			 * Event handler for the context selection checkbox
			 */
			onContextSelect: function() {
				this._oFeedbackDialog.updateContextData();
			},

			/**
			 * Event handler for the rating to update the label and the data
			 * @param {sap.ui.base.Event}
			 */
			onPressRatingButton: function(oEvent) {
				var that = this;
				var oPressedButton = oEvent.getSource();

				that._oFeedbackDialog.ratingBar.forEach(function(oRatingBarElement) {
					if (oPressedButton !== oRatingBarElement.button) {
						oRatingBarElement.button.setPressed(false);
					} else {
						if (!oRatingBarElement.button.getPressed()) {
							setRatingStatus("None", "", 0);
						} else {
							switch (oRatingBarElement.status) {
								case "Excellent":
									setRatingStatus("Success", oRatingBarElement.status, 5);
									break;
								case "Good":
									setRatingStatus("Success", oRatingBarElement.status, 4);
									break;
								case "Average":
									setRatingStatus("None", oRatingBarElement.status, 3);
									break;
								case "Poor":
									setRatingStatus("Warning", oRatingBarElement.status, 2);
									break;
								case "Very Poor":
									setRatingStatus("Error", oRatingBarElement.status, 1);
							}
						}
					}
				});

				function setRatingStatus(sState, sText, iValue) {
					that._oFeedbackDialog.ratingStatus.setState(sState);
					that._oFeedbackDialog.ratingStatus.setText(sText);
					that._oFeedbackDialog.ratingStatus.value = iValue;
					if (iValue) {
						that._oFeedbackDialog.sendButton.setEnabled(true);
					} else {
						that._oFeedbackDialog.sendButton.setEnabled(false);
					}
				}
			},

			//onFeedbackInput : function() {
			//	if (this._oFeedbackDialog.textInput.getValue() || this._oFeedbackDialog.ratingStatus.value) {
			//		this._oFeedbackDialog.sendButton.setEnabled(true);
			//	} else {
			//		this._oFeedbackDialog.sendButton.setEnabled(false);
			//	}
			//},

			onSearch : function (oEvent) {
				var sQuery = oEvent.getParameter("query");
				if (!sQuery) {
					return;
				}
				this.getRouter().navTo("search", {searchParam: sQuery}, false);
			},

			onHeaderResize: function (oEvent) {
				var iWidth = oEvent.size.width,
					bPhoneSize = Device.system.phone || iWidth < Device.media._predefinedRangeSets[Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];

				this.getModel("appView").setProperty("/bPhoneSize", bPhoneSize);

				this._toggleTabHeaderClass();
			},

			_onOrientationChange: function() {
				this.getModel("appView").setProperty("/bLandscape", Device.orientation.landscape);

				this._toggleTabHeaderClass();
			},

			onToggleSearchMode : function(oEvent) {
				var bSearchMode = oEvent.getParameter("isOpen"),
				oViewModel = this.getModel("appView");

				oViewModel.setProperty("/bSearchMode", bSearchMode);

				this._toggleTabHeaderClass();
			},

			/**
			 * Register Feedback rating icons
			 * @private
			 */
			_registerFeedbackRatingIcons: function () {
				IconPool.addIcon("icon-face-very-bad", "FeedbackRatingFaces", {
					fontFamily: "FeedbackRatingFaces",
					content: "E086",
					suppressMirroring: true
				});
				IconPool.addIcon("icon-face-bad", "FeedbackRatingFaces", {
					fontFamily: "FeedbackRatingFaces",
					content: "E087",
					suppressMirroring: true
				});
				IconPool.addIcon("icon-face-neutral", "FeedbackRatingFaces", {
					fontFamily: "FeedbackRatingFaces",
					content: "E089",
					suppressMirroring: true
				});
				IconPool.addIcon("icon-face-happy", "FeedbackRatingFaces", {
					fontFamily: "FeedbackRatingFaces",
					content: "E08B",
					suppressMirroring: true
				});
				IconPool.addIcon("icon-face-very-happy", "FeedbackRatingFaces", {
					fontFamily: "FeedbackRatingFaces",
					content: "E08C",
					suppressMirroring: true
				});
			},

			_getUI5Distribution: function () {
				var oVersionInfo = sap.ui.getVersionInfo();
				var sUI5Distribution = "SAPUI5";
				if (oVersionInfo && oVersionInfo.gav && /openui5/i.test(oVersionInfo.gav)) {
					sUI5Distribution = "OpenUI5";
				}
				return sUI5Distribution;
			},

			_getCurrentPageRelativeURL: function () {
				var parser = window.location;
				return parser.pathname + parser.hash + parser.search;
			},

			_isToggleButtonVisible: function() {
				var oViewModel = this.getModel("appView"),
					bHasMaster = oViewModel.getProperty("/bHasMaster"),
					bPhoneSize = oViewModel.getProperty("/bPhoneSize"),
					bLandscape = oViewModel.getProperty("/bLandscape"),
					bSearchMode = oViewModel.getProperty("/bSearchMode");

				return bHasMaster && (bPhoneSize || !bLandscape) && !bSearchMode;
			},

			_toggleTabHeaderClass: function() {
				var th = this.getView().byId("tabHeader");
				if (this._isToggleButtonVisible()) {
					th.addStyleClass("tabHeaderNoLeftMargin");
				} else {
					th.removeStyleClass("tabHeaderNoLeftMargin");
				}
			}

		});

	}
);

}; // end of sap/ui/documentation/sdk/controller/App.controller.js
