/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/dt/MutationObserver','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/DOMUtil','jquery.sap.dom'],function(q,C,M,E,O,D){"use strict";var o="overlay-container";var a;var m;var b=C.extend("sap.ui.dt.Overlay",{metadata:{library:"sap.ui.dt",properties:{visible:{type:"boolean",defaultValue:true},lazyRendering:{type:"boolean",defaultValue:true},focusable:{type:"boolean",defaultValue:false},enabled:{type:"boolean",defaultValue:true}},associations:{element:{type:"sap.ui.core.Element"}},aggregations:{designTimeMetadata:{type:"sap.ui.dt.DesignTimeMetadata",multiple:false}},events:{focusableChange:{parameters:{focusable:{type:"boolean"}}},destroyed:{parameters:{}},visibleChanged:{parameters:{visible:"boolean"}}}}});b.getOverlayContainer=function(){if(!a){a=q.sap.byId(o);if(!a.length){a=q("<div id='"+o+"'></div>").appendTo("body");}}return a.get(0);};b.removeOverlayContainer=function(){if(a){a.remove();}a=null;};b.getMutationObserver=function(){if(!m){m=new M();}return m;};b.destroyMutationObserver=function(){if(m){m.destroy();m=null;}};b.prototype.init=function(){this._bVisible=null;this._domRefScrollHandler=this._onSyncScrollWithDomRef.bind(this);this.attachBrowserEvent("scroll",this._onOverlayScroll,this);};b.prototype.exit=function(){this._detachDomRefScrollHandler();delete this._oDomRef;delete this._bVisible;window.clearTimeout(this._iCloneDomTimeout);window.clearTimeout(this._iSyncScrollWithDomRef);this.fireDestroyed();};b.prototype._onChildRerenderedEmpty=function(){return true;};b.prototype.onAfterRendering=function(){this._oDomRef=this.getDomRef();if(this._oDomRef){this._updateDom();}var f=this.isFocusable();if(f){this.$().attr("tabindex",0);}else{this.$().attr("tabindex",null);}};b.prototype.getDomRef=function(){return this._oDomRef||C.prototype.getDomRef.apply(this,arguments);};b.prototype.getAssociatedDomRef=function(){throw new Error("This method is abstract and needs to be implemented");};b.prototype.getElementInstance=function(){return E.getElementInstance(this.getElement());};b.prototype.hasFocus=function(){return document.activeElement===this.getFocusDomRef();};b.prototype.setFocusable=function(f){f=!!f;if(this.isFocusable()!==f){this.setProperty("focusable",f);this.toggleStyleClass("sapUiDtOverlayFocusable",f);this.fireFocusableChange({focusable:f});}return this;};b.prototype.isFocusable=function(){return this.getFocusable();};b.prototype.applyStyles=function(){if(!this.getEnabled()){return;}var d=function(){if(this._oDummyScrollContainer){this._oDummyScrollContainer.remove();delete this._oDummyScrollContainer;if(this.getParent()&&this.getParent().$){var k=this.getParent().$();k.removeClass("sapUiDtOverlayWithScrollBar");k.removeClass("sapUiDtOverlayWithScrollBarVertical");k.removeClass("sapUiDtOverlayWithScrollBarHorizontal");}}}.bind(this);delete this._mGeometry;if(!this.getDomRef()){return;}if(!this.isVisible()){this.$().css("display","none");return;}var g=this.getGeometry();if(g&&g.visible){var $=this.$();var s=D.getScrollbarWidth();var S=g.size;$.css("display","block");var c=this.getParent();var p=(c&&c instanceof b)?c.$().scrollTop():null;var P=(c&&c instanceof b)?c.$().scrollLeft():null;var e=(c&&c instanceof b)?c.$().offset():null;if(e&&q('html').attr('dir')==='rtl'&&D.hasVerticalScrollBar(c.getDomRef())){e.left+=s;}var f=D.getOffsetFromParent(g.position,e,p,P);$.css("width",S.width+"px");$.css("height",S.height+"px");$.css("top",f.top+"px");$.css("left",f.left+"px");if(g.domRef){var z=D.getZIndex(g.domRef);if(z){$.css("z-index",z);}var h=D.getOverflows(g.domRef);if(h){if(h.overflowX){$.css("overflow-x",h.overflowX);}if(h.overflowY){$.css("overflow-y",h.overflowY);}var i=g.domRef.scrollHeight;var j=g.domRef.scrollWidth;if(i>Math.ceil(S.height)||j>Math.ceil(S.width)){if(!this._oDummyScrollContainer){this._oDummyScrollContainer=q("<div class='sapUiDtDummyScrollContainer' style='height: "+i+"px; width: "+j+"px;'></div>");if(c.$&&D.hasVerticalScrollBar(g.domRef)){c.$().addClass("sapUiDtOverlayWithScrollBar");c.$().addClass("sapUiDtOverlayWithScrollBarVertical");}if(c.$&&D.hasHorizontalScrollBar(g.domRef)){c.$().addClass("sapUiDtOverlayWithScrollBar");c.$().addClass("sapUiDtOverlayWithScrollBarHorizontal");}this.$().append(this._oDummyScrollContainer);}else{this._oDummyScrollContainer.css({"height":i,"width":j});}}else{d();}this._attachDomRefScrollHandler();this._syncScrollWithDomRef();}this._cloneDomRef(g.domRef);}this.getChildren().forEach(function(k){k.applyStyles();});}else{d();this.$().css("display","none");}};b.prototype._attachDomRefScrollHandler=function(){this._detachDomRefScrollHandler();var g=this.getGeometry();var d=g?g.domRef:null;if(d){this._oDomRefWithScrollHandler=d;q(this._oDomRefWithScrollHandler).on("scroll",this._domRefScrollHandler);}};b.prototype._detachDomRefScrollHandler=function(d){if(this._oDomRefWithScrollHandler){q(this._oDomRefWithScrollHandler).off("scroll",this._domRefScrollHandler);delete this._oDomRefWithScrollHandler;}};b.prototype._onSyncScrollWithDomRef=function(){window.clearTimeout(this._iSyncScrollWithDomRef);this._iSyncScrollWithDomRef=window.setTimeout(function(){this._syncScrollWithDomRef();delete this._iSyncScrollWithDomRef;}.bind(this),0);};b.prototype._syncScrollWithDomRef=function(){D.syncScroll(this._oDomRefWithScrollHandler,this.$());};b.prototype.getGeometry=function(f){if(f||!this._mGeometry){var d=this.getAssociatedDomRef();var c;if(d){var i=this.isRoot();c=q.makeArray(d).map(function($){return D.getGeometry($,i);});}else{c=this.getChildren().map(function(e){return e.getGeometry(true);});}if(c.length){this._mGeometry=c.length>1?O.getGeometry(c):c[0];}else{delete this._mGeometry;}}return this._mGeometry;};b.prototype._cloneDomRef=function(d){var $=this.$();var c=$.find(">.sapUiDtClonedDom");var v=this.getDesignTimeMetadata().getCloneDomRef();if(v){if(d){var f=function(){if(v!==true){d=D.getDomRefForCSSSelector(d,v);}if(!c.length){c=q("<div class='sapUiDtClonedDom'></div>").prependTo($);}else{c.empty();}D.cloneDOMAndStyles(d,c);};if(!this._bClonedDom){this._bClonedDom=true;f();}else{window.clearTimeout(this._iCloneDomTimeout);this._iCloneDomTimeout=window.setTimeout(f,250);}}}else{c.remove();}};b.prototype._updateDom=function(){if(this.isRoot()){this._ensureIsInOverlayContainer();this.applyStyles();}else{this._ensureDomOrder();}};b.prototype._ensureDomOrder=function(){var $=this.$();var p=this.getParent();var c=p.$();var d=c.find(">.sapUiDtOverlayChildren");var i;var P;var e=p.getChildren();var f=e.indexOf(this)-1;while(f>=0){P=e[f].$();if(P.length){break;}f--;}if(P&&P.length){i=$.prev().get(0)===P.get(0);}else{i=d.children().index($)===0;}if(!i){if(P&&P.length){P.after($);}else{d.prepend($);}p.applyStyles();}};b.prototype._ensureIsInOverlayContainer=function(){var $=this.$();var c=$.parent();var a=b.getOverlayContainer();var p=c.length?c.get(0):null;if(a!==p){$.appendTo(a);}};b.prototype._onOverlayScroll=function(){var g=this.getGeometry();var d=g?g.domRef:null;if(d){D.syncScroll(this.$(),d);}};b.prototype.setVisible=function(v){if(this.getVisible()!==v){this.setProperty("visible",v);this._bVisible=v;this.fireVisibleChanged({visible:v});}return this;};b.prototype.getVisible=function(){if(this._bVisible===null){if(!this.getLazyRendering()){return true;}var d=this.getDesignTimeMetadata();return d?!d.isIgnored(this.getElementInstance()):false;}else{return this.getProperty("visible");}};b.prototype.isVisible=function(){return this.getVisible();};b.prototype.isRoot=function(){var p=this.getParent();if(p){if(!p.getDomRef){return true;}}};return b;},true);
