/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/fl/Persistence","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Change","sap/ui/fl/Cache","sap/ui/fl/registry/Settings","sap/ui/fl/ChangePersistenceFactory","sap/ui/core/mvc/View","sap/ui/fl/changeHandler/JsControlTreeModifier","sap/ui/fl/changeHandler/XmlTreeModifier","sap/ui/fl/context/ContextManager"],function(q,P,C,U,L,a,b,F,c,V,J,X,d){"use strict";var e=function(s,A){this._oChangePersistence=undefined;this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;if(this._sComponentName&&this._sAppVersion){this._createChangePersistence();}};e.appliedChangesCustomDataKey="sap.ui.fl:AppliedChanges";e.PENDING="sap.ui.fl:PendingChange";e.PROCESSING="sap.ui.fl:ProcessingChange";e.prototype.setComponentName=function(s){this._sComponentName=s;this._createChangePersistence();};e.prototype.getComponentName=function(){return this._sComponentName;};e.prototype.getAppVersion=function(){return this._sAppVersion;};e.prototype.getVariantModelData=function(){var D;if(this._oChangePersistence&&this._oChangePersistence._oVariantController._mVariantManagement&&Object.keys(this._oChangePersistence._oVariantController._mVariantManagement).length>0){D=this._oChangePersistence._oVariantController._fillVariantModel();}return D;};e.prototype.createChange=function(o,f){var g,h,i;if(!f){throw new Error("A flexibility change cannot be created without a targeted control.");}var j=d._getContextIdsFromUrl();if(j.length>1){throw new Error("More than one DesignTime Context is currently active.");}var s=f.id||f.getId();if(!o.selector){o.selector={};}var A=f.appComponent||U.getAppComponentForControl(f);if(!A){throw new Error("No Application Component found - to offer flexibility the control with the id '"+s+"' has to have a valid relation to its owning application component.");}if(U.hasLocalIdSuffix(s,A)){var l=A.getLocalId(s);if(!l){throw new Error("Generated ID attribute found ('"+s+"'); provide a stable ID for the control as required by flexibility for assigning the changes.");}o.selector.id=l;o.selector.idIsLocal=true;}else{o.selector.id=s;o.selector.idIsLocal=false;}o.reference=this.getComponentName();o.packageName="$TMP";o.context=j.length===1?j[0]:"";var k=this.getAppVersion();var v={creation:k,from:k};if(k&&o.developerMode){v.to=k;}o.validAppVersions=v;g=a.createInitialFileContent(o);h=new a(g);var m=f.controlType||U.getControlType(f);if(!m){throw new Error("No control type found - the change handler can not be retrieved.");}i=this._getChangeHandler(h,m);if(i){if(o["variantManagementKey"]&&o["variantKey"]){q.sap.log.error("VariantChange"+"-"+o["variantManagementKey"]+"-"+o["variantKey"]);}i.completeChangeContent(h,o,{modifier:J,appComponent:A});}else{throw new Error("Change handler could not be retrieved for change "+JSON.stringify(o)+".");}return h;};e.prototype.addChange=function(o,f){var g=this.createChange(o,f);var h=U.getAppComponentForControl(f);this._oChangePersistence.addChange(g,h);return g;};e.prototype.addPreparedChange=function(o,A){this._oChangePersistence.addChange(o,A);return o;};e.prototype.deleteChange=function(o){this._oChangePersistence.deleteChange(o);};e.prototype.createAndApplyChange=function(o,f){var g=this.addChange(o,f);try{var p={modifier:J,appComponent:U.getAppComponentForControl(f)};this.checkTargetAndApplyChange(g,f,p);}catch(E){this._oChangePersistence.deleteChange(g);throw E;}};e.prototype.saveAll=function(){return this._oChangePersistence.saveDirtyChanges();};e.prototype.processXmlView=function(v,p){var o=sap.ui.getCore().getComponent(p.componentId);var A=U.getAppComponentForControl(o);var m=o.getManifest();p.appComponent=A;p.appDescriptor=m;p.modifier=X;p.view=v;return this.processViewByModifier(p);};e.prototype.processViewByModifier=function(p){p.siteId=U.getSiteId(p.appComponent);return this._oChangePersistence.getChangesForView(p.viewId,p).then(this._resolveGetChangesForView.bind(this,p),this._handlePromiseChainError.bind(this,p.view));};e.prototype._resolveGetChangesForView=function(p,f){if(!Array.isArray(f)){var E="No list of changes was passed for processing the flexibility on view: "+p.view+".";U.log.error(E,undefined,"sap.ui.fl.FlexController");return[];}f.forEach(function(o){try{var s=this._getSelectorOfChange(o);if(!s||!s.id){throw new Error("No selector in change found or no selector ID.");}var g=p.modifier.bySelector(s,p.appComponent,p.view);if(!g){throw new Error("A flexibility change tries to change a nonexistent control.");}this.checkTargetAndApplyChange(o,g,p);}catch(h){this._logApplyChangeError(h,o);}}.bind(this));return p.view;};e.prototype._logApplyChangeError=function(E,o){var D=o.getDefinition();var s=D.changeType;var t=D.selector.id;var f=D.namespace+D.fileName+"."+D.fileType;var w="A flexibility change could not be applied.";w+="\nThe displayed UI might not be displayed as intedend.";if(E.message){w+="\n   occurred error message: '"+E.message+"'";}w+="\n   type of change: '"+s+"'";w+="\n   LRep location of the change: "+f;w+="\n   id of targeted control: '"+t+"'.";U.log.warning(w,undefined,"sap.ui.fl.FlexController");};e.prototype.checkTargetAndApplyChange=function(o,f,p){var m=p.modifier;var s=m.getControlType(f);var g=this._getChangeHandler(o,s);if(!g){U.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored");return;}var h=this._getAppliedCustomData(o,f,m);var A=h.appliedChangesString;var i=h.appliedChanges;var j=h.appliedChangeCustomData;var k=o.getId();if(i.indexOf(k)===-1){try{g.applyChange(o,f,p);}catch(l){this._setMergeError(true);U.log.error("Change could not be applied. Merge error detected.");return;}var v=A?A+","+k:k;this._writeCustomData(j,v,p,f);}};e.prototype._removeFromAppliedChangesAndMaybeRevert=function(o,f,p,r){var m=p.modifier;var s=m.getControlType(f);var g=this._getChangeHandler(o,s);if(r&&!g){U.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored");return;}var h=this._getAppliedCustomData(o,f,m);var A=h.appliedChanges;var i=h.appliedChangeCustomData;var j=o.getId();var I=A.indexOf(j);if(I>-1){if(r){try{g.revertChange(o,f,p);}catch(k){U.log.error("Change could not be reverted.");return;}}if(i){A.splice(I,1);this._writeCustomData(i,A.join(),p,f);}}};e.prototype._writeCustomData=function(o,v,p,f){var m=p.modifier;if(o){m.setProperty(o,"value",v);}else{var A=p.appComponent;var g=p.view;o=m.createControl("sap.ui.core.CustomData",A,g);m.setProperty(o,"key",e.appliedChangesCustomDataKey);m.setProperty(o,"value",v);m.insertAggregation(f,"customData",o,0,g,true);}};e.prototype._getAppliedCustomData=function(o,f,m){var g=m.getAggregation(f,"customData")||[];var r={appliedChanges:[]};g.some(function(h){var k=m.getProperty(h,"key");if(k===e.appliedChangesCustomDataKey){r.appliedChangeCustomData=h;r.appliedChangesString=m.getProperty(h,"value");r.appliedChanges=r.appliedChangesString.split(",");return true;}});return r;};e.prototype._handlePromiseChainError=function(v,E){U.log.error("Error processing view "+E+".");return v;};e.prototype._getSelectorOfChange=function(o){if(!o||!o.getSelector){return undefined;}return o.getSelector();};e.prototype.applyChange=function(o,f){var s=U.getControlType(f);var g=this._getChangeHandler(o,s);if(!g){if(o&&f){U.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored.");}return;}try{g.applyChange(o,f);}catch(h){this._setMergeError(true);U.log.error("Change could not be applied. Merge error detected.");throw h;}};e.prototype._getChangeHandler=function(o,s){var f,g;f=this._getChangeTypeMetadata(o,s);if(!f){return undefined;}g=f.getChangeHandler();return g;};e.prototype._getChangeTypeMetadata=function(o,s){var f,g;f=this._getChangeRegistryItem(o,s);if(!f||!f.getChangeTypeMetadata){return undefined;}g=f.getChangeTypeMetadata();return g;};e.prototype._getChangeRegistryItem=function(o,s){var f,g,l;if(!o||!s){return undefined;}f=o.getChangeType();if(!f||!s){return undefined;}l=o.getLayer();g=this._getChangeRegistry().getRegistryItems({"changeTypeName":f,"controlType":s,"layer":l});if(g&&g[s]&&g[s][f]){return g[s][f];}else if(g&&g[s]){return g[s];}else{return g;}};e.prototype._getChangeRegistry=function(){var i=C.getInstance();i.initSettings();return i;};e.prototype.getComponentChanges=function(p){return this._oChangePersistence.getChangesForComponent(p);};e.prototype.isPersonalized=function(p){p=p||{};p.includeVariants=true;return this.getComponentChanges(p).then(function(f){var i=f.some(function(o){return o.isUserDependent();});return!!i;});};e.prototype._createChangePersistence=function(){this._oChangePersistence=c.getChangePersistenceForComponent(this.getComponentName(),this.getAppVersion());return this._oChangePersistence;};e.prototype.discardChanges=function(f,D){var A=U.getCurrentLayer(!!D);var i=0;var l;var o;l=f.length;while(i<f.length){o=f[i];if(o&&o.getLayer&&o.getLayer()===A){this._oChangePersistence.deleteChange(o);}if(l===f.length){i++;}else{l=f.length;}}return this._oChangePersistence.saveDirtyChanges();};e.prototype.discardChangesForId=function(i,D){if(!i){return Promise.resolve();}var o=this._oChangePersistence.getChangesMapForComponent();var f=o.mChanges[i]||[];return this.discardChanges(f,D);};e.prototype._setMergeError=function(){return F.getInstance().then(function(s){s.setMergeErrorOccured(true);});};e.prototype._applyChangesOnControl=function(g,A,o){var m=g();var f=m.mChanges;var D=m.mDependencies;var h=m.mDependentChangesOnMe;var i=f[o.getId()]||[];i.forEach(function(j){if(!D[j.getKey()]){this.checkTargetAndApplyChange(j,o,{modifier:J,appComponent:A});this._updateDependencies(D,h,j.getKey());}else{D[j.getKey()][e.PENDING]=this.checkTargetAndApplyChange.bind(this,j,o,{modifier:J,appComponent:A});}}.bind(this));this._processDependentQueue(D,h);};e.prototype.getBoundApplyChangesOnControl=function(g,o){var B=this._applyChangesOnControl.bind(this,g,o);B._bIsSapUiFlFlexControllerApplyChangesOnControl=true;return B;};e.prototype.revertChangesOnControl=function(f,A){f.forEach(function(o){var p={modifier:J,appComponent:A};var s=this._getSelectorOfChange(o);var g=p.modifier.bySelector(s,p.appComponent);this._removeFromAppliedChangesAndMaybeRevert(o,g,{modifier:J,appComponent:A},true);this._oChangePersistence._deleteChangeInMap(o);}.bind(this));};e.prototype.applyVariantChanges=function(f,o){var A=U.getAppComponentForControl(o);var g=[];f.forEach(function(h){var m=this._oChangePersistence.getChangesMapForComponent().mChanges;var i=Object.keys(m).reduce(function(f,s){return f.concat(m[s]);},[]);this._oChangePersistence._addChangeAndUpdateDependencies(o,h,i.length,i);g.push(function(){var p={modifier:J,appComponent:A};var s=this._getSelectorOfChange(h);var j=p.modifier.bySelector(s,p.appComponent);if(!j){U.log.error("A flexibility change tries to change a nonexistent control.");return;}this._applyChangesOnControl(this._oChangePersistence.getChangesMapForComponent.bind(this._oChangePersistence),A,j);}.bind(this));}.bind(this));g.forEach(function(h){h();});};e.prototype.removeFromAppliedChangesOnControl=function(o,A,f){this._removeFromAppliedChangesAndMaybeRevert(o,f,{modifier:J,appComponent:A},false);};e.prototype._updateDependencies=function(D,m,s){if(m[s]){m[s].forEach(function(k){var o=D[k];var i=o.dependencies.indexOf(s);if(i>-1){o.dependencies.splice(i,1);}});delete m[s];}};e.prototype._processDependentQueue=function(D,m){var A;var f;do{A=[];f=[];for(var i=0;i<Object.keys(D).length;i++){var s=Object.keys(D)[i];var o=D[s];if(o[e.PENDING]&&o.dependencies.length===0&&!o[e.PROCESSING]){o[e.PROCESSING]=true;o[e.PENDING]();f.push(s);A.push(o.changeObject.getKey());}}for(var j=0;j<f.length;j++){delete D[f[j]];}for(var k=0;k<A.length;k++){this._updateDependencies(D,m,A[k]);}}while(A.length>0);};return e;},true);
