// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.fl.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.fl.EventHistory') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.EventHistory'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/EventHistory",function () {
	"use strict";

	/**
	 * Provides a history of events. This is needed to show/hide the personalization icon
	 *
	 * @namespace
	 * @alias sap.ui.fl.EventHistory
	 * @experimental Since 1.47.0
	 * @author SAP SE
	 * @version 1.48.6
	 */
	var EventHistory = function () {
	};

	EventHistory._aEventIds = [
		"ControlForPersonalizationRendered"
	];

	EventHistory._aUnsubscribedEventIds = [];

	EventHistory._oHistory = {};

	/**
	 * Starts listening to the events
	 *
	 * @public
	 */
	EventHistory.start = function () {
		EventHistory._aEventIds.forEach(function(sEventId) {
			if (EventHistory._aUnsubscribedEventIds.indexOf(sEventId) === -1) {
				sap.ui.getCore().getEventBus().subscribe("sap.ui", sEventId, EventHistory.saveEvent);
				EventHistory._oHistory[sEventId] = [];
			}
		});
	};

	/**
	 * Saves an event when fired
	 *
	 * @param {string} sChannelId The channel of the event
	 * @param {string} sEventId The identifier of the event
	 * @param {map} The parameter map carried by the event
	 *
	 * @public
	 */
	EventHistory.saveEvent = function (sChannelId, sEventId, mParameters) {
		var oEvent = {
			"channelId": sChannelId,
			"eventId": sEventId,
			"parameters": mParameters
		};

		if (EventHistory._oHistory[sEventId]) {
			EventHistory._oHistory[sEventId].push(oEvent);
		}
	};

	/**
	 * Returns the history of the event and stops listening
	 *
	 * @param {string} sEventId The identifier of the event
	 *
	 * @return {array} List of events
	 *
	 * @public
	 */
	EventHistory.getHistoryAndStop = function (sEventId) {
		sap.ui.getCore().getEventBus().unsubscribe("sap.ui", sEventId, EventHistory.saveEvent);
		EventHistory._addUnsubscribedEvent(sEventId);
		return EventHistory._oHistory[sEventId] || [];
	};

	EventHistory._addUnsubscribedEvent = function(sEventId) {
		if (EventHistory._aUnsubscribedEventIds.indexOf(sEventId) === -1) {
			EventHistory._aUnsubscribedEventIds.push(sEventId);
		}
	};

	return EventHistory;
}, /* bExport= */true);

}; // end of sap/ui/fl/EventHistory.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.FakeLrepLocalStorage') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.FakeLrepLocalStorage'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/FakeLrepLocalStorage",[], function() {
	"use strict";

	/**
	 * Class handling the Fake Lrep in localStorage
	 *
	 * @class
	 *
	 * @author SAP SE
	 * @version 1.48.6
	 *
	 * @private
	 * @static
	 * @since 1.48
	 * @alias sap.ui.fl.FakeLrepLocalStorage
	 */

	var FL_LREP_KEY = "sap.ui.fl.change";
	var FakeLrepLocalStorage = {};

	/**
	 * Creates the  Lrep change key
	 * @public
	 * @param  {String} sId - the Lrep change id
	 * @returns {String} the prefixed id
	 */
	FakeLrepLocalStorage.createChangeKey = function(sId) {

		if (sId) {
			return FL_LREP_KEY + "." + sId;
		}
	};

	/**
	 * The iterator for the local  Lrep changes (localStorage)
	 * @public
	 * @param {function} fnPredicate - the function to apply for each  cahnge
	 */
	FakeLrepLocalStorage.forEachLrepChangeInLocalStorage = function(fnPredicate) {

		for (var sKey in window.localStorage) {

			if (sKey.indexOf(FL_LREP_KEY) > -1) {
				fnPredicate(sKey);
			}
		}
	};

	/**
	 * Get a specific  Lrep change (localStorage)
	 * @public
	 * @param  {String} sId - the Lrep change id
	 * @returns {Object} the specific change
	 */
	FakeLrepLocalStorage.getChange = function(sId) {

		if (sId) {

			var sChange = window.localStorage.getItem(this.createChangeKey(sId));
			return JSON.parse(sChange);
		}
	};

	/**
	 * Get all  Lrep changes (localStorage)
	 * @returns {Object[]} all local  changes
	 */
	FakeLrepLocalStorage.getChanges = function() {

		var aChanges = [],
			oChange;

		this.forEachLrepChangeInLocalStorage(function(sKey) {

			oChange = JSON.parse(window.localStorage[sKey]);
			aChanges.push(oChange);
		});

		return aChanges;
	};

	/**
	 * Get the number of  Lrep changes (localStorage)
	 * @returns {Number} the amout of local  Lrep changes
	 */
	FakeLrepLocalStorage.getNumChanges = function() {

		var iChanges = 0;

		this.forEachLrepChangeInLocalStorage(function(sKey) {
			iChanges++;
		});

		return iChanges;
	};

	FakeLrepLocalStorage._aModifyCallbacks = [];

	/**
	 * Use this in tests to ensure the modify operation happend
	 * @param {Function} fnCallback callback, which is called, when the local storage is
	 */
	FakeLrepLocalStorage.attachModifyCallback = function(fnCallback) {
		this._aModifyCallbacks.push(fnCallback);
	};

	/**
	 * Stop listening on modify operations
	 * @param {Function} fnCallback callback to be removed
	 */
	FakeLrepLocalStorage.detachModifyCallback = function(fnCallback) {
		var i = this._aModifyCallbacks.indexOf(fnCallback);
		if (i !== -1){
			this._aModifyCallbacks.splice(i,1);
		}
	};

	FakeLrepLocalStorage._callModifyCallbacks = function() {
		this._aModifyCallbacks.forEach(function(fnCallback){
			fnCallback();
		});
	};
	/**
	 * Delete a specific  Lrep change (localStorage)
	 * @public
	 * @param  {String} sId - the Lrep change id
	 */
	FakeLrepLocalStorage.deleteChange = function(sId) {

		if (sId) {
			window.localStorage.removeItem(this.createChangeKey(sId));
		}

		this._callModifyCallbacks();
	};

	/**
	 * Delete all  Lrep changes (localStorage)
	 * @public
	 */
	FakeLrepLocalStorage.deleteChanges = function() {

		this.forEachLrepChangeInLocalStorage(function(sKey) {
			window.localStorage.removeItem(sKey);
		});
		this._callModifyCallbacks();
	};

	/**
	 * Save a  Lrep change (localStorage)
	 * @public
	 * @param  {String} sId - the Lrep change id
	 * @param  {Object} oChange - the change object
	 */
	FakeLrepLocalStorage.saveChange = function(sId, oChange) {

		if (sId && oChange) {

			var sChangeKey = this.createChangeKey(sId),
				sChange = JSON.stringify(oChange);

			window.localStorage.setItem(sChangeKey, sChange);
		}
		this._callModifyCallbacks();
	};

	return FakeLrepLocalStorage;

}, /* bExport= */ true);
}; // end of sap/ui/fl/FakeLrepLocalStorage.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.Preprocessor') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.fl.Processor
jQuery.sap.declare('sap.ui.fl.Preprocessor'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.Object'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/Preprocessor",[
	'jquery.sap.global', 'sap/ui/base/Object'
], function(jQuery, BaseObject) {
	'use strict';

	/**
	 * The implementation of the <code>Preprocessor</code> for the SAPUI5 flexibility services that can be hooked in the <code>View</code> life cycle.
	 *
	 * @name sap.ui.fl.Preprocessor
	 * @class
	 * @constructor
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 * @implements sap.ui.core.mvc.View.Preprocessor
	 */
	return BaseObject.extend("sap.ui.fl.Preprocessor", {});

}, /* bExport= */true);

}; // end of sap/ui/fl/Preprocessor.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.Utils') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.Utils'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/Utils",[
	"jquery.sap.global", "sap/ui/core/Component"
], function (jQuery, Component) {
	"use strict";
	//Stack of layers in the layered repository
	var aLayers = [
			"VENDOR",
			"PARTNER",
			"CUSTOMER_BASE",
			"CUSTOMER",
			"USER"
		];
	//Precalculates index of layers
	var mLayersIndex = {};
	aLayers.forEach(function(sLayer, iIndex){
		mLayersIndex[sLayer] = iIndex;
	});
	/**
	 * Provides utility functions for the SAPUI5 flexibility library
	 *
	 * @namespace
	 * @alias sap.ui.fl.Utils
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.25.0
	 */
	var Utils = {

		_aLayers : aLayers,
		_mLayersIndex : mLayersIndex,
		_sTopLayer : aLayers[aLayers.length - 1],
		_sMaxLayer : aLayers[aLayers.length - 1],
		DEFAULT_APP_VERSION : "DEFAULT_APP_VERSION",
		/**
		 * log object exposes available log functions
		 *
		 * @name sap.ui.fl.Utils.log
		 * @public
		 */
		log: {
			error: function (sMessage, sDetails, sComponent) {
				jQuery.sap.log.error(sMessage, sDetails, sComponent);
			},
			warning: function (sMessage, sDetails, sComponent) {
				jQuery.sap.log.warning(sMessage, sDetails, sComponent);
			},
			debug: function (sMessage, sDetails, sComponent) {
				jQuery.sap.log.debug(sMessage, sDetails, sComponent);
			}
		},

		/**
		 * Tries to retrieve the xsrf token from the controls OData Model. Returns empty string if retrieval failed.
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {String} XSRF Token
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.getXSRFTokenFromControl
		 */
		getXSRFTokenFromControl: function (oControl) {
			var oModel;
			if (!oControl) {
				return "";
			}

			// Get Model
			if (oControl && typeof oControl.getModel === "function") {
				oModel = oControl.getModel();
				return Utils._getXSRFTokenFromModel(oModel);
			}
			return "";
		},

		/**
		 * Returns XSRF Token from the Odata Model. Returns empty string if retrieval failed
		 *
		 * @param {sap.ui.model.odata.ODataModel} oModel - OData Model
		 * @returns {String} XSRF Token
		 * @private
		 */
		_getXSRFTokenFromModel: function (oModel) {
			var mHeaders;
			if (!oModel) {
				return "";
			}
			if (typeof oModel.getHeaders === "function") {
				mHeaders = oModel.getHeaders();
				if (mHeaders) {
					return mHeaders["x-csrf-token"];
				}
			}
			return "";
		},

		/**
		 * Returns the class name of the component the given control belongs to.
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {String} The component class name, ending with ".Component"
		 * @see sap.ui.base.Component.getOwnerIdFor
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.getComponentClassName
		 */
		getComponentClassName: function (oControl) {
			var oAppComponent;

			// determine UI5 component out of given control
			if (oControl) {
				oAppComponent = this.getAppComponentForControl(oControl);

				// check if the component is an application variant and assigned an application descriptor then use this as reference
				if (oAppComponent) {
					var sVariantId = this._getComponentStartUpParameter(oAppComponent, "sap-app-id");
					if (sVariantId) {
						return sVariantId;
					}

					if (oAppComponent.getManifestEntry("sap.ui5") && oAppComponent.getManifestEntry("sap.ui5").appVariantId) {
						return oAppComponent.getManifestEntry("sap.ui5").appVariantId;
					}
				}
			}

			return Utils.getComponentName(oAppComponent);
		},

		isVariantByStartupParameter: function (oControl) {
			// determine UI5 component out of given control
			if (oControl) {
				var oAppComponent = this.getAppComponentForControl(oControl);
				if (oAppComponent) {
					return !!this._getComponentStartUpParameter(oAppComponent, "sap-app-id");
				}
			}

			return false;
		},

		/**
		 * Returns the class name of the application component owning the passed component or the component name itself if
		 * this is already an application component.
		 *
		 * @param {sap.ui.base.Component} oComponent - SAPUI5 component
		 * @returns {String} The component class name, ending with ".Component"
		 * @see sap.ui.base.Component.getOwnerIdFor
		 * @public
		 * @since 1.40
		 * @function
		 * @name getAppComponentClassNameForComponent
		 */
		getAppComponentClassNameForComponent: function (oComponent) {
			return Utils.getComponentClassName(oComponent);
		},

		/**
		 * Returns the appDescriptor of the component for the given control
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {object} that represent the appDescriptor
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.getAppDescriptor
		 */
		getAppDescriptor: function (oControl) {
			var oManifest = null, oComponent = null, oComponentMetaData = null;

			// determine UI5 component out of given control
			if (oControl) {
				oComponent = this.getAppComponentForControl(oControl);

				// determine manifest out of found component
				if (oComponent && oComponent.getMetadata) {
					oComponentMetaData = oComponent.getMetadata();
					if (oComponentMetaData && oComponentMetaData.getManifest) {
						oManifest = oComponentMetaData.getManifest();
					}
				}
			}

			return oManifest;
		},

		/**
		 * Returns the siteId of a component
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {string} siteId - that represent the found siteId
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.getSiteId
		 */
		getSiteId: function (oControl) {
			var sSiteId = null, oComponent = null;

			// determine UI5 component out of given control
			if (oControl) {
				oComponent = this.getAppComponentForControl(oControl);

				// determine siteId from ComponentData
				if (oComponent) {

					//Workaround for back-end check: isApplicationPermitted
					//As long as FLP does not know about appDescriptorId we have to pass siteID and applicationID.
					//With startUpParameter hcpApplicationId we will get a concatenation of “siteId:applicationId”

					//sSiteId = this._getComponentStartUpParameter(oComponent, "scopeId");
					sSiteId = this._getComponentStartUpParameter(oComponent, "hcpApplicationId");

				}
			}

			return sSiteId;
		},

		/**
		 * Returns the siteId of a component when you already have the component data.
		 *
		 * @param {object} oComponentData - Component data
		 * @returns {string} siteId - that represent the found siteId
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.getSiteIdByComponentData
		 */
		getSiteIdByComponentData: function (oComponentData) {
			var sSiteId = null;

			sSiteId = this._getStartUpParameter(oComponentData, "hcpApplicationId");

			return sSiteId;
		},

		/**
		 * Indicates if the current application is a variant of an existing one and the VENDOR layer is selected
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {boolean} true if application is a variant and the VENDOR layer selected
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.isAppVariantMode
		 */
		isAppVariantMode: function (oControl) {
			return (Utils.isVendorLayer() && Utils.isApplicationVariant(oControl));
		},

		/**
		 * Indicates if the property value represents a binding
		 *
		 * @param {object} oPropertyValue - property value
		 * @returns {boolean} true if value represents a binding
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.isBinding
		 */
		isBinding: function (oPropertyValue) {
			var bIsBinding = false;
			if (oPropertyValue && typeof oPropertyValue === "string" && oPropertyValue.substring(0, 1) === "{" && oPropertyValue.slice(-1) === "}") {
				bIsBinding = true;
			}
			return bIsBinding;
		},

		/**
		 * Indicates if the VENDOR is selected
		 *
		 * @returns {boolean} true if it's an application variant
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.isVendorLayer
		 */
		isVendorLayer: function () {
			// variant mode only supported for vendor other types are not allowed to change standard control variants
			if (Utils.getCurrentLayer(false) === "VENDOR") {
				return true;
			}

			return false;
		},

		/**
		 * Indicates if the current application is a variant of an existing one
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {boolean} true if it's an application variant
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.isApplicationVariant
		 */
		isApplicationVariant: function (oControl) {
			var sFlexReference = Utils.getComponentClassName(oControl);
			var oAppComponent = Utils.getAppComponentForControl(oControl);
			var sComponentName = Utils.getComponentName(oAppComponent);
			return sFlexReference !== sComponentName;
		},

		/**
		 * Sets the top layer that the changes are applied to; if max layer is not specified, the highest layer in the layer stack is used.
		 *
		 * @param {string} sMaxLayer (optional) - name of the max layer
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.setMaxLayerParameter
		 */
		setMaxLayerParameter: function(sMaxLayer) {
			this._sMaxLayer = sMaxLayer || this._sTopLayer;
		},

		/**
		 * Converts layer name into index
		 * @param {string} sLayer - layer name
		 * @returns {Integer} index of the layer
		 * @function
		 * @name sap.ui.fl.Utils.getLayerIndex
		 */
		getLayerIndex: function(sLayer) {
			return this._mLayersIndex[sLayer];
		},

		/**
		 * Determines whether a layer is higher than the max layer.
		 *
		 * @param {String} sLayer - Layer name to be evaluated
		 * @returns {boolean} <code>true<code> if input layer is higher than max layer, otherwise <code>false<code>
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.isOverMaxLayer
		 */
		isOverMaxLayer: function(sLayer) {
			return (this.getLayerIndex(sLayer) > this.getLayerIndex(this._sMaxLayer));
		},

		/**
		 * Determines if filtering of changes based on layer is required.
		 *
		 * @returns {boolean} <code>true<code> if the top layer is also the max layer, otherwise <code>false<code>
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.isLayerFilteringRequired
		 */
		isLayerFilteringRequired: function() {
			return !(this._sTopLayer === this._sMaxLayer);
		},

		/**
		 * Determines the content for a given startUpParameter name
		 *
		 * @param {sap.ui.core.Component} oComponent - component instance
		 * @param {String} sParameterName - startUpParameterName that shall be determined
		 * @returns {String} content of found startUpParameter
		 * @private
		 */
		_getComponentStartUpParameter: function (oComponent, sParameterName) {
			var startUpParameterContent = null;

			if (sParameterName) {
				if (oComponent && oComponent.getComponentData) {
					startUpParameterContent = this._getStartUpParameter(oComponent.getComponentData(), sParameterName);
				}
			}

			return startUpParameterContent;
		},

		_getStartUpParameter: function (oComponentData, sParameterName) {
			if (oComponentData && oComponentData.startupParameters && sParameterName) {
				if (jQuery.isArray(oComponentData.startupParameters[sParameterName])) {
					return oComponentData.startupParameters[sParameterName][0];
				}
			}
		},

		/**
		 * Gets the component name for a component instance.
		 *
		 * @param {sap.ui.core.Component} oComponent component instance
		 * @returns {String} component name
		 * @public
		 */
		getComponentName: function (oComponent) {
			var sComponentName = "";
			if (oComponent) {
				sComponentName = oComponent.getMetadata().getName();
			}
			if (sComponentName.length > 0 && sComponentName.indexOf(".Component") < 0) {
				sComponentName += ".Component";
			}
			return sComponentName;
		},

		/**
		 * Gets the component instance for a component ID.
		 *
		 * @param {String} sComponentId component ID
		 * @returns {sap.ui.core.Component} component for the component ID
		 * @private
		 */
		_getComponent: function (sComponentId) {
			var oComponent;
			if (sComponentId) {
				oComponent = sap.ui.getCore().getComponent(sComponentId);
			}
			return oComponent;
		},

		/**
		 * Returns ComponentId of the control. If the control has no component, it walks up the control tree in order to find a control having one
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {String} The component id
		 * @see sap.ui.base.Component.getOwnerIdFor
		 * @private
		 */
		_getComponentIdForControl: function (oControl) {
			var sComponentId = "", i = 0;
			do {
				i++;
				sComponentId = Utils._getOwnerIdForControl(oControl);
				if (sComponentId) {
					return sComponentId;
				}
				if (oControl && typeof oControl.getParent === "function") { // Walk up control tree
					oControl = oControl.getParent();
				} else {
					return "";
				}
			} while (oControl && i < 100);
			return "";
		},

		/**
		 * Returns the Component that belongs to given control. If the control has no component, it walks up the control tree in order to find a
		 * control having one.
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {sap.ui.base.Component} found component
		 * @public
		 */
		getComponentForControl: function (oControl) {
			return Utils._getComponentForControl(oControl);
		},

		/**
		 * Returns the Component that belongs to given control whose type is "application". If the control has no component, it walks up the control tree in order to find a
		 * control having one.
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {sap.ui.base.Component} found component
		 * @public
		 */
		getAppComponentForControl: function (oControl) {
			var oComponent;

			if (oControl instanceof sap.ui.core.Component) {
				oComponent = oControl;
			} else {
				oComponent = this._getComponentForControl(oControl);
			}
			return this._getAppComponentForComponent(oComponent);
		},

		/**
		 * Returns the Component that belongs to given control. If the control has no component, it walks up the control tree in order to find a
		 * control having one.
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {sap.ui.base.Component} found component
		 * @private
		 */
		_getComponentForControl: function (oControl) {
			var oComponent = null;
			var sComponentId = null;

			// determine UI5 component out of given control
			if (oControl) {
				sComponentId = Utils._getComponentIdForControl(oControl);
				if (sComponentId) {
					oComponent = Utils._getComponent(sComponentId);
				}
			}

			return oComponent;
		},

		/**
		 * Returns the Component that belongs to given component whose type is "application".
		 *
		 * @param {sap.ui.base.Component} oComponent - SAPUI5 component
		 * @returns {sap.ui.base.Component} found component
		 * @private
		 */
		_getAppComponentForComponent: function (oComponent) {
			var oSapApp = null;

			// special case for Fiori Elements to reach the real appComponent
			if (oComponent && oComponent.getAppComponent) {
				return oComponent.getAppComponent();
			}

			// special case for OVP
			if (oComponent && oComponent.oComponentData && oComponent.oComponentData.appComponent) {
				return oComponent.oComponentData.appComponent;
			}

			if (oComponent && oComponent.getManifestEntry) {
				oSapApp = oComponent.getManifestEntry("sap.app");
			} else {
				return oComponent;
			}

			if (oSapApp && oSapApp.type && oSapApp.type !== "application") {
				//we need to call this method only when the component
				//an instance of Component is in order to walk up the tree.
				if (oComponent instanceof sap.ui.core.Component) {
					oComponent = this._getComponentForControl(oComponent);
				}
				return this.getAppComponentForControl(oComponent);
			}

			return oComponent;
		},

		/**
		 * Returns the parent view of the control. If there are nested views, only the one closest to the control will be returned. If no view can be
		 * found, undefiend will be returned.
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {sap.ui.core.mvc.View} The view
		 * @see sap.ui.base.Component.getOwnerIdFor
		 * @public
		 */
		getViewForControl: function (oControl) {
			return Utils.getFirstAncestorOfControlWithControlType(oControl, sap.ui.core.mvc.View);

		},

		getFirstAncestorOfControlWithControlType: function (oControl, controlType) {
			if (oControl instanceof controlType) {
				return oControl;
			}

			if (oControl && typeof oControl.getParent === "function") {
				oControl = oControl.getParent();
				return Utils.getFirstAncestorOfControlWithControlType(oControl, controlType);
			}
		},

		hasControlAncestorWithId: function (sControlId, sAncestorControlId) {
			var oControl;

			if (sControlId === sAncestorControlId) {
				return true;
			}

			oControl = sap.ui.getCore().byId(sControlId);
			while (oControl) {

				if (oControl.getId() === sAncestorControlId) {
					return true;
				}

				if (typeof oControl.getParent === "function") {
					oControl = oControl.getParent();
				} else {
					return false;
				}
			}

			return false;
		},

		/**
		 * Checks whether the provided control is a view
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {Boolean} Flag
		 * @see sap.ui.base.Component.getOwnerIdFor
		 * @private
		 */
		_isView: function (oControl) {
			return oControl instanceof sap.ui.core.mvc.View;
		},

		/**
		 * Returns OwnerId of the control
		 *
		 * @param {sap.ui.core.Control} oControl - SAPUI5 control
		 * @returns {String} The owner id
		 * @see sap.ui.base.Component.getOwnerIdFor
		 * @private
		 */
		_getOwnerIdForControl: function (oControl) {
			return Component.getOwnerIdFor(oControl);
		},

		/**
		 * Returns the current layer as defined by the url parameter. If the end user flag is set, it always returns "USER".
		 *
		 * @param {boolean} bIsEndUser - the end user flag
		 * @returns {string} the current layer
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.getCurrentLayer
		 */
		getCurrentLayer: function (bIsEndUser) {
			var oUriParams, layer;
			if (bIsEndUser) {
				return "USER";
			}

			oUriParams = this._getUriParameters();
			layer = oUriParams.mParams["sap-ui-layer"];
			if (layer && layer.length > 0) {
				return layer[0];
			}
			return "CUSTOMER";

		},

		/**
		 * Checks if a shared newly created variant requires an ABAP package; this is relevant for the VENDOR, PARTNER and CUSTOMER_BASE layers,
		 * whereas variants in the CUSTOMER layer are client-dependent content and can either be transported or stored as local objects ($TMP).
		 * A variant in the CUSTOMER layer that will be transported must not be assigned to a package.
		 *
		 * @returns {boolean} - Indicates whether a new variant needs an ABAP package
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.doesSharedVariantRequirePackage
		 */
		doesSharedVariantRequirePackage: function () {
			var sCurrentLayer;
			sCurrentLayer = Utils.getCurrentLayer(false);
			if ((sCurrentLayer === "VENDOR") || (sCurrentLayer === "PARTNER") || (sCurrentLayer === "CUSTOMER_BASE")) {
				return true;
			}

			return false;
		},

		/**
		 * Returns the tenant number for the communication with the ABAP back end.
		 *
		 * @public
		 * @function
		 * @returns {string} the current client
		 * @name sap.ui.fl.Utils.getClient
		 */
		getClient: function () {
			var oUriParams, client;
			oUriParams = this._getUriParameters();
			client = oUriParams.mParams["sap-client"];
			if (client && client.length > 0) {
				return client[0];
			}
			return undefined;
		},

		_getUriParameters: function () {
			return jQuery.sap.getUriParameters();
		},
		/**
		 * Returns whether the hot fix mode is active (url parameter hotfix=true)
		 *
		 * @public
		 * @returns {bool} is hotfix mode active, or not
		 */
		isHotfixMode: function () {
			var oUriParams, aIsHotfixMode, sIsHotfixMode;
			oUriParams = this._getUriParameters();
			aIsHotfixMode = oUriParams.mParams["hotfix"];
			if (aIsHotfixMode && aIsHotfixMode.length > 0) {
				sIsHotfixMode = aIsHotfixMode[0];
			}
			return (sIsHotfixMode === "true");
		},

		/**
		 * Converts the browser language into a 2-character ISO 639-1 language. If the browser language is in format RFC4646, the first part will be
		 * used: For example en-us will be converted to EN. If the browser language already is in ISO 639-1, it will be returned after an upper case
		 * conversion: For example de will be converted to DE.
		 *
		 * @param {String} sBrowserLanguage - Language in RFC4646
		 * @returns {String} Language in ISO 639-1. Empty string if conversion was not successful
		 * @public
		 * @function
		 * @name sap.ui.fl.Utils.convertBrowserLanguageToISO639_1
		 */
		convertBrowserLanguageToISO639_1: function (sBrowserLanguage) {
			if (!sBrowserLanguage || typeof sBrowserLanguage !== "string") {
				return "";
			}

			var nIndex = sBrowserLanguage.indexOf("-");
			if ((nIndex < 0) && (sBrowserLanguage.length <= 2)) {
				return sBrowserLanguage.toUpperCase();
			}
			if (nIndex > 0 && nIndex <= 2) {
				return sBrowserLanguage.substring(0, nIndex).toUpperCase();
			}

			return "";
		},

		/**
		 * Returns the current language in ISO 639-1 format.
		 *
		 * @returns {String} Language in ISO 639-1. Empty string if language cannot be determined
		 * @public
		 */
		getCurrentLanguage: function () {
			var sLanguage = sap.ui.getCore().getConfiguration().getLanguage();
			return Utils.convertBrowserLanguageToISO639_1(sLanguage);
		},

		/**
		 * Retrieves the controlType of the control
		 *
		 * @param {sap.ui.core.Control} oControl Control instance
		 * @returns {string} control type of the control - undefined if controlType cannot be determined
		 * @private
		 */
		getControlType: function (oControl) {
			var oMetadata;
			if (oControl && typeof oControl.getMetadata === "function") {
				oMetadata = oControl.getMetadata();
				if (oMetadata && typeof oMetadata.getElementName === "function") {
					return oMetadata.getElementName();
				}
			}
		},

		/**
		 * Converts ASCII coding into a string. Required for restoring stored code extinsions
		 *
		 * @param {String} ascii string containing ascii code valid numbers seperated by ','
		 * @returns {String} parsedString parsed string
		 */
		asciiToString: function (ascii) {
			var asciiArray = ascii.split(",");
			var parsedString = "";

			jQuery.each(asciiArray, function (index, asciiChar) {
				parsedString += String.fromCharCode(asciiChar);
			});

			return parsedString;

		},

		/**
		 * Converts ASCII coding into a string. Required for restoring stored code extinsions
		 *
		 * @param {String} string string which has to be encoded
		 * @returns {String} ascii imput parsed to ascii numbers seperated by ','
		 */
		stringToAscii: function (string) {
			var ascii = "";

			for (var i = 0; i < string.length; i++) {
				ascii += string.charCodeAt(i) + ",";
			}

			// remove last ","
			ascii = ascii.substring(0, ascii.length - 1);

			return ascii;
		},

		_fnCheckElementIsNoClone: function (oElement) {
			var bElementIsNoClone = true;

			if (oElement.getBindingContext && oElement.getBindingContext()) {
				var aBindingHierarchy = oElement.getBindingContext().getPath().split("/");
				var sLowestBindingHierarchy = aBindingHierarchy[aBindingHierarchy.length - 1];
				bElementIsNoClone = isNaN(sLowestBindingHierarchy);
			}

			return bElementIsNoClone;
		},

		/**
		 * Check if the control id is generated or maintained by the application
		 *
		 * @param {sap.ui.core.Control | string} vControl Control instance or id
		 * @param {sap.ui.core.Component} [oAppComponent] oAppComponent application component, needed only if vControl is string (id)
		 * @param {boolean} [bSuppressLogging] bSuppressLogging flag to suppress the warning in the console
		 * @returns {boolean} Returns true if the id is maintained by the application
		 */
		checkControlId: function (vControl, oAppComponent, bSuppressLogging) {

			var sControlId = vControl instanceof sap.ui.base.ManagedObject ? vControl.getId() : vControl;
			if (!oAppComponent) {
				vControl = vControl instanceof sap.ui.base.ManagedObject ? vControl : sap.ui.getCore().byId(sControlId);
				oAppComponent = Utils.getAppComponentForControl(vControl);
			}
			var bIsGenerated = sap.ui.base.ManagedObjectMetadata.isGeneratedId(sControlId);

			if (!bIsGenerated || this.hasLocalIdSuffix(vControl, oAppComponent)) {
				return true;
			} else {


				var sHasConcatenatedId = sControlId.indexOf("--") !== -1;
				if (!bSuppressLogging && !sHasConcatenatedId && this._fnCheckElementIsNoClone(vControl)) {
					this.log.warning("Generated id attribute found, to offer flexibility a stable control id is needed " +
						"to assign the changes to, but for this control the id was generated by SAPUI5", sControlId);
				}
				return false;
			}
		},

		/**
		 * Checks if a control id has a prefix matching the application component it.
		 * If this prefix exists the suffix after the component Id is called the local id.
		 *
		 * @param {sap.ui.core.Control | string} vControl ui5 control or id to be checked if it is wihtin the generic application
		 * @param {sap.ui.core.Component} oAppComponent application component, needed only if vControl is string (id)
		 * @returns {boolean} control has a local id
		 */
		hasLocalIdSuffix: function (vControl, oAppComponent) {
			var sControlId = (vControl instanceof sap.ui.base.ManagedObject) ? vControl.getId() : vControl;

			if (!oAppComponent) {
				this.log.error("determination of a local id suffix failed due to missing app component for " + sControlId);
				return false;
			}

			return !!oAppComponent.getLocalId(sControlId);
		},

		/**
		 * Returns the a string containing all url parameters of the current window.location
		 *
		 * @returns {string} Substring of url containing the url query parameters
		 * @private
		 */
		_getAllUrlParameters: function () {
			return window.location.search.substring(1);
		},

		/**
		 * Returns the value of the specified url parameter of the current url
		 *
		 * @param {String} sParameterName - Name of the url parameter
		 * @returns {string} url parameter
		 * @private
		 */
		getUrlParameter: function (sParameterName) {
			return jQuery.sap.getUriParameters().get(sParameterName);
		},

		createDefaultFileName: function (sNameAddition) {
			var sFileName = jQuery.sap.uid().replace(/-/g, "_");
			if (sNameAddition) {
				sFileName += '_' + sNameAddition;
			}
			return sFileName;
		},

		createNamespace: function (oPropertyBag, sSubfolder) {
			var sReferenceName = oPropertyBag.reference.replace('.Component', '');
			var sNamespace = 'apps/' + sReferenceName + "/" + sSubfolder + "/";
			return sNamespace;
		},

		isApplication: function (oManifest) {
			return (oManifest && oManifest.getEntry("sap.app") && oManifest.getEntry("sap.app").type === "application");
		},

		/**
		 * Returns the reference of a component, according to the following logic:
		 * First appVariantId, if not, componentName + ".Component", if not appId + ".Component".
		 *
		 * @param {object} oManifest - Manifest of the component
		 * @returns {string} flex reference
		 * @public
		 */
		getFlexReference: function (oManifest) {
			if (oManifest) {
				if (oManifest.getEntry("sap.ui5")) {
					if (oManifest.getEntry("sap.ui5").appVariantId) {
						return oManifest.getEntry("sap.ui5").appVariantId;
					}
					if (oManifest.getEntry("sap.ui5").componentName) {
						return oManifest.getEntry("sap.ui5").componentName + ".Component";
					}
				}
				if (oManifest.getEntry("sap.app") && oManifest.getEntry("sap.app").id) {
					return oManifest.getEntry("sap.app").id + ".Component";
				}
			}
			this.log.warning("No Manifest received.");
			return "";
		},

		/**
		 * Returns the semantic application version using format: "major.minor.patch".
		 *
		 * @param {object} oManifest - Manifest of the component
		 * @returns {string} Version of application if it is available in the manifest, otherwise an empty string
		 * @public
		 */
		getAppVersionFromManifest: function (oManifest) {
			var sVersion = "";
			if (oManifest){
				var oSapApp = (oManifest.getEntry) ? oManifest.getEntry("sap.app") : oManifest["sap.app"];
				if (oSapApp && oSapApp.applicationVersion && oSapApp.applicationVersion.version){
					sVersion = oSapApp.applicationVersion.version;
				}
			} else {
				this.log.warning("No Manifest received.");
			}
			return sVersion;
		},

		/**
		 * Returns whether provided layer is a customer dependent layer
		 *
		 * @returns {boolean} true if provided layer is customer dependent layer else false
		 * @public
		 */
		isCustomerDependentLayer : function(sLayerName) {
			return (["CUSTOMER", "CUSTOMER_BASE"].indexOf(sLayerName) > -1);
		}
	};
	return Utils;
}, true);

}; // end of sap/ui/fl/Utils.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.Base') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.changeHandler.Base'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/changeHandler/Base",[
	"sap/ui/fl/Utils", "jquery.sap.global"
], function(Utils, $) {
	"use strict";

	/**
	 * Base functionality for all change handler which provides some reuse methods
	 * @alias sap.ui.fl.changeHandler.Base
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 *
	 */
	var Base = { };

	/**
	 * Sets a text in a change.
	 *
	 * @param {object} oChange - change object
	 * @param {string} sKey - text key
	 * @param {string} sText - text value
	 * @param {string} sType - translation text type e.g. XBUT, XTIT, XTOL, XFLD
	 *
	 * @public
	 */
	Base.setTextInChange = function(oChange, sKey, sText, sType) {
		if (!oChange.texts) {
			oChange.texts = {};
		}
		if (!oChange.texts[sKey]) {
			oChange.texts[sKey] = {};
		}
		oChange.texts[sKey].value = sText;
		oChange.texts[sKey].type = sType;
	};

	return Base;
}, /* bExport= */true);

}; // end of sap/ui/fl/changeHandler/Base.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.BaseRename') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.changeHandler.BaseRename'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/changeHandler/BaseRename",[
	"jquery.sap.global", "./Base", "sap/ui/fl/Utils"
    ], function(jQuery, Base, Utils) {
		"use strict";

		/**
		 * Base Change Handler for Rename
		 *
		 * @constructor
		 * @alias sap.ui.fl.changeHandler.BaseRename
		 * @author SAP SE
		 * @version 1.48.6
		 * @experimental Since 1.46
		 */
		var BaseRename = {

			/**
			 * Returns an instance of the rename change handler
			 * @param  {object} mRenameSettings The settings required for the rename action
			 *                  mRenameSettings.propertyName The property from the control to be renamed (e.g. "label")
			 *                  mRenameSettings.changePropertyName Only use if you have to have migration changeHandler: Property name in change (for LRep; e.g. "fieldLabel")
			 *                  mRenameSettings.translationTextType The translation text type in change (e.g. "XFLD")
			 * @return {any} the rename change handler object
			 */
			createRenameChangeHandler: function(mRenameSettings) {

				mRenameSettings.changePropertyName = mRenameSettings.changePropertyName || "newText";

				return {

					/**
					 * Renames a control.
					 *
					 * @param {sap.ui.fl.Change} oChange change wrapper object with instructions to be applied on the control map
					 * @param {sap.ui.core.Control} oControl Control that matches the change selector for applying the change
					 * @param {object} mPropertyBag property bag
					 * @param {object} mPropertyBag.modifier modifier for the controls
					 * @returns {boolean} true if successful
					 * @public
					 */
					applyChange : function(oChange, oControl, mPropertyBag) {
						var oModifier = mPropertyBag.modifier;
						var sPropertyName = mRenameSettings.propertyName;
						var oChangeDefinition = oChange.getDefinition();
						var sText = oChangeDefinition.texts[mRenameSettings.changePropertyName];
						var sValue = sText.value;

						if (oChangeDefinition.texts && sText && typeof (sValue) === "string") {

							// The value can be a binding - e.g. for translatable values in WebIde
							if (Utils.isBinding(sValue)) {
								oModifier.setPropertyBinding(oControl, sPropertyName, sValue);
							} else {
								oModifier.setProperty(oControl, sPropertyName, sValue);
							}
							return true;

						} else {
							Utils.log.error("Change does not contain sufficient information to be applied: [" + oChangeDefinition.layer + "]" + oChangeDefinition.namespace + "/" + oChangeDefinition.fileName + "." + oChangeDefinition.fileType);
							//however subsequent changes should be applied
						}
					},

					/**
					 * Completes the change by adding change handler specific content
					 *
					 * @param {sap.ui.fl.Change} oChange change wrapper object to be completed
					 * @param {object} mSpecificChangeInfo with attribute (e.g. textLabel) to be included in the change
					 * @public
					 */
					completeChangeContent : function(oChange, mSpecificChangeInfo, mPropertyBag) {
						var oChangeDefinition = oChange.getDefinition();
						var sChangePropertyName = mRenameSettings.changePropertyName;
						var sTranslationTextType = mRenameSettings.translationTextType;

						var oControlToBeRenamed = mPropertyBag.modifier.bySelector(oChange.getSelector(), mPropertyBag.appComponent);
						oChangeDefinition.content.originalControlType = mPropertyBag.modifier.getControlType(oControlToBeRenamed);

						if (typeof (mSpecificChangeInfo.value) === "string") {
							Base.setTextInChange(oChangeDefinition, sChangePropertyName, mSpecificChangeInfo.value, sTranslationTextType);
						} else {
							throw new Error("oSpecificChangeInfo.value attribute required");
						}
					}

				};
			}
		};

		return BaseRename;
	},
/* bExport= */true);
}; // end of sap/ui/fl/changeHandler/BaseRename.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.BaseTreeModifier') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.changeHandler.BaseTreeModifier'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/changeHandler/BaseTreeModifier",["sap/ui/fl/Utils", "sap/ui/base/ManagedObject"], function(Utils, ManagedObject) {

	"use strict";

	return {
		/** Function determining the control targeted by the change.
		* The function differs between local ids generated starting with 1.40 and the global ids generated in previous versions.
		*
		* @param {object} oSelector - Target of a flexiblity change
		* @param {string} oSelector.id - id of the control targeted by the change
		* @param {boolean} oSelector.isLocalId - true if the id within the selector is a local id or a global id
		* @param {sap.ui.core.UIComponent} oAppComponent
		* @param {object} mAdditionalSelectorInformation additional mapped data which is added to the selector
		* @param {Node} oView - only for xml processing: the xml node of the view
		* @returns {sap.ui.core.Control} - control targeted within the selector
		* @throws {Exception} oException - in case no control could be determined an error is thrown
		* @public
		*/
		bySelector: function (oSelector, oAppComponent, oView) {
		   var sControlId = this.getControlIdBySelector(oSelector, oAppComponent);
		   return this._byId(sControlId, oView);
		},

		/** Function determining the control id from selector.
		* The function differs between local ids generated starting with 1.40 and the global ids generated in previous versions.
		*
		* @param {object} oSelector - Target of a flexiblity change
		* @param {string} oSelector.id - id of the control targeted by the change
		* @param {boolean} oSelector.isLocalId - true if the id within the selector is a local id or a global id
		* @param {sap.ui.core.UIComponent} oAppComponent
		* @returns {sap.ui.core.Control} - control targeted within the selector
		* @throws {Exception} oException - in case no control could be determined an error is thrown
		* @public
		*/
		getControlIdBySelector: function (oSelector, oAppComponent) {
			if (!oSelector){
				return undefined;
			}

		   if (typeof oSelector === "string") {
		      oSelector = {
		         id: oSelector
		      };
		   }

		   var sControlId = oSelector.id;

		   if (oSelector.idIsLocal) {
		      if (oAppComponent) {
		         sControlId = oAppComponent.createId(sControlId);
		      } else {
		         throw new Error("App Component instance needed to get a control's id from selector");
		      }
		   } else {
		      // does nothing except in the case of a FLP prefix
		      var pattern = /^application-[^-]*-[^-]*-component---/igm;
		      var bHasFlpPrefix = !!pattern.exec(oSelector.id);
		      if (bHasFlpPrefix) {
		         sControlId = sControlId.replace(/^application-[^-]*-[^-]*-component---/g, "");
		         if (oAppComponent) {
		            sControlId = oAppComponent.createId(sControlId);
		         } else {
		            throw new Error("App Component instance needed to get a control's id from selector");
		         }
		      }
		   }

		   return sControlId;
		},


		/** Function for determining the selector later used to apply a change for a given control.
		 * The function differs between local ids generated starting with 1.40 and the global ids generated in previous versions.
		 *
		 * @param {sap.ui.core.Control | string} vControl - sapui5 control or id string for which the selector should be determined
		 * @param {object} mAdditionalSelectorInformation additional mapped data which is added to the selector
		 * @param {sap.ui.core.Component} (optional) oAppComponent application component, needed only if vControl is a string or XML Node
		 * @returns {object} - oSelector
		 * @returns {string} - oSelector.id id used for determination of the flexibility target
		 * @returns {boolean} - oSelector.idIsLocal flag if the selector.id has to be concatenated with the application component id
		 * while applying the change.
		 * @throws {Exception} oException - in case no control could be determined an error is thrown
		 * @public
		 */
		getSelector: function (vControl, oAppComponent, mAdditionalSelectorInformation) {
			var sControlId = vControl;
			if (vControl instanceof ManagedObject) {
				sControlId = vControl.getId();
			} else {
				if (!oAppComponent) {
					throw new Error("App Component instance needed to get a selector from string id");
				}
			}

			if (mAdditionalSelectorInformation && (mAdditionalSelectorInformation.id || mAdditionalSelectorInformation.idIsLocal)) {
				throw new Error("A selector of control with the id '" + sControlId + "' was requested, " +
					"but core properties were overwritten by the additionally passed information.");
			}

			var bValidId = Utils.checkControlId(vControl, oAppComponent);

			if (!bValidId) {
				throw new Error("Generated id attribute found - to offer flexibility a stable control id is needed to assign the changes to, but for this control the id was generated by SAPUI5 " + sControlId);
			}

			var oSelector = jQuery.extend(mAdditionalSelectorInformation || {}, {
				id: "",
				idIsLocal: false
			}, true);


			if (Utils.hasLocalIdSuffix(vControl, oAppComponent)) {
				// get local Id for control at root component and use it as selector id
				var sLocalId = oAppComponent.getLocalId(sControlId);
				oSelector.id = sLocalId;
				oSelector.idIsLocal = true;
			} else {
				oSelector.id = sControlId;
			}

			return oSelector;
		}
	};
});


}; // end of sap/ui/fl/changeHandler/BaseTreeModifier.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.HideControl') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.changeHandler.HideControl'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/changeHandler/HideControl",[
	'jquery.sap.global', './Base'
], function(jQuery, Base) {
	"use strict";

	/**
	 * Change handler for hiding of a control.
	 * @alias sap.ui.fl.changeHandler.HideControl
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 */
	var HideControl = { };

	/**
	 * Hides a control.
	 *
	 * @param {sap.ui.fl.Change} oChange change object with instructions to be applied on the control map
	 * @param {sap.ui.core.Control} oControl control that matches the change selector for applying the change
	 * @param {object} mPropertyBag.modifier - modifier for the controls
	 * @param {object} mPropertyBag	- map of properties
	 * @return {boolean} true - if change could be applied
	 * @public
	 */
	HideControl.applyChange = function(oChange, oControl, mPropertyBag) {
		mPropertyBag.modifier.setVisible(oControl, false);
		return true;
	};

	/**
	 * Completes the change by adding change handler specific content
	 *
	 * @param {sap.ui.fl.Change} oChange change object to be completed
	 * @param {object} oSpecificChangeInfo as an empty object since no additional attributes are required for this operation
	 * @public
	 */
	HideControl.completeChangeContent = function(oChange, oSpecificChangeInfo) {

	};

	return HideControl;
},
/* bExport= */true);

}; // end of sap/ui/fl/changeHandler/HideControl.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.JsControlTreeModifier') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.changeHandler.JsControlTreeModifier'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/changeHandler/JsControlTreeModifier",["sap/ui/fl/changeHandler/BaseTreeModifier", "sap/ui/fl/Utils"], function (BaseTreeModifier, Utils) {

		"use strict";

		var JsControlTreeModifier = {

			targets: "jsControlTree",

			setVisible: function (oControl, bVisible) {
				if (oControl.setVisible) {
					this.unbindProperty(oControl, "visible");
					oControl.setVisible(bVisible);
				} else {
					throw new Error("Provided control instance has no setVisible method");
				}
			},

			getVisible: function (oControl) {
				if (oControl.getVisible) {
					return oControl.getVisible();
				} else {
					throw new Error("Provided control instance has no getVisible method");
				}
			},

			setStashed: function (oControl, bStashed) {
				if (oControl.setStashed) {
					if (oControl.setVisible) {
						oControl.setVisible(!bStashed);
					}
					oControl.setStashed(bStashed);
				} else {
					throw new Error("Provided control instance has no setStashed method");
				}
			},

			bindProperty: function (oControl, sPropertyName, mBindingInfos) {
				oControl.bindProperty(sPropertyName, mBindingInfos);
			},

			/**
			 * Unbind a property
			 * The value should not be reset to default when unbinding (bSuppressReset = true)
			 * @param  {sap.ui.core.Control} oControl  The control containing the property
			 * @param  {String} sPropertyName  The property to be unbound
			 */
			unbindProperty: function (oControl, sPropertyName) {
				if (oControl) {
					oControl.unbindProperty(sPropertyName, /*bSuppressReset = */true);
				}
			},

			setProperty: function (oControl, sPropertyName, oPropertyValue) {
				var oMetadata = oControl.getMetadata().getPropertyLikeSetting(sPropertyName);
				this.unbindProperty(oControl, sPropertyName);

				if (oMetadata) {
					var sPropertySetter = oMetadata._sMutator;
					oControl[sPropertySetter](oPropertyValue);
				}
			},

			getProperty: function (oControl, sPropertyName) {
				var oMetadata = oControl.getMetadata().getPropertyLikeSetting(sPropertyName);
				if (oMetadata) {
					var sPropertyGetter = oMetadata._sGetter;
					return oControl[sPropertyGetter]();
				}
			},

			setPropertyBinding: function (oControl, sPropertyName, oPropertyBinding) {
				var mSettings = {};
				mSettings[sPropertyName] = oPropertyBinding;
				oControl.applySettings(mSettings);
			},

			createControl: function (sClassName, oAppComponent, oView, oSelector) {
				if (this.bySelector(oSelector, oAppComponent)) {
					throw new Error("Can't create a control with duplicated id " + oSelector);
				}

				jQuery.sap.require(sClassName); //ensure class is there
				var ClassObject = jQuery.sap.getObject(sClassName);
				var sId = this.getControlIdBySelector(oSelector, oAppComponent);
				return new ClassObject(sId);
			},

			/** SUBSTITUTION UNTIL SmartForm has adopted to the bySelector
			 *
			 * @param sId
			 * @returns {*|Node}
			 */
			byId: function (sId) {
				return this._byId(sId);
			},

			/**
			 * Returns the control for the given id. Undefined if control cannot be found.
			 *
			 * @param {string} sId control id
			 * @returns {sap.ui.core.Control} Control
			 * @private
			 */
			_byId: function (sId) {
				return sap.ui.getCore().byId(sId);
			},

			getId: function (oControl) {
				return oControl.getId();
			},

			getParent: function (oControl) {
				return oControl.getParent();
			},

			getControlType: function (oControl) {
				return Utils.getControlType(oControl);
			},

			/**
			 * Adds an additional item of the aggregation or changes it in case it is not a multiple one
			 *
			 * @param {sap.ui.core.Control}
			 *          oParent - the control for which the changes should be fetched
			 * @param {string}
			 *          sName - aggregation name
			 */
			getAggregation: function (oParent, sName) {
				if (oParent) {
					if (oParent.getMetadata) {
						var oMetadata = oParent.getMetadata();
						var oAggregations = oMetadata.getAllAggregations();
						if (oAggregations) {
							var oAggregation = oAggregations[sName];
							if (oAggregation) {
								return oParent[oAggregation._sGetter]();
							}
						}
					}
				}
			},

			/**
			 * Adds an additional item of the aggregation or changes it in case it is not a multiple one
			 *
			 * @param {sap.ui.core.Control}
			 *          oParent - the control for which the changes should be fetched
			 * @param {string}
			 *          sName - aggregation name
			 * @param {object}
			 *          oObject - aggregated object to be set
			 * @param {int}
			 *          iIndex <optional> - index to which it should be added/inserted
			 */
			insertAggregation: function (oParent, sName, oObject, iIndex) {
				if (oParent) {
					if (oParent.getMetadata) {
						var oMetadata = oParent.getMetadata();
						var oAggregations = oMetadata.getAllAggregations();
						if (oAggregations) {
							var oAggregation = oAggregations[sName];
							if (oAggregation) {
								if (oAggregation.multiple) {
									var iInsertIndex = iIndex || 0;
									oParent[oAggregation._sInsertMutator](oObject, iInsertIndex);
								} else {
									oParent[oAggregation._sMutator](oObject);
								}
							}
						}
					}
				}
			},

			/**
			 * Removes the object from the aggregation of the given control
			 *
			 * @param {sap.ui.core.Control}
			 *          oParent - the control for which the changes should be fetched
			 * @param {string}
			 *          sName - aggregation name
			 * @param {object}
			 *          oObject - aggregated object to be set
			 */
			removeAggregation: function (oControl, sName, oObject) {
				if (oControl) {
					if (oControl.getMetadata) {
						var oMetadata = oControl.getMetadata();
						var oAggregations = oMetadata.getAllAggregations();
						if (oAggregations) {
							var oAggregation = oAggregations[sName];
							if (oAggregation) {
								oControl[oAggregation._sRemoveMutator](oObject);
							}
						}
					}
				}
			},

			removeAllAggregation: function (oControl, sName) {
				if (oControl) {
					if (oControl.getMetadata) {
						var oMetadata = oControl.getMetadata();
						var oAggregations = oMetadata.getAllAggregations();
						if (oAggregations) {
							var oAggregation = oAggregations[sName];
							if (oAggregation) {
								oControl[oAggregation._sRemoveAllMutator]();
							}
						}
					}
				}
			}
		};

		return jQuery.sap.extend(
			true /* deep extend */,
			{} /* target object, to avoid changing of original modifier */,
			BaseTreeModifier,
			JsControlTreeModifier
		);
	},
	/* bExport= */true);

}; // end of sap/ui/fl/changeHandler/JsControlTreeModifier.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.MoveControls') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.changeHandler.MoveControls'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/changeHandler/MoveControls",[
	"jquery.sap.global", "./Base", "sap/ui/fl/Utils"
    ], function(jQuery, Base, FlexUtils) {
		"use strict";

		/**
		 * Change handler for moving of an element.
		 *
		 * @alias sap.ui.fl.changeHandler.MoveControls
		 * @author SAP SE
		 * @version 1.48.6
		 * @experimental Since 1.46
		 */
		var MoveControls = { };

		MoveControls.CHANGE_TYPE = "moveControls";

		// Defines object which contains constants used in the handler
		MoveControls.SOURCE_ALIAS = "source";
		MoveControls.TARGET_ALIAS = "target";
		MoveControls.MOVED_ELEMENTS_ALIAS = "movedElements";

		MoveControls._checkConditions = function (oChange, oModifier, oView, oAppComponent) {
			if (!oChange) {
				throw new Error("No change instance");
			}

			var oChangeContent = oChange.getContent();

			if (!oChangeContent || !oChangeContent.movedElements || oChangeContent.movedElements.length === 0) {
				throw new Error("Change format invalid");
			}
			if (!oChangeContent.source || !oChangeContent.source.selector) {
				throw new Error("No source supplied for move");
			}
			if (!oChangeContent.target || !oChangeContent.target.selector) {
				throw new Error("No target supplied for move");
			}
			if (!oModifier.bySelector(oChangeContent.source.selector, oAppComponent, oView)) {
				throw new Error("Move source parent not found");
			}
			if (!oModifier.bySelector(oChangeContent.target.selector, oAppComponent, oView)) {
				throw new Error("Move target parent not found");
			}
			if (!oChangeContent.source.selector.aggregation) {
				throw new Error("No source aggregation supplied for move");
			}
			if (!oChangeContent.target.selector.aggregation) {
				throw new Error("No target aggregation supplied for move");
			}
		};

		MoveControls._getElementControlOrThrowError = function(mMovedElement, oModifier, oAppComponent, oView) {
			if (!mMovedElement.selector && !mMovedElement.id) {
				throw new Error("Change format invalid - moveElements element has no id attribute");
			}
			if (typeof mMovedElement.targetIndex !== "number") {
				throw new Error("Missing targetIndex for element with id '" + mMovedElement.selector.id
						+ "' in movedElements supplied");
			}

			return oModifier.bySelector(mMovedElement.selector || mMovedElement.id, oAppComponent, oView);
		};

		MoveControls._checkCompleteChangeContentConditions = function(mSpecificChangeInfo) {
			if (!mSpecificChangeInfo.movedElements) {
				throw new Error("mSpecificChangeInfo.movedElements attribute required");
			}
			if (mSpecificChangeInfo.movedElements.length === 0) {
				throw new Error("MovedElements array is empty");
			}

			mSpecificChangeInfo.movedElements.forEach(function (mElement) {
				if (!mElement.id) {
					throw new Error("MovedControls element has no id attribute");
				}
				if (typeof (mElement.sourceIndex) !== "number") {
					throw new Error("SourceIndex attribute at MovedElements element is no number");
				}
				if (typeof (mElement.targetIndex) !== "number") {
					throw new Error("TargetIndex attribute at MovedElements element is no number");
				}
			});
		};

		MoveControls._getSpecificChangeInfo = function(oModifier, mSpecificChangeInfo, oAppComponent) {

			delete mSpecificChangeInfo.source.publicAggregation;
			delete mSpecificChangeInfo.target.publicAggregation;

			var oSourceParent = mSpecificChangeInfo.source.parent || oModifier.bySelector(mSpecificChangeInfo.source.id, oAppComponent);
			var oTargetParent = mSpecificChangeInfo.target.parent || oModifier.bySelector(mSpecificChangeInfo.target.id, oAppComponent);
			var sSourceAggregation = mSpecificChangeInfo.source.aggregation;
			var sTargetAggregation = mSpecificChangeInfo.target.aggregation;



			var mAdditionalSourceInfo = {
					aggregation: mSpecificChangeInfo.source.aggregation,
					type: oModifier.getControlType(oSourceParent)
				};

			var mAdditionalTargetInfo = {
				aggregation: mSpecificChangeInfo.target.aggregation,
				type: oModifier.getControlType(oTargetParent)
			};

			var mSpecificInfo = {
				source : {
					id : oSourceParent.getId(),
					aggregation : sSourceAggregation,
					type : mAdditionalSourceInfo.type,
					selector : oModifier.getSelector(mSpecificChangeInfo.source.id, oAppComponent, mAdditionalSourceInfo)
				},
				target : {
					id : oTargetParent.getId(),
					aggregation : sTargetAggregation,
					type : mAdditionalTargetInfo.type,
					selector : oModifier.getSelector(mSpecificChangeInfo.target.id, oAppComponent, mAdditionalTargetInfo)
				},
				movedElements : mSpecificChangeInfo.movedElements
			};

			return mSpecificInfo;
		};

		/**
		 * Moves an element from one aggregation to another.
		 *
		 * @param {sap.ui.fl.Change} oChange change object with instructions to be applied on the control map
		 * @param {sap.ui.core.Control} oRelevantContainer control that matches the change selector for applying the change, which is the source of the move
		 * @param {object} mPropertyBag - map of properties
		 * @param {object} mPropertyBag.view - xml node representing a ui5 view
		 * @param {sap.ui.fl.changeHandler.BaseTreeModifier} mPropertyBag.modifier - modifier for the controls
		 * @param {sap.ui.core.UIComponent} mPropertyBag.appComponent - appComopnent
		 * @return {boolean} true - if change could be applied
		 * @public
		 * @function
		 * @name sap.ui.fl.changeHandler.MoveControls#applyChange
		 */
		MoveControls.applyChange = function(oChange, oRelevantContainer, mPropertyBag) {
			var oModifier = mPropertyBag.modifier;
			var oView = mPropertyBag.view;
			var oAppComponent = mPropertyBag.appComponent;

			this._checkConditions(oChange, oModifier, oView, oAppComponent);

			var oChangeContent = oChange.getContent();
			var oSourceParent = oModifier.bySelector(oChangeContent.source.selector, oAppComponent, oView);
			var oTargetParent = oModifier.bySelector(oChangeContent.target.selector, oAppComponent, oView);
			var sSourceAggregation = oChangeContent.source.selector.aggregation;
			var sTargetAggregation = oChangeContent.target.selector.aggregation;

			oChangeContent.movedElements.forEach(function(mMovedElement) {
				var oMovedElement = this._getElementControlOrThrowError(mMovedElement, oModifier, oAppComponent, oView);

				if (!oMovedElement) {
					FlexUtils.log.warning("Element to move not found");
					return;
				}

				oModifier.removeAggregation(oSourceParent, sSourceAggregation, oMovedElement, oView);
				oModifier.insertAggregation(oTargetParent, sTargetAggregation, oMovedElement, mMovedElement.targetIndex);
			}, this);

			return true;
		};

		/**
		 * Completes the change by adding change handler specific content.
		 *
		 * @param {sap.ui.fl.Change} oChange change object to be completed
		 * @param {object} mSpecificChangeInfo as an empty object since no additional attributes are required for this operation
		 * @param {object} mPropertyBag - map of properties
		 * @param {sap.ui.core.UiComponent} mPropertyBag.appComponent component in which the change should be applied
		 * @public
		 * @function
		 * @name sap.ui.fl.changeHandler.MoveControls#completeChangeContent
		 */
		MoveControls.completeChangeContent = function(oChange, mSpecificChangeInfo, mPropertyBag) {
			this._checkCompleteChangeContentConditions(mSpecificChangeInfo);

			var oModifier = mPropertyBag.modifier;
			var oAppComponent = mPropertyBag.appComponent;
			var mChangeData = oChange.getDefinition();

			mSpecificChangeInfo = this._getSpecificChangeInfo(oModifier, mSpecificChangeInfo, oAppComponent);

			mChangeData.changeType = MoveControls.CHANGE_TYPE;
			mChangeData.content = {
				movedElements : [],
				source : {
					selector : mSpecificChangeInfo.source.selector
				},
				target : {
					selector : mSpecificChangeInfo.target.selector
				}
			};

			mSpecificChangeInfo.movedElements.forEach(function(mElement) {
				var oElement = mElement.element || oModifier.bySelector(mElement.id, oAppComponent);

				mChangeData.content.movedElements.push({
					selector: oModifier.getSelector(oElement, oAppComponent),
					sourceIndex : mElement.sourceIndex,
					targetIndex : mElement.targetIndex
				});
			});

			oChange.addDependentControl(mSpecificChangeInfo.source.id, MoveControls.SOURCE_ALIAS, mPropertyBag);
			oChange.addDependentControl(mSpecificChangeInfo.target.id, MoveControls.TARGET_ALIAS, mPropertyBag);
			oChange.addDependentControl(mSpecificChangeInfo.movedElements.map(function (element) {
				return element.id;
			}), MoveControls.MOVED_ELEMENTS_ALIAS, mPropertyBag);
		};

		return MoveControls;
	},
/* bExport= */true);

}; // end of sap/ui/fl/changeHandler/MoveControls.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.MoveElements') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.changeHandler.MoveElements'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/changeHandler/MoveElements",[
	"jquery.sap.global", "./Base", "sap/ui/fl/Utils", "sap/ui/fl/changeHandler/JsControlTreeModifier"
    ], function(jQuery, Base, FlexUtils, JsControlTreeModifier) {
		"use strict";

		/**
		 * Change handler for moving of an elements.
		 *
		 * @alias sap.ui.fl.changeHandler.MoveElements
		 * @author SAP SE
		 * @version 1.48.6
		 * @experimental Since 1.34.0
		 */
		var MoveElements = { };

		MoveElements.CHANGE_TYPE = "moveElements";

		/**
		 * Moves an element from one aggregation to another.
		 *
		 * @param {sap.ui.fl.Change} oChange change object with instructions to be applied on the control map
		 * @param {sap.ui.core.Control} oSourceParent control that matches the change selector for applying the change, which is the source of the move
		 * @param {object} mPropertyBag - map of properties
		 * @param {object} mPropertyBag.view - xml node representing a ui5 view
		 * @param {sap.ui.fl.changeHandler.BaseTreeModifier} mPropertyBag.modifier - modifier for the controls
		 * @param {sap.ui.core.UIComponent} mPropertyBag.appComponent - appComopnent
		 * @return {boolean} true - if change could be applied
		 * @public
		 * @function
		 * @name sap.ui.fl.changeHandler.MoveElements#applyChange
		 */
		MoveElements.applyChange = function(oChange, oSourceParent, mPropertyBag) {
			function checkConditions(oChange, oModifier, oView, oAppComponent) {
				if (!oChange) {
					throw new Error("No change instance");
				}

				var oChangeContent = oChange.getContent();

				if (!oChangeContent || !oChangeContent.movedElements || oChangeContent.movedElements.length === 0) {
					throw new Error("Change format invalid");
				}
				if (!oChange.getSelector().aggregation) {
					throw new Error("No source aggregation supplied via selector for move");
				}
				if (!oChangeContent.target || !oChangeContent.target.selector) {
					throw new Error("No target supplied for move");
				}
				if (!oModifier.bySelector(oChangeContent.target.selector, oAppComponent, oView)) {
					throw new Error("Move target parent not found");
				}
				if (!oChangeContent.target.selector.aggregation) {
					throw new Error("No target aggregation supplied for move");
				}
			}

			function getElementControlOrThrowError(mMovedElement, oModifier, oAppComponent, oView) {
				if (!mMovedElement.selector && !mMovedElement.id) {
					throw new Error("Change format invalid - moveElements element has no id attribute");
				}
				if (typeof mMovedElement.targetIndex !== "number") {
					throw new Error("Missing targetIndex for element with id '" + mMovedElement.selector.id
							+ "' in movedElements supplied");
				}

				return oModifier.bySelector(mMovedElement.selector || mMovedElement.id, oAppComponent, oView);
			}

			var oModifier = mPropertyBag.modifier;
			var oView = mPropertyBag.view;
			var oAppComponent = mPropertyBag.appComponent;

			checkConditions(oChange, oModifier, oView, oAppComponent);

			var oChangeContent = oChange.getContent();
			var oTargetParent = oModifier.bySelector(oChangeContent.target.selector, oAppComponent, oView);
			var sSourceAggregation = oChange.getSelector().aggregation;
			var sTargetAggregation = oChangeContent.target.selector.aggregation;

			oChangeContent.movedElements.forEach(function(mMovedElement) {
				var oMovedElement = getElementControlOrThrowError(mMovedElement, oModifier, oAppComponent, oView);

				if (!oMovedElement) {
					FlexUtils.log.warning("Element to move not found");
					return;
				}

				oModifier.removeAggregation(oSourceParent, sSourceAggregation, oMovedElement, oView);
				oModifier.insertAggregation(oTargetParent, sTargetAggregation, oMovedElement, mMovedElement.targetIndex);
			});

			return true;
		};

		/**
		 * @deprecated
		 */
		MoveElements.completeChangeContent = function() {
			throw new Error('Using deprecated change handler. Please consider of using \'MoveControls\' instead');
		};

		/**
		 * Enrich the incoming change info with the change info from the setter, to get the complete data in one format
		 *
		 * @param {object} oModifier modifier object
		 * @param {object} mSpecificChangeInfo as an empty object since no additional attributes are required for this operation
		 * @returns {object} MoveElements elements to move
		 * @function
		 * @name sap.ui.fl.changeHandler.MoveElements#getSpecificChangeInfo
		 */
		MoveElements.getSpecificChangeInfo = function(oModifier, mSpecificChangeInfo) {

			var oSourceParent = mSpecificChangeInfo.source.parent || oModifier.bySelector(mSpecificChangeInfo.source.id);
			var oTargetParent = mSpecificChangeInfo.target.parent || oModifier.bySelector(mSpecificChangeInfo.target.id);
			var sSourceAggregation = mSpecificChangeInfo.source.aggregation;
			var sTargetAggregation = mSpecificChangeInfo.target.aggregation;

			var mSpecificInfo = {
				source : {
					id : oSourceParent.getId(),
					aggregation : sSourceAggregation,
					type : oModifier.getControlType(oSourceParent)
				},
				target : {
					id : oTargetParent.getId(),
					aggregation : sTargetAggregation,
					type : oModifier.getControlType(oTargetParent)
				},
				movedElements : mSpecificChangeInfo.movedElements
			};

			return mSpecificInfo;
		};

		return MoveElements;
	},
/* bExport= */true);

}; // end of sap/ui/fl/changeHandler/MoveElements.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.PropertyBindingChange') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.changeHandler.PropertyBindingChange'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/changeHandler/PropertyBindingChange",["jquery.sap.global", "sap/ui/fl/changeHandler/Base", "sap/ui/fl/Utils"], function(jQuery, Base, FlexUtils) {
	"use strict";

	/**
	 * Change handler for setting properties bindings on controls
	 *
	 * @alias sap.ui.fl.changeHandler.PropertyBindingChange
	 * @author SAP SE
	 * @version 1.48.6
	 * @since 1.38
	 * @private
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var PropertyBindingChange = { };

	/**
	 * @param {object} oChange - change object with instructions to be applied on the control
	 * @param {object} oControl - the control which has been determined by the selector id
	 * @param {object} mPropertyBag
	 * @param {object} mPropertyBag.modifier - modifier for the controls
	 * @public
	 * @name sap.ui.fl.changeHandler.PropertyBindingChange#applyChange
	 */
	PropertyBindingChange.applyChange = function(oChange, oControl, mPropertyBag) {
		var oDef = oChange.getDefinition();
		var sPropertyName = oDef.content.property;
		var oPropertyBinding = oDef.content.newBinding;
		mPropertyBag.modifier.setPropertyBinding(oControl, sPropertyName, oPropertyBinding);
	};

	/**
	 * Completes the change by adding change handler specific content
	 *
	 * @param {object} oChange change object to be completed
	 * @param {object} oSpecificChangeInfo with attribute property which contains an array which holds objects which have attributes
	 * 				   id and index - id is the id of the field to property and index the new position of the field in the smart form group
	 * @public
	 * @name sap.ui.fl.changeHandler.PropertyBindingChange#completeChangeContent
	 */
	PropertyBindingChange.completeChangeContent = function(oChange, oSpecificChangeInfo) {

		var oChangeJson = oChange.getDefinition();

		if (oSpecificChangeInfo.content) {

			oChangeJson.content = oSpecificChangeInfo.content;

		} else {

			throw new Error("oSpecificChangeInfo attribute required");

		}

	};

	return PropertyBindingChange;
}, /* bExport= */true);

}; // end of sap/ui/fl/changeHandler/PropertyBindingChange.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.PropertyChange') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global sap */

jQuery.sap.declare('sap.ui.fl.changeHandler.PropertyChange'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/changeHandler/PropertyChange",["jquery.sap.global", "sap/ui/fl/changeHandler/Base", "sap/ui/fl/Utils"], function(jQuery, Base, FlexUtils) {
	"use strict";

	/**
	 * Change handler for setting properties on controls
	 *
	 * @alias sap.ui.fl.changeHandler.PropertyChange
	 * @author SAP SE
	 * @version 1.48.6
	 * @since 1.36
	 * @private
	 * @experimental Since 1.36. This class is experimental and provides only limited functionality. Also the API might be changed in future.
	 */
	var PropertyChange = { };

	/**
	 * Changes the properties on the given control
	 *
	 * @param {object} oChange - change object with instructions to be applied on the control
	 * @param {object} oControl - the control which has been determined by the selector id
	 * @param {object} mPropertyBag
	 * @param {object} mPropertyBag.modifier - modifier for the controls
	 * @public
	 * @name sap.ui.fl.changeHandler.PropertyChange#applyChange
	 */
	PropertyChange.applyChange = function(oChange, oControl, mPropertyBag) {

		try {
			var oDef = oChange.getDefinition();
			var sPropertyName = oDef.content.property;
			var oPropertyValue = oDef.content.newValue;
			if (FlexUtils.isBinding(oPropertyValue)) {
				mPropertyBag.modifier.setPropertyBinding(oControl, sPropertyName, oPropertyValue);
			} else {
				mPropertyBag.modifier.setProperty(oControl, sPropertyName, oPropertyValue);
			}
		} catch (ex) {
			throw new Error("Applying property changes failed: " +  ex);
		}

	};

	/**
	 * Completes the change by adding change handler specific content
	 *
	 * @param {object} oChange change object to be completed
	 * @param {object} oSpecificChangeInfo with attribute property which contains an array which holds objects which have attributes
	 * 				   id and index - id is the id of the field to property and index the new position of the field in the smart form group
	 * @public
	 * @name sap.ui.fl.changeHandler.PropertyChange#completeChangeContent
	 */
	PropertyChange.completeChangeContent = function(oChange, oSpecificChangeInfo) {

		var oChangeJson = oChange.getDefinition();

		if (oSpecificChangeInfo.content) {

			oChangeJson.content = oSpecificChangeInfo.content;

		} else {

			throw new Error("oSpecificChangeInfo attribute required");

		}

	};

	return PropertyChange;
}, /* bExport= */true);

}; // end of sap/ui/fl/changeHandler/PropertyChange.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.StashControl') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.changeHandler.StashControl'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/changeHandler/StashControl",[
	'jquery.sap.global', './Base'
], function(jQuery, Base) {
	"use strict";

	/**
	 * Change handler for stashing of a control.
	 * @alias sap.ui.fl.changeHandler.StashControl
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 */
	var StashControl = { };

	/**
	 * Stashes and hides a control.
	 *
	 * @param {sap.ui.fl.Change} oChange change object with instructions to be applied on the control map
	 * @param {sap.ui.core.Control} oControl control that matches the change selector for applying the change
	 * @param {object} mPropertyBag.modifier - modifier for the controls
	 * @param {object} mPropertyBag	- map of properties
	 * @returns {boolean} true - if change could be applied
	 * @public
	 */
	StashControl.applyChange = function(oChange, oControl, mPropertyBag) {
		mPropertyBag.modifier.setVisible(oControl, false);
		mPropertyBag.modifier.setStashed(oControl, true);
		return true;
	};

	/**
	 * Completes the change by adding change handler specific content
	 *
	 * @param {sap.ui.fl.Change} oChange change object to be completed
	 * @param {object} oSpecificChangeInfo as an empty object since no additional attributes are required for this operation
	 * @public
	 */
	StashControl.completeChangeContent = function(oChange, oSpecificChangeInfo) {

	};

	return StashControl;
},
/* bExport= */true);

}; // end of sap/ui/fl/changeHandler/StashControl.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.UnhideControl') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.changeHandler.UnhideControl'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/changeHandler/UnhideControl",[
	'jquery.sap.global', './Base'
], function(jQuery, Base) {
	"use strict";

	/**
	 * Change handler for unhiding of a control.
	 * @alias sap.ui.fl.changeHandler.UnhideControl
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 */
	var UnhideControl = { };

	/**
	 * Unhides a control.
	 *
	 * @param {sap.ui.fl.Change} oChange change object with instructions to be applied on the control map
	 * @param {sap.ui.core.Control} oControl control that matches the change selector for applying the change
	 * @param {object} mPropertyBag
	 * @param {object} mPropertyBag.modifier - modifier for the controls
	 * @public
	 */
	UnhideControl.applyChange = function(oChange, oControl, mPropertyBag) {
		mPropertyBag.modifier.setVisible(oControl, true);
		return true;
	};

	/**
	 * Completes the change by adding change handler specific content
	 *
	 * @param {sap.ui.fl.Change} oChange change object to be completed
	 * @param {object} oSpecificChangeInfo as an empty object since no additional attributes are required for this operation
	 * @public
	 */
	UnhideControl.completeChangeContent = function(oChange, oSpecificChangeInfo) {

		var oChangeJson = oChange.getDefinition();

		if (!oChangeJson.content) {
			oChangeJson.content = {};
		}

	};

	return UnhideControl;
},
/* bExport= */true);

}; // end of sap/ui/fl/changeHandler/UnhideControl.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.UnstashControl') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.changeHandler.UnstashControl'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/changeHandler/UnstashControl",[
	'jquery.sap.global', './Base'
], function(jQuery, Base) {
	"use strict";

	/**
	 * Change handler for unstashing of a control.
	 * @alias sap.ui.fl.changeHandler.UnstashControl
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 */
	var UnstashControl = { };

	/**
	 * Unstashes and shows a control.
	 *
	 * @param {sap.ui.fl.Change} oChange change object with instructions to be applied on the control map
	 * @param {sap.ui.core.Control} oControl control that matches the change selector for applying the change
	 * @param {object} mPropertyBag
	 * @param {object} mPropertyBag.modifier - modifier for the controls
	 * @public
	 */
	UnstashControl.applyChange = function(oChange, oControl, mPropertyBag) {
		var mContent = oChange.getContent();
		var oModifier = mPropertyBag.modifier;

		oModifier.setStashed(oControl, false);

		if (mContent.parentAggregationName){
			//old way including move, new way will have seperate move change
			var sTargetAggregation = mContent.parentAggregationName;
			var oTargetParent = oModifier.getParent(oControl);
			oModifier.removeAggregation(oTargetParent, sTargetAggregation, oControl);
			oModifier.insertAggregation(oTargetParent, sTargetAggregation, oControl, mContent.index);
		}
		return true;
	};

	/**
	 * Completes the change by adding change handler specific content
	 *
	 * @param {sap.ui.fl.Change} oChange change object to be completed
	 * @param {object} oSpecificChangeInfo as an empty object since no additional attributes are required for this operation
	 * @public
	 */
	UnstashControl.completeChangeContent = function(oChange, oSpecificChangeInfo) {

		var oChangeJson = oChange.getDefinition();

		if (oSpecificChangeInfo.content) {
			//old way including move, new way will have seperate move change
			oChangeJson.content = oSpecificChangeInfo.content;
		}

	};

	return UnstashControl;
},
/* bExport= */true);

}; // end of sap/ui/fl/changeHandler/UnstashControl.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.changeHandler.XmlTreeModifier') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.changeHandler.XmlTreeModifier'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/changeHandler/XmlTreeModifier",["sap/ui/fl/changeHandler/BaseTreeModifier"], function (BaseTreeModifier) {

		"use strict";

		var XmlTreeModifier = {

			targets: "xmlTree",

			setVisible: function (oControl, oPropertyValue) {
				this.setProperty(oControl, "visible", oPropertyValue);
			},

			getVisible: function (oControl) {
				return this.getProperty(oControl, "visible");
			},

			setStashed: function (oControl, oPropertyValue) {
				this.setProperty(oControl, "stashed", oPropertyValue);
			},

			bindProperty: function (oControl, sPropertyName, sBindingPath) {
				oControl.setAttribute(sPropertyName, "{" + sBindingPath + "}");
			},

			setProperty: function (oControl, sPropertyName, oPropertyValue) {
				oControl.setAttribute(sPropertyName, oPropertyValue);
			},

			getProperty: function (oControl, sPropertyName) {
				return oControl.getAttribute(sPropertyName);
			},

			setPropertyBinding: function (oControl, sPropertyName, oPropertyBinding) {
				oControl.setAttribute(sPropertyName, oPropertyBinding);
			},

			createControl: function (sClassName, oAppComponent, oView, oSelector) {
				if (!this.bySelector(oSelector, oAppComponent, oView)) {
					var oNewElementNode = oView.createElement(sClassName);
					var sId = this.getControlIdBySelector(oSelector, oAppComponent);
					if (sId) {
						oNewElementNode.setAttribute("id", sId);
					}
					return oNewElementNode;
				} else {
					throw new Error("Can't create a control with duplicated id " + sId);
				}
			},

			/** SUBSTITUTION UNTIL SmartForm has adopted to the bySelector
			 *
			 * @param sId
			 * @param oView
			 * @returns {*|Node}
			 */
			byId: function (sId, oView) {
				return this._byId(sId, oView);
			},

			/**
			 * Returns the control for the given id. Undefined if control cannot be found.
			 *
			 * @param {string} sId control id
			 * @param {Node} oView node of the view
			 * @returns {Node} xml node of the Control
			 * @private
			 */
			_byId: function (sId, oView) {

				// If function defined and operational use getElementById(sId) of document or view to access control
				// ... Note: oView.ownerDocument.getElementById(sId) may fail under IE 11.420 indicating "permission denied"
				if (oView) {
					if (oView.ownerDocument && oView.ownerDocument.getElementById && oView.ownerDocument.getElementById(sId)) {
						// oView.ownerDocument.getElementById(sId) fails under IE 11.420 indicating "permission denied"
						return oView.ownerDocument.getElementById(sId);
					} else if (oView.getElementById && oView.getElementById(sId)) {
						return oView.getElementById(sId);
					}
				}

				// Use jQuery.find function to access control if getElementById(..) failed
				var oNodes = jQuery(oView).find("#" + sId);
				if (oNodes.length === 1) {
					return oNodes[0];
				}
			},

			getId: function (oControl) {
				return oControl.getAttribute("id");
			},

			getParent: function (oControl) {
				var oParent = oControl.parentNode;
				if (!this.getId(oParent)) {
					//go to the real control, jump over aggregation node
					oParent = oParent.parentNode;
				}

				return oParent;
			},

			_getLocalName: function (xmlNode) {
				// localName for standard browsers, baseName for IE, nodeName in the absence of namespaces
				return xmlNode.localName || xmlNode.baseName || xmlNode.nodeName;
			},

			getControlType: function (oControl) {
				var sControlType = oControl.namespaceURI;
				sControlType = (sControlType ? sControlType + "." : ""); // add a dot if there is already a prefix
				sControlType += this._getLocalName(oControl);

				return sControlType;
			},

			getAggregation: function (oParent, sName) {
				var oAggregationNode = this._findAggregationNode(oParent, sName);
				//convert NodeList to Array
				return Array.prototype.slice.call(this._children(oAggregationNode));
			},

			insertAggregation: function (oParent, sName, oObject, iIndex, oView, bNewParent, oAppComponent) {
				var oAggregationNode = this._findAggregationNode(oParent, sName, oView, bNewParent, oAppComponent);

				if (iIndex >= oAggregationNode.childElementCount) {
					oAggregationNode.appendChild(oObject);
				} else {
					var oReferenceNode = this._children(oAggregationNode)[iIndex];
					oAggregationNode.insertBefore(oObject, oReferenceNode);
				}
			},

			/**
			 * Removes the object from the aggregation of the given control
			 *
			 * @param {Node}
			 *          oParent - the control for which the changes should be fetched
			 * @param {string}
			 *          sName - aggregation name
			 * @param {Node}
			 *          oObject - aggregated object to be set
			 */
			removeAggregation: function (oParent, sName, oObject, oView) {
				var oAggregationNode = this._findAggregationNode(oParent, sName, oView);
				oAggregationNode.removeChild(oObject);
			},

			removeAllAggregation: function (oControl, sName, oView) {
				var oAggregationNode = this._findAggregationNode(oControl, sName, oView);
				if (oControl === oAggregationNode) {
					var oChildren = this._children(oControl);
					for (var i = 0; i < oChildren.length; i++) {
						oControl.removeChild(oChildren[i]);
					}
				} else {
					oControl.removeChild(oAggregationNode);
				}
			},

			_findAggregationNode: function (oParent, sName, oView, bNewParent, oAppComponent) {
				var oAggregationNode;
				if (bNewParent) {
					oAggregationNode = this.createControl(sName, oAppComponent, oView);
					oParent.appendChild(oAggregationNode);
				} else {
					var aChildren = this._children(oParent);
					for (var i = 0; i < aChildren.length; i++) {
						var oNode = aChildren[i];
						if (oNode.localName === sName) {
							oAggregationNode = oNode;
							break;
						}
					}
					if (!oAggregationNode) {
						// expecting default aggregation
						oAggregationNode = oParent;
					}
				}
				return oAggregationNode;
			},

			_children: function (oParent) {
				if (oParent.children) {
					return oParent.children;
				} else {
					var aChildren = [];
					for (var i = 0; i < oParent.childNodes.length; i++) {
						var oNode = oParent.childNodes[i];
						if (oNode.nodeType === oNode.ELEMENT_NODE) {
							aChildren.push(oNode);
						}
					}
					return aChildren;
				}
			}
		};

		return jQuery.sap.extend(
			true /* deep extend */,
			{} /* target object, to avoid changing of original modifier */,
			BaseTreeModifier,
			XmlTreeModifier
		);
	},
	/* bExport= */true);

}; // end of sap/ui/fl/changeHandler/XmlTreeModifier.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.context.BaseContextProvider') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.context.BaseContextProvider'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/context/BaseContextProvider",['sap/ui/base/ManagedObject'], function(ManagedObject) {
	"use strict";

	/**
	 * Abstract context provider.
	 *
	 * Do not create an instance of this. Instead extend this abstract class with a custom implementation and instantiate
	 * that.
	 *
	 * @class
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.48.6
	 *
	 * @constructor
	 * @private
	 * @abstract
	 * @since 1.38
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var BaseContextProvider = ManagedObject.extend("sap.ui.fl.context.BaseContextProvider", {
		metadata : {
			properties : {
				text : {
					type : "String"
				},
				description : {
					type : "String"
				}
			}
		}
	});

	/**
	* Template method for context provider that just fetch a JSON object,
	* so that getValue can have the filtering implemented once.
	* @protected
	* @returns Promise which resolves with JSON object containing all context data
	*/
	BaseContextProvider.prototype.loadData = function() {
		return Promise.resolve({});
	};

	BaseContextProvider.prototype.getValue = function(sRequest) {
		return this.loadData().then(function(mData){
			var aRequestParts = sRequest && sRequest.split(".") || [];
			var mResult = aRequestParts.reduce(function(mContextPart, sCurrent){
				if (mContextPart && mContextPart.hasOwnProperty(sCurrent)){
					return mContextPart[sCurrent];
				}
				return undefined;
			}, mData);
			return mResult;
		});
	};

	BaseContextProvider.prototype.getValueHelp = function(sRequest) {
		return Promise.resolve({});
	};

	BaseContextProvider.prototype.validate = function(sKey, vValue) {
		return Promise.resolve(true);
	};

	return BaseContextProvider;

}, /* bExport= */true);

}; // end of sap/ui/fl/context/BaseContextProvider.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.context.Context') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.context.Context'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/context/Context",['sap/ui/base/ManagedObject'], function(ManagedObject) {
	"use strict";

	/**
	 * Implementation of the Context API
	 *
	 * @class
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.48.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var Context = ManagedObject.extend("sap.ui.fl.context.Context", {
		metadata : {
			library : "sap.ui.fl",
			properties : {
				configuration : {
					type : "object"
				},
				content : {
					type : "object"
				}
			},
			aggregations : {
				contextProviders : {
					type : "object",
					multiple : true
				}
			},
			events : {}
		}
	});

	Context.prototype.getValue = function(aRequest) {
		return this._getProviderContent(aRequest, "getValue");
	};

	Context.prototype.getValueHelp = function(aRequest) {
		return this._getProviderContent(aRequest, "getValueHelp");
	};

	var fnRemoveDomainFromRequest = function(sDomain, sRequest)  {
		if (sDomain.indexOf(sRequest) !== -1){
			//partial or full request for a domain, return all values of the domain
			return undefined;
		}
		if (sRequest.indexOf(sDomain + ".") !== -1){
			//sub request for a domain, return all values of the domain
			return sRequest.substring(sDomain.length + 1);
		}
		throw new Error("Invalid request for sap.ui.fl.context - domain:" + sDomain + "request:" + sRequest);
	};

	Context.prototype._getProviderContent = function(aRequest, sPropertyName) {

		var that = this;
		var aPromises = [];
		var aRequestByDomain = [];

		var fnHandleOneDomain = function(sRequest) {
			var sAssuredDomain = that._assureDomain(sRequest);
			if (sAssuredDomain) {
				var oPromise = that._loadProvider(sAssuredDomain);
				aPromises.push(oPromise);

				aRequestByDomain.push({
					domain : sAssuredDomain,
					request : fnRemoveDomainFromRequest(sAssuredDomain, sRequest)
				});
			} else {
				//unkown domain
				aRequestByDomain.push({
					domain : undefined,
					request : sRequest
				});
			}
		};

		var fnMassUpdateConfiguration = function(aDomainProviderPairs) {
			var mConfiguration = that.getConfiguration();
			var bConfigurationChanged = false;
			for (var i = 0; i < aDomainProviderPairs.length; i++) {
				var oPair = aDomainProviderPairs[i];
				if (oPair) {
					mConfiguration[oPair.domain] = oPair.provider;
					bConfigurationChanged = true;
				}
			}
			if (bConfigurationChanged) {
				that.setConfiguration(mConfiguration);
			}
		};


		if (aRequest instanceof Array) {
			aRequest.forEach(function(sRequest){
				fnHandleOneDomain(sRequest);
			});
		} else if (aRequest === undefined) {
			for ( var sDomain in this.getConfiguration()) {
				aPromises.push(this._loadProvider(sDomain));
			}
			aRequestByDomain = Object.keys(this.getConfiguration()).map(function(sDomain){
				return {
					domain : sDomain,
					request : undefined
				};
			});
		}

		return Promise.all(aPromises).then(fnMassUpdateConfiguration).then(function() {
			return that._mergeProviderContent(aRequestByDomain, sPropertyName, aRequest);
		});
	};

	Context.prototype._assureDomain = function(oDomain) {
		var mConfiguration = this.getConfiguration();
		if (mConfiguration.hasOwnProperty(oDomain)) {
			return oDomain;
		} else {
			var aKeys = Object.keys(mConfiguration);
			for (var i = 0; i < aKeys.length; i++) {
				var sKey = aKeys[i];
				if (oDomain.indexOf(sKey) === 0 || sKey.indexOf(oDomain) === 0) {
					return sKey;
				}
			}
		}
		return null;
	};

	Context.prototype._loadProvider = function(sDomain, mConfiguration) {
		var sActConfigPath = this.getConfiguration()[sDomain];
		if (typeof (sActConfigPath) === "string") {

			return new Promise(function(resolve, reject) {
				try {
					sap.ui.require([sActConfigPath], function(ProviderConstructor){
						var oProvider = new ProviderConstructor();
						resolve({
							"domain" : sDomain,
							"provider" : oProvider
						});
					});
				} catch (oError) {
					jQuery.sap.log.error(oError);
					resolve(); // recover from error, but deliver no information
					return;
				}
			});
		} else {
			return Promise.resolve();
		}
	};

	Context.prototype._mergeProviderContent = function(aRequestByDomain, sPropertyName, aRequest) {

		var aPromises = [];

		var mConfiguration = this.getConfiguration();
		aRequestByDomain.forEach(function(oRequest){
			if (mConfiguration.hasOwnProperty(oRequest.domain)) {
				var oActProvider = mConfiguration[oRequest.domain];
				if (oActProvider instanceof sap.ui.fl.context.BaseContextProvider) {
					aPromises.push(oActProvider[sPropertyName].call(oActProvider, oRequest.request).then(function(mValue){
						var mSingleResult = {};
						var sResultKey = oRequest.domain;
						if (oRequest.request){
							sResultKey = sResultKey + "." + oRequest.request;
						}
						mSingleResult[sResultKey] = mValue;
						return mSingleResult;
					}));
				}
			} else {
				var mSingleResult = {};
				mSingleResult[oRequest.request] = undefined;
				aPromises.push(Promise.resolve(mSingleResult));
			}
		});

		return Promise.all(aPromises).then(function(aResults) {
			return aResults.reduce(function(mResults, mCurrent) {
				//jQuery.extend will not merge undefined properties => do it on our own
				var sKey = Object.keys(mCurrent)[0];
				mResults[sKey] = mCurrent[sKey];
				return mResults;
			}, {});
		});

	};

	return Context;

}, /* bExport= */true);

}; // end of sap/ui/fl/context/Context.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.context.DeviceContextProvider') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.context.DeviceContextProvider'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.Device'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/context/DeviceContextProvider",["sap/ui/fl/context/BaseContextProvider", "sap/ui/Device"], function(BaseContextProvider, Device) {
	"use strict";

	/**
	 * Device context provider.
	 *
	 *
	 * @class
	 * @extends sap.ui.fl.context.BaseContextProvider
	 *
	 * @author SAP SE
	 * @version 1.48.6
	 *
	 * @constructor
	 * @private
	 * @since 1.38
	 * @experimental Since 1.38. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var DeviceContextProvider = BaseContextProvider.extend("sap.ui.fl.context.DeviceContextProvider", {
		metadata : {
			properties : {
				text : {
					type : "String",
					defaultValue : "Device"
				},
				description : {
					type : "String",
					defaultValue : "Returns the values of sap.ui.Device"
				}
			}
		}
	});

	DeviceContextProvider.prototype.loadData = function() {
		return Promise.resolve(Device);
	};

	DeviceContextProvider.prototype.getValueHelp = function() {
		return Promise.resolve({});
	};

	DeviceContextProvider.prototype.validate = function(sKey, vValue) {
		return Promise.resolve(true);
	};

	return DeviceContextProvider;

}, /* bExport= */true);

}; // end of sap/ui/fl/context/DeviceContextProvider.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.core.FlexVisualizer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.core.FlexVisualizer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/core/FlexVisualizer",[
	"jquery.sap.global"
], function(jQuery) {
	"use strict";

	/**
	 *
	 * @constructor
	 * @alias sap.ui.fl.core.FlexVisualizer
	 *
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 *
	 */
	var FlexVisualizer = function() {

	};

	/**
	 * Show a dialog providing detailed options to do a change
	 * @param {Object} oAffectedRegistryItems Relevant registry items required by the dialog to display itself correctly
	 * @param {Boolean} bIsKeyUser Is the current user in key user mode
	 *
	 * @public
	 */
	FlexVisualizer.showDialog = function(oAffectedRegistryItems, bIsKeyUser) {

	};

	/**
	 * Close an open dialog explicitly
	 *
	 * @public
	 */
	FlexVisualizer.closeDialog = function() {

	};

	return FlexVisualizer;

}, true);

}; // end of sap/ui/fl/core/FlexVisualizer.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.descriptorRelated.internal.Utils') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.descriptorRelated.internal.Utils'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/descriptorRelated/internal/Utils",function() {
	"use strict";

	//Descriptor Variant
	var Utils = function() {};

	Utils.prototype.getNameAndNameSpace = function(sId,sReference) {
		//namespace and file name according to namespace concept: apps/<Descriptor ID>/changes/<Descriptor Variant ID>/manifest.appdescr_variant
		return {
			"fileName": "manifest", //appdescr_variant" is the file type
			"namespace": "apps/" + sReference + "/changes/" + sId + "/"
		};
	};

	Utils.prototype.checkEntityPropertyChange = function(mParameters) {
		this.checkParameterAndType(mParameters, "entityPropertyChange", "object");
		this.checkParameterAndType(mParameters.entityPropertyChange, "propertyPath", "string");
		this.checkParameterAndType(mParameters.entityPropertyChange, "operation", "string");

		if (jQuery.inArray(mParameters.entityPropertyChange.operation, ['INSERT', 'UPDATE', 'UPSERT', 'DELETE']) < 0) {
			throw new Error("Parameter \"entityPropertyChange.operation\" needs to be one of 'INSERT', 'UPDATE', 'UPSERT', 'DELETE'");
		}
		if (mParameters.entityPropertyChange.propertyValue === undefined && mParameters.entityPropertyChange.operation !== 'DELETE') {
			throw new Error("No parameter \"entityPropertyChange.propertyValue\" provided");
		}
	};

	Utils.prototype.checkParameterAndType = function(mParameters, sParameterName, sType) {
		if (sType === "array") {
			if (mParameters === undefined || mParameters[sParameterName] === undefined || !Array.isArray(mParameters[sParameterName])) {
				throw new Error("No parameter \"" + sParameterName + "\" of type " + sType + " provided");
			}
		} else {
			if (mParameters === undefined || mParameters[sParameterName] === undefined || typeof mParameters[sParameterName] !== sType) {
				throw new Error("No parameter \"" + sParameterName + "\" of type " + sType + " provided");
			}
		}
	};

	Utils.prototype.checkTexts = function(mTexts) {
		if (mTexts !== undefined && typeof mTexts !== "object") { //further checks could be added
			throw new Error("Wrong format for provided \"texts\" parameter");
		}
	};
	Utils.prototype.checkTransportRequest = function(sTransportRequest) {
		//corresponding data element in ABAP: TRKORR, CHAR20
		//partial check: length le 20, alphanumeric, upper case, no space not underscore
		if (!/^[A-Z0-9]{1,20}$/.test(sTransportRequest)) {
			throw new Error("Wrong format for provided \"sTransportRequest\" parameter");
		}
	};
	Utils.prototype.checkPackage = function(sPackage) {
		//corresponding data element in ABAP: DEVCLASS, CHAR30
		//partial check: length le 30, alphanumeric, upper case, / for namespace, underscore, no space
		if (!/^[A-Z0-9/_]{1,30}$/.test(sPackage)) {
			throw new Error("Wrong format for provided \"sPackage\" parameter");
		}
	};
	return new Utils( );
}, /* bExport= */true);

}; // end of sap/ui/fl/descriptorRelated/internal/Utils.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.fieldExt.Access') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.fieldExt.Access'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.storage'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/fieldExt/Access",["jquery.sap.storage"], function(Storage) {
	"use strict";

	/**
	 * @namespace
	 * @alias sap.ui.fl.fieldExt.Access
	 * @experimental Since 1.25.0
	 * @author SAP SE
	 * @version 1.48.6
	 */
	var Access = {};

	/**
	 * Local storage key
	 */
	Access._sStorageKey = "sap.ui.fl.fieldExt.Access";

	/**
	 * Services return to a valid state if they are longer invalid than iValidityPeriod.
	 * This prevents storing more and more unused data.
	 */
	Access._iValidityPeriod = 1 * 7 * 24 * 60 * 60 * 1000;	// 1 Week in ms

	/**
	 * Returns all Business Contexts for given service and EntityTypeName/EntitySetName. Note that either EntityTypeName or EntitySetName can be
	 * supplied. Providing both results in an exception
	 *
	 * @param {string} sServiceUri
	 * @param {string} sEntityTypeName
	 * @param {string} sEntitySetName
	 * @returns {array} aBusinessContexts
	 * @public
	 */
	Access.getBusinessContexts = function(sServiceUri, sEntityTypeName, sEntitySetName) {
		// Determine ServiceName and ServiceVersion from Service URI
		var oService = this._parseServiceUri(sServiceUri);

		// Build URL for BusinessContextRetrievalService based on ServiceName, ServiceVersion, EntityName
		var sBusinessContextRetrievalUri = this._buildBusinessContextRetrievalUri(oService.serviceName, oService.serviceVersion, sEntityTypeName, sEntitySetName);

		// Execute Ajax call
		var mAjaxSettings = this._getAjaxSettings();
		var promise = this._executeAjaxCall(sBusinessContextRetrievalUri, mAjaxSettings, oService.serviceName, oService.serviceVersion, sEntityTypeName, sEntitySetName);

		return promise;
	};

	/**
	 * Checks if a given service is stale
	 *
	 * A serviceInfo object is a string or an object which contains serviceName and serviceVersion.
	 *
	 * serviceInfo: {
	 * 		"serviceName": 		"<string>",
	 * 		"serviceVersion": 	"<string>"
	 * }
	 *
	 * @param  {string|map} [mServiceInfo] service info object or service uri
	 * @return {boolean} 	returns true if the service is stale
	 */
	Access.isServiceOutdated = function(mServiceInfo) {
		if (!this._isSystemInfoAvailable()) {
			return false;	// No system information available => All services are valid.
		}

		var mServiceItem = this._getServiceItem(this._createServiceItem(mServiceInfo));

		if (mServiceItem) {
			if (this._isServiceExpired(mServiceItem)) {
				this.setServiceValid(mServiceInfo);
				return false;
			} else {
				return true;
			}
		} else {
			return false;
		}
	};

	/**
	* Validates a given service. A valid service is not stale.
	*
	* A serviceInfo object is a string or an object which contains serviceName and serviceVersion.
	*
	* serviceInfo: {
	* 		"serviceName": 		"<string>",
	* 		"serviceVersion": 	"<string>"
	* }
	*
	* @param  {string|map} [serviceInfo] service info object or service uri
	* @return {void}
	*/
	Access.setServiceValid = function(mServiceInfo) {
		if (this._isSystemInfoAvailable()) {
			var mData = this._getDataFromLocalStorage();
			delete mData[this._createServiceItem(mServiceInfo).serviceKey];
			this._setDataToLocalStorage(mData);
		}
	};

	/**
	* Invalidates a given service.
	* Once a service has been validated oder invalidation period is over the service becomes valid again
	*
	* A serviceInfo object is a string or an object which contains serviceName and serviceVersion.
	*
	* serviceInfo: {
	* 		"serviceName": 		"<string>",
	* 		"serviceVersion": 	"<string>"
	* }
	*
	* @param  {string|map} [serviceInfo] service info object or service uri
	* @return {void}
	*/
	Access.setServiceInvalid = function(mServiceInfo) {
		if (this._isSystemInfoAvailable()) {
			var mData = this._getDataFromLocalStorage();
			var mItem = this._createServiceItem(mServiceInfo);
			mData[mItem.serviceKey] = mItem;
			this._setDataToLocalStorage(mData);
		}
	};

	/**
	 * Extracts ServiceName and ServiceVersion out of Service URI
	 *
	 * @private
	 * @param {string} 		sServiceUri			URI to an OData service document
	 * @returns {object} 						An object with serviceName and serviceVersion
	 */
	Access._parseServiceUri = function(sServiceUri) {
		/**
		 * 1.) Case
		 * If and only if a service URI contains "sap/opa/odata" and the subsequent segment (namespace) is not "sap"
		 * than the result is defined as "/<namespace>/<ServiceName>". The segment MUST not contain a slash.
		 * Both "sap/opa/odata" and the namespace are considered case insensitive because ABAP does not respect
		 * case sensitivity.
		 * 2.) Case
		 * If the namespace is "sap" the result is defined as "<ServiceName>".
		 *
		 * 3.) Case
		 * If a service URI does not contain "sap/opa/odata" the result is defined as the last segement of the resource
		 * path without a leading slash.
		 *
		 * Note: A service URI may contain a service version. Service versions have to specified as matrix parameter "v"
		 * of the resource segment which represents the service name. e.g. sap/opu/odata/MyService;v=0002. Only
		 * numerical characters are allowed. Default version is '0001'.
		 */

		// 1. Capture group => Namespace 	2.) Capture group => Service Name
		var oRegexService = /.*sap\/opu\/odata\/([^\/]+)\/([^\/]+)/i;
		var oRegexServiceVersion = /([^;]+);v=(\d{1,4})/i;

		var sODataPath = "sap/opu/odata";
		var sServiceNameWithVersion;

		// First extract namespace and service
		if (sServiceUri.toLowerCase().indexOf(sODataPath) !== -1) {
			// 1. and 2. Case
			var aServiceSegments = sServiceUri.match(oRegexService);
			if (!aServiceSegments || aServiceSegments.length !== 3) {
				throw new Error("sap.ui.fl.fieldExt.Access._parseService", "Malformed service URI (Invalid service name)");
			}
			if (aServiceSegments[1].toLowerCase() !== "sap" ) { 		// 1.) Case
				sServiceNameWithVersion = "/" + aServiceSegments[1] + "/" + aServiceSegments[2];
			} else {												// 2.) Case
				sServiceNameWithVersion = aServiceSegments[2];
			}
		} else {													// 3. Case
			// Remove last slash
			if (sServiceUri.length > 0 && sServiceUri.lastIndexOf("/") + 1 === sServiceUri.length) {
				sServiceUri = sServiceUri.substring(0, sServiceUri.length - 1);
			}
			sServiceNameWithVersion = sServiceUri.substring(sServiceUri.lastIndexOf("/") + 1);
		}

		// Check if a service version has been specified
		if (sServiceNameWithVersion.indexOf(";v=") !== -1) {
			var aVersionSegments = sServiceNameWithVersion.match(oRegexServiceVersion);
			if (!aVersionSegments || aVersionSegments.length !== 3) {
				throw new Error("sap.ui.fl.fieldExt.Access._parseService", "Malformed service URI (Invalid version)");
			}

			return {
				serviceName: aVersionSegments[1],
				serviceVersion: aVersionSegments[2]
			};
		} else {
			return {
				serviceName: sServiceNameWithVersion,
				serviceVersion: '0001'
			};
		}
	};

	/**
	 * Builds URI for BusinessContext Retrieval
	 *
	 * @private
	 * @param {string} sServiceUri
	 * @param {string} sServiceName
	 * @param {string} sEntityName
	 * @param {string} sEntitySetName
	 * @returns {string} sBusinessContextRetrievalUri
	 */
	Access._buildBusinessContextRetrievalUri = function(sServiceName, sServiceVersion, sEntityName, sEntitySetName) {
		if (sEntityName == null) {
			sEntityName = "";
		}
		if (sEntitySetName == null) {
			sEntitySetName = "";
		}

		if (((sEntitySetName.length === 0) && (sEntityName.length === 0)) || (!(sEntitySetName.length === 0) && !(sEntityName.length === 0))) {
			throw new Error("sap.ui.fl.fieldExt.Access._buildBusinessContextRetrievalUri()" + "Inconsistent input parameters EntityName: " + sEntityName + " EntitySet: " + sEntitySetName);
		}

		// Example call:
		// sap/opu/odata/SAP/APS_CUSTOM_FIELD_MAINTENANCE_SRV/GetBusinessContextsByEntityType?EntitySetName=''&EntityTypeName='BusinessPartner'&ServiceName='CFD_TSM_BUPA_MAINT_SRV'&ServiceVersion='0001'&$format=json
		var sBusinessContextRetrievalUri = "/sap/opu/odata/SAP/APS_CUSTOM_FIELD_MAINTENANCE_SRV/GetBusinessContextsByEntityType?" + "EntitySetName=\'" + sEntitySetName + "\'" + "&EntityTypeName=\'" + sEntityName + "\'" + "&ServiceName=\'" + sServiceName + "\'" + "&ServiceVersion=\'" + sServiceVersion + "\'" + "&$format=json";
		return sBusinessContextRetrievalUri;
	};

	/**
	 * Executes Ajax Call for BusinessContext Retrieval
	 *
	 * @private
	 * @param {string} sBusinessContextRetrievalUri
	 * @param {map} mRequestSettings
	 * @param {string} sServiceName
	 * @param {string} sServiceVersion
	 * @param {string} sEntityName
	 * @returns {Object} oPromise
	 */
	Access._executeAjaxCall = function(sBusinessContextRetrievalUri, mRequestSettings, sServiceName, sServiceVersion, sEntityType, sEntitySetName) {
		var that = this;
		var oDeferred = jQuery.Deferred();

		jQuery.ajax(sBusinessContextRetrievalUri, mRequestSettings).done(function(data, textStatus, jqXHR) {
			var aBusinessContexts = [];
			if (data) {
				aBusinessContexts = that._extractBusinessContexts(data);
			}

			var oResult = {
				BusinessContexts: aBusinessContexts,
				ServiceName: sServiceName,
				ServiceVersion: sServiceVersion
			};
			oDeferred.resolve(oResult);

		}).fail(function(jqXHR, textStatus, errorThrown) {
			var aErrorMessages = that._getMessagesFromXHR(jqXHR);
			var oError = {
				errorOccured: true,
				errorMessages: aErrorMessages,
				serviceName: sServiceName,
				serviceVersion: sServiceVersion,
				entityType: sEntityType,
				entitySet: sEntitySetName
			};
			oDeferred.reject(oError);
		});

		return oDeferred.promise();
	};

	/**
	 * @private
	 * @returns {map} mSettings
	 */
	Access._getAjaxSettings = function() {
		var mSettings = {
			type: "GET",
			async: true,
			dataType: "json"
		};
		return mSettings;
	};

	/**
	 * Extracts BusinessContext out of Request response data
	 *
	 * @private
	 * @param {object} oData
	 * @returns {array} BusinessContexts
	 */
	Access._extractBusinessContexts = function(data) {
		var aResults = null;
		var aBusinessContexts = [];
		if (data && data.d) {
			aResults = data.d.results;
		}

		if (aResults !== null && aResults.length > 0) {
			for (var i = 0; i < aResults.length; i++) {
				if (aResults[i].BusinessContext !== null) {
					aBusinessContexts.push(aResults[i].BusinessContext);
				}
			}
		}

		return aBusinessContexts;
	};

	/**
	 * Extracts error messages from request failure response
	 *
	 * @private
	 * @param {object} oXHR
	 * @returns {array} errorMessages
	 */
	Access._getMessagesFromXHR = function(oXHR) {
		var aMessages = [];
		try {
			var oErrorResponse = JSON.parse(oXHR.responseText);
			if (oErrorResponse && oErrorResponse.error && oErrorResponse.error.message && oErrorResponse.error.message.value && oErrorResponse.error.message.value !== '') {
				aMessages.push({
					severity: "error",
					text: oErrorResponse.error.message.value
				});
			} else {
				aMessages.push({
					severity: "error",
					text: oXHR.responseText
				});
			}

		} catch (e) {
			// ignore
		}
		return aMessages;
	};

	/**
	 * Returns the current timestamp in milliseconds
	 *
	 * @return {int} Current timestamp in milli seconds
	 */
	Access._getCurrentTime = function() {
		return Date.now();
	};

	/**
	 * Returns true if the given serviceItem is outdated
	 *
	 * @return {boolean} True if the serviceItem is outdated
	 */
	Access._isServiceExpired = function(mServiceItem) {
		return mServiceItem.expirationDate <= this._getCurrentTime();
	};

	/**
	 * Returns a local storage instance
	 *
	 * @return {object} SapUI local storage object
	 */
	Access._getLocalStorage = function() {
		return jQuery.sap.storage(jQuery.sap.storage.Type.local);
	};

	/**
	 * Checks if the current browser supportes a local storage
	 *
	 * @return {boolean} true if the current browser supports a local storage
	 */
	Access.isLocalStorageAvailable = function() {
		return this._getLocalStorage() && this._getLocalStorage().isSupported();
	};

	/**
	 * Returns a serviceItem from the local storage
	 *
	 * @param  {map} [mServiceItem] serviceItem
	 * @return {map} serviceItem from local storage or null if no serviceItem is available
	 */
	Access._getServiceItem = function(mServiceItem) {
		return this._getDataFromLocalStorage()[mServiceItem.serviceKey] || null;
	};

	/**
	 * Create a serviceItem from a given serviceInfo map.
	 *
	 * The serviceInfo map belongs to the public interface of this 'class'.
	 * ServiceItems are used to store outdated services in the local storage.
	 * A service item consists of a unique key per service and an expiration date.
	 *
	 * @param  {string|map} [mServiceInfo] serviceInfo Object or serviceUri
	 * @return {map} serviceItem
	 */
	Access._createServiceItem = function(mServiceInfo) {
		var iExpirationDate = this._getCurrentTime() + this._iValidityPeriod;
		var mSystemInfo = this._getSystemInfo( );
		var parsedServiceInfo = this._extractServiceInfo(mServiceInfo);

		return {
			"serviceKey":     mSystemInfo.getName() + mSystemInfo.getClient() + parsedServiceInfo.serviceName + parsedServiceInfo.serviceVersion,
			"expirationDate": iExpirationDate
		};
	};

	/**
	 * Returns a map, that contains the service name and the service version.
	 *
	 * @param  {string|map} [mServiceInfo] serviceInfo Object or serviceUri
	 * @return {map} serviceItem
	 */
	Access._extractServiceInfo = function(mServiceInfo) {
		if (typeof mServiceInfo === "string") {
			return this._parseServiceUri(mServiceInfo);
		} else {
			return mServiceInfo;
		}
	};

	/**
	 * Returns true if information about the current backend system are available
	 *
	 * @private
	 * @return {boolean} true if system info is available
	 */
	Access._isSystemInfoAvailable = function() {
		return sap && sap.ushell && sap.ushell.Container && sap.ushell.Container.getLogonSystem;
	};

	/**
	 * Returns informations about the current backend system
	 *
	 * @return {map}	System informations
	 */
	Access._getSystemInfo = function() {
		return sap.ushell.Container.getLogonSystem();
	};

	/**
	 * Writes a map of all outdated services to the local storage
	 *
	 * @param  {map}  [mData] Map of all outdated services
	 * @return {void}
	 */
	Access._setDataToLocalStorage = function(mData) {
		if (this.isLocalStorageAvailable() ) {
			this._getLocalStorage().put(Access._sStorageKey, JSON.stringify(mData));
		}
	};

	/**
	 * Reads a map of all outdated services from local storage
	 *
	 * @return {map} Map of all outdated services (possibly empty)
	 */
	Access._getDataFromLocalStorage = function() {
		// If no local storage is available, we simulate an empty one
		if (!this.isLocalStorageAvailable() ) {
			return { };
		}

		var sServiceData = this._getLocalStorage().get(Access._sStorageKey);

		if (!sServiceData) {
			// No data available => return empty map
			return { };
		} else {
			return JSON.parse(sServiceData);
		}
	};

	return Access;
}, /* bExport= */true);

}; // end of sap/ui/fl/fieldExt/Access.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.registry.ChangeRegistryItem') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.registry.ChangeRegistryItem'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/registry/ChangeRegistryItem",[
	"sap/ui/fl/Utils", "jquery.sap.global"
], function(Utils, jQuery) {
	"use strict";

	/**
	 * Object to define a change on a specific control type with it's permissions
	 * @constructor
	 * @param {Object} mParam Parameter description below
	 * @param {sap.ui.fl.registry.ChangeTypeMetadata} mParam.changeTypeMetadata Change type metadata this registry item is describing
	 * @param {String} mParam.controlType Control type this registry item is assigned to
	 * @param {Object} [mParam.permittedRoles] Permissions who is allowed to use this kind of change type on the assigned control
	 * @alias sap.ui.fl.registry.ChangeRegistryItem
	 *
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 *
	 */
	var ChangeRegistryItem = function(mParam) {
		if (!mParam.changeTypeMetadata) {
			Utils.log.error("sap.ui.fl.registry.ChangeRegistryItem: ChangeTypeMetadata required");
		}
		if (!mParam.controlType) {
			Utils.log.error("sap.ui.fl.registry.ChangeRegistryItem: ControlType required");
		}

		this._changeTypeMetadata = mParam.changeTypeMetadata;
		this._controlType = mParam.controlType;

		if (mParam.permittedRoles) {
			this._permittedRoles = mParam.permittedRoles;
		}

		if (mParam.dragTargets) {
			this._dragTargets = mParam.dragTargets;
		}
	};

	ChangeRegistryItem.prototype._changeTypeMetadata = undefined;
	ChangeRegistryItem.prototype._controlType = undefined;
	ChangeRegistryItem.prototype._permittedRoles = {};
	ChangeRegistryItem.prototype._dragTargets = [];

	/**
	 * Get the metadata for a change type
	 *
	 * @returns {sap.ui.fl.registry.ChangeTypeMetadata} Returns the change type metadata of the item
	 *
	 * @public
	 */
	ChangeRegistryItem.prototype.getChangeTypeMetadata = function() {
		return this._changeTypeMetadata;
	};

	/**
	 * Get the name of a change type
	 *
	 * @returns {String} Returns the name of the change type of the item
	 *
	 * @public
	 */
	ChangeRegistryItem.prototype.getChangeTypeName = function() {
		return this._changeTypeMetadata.getName();
	};

	/**
	 * Get the control type
	 *
	 * @returns {String} Returns the control type the item is assigned to
	 *
	 * @public
	 */
	ChangeRegistryItem.prototype.getControlType = function() {
		return this._controlType;
	};

	/**
	 * Get the roles the change type for the control is permitted to
	 *
	 * @returns {String} Returns a list of permitted roles
	 *
	 * @public
	 */
	ChangeRegistryItem.prototype.getPermittedRoles = function() {
		return this._permittedRoles;
	};

	/**
	 * Get the targets the control type can be dragged on
	 *
	 * @returns {String} Returns a list of possible drag targets
	 *
	 * @public
	 */
	ChangeRegistryItem.prototype.getDragTargets = function() {
		return this._dragTargets;
	};

	return ChangeRegistryItem;
}, true);

}; // end of sap/ui/fl/registry/ChangeRegistryItem.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.registry.ChangeTypeMetadata') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.registry.ChangeTypeMetadata'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/registry/ChangeTypeMetadata",[
	"sap/ui/fl/Utils", "jquery.sap.global"
], function(Utils, jQuery) {
	"use strict";

	/**
	 * Object to define a change type with it's handlers and visual appearance options
	 * @constructor
	 * @param {Object} mParam Parameter description below
	 * @param {String} mParam.name Semantic name to identify the change type
	 * @param {String} mParam.changeHandler Full qualified name of the function which is executed when a change for this change type is merged or applied
	 * @param {String} [mParam.labelKey] Key of the translatable label
	 * @param {String} [mParam.tooltipKey] Key of the translatable tooltip
	 * @param {String} [mParam.iconKey] Key of the icon which should be displayed
	 * @param {Object} [mParam.sortIndex] Index to sort the change type on the visualization. (0 = default, lowest priority)
	 * @alias sap.ui.fl.registry.ChangeTypeMetadata
	 *
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 *
	 */
		var ChangeTypeMetadata = function(mParam) {
			if (!mParam.name) {
				Utils.log.error("sap.ui.fl.registry.ChangeType: Name required");
			}
			if (!mParam.changeHandler) {
				Utils.log.error("sap.ui.fl.registry.ChangeType: ChangeHandler required");
			}

		this._name = mParam.name;
		this._changeHandler = mParam.changeHandler;
		this._layers = mParam.layers;

		if (mParam.labelKey) {
			this._labelKey = mParam.labelKey;
		}
		if (mParam.tooltipKey) {
			this._tooltipKey = mParam.tooltipKey;
		}
		if (mParam.iconKey) {
			this._iconKey = mParam.iconKey;
		}
		if (mParam.sortIndex) {
			this._sortIndex = mParam.sortIndex;
		}
	};

	ChangeTypeMetadata.prototype._name = "";
	ChangeTypeMetadata.prototype._changeHandler = "";
	ChangeTypeMetadata.prototype._layers = [];
	ChangeTypeMetadata.prototype._sortIndex = 0;
	ChangeTypeMetadata.prototype._labelKey = "";
	ChangeTypeMetadata.prototype._tooltipKey = "";
	ChangeTypeMetadata.prototype._iconKey = "";

	/**
	 * Get the semantical name of the change type
	 * @returns {String} Returns the semantical name of the change type
	 * @public
	 */
	ChangeTypeMetadata.prototype.getName = function() {
		return this._name;
	};

	/**
	 * Get the full qualified name of the change handler function
	 * @returns {String} Returns the full qualified name of the change handler function
	 * @public
	 */
	ChangeTypeMetadata.prototype.getChangeHandler = function() {
		return this._changeHandler;
	};

	/**
	 * Gets the list of layers and the information whether or not they are enabled
	 * @returns {Object} Returns the list of layers
	 * @public
	 */
	ChangeTypeMetadata.prototype.getLayers = function() {
		return this._layers;
	};

	/**
	 * Get the translated label text for this type of change
	 * @returns {String} Returns the translated label text for this type of change
	 * @public
	 */
	ChangeTypeMetadata.prototype.getLabel = function() {
		return this._labelKey; //TODO: Add call with translation
	};

	/**
	 * Get the translated tooltip text for this type of change
	 * @returns {String} Returns the translated tooltip text for this type of change
	 * @public
	 */
	ChangeTypeMetadata.prototype.getTooltip = function() {
		//TODO: Add call with translation
		return this._tooltipKey;
	};

	/**
	 * Get the path to the icon which should be displayed for this type of change
	 * @returns {String} Returns the path to the icon which should be displayed for this type of change
	 * @public
	 */
	ChangeTypeMetadata.prototype.getIcon = function() {
		return this._iconKey; //TODO: Add call to get icon path
	};

	/**
	 * Get the sort index of this type of change
	 * @returns {String} Returns the sort index of this type of change
	 * @public
	 */
	ChangeTypeMetadata.prototype.getSortIndex = function() {
		return this._sortIndex;
	};

	return ChangeTypeMetadata;
}, true);

}; // end of sap/ui/fl/registry/ChangeTypeMetadata.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.registry.SimpleChanges') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.registry.SimpleChanges'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/registry/SimpleChanges",[
	"jquery.sap.global", "sap/ui/fl/changeHandler/HideControl", "sap/ui/fl/changeHandler/UnhideControl", "sap/ui/fl/changeHandler/StashControl", "sap/ui/fl/changeHandler/UnstashControl", "sap/ui/fl/changeHandler/MoveElements", "sap/ui/fl/changeHandler/MoveControls", "sap/ui/fl/changeHandler/PropertyChange", "sap/ui/fl/changeHandler/PropertyBindingChange"
], function(jQuery, HideControl, UnhideControl, StashControl, UnstashControl, MoveElements, MoveControls, PropertyChange, PropertyBindingChange) {
	"use strict";

	/**
	 * Containes standard changes like <code>hideControl</code>
	 * (structure: <code> { "hideControl":{"changeType":"hideControl", "changeHandler":sap.ui.fl.changeHandler.HideControl}} </code>);
	 * change types have a default change handler implementation, so that control developers don't have to implement one.
	 * @constructor
	 * @alias sap.ui.fl.registry.SimpleChanges
	 *
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 *
	 */
	var SimpleChanges = {
		hideControl: {
			changeType: "hideControl",
			changeHandler: HideControl
		},
		unhideControl: {
			changeType: "unhideControl",
			changeHandler: UnhideControl
		},
		stashControl: {
			changeType: "stashControl",
			changeHandler: StashControl
		},
		unstashControl: {
			changeType: "unstashControl",
			changeHandler: UnstashControl
		},
		moveElements: {
			changeType: "moveElements",
			changeHandler: MoveElements
		},
		moveControls: {
			changeType: "moveControls",
			changeHandler: MoveControls
		},
		propertyChange : {
			changeType: "propertyChange",
			changeHandler: PropertyChange
		},
		propertyBindingChange : {
			changeType: "propertyBindingChange",
			changeHandler: PropertyBindingChange
		}
	};

	return SimpleChanges;

}, true);

}; // end of sap/ui/fl/registry/SimpleChanges.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.Cache') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.Cache'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/Cache",["sap/ui/fl/Utils"], function (Utils) {
	"use strict";

	/**
	 * Helper object to access a change from the back end.
	 * Access helper object for each change (and variant) fetched from the back end
	 *
	 * @namespace
	 * @alias sap.ui.fl.Cache
	 * @experimental Since 1.25.0
	 * @author SAP SE
	 * @version 1.48.6
	 */
	var Cache = function () {
	};

	Cache._isOn = true;

	Cache._entries = {};

	Cache._switches = {};

	/**
	 * Get the list of the switched-on business functions from the flex response
	 *
	 * @returns {object} map which has switched-on business functions as its keys
	 *
	 * @public
	 */
	Cache.getSwitches = function () {
		return Cache._switches;
	};

	/**
	 * Indicates if the cache is active or not (for testing)
	 *
	 * @returns {boolean} Is Cache currently active or not
	 *
	 * @public
	 */
	Cache.isActive = function () {
		return Cache._isOn;
	};

	/**
	 * Sets the active state
	 *
	 * @param {boolean} bActive - cache active or not
	 *
	 * @public
	 */
	Cache.setActive = function (bActive) {
		Cache._isOn = bActive;
	};

	/**
	 * Returns the entries stored in the cache.
	 *
	 * @return {object} _entries - a map of flexibility references and server responses for the given entry
	 *
	 * @protected
	 */
	Cache.getEntries = function () {
		return Cache._entries;
	};

	/**
	 * Clears whole entries stored in the cache.
	 *
	 * @protected
	 * @sap-restricted sap.ui.fl
	 */
	Cache.clearEntries = function () {
		Cache._entries = {};
	};

	/**
	 * Returns the entry stored in the cache and creates an entry if needed.
	 *
	 * @param {string} sComponentName - Name of the application component
	 * @param {string} sAppVersion - Current running version of application
	 * @return {object} Cache entry of specific application component and application version
	 *
	 * @protected
	 */
	Cache.getEntry = function (sComponentName, sAppVersion) {
		if (!Cache._entries[sComponentName]) {
			Cache._entries[sComponentName] = {};
		}
		if (!Cache._entries[sComponentName][sAppVersion]) {
			Cache._entries[sComponentName][sAppVersion] = {
				file: {
					changes: {
						changes: []
					}
				}
			};
		}
		return Cache._entries[sComponentName][sAppVersion];
	};

	/**
	 * Clears a single entry stored in the cache for a specific application component and application version.
	 *
	 * @param {string} sComponentName - Name of the application component
	 * @param {string} sAppVersion - Current running version of application
	 *
	 * @protected
	 * @sap-restricted sap.ui.fl
	 */
	Cache.clearEntry = function (sComponentName, sAppVersion) {
		Cache.getEntry(sComponentName, sAppVersion);
		Cache._entries[sComponentName][sAppVersion] = {};
	};

	/**
	 * This method retrieves the changes for a given
	 * component. It answers all subsequent calls with the same promise, which
	 * will resolve with the same result. In the success case, it will keep the
	 * promise to resolve all calls in future event loop execution paths with
	 * the same result. In case of an error, it will delete the initial promise
	 * to give calls from future execution paths the chance to re-request the
	 * changes from the back end.
	 *
	 * If the cache is not active, the method just delegates the call to the
	 * loadChanges method of the given LrepConnector.
	 *
	 * @param {sap.ui.fl.LrepConnector} oLrepConnector - LrepConnector instance to retrieve the changes with
	 * @param {object} oComponent - Contains component data needed for reading changes
	 * @param {string} oComponent.name - Name of the component
	 * @param {string} oComponent.appVersion - Current running version of application
	 * @param {map} [mPropertyBag] - Contains additional data needed for reading changes
	 * @param {object} [mPropertyBag.appDescriptor] - Manifest that belongs to actual component
	 * @param {string} [mPropertyBag.siteId] - <code>sideId<code> that belongs to actual component
	 * @returns {Promise} resolves with the change file for the given component, either from cache or back end
	 *
	 * @public
	 */
	Cache.getChangesFillingCache = function (oLrepConnector, oComponent, mPropertyBag) {
		if (!this.isActive()) {
			return oLrepConnector.loadChanges(oComponent, mPropertyBag);
		}
		var sComponentName = oComponent.name;
		var sAppVersion = oComponent.appVersion || Utils.DEFAULT_APP_VERSION;
		var oCacheEntry = Cache.getEntry(sComponentName, sAppVersion);

		if (oCacheEntry.promise) {
			return oCacheEntry.promise;
		}

		// in case of no changes present according to async hints
		if (mPropertyBag && mPropertyBag.cacheKey === "<NO CHANGES>") {
			return Promise.resolve({
				changes: {
					changes : [],
					contexts : []
				},
				componentClassName: sComponentName
			});
		}

		var currentLoadChanges = oLrepConnector.loadChanges(oComponent, mPropertyBag).then(function (mChanges) {
			if (oCacheEntry.file) {
				Utils.log.error('sap.ui.fl.Cache: Cached changes for component ' + sComponentName + ' overwritten.');
			}
			if (mChanges && mChanges.changes && mChanges.changes.settings && mChanges.changes.settings.switchedOnBusinessFunctions) {
				mChanges.changes.settings.switchedOnBusinessFunctions.forEach(function(sValue) {
				Cache._switches[sValue] = true;
				});
			}
			oCacheEntry.file = mChanges;
			return oCacheEntry.file;
		}, function (err) {
			delete oCacheEntry.promise;
			throw err;
		});

		oCacheEntry.promise = currentLoadChanges;

		return currentLoadChanges;
	};

	/**
	 * @private
	 * @param {object} oComponent - Contains component data needed for getting change array
	 * @param {string} oComponent.name - Name of the component
	 * @param {string} oComponent.appVersion - Current running version of application
	 * @returns {array} Array of changes
	 */
	Cache._getChangeArray = function (oComponent) {
		var sComponentName = oComponent.name;
		var sAppVersion = oComponent.appVersion || Utils.DEFAULT_APP_VERSION;
		var oEntry = Cache.getEntry(sComponentName, sAppVersion);
		return oEntry.file.changes.changes;
	};

	/**
	 * Add a change for the given component to the cached changes.
	 *
	 * @param {object} oComponent - Contains component data needed for adding change
	 * @param {string} oComponent.name - Name of the component
	 * @param {string} oComponent.appVersion - Current running version of application
	 * @param {object} oChange - The change in JSON format
	 * @public
	 */
	Cache.addChange = function (oComponent, oChange) {
		var aChanges = Cache._getChangeArray(oComponent);

		if (!aChanges) {
			return;
		}

		aChanges.push(oChange);
	};

	/**
	 * Updates a change for the given component in the cached changes.
	 *
	 * @param {object} oComponent - Contains component data needed for adding change
	 * @param {string} oComponent.name - Name of the component
	 * @param {string} oComponent.appVersion - Current running version of application
	 * @param {object} oChange - The change in JSON format
	 * @public
	 */
	Cache.updateChange = function (oComponent, oChange) {
		var aChanges = Cache._getChangeArray(oComponent);

		if (!aChanges) {
			return;
		}

		for (var i = 0; i < aChanges.length; i++) {
			if (aChanges[i].fileName === oChange.fileName) {
				aChanges.splice(i, 1, oChange);
				break;
			}
		}
	};

	/**
	 * Delete a change for the given component from the cached changes.
	 *
	 * @param {object} oComponent - Contains component data needed for adding change
	 * @param {string} oComponent.name - Name of the component
	 * @param {string} oComponent.appVersion - Current running version of application
	 * @param {object} oChangeDefinition - The change in JSON format
	 * @public
	 */
	Cache.deleteChange = function (oComponent, oChangeDefinition) {
		var aChanges = Cache._getChangeArray(oComponent);

		if (!aChanges) {
			return;
		}

		for (var i = 0; i < aChanges.length; i++) {
			if (aChanges[i].fileName === oChangeDefinition.fileName) {
				aChanges.splice(i, 1);
				break;
			}
		}
	};

	return Cache;
}, /* bExport= */true);

}; // end of sap/ui/fl/Cache.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.LrepConnector') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.LrepConnector'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.URI'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/LrepConnector",[
	"jquery.sap.global", "sap/ui/thirdparty/URI", "sap/ui/fl/Utils"
], function(jQuery, uri, FlexUtils) {
	"use strict";

	/**
	 * Provides the connectivity to the ABAP based LRep REST-service
	 *
	 * @param {object} [mParameters] - map of parameters, see below
	 * @param {String} [mParameters.XsrfToken] - XSRF token which can be reused for back-end connectivity. If no XSRF token is passed, a new one
	 *        will be fetched from back end.
	 * @constructor
	 * @alias sap.ui.fl.LrepConnector
	 * @private
	 * @sap-restricted
	 * @author SAP SE
	 * @version 1.48.6
	 */
	var Connector = function(mParameters) {
		this._initClientParam();
		this._initLanguageParam();
		if (mParameters) {
			this._sXsrfToken = mParameters.XsrfToken;
		}

	};

	Connector.createConnector = function(mParameters) {
		return new Connector(mParameters);
	};

	Connector.prototype.DEFAULT_CONTENT_TYPE = "application/json";
	Connector.prototype._sClient = undefined;
	Connector.prototype._sLanguage = undefined;
	Connector.prototype._aSentRequestListeners = [];
	Connector.prototype._sRequestUrlPrefix = "";

	/**
	 * Registers a callback for a sent request to the back end. The callback is only called once for each change. Each call is done with an object
	 * similar to the resolve of the promises containing a <code>status</code> of the response from the back end i.e. <code>success</code>, a
	 * <code>response</code> containing the change processed in this request
	 *
	 * @param {function} fCallback function called after all related promises are resolved
	 * @public
	 */
	Connector.attachSentRequest = function(fCallback) {
		if (typeof fCallback === "function" && Connector.prototype._aSentRequestListeners.indexOf(fCallback) === -1) {
			Connector.prototype._aSentRequestListeners.push(fCallback);
		}
	};

	/**
	 * Deregisters a callback for a sent request to the back end if the callback was registered
	 *
	 * @param {function} fCallback function called after all related promises are resolved
	 * @public
	 */
	Connector.detachSentRequest = function(fCallback) {
		var iIndex = Connector.prototype._aSentRequestListeners.indexOf(fCallback);
		if (iIndex !== -1) {
			Connector.prototype._aSentRequestListeners.splice(iIndex, 1);
		}
	};

	/**
	 * Extract client from current running instance
	 *
	 * @private
	 */
	Connector.prototype._initClientParam = function() {
		var client = FlexUtils.getClient();
		if (client) {
			this._sClient = client;
		}
	};

	/**
	 * Extract the sap-language URL parameter from current URL
	 *
	 * @private
	 */
	Connector.prototype._initLanguageParam = function() {
		var sLanguage;
		sLanguage = FlexUtils.getUrlParameter("sap-language") || FlexUtils.getUrlParameter("sap-ui-language");
		if (sLanguage) {
			this._sLanguage = sLanguage;
		}
	};

	/**
	 * Prefix for request URL can be set in exceptional cases when consumer needs to add a prefix to the URL
	 *
	 * @param {String} sRequestUrlPrefix - request URL prefix which must start with a (/) and must not end with a (/)
	 * @private
	 * @sap-restricted
	 */
	Connector.prototype.setRequestUrlPrefix = function(sRequestUrlPrefix) {
		this._sRequestUrlPrefix = sRequestUrlPrefix;
	};

	/**
	 * Resolves the complete URL of a request using the back-end URL and the relative URL from the request
	 *
	 * @param {String} sRelativeUrl - relative URL of the current request
	 * @returns {sap.ui.core.URI} returns the complete uri for this request
	 * @private
	 */
	Connector.prototype._resolveUrl = function(sRelativeUrl) {
		if (!jQuery.sap.startsWith(sRelativeUrl, "/")) {
			sRelativeUrl = "/" + sRelativeUrl;
		}
		sRelativeUrl = this._sRequestUrlPrefix + sRelativeUrl;
		var oUri = uri(sRelativeUrl).absoluteTo("");
		return oUri.toString();
	};

	/**
	 * Get the default header for a request
	 *
	 * @returns {Object} Returns an object containing all headers for each request
	 * @private
	 */
	Connector.prototype._getDefaultHeader = function() {
		var mHeaders = {
			headers: {
				"X-CSRF-Token": this._sXsrfToken || "fetch"
			}
		};
		return mHeaders;
	};

	/**
	 * Get the default options, required for the jQuery.ajax request
	 *
	 * @param {String} sMethod - HTTP-method (PUT, POST, GET (default)...) used for this request
	 * @param {String} sContentType - Set the content-type manually and overwrite the default (application/json)
	 * @param {Object} oData - Payload of the request
	 * @returns {Object} Returns an object containing the options and the default header for a jQuery.ajax request
	 * @private
	 */
	Connector.prototype._getDefaultOptions = function(sMethod, sContentType, oData) {
		var mOptions;
		if (!sContentType) {
			sContentType = this.DEFAULT_CONTENT_TYPE;
		}

		mOptions = jQuery.extend(true, this._getDefaultHeader(), {
			type: sMethod,
			async: true,
			contentType: sContentType,
			processData: false,
			//xhrFields: {
			//	withCredentials: true
			//},
			headers: {
				"Content-Type": sContentType
			}
		});

		if (oData && mOptions.contentType === "application/json") {
			mOptions.dataType = "json";
			if (typeof oData === "object") {
				mOptions.data = JSON.stringify(oData);
			} else {
				mOptions.data = oData;
			}
		} else if (oData) {
			mOptions.data = oData;
		}

		if (sMethod === "DELETE") {
			delete mOptions.data;
			delete mOptions.contentType;
		}

		return mOptions;
	};

	/**
	 * Send a request to the back end
	 *
	 * @param {String} sUri Relative URL for this request
	 * @param {String} sMethod HTTP-method to be used by this request (default GET)
	 * @param {Object} oData Payload of the request
	 * @param {Object} mOptions Additional options which should be used in the request
	 * @returns {Promise} Returns a promise to the result of the request
	 * @public
	 */
	Connector.prototype.send = function(sUri, sMethod, oData, mOptions) {
		sMethod = sMethod || "GET";
		sMethod = sMethod.toUpperCase();
		mOptions = mOptions || {};
		sUri = this._resolveUrl(sUri);

		if (mOptions.success || mOptions.error) {
			var sErrorMessage = "Success and error handler are not allowed in mOptions";
			throw new Error(sErrorMessage);
		}

		var sContentType = mOptions.contentType || this.DEFAULT_CONTENT_TYPE;

		mOptions = jQuery.extend(true, this._getDefaultOptions(sMethod, sContentType, oData), mOptions);

		return this._sendAjaxRequest(sUri, mOptions);
	};

	/**
	 * Extracts the messages from the back-end response
	 *
	 * @param {Object} oXHR - ajax request object
	 * @returns {Array} Array of messages, for example <code>[ { "severity": "Error", "text": "content id must be non-initial" } ] </code>
	 * @private
	 */
	Connector.prototype._getMessagesFromXHR = function(oXHR) {
		var errorResponse, aMessages, length, i;
		aMessages = [];
		try {
			errorResponse = JSON.parse(oXHR.responseText);
			if (errorResponse && errorResponse.messages && errorResponse.messages.length > 0) {
				length = errorResponse.messages.length;
				for (i = 0; i < length; i++) {
					aMessages.push({
						severity: errorResponse.messages[i].severity,
						text: errorResponse.messages[i].text
					});
				}
			}
		} catch (e) {
			// ignore
		}

		return aMessages;
	};

	/**
	 * @param {String} sUri - Complete request URL
	 * @param {Object} mOptions - Options to be used by the request
	 * @returns {Promise} Returns a Promise with the status and response and messages
	 * @private
	 */
	Connector.prototype._sendAjaxRequest = function(sUri, mOptions) {
		var that = this;
		var sFetchXsrfTokenUrl = "/sap/bc/lrep/actions/getcsrftoken/";
		var mFetchXsrfTokenOptions = {
			headers: {
				"X-CSRF-Token": "fetch"
			},
			type: "HEAD"
		};

		if (this._sClient) {
			mFetchXsrfTokenOptions.headers["sap-client"] = this._sClient;
		}

		return new Promise(function(resolve, reject) {
			function handleValidRequest(oResponse, sStatus, oXhr) {

				var sNewCsrfToken = oXhr.getResponseHeader("X-CSRF-Token");
				that._sXsrfToken = sNewCsrfToken || that._sXsrfToken;
				var sEtag = oXhr.getResponseHeader("etag");

				var oResult = {
					status: sStatus,
					etag: sEtag,
					response: oResponse
				};

				resolve(oResult);

				jQuery.each(that._aSentRequestListeners, function(iIndex, fCallback) {
					fCallback(oResult);
				});
			}

			function fetchTokenAndHandleRequest(oResponse, sStatus, oXhr) {
				that._sXsrfToken = oXhr.getResponseHeader("X-CSRF-Token");
				mOptions.headers = mOptions.headers || {};
				mOptions.headers["X-CSRF-Token"] = that._sXsrfToken;

				// Re-send request after fetching token
				jQuery.ajax(sUri, mOptions).done(handleValidRequest).fail(function(oXhr, sStatus, sErrorThrown) {
					var oError = new Error(sErrorThrown);
					oError.status = "error";
					oError.code = oXhr.statusCode().status;
					oError.messages = that._getMessagesFromXHR(oXhr);
					reject(oError);
				});
			}

			function refetchTokenAndRequestAgainOrHandleInvalidRequest(oXhr, sStatus, sErrorThrown) {
				if (oXhr.status === 403) {
					// Token seems to be invalid, refetch and then resend
					jQuery.ajax(sFetchXsrfTokenUrl, mFetchXsrfTokenOptions).done(fetchTokenAndHandleRequest).fail(function(oXhr, sStatus, sErrorThrown) {
						// Fetching XSRF Token failed
						reject({
							status: "error"
						});
					});
				} else {
					if (mOptions && mOptions.type === "DELETE" && oXhr.status === 404) {
						// Do not reject, if a file was not found during deletion
						// (can be the case if another user already triggered a restore meanwhile)
						resolve();
					} else {
						var result;
						result = {
							status: "error"
						};
						result.code = oXhr.statusCode().status;
						result.messages = that._getMessagesFromXHR(oXhr);
						reject(result);
					}
				}
			}

			//Check, whether CSRF token has to be requested
			var bRequestCSRFToken = true;
			if (mOptions && mOptions.type) {
				if (mOptions.type === "GET" || mOptions.type === "HEAD") {
					bRequestCSRFToken = false;
				}
			} else {
				if (that._sXsrfToken && that._sXsrfToken !== "fetch") {
					bRequestCSRFToken = false;
				}
			}

			if (bRequestCSRFToken) {
				// Fetch XSRF Token
				jQuery.ajax(sFetchXsrfTokenUrl, mFetchXsrfTokenOptions).done(fetchTokenAndHandleRequest).fail(function(oXhr, sStatus, sErrorThrown) {
					// Fetching XSRF Token failed
					reject({
						status: "error"
					});
				});
			} else {
				// Send normal request
				jQuery.ajax(sUri, mOptions).done(handleValidRequest).fail(refetchTokenAndRequestAgainOrHandleInvalidRequest);
			}
		});
	};

	/**
	 * Loads the changes for the given component class name.
	 *
	 * @see sap.ui.core.Component
	 * @param {object} oComponent - Contains component data needed for reading changes
	 * @param {string} oComponent.name - Name of component
	 * @param {string} [oComponent.appVersion] - Current running version of application
	 * @param {map} [mPropertyBag] - Contains additional data needed for reading changes
	 * @param {object} [mPropertyBag.appDescriptor] - Manifest that belongs to actual component
	 * @param {string} [mPropertyBag.siteId] - <code>sideId<code> that belongs to actual component
	 * @param {string} [mPropertyBag.layer] - Layer up to which changes shall be read (excluding the specified layer)
	 * @param {string} [mPropertyBag.appVersion] - Version of application whose changes shall be read
	 *
	 * @returns {Promise} Returns a Promise with the changes (changes, contexts, optional messagebundle), <code>componentClassName<code> and <code>etag<code> value
	 * @public
	 */
	Connector.prototype.loadChanges = function(oComponent, mPropertyBag) {
		var sUri;
		var mOptions = {};
		var that = this;
		var sComponentClassName = oComponent.name;

		if (!sComponentClassName) {
			return Promise.reject(new Error("Component name not specified"));
		}

		sUri = "/sap/bc/lrep/flex/data/";

		var sUpToLayer = "";

		// fill header attribute: appDescriptor.id
		if (mPropertyBag) {
			var sCacheKey = mPropertyBag.cacheKey;

			if (sCacheKey) {
				mOptions.cache = true;
				sUri += "~" + sCacheKey + "~/";
			}

			if (mPropertyBag.appDescriptor) {
				if (mPropertyBag.appDescriptor["sap.app"]) {
					if (!mOptions.headers) {
						mOptions.headers = {};
					}

					mOptions.headers = {
						"X-LRep-AppDescriptor-Id": mPropertyBag.appDescriptor["sap.app"].id
					};
				}
			}

			// fill header attribute: siteId
			if (mPropertyBag.siteId) {
				if (!mOptions.headers) {
					mOptions.headers = {};
				}

				mOptions.headers = {
					"X-LRep-Site-Id": mPropertyBag.siteId
				};
			}

			// changes shall be read up to a specified layer type
			if (mPropertyBag.layer) {
				sUpToLayer = mPropertyBag.layer;
			}
		}

		if (sComponentClassName) {
			sUri += sComponentClassName;
		}
		if (this._sClient) {
			sUri += "&sap-client=" + this._sClient;
		}
		if (sUpToLayer) {
			sUri += "&upToLayerType=" + sUpToLayer;
		}
		if (oComponent.appVersion && (oComponent.appVersion !== FlexUtils.DEFAULT_APP_VERSION)) {
			sUri += "&appVersion=" + oComponent.appVersion;
		}

		// Replace first & with ?
		sUri = sUri.replace("&", "?");

		return this.send(sUri, undefined, undefined, mOptions)
			.then(function(oResponse) {
				return {
					changes: oResponse.response,
					componentClassName: sComponentClassName,
					etag: oResponse.etag
				};
			}, function(oError) {
				if (oError.code === 404 || oError.code === 405) {
					// load changes based old route, because new route is not implemented
					return that._loadChangesBasedOnOldRoute(sComponentClassName);
				} else {
					throw (oError);
				}
			});
	};

	/**
	 * Loads flexibility settings.
	 *
	 * @returns {Promise} Returns a Promise with the flexibility settings content
	 * @public
	 */
	Connector.prototype.loadSettings = function() {
		var sUri = "/sap/bc/lrep/flex/settings";

		if (this._sClient) {
			sUri += "?sap-client=" + this._sClient;
		}

		return this.send(sUri, undefined, undefined, {})
			.then(function(oResponse) {
				return oResponse.response;
			});
	};

	Connector.prototype._loadChangesBasedOnOldRoute = function(sComponentClassName) {
		var resourceName, params;

		try {
			resourceName = jQuery.sap.getResourceName(sComponentClassName, "-changes.json");
		} catch (e) {
			return Promise.reject(e);
		}

		params = {
			async: true,
			dataType: "json",
			failOnError: true,
			headers: {
				"X-UI5-Component": sComponentClassName
			}
		};

		if (this._sClient) {
			params.headers["sap-client"] = this._sClient;
		}

		return jQuery.sap.loadResource(resourceName, params).then(function(oResponse) {
			return {
				changes: oResponse,
				componentClassName: sComponentClassName
			};
		});
	};

	/**
	 * @param {Array} aParams Array of parameter objects in format {name:<name>, value:<value>}
	 * @returns {String} Returns a String with all parameters concatenated
	 * @private
	 */
	Connector.prototype._buildParams = function(aParams) {
		if (!aParams) {
			aParams = [];
		}
		if (this._sClient) {
			// Add mandatory "sap-client" parameter
			aParams.push({
				name: "sap-client",
				value: this._sClient
			});
		}

		if (this._sLanguage) {
			// Add mandatory "sap-language" URL parameter.
			// Only use sap-language if there is an sap-language parameter in the original URL.
			// If sap-language is not added, the browser language might be used as back-end login language instead of sap-language.
			aParams.push({
				name: "sap-language",
				value: this._sLanguage
			});
		}

		var result = "";
		var len = aParams.length;
		for (var i = 0; i < len; i++) {
			if (i === 0) {
				result += "?";
			} else if (i > 0 && i < len) {
				result += "&";
			}
			result += aParams[i].name + "=" + aParams[i].value;
		}
		return result;
	};

	/**
	 * The URL prefix of the REST API for example /sap/bc/lrep/changes/.
	 *
	 * @param {Boolean} bIsVariant Flag whether the change is of type variant
	 * @returns {String} URL prefix
	 * @private
	 */
	Connector.prototype._getUrlPrefix = function(bIsVariant) {
		if (bIsVariant) {
			return "/sap/bc/lrep/variants/";
		}
		return "/sap/bc/lrep/changes/";
	};

	/**
	 * Creates a change or variant via REST call.
	 *
	 * @param {Object} oPayload The content which is send to the server
	 * @param {String} [sChangelist] The transport ID.
	 * @param {Boolean} bIsVariant - is variant?
	 * @returns {Object} Returns the result from the request
	 * @public
	 */
	Connector.prototype.create = function(oPayload, sChangelist, bIsVariant) {
		var sRequestPath = this._getUrlPrefix(bIsVariant);

		var aParams = [];
		if (sChangelist) {
			aParams.push({
				name: "changelist",
				value: sChangelist
			});
		}

		sRequestPath += this._buildParams(aParams);

		return this.send(sRequestPath, "POST", oPayload, null);
	};

	/**
	 * Update a change or variant via REST call.
	 *
	 * @param {Object} oPayload The content which is send to the server
	 * @param {String} sChangeName Name of the change
	 * @param {String} sChangelist (optional) The transport ID.
	 * @param {Boolean} bIsVariant - is variant?
	 * @returns {Object} Returns the result from the request
	 * @public
	 */
	Connector.prototype.update = function(oPayload, sChangeName, sChangelist, bIsVariant) {
		var sRequestPath = this._getUrlPrefix(bIsVariant);
		sRequestPath += sChangeName;

		var aParams = [];
		if (sChangelist) {
			aParams.push({
				name: "changelist",
				value: sChangelist
			});
		}

		sRequestPath += this._buildParams(aParams);

		return this.send(sRequestPath, "PUT", oPayload, null);
	};

	/**
	 * Delete a change or variant via REST call.
	 *
	 * @param {String} mParameters property bag
	 * @param {String} mParameters.sChangeName - name of the change
	 * @param {String} [mParameters.sLayer="USER"] - other possible layers: VENDOR,PARTNER,CUSTOMER_BASE,CUSTOMER
	 * @param {String} mParameters.sNamespace - the namespace of the change file
	 * @param {String} mParameters.sChangelist - The transport ID.
	 * @param {Boolean} bIsVariant - is it a variant?
	 * @returns {Object} Returns the result from the request
	 * @public
	 */
	Connector.prototype.deleteChange = function(mParameters, bIsVariant) {
		// REVISE rename to deleteFile
		var sRequestPath = this._getUrlPrefix(bIsVariant);
		sRequestPath += mParameters.sChangeName;

		var aParams = [];
		if (mParameters.sLayer) {
			aParams.push({
				name: "layer",
				value: mParameters.sLayer
			});
		}
		if (mParameters.sNamespace) {
			aParams.push({
				name: "namespace",
				value: mParameters.sNamespace
			});
		}
		if (mParameters.sChangelist) {
			aParams.push({
				name: "changelist",
				value: mParameters.sChangelist
			});
		}

		sRequestPath += this._buildParams(aParams);

		return this.send(sRequestPath, "DELETE", {}, null);
	};

	/**
	 * Authenticated access to a resource in the Lrep
	 *
	 * @param {String} sNamespace The abap package goes here. It is needed to identify the change. Default LREP namespace is "localchange".
	 * @param {String} sName Name of the change
	 * @param {String} sType File type extension
	 * @param {Boolean} bIsRuntime The stored file content is handed over to the lrep provider that can dynamically adjust the content to the runtime
	 *        context (e.g. do text replacement to the users' logon language) before
	 * @returns {Object} Returns the result from the request
	 * @public
	 */
	Connector.prototype.getStaticResource = function(sNamespace, sName, sType, bIsRuntime) {
		var sApiPath = "/sap/bc/lrep/content/";
		var sRequestPath = sApiPath;
		sRequestPath += sNamespace + "/" + sName + "." + sType;

		var aParams = [];
		if (!bIsRuntime) {
			aParams.push({
				name: "dt",
				value: "true"
			});
		}

		sRequestPath += this._buildParams(aParams);

		return this.send(sRequestPath, "GET", null, null);
	};

	/**
	 * Retrieves the file attributes for a given resource in the LREP.
	 *
	 * @param {String} sNamespace The abap package goes here. It is needed to identify the change. Default LREP namespace is "localchange".
	 * @param {String} sName Name of the change
	 * @param {String} sType File type extension
	 * @param {String} sLayer File layer
	 * @returns {Object} Returns the result from the request
	 * @public
	 */
	Connector.prototype.getFileAttributes = function(sNamespace, sName, sType, sLayer) {
		var sApiPath = "/sap/bc/lrep/content/";
		var sRequestPath = sApiPath;
		sRequestPath += sNamespace + "/" + sName + "." + sType;

		var aParams = [];
		aParams.push({
			name: "metadata",
			value: "true"
		});

		if (sLayer) {
			aParams.push({
				name: "layer",
				value: sLayer
			});
		}

		sRequestPath += this._buildParams(aParams);

		return this.send(sRequestPath, "GET", null, null);
	};

	/**
	 * Upserts a given change or variant via REST call.
	 *
	 * @param {String} sNamespace The abap package goes here. It is needed to identify the change.
	 * @param {String} sName Name of the change
	 * @param {String} sType File type extension
	 * @param {String} sLayer File layer
	 * @param {String} sContent File content to be saved as string
	 * @param {String} sContentType Content type (e.g. application/json, text/plain, ...), default: application/json
	 * @param {String} sChangelist The transport ID, optional
	 * @returns {Object} Returns the result from the request
	 * @public
	 */
	Connector.prototype.upsert = function(sNamespace, sName, sType, sLayer, sContent, sContentType, sChangelist) {
		var that = this;
		return Promise.resolve(that._fileAction("PUT", sNamespace, sName, sType, sLayer, sContent, sContentType, sChangelist));
	};

	/**
	 * Delete a file via REST call.
	 *
	 * @param {String} sNamespace The abap package goes here. It is needed to identify the change.
	 * @param {String} sName Name of the change
	 * @param {String} sType File type extension
	 * @param {String} sLayer File layer
	 * @param {String} sChangelist The transport ID, optional
	 * @returns {Object} Returns the result from the request
	 * @public
	 */
	Connector.prototype.deleteFile = function(sNamespace, sName, sType, sLayer, sChangelist) {
		return this._fileAction("DELETE", sNamespace, sName, sType, sLayer, null, null, sChangelist);
	};

	Connector.prototype._fileAction = function(sMethod, sNamespace, sName, sType, sLayer, sContent, sContentType, sChangelist) {
		var sApiPath = "/sap/bc/lrep/content/";
		var sRequestPath = sApiPath;
		sRequestPath += sNamespace + "/" + sName + "." + sType;

		var aParams = [];
		aParams.push({
			name: "layer",
			value: sLayer
		});

		if (sChangelist) {
			aParams.push({
				name: "changelist",
				value: sChangelist
			});
		}

		sRequestPath += this._buildParams(aParams);

		var mOptions = {
			contentType: sContentType || this.DEFAULT_CONTENT_TYPE
		};

		return this.send(sRequestPath, sMethod.toUpperCase(), sContent, mOptions);
	};

	/**
	 * @param {String} sOriginNamespace The abap package goes here. It is needed to identify the change. Default LREP namespace is "localchange".
	 * @param {String} sName Name of the change
	 * @param {String} sType File type extension
	 * @param {String} sOriginLayer File layer
	 * @param {String} sTargetLayer File where the new Target-Layer
	 * @param {String} sTargetNamespace target namespace
	 * @param {String} sChangelist The changelist where the file will be written to
	 * @returns {Object} Returns the result from the request
	 * @private Private for now, as is not in use.
	 */
	Connector.prototype.publish = function(sOriginNamespace, sName, sType, sOriginLayer, sTargetLayer, sTargetNamespace, sChangelist) {
		var sApiPath = "/sap/bc/lrep/actions/publish/";
		var sRequestPath = sApiPath;
		sRequestPath += sOriginNamespace + "/" + sName + "." + sType;

		var aParams = [];
		if (sOriginLayer) {
			aParams.push({
				name: "layer",
				value: sOriginLayer
			});
		}
		if (sTargetLayer) {
			aParams.push({
				name: "target-layer",
				value: sTargetLayer
			});
		}
		if (sTargetNamespace) {
			aParams.push({
				name: "target-namespace",
				value: sTargetNamespace
			});
		}
		if (sChangelist) {
			aParams.push({
				name: "changelist",
				value: sChangelist
			});
		}

		sRequestPath += this._buildParams(aParams);

		return this.send(sRequestPath, "POST", {}, null);
	};

	/**
	 * Retrieves the content for a given namespace and layer via REST call.
	 *
	 * @param {String} sNamespace - The file namespace goes here. It is needed to identify the change.
	 * @param {String} sLayer - File layer
	 * @returns {Object} Returns the result from the request
	 * @public
	 */
	Connector.prototype.listContent = function(sNamespace, sLayer) {
		var sRequestPath = "/sap/bc/lrep/content/";
		sRequestPath += sNamespace;

		var aParams = [];
		if (sLayer) {
			aParams.push({
				name: "layer",
				value: sLayer
			});
		}

		sRequestPath += this._buildParams(aParams);

		return this.send(sRequestPath, "GET", null, null);
	};

	return Connector;
}, true);

}; // end of sap/ui/fl/LrepConnector.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.context.ContextManager') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.context.ContextManager'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/context/ContextManager",["sap/ui/fl/LrepConnector", "sap/ui/fl/Utils", "sap/ui/fl/context/Context"], function(LrepConnector, Utils, Context) {
	"use strict";

	/**
	 * Helper object to process and filter changes by contexts
	 *
	 * @namespace
	 * @alias sap.ui.fl.context.ContextManager
	 * @since 1.38.0
	 * @author SAP SE
	 * @version 1.48.6
	 */
	var ContextManager;

	ContextManager = {

		_oContext: new Context({
			configuration : {
				"device" : "sap/ui/fl/context/DeviceContextProvider",
				"switches" : "sap/ui/fl/context/SwitchContextProvider"
			}
		}),
		_oLrepConnector: new LrepConnector(),

		/**
		 * Helper to check if a passed change is free of contexts or in a matching context.
		 *
		 * @param {sap.ui.fl.Change} oChange - change object which has to be filtered
		 * @param {sap.ui.fl.Context[]} aActiveContexts - active runtime or designtime context
		 * @returns {boolean} is change context free or has a valid context
		 */
		doesContextMatch: function (oChange, aActiveContexts) {
			var sChangeContext = oChange.context || "";

			if (!sChangeContext) {
				// change is free of context (always applied)
				return true;
			}

			return jQuery.inArray(sChangeContext, aActiveContexts) !== -1;
		},

		/**
		 * Helper to filter passed context objects.
		 * This method loops over each context object and check for its current validity
		 *
		 * @param {sap.ui.fl.Context[]} aContextObjects - context objects within the application
		 * @returns {Promise|string[]} aActiveContexts - Promise returning or direct build array containing ids of context objects
		 */
		getActiveContexts: function (aContextObjects) {
			var aDesignTimeContextIdsByUrl = this._getContextIdsFromUrl();

			if (aDesignTimeContextIdsByUrl.length === 0) {
				// [default: runtime] use runtime contexts
				return this._getContextParametersFromAPI(aContextObjects)
					.then(this._getActiveContextsByAPIParameters.bind(this, aContextObjects));
			} else {
				// [designtime] use url parameters to determine the current active context(s)
				return Promise.resolve(this._getActiveContextsByUrlParameters(aContextObjects, aDesignTimeContextIdsByUrl));
			}
		},

		/**
		 * Helper to retreive the context parameters from the instanciated context api
		 *
		 * @param {sap.ui.fl.Context[]} aContextObjects - context objects within the application
		 * @returns {Promise} aRuntimeContextParameters - Promise resolving with a map of context keys and their current values
		 */
		_getContextParametersFromAPI: function (aContextObjects) {
			var aRequiredContextParameters = [];

			aContextObjects.forEach(function (oContext) {
				oContext.parameters.forEach(function (oContextParameter) {
					var sSelector = oContextParameter.selector;
					if (aRequiredContextParameters.indexOf(sSelector) === -1) {
						aRequiredContextParameters.push(sSelector);
					}
				});
			});

			return this._oContext.getValue(aRequiredContextParameters);
		},

		/**
		 * Function to filter all contexts by the passed runtime context parameters.
		 *
		 * @param {object[]} aContextObjects - context objects within the application
		 * @param {object} aRuntimeContextParameters - map of context keys and their current values
		 * @returns {string[]} aActiveContexts - id list of all active contexts
		 */
		_getActiveContextsByAPIParameters: function (aContextObjects, aRuntimeContextParameters) {
			var that = this;
			var aActiveContexts = [];

			aContextObjects.forEach(function (oContext) {
				if (that._isContextObjectActive(oContext, aRuntimeContextParameters)) {
					aActiveContexts.push(oContext.id);
				}
			});

			return aActiveContexts;
		},

		/**
		 * Function to filter all contexts by the context URL parameters.
		 *
		 * @param {string[]} aDesignTimeContextIdsByUrl - list of ids passed via URL
		 * @param {object[]} aContextObjects - context objects within the application
		 * @returns {string[]} aActiveContexts - id list of all active contexts
		 */
		_getActiveContextsByUrlParameters: function(aContextObjects, aDesignTimeContextIdsByUrl) {
			var aActiveContexts = [];

			aContextObjects.forEach(function (oContext) {
				var bContextActive = jQuery.inArray(oContext.id, aDesignTimeContextIdsByUrl) !== -1;

				if (bContextActive) {
					aActiveContexts.push(oContext.id);
				}
			});

			return aActiveContexts;
		},

		/**
		 * Helper to filter passed context object.
		 * If a passed context is not within the context objects of the given application the context is filtered.
		 *
		 * The filtering is done
		 * [At runtime] by comparing the parameters of the context objects with the actual runtime context.
		 * [At designtime] by comparing the id of the context objects with the set url parameter "sap-ui-designTimeContexts"
		 *
		 * @param {object} oContext - context object to be validated
		 * @param {object[]} aRuntimeContextParameters - context parameter returned form the context providers
		 * @returns {boolean} bContextActive - determines if the passed context matches the context of the current environment
		 * @private
		 */
		_isContextObjectActive: function(oContext, aRuntimeContextParameters) {
			var that = this;
			var bContextActive = true;

			var aParameterOfContext = oContext.parameters;
			aParameterOfContext.every(function (oParameter) {
				bContextActive = bContextActive && that._checkContextParameter(oParameter, aRuntimeContextParameters);
				return bContextActive; // breaks loop on false
			});

			return bContextActive;
		},

		/**
		 * Helper to get the url parameter or an empty array if the url parameter is not present
		 *
		 * @returns {string[]} context object ids
		 * @private
		 */
		_getContextIdsFromUrl: function () {
			var sContextIdsUrlParameter = Utils.getUrlParameter("sap-ui-flexDesignTimeContext");

			if (!sContextIdsUrlParameter) {
				return [];
			}

			return sContextIdsUrlParameter.split(",");
		},

		/**
		 * Checks a single condition of a context object. Returns true if the condition matches the current runtime context.
		 *
		 * @param {Object} oParameter - context within an sap.ui.fl.Change
		 * @param {string} oParameter.selector - key of a runtime context
		 * @param {string} oParameter.operator - determine which comparison has to be executed
		 * @param {string} oParameter.value - value which has to be matched within the key
		 * @param {Object} aRuntimeContext - key value pairs of the current runtime context
		 * @returns {boolean} bContextValid - context of the changes matches
		 * @private
		 */
		_checkContextParameter: function (oParameter, aRuntimeContext) {
			var sSelector = oParameter.selector;
			var sOperator = oParameter.operator;
			var oValue = oParameter.value;

			switch (sOperator) {
				case "EQ":
					return this._checkEquals(sSelector, oValue, aRuntimeContext);
				case "NE":
					return !this._checkEquals(sSelector, oValue, aRuntimeContext);
				default:
					jQuery.sap.log.info("A context within a flexibility change with the operator '" + sOperator + "' could not be verified");
					return false;
			}
		},

		/**
		 * Equals-comparison for the _checkContent functionality.
		 *
		 * @param {string} sSelector - key of a runtime context
		 * @param {object} oValue - value which has to be matched within the key
		 * @param {Object} aRuntimeContext - key value pairs of the current runtime context
		 * @returns {boolean} isEquals - passed value is equals to the value within the runtime context found under the passed key
		 * @private
		 */
		_checkEquals: function (sSelector, oValue, aRuntimeContext) {
			return aRuntimeContext[sSelector] === oValue;
		},

		/**
		 *
		 * @param {string} oPropertyBag.id - contextID if not present it will be generated
		 * @param {string} oPropertyBag.reference - reference (app variant id or componentName.Component" in which the context is present
		 * @param {string} oPropertyBag.title - human readable title of the context
		 * @param {string} oPropertyBag.description - human readable description of the context
		 * @param {Object[]} oPropertyBag.parameters - Runtime context parameters required to match the active context
		 * @param {string} oPropertyBag.parameters.selector - runtime context name
		 * @param {string} oPropertyBag.parameters.operator - Comparison method
		 * @param {Object} oPropertyBag.parameters.value - Value passed to the comparison
		 * @param {Object} oPropertyBag.validAppVersions - Application versions (format: major.minor.patch) where the context is active
		 * @param {String} oPropertyBag.validAppVersions.creation - Original application version
		 * @param {String} oPropertyBag.validAppVersions.from - Minimum application version
		 * @param {String} oPropertyBag.validAppVersions.to - Maximum application version
		 */
		createOrUpdateContextObject: function (oPropertyBag) {
			if (!oPropertyBag.reference) {
				throw new Error("no reference passed for the context object");
			}

			if (!oPropertyBag.namespace) {
				throw new Error("no namespace passed for the context object");
			}

			var sId = oPropertyBag.id || Utils.createDefaultFileName();

			oPropertyBag = {
				id: sId,
				fileName: sId,
				title: oPropertyBag.title || "",
				description: oPropertyBag.description || "",
				parameters: oPropertyBag.parameters || [],
				fileType: "context",
				reference: oPropertyBag.reference || "",
				packageName: oPropertyBag.packageName || "",
				layer: oPropertyBag.layer || Utils.getCurrentLayer(false),
				namespace: oPropertyBag.namespace,
				creation: oPropertyBag.creation || "",
				originalLanguage: oPropertyBag.originalLanguage || Utils.getCurrentLanguage(),
				support: oPropertyBag.support || {
					generator: "",
					service: "",
					user: ""
				},
				validAppVersions: oPropertyBag.validAppVersions || {}
			};

			var sUri = "/sap/bc/lrep/content/" + oPropertyBag.namespace + oPropertyBag.fileName + ".context";
			sUri += "?layer=" + oPropertyBag.layer;
			var sMethod = "PUT";
			return this._oLrepConnector.send(sUri, sMethod, oPropertyBag, {});
		}
	};

	return ContextManager;
}, true);

}; // end of sap/ui/fl/context/ContextManager.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.context.SwitchContextProvider') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.context.SwitchContextProvider'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/context/SwitchContextProvider",["sap/ui/fl/context/BaseContextProvider", "sap/ui/fl/Cache"], function(BaseContextProvider, Cache) {
	"use strict";

	/**
	 * Switch context provider.
	 *
	 *
	 * @class
	 * @extends sap.ui.fl.context.BaseContextProvider
	 *
	 * @author SAP SE
	 * @version 1.48.6
	 *
	 * @constructor
	 * @private
	 * @since 1.43
	 * @experimental Since 1.43. This class is experimental and provides only limited functionality. Also the API might be
	 *               changed in future.
	 */
	var SwitchContextProvider = BaseContextProvider.extend("sap.ui.fl.context.SwitchContextProvider", {
		metadata : {
			properties : {
				text : {
					type : "String",
					defaultValue : "Switch"
				},
				description : {
					type : "String",
					defaultValue : "Returns the values of switches recieved in the flexibility response from the back end"
				}
			}
		}
	});

	SwitchContextProvider.prototype.loadData = function() {
		return Promise.resolve(Cache.getSwitches());
	};

	SwitchContextProvider.prototype.getValueHelp = function() {
		return Promise.resolve({});
	};

	SwitchContextProvider.prototype.validate = function(sKey, vValue) {
		return Promise.resolve(true);
	};

	return SwitchContextProvider;

}, /* bExport= */true);

}; // end of sap/ui/fl/context/SwitchContextProvider.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.descriptorRelated.api.DescriptorInlineChangeFactory') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.descriptorRelated.api.DescriptorInlineChangeFactory'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory",["sap/ui/fl/descriptorRelated/internal/Utils"
], function(Utils) {
	"use strict";

	/**
	 * Descriptor Inline Change
	 *
	 * @param {string} sChangeType change type
	 * @param {object} [mParameters] parameters of the inline change for the provided change type
	 * @param {object} [mTexts] texts for the inline change
	 *
	 * @constructor
	 * @alias sap.ui.fl.descriptorRelated.api.DescriptorInlineChange
	 * @author SAP SE
	 * @version 1.48.6
	 * @private
	 * @sap-restricted
	 */
	var DescriptorInlineChange = function(sChangeType,mParameters,mTexts) {
		//parameter correspond to inline change format
		//exception: appdescr_app_setTitle, and similar


		Utils.checkTexts(mTexts);
		this._mParameters = {};
		this._mParameters.changeType = sChangeType;
		this._mParameters.content = mParameters;
		this._mParameters.texts = mTexts;
	};

	DescriptorInlineChange.prototype._getChangeType = function() {
		return this._mParameters.changeType;
	};

	DescriptorInlineChange.prototype.getMap = function() {
		return this._mParameters;
	};


	/**
	 * Factory for Descriptor Inline Changes
	 *
	 * @namespace
	 * @alias sap.ui.fl.descriptorRelated.api.DescriptorInlineChangeFactory
	 * @author SAP SE
	 * @version 1.48.6
	 * @private
	 * @sap-restricted
	 */

	var DescriptorInlineChangeFactory = {};

	DescriptorInlineChangeFactory.getDescriptorChangeTypes = function(){
		return ["appdescr_ovp_addNewCard","appdescr_ovp_removeCard",
		        "appdescr_app_addNewInbound", "appdescr_app_changeInbound", "appdescr_app_removeInbound",
		        "appdescr_app_addNewOutbound", "appdescr_app_changeOutbound", "appdescr_app_removeOutbound",
		        "appdescr_app_addNewDataSource", "appdescr_app_changeDataSource", "appdescr_app_removeDataSource",
		        "appdescr_app_addAnnotationsToOData", "appdescr_app_addTechnicalAttributes", "appdescr_app_removeTechnicalAttributes",
		        "appdescr_app_setTitle", "appdescr_app_setSubTitle", "appdescr_app_setShortTitle", "appdescr_app_setDescription",
		        "appdescr_app_setDestination", "appdescr_app_setKeywords", "appdescr_ui5_addNewModel", "appdescr_ui5_replaceComponentUsage",
		        "appdescr_smb_addNamespace", "appdescr_smb_changeNamespace", "appdescr_ui_generic_app_setMainPage", "appdescr_ui_setIcon"];
	};

	DescriptorInlineChangeFactory.createNew = function(sChangeType,mParameters,mTexts) {
		var oDescriptorInlineChange = new DescriptorInlineChange(sChangeType,mParameters,mTexts);

		return new Promise(function(resolve, reject) {
			//no check in backend at that point, check only after submitting in service provider

			if (oDescriptorInlineChange) {
				resolve(oDescriptorInlineChange);
			} else {
				var oError = {}; //TODO
				reject(oError);
			}

		});
	};


//private static methods
	DescriptorInlineChangeFactory._createDescriptorInlineChange = function( sDescriptorChangeType,mParameters,mTexts ){
		var oDescriptorInlineChange = new DescriptorInlineChange(sDescriptorChangeType,mParameters,mTexts);

		//no check in backend at that point, check only after submitting in service provider
		return new Promise(function(resolve, reject) {
			if (oDescriptorInlineChange) {
				resolve(oDescriptorInlineChange);
			} else {
				var oError = {};
				reject(oError);
			}
		});
	};


//public static factory methods
	/**
	 * Creates an inline change
	 *
	 * @param {string} sDescriptorChangeType the change type
	 * @param {object} mParameters parameters of the changed type
	 * @param {object} [mTexts] texts for the inline change
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.createDescriptorInlineChange = function( sDescriptorChangeType,mParameters,mTexts ){
		return this._createDescriptorInlineChange( sDescriptorChangeType,mParameters,mTexts );
	};

	/**
	 * Creates an inline change of change type appdescr_ovp_addNewCard
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {object} mParameters.card the card to be created according to descriptor schema
	 * @param {object} [mParameters.model] the ui5 model to be created according to descriptor schema
	 * @param {object} [mParameters.dataSource] the data sources to be created according to descriptor schema (either not provided or of type OData or of type OData and ODataAnnotation
	 * @param {object} [mTexts] texts for the inline change
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_ovp_addNewCard = function(mParameters,mTexts) {
		Utils.checkParameterAndType(mParameters, "card", "object");
		return this._createDescriptorInlineChange('appdescr_ovp_addNewCard', mParameters,mTexts);
	};

	/**
	 * Creates an inline change of change type appdescr_ovp_removeCard
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {string} mParameters.cardId the id of the card to be removed
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_ovp_removeCard = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "cardId", "string");
		return this._createDescriptorInlineChange('appdescr_ovp_removeCard', mParameters);

	};

	/**
	 * Creates an inline change of change type appdescr_app_addNewInbound
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {object} mParameters.inbound the inbound to be created according to descriptor schema
	 * @param {object} [mTexts] texts for the inline change
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_addNewInbound = function(mParameters,mTexts) {
		Utils.checkParameterAndType(mParameters, "inbound", "object");
		return this._createDescriptorInlineChange('appdescr_app_addNewInbound', mParameters, mTexts);

	};

	/**
	 * Creates an inline change of change type appdescr_app_removeInbound
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {string} mParameters.inboundId the id of the inbound to be removed
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_removeInbound = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "inboundId", "string");
		return this._createDescriptorInlineChange('appdescr_app_removeInbound', mParameters);

	};

	/**
	 * Creates an inline change of change type appdescr_app_changeInbound
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {string} mParameters.inboundId the id of the inbound to be changed
	 * @param {object} mParameters.entityPropertyChange
	 * @param {object} mParameters.entityPropertyChange.propertyPath - the property path inside the inbound
	 * @param {object} mParameters.entityPropertyChange.operation - the operation (INSERT, UPDATE, UPSERT, DELETE)
	 * @param {object} mParameters.entityPropertyChange.propertyValue - the new property value
	 * @param {object} [mTexts] texts for the inline change
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_changeInbound = function(mParameters,mTexts) {
		Utils.checkParameterAndType(mParameters, "inboundId", "string");
		Utils.checkEntityPropertyChange(mParameters);
		return this._createDescriptorInlineChange('appdescr_app_changeInbound', mParameters, mTexts);

	};

	/**
	 * Creates an inline change of change type appdescr_app_addNewOutbound
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {object} mParameters.outbound the outbound to be created according to descriptor schema
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_addNewOutbound = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "outbound", "object");
		return this._createDescriptorInlineChange('appdescr_app_addNewOutbound', mParameters);

	};

	/**
	 * Creates an inline change of change type appdescr_app_removeOutbound
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {string} mParameters.outboundId the id of the outbound to be removed
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_removeOutbound = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "outboundId", "string");
		return this._createDescriptorInlineChange('appdescr_app_removeOutbound', mParameters);

	};

	/**
	 * Creates an inline change of change type appdescr_app_changeOutbound
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {string} mParameters.outboundId the id of the outbound to be changed
	 * @param {object} mParameters.entityPropertyChange
	 * @param {object} mParameters.entityPropertyChange.propertyPath - the property path inside the outbound
	 * @param {object} mParameters.entityPropertyChange.operation - the operation (INSERT, UPDATE, UPSERT, DELETE)
	 * @param {object} mParameters.entityPropertyChange.propertyValue - the new property value
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_changeOutbound = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "outboundId", "string");
		Utils.checkEntityPropertyChange(mParameters);
		return this._createDescriptorInlineChange('appdescr_app_changeOutbound', mParameters);

	};

	/**
	 * Creates an inline change of change type appdescr_app_addNewDataSource
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {object} mParameters.dataSource - the data source to be created according to descriptor schema (either one data source or one of type OData and one of type ODataAnnotation)
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_addNewDataSource = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "dataSource", "object");
		return this._createDescriptorInlineChange('appdescr_app_addNewDataSource', mParameters);

	};

	/**
	 * Creates an inline change of change type appdescr_app_removeDataSource
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {string} mParameters.dataSourceId the id of the data source to be removed
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_removeDataSource = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "dataSourceId", "string");
		return this._createDescriptorInlineChange('appdescr_app_removeDataSource', mParameters);

	};

	/**
	 * Creates an inline change of change type appdescr_app_changeDataSource
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {string} mParameters.dataSourceId the id of the data source to be changed
	 * @param {object} mParameters.entityPropertyChange
	 * @param {object} mParameters.entityPropertyChange.propertyPath - the property path inside the data source
	 * @param {object} mParameters.entityPropertyChange.operation - the operation (INSERT, UPDATE, UPSERT, DELETE)
	 * @param {object} mParameters.entityPropertyChange.propertyValue - the new property value
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_changeDataSource = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "dataSourceId", "string");
		Utils.checkEntityPropertyChange(mParameters);
		return this._createDescriptorInlineChange('appdescr_app_changeDataSource', mParameters);

	};

	/**
	 * Creates an inline change of change type appdescr_app_addAnnotationsToOData
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {string} mParameters.dataSourceId the id of the data source to be changed by adding annotations from annotations parameter
	 * @param {array} mParameters.annotations array with ids of data sources of type 'ODataAnnotation' that should be added to the data source to be changed
	 * @param {enum} [mParameters.annotationsInsertPosition] position at which the annotations should be added to the annotations of the data source to be changed (BEGINNING/END, default BEGINNING)
	 * @param {object} mParameters.dataSource one or several data sources of type 'ODataAnnotation' which should be added, all need to be contained in the annotations parameter
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_addAnnotationsToOData = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "dataSourceId", "string");
		Utils.checkParameterAndType(mParameters, "annotations", "array");
		Utils.checkParameterAndType(mParameters, "dataSource", "object");
		return this._createDescriptorInlineChange('appdescr_app_addAnnotationsToOData', mParameters);

	};


	/**
	 * Creates an inline change of change type appdescr_app_setTitle
	 *
	 * @param {object} mParameters map of text properties
	 * @param {object} mParameters.maxLength max length of title
	 * @param {object} [mParameters.type='XTIT'] type of title
	 * @param {object} [mParameters.comment] comment for additional information
	 * @param {object} [mParameters.value] map of locale and text, "" represents the default title
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_setTitle = function(mParameters) {

		var mTexts = {
					"" : mParameters //property name = text key set when adding to descriptor variant
		};

		return this._createDescriptorInlineChange('appdescr_app_setTitle', {}, mTexts).then(function(oDescriptorInlineChange){

			//TODO check how this can be done nicer, e.g. by sub classing
			return new Promise(function(resolve){
				oDescriptorInlineChange["setHostingIdForTextKey"] = function(sHostingId){
					var that = oDescriptorInlineChange;
					var sTextKey = sHostingId + "_sap.app.title";
					that._mParameters.texts[sTextKey] = that._mParameters.texts[""];
					delete that._mParameters.texts[""];
				};
				resolve(oDescriptorInlineChange);
			});
		});
	};

	/**
	 * Creates an inline change of change type appdescr_app_setSubTitle
	 *
	 * @param {object} mParameters map of text properties
	 * @param {object} mParameters.maxLength max length of sub title
	 * @param {object} [mParameters.type='XTIT'] type of sub title
	 * @param {object} [mParameters.comment] comment for additional information
	 * @param {object} [mParameters.value] map of locale and text, "" represents the default sub title
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_setSubTitle = function(mParameters) {

		var mTexts = {
					"" : mParameters //property name = text key set when adding to descriptor variant
		};

		return this._createDescriptorInlineChange('appdescr_app_setSubTitle', {}, mTexts).then(function(oDescriptorInlineChange){

			//TODO check how this can be done nicer, e.g. by sub classing
			return new Promise(function(resolve){
				oDescriptorInlineChange["setHostingIdForTextKey"] = function(sHostingId){
					var that = oDescriptorInlineChange;
					var sTextKey = sHostingId + "_sap.app.subTitle";
					that._mParameters.texts[sTextKey] = that._mParameters.texts[""];
					delete that._mParameters.texts[""];
				};
				resolve(oDescriptorInlineChange);
			});
		});
	};

	/**
	 * Creates an inline change of change type appdescr_app_setShortTitle
	 *
	 * @param {object} mParameters map of text properties
	 * @param {object} mParameters.maxLength max length of sub title
	 * @param {object} [mParameters.type='XTIT'] type of short title
	 * @param {object} [mParameters.comment] comment for additional information
	 * @param {object} [mParameters.value] map of locale and text, "" represents the default short title
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_setShortTitle = function(mParameters) {

		var mTexts = {
					"" : mParameters //property name = text key set when adding to descriptor variant
		};

		return this._createDescriptorInlineChange('appdescr_app_setShortTitle', {}, mTexts).then(function(oDescriptorInlineChange){

			//TODO check how this can be done nicer, e.g. by sub classing
			return new Promise(function(resolve){
				oDescriptorInlineChange["setHostingIdForTextKey"] = function(sHostingId){
					var that = oDescriptorInlineChange;
					var sTextKey = sHostingId + "_sap.app.shortTitle";
					that._mParameters.texts[sTextKey] = that._mParameters.texts[""];
					delete that._mParameters.texts[""];
				};
				resolve(oDescriptorInlineChange);
			});
		});
	};

	/**
	 * Creates an inline change of change type appdescr_app_description
	 *
	 * @param {object} mParameters map of text properties
	 * @param {object} mParameters.maxLength max length of description
	 * @param {object} [mParameters.type='XTIT'] type of description
	 * @param {object} [mParameters.comment] comment for additional information
	 * @param {object} [mParameters.value] map of locale and text, "" represents the default description
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_setDescription = function(mParameters) {

		var mTexts = {
					"" : mParameters //property name = text key set when adding to descriptor variant
		};

		return this._createDescriptorInlineChange('appdescr_app_setDescription', {}, mTexts).then(function(oDescriptorInlineChange){

			//TODO check how this can be done nicer, e.g. by sub classing
			return new Promise(function(resolve){
				oDescriptorInlineChange["setHostingIdForTextKey"] = function(sHostingId){
					var that = oDescriptorInlineChange;
					var sTextKey = sHostingId + "_sap.app.description";
					that._mParameters.texts[sTextKey] = that._mParameters.texts[""];
					delete that._mParameters.texts[""];
				};
				resolve(oDescriptorInlineChange);
			});
		});
	};


	/**
	 * Creates an inline change of change type appdescr_app_setDestination
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {object} mParameters.destination the destination
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_setDestination = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "destination", "object");
		return this._createDescriptorInlineChange('appdescr_app_setDestination', mParameters);
	};


	/**
	 * Creates an inline change of change type appdescr_app_setKeywords
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {array} mParameters.keywords the keywords
	 * @param {object} [mTexts] texts for the inline change
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_setKeywords = function(mParameters, mTexts) {
		Utils.checkParameterAndType(mParameters, "keywords", "array");
		return this._createDescriptorInlineChange('appdescr_app_setKeywords', mParameters, mTexts);
	};

	/**
	 * Creates an inline change of change type appdescr_app_addTechnicalAttributes
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {array} mParameters.technicalAttributes the technicalAttributes
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_addTechnicalAttributes = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "technicalAttributes", "array");
		return this._createDescriptorInlineChange('appdescr_app_addTechnicalAttributes', mParameters);
	};

	/**
	 * Creates an inline change of change type appdescr_app_removeTechnicalAttributes
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {array} mParameters.technicalAttributes the technicalAttributes
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_app_removeTechnicalAttributes = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "technicalAttributes", "array");
		return this._createDescriptorInlineChange('appdescr_app_removeTechnicalAttributes', mParameters);
	};

	/**
	 * Creates an inline change of change type appdescr_ui5_addNewModel
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {object} mParameters.model the ui5 model to be created according to descriptor schema
	 * @param {object} [mParameters.dataSource] the data sources to be created according to descriptor schema (either not provided or of arbitrary type or two provided of type OData and of type OData and ODataAnnotation)
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_ui5_addNewModel = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "model", "object");
		return this._createDescriptorInlineChange('appdescr_ui5_addNewModel', mParameters);
	};

	/**
	 * Creates an inline change of change type appdescr_ui5_replaceComponentUsage
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {object} mParameters.componentUsageId the ui5 component usage id to be created
	 * @param {object} mParameters.componentUsage the ui5 component usage data to replace the old one according to descriptor schema
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_ui5_replaceComponentUsage = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "componentUsageId", "string");
		Utils.checkParameterAndType(mParameters, "componentUsage", "object");
		return this._createDescriptorInlineChange('appdescr_ui5_replaceComponentUsage', mParameters);
	};

	/**
	 * Creates an inline change of change type appdescr_smb_addNamespace
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {object} mParameters.smartBusinessApp the smart business app to be created according to descriptor schema
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_smb_addNamespace = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "smartBusinessApp", "object");
		return this._createDescriptorInlineChange('appdescr_smb_addNamespace', mParameters);
	};

	/**
	 * Creates an inline change of change type appdescr_smb_changeNamespace
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {object} mParameters.smartBusinessApp the smart business app to be changed according to descriptor schema
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_smb_changeNamespace = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "smartBusinessApp", "object");
		return this._createDescriptorInlineChange('appdescr_smb_changeNamespace', mParameters);
	};

	/**
	 * Creates an inline change of change type appdescr_ui_generic_app_setMainPage
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {object} mParameters.page the page to be created according to descriptor schema
	 * @param {object} [mTexts] texts for the inline change
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_ui_generic_app_setMainPage = function(mParameters,mTexts) {
		Utils.checkParameterAndType(mParameters, "page", "object");
		return this._createDescriptorInlineChange('appdescr_ui_generic_app_setMainPage', mParameters, mTexts);
	};

	/**
	 * Creates an inline change of change type appdescr_ui_setIcon
	 *
	 * @param {object} mParameters parameters of the change type
	 * @param {object} mParameters.icon the icon string
	 *
	 * @return {Promise} resolving when creating the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorInlineChangeFactory.create_ui_setIcon = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "icon", "string");
		return this._createDescriptorInlineChange('appdescr_ui_setIcon', mParameters);
	};


	return DescriptorInlineChangeFactory;

},true);

}; // end of sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.registry.Settings') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/*global Error */

jQuery.sap.declare('sap.ui.fl.registry.Settings'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.EventProvider'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/registry/Settings",[
	"jquery.sap.global", "sap/ui/fl/LrepConnector", "sap/ui/fl/Cache", "sap/ui/fl/Utils", "sap/ui/base/EventProvider"
], function(jQuery, LrepConnector, Cache, Utils, EventProvider) {
	"use strict";

	/**
	 * FlexSettings access
	 *
	 * @param {object} oSettings settings as JSON object
	 * @constructor
	 * @alias sap.ui.fl.registry.Settings
	 * @author SAP SE
	 * @experimental Since 1.27.0
	 * @private
	 */
	var Settings = function(oSettings) {
		EventProvider.apply(this);
		if (!oSettings) {
			throw new Error("no flex settings provided");
		}
		// Defaults layers used for standard changes, such as 'move' or 'add'
		if (!oSettings.defaultLayerPermissions) {
			oSettings.defaultLayerPermissions = {
				"VENDOR": true,
				"CUSTOMER_BASE": true,
				"CUSTOMER": true,
				"USER": false
			};
		}

		// These are the permissions for the Developer Mode Changes, e.g. 'propertyChange', 'propertyBindingChange'
		if (!oSettings.developerModeLayerPermissions) {
			oSettings.developerModeLayerPermissions = {
				"VENDOR": true,
				"CUSTOMER_BASE": true,
				"CUSTOMER": false,
				"USER": false
			};
		}

		this._oSettings = oSettings;
		this._hasMergeErrorOccured = false;
	};

	Settings.prototype = jQuery.sap.newObject(EventProvider.prototype);

	Settings.events = {
		flexibilityAdaptationButtonAllowedChanged: "flexibilityAdaptationButtonAllowedChanged",
		changeModeUpdated: "changeModeUpdated"
	};

	Settings._instance = undefined;
	Settings._bFlexChangeMode = true;
	Settings._bFlexibilityAdaptationButtonAllowed = false;
	Settings._oEventProvider = new EventProvider();

	/**
	 * fires the passed event via its event provider
	 *
	 * @param {string} sEventId name of the event
	 * @param {object} mParameters
	 *
	 * @public
	 */
	Settings.fireEvent = function(sEventId, mParameters) {
		Settings._oEventProvider.fireEvent(sEventId, mParameters);
	};

	/**
	 * attaches a callback to an event on the event provider of Settings
	 *
	 * @param {string} sEventId name of the event
	 * @param {function} oCallback
	 *
	 * @public
	 */
	Settings.attachEvent = function(sEventId, oCallback) {
		Settings._oEventProvider.attachEvent(sEventId, oCallback);
	};

	/**
	 * detaches a callback to an event on the event provider of Settings
	 *
	 * @param {string} sEventId name of the event
	 * @param {function} oCallback
	 *
	 * @public
	 */
	Settings.detachEvent = function(sEventId, oCallback) {
		Settings._oEventProvider.detachEvent(sEventId, oCallback);
	};

	/**
	 * Returns a settings instance after reading the settings from the back end if not already done. There is only one instance of settings during a
	 * session.
	 *
	 * @param {string} [sComponentName] - Current SAPUI5 component name
	 * @param {string} [sAppVersion] - Current application version
	 * @param {map} [mPropertyBag] - Contains additional data needed for reading changes
	 * @param {object} [mPropertyBag.appDescriptor] - App descriptor belonging to actual component
	 * @param {string} [mPropertyBag.siteId] - Side ID that belongs to actual component
	 * @returns {Promise} with parameter <code>oInstance</code> of type {sap.ui.fl.registry.Settings}
	 * @public
	 */
	Settings.getInstance = function(sComponentName, sAppVersion, mPropertyBag) {
		if (Settings._instance) {
			return Promise.resolve(Settings._instance);
		}
		if (sComponentName) {
			sAppVersion = sAppVersion || Utils.DEFAULT_APP_VERSION;
			return Cache.getChangesFillingCache(LrepConnector.createConnector(), { name: sComponentName, appVersion: sAppVersion }, mPropertyBag)
				.then(function (oFileContent) {
					var oSettings = {};
					if (oFileContent.changes && oFileContent.changes.settings) {
						oSettings = oFileContent.changes.settings;
					}
					return Settings._storeInstance(oSettings);
				});
		}
		return Settings._loadSettings();
	};

	/**
	 * Sends request to the back end for settings content. Stores content into internal setting instance and returns the instance.
	 *
	 * @returns {Promise} With parameter <code>oInstance</code> of type {sap.ui.fl.registry.Settings}
	 * @private
	 */
	Settings._loadSettings = function() {
		return LrepConnector.createConnector().loadSettings().then(function (oSettings){
			return Settings._storeInstance(oSettings);
		});
	};

	/**
	 * Writes the data received from the back end or cache into an internal instance and then returns the settings object within a Promise.
	 *
	 * @param oSettings - Data received from the back end or cache
	 * @returns {Promise} with parameter <code>oInstance</code> of type {sap.ui.fl.registry.Settings}
	 * @protected
	 *
	 */
	Settings._storeInstance = function(oSettings) {
		if (!Settings._instance) {
			Settings._instance = new Settings(oSettings);
		}
		return Settings._instance;
	};

	/**
	 * Returns a settings instance from the local instance cache. There is only one instance of settings during a session. If no instance has been
	 * created before, undefined will be returned.
	 *
	 * @returns {sap.ui.fl.registry.Settings} instance or undefined if no instance has been created so far.
	 * @public
	 */
	Settings.getInstanceOrUndef = function() {
		var oSettings;
		if (Settings._instance) {
			oSettings = Settings._instance;
		}
		return oSettings;
	};

	/**
	 * Checks if the flexibility change mode is enabled.
	 *
	 * @returns {boolean} true if the flexibility change mode is enabled
	 * @public
	 */
	Settings.isFlexChangeMode = function() {
		var bFlexChangeModeUrl = this._isFlexChangeModeFromUrl();
		if (bFlexChangeModeUrl !== undefined) {
			return bFlexChangeModeUrl;
		}

		return Settings._bFlexChangeMode;
	};

	/**
	 * Checks if the flexibility change mode is enabled via URL query parameter
	 *
	 * @returns {boolean} bFlexChangeMode true if the flexibility change mode is enabled, false if not enabled, undefined if not set via url.
	 * @public
	 */
	Settings._isFlexChangeModeFromUrl = function() {
		var bFlexChangeMode;
		var oUriParams = jQuery.sap.getUriParameters();
		if (oUriParams && oUriParams.mParams && oUriParams.mParams['sap-ui-fl-changeMode'] && oUriParams.mParams['sap-ui-fl-changeMode'][0]) {
			if (oUriParams.mParams['sap-ui-fl-changeMode'][0] === 'true') {
				bFlexChangeMode = true;
			} else if (oUriParams.mParams['sap-ui-fl-changeMode'][0] === 'false') {
				bFlexChangeMode = false;
			}
		}
		return bFlexChangeMode;
	};

	/**
	 * Activates the flexibility change mode.
	 *
	 * @public
	 */
	Settings.activateFlexChangeMode = function() {
		var bFlexChangeModeOn = true;
		Settings._setFlexChangeMode(bFlexChangeModeOn);
	};

	/**
	 * Deactivates / leaves the flexibility change mode.
	 *
	 * @public
	 */
	Settings.leaveFlexChangeMode = function() {
		var bFlexChangeModeOff = false;
		Settings._setFlexChangeMode(bFlexChangeModeOff);
	};


	/**
	 * sets the flexChangeMode flag
	 * fires an event if the flag has been toggled
	 *
	 * @private
	 */
	Settings._setFlexChangeMode = function (bFlexChangeModeOn) {
		if (Settings._bFlexChangeMode === bFlexChangeModeOn) {
			return; // no change
		}

		Settings._bFlexChangeMode = bFlexChangeModeOn;
		var mParameter = {
			bFlexChangeMode: bFlexChangeModeOn
		};
		Settings.fireEvent(Settings.events.changeModeUpdated, mParameter);
	};

	/**
	 * Method to check for adaptation button allowance
	 *
	 * @returns {boolean} Settings._bFlexibilityAdaptationButtonAllowed
	 * @public
	 */
	Settings.isFlexibilityAdaptationButtonAllowed = function () {
		return Settings._bFlexibilityAdaptationButtonAllowed;
	};

	/**
	 * Method to allow the adaptation button
	 *
	 * @public
	 */
	Settings.allowFlexibilityAdaptationButton = function () {
		var bFlexibilityAdaptationButtonAllowed = true;
		Settings.setFlexibilityAdaptationButtonAllowed(bFlexibilityAdaptationButtonAllowed);
	};

	/**
	 * Method to disallow the adaptation button
	 *
	 * @public
	 */
	Settings.disallowFlexibilityAdaptationButton = function () {
		var bFlexibilityAdaptationButtonDisallowed = false;
		Settings.setFlexibilityAdaptationButtonAllowed(bFlexibilityAdaptationButtonDisallowed);
	};

	/**
	 * Method to set the adaptation button allowance flag on or off depending on the passed parameter
	 * fires an event if the flag has been toggled
	 *
	 * @param {boolean} bFlexibilityAdaptationButtonAllowed
	 *
	 * @public
	 */
	Settings.setFlexibilityAdaptationButtonAllowed = function (bFlexibilityAdaptationButtonAllowed) {
		if (Settings._bFlexibilityAdaptationButtonAllowed === bFlexibilityAdaptationButtonAllowed) {
			return; // no change
		}

		Settings._bFlexibilityAdaptationButtonAllowed = bFlexibilityAdaptationButtonAllowed;

		var mParameter = {
			bFlexibilityAdaptationButtonAllowed: bFlexibilityAdaptationButtonAllowed
		};
		Settings.fireEvent(Settings.events.flexibilityAdaptationButtonAllowedChanged, mParameter);

	};

	/**
	 * Returns the key user status of the current user.
	 *
	 * @returns {boolean} true if the user is a flexibility key user, false if not supported.
	 * @public
	 */
	Settings.prototype.isKeyUser = function() {
		var bIsKeyUser = false;
		if (this._oSettings.isKeyUser) {
			bIsKeyUser = this._oSettings.isKeyUser;
		}
		return bIsKeyUser;
	};

	/**
	 * Returns true if back end is ModelS back end.
	 *
	 * @returns {boolean} true if ATO coding exists in back end.
	 * @public
	 */
	Settings.prototype.isModelS = function() {
		var bIsModelS = false;
		if (this._oSettings.isAtoAvailable) {
			bIsModelS = this._oSettings.isAtoAvailable;
		}
		return bIsModelS;
	};

	/**
	 * Returns true if ATO is enabled in the back end.
	 *
	 * @returns {boolean} true if ATO is enabled.
	 * @public
	 */
	Settings.prototype.isAtoEnabled = function() {
		var bIsAtoEnabled = false;
		if (this._oSettings.isAtoEnabled) {
			bIsAtoEnabled = this._oSettings.isAtoEnabled;
		}
		return bIsAtoEnabled;
	};

	/**
	 * Checks whether the current system is defined as a productive system.
	 *
	 * @public
	 * @returns {boolean} true if system is productive system
	 */
	Settings.prototype.isProductiveSystem = function() {
		var bIsProductiveSystem = false;
		if (this._oSettings.isProductiveSystem) {
			bIsProductiveSystem = this._oSettings.isProductiveSystem;
		}
		return bIsProductiveSystem;
	};

	Settings.prototype.setMergeErrorOccured = function(bErrorOccured) {
		this._hasMergeErrorOccoured = bErrorOccured;
	};
	/**
	 * Checks if a merge error occured during merging changes into the view on startup
	 */
	Settings.prototype.hasMergeErrorOccured = function() {
		return this._hasMergeErrorOccured;
	};

	/**
	 * Getter for the default Layer-Permissions
	 */
	Settings.prototype.getDefaultLayerPermissions = function() {
		return this._oSettings.defaultLayerPermissions;
	};

	/**
	 * Getter for the Developer Mode Layer-Permissions
	 */
	Settings.prototype.getDeveloperModeLayerPermissions = function() {
		return this._oSettings.developerModeLayerPermissions;
	};

	return Settings;
}, /* bExport= */true);

}; // end of sap/ui/fl/registry/Settings.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.transport.Transports') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/*global Promise */

jQuery.sap.declare('sap.ui.fl.transport.Transports'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/transport/Transports",[
	"sap/ui/fl/LrepConnector", "sap/ui/fl/Utils"
], function(LrepConnector, FlexUtils) {
	"use strict";

	/**
	 * Entity that handles ABAP transport related information.
	 * @constructor
	 * @alias sap.ui.fl.transport.Transports
	 * @author SAP SE
	 * @version 1.48.6
	 * @since 1.38.0
	 */
	var Transports = function() {
	};

	/**
	 * Reads the transports of the current user from the back end.
	 * The "locked" attribute indicates that the provided file (package/name/type) is already locked on this transport.
	 *
	 * @param {object} mParameters map of parameters, see below
	 * @param {string} mParameters.package - abap package; only relevant for VENDOR layer
	 * @param {string} mParameters.name - name of the lrep document
	 * @param {string} mParameters.namespace - namespace of the lrep document
	 * @param {string} mParameters.type - file extension of the lrep document
	 * @returns {Promise} with parameter <code>oResult</code>
	 * 					which is an object that has the attributes "transports", "localonly" and "errorCode".
	 * 					"localonly" tells the consumer if only local development is valid and no transport selection should take place.
	 * 					"transports" is an array of objects with attributes "transportId", "owner", "description", "locked"(true/false).
	 * 					"errorCode" can have the values "INVALID_PACKAGE" or "NO_TRANSPORTS" or is an empty string if there is no error.
	 * @public
	 */
	Transports.prototype.getTransports = function(mParameters) {
		var sUri, sClient, oLrepConnector, oPromise;
		sUri = '/sap/bc/lrep/actions/gettransports/';
		if (mParameters['package']) {
			sUri += '&package=' + mParameters['package'];
		}
		if (mParameters.name) {
			sUri += '&name=' + mParameters.name;
		}
		if (mParameters.namespace) {
			sUri += '&namespace=' + mParameters.namespace;
		}
		if (mParameters.type) {
			sUri += '&type=' + mParameters.type;
		}
		sClient = FlexUtils.getClient();
		if (sClient) {
			sUri += '&sap-client=' + sClient;
		}
		//Replace first & with ?
		sUri = sUri.replace('&', '?');

		oLrepConnector = LrepConnector.createConnector();
		oPromise = oLrepConnector.send(sUri);
		return oPromise.then(function(oResponse) {
			if (oResponse.response) {
				if (!oResponse.response.localonly) {
					oResponse.response.localonly = false;
				}
				if (!oResponse.response.errorCode) {
					oResponse.response.errorCode = "";
				}
				return Promise.resolve(oResponse.response);
			} else {
				return Promise.reject('response is empty');
			}
		});
	};

	/**
	 * Reads the transports of the current user from the back end.
	 * The "locked" attribute indicates that the provided file (package/name/type) is already locked on this transport.
	 *
	 * @param {object} mParameters map of parameters, see below
	 * @param {string} mParameters.transportId - ABAP transport ID
	 * @param {string} mParameters.changeIds - array of change ID objects with attributes "namespace", "fileName", "fileType"
	 * @returns {Promise} without parameters
	 * @public
	 */
	Transports.prototype.makeChangesTransportable = function(mParameters) {
		var sUri, sClient, oLrepConnector;
		sUri = '/sap/bc/lrep/actions/make_changes_transportable/';
		sClient = FlexUtils.getClient();
		if (sClient) {
			sUri += '?sap-client=' + sClient;
		}
		if (!mParameters.transportId) {
			return Promise.reject(new Error("no transportId provided as attribute of mParameters"));
		}
		if (!mParameters.changeIds) {
			return Promise.reject(new Error("no changeIds provided as attribute of mParameters"));
		}
		oLrepConnector = LrepConnector.createConnector();
		return oLrepConnector.send(sUri,'POST',mParameters);
	};

	/**
	 * Get list of changes which should be added to a transport
	 *
	 * @param {Array} aLocalChanges List of changes which data have to be extracted
	 * @returns {Array} Returns an array of object containing all required data to transport the existing local changes
	 */
	Transports.prototype._convertToChangeTransportData = function(aLocalChanges) {
		var aTransportData = [];
		var len = aLocalChanges.length;
		for (var i = 0; i < len; i++) {
			var oCurrentChange = aLocalChanges[i];
			var oData = {};
			oData.namespace = oCurrentChange.getNamespace();
			oData.fileName = oCurrentChange.getId();
			oData.fileType = oCurrentChange.getDefinition().fileType;
			aTransportData.push(oData);
		}
		return aTransportData;
	};

	return Transports;
}, /* bExport= */true);

}; // end of sap/ui/fl/transport/Transports.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.Change') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.fl.Change'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.base.EventProvider'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/Change",[
	"sap/ui/base/EventProvider", "sap/ui/fl/Utils", "sap/ui/fl/registry/Settings"
], function (EventProvider, Utils, Settings) {

	"use strict";

	/**
	 * A change object based on the json data with dirty handling.
	 * @constructor
	 * @alias sap.ui.fl.Change
	 * @param {object} oFile - file content and admin data
	 * @experimental Since 1.25.0
	 * @author SAP SE
	 * @version 1.48.6
	 */
	var Change = function (oFile) {
		EventProvider.apply(this);
		if (typeof (oFile) !== "object") {
			Utils.log.error("Constructor : sap.ui.fl.Change : oFile is not defined");
		}

		this._oDefinition = oFile;
		this._oOriginDefinition = JSON.parse(JSON.stringify(oFile));
		this._sRequest = '';
		this._bIsDeleted = false;
		this._bUserDependent = (oFile.layer === "USER");
	};

	Change.events = {
		markForDeletion: "markForDeletion"
	};

	Change.prototype = jQuery.sap.newObject(EventProvider.prototype);

	/**
	 * Returns if the change protocol is valid
	 * @returns {boolean} Change is valid (mandatory fields are filled, etc)
	 *
	 * @public
	 */
	Change.prototype.isValid = function () {
		var bIsValid = true;

		if (typeof (this._oDefinition) !== "object") {
			bIsValid = false;
		}
		if (!this._oDefinition.fileType) {
			bIsValid = false;
		}
		if (!this._oDefinition.fileName) {
			bIsValid = false;
		}
		if (!this._oDefinition.changeType) {
			bIsValid = false;
		}
		if (!this._oDefinition.layer) {
			bIsValid = false;
		}
		if (!this._oDefinition.originalLanguage) {
			bIsValid = false;
		}

		return bIsValid;
	};

	/**
	 * Returns if the change is of type variant
	 * @returns {boolean} fileType of the change document is a variant
	 *
	 * @public
	 */
	Change.prototype.isVariant = function () {
		return this._oDefinition.fileType === "variant";
	};

	/**
	 * Returns the change type
	 *
	 * @returns {String} Changetype of the file, for example LabelChange
	 * @public
	 */
	Change.prototype.getChangeType = function () {
		if (this._oDefinition) {
			return this._oDefinition.changeType;
		}
	};

	/**
	 * Returns the the original language in ISO 639-1 format
	 *
	 * @returns {String} Original language
	 *
	 * @public
	 */
	Change.prototype.getOriginalLanguage = function () {
		if (this._oDefinition && this._oDefinition.originalLanguage) {
			return this._oDefinition.originalLanguage;
		}
		return "";
	};

	/**
	 * Returns the the context in which the change should be applied
	 *
	 * @returns {Object[]} context - List of objects determine the context
	 * @returns {string} selector  - names the key of the context
	 * @returns {string} operator - instruction how the values should be compared
	 * @returns {Object} value - values given to the comparison
	 *
	 * @public
	 */
	Change.prototype.getContext = function () {
		if (this._oDefinition && this._oDefinition.context) {
			return this._oDefinition.context;
		}
		return "";
	};

	/**
	 * Returns the abap package name
	 * @returns {string} ABAP package where the change is assigned to
	 *
	 * @public
	 */
	Change.prototype.getPackage = function () {
		return this._oDefinition.packageName;
	};

	/**
	 * Returns the namespace. The changes' namespace is
	 * also the namespace of the change file in the repository.
	 *
	 * @returns {String} Namespace of the change document
	 *
	 * @public
	 */
	Change.prototype.getNamespace = function () {
		return this._oDefinition.namespace;
	};

	/**
	 * Returns the id of the change
	 * @returns {string} Id of the change document
	 *
	 * @public
	 */
	Change.prototype.getId = function () {
		return this._oDefinition.fileName;
	};

	/**
	 * Returns the content section of the change
	 * @returns {string} Content of the change document. The content structure can be any JSON.
	 *
	 * @public
	 */
	Change.prototype.getContent = function () {
		return this._oDefinition.content;
	};

	/**
	 * Sets the object of the content attribute
	 *
	 * @param {object} oContent The content of the change document. Can be any JSON object.
	 *
	 * @public
	 */
	Change.prototype.setContent = function (oContent) {
		this._oDefinition.content = oContent;
	};

	/**
	 * Returns the selector from the file content
	 * @returns {object} selector in format selectorPropertyName:selectorPropertyValue
	 *
	 * @public
	 */
	Change.prototype.getSelector = function () {
		return this._oDefinition.selector;
	};

	/**
	 * Returns the user ID of the owner
	 * @returns {string} ID of the owner
	 *
	 * @public
	 */
	Change.prototype.getOwnerId = function () {
		return this._oDefinition.support ? this._oDefinition.support.user : "";
	};

	/**
	 * Returns the text in the current language for a given id
	 *
	 * @param {string} sTextId
	 *                text id which was used as part of the <code>oTexts</code> object
	 * @returns {string} The text for the given text id
	 *
	 * @function
	 */
	Change.prototype.getText = function (sTextId) {
		if (typeof (sTextId) !== "string") {
			Utils.log.error("sap.ui.fl.Change.getTexts : sTextId is not defined");
		}
		if (this._oDefinition.texts) {
			if (this._oDefinition.texts[sTextId]) {
				return this._oDefinition.texts[sTextId].value;
			}
		}
		return "";
	};

	/**
	 * Sets the new text for the given text id
	 *
	 * @param {string} sTextId
	 *                text id which was used as part of the <code>oTexts</code> object
	 * @param {string} sNewText the new text for the given text id
	 *
	 * @public
	 */
	Change.prototype.setText = function (sTextId, sNewText) {
		if (typeof (sTextId) !== "string") {
			Utils.log.error("sap.ui.fl.Change.setTexts : sTextId is not defined");
			return;
		}
		if (this._oDefinition.texts) {
			if (this._oDefinition.texts[sTextId]) {
				this._oDefinition.texts[sTextId].value = sNewText;
			}
		}
	};

	/**
	 * Returns true if the current layer is the same as the layer
	 * in which the change was created or the change is from the
	 * end-user layer and for this user created.
	 * @returns {boolean} is the change document read only
	 *
	 * @public
	 */
	Change.prototype.isReadOnly = function () {
		return this._isReadOnlyDueToLayer() || this._isReadOnlyWhenNotKeyUser();
	};

	/**
	 * Checks if the change is read-only
	 * because the current user is not a key user and the change is "shared"
	 * @returns {boolean} Flag whether change is read only
	 *
	 * @private
	 */
	Change.prototype._isReadOnlyWhenNotKeyUser = function () {
		if (this.isUserDependent()) {
			return false; // the user always can edit its own changes
		}

		var sReference = this.getDefinition().reference;
		if (!sReference) {
			return true; // without a reference the right to edit or delete a change cannot be determined
		}

		var oSettings = Settings.getInstanceOrUndef();
		if (!oSettings) {
			return true; // without settings the right to edit or delete a change cannot be determined
		}

		return !oSettings.isKeyUser(); // a key user can edit changes
	};

	/**
	 * Returns true if the label is read only. The label might be read only because of the current layer or because the logon language differs from the original language of the change document.
	 *
	 * @returns {boolean} is the label read only
	 *
	 * @public
	 */
	Change.prototype.isLabelReadOnly = function () {
		if (this._isReadOnlyDueToLayer()) {
			return true;
		}
		return this._isReadOnlyDueToOriginalLanguage();
	};

	/**
	 * Checks if the layer allows modifying the file
	 * @returns {boolean} Flag whether change is read only
	 *
	 * @private
	 */
	Change.prototype._isReadOnlyDueToLayer = function () {
		var sCurrentLayer;
		sCurrentLayer = Utils.getCurrentLayer(this._bUserDependent);
		return (this._oDefinition.layer !== sCurrentLayer);
	};

	/**
	 * A change can only be modified if the current language equals the original language.
	 * Returns false if the current language does not equal the original language of the change file.
	 * Returns false if the original language is initial.
	 *
	 * @returns {boolean} flag whether the current logon language differs from the original language of the change document
	 *
	 * @private
	 */
	Change.prototype._isReadOnlyDueToOriginalLanguage = function () {
		var sCurrentLanguage, sOriginalLanguage;

		sOriginalLanguage = this.getOriginalLanguage();
		if (!sOriginalLanguage) {
			return false;
		}

		sCurrentLanguage = Utils.getCurrentLanguage();
		return (sCurrentLanguage !== sOriginalLanguage);
	};

	/**
	 * Mark the current change to be deleted persistently
	 *
	 * @public
	 */
	Change.prototype.markForDeletion = function () {
		this._bIsDeleted = true;
	};

	/**
	 * Determines whether the change has to be updated on the back end
	 * @returns {boolean} content of the change document has changed (change is in dirty state)
	 * @private
	 */
	Change.prototype._isDirty = function () {
		var sCurrentDefinition = JSON.stringify(this._oDefinition);
		var sOriginDefinition = JSON.stringify(this._oOriginDefinition);

		return (sCurrentDefinition !== sOriginDefinition);
	};

	/**
	 * Sets the transport request
	 *
	 * @param {string} sRequest Transport request
	 *
	 * @public
	 */
	Change.prototype.setRequest = function (sRequest) {
		if (typeof (sRequest) !== "string") {
			Utils.log.error("sap.ui.fl.Change.setRequest : sRequest is not defined");
		}
		this._sRequest = sRequest;
	};

	/**
	 * Gets the transport request
	 * @returns {string} Transport request
	 *
	 * @public
	 */
	Change.prototype.getRequest = function () {
		return this._sRequest;
	};

	/**
	 * Gets the layer type for the change
	 * @returns {string} The layer of the change document
	 *
	 * @public
	 */
	Change.prototype.getLayer = function () {
		return this._oDefinition.layer;
	};

	/**
	 * Gets the component for the change
	 * @returns {string} The SAPUI5 component this change is assigned to
	 *
	 * @public
	 */
	Change.prototype.getComponent = function () {
		return this._oDefinition.reference;
	};

	/**
	 * Gets the creation timestamp
	 *
	 * @returns {String} creation timestamp
	 *
	 * @public
	 */
	Change.prototype.getCreation = function () {
		return this._oDefinition.creation;
	};

	/**
	 * Returns true if the change is user dependent
	 * @returns {boolean} Change is only relevant for the current user
	 *
	 * @public
	 */
	Change.prototype.isUserDependent = function () {
		return (this._bUserDependent);
	};

	/**
	 * Returns the pending action on the change item
	 * @returns {string} contains one of these values: DELETE/NEW/UPDATE/NONE
	 *
	 * @public
	 */
	Change.prototype.getPendingAction = function () {
		if (this._bIsDeleted) {
			return "DELETE";
		} else if (!this._oDefinition.creation) {
			return "NEW";
		} else if (this._isDirty() === true) {
			return "UPDATE";
		}
		return "NONE";
	};

	/**
	 * Gets the JSON definition of the change
	 * @returns {object} the content of the change document
	 *
	 * @public
	 */
	Change.prototype.getDefinition = function () {
		return this._oDefinition;
	};

	/**
	 * Set the response from the back end after saving the change
	 * @param {object} oResponse the content of the change document
	 *
	 * @public
	 */
	Change.prototype.setResponse = function (oResponse) {
		var sResponse = JSON.stringify(oResponse);
		if (sResponse) {
			this._oDefinition = JSON.parse(sResponse);
			this._oOriginDefinition = JSON.parse(sResponse);
		}
	};

	Change.prototype.getFullFileIdentifier = function () {
		var sLayer = this.getLayer();
		var sNamespace = this.getNamespace();
		var sFileName = this.getDefinition().fileName;
		var sFileType = this.getDefinition().fileType;

		return sLayer + "/" + sNamespace + "/" + sFileName + "." + sFileType;
	};

	/**
	 * Adds the selector to the dependent selector list.
	 *
	 * @param {(string|sap.ui.core.Control|string[]|sap.ui.core.Control[])} vControl - SAPUI5 control, or ID string,
	 * or array of SAPUI5 controls, for which the selector shall be determined
	 * @param {string} sAlias - Dependent object is saved under this alias
	 * @param {object} mPropertyBag
	 * @param {sap.ui.fl.changeHandler.BaseTreeModifier} mPropertyBag.modifier - Modifier for the controls
	 * @param {sap.ui.core.Component} [mPropertyBag.appComponent] - Application component; only needed if <code>vControl</code> is a string or an XML node
	 * @param {object} [mAdditionalSelectorInformation] - Additional mapped data which is added to the selector
	 *
	 * @throws {Exception} oException - If sAlias already exists, an error is thrown
	 * @public
	 */
	Change.prototype.addDependentControl = function (vControl, sAlias, mPropertyBag, mAdditionalSelectorInformation) {
		if (!vControl) {
			throw new Error("Parameter vControl is mandatory");
		}
		if (!sAlias) {
			throw new Error("Parameter sAlias is mandatory");
		}
		if (!mPropertyBag) {
			throw new Error("Parameter mPropertyBag is mandatory");
		}

		if (!this._oDefinition.dependentSelector) {
			this._oDefinition.dependentSelector = {};
		}

		if (this._oDefinition.dependentSelector[sAlias]) {
			throw new Error("Alias '" + sAlias + "' already exists in the change.");
		}

		var oModifier = mPropertyBag.modifier;
		var oAppComponent = mPropertyBag.appComponent;

		if (Array.isArray(vControl)) {
			var aSelector = [];
			vControl.forEach(function (oControl) {
				aSelector.push(oModifier.getSelector(oControl, oAppComponent, mAdditionalSelectorInformation));
			});
			this._oDefinition.dependentSelector[sAlias] = aSelector;
		} else {
			this._oDefinition.dependentSelector[sAlias] = oModifier.getSelector(vControl, oAppComponent, mAdditionalSelectorInformation);
		}

		//remove dependency list so that it will be created again in method getDependentIdList
		delete this._aDependentIdList;
	};

	/**
	 * Returns the control or array of controls saved under the passed alias.
	 *
	 * @param {string} sAlias - Used to retrieve the selectors that have been saved under this alias
	 * @param {object} mPropertyBag
	 * @param {sap.ui.fl.changeHandler.BaseTreeModifier} mPropertyBag.modifier - Modifier for the controls
	 * @param {sap.ui.core.Component} mPropertyBag.appComponent - Application component, needed to retrieve the control from the selector
	 * @param {Node} mPropertyBag.view - only for xml processing: the xml node of the view
	 *
	 * @returns {array | object} dependent selector list in format selectorPropertyName:selectorPropertyValue or the selector saved under the alias
	 *
	 * @public
	 */
	Change.prototype.getDependentControl = function (sAlias, mPropertyBag) {
		var aDependentControls = [];
		var oDependentSelector;
		if (!sAlias) {
			throw new Error("Parameter sAlias is mandatory");
		}
		if (!mPropertyBag) {
			throw new Error("Parameter mPropertyBag is mandatory");
		}

		var oModifier = mPropertyBag.modifier;
		var oAppComponent = mPropertyBag.appComponent;

		if (!this._oDefinition.dependentSelector) {
			return undefined;
		}

		oDependentSelector = this._oDefinition.dependentSelector[sAlias];
		if (Array.isArray(oDependentSelector)) {
			oDependentSelector.forEach(function (oSelector) {
				aDependentControls.push(oModifier.bySelector(oSelector, oAppComponent, mPropertyBag.view));
			});
			return aDependentControls;
		} else {
			return oModifier.bySelector(oDependentSelector, oAppComponent, mPropertyBag.view);
		}
	};

	/**
	 * Returns all dependent global IDs, including the ID from selector of the changes.
	 *
	 * @param {sap.ui.core.Component} oAppComponent - Application component, needed to translate the local ID into a global ID
	 *
	 * @returns {array} dependent global ID list
	 *
	 * @public
	 */
	Change.prototype.getDependentIdList = function (oAppComponent) {
		var that = this;
		var sId;
		var aDependentSelectors = [this.getSelector()];
		var aDependentIds = [];

		if (!this._aDependentIdList) {
			if (this._oDefinition.dependentSelector){
				aDependentSelectors = Object.keys(this._oDefinition.dependentSelector).reduce(function(aDependentSelectors, sAlias){
					return aDependentSelectors.concat(that._oDefinition.dependentSelector[sAlias]);
				}, aDependentSelectors);
			}

			aDependentSelectors.forEach(function (oDependentSelector) {
				sId = oDependentSelector.id;
				if (oDependentSelector.idIsLocal) {
					sId = oAppComponent.createId(oDependentSelector.id);
				}
				if (aDependentIds.indexOf(sId) === -1) {
					aDependentIds.push(sId);
				}
			});

			this._aDependentIdList = aDependentIds;
		}

		return this._aDependentIdList;
	};

	/**
	 * Returns the change key
	 *
	 * @returns {String} Change key of the file which is a unique concatenation of fileName, layer and namespace
	 * @public
	 */
	Change.prototype.getKey = function () {
		return this._oDefinition.fileName + this._oDefinition.layer + this._oDefinition.namespace;
	};

	/**
	 * Creates and returns an instance of change instance
	 *
	 * @param {Object}  [oPropertyBag] property bag
	 * @param {String}  [oPropertyBag.service] name of the OData service
	 * @param {String}  [oPropertyBag.changeType] type of the change
	 * @param {Object}  [oPropertyBag.texts] map object with all referenced texts within the file
	 *                                      these texts will be connected to the translation process
	 * @param {Object}  [oPropertyBag.content] content of the new change
	 * @param {Boolean} [oPropertyBag.isVariant] variant?
	 * @param {String}  [oPropertyBag.packageName] ABAP package name
	 * @param {Object}  [oPropertyBag.selector] name value pair of the attribute and value
	 * @param {String}  [oPropertyBag.id] name/id of the file. if not set implicitly created
	 * @param {Boolean} [oPropertyBag.isVariant] name of the component
	 * @param {Boolean} [oPropertyBag.isUserDependent] true for enduser changes
	 * @param {String}  [oPropertyBag.context] ID of the context
	 * @param {Object}  [oPropertyBag.dependentSelector] List of selectors saved under an alias for creating the dependencies between changes
	 * @param {Object}  [oPropertyBag.validAppVersions] Application versions where the change is active
	 * @param {String}  [oPropertyBag.reference] Application component name
	 * @param {String}  [oPropertyBag.namespace] The namespace of the change file
	 *
	 * @returns {Object} The content of the change file
	 *
	 * @public
	 */
	Change.createInitialFileContent = function (oPropertyBag) {

		if (!oPropertyBag) {
			oPropertyBag = {};
		}

		var oNewFile = {
			fileName: oPropertyBag.id || Utils.createDefaultFileName(oPropertyBag.changeType),
			fileType: (oPropertyBag.isVariant) ? "variant" : "change",
			changeType: oPropertyBag.changeType || "",
			reference: oPropertyBag.reference || "",
			packageName: oPropertyBag.packageName || "",
			content: oPropertyBag.content || {},
			selector: oPropertyBag.selector || {},
			layer: oPropertyBag.layer || Utils.getCurrentLayer(oPropertyBag.isUserDependent),
			texts: oPropertyBag.texts || {},
			namespace: oPropertyBag.namespace || Utils.createNamespace(oPropertyBag, "changes"), //TODO: we need to think of a better way to create namespaces from Adaptation projects.
			creation: "",
			originalLanguage: Utils.getCurrentLanguage(),
			conditions: {},
			context: oPropertyBag.context || "",
			support: {
				generator: "Change.createInitialFileContent",
				service: oPropertyBag.service || "",
				user: "",
				sapui5Version: sap.ui.version
			},
			dependentSelector: oPropertyBag.dependentSelector || {},
			validAppVersions: oPropertyBag.validAppVersions || {}
		};

		return oNewFile;
	};

	return Change;
}, true);

}; // end of sap/ui/fl/Change.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.ChangePersistence') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.ChangePersistence'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/ChangePersistence",[
	"sap/ui/fl/Change", "sap/ui/fl/Utils", "sap/ui/fl/LrepConnector", "sap/ui/fl/Cache", "sap/ui/fl/context/ContextManager", "sap/ui/fl/registry/Settings"
], function(Change, Utils, LRepConnector, Cache, ContextManager, Settings) {
	"use strict";

	/**
	 * Helper object to access a change from the back end. Access helper object for each change (and variant) which was fetched from the back end
	 *
	 * @constructor
	 * @author SAP SE
	 * @version 1.37.0-SNAPSHOT
	 * @experimental Since 1.25.0
	 * @param {object} mComponent Component data to initiate <code>ChangePersistence</code> instance
	 * @param {string} mComponent.name Name of the component this instance is responsible for
	 * @param {string} mComponent.appVersion Version of application
	 */
	var ChangePersistence = function(mComponent) {
		this._mComponent = mComponent;
		//_mChanges contains:
		// - mChanges: map of changes (selector id)
		// - mDependencies: map of changes (change key) that need to be applied before any change. Used to check if a change can be applied. Format:
		//		mDependencies: {
		//			"fileNameChange2USERnamespace": {
		//				"changeObject": oChange2,
		//				"dependencies": ["fileNameChange1USERnamespace"]
		//			},
		//			"fileNameChange3USERnamespace": {
		//				"changeObject": oChange3,
		//				"dependencies": ["fileNameChange2USERnamespace"]
		//			}
		//		}
		// - mDependentChangesOnMe: map of changes (change key) that cannot be applied before the change. Used to remove dependencies faster. Format:
		//		mDependentChangesOnMe: {
		//			"fileNameChange1USERnamespace": [oChange2],
		//			"fileNameChange2USERnamespace": [oChange3]
		//		}
		this._mChanges = {
			mChanges: {},
			mDependencies: {},
			mDependentChangesOnMe: {}
		};

		if (!this._mComponent || !this._mComponent.name) {
			Utils.log.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");
			throw new Error("Missing component name.");
		}

		this._oConnector = this._createLrepConnector();
		this._aDirtyChanges = [];
	};

	ChangePersistence.NOTAG = "<NoTag>";

	/**
	 * Return the name of the SAPUI5 component. All changes are assigned to 1 SAPUI5 component. The SAPUI5 component also serves as authorization
	 * object.
	 *
	 * @returns {String} component name
	 * @public
	 */
	ChangePersistence.prototype.getComponentName = function() {
		return this._mComponent.name;
	};

	/**
	 * Creates a new instance of the LRepConnector
	 *
	 * @returns {sap.ui.fl.LrepConnector} LRep connector instance
	 * @private
	 */
	ChangePersistence.prototype._createLrepConnector = function() {
		return LRepConnector.createConnector();
	};


	ChangePersistence.prototype.getCacheKey = function() {
		return Cache.getChangesFillingCache(this._oConnector, this._mComponent).then(function(oWrappedChangeFileContent) {
			if (oWrappedChangeFileContent && oWrappedChangeFileContent.etag) {
				return oWrappedChangeFileContent.etag;
			}

			return ChangePersistence.NOTAG;
		});
	};

	/**
	 * Verifies whether a change fulfils the preconditions.
	 *
	 * All changes need to be matched with current active contexts;
	 * only changes whose <code>fileType</code> is 'change' and whose <code>changeType</code> is different from 'defaultVariant' are valid;
	 * if <code>bIncludeVariants</code> parameter is true, the changes with 'variant' <code>fileType</code> or 'defaultVariant' <code>changeType</code> are also valid
	 * if it has a selector <code>persistencyKey</code>.
	 *
	 * @param {sap.ui.fl.context.Context[]} aActiveContexts Array of current active contexts
	 * @param {boolean} [bIncludeVariants] Indicates that smart variants shall be included
	 * @param {object} oChangeContent Content of the change
	 *
	 * @returns {boolean} <code>true</code> if all the preconditions are fulfilled
	 * @public
	 */
	ChangePersistence.prototype._preconditionsFulfilled = function(aActiveContexts, bIncludeVariants, oChangeContent) {

		function _isValidFileType () {
			if (bIncludeVariants) {
				return (oChangeContent.fileType === "change") || (oChangeContent.fileType === "variant");
			}
			return (oChangeContent.fileType === "change") && (oChangeContent.changeType !== "defaultVariant");
		}

		function _isValidSelector () {
			if (bIncludeVariants) {
				if ((oChangeContent.fileType === "variant") || (oChangeContent.changeType === "defaultVariant")){
					return oChangeContent.selector && oChangeContent.selector.persistencyKey;
				}
			}
			return true;
		}

		function _isValidContext () {
			return ContextManager.doesContextMatch(oChangeContent, aActiveContexts);
		}

		if (_isValidFileType() && _isValidSelector() && _isValidContext()){
				return true;
		}
		return false;
	};

	/**
	 * Calls the back end asynchronously and fetches all changes for the component
	 * New changes (dirty state) that are not yet saved to the back end won't be returned.
	 * @param {map} mPropertyBag Contains additional data needed for reading changes
	 * @param {object} mPropertyBag.appDescriptor Manifest that belongs to actual component
	 * @param {string} mPropertyBag.siteId ID of the site belonging to actual component
	 * @param {string} [mPropertyBag.sCurrentLayer] Specifies a single layer for loading changes. If this parameter is set, the max layer filtering is not applied
	 * @param {boolean} [mPropertyBag.ignoreMaxLayerParameter] Indicates that changes shall be loaded without layer filtering
	 * @param {boolean} [mPropertyBag.includeVariants] Indicates that smart variants shall be included
	 * @param {string} [mPropertyBag.cacheKey] key to validate the client side stored cache entry
	 * @param {string} [mPropertyBag.url] address to which the request for change should be sent in case the data is not cached
	 * @see sap.ui.fl.Change
	 * @returns {Promise} Resolving with an array of changes
	 * @public
	 */
	ChangePersistence.prototype.getChangesForComponent = function(mPropertyBag) {
		return Cache.getChangesFillingCache(this._oConnector, this._mComponent, mPropertyBag).then(function(oWrappedChangeFileContent) {
			this._bHasLoadedChangesFromBackEnd = true;

			if (oWrappedChangeFileContent.changes && oWrappedChangeFileContent.changes.settings){
				Settings._storeInstance(oWrappedChangeFileContent.changes.settings);
			}

			if (!oWrappedChangeFileContent.changes || !oWrappedChangeFileContent.changes.changes) {
				return [];
			}

			var aChanges = oWrappedChangeFileContent.changes.changes;

			var sCurrentLayer = mPropertyBag && mPropertyBag.currentLayer;
			if (sCurrentLayer) {
				var aCurrentLayerChanges = [];
				aChanges.forEach(function (oChange) {
					if (oChange.layer === sCurrentLayer) {
						aCurrentLayerChanges.push(oChange);
					}
				});
				aChanges = aCurrentLayerChanges;
			} else if (Utils.isLayerFilteringRequired() && !(mPropertyBag && mPropertyBag.ignoreMaxLayerParameter)) {
				//If layer filtering required, excludes changes in higher layer than the max layer
				var aFilteredChanges = [];
				aChanges.forEach(function (oChange) {
					if (!Utils.isOverMaxLayer(oChange.layer)) {
						aFilteredChanges.push(oChange);
					}
				});
				aChanges = aFilteredChanges;
			}

			var bIncludeVariants = mPropertyBag && mPropertyBag.includeVariants;

			var aContextObjects = oWrappedChangeFileContent.changes.contexts || [];
			return new Promise(function (resolve) {
				ContextManager.getActiveContexts(aContextObjects).then(function (aActiveContexts) {
					resolve(aChanges.filter(this._preconditionsFulfilled.bind(this, aActiveContexts, bIncludeVariants)).map(createChange));
				}.bind(this));
			}.bind(this));

		}.bind(this));

		function createChange(oChangeContent) {
			return new Change(oChangeContent);
		}
	};

	/**
	 * @param {sap.ui.core.UIComponent} oComponent component containing the control for which the change should be added
	 * @param {sap.ui.fl.Change} oChange change which should be added into the mapping
	 * @see sap.ui.fl.Change
	 * @returns {map} mChanges map with added change
	 * @private
	 */
	ChangePersistence.prototype._addChangeIntoMap = function (oComponent, oChange) {
		var oSelector = oChange.getSelector();
		if (oSelector && oSelector.id) {
			var sSelectorId = oSelector.id;
			if (oSelector.idIsLocal) {
				sSelectorId = oComponent.createId(sSelectorId);
			}

			this._addMapEntry(sSelectorId, oChange);

			// if the localId flag is missing and the selector has a component prefix that is not matching the
			// application component, adds the change for a second time replacing the component ID prefix with
			// the application component ID prefix
			if (oSelector.idIsLocal === undefined && sSelectorId.indexOf("---") != -1) {
				var sComponentPrefix = sSelectorId.split("---")[0];

				if (sComponentPrefix !== oComponent.getId()) {
					sSelectorId = sSelectorId.split("---")[1];
					sSelectorId = oComponent.createId(sSelectorId);
					this._addMapEntry(sSelectorId, oChange);
				}
			}
		}

		return this._mChanges;
	};

	/**
	 *
	 * @param {string} sSelectorId Key in the mapping for which the entry is written
	 * @param {sap.ui.fl.Change} oChange Change object to be added to the mapping
	 * @private
	 */
	ChangePersistence.prototype._addMapEntry = function (sSelectorId, oChange) {
		if (!this._mChanges.mChanges[sSelectorId]) {
			this._mChanges.mChanges[sSelectorId] = [];
		}
		this._mChanges.mChanges[sSelectorId].push(oChange);
	};

	ChangePersistence.prototype._addDependency = function (oDependentChange, oChange) {
		if (!this._mChanges.mDependencies[oDependentChange.getKey()]) {
			this._mChanges.mDependencies[oDependentChange.getKey()] = {
				changeObject: oDependentChange,
				dependencies: []
			};
		}
		this._mChanges.mDependencies[oDependentChange.getKey()].dependencies.push(oChange.getKey());

		if (!this._mChanges.mDependentChangesOnMe[oChange.getKey()]) {
			this._mChanges.mDependentChangesOnMe[oChange.getKey()] = [];
		}
		this._mChanges.mDependentChangesOnMe[oChange.getKey()].push(oDependentChange.getKey());
	};

	/**
	 * Calls the back end asynchronously and fetches all changes for the component
	 * New changes (dirty state) that are not yet saved to the back end won't be returned.
	 * @param {object} oComponent Component instance used to prepare the IDs (e.g. local)
	 * @param {map} mPropertyBag Contains additional data needed for reading changes
	 * @param {object} mPropertyBag.appDescriptor Manifest belonging to actual component
	 * @param {string} mPropertyBag.siteId ID of the site belonging to actual component
	 * @see sap.ui.fl.Change
	 * @returns {Promise} Resolving with a getter for the changes map
	 * @public
	 */
	ChangePersistence.prototype.loadChangesMapForComponent = function (oComponent, mPropertyBag) {

		return this.getChangesForComponent(mPropertyBag).then(createChangeMap.bind(this));

		function createChangeMap(aChanges) {
			//Since starting RTA does not recreate ChangePersistence instance, resets changes map is required to filter personalized changes
			this._mChanges = {
				mChanges: {},
				mDependencies: {},
				mDependentChangesOnMe: {}
			};
			aChanges.forEach(this._addChangeAndUpdateDependencies.bind(this, oComponent));

			return this.getChangesMapForComponent.bind(this);
		}
	};

	ChangePersistence.prototype._addChangeAndUpdateDependencies = function(oComponent, oChange, iIndex, aChangesCopy) {
		this._addChangeIntoMap(oComponent, oChange);

		var oAppComponent = Utils.getAppComponentForControl(oComponent);

		//create dependencies map
		var aDependentIdList = oChange.getDependentIdList(oAppComponent);
		var oPreviousChange;
		var aPreviousDependentIdList;
		var iDependentIndex;
		var bFound;

		for (var i = iIndex - 1; i >= 0; i--) {//loop over the changes
			oPreviousChange = aChangesCopy[i];
			aPreviousDependentIdList = aChangesCopy[i].getDependentIdList(oAppComponent);
			bFound = false;
			for (var j = 0; j < aDependentIdList.length && !bFound; j++) {
				iDependentIndex = aPreviousDependentIdList.indexOf(aDependentIdList[j]);
				if (iDependentIndex > -1) {
					this._addDependency(oChange, oPreviousChange);
					bFound = true;
				}
			}
		}

	};

	/**
	 * Getter for the private aggregation containing sap.ui.fl.Change objects mapped by their selector ids.
	 * @return {map} mChanges mapping with changes sorted by their selector ids
	 * @public
	 */
	ChangePersistence.prototype.getChangesMapForComponent = function () {
		return this._mChanges;
	};

	/**
	 * Gets the changes for the given view id. The complete view prefix has to match.
	 *
	 * Example:
	 * Change has selector id:
	 * view1--view2--controlId
	 *
	 * Will match for view:
	 * view1--view2
	 *
	 * Will not match for view:
	 * view1
	 * view1--view2--view3
	 *
	 * @param {string} sViewId the id of the view, changes should be retrieved for
	 * @param {map} mPropertyBag contains additional data that are needed for reading of changes
	 * @param {object} mPropertyBag.appDescriptor Manifest that belongs to actual component
	 * @param {string} mPropertyBag.siteId id of the site that belongs to actual component
	 * @returns {Promise} resolving with an array of changes
	 * @public
	 */
	ChangePersistence.prototype.getChangesForView = function(sViewId, mPropertyBag) {
		var that = this;
		return this.getChangesForComponent(mPropertyBag).then(function(aChanges) {
			return aChanges.filter(changesHavingCorrectViewPrefix.bind(that));
		});

		function changesHavingCorrectViewPrefix(oChange) {
			var oSelector = oChange.getSelector();
			if (!oSelector){
				return false;
			}
			var sSelectorId = oSelector.id;
			if (!sSelectorId || !mPropertyBag) {
				return false;
			}
			var sSelectorIdViewPrefix = sSelectorId.slice(0, sSelectorId.lastIndexOf("--"));
			var sViewId;

			if (oChange.getSelector().idIsLocal) {
				var oAppComponent = mPropertyBag.appComponent;
				if (oAppComponent) {
					sViewId = oAppComponent.getLocalId(mPropertyBag.viewId);
				}
			} else {
				sViewId = mPropertyBag.viewId;
			}

			return sSelectorIdViewPrefix === sViewId;
		}
	};

	/**
	 * Adds a new change (could be variant as well) and returns the id of the new change.
	 *
	 * @param {object} vChange The complete and finalized JSON object representation the file content of the change or a Change instance
	 * @param {object} oComponent Component instance
	 * @returns {sap.ui.fl.Change} the newly created change object
	 * @public
	 */
	ChangePersistence.prototype.addChange = function(vChange, oComponent) {
		var oNewChange;
		if (vChange instanceof Change){
			oNewChange = vChange;
		}else {
			oNewChange = new Change(vChange);
		}
		this._aDirtyChanges.push(oNewChange);
		this._addChangeIntoMap(oComponent, oNewChange);
		this._addPropagationListener(oComponent);


		return oNewChange;
	};

	/**
	 * If the first change was created, the <code>propagationListener</code> of <code>sap.ui.fl</code> might not yet be
	 * attached to the application component and must be added then.
	 *
	 * @param {sap.ui.core.UiComponent} oComponent Application component that might not have a propagation listener yet
	 * @private
	 */
	ChangePersistence.prototype._addPropagationListener = function (oComponent) {
		if (oComponent) {
			var fnCheckIsNotFlPropagationListener = function (fnPropagationListener) {
				return !fnPropagationListener._bIsSapUiFlFlexControllerApplyChangesOnControl;
			};
			var bNoFlPropagationListenerAttached = oComponent.getPropagationListeners().every(fnCheckIsNotFlPropagationListener);

			if (bNoFlPropagationListenerAttached) {
				var oManifest = oComponent.getManifest();
				var sVersion = Utils.getAppVersionFromManifest(oManifest);
				var oFlexController = sap.ui.fl.FlexControllerFactory.create(this.getComponentName(), sVersion);
				var fnPropagationListener = oFlexController.getBoundApplyChangesOnControl(this.getChangesMapForComponent.bind(this), oComponent);
				oComponent.addPropagationListener(fnPropagationListener);
			}
		}
	};

	/**
	 * Saves all dirty changes by calling the appropriate back-end method (create for new changes, deleteChange for deleted changes);
	 * to ensure the correct order, the methods are called sequentially;
	 * after a change was saved successfully, it is removed from the dirty changes and the cache is updated.
	 *
	 * @returns {Promise} resolving after all changes have been saved
	 */
	ChangePersistence.prototype.saveDirtyChanges = function() {
		var aDirtyChangesClone = this._aDirtyChanges.slice(0);
		var aDirtyChanges = this._aDirtyChanges;
		var aRequests = this._getRequests(aDirtyChangesClone);
		var aPendingActions = this._getPendingActions(aDirtyChangesClone);

		if (aPendingActions.length === 1 && aRequests.length === 1 && aPendingActions[0] === "NEW") {
			var sRequest = aRequests[0];
			var aPreparedDirtyChangesBulk = this._prepareDirtyChanges(aDirtyChanges);
			return this._oConnector.create(aPreparedDirtyChangesBulk, sRequest).then(this._massUpdateCacheAndDirtyState(aDirtyChanges, aDirtyChangesClone));
		} else {
			return aDirtyChangesClone.reduce(function (sequence, oDirtyChange) {
				var saveAction = sequence.then(this._performSingleSaveAction(oDirtyChange).bind(this));
				saveAction.then(this._updateCacheAndDirtyState(aDirtyChanges, oDirtyChange));

				return saveAction;
			}.bind(this), Promise.resolve());
		}
	};

	ChangePersistence.prototype._performSingleSaveAction = function (oDirtyChange) {
		return function() {
			if (oDirtyChange.getPendingAction() === "NEW") {
				return this._oConnector.create(oDirtyChange.getDefinition(), oDirtyChange.getRequest());
			}

			if (oDirtyChange.getPendingAction() === "DELETE") {
				return this._oConnector.deleteChange({
					sChangeName: oDirtyChange.getId(),
					sLayer: oDirtyChange.getLayer(),
					sNamespace: oDirtyChange.getNamespace(),
					sChangelist: oDirtyChange.getRequest()
				});
			}
		};
	};

	ChangePersistence.prototype._updateCacheAndDirtyState = function (aDirtyChanges, oDirtyChange) {
		var that = this;

		return function() {
			if (oDirtyChange.getPendingAction() === "NEW") {
				Cache.addChange(that._mComponent, oDirtyChange.getDefinition());
			}

			if (oDirtyChange.getPendingAction() === "DELETE") {
				Cache.deleteChange(that._mComponent, oDirtyChange.getDefinition());
			}

			var iIndex = aDirtyChanges.indexOf(oDirtyChange);
			if (iIndex > -1) {
				aDirtyChanges.splice(iIndex, 1);
			}
		};
	};

	ChangePersistence.prototype._massUpdateCacheAndDirtyState = function (aDirtyChanges, aDirtyChangesClone) {
		var that = this;

		jQuery.each(aDirtyChangesClone, function (index, oDirtyChange) {
			that._updateCacheAndDirtyState(aDirtyChanges, oDirtyChange)();
		});
	};

	ChangePersistence.prototype._getRequests = function (aDirtyChanges) {
		var aRequests = [];

		jQuery.each(aDirtyChanges, function (index, oChange) {
			var sRequest = oChange.getRequest();
			if (aRequests.indexOf(sRequest) === -1) {
				aRequests.push(sRequest);
			}
		});

		return aRequests;
	};

	ChangePersistence.prototype._getPendingActions = function (aDirtyChanges) {
		var aPendingActions = [];

		jQuery.each(aDirtyChanges, function (index, oChange) {
			var sPendingAction = oChange.getPendingAction();
			if (aPendingActions.indexOf(sPendingAction) === -1) {
				aPendingActions.push(sPendingAction);
			}
		});

		return aPendingActions;
	};

	ChangePersistence.prototype._prepareDirtyChanges = function (aDirtyChanges) {
		var aChanges = [];

		jQuery.each(aDirtyChanges, function (index, oChange) {
			aChanges.push(oChange.getDefinition());
		});

		return aChanges;
	};

	ChangePersistence.prototype.getDirtyChanges = function() {
		return this._aDirtyChanges;
	};

	/**
	 * Prepares a change to be deleted with the next call to
	 * @see {ChangePersistence#saveDirtyChanges};
	 *
	 * If the given change is already in the dirty changes and
	 * has pending action 'NEW' it will be removed, assuming,
	 * it has just been created in the current session;
	 *
	 * Otherwise it will be marked for deletion.
	 *
	 * @param {sap.ui.fl.Change} oChange the change to be deleted
	 */
	ChangePersistence.prototype.deleteChange = function(oChange) {
		var nIndexInDirtyChanges = this._aDirtyChanges.indexOf(oChange);

		if (nIndexInDirtyChanges > -1) {
			if (oChange.getPendingAction() === "DELETE"){
				return;
			}
			this._aDirtyChanges.splice(nIndexInDirtyChanges, 1);
			this._deleteChangeInMap(oChange);
			return;
		}

		oChange.markForDeletion();
		this._aDirtyChanges.push(oChange);
		this._deleteChangeInMap(oChange);
	};

	/**
	 * Deletes a change object from the internal map.
	 *
	 * @param {sap.ui.fl.Change} oChange which has to be removed from the mapping
	 * @private
	 */
	ChangePersistence.prototype._deleteChangeInMap = function (oChange) {
		var sChangeKey = oChange.getKey();
		var mChanges = this._mChanges.mChanges;
		var mDependencies = this._mChanges.mDependencies;
		var mDependentChangesOnMe = this._mChanges.mDependentChangesOnMe;

		//mChanges
		Object.keys(mChanges).some(function (key) {
			var aChanges = mChanges[key];
			var nIndexInMapElement = aChanges
				.map(function(oExistingChange){
					return oExistingChange.getKey();
				}).indexOf(oChange.getKey());
			if (nIndexInMapElement !== -1) {
				aChanges.splice(nIndexInMapElement, 1);
				return true;
			}
		});

		//mDependencies
		Object.keys(mDependencies).forEach( function(key) {
			if (key === sChangeKey) {
				delete mDependencies[key];
			} else if ( mDependencies[key].dependencies
				&& jQuery.isArray(mDependencies[key].dependencies)
				&& mDependencies[key].dependencies.indexOf(sChangeKey) !== -1 ) {
				mDependencies[key].dependencies.splice(mDependencies[key].dependencies.indexOf(sChangeKey), 1);
				if (mDependencies[key].dependencies.length === 0) {
					delete mDependencies[key];
				}
			}
		});

		//mDependentChangesOnMe
		Object.keys(mDependentChangesOnMe).forEach( function(key) {
			if (key === sChangeKey) {
				delete mDependentChangesOnMe[key];
			} else if ( jQuery.isArray(mDependentChangesOnMe[key])
				&& mDependentChangesOnMe[key].indexOf(sChangeKey) !== -1 ) {
				mDependentChangesOnMe[key].splice(mDependentChangesOnMe[key].indexOf(sChangeKey), 1);
				if (mDependentChangesOnMe[key].length === 0) {
					delete mDependentChangesOnMe[key];
				}
			}
		});
	};

	return ChangePersistence;
}, true);

}; // end of sap/ui/fl/ChangePersistence.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.ChangePersistenceFactory') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.ChangePersistenceFactory'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/ChangePersistenceFactory",[
	"jquery.sap.global", "sap/ui/core/Component", "sap/ui/fl/ChangePersistence", "sap/ui/fl/Utils"
], function(jQuery, Component, ChangePersistence, Utils) {
	"use strict";

	/**
	 * Factory to get or create a new instances of {sap.ui.fl.ChangePersistence}
	 * @constructor
	 * @alias sap.ui.fl.ChangePersistenceFactory
	 * @experimental Since 1.27.0
	 * @author SAP SE
	 * @version 1.48.6
	 */
	var ChangePersistenceFactory = {};

	ChangePersistenceFactory._instanceCache = {};

	/**
	 * Creates or returns an instance of the ChangePersistence
	 * @param {String} sComponentName - Name of the component
	 * @param {String} sAppVersion - Current running version of application
	 * @returns {sap.ui.fl.ChangePersistence} <code>ChangePersistence<code> instance
	 *
	 * @public
	 */
	ChangePersistenceFactory.getChangePersistenceForComponent = function(sComponentName, sAppVersion) {
		var oChangePersistence;
		sAppVersion = sAppVersion || Utils.DEFAULT_APP_VERSION;

		if (!ChangePersistenceFactory._instanceCache[sComponentName]) {
			ChangePersistenceFactory._instanceCache[sComponentName] = {};
		}
		oChangePersistence = ChangePersistenceFactory._instanceCache[sComponentName][sAppVersion];
		if (!oChangePersistence) {
			var oComponent = {
				name : sComponentName,
				appVersion : sAppVersion
			};
			oChangePersistence = new ChangePersistence(oComponent);
			ChangePersistenceFactory._instanceCache[sComponentName][sAppVersion] = oChangePersistence;
		}

		return oChangePersistence;
	};

	/**
	 * Creates or returns an instance of the ChangePersistence for the component of the specified control.
	 * The control needs to be embedded into a component.
	 * @param {sap.ui.core.Control} oControl The control for example a SmartField, SmartGroup or View
	 * @returns {sap.ui.fl.ChangePersistence} instance
	 *
	 * @public
	 */
	ChangePersistenceFactory.getChangePersistenceForControl = function(oControl) {
		var sComponentId;
		sComponentId = this._getComponentClassNameForControl(oControl);
		var sAppVersion = Utils.getAppVersionFromManifest(Utils.getAppComponentForControl(oControl).getManifest());
		return ChangePersistenceFactory.getChangePersistenceForComponent(sComponentId, sAppVersion);
	};

	/**
	 * Returns the name of the component of the control
	 * @param {sap.ui.core.Control} oControl Control
	 * @returns {String} The name of the component. Undefined if no component was found
	 *
	 * @private
	 */
	ChangePersistenceFactory._getComponentClassNameForControl = function(oControl) {
		return Utils.getComponentClassName(oControl);
	};

	/**
	 * Registers the ChangePersistenceFactory._onLoadComponent to the Component loading functionality
	 *
	 * @since 1.38
	 * @private
	 */
	ChangePersistenceFactory.registerLoadComponentEventHandler = function () {
		Component._fnLoadComponentCallback = this._onLoadComponent.bind(this);
	};

	/**
	 * Processing of the load component, shared by _onLoadComponent and _getChangesForComponentAfterInstantiation.
	 *
	 * @param {object} oConfig - copy of the configuration of loaded component
	 * @param {object} oConfig.asyncHints - async hints passed from the app index to the core Component processing
	 * @param {object} oManifest - Manifest of the component
	 * @returns {object} Wrapper for oChangePersistence and oRequestOptions
	 * @since 1.43
	 * @private
	 */
	ChangePersistenceFactory._doLoadComponent = function (oConfig, oManifest) {
		var oChangePersistenceWrapper = {oChangePersistence: {}, oRequestOptions: {}};
		var sComponentName = Utils.getFlexReference(oManifest);
		var sAppVersion = Utils.getAppVersionFromManifest(oManifest);
		var sMaxLayer, oStartupParameters, oTechnicalParameters;

		oStartupParameters = oConfig && oConfig.componentData && oConfig.componentData.startupParameters || {};
		oTechnicalParameters = oConfig && oConfig.componentData && oConfig.componentData.technicalParameters;

		if (oStartupParameters["sap-app-id"] && oStartupParameters["sap-app-id"].length === 1) {
			// deprecated app variant id support with no caching
			sComponentName = oStartupParameters["sap-app-id"][0];
		} else {
			if (oConfig) {
				var aAsyncHints = oConfig.asyncHints;
				if (aAsyncHints && aAsyncHints.requests && Array.isArray(aAsyncHints.requests)) {
					var oFlAsyncHint = this._findFlAsyncHint(aAsyncHints.requests);
					if (oFlAsyncHint && sComponentName === oFlAsyncHint.reference) {
						oChangePersistenceWrapper.oRequestOptions.cacheKey = oFlAsyncHint.cachebusterToken || "<NO CHANGES>";
					}
				}
			}
		}
		//Checks technicalParameters/startup (old) parameter for sap-ui-fl-max-layer value
		var oMaxLayerParameters = oTechnicalParameters || oStartupParameters;
		if (oMaxLayerParameters && oMaxLayerParameters["sap-ui-fl-max-layer"] && oMaxLayerParameters["sap-ui-fl-max-layer"].length === 1) {
			sMaxLayer = oMaxLayerParameters["sap-ui-fl-max-layer"][0];
		}
		Utils.setMaxLayerParameter(sMaxLayer);

		oChangePersistenceWrapper.oRequestOptions.siteId = Utils.getSiteIdByComponentData(oConfig.componentData);
		oChangePersistenceWrapper.oChangePersistence = this.getChangePersistenceForComponent(sComponentName, sAppVersion);

		return oChangePersistenceWrapper;
	};

	/**
	 * Callback which is called within the early state of Component processing.
	 * Already triggers the loading of the flexibility changes if the loaded manifest is an application variant.
	 *
	 * @param {object} oConfig - copy of the configuration of loaded component
	 * @param {object} oConfig.asyncHints - async hints passed from the app index to the core Component processing
	 * @param {object} oManifest - copy of the manifest of loaded component
	 * @param {object} oManifest."sap.app"
	 * @param {string} oManifest."sap.app".type - type of the component (i.e. "application").
	 * The processing is only done for components of the type "application"
	 * @since 1.38
	 * @private
	 */
	ChangePersistenceFactory._onLoadComponent = function (oConfig, oManifest) {

		// stop processing if the component is not of the type application
		if (!Utils.isApplication(oManifest)) {
			return;
		}

		var oChangePersistenceWrapper = this._doLoadComponent(oConfig, oManifest);

		oChangePersistenceWrapper.oChangePersistence.getChangesForComponent(oChangePersistenceWrapper.oRequestOptions);
	};

	/**
	 * Callback which is called within the early state of Component instantiation.
	 *
	 * @param {object} oConfig - copy of the configuration of loaded component
	 * @param {object} oConfig.asyncHints - async hints passed from the app index to the core Component processing
	 * @param {object} oManifest - copy of the manifest of loaded component
	 * @param {object} oManifest."sap.app"
	 * @param {string} oManifest."sap.app".type - type of the component (i.e. "application").
	 * @param {object} oComponent Component instance
	 * The processing is only done for components of the type "application"
	 * @returns {Promise} Promise resolving after the changes are loaded with a getter to retrieve the mapped changes.
	 * @since 1.43
	 * @private
	 */
	ChangePersistenceFactory._getChangesForComponentAfterInstantiation = function (oConfig, oManifest, oComponent) {

		// stop processing if the component is not of the type application
		if (!Utils.isApplication(oManifest)) {
			return Promise.resolve(function() {
				return {
					mChanges: {},
					mDependencies: {},
					mDependentChangesOnMe: {}
				};
			});
		}

		var oChangePersistenceWrapper = this._doLoadComponent(oConfig, oManifest);

		return oChangePersistenceWrapper.oChangePersistence.loadChangesMapForComponent(oComponent, oChangePersistenceWrapper.oRequestOptions);
	};

	ChangePersistenceFactory._findFlAsyncHint = function (oAsyncHintRequest) {
		var that = this;
		var oFlAsyncHint;

		jQuery.each(oAsyncHintRequest, function (nIndex, oAsyncHint) {
			if (that._flAsyncHintMatches(oAsyncHint)) {
				oFlAsyncHint = oAsyncHint;
				return false; // break forEach
			}
		});

		return oFlAsyncHint;
	};

	ChangePersistenceFactory._flAsyncHintMatches = function (oAsyncHintRequest) {
		return oAsyncHintRequest.name === "sap.ui.fl.changes";
	};

	return ChangePersistenceFactory;
}, true);

}; // end of sap/ui/fl/ChangePersistenceFactory.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.DefaultVariant') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.DefaultVariant'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/DefaultVariant",[
	"jquery.sap.global", "sap/ui/fl/Change"
], function($, Change) {
	"use strict";

	/**
	 * DefaultVariant handles default variant changes without keeping control specific state.
	 *        It knows how to create a default variant change, how to retrieve the default variant id from a given list of changes, etc.
	 * @constructor
	 * @alias sap.ui.fl.DefaultVariant
	 * @author SAP SE
	 *
	 * @version 1.48.6
	 *
	 * @experimental Since 1.25.0
	 */
	var DefaultVariant = function() {

	};

	/**
	 * Returns the id of the default variant. Returns an empty string if there is no default variant.
	 *
	 * @param {object} mChanges Map containing multiple change files.
	 *
	 * @returns {String} default variant id
	 *
	 * @public
	 */
	DefaultVariant.prototype.getDefaultVariantId = function(mChanges) {
		var defaultVariantChange = this.getNewestDefaultVariantChangeDeleteTheRest(mChanges);

		if (defaultVariantChange) {
			return defaultVariantChange.getContent().defaultVariantName;
		}

		return "";
	};

	/**
	 * Returns the newest default variant change and marks the rest for deletion.
	 * A change with an empty string as creation is considered newer
	 * than a change with an iso date string. If multiple changes
	 * have an empty string, order is not guaranteed. That is a case
	 * that should not happen.
	 *
	 * @param {object} mChanges map containing multiple change files.
	 *
	 * @returns {array} default variant changes
	 *
	 * @public
	 */
	DefaultVariant.prototype.getNewestDefaultVariantChangeDeleteTheRest = function(mChanges) {
		var aChanges = this.getDefaultVariantChanges(mChanges).sort(function(a, b) {
			var aDate = new Date(a.getCreation());
			var bDate = new Date(b.getCreation());

			if (isNaN(aDate.getDate())) {
				return -1;
			}

			if (isNaN(bDate.getDate())) {
				return 1;
			}

			return bDate - aDate;
		});

		var oNewestChange = aChanges.shift();

		aChanges.forEach(function(oChange) {
			oChange.markForDeletion();
		});

		return oNewestChange;
	};

	/**
	 * Returns all default variant changes within the given map of changes
	 *
	 * @param {object} mChanges - map containing multiple change files.
	 *
	 * @returns {array} default variant changes
	 *
	 * @public
	 */
	DefaultVariant.prototype.getDefaultVariantChanges = function(mChanges) {
		if (!mChanges || typeof mChanges !== 'object') {
			return [];
		}

		return Object.keys(mChanges).map(changeIdsToChanges).filter(defaultVariantChanges);

		function changeIdsToChanges(sChangeId) {
			return mChanges[sChangeId];
		}

		function defaultVariantChanges(oChange) {
			return oChange.getChangeType() === 'defaultVariant';
		}

	};

	/**
	 * Updates the default variant id, if the given list of changes contains a default variant change.
	 * Only the newest is updated, the rest is marked for deletion.
	 *
	 * @param {object} mChanges map of changes
	 * @param {string} sNewDefaultVariantId the new default variant id
	 * @returns {object} the updated change, undefined if non was found
	 *
	 * @public
	 */
	DefaultVariant.prototype.updateDefaultVariantId = function(mChanges, sNewDefaultVariantId) {
		var oNewsetChange = this.getNewestDefaultVariantChangeDeleteTheRest(mChanges);

		if (oNewsetChange) {
			oNewsetChange.getContent().defaultVariantName = sNewDefaultVariantId;
		}

		return oNewsetChange;
	};

	/**
	 * Creates the JSON content of a new change file, specifying the new default variant
	 *
	 * @param {object} mParameters map of parameters, see below
	 * @param {String} mParameters.defaultVariantName - id of the new default variant
	 * @param {String} mParameters.component - name of the UI5 component
	 * @param {object} mParameters.selector - stable propertyName:propertyValue
	 *
	 * @returns {Object} default variant change
	 *
	 * @private
	 */
	DefaultVariant.prototype._createChangeFile = function(mParameters) {
		var oFileData;

		mParameters.namespace = mParameters.component + '/changes/default';
		mParameters.componentName = mParameters.component;
		mParameters.changeType = 'defaultVariant';

		oFileData = Change.createInitialFileContent(mParameters);

		oFileData.content.defaultVariantName = mParameters.defaultVariantId;
		oFileData.layer = 'USER';

		return oFileData;
	};

	/**
	 * Creates an instance of {sap.ui.fl.Change}, specifying the new default variant
	 *
	 * @param {object} mParameters - map of parameters, see below
	 * @param {String} mParameters.defaultVariantName - id of the new default variant
	 * @param {String} mParameters.component - name of the UI5 component
	 * @param {object} mParameters.selector - stable propertyName:propertyValue
	 * @returns {sap.ui.fl.Change} Change
	 *
	 * @public
	 */
	DefaultVariant.prototype.createChangeObject = function(mParameters) {
		var oFileContent, oChange;

		oFileContent = this._createChangeFile(mParameters);
		oChange = new Change(oFileContent);

		return oChange;
	};

	return new DefaultVariant();
}, /* bExport= */true);

}; // end of sap/ui/fl/DefaultVariant.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.FakeLrepConnector') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.FakeLrepConnector'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.URI'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/FakeLrepConnector",[
	"jquery.sap.global", "sap/ui/thirdparty/URI", "sap/ui/fl/Utils", "sap/ui/fl/LrepConnector", "sap/ui/fl/Cache", "sap/ui/fl/ChangePersistenceFactory"
], function(jQuery, uri, FlexUtils, LrepConnector, Cache, ChangePersistenceFactory) {
	"use strict";
	var oLrepConnector = Object.create(LrepConnector.prototype);
	FakeLrepConnector._oBackendInstances = {};

	/**
	 * Please use the @link {FakeLrepConnector#enableFakeConnector} function
	 * to enable the FakeLrepConnector.
	 *
	 * Provides a fake implementation for the sap.ui.fl.LrepConnector
	 * @param {String} sInitialComponentJsonPath - the relative path to a test-component-changes.json file
	 *
	 * @constructor
	 * @alias sap.ui.fl.FakeLrepConnector
	 * @experimental Since 1.27.0
	 * @author SAP SE
	 * @version 1.48.6
	 */
	function FakeLrepConnector(sInitialComponentJsonPath){
		this.sInitialComponentJsonPath = sInitialComponentJsonPath;
	}

	for (var prop in oLrepConnector){
		if (typeof oLrepConnector[prop] === 'function'){
			/*eslint-disable noinspection, no-loop-func */
			FakeLrepConnector.prototype[prop] = (function(prop){
				return function() {
					throw new Error('Method ' + prop + '() is not implemented in FakeLrepConnector.');
				};
			}(prop));
			/*eslint-enable noinspection, no-loop-func */
		}
	}

	FakeLrepConnector.prototype.loadChanges = function(sComponentClassName){
		var initialComponentJsonPath = this.sInitialComponentJsonPath;

		return new Promise(function(resolve, reject){
			jQuery.getJSON(initialComponentJsonPath).done(function(oResponse){
				var result = {
					changes: oResponse,
					componentClassName: sComponentClassName
				};

				resolve(result);
			}).fail(function(error){
				reject(error);
			});
		});
	};

	FakeLrepConnector.prototype.create = function(payload, changeList, isVariant){
		// REVISE ensure old behavior for now, but check again for changes
		if (!isVariant){
			return Promise.resolve();
		}

		if (!payload.creation){
			payload.creation = new Date().toISOString();
		}

		return Promise.resolve({
			response: payload,
			status: 'success'
		});
	};

	FakeLrepConnector.prototype.update = function(payload, changeName, changelist, isVariant) {
		// REVISE ensure old behavior for now, but check again for changes
		if (!isVariant){
			return Promise.resolve();
		}

		return Promise.resolve({
			response: payload,
			status: 'success'
		});
	};

	FakeLrepConnector.prototype.deleteChange = function(params, isVariant){
		// REVISE ensure old behavior for now, but check again for changes
		if (!isVariant){
			return Promise.resolve();
		}

		return Promise.resolve({
			response: undefined,
			status: 'nocontent'
		});
	};

	FakeLrepConnector.prototype.send = function(sUri, sMethod, oData, mOptions){
		return new Promise(function(resolve, reject){
			handleGetTransports(sUri, sMethod, oData, mOptions, resolve, reject);
			handleMakeChangesTransportable(sUri, sMethod, oData, mOptions, resolve, reject);
		});
	};

	function handleMakeChangesTransportable(sUri, sMethod, oData, mOptions, resolve){
		if (sUri.match(/^\/sap\/bc\/lrep\/actions\/make_changes_transportable\//) && sMethod === 'POST'){
			resolve();
		}
	}

	//REVISE Make response configurable
	function handleGetTransports(sUri, sMethod, oData, mOptions, resolve, reject){
		if (sUri.match(/^\/sap\/bc\/lrep\/actions\/gettransports\//)){
			resolve({
				response: {
					"transports": [
						{
							"transportId": "U31K008488",
							"description": "The Ultimate Transport",
							"owner": "Fantasy Owner",
							"locked": false
						}
					],
					"localonly": false,
					"errorCode": ""
				}
			});
		}
	}

	/**
	 * Enables fake LRep connector.
	 *
	 * If the <code>sAppComponentName<code> is provided, replaces the connector of corresponding @link {sap.ui.fl.ChangePersistence} by a fake one.
	 * Otherwise, hooks into the @link {sap.ui.fl.LrepConnector.createConnector} factory function to enable the fake LRep connector. After enabling fake LRep connector,
	 * the original connector can be restored by calling function @link {sap.ui.fl.FakeLrepConnector.disableFakeConnector}.
	 *
	 * @param {string} sInitialComponentJsonPath - Relative path to a test-component-changes.json file
	 * @param {string} [sAppComponentName] - Name of application component to overwrite the existing LRep connector
	 * @param {string} [sAppVersion] - Version of application to overwrite the existing LRep connector
	 */
	FakeLrepConnector.enableFakeConnector = function(sInitialComponentJsonPath, sAppComponentName, sAppVersion){

		if (sAppComponentName && sAppVersion) {
			var oChangePersistence = ChangePersistenceFactory.getChangePersistenceForComponent(sAppComponentName, sAppVersion);
			if (!(oChangePersistence._oConnector instanceof FakeLrepConnector)){
				Cache.clearEntry(sAppComponentName, sAppVersion);
				if (!FakeLrepConnector._oBackendInstances[sAppComponentName]){
					FakeLrepConnector._oBackendInstances[sAppComponentName] = {};
				}
				FakeLrepConnector._oBackendInstances[sAppComponentName][sAppVersion] = oChangePersistence._oConnector;
				oChangePersistence._oConnector = new FakeLrepConnector(sInitialComponentJsonPath);
			}
			return;
		}

		Cache.clearEntries();

		if (FakeLrepConnector.enableFakeConnector.original){
			return;
		}

		FakeLrepConnector.enableFakeConnector.original = LrepConnector.createConnector;

		LrepConnector.createConnector = function(){
			if (!FakeLrepConnector._oFakeInstance){
				FakeLrepConnector._oFakeInstance = new FakeLrepConnector(sInitialComponentJsonPath);
			}
			return FakeLrepConnector._oFakeInstance;
		};
	};

	/**
	 * If the <code>sAppComponentName<code> is provided, restores the connector of corresponding @link {sap.ui.fl.ChangePersistence} by the original instance.
	 * Otherwise, restores the original @link {sap.ui.fl.LrepConnector.createConnector} factory function.
	 *
	 * @param {string} [sAppComponentName] - Name of application component to restore the original LRep connector
	 * @param {string} [sAppVersion] - Version of application to restore the original LRep connector
	 */
	FakeLrepConnector.disableFakeConnector = function(sAppComponentName, sAppVersion){

		if (sAppComponentName && sAppVersion) {
			var oChangePersistence = ChangePersistenceFactory.getChangePersistenceForComponent(sAppComponentName, sAppVersion);
			if (!(oChangePersistence._oConnector instanceof LrepConnector)) {
				Cache.clearEntry(sAppComponentName, sAppVersion);
				if (FakeLrepConnector._oBackendInstances[sAppComponentName] && FakeLrepConnector._oBackendInstances[sAppComponentName][sAppVersion]) {
					oChangePersistence._oConnector = FakeLrepConnector._oBackendInstances[sAppComponentName][sAppVersion];
					FakeLrepConnector._oBackendInstances[sAppComponentName][sAppVersion] = undefined;
				}
			}
			return;
		}

		Cache.clearEntries();

		if (FakeLrepConnector.enableFakeConnector.original){
			LrepConnector.createConnector = FakeLrepConnector.enableFakeConnector.original;
			FakeLrepConnector.enableFakeConnector.original = undefined;
			FakeLrepConnector._oFakeInstance = undefined;
		}
	};

	return FakeLrepConnector;

}, true);

}; // end of sap/ui/fl/FakeLrepConnector.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.FakeLrepConnectorLocalStorage') ) {
/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.FakeLrepConnectorLocalStorage'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/FakeLrepConnectorLocalStorage",[
	"sap/ui/fl/FakeLrepLocalStorage",
	"sap/ui/fl/FakeLrepConnector",
	"sap/ui/fl/LrepConnector",
	"sap/ui/fl/Cache",
	"sap/ui/fl/ChangePersistenceFactory"
	], function(
	FakeLrepLocalStorage, FakeLrepConnector, LrepConnector, Cache, ChangePersistenceFactory) {
	"use strict";

	FakeLrepConnectorLocalStorage._oBackendInstances = {};

	/**
	 * Class for connecting to Fake LREP storing changes in localStorage
	 *
	 * @class
	 *
	 * @author SAP SE
	 * @version 1.48.6
	 *
	 * @private
	 * @static
	 * @since 1.48
	 * @alias sap.ui.fl.FakeLrepConnectorLocalStorage
	 */
	function FakeLrepConnectorLocalStorage(mSettings){
		this.mSettings = jQuery.extend({
			"isKeyUser": true,
			"isAtoAvailable": false,
			"isProductiveSystem": false
		}, mSettings);
	}

	jQuery.extend(FakeLrepConnectorLocalStorage.prototype, FakeLrepConnector.prototype);

	/**
	 * Creates a Fake Lrep change in localStorage
	 * @param  {Object|Array} vChangeDefinitions - single or multiple changeDefinitions
	 * @returns {Promise} Returns a promise to the result of the request
	 */
	FakeLrepConnectorLocalStorage.prototype.create = function(vChangeDefinitions) {
		var response;
		if (Array.isArray(vChangeDefinitions)) {
			response = vChangeDefinitions.map(function(mChangeDefinition) {
				return this._saveChange(mChangeDefinition);
			}.bind(this));
		} else {
			response = this._saveChange(vChangeDefinitions);
		}

		return Promise.resolve({
			response: response,
			status: 'success'
		});
	};

	FakeLrepConnectorLocalStorage.prototype._saveChange = function(mChangeDefinition) {
		if (!mChangeDefinition.creation){
			mChangeDefinition.creation = new Date().toISOString();
		}
		FakeLrepLocalStorage.saveChange(mChangeDefinition.fileName, mChangeDefinition);
		return mChangeDefinition;
	};


	FakeLrepConnectorLocalStorage.prototype.update = function(mChangeDefinition, sChangeName, aChangelist, bIsVariant) {
		return Promise.resolve({
			response: this._saveChange(mChangeDefinition),
			status: 'success'
		});
	};

	/**
	 * Deletes a Fake Lrep change in localStorage
	 * @param  {Object} oChange - the change Object
	 * @returns {Promise} Returns a promise to the result of the request
	 */
	FakeLrepConnectorLocalStorage.prototype.deleteChange = function(oChange) {

		FakeLrepLocalStorage.deleteChange(oChange.fileName);

		return Promise.resolve({
			response: undefined,
			status: "nocontent"
		});
	};

	/**
	 * Deletes all Fake Lrep changes in localStorage
	 * @returns {Promise} Returns a promise to the result of the request
	 */
	FakeLrepConnectorLocalStorage.prototype.deleteChanges = function() {

		FakeLrepLocalStorage.deleteChanges();

		return Promise.resolve({
			response: undefined,
			status: "nocontent"
		});
	};

	/**
	 * Loads the changes for the given Component class name
	 * from the FakeLrepLocalStorage
	 * and also loads the mandatory FakeLrepConnector.json file.
	 * The settings are take from the JSON file, but changes are replaced with
	 * the changes from the local storage.
	 *
	 * @param {String} sComponentClassName - Component class name
	 * @returns {Promise} Returns a Promise with the changes and componentClassName
	 * @public
	 */
	FakeLrepConnectorLocalStorage.prototype.loadChanges = function(sComponentClassName) {

		var aChanges = FakeLrepLocalStorage.getChanges();

		return new Promise(function(resolve, reject){
			var result = {
				changes: {
					changes : aChanges,
					settings : this.mSettings
				},
				componentClassName: sComponentClassName
			};
			resolve(result);
		}.bind(this));

	};

	/**
	 * Enables fake LRep connector.
	 *
	 * If the <code>sAppComponentName<code> is provided, replaces the connector of corresponding @link {sap.ui.fl.ChangePersistence} by a fake one.
	 * Otherwise, hooks into the @link {sap.ui.fl.LrepConnector.createConnector} factory function to enable the fake LRep connector.After enabling fake LRep connector,
	 * the original connector can be restored by calling function @link {sap.ui.fl.FakeLrepConnectorLocalStorage.disableFakeConnector}.
	 *
	 * @param {object} [mSettings] - map of FakeLrepConnector settings
	 * @param {string} [sAppComponentName] - Name of application component to overwrite the existing LRep connector
	 * @param {string} [sAppVersion] - Version of application to overwrite the existing LRep connector
	 */
	FakeLrepConnectorLocalStorage.enableFakeConnector = function(mSettings, sAppComponentName, sAppVersion){
		mSettings = mSettings || {};

		if (sAppComponentName && sAppVersion) {
			var oChangePersistence = ChangePersistenceFactory.getChangePersistenceForComponent(sAppComponentName, sAppVersion);
			if (!(oChangePersistence._oConnector instanceof FakeLrepConnectorLocalStorage)) {
				Cache.clearEntry(sAppComponentName, sAppVersion);
				if (!FakeLrepConnectorLocalStorage._oBackendInstances[sAppComponentName]){
					FakeLrepConnectorLocalStorage._oBackendInstances[sAppComponentName] = {};
				}
				FakeLrepConnectorLocalStorage._oBackendInstances[sAppComponentName][sAppVersion] = oChangePersistence._oConnector;
				oChangePersistence._oConnector = new FakeLrepConnectorLocalStorage(mSettings);
			}
			return;
		}

		Cache.clearEntries();

		if (FakeLrepConnectorLocalStorage.enableFakeConnector.original){
			return;
		}

		FakeLrepConnectorLocalStorage.enableFakeConnector.original = LrepConnector.createConnector;

		LrepConnector.createConnector = function() {
			if (!FakeLrepConnectorLocalStorage._oFakeInstance){
				FakeLrepConnectorLocalStorage._oFakeInstance = new FakeLrepConnectorLocalStorage(mSettings);
			}
			return FakeLrepConnectorLocalStorage._oFakeInstance;
		};
	};

	/**
	 * If the <code>sAppComponentName<code> is provided, restores the connector of corresponding @link {sap.ui.fl.ChangePersistence} by the original instance.
	 * Otherwise, restores the original @link {sap.ui.fl.LrepConnector.createConnector} factory function.
	 *
	 * @param {string} [sAppComponentName] - Name of application component to restore the original LRep connector
	 * @param {string} [sAppVersion] - Version of application to restore the original LRep connector
	 */
	FakeLrepConnectorLocalStorage.disableFakeConnector = function(sAppComponentName, sAppVersion){

		if (sAppComponentName && sAppVersion) {
			var oChangePersistence = ChangePersistenceFactory.getChangePersistenceForComponent(sAppComponentName, sAppVersion);
			if (!(oChangePersistence._oConnector instanceof LrepConnector)){
				Cache.clearEntry(sAppComponentName, sAppVersion);
				if (FakeLrepConnectorLocalStorage._oBackendInstances[sAppComponentName] && FakeLrepConnectorLocalStorage._oBackendInstances[sAppComponentName][sAppVersion]) {
					oChangePersistence._oConnector = FakeLrepConnectorLocalStorage._oBackendInstances[sAppComponentName][sAppVersion];
					FakeLrepConnectorLocalStorage._oBackendInstances[sAppComponentName][sAppVersion] = undefined;
				}
			}
			return;
		}

		Cache.clearEntries();

		if (FakeLrepConnectorLocalStorage.enableFakeConnector.original){
			LrepConnector.createConnector = FakeLrepConnectorLocalStorage.enableFakeConnector.original;
			FakeLrepConnectorLocalStorage.enableFakeConnector.original = undefined;
			FakeLrepConnectorLocalStorage._oFakeInstance = undefined;
		}
	};

	return FakeLrepConnectorLocalStorage;

}, /* bExport= */ true);
}; // end of sap/ui/fl/FakeLrepConnectorLocalStorage.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.StandardVariant') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.StandardVariant'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/StandardVariant",[
	"jquery.sap.global", "sap/ui/fl/Change"
], function($, Change) {
	"use strict";

	/**
	 * StandardVariant handles the execute on select flag for the standard variant.
	 *        It knows how to create an execute on select for standard variant change, how to retrieve it from a given list of changes, etc.
	 * @constructor
	 * @alias sap.ui.fl.StandardVariant
	 * @author SAP SE
	 *
	 * @version 1.48.6
	 *
	 * @experimental Since 1.38.0
	 */
	var StandardVariant = function() {

	};

	/**
	 * Returns the execute on select flag of the standard variant. Returns <code>false</code> if there is no flag set.
	 *
	 * @param {object} mChanges Map containing multiple change files.
	 *
	 * @returns {boolean} execute on select for standard variant
	 *
	 * @public
	 */
	StandardVariant.prototype.getExecuteOnSelect = function(mChanges) {
		var StandardVariantChange = this.getNewestStandardVariantChangeDeleteTheRest(mChanges);

		if (StandardVariantChange) {
			return StandardVariantChange.getContent().executeOnSelect;
		}

		return null;
	};

	/**
	 * Returns the newest standard variant change and marks the rest for deletion.
	 * A change with an empty string as creation is considered newer
	 * than a change with an iso date string. If multiple changes
	 * have an empty string, order is not guaranteed. That is a case
	 * that should not happen.
	 *
	 * @param {object} mChanges map containing multiple change files.
	 *
	 * @returns {array} default variant changes
	 *
	 * @public
	 */
	StandardVariant.prototype.getNewestStandardVariantChangeDeleteTheRest = function(mChanges) {
		var aChanges = this.getStandardVariantChanges(mChanges).sort(function(a, b) {
			var aDate = new Date(a.getCreation());
			var bDate = new Date(b.getCreation());

			if (isNaN(aDate.getDate())) {
				return -1;
			}

			if (isNaN(bDate.getDate())) {
				return 1;
			}

			return bDate - aDate;
		});

		var oNewestChange = aChanges.shift();

		aChanges.forEach(function(oChange) {
			oChange.markForDeletion();
		});

		return oNewestChange;
	};

	/**
	 * Returns all standard variant changes within the given map of changes
	 *
	 * @param {object} mChanges - map containing multiple change files.
	 *
	 * @returns {array} default variant changes
	 *
	 * @public
	 */
	StandardVariant.prototype.getStandardVariantChanges = function(mChanges) {
		if (!mChanges || typeof mChanges !== 'object') {
			return [];
		}

		return Object.keys(mChanges).map(changeIdsToChanges).filter(StandardVariantChanges);

		function changeIdsToChanges(sChangeId) {
			return mChanges[sChangeId];
		}

		function StandardVariantChanges(oChange) {
			return oChange.getChangeType() === 'standardVariant';
		}

	};

	/**
	 * Updates the execute on select variant , if the given list of changes contains a default variant change.
	 * Only the newest is updated, the rest is marked for deletion.
	 *
	 * @param {object} mChanges map of changes
	 * @param {boolean} bNewExecuteOnSelect the new execute on select flag
	 * @returns {object} the updated change, undefined if non was found
	 *
	 * @public
	 */
	StandardVariant.prototype.updateExecuteOnSelect = function(mChanges, bNewExecuteOnSelect) {
		var oNewsetChange = this.getNewestStandardVariantChangeDeleteTheRest(mChanges);

		if (oNewsetChange) {
			oNewsetChange.getContent().executeOnSelect = bNewExecuteOnSelect;
		}

		return oNewsetChange;
	};

	/**
	 * Creates the JSON content of a new change file, specifying the new standard variant
	 *
	 * @param {object} mParameters map of parameters, see below
	 * @param {boolean} mParameters.executeOnSelect - execute flag of the standard variant
	 * @param {String} mParameters.component - name of the UI5 component
	 * @param {object} mParameters.selector - stable propertyName:propertyValue
	 *
	 * @returns {Object} standard variant change
	 *
	 * @private
	 */
	StandardVariant.prototype._createChangeFile = function(mParameters) {
		var oFileData;

		mParameters.namespace = mParameters.component + '/changes/standard';
		mParameters.componentName = mParameters.component;
		mParameters.changeType = 'standardVariant';

		oFileData = Change.createInitialFileContent(mParameters);

		oFileData.content.executeOnSelect = mParameters.executeOnSelect;
		oFileData.layer = 'USER';

		return oFileData;
	};

	/**
	 * Creates an instance of {sap.ui.fl.Change}, specifying the new standard variant
	 *
	 * @param {object} mParameters - map of parameters, see below
	 * @param {boolean} mParameters.executeOnSelect - execute flag of the standard variant
	 * @param {String} mParameters.component - name of the UI5 component
	 * @param {object} mParameters.selector - stable propertyName:propertyValue
	 * @returns {sap.ui.fl.Change} Change
	 *
	 * @public
	 */
	StandardVariant.prototype.createChangeObject = function(mParameters) {
		var oFileContent, oChange;

		oFileContent = this._createChangeFile(mParameters);
		oChange = new Change(oFileContent);

		return oChange;
	};

	return new StandardVariant();
}, /* bExport= */true);

}; // end of sap/ui/fl/StandardVariant.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.codeExt.CodeExtManager') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.codeExt.CodeExtManager'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/codeExt/CodeExtManager",[
	"sap/ui/fl/LrepConnector", "sap/ui/fl/Utils", "sap/ui/fl/Change"
], function(LrepConnector, Utils, Change) {
	"use strict";

	/**
	 * Helper object to process code extension changes
	 *
	 * @namespace
	 * @alias sap.ui.fl.codeExt.CodeExtManager
	 * @since 1.40.0
	 * @author SAP SE
	 * @version 1.48.6
	 */
	var CodeExtManager;

	CodeExtManager = {

		_oLrepConnector: new LrepConnector(),

		/**
		 * @param {string} oPropertyBag.id - change Id if not present it will be generated
		 * @param {string} oPropertyBag.codeRef - relative path of code file
		 * @param {string} oPropertyBag.controllerName - controller name
		 * @param {string} oPropertyBag.appVariantId - appVariantId or componentName in which the context is present
		 * @param {string} mOptions.transportId - Id of ABAP Transport which CodeExt change assigned to
		 * @param {string} mOptions.packageName - Name of ABAP Package which CodeExt change assigned to
		 */
		createOrUpdateCodeExtChange: function(oPropertyBag, mOptions) {

			if (!oPropertyBag.content || !oPropertyBag.content.codeRef) {
				throw new Error("no code reference passed for the code extension change");
			}
			if (!oPropertyBag.selector || !oPropertyBag.selector.id) {
				throw new Error("no controller name passed for the code extension change");
			}

			if (!oPropertyBag.reference) {
				throw new Error("no reference passed for the code extension change");
			}

			oPropertyBag.changeType = oPropertyBag.changeType || "codeExt";

			var oChange = Change.createInitialFileContent(oPropertyBag);

			var sUri = "/sap/bc/lrep/content/" + oChange.namespace + oChange.fileName + ".change";
			sUri += "?layer=" + oChange.layer;
			if (mOptions){
				if (mOptions.transportId){
					sUri += "&changelist=" + mOptions.transportId;
				}
				if (mOptions.packageName){
					sUri += "&package=" + mOptions.packageName;
				}
			}
			var sMethod = "PUT";
			return this._oLrepConnector.send(sUri, sMethod, oChange, {});
		},

		/**
		 * @param {array} aChanges - list of changes need to be created
		 * @param {string} mOptions.codeRef - code reference which changes are associated with
		 * @param {string} mOptions.transportId - id of ABAP transport on which the change is assigned to
		 * @param {string} mOptions.packageName - name of ABAP package on which the change is assigned to
		 */
		createCodeExtChanges: function(aChanges, mOptions) {
			aChanges = aChanges || [];
			if (aChanges.length === 0) {
				return Promise.resolve();
			}

			var aPreparedChanges = [];
			aChanges.forEach(function(oChange){
				oChange.changeType = oChange.changeType || "codeExt";
				oChange.packageName = mOptions.packageName;
				oChange.content = {
						codeRef: mOptions.codeRef
				};
				aPreparedChanges.push(Change.createInitialFileContent(oChange));
			});

			return this._oLrepConnector.create(aPreparedChanges, mOptions.transportId);
		},

		/**
		 * @param {sap.ui.fl.Change} oChange
		 * @param {string} mOptions.transportId - Id of ABAP Transport which CodeExt change assigned to
		 * @param {string} mOptions.packageName - Name of ABAP Package which CodeExt change assigned to
		 */
		deleteCodeExtChange: function(oChange, mOptions) {
			if (oChange.changeType !== "codeExt" || oChange.fileType !== "change") {
				throw new Error("the change is not of type 'code extension'");
			}

			if (!oChange.fileName) {
				throw new Error("the extension does not contains a file name");
			}

			if (oChange.namespace === undefined) {
				throw new Error("the extension does not contains a namespace");
			}

			var sUri = "/sap/bc/lrep/content/" + oChange.namespace + oChange.fileName + ".change";
			if (oChange.layer) {
				sUri += "&layer=" + oChange.layer;
			}
			if (mOptions){
				if (mOptions.transportId){
					sUri += "&changelist=" + mOptions.transportId;
				}
				if (mOptions.packageName){
					sUri += "&package=" + mOptions.packageName;
				}
			}
			sUri = sUri.replace("&", "?");
			var sMethod = "DELETE";
			return this._oLrepConnector.send(sUri, sMethod, oChange, {});
		}
	};

	return CodeExtManager;

}, true);

}; // end of sap/ui/fl/codeExt/CodeExtManager.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.descriptorRelated.api.DescriptorChangeFactory') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.fl.descriptorRelated.api.DescriptorChangeFactory'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory",[
	"sap/ui/fl/ChangePersistenceFactory",
	"sap/ui/fl/ChangePersistence",
	"sap/ui/fl/Change",
	"sap/ui/fl/descriptorRelated/internal/Utils",
	"sap/ui/fl/registry/Settings",
	"sap/ui/fl/Utils"
], function(ChangePersistenceFactory, ChangePersistence, Change, Utils, Settings, FlexUtils) {
	"use strict";

	/**
	 * Descriptor Related
	 * @namespace
	 * @name sap.ui.fl.descriptorRelated
	 * @author SAP SE
	 * @version 1.48.6
	 * @private
	 * @sap-restricted
	 */

	/**
	 * Descriptor Related Apis
	 * @namespace
	 * @name sap.ui.fl.descriptorRelated.api
	 * @author SAP SE
	 * @version 1.48.6
	 * @private
	 * @sap-restricted
	 */

	/**
	 * Descriptor Change
	 *
	 * @param {object} mChangeFile change file
	 * @param {sap.ui.fl.descriptorRelated.api.DescriptorInlineChange} oInlineChange inline change object
	 * @param {sap.ui.fl.registry.Settings} oSettings settings
	 *
	 * @constructor
	 * @alias sap.ui.fl.descriptorRelated.api.DescriptorChange
	 * @author SAP SE
	 * @version 1.48.6
	 * @private
	 * @sap-restricted
	 */
	var DescriptorChange = function(mChangeFile,oInlineChange,oSettings) { //so far, parameter correspond to inline change format
		this._mChangeFile = mChangeFile;
		this._mChangeFile.packageName = '$TMP';
		this._oInlineChange = oInlineChange;
		this._sTransportRequest = null;
		this._oSettings = oSettings;
	};

	/**
	 * Set transport request (for ABAP Backend)
	 *
	 * @param {string} sTransportRequest transport request
	 *
	 * @return {Promise} resolving when setting of transport request was successful
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorChange.prototype.setTransportRequest = function(sTransportRequest) {
		try {
			//partial check: length le 20, alphanumeric, upper case, no space not underscore - data element in ABAP: TRKORR, CHAR20
			Utils.checkTransportRequest(sTransportRequest);
		} catch (oError) {
			return Promise.reject(oError);
		}

		this._sTransportRequest = sTransportRequest;
		return Promise.resolve();
	};

	/**
	 * Set package (for ABAP Backend)
	 *
	 * @param {string} sPackage package
	 *
	 * @return {Promise} resolving when setting of package was successful
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorChange.prototype.setPackage = function(sPackage) {
		try {
			//partial check: length le 30, alphanumeric, upper case, / for namespace, no space, no underscore - data element in ABAP: DEVCLASS, CHAR30
			Utils.checkPackage(sPackage);
		} catch (oError) {
			return Promise.reject(oError);
		}
		this._mChangeFile.packageName = sPackage;
		return Promise.resolve();
	};

	/**
	 * Submits the descriptor change to the backend
	 *
	 * @return {Promise} resolving after all changes have been saved
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorChange.prototype.submit = function() {
		// create persistence
		var sComponentName = this._mChangeFile.reference;
		//TODO: Add application version
		var oChangePersistence = ChangePersistenceFactory.getChangePersistenceForComponent(sComponentName);

		//add change to persistence
		var oChange = this._getChangeToSubmit();
		oChangePersistence.addChange(oChange);

		//submit
		return oChangePersistence.saveDirtyChanges();
	};

	DescriptorChange.prototype._getChangeToSubmit = function() {
		//create Change
		var oChange = new Change(this._getMap());

		if ( this._sTransportRequest ) {
			oChange.setRequest( this._sTransportRequest );
		}  else if ( this._oSettings.isAtoEnabled() && FlexUtils.isCustomerDependentLayer(this._mChangeFile.layer) ) {
			oChange.setRequest( 'ATO_NOTIFICATION' );
		}
		return oChange;
	};

	DescriptorChange.prototype._getMap = function() {
		var mInlineChange = this._oInlineChange.getMap();

		this._mChangeFile.content = mInlineChange.content;
		this._mChangeFile.texts = mInlineChange.texts;
		return this._mChangeFile;
	};

	/**
	 * Returns a copy of the JSON object of the descriptor change
	 *
	 * @return {object} copy of JSON object of the descriptor change
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorChange.prototype.getJson = function() {
		return jQuery.extend(true, {}, this._getMap());
	};

//Descriptor LREP Change Factory
	/**
	 * Factory for Descriptor Changes
	 *
	 * @constructor
	 * @alias sap.ui.fl.descriptorRelated.api.DescriptorChangeFactory
	 * @author SAP SE
	 * @version 1.48.6
	 * @private
	 * @sap-restricted
	 */

	var DescriptorChangeFactory = function() {};

	/**
	 * Creates a new descriptor change
	 *
	 * @param {string} sReference the descriptor id for which the change is created
	 * @param {object} oInlineChange the inline change instance
	 * @param {string} sLayer layer of the descriptor change
	 *
	 * @return {Promise} resolving the new Change instance
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorChangeFactory.prototype.createNew = function(sReference,oInlineChange,sLayer) {
		var fSetHostingIdForTextKey = function(_oDescriptorInlineChange, sId){
			//providing "hosting id" for appdescr_app_setTitle and similar
			//"hosting id" is descriptor variant id
			if ( _oDescriptorInlineChange["setHostingIdForTextKey"] ){
				_oDescriptorInlineChange.setHostingIdForTextKey(sId);
			}
		};
		fSetHostingIdForTextKey(oInlineChange,sReference);

		var mPropertyBag = {};
		mPropertyBag.changeType = oInlineChange._getChangeType();
		mPropertyBag.componentName = sReference;
		mPropertyBag.reference = sReference;

		if (!sLayer){
			//default to 'CUSTOMER'
			mPropertyBag.layer = 'CUSTOMER';
		} else {
			if (sLayer != 'VENDOR' && sLayer != 'PARTNER' && !FlexUtils.isCustomerDependentLayer(sLayer)) {
				throw new Error("Parameter \"layer\" needs to be 'VENDOR', 'PARTNER' or customer dependent");
			}
			mPropertyBag.layer = sLayer;
		}

		var mChangeFile = Change.createInitialFileContent(mPropertyBag );
		return Settings.getInstance().then(function(oSettings) {
			return Promise.resolve( new DescriptorChange(mChangeFile, oInlineChange, oSettings) );
		});
	};

	return DescriptorChangeFactory;
}, true);
}; // end of sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.descriptorRelated.api.DescriptorVariantFactory') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.descriptorRelated.api.DescriptorVariantFactory'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory",[
	"sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory",
	"sap/ui/fl/Utils",
	"sap/ui/fl/LrepConnector",
	"sap/ui/fl/descriptorRelated/internal/Utils",
	"sap/ui/fl/registry/Settings"
], function(DescriptorInlineChangeFactory, FlexUtils, LrepConnector, Utils, Settings) {
	"use strict";

	/**
	 * Descriptor Variant
	 *
	 * @param {object} mParameters parameters
	 * @param {string} mParameters.id the id of the descriptor variant id to be provided for a new descriptor variant and for deleting a descriptor variant
	 * @param {string} mParameters.reference the referenced descriptor or descriptor variant id to be provided when creating a new descriptor variant
	 * @param {boolean} [mParameters.isAppVariantRoot=true]
	 * @param {object} mFileContent file content of the existing descriptor variant to be provided if descriptor variant shall be created from an existing
	 * @param {boolean} [bDeletion=false] deletion indicator to be provided if descriptor variant shall be deleted
	 * @param {sap.ui.fl.registry.Settings} oSettings settings
	 *
	 * @constructor
	 * @alias sap.ui.fl.descriptorRelated.api.DescriptorVariant
	 * @author SAP SE
	 * @version 1.48.6
	 * @private
	 * @sap-restricted
	 */


	//Descriptor Variant
	var DescriptorVariant = function(mParameters, mFileContent, bDeletion, oSettings) {
		if (mParameters && bDeletion) {
			this._id = mParameters.id;
			this._mode = 'DELETION';
			this._mMap = mFileContent;

		} else if (mParameters) {
			this._id = mParameters.id;
			this._reference = mParameters.reference;
			this._layer = mParameters.layer;
			if ( typeof mParameters.isAppVariantRoot != undefined){
				this._isAppVariantRoot = mParameters.isAppVariantRoot;
			}
			this._mode = 'NEW';

		} else if (mFileContent) {
			this._mMap = mFileContent;
			this._mode = 'FROM_EXISTING';

		}

		this._oSettings = oSettings;
		this._sTransportRequest = null;
		this._content = [];
	};

	/**
	 * Adds a descriptor inline change to the descriptor variant
	 *
	 * @param {sap.ui.fl.descriptorRelated.api.DescriptorInlineChange} oDescriptorInlineChange the inline change
	 *
	 * @return {Promise} resolving when adding the descriptor inline change was successful (without backend access)
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorVariant.prototype.addDescriptorInlineChange = function(oDescriptorInlineChange) {
		var that = this;
		return new Promise(function(resolve) {

			var fSetHostingIdForTextKey = function(_oDescriptorInlineChange, sId){
				//providing "hosting id" for appdescr_app_setTitle and similar
				//"hosting id" is descriptor variant id
				if ( _oDescriptorInlineChange["setHostingIdForTextKey"] ){
					_oDescriptorInlineChange.setHostingIdForTextKey(sId);
				}
			};

			switch (that._mode) {
				case 'NEW':
					fSetHostingIdForTextKey(oDescriptorInlineChange,that._id);
					that._content.push(oDescriptorInlineChange.getMap());
					break;
				case 'FROM_EXISTING':
					fSetHostingIdForTextKey(oDescriptorInlineChange,that._mMap.id);
					that._mMap.content.push(oDescriptorInlineChange.getMap());
					break;
				default:
					// do nothing
			}
			resolve(null);
		});
	};

	/**
	 * Set transport request (for ABAP Backend)
	 *
	 * @param {string} sTransportRequest ABAP transport request
	 *
	 * @return {Promise} resolving when setting of transport request was successful
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorVariant.prototype.setTransportRequest = function(sTransportRequest) {
		try {
			//partial check: length le 20, alphanumeric, upper case, no space not underscore - data element in ABAP: TRKORR, CHAR20
			Utils.checkTransportRequest(sTransportRequest);
		} catch (oError) {
			return Promise.reject(oError);
		}
		this._sTransportRequest = sTransportRequest;
		return Promise.resolve();
	};

	/**
	 * Set package (for ABAP Backend)
	 *
	 * @param {string} sPackage ABAP package
	 *
	 * @return {Promise} resolving when setting of package was successful
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorVariant.prototype.setPackage = function(sPackage) {
		try {
			//partial check: length le 30, alphanumeric, upper case, / for namespace, no space, no underscore - data element in ABAP: DEVCLASS, CHAR30
			Utils.checkPackage(sPackage);
		} catch (oError) {
			return Promise.reject(oError);
		}
		this._package = sPackage;
		return Promise.resolve();
	};

	/**
	 * Submits the descriptor variant to the backend
	 *
	 * @return {Promise} resolving when submitting the descriptor variant was successful
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorVariant.prototype.submit = function() {
		var sRoute = '/sap/bc/lrep/appdescr_variants/';
		var sMethod;

		switch (this._mode) {
			case 'NEW':
				sMethod = 'POST';
				break;
			case 'FROM_EXISTING':
				sMethod = 'PUT';
				sRoute = sRoute + this._getMap().id;
				break;
			case 'DELETION':
				sMethod = 'DELETE';
				sRoute = sRoute + this._id;
				break;
			default:
				// do nothing
		}

		var mMap = this._getMap();

		if (this._sTransportRequest) {
		//set to URL-Parameter 'changelist', as done in LrepConnector
			sRoute += '?changelist=' + this._sTransportRequest;
		} else if ( this._oSettings.isAtoEnabled() && FlexUtils.isCustomerDependentLayer(mMap.layer) ) {
			sRoute += '?changelist=ATO_NOTIFICATION';
		}

		var oLREPConnector = LrepConnector.createConnector();

		return oLREPConnector.send(sRoute, sMethod, mMap);
	};

	/**
	 * Returns a copy of the JSON object of the descriptor variant
	 *
	 * @return {object} copy of JSON object of the descriptor variant
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorVariant.prototype.getJson = function() {
		return jQuery.extend(true, {}, this._getMap());
	};

	DescriptorVariant.prototype._getMap = function() {
		switch (this._mode) {
			case 'NEW':
				var mResult = {
					"fileName": this._getNameAndNameSpace().fileName,
					"fileType": "appdescr_variant",
					"namespace": this._getNameAndNameSpace().namespace,
					"layer": this._layer,
					"packageName": this._package ? this._package : "$TMP",

					"reference": this._reference,
					"id": this._id,

					"content": this._content
				};
				if ( typeof this._isAppVariantRoot != undefined ) {
					mResult.isAppVariantRoot = this._isAppVariantRoot;
				}
				return mResult;

			case 'FROM_EXISTING':
			case 'DELETION':
				{
					return this._mMap;
				}
			default: // do nothing
		}
	};

	DescriptorVariant.prototype._getNameAndNameSpace = function() {
		return Utils.getNameAndNameSpace(this._id,this._reference);
	};

	/**
	 * Factory for Descriptor Variants
	 * @namespace
	 * @alias sap.ui.fl.descriptorRelated.api.DescriptorVariantFactory
	 * @author SAP SE
	 * @version 1.48.6
	 * @private
	 * @sap-restricted
	 */
	var DescriptorVariantFactory = {};

	DescriptorVariantFactory._getDescriptorVariant = function(sId) {
		var sRoute = '/sap/bc/lrep/appdescr_variants/' + sId;
		var oLREPConnector = LrepConnector.createConnector();
		return oLREPConnector.send(sRoute, 'GET');
	};

	/**
	 * Creates a new descriptor variant
	 *
	 * @param {object} mParameters
	 * @param {string} mParameters.reference the referenced descriptor or descriptor variant id
	 * @param {string} mParameters.id the id for the descriptor variant id
	 * @param {string} [mParameters.layer='CUSTOMER'] the layer for the descriptor variant
	 * @param {boolean} [mParameters.isAppVariantRoot=true] if descriptor variant is 'appVariantRoot'
	 *
	 * @return {Promise} resolving the new DescriptorVariant instance
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorVariantFactory.createNew = function(mParameters) {
		Utils.checkParameterAndType(mParameters, "reference", "string");
		Utils.checkParameterAndType(mParameters, "id", "string");

		//default layer to CUSTOMER
		if (!mParameters.layer){
			mParameters.layer = 'CUSTOMER';
		} else {
			Utils.checkParameterAndType(mParameters, "layer", "string");
			//TODO: is this necessary? already checked in Utils-method? -> checks only type
			if (mParameters.layer != 'VENDOR' && mParameters.layer != 'PARTNER' && !FlexUtils.isCustomerDependentLayer(mParameters.layer)) {
				//TODO: this should do a reject 	return Promise.reject(oError);
				throw new Error("Parameter \"layer\" needs to be 'VENDOR', 'PARTNER' or customer dependent");
			}
		}

		// isAppVariantRoot
		if (mParameters.isAppVariantRoot){
			Utils.checkParameterAndType(mParameters, "isAppVariantRoot", "boolean");
		}
		return Settings.getInstance().then(function(oSettings) {
			return Promise.resolve( new DescriptorVariant(mParameters,null,false,oSettings) );
		});
	};

	/**
	 * Creates a descriptor variant instance for an existing descriptor variant id
	 *
	 * @param {string} sId the id of the descriptor variant id
	 *
	 * @return {Promise} resolving the DescriptorVariant instance
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorVariantFactory.createForExisting = function(sId) {
		if (sId === undefined || typeof sId !== "string") {
			throw new Error("Parameter \"sId\" must be provided of type string");
		}

		var _mResult;
		return DescriptorVariantFactory._getDescriptorVariant(sId).then(function(mResult){
			_mResult = mResult;
			return Settings.getInstance();
		}).then( function(oSettings){
			var mDescriptorVariantJSON = _mResult.response;
			if (!jQuery.isPlainObject(mDescriptorVariantJSON)) {
				//Parse if needed. Happens if backend sends wrong content type
				mDescriptorVariantJSON = JSON.parse(mDescriptorVariantJSON);
			}
			return Promise.resolve(new DescriptorVariant(null,mDescriptorVariantJSON,false,oSettings));
		});
	};

	/**
	 * Creates a descriptor variant deletion
	 *
	 * @param {string} sId the id of the descriptor variant id
	 *
	 * @return {Promise} resolving the DescriptorVariant instance
	 *
	 * @private
	 * @sap-restricted
	 */
	DescriptorVariantFactory.createDeletion = function(sId) {
		if (sId === undefined || typeof sId !== "string") {
			throw new Error("Parameter \"sId\" must be provided of type string");
		}
		var mParameter = {};
		mParameter.id = sId;

		var _mResult;
		return DescriptorVariantFactory._getDescriptorVariant(sId).then(function(mResult){
			_mResult = mResult;
			return Settings.getInstance();
		}).then( function(oSettings){
			var mDescriptorVariantJSON = JSON.parse(_mResult.response);
			return Promise.resolve(new DescriptorVariant(mParameter,mDescriptorVariantJSON,true,oSettings));
		});

	};

	return DescriptorVariantFactory;
},true);
}; // end of sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.registry.ChangeRegistry') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.registry.ChangeRegistry'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/registry/ChangeRegistry",[
	"sap/ui/fl/Utils", "jquery.sap.global", "sap/ui/fl/registry/ChangeRegistryItem", "sap/ui/fl/registry/ChangeTypeMetadata",
	"sap/ui/fl/registry/Settings", "sap/ui/fl/changeHandler/HideControl", "sap/ui/fl/changeHandler/MoveElements", "sap/ui/fl/changeHandler/MoveControls",
	"sap/ui/fl/changeHandler/PropertyChange", "sap/ui/fl/changeHandler/PropertyBindingChange", "sap/ui/fl/changeHandler/UnhideControl",
	"sap/ui/fl/changeHandler/StashControl", "sap/ui/fl/changeHandler/UnstashControl"
], function(Utils, jQuery, ChangeRegistryItem, ChangeTypeMetadata, Settings, HideControl, MoveElements, MoveControls, PropertyChange, PropertyBindingChange, UnhideControl, StashControl, UnstashControl) {
	"use strict";

	/**
	 * Central registration for available change types on controls
	 * @constructor
	 * @alias sap.ui.fl.registry.ChangeRegistry
	 *
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 *
	 */
	var ChangeRegistry = function() {
		this._registeredItems = {};
		this.initSettings();
		this.initDeveloperModeChangeHandlers();
	};

	ChangeRegistry._instance = undefined;
	ChangeRegistry.prototype._oDefaultActiveChangeHandlers = {};

	ChangeRegistry.prototype._oDefaultChangeHandlers = {
		"hideControl": HideControl,
		"moveElements": MoveElements,
		"moveControls": MoveControls,
		"unhideControl": UnhideControl,
		"stashControl": StashControl,
		"unstashControl": UnstashControl
	};

	ChangeRegistry.prototype._mDeveloperModeChangeHandlers = {
		"propertyChange": {
			changeHandler: PropertyChange
		},
		"propertyBindingChange": {
			changeHandler: PropertyBindingChange
		}
	};

	ChangeRegistry.prototype.initDeveloperModeChangeHandlers = function () {
		Object.keys(this._mDeveloperModeChangeHandlers).forEach(function(sChangeType) {
			var oChangeHandler = this._mDeveloperModeChangeHandlers[sChangeType].changeHandler;
			var oLayers = this._oSettings.getDeveloperModeLayerPermissions();
			var oSimpleChangeObject = {
				changeType: sChangeType,
				changeHandler: oChangeHandler,
				layers: oLayers
			};
			var oChangeRegistryItem = this._createChangeRegistryItemForSimpleChange("defaultActiveForAllControls", oSimpleChangeObject);
			this._oDefaultActiveChangeHandlers[sChangeType] = oChangeRegistryItem;
		}.bind(this));
	};

	ChangeRegistry.getInstance = function() {
		if (!ChangeRegistry._instance) {
			ChangeRegistry._instance = new ChangeRegistry();
		}
		return ChangeRegistry._instance;
	};

	ChangeRegistry.prototype.hasRegisteredChangeHandlersForControl = function (sControlType) {
		var aControlsWithRegistered = Object.keys(this._registeredItems);
		return aControlsWithRegistered.indexOf(sControlType) !== -1;
	};

	ChangeRegistry.prototype.hasChangeHandlerForControlAndChange = function (sControlType, sChangeType) {
		if (!this.hasRegisteredChangeHandlersForControl(sControlType)) {
			return false;
		}

		var oRegisteredChangeHandlersForControl = this._registeredItems[sControlType];
		var aHandlersRegisteredForControl = Object.keys(oRegisteredChangeHandlersForControl);
		return aHandlersRegisteredForControl.indexOf(sChangeType) !== -1;
	};

	ChangeRegistry.prototype.registerControlsForChanges = function(mControlChanges) {
		var that = this;
		jQuery.each(mControlChanges, function (sControlType, changeHandlers) {
			if (Array.isArray(changeHandlers)) {
				var oChangeHandlers = {};
				changeHandlers.forEach(function (oChangeHandler) {
						oChangeHandlers[oChangeHandler.changeType] = oChangeHandler.changeHandler;
				});
				that._registerChangeHandlersForControl(sControlType, oChangeHandlers);
			} else {
				that._registerChangeHandlersForControl(sControlType, changeHandlers);
			}
		});
	};

	ChangeRegistry.prototype._registerChangeHandlersForControl = function (sControlType, oChangeHandlers) {
		var that = this;

		if (typeof oChangeHandlers === "string") {
			try {
				oChangeHandlers = sap.ui.requireSync(oChangeHandlers + ".flexibility");
			} catch (error) {
				Utils.log.error("Flexibility change handler registration failed.\nControlType: " + sControlType + "\n" + error.message);
				return; // continue without a registration
			}
		}

		jQuery.each(oChangeHandlers, function (sChangeType, sChangeHandler) {
			var oChangeHandler = that._getChangeHandler(sChangeType, sChangeHandler);
			var oSimpleChange = {
				"changeType": sChangeType,
				"changeHandler": oChangeHandler.changeHandler,
				"layers":oChangeHandler.layers
			};
			that.registerControlForSimpleChange(sControlType, oSimpleChange);
		});
	};

	/**
	 * Adds registration for a control and a simple change; if changeHandler is 'default', the default change handler is used.
	 * @param {string} sChangeType - Change type of a <code>sap.ui.fl.Change</code> change
	 * @param {string | object} vChangeHandler - Can be a string with 'default' or a path to a change handler implementation or an object (see example)
	 * @returns {string|object} Returns the passed <code>sChangeHandler</code> or, if 'default', the loaded object of the default change handler
	 * @example {
	 * 				"moveControls": {
	 * 					"changeHandler": "default",
	 * 					"layers": {
	 * 						"USER": true
	 * 					}
	 * 				}
	 * 			}
	 *
	 * @private
	 */
	ChangeRegistry.prototype._getChangeHandler = function (sChangeType, vChangeHandler) {
		var oResult = {};
		var aDeveloperModeChangeHandlers = Object.keys(this._mDeveloperModeChangeHandlers);
		if (!vChangeHandler.changeHandler) {
			oResult.changeHandler = vChangeHandler;
		} else {
			oResult = vChangeHandler;
		}
		if (oResult.changeHandler === "default") {
			oResult.changeHandler = this._oDefaultChangeHandlers[sChangeType];
		} else if (aDeveloperModeChangeHandlers.indexOf(sChangeType) > -1) {
			throw new Error("You can't use a custom change handler for the following Developer Mode change types: " + aDeveloperModeChangeHandlers.toString() + ". Please use 'default' instead.");
		}
		return oResult;
	};

	/**
	 * Adds registration for a control and a simple change
	 * @param {String} sControlType - Name of the control
	 * @param {sap.ui.fl.registry.SimpleChange.member} oSimpleChange - One of the simple changes
	 *
	 * @public
	 */
	ChangeRegistry.prototype.registerControlForSimpleChange = function(sControlType, oSimpleChange) {
		var oChangeRegistryItem;
		if (!sControlType) {
			return;
		}
		if (!oSimpleChange || !oSimpleChange.changeType || !oSimpleChange.changeHandler) {
			return;
		}

		oChangeRegistryItem = this._createChangeRegistryItemForSimpleChange(sControlType, oSimpleChange);

		if (oChangeRegistryItem) {
			this.addRegistryItem(oChangeRegistryItem);
		}
	};

	/**
	 * Adds registration for a control and a simple change
	 * @param {String} sControlType - Name of the control
	 * @param {sap.ui.fl.registry.SimpleChange.member} oSimpleChange - One of the simple changes
	 * @returns {sap.ui.fl.registry.ChangeRegistryItem} the registry item
	 *
	 * @public
	 */
	ChangeRegistry.prototype._createChangeRegistryItemForSimpleChange = function(sControlType, oSimpleChange) {
		var mParam, oChangeTypeMetadata, oChangeRegistryItem, mLayerPermissions;

		mLayerPermissions = jQuery.extend({}, this._oSettings.getDefaultLayerPermissions());
		var oLayers = oSimpleChange.layers;

		if (oLayers) {
			Object.keys(oLayers).forEach(function (sLayer) {
				if (mLayerPermissions[sLayer] === undefined) {
					throw new Error("The Layer '" + sLayer + "' is not supported. Please only use supported layers");
				}
				mLayerPermissions[sLayer] = oLayers[sLayer];
			});
		}

		//Create change type metadata
		mParam = {
			name: oSimpleChange.changeType,
			changeHandler: oSimpleChange.changeHandler,
			layers : mLayerPermissions
		};
		oChangeTypeMetadata = new ChangeTypeMetadata(mParam);

		//Create change registry item
		mParam = {
			changeTypeMetadata: oChangeTypeMetadata,
			controlType: sControlType
		};
		oChangeRegistryItem = new ChangeRegistryItem(mParam);

		return oChangeRegistryItem;
	};

	/**
	 * Add a registry item for the controlType and changeType. If the item already exists, it will be overwritten
	 * @param {sap.ui.fl.registry.ChangeRegistryItem} oRegistryItem the registry item
	 * @public
	 */
	ChangeRegistry.prototype.addRegistryItem = function(oRegistryItem) {
		var sChangeType, sControlType;
		if (!oRegistryItem) {
			return;
		}

		sChangeType = oRegistryItem.getChangeTypeName();
		sControlType = oRegistryItem.getControlType();

		this._registeredItems[sControlType] = this._registeredItems[sControlType] || {};
		this._registeredItems[sControlType][sChangeType] = oRegistryItem;
	};

	/**
	 * Remove a registration for:
	 *  - A single change type (only changeTypeName parameter set)
	 *  - The complete registration on a certain control (only controlType parameter set)
	 *  - Or all registrations of a change type on any control (both changeTypeName AND controlType set)
	 * @param {Object} mParam Description see below
	 * @param {String} [mParam.changeTypeName] Change type name which should be removed
	 * @param {String} [mParam.controlType] Control type which should be removed.
	 *
	 * @public
	 */
	ChangeRegistry.prototype.removeRegistryItem = function(mParam) {
		if (!mParam.changeTypeName && !mParam.controlType) {
			Utils.log.error("sap.ui.fl.registry.ChangeRegistry: ChangeType and/or ControlType required");
			return;
		}
		//Either remove a specific changeType from a specific control type
		if (mParam.controlType && mParam.changeTypeName) {
			if (this._registeredItems[mParam.controlType]) {
				if (Object.keys(this._registeredItems[mParam.controlType]).length === 1) { //only one changeType...
					delete this._registeredItems[mParam.controlType];
				} else {
					delete this._registeredItems[mParam.controlType][mParam.changeTypeName];
				}
			}
		//or remove by control type
		} else if (mParam.controlType) {
			if (this._registeredItems[mParam.controlType]) {
				delete this._registeredItems[mParam.controlType];
			}
		//or via changeType on all control types
		} else if (mParam.changeTypeName) {
			for ( var controlTypeKey in this._registeredItems) {
				var controlItem = this._registeredItems[controlTypeKey];
				delete controlItem[mParam.changeTypeName];
			}
		}
	};

	/**
	 * Get a registration for:
	 *  - All registration items with specific change type name on all controls (only changeTypeName parameter set)
	 *  - The complete registration(s) on a certain control (only controlType parameter set)
	 *  - Or all registrations of a change type name on any control (both changeTypeName AND controlType set)
	 * @param {Object} mParam Description see below
	 * @param {String} [mParam.changeTypeName] Change type to find registration(s) for this changeType
	 * @param {String} [mParam.controlType] Control type to find registration(s) for this controlType
	 * @param {String} [mParam.layer] Layer where changes are currently applied. If not provided no filtering for valid layers is done.
	 * @returns {Object} Returns an object in the format
	 * @example {
	 * 				"sap.ui.core.SampleControl":{
	 * 					<ChangeRegistryItem> : {
	 * 						_changeTypeMetadata: {
	 * 							_changeHandler: {},
	 * 							_layers: {},
	 * 							_name,
	 * 							_controlType
	 * 						}
	 * 					}
	 * 				}
	 * 			}
	 * @public
	 */
	ChangeRegistry.prototype.getRegistryItems = function(mParam) {
		if (!mParam) {
			Utils.log.error("sap.ui.fl.registry.ChangeRegistry: no parameters passed for getRegistryItems");
		}

		var sChangeType = mParam.changeTypeName;
		var sControlType = mParam.controlType;

		if (!sChangeType && !sControlType) {
			Utils.log.error("sap.ui.fl.registry.ChangeRegistry: Change Type Name and/or Control Type required");
		}

		var result = null;
		if (sControlType && sChangeType) {
			var oChangeHandler = this._getOrLoadChangeHandler(sControlType, sChangeType);

			if (oChangeHandler) {
				result = {};
				result[sControlType] = {};
				result[sControlType][sChangeType] = oChangeHandler;
			}
		} else if (sControlType) {
			result = {};
			result[sControlType] = {};
			if (this._registeredItems[sControlType]) {
				//keep the actual registry items but clone the control-changetype object structure to not modify the registry during filtering
				var aChangeTypes = Object.keys(this._registeredItems[sControlType]);

				aChangeTypes.forEach(function (sChangeType) {
					result[sControlType][sChangeType] = this._getOrLoadChangeHandler(sControlType, sChangeType);
				}.bind(this));
			}
			for (var sKey in this._oDefaultActiveChangeHandlers) {
				result[sControlType][sKey] = this._oDefaultActiveChangeHandlers[sKey];
			}
		} else if (sChangeType) {
			result = {};
			for ( sControlType in this._registeredItems) {
				if (this._registeredItems[sControlType][sChangeType]) {
					result[sControlType] = {};
					result[sControlType][sChangeType] = this._getOrLoadChangeHandler(sControlType, sChangeType);
				}
			}
			result["defaultActiveForAllControls"] = {};
			for (var key in this._oDefaultActiveChangeHandlers) {
				result["defaultActiveForAllControls"][key] = this._oDefaultActiveChangeHandlers[key];
			}
		}
		//filter out disabled change types
		this._filterChangeTypes(result, mParam.layer);
		return result;
	};

	ChangeRegistry.prototype._getOrLoadChangeHandler = function (sControlType, sChangeType) {
		var oControlRegistrations = this._registeredItems[sControlType];
		if (oControlRegistrations) {
			var oChangeHandler = oControlRegistrations[sChangeType];
			if (oChangeHandler) {
				var oChangeHandlerMetadata = oChangeHandler.getChangeTypeMetadata();
				var oChangeHandlerImplementation = oChangeHandlerMetadata.getChangeHandler();
				if (typeof oChangeHandlerImplementation === "string") {
					// load the module synchronous
					jQuery.sap.require(oChangeHandlerImplementation);
					oChangeHandlerImplementation = sap.ui.require(oChangeHandlerImplementation);
					oChangeHandlerMetadata._changeHandler = oChangeHandlerImplementation;
				}

				return oChangeHandler;
			}
		}

		var oDefaultActiveChangeHandler = this._oDefaultActiveChangeHandlers[sChangeType];

		if (oDefaultActiveChangeHandler) {
			return oDefaultActiveChangeHandler;
		}

		return null;
	};

	/**
	 * Retrieves settings for SAPUI5 flexibility.
	 *
	 * @private
	 */
	ChangeRegistry.prototype.initSettings = function() {
		this._oSettings = Settings.getInstanceOrUndef();
		if (!this._oSettings) {
			this._oSettings = new Settings({});
		}
	};

	/**
	 * Removes registry items that are not enabled for the current writable layer.
	 * @param {object} oRegistryItems see example
	 * @param {string} sLayer persistency layer, if not provided no filtering is done.
	 * @example {
	 * 				"moveControls": {
	 * 					"changeHandler": "default",
	 * 					"layers": {
	 * 						"USER": true
	 * 					}
	 * 				}
	 * 			}
	 * @private
	 */
	ChangeRegistry.prototype._filterChangeTypes = function(oRegistryItems, sLayer) {
		if (this._oSettings && sLayer && oRegistryItems) {
			var bIsChangeTypeEnabled = false;

			jQuery.each(oRegistryItems, function(sControlType, oControlReg) {
				jQuery.each(oControlReg, function(sChangeType, oRegistryItem) {
					var oLayers = oRegistryItem.getChangeTypeMetadata().getLayers();

					bIsChangeTypeEnabled = oLayers[sLayer];

					if (!bIsChangeTypeEnabled) {
						Utils.log.warning("Change type " + sChangeType + " not enabled for layer " + sLayer);
						delete oControlReg[sChangeType];
					}
				});
			});
		}
	};

	ChangeRegistry.prototype.getDragInfo = function(sControlType) {
		var controlTypeItems = this._registeredItems[sControlType];
		if (controlTypeItems) {
			return controlTypeItems.getDragInfo();
		}
		return null;
	};

	return ChangeRegistry;
}, true);

}; // end of sap/ui/fl/registry/ChangeRegistry.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.transport.TransportDialog') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.fl.transport.TransportDialog.
jQuery.sap.declare('sap.ui.fl.transport.TransportDialog'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.m.List'); // unlisted dependency retained
jQuery.sap.require('sap.m.InputListItem'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
jQuery.sap.require('sap.m.ComboBox'); // unlisted dependency retained
jQuery.sap.require('sap.m.Dialog'); // unlisted dependency retained
jQuery.sap.require('sap.m.DialogRenderer'); // unlisted dependency retained
jQuery.sap.require('sap.m.Input'); // unlisted dependency retained
jQuery.sap.require('sap.m.Label'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageToast'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ListItem'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/transport/TransportDialog",['jquery.sap.global', "sap/m/List", "sap/m/InputListItem", 'sap/m/Button', 'sap/m/ComboBox', 'sap/m/Dialog', 'sap/m/DialogRenderer', 'sap/m/Input', 'sap/m/Label', 'sap/m/MessageToast', 'sap/ui/core/ListItem', 'sap/ui/fl/transport/Transports'],
	function(jQuery, List, InputListItem, Button, ComboBox, Dialog, DialogRenderer, Input, Label, MessageToast, ListItem, Transports) {
	"use strict";


	/**
	 * Constructor for a new transport/TransportDialog.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The Transport Dialog Control can be used to implement a value help for selecting an ABAP package and transport request. It is not a generic utility, but part of the Variantmanament and therefore cannot be used in any other application.
	 * @extends sap.m.Dialog
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.fl.transport.TransportDialog
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var TransportDialog = Dialog.extend("sap.ui.fl.transport.TransportDialog", /** @lends sap.ui.fl.transport.TransportDialog.prototype */ { metadata : {

		library : "sap.ui.fl",
		properties : {

			/**
			 * An ABAP package that can be used as default for the ABAP package selection.
			 */
			pkg : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * The set of ABAP transport requests that can be selected by a user.
			 */
			transports : {type : "any", group : "Misc", defaultValue : null},

			/**
			 * The LREP object for which as transport request has to be selected
			 */
			lrepObject : {type : "any", group : "Misc", defaultValue : null},

			/**
			 * Flag indicating whether the selection of an ABAP package is to be hidden or not.
			 */
			hidePackage : {type : "boolean", group : "Misc", defaultValue : null}
		},
		events : {

			/**
			 * This event will be fired when the user clicks the OK button on the dialog.
			 */
			ok : {},

			/**
			 * This event will be fired when the user clicks the Cancel button on the dialog.
			 */
			cancel : {}
		}
	},
	renderer: DialogRenderer.render
	});


	/**
	 * Initialize the control.
	 *
	 * @private
	 */
	TransportDialog.prototype.init = function() {

		Dialog.prototype.init.apply(this);

		// initialize dialog and create member variables.
		this._oResources = sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");
		this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE"));

		// add the content.
		this._oPackageLabel = null;
		this._oPackage = this._createPackageField();
		this._oTransport = this._createTransportCombo();
		this.addContent(this._createContentList());

		// okay, cancel and local-object buttons.
		this._createButtons();
	};

	/**
	 * Creates the content list and places its content.
	 *
	 * @private
	 */
	TransportDialog.prototype._createContentList = function() {

		this._oPackageListItem = new InputListItem({
			label: this._oResources.getText("TRANSPORT_DIALOG_PACKAGE"),
			content: [
				this._oPackage
			]
		});

		this._oTransportListItem = new InputListItem({
			label: this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT"),
			content: [
				this._oTransport
			]
		});

		return new List({
			items: [
				this._oPackageListItem,
				this._oTransportListItem
			]
		});
	};

	/**
	 * Creates the footer buttons.
	 *
	 * @private
	 */
	TransportDialog.prototype._createButtons = function() {

		var that = this;

		this.addButton(new Button({
			text: this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),
			tooltip: this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),
			press: function() {
				that._onLocal();
			}
		}));
		this.addButton(new Button({
			text: this._oResources.getText("TRANSPORT_DIALOG_OK"),
			tooltip: this._oResources.getText("TRANSPORT_DIALOG_OK"),
			enabled: false,
			press: function() {
				that._onOkay();
			}
		}));
		this.addButton(new Button({
			text: this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),
			tooltip: this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),
			press: function() {
				that.fireCancel();
				that.close();
				that.destroy();
			}
		}));
	};

	/**
	 * Event handler for local object button.
	 *
	 * @private
	 */
	TransportDialog.prototype._onLocal = function() {

		this.fireOk({
			selectedTransport: "",
			selectedPackage: this.getPkg() || "$TMP",
			dialog: true
		});
		this.close();
		this.destroy();
	};

	/**
	 * Event handler for okay button.
	 *
	 * @private
	 */
	TransportDialog.prototype._onOkay = function() {

		var sTransport = this._oTransport.getSelectedKey();

		if (this._checkOkay(sTransport)) {
			this.fireOk({
				selectedTransport: sTransport,
				selectedPackage: this.getPkg() || this._oPackage.getValue(),
				dialog: true
			});
			this.close();
			this.destroy();
		} else {
			this.getButtons()[1].setEnabled(false);
			this._oTransport.setValueState(sap.ui.core.ValueState.Error);
			this._oTransport.setValueStateText(this.getTitle());
		}
	};

	/**
	 * Checks whether the Okay button triggers the okay callback.
	 *
	 * @param {string} sTransport the ID of a transport request, can be <code>null</code>.
	 * @returns {boolean} <code>true</code>, if the okay callback can be triggered, <code>false</code> otherwise.
	 *
	 * @private
	 */
	TransportDialog.prototype._checkOkay = function(sTransport) {

		if (sTransport) {
			return true;
		}

		return false;
	};

	/**
	 * Creates the transport <code>sap.ui.commons.ComboBox</code>.
	 * @returns {sap.ui.commons.ComboBox} the transport <code>sap.ui.commons.ComboBox</code>.
	 *
	 * @private
	 */
	TransportDialog.prototype._createTransportCombo = function() {

		var that = this;

		return new ComboBox({
			showSecondaryValues: true,
			enabled: false,
			tooltip: this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"),
			width: "100%",
			selectionChange: function() {
				//if package field is visible but has no value, the OK button is disable
				if (that._oPackageListItem.getVisible() && !that._oPackage.getValue()) {
					return;
				}

				that.getButtons()[1].setEnabled(true);
				that._oTransport.setValueState(sap.ui.core.ValueState.None);
			},
			change : function(oEvent) {
				var fCheck = function(oItem) {
					if ((oItem && oEvent.mParameters.newValue !== oItem.getText()) || !oItem) {
						return true;
					}

					return false;
				};

				if (oEvent && oEvent.mParameters && oEvent.mParameters.newValue) {
					if (fCheck(that._oTransport.getSelectedItem())) {
						that.getButtons()[1].setEnabled(false);
						that._oTransport.setValueState(sap.ui.core.ValueState.Error);
						that._oTransport.setValueStateText(that._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"));
					}
				}
			}
		});
	};

	/**
	 * Creates the package <code>sap.ui.commons.ComboBox</code>.
	 * @returns {sap.ui.commons.ComboBox} the package <code>sap.ui.commons.ComboBox</code>.
	 *
	 * @private
	 */
	TransportDialog.prototype._createPackageField = function() {

		var that = this;

		return new Input({
			tooltip: this._oResources.getText("TRANSPORT_DIALOG_PACKAGE_TT"),
			width: "100%",
			change: function() {
				var oTransports, oPromise, oObject;

				oObject = that._createObjectInfo();
				oTransports = new sap.ui.fl.transport.Transports(); // FIXME workaround to make test stub work with AMD
				oPromise = oTransports.getTransports(oObject);
				oPromise.then(function(oResult) {
					that._onPackageChangeSuccess(oResult);
				}, function(oResult) {
					that._onPackageChangeError(oResult);
				});
			},
			liveChange: function(oEvent) {
				if (oEvent.mParameters.liveValue && oEvent.mParameters.liveValue.length > 3) {
					that._oTransport.setEnabled(true);
				}
			}
		});
	};

	/**
	 * Creates the object info which serves as input for the transport service and returns it.
	 * @returns {object} the object info which serves as input for the transport service.
	 *
	 * @private
	 */
	TransportDialog.prototype._createObjectInfo = function() {

		var oObject, oResult = {
			"package" : this._oPackage.getValue() || ""
		};

		oObject = this.getProperty("lrepObject");

		if (oObject) {
			if (oObject.name) {
				oResult.name = oObject.name;
			}

			if (oObject.type) {
				oResult.type = oObject.type;
			}

			if (oObject.namespace) {
				oResult.namespace = oObject.namespace;
			}
		}

		return oResult;
	};

	/**
	 * Event handler reacting to package change.
	 * @param {object}
	 *            oTransports the possible transport requests.
	 *
	 * @private
	 */
	TransportDialog.prototype._onPackageChangeSuccess = function(oTransports) {

		if (oTransports) {
			if (oTransports.localonly) {
				this._oTransport.setEnabled(false);
				this.getButtons()[1].setEnabled(true);
			} else if (oTransports.transports && oTransports.transports.length > 0) {
				this._oTransport.setEnabled(true);
				this._setTransports(oTransports);
			} else if (oTransports.errorCode) {
				this.getButtons()[1].setEnabled(false);
				this._oPackage.setValueState(sap.ui.core.ValueState.Error);
				this._oPackage.setValueStateText(this._oResources.getText("TRANSPORT_DIALOG_" + oTransports.errorCode));
				this._setTransports(oTransports);
			} else {
				MessageToast.show(this._oResources.getText("TRANSPORT_DIALOG_NO_TRANSPORTS"));
			}
		}
	};

	/**
	 * Sets the transport requests into the drop down.
	 * @param {object}
	 *            oTransports the possible transport requests.
	 *
	 * @private
	 */
	TransportDialog.prototype._setTransports = function(oTransports) {

		var oLock, aTransports;

		//get the transports into an array.
		oLock = this._hasLock(oTransports.transports);

		if (oLock) {
			aTransports = [ oLock ];
		} else {
			aTransports = oTransports.transports;
		}

		//set the transports.
		this.setTransports(aTransports);

		//pre-select one, if necessary.
		if (aTransports && aTransports.length === 1) {
			this._oTransport.setValue(aTransports[0].description, true);
			this.getButtons()[1].setEnabled(true);
		}

		//clear the transport combo-box, if necessary.
		if (!aTransports || aTransports.length === 0) {
			this._oTransport.setSelectedKey(null);
			this._oTransport.setValueState(sap.ui.core.ValueState.None);
			this.getButtons()[1].setEnabled(false);
		}
	};

	/**
	 * Event handler reacting to package change.
	 * @param {object}
	 *            oResult response to requesting packages.
	 *
	 * @private
	 */
	TransportDialog.prototype._onPackageChangeError = function(oResult) {

		MessageToast.show(oResult);
		this.setTransports([]);
	};

	/**
	 * Returns whether the LREP object is already locked in one of the transports.
	 * @param {array}
	 *            aTransports the available transports.
	 * @returns {object} the transport, if the LREP object is already locked in one of the transports, <code>null</code> otherwise.
	 *
	 * @private
	 */
	TransportDialog.prototype._hasLock = function(aTransports) {

		var oTransport, len = aTransports.length;

		while (len--) {
			oTransport = aTransports[len];

			if (oTransport.locked) {
				return oTransport;
			}
		}

		return null;
	};

	/**
	 * An ABAP package that can be used as default for the ABAP package selection.
	 * The property can only be set once and afterwards it cannot be changed.
	 * @param {string}
	 *            sPackage an ABAP package that can be used as default for the ABAP package selection.
	 *
	 * @public
	 */
	TransportDialog.prototype.setPkg = function(sPackage) {

		if (sPackage && !this.getProperty("pkg")) {
			// set the property itself.
			this.setProperty("pkg", sPackage);

			// disable package selection.
			this._oPackage.setValue(sPackage);
			this._oPackage.setEnabled(false);

			// enable transport selection.
			this._oTransport.setEnabled(true);

			// correct the title.
			this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));

			//disable local object button, as package has been set from outside and therefore should not be changed.
			this.getButtons()[0].setVisible(false);
		}
	};

	/**
	 * The set of ABAP transport requests that can be selected by a user.
	 * @param {array}
	 *            aSelection the set of ABAP transport requests that can be selected by a user.
	 *
	 * @public
	 */
	TransportDialog.prototype.setTransports = function(aSelection) {

		var i, len = 0, oItem;

		if (aSelection) {
			this.setProperty("transports", aSelection);
			this._oTransport.removeAllItems();
			len = aSelection.length;

			for (i = 0; i < len; i++) {
				oItem = aSelection[i];
				this._oTransport.addItem(new ListItem({
					key: oItem.transportId,
					text: oItem.transportId,
					additionalText: oItem.description
				}));
			}

			if (len === 1) {
				this._oTransport.setSelectedKey(aSelection[0].transportId);
				this.getButtons()[1].setEnabled(true);
			}

			// enable transport selection.
			if (len > 0) {
				this._oTransport.setEnabled(true);
			}
		}
	};

	/**
	 * The LREP object for which as transport request has to be selected.
	 * The property can only be set once and afterwards it cannot be changed.
	 * @param {object}
	 *            oObject an LREP object for which as transport request has to be selected. The object has the attributes name, namespace and type.
	 *
	 * @public
	 */
	TransportDialog.prototype.setLrepObject = function(oObject) {

		if (oObject && !this.getProperty("lrepObject")) {
			this.setProperty("lrepObject", oObject);
		}
	};

	/**
	 * Flag indicating whether the selection of an ABAP package is to be hidden or not.
	 * @param {boolean}
	 *            bHide if set to <code>true</code>, the package selection is hidden.
	 *
	 * @public
	 */
	TransportDialog.prototype.setHidePackage = function(bHide) {

		//set the property itself.
		this.setProperty("hidePackage", bHide);

		//toggle package visibility.
		this._oPackageListItem.setVisible(!bHide);

		if (bHide) {
			//set the local object button to enabled,
			//as the end-user might want to "just" save the object without selecting a transport.
			this.getButtons()[0].setEnabled(bHide);

			//correct the title.
			this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));
		}
	};

	return TransportDialog;

}, /* bExport= */ true);

}; // end of sap/ui/fl/transport/TransportDialog.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.transport.TransportSelection') ) {
/*
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.transport.TransportSelection'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/transport/TransportSelection",[	"jquery.sap.global", "sap/ui/fl/Utils", "sap/ui/fl/transport/Transports", "sap/ui/fl/transport/TransportDialog", "sap/ui/fl/registry/Settings" ], function(jQuery, Utils, Transports, TransportDialog, FlexSettings) {
	"use strict";
	/**
	 * @public
	 * @alias sap.ui.fl.transport.TransportSelection
	 * @constructor
	 * @author SAP SE
	 * @version 1.48.6
	 * @since 1.38.0
	 * Helper object to select an ABAP transport for an LREP object. This is not a generic utility to select a transport request, but part
	 *        of the SmartVariant control.
	 * @param jQuery.sap.global} jQuery a reference to the jQuery implementation.
	 * @param {sap.ui.fl.Utils} Utils a reference to the flexibility utilities implementation.
	 * @param {sap.ui.fl.transport.Transports} Transports a reference to the transport service implementation.
	 * @param {sap.ui.fl.transport.TransportDialog} TransportDialog a reference to the transport dialog implementation.
	 * @param {sap.ui.fl.registry.Settings} FlexSettings a reference to the settings implementation
	 * @returns {sap.ui.fl.transport.TransportSelection} a new instance of <code>sap.ui.fl.transport.TransportSelection</code>.
	 */
	var TransportSelection = function() {
		this.oTransports = new sap.ui.fl.transport.Transports();
	};

	/**
	 * Selects a transport request for a given LREP object.
	 * First checks if the Adaptation Transport Organizer (ATO) is enabled
	 * If ATO is enabled and the layered repository object is in the CUSTOMER layer, the request 'ATO_NOTIFICATION' has to be used.
	 * This request triggers in the back end that the change is added to an ATO collection.
	 * If ATO is not enabled or LREP object not in CUSTOMER layer:
	 * If the LREP object is already assigned to an open transport request or the LREP object is
	 * assigned to a local ABAP package, no dialog to select a transport is started. Instead the success callback is invoked directly. The transport
	 * dialog is shown if a package or a transport request has still to be selected, so if more than one transport request is available for the
	 * current user and the LREP object is not locked in an open transport request.
	 *
	 * @param {object} oObjectInfo the LREP object, which has the attributes name, name space, type, layer and package.
	 * @param {function} fOkay call-back to be invoked when a transport request has successfully been selected.
	 * @param {function} fError call-back to be invoked when an error occurred during selection of a transport request.
	 * @param {boolean} bCompactMode flag indicating whether the transport dialog should be opened in compact mode.
	 * @param {object} oControl Control instance
	 * @public
	 */
	TransportSelection.prototype.selectTransport = function(oObjectInfo, fOkay, fError, bCompactMode, oControl) {
		var that = this;

		if (oObjectInfo) {
			var sLayerType = Utils.getCurrentLayer(false);

			// if object layer are known and layer is CUSTOMER
			// check in settings if the adaptation transport organizer (ATO) is enabled
			if (sLayerType && sLayerType === 'CUSTOMER') {
				// retrieve the settings and check if ATO is enabled
				FlexSettings.getInstance().then(function(oSettings) {
					// ATO is enabled - signal that change is to be added to an ATO collection
					// instead of a transport
					if (oSettings.isAtoEnabled()) {
						var oTransport = { transportId: "ATO_NOTIFICATION" };
						fOkay(that._createEventObject(oObjectInfo, oTransport));
						//ATO is not enabled, use CTS instead
					} else {
						that._selectTransport(oObjectInfo, fOkay, fError, bCompactMode);
					}
				});
			// do not have the required info to check for ATO or not CUSTOMER layer - use CTS
			} else {
				that._selectTransport(oObjectInfo, fOkay, fError, bCompactMode);
			}
		}
	};

	/**
	 * Selects a transport request for a given LREP object. If the LREP object is already assigned to an open transport request or the LREP object is
	 * assigned to a local ABAP package, no dialog to select a transport is started. Instead the success callback is invoked directly. The transport
	 * dialog is shown if a package or a transport request has still to be selected, so if more than one transport request is available for the
	 * current user and the LREP object is not locked in an open transport request.
	 *
	 * @param {object} oObjectInfo the LREP object, which has the attributes name, name space, type, layer and package.
	 * @param {function} fOkay call-back to be invoked when a transport request has successfully been selected.
	 * @param {function} fError call-back to be invoked when an error occurred during selection of a transport request.
	 * @param {boolean} bCompactMode flag indicating whether the transport dialog should be opened in compact mode.
	 * @private
	 */
	TransportSelection.prototype._selectTransport = function(oObjectInfo, fOkay, fError, bCompactMode) {
		var that = this;

		if (oObjectInfo) {
			this.oTransports.getTransports(oObjectInfo).then(function(oGetTransportsResult) {
				var oTransport;

				if (that._checkDialog(oGetTransportsResult)) {
					that._openDialog({
						hidePackage: !Utils.doesSharedVariantRequirePackage(),
						pkg: oObjectInfo.package,
						transports: oGetTransportsResult.transports,
						lrepObject: that._toLREPObject(oObjectInfo)
					}, fOkay, fError, bCompactMode);
				} else {
					oTransport = that._getTransport(oGetTransportsResult);
					fOkay(that._createEventObject(oObjectInfo, oTransport));
				}
			}, function(oResult) {
				fError(oResult);
			});
		}
	};

	/**
	 * Creates an event object similar to the UI5 event object.
	 *
	 * @param {object} oObjectInfo identifies the LREP object.
	 * @param {object} oTransport the transport request that has been selected.
	 * @return {object} event object.
	 * @private
	 */
	TransportSelection.prototype._createEventObject = function(oObjectInfo, oTransport) {
		return {
			mParameters: {
				selectedTransport: oTransport.transportId,
				selectedPackage: oObjectInfo["package"],
				dialog: false
			},
			getParameters: function() {
				return this.mParameters;
			},
			getParameter: function(sName) {
				return this.mParameters[sName];
			}
		};
	};

	/**
	 * Creates an LREP object description for the transport dialog.
	 *
	 * @param {object} oObjectInfo identifies the LREP object.
	 * @return {object} LREP object description for the transport dialog.
	 * @private
	 */
	TransportSelection.prototype._toLREPObject = function(oObjectInfo) {
		var oObject = {};

		if (oObjectInfo.namespace) {
			oObject.namespace = oObjectInfo.namespace;
		}

		if (oObjectInfo.name) {
			oObject.name = oObjectInfo.name;
		}

		if (oObjectInfo.type) {
			oObject.type = oObjectInfo.type;
		}

		return oObject;
	};

	/**
	 * Opens the dialog to select a transport request.
	 *
	 * @param {object} oConfig configuration for the dialog, e.g. package and transports.
	 * @param {function} fOkay call-back to be invoked when a transport request has successfully been selected.
	 * @param {function} fError call-back to be invoked when an error occurred during selection of a transport request.
	 * @param {boolean} bCompactMode flag indicating whether the transport dialog should be opened in compact mode.
	 * @returns {sap.ui.fl.transport.TransportDialog} the dialog.
	 * @private
	 */
	TransportSelection.prototype._openDialog = function(oConfig, fOkay, fError, bCompactMode) {
		var oDialog = new TransportDialog(oConfig);
		oDialog.attachOk(fOkay);
		oDialog.attachCancel(fError);

		// toggle compact style.
		if (bCompactMode) {
			oDialog.addStyleClass("sapUiSizeCompact");
		} else {
			oDialog.removeStyleClass("sapUiSizeCompact");
		}

		oDialog.open();

		return oDialog;
	};

	/**
	 * Returns a transport to assign an LREP object to.
	 *
	 * @param {object} oTransports the available transports.
	 * @returns {object} a transport to assign an LREP object to, can be <code>null</code>.
	 * @private
	 */
	TransportSelection.prototype._getTransport = function(oTransports) {
		var oTransport;

		if (!oTransports.localonly) {
			oTransport = this._hasLock(oTransports.transports);
		} else {
			oTransport = {
				transportId: ""
			};
		}

		return oTransport;
	};

	/**
	 * Returns whether the dialog to select a transport should be started.
	 *
	 * @param {object} oTransports the available transports.
	 * @returns {boolean} <code>true</code>, if the LREP object is already locked in one of the transports, <code>false</code> otherwise.
	 * @private
	 */
	TransportSelection.prototype._checkDialog = function(oTransports) {
		if (oTransports) {
			if (oTransports.localonly || this._hasLock(oTransports.transports)) {
				return false;
			}
		}

		return true;
	};

	/**
	 * Returns whether the LREP object is already locked in one of the transports.
	 *
	 * @param {array} aTransports the available transports.
	 * @returns {object} the transport, if the LREP object is already locked in one of the transports, <code>null</code> otherwise.
	 * @private
	 */
	TransportSelection.prototype._hasLock = function(aTransports) {
		var len = aTransports.length;

		while (len--) {
			var oTransport = aTransports[len];

			if (oTransport.locked) {
				return oTransport;
			}
		}

		return false;
	};

	/**
	 * Sets the transports for all changes.
	 *
	 * @param {array} aChanges array of {sap.ui.fl.Change}
	 * @param {object} oControl object of the root control for the transport
	 * @returns {Promise} promise that resolves without parameters
	 * @public
	 */
	TransportSelection.prototype.setTransports = function(aChanges, oControl) {
		// do a synchronous loop over all changes to fetch transport information per change each after the other
		// this is needed because only one transport popup should be shown to the user and not one per change

		var iChangeIdx = aChanges.length - 1;
		var that = this;
		var fnSetTransports = function(aChanges, iChangeIdx, oControl, sTransport, bFromDialog) {
			if (iChangeIdx >= 0) {
				var oCurrentChange = aChanges[iChangeIdx];

				if (bFromDialog === true) {
					// if the request has been set by the transport dialog already,
					// do not bring up the transport dialog a second time, but use this transport instead
					// if the change is locked on another transport, this will be resolved in the back end when the DELETE request is send
					if (oCurrentChange.getDefinition().packageName !== "$TMP") {
						oCurrentChange.setRequest(sTransport);
					}
					iChangeIdx--;
					// set the transport for the next request
					return fnSetTransports(aChanges, iChangeIdx, oControl, sTransport, bFromDialog);
				} else {
					// bring up the transport dialog to get the transport information for a change
					if (oCurrentChange.getDefinition().packageName !== "$TMP") {
						return that.openTransportSelection(oCurrentChange, oControl).then(function(oTransportInfo) {

							oCurrentChange.setRequest(oTransportInfo.transport);

							if (oTransportInfo.fromDialog === true) {
								sTransport = oTransportInfo.transport;
								bFromDialog = true;
							}

							iChangeIdx--;
							// set the transport for the next request
							return fnSetTransports(aChanges, iChangeIdx, oControl, sTransport, bFromDialog);
						}, function () {
							return null;
						});
					} else {
						iChangeIdx--;
						// set the transport for the next request
						return fnSetTransports(aChanges, iChangeIdx, oControl, sTransport, bFromDialog);
					}
				}
			} else {
				return Promise.resolve(); // last change has been processed, continue with discarding the changes
			}
		};

		return fnSetTransports(aChanges, iChangeIdx, oControl);
	};

	/**
	 * Opens the transport selection dialog
	 *
	 * @param {sap.ui.fl.Change} [oChange] - the change for which the transport information should be retrieved
	 * @param {object} oControl
	 * @returns {Promise} promise that resolves
	 * @public
	 */
	TransportSelection.prototype.openTransportSelection = function(oChange, oControl) {

		var that = this;

		return new Promise(function(resolve, reject) {
			var fnOkay = function(oResult) {
				if (oResult && oResult.getParameters) {
					var sTransport = oResult.getParameters().selectedTransport;
					var sPackage = oResult.getParameters().selectedPackage;
					var bFromDialog = oResult.getParameters().dialog;
					var oTransportInfo = {
						transport: sTransport,
						packageName: sPackage,
						fromDialog: bFromDialog
					};
					resolve(oTransportInfo);
				} else {
					resolve({});
				}
			};
			var fnError = function(oError) {
				if (oError.sId === 'cancel') {
					resolve();
				} else {
					reject(oError);
				}
			};
			var oObject = {}; // no restriction on package, name or name space
			if (oChange) {
				oObject["package"] = oChange.getPackage();
				oObject.namespace = oChange.getNamespace();
				oObject.name = oChange.getId();
				oObject.type = oChange.getDefinition().fileType;
			}

			that.selectTransport(oObject, fnOkay, fnError, false, oControl);
		});
	};

	return TransportSelection;
}, true);

}; // end of sap/ui/fl/transport/TransportSelection.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.Persistence') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.Persistence'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/Persistence",[
	"sap/ui/fl/Change", "sap/ui/fl/DefaultVariant",  "sap/ui/fl/StandardVariant", "sap/ui/fl/Utils", "jquery.sap.global", "sap/ui/fl/LrepConnector", "sap/ui/fl/Cache"
], function(Change, defaultVariant, standardVariant, Utils, $, LRepConnector, Cache) {

	"use strict";
	/**
	 * Helper object to access a change from the back end. Access helper object for each change (and variant) which was fetched from the back end
	 *
	 * @constructor
	 * @param {sap.ui.core.Control} oControl - the control for which the changes should be fetched
	 * @param {string} [sStableIdPropertyName='id'] the stable id
	 * @alias sap.ui.fl.Persistence
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.25.0
	 */
	var Persistence = function(oControl, sStableIdPropertyName) {
		this._oControl = oControl;
		this._bHasLoadedChangesFromBackEnd = false;

		this._sStableIdPropertyName = sStableIdPropertyName || 'id';
		this._sStableId = this._getStableId();

		this._sComponentName = Utils.getComponentClassName(oControl);
		if (!this._sComponentName) {
			Utils.log.error("The Control does not belong to an SAPUI5 component. Variants and Changes for this control might not work as expected.");
		}
		this._oAppDescriptor = Utils.getAppDescriptor(oControl);
		this._sAppVersion = Utils.getAppVersionFromManifest(this._oAppDescriptor);
		this._sSiteId = Utils.getSiteId(oControl);

		this._oChanges = {};
		this._oMessagebundle = {};

		this._oConnector = this._createLrepConnector();
	};

	/**
	 * Return the name of the SAPUI5 component. All changes are assigned to 1 SAPUI5 component. The SAPUI5 component also serves as authorization
	 * object.
	 *
	 * @returns {String} component name
	 * @public
	 */
	Persistence.prototype.getComponentName = function() {
		return this._sComponentName;
	};

	/**
	 * Return the name of the SAPUI5 component. All changes are assigned to 1 SAPUI5 component. The SAPUI5 component also serves as authorization
	 * object.
	 *
	 * @param {string} sComponentName The name of the component
	 * @public
	 */
	Persistence.prototype.setComponentName = function(sComponentName) {
		this._sComponentName = sComponentName;
	};

	/**
	 * Creates a new instance of the LRepConnector
	 *
	 * @returns {sap.ui.fl.LrepConnector} LRep connector instance
	 * @private
	 */
	Persistence.prototype._createLrepConnector = function() {
		var sXsrfToken, mParams;
		sXsrfToken = Utils.getXSRFTokenFromControl(this._oControl);
		mParams = {
			XsrfToken: sXsrfToken
		};
		return LRepConnector.createConnector(mParams);
	};

	/**
	 * Determines the value of the stable id property of the control
	 *
	 * @returns {String} Stable Id. Empty string if stable id determination failed
	 * @private
	 */
	Persistence.prototype._getStableId = function() {
		if (!this._oControl) {
			return undefined;
		}

		if ((this._sStableIdPropertyName) && (this._sStableIdPropertyName !== 'id')) {
			var sStableId;
			try {
				sStableId = this._oControl.getProperty(this._sStableIdPropertyName);
			} catch (exception) {
				sStableId = "";
			}
			return sStableId;
		}

		if (typeof this._oControl.getId !== 'function') {
			return undefined;
		}

		return this._oControl.getId();
	};

	/**
	 * Checks for the existance of a variant within the vendor layer
	 *
	 * @returns {boolean} bExistChangeInVendorLayer
	 * @private
	 */
	Persistence.prototype._existVendorLayerChange = function() {
		var bExistChangeInVendorLayer = false;

		jQuery.each(this._oChanges, function(sChangeKey, oChange) {
			var oOriginDefinition = oChange._oOriginDefinition;
			if (oOriginDefinition.layer === "VENDOR") {
				bExistChangeInVendorLayer = true;
				return false; // break foreach;
			}
		});

		return bExistChangeInVendorLayer;
	};

	/**
	 * Searches for the ower (sap.ui.Component) of passed control
	 *
	 * @param {object} oControl a ui5Control
	 * @returns {sap.ui.Component} oOwnerComponent
	 * @private
	 */
	Persistence.prototype._getOwnerComponentOfControl = function(oControl) {
		if (!oControl) {
			return undefined;
		}

		var sOwnerId = sap.ui.core.Component.getOwnerIdFor(oControl);
		if (sOwnerId) {
			var oOwnerComponent = sap.ui.component(sOwnerId);
			return oOwnerComponent;
		}

		return this._getOwnerComponentOfControl(oControl.getParent());
	};

	/**
	 * Binds a json model to the component the first time a variant within the vendor layer was detected
	 *
	 * @private
	 */
	Persistence.prototype._checkForMessagebundleBinding = function() {
		if (this._existVendorLayerChange()) {
			var oOwner = this._getOwnerComponentOfControl(this._oControl);

			if (oOwner && !oOwner.getModel("i18nFlexVendor")) {
				var oModel = new sap.ui.model.json.JSONModel(this._oMessagebundle);
				oOwner.setModel(oModel, "i18nFlexVendor");
			}
		}
	};

	/**
	 * Calls the back end asynchronously and fetches all changes and variants in the same component pointing to this control.
	 *
	 * @see sap.ui.fl.Change
	 * @returns {Promise} with parameter <code>aResults</code> which is a map with key changeId and value instance of sap.ui.fl.Change
	 * @public
	 */
	Persistence.prototype.getChanges = function() {
		var that = this;
		var mPropertyBag = {
			appDescriptor: this._oAppDescriptor,
			siteId: this._sSiteId
		};

		if (this._bHasLoadedChangesFromBackEnd === true) {
			if (this._oMessagebundle) {
				this._checkForMessagebundleBinding();
			}
			return Promise.resolve(this._oChanges);
		}
		return Cache.getChangesFillingCache(this._oConnector, {name : this._sComponentName, appVersion: this._sAppVersion}, mPropertyBag).then(that._resolveFillingCacheWithChanges.bind(that));
	};

	/**
	 * Intern method of 'getChanges' to handle the resolution of the deferred returned from 'Cache.getChangesFillingCache'.
	 *
	 * @returns {object} this._oChanges relevant changes filled by internal processing
	 * @private
	 */
	Persistence.prototype._resolveFillingCacheWithChanges = function(oFile) {
		this._fillRelevantChanges(oFile);
		if (oFile && oFile.changes && oFile.changes.messagebundle) {
			this._oMessagebundle = oFile.changes.messagebundle;
			this._checkForMessagebundleBinding();
		}
		this._bHasLoadedChangesFromBackEnd = true;
		return this._oChanges;
	};

	/**
	 * Calls the back end asynchronously and fetches all changes and variants of the current component.
	 *
	 * @see sap.ui.fl.Change
	 * @returns {Promise} with parameter <code>aResults</code> which is a map with key changeId and value instance of sap.ui.fl.Change
	 * @public
	 */
	Persistence.prototype.getComponentChanges = function() {
		var that = this;
		var mPropertyBag = {
			appDescriptor: this._oAppDescriptor,
			siteId: this._sSiteId
		};
		return Cache.getChangesFillingCache(this._oConnector, {name : this._sComponentName, appVersion: this._sAppVersion}, mPropertyBag).then(function(oFile) {
			var bNoFilter = true;
			that._fillRelevantChanges(oFile, bNoFilter);
			return that._oChanges;
		});
	};

	/**
	 * Fill the map of <code>sap.ui.fl.Change</code> with all relevant changes
	 *
	 * @param {object} oFile content of Component-changes.json file
	 * @param {boolean} bNoFilter do not filter on stable ID
	 * @see sap.ui.fl.Change
	 * @private
	 */
	Persistence.prototype._fillRelevantChanges = function(oFile, bNoFilter) {
		var aChangeList, len, oChangeContent, oSelector, oChange, j, sChangeId;
		var that = this;

		var fLogError = function(key, text) {
			Utils.log.error("key : " + key + " and text : " + text.value);
		};

		var fAppendValidChanges = function(id, value) {
			// when filtering set to inactive: add all changes but still filter variants
			if (bNoFilter === true && oChangeContent.fileType === 'change' || that._sStableId === value) {
				oChange = new Change(oChangeContent);
				oChange.attachEvent(Change.events.markForDeletion, that._onDeleteChange.bind(that));
				sChangeId = oChange.getId();
				if (oChange.isValid()) {
					if (that._oChanges[sChangeId] && oChange.isVariant()) {
						Utils.log.error("Id collision - two or more variant files having the same id detected: " + sChangeId);
						jQuery.each(oChange.getDefinition().texts, fLogError);
						Utils.log.error("already exists in variant : ");
						jQuery.each(that._oChanges[sChangeId].getDefinition().texts, fLogError);
					}

					that._oChanges[sChangeId] = oChange;
				}
				return false;
			}
		};

		if (oFile && oFile.changes && oFile.changes.changes) {
			aChangeList = oFile.changes.changes;
			len = aChangeList.length;
			for (j = 0; j < len; j++) {
				//filter out user changes and variants when no personalization was triggered
				if (!Utils.isOverMaxLayer(aChangeList[j].layer)){
					oChangeContent = aChangeList[j];
					oSelector = oChangeContent.selector;
					if (oSelector) {
						// filter out only controls of the current
						jQuery.each(oSelector, fAppendValidChanges);
					}
				}
			}
		}
	};

	/**
	 * Returns the change for the provided id.
	 *
	 * @see sap.ui.fl.Change
	 * @param {string} sChangeId - the id of the change to get
	 * @returns {sap.ui.fl.Change} the found change
	 * @public
	 */
	Persistence.prototype.getChange = function(sChangeId) {
		if (!sChangeId) {
			Utils.log.error("sap.ui.fl.Persistence.getChange : sChangeId is not defined");
			return undefined;
		}

		return this._oChanges[sChangeId];
	};

	/**
	 * Adds a new change (could be variant as well) and returns the id of the new change.
	 *
	 * @param {object} mParameters map of parameters, see below
	 * @param {string} mParameters.type - type <filterVariant, tableVariant, etc>
	 * @param {string} mParameters.ODataService - name of the OData service --> can be null
	 * @param {object} mParameters.texts - map object with all referenced texts within the file these texts will be connected to the translation
	 *        process
	 * @param {object} mParameters.content - content of the new change
	 * @param {boolean} mParameters.isVariant - indicates if the change is a variant
	 * @param {string} mParameters.packageName - <optional> package name for the new entity <default> is $tmp
	 * @param {boolean} mParameters.isUserDependent - indicates if a change is only valid for the current user
	 * @param {boolean} [mParameters.id] - id of the change. The id has to be globally unique and should only be set in exceptional cases for example
	 *        downport of variants
	 * @returns {string} the ID of the newly created change
	 * @public
	 */
	Persistence.prototype.addChange = function(mParameters) {
		var oFile, oInfo, mInternalTexts, oChange;

		if (!mParameters) {
			return undefined;
		}
		if (!mParameters.type) {
			Utils.log.error("sap.ui.fl.Persistence.addChange : type is not defined");
		}
		//if (!mParameters.ODataService) {
		//	Utils.log.error("sap.ui.fl.Persistence.addChange : ODataService is not defined");
		//}
		var sContentType = jQuery.type(mParameters.content);
		if (sContentType !== 'object' && sContentType !== 'array') {
			Utils.log.error("mParameters.content is not of expected type object or array, but is: " + sContentType, "sap.ui.fl.Persistence#addChange");
		}
		// convert the text object to the internal structure
		mInternalTexts = {};
		if (typeof (mParameters.texts) === "object") {
			jQuery.each(mParameters.texts, function(id, text) {
				mInternalTexts[id] = {
					value: text,
					type: "XFLD"
				};
			});
		}

		var oValidAppVersions = {
			creation: this._sAppVersion,
			from: this._sAppVersion
		};
		if (this._sAppVersion && mParameters.developerMode) {
			oValidAppVersions.to = this._sAppVersion;
		}

		oInfo = {
			changeType: mParameters.type,
			service: mParameters.ODataService,
			texts: mInternalTexts,
			content: mParameters.content,
			reference: this._sComponentName, //in this case the component name can also be the value of sap-app-id
			isVariant: mParameters.isVariant,
			packageName: mParameters.packageName,
			isUserDependent: mParameters.isUserDependent,
			validAppVersions: oValidAppVersions
		};

		oInfo.selector = this._getSelector();
		oFile = Change.createInitialFileContent(oInfo);

		// If id is provided, overwrite generated id
		if (mParameters.id) {
			oFile.fileName = mParameters.id;
		}

		oChange = this.addChangeFile(oFile);
		return oChange.getId();
	};

	/**
	 * Adds a new change (could be variant as well) and returns the id of the new change.
	 *
	 * @param {object} oChangeFile The complete and finalized JSON object representation the file content of the change
	 * @returns {sap.ui.fl.Change} the newly created change object
	 * @public
	 */
	Persistence.prototype.addChangeFile = function(oChangeFile) {
		var oChange, sChangeId;

		oChange = new Change(oChangeFile);
		oChange.attachEvent(Change.events.markForDeletion, this._onDeleteChange.bind(this));

		sChangeId = oChange.getId();
		this._oChanges[sChangeId] = oChange;
		return oChange;
	};

	Persistence.prototype.removeChangeFromPersistence = function(oChange) {
		if (oChange.getPendingAction() !== 'NEW') {
			return;
		}

		var sChangeToRemoveId = oChange.getId();
		delete this._oChanges[sChangeToRemoveId];
	};

	/**
	 * Puts an existing change into the persistence.
	 *
	 * @param {sap.ui.fl.Change} oChange object
	 * @public
	 */
	Persistence.prototype.putChange = function(oChange) {
		oChange.attachEvent(Change.events.markForDeletion, this._onDeleteChange.bind(this));
		var sChangeId = oChange.getId();
		this._oChanges[sChangeId] = oChange;
	};

	/**
	 * Returns a selector filled with the stableIdPropertyName and its value.
	 *
	 * @returns {Object} selector
	 * @private
	 */
	Persistence.prototype._getSelector = function() {
		var mSelector;
		mSelector = {};
		if (this._sStableIdPropertyName) {
			mSelector[this._sStableIdPropertyName] = this._sStableId;
		}
		return mSelector;
	};

	/**
	 * Retrieves the execute on select for the standard variant for the current control
	 *
	 * @returns {boolean} execute on select flag
	 * @public
	 */
	Persistence.prototype.getExecuteOnSelect = function() {
		return this.getChanges().then(function(oChanges) {
			return standardVariant.getExecuteOnSelect(oChanges);
		});
	};

	/**
	 * Retrieves the execute on select for the standard variant for the current control synchronously. WARNING: It is the responsibility of the consumer to make sure, that the
	 * changes have already been retrieved with getChanges. It's recommended to use the async API getExecuteOnSelect which works regardless of any
	 * preconditions.
	 *
	 * @returns {boolean} execute on select flag
	 * @public
	 */
	Persistence.prototype.getExecuteOnSelectSync = function() {
		return standardVariant.getExecuteOnSelect(this._oChanges);
	};

	/**
	 * Sets the execute on select for the standard variant for the current control. A new change object is created or an existing is updated. This change object is kept in
	 * memory and can be flushed using saveAll. WARNING: It is the responsibility of the consumer to make sure, that the changes have already been
	 * retrieved with getChanges. It's recommended to use the async API setExecuteOnSelect which works regardless of any preconditions.
	 *
	 * @param {boolean} bExecuteOnSelect the new execute on select flag for standard variant
	 * @returns {Object} the default variant change
	 * @public
	 */
	Persistence.prototype.setExecuteOnSelectSync = function(bExecuteOnSelect) {
		var mParameters, oChange;

		var selector = {};
		selector[this._sStableIdPropertyName] = this._sStableId;

		mParameters = {
			executeOnSelect: bExecuteOnSelect,
			reference: this._sComponentName,
			selector: selector
		};

		oChange = standardVariant.updateExecuteOnSelect(this._oChanges, bExecuteOnSelect);

		if (oChange) {
			return oChange;
		}

		oChange = standardVariant.createChangeObject(mParameters);
		oChange.attachEvent(Change.events.markForDeletion, this._onDeleteChange.bind(this));
		var sChangeId = oChange.getId();
		this._oChanges[sChangeId] = oChange;
		return oChange;
	};

	/**
	 * Sets the default variant for the current control. A new change object is created or an existing is updated. This change object is kept in
	 * memory and can be flushed using saveAll.
	 *
	 * @param {boolean} bExecuteOnSelect the new execute on select flag for standard variant
	 * @returns {Promise} the default variant change
	 * @public
	 */
	Persistence.prototype.setExecuteOnSelect = function(bExecuteOnSelect) {
		var mParameters, oChange;
		var that = this;

		return this.getChanges().then(function(oChanges) {
			var selector = {};
			selector[that._sStableIdPropertyName] = that._sStableId;

			mParameters = {
				executeOnSelect: bExecuteOnSelect,
				reference: that._sComponentName,
				selector: selector
			};

			oChange = standardVariant.updateExecuteOnSelect(oChanges, bExecuteOnSelect);

			if (oChange) {
				return oChange;
			}

			oChange = standardVariant.createChangeObject(mParameters);
			oChange.attachEvent(Change.events.markForDeletion, that._onDeleteChange.bind(that));
			oChanges[oChange.getId()] = oChange;
			return oChange;
		});
	};

	/**
	 * Retrieves the default variant for the current control
	 *
	 * @returns {String} id of the default variant
	 * @public
	 */
	Persistence.prototype.getDefaultVariantId = function() {
		return this.getChanges().then(function(oChanges) {
			return defaultVariant.getDefaultVariantId(oChanges);
		});
	};

	/**
	 * Retrieves the default variant for the current control synchronously. WARNING: It is the responsibility of the consumer to make sure, that the
	 * changes have already been retrieved with getChanges. It's recommended to use the async API getDefaultVariantId which works regardless of any
	 * preconditions.
	 *
	 * @returns {String} id of the default variant
	 * @public
	 */
	Persistence.prototype.getDefaultVariantIdSync = function() {
		return defaultVariant.getDefaultVariantId(this._oChanges);
	};

	/**
	 * Sets the default variant for the current control. A new change object is created or an existing is updated. This change object is kept in
	 * memory and can be flushed using saveAll. WARNING: It is the responsibility of the consumer to make sure, that the changes have already been
	 * retrieved with getChanges. It's recommended to use the async API setDefaultVariantId which works regardless of any preconditions.
	 *
	 * @param {string} sDefaultVariantId - the ID of the new default variant
	 * @returns {Object} the default variant change
	 * @public
	 */
	Persistence.prototype.setDefaultVariantIdSync = function(sDefaultVariantId) {
		var mParameters, oChange;

		var selector = {};
		selector[this._sStableIdPropertyName] = this._sStableId;

		mParameters = {
			defaultVariantId: sDefaultVariantId,
			reference: this._sComponentName,
			selector: selector
		};

		oChange = defaultVariant.updateDefaultVariantId(this._oChanges, sDefaultVariantId);

		if (oChange) {
			return oChange;
		}

		oChange = defaultVariant.createChangeObject(mParameters);
		oChange.attachEvent(Change.events.markForDeletion, this._onDeleteChange.bind(this));
		var sChangeId = oChange.getId();
		this._oChanges[sChangeId] = oChange;
		return oChange;
	};

	/**
	 * Sets the default variant for the current control. A new change object is created or an existing is updated. This change object is kept in
	 * memory and can be flushed using saveAll.
	 *
	 * @param {string} sDefaultVariantId - the ID of the new default variant
	 * @returns {Promise} the default variant change
	 * @public
	 */
	Persistence.prototype.setDefaultVariantId = function(sDefaultVariantId) {
		var mParameters, oChange;
		var that = this;

		return this.getChanges().then(function(oChanges) {
			var selector = {};
			selector[that._sStableIdPropertyName] = that._sStableId;

			mParameters = {
				defaultVariantId: sDefaultVariantId,
				reference: that._sComponentName,
				selector: selector
			};

			oChange = defaultVariant.updateDefaultVariantId(oChanges, sDefaultVariantId);

			if (oChange) {
				return oChange;
			}

			oChange = defaultVariant.createChangeObject(mParameters);
			oChange.attachEvent(Change.events.markForDeletion, that._onDeleteChange.bind(that));
			oChanges[oChange.getId()] = oChange;
			return oChange;
		});
	};

	/**
	 * Saves/flushes all current changes to the back end.
	 *
	 * @returns {Promise} resolving with an array of responses or rejecting with the first error
	 * @public
	 */
	Persistence.prototype.saveAll = function() {
		var aPromises = [];
		var that = this;
		jQuery.each(this._oChanges, function(id, oChange) {
			switch (oChange.getPendingAction()) {
				case "NEW":
					aPromises.push(that._oConnector.create(oChange.getDefinition(), oChange.getRequest(), oChange.isVariant()).then(function(result) {
						oChange.setResponse(result.response);
						if (Cache.isActive()) {
							Cache.addChange({ name: that._sComponentName, appVersion: that._sAppVersion}, result.response);
						}
						return result;
					}));
					break;
				case "UPDATE":
					aPromises.push(that._oConnector.update(oChange.getDefinition(), oChange.getId(), oChange.getRequest(), oChange.isVariant()).then(function(result) {
						oChange.setResponse(result.response);
						if (Cache.isActive()) {
							Cache.updateChange({ name: that._sComponentName, appVersion: that._sAppVersion}, result.response);
						}
						return result;
					}));
					break;
				case "DELETE":
					aPromises.push(that._oConnector.deleteChange({
						sChangeName: oChange.getId(),
						sLayer: oChange.getLayer(),
						sNamespace: oChange.getNamespace(),
						sChangelist: oChange.getRequest()
					}, oChange.isVariant()).then(function(result) {
						var sChangeId = oChange.getId();
						// remove change from all referring Persistence instances
						var mParameter = {
							id: sChangeId
						};
						oChange.fireEvent(Change.events.markForDeletion, mParameter);
						if (Cache.isActive()) {
							Cache.deleteChange({ name: that._sComponentName, appVersion: that._sAppVersion}, oChange.getDefinition());
						}
						return result;
					}));
					break;
				default:
					break;
			}
		});

		// TODO Consider not rejecting with first error, but wait for all promises and collect the results
		return Promise.all(aPromises);
	};

	/**
	 * Event Handler for deletion event of sap.ui.fl.Change. Removes the change from the internal changes map
	 *
	 * @param {object} oEvent - the event with parameters
	 * @private
	 */
	Persistence.prototype._onDeleteChange = function(oEvent) {
		var sChangeId;
		sChangeId = oEvent.getParameter("id");

		var oChange = this.getChange(sChangeId);
		if (oChange.getPendingAction() === "DELETE") {
			delete this._oChanges[sChangeId];
		}
	};

	/**
	 * Returns a flag whether the variant downport scenario is enabled or not. This scenario is only enabled if the current layer is the vendor layer
	 * and the url paramater hotfix is set to true.
	 *
	 * @returns {boolean} Flag whether the variant downport scenario is enabled
	 * @public
	 */
	Persistence.prototype.isVariantDownport = function() {
		var sLayer, bIsHotfix;
		sLayer = Utils.getCurrentLayer();
		bIsHotfix = Utils.isHotfixMode();

		return ((sLayer === 'VENDOR') && (bIsHotfix));
	};

	return Persistence;
}, true);

}; // end of sap/ui/fl/Persistence.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.core.EventDelegate') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.core.EventDelegate'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.EventProvider'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/core/EventDelegate",[
	"jquery.sap.global", "sap/ui/fl/Utils", "sap/ui/base/EventProvider", "sap/ui/fl/registry/ChangeRegistry", "sap/ui/fl/core/FlexVisualizer"
], function (jQuery, Utils, EventProvider, ChangeRegistry, FlexVisualizer) {
	"use strict";

	/**
	 *
	 * @constructor
	 * @param {sap.ui.core.Control} oControl Control reference of the control which is currently in focus
	 * @param {Object} oSupportedRegistryItems Object with supported changes as registry items. Structure matches the returnvalue of @see sap.ui.fl.registry.ChangeRegistry#getRegistryItems	 *
	 * @alias sap.ui.fl.core.EventDelegate
	 *
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 * @private
	 *
	 */
	var EventDelegate = function (oControl, oSupportedRegistryItems) {
		if (!oControl) {
			Utils.log.error("sap.ui.fl.core.EventDelegate: Control required");
		}
		if (!oSupportedRegistryItems) {
			Utils.log.error("sap.ui.fl.core.EventDelegate: Supported registry items required");
		}

		EventProvider.apply(this);

		this._oControl = oControl;
		this._oSupportedRegistryItems = oSupportedRegistryItems;
	};

	EventDelegate.prototype = jQuery.sap.newObject(EventProvider.prototype);

	/**
	 * Register a control for using flexibility
	 * @param {sap.ui.core.Control} oControl Control which should be registered
	 *
	 * @public
	 */
	EventDelegate.registerControl = function (oControl) {
		if (oControl) {
			// check if the control is already registered
			var i = 0;
			if (oControl.aDelegates) {
				for (i = 0; i < oControl.aDelegates.length; i++) {
					var sType = "";
					if (oControl.aDelegates[i].oDelegate && oControl.aDelegates[i].oDelegate.getType) {
						sType = (oControl.aDelegates[i].oDelegate.getType());
					}
					if (sType === "Flexibility") {
						return; // already added
					}
				}
			}
			EventDelegate.registerExplicitChanges(oControl);
		}
	};

	/**
	 * Register a control for explicit changes - changes which use a dialog or similar to do the change and can only be activated in a certain mode
	 * @param {sap.ui.core.Control} oControl Control which should be registered
	 *
	 * @public
	 */
	EventDelegate.registerExplicitChanges = function (oControl) {
		var oRegistry = ChangeRegistry.getInstance();
		var mParam = {
			controlType: Utils.getControlType(oControl)
		};
		var oSupportedRegistryItems = oRegistry.getRegistryItems(mParam);

		// check if the control will be handled by personalization
		if (Object.keys(oSupportedRegistryItems).length > 0) {
			oControl.addEventDelegate(new EventDelegate(oControl, oSupportedRegistryItems));
		}
	};

	/**
	 * Unregister the control which was registered before
	 *
	 * @public
	 */
	EventDelegate.unregisterControl = function () {

	};

	/**
	 * Function which is called on mouse-over on the registered control to trigger the flexibility framework
	 * @param {sap.ui.core.Event} oEvent Event parameters
	 *
	 * @public
	 */
	EventDelegate.prototype.onmouseover = function (oEvent) {
		oEvent.stopPropagation();
		// stopPropagation unfortunately kills column resize of table
		// therefore custom property on the event
		if (oEvent.handled) {
			return;
		} else {
			oEvent.handled = true;
		}

		//TODO: Get from FlexController, once checked-in
		if (FlexVisualizer.isPersonalizationMode()) {
			if (this._oControl && !jQuery(this._oControl.getDomRef()).hasClass("sapuiflex-highlight")) {
				FlexVisualizer.showDialog(this._oControl);
			}
		}
	};

	/**
	 * Function which is called on mouse-out on the registered control to notify that the control is not in scope anymore for flexibility
	 * @param {sap.ui.core.Event} oEvent Event parameters
	 *
	 * @public
	 */
	EventDelegate.prototype.onmouseout = function (oEvent) {
		//TODO: Get from FlexController, once checked-in
		if (FlexVisualizer.isPersonalizationMode()) {
			if (this._oControl) {
				FlexVisualizer.closeDialog();
			}
		}
	};

	return EventDelegate;
}, true);

}; // end of sap/ui/fl/core/EventDelegate.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.registry.ChangeHandlerRegistration') ) {
/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/

jQuery.sap.declare('sap.ui.fl.registry.ChangeHandlerRegistration'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/registry/ChangeHandlerRegistration",["sap/ui/fl/registry/ChangeRegistry"], function(ChangeRegistry) {
	"use strict";

	var ChangeHandlerRegistration = {
		getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs: function () {
			var that = this;
			var oCore = sap.ui.getCore();
			var oAlreadyLoadedLibraries = oCore.getLoadedLibraries();

			jQuery.each(oAlreadyLoadedLibraries, function (sLibraryName, oLibrary) {
				if (oLibrary.extensions && oLibrary.extensions.flChangeHandlers) {
					that.registerFlexChangeHandlers(oLibrary.extensions.flChangeHandlers);
				}
			});

			oCore.attachLibraryChanged(this.handleLibraryRegistrationAfterFlexLibraryIsLoaded.bind(this));

		},

		registerFlexChangeHandlers: function (oFlChangeHandlers) {
			if (oFlChangeHandlers) {
				var oChangeRegistryInstance = ChangeRegistry.getInstance();
				oChangeRegistryInstance.registerControlsForChanges(oFlChangeHandlers);
			}
		},

		handleLibraryRegistrationAfterFlexLibraryIsLoaded: function (oLibraryChangedEvent) {
			if (oLibraryChangedEvent.getParameter("operation") === "add") {
				var oLibMetadata = oLibraryChangedEvent.getParameter("metadata");
				if (oLibMetadata && oLibMetadata.extensions && oLibMetadata.extensions.flChangeHandlers) {
					var oFlChangeHandlers = oLibMetadata.extensions.flChangeHandlers;
					this.registerFlexChangeHandlers(oFlChangeHandlers);
				}
			}
		}
	};

	return ChangeHandlerRegistration;

}, true);

}; // end of sap/ui/fl/registry/ChangeHandlerRegistration.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.FlexController') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.FlexController'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.View'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/FlexController",[
	"jquery.sap.global",
	"sap/ui/fl/Persistence",
	"sap/ui/fl/registry/ChangeRegistry",
	"sap/ui/fl/Utils",
	"sap/ui/fl/LrepConnector",
	"sap/ui/fl/Change",
	"sap/ui/fl/Cache",
	"sap/ui/fl/registry/Settings",
	"sap/ui/fl/ChangePersistenceFactory",
	"sap/ui/core/mvc/View",
	"sap/ui/fl/changeHandler/JsControlTreeModifier",
	"sap/ui/fl/changeHandler/XmlTreeModifier",
	"sap/ui/fl/context/ContextManager"
], function (jQuery, Persistence, ChangeRegistry, Utils, LrepConnector, Change, Cache, FlexSettings, ChangePersistenceFactory, View, JsControlTreeModifier, XmlTreeModifier, ContextManager) {
	"use strict";

	/**
	 * Retrieves changes (LabelChange, etc.) for an sap.ui.core.mvc.View and applies these changes
	 *
	 * @param {string} sComponentName - Component name the flexibility controller is responsible for
	 * @param {string} sAppVersion - Current version of the application
	 * @constructor
	 * @class
	 * @alias sap.ui.fl.FlexController
	 * @experimental Since 1.27.0
	 * @author SAP SE
	 * @version 1.48.6
	 */
	var FlexController = function (sComponentName, sAppVersion) {
		this._oChangePersistence = undefined;
		this._sComponentName = sComponentName || "";
		this._sAppVersion = sAppVersion || Utils.DEFAULT_APP_VERSION;
		if (this._sComponentName && this._sAppVersion) {
			this._createChangePersistence();
		}
	};

	FlexController.appliedChangesCustomDataKey = "sap.ui.fl:AppliedChanges";
	FlexController.PENDING = "sap.ui.fl:PendingChange";
	FlexController.PROCESSING = "sap.ui.fl:ProcessingChange";

	/**
	 * Sets the component name of the FlexController
	 *
	 * @param {String} sComponentName The name of the component
	 * @public
	 */
	FlexController.prototype.setComponentName = function (sComponentName) {
		this._sComponentName = sComponentName;
		this._createChangePersistence();
	};

	/**
	 * Returns the component name of the FlexController
	 *
	 * @returns {String} the name of the component
	 * @public
	 */
	FlexController.prototype.getComponentName = function () {
		return this._sComponentName;
	};

	/**
	 * Returns the application version of the FlexController
	 *
	 * @returns {String} Application version
	 * @public
	 */
	FlexController.prototype.getAppVersion = function () {
		return this._sAppVersion;
	};

	/**
	 * Returns the variant model object
	 *
	 * @returns {Object} Variant Model Object
	 * @public
	 */
	FlexController.prototype.getVariantModelData = function () {
		var oData;
		if (this._oChangePersistence &&
				this._oChangePersistence._oVariantController._mVariantManagement &&
				Object.keys(this._oChangePersistence._oVariantController._mVariantManagement).length > 0) {
			oData = this._oChangePersistence._oVariantController._fillVariantModel();
		}

		return oData;
	};

	/**
	 * Create a change
	 *
	 * @param {object} oChangeSpecificData property bag (nvp) holding the change information (see sap.ui.fl.Change#createInitialFileContent
	 *        oPropertyBag). The property "packageName" is set to $TMP and internally since flex changes are always local when they are created.
	 * @param {sap.ui.core.Control | map} oControl - control for which the change will be added
	 * @param {string} oControl.id id of the control in case a map has been used to specify the control
	 * @param {sap.ui.base.Component} oControl.appComponent application component of the control at runtime in case a map has been used
	 * @param {string} oControl.controlType control type of the control in case a map has been used
	 * @returns {sap.ui.fl.Change} the created change
	 * @public
	 */
	FlexController.prototype.createChange = function (oChangeSpecificData, oControl) {
		var oChangeFileContent, oChange, ChangeHandler;

		if (!oControl) {
			throw new Error("A flexibility change cannot be created without a targeted control.");
		}

		var aCurrentDesignTimeContext = ContextManager._getContextIdsFromUrl();

		if (aCurrentDesignTimeContext.length > 1) {
			throw new Error("More than one DesignTime Context is currently active.");
		}

		var sControlId = oControl.id || oControl.getId();

		if (!oChangeSpecificData.selector) {
			oChangeSpecificData.selector = {};
		}
		var oAppComponent = oControl.appComponent || Utils.getAppComponentForControl(oControl);
		if (!oAppComponent) {
			throw new Error("No Application Component found - to offer flexibility the control with the id '" + sControlId + "' has to have a valid relation to its owning application component.");
		}
		// differentiate between controls containing the app component id as a prefix and others
		if (Utils.hasLocalIdSuffix(sControlId, oAppComponent)) {
			// get local Id for control at root component and use it as selector id
			var sLocalId = oAppComponent.getLocalId(sControlId);
			if (!sLocalId) {
				throw new Error("Generated ID attribute found ('" + sControlId + "'); provide a stable ID for the control as required by flexibility for assigning the changes.");
			}
			oChangeSpecificData.selector.id = sLocalId;
			oChangeSpecificData.selector.idIsLocal = true;
		} else {
			oChangeSpecificData.selector.id = sControlId;
			oChangeSpecificData.selector.idIsLocal = false;
		}


		oChangeSpecificData.reference = this.getComponentName(); //in this case the component name can also be the value of sap-app-id
		oChangeSpecificData.packageName = "$TMP"; // first a flex change is always local, until all changes of a component are made transportable
		oChangeSpecificData.context = aCurrentDesignTimeContext.length === 1 ? aCurrentDesignTimeContext[0] : "";

		//fallback in case no application descriptor is available (e.g. during unit testing)
		var sAppVersion = this.getAppVersion();
		var oValidAppVersions = {
			creation: sAppVersion,
			from: sAppVersion
		};
		if (sAppVersion && oChangeSpecificData.developerMode) {
			oValidAppVersions.to = sAppVersion;
		}

		oChangeSpecificData.validAppVersions = oValidAppVersions;

		oChangeFileContent = Change.createInitialFileContent(oChangeSpecificData);
		oChange = new Change(oChangeFileContent);
		// for getting the change handler the control type and the change type are needed
		var sControlType = oControl.controlType || Utils.getControlType(oControl);
		if (!sControlType) {
			throw new Error("No control type found - the change handler can not be retrieved.");
		}
		ChangeHandler = this._getChangeHandler(oChange, sControlType);
		if (ChangeHandler) {
			if (/*ChangeHandler.revertChange && */oChangeSpecificData["variantManagementKey"] && oChangeSpecificData["variantKey"]) {
				jQuery.sap.log.error("VariantChange" + "-" + oChangeSpecificData["variantManagementKey"] + "-" + oChangeSpecificData["variantKey"]); /*Only temporary*/
			}
			ChangeHandler.completeChangeContent(oChange, oChangeSpecificData, {
				modifier: JsControlTreeModifier,
				appComponent: oAppComponent
			});
		} else {
			throw new Error("Change handler could not be retrieved for change " + JSON.stringify(oChangeSpecificData) + ".");
		}

		return oChange;
	};

	/**
	 * Adds a change to the flex persistence (not yet saved). Will be saved with #saveAll.
	 *
	 * @param {object} oChangeSpecificData property bag (nvp) holding the change information (see sap.ui.fl.Change#createInitialFileContent
	 *        oPropertyBag). The property "packageName" is set to $TMP and internally since flex changes are always local when they are created.
	 * @param {sap.ui.core.Control} oControl control for which the change will be added
	 * @returns {sap.ui.fl.Change} the created change
	 * @public
	 */
	FlexController.prototype.addChange = function (oChangeSpecificData, oControl) {
		var oChange = this.createChange(oChangeSpecificData, oControl);
		var oComponent = Utils.getAppComponentForControl(oControl);
		this._oChangePersistence.addChange(oChange, oComponent);
		return oChange;
	};

	/**
	 * Adds an already prepared change to the flex persistence (not yet saved). This method will not call
	 * createChange again, but expects a fully computed and appliable change.
	 * Will be saved with #saveAll.
	 *
	 * @param {object} oChange property bag (nvp) holding the change information (see sap.ui.fl.Change#createInitialFileContent
	 *        oPropertyBag). The property "packageName" is set to $TMP and internally since flex changes are always local when they are created
	 * @param {object} oAppComponent component object
	 * @returns {sap.ui.fl.Change} the created change
	 * @public
	 */
	FlexController.prototype.addPreparedChange = function (oChange, oAppComponent) {
		this._oChangePersistence.addChange(oChange, oAppComponent);
		return oChange;
	};

	/**
	 * Prepares a change to be deleted with the next call to
	 * @see {ChangePersistence#saveDirtyChanges};
	 *
	 * If the given change is already in the dirty changes and
	 * has pending action 'NEW' it will be removed, assuming,
	 * it has just been created in the current session;
	 *
	 * Otherwise it will be marked for deletion.
	 *
	 * @param {sap.ui.fl.Change} oChange - the change to be deleted
	 */
	FlexController.prototype.deleteChange = function (oChange) {
		this._oChangePersistence.deleteChange(oChange);
	};

	/**
	 * Creates a new change and applies it immediately
	 *
	 * @param {object} oChangeSpecificData The data specific to the change, e.g. the new label for a RenameField change
	 * @param {sap.ui.core.Control} oControl The control where the change will be applied to
	 * @public
	 */
	FlexController.prototype.createAndApplyChange = function (oChangeSpecificData, oControl) {
		var oChange = this.addChange(oChangeSpecificData, oControl);
		try {
			var mPropertyBag = {
				modifier: JsControlTreeModifier,
				appComponent: Utils.getAppComponentForControl(oControl)
			};
			this.checkTargetAndApplyChange(oChange, oControl, mPropertyBag);
		} catch (oException) {
			this._oChangePersistence.deleteChange(oChange);
			throw oException;
		}
	};

	/**
	 * Saves all changes of a persistence instance.
	 *
	 * @returns {Promise} resolving with an array of responses or rejecting with the first error
	 * @public
	 */
	FlexController.prototype.saveAll = function () {
		return this._oChangePersistence.saveDirtyChanges();
	};

	/**
	 * Loads and applies all changes for the specified xml tree view
	 *
	 * @param {object} oView - the view to process as XML tree
	 * @param {object} mPropertyBag - collection of cross-functional attributes
	 * @param {string} mPropertyBag.viewId - id of the processed view
	 * @param {string} mPropertyBag.componentId - name of the root component of the view
	 * @returns {Promise} without parameters. Promise resolves once all changes of the view have been applied
	 * @public
	 */
	FlexController.prototype.processXmlView = function (oView, mPropertyBag) {
		var oComponent = sap.ui.getCore().getComponent(mPropertyBag.componentId);
		var oAppComponent = Utils.getAppComponentForControl(oComponent);
		var oManifest = oComponent.getManifest();

		mPropertyBag.appComponent = oAppComponent;
		mPropertyBag.appDescriptor = oManifest;
		mPropertyBag.modifier = XmlTreeModifier;
		mPropertyBag.view = oView;

		return this.processViewByModifier(mPropertyBag);
	};

	/**
	 * Loads and applies all changes for the specified view
	 *
	 * @param {object} mPropertyBag - collection of cross-functional attributes
	 * @param {object} mPropertyBag.view - the view to process as XML tree
	 * @param {string} mPropertyBag.viewId - id of the processed view
	 * @param {object} mPropertyBag.modifier - polymorph reuse operations handling the changes on the given view type
	 * @param {string} mPropertyBag.appComponent - app component
	 * @returns {Promise} without parameters. Promise resolves once all changes of the view have been applied
	 * @public
	 */
	FlexController.prototype.processViewByModifier = function (mPropertyBag) {

		mPropertyBag.siteId = Utils.getSiteId(mPropertyBag.appComponent);

		return this._oChangePersistence.getChangesForView(mPropertyBag.viewId, mPropertyBag)

		.then(this._resolveGetChangesForView.bind(this, mPropertyBag),
			this._handlePromiseChainError.bind(this, mPropertyBag.view));
	};

	/**
	 * Looping over all retrieved flexibility changes and applying them onto the targeted control within the view
	 *
	 * @param {object} mPropertyBag - collection of cross-functional attributes
	 * @param {object} mPropertyBag.view - the view to process
	 * @param {string} mPropertyBag.viewId - id of the processed view
	 * @param {string} mPropertyBag.appComponent - app component
	 * @param {object} mPropertyBag.modifier - polymorph reuse operations handling the changes on the given view type
	 * @param {object} mPropertyBag.appDescriptor - app descriptor containing the metadata of the current application
	 * @param {string} mPropertyBag.siteId - id of the flp site containing this application
	 * @param {sap.ui.fl.Change[]} aChanges - list of flexibility changes on controls for the current processed view
	 * @returns {object} Returns view object with all applied changes
	 * @private
	 */
	FlexController.prototype._resolveGetChangesForView = function (mPropertyBag, aChanges) {
		if (!Array.isArray(aChanges)) {
			var sErrorMessage = "No list of changes was passed for processing the flexibility on view: " + mPropertyBag.view + ".";
			Utils.log.error(sErrorMessage, undefined, "sap.ui.fl.FlexController");
			return [];
		}

		aChanges.forEach(function (oChange) {
			try {
				var oSelector = this._getSelectorOfChange(oChange);

				if (!oSelector || !oSelector.id) {
					throw new Error("No selector in change found or no selector ID.");
				}

				var oControl = mPropertyBag.modifier.bySelector(oSelector, mPropertyBag.appComponent, mPropertyBag.view);

				if (!oControl) {
					throw new Error("A flexibility change tries to change a nonexistent control.");
				}

				this.checkTargetAndApplyChange(oChange, oControl, mPropertyBag);

			} catch (oException) {
				this._logApplyChangeError(oException, oChange);
			}
		}.bind(this));

		return mPropertyBag.view;
	};

	FlexController.prototype._logApplyChangeError = function (oException, oChange) {
		var oDefinition = oChange.getDefinition();
		var sChangeType = oDefinition.changeType;
		var sTargetControlId = oDefinition.selector.id;
		var fullQualifiedName = oDefinition.namespace + oDefinition.fileName + "." + oDefinition.fileType;

		var sWarningMessage = "A flexibility change could not be applied.";
		sWarningMessage += "\nThe displayed UI might not be displayed as intedend.";
		if (oException.message) {
			sWarningMessage += "\n   occurred error message: '" + oException.message + "'";
		}
		sWarningMessage += "\n   type of change: '" + sChangeType + "'";
		sWarningMessage += "\n   LRep location of the change: " + fullQualifiedName;
		sWarningMessage += "\n   id of targeted control: '" + sTargetControlId + "'.";

		Utils.log.warning(sWarningMessage, undefined, "sap.ui.fl.FlexController");
	};

	/**
	 * Applying a specific change on the passed control
	 *
	 * @param {sap.ui.fl.Change} oChange - change object which should be applied on the passed control
	 * @param {sap.ui.core.Control} oControl - control which is the target of the passed change
	 * @param {object} mPropertyBag propertyBag passed by the view processing
	 * @param {object} mPropertyBag.view - the view to process
	 * @param {object} mPropertyBag.modifier - polymorph reuse operations handling the changes on the given view type
	 * @param {object} mPropertyBag.appDescriptor - app descriptor containing the metadata of the current application
	 * @param {object} mPropertyBag.appComponent - component instance that is currently loading
	 * @public
	 */
	FlexController.prototype.checkTargetAndApplyChange = function (oChange, oControl, mPropertyBag) {
		var oModifier = mPropertyBag.modifier;
		var sControlType = oModifier.getControlType(oControl);
		var oChangeHandler = this._getChangeHandler(oChange, sControlType);

		if (!oChangeHandler) {
			Utils.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored");
			return;
		}

		var mCustomData = this._getAppliedCustomData(oChange, oControl, oModifier);
		var sAppliedChanges = mCustomData.appliedChangesString;
		var aAppliedChanges = mCustomData.appliedChanges;
		var oAppliedChangeCustomData = mCustomData.appliedChangeCustomData;

		var sChangeId = oChange.getId();

		if (aAppliedChanges.indexOf(sChangeId) === -1) {
			try {
				oChangeHandler.applyChange(oChange, oControl, mPropertyBag);
			} catch (ex) {
				this._setMergeError(true);
				Utils.log.error("Change could not be applied. Merge error detected.");
				return;
			}

			var sValue = sAppliedChanges ? sAppliedChanges + "," + sChangeId : sChangeId;
			this._writeCustomData(oAppliedChangeCustomData, sValue, mPropertyBag, oControl);
		}
	};

	FlexController.prototype._removeFromAppliedChangesAndMaybeRevert = function(oChange, oControl, mPropertyBag, bRevert) {
		var oModifier = mPropertyBag.modifier;
		var sControlType = oModifier.getControlType(oControl);
		var oChangeHandler = this._getChangeHandler(oChange, sControlType);

		if (bRevert && !oChangeHandler) {
			Utils.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored");
			return;
		}

		var mCustomData = this._getAppliedCustomData(oChange, oControl, oModifier);
		var aAppliedChanges = mCustomData.appliedChanges;
		var oAppliedChangeCustomData = mCustomData.appliedChangeCustomData;

		var sChangeId = oChange.getId();
		var iIndex = aAppliedChanges.indexOf(sChangeId);
		if (iIndex > -1) {
			if (bRevert) {
				try {
					oChangeHandler.revertChange(oChange, oControl, mPropertyBag);
				} catch (error) {
					Utils.log.error("Change could not be reverted.");
					return;
				}
			}
			if (oAppliedChangeCustomData) {
				aAppliedChanges.splice(iIndex, 1);
				this._writeCustomData(oAppliedChangeCustomData, aAppliedChanges.join(), mPropertyBag, oControl);
			}
		}
	};

	FlexController.prototype._writeCustomData = function(oCustomData, sValue, mPropertyBag, oControl) {
		var oModifier = mPropertyBag.modifier;

		if (oCustomData) {
			oModifier.setProperty(oCustomData, "value", sValue);
		} else {
			var oAppComponent = mPropertyBag.appComponent;
			var oView = mPropertyBag.view;
			oCustomData = oModifier.createControl("sap.ui.core.CustomData", oAppComponent, oView);
			oModifier.setProperty(oCustomData, "key", FlexController.appliedChangesCustomDataKey);
			oModifier.setProperty(oCustomData, "value", sValue);
			oModifier.insertAggregation(oControl, "customData", oCustomData, 0, oView, true);
		}
	};

	FlexController.prototype._getAppliedCustomData = function(oChange, oControl, oModifier) {
		var aCustomData = oModifier.getAggregation(oControl, "customData") || [];
		var oReturn = {
			appliedChanges: []
		};
		aCustomData.some(function (oCustomData) {
			var sKey = oModifier.getProperty(oCustomData, "key");
			if (sKey === FlexController.appliedChangesCustomDataKey) {
				oReturn.appliedChangeCustomData = oCustomData;
				oReturn.appliedChangesString = oModifier.getProperty(oCustomData, "value");
				oReturn.appliedChanges = oReturn.appliedChangesString.split(",");
				return true; // break loop
			}
		});

		return oReturn;
	};

	FlexController.prototype._handlePromiseChainError = function (oView, oError) {
		Utils.log.error("Error processing view " + oError + ".");
		return oView;
	};

	FlexController.prototype._getSelectorOfChange = function (oChange) {
		if (!oChange || !oChange.getSelector) {
			return undefined;
		}
		return oChange.getSelector();
	};

	/**
	 * Retrieves the corresponding change handler for the change and applies the change to the control
	 *
	 * @param {sap.ui.fl.Change} oChange Change instance
	 * @param {sap.ui.core.Control} oControl Control instance
	 * @public
	 * @deprecated
	 */
	FlexController.prototype.applyChange = function (oChange, oControl) {
		var sControlType = Utils.getControlType(oControl);
		var oChangeHandler = this._getChangeHandler(oChange, sControlType);
		if (!oChangeHandler) {
			if (oChange && oControl) {
				Utils.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored.");
			}
			return;
		}

		try {
			oChangeHandler.applyChange(oChange, oControl);
		} catch (ex) {
			this._setMergeError(true);
			Utils.log.error("Change could not be applied. Merge error detected.");
			throw ex;
		}
	};

	/**
	 * Retrieves the <code>sap.ui.fl.registry.ChangeRegistryItem</code> for the given change and control
	 *
	 * @param {sap.ui.fl.Change} oChange - Change instance
	 * @param {string} sControlType name of the ui5 control type i.e. sap.m.Button
	 * @returns {sap.ui.fl.changeHandler.Base} the change handler. Undefined if not found.
	 * @private
	 */
	FlexController.prototype._getChangeHandler = function (oChange, sControlType) {
		var oChangeTypeMetadata, fChangeHandler;

		oChangeTypeMetadata = this._getChangeTypeMetadata(oChange, sControlType);
		if (!oChangeTypeMetadata) {
			return undefined;
		}

		fChangeHandler = oChangeTypeMetadata.getChangeHandler();
		return fChangeHandler;
	};

	/**
	 * Retrieves the <code>sap.ui.fl.registry.ChangeRegistryItem</code> for the given change and control
	 *
	 * @param {sap.ui.fl.Change} oChange Change instance
	 * @param {string} sControlType name of the ui5 control type i.e. sap.m.Button
	 * @returns {sap.ui.fl.registry.ChangeTypeMetadata} the registry item containing the change handler. Undefined if not found.
	 * @private
	 */
	FlexController.prototype._getChangeTypeMetadata = function (oChange, sControlType) {
		var oChangeRegistryItem, oChangeTypeMetadata;

		oChangeRegistryItem = this._getChangeRegistryItem(oChange, sControlType);
		if (!oChangeRegistryItem || !oChangeRegistryItem.getChangeTypeMetadata) {
			return undefined;
		}

		oChangeTypeMetadata = oChangeRegistryItem.getChangeTypeMetadata();
		return oChangeTypeMetadata;
	};

	/**
	 * Retrieves the <code>sap.ui.fl.registry.ChangeRegistryItem</code> for the given change and control
	 *
	 * @param {sap.ui.fl.Change} oChange Change instance
	 * @param {string} sControlType name of the ui5 control type i.e. sap.m.Button
	 * @returns {sap.ui.fl.registry.ChangeRegistryItem} the registry item containing the change handler. Undefined if not found.
	 * @private
	 */
	FlexController.prototype._getChangeRegistryItem = function (oChange, sControlType) {
		var sChangeType, oChangeRegistryItem, sLayer;
		if (!oChange || !sControlType) {
			return undefined;
		}

		sChangeType = oChange.getChangeType();

		if (!sChangeType || !sControlType) {
			return undefined;
		}

		sLayer = oChange.getLayer();

		oChangeRegistryItem = this._getChangeRegistry().getRegistryItems({
			"changeTypeName": sChangeType,
			"controlType": sControlType,
			"layer": sLayer
		});
		if (oChangeRegistryItem && oChangeRegistryItem[sControlType] && oChangeRegistryItem[sControlType][sChangeType]) {
			return oChangeRegistryItem[sControlType][sChangeType];
		} else if (oChangeRegistryItem && oChangeRegistryItem[sControlType]) {
			return oChangeRegistryItem[sControlType];
		} else {
			return oChangeRegistryItem;
		}
	};

	/**
	 * Returns the change registry
	 *
	 * @returns {sap.ui.fl.registry.ChangeRegistry} Instance of the change registry
	 * @private
	 */
	FlexController.prototype._getChangeRegistry = function () {
		var oInstance = ChangeRegistry.getInstance();
		// make sure to use the most current flex settings that have been retrieved during processView
		oInstance.initSettings();
		return oInstance;
	};

	/**
	 * Retrieves the changes for the complete UI5 component
	 * @param {map} mPropertyBag - (optional) contains additional data that are needed for reading of changes
	 * - appDescriptor that belongs to actual component
	 * - siteId that belongs to actual component
	 * @returns {Promise} Promise resolves with a map of all {sap.ui.fl.Change} having the changeId as key
	 * @public
	 */
	FlexController.prototype.getComponentChanges = function (mPropertyBag) {
		return this._oChangePersistence.getChangesForComponent(mPropertyBag);
	};

	/**
	 * Determines if an active personalization - user specific changes or variants - for the flexibility reference
	 * of the controller instance (<code>this._sComponentName</code>) is in place.
	 *
	 * @param {map} [mPropertyBag] - Contains additional data needed for checking personalization
	 * @param {boolean} [mPropertyBag.ignoreMaxLayerParameter] - Indicates that personalization shall be checked without layer filtering
	 * @returns {Promise} Resolves with a boolean; true if a personalization change made using SAPUI5 flexibility services is active in the application
	 * @public
	 */
	FlexController.prototype.isPersonalized = function (mPropertyBag) {
		mPropertyBag = mPropertyBag || {};
		//Always include smart variants when checking personalization
		mPropertyBag.includeVariants = true;
		return this.getComponentChanges(mPropertyBag).then(function (aChanges) {
			var bIsPersonalized = aChanges.some(function (oChange) {
				return oChange.isUserDependent();
			});

			return !!bIsPersonalized;
		});
	};

	/**
	 * Creates a new instance of sap.ui.fl.Persistence based on the current component and caches the instance in a private member
	 *
	 * @returns {sap.ui.fl.Persistence} persistence instance
	 * @private
	 */
	FlexController.prototype._createChangePersistence = function () {
		this._oChangePersistence = ChangePersistenceFactory.getChangePersistenceForComponent(this.getComponentName(), this.getAppVersion());
		return this._oChangePersistence;
	};

	/**
	 * Discard changes on the server.
	 *
	 * @param {array} aChanges array of {sap.ui.fl.Change} to be discarded
	 * @param {boolean} bDiscardPersonalization - (optional) specifies that only changes in the USER layer are discarded
	 * @returns {Promise} promise that resolves without parameters
	 */
	FlexController.prototype.discardChanges = function (aChanges, bDiscardPersonalization) {
		var sActiveLayer = Utils.getCurrentLayer(!!bDiscardPersonalization);
		var iIndex = 0;
		var iLength;
		var oChange;

		iLength = aChanges.length;
		while (iIndex < aChanges.length) {
			oChange = aChanges[iIndex];
			if (oChange && oChange.getLayer && oChange.getLayer() === sActiveLayer) {
				this._oChangePersistence.deleteChange(oChange);
			}
			//the array may change during this loop, so if the length is the same, the index must increase
			//otherwise the same index should be used (same index but different element in the array)
			if (iLength === aChanges.length) {
				iIndex++;
			} else {
				iLength = aChanges.length;
			}
		}

		return this._oChangePersistence.saveDirtyChanges();
	};

	/**
	 * Discard changes on the server for a specific selector ID.
	 *
	 * @param {string} sId for which the changes should be deleted
	 * @param {boolean} bDiscardPersonalization - (optional) specifies that only changes in the USER layer are discarded
	 * @returns {Promise} promise that resolves without parameters
	 */
	FlexController.prototype.discardChangesForId = function (sId, bDiscardPersonalization) {
		if (!sId) {
			return Promise.resolve();
		}

		var oChangesMap = this._oChangePersistence.getChangesMapForComponent();
		var aChanges = oChangesMap.mChanges[sId] || [];
		return this.discardChanges(aChanges, bDiscardPersonalization);
	};

	/**
	 * Set a flag in the settings instance in case an error has occurred when merging changes
	 *
	 * @returns {Promise} Promise resolved after the merge error flag is set
	 * @private
	 */
	FlexController.prototype._setMergeError = function () {
		return FlexSettings.getInstance().then(function (oSettings) {
			oSettings.setMergeErrorOccured(true);
		});
	};

	/**
	 * Apply the changes in the control; this function is called just before the end of the
	 * creation process, changes are applied synchronously.
	 *
	 * @param {function} fnGetChangesMap Getter to retrieve the mapped changes belonging to the app component
	 * @param {object} oAppComponent Component instance that is currently loading
	 * @param {object} oControl Control instance that is being created
	 * @private
	 */
	FlexController.prototype._applyChangesOnControl = function (fnGetChangesMap, oAppComponent, oControl) {
		var mChangesMap = fnGetChangesMap();
		var mChanges = mChangesMap.mChanges;
		var mDependencies = mChangesMap.mDependencies;
		var mDependentChangesOnMe = mChangesMap.mDependentChangesOnMe;
		var aChangesForControl = mChanges[oControl.getId()] || [];
		aChangesForControl.forEach(function (oChange) {
			if (!mDependencies[oChange.getKey()]) {
				this.checkTargetAndApplyChange(oChange, oControl, {
					modifier: JsControlTreeModifier,
					appComponent: oAppComponent
				});
				this._updateDependencies(mDependencies, mDependentChangesOnMe, oChange.getKey());
			} else {
				//saves the information whether a change was already processed but not applied.
				mDependencies[oChange.getKey()][FlexController.PENDING] =
					this.checkTargetAndApplyChange.bind(this, oChange, oControl, {
						modifier: JsControlTreeModifier,
						appComponent: oAppComponent
					});
			}
		}.bind(this));

		this._processDependentQueue(mDependencies, mDependentChangesOnMe);
	};

	/**
	 * Get <code>_applyChangesOnControl</code> function bound to the <code>FlexController</code> instance;
	 * this function must be used within the <code>addPropagationListener</code> function to ensure  proper
	 * identification of the bound function (identity check is not possible due to the wrapping of the <code>.bind</code>).
	 *
	 * @param {function} fnGetChangesMap Getter to retrieve the mapped changes belonging to the app component
	 * @param {object} oAppComponent Component instance that is currently loading
	 * @public
	 */
	FlexController.prototype.getBoundApplyChangesOnControl = function (fnGetChangesMap, oComponent) {
		var fnBoundApplyChangesOnControl = this._applyChangesOnControl.bind(this, fnGetChangesMap, oComponent);
		fnBoundApplyChangesOnControl._bIsSapUiFlFlexControllerApplyChangesOnControl = true;
		return fnBoundApplyChangesOnControl;
	};

	/**
	 * Revert changes for a control and removes the change from the applied Changes stored in the Controls Custom Data.
	 *
	 * @param {array} aChanges Array of to be reverted changes
	 * @param {object} oAppComponent Component instance
	 * @param {object} oControl Control instance
	 * @public
	 */
	FlexController.prototype.revertChangesOnControl = function(aChanges, oAppComponent) {
		aChanges.forEach(function(oChange) {
			var mPropertyBag = {
				modifier: JsControlTreeModifier,
				appComponent: oAppComponent
			};
			var oSelector = this._getSelectorOfChange(oChange);
			var oControl = mPropertyBag.modifier.bySelector(oSelector, mPropertyBag.appComponent);
			this._removeFromAppliedChangesAndMaybeRevert(oChange, oControl, {
				modifier: JsControlTreeModifier,
				appComponent: oAppComponent
			}, true);
			this._oChangePersistence._deleteChangeInMap(oChange);
		}.bind(this));
	};

	/**
	 * Applying variant changes.
	 *
	 * @param {array} aChanges Array of relevant changes
	 * @param {object} oComponent Component instance
	 * @public
	 */
	FlexController.prototype.applyVariantChanges = function(aChanges, oComponent) {
		var oAppComponent = Utils.getAppComponentForControl(oComponent);
		var aApplyChanges = [];
		aChanges.forEach(function(oChange) {
			var mChangesMap = this._oChangePersistence.getChangesMapForComponent().mChanges;
			var aAllChanges = Object.keys(mChangesMap).reduce(function (aChanges, sControlId) {
				return aChanges.concat(mChangesMap[sControlId]);
			}, []);
			this._oChangePersistence._addChangeAndUpdateDependencies(oComponent, oChange, aAllChanges.length, aAllChanges);

			aApplyChanges.push( function () {
				var mPropertyBag = {
					modifier: JsControlTreeModifier,
					appComponent: oAppComponent
				};
				var oSelector = this._getSelectorOfChange(oChange);
				var oControl = mPropertyBag.modifier.bySelector(oSelector, mPropertyBag.appComponent);
				if (!oControl) {
					Utils.log.error("A flexibility change tries to change a nonexistent control.");
					return;
				}
				this._applyChangesOnControl(this._oChangePersistence.getChangesMapForComponent.bind(this._oChangePersistence), oAppComponent, oControl);
			}.bind(this));
		}.bind(this));
		aApplyChanges.forEach(function (fnApplyChange) {
			fnApplyChange();
		});
	};

	/**
	 * Remove the change from the applied Changes stored in the Controls Custom Data without reverting the change.
	 *
	 * @param {object} oChange Change
	 * @param {object} oAppComponent Component instance
	 * @param {object} oControl Control instance
	 * @public
	 */
	FlexController.prototype.removeFromAppliedChangesOnControl = function(oChange, oAppComponent, oControl) {
		this._removeFromAppliedChangesAndMaybeRevert(oChange, oControl, {modifier: JsControlTreeModifier, appComponent: oAppComponent}, false);
	};

	FlexController.prototype._updateDependencies = function (mDependencies, mDependentChangesOnMe, sChangeKey) {
		if (mDependentChangesOnMe[sChangeKey]) {
			mDependentChangesOnMe[sChangeKey].forEach(function (sKey) {
				var oDependency = mDependencies[sKey];
				var iIndex = oDependency.dependencies.indexOf(sChangeKey);
				if (iIndex > -1) {
					oDependency.dependencies.splice(iIndex, 1);
				}
			});
			delete mDependentChangesOnMe[sChangeKey];
		}
	};

	FlexController.prototype._processDependentQueue = function (mDependencies, mDependentChangesOnMe) {
		var aAppliedChanges;
		var aDependenciesToBeDeleted;

		do {
			aAppliedChanges = [];
			aDependenciesToBeDeleted = [];
			for (var i = 0; i < Object.keys(mDependencies).length; i++) {
				var sDependencyKey = Object.keys(mDependencies)[i];
				var oDependency = mDependencies[sDependencyKey];
				if (oDependency[FlexController.PENDING] && oDependency.dependencies.length === 0 && !oDependency[FlexController.PROCESSING]) {
					oDependency[FlexController.PROCESSING] = true;
					oDependency[FlexController.PENDING]();
					aDependenciesToBeDeleted.push(sDependencyKey);
					aAppliedChanges.push(oDependency.changeObject.getKey());
				}
			}

			for (var j = 0; j < aDependenciesToBeDeleted.length; j++) {
				delete mDependencies[aDependenciesToBeDeleted[j]];
			}

			for (var k = 0; k < aAppliedChanges.length; k++) {
				this._updateDependencies(mDependencies, mDependentChangesOnMe, aAppliedChanges[k]);
			}
		} while (aAppliedChanges.length > 0);
	};

	return FlexController;
}, true);

}; // end of sap/ui/fl/FlexController.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.FlexControllerFactory') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.FlexControllerFactory'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/FlexControllerFactory",[
	"jquery.sap.global", "sap/ui/fl/FlexController", "sap/ui/fl/Utils", "sap/ui/fl/ChangePersistenceFactory"
], function(jQuery, FlexController, Utils, ChangePersistenceFactory) {
	"use strict";

	/**
	 * Factory to create new instances of {sap.ui.fl.FlexController}
	 * @constructor
	 * @alias sap.ui.fl.FlexControllerFactory
	 * @experimental Since 1.27.0
	 * @author SAP SE
	 * @version 1.48.6
	 */
	var FlexControllerFactory = {};

	FlexControllerFactory._instanceCache = {};

	/**
	 * Creates or returns an instance of the FlexController
	 *
	 * @public
	 * @param {String} sComponentName - Name of the component
	 * @param {String} sAppVersion - Current version of the application
	 * @returns {sap.ui.fl.FlexController} instance
	 *
	 */
	FlexControllerFactory.create = function(sComponentName, sAppVersion) {
		var sAppVersion = sAppVersion || Utils.DEFAULT_APP_VERSION;

		if (!FlexControllerFactory._instanceCache[sComponentName]) {
			FlexControllerFactory._instanceCache[sComponentName] = {};
		}
		var oFlexController = FlexControllerFactory._instanceCache[sComponentName][sAppVersion];

		if (!oFlexController){
			oFlexController = new FlexController(sComponentName, sAppVersion);
			FlexControllerFactory._instanceCache[sComponentName][sAppVersion] = oFlexController;
		}

		return oFlexController;
	};

	/**
	 * Creates or returns an instance of the FlexController for the specified control.
	 * The control needs to be embedded into a View and the view needs to be embedded into a component.
	 * If one of this prerequisites is not fulfilled, no instance of FlexController will be returned.
	 *
	 * @public
	 * @param {sap.ui.core.Control} oControl The control
	 * @param {object} [oManifest] - Manifest of the component
	 * @returns {sap.ui.fl.FlexController} instance
	 */
	FlexControllerFactory.createForControl = function(oControl, oManifest) {
		var sComponentName = Utils.getComponentClassName(oControl);
		var oLocalManifest = oManifest || Utils.getAppComponentForControl(oControl).getManifest();
		var sAppVersion = Utils.getAppVersionFromManifest(oLocalManifest);
		return FlexControllerFactory.create(sComponentName, sAppVersion);
	};

	/**
	 * Gets the changes and in case of existing changes, prepare the applyChanges function already with the changes.
	 *
	 * @param {object} oComponent Component instance that is currently loading
	 * @param {object} vConfig configuration of loaded component
	 * @public
	 */
	FlexControllerFactory.getChangesAndPropagate = function (oComponent, vConfig) {
		var oManifest = oComponent.getManifestObject();
		if (Utils.isApplication(oManifest)) {
			var oFlexController = FlexControllerFactory.createForControl(oComponent, oManifest);
			ChangePersistenceFactory._getChangesForComponentAfterInstantiation(vConfig, oManifest, oComponent)
			.then(function (fnGetChangesMap) {
				oComponent.addPropagationListener(oFlexController.getBoundApplyChangesOnControl(fnGetChangesMap, oComponent));
			});
		}
	};

	return FlexControllerFactory;
}, true);

}; // end of sap/ui/fl/FlexControllerFactory.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.PreprocessorImpl') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.fl.ProcessorImpl
jQuery.sap.declare('sap.ui.fl.PreprocessorImpl'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/PreprocessorImpl",[
	'jquery.sap.global', 'sap/ui/core/Component', 'sap/ui/fl/FlexControllerFactory', 'sap/ui/fl/Utils', 'sap/ui/fl/LrepConnector', 'sap/ui/fl/ChangePersistenceFactory'
], function(jQuery, Component, FlexControllerFactory, Utils, LrepConnector, ChangePersistenceFactory) {
	'use strict';

	/**
	 * The implementation of the <code>Preprocessor</code> for the SAPUI5 flexibility services that can be hooked in the <code>View</code> life cycle.
	 *
	 * @name sap.ui.fl.PreprocessorImpl
	 * @class
	 * @constructor
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 */
	var PreprocessorImpl = function(){
	};

	/**
	 * Provides an array of extension providers. An extension provider is an object which were defined as controller extensions. These objects
	 * provides lifecycle and event handler functions of a specific controller.
	 *
	 * @param {string} sControllerName - name of the controller
	 * @param {string} sComponentId - unique id for the running controller - unique as well for manifest first
	 * @param {boolean} bAsync - flag whether <code>Promise</code> should be returned or not (async=true)
	 * @see sap.ui.controller for an overview of the available functions on controllers.
	 * @since 1.34.0
	 * @public
	 */
	PreprocessorImpl.prototype.getControllerExtensions = function(sControllerName, sComponentId, bAsync) {
		if (bAsync) {

			if (!sComponentId) {
				jQuery.sap.log.warning("No component ID for determining the anchor of the code extensions was passed.");
				return [];
			}

			var oComponent = sap.ui.component(sComponentId);
			var oAppComponent = Utils.getAppComponentForControl(oComponent);
			var sFlexReference = Utils.getComponentClassName(oAppComponent);
			var sAppVersion = Utils.getAppVersionFromManifest(oAppComponent.getManifest());

			var oChangePersistence = ChangePersistenceFactory.getChangePersistenceForComponent(sFlexReference, sAppVersion);
			return oChangePersistence.getChangesForComponent().then(function(oChanges) {

				var aExtensionProviders = [];

				jQuery.each(oChanges, function (index, oChange) {
					var oChangeDefinition = oChange.getDefinition();
					if (oChangeDefinition.changeType === "codeExt" && oChangeDefinition.content && sControllerName === oChangeDefinition.selector.id) {
						aExtensionProviders.push(PreprocessorImpl.getExtensionProvider(oChangeDefinition));
					}
				});

				return aExtensionProviders;
			});
		}
	};

	PreprocessorImpl.getExtensionProvider = function(oChange) {
		var sConvertedAsciiCodeContent = oChange.content.code || {};
		var sConvertedCodeContent = Utils.asciiToString(sConvertedAsciiCodeContent);
		var oExtensionProvider;
		/*eslint-disable */
		eval("oExtensionProvider = " + sConvertedCodeContent);
		/*eslint-enable */

		return oExtensionProvider;
	};

	 return PreprocessorImpl;

}, /* bExport= */true);

}; // end of sap/ui/fl/PreprocessorImpl.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.RegistrationDelegator') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides object sap.ui.fl.RegistrationDelegator
jQuery.sap.declare('sap.ui.fl.RegistrationDelegator'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.XMLView'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/RegistrationDelegator",[
	"sap/ui/fl/FlexControllerFactory",
	"sap/ui/core/Component",
	"sap/ui/fl/registry/ChangeHandlerRegistration",
	"sap/ui/fl/ChangePersistenceFactory",
	"sap/ui/core/mvc/Controller",
	"sap/ui/core/mvc/XMLView",
	"sap/ui/fl/EventHistory"
], function(FlexControllerFactory, Component, ChangeHandlerRegistration, ChangePersistenceFactory, MvcController, XMLView, EventHistory) {
	"use strict";

	/**
	 * This class takes care of all the registration (hooks) needed to run flex!
	 *
	 * @name sap.ui.fl.RegistrationDelegator
	 * @class
	 * @constructor
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.43.0
	 */
	var RegistrationDelegator = {
	};

	/**
	 * Registers the changes in the component
	 *
	 * @public
	 */
	RegistrationDelegator.registerChangesInComponent = function() {
		Component._fnOnInstanceCreated = FlexControllerFactory.getChangesAndPropagate;
	};

	/**
	 * Registers change handlers
	 *
	 * @public
	 */
	RegistrationDelegator.registerChangeHandlers = function() {
		ChangeHandlerRegistration.getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs();
	};

	/**
	 * Register the event handler
	 *
	 * @public
	 */
	RegistrationDelegator.registerLoadComponentEventHandler = function() {
		Component._fnLoadComponentCallback = ChangePersistenceFactory._onLoadComponent.bind(ChangePersistenceFactory);
	};

	/**
	 * Registers the extension provider
	 *
	 * @public
	 */
	RegistrationDelegator.registerExtensionProvider = function() {
		MvcController.registerExtensionProvider("sap.ui.fl.PreprocessorImpl");
	};

	/**
	 * Registers the xml preprocessor
	 *
	 * @public
	 */
	RegistrationDelegator.registerXMLPreprocessor = function() {
		if (XMLView.registerPreprocessor){
			XMLView.registerPreprocessor("viewxml", "sap.ui.fl.XmlPreprocessorImpl", true);
		}
	};

	/**
	 * Registers the event listener
	 *
	 * @public
	 */
	RegistrationDelegator.registerEventListener = function() {
		EventHistory.start();
	};

	/**
	 * Registers everything in one call
	 *
	 * @public
	 */
	RegistrationDelegator.registerAll = function() {
		RegistrationDelegator.registerEventListener();
		RegistrationDelegator.registerChangeHandlers();
		RegistrationDelegator.registerLoadComponentEventHandler();
		RegistrationDelegator.registerExtensionProvider();
		RegistrationDelegator.registerChangesInComponent();
		RegistrationDelegator.registerXMLPreprocessor();
	};

	return RegistrationDelegator;

}, /* bExport= */true);

}; // end of sap/ui/fl/RegistrationDelegator.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.XmlPreprocessorImpl') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.XmlPreprocessorImpl'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Component'); // unlisted dependency retained
sap.ui.define("sap/ui/fl/XmlPreprocessorImpl",[
	"jquery.sap.global",
	"sap/ui/core/Component",
	"sap/ui/fl/FlexControllerFactory",
	"sap/ui/fl/Utils",
	"sap/ui/fl/LrepConnector",
	"sap/ui/fl/ChangePersistenceFactory",
	"sap/ui/fl/ChangePersistence"
], function(jQuery, Component, FlexControllerFactory, Utils, LrepConnector, ChangePersistenceFactory, ChangePersistence) {
	"use strict";

	/**
	 * The implementation of the <code>XmlPreprocessor</code> for the SAPUI5 flexibility services that can be hooked in the <code>View</code> life cycle.
	 *
	 * @name sap.ui.fl.XmlPreprocessorImpl
	 * @class
	 * @constructor
	 * @author SAP SE
	 * @version 1.48.6
	 * @experimental Since 1.27.0
	 */
	var XmlPreprocessorImpl = function(){
	};

	/**
	 * Asynchronous view processing method.
	 *
	 * @param {Node} oView XML node of the view to process
	 * @param {object} mProperties
	 * @param {string} mProperties.componentId - id of the component creating the view
	 * @param {string} mPropertyBag.id - id of the processed view
	 *
	 * @returns {jquery.sap.promise} result of the processing, promise if executed asynchronously
	 *
	 * @public
	 */
	XmlPreprocessorImpl.process = function(oView, mProperties){
		try {
			if (!mProperties || mProperties.sync) {
				Utils.log.warning("Flexibility feature for applying changes on an XML view is only available for " +
					"asynchronous views; merge is be done later on the JS controls.");
				return (oView);
			}

			// align view id attribute with the js processing (getting the id passed in "viewId" instead of "id"
			mProperties.viewId = mProperties.id;

			var oComponent = sap.ui.getCore().getComponent(mProperties.componentId);

			if (!oComponent) {
				Utils.log.warning("View is generated without a component. Flexibility features are not possible.");
				return Promise.resolve(oView);
			}

			var oAppComponent = Utils.getAppComponentForControl(oComponent);
			var sFlexReference = Utils.getComponentClassName(oAppComponent);
			var sAppVersion = Utils.getAppVersionFromManifest(oAppComponent.getManifest());
			var oChangePersistence = ChangePersistenceFactory.getChangePersistenceForComponent(sFlexReference, sAppVersion);
			return oChangePersistence.getCacheKey().then(function(sCacheKey){
				if (!sCacheKey || sCacheKey === ChangePersistence.NOTAG) {
					Utils.log.warning("No cache key could be determined for the view; flexibility XML view preprocessing is skipped. " +
						"The processing will be done later on the JS controls.");
					return Promise.resolve(oView);
				}

				var oFlexController = FlexControllerFactory.create(sFlexReference, sAppVersion);
				return oFlexController.processXmlView(oView, mProperties).then(function() {
					Utils.log.debug("flex processing view " + mProperties.id + " finished");
					return oView;
				});
			}, function () {
				Utils.log.warning("Error happens when getting flex cache key! flexibility XML view preprocessing is skipped. " +
					"The processing will be done later on the JS controls.");
				return Promise.resolve(oView);
			});
		} catch (error) {
			var sError = "view " + mProperties.id + ": " + error;
			jQuery.sap.log.info(sError); //to allow control usage in applications that do not work with UI flex and components
			// throw new Error(sError); // throw again, when caller handles the promise
			return Promise.resolve(oView);
		}
	 };

	/**
	 * Asynchronous determination of a hash key for caching purposes
	 *
	 * @param {Node} oView XML node of the view for which the key should be determined
	 * @returns {jquery.sap.promise} promise returning the hash key
	 *
	 * @public
	 */
	XmlPreprocessorImpl.getCacheKey = function(mProperties) {
		var oComponent = sap.ui.getCore().getComponent(mProperties.componentId);
		var oAppComponent = Utils.getAppComponentForControl(oComponent);

		// no caching possible with startup parameter based variants
		if (Utils.isVariantByStartupParameter(oAppComponent)) {
			return Promise.resolve();
		}

		var sFlexReference = Utils.getComponentClassName(oAppComponent);
		var sAppVersion = Utils.getAppVersionFromManifest(oAppComponent.getManifest());
		var oChangePersistence = ChangePersistenceFactory.getChangePersistenceForComponent(sFlexReference, sAppVersion);
		return oChangePersistence.getCacheKey();
	};

	 return XmlPreprocessorImpl;

}, /* bExport= */true);

}; // end of sap/ui/fl/XmlPreprocessorImpl.js
if ( !jQuery.sap.isDeclared('sap.ui.fl.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.fl.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/fl/library",["sap/ui/fl/RegistrationDelegator"
	],
	function(RegistrationDelegator) {
	"use strict";

	/**
	 * SAPUI5 library for UI Flexibility and Descriptor Changes and Descriptor Variants.
	 *
	 * @namespace
	 * @name sap.ui.fl
	 * @author SAP SE
	 * @version 1.48.6
	 * @private
	 * @sap-restricted
	 *
	 */

	sap.ui.getCore().initLibrary({
		name:"sap.ui.fl",
		version:"1.48.6",
		dependencies:["sap.ui.core","sap.m"],
		noLibraryCSS: true,
		extensions: {
			"sap.ui.support": {
				diagnosticPlugins: [
					"sap/ui/fl/support/Flexibility"
				]
			}
		}
	});

	RegistrationDelegator.registerAll();

	return sap.ui.fl;

}, /* bExport= */ true);

}; // end of sap/ui/fl/library.js
