/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Filter','sap/ui/model/Sorter','sap/ui/model/Filter','sap/ui/core/format/DateFormat'],function(q,O,S,F,D){"use strict";var r=/^([-+]?)0*(\d+)(\.\d+|)$/,a=/\.$/,b=/0+$/;var c=function(){};c.createSortParams=function(j){var l;if(!j||j.length==0){return;}l="$orderby=";for(var i=0;i<j.length;i++){var o=j[i];if(o instanceof S){l+=o.sPath;l+=o.bDescending?"%20desc":"%20asc";l+=",";}else{q.sap.log.error("Trying to use "+o+" as a Sorter, but it is a "+typeof o);}}l=l.slice(0,-1);return l;};c.createFilterParams=function(i,m,E){if(!i||i.length==0){return;}return"$filter="+this._createFilterParams(i,m,E);};c._createFilterParams=function(l,m,E){var o;if(!l||l.length==0){return;}var t={},u=0,v,o="",w=0,x=this;q.each(l,function(j,i){if(i.sPath){v=t[i.sPath];if(!v){v=t[i.sPath]=[];u++;}}else{v=t["__multiFilter"];if(!v){v=t["__multiFilter"]=[];u++;}}v.push(i);});q.each(t,function(P,v){if(v.length>1){o+='(';}q.each(v,function(i,j){if(j instanceof O){if(j.aValues.length>1){o+='(';}q.each(j.aValues,function(i,y){if(i>0){if(j.bAND){o+="%20and%20";}else{o+="%20or%20";}}o=x._createFilterSegment(j.sPath,m,E,y.operator,y.value1,y.value2,o);});if(j.aValues.length>1){o+=')';}}else if(j._bMultiFilter){o+=x._resolveMultiFilter(j,m,E);}else{o=x._createFilterSegment(j.sPath,m,E,j.sOperator,j.oValue1,j.oValue2,o);}if(i<v.length-1){o+="%20or%20";}});if(v.length>1){o+=')';}if(w<u-1){o+="%20and%20";}w++;});return o;};c._createUrlParamsArray=function(P){var u,t=q.type(P),i;if(t==="array"){return P;}u=[];if(t==="object"){i=this._encodeURLParameters(P);if(i){u.push(i);}}else if(t==="string"){if(P){u.push(P);}}return u;};c._encodeURLParameters=function(P){if(!P){return"";}var u=[];q.each(P,function(i,v){if(q.type(v)==="string"){v=encodeURIComponent(v);}i=q.sap.startsWith(i,'$')?i:encodeURIComponent(i);u.push(i+"="+v);});return u.join("&");};c.setOrigin=function(i,P){var o,j,C;if(!i||!P||i.indexOf(";mo")>0){return i;}if(typeof P=="string"){o=P;}else{o=P.alias;if(!o){j=P.system;C=P.client;if(!j||!C){q.sap.log.warning("ODataUtils.setOrigin: No Client or System ID given for Origin");return i;}o="sid("+j+"."+C+")";}}var u=i.split("?");var B=u[0];var U=u[1]?"?"+u[1]:"";var t="";if(q.sap.endsWith(B,"/")){B=B.substring(0,B.length-1);t="/";}var l=/(;o=[^/]+)$/;if(B.match(l)!=null){if(P.force){B=B.replace(l,";o="+o);return B+t+U;}return i;}B=B+";o="+o+t;return B+U;};c.setAnnotationOrigin=function(A,P){var i;var j=A.indexOf("/Annotations(");if(j===-1){j=A.indexOf("/Annotations%28");}if(j>=0){if(A.indexOf("/$value",j)===-1){q.sap.log.warning("ODataUtils.setAnnotationOrigin: Annotation url is missing $value segment.");i=A;}else{var l=A.substring(0,j);var m=A.substring(j,A.length);var o=c.setOrigin(l,P);i=o+m;}}else{i=A.replace(P.preOriginBaseUri,P.postOriginBaseUri);}return i;};c._resolveMultiFilter=function(m,M,E){var t=this,j=m.aFilters,l="";if(j){l+="(";q.each(j,function(i,o){if(o._bMultiFilter){l+=t._resolveMultiFilter(o,M,E);}else if(o.sPath){l+=t._createFilterSegment(o.sPath,M,E,o.sOperator,o.oValue1,o.oValue2,"");}if(i<(j.length-1)){if(m.bAnd){l+="%20and%20";}else{l+="%20or%20";}}});l+=")";}return l;};c._createFilterSegment=function(P,m,E,o,v,V,i){var j,t;if(E){j=m._getPropertyMetadata(E,P);t=j&&j.type;}if(t){v=this.formatValue(v,t);V=(V!=null)?this.formatValue(V,t):null;}else{}if(v){v=q.sap.encodeURL(String(v));}if(V){V=q.sap.encodeURL(String(V));}switch(o){case"EQ":case"NE":case"GT":case"GE":case"LT":case"LE":i+=P+"%20"+o.toLowerCase()+"%20"+v;break;case"BT":i+="("+P+"%20ge%20"+v+"%20and%20"+P+"%20le%20"+V+")";break;case"Contains":i+="substringof("+v+","+P+")";break;case"StartsWith":i+="startswith("+P+","+v+")";break;case"EndsWith":i+="endswith("+P+","+v+")";break;default:i+="true";}return i;};c.formatValue=function(v,t){if(!this.oDateTimeFormat){this.oDateTimeFormat=D.getDateInstance({pattern:"'datetime'''yyyy-MM-dd'T'HH:mm:ss''"});this.oDateTimeOffsetFormat=D.getDateInstance({pattern:"'datetimeoffset'''yyyy-MM-dd'T'HH:mm:ss'Z'''"});this.oTimeFormat=D.getTimeInstance({pattern:"'time''PT'HH'H'mm'M'ss'S'''"});}if(v===null||v===undefined){return"null";}var V;switch(t){case"Edm.String":V="'"+String(v).replace(/'/g,"''")+"'";break;case"Edm.Time":if(typeof v==="object"){V=this.oTimeFormat.format(new Date(v.ms),true);}else{V="time'"+v+"'";}break;case"Edm.DateTime":V=this.oDateTimeFormat.format(new Date(v),true);break;case"Edm.DateTimeOffset":V=this.oDateTimeOffsetFormat.format(new Date(v),true);break;case"Edm.Guid":V="guid'"+v+"'";break;case"Edm.Decimal":V=v+"m";break;case"Edm.Int64":V=v+"l";break;case"Edm.Double":V=v+"d";break;case"Edm.Float":case"Edm.Single":V=v+"f";break;case"Edm.Binary":V="binary'"+v+"'";break;default:V=String(v);break;}return V;};function s(v,V){if(v===V){return 0;}if(v===null||V===null||v===undefined||V===undefined){return NaN;}return v>V?1:-1;}function p(v){var m;if(typeof v!=="string"){return undefined;}m=r.exec(v);if(!m){return undefined;}return{sign:m[1]==="-"?-1:1,integerLength:m[2].length,abs:m[2]+m[3].replace(b,"").replace(a,"")};}function d(v,V){var o,i,R;if(v===V){return 0;}o=p(v);i=p(V);if(!o||!i){return NaN;}if(o.sign!==i.sign){return o.sign>i.sign?1:-1;}R=s(o.integerLength,i.integerLength)||s(o.abs,i.abs);return o.sign*R;}function e(v){if(v instanceof Date){return v.getTime();}if(v&&v.__edmType==="Edm.Time"){return v.ms;}return v;}c.compare=function(v,V,A){return A?d(v,V):s(e(v),e(V));};c.getComparator=function(E){switch(E){case"Edm.Date":case"Edm.DateTime":case"Edm.DateTimeOffset":case"Edm.Time":return c.compare;case"Edm.Decimal":case"Edm.Int64":return d;default:return s;}};var f=/([(=,])('.*?')([,)])/g,g=/[MLDF](?=[,)](?:[^']*'[^']*')*[^']*$)/g,h=/([(=,])(X')/g,n=function(v,i,j,l){return i+encodeURIComponent(decodeURIComponent(j))+l;},N=function(v){return v.toLowerCase();},k=function(v,i){return i+"binary'";};c._normalizeKey=function(K){return K.replace(f,n).replace(g,N).replace(h,k);};return c;},true);
