// This file has been generated by the SAPUI5 'AllInOne' Builder
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

window.sapUiSupportReport = window.sapUiSupportReport || {};
window.sapUiSupportReport.collapseExpand = (function() {
	'use strict';

	function collapseExpandClickHandler(event) {
		var toExpandElementId = this.getAttribute('data-expandableElement');
		var expandableElement = document.getElementById(toExpandElementId);
		var toExpand = expandableElement.classList.contains('collapsed');

		if (toExpand) {
			expandableElement.classList.remove('collapsed');
			expandableElement.classList.add('expanded');
			this.classList.remove('collapsed-content');
			this.classList.add('expanded-content');
		} else {
			expandableElement.classList.remove('expanded');
			expandableElement.classList.add('collapsed');
			this.classList.remove('expanded-content');
			this.classList.add('collapsed-content');
		}
	}

	function init() {
		try {
			var expandableElements = document.getElementsByClassName('expandable-control');
			if (!expandableElements) {
				return;
			}

			for (var i = 0; i < expandableElements.length; i++) {
				expandableElements[i].addEventListener('click', collapseExpandClickHandler);

				// Set the default collapsed/expanded state of the expandable content.
				var elementToExpandId = expandableElements[i].getAttribute('data-expandableElement');
				var elementToExpand = document.getElementById(elementToExpandId);
				if (expandableElements[i].classList.contains('collapsed-content')) {
					elementToExpand.classList.add('collapsed');
				} else {
					elementToExpand.classList.add('expanded');
				}

				expandableElements[i].setAttribute('style', 'cursor: pointer;');
			}
		} catch (ex) {
			/* eslint-disable no-console */
			console.log('There was a problem initializing collapse/expand functionality.');
			/* eslint-enable no-console */
		}
	}

	return {
		init: init
	};
}());
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

window.sapUiSupportReport = window.sapUiSupportReport || {};
window.sapUiSupportReport.filter = (function () {
	'use strict';

	// Used to update the groups counters and hide/show group headers if all
	// of the elements are filtered.
	function updateIssuesGroups() {
		// Get all groups.
		var groupHeaderElements = document.querySelectorAll('[data-groupName]');

		for (var i = 0; i < groupHeaderElements.length; i++) {
			var groupHeader = groupHeaderElements[i];
			var issuesGroupId = groupHeader.getAttribute('data-expandableElement');
			var groupName = groupHeader.getAttribute('data-groupName');
			var groupNumber = groupHeader.getAttribute('data-groupNumber');
			// Get all rules for the current group.
			var rules = document.querySelectorAll('#' + issuesGroupId + ' > tr');
			var numberOfUnfilteredIssues = 0;
			var numberOfUnfilteredRules = 0;

			// Hide the rule section if no issues. Otherwise update count.
			for (var k = 0; k < rules.length; k++) {
				var rule = rules[k];
				var unfilteredIssuesForRule = rule.querySelectorAll('tr.filterable:not(.filtered)');
				var numberOfUnfilteredIssuesForRule = unfilteredIssuesForRule.length;
				if (numberOfUnfilteredIssuesForRule === 0) {
					rule.classList.add('filtered');
				} else {
					numberOfUnfilteredRules++;
					numberOfUnfilteredIssues += numberOfUnfilteredIssuesForRule;
					rule.querySelector('span.rule-issue-number').innerText = '(' + numberOfUnfilteredIssuesForRule + ' issues)';
				}
			}

			// Hide the group section if no issues. Otherwise update count.
			if (numberOfUnfilteredRules === 0) {
				groupHeader.classList.add('filtered');
			} else {
				groupHeader.classList.remove('filtered');
				groupHeader.querySelector('span').innerText = ' ' + groupNumber + '. ' + groupName + ' (' + numberOfUnfilteredRules + ' rules, ' + numberOfUnfilteredIssues + ' issues)';
			}
		}
	}
	function selectFilter(filter) {
		if (filter.classList.contains('filter-active')) {
			return;
		}

		var activeFilters = document.getElementsByClassName('filter-active');
		for (var k = 0; k < activeFilters.length; k++) {
			activeFilters[k].classList.remove('filter-active');
		}
		filter.classList.add('filter-active');
	}
	function resetFilters() {
		var filteredElements = document.querySelectorAll('.filtered');
		for (var i = 0; i < filteredElements.length; i++) {
			filteredElements[i].classList.remove('filtered');
		}
	}
	function filterBy(severity) {
		resetFilters();
		if (severity === 'Total') {
			return;
		}

		var elements = document.querySelectorAll('.filterable:not([data-severity="' + severity + '"])');
		for (var i = 0; i < elements.length; i++) {
			elements[i].classList.add('filtered');
		}
	}
	function filterClickHandler(event) {
		selectFilter(this);
		var severity = this.getAttribute('data-severity');
		filterBy(severity);
		updateIssuesGroups();
	}

	function init() {
		try {
			var filters = document.getElementsByClassName('filter');

			if (!filters) {
				return;
			}

			for (var i = 0; i < filters.length; i++) {
				if (filters[i].classList.contains('filter-initialized')) {
					continue;
				}

				filters[i].addEventListener('click', filterClickHandler);
				filters[i].classList.add('filter-initialized');
			}
		} catch (ex) {
			/* eslint-disable no-console */
			console.log('There was a problem initializing filters.');
			/* eslint-enable no-console */
		}
	}

	return {
		init: init
	};
}());
jQuery.sap.declare('sap.ui.support.library-all');
jQuery.sap.declare('sap.ui.support.supportRules.report.resources.collapseExpand'); // raw module, declared by SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.support.supportRules.report.resources.filter'); // raw module, declared by SAPUI5 'AllInOne' Builder
if ( !jQuery.sap.isDeclared('sap.ui.support.library') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.ui.support.
 */
jQuery.sap.declare('sap.ui.support.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
sap.ui.define("sap/ui/support/library",["sap/ui/core/library"],
	function (library1) {
	"use strict";

	/**
	 * UI5 library: sap.ui.support.
	 *
	 * @namespace
	 * @name sap.ui.support
	 * @public
	 */

	// library dependencies

	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : "sap.ui.support",
		// Loading sap.ui.codeeditor is moved to overlay.html to make sure it is loaded from the correct origin.
		dependencies : ["sap.ui.core", "sap.ui.fl", "sap.m", "sap.ui.layout"],
		types: ["sap.ui.support.Severity"],
		interfaces: [],
		controls: [],
		elements: [],
		noLibraryCSS: false,
		version: "1.48.6"
	});

	sap.ui.support.Severity = {
		Medium: "Medium",
		High: "High",
		Low: "Low"
	};

	sap.ui.support.Audiences = {
		Control: "Control",
		Internal: "Internal",
		Application: "Application"
	};

	sap.ui.support.Categories = {
		Accessibility: "Accessibility",
		Performance: "Performance",
		Memory: "Memory",
		Bindings: "Bindings",
		Consistency: "Consistency",
		Functionality : "Functionality",
		Usability : "Usability",
		DataModel: "DataModel",
		Usage: "Usage",
		Other: "Other"
	};

	return sap.ui.support;
});

}; // end of sap/ui/support/library.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.Analyzer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global performance */

/**
 * Creates an Analyser that async runs tasks added by addTask function. Analysis can be started, stopped, restarted, paused and continued.
 * THe analyser can be used to update the UI while a task is running with the current progress
 */
jQuery.sap.declare('sap.ui.support.supportRules.Analyzer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.Object'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/Analyzer",["jquery.sap.global", "sap/ui/base/Object"],
	function (jQuery, BaseObject) {
		"use strict";

		/**
		 * Analyzer class that runs tasks. A Task runs a function for every entry in its object array.
		 * The Analyzer counts the task objects and calculates the percentages.
		 * With the start, restart, stop and pause methods the analyzer can be controlled.
		 * While started it walks async through the list of object for each task and completes them.
		 *
		 *
		 * @private
		 */
		var Analyzer = function () {
			this.reset();
		};

		/**
		 * Returns the total progress for all tasks with all their objects.
		 * @returns {int} total progress for all tasks with all their objects.
		 *
		 * @private
		 * @experimental
		 */
		Analyzer.prototype.getProgress = function () {
			return this._iTotalProgress;
		};

		/**
		 * Adds a task to with a name to the analyzer.
		 * The fnTaskProcessor function is called if the task is run for every object in aObjects.
		 *
		 * @param sTaskName
		 * @param fnTaskProcessor
		 * @param aObjects
		 */
		Analyzer.prototype.addTask = function (sTaskName, fnTaskProcessor, aObjects) {
			var oTask = {
				name: sTaskName,
				handler: fnTaskProcessor,
				objects: jQuery.extend(true, {arr: aObjects},{}).arr,
				progress: 0
			};
			this._aTasks.push(oTask);
			this._iTotalSteps = this._iTotalSteps + oTask.objects.length;
		};

		/**
		 * Resets the analyzer and clears all tasks
		 * @private
		 */
		Analyzer.prototype.reset = function () {
			this._iTotalProgress = 0;
			this._iTotalCompletedSteps = 0;
			this._iTotalSteps = 0;
			this._aTasks = [];
			this._oCurrent = {};
			this._bRunning = false;
			this._iStartTS = 0;
			this.startedAt = null;
			this.finishedAt = null;
			this.elapsedTime = null;
		};

		/**
		 * Returns whether the Analyzer is currently running
		 * @returns
		 */
		Analyzer.prototype.running = function () {
			return this._bRunning;
		};

		/**
		 * Starts the analyzer to run all tasks
		 * @private
		 */
		Analyzer.prototype.start = function (resolveFn) {
			var that = this;
			// resolve() is called when the analyzer finishes all tasks.
			// It is called inside _done function.
			that.resolve = resolveFn;
			that.startedAt = new Date();
			var progressPromise = new Promise(
				function (resolve, reject) {
					that._iStartTS = performance.now();
					that._start(undefined, resolve);
				}
			);

			return progressPromise;
		};

		/**
		 * Internal method to start the next run on the next object.
		 * @param bContinue {boolean} true if called via timer
		 * @param fnResolve {function} resolve function
		 *
		 * @private
		 * @experimental
		 */
		Analyzer.prototype._start = function (bContinue, fnResolve) {
			if (this._bRunning && !bContinue) {
				return;
			}

			if (this._oCurrent.task) {
				if (bContinue) {
					this._next(fnResolve);
				}

				return;
			}

			for (var i = 0; i < this._aTasks.length; i++) {
				if (this._aTasks[i].progress < 100) {
					this._oCurrent = {
						task: this._aTasks[i],
						index: -1
					};

					this._bRunning = true;
					jQuery.sap.delayedCall(1, this, "_next", [fnResolve]);
					break;
				} else {
					this._bRunning = false;
				}
			}
		};

		/**
		 * Processes the next object in the current task
		 *
		 * @param fnResolve {function} resolves promise to notify of finished state
		 */
		Analyzer.prototype._next = function (fnResolve) {
			if (!this._bRunning) {
				return;
			}

			var oCurrent = this._oCurrent;

			if (oCurrent.task) {

				oCurrent.index++;
				if (oCurrent.task.objects[oCurrent.index]) {
					this._iTotalCompletedSteps++;
					this._iTotalProgress = Math.min(Math.ceil((this._iTotalCompletedSteps / this._iTotalSteps) * 100), 100);
					oCurrent.task.handler(oCurrent.task.objects[oCurrent.index]);
					oCurrent.task.progress = Math.min(Math.ceil((oCurrent.index / oCurrent.task.objects.length) * 100), 100);
				} else {
					//finished
					oCurrent.task.progress = 100;
					this._iTotalCompletedSteps = this._iTotalCompletedSteps + (oCurrent.task.objects.length - oCurrent.index);
					this._iTotalProgress = Math.min(Math.ceil((this._iTotalCompletedSteps / this._iTotalSteps) * 100), 100);
					this._oCurrent = {};
					this.finishedAt = new Date();
					this.elapsedTime = this.finishedAt.getTime() - this.startedAt.getTime(); // In milliseconds
					// _bRunning needs to be set to false in order to have
					// results ready for reading in promise of fnResolve
					this._bRunning = false;
					fnResolve();
				}
				if (performance.now() - this._iStartTS  > 100) {
					jQuery.sap.delayedCall(5, this, "_start", [true, fnResolve]);
					this._iStartTS = performance.now();
				} else {
					jQuery.sap.delayedCall(0, this, "_start", [true, fnResolve]);
				}
			}
		};

		Analyzer.prototype.getElapsedTimeString = function () {
			if (!this.elapsedTime) {
				return;
			}

			var oDate = new Date(null);
			oDate.setHours(0, 0, 0, 0);
			oDate.setMilliseconds(this.elapsedTime);
			var oBuffer = [
				(oDate.getHours() < 10 ? "0" : "") + oDate.getHours(),
				(oDate.getMinutes() < 10 ? "0" : "") + oDate.getMinutes(),
				(oDate.getSeconds() < 10 ? "0" : "") + oDate.getSeconds(),
				oDate.getMilliseconds()
			];

			return oBuffer.join(":");
		};

		return Analyzer;
	}, false);

}; // end of sap/ui/support/supportRules/Analyzer.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.Constants') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
jQuery.sap.declare('sap.ui.support.supportRules.Constants'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/Constants",[],
	function() {
		"use strict";

		/**
		 * Constants variables used in the Support Assistant
		 * @enum
		 *
		 * @author SAP SE
		 * @namespace
		 *
		 * @alias sap.ui.support.AssistantConstants
		 */
		return {
			TEMP_RULESETS_NAME: "temporary",
			SUPPORT_ASSISTANT_NAME: "Support Assistant",
			LOCAL_STORAGE_TEMP_RULES_KEY: "support-assistant-temprules",
			LOCAL_STORAGE_SELECTED_RULES_KEY: "support-assistant-selected-rules",
			LOCAL_STORAGE_SELECTED_CONTEXT_KEY: "support-assistant-settings-selected-context",
			LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY: "support-assistant-settings-selected-context-components",
			COOKIE_NAME: "persistence-cookie"
		};


	}, /* bExport= */ true);

}; // end of sap/ui/support/supportRules/Constants.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.CoreFacade') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*!
 * An interface to the core to be used by rules
 */
jQuery.sap.declare('sap.ui.support.supportRules.CoreFacade'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/CoreFacade",[],
	function () {
		"use strict";

		var coreInstance = null;

		/**
		 * Constructor for facade to given core object
		 *
		 * @returns {object} Core facade
		 * @param {object} oCore Core object as available in plugin
		 */
		function CoreFacade(oCore) {
			coreInstance = oCore;

			return {
				/**
				 * @returns {object} Core metadata
				 */
				getMetadata: function () {
					return coreInstance.getMetadata();
				},
				/**
				 * @returns {object} UI areas
				 */
				getUIAreas: function () {
					return coreInstance.mUIAreas;
				},
				/**
				 * @returns {object} Components
				 */
				getComponents: function () {
					return coreInstance.mObjects.component;
				},
				/**
				 * @returns {object} Models
				 */
				getModels: function () {
					return coreInstance.oModels;
				}
			};
		}

		return CoreFacade;

	}, true);

}; // end of sap/ui/support/supportRules/CoreFacade.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ElementTree') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ElementTree'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ElementTree",["jquery.sap.global", "sap/ui/base/ManagedObject"],
	function (jQuery, ManagedObject) {
		"use strict";

		function _isObject(data) {
			return (typeof data === "object" && !Array.isArray(data) && data !== null);
		}

		/**
		 * @param {ElementTreeRenderingOptions} options
		 * @returns {string}
		 * @private
		 */
		function _startElementTreeList(options) {

			return "<ul " + options.attributes.join(" ") + ">";
		}

		/**
		 * @returns {string}
		 * @private
		 */
		function _endElementTreeList() {
			return "</ul>";
		}

		/**
		 * @param {ElementTreeRenderingOptions.controls} options
		 * @returns {string}
		 * @private
		 */
		function _startElementTreeListItem(options, hasIssue) {
			var html = "<li data-id=\"" + options.id + "\" ";
			if (hasIssue) {
				html += "issue";
			}
			html += ">";
			return html;
		}

		/**
		 * @returns {string}
		 * @private
		 */
		function _endElementTreeListItem() {
			return "</li>";
		}

		/**
		 * Create HTML for the left part of the ElementTree list item.
		 * @param {ElementTreeOptions.controls} controls
		 * @param {number} paddingLeft
		 * @returns {string}
		 * @private
		 */
		function _getElementTreeLeftColumnOfListItem(controls, paddingLeft) {
			var html = "<offset style=\"padding-left:" + paddingLeft + "px\" >";

			if (controls.content.length > 0) {
				html += "<arrow down=\"true\"></arrow>";
			} else {
				html += "<place-holder></place-holder>";
			}

			html += "</offset>";

			return html;
		}

		/**
		 * Create HTML for the right part of the ElementTree list item.
		 * @param {Object} control - JSON object form {ElementTreeOptions.controls}
		 * @returns {string}
		 * @private
		 */
		function _getElementTreeRightColumnOfListItem(control, numberOfIssues) {
			var splitControlName = control.name.split(".");
			var name = splitControlName[splitControlName.length - 1];
			var nameSpace = control.name.replace(name, "");
			var hideShowClass = (numberOfIssues > 0) ? "showNumbOfIssues" : "hideNumbOfIssues";

			return "<tag data-search=\"" + control.name + control.id + "\">" +
				"&#60;" +
				"<namespace>" + nameSpace + "</namespace>" +
				name +
				"<attribute>&#32;id=\"<attribute-value>" + control.id + "</attribute-value>\"</attribute>" +
				"&#62;" +
				"</tag>" + "<span class = " + hideShowClass  + ">[" + numberOfIssues + "  issue(s)] </span>";
		}

		/**
		 * Search for the nearest parent Node.
		 * @param {element} element - HTML DOM element that will be the root of the search
		 * @param {string} parentNodeName - The desired HTML parent element nodeName
		 * @returns {Object} HTML DOM element
		 * @private
		 */
		function _findNearestDOMParent(element, parentNodeName) {
			while (element.nodeName !== parentNodeName) {
				if (element.nodeName === "CONTROL-TREE") {
					break;
				}
				element = element.parentNode;
			}

			return element;
		}

		/**
		 * ElementTree constructor.
		 * @param {string} id - The id of the DOM container
		 * @param {ElementTree} instantiationOptions
		 * @constructor
		 */
		function ElementTree(id, instantiationOptions) {
			var areInstantiationOptionsAnObject = _isObject(instantiationOptions);
			var options;

			/**
			 * Make sure that the options parameter is Object and
			 * that the ElementTree can be instantiate without initial options.
			 */
			if (areInstantiationOptionsAnObject) {
				options = instantiationOptions;
			} else {
				options = {};
			}

			// Save DOM reference
			this._ElementTreeContainer = document.getElementById(id);

			/**
			 * Method fired when the number of issues against an element is clicked
			 */
			this.onIssueCountClicked = options.onIssueCountClicked ? options.onIssueCountClicked : function () {};

			/**
			 * Method fired when the selected element in the ElementTree is changed.
			 * @param {string} selectedElementId - The selected element id
			 */
			this.onSelectionChanged = options.onSelectionChanged ? options.onSelectionChanged : function (selectedElementId) {};

			/**
			 * Method fired when the hovered element in the ElementTree is changed.
			 * @param {string} hoveredElementId - The hovered element id
			 */
			this.onHoverChanged = options.onHoverChanged ? options.onHoverChanged : function (hoveredElementId) {};

			/**
			 * Method fired when the mouse is out of the ElementTree.
			 */
			this.onMouseOut = options.onMouseOut ? options.onMouseOut : function () {};

			/**
			 * Method fired when the initial ElementTree rendering is done.
			 */
			this.onInitialRendering = options.onInitialRendering ? options.onInitialRendering : function () {};

			// Object with the tree model that will be visualized
			this.setData(options.data);
		}

		/**
		 * Initialize Tree.
		 */
		ElementTree.prototype.init = function () {
			if (!this._ElementTreeContainer) {
				return;
			}

			this._createHTML();
			this._createHandlers();

			// Fire event to notify that the ElementTree is initialized
			this.onInitialRendering();
		};

		/**
		 * Get the data model used for the tree.
		 * @returns {ElementTreeOptions} the data that is used for the tree
		 */
		ElementTree.prototype.getData = function () {
			return this._data;
		};

		/**
		 * Set the data model used for the tree.
		 * @param {ElementTreeOptions} data
		 * @returns {ElementTree}
		 */
		ElementTree.prototype.setData = function (data) {
			var oldData = this.getData();
			var isDataAnObject = _isObject(data);

			if (isDataAnObject === false) {
				jQuery.sap.log.warning("The parameter should be an Object");
				return;
			}

			// Make sure that the new data is different from the old one
			if (JSON.stringify(oldData) === JSON.stringify(data)) {
				return;
			}

			this._data = data;

			// Initialize ElementTree on first rendering
			// If it is a second rendering, render only the tree elements
			if (this._isFirstRendering === undefined) {
				this.init();
				this._isFirstRendering = true;
			} else {
				this._createTree();
			}

			return this;
		};

		ElementTree.prototype.setContainerId = function (id) {
			this._ElementTreeContainer = document.getElementById(id);
			this.init();
		};

		/**
		 * Returns the selected <li> element of the tree.
		 * @returns {Element} HTML DOM element
		 */
		ElementTree.prototype.getSelectedElement = function () {
			return this._selectedElement;
		};

		/**
		 * Set the selected <li> element of the tree.
		 * @param {string} elementID - HTML DOM element id
		 * @returns {ElementTree}
		 */
		ElementTree.prototype.setSelectedElement = function (elementID, bNotify) {
			var selectedElement;

			if (typeof elementID !== "string") {
				jQuery.sap.log.warning("Please use a valid string parameter");
				return;
			}

			selectedElement = this._ElementTreeContainer.querySelector("#" + elementID);

			if (selectedElement === null) {
				jQuery.sap.log.warning("The selected element is not a child of the ElementTree");
				return;
			}

			this._selectedElement = selectedElement;
			this._selectTreeElement(selectedElement, bNotify);

			return this;
		};

		ElementTree.prototype.clearSelection = function () {
			var selectedList = this._ElementTreeContainer.querySelector("[selected]");

			if (selectedList) {
				selectedList.removeAttribute("selected");
			}
		};

		/**
		 * Create and places the ElementTree HTML.
		 * @private
		 */
		ElementTree.prototype._createHTML = function () {
			var html;

			html = this._createFilter();
			html += this._createTreeContainer();

			this._ElementTreeContainer.innerHTML = html;
			// Save reverences for future use
			this._setReferences();

			if (this.getData() !== undefined) {
				this._createTree();
			}
		};

		/**
		 * Create the HTML needed for filtering.
		 * @returns {string}
		 * @private
		 */
		ElementTree.prototype._createFilter = function () {
			return "<filter>" +
				"<end>" +
				"<label><input type=\"checkbox\" issues checked/>Issues</label>" +
				"<label><input type=\"checkbox\" namespaces checked/>Namespaces</label>" +
				"<label><input type=\"checkbox\" attributes/>Attributes</label>" +
				"</end>" +
				"</filter>";
		};

		/**
		 * Create the HTML container for the tree.
		 * @returns {string}
		 * @private
		 */
		ElementTree.prototype._createTreeContainer = function () {
			return "<tree show-namespaces show-problematic-elements></tree>";
		};

		/**
		 * Create ElementTree HTML.
		 */
		ElementTree.prototype._createTree = function () {
			var controls = this.getData().controls;

			this._treeContainer.innerHTML = this._createTreeHTML(controls);
		};

		/**
		 * Create HTML tree from JSON.
		 * @param {ElementTreeOptions.controls} controls
		 * @param {number} level - nested level
		 * @returns {string} HTML ElementTree in form of a string
		 * @private
		 */
		ElementTree.prototype._createTreeHTML = function (controls, level) {
			if (controls === undefined || controls.length === 0) {
				return "";
			}

			var html = "";
			var nestedLevel = level || 0;
			var paddingLeft = ++nestedLevel * 10;
			var that = this;
			var issuesIds = this.getData().issuesIds;

			controls.forEach(function (control) {
				html += _startElementTreeList({
					attributes: ["expanded=\"true\""]
				});

				var hasIssue = issuesIds[control.id] !== undefined ? true : false;
				var numberOfIssues = 0;
				var numberOfIssues = hasIssue ? issuesIds[control.id].length : 0;
					html += _startElementTreeListItem({
					id: control.id
				}, hasIssue);

				html += _getElementTreeLeftColumnOfListItem(control, paddingLeft);

				html += _getElementTreeRightColumnOfListItem(control, numberOfIssues);

				html += _endElementTreeListItem();

				html += that._createTreeHTML(control.content, nestedLevel);

				html += _endElementTreeList();
			});

			return html;
		};

		/**
		 * Hide/Show nested "<ul>" in "<li>" elements.
		 * @param {Element} target - DOM element
		 * @private
		 */
		ElementTree.prototype._toggleCollapse = function (target) {
			var targetParent = _findNearestDOMParent(target.parentNode, "UL");

			if (target.getAttribute("right") === "true") {
				target.removeAttribute("right");
				target.setAttribute("down", "true");

				targetParent.setAttribute("expanded", "true");
			} else if (target.getAttribute("down") === "true") {
				target.removeAttribute("down");

				targetParent.removeAttribute("expanded");
				target.setAttribute("right", "true");
			}
		};

		/**
		 * Add visual selection to clicked "<li>" elements.
		 * @param {Element} targetElement - DOM element
		 * @private
		 */
		ElementTree.prototype._selectTreeElement = function (targetElement, bNotify) {
			var target = _findNearestDOMParent(targetElement, "LI");
			var dataId = target.attributes["data-id"];

			if (!dataId) {
				return;
			}

			var id = dataId.value;
			// Prevent tree element selection for allowing proper multiple tree element selection for copy/paste
			if (id === this._ElementTreeContainer.id) {
				return;
			}

			this._scrollToElement(target);

			if (bNotify) {
				this.onSelectionChanged(id);
			}

			if (targetElement.classList.contains("showNumbOfIssues")) {
				this.clearSelection();

				target.setAttribute("selected", "true");

				if (bNotify) {
					this.onIssueCountClicked(id);
				}
			}
		};

		/**
		 * Scroll to element in the ElementTree.
		 * @param {Element} target - DOM element to which need to be scrolled
		 */
		ElementTree.prototype._scrollToElement = function (target) {
			var desiredViewBottomPosition = this._treeContainer.offsetHeight - this._treeContainer.offsetTop + this._treeContainer.scrollTop;

			if (target.offsetTop > desiredViewBottomPosition || target.offsetTop < this._treeContainer.scrollTop) {
				this._treeContainer.scrollTop = target.offsetTop - window.innerHeight / 6;
			}
		};

		/**
		 * Search tree elements that match given criteria.
		 * @param {string} userInput - Search criteria
		 * @private
		 */
		ElementTree.prototype._searchInTree = function (userInput) {
			var searchableElements = this._ElementTreeContainer.querySelectorAll("[data-search]");
			var searchInput = userInput.toLocaleLowerCase();
			var elementInformation;

			for (var i = 0; i < searchableElements.length; i++) {
				elementInformation = searchableElements[i].getAttribute("data-search").toLocaleLowerCase();

				if (elementInformation.indexOf(searchInput) !== -1) {
					searchableElements[i].parentNode.setAttribute("matching", true);
				} else {
					searchableElements[i].parentNode.removeAttribute("matching");
				}
			}
		};

		/**
		 * Remove  "matching" attribute from the search.
		 * @private
		 */
		ElementTree.prototype._removeAttributesFromSearch = function () {
			var elements = this._treeContainer.querySelectorAll("[matching]");

			for (var i = 0; i < elements.length; i++) {
				elements[i].removeAttribute("matching");
			}
		};

		/**
		 * Visualize the number of elements which satisfy the search.
		 * @private
		 */
		ElementTree.prototype._setSearchResultCount = function (count) {
			this._filterContainer.querySelector("results").innerHTML = "(" + count + ")";
		};

		/**
		 * Event handler for mouse click on a tree element arrow.
		 * @param {Object} event - click event
		 * @private
		 */
		ElementTree.prototype._onArrowClick = function (event) {
			var target = event.target;

			if (target.nodeName === "ARROW") {
				this._toggleCollapse(target);
			} else {
				this._selectTreeElement(target, true);
			}
		};

		/**
		 * Event handler for user input in "search" input.
		 * @param {Object} event - keyup event
		 * @private
		 */
		ElementTree.prototype._onSearchInput = function (event) {
			var target = event.target;
			var searchResultCount;

			if (target.getAttribute("search") !== null) {

				if (target.value.length !== 0) {
					this._searchInTree(target.value);
				} else {
					this._removeAttributesFromSearch("matching");
				}

				searchResultCount = this._treeContainer.querySelectorAll("[matching]").length;
				this._setSearchResultCount(searchResultCount);
			}
		};

		/**
		 * Event handler for onsearch event.
		 * @param {Object} event - onsearch event
		 * @private
		 */
		ElementTree.prototype._onSearchEvent = function (event) {
			var searchResultCount;

			if (event.target.value.length === 0) {
				this._removeAttributesFromSearch("matching");

				searchResultCount = this._treeContainer.querySelectorAll("[matching]").length;
				this._setSearchResultCount(searchResultCount);
			}

		};

		/**
		 * Event handler for ElementTree options change.
		 * @param {Object} event - click event
		 * @private
		 */
		ElementTree.prototype._onOptionsChange = function (event) {
			var target = event.target;

			if (target.getAttribute("filter") !== null) {
				if (target.checked) {
					this._treeContainer.setAttribute("show-filtered-elements", true);
				} else {
					this._treeContainer.removeAttribute("show-filtered-elements");
				}
			}

			if (target.getAttribute("issues") !== null) {
				if (target.checked) {
					this._treeContainer.setAttribute("show-problematic-elements", true);
				} else {
					this._treeContainer.removeAttribute("show-problematic-elements");
				}
			}

			if (target.getAttribute("namespaces") !== null) {
				if (target.checked) {
					this._treeContainer.setAttribute("show-namespaces", true);
				} else {
					this._treeContainer.removeAttribute("show-namespaces");
				}
			}

			if (target.getAttribute("attributes") !== null) {
				if (target.checked) {
					this._treeContainer.setAttribute("show-attributes", true);
				} else {
					this._treeContainer.removeAttribute("show-attributes");
				}
			}

		};

		/**
		 * Event handler for mouse hover on tree element.
		 * @param {Object} event - mouse event
		 * @private
		 */
		ElementTree.prototype._onTreeElementMouseHover = function (event) {
			var target = _findNearestDOMParent(event.target, "LI");

			var hoverList = this._ElementTreeContainer.querySelector("[hover]");

			if (hoverList) {
				hoverList.removeAttribute("hover");
			}

			target.setAttribute("hover", "true");

			var dataId = target.attributes["data-id"];
			this.onHoverChanged(dataId && dataId.value);
		};

		/**
		 * Event handler for mouse out of the tree element.
		 * @param {Object} event - mouse event
		 * @private
		 */
		ElementTree.prototype._onTreeElementMouseOut = function (event) {
			this.onMouseOut();
		};

		/**
		 * Create all event handlers for the ElementTree.
		 * @private
		 */
		ElementTree.prototype._createHandlers = function () {
			this._treeContainer.onclick = this._onArrowClick.bind(this);
			this._filterContainer.onkeyup = this._onSearchInput.bind(this);
			this._filterContainer.onsearch = this._onSearchEvent.bind(this);
			this._filterContainer.onchange = this._onOptionsChange.bind(this);
			this._ElementTreeContainer.onmouseover = this._onTreeElementMouseHover.bind(this);
			this._ElementTreeContainer.onmouseout = this._onTreeElementMouseOut.bind(this);
		};

		/**
		 * Save references to ElementTree different sections.
		 * @private
		 */
		ElementTree.prototype._setReferences = function () {
			this._filterContainer = this._ElementTreeContainer.querySelector("filter");
			this._treeContainer = this._ElementTreeContainer.querySelector("tree");
		};

		return ElementTree;
	});

}; // end of sap/ui/support/supportRules/ElementTree.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ExecutionScope') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ExecutionScope'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ExecutionScope",["jquery.sap.global"],
	function(jQuery) {
		"use strict";

		var coreInstance = null,
			_context = null,
			elements = [];

		var globalContext = {
			setScope: function () {
				for (var i in coreInstance.mElements) {
					elements.push(coreInstance.mElements[i]);
				}
			}
		};

		var subtreeContext = {
			setScope: function () {
				var parent = sap.ui.getCore().byId(_context.parentId);
				//TODO: Handle parent not found
				elements = parent.findAggregatedObjects(true);
			}
		};

		var componentsContext = {
			setScope: function () {
				var set = {};
				_context.components.forEach(function (componentId) {
					var component = coreInstance.mObjects.component[componentId],
						aggregations = component.findAggregatedObjects(true);

					aggregations.forEach(function (agg) {
						set[agg.getId()] = agg;
					});
				});

				for (var i in set) {
					if (set.hasOwnProperty(i)){
						elements.push(set[i]);
					}
				}
			}
		};

		var contextTypes = {
			global: globalContext,
			subtree: subtreeContext,
			components: componentsContext
		};

		function ExecutionScope(core, context) {
			coreInstance = core;
			elements = [];
			_context = context;

			contextTypes[_context.type].setScope();

			return {
				getElements: function () {
					return elements;
				},
				getElementsByClassName: function (classNameSelector) {
					if (typeof classNameSelector === "string") {
						return elements.filter(function (element) {
							return element.getMetadata().getName() === classNameSelector;
						});
					}

					if (typeof classNameSelector === "function") {
						return elements.filter(function (element) {
							return element instanceof classNameSelector;
						});
					}
				},
				/**
				 * Gets the logged objects by object type
				 */
				getLoggedObjects: function (type) {
					var log = jQuery.sap.log.getLog(),
						loggedObjects = [];

					/**
					 * Add logEntries that have support info object,
					 * ad that have the same type as the type provided
					 */
					log.forEach(function (logEntry) {
						if (!logEntry.supportInfo) {
							return;
						}

						var elemIds = elements.map(function (element) {
							return element.getId();
						});

						var hasElemId = !!logEntry.supportInfo.elementId,
							typeMatch = logEntry.supportInfo.type === type || type === undefined,
							scopeMatch = !hasElemId || (jQuery.inArray(logEntry.supportInfo.elementId, elemIds) > -1);

						/**
						 * Give the developer the ability to pass filtering function
						 */
						if (typeof type === "function" && type(logEntry) && scopeMatch) {
							loggedObjects.push(logEntry);
							return;
						}

						if (typeMatch && scopeMatch) {
							loggedObjects.push(logEntry);
						}
					});

					return loggedObjects;
				},
				_getType: function () {
					return _context.type;
				},
				_getContext: function () {
					return _context;
				}
			};
		}

		ExecutionScope.possibleScopes = Object.getOwnPropertyNames(contextTypes);

		return ExecutionScope;
	}, true);
}; // end of sap/ui/support/supportRules/ExecutionScope.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.Highlighter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.Highlighter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/Highlighter",[],
	function () {
		"use strict";

		// Reference for the highlighter DOM element
		var _highLighter = null;

		/**
		 * Hide the highlighter.
		 * @private
		 */
		function _hideHighLighter() {
			_highLighter.style.display = "none";
		}

		/**
		 * Show the highlighter.
		 * @private
		 */
		function _showHighLighter() {
			_highLighter.style.display = "block";
		}

		/**
		 * Create DOM element for visual highlighting.
		 * @private
		 */
		function _createHighLighter() {
			var highLighter = document.createElement("div");

			highLighter.style.cssText = "box-sizing: border-box;border:1px solid blue;background: rgba(20, 20, 200, 0.4);position: absolute";

			var highLighterWrapper = document.createElement("div");

			highLighterWrapper.id = "ui5-highlighter";
			highLighterWrapper.style.cssText = "position: fixed;top:0;right:0;bottom:0;left:0;z-index: 1000;overflow: hidden;";
			highLighterWrapper.appendChild(highLighter);

			document.body.appendChild(highLighterWrapper);

			// Save reference for later usage
			_highLighter = document.getElementById("ui5-highlighter");

			// Add event handler
			_highLighter.onmouseover = _hideHighLighter;
		}

		/**
		 * Highlight controls.
		 * @type {{setDimensions: Function}}
		 */
		return {
			/**
			 * Set the position of the visual highlighter.
			 * @param {string} elementId - The id of the DOM element that need to be highlighted
			 * @returns {exports}
			 */
			highlight: function (elementId) {
				var highlighter;
				var targetDomElement;
				var targetRect;

				if (_highLighter === null && !document.getElementById("ui5-highlighter")) {
					_createHighLighter();
				} else {
					_showHighLighter();
				}

				highlighter = _highLighter.firstElementChild;
				targetDomElement = document.getElementById(elementId);

				if (targetDomElement) {
					targetRect = targetDomElement.getBoundingClientRect();

					highlighter.style.top = targetRect.top + "px";
					highlighter.style.left = targetRect.left + "px";
					highlighter.style.height = targetRect.height + "px";
					highlighter.style.width = targetRect.width + "px";
				}

				return this;
			},
			/**
			 * Hides the visual highlighter.
			 */
			hideHighLighter: _hideHighLighter
		};
	});

}; // end of sap/ui/support/supportRules/Highlighter.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.IssueManager') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.IssueManager'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.Object'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/IssueManager",["jquery.sap.global", "sap/ui/base/Object"],
	function (jQuery, BaseObject) {
		"use strict";

		var _aIssues = [];
		var _aHistory = [];
		var _convertIssueToViewModel = function (issue) {
			var element = sap.ui.getCore().byId(issue.context.id),
				className = "";

			if (issue.context.id === "WEBPAGE") {
				className = "sap.ui.core";
			} else if (element) {
				className = element.getMetadata().getName();
			}

			return {
				severity: issue.severity,
				name: issue.rule.title,
				description: issue.rule.description,
				resolution: issue.rule.resolution,
				resolutionUrls: issue.rule.resolutionurls,
				audiences: issue.rule.audiences,
				categories: issue.rule.categories,
				details: issue.details,
				ruleLibName: issue.rule.libName,
				ruleId: issue.rule.id,
				context: {
					className: className,
					id: issue.context.id
				}
			};
		};

		var IssueManager = {
			/**
			 * Adds an issue to the list of issues found
			 * @param {object} oIssue
			 */
			addIssue: function (oIssue) {
				_aIssues.push(oIssue);
			},
			/**
			 * @param {function} fnCb Callback function to be used in the same
			 * fashion as Array.prototype.forEach
			 */
			walkIssues: function (fnCb) {
				_aIssues.forEach(fnCb);
			},
			clearIssues: function () {
				// Return if no issues
				if (!_aIssues.length) {
					return;
				}

				// Add to history. Using object for future compatibility
				_aHistory.push({
					// Copy array
					issues: _aIssues.slice()
				});

				// Reset issues array
				_aIssues = [];
			},
			/**
			 * @returns {array} Issue history - array of objects.
			 * Each history object has an issues key that contains an array of
			 * issues
			 */
			getHistory: function () {
				this.clearIssues();
				// Copy and return history
				return _aHistory.slice();
			},
			/**
			 * @returns {array} Issue history - array of objects.
			 * Each history object has an issues key that contains the issues grouped
			 * by library and rule in ViewModel format
			 */
			getConvertedHistory: function () {
				var that = this,
					issueHistory = that.getHistory(),
					convertedHistory = [],
					issues = null;

				issueHistory.forEach(function (run) {
					issues = that.groupIssues(
						that.convertToViewModel(run.issues)
					);
					convertedHistory.push({ issues: issues });
				});

				return convertedHistory;
			},
			/**
			 * @returns {array} Issues in ViewModel format
			 * Converts the issues inside the IssueManager
			 */
			getIssuesViewModel: function () {
				var viewModel = [];
				this.walkIssues(function (issue) {
					viewModel.push(_convertIssueToViewModel(issue));
				});
				return viewModel;
			},
			/**
			 * @returns {object} All the rules with issues, selected flag and issueCount properties
			 * The issues are in ViewModel format
			 * @param {object} rules All the rules from _mRulesets
			 * @param {object} selectedRulesIDs The selected rules ids
			 * @param {array} issues The issues to map to the rulesViewModel.
			 * The issues passes should be grouped and in ViewModel format
			 */
			getRulesViewModel: function (rules, selectedRulesIDs, issues) {
				var rulesViewModel = {},
					issueCount = 0,
					group = {},
					library = {},
					rule = {},
					rulesCopy = jQuery.extend(true, {}, rules),
					issuesCopy = jQuery.extend(true, {}, issues);

				for (group in rulesCopy) {
					rulesViewModel[group] = jQuery.extend(true, {}, rulesCopy[group].ruleset._mRules);
					library = rulesViewModel[group];

					// Create non-enumerable properties
					Object.defineProperty(library, 'selected', {
						enumerable: false,
						configurable: true,
						writable: true,
						value: false
					});
					Object.defineProperty(library, 'issueCount', {
						enumerable: false,
						configurable: true,
						writable: true,
						value: 0
					});

					for (rule in rulesCopy[group].ruleset._mRules) {
						library[rule] = jQuery.extend(true, [], library[rule]);

						// Create non-enumerable properties
						Object.defineProperty(library[rule], 'selected', {
							enumerable: false,
							configurable: true,
							writable: true,
							value: false
						});
						Object.defineProperty(library[rule], 'issueCount', {
							enumerable: false,
							configurable: true,
							writable: true,
							value: 0
						});

						// Add selected flag to library and rule level.
						if (selectedRulesIDs[rule]) {
							library[rule].selected = true;
							library.selected = true;
						}

						// Add issue count to library and rule level.
						if (issuesCopy[group] && issuesCopy[group][rule]) {
							// Not creating a new array to keep the properties.
							library[rule].push.apply(library[rule], issuesCopy[group][rule]);
							issueCount = issuesCopy[group][rule].length;
							library[rule].issueCount = issueCount;
							library.issueCount += issueCount;
						}
					}
				}

				return rulesViewModel;
			},
			clearHistory: function () {
				_aHistory = [];
			},
			/**
			 * @returns {array} Issues in ViewModel format
			 * @param {array} The issues to convert
			 * Converts issues to ViewModel format
			 */
			convertToViewModel: function (issues) {
				var viewModel = [];
				for (var i = 0; i < issues.length; i++) {
					viewModel.push(_convertIssueToViewModel(issues[i]));
				}
				return viewModel;
			},
			/**
			 * @returns {array} Grouped issues
			 * @param {array} issues The issues to group. Must be in ViewModel format
			 * Groups issues by library and rule
			 */
			groupIssues: function (issues) {
				var groupedIssues = {},
					issue = {};

				for (var i = 0; i < issues.length; i++) {
					issue = issues[i];

					if (!groupedIssues[issue.ruleLibName]) {
						groupedIssues[issue.ruleLibName] = {};
					}

					if (!groupedIssues[issue.ruleLibName][issue.ruleId]) {
						groupedIssues[issue.ruleLibName][issue.ruleId] = [];
					}

					groupedIssues[issue.ruleLibName][issue.ruleId].push(issue);
				}

				return groupedIssues;
			},
			createIssueManagerFacade: function (oRule) {
				return new IssueManagerFacade(oRule);
			}
		};

		var IssueManagerFacade = function (oRule) {
			this.oRule = oRule;
		};

		IssueManagerFacade.prototype.addIssue = function (oIssue) {
			oIssue.rule = this.oRule;

			if (!sap.ui.support.Severity[oIssue.severity]) {
				throw "The issue from rule " + this.oRule.title + " does not have proper severity defined. Allowed values can be found" +
						"in sap.ui.support.Severity";
			}

			if (!oIssue.context || !oIssue.context.id) {
				throw "The issue from rule '" + this.oRule.title + "' should provide a context id.";
			}

			if (!oIssue.details) {
				throw "The issue from rule '" + this.oRule.title + "' should provide details for the generated issue.";
			}

			IssueManager.addIssue(oIssue);
		};

		return IssueManager;

	}, true);

}; // end of sap/ui/support/supportRules/IssueManager.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.RuleSerializer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.RuleSerializer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/RuleSerializer",[],
	function () {
		"use strict";

		return {
			serialize: function serializeRule(rule) {
				var replacer = function (key, value) {
					if (typeof value === "function") {
						return value.toString();
					} else {
						return value;
					}
				};

				var result = JSON.stringify(rule, replacer);
				return result;
			},
			deserialize: function (serializedRule, stringifyCheck) {
				var rule;

				if (typeof serializedRule === 'string') {
					rule = JSON.parse(serializedRule);
				} else {
					rule = serializedRule;
				}

				/* eslint-disable no-eval */
				if (!stringifyCheck && rule.check !== undefined) {
					eval("rule.check = " + rule.check);
				}
				/* eslint-enable no-eval */

				return rule;
			}
		};
	}, true);

}; // end of sap/ui/support/supportRules/RuleSerializer.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.Storage') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/*global localStorage */

jQuery.sap.declare('sap.ui.support.supportRules.Storage'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/Storage",[
	"sap/ui/support/supportRules/RuleSerializer",
	"sap/ui/support/supportRules/Constants"
],
function (RuleSerializer, constants) {
	"use strict";

	function encode(sData) {
		return window.btoa(unescape(encodeURIComponent(sData)));
	}

	function decode(sData) {
		return decodeURIComponent(escape(window.atob(sData)));
	}

	return {
		/**
		 * Returns all previously created user temporary rules
		 * @returns {Array} An array containing all the temporary rules
		 */
		getRules: function () {
			var rawLSData = localStorage.getItem(constants.LOCAL_STORAGE_TEMP_RULES_KEY);

			if (!rawLSData) {
				return null;
			}

			var tempRules = JSON.parse(decode(rawLSData));

			tempRules = tempRules.map(function (tempRule) {
				return RuleSerializer.deserialize(tempRule);
			});

			return tempRules;
		},

		/**
		 * Saves the temporary rules into the local storage persistence layer
		 * @param {Array} rules The temporary rules from the shared model
		 */
		setRules: function (rules) {
			var stringifyRules = encode(JSON.stringify(rules));
			localStorage.setItem(constants.LOCAL_STORAGE_TEMP_RULES_KEY, stringifyRules);
		},

		getSelectedRules: function () {
			var rawLSData = localStorage.getItem(constants.LOCAL_STORAGE_SELECTED_RULES_KEY);

			if (!rawLSData) {
				return null;
			}

			return JSON.parse(rawLSData);
		},

		setSelectedRules: function (selectedRules) {
			localStorage.setItem(constants.LOCAL_STORAGE_SELECTED_RULES_KEY, JSON.stringify(selectedRules));
		},

		setSelectedContext: function(selectedContext) {
			localStorage.setItem(constants.LOCAL_STORAGE_SELECTED_CONTEXT_KEY, JSON.stringify(selectedContext));
		},

		getSelectedContext: function() {
			return JSON.parse(localStorage.getItem(constants.LOCAL_STORAGE_SELECTED_CONTEXT_KEY));
		},

		setSelectedScopeComponents: function(contextComponent)  {
			localStorage.setItem(constants.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY, JSON.stringify(contextComponent));
		},

		getSelectedScopeComponents: function() {
			var componentContext = localStorage.getItem(constants.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY);
			return JSON.parse(componentContext);
		},
		/**
		 * Overwrites the temporary rules into the local storage persistence layer
		 * @param {Array} rules The temporary rules from the shared model
		 */
		removeSelectedRules: function(selectedRules) {
			this.setRules(selectedRules);
		},

		removeAllData: function() {
			localStorage.removeItem(constants.LOCAL_STORAGE_TEMP_RULES_KEY);
			localStorage.removeItem(constants.LOCAL_STORAGE_SELECTED_CONTEXT_KEY);
			localStorage.removeItem(constants.LOCAL_STORAGE_SELECTED_CONTEXT_COMPONENT_KEY);
		},

		/**
		 * Create cookie to save information if we wish to preserve data in local storage
		 * @param {String} name of the cookie
		 * @param {boolean} value of the cookie
		 */
		createPersistenceCookie: function(name, value) {
			document.cookie = name + "=" + value;
		},

		readPersistenceCookie: function(cname) {

			var name = cname + "=",
				decodedCookie = decodeURIComponent(document.cookie),
				ca = decodedCookie.split(';'),
				output = "";
			for (var i = 0; i < ca.length; i++) {
				var c = ca[i];
				while (c.charAt(0) == ' ') {
					c = c.substring(1);
				}
				if (c.indexOf(name) == 0) {
					output = c.substring(name.length, c.length);
					return  output;
				}
			}
			return output;

		},

		deletePersistenceCookie: function(cookieName) {
			document.cookie = cookieName + '=;expires=Thu, 01 Jan 1970 00:00:01 GMT;';
		}

	};
}, true);

}; // end of sap/ui/support/supportRules/Storage.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.WCBChannels') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.WCBChannels'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/WCBChannels",[
],
function () {
	"use strict";

	// sap.ui.support
	// WindowCommunicationBus channels
	return {
		ON_CORE_STATE_CHANGE:       "ON_CORE_STATE_CHANGE",
		ON_SHOW_REPORT_REQUEST:     "ON_SHOW_REPORT_REQUEST",
		ON_DOWNLOAD_REPORT_REQUEST: "ON_DOWNLOAD_REPORT_REQUEST",
		ON_ANALYZE_REQUEST:         "ON_ANALYZE_REQUEST",

		ON_INIT_ANALYSIS_CTRL:      "ON_INIT_ANALYSIS_CTRL",
		ON_PROGRESS_UPDATE:         "ON_PROGRESS_UPDATE",
		ON_ANALYZE_FINISH:          "ON_ANALYZE_FINISH",

		VERIFY_CREATE_RULE:         "VERIFY_CREATE_RULE",
		VERIFY_RULE_CREATE_RESULT:  "VERIFY_RULE_CREATE_RESULT",

		VERIFY_UPDATE_RULE:         "VERIFY_UPDATE_RULE",
		VERIFY_RULE_UPDATE_RESULT:  "VERIFY_RULE_UPDATE_RESULT",

		POST_AVAILABLE_LIBRARIES:    "POST_AVAILABLE_LIBRARIES",
		LOAD_RULESETS:               "LOAD_RULESETS",

		GET_AVAILABLE_COMPONENTS:   "GET_AVAILABLE_COMPONENTS",
		POST_AVAILABLE_COMPONENTS:  "POST_AVAILABLE_COMPONENTS",

		HIGHLIGHT_ELEMENT:          "HIGHLIGHT_ELEMENT",
		OPEN_URL:                   "OPEN_URL",

		TREE_ELEMENT_MOUSE_ENTER:   "TREE_ELEMENT_MOUSE_ENTER",
		TREE_ELEMENT_MOUSE_OUT:     "TREE_ELEMENT_MOUSE_OUT",

		UPDATE_SUPPORT_RULES:       "UPDATE_SUPPORT_RULES",
		EXTERNAL_MODULE_UPLOADED:   "EXTERNAL_MODULE_UPLOADED",

		TOGGLE_FRAME_HIDDEN:        "TOGGLE_FRAME_HIDDEN",
		ENSURE_FRAME_OPENED:        "ENSURE_FRAME_OPENED",
		RESIZE_FRAME:               "RESIZE_FRAME"
	};
}, true);

}; // end of sap/ui/support/supportRules/WCBChannels.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.WindowCommunicationBus') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.WindowCommunicationBus'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/WindowCommunicationBus",[
	"jquery.sap.global"
],
function (jQuery) {
	"use strict";

	var CommunicationBus = {
		channels: {},
		onMessageChecks: []
	};

	var originParameter = jQuery.sap.getUriParameters().get("sap-ui-xx-support-origin");
	var origin = originParameter;
	var frameIdentifier = jQuery.sap.getUriParameters().get("sap-ui-xx-frame-identifier") || '_unnamed_frame_-_use_message_origin_';

	if (!origin) {
		// When loading from CDN, module path needs to be relative to that origin
		var modulePathURI = new window.URI(jQuery.sap.getModulePath("sap.ui.support"));
		var protocol = modulePathURI.protocol() === "" ?
			window.location.protocol.replace(":", "") : modulePathURI.protocol();

		var host = modulePathURI.host() === "" ?
			window.location.host : modulePathURI.host();

		origin = protocol + "://" + host;
	}

	CommunicationBus.origin = origin;

	CommunicationBus.subscribe = function (channelName, callback, context) {
		if (!this.channels[channelName]) {
			this.channels[channelName] = [{
				callback: callback,
				context: context
			}];
			return;
		}

		this.channels[channelName].push({
			callback: callback,
			context: context
		});
	};

	CommunicationBus.publish = function (channelName, aParams) {
		var receivingWindow = this._getReceivingWindow(),
			dataObject = {
				channelName: channelName,
				params: aParams,
				_frameIdentifier: frameIdentifier,
				_origin: window.location.href
			};

		// TODO: we need to find a way to make sure we're executing on the
		// correct window. Issue happen in cases where we're too fast to
		// post messages to the iframe but it is not there yet
		receivingWindow.postMessage(dataObject, this.origin);
	};

	CommunicationBus.destroyChanels = function () {
		CommunicationBus.channels = {};
	};

	CommunicationBus._getReceivingWindow = function () {

		if (window.communicationWindows && window.communicationWindows.hasOwnProperty("supportTool")) {
			return window.communicationWindows.supportTool;
		}

		// If opener is not null, tool's UI is in an IFRAME (parent is used),
		// else it's a POPUP WINDOW (opener is used)
		return window.opener || window.parent;
	};

	CommunicationBus._onmessage = function (evt) {
		// Validate received message
		var checkResults = CommunicationBus.onMessageChecks.every(function (fnMsgCheck) {
			return fnMsgCheck.call(null, evt);
		});

		if (!checkResults) {
			jQuery.sap.log.error("Message was received but failed validation");
			return;
		}

		var channelName = evt.data.channelName,
			params = evt.data.params,
			callbackObjects = CommunicationBus.channels[channelName];

		if (!callbackObjects) {
			return;
		}

		callbackObjects.forEach(function (cbObj) {
			cbObj.callback.apply(cbObj.context, [params]);
		});
	};

	if (window.addEventListener) {
		window.addEventListener("message", CommunicationBus._onmessage, false);
	} else {
		window.attachEvent("onmessage", CommunicationBus._onmessage);
	}

	// Dependent frames notify parent
	if (originParameter) {
		CommunicationBus.publish("COMM_BUS_INTERNAL", "READY");
	}

	return CommunicationBus;
}, true);

}; // end of sap/ui/support/supportRules/WindowCommunicationBus.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.report.AnalysisHistoryFormatter') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Formats the analysis history in a single string.
 */
jQuery.sap.declare('sap.ui.support.supportRules.report.AnalysisHistoryFormatter'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/report/AnalysisHistoryFormatter",[], function() {
	"use strict";

    // Create a line with 196 "-"
    var _horizontalSeparator = Array(196).join("-"),
        _verticalSeparator = "|";

    function formatString(text, columnSize) {
        var formatted = "",
            text = text || "";

        // Set default.
        if (!columnSize) {
            columnSize = 50;
        }

        // Clear new line characters and double quotes to avoid bad formatting.
        formatted = text.replace(/(\r\n|\n|\r)/gm, " ").replace(/(\")/gm, "");

        if (formatted.length > columnSize) {
            formatted = formatted.substring(0, columnSize - 3) + "...";
        } else {
            while (formatted.length < columnSize) {
                formatted += " ";
            }
        }

        return formatted;
    }

    function formatRule(rule) {
        var text = _horizontalSeparator + "\n";
        // Use the first issue to get the rule properties.
        text += _verticalSeparator + formatString("rule id: " + rule[0].ruleId, 193) + _verticalSeparator + "\n";
        text += _verticalSeparator + formatString("name: " + rule[0].name, 193) + _verticalSeparator + "\n";
        text += _verticalSeparator + formatString("library: " + rule[0].ruleLibName, 193) + _verticalSeparator + "\n";
        text += _verticalSeparator + formatString("categories: " + rule[0].categories.join(", "), 193) + _verticalSeparator + "\n";
        text += _verticalSeparator + formatString("audiences: " + rule[0].audiences.join(", "), 193) + _verticalSeparator + "\n";
        text += _verticalSeparator + formatString("description: " + rule[0].description, 193) + _verticalSeparator + "\n";
        text += _verticalSeparator + formatString("resolution: " + rule[0].resolution, 193) + _verticalSeparator + "\n";
        text += _horizontalSeparator + "\n";
        text += _verticalSeparator + formatString("id", 50);
        text += _verticalSeparator + formatString("class name", 30);
        text += _verticalSeparator + formatString("status", 10);
        text += _verticalSeparator + formatString("details", 100);
        text += _verticalSeparator + "\n";
        text += _horizontalSeparator + "\n";

        for (var i = 0; i < rule.length; i++) {
            text += _verticalSeparator + formatString(rule[i].context.id, 50);
            text += _verticalSeparator + formatString(rule[i].context.className, 30);
            text += _verticalSeparator + formatString(rule[i].severity, 10);
            text += _verticalSeparator + formatString(rule[i].details, 100);
            text += _verticalSeparator + "\n";
        }

        text += _horizontalSeparator + "\n";

        return text;
    }

    function formatSingleRun(libraries) {
        var text = "";

        if (!libraries) {
            return text;
        }

        for (var lib in libraries) {
            for (var rule in libraries[lib]) {
                text += formatRule(libraries[lib][rule]);
            }

            text += "\n";
        }

        text += "\n";

        return text;
    }

    function format(analysisHistory) {
        var text = "";

        if (!analysisHistory) {
            return text;
        }

        for (var i = 0; i < analysisHistory.length; i++) {
            text += "\n";
            text += "Run " + (i + 1) + "\n";
            text += formatSingleRun(analysisHistory[i].issues);
            text += "\n";
        }

        return text;
    }

    return {
		format: format
	};
}, true);
}; // end of sap/ui/support/supportRules/report/AnalysisHistoryFormatter.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.report.Archiver') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Creates a zip file
 */
jQuery.sap.declare('sap.ui.support.supportRules.report.Archiver'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.jszip'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.util.File'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/report/Archiver",['jquery.sap.global', 'sap/ui/thirdparty/jszip', 'sap/ui/core/util/File'],
	function (jQuery, JSZip, File) {
	"use strict";

	/**
	 * The Archiver collects files for zip download
	 */
	var Archiver = function() {
		this._mData = {};
	};

	/**
	 * Adds vData with the name to the data collection. sType json and has will use JSON.stringify
	 */
	Archiver.prototype.add = function(sName, vData, sType) {
		if (!sName) {
			jQuery.sap.log.error("Archiver: No name was given.");
			return false;
		}
		if (!vData) {
			jQuery.sap.log.error("Archiver: No data was given.");
			return false;
		}
		if (typeof vData === "string") {
			this._mData[sName] = vData;
			return true;
		} else if (sType) {
			if ((sType === "json" || sType === "har") && (jQuery.isPlainObject(vData) || jQuery.isArray(vData))) {
				try {
					this._mData[sName] = JSON.stringify(vData);
					return true;
				} catch (ex) {
					jQuery.sap.log.error("Archiver: JSON data could not be serialized for " + sName);
				}
			} else {
				jQuery.sap.log.error("Archiver: JSON data could not be serialized for " + sType + ". Either the type is unknown or the data has a wrong format.");
			}
		} else {
			jQuery.sap.log.error("Archiver: Data could not be serialized for " + sName + ". Data is is not a string or has a an invalid type.");
			return false;
		}
		return false;
	};

	/**
	 * Downloads a zip file
	 * @public
	 * @param {string} fileName the name of the zip file
	 */
	Archiver.prototype.download = function(fileName) {
		var oZip = new JSZip();

		if (oZip) {
			for (var n in this._mData) {
				oZip.file(n, this._mData[n]);
			}

			var oContent = oZip.generate({
				type : "blob"
			});

			File.save(oContent, fileName, "zip", "application/zip");
		}
	};

	Archiver.prototype.clear = function() {
		this._mData = {};
		return true;
	};

	Archiver.prototype.hasData = function(sName) {
		if (sName !== undefined) {
			return this._mData.hasOwnProperty(sName);
		}
		return Object.keys(this._mData).length > 0;
	};

	return Archiver;
}, true);

}; // end of sap/ui/support/supportRules/report/Archiver.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.report.DataCollector') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Provides methods for information retrieval from the core.
 */
jQuery.sap.declare('sap.ui.support.supportRules.report.DataCollector'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.support.ToolsAPI'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.URI'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/report/DataCollector",['jquery.sap.global', 'sap/ui/core/support/ToolsAPI', 'sap/ui/thirdparty/URI'],
	function (jQuery, ToolsAPI, URI) {
	"use strict";

	/**
	 * The DataCollector collects information.
	 */
	var DataCollector = function(oCore) {
		this._oCore = oCore;
	};

	/**
	 * @returns {Array} All loaded manifest.json files.
	 */
	DataCollector.prototype.getAppInfo = function() {
		var appInfos = [];
		for (var componentName in this._oCore.mObjects.component) {
			var component = this._oCore.mObjects.component[componentName];
			var sapApp = component.getMetadata().getManifestEntry('sap.app');
			appInfos.push(sapApp);
		}
		return appInfos;
	};

	/**
	 * Retrieves all technical information. Reused from diagnostics tools.
	 * @returns {Object}
	 */
	DataCollector.prototype.getTechInfoJSON = function() {
		var oCfg = ToolsAPI.getFrameworkInformation();
		var oTechData = {
			sapUi5Version: null,
			version: oCfg.commonInformation.version,
			build: oCfg.commonInformation.buildTime,
			change: oCfg.commonInformation.lastChange,
			jquery: oCfg.commonInformation.jquery,
			useragent: oCfg.commonInformation.userAgent,
			docmode: oCfg.commonInformation.documentMode,
			debug: oCfg.commonInformation.debugMode,
			bootconfig: oCfg.configurationBootstrap,
			config:  oCfg.configurationComputed,
			libraries: oCfg.libraries,
			loadedLibraries: oCfg.loadedLibraries,
			modules: oCfg.loadedModules,
			uriparams: oCfg.URLParameters,
			appurl: oCfg.commonInformation.applicationHREF,
			title: oCfg.commonInformation.documentTitle,
			statistics: oCfg.commonInformation.statistics,
			resourcePaths: [],
			themePaths : [],
			locationsearch: document.location.search,
			locationhash: document.location.hash
		};

		//add absolute paths for resources
		var aModules = jQuery.sap.getAllDeclaredModules();
		var aResults = [];
		for (var i = 0; i < aModules.length; i++) {
			aResults.push({
				moduleName : aModules[i],
				relativePath: jQuery.sap.getResourcePath(aModules[i]),
				absolutePath: URI(jQuery.sap.getResourcePath(aModules[i])).absoluteTo(document.location.origin + document.location.pathname).toString()
			});
		}
		oTechData.resourcePaths = aResults;

		//add theme paths
		var mLibraries = this._oCore.getLoadedLibraries();
		aResults = [];
		for (var n in mLibraries) {
			var sPath = this._oCore._getThemePath(n, this._oCore.oConfiguration.theme);
			aResults.push({
				theme : this._oCore.oConfiguration.theme,
				library: n,
				relativePath: sPath,
				absolutePath: URI(sPath).absoluteTo(document.location.origin + document.location.pathname).toString()
			});
		}
		oTechData.themePaths = aResults;

		//add SAPUI5 version object
		try {
			oTechData.sapUi5Version = {
				version: sap.ui.getVersionInfo(),
				path: sap.ui.resource("", "sap-ui-version.json")
			};
		} catch (ex) {
			oTechData.sapUi5Version = null;
		}

		return oTechData;
	};

	return DataCollector;
}, true);

}; // end of sap/ui/support/supportRules/report/DataCollector.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.report.IssueRenderer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Renders issues
 */
jQuery.sap.declare('sap.ui.support.supportRules.report.IssueRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/report/IssueRenderer",['jquery.sap.global'], function(jQuery) {
	'use strict';

	var _OPARenderingInitialized = false;

	function getEscapedString(value) {
		if (value) {
			if (jQuery.isArray(value)) {
				return jQuery.sap.escapeHTML(value.join(', '));
			} else {
				return jQuery.sap.escapeHTML(value);
			}
		} else {
			return '';
		}
	}

	function renderGroup(groupName, ruleGroup, groupId, groupNumber) {
		var content = '';
		var container = '';
		var ruleNumber = 1;
		var totalIssues = 0;

		for (var group in ruleGroup) {
			var issues = ruleGroup[group];
			totalIssues += issues.length;
			var issue = issues[0]; // Get the first issue from this rule group and add all common information.
			container += '<tr id="' + groupId + '_rule_' + ruleNumber + '" >';
			container += '<td>';
			container += '<div class="expandable-control collapsed-content" data-expandableElement="' + groupId + '_rule_' + ruleNumber + '_content">';
			container += '<div class="expandable-title"> ' + ruleNumber + '. ' + getEscapedString(issue.name) + ' <span class="rule-issue-number">(' + issues.length + ' issues)</span></div></div>';
			container += '<div id="' + groupId + '_rule_' + ruleNumber + '_content">';
			container += '<div><span class="sapUiSupportLabel">Description: </span>' + getEscapedString(issue.description) + '</div>';
			container += '<div><span class="sapUiSupportLabel">Resolution: </span>' + getEscapedString(issue.resolution) + '</div>';
			container += '<div>';
			if (issue.resolutionUrls) {
				for (var k = 0; k < issue.resolutionUrls.length; k++) {
					container += '<div><a href="' + getEscapedString(issue.resolutionUrls[k].href) + '" target="_blank">' + getEscapedString(issue.resolutionUrls[k].text) + '</a></div>';
				}
			}
			container += '</div>';
			container += '<table class="sapUiTable"><tr><th></th><th>Element Id</th><th>Class</th><th>Status</th><th>Details</th></tr>';
			for (var i = 0; i < issues.length; i++) {
				container += '<tr class="filterable" data-severity="' + getEscapedString(issues[i].severity) + '"><td>' + (i + 1) + '</td><td>' + getEscapedString(issues[i].context.id) + '</td>';
				container += '<td>' + getEscapedString(issues[i].context.className) + '</td>';
				container += '<td class="' + getEscapedString(issues[i].severity) + '">' + getEscapedString(issues[i].severity) + '</td>';
				container += '<td>' + getEscapedString(issues[i].details) + '</td></tr>';
			}
			container += '</table>';
			container += '</div></td>';
			container += '<td>' + getEscapedString(issue.categories) + '</td>';
			container += '<td>' + getEscapedString(issue.audiences) + '</td>';
			container += '</tr>';

			ruleNumber++;
		}

		// Make the first group expanded.
		var expandedClass = 'collapsed-content';
		if (groupNumber === 1) {
			expandedClass = 'expanded-content';
		}

		content += '<tr>';
		content += '<td colspan="100" class="expandable-control ' + expandedClass + '" data-expandableElement="' + groupId + '" data-groupName="' + groupName + '" data-groupNumber="' + groupNumber + '">';
		content += '<span class="sapUiSupportLabel expandable-title"> ' + groupNumber + '. ' + groupName + ' (' + (ruleNumber - 1) + ' rules, ' + totalIssues + ' issues)</span>';
		content += '</td></tr><tbody id="' + groupId + '">';
		content += container;
		content += '</tbody>';

		return content;
	}

	function getIssues(groups) {
		var content = '';
		var groupNumber = 1;

		if (!groups) {
			return content;
		}

		try {
			content += '<table class="sapUiTable"><tr><th>Title</th><th>Categories</th><th>Audiences</th></tr>';

			for (var group in groups) {
				content += renderGroup(group, groups[group], 'group' + groupNumber, groupNumber);
				groupNumber++;
			}

			content += '</table>';
		} catch (ex) {
			jQuery.sap.log.warning('There was a problem extracting issues info.');
			content = '';
		}

		return content;
	}

	function getSeverityFilter(severity, count, isActive) {
		if (!count) {
			return '';
		}

		var activeClass = isActive ? 'filter-active' : '';
		return '<div data-severity="' + severity + '" class="filter ' + activeClass + ' ' + severity + '">' + severity + '(' + count + ')</div>' + ' | ';
	}

	function getSeverityFilters(groups) {
		var content = '',
			severities = {},
			severityProperty,
			i,
			total = 0,
			issues = [],
			rules = {},
			rule = {},
			group = {};

		if (!groups) {
			return content;
		}

		try {
			for (group in groups) {
				rules = groups[group];
				for (rule in rules) {
					issues = rules[rule];
					for (i = 0; i < issues.length; i++) {
						severityProperty = issues[i].severity;
						if (severities[severityProperty]) {
							severities[severityProperty]++;
						} else {
							severities[severityProperty] = 1;
						}
						total++;
					}
				}
			}
			content += getSeverityFilter('Total', total, true);
			content += getSeverityFilter('High', severities['High'], false);
			content += getSeverityFilter('Medium', severities['Medium'], false);
			content += getSeverityFilter('Low', severities['Low'], false);
		} catch (ex) {
			jQuery.sap.log.warning('There was a problem creating severity filters.');
			content = '';
		}

		return content;
	}

	// Public functions

	/**
	 * Creates an html string containing the issues.
	 * @param {Object} issues - the issues in viewmodel format
	 * @param {Boolean} enableFiltering - if true renders the severity filters
	 * @returns {String}
	 */
	function render(issues, enableFiltering) {
		var content = '';

		if (enableFiltering) {
			content += '<div class="filters">' + getSeverityFilters(issues) + '<div>\n';
		}

		content += '<div>' + getIssues(issues) + '</div>';

		return '<div>' + content + '</div>';
	}

	/* eslint-disable no-undef */
	/**
	 * Creates an html string containing the issues and appends it to the OPA html page
	 * @param {Object} issues - the issues in viewmodel format
	 * @returns {String}
	 */
	function renderIssuesForOPA(issues) {
		if (!jQuery("#qunit") || !issues) {
			return;
		}

		// TODO: Add rendered issues to a buffer and render all of them at the same time at the end of the OPA test.
		var element = jQuery(this.render(issues));
		jQuery("#qunit").append(element);

		if (!_OPARenderingInitialized) {
			var styles = [
				jQuery.sap.getResourcePath('sap/ui/support/supportRules/report/resources/styles.css'),
				jQuery.sap.getResourcePath('sap/ui/support/supportRules/report/resources/collapseExpand.css'),
				jQuery.sap.getResourcePath('sap/ui/support/supportRules/report/resources/filter.css')
			];
			var collapseExpandUrl = jQuery.sap.getResourcePath('sap/ui/support/supportRules/report/resources/collapseExpand.js');
			var filterUrl = jQuery.sap.getResourcePath('sap/ui/support/supportRules/report/resources/filter.js');

			jQuery.each(styles, function (index, value) {
				jQuery('<link>').appendTo('head').attr({ type: 'text/css', rel: 'stylesheet', href: value });
			});
			jQuery.getScript(collapseExpandUrl, function () {
				window.sapUiSupportReport.collapseExpand.init();
			});
			jQuery.getScript(filterUrl, function () {
				window.sapUiSupportReport.filter.init();
			});
			_OPARenderingInitialized = true;
		} else {
			window.sapUiSupportReport.collapseExpand.init();
			window.sapUiSupportReport.filter.init();
		}
	}
	/* eslint-enable no-undef */

	return {
		render: render,
		renderIssuesForOPA: renderIssuesForOPA
	};
}, true);
}; // end of sap/ui/support/supportRules/report/IssueRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.report.ReportProvider') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Creates a report from data.
 */
jQuery.sap.declare('sap.ui.support.supportRules.report.ReportProvider'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.thirdparty.handlebars'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/report/ReportProvider",['jquery.sap.global', 'sap/ui/thirdparty/handlebars', 'sap/ui/support/supportRules/report/Archiver',
	'sap/ui/support/supportRules/report/IssueRenderer'], function(jQuery, Handlebars, Archiver, IssueRenderer) {
	'use strict';

	// Private fields
	var resourcesBaseUrl = jQuery.sap.getResourcePath('sap/ui/support/supportRules/report/resources');
	var resources = [
		{ url: resourcesBaseUrl + '/ReportTemplate.html', type: 'template' },
		{ url: resourcesBaseUrl + '/styles.css', type: 'css' },
		{ url: resourcesBaseUrl + '/filter.css', type: 'css' },
		{ url: resourcesBaseUrl + '/collapseExpand.css', type: 'css' },
		{ url: resourcesBaseUrl + '/filter.js', type: 'js' },
		{ url: resourcesBaseUrl + '/collapseExpand.js', type: 'js' }
	];

	/*
	 * Functions taken from core.support.plugins.TechInfo.js
	 */
	var techInfoRenderer = {
		line: function (buffer, right, border, label, content) {
			buffer.push("<tr><td ", right ? "align='right' " : "", "valign='top'>", "<label class='sapUiSupportLabel'>", jQuery.sap.escapeHTML(label || ""), "</label></td><td",
					border ? " class='sapUiSupportTechInfoBorder'" : "", ">");
			var ctnt = content;
			if (jQuery.isFunction(content)) {
				ctnt = content(buffer);
			}
			buffer.push(jQuery.sap.escapeHTML(ctnt || ""));
			buffer.push("</td></tr>");
		},
		multiline: function (buffer, right, border, label, content){
			var that = this;
			that.line(buffer, right, border, label, function(buffer){
				buffer.push("<table border='0' cellspacing='0' cellpadding='3'>");
				jQuery.each(content, function(i,v){
					var val = "";
					if (v) {
						if (typeof (v) === "string" || typeof (v) === "string" || typeof (v) === "boolean") {
							val = v;
						} else if ((jQuery.isArray(v) || jQuery.isPlainObject(v)) && window.JSON) {
							val = window.JSON.stringify(v);
						}
					}
					that.line(buffer, false, false, i, "" + val);
				});
				buffer.push("</table>");
			});
		}
	};

	function getResource(resource) {
		return jQuery.ajax({
			type: 'GET',
			url: resource.url,
			dataType: 'text'
		}).then(function (text) {
			return { content: text, type: resource.type };
		});
	}

	function getResources() {
		var deferreds = [];
		for (var i = 0; i < resources.length; i++) {
			deferreds.push(getResource(resources[i]));
		}
		return jQuery.when.apply(jQuery, deferreds);
	}

	/*
	 * Modified version of the function onsapUiSupportTechInfoData from core.support.plugins.TechInfo.js
	 */
	function getTechnicalInformation(technicalInfo) {
		var content = '';

		if (!technicalInfo) {
			return new Handlebars.SafeString(content);
		}

		try {
			technicalInfo.modules.sort();
			var html = ["<div class='sapUiSupportToolbar'>",
						"<div><div class='sapUiSupportTechInfoCntnt'>",
						"<table border='0' cellpadding='3'>"];
			techInfoRenderer.line(html, true, true, "SAPUI5 Version", function(buffer){
				var sapUI5Version = technicalInfo.sapUi5Version;
				if (sapUI5Version && sapUI5Version.version) {
					var oVersionInfo = sapUI5Version.version;
					var sVersion = jQuery.sap.escapeHTML(oVersionInfo.version || "");
					buffer.push(sVersion, " (built at ", jQuery.sap.escapeHTML(oVersionInfo.buildTimestamp || ""), ", last change ", jQuery.sap.escapeHTML(oVersionInfo.scmRevision || ""), ")");
				} else {
					buffer.push("not available");
				}
			});
			techInfoRenderer.line(html, true, true, "Core Version", function(buffer){
				return technicalInfo.version + " (built at " + technicalInfo.build + ", last change " + technicalInfo.change + ")";
			});
			techInfoRenderer.line(html, true, true, "Loaded jQuery Version", function(buffer){
				return technicalInfo.jquery;
			});
			techInfoRenderer.line(html, true, true, "User Agent", function(buffer){
				return technicalInfo.useragent + (technicalInfo.docmode ? ", Document Mode '" + technicalInfo.docmode + "'" : "");
			});
			techInfoRenderer.line(html, true, true, "Application", technicalInfo.appurl);
			techInfoRenderer.multiline(html, true, true, "Configuration (bootstrap)", technicalInfo.bootconfig);
			techInfoRenderer.multiline(html, true, true, "Configuration (computed)", technicalInfo.config);
			if (!jQuery.isEmptyObject(technicalInfo.libraries)) {
				techInfoRenderer.multiline(html, true, true, "Libraries", technicalInfo.libraries);
			}
			techInfoRenderer.multiline(html, true, true, "Loaded Libraries", technicalInfo.loadedLibraries);
			techInfoRenderer.line(html, true, true, "Loaded Modules", function(buffer){
				jQuery.each(technicalInfo.modules, function(i,v){
					if (v.indexOf("sap.ui.core.support") < 0) {
						buffer.push("<span>", jQuery.sap.escapeHTML(v || ""), "</span>");
						if (i < technicalInfo.modules.length - 1) {
							buffer.push(", ");
						}
					}
				});
			});
			techInfoRenderer.multiline(html, true, true, "URI Parameters", technicalInfo.uriparams);

			html.push("</table></div>");
			content = html.join('');
		} catch (ex) {
			jQuery.sap.log.warning('There was a problem extracting technical info.');
		}

		return new Handlebars.SafeString(content);
	}

	function getComponentPart(value) {
		var result = '<td>';
		if (value) {
			result += jQuery.sap.escapeHTML(value);
		}
		result += '</td>';
		return result;
	}

	function getAppInfo(appInfo) {
		var content = '';

		if (!appInfo) {
			return new Handlebars.SafeString(content);
		}

		content += '<table class="sapUiTable"><tr><th>Component ID</th><th>Type</th><th>Title</th><th>Subtitle</th><th>Application version</th><th>Description</th><th>BCP Component</th></tr>';

		try {
			for (var i = 0; i < appInfo.length; i++) {
				var component = appInfo[i];
				content += '<tr>';
				content += getComponentPart(component.id);
				content += getComponentPart(component.type);
				content += getComponentPart(component.title);
				content += getComponentPart(component.subTitle);
				if (component.applicationVersion) {
					content += getComponentPart(component.applicationVersion.version);
				} else {
					content += '<td></td>';
				}
				content += getComponentPart(component.description);
				content += getComponentPart(component.ach);
				content += '</tr>';
			}

			content += '</table>';
		} catch (ex) {
			jQuery.sap.log.warning('There was a problem extracting app info.');
			content = '';
		}

		return new Handlebars.SafeString(content);
	}

	function getGlobalScope(displaySettings) {
		var content = '';
		content += '<div><span class="sapUiSupportLabel">' + displaySettings.displayName + '</span>';
		content += '<span> (' + displaySettings.description + ')</span></div>';
		return content;
	}

	function getSubtreeScope(parentId, displaySettings) {
		var content = '';
		content += '<div><span class="sapUiSupportLabel">' + displaySettings.displayName + ' with id:</span> ' + parentId;
		content += '<span> (' + displaySettings.description + ')</span></div>';
		return content;
	}

	function getComponentsScope(components, displaySettings) {
		var content = '';
		// Make components collapsable if they are too many.
		if (components.length > 5) {
			content += '<div class="expandable-control collapsed-content" data-expandableElement="execution-scope-components">';
			content += '<span class="expandable-title"><span class="sapUiSupportLabel">' + displaySettings.displayName + '</span>';
			content += '<span> (' + displaySettings.description + ')</span></span></div>';
		} else {
			content += '<div><span class="sapUiSupportLabel">' + displaySettings.displayName + '</span>';
			content += '<span> (' + displaySettings.description + ')</span></div>';
		}

		content += '<ol id="execution-scope-components" class="top-margin-xsmall">';
		for (var i = 0; i < components.length; i++) {
			content += '<li>' + components[i] + '</li>';
		}
		content += '</ol>';

		return content;
	}

	function getScope(scope) {
		var content = '';

		try {
			var scopeType = scope.executionScope._getType();
			var scopeDisplaySettings = scope.scopeDisplaySettings.executionScopes[scopeType];
			var scopeDisplayTitle = scope.scopeDisplaySettings.executionScopeTitle;
			content += '<div class="sapUiSupportLabel">' + scopeDisplayTitle + ': </div>';

			switch (scopeType) {
				case 'global':
					content += getGlobalScope(scopeDisplaySettings);
					break;
				case 'subtree':
					content += getSubtreeScope(scope.executionScope._getContext().parentId, scopeDisplaySettings);
					break;
				case 'components':
					content += getComponentsScope(scope.executionScope._getContext().components, scopeDisplaySettings);
					break;
			}
		} catch (ex) {
			jQuery.sap.log.warning('There was a problem extracting scope info.');
			content = '';
		}

		return new Handlebars.SafeString(content);
	}

	function getRules(groups) {
		var content = '';

		if (!groups) {
			return new Handlebars.SafeString(content);
		}

		try {
			var groupNumber = 1;

			content += '<table class="sapUiTable"><tbody><tr><th>Name</th><th>Description</th></tr></tbody>';

			for (var group in groups) {
				var rules = groups[group];

				// Make the first group expanded.
				var expandedClass = 'collapsed-content';
				if (groupNumber === 1) {
					expandedClass = 'expanded-content';
				}

				var groupIssueCountElement = groups[group].selected ? ' (' + groups[group].issueCount + ' issues)' : '';
				var checkedGroup = '<span class="checked" style="' + (groups[group].selected ? '' : 'visibility: hidden;') + '"> &#10004; </span>';
				content += '<tbody><tr><td colspan="100" ';
				content += 'class="expandable-control ' + expandedClass + '" data-expandableElement="section-selected-rules-group' + groupNumber + '">' + checkedGroup;
				content += '<span class="sapUiSupportLabel expandable-title"> ' + group + groupIssueCountElement + '</span>';
				content += '</td></tr></tbody>';
				var rulesTable = '';

				for (var rule in rules) {
					var issueCountElement = rules[rule].selected ? ' (' + rules[rule].issueCount + ' issues)' : '';
					var checked = '<span class="checked" style="' + (rules[rule].selected ? '' : 'visibility: hidden;') + '"> &#10004; </span>';
					rulesTable += '<tr><td>' + checked + rules[rule].title + issueCountElement + '</td><td>' + rules[rule].description + '</td></tr>';
				}

				content += '<tbody id="section-selected-rules-group' + groupNumber + '">' + rulesTable + '</tbody>';
				groupNumber++;
			}

			content += '</table>';
		} catch (ex) {
			jQuery.sap.log.warning('There was a problem extracting selected rules info.');
			content = '';
		}

		return new Handlebars.SafeString(content);
	}

	function getResourcesHtml(resources, type) {
		var content = '';

		if (type !== 'script' && type !== 'style') {
			return content;
		}

		for (var i = 0; i < resources.length; i++) {
			switch (type) {
				case 'script': content += '<script>' + resources[i] + '</script>\n'; break;
				case 'style': content += '<style type="text/css">' + resources[i] + '</style>\n'; break;
			}
		}

		return new Handlebars.SafeString(content);
	}

	Handlebars.registerHelper('getTechnicalInformation', function (technicalInfo) {
		return getTechnicalInformation(technicalInfo);
	});
	Handlebars.registerHelper('getRules', function (rules) {
		return getRules(rules);
	});
	Handlebars.registerHelper('getIssues', function (issues) {
		return new Handlebars.SafeString(IssueRenderer.render(issues, true));
	});
	Handlebars.registerHelper('getAppInfo', function (appInfo) {
		return getAppInfo(appInfo);
	});
	Handlebars.registerHelper('getScope', function (scope) {
		return getScope(scope);
	});
	Handlebars.registerHelper('getScripts', function (scripts) {
		return getResourcesHtml(scripts, 'script');
	});
	Handlebars.registerHelper('getStyles', function (styles) {
		return getResourcesHtml(styles, 'style');
	});

	// Public functions

	/**
	 * Creates an html string containing the whole report.
	 * @param {Object} oData - the data required to create a report
	 * @returns {String}
	 */
	function getReportHtml(oData) {
		return getResources().then(function () {
			var styles = [],
				scripts = [],
				html = '',
				i,
				template = {},
				reportContext = {};

			for (i = 0; i < arguments.length; i++) {
				switch (arguments[i].type) {
					case 'template': html = arguments[i].content; break;
					case 'css': styles.push(arguments[i].content); break;
					case 'js': scripts.push(arguments[i].content); break;
				}
			}

			template = Handlebars.compile(html);

			reportContext = {
				technicalInfo: oData.technical,
				issues: oData.issues,
				appInfo: oData.application,
				rules: oData.rules,
				metadata: {
					title: oData.name + ' Analysis Results',
					title_TechnicalInfo: 'Technical Information',
					title_Issues: 'Issues',
					title_AppInfo: 'Application Information',
					title_SelectedRules: 'Available and (<span class="checked">&#10004;</span>) Executed Rules',
					timestamp: new Date(),
					scope: oData.scope,
					analysisDuration: oData.analysisDuration,
					analysisDurationTitle: oData.analysisDurationTitle,
					styles: styles,
					scripts: scripts
				}
			};

			return template(reportContext);
		});
	}

	/**
	 * Creates a zip file containing the report.html, appInfo.json, technicalInfo.json, issues.json.
	 * @param {Object} oData - the data required to create a report
	 */
	function downloadReportZip(oData) {
		this.getReportHtml(oData).done(function (html) {
			var report = '<!DOCTYPE HTML><html><head><title>Report</title></head><body><div id="sap-report-content">' + html + '</div></body></html>';
			var issues = { 'issues': oData.issues };
			var appInfos = { 'appInfos': oData.application };
			var technicalInfo = { 'technicalInfo': oData.technical };
			var archiver = new Archiver();
			archiver.add('technicalInfo.json', technicalInfo, 'json');
			archiver.add('issues.json', issues, 'json');
			archiver.add('appInfos.json', appInfos, 'json');
			archiver.add('report.html', report);
			archiver.download("SupportAssistantReport");
			archiver.clear();
		});
	}

	/**
	 * Opens a report in a new window.
	 * @param {Object} oData - the data required to create a report
	 */
	function openReport(oData) {
		// Create a hidden anchor. Open window outside of the promise otherwise browsers blocks the window.open.
		var content = '';
		var a = jQuery('<a style="display: none;"/>');
		a.on('click', function () {
			var reportWindow = window.open('', '_blank');
			jQuery(reportWindow.document).ready(function () {
				// Sometimes document.write overwrites the document html and sometimes it appends to it so we need a wrapper div.
				if (reportWindow.document.getElementById('sap-report-content')) {
					reportWindow.document.getElementById('sap-report-content').innerHtml = content;
				} else {
					reportWindow.document.write('<div id="sap-report-content">' + content + '</div>');
				}
				reportWindow.document.title = 'Report';
			});
		});
		jQuery('body').append(a);

		this.getReportHtml(oData).then(function (html) {
			content = html;
			a[0].click();
			a.remove();
		});
	}

	return {
		getReportHtml: getReportHtml,
		downloadReportZip: downloadReportZip,
		openReport: openReport
	};
}, true);

}; // end of sap/ui/support/supportRules/report/ReportProvider.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.IFrameController') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.IFrameController'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ui/IFrameController",[
	"jquery.sap.global",
	"sap/ui/base/ManagedObject",
	"sap/ui/support/supportRules/WindowCommunicationBus",
	"sap/ui/support/supportRules/WCBChannels",
	"sap/ui/support/supportRules/Constants"
],
function (jQuery, ManagedObject, CommunicationBus, channelNames, constants) {
	"use strict";

	var oIFrameController = null;

	var sFrameOrigin;

	var sFrameIdentifier;

	var sFrameUrl;

	function computeFrameOrigin(sUrl) {
		var frameURI = new window.URI(sUrl);
		var sOrigin = ( frameURI.protocol() || window.location.protocol.replace(':', '') ) +
						'://' +
						( frameURI.host() || window.location.host );

		return sOrigin;
	}

	function generateIdentifier() {
		return '' + +new Date();
	}

	function openFrame(sUrl) {
		var toolFrame = document.createElement("IFRAME");
		var style = toolFrame.style;

		toolFrame.id = "sap-ui-supportToolsFrame";
		toolFrame.src = sUrl;

		style.width = "100%";
		style.height = "50%";
		style.position = "absolute";
		style.left = "0";
		style.bottom = "0";
		style.border = "none";
		style.zIndex = "1001";
		// style.transition = "width 300ms ease-in-out, height 300ms ease-in-out";
		style.boxShadow = "1px -10px 42px -4px #888";

		document.body.appendChild(toolFrame);

		// This interval is needed because sometimes an app is placed at
		// the body element which involves moving everything already there
		// into a new, hidden DIV element
		setInterval(function () {
			if (toolFrame.parentNode.nodeName !== "BODY") {
				document.body.appendChild(toolFrame);
				window.communicationWindows.supportTool = toolFrame.contentWindow;
			}
		}, 1000);

		window.communicationWindows.supportTool = toolFrame.contentWindow;
	}

	function openWindow(sUrl) {
		window.communicationWindows.supportTool = window.open(
			sUrl,
			"sapUiSupportTool",
			"width=1024,height=400,status=no,toolbar=no,menubar=no,resizable=yes,location=no,directories=no,scrollbars=no"
		);

		window.communicationWindows.supportTool.window.onload = function () {
			window.communicationWindows.supportTool.document.title = constants.SUPPORT_ASSISTANT_NAME;
		};
	}

	var IFrameController = ManagedObject.extend("sap.ui.support.IFrameController", {
		constructor: function () {
			if (!oIFrameController) {
				ManagedObject.apply(this, arguments);
			} else {
				jQuery.sap.log.warning("Only one support tool allowed");
				return oIFrameController;
			}
		}
	});

	IFrameController.prototype._setCommunicationSubscriptions = function () {
		CommunicationBus.subscribe(channelNames.ENSURE_FRAME_OPENED, function () {
			if (document.getElementById("sap-ui-supportToolsFrame").style.height === "28px") {
				this.resizeFrame(true);
				this.toggleHide();
			}
		}, this);

		CommunicationBus.subscribe(channelNames.RESIZE_FRAME, function (aParams) {
			oIFrameController.resizeFrame(aParams.bigger);
		});
	};

	IFrameController.prototype.injectFrame = function (supportModeConfig) {
		sFrameIdentifier = generateIdentifier();

		sFrameUrl = jQuery.sap.getModulePath("sap.ui.support.supportRules.ui",
			"/overlay.html?sap-ui-xx-formfactor=compact&sap-ui-xx-support-origin=" +
			window.location.protocol + "//" + window.location.host + "&" +
			"sap-ui-xx-frame-identifier=" + sFrameIdentifier);

		sFrameOrigin = computeFrameOrigin(sFrameUrl);

		window.communicationWindows = window.communicationWindows || {};

		if (supportModeConfig.indexOf("window") > -1) {
			openWindow(sFrameUrl);
		} else {
			openFrame(sFrameUrl);
			this._setCommunicationSubscriptions();
		}
	};

	IFrameController.prototype.resizeFrame = function (bigger) {
		var toolFrameStyle = document.getElementById("sap-ui-supportToolsFrame").style;

		if (bigger) {
			if (toolFrameStyle.height === "50%") {
				toolFrameStyle.height = "100%";
			} else if (toolFrameStyle.height === "28px") {
				toolFrameStyle.height = "50%";
			}
		} else {
			if (toolFrameStyle.height === "100%") {
				toolFrameStyle.height = "50%";
			} else if (toolFrameStyle.height === "50%") {
				toolFrameStyle.height = "28px";
			}
		}
	};

	/**
	 * Toggles frame state between hidden and shown
	 * Default is shown
	 *
	 * @param hidden {boolean} should the frame hide or not
	 */
	IFrameController.prototype.toggleHide = function (hidden) {
		var toolFrameStyle = document.getElementById("sap-ui-supportToolsFrame").style;

		if (hidden) {
			this._originalSize = {
				width: toolFrameStyle.width,
				height: toolFrameStyle.height
			};

			toolFrameStyle.width = "170px";
			toolFrameStyle.height = "28px";
		} else {
			if (this._originalSize) {
				toolFrameStyle.width = this._originalSize.width;
				toolFrameStyle.height = this._originalSize.height;
				this._originalSize = null;
			}
		}
	};

	IFrameController.prototype._stop = function () {
		this._oCssLink.parentNode.removeChild(this._oCssLink);
		this._oDomRef.parentNode.removeChild(this._oCssLink);
		this._oCore = null;
	};

	IFrameController.prototype.getFrameOrigin = function () {
		return sFrameOrigin;
	};

	IFrameController.prototype.getFrameIdentifier = function () {
		return sFrameIdentifier;
	};

	IFrameController.prototype.getFrameUrl = function () {
		return sFrameUrl;
	};

	oIFrameController = new IFrameController();

	return oIFrameController;

}, true);

}; // end of sap/ui/support/supportRules/ui/IFrameController.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.models.SharedModel') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.models.SharedModel'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ui/models/SharedModel",[
	"sap/ui/model/json/JSONModel"
], function (JSONModel) {
	"use strict";

	var executionScopes = {
			global: {
				key: "global",
				displayName: "Global",
				description: "The Rules will be / are executed on the complete application with all loaded elements and components, including all previously loaded pages"
			},
			subtree: {
				key: "subtree",
				displayName: "Sub-tree",
				description: "The Rules will be / are executed on the specified sub-tree root element, including all child elements (aggregated sub-elements)"
			},
			components: {
				key: "components",
				displayName: "Component(s)",
				description: "The Rules will be / are executed on the selected components from the list of currently loaded components (or fragments)"
			}
		};

	var model = new JSONModel({
		selectedRule: null,
		libraries: null,
		selectedIssue: null,
		issues: [],
		progress: 0.1,
		showProgressIndicator: false,
		coreStateChanged: true,
		analyzePressed: false,
		selectedRulePreviewKey: "ruleProperties",
		selectedRuleCreateKey: "ruleProperties",
		selectedRuleEditKey: "ruleProperties",
		selectedSetPreviewKey: "availableRules",
		newRule: {},
		newRuleStringified: "",
		updateRuleStringified: "",
		subtreeExecutionContextId: "",
		availableComponents: [],
		audiences: sap.ui.support.Audiences,
		categories: sap.ui.support.Categories,
		severities: sap.ui.support.Severity,
		audiencesFilter : ["All"].concat(Object.keys(sap.ui.support.Audiences)),
		categoriesFilter : ["All"].concat(Object.keys(sap.ui.support.Categories)),
		severitiesFilter : ["All"].concat(Object.keys(sap.ui.support.Severity)),
		newEmptyRule: {
			libName: "",
			id: "",
			categories: [sap.ui.support.Categories.Other],
			audiences: [sap.ui.support.Audiences.Internal],
			title: "",
			description: "",
			resolution: "",
			resolutionurls: [],
			check: "function(oIssueManager, oCoreFacade, oScope) {\n\t/* \n\t oIssueManager - allows you to add new issues with the addIssue() method \n\t oCoreFacade - gives you access to state of the core: getMetadata(), getUIAreas(), getComponents(), getModels() \n\t oScope - retrieves elements in the scope with these methods: getElements(), getElementsByClassName(className), getLoggedObjects(type) \n\t*/ \n}",
			selected: true
		},
		editRule: null,
		tempLink: {
			href: "",
			text: ""
		},
		selectedRuleStringify: "",
		analyzeContext: executionScopes.global,
		executionScopes: executionScopes,
		executionScopeTitle: "Execution scope",
		lastAnalysisElapsedTime: "",
		analysisDurationTitle: "Last analysis duration",
		costants: "",
		executionScopeComponents: [],
		persistingSettings: false,
		loadingAdditionalRuleSets: false,
		analyzedFinish: false,
		selectedRules: true
	});

	return model;
});

}; // end of sap/ui/support/supportRules/ui/models/SharedModel.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.util.StringAnalyzer') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Contains String analyzing functionality such as calculating the levenshtein distance between 2 strings
 */
jQuery.sap.declare('sap.ui.support.supportRules.util.StringAnalyzer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
sap.ui.define("sap/ui/support/supportRules/util/StringAnalyzer",[],
	function () {
	"use strict";

	var StringAnalyzer = {
		/**
		 *
		 * @param sWordA
		 * @param sWordB
		 * @returns levenshtein distance number
		 */
		calculateLevenshteinDistance: function(sWordA, sWordB) {

			var iLengthA = sWordA.length;
			var iLengthB = sWordB.length;

			if (iLengthA === 0) {
				return iLengthB;
			}
			if (iLengthB === 0) {
				return iLengthA;
			}

			// fill the x axis of the matrix
			var aMatrix = new Array(iLengthB + 1);
			var iIndexFirstRowX;
			for (iIndexFirstRowX = 0; iIndexFirstRowX <= iLengthB; iIndexFirstRowX++) {
				aMatrix[iIndexFirstRowX] = new Array(iLengthA + 1);
				aMatrix[iIndexFirstRowX][0] = iIndexFirstRowX;
			}

			// fill the y axis of the matrix
			var iIndexFirstRowY;
			for (iIndexFirstRowY = 0; iIndexFirstRowY <= iLengthA; iIndexFirstRowY++) {
				aMatrix[0][iIndexFirstRowY] = iIndexFirstRowY;
			}

			// calculate the levenshtein distance row by row
			var iLevenshteinDistance = 0;
			var iIndexRowsX;
			var iIndexRowY;
			for (iIndexRowsX = 1; iIndexRowsX <= iLengthB; iIndexRowsX++) {
				for (iIndexRowY = 1; iIndexRowY <= iLengthA; iIndexRowY++) {
					var iDeletionCost = aMatrix[iIndexRowsX - 1][iIndexRowY] + 1;
					var iInsertionCost = aMatrix[iIndexRowsX][iIndexRowY - 1] + 1;
					var iSubstitutionCost = aMatrix[iIndexRowsX - 1][iIndexRowY - 1];
					if (sWordA[iIndexRowY] !== sWordB[iIndexRowsX]) {
						iSubstitutionCost += 1;
					}
					iLevenshteinDistance = Math.min(iDeletionCost, iInsertionCost, iSubstitutionCost);
					aMatrix[iIndexRowsX][iIndexRowY] = iLevenshteinDistance;
				}
			}
			//the last calculated distance is the shortest distance
			return iLevenshteinDistance;
		}
	};

	return StringAnalyzer;
}, false);

}; // end of sap/ui/support/supportRules/util/StringAnalyzer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TableHelper.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Helper functionality for table, list and tree controls for the Support Tool infrastructure.
 */
jQuery.sap.declare('sap.ui.table.TableHelper.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/table/TableHelper.support",["jquery.sap.global", "sap/ui/support/library"],
	function(jQuery, SupportLib) {
	"use strict";

	// shortcuts
	var Audiences = SupportLib.Audiences, // Control, Internal, Application
		Categories = SupportLib.Categories, // Accessibility, Performance, Memory, ...
		Severity = SupportLib.Severity;	// Hint, Warning, Error


	var TableSupportHelper = {

		DOCU_REF : "https://sapui5.hana.ondemand.com/",

		DEFAULT_RULE_DEF : {
			audience: [Audiences.Application],
			categories: [Categories.Other],
			enabled: true,
			minversion: "1.38",
			maxversion: "-",
			title: "",
			description: "",
			resolution: "",
			resolutionurls: [],
			check: function(oIssueManager, oCoreFacade, oScope) {}
		},

		/**
		 * Normalizes the given rule definition.
		 * The rule definition object can/must have the following parameters:
		 *
		 * 		id:				ID of the rule, MANDATORY
		 * 		audience:		[Audiences.Application, ...] - Choose one or several, Default "Application"
		 * 		categories:		[Categories.Accessibility, ...] - choose one or several, Default "Other" (TBD)
		 * 		enabled:		true/false - Default true
		 * 		minversion:		the minimum version required to run the rule - Default "1.38"
		 * 		maxversion:		the maximum version required to run the rule - Default "-"
		 * 		title:			user friendly title, MANDATORY
		 * 		description:	detailed description, MANDATORY
		 * 		resolution:		proposed resolution steps, MANDATORY
		 * 		resolutionurls: [{text: "Text to be displayed", href: "URL to public(!) docu"}] - list of useful URLs, Default []
		 * 		check:			function(oIssueManager, oCoreFacade, oScope) { ... } - Check function code, MANDATORY
		 *
		 * @param {object} The rule definition
		 * @returns The normalized rule definition
		 */
		normalizeRule : function(oRuleDef) {
			return jQuery.extend({}, TableSupportHelper.DEFAULT_RULE_DEF, oRuleDef);
		},

		/**
		 * Normalizes the given rule definition and adds it to the given Ruleset.
		 *
		 * @see #normalizeRule
		 *
		 * @param {object} The rule definition
		 * @param {sap.ui.support.supportRules.RuleSet} The ruleset
		 */
		addRuleToRuleset : function(oRuleDef, oRuleset) {
			oRuleDef = jQuery.extend({}, TableSupportHelper.DEFAULT_RULE_DEF, oRuleDef);
			var sResult = oRuleset.addRule(oRuleDef);
			if (sResult != "success") {
				jQuery.sap.log.warning("Support Rule '" + oRuleDef.id + "' for library sap.m not applied: " + sResult);
			}
		},

		/**
		 * Creates a documentation link description in the format as requested by the parameter resolutionurls of a rule.
		 * @param {string} sText 		The text of the docu link.
		 * @param {string} sRefSuffix 	The url suffix. It gets automatically prefixed by TableSupportHelper.DOCU_REF.
		 * @returns Documentation link description
		 */
		createDocuRef : function(sText, sRefSuffix) {
			return {
				text: sText,
				href: TableSupportHelper.DOCU_REF + sRefSuffix
			};
		},

		/**
		 * Adds an issue with the given text, severity and context to the given issue manager.
		 * @param {sap.ui.support.IssueManager} oIssueManager The issue manager
		 * @param {string} sText 						The text of the issue.
		 * @param {sap.ui.support.Severity} [sSeverity] The severity of the issue, if nothing is given Warning is used.
		 * @param {string} [sControlId] 				The id of the control the issue is related to. If nothing is given the "global" context is used.
		 */
		reportIssue : function(oIssueManager, sText, sSeverity, sControlId) {
			oIssueManager.addIssue({
				severity: sSeverity || Severity.Medium,
				details: sText,
				context: {id: sControlId || "WEBPAGE"}
			});
		},

		/**
		 * Checks whether the given object is of the given type (given in AMD module syntax)
		 * without the need of loading the types module.
		 * @param {sap.ui.base.ManagedObject} oObject The object to check
		 * @param {string} sType The type given in AMD module syntax
		 * @returns {boolean}
		 */
		isInstanceOf : function(oObject, sType) {
			if (!oObject || !sType) {
				return false;
			}
			var oType = sap.ui.require(sType);
			return !!(oType && (oObject instanceof oType));
		},

		/**
		 * Return all existing control instances of the given type.
		 * @param {object} oScope The scope as given in the rule check function.
		 * @param {boolean} bVisisbleOnly Whether all existing controls or only the ones which currently have a DOM reference should be returned.
		 * @param {string} sType The type given in AMD module syntax
		 * @returns All existing control instances
		 */
		find: function(oScope, bVisisbleOnly, sType) {
			var mElements = oScope.getElements();
			var aResult = [];
			for (var n in mElements) {
				var oElement = mElements[n];
				if (TableSupportHelper.isInstanceOf(oElement, sType)) {
					if (bVisisbleOnly && oElement.getDomRef() || !bVisisbleOnly) {
						aResult.push(oElement);
					}
				}
			}
			return aResult;
		},

		/**
		 * Iterates over the available log entries.
		 *
		 * Both parameter functions gets a log entry object passed in with the following properties:
		 * <ul>
		 *    <li>{jQuery.sap.log.Level} oLogEntry.level One of the log levels FATAL, ERROR, WARNING, INFO, DEBUG, TRACE</li>
		 *    <li>{string} oLogEntry.message     The logged message</li>
		 *    <li>{string} oLogEntry.details     The optional details for the message</li>
		 *    <li>{string} oLogEntry.component   The optional log component under which the message was logged</li>
		 *    <li>{float}  oLogEntry.timestamp   The timestamp when the log entry was written</li>
		 *    <li>{object} oLogEntry.supportInfo The optional support info object</li>
		 * </ul>
		 *
		 * @param {function} fnFilter Filter function to filter out irrelevant log entries.
		 *                            If the function returns <code>true</code> the log entry is kept, otherwise it's filtered out.
		 * @param {string} fnCheck Check function to check the remaining log entries.
		 *                         If the function returns <code>true</code> the checking procedure is stopped,
		 *                         otherwise the next entry is passed for checking.
		 */
		checkLogEntries : function(fnFilter, fnCheck) {
			var aLog = jQuery.sap.log.getLogEntries(); //oScope.getLoggedObjects(); /*getLoggedObjects returns only log entries with supportinfo*/
			var oLogEntry;
			for (var i = 0; i < aLog.length; i++) {
				oLogEntry = aLog[i];
				if (fnFilter(oLogEntry)) {
					if (fnCheck(oLogEntry)) {
						return;
					}
				}
			}
		}

	};



	return TableSupportHelper;

}, true);
}; // end of sap/ui/table/TableHelper.support.js
if ( !jQuery.sap.isDeclared('sap.m.Button.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Defines support rules of the Button control of sap.m library.
 */
jQuery.sap.declare('sap.m.Button.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/Button.support",["jquery.sap.global", "sap/ui/support/library"],
	function(jQuery, SupportLib) {
	"use strict";

	// shortcuts
	var Categories = SupportLib.Categories, // Accessibility, Performance, Memory, ...
		Severity = SupportLib.Severity,	// Hint, Warning, Error
		Audiences = SupportLib.Audiences; // Control, Internal, Application


	var aRules = [];

	function createRule(oRuleDef) {
		aRules.push(oRuleDef);
	}


	//**********************************************************
	// Rule Definitions
	//**********************************************************

	/**
	 *Checks, if a button consisting of only an icon has a tooltip (design guideline)
	 */
	createRule({
		id : "onlyIconButtonNeedsTooltip",
		audiences: [Audiences.Control],
		categories: [Categories.Usability],
		enabled: true,
		minversion: "1.28",
		title: "Button: Consists of only an icon, needs a tooltip",
		description: "A button without text needs a tooltip, so that the user knows what the button does",
		resolution: "Add a value to the tooltip property of the button",
		resolutionurls: [{
			text: "SAP Fiori Design Guidelines: Button",
			href: "https://experience.sap.com/fiori-design-web/button/#guidelines"
		}],
		check: function (oIssueManager, oCoreFacade, oScope) {
			oScope.getElementsByClassName("sap.m.Button")
				.forEach(function(oElement) {
					if (!jQuery.isEmptyObject(oElement.getProperty("icon"))
						&& jQuery.isEmptyObject(oElement.getProperty("text"))
						&& jQuery.isEmptyObject(oElement.getProperty("tooltip"))) {

						var sElementId = oElement.getId(),
							sElementName = oElement.getMetadata().getElementName();

						oIssueManager.addIssue({
							severity: Severity.Medium,
							details: "Button '" + sElementName + "' (" + sElementId + ") consists of only an icon but has no tooltip",
							context: {
								id: sElementId
							}
						});
					}
				});
		}
	});

	return {
		addRulesToRuleset: function(oRuleset) {
			jQuery.each(aRules, function(idx, oRuleDef){
				oRuleset.addRule(oRuleDef);
			});
		}
	};

}, true);

}; // end of sap/m/Button.support.js
if ( !jQuery.sap.isDeclared('sap.m.Dialog.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Defines support rules of the List, Table and Tree controls of sap.m library.
 */
jQuery.sap.declare('sap.m.Dialog.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/Dialog.support",["jquery.sap.global", "sap/ui/support/library"],
	function(jQuery, SupportLib) {
	"use strict";

	// shortcuts
	var Categories = SupportLib.Categories, // Accessibility, Performance, Memory, ...
		Severity = SupportLib.Severity,	// Hint, Warning, Error
		Audiences = SupportLib.Audiences; // Control, Internal, Application

	var aRules = [];

	function createRule(oRuleDef) {
		aRules.push(oRuleDef);
	}

	//**********************************************************
	// Rule Definitions
	//**********************************************************

	createRule({
		id : "dialogarialabelledby",
		audiences: [Audiences.Control],
		categories: [Categories.Accessibility],
		enabled: true,
		minversion: "1.28",
		title: "Dialog accessibility",
		description: "Dialogs with content should have ariaLabelledBy association set",
		resolution: "Use ariaLabelledBy association so that dialog content is read out",
		resolutionurls: [{
			text: "Set ariaLabelledBy",
			href: "https://uacp2.hana.ondemand.com/viewer/DRAFT/SAPUI5_Internal/5709e73d51f2401a9a5a89d8f5479132.html"
		}],
		check: function (issueManager, oCoreFacade, oScope) {
			oScope.getElementsByClassName("sap.m.Dialog")
				.forEach(function(oElement) {

				var ariaLabelledBy = oElement.getAssociation("ariaLabelledBy"),
					sDetails,
					sElementTitle = oElement.getTitle(),
					sElementId = oElement.getId(),
					sElementName = oElement.getMetadata().getElementName();

				if ((oElement.getContent() && oElement.getContent().length > 0)	// dialog has content
						&& (!ariaLabelledBy || ariaLabelledBy.length == 0)) {	// but has no ariaLabelledBy set
					if (sElementTitle) {
						sDetails = "'" + sElementTitle + "' " + sElementName + " (" + sElementId + ") has content but ariaLabelledBy association is not set. Set the association so that dialog's content is read out.";
					} else {
						sDetails = sElementName + " (" + sElementId + ") has content but ariaLabelledBy association is not set. Set the association so that dialog's content is read out.";
					}

					issueManager.addIssue({
						severity: Severity.Medium,
						details: sDetails,
						context: {
							id: oElement.getId()
						}
					});
				}
			});
		}
	});

	return {
		addRulesToRuleset: function(oRuleset) {
			jQuery.each(aRules, function(idx, oRuleDef){
				oRuleset.addRule(oRuleDef);
			});
		}
	};

}, true);
}; // end of sap/m/Dialog.support.js
if ( !jQuery.sap.isDeclared('sap.m.Input.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Defines support rules of the List, Table and Tree controls of sap.m library.
 */
jQuery.sap.declare('sap.m.Input.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/Input.support",["jquery.sap.global", "sap/ui/support/library"],
	function(jQuery, SupportLib) {
	"use strict";

	// shortcuts
	var Categories = SupportLib.Categories, // Accessibility, Performance, Memory, ...
		Severity = SupportLib.Severity,	// Hint, Warning, Error
		Audiences = SupportLib.Audiences; // Control, Internal, Application


	var aRules = [];

	function createRule(oRuleDef) {
		aRules.push(oRuleDef);
	}


	//**********************************************************
	// Rule Definitions
	//**********************************************************

	/**
	 * Input field needs to have a label association
	 */
	createRule({
		id: "inputNeedsLabel",
		audiences: [Audiences.Control],
		categories: [Categories.Usability],
		enabled: true,
		minversion: "1.28",
		title: "Input field: Missing label",
		description:"An input field needs a label",
		resolution: "Define a sap.m.Label for the input field in the xml view and set the labelFor property to this input field Id.",
		resolutionurls: [{
			text: "SAP Fiori Design Guidelines: Input field",
			href:"https://experience.sap.com/fiori-design-web/input-field/#guidelines"
		}],
		check: function (issueManager, oCoreFacade, oScope) {

			var aInputIds = oScope.getElementsByClassName("sap.m.Input")
				.map(function(oInput) {
					return oInput.getId();
				});

			oScope.getElementsByClassName("sap.m.Label")
				.forEach(function (oLabel){
					var sLabelFor = oLabel.getLabelFor();
					if (aInputIds.includes(sLabelFor)) {
						var iIndex = aInputIds.indexOf(sLabelFor);
						aInputIds.splice(iIndex, 1);
					}
				});

			if (aInputIds.length > 0) {
				aInputIds.forEach(function(sInputId) {
					issueManager.addIssue({
						severity: Severity.Medium,
						details: "Input field" + " (" + sInputId + ") is missing a label.",
						context: {
							id: sInputId
						}
					});
				});
			}
		}
	});

	return {
		addRulesToRuleset: function(oRuleset) {
			jQuery.each(aRules, function(idx, oRuleDef){
				oRuleset.addRule(oRuleDef);
			});
		}
	};

}, true);

}; // end of sap/m/Input.support.js
if ( !jQuery.sap.isDeclared('sap.ui.core.App.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Defines Application related support rules.
 */
jQuery.sap.declare('sap.ui.core.App.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/core/App.support",["jquery.sap.global", "sap/ui/support/library"],
	function(jQuery, SupportLib) {
	"use strict";

	// shortcuts
	var Categories = SupportLib.Categories; // Accessibility, Performance, Memory, ...
	var Severity = SupportLib.Severity; // Hint, Warning, Error
	var Audiences = SupportLib.Audiences; // Control, Internal, Application

	return {
		/**
		 *
		 * @param oRuleSet
		 * @param {object} oCfg configuration object with key 'aObsoleteFunctionNames' containing an array with obsolete
		 * function names.
		 */
		addRulesToRuleSet: function(oRuleSet, oCfg) {
			oCfg = oCfg || {};
			//**********************************************************
			// Rule Definitions
			//**********************************************************
			/**
			 * Check controller code for obsolete function calls.
			 *
			 * Uses oCfg with the obsolete function name
			 * e.g. <code>{aObsoleteFunctionNames:["jQuery.sap.sjax"]}</code>
			 */
			oRuleSet.addRule({
				id: "controllerSyncCodeCheck",
				audiences: [Audiences.Internal],
				categories: [Categories.Consistency],
				enabled: true,
				minversion: "1.32",
				title: "Synchronous calls in controller code",
				description: "Synchronous calls are deprecated within the Google Chrome browser and block the UI.",
				resolution: "Use asynchronous XHR calls instead",
				resolutionurls: [{
					text: 'Documentation: Loading a Module',
					href: 'https://sapui5.hana.ondemand.com/#docs/guide/d12024e38385472a89c1ad204e1edb48.html'
				}],
				check: function(oIssueManager, oCoreFacade, oScope) {

					// content which should be avoided (sync calls)
					var aObsoleteFunctionNames = oCfg.aObsoleteFunctionNames || [];

					// get the controllers and the associated viewId
					var aElements = oScope.getElementsByClassName(sap.ui.core.mvc.View);
					var aControllersWithViewId = [];
					aElements.forEach(function(oElement) {
						if (oElement.getController) {
							var oController = oElement.getController();
							if (oController) {
								aControllersWithViewId.push({
									controller: oController,
									viewId: oElement.getId()
								});
							}
						}
					});

					// checks the given module's functions code for invalidContent
					// returns an array which contains the functions with invalid content
					var fnGatherInvalidControllerFunctions = function(oController, viewId, aInvalidContent, fnProcessInvalidFunction) {
						var _aInvalidControllerFunctions = [];
						Object.keys(oController).forEach(function(sProtoKey) {
							var sFnContent = oController[sProtoKey].toString().replace(/(\r\n|\n|\r)/gm,"");

							aInvalidContent.forEach(function(sInvalidContent) {
								if (sFnContent.indexOf(sInvalidContent) > 0) {
									fnProcessInvalidFunction(oController.getMetadata().getName(), sProtoKey, sInvalidContent, viewId);
								}
							});


						});
						return _aInvalidControllerFunctions;
					};

					var mViewIdToControllerFunctions = {};

					// check the code for each controller and their prototype
					// and stores it grouped by view id in <code>mViewIdToControllerFunctions</code>
					aControllersWithViewId.forEach(function(oControllerWithViewId) {

						var fnMapUsingViewIds = function(sControllerName, sFnName, sInvalidContent, sViewId) {
							mViewIdToControllerFunctions[sViewId] = mViewIdToControllerFunctions[sViewId] || [];
							mViewIdToControllerFunctions[sViewId].push({
								controllerName: sControllerName,
								functionName: sFnName,
								invalidContent: sInvalidContent
							});
						};

						// check each controller and their prototypes
						var oController = oControllerWithViewId.controller;
						while (oController) {
							fnGatherInvalidControllerFunctions(oController, oControllerWithViewId.viewId, aObsoleteFunctionNames, fnMapUsingViewIds);
							var oControllerPrototype = Object.getPrototypeOf(oController);
							// sanity check to avoid potential endless loops and limit recursion only up to the Controller itself
							if (oController === oControllerPrototype || oControllerPrototype === sap.ui.core.mvc.Controller.prototype) {
								break;
							}
							oController = oControllerPrototype;
						}
					});


					// add issues for each invalid controller function
					Object.keys(mViewIdToControllerFunctions).forEach(function(sViewId) {
						var aControllerFunctions = mViewIdToControllerFunctions[sViewId];
						oIssueManager.addIssue({
							severity: Severity.Medium,
							details: aControllerFunctions.map(function(oController) {
								return "\nSynchronous call " + oController.invalidContent + " found in " + oController.controllerName + "#" + oController.functionName;
							}),
							context: {
								id: sViewId
							}
						});

					});


				}
			});

		}
	};

}, true);
}; // end of sap/ui/core/App.support.js
if ( !jQuery.sap.isDeclared('sap.ui.core.Config.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Defines support rules for the app configuration.
 */
jQuery.sap.declare('sap.ui.core.Config.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/core/Config.support",["jquery.sap.global", "sap/ui/support/library"],
	function(jQuery, SupportLib) {
	"use strict";

	// shortcuts
	var Categories = SupportLib.Categories; // Accessibility, Performance, Memory, ...
	var Severity = SupportLib.Severity; // Hint, Warning, Error
	var Audiences = SupportLib.Audiences; // Control, Internal, Application

	return {
		addRulesToRuleSet: function(oRuleSet) {

			//**********************************************************
			// Rule Definitions
			//**********************************************************
			/**
			 * Checks whether the preload configuration was set correctly to async
			 */
			oRuleSet.addRule({
				id : "preloadAsyncCheck",
				audiences: [Audiences.Control, Audiences.Internal],
				categories: [Categories.Performance],
				enabled: true,
				minversion: "1.32",
				maxversion: "-",
				title: "Preload Configuration",
				description: "Checks whether the preload configuration was set correctly to async",
				resolution: "Add \"data-sap-ui-preload=\"async\"\" to script tag that includes \"sap-ui-core.js\"",
				resolutionurls: [{
					text: "Performance: Speed Up Your App",
					href: "https://sapui5.hana.ondemand.com/#docs/guide/408b40efed3c416681e1bd8cdd8910d4.html"
				}],
				check: function(oIssueManager, oCoreFacade) {
					if (sap.ui.getCore().getConfiguration().getPreload() !== "async") {
						oIssueManager.addIssue({
							severity: Severity.High,
							details: "None",
							context: {
								id: "WEBPAGE"
							}
						});
					}
				}
			});

			/**
			 * Checks whether all requests for SAPUI5 repository resources contain a cache buster token
			 * It checks the requests under ICF node "/sap/bc/ui5_ui5/"
			 */
			oRuleSet.addRule({
				id: "cacheBusterToken",
				audiences : [Audiences.Application],
				categories : [Categories.Performance],
				enabled : true,
				minversion : "1.28",
				title : "Cache Buster Token",
				description : "Checks whether the application uses cache buster tokens in its requests for static resources from SAPUI5 repositories.",
				resolution : "Change the application.\n"
				+ "Note: Not using cache buster tokens negatively impacts performance.\n"
				+ "For more information, see the SAPUI5 developer guide.",
				resolutionurls : [{
					text : "SAPUI5 developer guide: ",
					href : "https://sapui5.hana.ondemand.com/#docs/guide/4cfe7eff3001447a9d4b0abeaba95166.html"
				}],
				check : function (oIssueManager, oCoreFacade, oScope) {
					var sUI5ICFNode = "/sap/bc/ui5_ui5/";
					var aAppNames = [];
					var sAppName;
					var aRequests = jQuery.sap.measure.getRequestTimings();
					for (var i = 0; i < aRequests.length; i++) {
						var sUrl = aRequests[i].name;
						//We limit the check to requests under ICF node "/sap/bc/ui5_ui5/", only these are relevant here
						if (sUrl.indexOf( sUI5ICFNode ) > 0) {
							if (!sUrl.match(/\/~[A-Z0-9]*~/g)) {
								if (sUrl.indexOf("/sap-ui-cachebuster/sap-ui-core.js") < 0 && sUrl.indexOf("sap-ui-cachebuster-info.json") < 0) {
									var aSegments = sUrl.split( sUI5ICFNode );
									aSegments = aSegments[1].split("/");
									sAppName = aSegments[0] === "sap" ? aSegments[1] : "/" + aSegments[0] + "/" + aSegments[1];
									if (aAppNames.indexOf(sAppName) < 0){
										aAppNames.push(sAppName);
									}
								}
							}
						}
					}
					for (var i = 0 ; i < aAppNames.length ; i++){
						sAppName = aAppNames[i];
						var sICFPath = sUI5ICFNode + ( sAppName.charAt(0) === "/" ? sAppName.substr(1) : "sap/" + sAppName ) ;
						oIssueManager.addIssue({
							severity: Severity.Medium,
							details: "Application '" + sAppName + "' is lacking cache buster tokens in some or all of its requests.\n " +
							"For more information about the URLs affected under application '" + sAppName + "' please check the network trace for URLs starting with '" + sICFPath + "'",
							context: {
								id: "WEBPAGE"
							}
						});
					}
				}
			});

		}
	};

}, true);

}; // end of sap/ui/core/Config.support.js
if ( !jQuery.sap.isDeclared('sap.ui.core.Misc.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Defines miscellaneous support rules.
 */
jQuery.sap.declare('sap.ui.core.Misc.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/core/Misc.support",["jquery.sap.global", "sap/ui/support/library"],
	function(jQuery, SupportLib) {
	"use strict";

	// shortcuts
	var Categories = SupportLib.Categories; // Accessibility, Performance, Memory, ...
	var Severity = SupportLib.Severity; // Hint, Warning, Error
	var Audiences = SupportLib.Audiences; // Control, Internal, Application

	return {
		addRulesToRuleSet: function(oRuleSet) {

			//**********************************************************
			// Rule Definitions
			//**********************************************************

			/**
			 * checks the error logs
			 */
			oRuleSet.addRule({
				id: "errorLogs",
				audiences: [Audiences.Control, Audiences.Internal],
				categories: [Categories.Performance],
				enabled: true,
				minversion: "1.32",
				title: "Error logs",
				description: "Checks for the amount of error logs in the console",
				resolution: "Error logs should be fixed",
				resolutionurls: [],
				check: function(oIssueManager, oCoreFacade) {
					var count = 0,
						message = "";

					var log = jQuery.sap.log.getLog();
					log.forEach(function(logEntry) {
						if (logEntry.level === jQuery.sap.log.Level.ERROR) {
							count++;
							if (count <= 20) {
								message += "- " + logEntry.message + "\n";
							}
						}
					});

					oIssueManager.addIssue({
						severity: Severity.Low,
						details: "Total error logs: " + count + "\n" + message,
						context: {
							id: "WEBPAGE"
						}
					});
				}
			});
		}
	};

}, true);

}; // end of sap/ui/core/Misc.support.js
if ( !jQuery.sap.isDeclared('sap.ui.core.Model.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Defines support rules related to the model.
 */
jQuery.sap.declare('sap.ui.core.Model.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.ListBinding'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.odata.ODataMetadata'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.CompositeBinding'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.PropertyBinding'); // unlisted dependency retained
sap.ui.define("sap/ui/core/Model.support",["jquery.sap.global",
		"sap/ui/support/library",
		"sap/ui/support/supportRules/util/StringAnalyzer",
		"sap/ui/model/ListBinding",
		"sap/ui/model/json/JSONModel",
		"sap/ui/model/odata/ODataMetadata",
		"sap/ui/model/CompositeBinding",
		"sap/ui/model/PropertyBinding"],
	function(
		jQuery,
		SupportLib,
		StringAnalyzer,
		ListBinding,
		JSONModel,
		ODataMetadata,
		CompositeBinding,
		PropertyBinding) {
	"use strict";

	// shortcuts
	var Categories = SupportLib.Categories; // Accessibility, Performance, Memory, ...
	var Severity = SupportLib.Severity; // Hint, Warning, Error
	var Audiences = SupportLib.Audiences; // Control, Internal, Application

	return {
		addRulesToRuleSet: function(oRuleSet) {

			//**********************************************************
			// Rule Definitions
			//**********************************************************
			/**
			 * Checks whether there are property bindings for models where the model is undefined
			 */
			oRuleSet.addRule({
				id: "unresolvedPropertyBindings",
				audiences: [Audiences.Control, Audiences.Application],
				categories: [Categories.Bindings],
				enabled: true,
				minversion: "1.32",
				title: "Unresolved Property Bindings",
				description: "Unresolved bindings might be caused by typos in their path",
				resolution: "Check the binding path for typos",
				resolutionurls: [
					{
						href: "https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.model.Context.html",
						text: "Context class"
					},
					{
						href: "https://sapui5.hana.ondemand.com/#docs/guide/e5310932a71f42daa41f3a6143efca9c.html",
						text: "Data binding"
					},
					{
						href: "https://sapui5.hana.ondemand.com/#docs/guide/97830de2d7314e93b5c1ee3878a17be9.html",
						text: "Aggregation binding with templates"
					},
					{
						href: "https://sapui5.hana.ondemand.com/#docs/guide/6c7c5c266b534e7ea9a28f861dc515f5.html",
						text: "Element binding"
					}
				],
				check: function(oIssueManager, oCoreFacade, oScope) {
					var mElements = oScope.getElements();
					for (var n in mElements) {
						var oElement = mElements[n],
							mBindingInfos = oElement.mBindingInfos;
						for (var m in mBindingInfos) {
							var oBinding = mBindingInfos[m].binding;
							if (oBinding) {
								if (!(oBinding instanceof CompositeBinding) && oBinding instanceof PropertyBinding && oBinding.getModel()) {
									if (oBinding.getValue() === undefined) {
										oIssueManager.addIssue({
											severity: Severity.Low,
											details: "Element " + oElement.getId() + " has unresolved bindings.",
											context: {
												id: oElement.getId()
											}
										});
									}
								}
							}
						}
					}
				}
			});

			function _fnFindBestMatch(aValues, sBindingPath) {
				var iJsonModelMin = -1;
				var sJsonModelBestMatch = false;
				aValues.forEach(function(sKey) {
					var iCurrDest = StringAnalyzer.calculateLevenshteinDistance(sBindingPath, sKey);
					if (iJsonModelMin === -1 || iCurrDest < iJsonModelMin) {
						iJsonModelMin = iCurrDest;
						sJsonModelBestMatch = sKey;
					}
				});
				return sJsonModelBestMatch;
			}

			/**
			 * Checks whether there are bindings for models where the model is available but a binding has no result
			 * It checks the path structure and checks for typos
			 */
			oRuleSet.addRule({
				id: "bindingPathSyntaxValidation",
				audiences: [Audiences.Control, Audiences.Application],
				categories: [Categories.Bindings],
				enabled: true,
				minversion: "1.32",
				title: "Model: Unresolved binding path",
				description: "The binding path used in the model could not be resolved",
				resolution: "Check the binding path for typos",
				resolutionurls: [
					{
						href: "https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.model.Context.html",
						text: "API Reference: Context"
					},
					{
						href: "https://sapui5.hana.ondemand.com/#docs/guide/e5310932a71f42daa41f3a6143efca9c.html",
						text: "Documentation: Data Binding"
					},
					{
						href: "https://sapui5.hana.ondemand.com/#docs/guide/97830de2d7314e93b5c1ee3878a17be9.html",
						text: "Data Binding Tutorial - Step 12: Aggregation Binding Using Templates"
					},
					{
						href: "https://sapui5.hana.ondemand.com/#docs/guide/6c7c5c266b534e7ea9a28f861dc515f5.html",
						text: "Data Binding Tutorial - Step 13: Element Binding"
					}
				],
				check: function(oIssueManager, oCoreFacade, oScope) {
					var mElements = oScope.getElements();
					Object.keys(mElements).forEach(function(sElement) {

						var oElement = mElements[sElement],
							mBindingInfos = oElement.mBindingInfos;

						Object.keys(mBindingInfos).forEach(function(sBindingInfo) {

							var oBinding = mBindingInfos[sBindingInfo].binding;
							if (oBinding && !(oBinding instanceof CompositeBinding) && oBinding.getModel && oBinding.getModel()) {
								var oModel = oBinding.getModel();
								if ((oBinding.getValue && oBinding.getValue() === undefined)
									|| (oBinding instanceof ListBinding && oBinding.getLength() === 0)) {
									var sJsonModelBestMatch = false;

									if (oModel instanceof JSONModel) {
										var oJsonModelResult = oModel.getObject(oBinding.getPath());
										if (!oJsonModelResult) {
											var oData = oModel.getData();
											sJsonModelBestMatch = _fnFindBestMatch(Object.keys(oData), oBinding.getPath());
										}
									} else if (oModel.oMetadata && oModel.oMetadata instanceof ODataMetadata) {
										//try to look it up
										var result = oModel.oMetadata._getEntityTypeByPath(oBinding.getPath());
										if (!result) {
											var aValues = [];
											oModel.oMetadata.getServiceMetadata().dataServices.schema.forEach(function(mShema) {

												if (mShema.entityContainer) {
													mShema.entityContainer.forEach(function(mContainer) {
														if (mContainer.entitySet) {
															mContainer.entitySet.forEach(function(mEntitySet) {
																if (mEntitySet.name) {
																	aValues.push(mEntitySet.name);
																}
															});
														}
													});
												}

											});
											sJsonModelBestMatch = _fnFindBestMatch(aValues, oBinding.getPath());
										}
									}

									if (sJsonModelBestMatch) {
										oIssueManager.addIssue({
											severity: Severity.High,
											details: "Element " + oElement.getId() + " " + oBinding.getPath() + " has unresolved bindings.",
											resolution: "You could try '" + sJsonModelBestMatch + "' instead",
											context: {
												id: oElement.getId()
											}
										});
									}

								} else if (oBinding.getValue && oBinding.getValue() === oBinding.getPath()) {
									oIssueManager.addIssue({
										severity: Severity.Low,
										details: "Element " + oElement.getId() + " " + oBinding.getPath() + " has the same value as the path. Potential Error.",
										context: {
											id: oElement.getId()
										}
									});
								}
							}
						});
					});
				}
			});
		}
	};

}, true);

}; // end of sap/ui/core/Model.support.js
if ( !jQuery.sap.isDeclared('sap.ui.core.View.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Defines support rules related to the view.
 */
jQuery.sap.declare('sap.ui.core.View.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/core/View.support",["jquery.sap.global", "sap/ui/support/library"],
	function(jQuery, SupportLib) {
	"use strict";

	// shortcuts
	var Categories = SupportLib.Categories; // Accessibility, Performance, Memory, ...
	var Severity = SupportLib.Severity; // Hint, Warning, Error
	var Audiences = SupportLib.Audiences; // Control, Internal, Application

	return {
		/**
		 *
		 * @param oRuleSet
		 * @param {object} oCfg configuration object with key 'iNumberOfControlsThreshold' containing an the maximum
		 * number of controls.
		 */
		addRulesToRuleSet: function(oRuleSet, oCfg) {
			oCfg = oCfg || {};
			//**********************************************************
			// Rule Definitions
			//**********************************************************


			/**
			 * Checks for wrongly configured view namespace
			 */
			oRuleSet.addRule({
				id: "XMLViewWrongNamespace",
				audiences: [Audiences.Application],
				categories: [Categories.Functionality],
				enabled: true,
				title: "XML View is not configured with namespace 'sap.ui.core.mvc'",
				description: "For consistency and proper resource loading, the root node of an XML view must be configured with the namespace 'mvc'",
				resolution: "Define the XML view as '<core:View ...>' and configure the XML namepspace as 'xmlns:mvc=\"sap.ui.core.mvc\"'",
				resolutionurls: [{
					text: "Documentation: Namespaces in XML Views",
					href: "https://sapui5.hana.ondemand.com/#docs/guide/2421a2c9fa574b2e937461b5313671f0.html"
				}],
				check: function(oIssueManager, oCoreFacade, oScope) {
					var aXMLViews = oScope.getElements().filter(function (oControl) { return oControl.getMetadata().getName() === "sap.ui.core.mvc.XMLView"; });
					aXMLViews.forEach(function (oXMLView) {
						if (oXMLView._xContent.namespaceURI !== "sap.ui.core.mvc") {
							var sViewName = oXMLView.getViewName().split("\.").pop();
							oIssueManager.addIssue({
								severity: Severity.Medium,
								details: "The view '" + sViewName + "' (" + oXMLView.getId() + ") is configured with namespace '" + oXMLView._xContent.namespaceURI + "' instead of 'sap.ui.core.mvc'",
								context: {
									id: oXMLView.getId()
								}
							});
						}
					});
				}
			});


			/**
			 * Checks if a default namespaces is set in an XML view
			 */
			oRuleSet.addRule({
				id: "XMLViewDefaultNamespace",
				audiences: [Audiences.Control, Audiences.Application],
				categories: [Categories.Performance],
				enabled: true,
				title: "Default namespace missing in XML view",
				description: "If the default namespace is missing, the code is less readable and parsing performance may be slow",
				resolution: "Set the namespace of the control library that holds most of the controls you use as default namespace (e.g. xmlns=\"sap.m\")",
				resolutionurls: [{
					text: "Documentation: Namespaces in XML Views",
					href: "https://sapui5.hana.ondemand.com/#docs/guide/2421a2c9fa574b2e937461b5313671f0.html"
				}],
				check: function(oIssueManager, oCoreFacade, oScope) {
					var aXMLViews = oScope.getElements().filter(function (oControl) { return oControl.getMetadata().getName() === "sap.ui.core.mvc.XMLView"; });

					aXMLViews.forEach(function (oXMLView) {
						if (!oXMLView._xContent.attributes.getNamedItem("xmlns")) {
							var sViewName = oXMLView.getViewName().split("\.").pop();
							oIssueManager.addIssue({
								severity: Severity.Low,
								details: "The view '" + sViewName + "' (" + oXMLView.getId() + ") does not contain a default namespace",
								context: {
									id: oXMLView.getId()
								}
							});
						}
					});
				}
			});


			/**
			 * Checks for unused namespaces inside an XML view
			 */
			oRuleSet.addRule({
				id: "XMLViewUnusedNamespaces",
				audiences: [Audiences.Control, Audiences.Application],
				categories: [Categories.Performance],
				enabled: true,
				title: "Unused namespaces in XML view",
				description: "Namespaces that are declared but not used have a negative impact on performance (and may confuse readers of the code)",
				resolution: "Remove the unused namespaces from the view definition",
				resolutionurls: [{
					text: "Documentation: Namespaces in XML Views",
					href: "https://sapui5.hana.ondemand.com/#docs/guide/2421a2c9fa574b2e937461b5313671f0.html"
				}],
				check: function(oIssueManager, oCoreFacade, oScope) {
					var aXMLViews = oScope.getElements().filter(function (oControl) { return oControl.getMetadata().getName() === "sap.ui.core.mvc.XMLView"; });

					aXMLViews.forEach(function (oXMLView) {
						for (var i = 0; i < oXMLView._xContent.attributes.length; i++) {
							var sName = oXMLView._xContent.attributes.item(i).name;
							var sLocalName = oXMLView._xContent.attributes.item(i).localName;
							var sFullName = oXMLView._xContent.attributes.item(i).value;

							// check all explicit namespaces except for the injected support namespace
							if (sName.match("xmlns:") && sLocalName !== "xmlns:support") {
								for (var j = 0; j < oXMLView._xContent.children.length; j++) {
									var sContent = oXMLView._xContent.children[j].outerHTML;

									// check if there is a reference of this namespace inside the view
									if (!sContent.match("<" + sLocalName + ":")) {
										var sViewName = oXMLView.getViewName().split("\.").pop();
										oIssueManager.addIssue({
											severity: Severity.Medium,
											details: "View '" + sViewName + "' (" + oXMLView.getId() + ") contains an unused XML namespace '" + sLocalName + "' referencing library '" + sFullName + "'",
											context: {
												id: oXMLView.getId()
											}
										});
									}
								}
							}
						}
					});
				}
			});

		}
	};

}, true);

}; // end of sap/ui/core/View.support.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.Form.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Defines support rules of the Form controls of sap.ui.layout library.
 */
jQuery.sap.declare('sap.ui.layout.Form.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/layout/Form.support",["jquery.sap.global", "sap/ui/support/library"],
	function(jQuery, SupportLib) {
	"use strict";

	// shortcuts
	var Categories = SupportLib.Categories; // Accessibility, Performance, Memory, ...
	var Severity = SupportLib.Severity; // Hint, Warning, Error
	var Audiences = SupportLib.Audiences; // Control, Internal, Application

	var aRules = [];

	function createRule(oRuleDef) {
		aRules.push(oRuleDef);
	}

	//**********************************************************
	// Rule Definitions
	//**********************************************************

	/* eslint-disable no-lonely-if */

	function isSimpleForm(oControl){
		if (oControl) {
			var oMetadata = oControl.getMetadata();
			if (oMetadata.getName() == "sap.ui.layout.form.SimpleForm") {
				return true;
			}
		}

		return false;
	}

	function isSmartForm(oControl){
		if (oControl) {
			var oMetadata = oControl.getMetadata();
			if (oMetadata.getName() == "sap.ui.comp.smartform.SmartForm" ||
					(oMetadata.getName() == "sap.m.Panel" && oControl.getParent().getMetadata().getName() == "sap.ui.comp.smartform.SmartForm")) {
				return true;
			}
		}

		return false;
	}

	createRule({
		id: "formResponsiveLayout",
		audiences: [Audiences.Control],
		categories: [Categories.Functionality],
		enabled: true,
		minversion: "1.48",
		title: "Form: Use of ResponsiveLayout",
		description: "ResponsiveLayout should not be used any longer because of UX requirements",
		resolution: "Use the ResponsiveGridLayout instead",
		resolutionurls: [{
				text: "API Reference: Form",
				href:"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.Form.html"
			},
			{
				text: "API Reference: SimpleForm",
				href:"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.SimpleForm.html"
			},
			{
				text: "API Reference: ResponsiveGridLayout",
				href:"https://sapui5.hana.ondemand.com/#docs/api/symbols/sap.ui.layout.form.ResponsiveGridLayout.html"
			}],
		check: function (oIssueManager, oCoreFacade, oScope) {
			oScope.getElementsByClassName("sap.ui.layout.form.Form")
			.forEach(function(oForm) {
				var oLayout = oForm.getLayout();
				if (oLayout && oLayout.getMetadata().getName() == "sap.ui.layout.form.ResponsiveLayout") {
					var oParent = oForm.getParent();
					var sId;
					var sName = "Form";

					if (isSimpleForm(oParent)) {
						sId = oParent.getId();
						sName = "SimpleForm";
					} else if (isSmartForm(oParent)) {
						// for SmartForm don't check on Form level
						return;
					} else {
						sId = oForm.getId();
					}

					oIssueManager.addIssue({
						severity: Severity.Medium,
						details: sName + " " + sId + " uses ResponsiveLayout.",
						context: {
							id: sId
						}
					});
				}
			});
		}
	});

	return {
		addRulesToRuleset: function(oRuleset) {
			jQuery.each(aRules, function(idx, oRuleDef){
				oRuleset.addRule(oRuleDef);
			});
		}
	};

}, true);
}; // end of sap/ui/layout/Form.support.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.RuleSet') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.RuleSet'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/RuleSet",[
	"jquery.sap.global",
	"sap/ui/support/supportRules/Storage",
	"sap/ui/support/supportRules/Constants"
],
function (jQuery, storage, constants) {
	"use strict";

	var mRuleSets = {};

	var RuleSet = function (oSettings) {
		oSettings = oSettings || {};
		if (!oSettings.name) {
			jQuery.sap.log.error("Please provide a name for the RuleSet.");
		}

		if (mRuleSets[oSettings.name]) {
			return mRuleSets[oSettings.name];
		}
		this._oSettings = oSettings;
		this._mRules = {};
		mRuleSets[oSettings.name] = this;
	};

	RuleSet.clearAllRuleSets = function () {
		mRuleSets = {};
	};

	RuleSet.prototype.getRules = function () {
		return this._mRules;
	};

	RuleSet.prototype.updateRule = function (oldId, newSettings) {
		var verifyResult = this._verifySettingsObject(newSettings, true);

		if (verifyResult === "success") {
			delete this._mRules[oldId];
			this._mRules[newSettings.id] = newSettings;
		}

		return verifyResult;
	};

	RuleSet.prototype._verifySettingsObject = function (oSettings, update) {
		if (!oSettings.id) {
			jQuery.sap.log.error("Support rule needs an id.");
			return "Support rule needs an unique id.";
		}

		if (!update && this._mRules[oSettings.id]) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " already exists.");
			return "Support rule with the id " + oSettings.id + " already exists.";
		}

		if (!oSettings.check) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " needs a check function.");
			return "Support rule with the id " + oSettings.id + " needs a check function.";
		}

		if (!oSettings.title) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " needs a title.");
			return "Support rule with the id " + oSettings.id + " needs a title.";
		}

		if (!oSettings.description) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " needs a description.");
			return "Support rule with the id " + oSettings.id + " needs a description.";
		}

		if (!oSettings.resolution && (!oSettings.resolutionurls || !oSettings.resolutionurls.length > 0)) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " needs either a resolution or resolutionurls or should have a ticket handler function");
			return "Support rule with the id " + oSettings.id + " needs either a resolution or resolutionurls or should have a ticket handler function";
		}

		if (!oSettings.audiences || oSettings.audiences.length === 0) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " should have an audience. Applying audience ['Control']");
			oSettings.audiences = [sap.ui.support.Audiences.Control];
		}

		if (oSettings.audiences && oSettings.audiences.forEach) {
			var wrongAudience = false,
				audName = "";
			oSettings.audiences.forEach(function (aud) {
				if (!sap.ui.support.Audiences[aud]) {
					wrongAudience = true;
					audName = aud;
				}
			});

			if (wrongAudience) {
				jQuery.sap.log.error("Audience " + audName + " does not exist. Please use the audiences from sap.ui.support.Audiences");
				return "Audience " + audName + " does not exist. Please use the audiences from sap.ui.support.Audiences";
			}
		}

		if (!oSettings.categories || oSettings.categories.length === 0) {
			jQuery.sap.log.error("Support rule with the id " + oSettings.id + " should have a category. Applying category ['Performance']");
			oSettings.categories = ["Performance"];
		}

		if (oSettings.categories && oSettings.categories.forEach) {
			var wrongCategory = false,
				catName = "";
			oSettings.categories.forEach(function (cat) {
				if (!sap.ui.support.Categories[cat]) {
					wrongCategory = true;
					catName = cat;
				}
			});

			if (wrongCategory) {
				jQuery.sap.log.error("Category " + catName + " does not exist. Please use the categories from sap.ui.support.Categories");
				return "Category " + catName + " does not exist. Please use the categories from sap.ui.support.Categories";
			}
		}

		return "success";
	};

	RuleSet.prototype.addRule = function (oSettings) {
		var sCurrentVersion = RuleSet.versionInfo ? RuleSet.versionInfo.version : '';

		var sRuleVersion = oSettings.minversion ? oSettings.minversion : '';

		// Some rules use '-' instead of ''
		if (sRuleVersion === '-') {
			sRuleVersion = '';
		}

		// Do not add a rule that is for higher version of UI5
		// because APIs might not be in place
		if (sRuleVersion && jQuery.sap.Version(sCurrentVersion).compareTo(sRuleVersion) < 0) {
			return "Rule " + oSettings.id + " should be used with a version >= " + oSettings.minversion;
		}

		var verifyResult = this._verifySettingsObject(oSettings);

		if (verifyResult === "success") {
			this._mRules[oSettings.id] = oSettings;
			oSettings.libName = this._oSettings.name;
		}

		return verifyResult;
	};

	/**
	 * Adds all previously created temporary rules to the current library rules
	 * @param {Object} data The loaded libraries' and their rules
	 * @param {Array} tempRules The previously created user temporary rules
	 */
	RuleSet.addToTempRules = function (data, tempRules) {
		if (tempRules) {
			tempRules.forEach(function (tempRule) {
				var ruleName = tempRule.id;
				data[constants.TEMP_RuleSetS_NAME].RuleSet._mRules[ruleName] = tempRule;
			});
		}
	};

	/**
	 * Stores which rules are selected to be run by the analyzer on the next check
	 * @param {Array} libraries The data for the libraries and their rules
	 */
	RuleSet.storeSelectionOfRules = function (libraries) {
		var selectedRules = extractRulesSettingsToSave(libraries);
		storage.setSelectedRules(selectedRules);
	};

	/**
	 * Loads the previous selection of the user - which rules are selected to be run by the Rule Analyzer.
	 * The method applies the settings over the current loaded rules.
	 * @param {Array} libraries The current loaded libraries and their rules
	 */
	RuleSet.loadSelectionOfRules = function (libraries) {
		var savedPreferences = storage.getSelectedRules();

		if (!savedPreferences) {
			return;
		}

		for (var index = 0; index < libraries.length; index += 1) {
			var libraryRules = libraries[index].rules;
			var libraryName = libraries[index].title;

			for (var rulesIndex = 0; rulesIndex < libraryRules.length; rulesIndex += 1) {
				//If there is a saved preference for the loaded rule apply it over the default
				if (savedPreferences[libraryName] && savedPreferences[libraryName].hasOwnProperty(libraryRules[rulesIndex].id)) {
					libraryRules[rulesIndex].selected = savedPreferences[libraryName][libraryRules[rulesIndex].id].selected;
				}
			}
		}
	};

	/**
	 * Extracts all the settings needed to be save from the libraries' rules
	 * @param {Array} libraries The libraries and rules loaded from the model
	 * @returns {Object} The extracted settings the should be persisted
	 */
	function extractRulesSettingsToSave(libraries) {
		var librarySettings = Object.create(null);
		var libraryRules;
		var librariesCount = libraries.length;
		var rulesCount;
		var libraryName;
		var ruleSettings;

		for (var libraryIndex = 0; libraryIndex < librariesCount; libraryIndex += 1) {
			libraryName = libraries[libraryIndex].title;
			librarySettings[libraryName] = Object.create(null);
			libraryRules = libraries[libraryIndex].rules;

			rulesCount = libraryRules.length;
			for (var rulesIndex = 0; rulesIndex < rulesCount; rulesIndex += 1) {
				ruleSettings = Object.create(null);
				ruleSettings.id = libraryRules[rulesIndex].id;
				ruleSettings.selected = libraryRules[rulesIndex].selected;
				librarySettings[libraryName][ruleSettings.id] = ruleSettings;
			}
		}

		return librarySettings;
	}

	return RuleSet;
}, true);

}; // end of sap/ui/support/supportRules/RuleSet.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.controllers.Analysis.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.controllers.Analysis.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
jQuery.sap.require('sap.m.Panel'); // unlisted dependency retained
jQuery.sap.require('sap.m.List'); // unlisted dependency retained
jQuery.sap.require('sap.m.ListItemBase'); // unlisted dependency retained
jQuery.sap.require('sap.m.StandardListItem'); // unlisted dependency retained
jQuery.sap.require('sap.m.InputListItem'); // unlisted dependency retained
jQuery.sap.require('sap.m.Button'); // unlisted dependency retained
jQuery.sap.require('sap.m.Toolbar'); // unlisted dependency retained
jQuery.sap.require('sap.m.ToolbarSpacer'); // unlisted dependency retained
jQuery.sap.require('sap.m.Label'); // unlisted dependency retained
jQuery.sap.require('sap.m.MessageToast'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ui/controllers/Analysis.controller",[
	"jquery.sap.global",
	"sap/ui/core/mvc/Controller",
	"sap/ui/model/json/JSONModel",
	"sap/m/Panel",
	"sap/m/List",
	"sap/m/ListItemBase",
	"sap/m/StandardListItem",
	"sap/m/InputListItem",
	"sap/m/Button",
	"sap/m/Toolbar",
	"sap/m/ToolbarSpacer",
	"sap/m/Label",
	"sap/m/MessageToast",
	"sap/ui/support/supportRules/WindowCommunicationBus",
	"sap/ui/support/supportRules/WCBChannels",
	"sap/ui/support/supportRules/ui/models/SharedModel",
	"sap/ui/support/supportRules/RuleSerializer",
	"sap/ui/support/supportRules/Constants",
	"sap/ui/support/supportRules/RuleSet",
	"sap/ui/support/supportRules/Storage"
], function ($, Controller, JSONModel, Panel, List, ListItemBase, StandardListItem, InputListItem, Button, Toolbar, ToolbarSpacer,
		Label, MessageToast, CommunicationBus, channelNames, SharedModel, RuleSerializer, constants, Ruleset, storage) {
	"use strict";


	return Controller.extend("sap.ui.support.supportRules.ui.controllers.Analysis", {
		onInit: function () {
			this.model = SharedModel;
			this.setCommunicationSubscriptions();
			this.initSettingsPopover();

			CommunicationBus.publish(channelNames.ON_INIT_ANALYSIS_CTRL);
			this.tempRulesLoaded = false;

			this.hackListItemBase();
			this.getView().setModel(this.model);
		},

		getTemporaryLib: function() {
			var libs = this.model.getProperty("/libraries");

			for (var i = 0; i < libs.length; i++) {
				if (libs[i].title == constants.TEMP_RULESETS_NAME) {
					return libs[i];
				}
			}
		},
		setCommunicationSubscriptions: function () {
			CommunicationBus.subscribe(channelNames.UPDATE_SUPPORT_RULES, this.updatesupportRules, this);

			CommunicationBus.subscribe(channelNames.VERIFY_RULE_CREATE_RESULT, function (data) {
				var result = data.result,
					newRule = RuleSerializer.deserialize(data.newRule, true),
					persistingSettings = this.model.getProperty("/persistingSettings"),
					tempLib = this.getTemporaryLib();
				if (result == "success") {
					tempLib.rules.push(newRule);
					if (persistingSettings) {
						storage.setRules(tempLib.rules);
						if (this.showRuleCreatedToast) {
							MessageToast.show('Your temporary rule "' + newRule.id + '" was persisted in the local storage');
							this.showRuleCreatedToast = false;
						}
					}

					var emptyRule = this.model.getProperty("/newEmptyRule");
					this.model.setProperty("/newRule", jQuery.extend(true, {}, emptyRule));
					this.goToRuleProperties();
					this.createRulesUI();
					this.model.setProperty("/selectedRule", newRule);
					var panel = this.getView().byId("ruleSetContainer").getContent()[0];
					panel.setExpanded(true);
				} else {
					MessageToast.show("Add rule failed because: " + result);
				}
			}, this);

			CommunicationBus.subscribe(channelNames.VERIFY_RULE_UPDATE_RESULT, function (data) {
				var result = data.result,
					updateRule = RuleSerializer.deserialize(data.updateRule, true);

				if (result === "success") {
					var ruleSource = this.model.getProperty("/editRuleSource");
					var libraries = this.model.getProperty('/libraries');
					libraries.forEach(function(lib, libIndex){
						if (lib.title === constants.TEMP_RULESETS_NAME) {
							lib.rules.forEach(function(rule, ruleIndex){
								if (rule.id === ruleSource.id) {
									lib.rules[ruleIndex] = updateRule;
									storage.setRules(lib.rules);
								}
							});
						}
					});

					this.model.checkUpdate(true);
					this.model.setProperty('/selectedRule', updateRule);

					this.goToRuleProperties();
				} else {
					MessageToast.show("Update rule failed because: " + result);
				}
			}, this);

			CommunicationBus.subscribe(channelNames.POST_AVAILABLE_LIBRARIES, function (data) {
				this.model.setProperty("/availableLibrariesSet", data.libNames);

				if (this.loadingFromLoadButton) {
					MessageToast.show("Libraries ruleset loaded");
					this.loadingFromLoadButton = false;
				}
			}, this);

			CommunicationBus.subscribe(channelNames.POST_AVAILABLE_COMPONENTS, function (data) {
				var executionScopeComponents = [],
					modelScopeComponents = this.model.getProperty("/executionScopeComponents"),
					savedComponents = storage.getSelectedScopeComponents(),
					index;

				for (var componentIndex = 0; componentIndex < data.length; componentIndex += 1) {
					executionScopeComponents.push({text: data[componentIndex]});
				}
				if (modelScopeComponents && modelScopeComponents.length > 0) {
					for (index = 0; index < executionScopeComponents.length; index++) {
						executionScopeComponents[index].selected = this.checkIfComponentIsSelected(executionScopeComponents[index], modelScopeComponents);
					}
				} else if (savedComponents && savedComponents.length > 0) {
					for (index = 0; index < executionScopeComponents.length; index++) {
						executionScopeComponents[index].selected = this.checkIfComponentIsSelected(executionScopeComponents[index], savedComponents);
					}
				}

				this.model.setProperty("/executionScopeComponents", executionScopeComponents);
			}, this);
		},
		/**
		 * Checks if given execution scope component is selected comparing against an array of settings
		 * @param {Object} component The current component object to be checked
		 * @param {Array} savedComponents The local storage settings for the checked execution scope components
		 * @returns {boolean} If the component is checked or not
		 */
		checkIfComponentIsSelected: function(component, savedComponents) {
			for (var index = 0; index < savedComponents.length; index += 1) {
				if (savedComponents[index].text == component.text && savedComponents[index].selected) {
					return true;
				}
			}
			return false;
		},

		onAnalyze: function () {
			var selectedRules = this._getSelectedRules(),
				executionContext = this._getExecutionContext();
			// if (selectedRules.length > 0) {
			CommunicationBus.publish(channelNames.ON_ANALYZE_REQUEST, {
				selectedRules: selectedRules,
				executionContext: executionContext
			});
				this.model.setProperty("/showProgressIndicator", true);

		},

		initSettingsPopover: function () {
			this._settingsPopover = sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.AnalyzeSettings", this);
			this._settingsPopover.setModel(SharedModel);
			this.getView().addDependent(this._oPopover);
		},

		_getExecutionContext: function () {
			var ctx = {
				type: this.model.getProperty("/analyzeContext/key")
			};

			// TODO: these "if"s can be consistently turned into switch with constants
			if (ctx.type === "subtree") {
				ctx.parentId = this.model.getProperty("/subtreeExecutionContextId");
			}

			if (ctx.type === "components") {
				var selectionContainer = sap.ui.getCore().byId("componentsSelectionContainer"),
					cbs = selectionContainer.getContent();

				ctx.components = [];
				cbs.forEach(function (checkBox) {
					if (checkBox.getSelected()) {
						ctx.components.push(checkBox.getText());
					}
				});
			}

			return ctx;
		},
		_getSelectedRules: function () {
			var libs = this.model.getProperty("/libraries"),
				selectedRules = [];

			// When tool is inject from outside libraries is empty
			// TODO: fix libraries to be there if possible
			if (Array.isArray(libs)) {
				libs.forEach(function (lib, libIndex) {
					lib.rules.forEach(function (rule) {
						if (rule.selected) {
							selectedRules.push({
								libName: lib.title,
								ruleId: rule.id
							});
						}
					});
				});
			}

			return selectedRules;
		},
		onAnalyzeSettings: function (oEvent) {
			CommunicationBus.publish(channelNames.GET_AVAILABLE_COMPONENTS);
			this._settingsPopover.openBy(oEvent.getSource());
		},
		onContextSelect: function (oEvent) {
			if (oEvent.getParameter("selected")) {
				var source = oEvent.getSource(),
					radioKey = source.getCustomData()[0].getValue(),
					execScope = this.model.getProperty("/executionScopes")[radioKey];
				this.model.setProperty("/analyzeContext", execScope);
			}
			var cookie =  storage.readPersistenceCookie(constants.COOKIE_NAME);
			if (cookie) {
				this.persistExecutionScope();
			}
		},

		onExecutionContextChange: function (event) {
			var value = event.getSource().getValue();

			if (value) {
				this.model.setProperty("/subtreeExecutionContextId", value);
			}

			var cookie =  storage.readPersistenceCookie(constants.COOKIE_NAME);
			if (cookie) {
				this.persistExecutionScope();
			}
		},

		persistExecutionScope: function() {
			var setting = {
				analyzeContext: this.model.getProperty("/analyzeContext"),
				subtreeExecutionContextId: this.model.getProperty("/subtreeExecutionContextId")
			};

			storage.setSelectedContext(setting);
		},

		onScopeComponentSelect: function (event) {
			var scopeComponents = this.model.getProperty("/executionScopeComponents"),
				cookie =  storage.readPersistenceCookie(constants.COOKIE_NAME);

			if (cookie) {
				storage.setSelectedScopeComponents(scopeComponents);
			}
		},
		onBeforePopoverOpen: function () {
			if (this.model.getProperty("/executionScopeComponents").length === 0) {
				CommunicationBus.publish(channelNames.GET_AVAILABLE_COMPONENTS);
			}
		},

		createNewRulePress: function(oEvent) {

				var emptyRule = this.model.getProperty("/newEmptyRule");
				this.model.setProperty("/selectedSetPreviewKey", "availableRules");
				this.model.setProperty("/newRule", jQuery.extend(true, {}, emptyRule));
				this.goToCreateRule();
		},
		goToRuleProperties: function () {
			var navCont = this.getView().byId("rulesNavContainer");
			navCont.to(this.getView().byId("rulesDisplayPage"), "show");
		},
		/**
		 * Here we need a new behavior for the sap.m.List - we need to be able to both click on the checkbox,
		 * and click on the whole list item, and those 2 clicks to be separate from each other (with separate
		 * event handlers)
		 * In our case 1 list is the rules for 1 library, we have more than one list, and we need the select
		 * state to also be shared between 2 or more lists (visualy).
		 * Could be implemented with extension control of the list item, but because we are in iframe this is also fine.
		 */
		hackListItemBase: function () {
			var that = this,
				oldTap = ListItemBase.prototype.ontap,
				oldUpdateSelectedDom = ListItemBase.prototype.updateSelectedDOM,
				oldAfterRendering = ListItemBase.prototype.onAfterRendering;

			var isRulesList = function (list) {
				var customData = list.getCustomData();
				if (!customData || customData.length == 0) {
					return false;
				}

				var result = false;
				customData.forEach(function (data) {
					if (data.getKey() === "rulesList") {
						result = true;
					}
				});

				return result;
			};

			ListItemBase.prototype.onAfterRendering = function () {
				oldAfterRendering.apply(this, arguments);
				if (isRulesList(this.getParent())) {
					this.$().removeClass("sapMLIBSelected");
				}
			};

			ListItemBase.prototype.ontap = function (oEvent) {
				if (!isRulesList(this.getParent())) {
					oldTap.call(this, oEvent);
					return;
				}
				if ($(oEvent.target).hasClass("sapMCbBg") || $(oEvent.target).hasClass("sapMCb")) {
					oldTap.call(this, oEvent);
				} else {
					that.model.setProperty("/selectedRuleStringify", "");
					that.markLIBAsSelected(this);

					var selectedRule = this.getBindingContext().getObject();
					that.model.setProperty("/selectedRule", selectedRule);
					that.model.setProperty("/selectedRuleStringify", that.createRuleString(selectedRule));
				}

				Ruleset.storeSelectionOfRules(that.model.getProperty("/libraries"));
			};

			ListItemBase.prototype.updateSelectedDOM = function(bSelected, $This) {
				oldUpdateSelectedDom.call(this, bSelected, $This);
				if (isRulesList(this.getParent())) {
					$This.removeClass("sapMLIBSelected");
				}
			};
		},
		createRuleString: function (rule) {
			// FIXME
			// Need to return empty string when rule is undefined
			// it happens when tool is injected from outside
			if (!rule) {
				return '';
			}

			var str = "{\n",
				count = 0,
				keysLength = Object.keys(rule).length;

			for (var key in rule) {
				var value = rule[key];
				count++;
				str += "\t";
				str += key + ": ";
				if (key === "check") {
					str += value.split("\n").join("\n\t");
				} else {
					str += JSON.stringify(value);
				}

				//Don't add comma after last value
				if (count < keysLength) {
					str += ",";
				}

				str += "\n";
			}
			str += "}";
			return str;
		},
		markLIBAsSelected: function (listItemBase) {
			if (!listItemBase) {
				var selectedRuleTitle = this.model.getProperty("/selectedRule/title");
				this.getView().byId("ruleSetContainer").getContent().forEach(function (libPanel) {
					libPanel.getContent()[0].getItems().forEach(function (libItem) {
						if (libItem.getLabel() === selectedRuleTitle) {
							listItemBase = libItem;
						}
					});
				});
			} else {
				this.getView().$().find(".sapMLIB").removeClass("sapMLIBSelected");
				listItemBase.$().addClass("sapMLIBSelected");
			}
		},
		onAfterNavigate: function (oEvent) {
			var to = oEvent.getParameter("to"),
				that = this;

			if (to === this.getView().byId("rulesDisplayPage")) {
				setTimeout(function () {
					that.markLIBAsSelected();
				}, 250);
			}
		},
		selectAll: function () {
			var that = this;
			this.visitAllRules(function (rule, ruleIndex, libIndex) {
					that.model.setProperty("/libraries/" + libIndex + "/rules/" + ruleIndex + "/selected", true);
			});
			Ruleset.storeSelectionOfRules(this.model.getProperty("/libraries"));
		},
		deselectAll: function () {
			var that = this;
			that.visitAllRules(function (rule, ruleIndex, libIndex) {
					that.model.setProperty("/libraries/" + libIndex + "/rules/" + ruleIndex + "/selected", false);
			});
			Ruleset.storeSelectionOfRules(this.model.getProperty("/libraries"));
		},
		updateRule: function () {
			var oldId = this.model.getProperty("/editRuleSource/id"),
				updateObj = this.model.getProperty("/editRule");

			if (this.checkFunctionString(updateObj.check)) {
				CommunicationBus.publish(channelNames.VERIFY_UPDATE_RULE, {
					oldId: oldId,
					updateObj: RuleSerializer.serialize(updateObj)
				});
			}
		},
		updatesupportRules: function (data) {
			data = RuleSerializer.deserialize(data);

			var libraries = [],
				that = this;

			for (var i in data) {
				var rules = [],
					ruleSets = data[i].ruleset._mRules;

				for (var j in ruleSets) {
					var rule = ruleSets[j];
					rule.libName = i;
					rule.selected = true;
					rules.push(rule);
				}

				libraries.push({
					title: i,
					type: "library",
					rules: rules
				});
			}

			var firstSelectedRule = libraries[0].rules[0];
			that.placeTemporaryRulesetAtStart(libraries);
			that.model.setProperty("/selectedRuleStringify", "");
			that.model.setProperty("/selectedRule", firstSelectedRule);
			that.model.setProperty("/selectedRuleStringify", that.createRuleString(firstSelectedRule));
			that.model.setProperty("/libraries", libraries);

			var tempRules = storage.getRules(),
				loadingFromAddiotnalRuleSets = that.model.getProperty("/loadingAdditionalRuleSets");
			if (tempRules && !loadingFromAddiotnalRuleSets && !this.tempRulesLoaded) {
				this.tempRulesLoaded = true;
				tempRules.forEach(function (tempRule) {
					CommunicationBus.publish(channelNames.VERIFY_CREATE_RULE, RuleSerializer.serialize(tempRule));
				});
			}
			//*This property is neede when we are loading additional rulesets and to not retriger ".VERIFY_CREATE_RULE"*/
			that.model.setProperty("/loadingAdditionalRuleSets", false);

			Ruleset.loadSelectionOfRules(that.model.getProperty("/libraries"));
			that.createRulesUI();
			var panel = that.getView().byId("ruleSetContainer").getContent()[0];
			panel.setExpanded(true);
		},
		placeTemporaryRulesetAtStart: function (libraries) {
			for (var i = 0; i < libraries.length; i++) {
				var ruleSet = libraries[i];

				if (ruleSet.title === constants.TEMP_RULESETS_NAME) {
					var temp = ruleSet;
					libraries.splice(i, 1);
					libraries.unshift(temp);
					return;
				}
			}
		},
		createRulesUI: function () {
			var libs = this.model.getProperty("/libraries"),
				rulesCount = 0,
				that = this,
				vlContainer = this.getView().byId("ruleSetContainer");
			that.model.setProperty("/selectedRule", that.model.getProperty("/libraries/1/rules/1"));

			vlContainer.getContent().forEach(function (content, contentIndex) {
				vlContainer.removeContent(content);
			});

			libs.forEach(function (lib, libIndex) {

				var ruleListContent = that._creatingContentForRulesList(lib, libIndex, that);

				var rulesList = new List({
					mode : "MultiSelect",
					includeItemInSelection: true,
					items: {
						path: "/libraries/" + libIndex + "/rules",
						template: new InputListItem({
							label: "{title}",
							selected: "{selected}",
							content: ruleListContent
						})
					}
				});
				rulesList.data("rulesList", true);

				if (lib.rules.length === undefined) {
					rulesCount = 1;
				} else {
					rulesCount = lib.rules.length;
				}

				var libPanel = new Panel({
					width: "100%",
					expandable: true,
					expanded: false,
					content: rulesList,
					headerToolbar: new Toolbar({
						content: [
							new Label({
								text: lib.title + " (" + rulesCount + ")"
							})
						]
					})
				});

				vlContainer.addContent(libPanel);
			});

		},
		addLinkToNewRule: function () {
			var tempLink = this.model.getProperty("/tempLink"),
				copy = jQuery.extend(true, {}, tempLink);
			this.model.getProperty("/newRule/resolutionurls").push(copy);
			this.model.checkUpdate(true, true);
		},
		addLinkToEditRule: function () {
			var tempLink = this.model.getProperty("/tempLink"),
				copy = jQuery.extend(true, {}, tempLink);
			this.model.getProperty("/editRule/resolutionurls").push(copy);
			this.model.checkUpdate(true, true);
		},
		goToCreateRule: function () {
			var navCont = this.getView().byId("rulesNavContainer");
			navCont.to(this.getView().byId("rulesCreatePage"), "show");
		},
		checkFunctionString: function (functionString) {
			try {
				/* eslint-disable no-eval */
				eval("var testAsignedVar = " + functionString);
				/* eslint-enable no-eval */
			} catch (err) {
				MessageToast.show("Your check function contains errors, and can't be evaluated:" + err);
				return false;
			}
			return true;
		},
		addNewRule: function () {
			var newRule = this.model.getProperty("/newRule");
			if (this.checkFunctionString(newRule.check)) {
				this.showRuleCreatedToast = true;
				CommunicationBus.publish(channelNames.VERIFY_CREATE_RULE, RuleSerializer.serialize(newRule));
			}
		},
		rulesToolbarITHSelect: function (oEvent) {
			if (oEvent.getParameter("key") === "jsonOutput") {
				var newRule = this.model.getProperty("/newRule"),
					stringifiedJson = this.createRuleString(newRule);
				this.model.setProperty("/newRuleStringified", stringifiedJson);
			}
		},
		rulesToolbarEditITHSelect: function (oEvent) {
			if (oEvent.getParameter("key") === "jsonOutput") {
				var newRule = this.model.getProperty("/editRule"),
					stringifiedJson = this.createRuleString(newRule);
				this.model.setProperty("/updateRuleStringified", stringifiedJson);
			}
		},
		visitAllRules: function (callback) {
			var libs = this.model.getProperty("/libraries");
			libs.forEach(function (lib, libIndex) {
				lib.rules.forEach(function (rule, ruleIndex) {
					callback(rule, ruleIndex, libIndex);
				});
			});
		},
		loadMarkedSupportLibraries: function () {
			var list = this.getView().byId("availableLibrariesSet"),
				libNames = list.getSelectedItems().map(function (item) {
					return item.getTitle();
				});

			list.getItems().forEach(function (item) {
				item.setSelected(false);

			});

			if (libNames.length > 0) {
				this.loadingFromLoadButton = true;
				CommunicationBus.publish(channelNames.LOAD_RULESETS, {
					libNames: libNames
				});
				this.model.setProperty("/loadingAdditionalRuleSets", true);
			}
		},

		_creatingContentForRulesList: function(lib, libIndex, that) {
			var tempRulesButtons = [new sap.m.Button({
				icon:"sap-icon://edit",
				press: function (oEvent) {
					var sourceObject = this.getParent().getBindingContext().getObject();
					that.model.setProperty("/editRuleSource", sourceObject);
					that.model.setProperty("/editRule", jQuery.extend(true, {}, sourceObject));
					that.model.checkUpdate(true, true);
					var navCont = that.getView().byId("rulesNavContainer");
					navCont.to(that.getView().byId("ruleUpdatePage"), "show");
				}
			}),  new sap.m.Button({
				icon:"sap-icon://delete",
				press: function (oEvent) {

					var sourceObject = this.getParent().getBindingContext().getObject(),
						ruleSetWithDeletedRules = [];

					for (var i = 0; i < lib.rules.length; i++) {

						if (lib.rules[i].id !== sourceObject.id) {
							ruleSetWithDeletedRules.push(lib.rules[i]);
						}
					}
					that.model.setProperty("/libraries/0/rules", ruleSetWithDeletedRules);
					storage.removeSelectedRules(ruleSetWithDeletedRules);
					that.createRulesUI();
					var firstPanelItem = that.getView().byId("ruleSetContainer").getContent()[0];
					firstPanelItem.setExpanded(true);
				}
			})];
			var content = lib.title === constants.TEMP_RULESETS_NAME ? tempRulesButtons :
				new sap.m.Button({
					text: "Duplicate",
					press: function (oEvent) {
						var sourceObject = this.getParent().getBindingContext().getObject();
						var selectedRuleCopy = jQuery.extend(true, {}, sourceObject);
						that.model.setProperty("/newRule", selectedRuleCopy);
						that.model.checkUpdate(true, false);
						that.goToCreateRule();
					}
				});
			return content;
		}
	});
});

}; // end of sap/ui/support/supportRules/ui/controllers/Analysis.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.controllers.Issues.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.controllers.Issues.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ui/controllers/Issues.controller",[
	"jquery.sap.global",
	"sap/ui/core/mvc/Controller",
	"sap/ui/model/json/JSONModel",
	"sap/ui/support/supportRules/WindowCommunicationBus",
	"sap/ui/support/supportRules/ui/models/SharedModel",
	"sap/ui/support/supportRules/ElementTree",
	"sap/ui/support/supportRules/WCBChannels"
], function ($, Controller, JSONModel, CommunicationBus, SharedModel, ElementTree, channelNames) {
	"use strict";

	var mIssueSettings = {
		severitytexts: {
			High: "High",
			Medium: "Medium",
			Low: "Low",
			All: "All Severities"
		},
		severitystates: {
			High: "Error",
			Medium: "Warning",
			Low: "None",
			All: "None"
		},
		severityicons: {
			High: "sap-icon://message-error",
			Medium: "sap-icon://message-warning",
			Low: "sap-icon://message-information",
			All: "sap-icon://multiselect-all"
		}
	};

	return Controller.extend("sap.ui.support.supportRules.ui.controllers.Issues", {
		ISSUES_LIMIT : 1000,
		onInit: function () {
			CommunicationBus.subscribe(channelNames.ON_ANALYZE_FINISH, function (data) {
			var that = this;

				var problematicControlsIds = {};

				// Contains a list of all issues found during analisys.
				// The list is used later when filters are modified.
				that.data = data;

				data.issues.forEach(function (issue) {
					if (!issue.context || !issue.context.id) {
						return;
					}

					if (!problematicControlsIds[issue.context.id]) {
						problematicControlsIds[issue.context.id] = [issue.name];
					} else {
						problematicControlsIds[issue.context.id].push(issue.name);
					}

				});
				this.model.setSizeLimit(this.ISSUES_LIMIT);
				this.model.setProperty("/issues", data.issues);
				this.model.setProperty("/maxIssuesDisplayedNumber", Math.min(this.ISSUES_LIMIT, data.issues.length));
				this.model.setProperty('/analyzePressed', true);
				this.model.setProperty("/visibleIssuesCount", data.issues.length);
				/*this.elementTreeData = {
					controls: data.elementTree,
					issuesIds: problematicControlsIds
				};*/

				this.elementTree.setData({
					controls: data.elementTree,
					issuesIds: problematicControlsIds
				});

				this.clearFilters();
				this._selectFirstVisibleIssue();
			}, this);

			this.model = SharedModel;
			this.getView().setModel(this.model);
			this.clearFilters();
			this._initElementTree();
		},
		_initElementTree: function () {
			var that = this;

			this.elementTree = new ElementTree(null, {
				onIssueCountClicked: function (selectedElementId) {
					that.clearFilters();
					that.model.setProperty("/elementFilter", selectedElementId);
					that.updateIssuesVisibility();
					that._selectFirstVisibleIssue();
				},
				onHoverChanged: function (hoveredElementId) {
					CommunicationBus.publish(channelNames.TREE_ELEMENT_MOUSE_ENTER, hoveredElementId);
				},
				onMouseOut: function () {
					CommunicationBus.publish(channelNames.TREE_ELEMENT_MOUSE_OUT);
				}
			});
		},
		onAfterRendering: function () {
			this.elementTree.setContainerId(this.getView().byId("elementTreeContainer").getId());
		},
		clearFilters: function () {
			this.model.setProperty("/severityFilter", "All");
			this.model.setProperty("/categoryFilter", "All");
			this.model.setProperty("/elementFilter", "All");
			this.model.setProperty("/audienceFilter", "All");

			if (this.data) {
				this.model.setProperty("/issues", this.data.issues);
				this.setToolbarHeight();
			}

			this.updateIssuesVisibility();
		},
		clearFiltersAndElementSelection: function () {
			this.clearFilters();
			this.elementTree.clearSelection();
		},
		onIssuePressed: function (event) {
			var pressedLi = event.mParameters.listItem,
				selectedIssue = pressedLi.getBindingContext().getObject();
			this.model.setProperty("/selectedIssue", selectedIssue);
			this.elementTree.setSelectedElement(selectedIssue.context.id, false);
		},
		openDocumentation: function (oEvent) {
			var link = sap.ui.getCore().byId(oEvent.mParameters.id),
				url = link.getBindingContext().getProperty("href");
			CommunicationBus.publish(channelNames.OPEN_URL, url);
		},
		updateIssuesVisibility: function () {
			var visibleIssuesCount = 0;
			var issuesList = this.getView().byId("issuesList");

			if (this.data) {
				var filteredIssues = this.data.issues.filter(this.filterIssueListItems, this);

				this.model.setProperty("/issues", filteredIssues);
				this.model.setProperty("/maxIssuesDisplayedNumber", Math.min(this.ISSUES_LIMIT, filteredIssues.length));
			}

			this.setToolbarHeight();

			issuesList.getItems().forEach(function (item) {
				item.updateProperty("visible");
			});

			issuesList.getItems().forEach(function (item) {
				if (item.getVisible()) {
					visibleIssuesCount++;
				}
			});
			this.model.setProperty("/visibleIssuesCount", visibleIssuesCount);
		},
		_selectFirstVisibleIssue: function () {
			var list = this.getView().byId("issuesList"),
				items = list.getVisibleItems();

			if (items.length > 0) {
				list.setSelectedItem(items[0]);
				this.model.setProperty("/selectedIssue", items[0].getBindingContext().getObject());
			}
		},
		filterIssueListItems: function (issue) {
			var sevFilter = this.model.getProperty("/severityFilter"),
				sevFilterApplied = issue.severity === sevFilter || sevFilter === 'All',
				catFilter = this.model.getProperty("/categoryFilter"),
				catFilterApplied = $.inArray( catFilter, issue.categories ) > -1 || catFilter === 'All',
				elementFilter = this.model.getProperty("/elementFilter"),
				elementFilterApplied =  elementFilter ===  issue.context.id || elementFilter === 'All',
				audFilter = this.model.getProperty("/audienceFilter"),
				audienseFilterApplied =  $.inArray( audFilter, issue.audiences ) > -1 || audFilter === 'All';

			return sevFilterApplied && catFilterApplied && elementFilterApplied && audienseFilterApplied;
		},
		filterSevirityIcon: function(sValue) {
			return mIssueSettings.severityicons[sValue];
		},
		filterSevirityState: function(sValue) {
			return mIssueSettings.severitystates[sValue];
		},
		filterSevirityText: function(sValue) {
			return mIssueSettings.severitytexts[sValue];
		},
		setToolbarHeight: function() {
			var issues = this.model.getProperty("/issues");
			if (issues && issues.length > this.ISSUES_LIMIT) {
				this.model.setProperty("/filterBarHeight", "3.5rem");
				this.model.setProperty("/messegeStripHeight", "2.5rem");
			} else {
				this.model.setProperty("/filterBarHeight", "4rem");
				this.model.setProperty("/messegeStripHeight", "2rem");
			}
		},
		onReportPress: function(oEvent) {
				var oItem = oEvent.getParameter("item"),
					actionToTake = oItem.getText(),
					data = this._getReportData();
				if (actionToTake === 'View') {
					CommunicationBus.publish(channelNames.ON_SHOW_REPORT_REQUEST, data);
				} else {
					CommunicationBus.publish(channelNames.ON_DOWNLOAD_REPORT_REQUEST, data);
				}
		},
		_getReportData: function () {
			return {
				executionScopes: this.model.getProperty("/executionScopes"),
				executionScopeTitle: this.model.getProperty("/executionScopeTitle"),
				analysisDurationTitle: this.model.getProperty("/analysisDurationTitle")
			};
		}
	});
});

}; // end of sap/ui/support/supportRules/ui/controllers/Issues.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.ui.controllers.Main.controller') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.ui.controllers.Main.controller'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('sap.ui.core.mvc.Controller'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/ui/controllers/Main.controller",[
	"sap/ui/core/mvc/Controller",
	"sap/ui/model/json/JSONModel",
	"sap/ui/support/supportRules/WindowCommunicationBus",
	"sap/ui/support/supportRules/ui/models/SharedModel",
	"sap/ui/support/supportRules/WCBChannels",
	"sap/ui/support/supportRules/Constants",
	"sap/ui/support/supportRules/Storage"
], function (Controller, JSONModel, CommunicationBus, SharedModel, channelNames, constants, storage) {
	"use strict";

	return Controller.extend("sap.ui.support.supportRules.ui.controllers.Main", {
		onInit: function () {
			this.model = SharedModel;
			this.getView().setModel(this.model);
			this.resizeDown();
			this.setCommunicationSubscriptions();
			this.initSettingsPopover();

			this.hidden = false;
			this.model.setProperty("/hasNoOpener", window.opener ? false : true);
			this.model.setProperty("/constants", constants);
			this.updateShowButton();
			this._setContextSettings();

		},

		initSettingsPopover: function () {
			this._settingsPopover = sap.ui.xmlfragment("sap.ui.support.supportRules.ui.views.StorageSettings", this);
			this._settingsPopover.setModel(SharedModel);
			this.getView().addDependent(this._oPopover);
		},

		setCommunicationSubscriptions: function () {
			CommunicationBus.subscribe(channelNames.ON_ANALYZE_FINISH, function (data) {
				this._clearProcessIndicator();
				this.ensureOpened();
				this.model.setProperty("/showProgressIndicator", false);
				this.model.setProperty("/coreStateChanged", false);
				this.model.setProperty("/lastAnalysisElapsedTime", data.elapsedTime);
				this.goToIssues();
				this.model.setProperty("/analyzedFinish", true);
			}, this);

			CommunicationBus.subscribe(channelNames.ON_PROGRESS_UPDATE, function (data) {
				var currentProgress = data.currentProgress,
					pi = this.getView().byId("progressIndicator");

				pi.setDisplayValue(currentProgress + "/" + 100);
				this.model.setProperty("/progress", currentProgress);
			}, this);

			CommunicationBus.subscribe(channelNames.ON_CORE_STATE_CHANGE, function () {
				this.model.setProperty("/coreStateChanged", true);
			}, this);
		},

		resizeUp: function () {
			CommunicationBus.publish(channelNames.RESIZE_FRAME, {bigger: true});
		},

		ensureOpened: function () {
			CommunicationBus.publish(channelNames.ENSURE_FRAME_OPENED);
		},

		resizeDown: function () {
			CommunicationBus.publish(channelNames.RESIZE_FRAME, {bigger: false});
		},

		onPersistedSettingSelect: function() {
			if (this.model.getProperty("/persistingSettings")) {
				storage.createPersistenceCookie(constants.COOKIE_NAME, true);

				this.model.getProperty("/libraries").forEach(function (lib) {
					if (lib.title == constants.TEMP_RULESETS_NAME) {
							storage.setRules(lib.rules);
						}
				});
				this.persistExecutionScope();

			} else {
				storage.deletePersistenceCookie(constants.COOKIE_NAME);
				this.deletePersistedData();
			}
		},
		onSettings: function (oEvent) {
			CommunicationBus.publish(channelNames.ENSURE_FRAME_OPENED);

			var that = this,
				source = oEvent.getSource();
			setTimeout(function() {
				that._settingsPopover.openBy(source);
			}, 0);
		},

		onNavConAfterNavigate: function (oEvent) {
			var to = oEvent.getParameter("to");
			if (to === this.getView().byId("analysis")) {
				setTimeout(function () {
					to.getController().markLIBAsSelected();
				}, 250);
			}
		},


		goToAnalysis: function (evt) {
			var navCon = this.getView().byId("navCon");
			navCon.to(this.getView().byId("analysis"), "show");
			this.ensureOpened();
		},
		goToIssues: function () {
			var navCon = this.getView().byId("navCon");
			navCon.to(this.getView().byId("issues"), "show");
			this.ensureOpened();
		},

		goToWiki: function () {
			 window.open('https://uacp2.hana.ondemand.com/viewer/DRAFT/SAPUI5_Internal/57ccd7d7103640e3a187ed55e1d2c163.html','_blank');
		},

		setRulesLabel: function (libs) {
			var selectedCounter = 0;
			if (libs === null) {
				return "Rules (" + selectedCounter + ")";
			} else {
				libs.forEach(function (lib, libIndex) {
					selectedCounter += lib.rules.length;
				});
				return "Rules (" + selectedCounter + ")";
			}
		},

		updateShowButton: function () {
			// When hidden is true - the frame is minimized and we show the "show" button
			this.getView().byId("sapSTShowButtonBar").setVisible(this.hidden);
		},

		toggleHide: function () {
			this.hidden = !this.hidden;
			this.updateShowButton();

			CommunicationBus.publish(channelNames.TOGGLE_FRAME_HIDDEN, this.hidden);
		},

		persistExecutionScope: function() {
			var setting = {
				analyzeContext: this.model.getProperty("/analyzeContext"),
				subtreeExecutionContextId: this.model.getProperty("/subtreeExecutionContextId")
			},
			scopeComponent = this.model.getProperty("/executionScopeComponents");

			storage.setSelectedScopeComponents(scopeComponent);
			storage.setSelectedContext(setting);
		},

		deletePersistedData: function() {
			storage.deletePersistenceCookie(constants.COOKIE_NAME);
			this.model.setProperty("/persistingSettings", false);
			storage.removeAllData();
		},

		_clearProcessIndicator: function() {
			var pi = this.getView().byId("progressIndicator");
			pi.setDisplayValue("None");
			this.model.setProperty("/progress", 0.1);
		},

		_setContextSettings:function() {
			var cookie = storage.readPersistenceCookie(constants.COOKIE_NAME);
			if (cookie) {
				this.model.setProperty("/persistingSettings", true);
				var contextSettings = storage.getSelectedContext();

				if (contextSettings) {
					this.model.setProperty("/analyzeContext", contextSettings.analyzeContext);
					this.model.setProperty("/subtreeExecutionContextId", contextSettings.subtreeExecutionContextId);
				}else {
					this.model.setProperty("/analyzeContext", this.model.getProperty("/analyzeContext"));
					this.model.setProperty("/subtreeExecutionContextId", "");
				}
			}
		}
	});
});

}; // end of sap/ui/support/supportRules/ui/controllers/Main.controller.js
if ( !jQuery.sap.isDeclared('sap.ui.table.library.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Adds support rules of the sap.ui.table library to the support infrastructure.
 */
jQuery.sap.declare('sap.ui.table.library.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/table/library.support",["jquery.sap.global", "sap/ui/support/library", "sap/ui/support/supportRules/RuleSet", "./TableHelper.support"],
	function(jQuery, SupportLib, Ruleset, SupportHelper) {
	"use strict";

	// shortcuts
	var Categories = SupportLib.Categories, // Accessibility, Performance, Memory, ...
		Severity = SupportLib.Severity;	// Hint, Warning, Error
		//Audiences = SupportLib.Audiences; // Control, Internal, Application

	var oLib = {
		name: "sap.ui.table",
		niceName: "UI5 Table library"
	};

	var oRuleset = new Ruleset(oLib);

	function createRule(oRuleDef) {
		oRuleDef.id = "GRIDTABLE_" + oRuleDef.id;
		SupportHelper.addRuleToRuleset(oRuleDef, oRuleset);
	}


	//**********************************************************
	// Rule Definitions
	//**********************************************************


	/*
	 * Checks whether content densities are used correctly.
	 */
	createRule({
		id : "CONTENT_DENSITY",
		title : "Content Density Usage",
		description : "Checks whether the content densities 'Cozy', 'Compact' and 'Condensed' are used correctly.",
		resolution : "Ensure that either only the 'Cozy' or 'Compact' content density is used or the 'Condensed' and 'Compact' content densities in combination are used.",
		resolutionurls : [SupportHelper.createDocuRef("How to use Content Densities", "#docs/guide/e54f729da8e3405fae5e4fe8ae7784c1.html")],
		check : function(oIssueManager, oCoreFacade, oScope) {
			var $Document = jQuery("html");
			var $Cozy = $Document.find(".sapUiSizeCozy");
			var $Compact = $Document.find(".sapUiSizeCompact");
			var $Condensed = $Document.find(".sapUiSizeCondensed");

			function checkDensity($Source, sTargetClass, sMessage) {
				var bFound = false;
				$Source.each(function(){
					if (jQuery(this).closest(sTargetClass).length) {
						bFound = true;
					}
				});
				if (bFound && sMessage) {
					SupportHelper.reportIssue(oIssueManager, sMessage, Severity.High);
				}
				return bFound;
			}

			checkDensity($Compact, ".sapUiSizeCozy", "'Compact' content density is used within 'Cozy' area.");
			checkDensity($Cozy, ".sapUiSizeCompact", "'Cozy' content density is used within 'Compact' area.");
			checkDensity($Condensed, ".sapUiSizeCozy", "'Condensed' content density is used within 'Cozy' area.");
			checkDensity($Cozy, ".sapUiSizeCondensed", "'Cozy' content density is used within 'Condensed' area.");

			if ($Condensed.length > 0) {
				var bFound = checkDensity($Condensed, ".sapUiSizeCompact");
				if (!bFound) {
					SupportHelper.reportIssue(oIssueManager, "'Condensed' content density must be used in combination with 'Compact'.", Severity.High);
				}
			}
		}
	});

	/*
	 * Validates whether title or aria-labelledby is correctly set
	 */
	createRule({
		id : "VALIDATE_ACC_TITLE",
		categories: [Categories.Accessibility],
		title : "Accessible Label",
		description : "Checks whether 'sap.ui.table.Table' controls have an accessible label.",
		resolution : "Use the 'title' aggregation or the 'ariaLabelledBy' association of the 'sap.ui.table.Table' control to define a proper accessible labeling.",
		check : function(oIssueManager, oCoreFacade, oScope) {
			var aTables = SupportHelper.find(oScope, true, "sap/ui/table/Table");
			for (var i = 0; i < aTables.length; i++) {
				if (!aTables[i].getTitle() && aTables[i].getAriaLabelledBy().length == 0) {
					SupportHelper.reportIssue(oIssueManager, "Table '" + aTables[i].getId() + "' does not have an accessible label.", Severity.High, aTables[i].getId());
				}
			}
		}
	});

	return {lib: oLib, ruleset: oRuleset};

}, true);

}; // end of sap/ui/table/library.support.js
if ( !jQuery.sap.isDeclared('sap.m.library.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Adds support rules of the sap.m library to the support infrastructure.
 */
jQuery.sap.declare('sap.m.library.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/m/library.support",["jquery.sap.global", "sap/ui/support/library", "sap/ui/support/supportRules/RuleSet",
			   "./Button.support",
			   "./Dialog.support",
			   "./Input.support"],
	function(jQuery, SupportLib, Ruleset,
			 ButtonSupport,
			 DialogSupport,
			 InputSupport) {
	"use strict";

	var oLib = {
		name: "sap.m",
		niceName: "UI5 Main Library"
	};
	var oRuleset = new Ruleset(oLib);

	ButtonSupport.addRulesToRuleset(oRuleset);
	DialogSupport.addRulesToRuleset(oRuleset);
	InputSupport.addRulesToRuleset(oRuleset);

	return {lib: oLib, ruleset: oRuleset};

}, true);

}; // end of sap/m/library.support.js
if ( !jQuery.sap.isDeclared('sap.ui.core.library.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Adds support rules to the core
 */
jQuery.sap.declare('sap.ui.core.library.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/core/library.support",["jquery.sap.global",
		"sap/ui/support/supportRules/RuleSet",
		"./Misc.support",
		"./Config.support",
		"./Model.support",
		"./View.support",
		"./App.support"],
	function(jQuery, RuleSet, MiscSupport, ConfigSupport, ModelSupport, ViewSupport, AppSupport) {
	"use strict";

	var oLib = {
		name: "sap.ui.core",
		niceName: "UI5 Core Library"
	};

	var oRuleSet = new RuleSet(oLib);


	// Adds the miscellaneous rules
	MiscSupport.addRulesToRuleSet(oRuleSet);

	// Adds the configuration rules
	ConfigSupport.addRulesToRuleSet(oRuleSet);

	// Adds the model rules
	ModelSupport.addRulesToRuleSet(oRuleSet);

	// Adds the view related rules
	ViewSupport.addRulesToRuleSet(oRuleSet, {
		iNumberOfControlsThreshold: 20000
	});

	// Adds the app related rules
	var aObsoleteFunctionNames = ["jQuery.sap.require", "$.sap.require", "sap.ui.requireSync", "jQuery.sap.sjax"];
	if (jQuery && jQuery.sap && jQuery.sap.sjax) {
		aObsoleteFunctionNames.push("jQuery.sap.syncHead",
			"jQuery.sap.syncGet",
			"jQuery.sap.syncPost",
			"jQuery.sap.syncGetText",
			"jQuery.sap.syncGetJSON");
	}

	AppSupport.addRulesToRuleSet(oRuleSet, {
		aObsoleteFunctionNames: aObsoleteFunctionNames
	});



	return {
		lib: oLib,
		ruleset: oRuleSet
	};
}, true);
}; // end of sap/ui/core/library.support.js
if ( !jQuery.sap.isDeclared('sap.ui.layout.library.support') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
/**
 * Adds support rules of the sap.m library to the support infrastructure.
 */
jQuery.sap.declare('sap.ui.layout.library.support'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/layout/library.support",["jquery.sap.global", "sap/ui/support/library", "sap/ui/support/supportRules/RuleSet",
               "./Form.support"],
	function(jQuery, SupportLib, Ruleset,
			FormSupport) {
	"use strict";

	// shortcuts
	//var Audiences = SupportLib.Audiences, // Control, Internal, Application
	//	Categories = SupportLib.Categories, // Accessibility, Performance, Memory, Modelbindings, ...
	//	Severity = SupportLib.Severity;	// Hint, Warning, Error

	var oLib = {
		name: "sap.ui.layout",
		niceName: "UI5 Layout Library"
	};

	var oRuleset = new Ruleset(oLib);

	// Adds the rules related to sap.m.List, sap.m.Table and sap.m.Tree
	FormSupport.addRulesToRuleset(oRuleset);

	//Add rules with the addRule method
	//oRuleset.addRule({})

	return {lib: oLib, ruleset: oRuleset};

}, true);
}; // end of sap/ui/layout/library.support.js
if ( !jQuery.sap.isDeclared('sap.ui.support.supportRules.Main') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.support.supportRules.Main'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.json.JSONModel'); // unlisted dependency retained
sap.ui.define("sap/ui/support/supportRules/Main",[
	"jquery.sap.global",
	"sap/ui/base/ManagedObject",
	"sap/ui/model/json/JSONModel",
	"sap/ui/support/supportRules/Analyzer",
	"sap/ui/support/supportRules/CoreFacade",
	"sap/ui/support/supportRules/ExecutionScope",
	"sap/ui/support/supportRules/Highlighter",
	"sap/ui/support/supportRules/WindowCommunicationBus",
	"sap/ui/support/supportRules/RuleSerializer",
	"sap/ui/support/supportRules/RuleSet",
	"sap/ui/support/supportRules/IssueManager",
	"sap/ui/support/supportRules/report/DataCollector",
	"sap/ui/support/supportRules/WCBChannels",
	"sap/ui/support/supportRules/Constants"
],
function (jQuery, ManagedObject, JSONModel, Analyzer, CoreFacade,
		  ExecutionScope, Highlighter, CommunicationBus, RuleSerializer,
		  RuleSet, IssueManager, DataCollector, channelNames, constants) {
	"use strict";

	var IFrameController = null;
	var oMain = null;
	var customSuffix = 'sprt';

	/**
	 * Controller for the support tools
	 * Provides integration with respective data services
	 */
	var Main = ManagedObject.extend("sap.ui.support.Main", {
		constructor: function () {
			if (!oMain) {
				var that = this;
				this._oCore = null;
				this._rulesCreated = false;
				this._mRuleSets = {};
				this._oAnalyzer = new Analyzer();
				that._initTempRulesLib();

				ManagedObject.apply(this, arguments);

				jQuery.sap.support = {
					analyze: function (executionScope, ruleDescriptors) {
						return oMain.analyze(executionScope, ruleDescriptors);
					},
					getAnalysisHistory: function () {
						if (that._oAnalyzer.running()) {
							return null;
						}

						return IssueManager.getHistory();
					},
					getFormattedAnalysisHistory: function () {
						if (that._oAnalyzer.running()) {
							return;
						}

						// Lazily, asynchronously load the IssueFormatter
						return new Promise(
							function (resolve, reject) {
								sap.ui.require(["sap/ui/support/supportRules/report/AnalysisHistoryFormatter"], function (AnalysisHistoryFormatter) {
									resolve(AnalysisHistoryFormatter.format(IssueManager.getConvertedHistory()));
								});
							}
						);
					}
				};

				var evt = document.createEvent("CustomEvent");
				evt.initCustomEvent("supportToolLoaded", true, true, {});
			} else {
				jQuery.sap.log.warning("Only one support tool allowed");

				return oMain;
			}
		}
	});

	/**
	 * Checks if the current page is inside an iframe.
	 */
	Main.prototype._isInIframe = function () {
		try {
			return window.self !== window.top;
		} catch (e) {
			// Access to window.top might be blocked if so the page is inside an iframe.
			return true;
		}
	};

	/**
	 * This controller is started by the core as plugin
	 */
	Main.prototype.startPlugin = function (supportModeConfig) {
		if (this._pluginStarted) {
			return;
		}

		this._pluginStarted = true;

		var that = this;

		sap.ui.getCore().registerPlugin({
			startPlugin: function (oCore) {
				that._supportModeConfig = supportModeConfig = supportModeConfig || oCore.getConfiguration().getSupportMode();
				that._setCommunicationSubscriptions();

				// If the current page is inside of an iframe don't start the Support tool.
				// Otherwise if there are any iframes inside a page, all of them
				// will have the Support tool started along with the parent page.
				var bForceUIInFrame = that._isInIframe() && supportModeConfig.indexOf("frame-force-ui") !== -1;

				that._oCore = oCore;
				that._oDataCollector = new DataCollector(oCore);
				that._oCoreFacade = CoreFacade(oCore);
				that._oExecutionScope = null;
				that._createCoreSpies();
				oCore.attachLibraryChanged(that._onLibraryChanged, that);

				// Make sure that we load UI frame, when no parameter supplied
				// but tools is required to load, or when parameter is there
				// but is not equal to 'silent'
				if (!supportModeConfig ||
					supportModeConfig.indexOf("silent") === -1 ||
					bForceUIInFrame) {
					// Lazily, asynchronously load the frame controller
					sap.ui.require(["sap/ui/support/supportRules/ui/IFrameController"], function (IFrameCtrl) {
						IFrameController = IFrameCtrl;

						IFrameController.injectFrame(supportModeConfig);

						// Validate messages
						CommunicationBus.onMessageChecks.push(function (msg) {
							return msg.origin === IFrameController.getFrameOrigin();
						});

						CommunicationBus.onMessageChecks.push(function (msg) {
							return msg.data._frameIdentifier === IFrameController.getFrameIdentifier();
						});

						CommunicationBus.onMessageChecks.push(function (msg) {
							var frameUrl = IFrameController.getFrameUrl();
							// remove relative path information
							frameUrl = frameUrl.replace(/\.\.\//g, '');
							return msg.data._origin.indexOf(frameUrl) > -1;
						});
					});
				} else {
					that._fetchSupportRuleSets();
				}
			},
			stopPlugin: function () {
				IFrameController._stop();
				that._pluginStarted = false;
				that._oCore = null;
				that._oCoreFacade = null;
				that._oDataCollector = null;
				that._oExecutionScope = null;
			}
		});
	};

	Main.prototype._onLibraryChanged = function (oEvent) {
		if (oEvent.getParameter("stereotype") === "library" && this._rulesCreated) {
			var that = this;

			this._fetchSupportRuleSets().then(function() {
				that._fetchNonLoadedRuleSets();
			});
		}
	};

	Main.prototype._createCoreSpies = function () {
		var that = this,
			notifyDirtyStateInterval = 500;

		this._dirtyTimeoutHandle = null;

		var spyFunction = function (fnName) {
			var oldFunction = that._oCore[fnName];
			that._oCore[fnName] = function () {
				oldFunction.apply(that._oCore, arguments);
				/**
				 * If we have 50 new elements in the core, don't send 50 new messages for
				 * dirty state instead wait 500ms and send one message.
				 */
				clearTimeout(that._dirtyTimeoutHandle);
				that._dirtyTimeoutHandle = setTimeout(function () {
					CommunicationBus.publish(channelNames.ON_CORE_STATE_CHANGE);
				}, notifyDirtyStateInterval);
			};
		};

		spyFunction("registerElement");
		spyFunction("deregisterElement");
	};

	Main.prototype._setCommunicationSubscriptions = function () {
		// If configuration contains 'silent' there must be no subscription
		// for temporary rules
		if (this._supportModeConfig.indexOf("silent") < 0) {
            CommunicationBus.subscribe(channelNames.VERIFY_CREATE_RULE, function (tempRuleSerialized) {
                var tempRule = RuleSerializer.deserialize(tempRuleSerialized),
                    tempRuleSet = this._mRuleSets[constants.TEMP_RULESETS_NAME].ruleset,
                    result = tempRuleSet.addRule(tempRule);
                CommunicationBus.publish(channelNames.VERIFY_RULE_CREATE_RESULT, {
                    result: result,
                    newRule: RuleSerializer.serialize(tempRule)
                });
            }, this);

			CommunicationBus.subscribe(channelNames.VERIFY_UPDATE_RULE, function (data) {
				var tempRule = RuleSerializer.deserialize(data.updateObj),
					tempRuleSet = this._mRuleSets[constants.TEMP_RULESETS_NAME].ruleset,
					result = tempRuleSet.updateRule(data.oldId, tempRule);
				CommunicationBus.publish(channelNames.VERIFY_RULE_UPDATE_RESULT, {
					result: result,
					updateRule: RuleSerializer.serialize(tempRule)
				});
			}, this);

			CommunicationBus.subscribe(channelNames.OPEN_URL, function (url) {
				var win = window.open(url, "_blank");
				win.focus();
			}, this);

			CommunicationBus.subscribe(channelNames.ON_DOWNLOAD_REPORT_REQUEST, function (reportConstants) {
				var data = this._getReportData(reportConstants);
				sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"], function (ReportProvider) {
					ReportProvider.downloadReportZip(data);
				});
			}, this);

			CommunicationBus.subscribe(channelNames.HIGHLIGHT_ELEMENT, function (id) {
				var $domElem = sap.ui.getCore().byId(id).$();
				$domElem.css("background-color", "red");
			}, this);

			CommunicationBus.subscribe(channelNames.TREE_ELEMENT_MOUSE_ENTER, function (elementId) {
				Highlighter.highlight(elementId);
			}, this);

			CommunicationBus.subscribe(channelNames.TREE_ELEMENT_MOUSE_OUT, function () {
				Highlighter.hideHighLighter();
			}, this);

			CommunicationBus.subscribe(channelNames.TOGGLE_FRAME_HIDDEN, function (hidden) {
				IFrameController.toggleHide(hidden);
			}, this);
		}

		CommunicationBus.subscribe(channelNames.GET_AVAILABLE_COMPONENTS, function () {
			CommunicationBus.publish(channelNames.POST_AVAILABLE_COMPONENTS, Object.keys(this._oCore.mObjects.component));
		}, this);

		CommunicationBus.subscribe(channelNames.ON_ANALYZE_REQUEST, function (data) {
			this.analyze(data.executionContext, data.selectedRules);
		}, this);

		CommunicationBus.subscribe(channelNames.ON_INIT_ANALYSIS_CTRL, function () {
			var onUpdateSupportRules = this._fetchSupportRuleSets(),
				that = this;

			onUpdateSupportRules.then(function () {
				that._fetchNonLoadedRuleSets();
			});
		}, this);

		CommunicationBus.subscribe(channelNames.ON_SHOW_REPORT_REQUEST, function (reportConstants) {
			var data = this._getReportData(reportConstants);
			sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"], function (ReportProvider) {
				ReportProvider.openReport(data);
			});
		}, this);

		CommunicationBus.subscribe(channelNames.LOAD_RULESETS, function (data) {
			var onUpdateRules = this._fetchSupportRuleSets(data.libNames),
				that = this;

			onUpdateRules.then(function () {
				that._fetchNonLoadedRuleSets();
			});
		}, this);
	};

	Main.prototype._getLoadFromSupportOrigin = function () {
		var loadFromSupportOrigin = false;

		var coreUri = new window.URI(jQuery.sap.getModulePath("sap.ui.core"));
		var supportUri = new window.URI(jQuery.sap.getModulePath("sap.ui.support"));

		// If loading support tool from different origin,
		// i.e. protocol or host (host name + port) different
		if (coreUri.protocol() !== supportUri.protocol() || coreUri.host() !== supportUri.host()) {
			loadFromSupportOrigin = true;
		}

		return loadFromSupportOrigin;
	};

	Main.prototype._fetchLibraryFiles = function (libNames, fnProcessFile) {
		var ajaxPromises = [],
			that = this;

		var supportModulePath = jQuery.sap.getModulePath("sap.ui.support");
		var supportModulesRoot = supportModulePath.replace("sap/ui/support", "");

		libNames.forEach(function (libName) {
			var libPath = libName.replace(/\./g, "/");

			var customizableLibName = libName;
			var loadFromSupportOrigin = that._getLoadFromSupportOrigin();

			// Prepare modules root string
			if (loadFromSupportOrigin) {
				// In order to avoid module name collision
				// we need to generate an internal library name
				customizableLibName += '.' + customSuffix;

				jQuery.sap.registerModulePath(customizableLibName, supportModulesRoot + libName.replace(/\./g, "/"));
			}

			var internalLibName = customizableLibName + '.internal';
			var libraryInternalResourceRoot = supportModulesRoot.replace('resources/', '') + 'test-resources/' + libPath + '/internal';

			jQuery.sap.registerModulePath(internalLibName, libraryInternalResourceRoot);

			if (that._mRuleSets[libName]) {
				return;
			}

			// CHECK FOR INTERNAL RULES
			ajaxPromises.push(new Promise(function (resolve) {
				try {
					sap.ui.require([(internalLibName).replace(/\./g, "/") + "/library.support"], function () {
						fnProcessFile(internalLibName);
						resolve();
					});
				} catch (ex) {
					resolve();
				}
			}));

			// CHECK FOR PUBLIC RULES
			ajaxPromises.push(new Promise(function (resolve) {
				try {
					sap.ui.require([customizableLibName.replace(/\./g, "/") + "/library.support"], function () {
						fnProcessFile(customizableLibName);
						resolve();
					});
				} catch (ex) {
					resolve();
				}
			}));
		});

		return ajaxPromises;
	};

	/**
	 * Factory function for creating a RuleSet. Helps reducing API complexity.
	 * @private
	 * @param {object} librarySupport object to be used for RuleSet creation
	 * @returns {object} ruleset object to be added to _mRuleSets
	 */
	Main.prototype._createRuleSet = function (librarySupport) {
		var oLib = {
			name: librarySupport.name,
			niceName: librarySupport.niceName
		};
		var oRuleSet = new RuleSet(oLib);

		for (var i = 0; i < librarySupport.ruleset.length; i++) {
			var ruleset = librarySupport.ruleset[i];

			// If the ruleset contains arrays of rules make sure we add them.
			if (jQuery.isArray(ruleset)) {
				for (var k = 0; k < ruleset.length; k++) {
					oRuleSet.addRule(ruleset[k]);
				}
			} else {
				oRuleSet.addRule(ruleset);
			}
		}

		return {
			lib: oLib,
			ruleset: oRuleSet
		};
	};

	Main.prototype._fetchSupportRuleSets = function (libNames) {
		libNames = libNames || [];
		libNames = libNames.concat(Object.keys(sap.ui.getCore().getLoadedLibraries()));

		var that = this;

		var mainPromise = new Promise(function (resolve) {
			sap.ui.getVersionInfo({async: true}).then(function (versionInfo) {
				// VersionInfo cache
				that._versionInfo = versionInfo;
				RuleSet.versionInfo = versionInfo;

				var libFetchPromises = that._fetchLibraryFiles(libNames, function (libName) {
					var normalizedLibName = libName.replace("." + customSuffix, "").replace(".internal", ""),
						libSupport = jQuery.sap.getObject(libName).library.support,
						library = that._mRuleSets[normalizedLibName];

					if (libSupport.ruleset instanceof RuleSet) {
						if (library) {
							library.ruleset._mRules = jQuery.extend(library.ruleset._mRules, libSupport.ruleset._mRules);
						} else {
							library = libSupport;
						}
					} else {
						if (library) {
							library.ruleset._mRules = jQuery.extend(library.ruleset._mRules, that._createRuleSet(libSupport));
						} else {
							library = that._createRuleSet(libSupport);
						}
					}

					that._mRuleSets[normalizedLibName] = library;
				});

				Promise.all(libFetchPromises).then(function () {
					//if (!that._rulesCreated) {
						that._rulesCreated = true;

						CommunicationBus.publish(channelNames.UPDATE_SUPPORT_RULES, RuleSerializer.serialize(that._mRuleSets));
					//}

					resolve();
				});
			});
		});

		return mainPromise;
	};

	Main.prototype._fetchNonLoadedRuleSets = function () {
		var libs = this._versionInfo.libraries,
			data = [];

		var libNames = libs.map(function (lib) {
			return lib.name;
		});

		var libFetchPromises = this._fetchLibraryFiles(libNames, function (libName) {
			libName = libName.replace("." + customSuffix, "").replace(".internal", "");

			if (data.indexOf(libName) < 0) {
				data.push(libName);
			}
		});

		Promise.all(libFetchPromises).then(function () {
			CommunicationBus.publish(channelNames.POST_AVAILABLE_LIBRARIES,{
				libNames: data
			});
		});
	};

	Main.prototype._initTempRulesLib = function () {
		if (this._mRuleSets[constants.TEMP_RULESETS_NAME]) {
			return;
		}

		this._mRuleSets[constants.TEMP_RULESETS_NAME] = {
			lib: {
				name: constants.TEMP_RULESETS_NAME
			},
			ruleset: new RuleSet({
				name: constants.TEMP_RULESETS_NAME
			})
		};

	};

	/**
	 * @param {object} executionScope - The execution scope of the analysis
	 * @param {array} ruleDescriptors - An array with rules against which the analysis will be run
	 * @returns {promise} to notify of finished state
	 */
	Main.prototype.analyze = function (executionScope, ruleDescriptors) {
		var that = this;

		if (this._oAnalyzer && this._oAnalyzer.running()) {
			return;
		}

		// Validations
		if (executionScope && ExecutionScope.possibleScopes.indexOf(executionScope.type) === -1) {
			jQuery.sap.log.error("Invalid execution scope type. Type must be one of the following: "
				+ ExecutionScope.possibleScopes.join(", "));
			return;
		}

		// When analyze is called as an API function there is a selectors property
		// which is used to reduce complexity of the API function
		// selectors is mapped to parentId and components.
		if (executionScope && executionScope.selectors) {
			this._mapExecutionScope(executionScope);
		}

		// Set default scope
		executionScope = executionScope || {type: "global"};

		this._oAnalyzer.reset();

		this.setExecutionScope(executionScope);

		if (Array.isArray(ruleDescriptors)) {
			// If there are 0 rules don't add tasks.
			if (ruleDescriptors.length > 0) {
				this._addTasksForSelectedRules(ruleDescriptors);
			}
		} else {
			this._addTasksForAllRules();
		}

		IssueManager.clearIssues();

		return new Promise(function (resolve) {
			that._oAnalyzer.start(resolve);
		});
	};

	Main.prototype._addTasksForSelectedRules = function (ruleDescriptors) {
		var that = this;

		this._oSelectedRulesIds = {};

		ruleDescriptors.forEach(function (ruleDescriptor) {
			var libWithRules = that._mRuleSets[ruleDescriptor.libName],
				executedRule = libWithRules.ruleset.getRules()[ruleDescriptor.ruleId];
			that._oAnalyzer.addTask([executedRule.title], function (oObject) {
				that._analyzeSupportRule(oObject);
			}, [executedRule]);
			that._oSelectedRulesIds[ruleDescriptor.ruleId] = true;
		});
	};

	Main.prototype._addTasksForAllRules = function () {
		var that = this;

		Object.keys(that._mRuleSets).map(function (libName) {
			var rulesetRules = that._mRuleSets[libName].ruleset.getRules();
			Object.keys(rulesetRules).map(function (ruleId) {
				var rule = rulesetRules[ruleId];
				that._oAnalyzer.addTask([rule.title], function (oObject) {
					that._analyzeSupportRule(oObject);
				}, [rule]);
			});
		});
	};

	Main.prototype.setExecutionScope = function (settings) {
		this._oExecutionScope = ExecutionScope(this._oCore, settings);
	};

	// Map the execution scope selectors property to parentId and components.
	// Doing this internally to reduce API complexity.
	Main.prototype._mapExecutionScope = function (executionScope) {
		if (executionScope.type === "subtree") {
			if (typeof executionScope.selectors === "string") {
				executionScope.parentId = executionScope.selectors;
			} else if (Array.isArray(executionScope.selectors)) {
				executionScope.parentId = executionScope.selectors[0];
			}
		} else if (executionScope.type === "components") {
			if (typeof executionScope.selectors === "string") {
				executionScope.components = [executionScope.selectors];
			} else if (Array.isArray(executionScope.selectors)) {
				executionScope.components = executionScope.selectors;
			}
		}

		delete executionScope.selectors;
	};

	/**
	 * Called after the analyzer finished and reports whether there are issues or not.
	 */
	Main.prototype._done = function () {
		var issues = IssueManager.getIssuesViewModel(),
			elementTree = this._createElementTree();

		CommunicationBus.publish(channelNames.ON_ANALYZE_FINISH, {
			issues: issues,
			elementTree: elementTree,
			elapsedTime: this._oAnalyzer.getElapsedTimeString()
		});

		this._oAnalyzer.resolve();
	};

	Main.prototype._createElementTree = function () {
		var contextElements = this._copyElementsStructure(),
			elementTree = [];

		this._setContextElementReferences(contextElements);

		for (var i in contextElements) {
			if (contextElements[i].skip) {
				continue;
			}
			elementTree.push(contextElements[i]);
		}

		return [{
			content: elementTree,
			id: "WEBPAGE",
			name: "WEBPAGE"
		}];
	};

	Main.prototype._setContextElementReferences = function (contextElements) {
		var coreElements = this._oCore.mElements;

		for (var elementId in contextElements) {
			var element = contextElements[elementId],
				parent = coreElements[elementId] == undefined ? undefined : coreElements[elementId].getParent();

			if (coreElements[elementId] instanceof sap.ui.core.ComponentContainer) {
				var componentContainer = coreElements[elementId],
					componentId = componentContainer.getComponent();
				if (componentId) {
					element.content.push(contextElements[componentId]);
					contextElements[componentId].skip = true;
				}
			}

			if (parent) {
				var parentId = parent.getId();
				if (!contextElements[parentId]) {
					continue;
				}
				contextElements[parentId].content.push(contextElements[elementId]);
				contextElements[elementId].skip = true;
			}
		}
	};

	// TODO: the element crushing needs to be encapsulated on it's own
	Main.prototype._copyElementsStructure = function () {
		var copy = {},
			that = this;

		var copyElementsFromCoreObject = function (coreObject, elemNames) {
			for (var i in coreObject) {
				if (coreObject.hasOwnProperty(i)) {
					var element = coreObject[i];
					var elementCopy = {
						content: [],
						id: element.getId(),
						name: (elemNames == undefined) ? element.getMetadata().getName() : elemNames
					};
					copy[element.getId()] = elementCopy;
				}
			}
		};

		copyElementsFromCoreObject(this._oExecutionScope.getElements());

		this._oExecutionScope.getElements().forEach(function (element) {
			if (element instanceof sap.ui.core.ComponentContainer) {
				var componentId = element.getComponent(),
					component = that._oCore.mObjects.component[componentId];
				if (component) {
					copyElementsFromCoreObject([component], "sap-ui-component");
				}
			}
		});

		// TODO: we need to make those "case"s using constants
		switch (this._oExecutionScope._getType()) {
			case "global":
				copyElementsFromCoreObject(this._oCoreFacade.getUIAreas(), "sap-ui-area");
				copyElementsFromCoreObject(this._oCoreFacade.getComponents(), "sap-ui-component");
				break;

			case "subtree":
				var parentId = this._oExecutionScope._getContext().parentId;
				copyElementsFromCoreObject([this._oCore.mElements[parentId]]);
				break;

			case "components":
				var components = this._oExecutionScope._getContext().components;
				components.forEach(function (componentId) {
					copyElementsFromCoreObject([that._oCore.mObjects.component[componentId]], "sap-ui-component");
				});
				break;
		}

		return copy;
	};

	/**
	 * Used to create a data object for the report.
	 *
	 * @param {object} reportConstants - the string constants used in the report and in the Support Tools UI.
	 * @return {object} contains all the information required to create a report.
	 */
	Main.prototype._getReportData = function (reportConstants) {
		var issues = IssueManager.groupIssues(IssueManager.getIssuesViewModel());

		return {
			issues: issues,
			technical: this._oDataCollector.getTechInfoJSON(),
			application: this._oDataCollector.getAppInfo(),
			rules: IssueManager.getRulesViewModel(this._mRulesets, this._oSelectedRulesIds, issues),
			scope: {
				executionScope: this._oExecutionScope,
				scopeDisplaySettings: {
					executionScopes: reportConstants.executionScopes,
					executionScopeTitle: reportConstants.executionScopeTitle
				}
			},
			analysisDuration: this._oAnalyzer.getElapsedTimeString(),
			analysisDurationTitle: reportConstants.analysisDurationTitle,
			name: constants.SUPPORT_ASSISTANT_NAME
		};
	};

	/**
	 * Callback for checking a support rule from the analyzer
	 *
	 * @param oRule
	 */
	Main.prototype._analyzeSupportRule = function (oRule) {
		try {
			oRule.check(IssueManager.createIssueManagerFacade(oRule), this._oCoreFacade, this._oExecutionScope);
		} catch (ruleExecException) {
			var sMessage = "[" + constants.SUPPORT_ASSISTANT_NAME + "] Error while execution rule \"" + oRule.id +
				"\": " + ruleExecException.message;
			jQuery.sap.log.error(sMessage);
		}

		CommunicationBus.publish(channelNames.ON_PROGRESS_UPDATE, {
			currentProgress: this._oAnalyzer.getProgress()
		});

		if (this._iDoneTimer) {
			jQuery.sap.clearDelayedCall(this._iDoneTimer);
		}

		this._iDoneTimer = jQuery.sap.delayedCall(100, this, "_done");
	};

	var oMain = new Main();

	return oMain;

}, true);

}; // end of sap/ui/support/supportRules/Main.js
if ( !jQuery.sap.isDeclared('sap.ui.support.Bootstrap') ) {
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.support.Bootstrap.
jQuery.sap.declare('sap.ui.support.Bootstrap'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/support/Bootstrap",["jquery.sap.global", "./library", "sap/ui/support/supportRules/Main"],
	function (jQuery, library, Main) {
		"use strict";

	var Bootstrap = {
		initSupportRules: function (settings) {
			if (settings[0].toLowerCase() === "true" || settings[0].toLowerCase() === "silent") {
				Main.startPlugin(settings);
				/**
				 * Enables the additional logging capabilites of the logger,
				 * allowing the developers to pass custom data, that is later going to be added
				 * to the executionScope of the rules
				 */
				if ('logSupportInfo' in jQuery.sap.log) {
					jQuery.sap.log.logSupportInfo(true);
				}
			}
		}
	};

	return Bootstrap;
});

}; // end of sap/ui/support/Bootstrap.js
