/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/model/json/JSONModel","sap/ui/support/supportRules/Analyzer","sap/ui/support/supportRules/CoreFacade","sap/ui/support/supportRules/ExecutionScope","sap/ui/support/supportRules/Highlighter","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/RuleSerializer","sap/ui/support/supportRules/RuleSet","sap/ui/support/supportRules/IssueManager","sap/ui/support/supportRules/report/DataCollector","sap/ui/support/supportRules/WCBChannels","sap/ui/support/supportRules/Constants"],function(q,M,J,A,C,E,H,a,R,b,I,D,c,d){"use strict";var f=null;var m=null;var g='sprt';var h=M.extend("sap.ui.support.Main",{constructor:function(){if(!m){var t=this;this._oCore=null;this._rulesCreated=false;this._mRuleSets={};this._oAnalyzer=new A();t._initTempRulesLib();M.apply(this,arguments);q.sap.support={analyze:function(i,r){return m.analyze(i,r);},getAnalysisHistory:function(){if(t._oAnalyzer.running()){return null;}return I.getHistory();},getFormattedAnalysisHistory:function(){if(t._oAnalyzer.running()){return;}return new Promise(function(r,i){sap.ui.require(["sap/ui/support/supportRules/report/AnalysisHistoryFormatter"],function(j){r(j.format(I.getConvertedHistory()));});});}};var e=document.createEvent("CustomEvent");e.initCustomEvent("supportToolLoaded",true,true,{});}else{q.sap.log.warning("Only one support tool allowed");return m;}}});h.prototype._isInIframe=function(){try{return window.self!==window.top;}catch(e){return true;}};h.prototype.startPlugin=function(s){if(this._pluginStarted){return;}this._pluginStarted=true;var t=this;sap.ui.getCore().registerPlugin({startPlugin:function(o){t._supportModeConfig=s=s||o.getConfiguration().getSupportMode();t._setCommunicationSubscriptions();var F=t._isInIframe()&&s.indexOf("frame-force-ui")!==-1;t._oCore=o;t._oDataCollector=new D(o);t._oCoreFacade=C(o);t._oExecutionScope=null;t._createCoreSpies();o.attachLibraryChanged(t._onLibraryChanged,t);if(!s||s.indexOf("silent")===-1||F){sap.ui.require(["sap/ui/support/supportRules/ui/IFrameController"],function(e){f=e;f.injectFrame(s);a.onMessageChecks.push(function(i){return i.origin===f.getFrameOrigin();});a.onMessageChecks.push(function(i){return i.data._frameIdentifier===f.getFrameIdentifier();});a.onMessageChecks.push(function(i){var j=f.getFrameUrl();j=j.replace(/\.\.\//g,'');return i.data._origin.indexOf(j)>-1;});});}else{t._fetchSupportRuleSets();}},stopPlugin:function(){f._stop();t._pluginStarted=false;t._oCore=null;t._oCoreFacade=null;t._oDataCollector=null;t._oExecutionScope=null;}});};h.prototype._onLibraryChanged=function(e){if(e.getParameter("stereotype")==="library"&&this._rulesCreated){var t=this;this._fetchSupportRuleSets().then(function(){t._fetchNonLoadedRuleSets();});}};h.prototype._createCoreSpies=function(){var t=this,n=500;this._dirtyTimeoutHandle=null;var s=function(N){var o=t._oCore[N];t._oCore[N]=function(){o.apply(t._oCore,arguments);clearTimeout(t._dirtyTimeoutHandle);t._dirtyTimeoutHandle=setTimeout(function(){a.publish(c.ON_CORE_STATE_CHANGE);},n);};};s("registerElement");s("deregisterElement");};h.prototype._setCommunicationSubscriptions=function(){if(this._supportModeConfig.indexOf("silent")<0){a.subscribe(c.VERIFY_CREATE_RULE,function(t){var e=R.deserialize(t),i=this._mRuleSets[d.TEMP_RULESETS_NAME].ruleset,r=i.addRule(e);a.publish(c.VERIFY_RULE_CREATE_RESULT,{result:r,newRule:R.serialize(e)});},this);a.subscribe(c.VERIFY_UPDATE_RULE,function(e){var t=R.deserialize(e.updateObj),i=this._mRuleSets[d.TEMP_RULESETS_NAME].ruleset,r=i.updateRule(e.oldId,t);a.publish(c.VERIFY_RULE_UPDATE_RESULT,{result:r,updateRule:R.serialize(t)});},this);a.subscribe(c.OPEN_URL,function(u){var w=window.open(u,"_blank");w.focus();},this);a.subscribe(c.ON_DOWNLOAD_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(i){i.downloadReportZip(e);});},this);a.subscribe(c.HIGHLIGHT_ELEMENT,function(i){var $=sap.ui.getCore().byId(i).$();$.css("background-color","red");},this);a.subscribe(c.TREE_ELEMENT_MOUSE_ENTER,function(e){H.highlight(e);},this);a.subscribe(c.TREE_ELEMENT_MOUSE_OUT,function(){H.hideHighLighter();},this);a.subscribe(c.TOGGLE_FRAME_HIDDEN,function(e){f.toggleHide(e);},this);}a.subscribe(c.GET_AVAILABLE_COMPONENTS,function(){a.publish(c.POST_AVAILABLE_COMPONENTS,Object.keys(this._oCore.mObjects.component));},this);a.subscribe(c.ON_ANALYZE_REQUEST,function(e){this.analyze(e.executionContext,e.selectedRules);},this);a.subscribe(c.ON_INIT_ANALYSIS_CTRL,function(){var o=this._fetchSupportRuleSets(),t=this;o.then(function(){t._fetchNonLoadedRuleSets();});},this);a.subscribe(c.ON_SHOW_REPORT_REQUEST,function(r){var e=this._getReportData(r);sap.ui.require(["sap/ui/support/supportRules/report/ReportProvider"],function(i){i.openReport(e);});},this);a.subscribe(c.LOAD_RULESETS,function(e){var o=this._fetchSupportRuleSets(e.libNames),t=this;o.then(function(){t._fetchNonLoadedRuleSets();});},this);};h.prototype._getLoadFromSupportOrigin=function(){var l=false;var e=new window.URI(q.sap.getModulePath("sap.ui.core"));var s=new window.URI(q.sap.getModulePath("sap.ui.support"));if(e.protocol()!==s.protocol()||e.host()!==s.host()){l=true;}return l;};h.prototype._fetchLibraryFiles=function(l,p){var e=[],t=this;var s=q.sap.getModulePath("sap.ui.support");var i=s.replace("sap/ui/support","");l.forEach(function(j){var k=j.replace(/\./g,"/");var n=j;var o=t._getLoadFromSupportOrigin();if(o){n+='.'+g;q.sap.registerModulePath(n,i+j.replace(/\./g,"/"));}var r=n+'.internal';var u=i.replace('resources/','')+'test-resources/'+k+'/internal';q.sap.registerModulePath(r,u);if(t._mRuleSets[j]){return;}e.push(new Promise(function(v){try{sap.ui.require([(r).replace(/\./g,"/")+"/library.support"],function(){p(r);v();});}catch(w){v();}}));e.push(new Promise(function(v){try{sap.ui.require([n.replace(/\./g,"/")+"/library.support"],function(){p(n);v();});}catch(w){v();}}));});return e;};h.prototype._createRuleSet=function(l){var L={name:l.name,niceName:l.niceName};var r=new b(L);for(var i=0;i<l.ruleset.length;i++){var e=l.ruleset[i];if(q.isArray(e)){for(var k=0;k<e.length;k++){r.addRule(e[k]);}}else{r.addRule(e);}}return{lib:L,ruleset:r};};h.prototype._fetchSupportRuleSets=function(l){l=l||[];l=l.concat(Object.keys(sap.ui.getCore().getLoadedLibraries()));var t=this;var e=new Promise(function(r){sap.ui.getVersionInfo({async:true}).then(function(v){t._versionInfo=v;b.versionInfo=v;var i=t._fetchLibraryFiles(l,function(j){var n=j.replace("."+g,"").replace(".internal",""),k=q.sap.getObject(j).library.support,o=t._mRuleSets[n];if(k.ruleset instanceof b){if(o){o.ruleset._mRules=q.extend(o.ruleset._mRules,k.ruleset._mRules);}else{o=k;}}else{if(o){o.ruleset._mRules=q.extend(o.ruleset._mRules,t._createRuleSet(k));}else{o=t._createRuleSet(k);}}t._mRuleSets[n]=o;});Promise.all(i).then(function(){t._rulesCreated=true;a.publish(c.UPDATE_SUPPORT_RULES,R.serialize(t._mRuleSets));r();});});});return e;};h.prototype._fetchNonLoadedRuleSets=function(){var l=this._versionInfo.libraries,e=[];var i=l.map(function(k){return k.name;});var j=this._fetchLibraryFiles(i,function(k){k=k.replace("."+g,"").replace(".internal","");if(e.indexOf(k)<0){e.push(k);}});Promise.all(j).then(function(){a.publish(c.POST_AVAILABLE_LIBRARIES,{libNames:e});});};h.prototype._initTempRulesLib=function(){if(this._mRuleSets[d.TEMP_RULESETS_NAME]){return;}this._mRuleSets[d.TEMP_RULESETS_NAME]={lib:{name:d.TEMP_RULESETS_NAME},ruleset:new b({name:d.TEMP_RULESETS_NAME})};};h.prototype.analyze=function(e,r){var t=this;if(this._oAnalyzer&&this._oAnalyzer.running()){return;}if(e&&E.possibleScopes.indexOf(e.type)===-1){q.sap.log.error("Invalid execution scope type. Type must be one of the following: "+E.possibleScopes.join(", "));return;}if(e&&e.selectors){this._mapExecutionScope(e);}e=e||{type:"global"};this._oAnalyzer.reset();this.setExecutionScope(e);if(Array.isArray(r)){if(r.length>0){this._addTasksForSelectedRules(r);}}else{this._addTasksForAllRules();}I.clearIssues();return new Promise(function(i){t._oAnalyzer.start(i);});};h.prototype._addTasksForSelectedRules=function(r){var t=this;this._oSelectedRulesIds={};r.forEach(function(e){var l=t._mRuleSets[e.libName],i=l.ruleset.getRules()[e.ruleId];t._oAnalyzer.addTask([i.title],function(o){t._analyzeSupportRule(o);},[i]);t._oSelectedRulesIds[e.ruleId]=true;});};h.prototype._addTasksForAllRules=function(){var t=this;Object.keys(t._mRuleSets).map(function(l){var r=t._mRuleSets[l].ruleset.getRules();Object.keys(r).map(function(e){var i=r[e];t._oAnalyzer.addTask([i.title],function(o){t._analyzeSupportRule(o);},[i]);});});};h.prototype.setExecutionScope=function(s){this._oExecutionScope=E(this._oCore,s);};h.prototype._mapExecutionScope=function(e){if(e.type==="subtree"){if(typeof e.selectors==="string"){e.parentId=e.selectors;}else if(Array.isArray(e.selectors)){e.parentId=e.selectors[0];}}else if(e.type==="components"){if(typeof e.selectors==="string"){e.components=[e.selectors];}else if(Array.isArray(e.selectors)){e.components=e.selectors;}}delete e.selectors;};h.prototype._done=function(){var i=I.getIssuesViewModel(),e=this._createElementTree();a.publish(c.ON_ANALYZE_FINISH,{issues:i,elementTree:e,elapsedTime:this._oAnalyzer.getElapsedTimeString()});this._oAnalyzer.resolve();};h.prototype._createElementTree=function(){var e=this._copyElementsStructure(),j=[];this._setContextElementReferences(e);for(var i in e){if(e[i].skip){continue;}j.push(e[i]);}return[{content:j,id:"WEBPAGE",name:"WEBPAGE"}];};h.prototype._setContextElementReferences=function(e){var i=this._oCore.mElements;for(var j in e){var k=e[j],p=i[j]==undefined?undefined:i[j].getParent();if(i[j]instanceof sap.ui.core.ComponentContainer){var l=i[j],n=l.getComponent();if(n){k.content.push(e[n]);e[n].skip=true;}}if(p){var o=p.getId();if(!e[o]){continue;}e[o].content.push(e[j]);e[j].skip=true;}}};h.prototype._copyElementsStructure=function(){var e={},t=this;var j=function(l,n){for(var i in l){if(l.hasOwnProperty(i)){var o=l[i];var r={content:[],id:o.getId(),name:(n==undefined)?o.getMetadata().getName():n};e[o.getId()]=r;}}};j(this._oExecutionScope.getElements());this._oExecutionScope.getElements().forEach(function(i){if(i instanceof sap.ui.core.ComponentContainer){var l=i.getComponent(),n=t._oCore.mObjects.component[l];if(n){j([n],"sap-ui-component");}}});switch(this._oExecutionScope._getType()){case"global":j(this._oCoreFacade.getUIAreas(),"sap-ui-area");j(this._oCoreFacade.getComponents(),"sap-ui-component");break;case"subtree":var p=this._oExecutionScope._getContext().parentId;j([this._oCore.mElements[p]]);break;case"components":var k=this._oExecutionScope._getContext().components;k.forEach(function(i){j([t._oCore.mObjects.component[i]],"sap-ui-component");});break;}return e;};h.prototype._getReportData=function(r){var i=I.groupIssues(I.getIssuesViewModel());return{issues:i,technical:this._oDataCollector.getTechInfoJSON(),application:this._oDataCollector.getAppInfo(),rules:I.getRulesViewModel(this._mRulesets,this._oSelectedRulesIds,i),scope:{executionScope:this._oExecutionScope,scopeDisplaySettings:{executionScopes:r.executionScopes,executionScopeTitle:r.executionScopeTitle}},analysisDuration:this._oAnalyzer.getElapsedTimeString(),analysisDurationTitle:r.analysisDurationTitle,name:d.SUPPORT_ASSISTANT_NAME};};h.prototype._analyzeSupportRule=function(r){try{r.check(I.createIssueManagerFacade(r),this._oCoreFacade,this._oExecutionScope);}catch(e){var s="["+d.SUPPORT_ASSISTANT_NAME+"] Error while execution rule \""+r.id+"\": "+e.message;q.sap.log.error(s);}a.publish(c.ON_PROGRESS_UPDATE,{currentProgress:this._oAnalyzer.getProgress()});if(this._iDoneTimer){q.sap.clearDelayedCall(this._iDoneTimer);}this._iDoneTimer=q.sap.delayedCall(100,this,"_done");};var m=new h();return m;},true);
