/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/mvc/Controller","sap/ui/model/json/JSONModel","sap/ui/support/supportRules/WindowCommunicationBus","sap/ui/support/supportRules/ui/models/SharedModel","sap/ui/support/supportRules/ElementTree","sap/ui/support/supportRules/WCBChannels"],function($,C,J,a,S,E,c){"use strict";var i={severitytexts:{High:"High",Medium:"Medium",Low:"Low",All:"All Severities"},severitystates:{High:"Error",Medium:"Warning",Low:"None",All:"None"},severityicons:{High:"sap-icon://message-error",Medium:"sap-icon://message-warning",Low:"sap-icon://message-information",All:"sap-icon://multiselect-all"}};return C.extend("sap.ui.support.supportRules.ui.controllers.Issues",{ISSUES_LIMIT:1000,onInit:function(){a.subscribe(c.ON_ANALYZE_FINISH,function(d){var t=this;var p={};t.data=d;d.issues.forEach(function(b){if(!b.context||!b.context.id){return;}if(!p[b.context.id]){p[b.context.id]=[b.name];}else{p[b.context.id].push(b.name);}});this.model.setSizeLimit(this.ISSUES_LIMIT);this.model.setProperty("/issues",d.issues);this.model.setProperty("/maxIssuesDisplayedNumber",Math.min(this.ISSUES_LIMIT,d.issues.length));this.model.setProperty('/analyzePressed',true);this.model.setProperty("/visibleIssuesCount",d.issues.length);this.elementTree.setData({controls:d.elementTree,issuesIds:p});this.clearFilters();this._selectFirstVisibleIssue();},this);this.model=S;this.getView().setModel(this.model);this.clearFilters();this._initElementTree();},_initElementTree:function(){var t=this;this.elementTree=new E(null,{onIssueCountClicked:function(s){t.clearFilters();t.model.setProperty("/elementFilter",s);t.updateIssuesVisibility();t._selectFirstVisibleIssue();},onHoverChanged:function(h){a.publish(c.TREE_ELEMENT_MOUSE_ENTER,h);},onMouseOut:function(){a.publish(c.TREE_ELEMENT_MOUSE_OUT);}});},onAfterRendering:function(){this.elementTree.setContainerId(this.getView().byId("elementTreeContainer").getId());},clearFilters:function(){this.model.setProperty("/severityFilter","All");this.model.setProperty("/categoryFilter","All");this.model.setProperty("/elementFilter","All");this.model.setProperty("/audienceFilter","All");if(this.data){this.model.setProperty("/issues",this.data.issues);this.setToolbarHeight();}this.updateIssuesVisibility();},clearFiltersAndElementSelection:function(){this.clearFilters();this.elementTree.clearSelection();},onIssuePressed:function(e){var p=e.mParameters.listItem,s=p.getBindingContext().getObject();this.model.setProperty("/selectedIssue",s);this.elementTree.setSelectedElement(s.context.id,false);},openDocumentation:function(e){var l=sap.ui.getCore().byId(e.mParameters.id),u=l.getBindingContext().getProperty("href");a.publish(c.OPEN_URL,u);},updateIssuesVisibility:function(){var v=0;var b=this.getView().byId("issuesList");if(this.data){var f=this.data.issues.filter(this.filterIssueListItems,this);this.model.setProperty("/issues",f);this.model.setProperty("/maxIssuesDisplayedNumber",Math.min(this.ISSUES_LIMIT,f.length));}this.setToolbarHeight();b.getItems().forEach(function(d){d.updateProperty("visible");});b.getItems().forEach(function(d){if(d.getVisible()){v++;}});this.model.setProperty("/visibleIssuesCount",v);},_selectFirstVisibleIssue:function(){var l=this.getView().byId("issuesList"),b=l.getVisibleItems();if(b.length>0){l.setSelectedItem(b[0]);this.model.setProperty("/selectedIssue",b[0].getBindingContext().getObject());}},filterIssueListItems:function(b){var s=this.model.getProperty("/severityFilter"),d=b.severity===s||s==='All',e=this.model.getProperty("/categoryFilter"),f=$.inArray(e,b.categories)>-1||e==='All',g=this.model.getProperty("/elementFilter"),h=g===b.context.id||g==='All',j=this.model.getProperty("/audienceFilter"),k=$.inArray(j,b.audiences)>-1||j==='All';return d&&f&&h&&k;},filterSevirityIcon:function(v){return i.severityicons[v];},filterSevirityState:function(v){return i.severitystates[v];},filterSevirityText:function(v){return i.severitytexts[v];},setToolbarHeight:function(){var b=this.model.getProperty("/issues");if(b&&b.length>this.ISSUES_LIMIT){this.model.setProperty("/filterBarHeight","3.5rem");this.model.setProperty("/messegeStripHeight","2.5rem");}else{this.model.setProperty("/filterBarHeight","4rem");this.model.setProperty("/messegeStripHeight","2rem");}},onReportPress:function(e){var I=e.getParameter("item"),b=I.getText(),d=this._getReportData();if(b==='View'){a.publish(c.ON_SHOW_REPORT_REQUEST,d);}else{a.publish(c.ON_DOWNLOAD_REPORT_REQUEST,d);}},_getReportData:function(){return{executionScopes:this.model.getProperty("/executionScopes"),executionScopeTitle:this.model.getProperty("/executionScopeTitle"),analysisDurationTitle:this.model.getProperty("/analysisDurationTitle")};}});});
