/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./library','./TableExtension','./TableAccRenderExtension','./TableUtils'],function(q,C,l,T,a,b){"use strict";var S=l.SelectionMode;var A={getAccInfoOfControl:function(o,B){if(o&&typeof o.getAccessibilityInfo==="function"){if(typeof o.getVisible==="function"&&!o.getVisible()){return A._normalize({});}var s=o.getAccessibilityInfo();if(s){var t={};A._flatten(s,t,B);return t;}}return null;},_normalize:function(i){if(!i){return null;}if(i._normalized){return i;}i.role=i.role||"";i.type=i.type||"";i.description=i.description||"";i.focusable=!!i.focusable;i.enabled=(i.enabled===true||i.enabled===false)?i.enabled:null;i.editable=(i.editable===true||i.editable===false)?i.editable:null;i.children=i.children||[];i._normalized=true;return i;},_flatten:function(s,t,B,L){L=L?L:0;A._normalize(s);if(L==0){A._normalize(t);t._descriptions=[];}t.focusable=t.focusable||s.focusable;t._descriptions.push(A._getFullDescription(s,B));s.children.forEach(function(o){if(!o.getAccessibilityInfo||(o.getVisible&&!o.getVisible())){return;}var d=o.getAccessibilityInfo();if(d){A._flatten(d,t,B,L+1);}});if(L==0){t.description=t._descriptions.join(" ").trim();t._descriptions=undefined;}},_getFullDescription:function(i,B){var d=i.type+" "+i.description;if(i.enabled!=null&&!i.enabled){d=d+" "+B.getText("TBL_CTRL_STATE_DISABLED");}else if(i.editable!=null&&!i.editable){d=d+" "+B.getText("TBL_CTRL_STATE_READONLY");}return d.trim();}};var E={getColumnIndexOfFocusedCell:function(e){var t=e.getTable();var i=b.getFocusedItemInfo(t);return i.cellInRow-(b.hasRowHeader(t)?1:0);},getInfoOfFocusedCell:function(e){var t=e.getTable();var i=t._getItemNavigation();var o=t.getDomRef();if(!e.getAccMode()||!o||!i){return null;}var d=i.getFocusedDomRef();if(!d||d!==document.activeElement){return null;}return b.getCellInfo(d);},getRelevantColumnHeaders:function(t,o){if(!t||!o){return[];}var h=b.getHeaderRowCount(t),s=o.getId(),L=[s];if(h>1){for(var i=1;i<h;i++){L.push(s+"_"+i);}var d=b.Column.getParentSpannedColumns(t,s);if(d&&d.length){for(var i=0;i<d.length;i++){var e=d[i].level;var p=d[i].column.getId();L[e]=e===0?p:(p+"_"+e);}}}return L;},isHiddenCell:function($,o){var g=b.Grouping.isInGroupingRow($);var s=b.Grouping.isInSumRow($);var d=!!o&&!!o.hasStyleClass;var i=$.parent().hasClass("sapUiTableRowHidden");var I=$.hasClass("sapUiTableCellHidden");var n=g&&$.hasClass("sapUiTableTdFirst")&&!$.hasClass("sapUiTableMeasureCell");var G=g&&d&&o.hasStyleClass("sapUiAnalyticalTableGroupCellHidden");var e=s&&d&&o.hasStyleClass("sapUiAnalyticalTableSumCellHidden");return i||I||n||G||e;},isTreeColumnCell:function(e,$){return b.Grouping.isTreeMode(e.getTable())&&$.hasClass("sapUiTableTdFirst");},getColumnTooltip:function(o){if(!o){return null;}var t=o.getTooltip_AsString();if(t){return t;}var L=o.getLabel();if(L instanceof C){t=L.getTooltip_AsString();}if(t){return t;}return null;},updateRowColCount:function(e){var t=e.getTable(),i=t._getItemNavigation(),I=false,d=false,f=false;if(i){var g=E.getColumnIndexOfFocusedCell(e)+1;var r=b.getRowIndexOfFocusedCell(t)+t.getFirstVisibleRow()+1;var h=b.getVisibleColumnCount(t)+(b.hasRowActions(t)?1:0);var R=b.isNoDataVisible(t)?0:b.getTotalRowCount(t,true);I=e._iLastRowNumber!=r||(e._iLastRowNumber==r&&e._iLastColumnNumber==g);d=e._iLastColumnNumber!=g;f=!e._iLastRowNumber&&!e._iLastColumnNumber;t.$("rownumberofrows").text(I?t._oResBundle.getText("TBL_ROW_ROWCOUNT",[r,R]):" ");t.$("colnumberofcols").text(d?t._oResBundle.getText("TBL_COL_COLCOUNT",[g,h]):" ");t.$("ariacount").text(f?t._oResBundle.getText("TBL_DATA_ROWS_COLS",[R,h]):" ");e._iLastRowNumber=r;e._iLastColumnNumber=g;}return{rowChange:I,colChange:d,initial:f};},cleanupCellModifications:function(e){if(e._cleanupInfo){e._cleanupInfo.cell.attr(e._cleanupInfo.attr);e._cleanupInfo=null;}},storeDefaultsBeforeCellModifications:function(e,$,d,D){e._cleanupInfo={cell:$,attr:{"aria-labelledby":d&&d.length?d.join(" "):null,"aria-describedby":D&&D.length?D.join(" "):null}};},performCellModifications:function(e,$,d,D,L,f,t,g){E.storeDefaultsBeforeCellModifications(e,$,d,D);var o=E.updateRowColCount(e);e.getTable().$("cellacc").text(t||" ");if(g){g(L,f,o.rowChange,o.colChange,o.initial);}var s="";if(o.initial){var h=e.getTable();s=h.getAriaLabelledBy().join(" ")+" "+h.getId()+"-ariadesc "+h.getId()+"-ariacount";if(h.getSelectionMode()!==S.None){s=s+" "+h.getId()+"-ariaselection";}}if(L&&L.length){s=s+" "+L.join(" ");}$.attr({"aria-labelledby":s?s:null,"aria-describedby":f&&f.length?f.join(" "):null});},modifyAccOfDATACELL:function($,o){var t=this.getTable(),s=t.getId(),i=t._getItemNavigation();if(!i){return;}var r=b.getRowIndexOfFocusedCell(t),d=E.getColumnIndexOfFocusedCell(this),e=b.getRowColCell(t,r,d,false),I=null,h=E.isHiddenCell($,e.cell),f=E.isTreeColumnCell(this,$),g=b.Grouping.isInGroupingRow($),j=b.Grouping.isInSumRow($),D=E.getAriaAttributesFor(this,c.ELEMENTTYPES.DATACELL,{index:d,column:e.column,fixed:b.isFixedColumn(t,d)})["aria-labelledby"]||[],k=[],L=[s+"-rownumberofrows",s+"-colnumberofcols"];if(g){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");}if(j){var m=$.parent().data("sap-ui-level");if(m==0){L.push(s+"-ariagrandtotallabel");}else if(m>0){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}}if(b.hasRowHighlights(t)&&!g&&!j){L.push(e.row.getId()+"-highlighttext");}L=L.concat(D);if(!h){I=A.getAccInfoOfControl(e.cell,t._oResBundle);L.push(I?(s+"-cellacc"):e.cell.getId());if(((!I||I.focusable)&&!this._readonly)||(f&&e.row&&e.row._bHasChildren)){k.push(s+"-toggleedit");}}var n=I?I.description:" ";if(f&&!h){var p=E.getAriaAttributesFor(this,c.ELEMENTTYPES.TREEICON,{row:e.row});if(p&&p["aria-label"]){n=p["aria-label"]+" "+n;}}E.performCellModifications(this,$,D,null,L,k,n,function(L,k,R,u,v){if(!h&&b.isRowSelectionAllowed(t)&&R){k.push(e.row.getId()+"-rowselecttext");}});},modifyAccOfROWHEADER:function($,o){var t=this.getTable(),s=t.getId(),i=b.Grouping.isInGroupingRow($),I=b.Grouping.isInSumRow($),r=t.getRows()[$.attr("data-sap-ui-rowindex")],d=E.getAriaAttributesFor(this,c.ELEMENTTYPES.ROWHEADER)["aria-labelledby"]||[],L=d.concat([s+"-rownumberofrows"]);if(!I&&!i){if(!$.hasClass("sapUiTableRowHidden")){L.push(r.getId()+"-rowselecttext");if(b.hasRowHighlights(t)){L.push(r.getId()+"-highlighttext");}}}if(i){L.push(s+"-ariarowgrouplabel");}if(I){var e=$.data("sap-ui-level");if(e==0){L.push(s+"-ariagrandtotallabel");}else if(e>0){L.push(s+"-ariagrouptotallabel");}}E.performCellModifications(this,$,d,null,L,null,null);},modifyAccOfCOLUMNHEADER:function($,o){var t=this.getTable(),d=sap.ui.getCore().byId($.attr("data-sap-ui-colid")),m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.COLUMNHEADER,{headerId:$.attr("id"),column:d,index:$.attr("data-sap-ui-colindex")}),s=E.getColumnTooltip(d),L=[t.getId()+"-colnumberofcols"].concat(m["aria-labelledby"]),h=b.getColumnHeaderCellInfo($),i=h?h.span:1,I=d&&d.getId()===$.attr("id");if(i>1){L.push(t.getId()+"-ariacolspan");t.$("ariacolspan").text(t._oResBundle.getText("TBL_COL_DESC_SPAN",[""+i]));}if(s){L.push(t.getId()+"-cellacc");}if(I&&d&&d.getSorted()){L.push(t.getId()+(d.getSortOrder()==="Ascending"?"-ariacolsortedasc":"-ariacolsorteddes"));}if(I&&d&&d.getFiltered()){L.push(t.getId()+"-ariacolfiltered");}if($.attr("aria-haspopup")==="true"){L.push(t.getId()+"-ariacolmenu");}E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],L,m["aria-describedby"],s);},modifyAccOfCOLUMNROWHEADER:function($,o){var t=this.getTable(),e=$.hasClass("sapUiTableSelAllEnabled");var m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.COLUMNROWHEADER,{enabled:e,checked:e&&!t.$().hasClass("sapUiTableSelAll")});E.performCellModifications(this,$,m["aria-labelledby"],m["aria-describedby"],m["aria-labelledby"],m["aria-describedby"],null);},modifyAccOfROWACTION:function($,o){var t=this.getTable(),s=t.getId(),i=b.Grouping.isInGroupingRow($),I=b.Grouping.isInSumRow($),r=$.attr("data-sap-ui-rowindex"),R=t.getRows()[r],h=E.isHiddenCell($),d=E.getAriaAttributesFor(this,c.ELEMENTTYPES.ROWACTION)["aria-labelledby"]||[],L=[s+"-rownumberofrows",s+"-colnumberofcols"].concat(d),D=[];if(i){L.push(s+"-ariarowgrouplabel");L.push(s+"-rows-row"+r+"-groupHeader");}if(I){var e=$.data("sap-ui-level");if(e==0){L.push(s+"-ariagrandtotallabel");}else if(e>0){L.push(s+"-ariagrouptotallabel");L.push(s+"-rows-row"+r+"-groupHeader");}}if(!I&&!i&&$.attr("aria-selected")=="true"){L.push(s+"-ariarowselected");}if(b.hasRowHighlights(t)&&!i&&!I){L.push(R.getId()+"-highlighttext");}var f="";if(!h){var g=R.getAggregation("_rowAction");if(g){var j=g.getAccessibilityInfo();if(j){L.push(s+"-cellacc");f=j.description;if(j.focusable){D.push(s+"-toggleedit");}}}}E.performCellModifications(this,$,d,[],L,D,f);},getAriaAttributesFor:function(e,t,p){var m={},o=e.getTable(),s=o.getId();function d(o,u,O,v){var M="";if(O&&v){M="overlay,nodata";}else if(O&&!v){M="overlay";}else if(!O&&v){M="nodata";}var w=false;if(O&&o.getShowOverlay()||v&&b.isNoDataVisible(o)){w=true;}if(w){m["aria-hidden"]="true";}if(M){m["data-sap-ui-table-acc-covered"]=M;}}switch(t){case c.ELEMENTTYPES.COLUMNROWHEADER:m["aria-labelledby"]=[s+"-ariacolrowheaderlabel"];var f=false;m["role"]=["button"];if(p&&p.enabled){m["aria-pressed"]=p.checked?"true":"false";}else{f=true;m["aria-disabled"]="true";m["aria-pressed"]="false";}if(f||!o._getShowStandardTooltips()){m["aria-labelledby"].push(s+"-ariaselectall");}break;case c.ELEMENTTYPES.ROWHEADER:m["aria-labelledby"]=[s+"-ariarowheaderlabel"];if(!b.Grouping.isTreeMode(o)){m["role"]=["rowheader"];}if(o.getSelectionMode()!==S.None&&(!p||!p.rowHidden)){var g=p&&p.rowSelected;m["aria-selected"]=""+g;var h=e.getAriaTextsForSelectionMode(true);m["title"]=h.mouse[g?"rowDeselect":"rowSelect"];}break;case c.ELEMENTTYPES.ROWACTION:m["role"]=["gridcell"];m["aria-labelledby"]=[s+"-rowacthdr"];if(o.getSelectionMode()!==S.None&&(!p||!p.rowHidden)){var g=p&&p.rowSelected;m["aria-selected"]=""+g;}break;case c.ELEMENTTYPES.COLUMNHEADER:var j=p&&p.column;var I=j&&j.getId()===p.headerId;m["role"]="columnheader";var L=[];if(p&&p.headerId){var H=E.getRelevantColumnHeaders(o,j);var k=q.inArray(p.headerId,H);L=k>0?H.slice(0,k+1):[p.headerId];}for(var i=0;i<L.length;i++){L[i]=L[i]+"-inner";}m["aria-labelledby"]=L;if(p&&(p.index<o.getFixedColumnCount())){m["aria-labelledby"].push(s+"-ariafixedcolumn");}if(I&&j&&j.getSorted()){m["aria-sort"]=j.getSortOrder()==="Ascending"?"ascending":"descending";}if(j&&j._menuHasItems()){m["aria-haspopup"]="true";}break;case c.ELEMENTTYPES.DATACELL:m["role"]="gridcell";if(p&&typeof p.index==="number"){m["headers"]=s+"_col"+p.index;}var L=[],j=p&&p.column?p.column:null;if(j){L=E.getRelevantColumnHeaders(o,j);for(var i=0;i<L.length;i++){L[i]=L[i]+"-inner";}if(p&&p.fixed){L.push(s+"-ariafixedcolumn");}}m["aria-labelledby"]=L;if(b.Grouping.isTreeMode(o)&&p&&p.firstCol&&p.row){var B=o.mBindingInfos["rows"];if(p.row.getBindingContext(B&&B.model)){m["aria-level"]=p.row._iLevel+1;m["aria-expanded"]=""+p.row._bIsExpanded;}}break;case c.ELEMENTTYPES.ROOT:break;case c.ELEMENTTYPES.TABLE:m["role"]="presentation";d(o,m,true,true);break;case c.ELEMENTTYPES.CONTENT:m["role"]=b.Grouping.isGroupMode(o)||b.Grouping.isTreeMode(o)?"treegrid":"grid";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}if(o.getSelectionMode()===S.Multi||o.getSelectionMode()===S.MultiToggle){m["aria-multiselectable"]="true";}break;case c.ELEMENTTYPES.TABLEHEADER:m["role"]="heading";d(o,m,true,false);break;case c.ELEMENTTYPES.COLUMNHEADER_TBL:m["role"]="presentation";break;case c.ELEMENTTYPES.COLUMNHEADER_ROW:if(!b.hasRowHeader(o)){m["role"]="row";}d(o,m,true,false);break;case c.ELEMENTTYPES.ROWHEADER_COL:d(o,m,true,true);break;case c.ELEMENTTYPES.TH:var n=o.getFixedColumnCount()>0;m["role"]=n?"columnheader":"presentation";m["scope"]="col";if(n){if(p&&p.column){m["aria-owns"]=p.column.getId();m["aria-labelledby"]=[p.column.getId()];}}else{m["aria-hidden"]="true";}break;case c.ELEMENTTYPES.ROWHEADER_TD:m["role"]="rowheader";m["aria-labelledby"]=[s+"-ariarowheaderlabel"];m["headers"]=s+"-colsel";if(p&&typeof p.index==="number"){m["aria-owns"]=s+"-rowsel"+p.index;}if(o.getSelectionMode()!==S.None){var g=p&&p.rowSelected;m["aria-selected"]=""+g;}break;case c.ELEMENTTYPES.TR:m["role"]="row";var g=false;if(p&&typeof p.index==="number"&&o.getSelectionMode()!==S.None&&o.isIndexSelected(p.index)){m["aria-selected"]="true";g=true;}if(b.isRowSelectionAllowed(o)){var h=e.getAriaTextsForSelectionMode(true);m["title"]=h.mouse[g?"rowDeselect":"rowSelect"];}break;case c.ELEMENTTYPES.TREEICON:if(b.Grouping.isTreeMode(o)){m={"aria-label":"","title":"","role":""};if(o.getBinding("rows")){m["role"]="button";if(p&&p.row){if(p.row._bHasChildren){var r=o._oResBundle.getText(p.row._bIsExpanded?"TBL_COLLAPSE":"TBL_EXPAND");if(o._getShowStandardTooltips()){m["title"]=r;}else{m["aria-label"]=r;}m["aria-expanded"]=""+(!!p.row._bIsExpanded);}else{m["aria-label"]=o._oResBundle.getText("TBL_LEAF");}}}}break;case c.ELEMENTTYPES.NODATA:m["role"]="gridcell";var N=o.getNoData();m["aria-labelledby"]=[N instanceof C?N.getId():(s+"-noDataMsg")];d(o,m,true,false);break;case c.ELEMENTTYPES.OVERLAY:m["role"]="region";m["aria-labelledby"]=[].concat(o.getAriaLabelledBy());if(o.getTitle()){m["aria-labelledby"].push(o.getTitle().getId());}m["aria-labelledby"].push(s+"-ariainvalid");break;case c.ELEMENTTYPES.TABLEFOOTER:case c.ELEMENTTYPES.TABLESUBHEADER:d(o,m,true,false);break;case c.ELEMENTTYPES.ROWACTIONHEADER:m["aria-hidden"]="true";break;case"PRESENTATION":m["role"]="presentation";break;}return m;}};var c=T.extend("sap.ui.table.TableAccExtension",{_init:function(t,s,m){this._accMode=sap.ui.getCore().getConfiguration().getAccessibility();this._readonly=s==T.TABLETYPES.ANALYTICAL?true:false;t.addEventDelegate(this);T.enrich(t,a);return"AccExtension";},destroy:function(){this.getTable().removeEventDelegate(this);this._readonly=false;T.prototype.destroy.apply(this,arguments);},_debug:function(){this._ExtensionHelper=E;this._ACCInfoHelper=A;},_getAriaAttributesFor:function(t,p){return E.getAriaAttributesFor(this,t,p);},onfocusin:function(e){var t=this.getTable();if(!t||!b.getCellInfo(e.target)){return;}if(t._mTimeouts._cleanupACCExtension){q.sap.clearDelayedCall(t._mTimeouts._cleanupACCExtension);t._mTimeouts._cleanupACCExtension=null;}this.updateAccForCurrentCell(true);},onfocusout:function(e){var t=this.getTable();if(!t){return;}t._mTimeouts._cleanupACCExtension=q.sap.delayedCall(100,this,function(){var t=this.getTable();if(!t){return;}this._iLastRowNumber=null;this._iLastColumnNumber=null;E.cleanupCellModifications(this);t._mTimeouts._cleanupACCExtension=null;});}});c.ELEMENTTYPES={DATACELL:b.CELLTYPES.DATACELL,COLUMNHEADER:b.CELLTYPES.COLUMNHEADER,ROWHEADER:b.CELLTYPES.ROWHEADER,ROWACTION:b.CELLTYPES.ROWACTION,COLUMNROWHEADER:b.CELLTYPES.COLUMNROWHEADER,ROOT:"ROOT",CONTENT:"CONTENT",TABLE:"TABLE",TABLEHEADER:"TABLEHEADER",TABLEFOOTER:"TABLEFOOTER",TABLESUBHEADER:"TABLESUBHEADER",COLUMNHEADER_TBL:"COLUMNHEADER_TABLE",COLUMNHEADER_ROW:"COLUMNHEADER_ROW",ROWHEADER_COL:"ROWHEADER_COL",TH:"TH",ROWHEADER_TD:"ROWHEADER_TD",TR:"TR",TREEICON:"TREEICON",ROWACTIONHEADER:"ROWACTIONHEADER",NODATA:"NODATA",OVERLAY:"OVERLAY"};c.prototype.getAccMode=function(){return this._accMode;};c.prototype.updateAccForCurrentCell=function(o){if(!this._accMode||!this.getTable()._getItemNavigation()){return;}var t=this.getTable();if(t._mTimeouts._cleanupACCFocusRefresh){q.sap.clearDelayedCall(t._mTimeouts._cleanupACCFocusRefresh);t._mTimeouts._cleanupACCFocusRefresh=null;}if(o){E.cleanupCellModifications(this);}var i=E.getInfoOfFocusedCell(this);if(!i||!i.cell||!i.type||!E["modifyAccOf"+i.type]){return;}if(!o){if(i.type===b.CELLTYPES.DATACELL||b.CELLTYPES.ROWHEADER){t._mTimeouts._cleanupACCFocusRefresh=q.sap.delayedCall(100,this,function($){var t=this.getTable();if(!t){return;}var i=E.getInfoOfFocusedCell(this);if(i&&i.cell&&i.type&&i.cell.get(0)&&$.get(0)===i.cell.get(0)){i.cell.blur().focus();}t._mTimeouts._cleanupACCFocusRefresh=null;},[i.cell]);}return;}E["modifyAccOf"+i.type].apply(this,[i.cell,o]);};c.prototype.updateAriaStateOfColumn=function(o,r){if(!this._accMode){return;}var m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.COLUMNHEADER,{headerId:o.getId(),column:o,index:this.getTable().indexOfColumn(o)});r=r?r:o.$();r.attr({"aria-sort":m["aria-sort"]||null,"aria-labelledby":m["aria-labelledby"]?m["aria-labelledby"].join(" "):null});};c.prototype.updateAriaStateOfRow=function(r,R,i){if(!this._accMode){return;}if(!R){R=r.getDomRefs(true);}if(R.row){R.row.children("td").add(R.row).attr("aria-selected",i?"true":null);if(i&&R.rowSelectorText){var t=R.rowSelectorText.text();if(t){t=this.getTable()._oResBundle.getText("TBL_ROW_DESC_SELECTED")+" "+t;}R.rowSelectorText.text(t);}}};c.prototype.updateAriaExpandAndLevelState=function(r,s,R,f,$,g,e,L,t){if(!this._accMode){return;}var d=null,o=this.getTable(),h=[s,s.children(),R,f,f?f.children():null,$],j=!!t,B=o.getBinding("rows");if(!g&&R&&!j){var I=R.attr("data-sap-ui-rowindex");var m=E.getAriaAttributesFor(this,c.ELEMENTTYPES.ROWHEADER,{rowSelected:!r._bHidden&&o.isIndexSelected(I)});d=m["title"]||null;}if(R&&!j){R.attr({"aria-haspopup":g?"true":null,"title":d});}if(B&&B.hasTotaledMeasures&&L>0&&(!B.bProvideGrandTotals||!B.hasTotaledMeasures())){L=L-1;}for(var i=0;i<h.length;i++){if(h[i]){h[i].attr({"aria-expanded":g?e+"":null,"aria-level":L<0?null:(L+1)});}}if(j){t.attr(E.getAriaAttributesFor(this,c.ELEMENTTYPES.TREEICON,{row:r}));}};c.prototype.updateAriaStateOfRowHighlight=function(r){if(!this._accMode||r==null){return;}var R=r._getRow();if(R!=null){var h=R.getDomRef("highlighttext");h.innerText=r._getHighlightText();}};c.prototype.updateAriaStateForOverlayAndNoData=function(){var t=this.getTable();if(!t||!t.getDomRef()||!this._accMode){return;}if(t.getShowOverlay()){t.$().find("[data-sap-ui-table-acc-covered*='overlay']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='overlay']").removeAttr("aria-hidden");if(b.isNoDataVisible(t)){t.$().find("[data-sap-ui-table-acc-covered*='nodata']").attr("aria-hidden","true");}else{t.$().find("[data-sap-ui-table-acc-covered*='nodata']").removeAttr("aria-hidden");}}};c.prototype.getAriaTextsForSelectionMode=function(d,s){var t=this.getTable();if(!s){s=t.getSelectionMode();}var r=t._oResBundle;var e=t._getShowStandardTooltips();var m={mouse:{rowSelect:"",rowDeselect:""},keyboard:{rowSelect:"",rowDeselect:""}};var i=t._getSelectedIndicesCount();if(s===S.Single){m.mouse.rowSelect=e?r.getText("TBL_ROW_SELECT"):"";m.mouse.rowDeselect=e?r.getText("TBL_ROW_DESELECT"):"";m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");}else if(s===S.MultiToggle){m.mouse.rowSelect=e?r.getText("TBL_ROW_SELECT_MULTI_TOGGLE"):"";m.mouse.rowDeselect=e?r.getText("TBL_ROW_DESELECT"):"";m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_MULTI_TOGGLE_KEY");m.keyboard.rowDeselect=r.getText("TBL_ROW_DESELECT_KEY");if(d===true&&i===0){m.mouse.rowSelect=e?r.getText("TBL_ROW_SELECT"):"";m.keyboard.rowSelect=r.getText("TBL_ROW_SELECT_KEY");}}return m;};c.prototype.setSelectAllState=function(s){var t=this.getTable();if(t){t.$("selall").attr("aria-pressed",s?"true":"false");}};c.prototype.addColumnHeaderLabel=function(o,d){var t=this.getTable();if(!this._accMode||!d.getAriaLabelledBy||!t){return;}var L=t.getColumnHeaderVisible()?o.getId():null;if(!L){var e=o.getAggregation("label");if(e){L=e.getId();}}var f=d.getAriaLabelledBy();if(L&&q.inArray(L,f)<0){d.addAriaLabelledBy(L);}};return c;});
