/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/Control","sap/ui/core/ResizeHandler","sap/ui/core/MessageType","sap/ui/Device","sap/ui/model/ChangeReason","./TableGrouping","./TableColumnUtils","./TableMenuUtils","./library"],function(q,C,R,M,D,a,T,b,c,l){"use strict";var S=l.SelectionBehavior;var d=l.SelectionMode;var e=1;function _(t,E,s){if(t==null||E==null||s==null){return null;}var $=q(E);var p=$.parent().closest(s,t.getDomRef());if(p.length>0){return p;}return null;}var f={Grouping:T,Column:b,Menu:c,CELLTYPES:{DATACELL:"DATACELL",COLUMNHEADER:"COLUMNHEADER",ROWHEADER:"ROWHEADER",ROWACTION:"ROWACTION",COLUMNROWHEADER:"COLUMNROWHEADER"},DEFAULT_ROW_HEIGHT:{sapUiSizeCondensed:24+e,sapUiSizeCompact:32+e,sapUiSizeCozy:48+e,undefined:32+e},RowsUpdateReason:(function(){var u={};for(var p in a){u[p]=a[p];}u.Render="Render";u.VerticalScroll="VerticalScroll";u.FirstVisibleRowChange="FirstVisibleRowChange";u.Unbind="Unbind";u.Animation="Animation";u.Resize="Resize";u.Unknown="Unknown";return u;})(),hasRowHeader:function(t){return(t.getSelectionMode()!==d.None&&t.getSelectionBehavior()!==S.RowOnly)||T.isGroupMode(t);},hasSelectAll:function(t){var s=t!=null?t.getSelectionMode():d.None;return(s===d.Multi||s===d.MultiToggle)&&t.getEnableSelectAll();},hasRowHighlights:function(t){if(t==null){return false;}var r=t.getRowSettingsTemplate();if(r==null){return false;}var h=r.getHighlight();return r.isBound("highlight")||(h!=null&&h!==M.None);},getRowActionCount:function(t){var o=t.getRowActionTemplate();return o?o._getCount():0;},hasRowActions:function(t){var r=t.getRowActionTemplate();return r!=null&&(r.isBound("visible")||r.getVisible())&&f.getRowActionCount(t)>0;},isRowSelectionAllowed:function(t){return t.getSelectionMode()!==d.None&&(t.getSelectionBehavior()===S.Row||t.getSelectionBehavior()===S.RowOnly);},isRowSelectorSelectionAllowed:function(t){return t.getSelectionMode()!==d.None&&f.hasRowHeader(t);},areAllRowsSelected:function(t){if(t==null){return false;}var s=t._getSelectableRowCount();return s>0&&s===t._getSelectedIndicesCount();},isNoDataVisible:function(t){if(!t.getShowNoData()){return false;}return!f.hasData(t);},hasData:function(t){var B=t.getBinding("rows"),i=t._getRowCount(),h=B?!!i:false;if(B&&B.providesGrandTotal){var H=B.providesGrandTotal()&&B.hasTotaledMeasures();h=(H&&i<2)||(!H&&i===0)?false:true;}return h;},isBusyIndicatorVisible:function(t){if(t==null||t.getDomRef()==null){return false;}return t.getDomRef().querySelector(".sapUiTableCnt > .sapUiLocalBusyIndicator")!=null;},hasPendingRequest:function(t){return t!=null&&t._bPendingRequest===true;},isInstanceOf:function(o,t){if(!o||!t){return false;}var g=sap.ui.require(t);return!!(g&&(o instanceof g));},toggleRowSelection:function(t,r,s,g){if(t==null||t.getBinding("rows")==null||t.getSelectionMode()===d.None||r==null){return false;}function h(A){if(!t._isRowSelectable(A)){return false;}t._iSourceRowIndex=A;var j=true;if(g){j=g(A,s);}else{if(t.isIndexSelected(A)){if(s!=null&&s){return false;}t.removeSelectionInterval(A,A);}else{if(s!=null&&!s){return false;}t.addSelectionInterval(A,A);}}delete t._iSourceRowIndex;return j;}if(typeof r==="number"){if(r<0||r>=t._getRowCount()){return false;}return h(r);}else{var $=q(r);var o=this.getCellInfo($[0]);var i=this.isRowSelectionAllowed(t);if(o!==null&&!f.Grouping.isInGroupingRow($[0])&&((o.type===this.CELLTYPES.DATACELL&&i)||(o.type===this.CELLTYPES.ROWACTION&&i)||(o.type===this.CELLTYPES.ROWHEADER&&this.isRowSelectorSelectionAllowed(t)))){var A;if(o.type===this.CELLTYPES.DATACELL){A=t.getRows()[parseInt($.closest("tr",t.getDomRef()).attr("data-sap-ui-rowindex"),10)].getIndex();}else{A=t.getRows()[parseInt($.attr("data-sap-ui-rowindex"),10)].getIndex();}return h(A);}return false;}},getNoDataText:function(t){var n=t.getNoData();if(n instanceof C){return null;}else if(typeof n==="string"||t.getNoData()instanceof String){return n;}else{return t._oResBundle.getText("TBL_NO_DATA");}},getVisibleColumnCount:function(t){return t._getVisibleColumns().length;},getHeaderRowCount:function(t){if(t._iHeaderRowCount===undefined){if(!t.getColumnHeaderVisible()){t._iHeaderRowCount=0;}else{var h=1;var g=t.getColumns();for(var i=0;i<g.length;i++){if(g[i].shouldRender()){h=Math.max(h,g[i].getMultiLabels().length);}}t._iHeaderRowCount=h;}}return t._iHeaderRowCount;},isVariableRowHeightEnabled:function(t){return t._bVariableRowHeightEnabled&&t.getFixedRowCount()<=0&&t.getFixedBottomRowCount()<=0;},getTotalRowCount:function(t,i){var r=t._getRowCount();if(i){r=Math.max(r,t.getVisibleRowCount());}return r;},getNonEmptyVisibleRowCount:function(t){return Math.min(t.getVisibleRowCount(),t._getRowCount());},getFocusedItemInfo:function(t){var i=t._getItemNavigation();if(!i){return null;}return{cell:i.getFocusedIndex(),columnCount:i.iColumns,cellInRow:i.getFocusedIndex()%i.iColumns,row:Math.floor(i.getFocusedIndex()/i.iColumns),cellCount:i.getItemDomRefs().length,domRef:i.getFocusedDomRef()};},getRowIndexOfFocusedCell:function(t){var i=f.getFocusedItemInfo(t);return i.row-f.getHeaderRowCount(t);},isFixedColumn:function(t,i){return i<t.getFixedColumnCount();},hasFixedColumns:function(t){return t.getFixedColumnCount()>0;},focusItem:function(t,i,E){var I=t._getItemNavigation();if(I){I.focusItem(i,E);}},getCellInfo:function(o){if(!o){return null;}var $=q(o);if($.hasClass("sapUiTableTd")){return{type:f.CELLTYPES.DATACELL,cell:$};}else if($.hasClass("sapUiTableCol")){return{type:f.CELLTYPES.COLUMNHEADER,cell:$};}else if($.hasClass("sapUiTableRowHdr")){return{type:f.CELLTYPES.ROWHEADER,cell:$};}else if($.hasClass("sapUiTableRowAction")){return{type:f.CELLTYPES.ROWACTION,cell:$};}else if($.hasClass("sapUiTableColRowHdr")){return{type:f.CELLTYPES.COLUMNROWHEADER,cell:$};}return null;},getColumnHeaderCellInfo:function(o){if(o==null){return null;}var $=q(o);var g=this.getCellInfo($);if(g!==null&&g.type===f.CELLTYPES.COLUMNHEADER){return{index:parseInt($.data("sap-ui-colindex"),10),span:parseInt($.attr("colspan")||1,10)};}else{return null;}},getDataCellInfo:function(t,o){if(t==null||o==null){return null;}var $=q(o);var g=this.getCellInfo($);if(g!==null&&g.type===f.CELLTYPES.DATACELL){var s=$.data("sap-ui-colid");var h=sap.ui.getCore().byId(s);if(h!=null){var i=h.getIndex();var r=parseInt($.parent().data("sap-ui-rowindex"),10);return{rowIndex:r,columnIndex:i};}}return null;},getRowActionCellInfo:function(t,o){if(t==null||o==null){return null;}var $=q(o);var g=this.getCellInfo($);if(g!==null&&g.type===f.CELLTYPES.ROWACTION){return{rowIndex:parseInt($.data("sap-ui-rowindex"),10)};}else{return null;}},getRowColCell:function(t,r,g,I){var o=r>=0&&r<t.getRows().length?t.getRows()[r]:null;var h=I?t.getColumns():t._getVisibleColumns();var j=g>=0&&g<h.length?h[g]:null;var k=null;if(o&&j){if(I){if(j.shouldRender()){var v=t._getVisibleColumns();for(var i=0;i<v.length;i++){if(v[i]===j){k=o.getCells()[i];break;}}}}else{k=o.getCells()[g];}if(k&&k.data("sap-ui-colid")!=j.getId()){var m=o.getCells();for(var i=0;i<m.length;i++){if(m[i].data("sap-ui-colid")===j.getId()){k=m[i];break;}}}}return{row:o,column:j,cell:k};},getParentDataCell:function(t,E){return _(t,E,".sapUiTableTd");},getParentRowActionCell:function(t,E){return _(t,E,".sapUiTableRowAction");},getCell:function(t,E){if(t==null||E==null){return null;}var $=q(E);var g;var o=t.getDomRef();g=$.closest(".sapUiTableTd",o);if(g.length>0){return g;}g=$.closest(".sapUiTableCol",o);if(g.length>0){return g;}g=$.closest(".sapUiTableRowHdr",o);if(g.length>0){return g;}g=$.closest(".sapUiTableRowAction",o);if(g.length>0){return g;}g=$.closest(".sapUiTableColRowHdr",o);if(g.length>0){return g;}return null;},registerResizeHandler:function(t,i,h,r){var o;if(typeof i=="string"){o=t.getDomRef(i);}else{q.sap.log.error("sIdSuffix must be a string",t);return;}if(typeof h!=="function"){q.sap.log.error("fnHandler must be a function",t);return;}this.deregisterResizeHandler(t,i);if(!t._mResizeHandlerIds){t._mResizeHandlerIds={};}if(r&&o){o=o.parentNode;}if(o){t._mResizeHandlerIds[i]=R.register(o,h);}return t._mResizeHandlerIds[i];},deregisterResizeHandler:function(t,I){var g;if(!t._mResizeHandlerIds){return;}if(typeof I=="string"){g=[I];}else if(I===undefined){g=[];for(var k in t._mResizeHandlerIds){if(typeof k=="string"&&t._mResizeHandlerIds.hasOwnProperty(k)){g.push(k);}}}else if(q.isArray(I)){g=I;}for(var i=0;i<g.length;i++){var s=g[i];if(t._mResizeHandlerIds[s]){R.deregister(t._mResizeHandlerIds[s]);t._mResizeHandlerIds[s]=undefined;}}},isFirstScrollableRow:function(t,r){if(isNaN(r)){var $=q(r);r=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").data("sap-ui-rowindex"),10);}var F=t.getFixedRowCount()||0;return r==F;},isLastScrollableRow:function(t,r){if(isNaN(r)){var $=q(r);r=parseInt($.add($.parent()).filter("[data-sap-ui-rowindex]").data("sap-ui-rowindex"),10);}var F=t.getFixedBottomRowCount()||0;return r==t.getVisibleRowCount()-F-1;},getContentDensity:function(o){var s;var g=["sapUiSizeCompact","sapUiSizeCondensed","sapUiSizeCozy"];var G=function(F,O){if(!O[F]){return;}for(var i=0;i<g.length;i++){if(O[F](g[i])){return g[i];}}};var $=o.$();if($.length>0){s=G("hasClass",$);}else{s=G("hasStyleClass",o);}if(s){return s;}var p=null;var P=o.getParent();if(P){do{s=G("hasStyleClass",P);if(s){return s;}if(P.getDomRef){p=P.getDomRef();}else if(P.getRootNode){p=P.getRootNode();}if(!p&&P.getParent){P=P.getParent();}else{P=null;}}while(P&&!p);}$=q(p||document.body);s=G("hasClass",$.closest("."+g.join(",.")));return s;},sanitizeSelectionMode:function(t,s){if(s===d.Multi){s=d.MultiToggle;q.sap.log.warning("The selection mode 'Multi' is deprecated and must not be used anymore. Your setting was defaulted to selection mode 'MultiToggle'");}return s;},isVariableWidth:function(w){return!w||w=="auto"||w.toString().match(/%$/);},getFirstFixedButtomRowIndex:function(t){var F=t.getFixedBottomRowCount();var B=t.getBinding("rows");var i=-1;if(B&&F>0){var v=t.getVisibleRowCount();var g=t.getFirstVisibleRow();if(t._iBindingLength>=v){i=v-F;}else{var I=t._iBindingLength-F-g;if(I>=0&&(g+I)<t._iBindingLength){i=I;}}}return i;}};T.TableUtils=f;b.TableUtils=f;c.TableUtils=f;return f;},true);
