/**
 * Sinon.JS 1.14.1, 2015/03/16
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @author Contributors: https://github.com/cjohansen/Sinon.JS/blob/master/AUTHORS
 *
 * (The BSD License)
 *
 * Copyright (c) 2010-2014, Christian Johansen, christian@cjohansen.no
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright notice,
 *       this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright notice,
 *       this list of conditions and the following disclaimer in the documentation
 *       and/or other materials provided with the distribution.
 *     * Neither the name of Christian Johansen nor the names of his contributors
 *       may be used to endorse or promote products derived from this software
 *       without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(r,f){if(typeof define==='function'&&define.amd){define('sinon',[],function(){return(r.sinon=f());});}else if(typeof exports==='object'){module.exports=f();}else{r.sinon=f();}}(this,function(){var samsam,formatio;(function(){function define(m,d,f){if(m=="samsam"){samsam=d();}else if(typeof d==="function"&&m.length===0){lolex=d();}else if(typeof f==="function"){formatio=f(samsam);}}define.amd={};((typeof define==="function"&&define.amd&&function(m){define("samsam",m);})||(typeof module==="object"&&function(m){module.exports=m();})||function(m){this.samsam=m();})(function(){var o=Object.prototype;var d=typeof document!=="undefined"&&document.createElement("div");function a(v){var i=v;return typeof v==="number"&&v!==i;}function g(v){return o.toString.call(v).split(/[ \]]/)[1];}function b(i){if(g(i)==='Arguments'){return true;}if(typeof i!=="object"||typeof i.length!=="number"||g(i)==="Array"){return false;}if(typeof i.callee=="function"){return true;}try{i[i.length]=6;delete i[i.length];}catch(e){return true;}return false;}function c(i){if(!i||i.nodeType!==1||!d){return false;}try{i.appendChild(d);i.removeChild(d);}catch(e){return false;}return true;}function f(i){var k=[],j;for(j in i){if(o.hasOwnProperty.call(i,j)){k.push(j);}}return k;}function h(v){return typeof v.getTime=="function"&&v.getTime()==v.valueOf();}function m(v){return v===0&&1/v===-Infinity;}function n(i,j){if(i===j||(a(i)&&a(j))){return i!==0||m(i)===m(j);}}function p(j,k){var s=[],t=[],u=[],v=[],w={};function x(i){if(typeof i==='object'&&i!==null&&!(i instanceof Boolean)&&!(i instanceof Date)&&!(i instanceof Number)&&!(i instanceof RegExp)&&!(i instanceof String)){return true;}return false;}function y(l,z){var i;for(i=0;i<l.length;i++){if(l[i]===z){return i;}}return-1;}return(function deepEqual(j,k,z,A){var B=typeof j;var C=typeof k;if(j===k||a(j)||a(k)||j==null||k==null||B!=="object"||C!=="object"){return n(j,k);}if(c(j)||c(k)){return false;}var D=h(j),E=h(k);if(D||E){if(!D||!E||j.getTime()!==k.getTime()){return false;}}if(j instanceof RegExp&&k instanceof RegExp){if(j.toString()!==k.toString()){return false;}}var F=g(j);var G=g(k);var H=f(j);var I=f(k);if(b(j)||b(k)){if(j.length!==k.length){return false;}}else{if(B!==C||F!==G||H.length!==I.length){return false;}}var J,i,l,K,L,M,N,O,P,Q,R;for(i=0,l=H.length;i<l;i++){J=H[i];if(!o.hasOwnProperty.call(k,J)){return false;}K=j[J];L=k[J];M=x(K);N=x(L);O=M?y(s,K):-1;P=N?y(t,L):-1;Q=O!==-1?u[O]:z+'['+JSON.stringify(J)+']';R=P!==-1?v[P]:A+'['+JSON.stringify(J)+']';if(w[Q+R]){return true;}if(O===-1&&M){s.push(K);u.push(Q);}if(P===-1&&N){t.push(L);v.push(R);}if(M&&N){w[Q+R]=true;}if(!deepEqual(K,L,Q,R)){return false;}}return true;}(j,k,'$1','$2'));}var q;function r(s,t){if(t.length===0){return true;}var i,l,j,k;for(i=0,l=s.length;i<l;++i){if(q(s[i],t[0])){for(j=0,k=t.length;j<k;++j){if(!q(s[i+j],t[j])){return false;}}return true;}}return false;}q=function q(i,j){if(j&&typeof j.test==="function"){return j.test(i);}if(typeof j==="function"){return j(i)===true;}if(typeof j==="string"){j=j.toLowerCase();var k=typeof i==="string"||!!i;return k&&(String(i)).toLowerCase().indexOf(j)>=0;}if(typeof j==="number"){return j===i;}if(typeof j==="boolean"){return j===i;}if(typeof(j)==="undefined"){return typeof(i)==="undefined";}if(j===null){return i===null;}if(g(i)==="Array"&&g(j)==="Array"){return r(i,j);}if(j&&typeof j==="object"){if(j===i){return true;}var l;for(l in j){var v=i[l];if(typeof v==="undefined"&&typeof i.getAttribute==="function"){v=i.getAttribute(l);}if(j[l]===null||typeof j[l]==='undefined'){if(v!==j[l]){return false;}}else if(typeof v==="undefined"||!q(v,j[l])){return false;}}return true;}throw new Error("Matcher was not a string, a number, a "+"function, a boolean or an object");};return{isArguments:b,isElement:c,isDate:h,isNegZero:m,identical:n,deepEqual:p,match:q,keys:f};});((typeof define==="function"&&define.amd&&function(m){define("formatio",["samsam"],m);})||(typeof module==="object"&&function(m){module.exports=m(require("samsam"));})||function(m){this.formatio=m(this.samsam);})(function(s){var a={excludeConstructors:["Object",/^.$/],quoteStrings:true,limitChildrenCount:0};var h=Object.prototype.hasOwnProperty;var b=[];if(typeof global!=="undefined"){b.push({object:global,value:"[object global]"});}if(typeof document!=="undefined"){b.push({object:document,value:"[object HTMLDocument]"});}if(typeof window!=="undefined"){b.push({object:window,value:"[object Window]"});}function c(f){if(!f){return"";}if(f.displayName){return f.displayName;}if(f.name){return f.name;}var m=f.toString().match(/function\s+([^\(]+)/m);return(m&&m[1])||"";}function d(f,o){var n=c(o&&o.constructor);var k=f.excludeConstructors||a.excludeConstructors||[];var i,l;for(i=0,l=k.length;i<l;++i){if(typeof k[i]==="string"&&k[i]===n){return"";}else if(k[i].test&&k[i].test(n)){return"";}}return n;}function g(o,f){if(typeof o!=="object"){return false;}var i,l;for(i=0,l=f.length;i<l;++i){if(f[i]===o){return true;}}return false;}function j(f,o,p,k){if(typeof o==="string"){var q=f.quoteStrings;var m=typeof q!=="boolean"||q;return p||m?'"'+o+'"':o;}if(typeof o==="function"&&!(o instanceof RegExp)){return j.func(o);}p=p||[];if(g(o,p)){return"[Circular]";}if(Object.prototype.toString.call(o)==="[object Array]"){return j.array.call(f,o,p);}if(!o){return String((1/o)===-Infinity?"-0":o);}if(s.isElement(o)){return j.element(o);}if(typeof o.toString==="function"&&o.toString!==Object.prototype.toString){return o.toString();}var i,l;for(i=0,l=b.length;i<l;i++){if(o===b[i].object){return b[i].value;}}return j.object.call(f,o,p,k);}j.func=function(f){return"function "+c(f)+"() {}";};j.array=function(f,p){p=p||[];p.push(f);var k=[];var i,l;l=(this.limitChildrenCount>0)?Math.min(this.limitChildrenCount,f.length):f.length;for(i=0;i<l;++i){k.push(j(this,f[i],p));}if(l<f.length)k.push("[... "+(f.length-l)+" more elements]");return"["+k.join(", ")+"]";};j.object=function(o,p,f){p=p||[];p.push(o);f=f||0;var m=[],n=s.keys(o).sort();var q=3;var r,t,u,i,k,l;l=(this.limitChildrenCount>0)?Math.min(this.limitChildrenCount,n.length):n.length;for(i=0;i<l;++i){r=n[i];u=o[r];if(g(u,p)){t="[Circular]";}else{t=j(this,u,p,f+2);}t=(/\s/.test(r)?'"'+r+'"':r)+": "+t;q+=t.length;m.push(t);}var v=d(this,o);var w=v?"["+v+"] ":"";var x="";for(i=0,k=f;i<k;++i){x+=" ";}if(l<n.length)m.push("[... "+(n.length-l)+" more elements]");if(q+f>80){return w+"{\n  "+x+m.join(",\n  "+x)+"\n"+x+"}";}return w+"{ "+m.join(", ")+" }";};j.element=function(f){var t=f.tagName.toLowerCase();var k=f.attributes,m,p=[],n,i,l,v;for(i=0,l=k.length;i<l;++i){m=k.item(i);n=m.nodeName.toLowerCase().replace("html:","");v=m.nodeValue;if(n!=="contenteditable"||v!=="inherit"){if(!!v){p.push(n+"=\""+v+"\"");}}}var o="<"+t+(p.length>0?" ":"");var q=f.innerHTML;if(q.length>20){q=q.substr(0,20)+"[...]";}var r=o+p.join(" ")+">"+q+"</"+t+">";return r.replace(/ contentEditable="inherit"/,"");};function F(o){for(var f in o){this[f]=o[f];}}F.prototype={functionName:c,configure:function(o){return new F(o);},constructorName:function(o){return d(this,o);},ascii:function(o,p,i){return j(this,o,p,i);}};return F.prototype;});!function(e){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=e();else if("function"==typeof define&&define.amd)define([],e);else{var f;"undefined"!=typeof window?f=window:"undefined"!=typeof global?f=global:"undefined"!=typeof self&&(f=self),f.lolex=e()}}(function(){var define,module,exports;return(function e(t,n,r){function s(o,u){if(!n[o]){if(!t[o]){var a=typeof require=="function"&&require;if(!u&&a)return a(o,!0);if(i)return i(o,!0);var f=new Error("Cannot find module '"+o+"'");throw f.code="MODULE_NOT_FOUND",f}var l=n[o]={exports:{}};t[o][0].call(l.exports,function(e){var n=t[o][1][e];return s(n?n:e)},l,l.exports,e,t,n,r)}return n[o].exports}var i=typeof require=="function"&&require;for(var o=0;o<r.length;o++)s(r[o]);return s})({1:[function(require,module,exports){(function(global){
/**
 * @author Christian Johansen (christian@cjohansen.no) and contributors
 * @license BSD
 *
 * Copyright (c) 2010-2014 Christian Johansen
 */
var timeoutResult=setTimeout(function(){},0);var addTimerReturnsObject=typeof timeoutResult==="object";clearTimeout(timeoutResult);var NativeDate=Date;var id=1;function parseTime(s){if(!s){return 0;}var a=s.split(":");var l=a.length,i=l;var m=0,p;if(l>3||!/^(\d\d:){0,2}\d\d?$/.test(s)){throw new Error("tick only understands numbers and 'h:m:s'");}while(i--){p=parseInt(a[i],10);if(p>=60){throw new Error("Invalid time "+s);}m+=p*Math.pow(60,(l-i-1));}return m*1000;}function getEpoch(a){if(!a){return 0;}if(typeof a.getTime==="function"){return a.getTime();}if(typeof a==="number"){return a;}throw new TypeError("now should be milliseconds since UNIX epoch");}function inRange(f,t,a){return a&&a.callAt>=f&&a.callAt<=t;}function mirrorDateProperties(t,s){if(s.now){t.now=function now(){return t.clock.now;};}else{delete t.now;}if(s.toSource){t.toSource=function toSource(){return s.toSource();};}else{delete t.toSource;}t.toString=function toString(){return s.toString();};t.prototype=s.prototype;t.parse=s.parse;t.UTC=s.UTC;t.prototype.toUTCString=s.prototype.toUTCString;for(var p in s){if(s.hasOwnProperty(p)){t[p]=s[p];}}return t;}function createDate(){function C(y,m,d,h,a,s,b){switch(arguments.length){case 0:return new NativeDate(C.clock.now);case 1:return new NativeDate(y);case 2:return new NativeDate(y,m);case 3:return new NativeDate(y,m,d);case 4:return new NativeDate(y,m,d,h);case 5:return new NativeDate(y,m,d,h,a);case 6:return new NativeDate(y,m,d,h,a,s);default:return new NativeDate(y,m,d,h,a,s,b);}}return mirrorDateProperties(C,NativeDate);}function addTimer(c,t){if(typeof t.func==="undefined"){throw new Error("Callback must be provided to timer calls");}if(!c.timers){c.timers={};}t.id=id++;t.createdAt=c.now;t.callAt=c.now+(t.delay||0);c.timers[t.id]=t;if(addTimerReturnsObject){return{id:t.id,ref:function(){},unref:function(){}};}else{return t.id;}}function firstTimerInRange(c,f,t){var a=c.timers,b=null;for(var i in a){if(!inRange(f,t,a[i])){continue;}if(!b||~compareTimers(b,a[i])){b=a[i];}}return b;}function compareTimers(a,b){if(a.callAt<b.callAt){return-1;}if(a.callAt>b.callAt){return 1;}if(a.immediate&&!b.immediate){return-1;}if(!a.immediate&&b.immediate){return 1;}if(a.createdAt<b.createdAt){return-1;}if(a.createdAt>b.createdAt){return 1;}if(a.id<b.id){return-1;}if(a.id>b.id){return 1;}}function callTimer(clock,timer){if(typeof timer.interval=="number"){clock.timers[timer.id].callAt+=timer.interval;}else{delete clock.timers[timer.id];}try{if(typeof timer.func=="function"){timer.func.apply(null,timer.args);}else{eval(timer.func);}}catch(e){var exception=e;}if(!clock.timers[timer.id]){if(exception){throw exception;}return;}if(exception){throw exception;}}function uninstall(c,t){var m;for(var i=0,l=c.methods.length;i<l;i++){m=c.methods[i];if(t[m].hadOwnProperty){t[m]=c["_"+m];}else{try{delete t[m];}catch(e){}}}c.methods=[];}function hijackMethod(t,m,c){c[m].hadOwnProperty=Object.prototype.hasOwnProperty.call(t,m);c["_"+m]=t[m];if(m=="Date"){var d=mirrorDateProperties(c[m],t[m]);t[m]=d;}else{t[m]=function(){return c[m].apply(c,arguments);};for(var p in c[m]){if(c[m].hasOwnProperty(p)){t[m][p]=c[m][p];}}}t[m].clock=c;}var timers={setTimeout:setTimeout,clearTimeout:clearTimeout,setImmediate:(typeof setImmediate!=="undefined"?setImmediate:undefined),clearImmediate:(typeof clearImmediate!=="undefined"?clearImmediate:undefined),setInterval:setInterval,clearInterval:clearInterval,Date:Date};var keys=Object.keys||function(o){var k=[];for(var a in o){k.push(a);}return k;};exports.timers=timers;var createClock=exports.createClock=function(n){var c={now:getEpoch(n),timeouts:{},Date:createDate()};c.Date.clock=c;c.setTimeout=function setTimeout(f,t){return addTimer(c,{func:f,args:Array.prototype.slice.call(arguments,2),delay:t});};c.clearTimeout=function clearTimeout(t){if(!t){return;}if(!c.timers){c.timers=[];}if(typeof t==="object"){t=t.id}if(t in c.timers){delete c.timers[t];}};c.setInterval=function setInterval(f,t){return addTimer(c,{func:f,args:Array.prototype.slice.call(arguments,2),delay:t,interval:t});};c.clearInterval=function clearInterval(t){c.clearTimeout(t);};c.setImmediate=function setImmediate(f){return addTimer(c,{func:f,args:Array.prototype.slice.call(arguments,1),immediate:true});};c.clearImmediate=function clearImmediate(t){c.clearTimeout(t);};c.tick=function tick(m){m=typeof m=="number"?m:parseTime(m);var t=c.now,a=c.now+m,p=c.now;var b=firstTimerInRange(c,t,a);var f;while(b&&t<=a){if(c.timers[b.id]){t=c.now=b.callAt;try{callTimer(c,b);}catch(e){f=f||e;}}b=firstTimerInRange(c,p,a);p=t;}c.now=a;if(f){throw f;}return c.now;};c.reset=function reset(){c.timers={};};return c;};exports.install=function install(t,n,a){if(typeof t==="number"){a=n;n=t;t=null;}if(!t){t=global;}var c=createClock(n);c.uninstall=function(){uninstall(c,t);};c.methods=a||[];if(c.methods.length===0){c.methods=keys(timers);}for(var i=0,l=c.methods.length;i<l;i++){hijackMethod(t,c.methods[i],c);}return c;};}).call(this,typeof global!=="undefined"?global:typeof self!=="undefined"?self:typeof window!=="undefined"?window:{})},{}]},{},[1])(1)});})();var define;
/**
 * Sinon core utilities. For internal use only.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
var sinon=(function(){"use strict";var s;var i=typeof module!=="undefined"&&module.exports&&typeof require==="function";var a=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function l(r,b,m){s=m.exports=r("./sinon/util/core");r("./sinon/extend");r("./sinon/typeOf");r("./sinon/times_in_words");r("./sinon/spy");r("./sinon/call");r("./sinon/behavior");r("./sinon/stub");r("./sinon/mock");r("./sinon/collection");r("./sinon/assert");r("./sinon/sandbox");r("./sinon/test");r("./sinon/test_case");r("./sinon/match");r("./sinon/format");r("./sinon/log_error");}if(a){define(l);}else if(i){l(require,module.exports,module);s=module.exports;}else{s={};}return s;}());(function(s){var d=typeof document!="undefined"&&document.createElement("div");var h=Object.prototype.hasOwnProperty;function c(a){var b=false;try{a.appendChild(d);b=d.parentNode==a;}catch(e){return false;}finally{try{a.removeChild(d);}catch(e){}}return b;}function f(a){return d&&a&&a.nodeType===1&&c(a);}function g(a){return typeof a==="function"||!!(a&&a.constructor&&a.call&&a.apply);}function j(v){return typeof v==="number"&&isNaN(v);}function m(t,a){for(var b in a){if(!h.call(t,b)){t[b]=a[b];}}}function k(a){return typeof a==="function"&&typeof a.restore==="function"&&a.restore.sinon;}var n="keys"in Object;function o(s){s.wrapMethod=function wrapMethod(a,b,l){if(!a){throw new TypeError("Should wrap property of object");}if(typeof l!="function"&&typeof l!="object"){throw new TypeError("Method wrapper should be a function or a property descriptor");}function t(w){if(!g(w)){u=new TypeError("Attempted to wrap "+(typeof w)+" property "+b+" as function");}else if(w.restore&&w.restore.sinon){u=new TypeError("Attempted to wrap "+b+" which is already wrapped");}else if(w.calledBefore){var A=!!w.returns?"stubbed":"spied on";u=new TypeError("Attempted to wrap "+b+" which is already "+A);}if(u){if(w&&w.stackTrace){u.stack+="\n--------------\n"+w.stackTrace;}throw u;}}var u,w;var v=a.hasOwnProperty?a.hasOwnProperty(b):h.call(a,b);if(n){var x=(typeof l=="function")?{value:l}:l,y=s.getPropertyDescriptor(a,b),i;if(!y){u=new TypeError("Attempted to wrap "+(typeof w)+" property "+b+" as function");}else if(y.restore&&y.restore.sinon){u=new TypeError("Attempted to wrap "+b+" which is already wrapped");}if(u){if(y&&y.stackTrace){u.stack+="\n--------------\n"+y.stackTrace;}throw u;}var z=s.objectKeys(x);for(i=0;i<z.length;i++){w=y[z[i]];t(w);}m(x,y);for(i=0;i<z.length;i++){m(x[z[i]],y[z[i]]);}Object.defineProperty(a,b,x);}else{w=a[b];t(w);a[b]=l;l.displayName=b;}l.displayName=b;l.stackTrace=(new Error("Stack Trace for original")).stack;l.restore=function(){if(!v){try{delete a[b];}catch(e){}if(a[b]===l){a[b]=w;}}else if(n){Object.defineProperty(a,b,y);}if(!n&&a[b]===l){a[b]=w;}};l.restore.sinon=true;if(!n){m(l,w);}return l;};s.create=function create(a){var F=function(){};F.prototype=a;return new F();};s.deepEqual=function deepEqual(a,b){if(s.match&&s.match.isMatcher(a)){return a.test(b);}if(typeof a!="object"||typeof b!="object"){if(j(a)&&j(b)){return true;}else{return a===b;}}if(f(a)||f(b)){return a===b;}if(a===b){return true;}if((a===null&&b!==null)||(a!==null&&b===null)){return false;}if(a instanceof RegExp&&b instanceof RegExp){return(a.source===b.source)&&(a.global===b.global)&&(a.ignoreCase===b.ignoreCase)&&(a.multiline===b.multiline);}var S=Object.prototype.toString.call(a);if(S!=Object.prototype.toString.call(b)){return false;}if(S=="[object Date]"){return a.valueOf()===b.valueOf();}var i,l=0,L=0;if(S=="[object Array]"&&a.length!==b.length){return false;}for(i in a){l+=1;if(!(i in b)){return false;}if(!deepEqual(a[i],b[i])){return false;}}for(i in b){L+=1;}return l==L;};s.functionName=function functionName(a){var b=a.displayName||a.name;if(!b){var i=a.toString().match(/function ([^\s\(]+)/);b=i&&i[1];}return b;};s.functionToString=function toString(){if(this.getCall&&this.callCount){var t,a,i=this.callCount;while(i--){t=this.getCall(i).thisValue;for(a in t){if(t[a]===this){return a;}}}}return this.displayName||"sinon fake";};s.objectKeys=function objectKeys(a){if(a!==Object(a)){throw new TypeError("sinon.objectKeys called on a non-object");}var b=[];var i;for(i in a){if(h.call(a,i)){b.push(i);}}return b;};s.getPropertyDescriptor=function getPropertyDescriptor(a,b){var i=a,l;while(i&&!(l=Object.getOwnPropertyDescriptor(i,b))){i=Object.getPrototypeOf(i);}return l;};s.getConfig=function(a){var b={};a=a||{};var i=s.defaultConfig;for(var l in i){if(i.hasOwnProperty(l)){b[l]=a.hasOwnProperty(l)?a[l]:i[l];}}return b;};s.defaultConfig={injectIntoThis:true,injectInto:null,properties:["spy","stub","mock","clock","server","requests"],useFakeTimers:true,useFakeServer:true};s.timesInWords=function timesInWords(a){return a==1&&"once"||a==2&&"twice"||a==3&&"thrice"||(a||0)+" times";};s.calledInOrder=function(a){for(var i=1,l=a.length;i<l;i++){if(!a[i-1].calledBefore(a[i])||!a[i].called){return false;}}return true;};s.orderByFirstCall=function(i){return i.sort(function(a,b){var C=a.getCall(0);var l=b.getCall(0);var I=C&&C.callId||-1;var t=l&&l.callId||-1;return I<t?-1:1;});};s.createStubInstance=function(a){if(typeof a!=="function"){throw new TypeError("The constructor should be a function.");}return s.stub(s.create(a.prototype));};s.restore=function(a){if(a!==null&&typeof a==="object"){for(var b in a){if(k(a[b])){a[b].restore();}}}else if(k(a)){a.restore();}};return s;}var p=typeof module!=="undefined"&&module.exports&&typeof require=="function";var q=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function r(a,b){o(b);}if(q){define(r);}else if(p){r(require,module.exports);}else if(!s){return;}else{o(s);}}(typeof sinon=="object"&&sinon||null));(function(s){function m(s){var h=(function(){var o={constructor:function(){return"0";},toString:function(){return"1";},valueOf:function(){return"2";},toLocaleString:function(){return"3";},prototype:function(){return"4";},isPrototypeOf:function(){return"5";},propertyIsEnumerable:function(){return"6";},hasOwnProperty:function(){return"7";},length:function(){return"8";},unique:function(){return"9"}};var r=[];for(var p in o){r.push(o[p]());}return r.join("")!=="0123456789";})();function c(t){var d=Array.prototype.slice.call(arguments,1),f,i,p;for(i=0;i<d.length;i++){f=d[i];for(p in f){if(f.hasOwnProperty(p)){t[p]=f[p];}}if(h&&f.hasOwnProperty("toString")&&f.toString!==t.toString){t.toString=f.toString;}}return t;};s.extend=c;return s.extend;}function l(r,c,d){var s=r("./util/core");d.exports=m(s);}var a=typeof module!=="undefined"&&module.exports&&typeof require=="function";var b=typeof define==="function"&&typeof define.amd==="object"&&define.amd;if(b){define(l);}else if(a){l(require,module.exports,module);}else if(!s){return;}else{m(s);}}(typeof sinon=="object"&&sinon||null));(function(s){function m(s){function t(c){switch(c){case 1:return"once";case 2:return"twice";case 3:return"thrice";default:return(c||0)+" times";}}s.timesInWords=t;return s.timesInWords;}function l(r,b,c){var s=r("./util/core");c.exports=m(s);}var i=typeof module!=="undefined"&&module.exports&&typeof require=="function";var a=typeof define==="function"&&typeof define.amd==="object"&&define.amd;if(a){define(l);}else if(i){l(require,module.exports,module);}else if(!s){return;}else{m(s);}}(typeof sinon=="object"&&sinon||null));
/**
 * Format functions
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2014 Christian Johansen
 */
(function(s,f){function m(s){function t(v){if(v===null){return"null";}else if(v===undefined){return"undefined";}var b=Object.prototype.toString.call(v);return b.substring(8,b.length-1).toLowerCase();};s.typeOf=t;return s.typeOf;}function l(r,b,c){var s=r("./util/core");c.exports=m(s);}var i=typeof module!=="undefined"&&module.exports&&typeof require=="function";var a=typeof define==="function"&&typeof define.amd==="object"&&define.amd;if(a){define(l);}else if(i){l(require,module.exports,module);}else if(!s){return;}else{m(s);}}((typeof sinon=="object"&&sinon||null),(typeof formatio=="object"&&formatio)));
/**
 * Match functions
 *
 * @author Maximilian Antoni (mail@maxantoni.de)
 * @license BSD
 *
 * Copyright (c) 2012 Maximilian Antoni
 */
(function(s){function a(s){function c(v,t,n){var k=s.typeOf(v);if(k!==t){throw new TypeError("Expected type of "+n+" to be "+t+", but was "+k);}}var d={toString:function(){return this.message;}};function f(o){return d.isPrototypeOf(o);}function g(k,m){if(m===null||m===undefined){return false;}for(var n in k){if(k.hasOwnProperty(n)){var o=k[n];var p=m[n];if(h.isMatcher(o)){if(!o.test(p)){return false;}}else if(s.typeOf(o)==="object"){if(!g(o,p)){return false;}}else if(!s.deepEqual(o,p)){return false;}}}return true;}d.or=function(m){if(!arguments.length){throw new TypeError("Matcher expected");}else if(!f(m)){m=h(m);}var k=this;var o=s.create(d);o.test=function(n){return k.test(n)||m.test(n);};o.message=k.message+".or("+m.message+")";return o;};d.and=function(m){if(!arguments.length){throw new TypeError("Matcher expected");}else if(!f(m)){m=h(m);}var k=this;var n=s.create(d);n.test=function(o){return k.test(o)&&m.test(o);};n.message=k.message+".and("+m.message+")";return n;};var h=function(k,n){var m=s.create(d);var t=s.typeOf(k);switch(t){case"object":if(typeof k.test==="function"){m.test=function(q){return k.test(q)===true;};m.message="match("+s.functionName(k.test)+")";return m;}var o=[];for(var p in k){if(k.hasOwnProperty(p)){o.push(p+": "+k[p]);}}m.test=function(q){return g(k,q);};m.message="match("+o.join(", ")+")";break;case"number":m.test=function(q){return k==q;};break;case"string":m.test=function(q){if(typeof q!=="string"){return false;}return q.indexOf(k)!==-1;};m.message="match(\""+k+"\")";break;case"regexp":m.test=function(q){if(typeof q!=="string"){return false;}return k.test(q);};break;case"function":m.test=k;if(n){m.message=n;}else{m.message="match("+s.functionName(k)+")";}break;default:m.test=function(q){return s.deepEqual(k,q);};}if(!m.message){m.message="match("+k+")";}return m;};h.isMatcher=f;h.any=h(function(){return true;},"any");h.defined=h(function(k){return k!==null&&k!==undefined;},"defined");h.truthy=h(function(k){return!!k;},"truthy");h.falsy=h(function(k){return!k;},"falsy");h.same=function(k){return h(function(m){return k===m;},"same("+k+")");};h.typeOf=function(t){c(t,"string","type");return h(function(k){return s.typeOf(k)===t;},"typeOf(\""+t+"\")");};h.instanceOf=function(t){c(t,"function","type");return h(function(k){return k instanceof t;},"instanceOf("+s.functionName(t)+")");};function j(p,m){return function(k,v){c(k,"string","property");var o=arguments.length===1;var n=m+"(\""+k+"\"";if(!o){n+=", "+v;}n+=")";return h(function(q){if(q===undefined||q===null||!p(q,k)){return false;}return o||s.deepEqual(v,q[k]);},n);};}h.has=j(function(k,p){if(typeof k==="object"){return p in k;}return k[p]!==undefined;},"has");h.hasOwn=j(function(k,p){return k.hasOwnProperty(p);},"hasOwn");h.bool=h.typeOf("boolean");h.number=h.typeOf("number");h.string=h.typeOf("string");h.object=h.typeOf("object");h.func=h.typeOf("function");h.array=h.typeOf("array");h.regexp=h.typeOf("regexp");h.date=h.typeOf("date");s.match=h;return h;}var i=typeof module!=="undefined"&&module.exports&&typeof require=="function";var b=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function l(r,c,m){var s=r("./util/core");r("./typeOf");m.exports=a(s);}if(b){define(l);}else if(i){l(require,module.exports,module);}else if(!s){return;}else{a(s);}}(typeof sinon=="object"&&sinon||null));
/**
 * Format functions
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2014 Christian Johansen
 */
(function(s,f){function m(s){function v(d){return""+d;}function g(){var c=f.configure({quoteStrings:false,limitChildrenCount:250});function d(){return c.ascii.apply(c,arguments);};return d;}function b(d){function h(d){return typeof d=="object"&&d.toString===Object.prototype.toString?u.inspect(d):d;};try{var u=require("util");}catch(e){}return u?h:v;}var i=typeof module!=="undefined"&&module.exports&&typeof require=="function",c;if(i){try{f=require("formatio");}catch(e){}}if(f){c=g()}else if(i){c=b();}else{c=v;}s.format=c;return s.format;}function l(r,b,c){var s=r("./util/core");c.exports=m(s);}var i=typeof module!=="undefined"&&module.exports&&typeof require=="function";var a=typeof define==="function"&&typeof define.amd==="object"&&define.amd;if(a){define(l);}else if(i){l(require,module.exports,module);}else if(!s){return;}else{m(s);}}((typeof sinon=="object"&&sinon||null),(typeof formatio=="object"&&formatio)));
/**
  * Spy calls
  *
  * @author Christian Johansen (christian@cjohansen.no)
  * @author Maximilian Antoni (mail@maxantoni.de)
  * @license BSD
  *
  * Copyright (c) 2010-2013 Christian Johansen
  * Copyright (c) 2013 Maximilian Antoni
  */
(function(s){function m(s){function t(p,h,i){var j=s.functionName(p)+h;if(i.length){j+=" Received ["+d.call(i).join(", ")+"]";}throw new Error(j);}var d=Array.prototype.slice;var f={calledOn:function calledOn(h){if(s.match&&s.match.isMatcher(h)){return h.test(this.thisValue);}return this.thisValue===h;},calledWith:function calledWith(){var l=arguments.length;if(l>this.args.length){return false;}for(var i=0;i<l;i+=1){if(!s.deepEqual(arguments[i],this.args[i])){return false;}}return true;},calledWithMatch:function calledWithMatch(){var l=arguments.length;if(l>this.args.length){return false;}for(var i=0;i<l;i+=1){var h=this.args[i];var j=arguments[i];if(!s.match||!s.match(j).test(h)){return false;}}return true;},calledWithExactly:function calledWithExactly(){return arguments.length==this.args.length&&this.calledWith.apply(this,arguments);},notCalledWith:function notCalledWith(){return!this.calledWith.apply(this,arguments);},notCalledWithMatch:function notCalledWithMatch(){return!this.calledWithMatch.apply(this,arguments);},returned:function returned(v){return s.deepEqual(v,this.returnValue);},threw:function threw(h){if(typeof h==="undefined"||!this.exception){return!!this.exception;}return this.exception===h||this.exception.name===h;},calledWithNew:function calledWithNew(){return this.proxy.prototype&&this.thisValue instanceof this.proxy;},calledBefore:function(o){return this.callId<o.callId;},calledAfter:function(o){return this.callId>o.callId;},callArg:function(p){this.args[p]();},callArgOn:function(p,h){this.args[p].apply(h);},callArgWith:function(p){this.callArgOnWith.apply(this,[p,null].concat(d.call(arguments,1)));},callArgOnWith:function(p,h){var i=d.call(arguments,2);this.args[p].apply(h,i);},yield:function(){this.yieldOn.apply(this,[null].concat(d.call(arguments,0)));},yieldOn:function(h){var j=this.args;for(var i=0,l=j.length;i<l;++i){if(typeof j[i]==="function"){j[i].apply(h,d.call(arguments,1));return;}}t(this.proxy," cannot yield since no callback was passed.",j);},yieldTo:function(p){this.yieldToOn.apply(this,[p,null].concat(d.call(arguments,1)));},yieldToOn:function(p,h){var j=this.args;for(var i=0,l=j.length;i<l;++i){if(j[i]&&typeof j[i][p]==="function"){j[i][p].apply(h,d.call(arguments,2));return;}}t(this.proxy," cannot yield to '"+p+"' since no callback was passed.",j);},toString:function(){var h=this.proxy.toString()+"(";var j=[];for(var i=0,l=this.args.length;i<l;++i){j.push(s.format(this.args[i]));}h=h+j.join(", ")+")";if(typeof this.returnValue!="undefined"){h+=" => "+s.format(this.returnValue);}if(this.exception){h+=" !"+this.exception.name;if(this.exception.message){h+="("+this.exception.message+")";}}return h;}};f.invokeCallback=f.yield;function g(h,i,j,r,k,l){if(typeof l!=="number"){throw new TypeError("Call id is not a number");}var p=s.create(f);p.proxy=h;p.thisValue=i;p.args=j;p.returnValue=r;p.exception=k;p.callId=l;return p;}g.toString=f.toString;s.spyCall=g;return g;}var a=typeof module!=="undefined"&&module.exports&&typeof require=="function";var b=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function c(r,d,f){var s=r("./util/core");r("./match");r("./format");f.exports=m(s);}if(b){define(c);}else if(a){c(require,module.exports,module);}else if(!s){return;}else{m(s);}}(typeof sinon=="object"&&sinon||null));
/**
  * Spy functions
  *
  * @author Christian Johansen (christian@cjohansen.no)
  * @license BSD
  *
  * Copyright (c) 2010-2013 Christian Johansen
  */
(function(sinon){function makeApi(sinon){var push=Array.prototype.push;var slice=Array.prototype.slice;var callId=0;function spy(o,p,t){if(!p&&typeof o=="function"){return spy.create(o);}if(!o&&!p){return spy.create(function(){});}if(t){var m=sinon.getPropertyDescriptor(o,p);for(var i=0;i<t.length;i++){m[t[i]]=spy.create(m[t[i]]);}return sinon.wrapMethod(o,p,m);}else{var a=o[p];return sinon.wrapMethod(o,p,spy.create(a));}}function matchingFake(f,a,s){if(!f){return;}for(var i=0,l=f.length;i<l;i++){if(f[i].matches(a,s)){return f[i];}}}function incrementCallCount(){this.called=true;this.callCount+=1;this.notCalled=false;this.calledOnce=this.callCount==1;this.calledTwice=this.callCount==2;this.calledThrice=this.callCount==3;}function createCallProperties(){this.firstCall=this.getCall(0);this.secondCall=this.getCall(1);this.thirdCall=this.getCall(2);this.lastCall=this.getCall(this.callCount-1);}var vars="a,b,c,d,e,f,g,h,i,j,k,l";function createProxy(func,proxyLength){var p;if(proxyLength){eval("p = (function proxy("+vars.substring(0,proxyLength*2-1)+") { return p.invoke(func, this, slice.call(arguments)); });");}else{p=function proxy(){return p.invoke(func,this,slice.call(arguments));};}return p;}var uuid=0;var spyApi={reset:function(){if(this.invoking){var a=new Error("Cannot reset Sinon function while invoking it. "+"Move the call to .reset outside of the callback.");a.name="InvalidResetException";throw a;}this.called=false;this.notCalled=true;this.calledOnce=false;this.calledTwice=false;this.calledThrice=false;this.callCount=0;this.firstCall=null;this.secondCall=null;this.thirdCall=null;this.lastCall=null;this.args=[];this.returnValues=[];this.thisValues=[];this.exceptions=[];this.callIds=[];if(this.fakes){for(var i=0;i<this.fakes.length;i++){this.fakes[i].reset();}}return this;},create:function create(f,s){var n;if(typeof f!="function"){f=function(){};}else{n=sinon.functionName(f);}if(!s){s=f.length;}var p=createProxy(f,s);sinon.extend(p,spy);delete p.create;sinon.extend(p,f);p.reset();p.prototype=f.prototype;p.displayName=n||"spy";p.toString=sinon.functionToString;p.instantiateFake=sinon.spy.create;p.id="spy#"+uuid++;return p;},invoke:function invoke(f,t,a){var m=matchingFake(this.fakes,a);var b,r;incrementCallCount.call(this);push.call(this.thisValues,t);push.call(this.args,a);push.call(this.callIds,callId++);createCallProperties.call(this);try{this.invoking=true;if(m){r=m.invoke(f,t,a);}else{r=(this.func||f).apply(t,a);}var c=this.getCall(this.callCount-1);if(c.calledWithNew()&&typeof r!=="object"){r=t;}}catch(e){b=e;}finally{delete this.invoking;}push.call(this.exceptions,b);push.call(this.returnValues,r);createCallProperties.call(this);if(b!==undefined){throw b;}return r;},named:function named(n){this.displayName=n;return this;},getCall:function getCall(i){if(i<0||i>=this.callCount){return null;}return sinon.spyCall(this,this.thisValues[i],this.args[i],this.returnValues[i],this.exceptions[i],this.callIds[i]);},getCalls:function(){var c=[];var i;for(i=0;i<this.callCount;i++){c.push(this.getCall(i));}return c;},calledBefore:function calledBefore(s){if(!this.called){return false;}if(!s.called){return true;}return this.callIds[0]<s.callIds[s.callIds.length-1];},calledAfter:function calledAfter(s){if(!this.called||!s.called){return false;}return this.callIds[this.callCount-1]>s.callIds[s.callCount-1];},withArgs:function(){var a=slice.call(arguments);if(this.fakes){var m=matchingFake(this.fakes,a,true);if(m){return m;}}else{this.fakes=[];}var o=this;var f=this.instantiateFake();f.matchingAguments=a;f.parent=this;push.call(this.fakes,f);f.withArgs=function(){return o.withArgs.apply(o,arguments);};for(var i=0;i<this.args.length;i++){if(f.matches(this.args[i])){incrementCallCount.call(f);push.call(f.thisValues,this.thisValues[i]);push.call(f.args,this.args[i]);push.call(f.returnValues,this.returnValues[i]);push.call(f.exceptions,this.exceptions[i]);push.call(f.callIds,this.callIds[i]);}}createCallProperties.call(f);return f;},matches:function(a,s){var m=this.matchingAguments;if(m.length<=a.length&&sinon.deepEqual(m,a.slice(0,m.length))){return!s||m.length==a.length;}},printf:function(f){var s=this;var a=slice.call(arguments,1);var b;return(f||"").replace(/%(.)/g,function(m,c){b=spyApi.formatters[c];if(typeof b=="function"){return b.call(null,s,a);}else if(!isNaN(parseInt(c,10))){return sinon.format(a[c-1]);}return"%"+c;});}};function delegateToCalls(m,a,b,n){spyApi[m]=function(){if(!this.called){if(n){return n.apply(this,arguments);}return false;}var c;var d=0;for(var i=0,l=this.callCount;i<l;i+=1){c=this.getCall(i);if(c[b||m].apply(c,arguments)){d+=1;if(a){return true;}}}return d===this.callCount;};}delegateToCalls("calledOn",true);delegateToCalls("alwaysCalledOn",false,"calledOn");delegateToCalls("calledWith",true);delegateToCalls("calledWithMatch",true);delegateToCalls("alwaysCalledWith",false,"calledWith");delegateToCalls("alwaysCalledWithMatch",false,"calledWithMatch");delegateToCalls("calledWithExactly",true);delegateToCalls("alwaysCalledWithExactly",false,"calledWithExactly");delegateToCalls("neverCalledWith",false,"notCalledWith",function(){return true;});delegateToCalls("neverCalledWithMatch",false,"notCalledWithMatch",function(){return true;});delegateToCalls("threw",true);delegateToCalls("alwaysThrew",false,"threw");delegateToCalls("returned",true);delegateToCalls("alwaysReturned",false,"returned");delegateToCalls("calledWithNew",true);delegateToCalls("alwaysCalledWithNew",false,"calledWithNew");delegateToCalls("callArg",false,"callArgWith",function(){throw new Error(this.toString()+" cannot call arg since it was not yet invoked.");});spyApi.callArgWith=spyApi.callArg;delegateToCalls("callArgOn",false,"callArgOnWith",function(){throw new Error(this.toString()+" cannot call arg since it was not yet invoked.");});spyApi.callArgOnWith=spyApi.callArgOn;delegateToCalls("yield",false,"yield",function(){throw new Error(this.toString()+" cannot yield since it was not yet invoked.");});spyApi.invokeCallback=spyApi.yield;delegateToCalls("yieldOn",false,"yieldOn",function(){throw new Error(this.toString()+" cannot yield since it was not yet invoked.");});delegateToCalls("yieldTo",false,"yieldTo",function(p){throw new Error(this.toString()+" cannot yield to '"+p+"' since it was not yet invoked.");});delegateToCalls("yieldToOn",false,"yieldToOn",function(p){throw new Error(this.toString()+" cannot yield to '"+p+"' since it was not yet invoked.");});spyApi.formatters={c:function(s){return sinon.timesInWords(s.callCount);},n:function(s){return s.toString();},C:function(s){var c=[];for(var i=0,l=s.callCount;i<l;++i){var a="    "+s.getCall(i).toString();if(/\n/.test(c[i-1])){a="\n"+a;}push.call(c,a);}return c.length>0?"\n"+c.join("\n"):"";},t:function(s){var o=[];for(var i=0,l=s.callCount;i<l;++i){push.call(o,sinon.format(s.thisValues[i]));}return o.join(", ");},"*":function(s,a){var f=[];for(var i=0,l=a.length;i<l;++i){push.call(f,sinon.format(a[i]));}return f.join(", ");}};sinon.extend(spy,spyApi);spy.spyCall=sinon.spyCall;sinon.spy=spy;return spy;}var isNode=typeof module!=="undefined"&&module.exports&&typeof require=="function";var isAMD=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function loadDependencies(r,a,m){var s=r("./util/core");r("./call");r("./extend");r("./times_in_words");r("./format");m.exports=makeApi(s);}if(isAMD){define(loadDependencies);}else if(isNode){loadDependencies(require,module.exports,module);}else if(!sinon){return;}else{makeApi(sinon);}}(typeof sinon=="object"&&sinon||null));
/**
 * Stub behavior
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @author Tim Fischbach (mail@timfischbach.de)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
(function(s){var a=Array.prototype.slice;var j=Array.prototype.join;var u=-1;var b=-2;var n=(function(){if(typeof process==="object"&&typeof process.nextTick==="function"){return process.nextTick;}else if(typeof setImmediate==="function"){return setImmediate;}else{return function(h){setTimeout(h,0);};}})();function t(h,i){if(typeof h=="string"){this.exception=new Error(i||"");this.exception.name=h;}else if(!h){this.exception=new Error("Error");}else{this.exception=h;}return this;}function g(h,k){var o=h.callArgAt;if(o>=0){return k[o];}var p;if(o===u){p=k;}if(o===b){p=a.call(k).reverse();}var q=h.callArgProp;for(var i=0,l=p.length;i<l;++i){if(!q&&typeof p[i]=="function"){return p[i];}if(q&&p[i]&&typeof p[i][q]=="function"){return p[i][q];}}return null;}function m(s){function h(l,o,q){if(l.callArgAt<0){var r;if(l.callArgProp){r=s.functionName(l.stub)+" expected to yield to '"+l.callArgProp+"', but no object with such a property was passed.";}else{r=s.functionName(l.stub)+" expected to yield, but no callback was passed.";}if(q.length>0){r+=" Received ["+j.call(q,", ")+"]";}return r;}return"argument at index "+l.callArgAt+" is not a function: "+o;}function i(l,o){if(typeof l.callArgAt=="number"){var q=g(l,o);if(typeof q!="function"){throw new TypeError(h(l,q,o));}if(l.callbackAsync){n(function(){q.apply(l.callbackContext,l.callbackArguments);});}else{q.apply(l.callbackContext,l.callbackArguments);}}}var p={create:function create(l){var o=s.extend({},s.behavior);delete o.create;o.stub=l;return o;},isPresent:function isPresent(){return(typeof this.callArgAt=="number"||this.exception||typeof this.returnArgAt=="number"||this.returnThis||this.returnValueDefined);},invoke:function invoke(l,o){i(this,o);if(this.exception){throw this.exception;}else if(typeof this.returnArgAt=="number"){return o[this.returnArgAt];}else if(this.returnThis){return l;}return this.returnValue;},onCall:function onCall(l){return this.stub.onCall(l);},onFirstCall:function onFirstCall(){return this.stub.onFirstCall();},onSecondCall:function onSecondCall(){return this.stub.onSecondCall();},onThirdCall:function onThirdCall(){return this.stub.onThirdCall();},withArgs:function withArgs(){throw new Error("Defining a stub by invoking \"stub.onCall(...).withArgs(...)\" is not supported. "+"Use \"stub.withArgs(...).onCall(...)\" to define sequential behavior for calls with certain arguments.");},callsArg:function callsArg(l){if(typeof l!="number"){throw new TypeError("argument index is not number");}this.callArgAt=l;this.callbackArguments=[];this.callbackContext=undefined;this.callArgProp=undefined;this.callbackAsync=false;return this;},callsArgOn:function callsArgOn(l,o){if(typeof l!="number"){throw new TypeError("argument index is not number");}if(typeof o!="object"){throw new TypeError("argument context is not an object");}this.callArgAt=l;this.callbackArguments=[];this.callbackContext=o;this.callArgProp=undefined;this.callbackAsync=false;return this;},callsArgWith:function callsArgWith(l){if(typeof l!="number"){throw new TypeError("argument index is not number");}this.callArgAt=l;this.callbackArguments=a.call(arguments,1);this.callbackContext=undefined;this.callArgProp=undefined;this.callbackAsync=false;return this;},callsArgOnWith:function callsArgWith(l,o){if(typeof l!="number"){throw new TypeError("argument index is not number");}if(typeof o!="object"){throw new TypeError("argument context is not an object");}this.callArgAt=l;this.callbackArguments=a.call(arguments,2);this.callbackContext=o;this.callArgProp=undefined;this.callbackAsync=false;return this;},yields:function(){this.callArgAt=u;this.callbackArguments=a.call(arguments,0);this.callbackContext=undefined;this.callArgProp=undefined;this.callbackAsync=false;return this;},yieldsRight:function(){this.callArgAt=b;this.callbackArguments=a.call(arguments,0);this.callbackContext=undefined;this.callArgProp=undefined;this.callbackAsync=false;return this;},yieldsOn:function(l){if(typeof l!="object"){throw new TypeError("argument context is not an object");}this.callArgAt=u;this.callbackArguments=a.call(arguments,1);this.callbackContext=l;this.callArgProp=undefined;this.callbackAsync=false;return this;},yieldsTo:function(l){this.callArgAt=u;this.callbackArguments=a.call(arguments,1);this.callbackContext=undefined;this.callArgProp=l;this.callbackAsync=false;return this;},yieldsToOn:function(l,o){if(typeof o!="object"){throw new TypeError("argument context is not an object");}this.callArgAt=u;this.callbackArguments=a.call(arguments,2);this.callbackContext=o;this.callArgProp=l;this.callbackAsync=false;return this;},throws:t,throwsException:t,returns:function returns(v){this.returnValue=v;this.returnValueDefined=true;return this;},returnsArg:function returnsArg(l){if(typeof l!="number"){throw new TypeError("argument index is not number");}this.returnArgAt=l;return this;},returnsThis:function returnsThis(){this.returnThis=true;return this;}};for(var k in p){if(p.hasOwnProperty(k)&&k.match(/^(callsArg|yields)/)&&!k.match(/Async/)){p[k+"Async"]=(function(l){return function(){var r=this[l].apply(this,arguments);this.callbackAsync=true;return r;};})(k);}}s.behavior=p;return p;}var c=typeof module!=="undefined"&&module.exports&&typeof require=="function";var d=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function f(r,h,i){var s=r("./util/core");r("./extend");i.exports=m(s);}if(d){define(f);}else if(c){f(require,module.exports,module);}else if(!s){return;}else{m(s);}}(typeof sinon=="object"&&sinon||null));
/**
 * Stub functions
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
(function(s){function m(s){function c(o,j,k){if(!!k&&typeof k!="function"&&typeof k!="object"){throw new TypeError("Custom stub should be a function or a property descriptor");}var w;if(k){if(typeof k=="function"){w=s.spy&&s.spy.create?s.spy.create(k):k;}else{w=k;if(s.spy&&s.spy.create){var t=s.objectKeys(w);for(var i=0;i<t.length;i++){w[t[i]]=s.spy.create(w[t[i]]);}}}}else{var n=0;if(typeof o=="object"&&typeof o[j]=="function"){n=o[j].length;}w=c.create(n);}if(!o&&typeof j==="undefined"){return s.stub.create();}if(typeof j==="undefined"&&typeof o=="object"){for(var q in o){if(typeof o[q]==="function"){c(o,q);}}return o;}return s.wrapMethod(o,j,w);}function g(c){return c.defaultBehavior||d(c)||s.behavior.create(c);}function d(c){return(c.parent&&f(c.parent));}function f(c){var i=c.behaviors[c.callCount-1];return i&&i.isPresent()?i:g(c);}var u=0;var p={create:function create(i){var j=function(){return f(j).invoke(this,arguments);};j.id="stub#"+u++;var o=j;j=s.spy.create(j,i);j.func=o;s.extend(j,c);j.instantiateFake=s.stub.create;j.displayName="stub";j.toString=s.functionToString;j.defaultBehavior=null;j.behaviors=[];return j;},resetBehavior:function(){var i;this.defaultBehavior=null;this.behaviors=[];delete this.returnValue;delete this.returnArgAt;this.returnThis=false;if(this.fakes){for(i=0;i<this.fakes.length;i++){this.fakes[i].resetBehavior();}}},onCall:function onCall(i){if(!this.behaviors[i]){this.behaviors[i]=s.behavior.create(this);}return this.behaviors[i];},onFirstCall:function onFirstCall(){return this.onCall(0);},onSecondCall:function onSecondCall(){return this.onCall(1);},onThirdCall:function onThirdCall(){return this.onCall(2);}};for(var h in s.behavior){if(s.behavior.hasOwnProperty(h)&&!p.hasOwnProperty(h)&&h!="create"&&h!="withArgs"&&h!="invoke"){p[h]=(function(i){return function(){this.defaultBehavior=this.defaultBehavior||s.behavior.create(this);this.defaultBehavior[i].apply(this.defaultBehavior,arguments);return this;};}(h));}}s.extend(c,p);s.stub=c;return c;}var a=typeof module!=="undefined"&&module.exports&&typeof require=="function";var b=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function l(r,c,d){var s=r("./util/core");r("./behavior");r("./spy");r("./extend");d.exports=m(s);}if(b){define(l);}else if(a){l(require,module.exports,module);}else if(!s){return;}else{m(s);}}(typeof sinon=="object"&&sinon||null));
/**
 * Mock functions.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
(function(s){function m(s){var p=[].push;var d=s.match;function f(o){if(!o){return s.expectation.create("Anonymous mock");}return f.create(o);}function g(o,q){if(!o){return;}for(var i=0,l=o.length;i<l;i+=1){q(o[i]);}}s.extend(f,{create:function create(o){if(!o){throw new TypeError("object is null");}var i=s.extend({},f);i.object=o;delete i.create;return i;},expects:function expects(i){if(!i){throw new TypeError("method is falsy");}if(!this.expectations){this.expectations={};this.proxies=[];}if(!this.expectations[i]){this.expectations[i]=[];var l=this;s.wrapMethod(this.object,i,function(){return l.invokeMethod(i,this,arguments);});p.call(this.proxies,i);}var o=s.expectation.create(i);p.call(this.expectations[i],o);return o;},restore:function restore(){var o=this.object;g(this.proxies,function(i){if(typeof o[i].restore=="function"){o[i].restore();}});},verify:function verify(){var i=this.expectations||{};var l=[],o=[];g(this.proxies,function(q){g(i[q],function(u){if(!u.met()){p.call(l,u.toString());}else{p.call(o,u.toString());}});});this.restore();if(l.length>0){s.expectation.fail(l.concat(o).join("\n"));}else if(o.length>0){s.expectation.pass(l.concat(o).join("\n"));}return true;},invokeMethod:function invokeMethod(l,o,q){var u=this.expectations&&this.expectations[l];var w=u&&u.length||0,i;for(i=0;i<w;i+=1){if(!u[i].met()&&u[i].allowsCall(o,q)){return u[i].apply(o,q);}}var x=[],y,z=0;for(i=0;i<w;i+=1){if(u[i].allowsCall(o,q)){y=y||u[i];}else{z+=1;}p.call(x,"    "+u[i].toString());}if(z===0){return y.apply(o,q);}x.unshift("Unexpected call: "+s.spyCall.toString.call({proxy:l,args:q}));s.expectation.fail(x.join("\n"));}});var t=s.timesInWords;var h=Array.prototype.slice;function j(i){if(i==0){return"never called";}else{return"called "+t(i);}}function k(i){var l=i.minCalls;var o=i.maxCalls;if(typeof l=="number"&&typeof o=="number"){var q=t(l);if(l!=o){q="at least "+q+" and at most "+t(o);}return q;}if(typeof l=="number"){return"at least "+t(l);}return"at most "+t(o);}function r(i){var l=typeof i.minCalls=="number";return!l||i.callCount>=i.minCalls;}function n(i){if(typeof i.maxCalls!="number"){return false;}return i.callCount==i.maxCalls;}function v(i,l){if(d&&d.isMatcher(i)){return i.test(l);}else{return true;}}s.expectation={minCalls:1,maxCalls:1,create:function create(i){var l=s.extend(s.stub.create(),s.expectation);delete l.create;l.method=i;return l;},invoke:function invoke(i,l,o){this.verifyCallAllowed(l,o);return s.spy.invoke.apply(this,arguments);},atLeast:function atLeast(i){if(typeof i!="number"){throw new TypeError("'"+i+"' is not number");}if(!this.limitsSet){this.maxCalls=null;this.limitsSet=true;}this.minCalls=i;return this;},atMost:function atMost(i){if(typeof i!="number"){throw new TypeError("'"+i+"' is not number");}if(!this.limitsSet){this.minCalls=null;this.limitsSet=true;}this.maxCalls=i;return this;},never:function never(){return this.exactly(0);},once:function once(){return this.exactly(1);},twice:function twice(){return this.exactly(2);},thrice:function thrice(){return this.exactly(3);},exactly:function exactly(i){if(typeof i!="number"){throw new TypeError("'"+i+"' is not a number");}this.atLeast(i);return this.atMost(i);},met:function met(){return!this.failed&&r(this);},verifyCallAllowed:function verifyCallAllowed(o,q){if(n(this)){this.failed=true;s.expectation.fail(this.method+" already called "+t(this.maxCalls));}if("expectedThis"in this&&this.expectedThis!==o){s.expectation.fail(this.method+" called with "+o+" as thisValue, expected "+this.expectedThis);}if(!("expectedArguments"in this)){return;}if(!q){s.expectation.fail(this.method+" received no arguments, expected "+s.format(this.expectedArguments));}if(q.length<this.expectedArguments.length){s.expectation.fail(this.method+" received too few arguments ("+s.format(q)+"), expected "+s.format(this.expectedArguments));}if(this.expectsExactArgCount&&q.length!=this.expectedArguments.length){s.expectation.fail(this.method+" received too many arguments ("+s.format(q)+"), expected "+s.format(this.expectedArguments));}for(var i=0,l=this.expectedArguments.length;i<l;i+=1){if(!v(this.expectedArguments[i],q[i])){s.expectation.fail(this.method+" received wrong arguments "+s.format(q)+", didn't match "+this.expectedArguments.toString());}if(!s.deepEqual(this.expectedArguments[i],q[i])){s.expectation.fail(this.method+" received wrong arguments "+s.format(q)+", expected "+s.format(this.expectedArguments));}}},allowsCall:function allowsCall(o,q){if(this.met()&&n(this)){return false;}if("expectedThis"in this&&this.expectedThis!==o){return false;}if(!("expectedArguments"in this)){return true;}q=q||[];if(q.length<this.expectedArguments.length){return false;}if(this.expectsExactArgCount&&q.length!=this.expectedArguments.length){return false;}for(var i=0,l=this.expectedArguments.length;i<l;i+=1){if(!v(this.expectedArguments[i],q[i])){return false;}if(!s.deepEqual(this.expectedArguments[i],q[i])){return false;}}return true;},withArgs:function withArgs(){this.expectedArguments=h.call(arguments);return this;},withExactArgs:function withExactArgs(){this.withArgs.apply(this,arguments);this.expectsExactArgCount=true;return this;},on:function on(i){this.expectedThis=i;return this;},toString:function(){var i=(this.expectedArguments||[]).slice();if(!this.expectsExactArgCount){p.call(i,"[...]");}var l=s.spyCall.toString.call({proxy:this.method||"anonymous mock expectation",args:i});var o=l.replace(", [...","[, ...")+" "+k(this);if(this.met()){return"Expectation met: "+o;}return"Expected "+o+" ("+j(this.callCount)+")";},verify:function verify(){if(!this.met()){s.expectation.fail(this.toString());}else{s.expectation.pass(this.toString());}return true;},pass:function pass(i){s.assert.pass(i);},fail:function fail(i){var l=new Error(i);l.name="ExpectationError";throw l;}};s.mock=f;return f;}var a=typeof module!=="undefined"&&module.exports&&typeof require=="function";var b=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function c(r,d,f){var s=r("./util/core");r("./times_in_words");r("./call");r("./extend");r("./match");r("./spy");r("./stub");r("./format");f.exports=m(s);}if(b){define(c);}else if(a){c(require,module.exports,module);}else if(!s){return;}else{m(s);}}(typeof sinon=="object"&&sinon||null));
/**
 * Collections of stubs, spies and mocks.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
(function(s){var p=[].push;var h=Object.prototype.hasOwnProperty;function g(i){if(!i.fakes){i.fakes=[];}return i.fakes;}function a(j,k){var n=g(j);for(var i=0,l=n.length;i<l;i+=1){if(typeof n[i][k]=="function"){n[i][k]();}}}function c(j){var k=g(j);var i=0;while(i<k.length){k.splice(i,1);}}function m(s){var i={verify:function resolve(){a(this,"verify");},restore:function restore(){a(this,"restore");c(this);},reset:function restore(){a(this,"reset");},verifyAndRestore:function verifyAndRestore(){var j;try{this.verify();}catch(e){j=e;}this.restore();if(j){throw j;}},add:function add(j){p.call(g(this),j);return j;},spy:function spy(){return this.add(s.spy.apply(s,arguments));},stub:function stub(o,j,v){if(j){var k=o[j];if(typeof k!="function"){if(!h.call(o,j)){throw new TypeError("Cannot stub non-existent own property "+j);}o[j]=v;return this.add({restore:function(){o[j]=k;}});}}if(!j&&!!o&&typeof o=="object"){var l=s.stub.apply(s,arguments);for(var n in l){if(typeof l[n]==="function"){this.add(l[n]);}}return l;}return this.add(s.stub.apply(s,arguments));},mock:function mock(){return this.add(s.mock.apply(s,arguments));},inject:function inject(o){var j=this;o.spy=function(){return j.spy.apply(j,arguments);};o.stub=function(){return j.stub.apply(j,arguments);};o.mock=function(){return j.mock.apply(j,arguments);};return o;}};s.collection=i;return i;}var b=typeof module!=="undefined"&&module.exports&&typeof require=="function";var d=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function f(r,i,j){var s=r("./util/core");r("./mock");r("./spy");r("./stub");j.exports=m(s);}if(d){define(f);}else if(b){f(require,module.exports,module);}else if(!s){return;}else{m(s);}}(typeof sinon=="object"&&sinon||null));
/**
 * Fake timer API
 * setTimeout
 * setInterval
 * clearTimeout
 * clearInterval
 * tick
 * reset
 * Date
 *
 * Inspired by jsUnitMockTimeOut from JsUnit
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
if(typeof sinon=="undefined"){var sinon={};}(function(g){function m(s,b){var c=typeof lolex!=="undefined"?lolex:b;s.useFakeTimers=function(){var n,d=Array.prototype.slice.call(arguments);if(typeof d[0]==="string"){n=0;}else{n=d.shift();}var f=c.install(n||0,d);f.restore=f.uninstall;return f;};s.clock={create:function(n){return c.createClock(n);}};s.timers={setTimeout:setTimeout,clearTimeout:clearTimeout,setImmediate:(typeof setImmediate!=="undefined"?setImmediate:undefined),clearImmediate:(typeof clearImmediate!=="undefined"?clearImmediate:undefined),setInterval:setInterval,clearInterval:clearInterval,Date:Date};}var i=typeof module!=="undefined"&&module.exports&&typeof require=="function";var a=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function l(r,b,c,d){var s=r("./core");m(s,d);c.exports=s;}if(a){define(l);}else if(i){l(require,module.exports,module,require("lolex"));}else{m(sinon);}}(typeof global!="undefined"&&typeof global!=="function"?global:this));
/**
 * Minimal Event interface implementation
 *
 * Original implementation by Sven Fuchs: https://gist.github.com/995028
 * Modifications and tests by Christian Johansen.
 *
 * @author Sven Fuchs (svenfuchs@artweb-design.de)
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2011 Sven Fuchs, Christian Johansen
 */
if(typeof sinon=="undefined"){this.sinon={};}(function(){var p=[].push;function m(s){s.Event=function Event(t,d,f,g){this.initEvent(t,d,f,g);};s.Event.prototype={initEvent:function(t,d,f,g){this.type=t;this.bubbles=d;this.cancelable=f;this.target=g;},stopPropagation:function(){},preventDefault:function(){this.defaultPrevented=true;}};s.ProgressEvent=function ProgressEvent(t,d,f){this.initEvent(t,false,false,f);this.loaded=d.loaded||null;this.total=d.total||null;this.lengthComputable=!!d.total;};s.ProgressEvent.prototype=new s.Event();s.ProgressEvent.prototype.constructor=s.ProgressEvent;s.CustomEvent=function CustomEvent(t,d,f){this.initEvent(t,false,false,f);this.detail=d.detail||null;};s.CustomEvent.prototype=new s.Event();s.CustomEvent.prototype.constructor=s.CustomEvent;s.EventTarget={addEventListener:function addEventListener(d,l){this.eventListeners=this.eventListeners||{};this.eventListeners[d]=this.eventListeners[d]||[];p.call(this.eventListeners[d],l);},removeEventListener:function removeEventListener(d,f){var g=this.eventListeners&&this.eventListeners[d]||[];for(var i=0,l=g.length;i<l;++i){if(g[i]==f){return g.splice(i,1);}}},dispatchEvent:function dispatchEvent(d){var t=d.type;var l=this.eventListeners&&this.eventListeners[t]||[];for(var i=0;i<l.length;i++){if(typeof l[i]=="function"){l[i].call(this,d);}else{l[i].handleEvent(d);}}return!!d.defaultPrevented;}};}var a=typeof module!=="undefined"&&module.exports&&typeof require=="function";var b=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function c(r){var s=r("./core");m(s);}if(b){define(c);}else if(a){c(require);}else{m(sinon);}}());
/**
 * Logs errors
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2014 Christian Johansen
 */
(function(s){var r=setTimeout;function m(s){function b(){}function c(f,g){var h=f+" threw exception: ";s.log(h+"["+g.name+"] "+g.message);if(g.stack){s.log(g.stack);}c.setTimeout(function(){g.message=h+g.message;throw g;},0);};c.setTimeout=function(f,t){r(f,t);};var d={};d.log=s.log=b;d.logError=s.logError=c;return d;}function l(b,c,d){var s=b("./util/core");d.exports=m(s);}var i=typeof module!=="undefined"&&module.exports&&typeof require=="function";var a=typeof define==="function"&&typeof define.amd==="object"&&define.amd;if(a){define(l);}else if(i){l(require,module.exports,module);}else if(!s){return;}else{m(s);}}(typeof sinon=="object"&&sinon||null));if(typeof sinon=="undefined"){this.sinon={};}(function(g){var x={XDomainRequest:g.XDomainRequest};x.GlobalXDomainRequest=g.XDomainRequest;x.supportsXDR=typeof x.GlobalXDomainRequest!="undefined";x.workingXDR=x.supportsXDR?x.GlobalXDomainRequest:false;function m(s){s.xdr=x;function F(){this.readyState=F.UNSENT;this.requestBody=null;this.requestHeaders={};this.status=0;this.timeout=null;if(typeof F.onCreate=="function"){F.onCreate(this);}}function v(x){if(x.readyState!==F.OPENED){throw new Error("INVALID_STATE_ERR");}if(x.sendFlag){throw new Error("INVALID_STATE_ERR");}}function b(x){if(x.readyState==F.UNSENT){throw new Error("Request not sent");}if(x.readyState==F.DONE){throw new Error("Request done");}}function c(d){if(typeof d!="string"){var f=new Error("Attempted to respond to fake XDomainRequest with "+d+", which is not a string.");f.name="InvalidBodyException";throw f;}}s.extend(F.prototype,s.EventTarget,{open:function open(d,u){this.method=d;this.url=u;this.responseText=null;this.sendFlag=false;this.readyStateChange(F.OPENED);},readyStateChange:function readyStateChange(d){this.readyState=d;var f="";switch(this.readyState){case F.UNSENT:break;case F.OPENED:break;case F.LOADING:if(this.sendFlag){f="onprogress";}break;case F.DONE:if(this.isTimeout){f="ontimeout"}else if(this.errorFlag||(this.status<200||this.status>299)){f="onerror";}else{f="onload"}break;}if(f){if(typeof this[f]=="function"){try{this[f]();}catch(e){s.logError("Fake XHR "+f+" handler",e);}}}},send:function send(d){v(this);if(!/^(get|head)$/i.test(this.method)){this.requestBody=d;}this.requestHeaders["Content-Type"]="text/plain;charset=utf-8";this.errorFlag=false;this.sendFlag=true;this.readyStateChange(F.OPENED);if(typeof this.onSend=="function"){this.onSend(this);}},abort:function abort(){this.aborted=true;this.responseText=null;this.errorFlag=true;if(this.readyState>s.FakeXDomainRequest.UNSENT&&this.sendFlag){this.readyStateChange(s.FakeXDomainRequest.DONE);this.sendFlag=false;}},setResponseBody:function setResponseBody(d){b(this);c(d);var f=this.chunkSize||10;var h=0;this.responseText="";do{this.readyStateChange(F.LOADING);this.responseText+=d.substring(h,h+f);h+=f;}while(h<d.length);this.readyStateChange(F.DONE);},respond:function respond(d,f,h){this.status=typeof d=="number"?d:200;this.setResponseBody(h||"");},simulatetimeout:function simulatetimeout(){this.status=0;this.isTimeout=true;this.responseText=undefined;this.readyStateChange(F.DONE);}});s.extend(F,{UNSENT:0,OPENED:1,LOADING:3,DONE:4});s.useFakeXDomainRequest=function useFakeXDomainRequest(){s.FakeXDomainRequest.restore=function restore(k){if(x.supportsXDR){g.XDomainRequest=x.GlobalXDomainRequest;}delete s.FakeXDomainRequest.restore;if(k!==true){delete s.FakeXDomainRequest.onCreate;}};if(x.supportsXDR){g.XDomainRequest=s.FakeXDomainRequest;}return s.FakeXDomainRequest;};s.FakeXDomainRequest=F;}var i=typeof module!=="undefined"&&module.exports&&typeof require=="function";var a=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function l(r,b,c){var s=r("./core");r("../extend");r("./event");r("../log_error");m(s);c.exports=s;}if(a){define(l);}else if(i){l(require,module.exports,module);}else{m(sinon);}})(this);
/**
 * Fake XMLHttpRequest object
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
(function(g){var s=typeof ProgressEvent!=="undefined";var a=typeof CustomEvent!=="undefined";var b={XMLHttpRequest:g.XMLHttpRequest};b.GlobalXMLHttpRequest=g.XMLHttpRequest;b.GlobalActiveXObject=g.ActiveXObject;b.supportsActiveX=typeof b.GlobalActiveXObject!="undefined";b.supportsXHR=typeof b.GlobalXMLHttpRequest!="undefined";b.workingXHR=b.supportsXHR?b.GlobalXMLHttpRequest:b.supportsActiveX?function(){return new b.GlobalActiveXObject("MSXML2.XMLHTTP.3.0")}:false;b.supportsCORS=b.supportsXHR&&"withCredentials"in(new b.GlobalXMLHttpRequest());var u={"Accept-Charset":true,"Accept-Encoding":true,Connection:true,"Content-Length":true,Cookie:true,Cookie2:true,"Content-Transfer-Encoding":true,Date:true,Expect:true,Host:true,"Keep-Alive":true,Referer:true,TE:true,Trailer:true,"Transfer-Encoding":true,Upgrade:true,"User-Agent":true,Via:true};function F(){this.readyState=F.UNSENT;this.requestHeaders={};this.requestBody=null;this.status=0;this.statusText="";this.upload=new U();if(b.supportsCORS){this.withCredentials=false;}var x=this;var h=["loadstart","load","abort","loadend"];function l(w){x.addEventListener(w,function(y){var z=x["on"+w];if(z&&typeof z=="function"){z.call(this,y);}});}for(var i=h.length-1;i>=0;i--){l(h[i]);}if(typeof F.onCreate=="function"){F.onCreate(this);}}function U(){this.eventListeners={progress:[],load:[],abort:[],error:[]}}U.prototype.addEventListener=function addEventListener(h,l){this.eventListeners[h].push(l);};U.prototype.removeEventListener=function removeEventListener(h,w){var x=this.eventListeners[h]||[];for(var i=0,l=x.length;i<l;++i){if(x[i]==w){return x.splice(i,1);}}};U.prototype.dispatchEvent=function dispatchEvent(h){var l=this.eventListeners[h.type]||[];for(var i=0,w;(w=l[i])!=null;i++){w(h);}};function v(x){if(x.readyState!==F.OPENED){throw new Error("INVALID_STATE_ERR");}if(x.sendFlag){throw new Error("INVALID_STATE_ERR");}}function c(i,l){l=l.toLowerCase();for(var h in i){if(h.toLowerCase()==l){return h;}}return null;}function d(h,w){if(!h){return;}for(var i=0,l=h.length;i<l;i+=1){w(h[i]);}}function f(h,i){for(var l=0;l<h.length;l++){if(i(h[l])===true){return true;}}return false;}var j=function(h,i,l){switch(l.length){case 0:return h[i]();case 1:return h[i](l[0]);case 2:return h[i](l[0],l[1]);case 3:return h[i](l[0],l[1],l[2]);case 4:return h[i](l[0],l[1],l[2],l[3]);case 5:return h[i](l[0],l[1],l[2],l[3],l[4]);}};F.filters=[];F.addFilter=function addFilter(h){this.filters.push(h)};var I=/MSIE [6-9]/;F.defake=function defake(h,x){var i=new b.workingXHR();d(["open","setRequestHeader","send","abort","getResponseHeader","getAllResponseHeaders","addEventListener","overrideMimeType","removeEventListener"],function(z){h[z]=function(){return j(i,z,arguments);};});var l=function(z){d(z,function(A){try{h[A]=i[A]}catch(e){if(!I.test(navigator.userAgent)&&"The data necessary to complete this operation is not yet available.\r\n"!==e.message){throw e;}}});};var w=function w(){h.readyState=i.readyState;if(i.readyState>=F.HEADERS_RECEIVED){l(["status","statusText"]);}if(i.readyState>=F.LOADING){l(["responseText","response"]);}if(i.readyState===F.DONE){l(["responseXML"]);}if(h.onreadystatechange){h.onreadystatechange.call(h,{target:h});}};if(i.addEventListener){for(var y in h.eventListeners){if(h.eventListeners.hasOwnProperty(y)){d(h.eventListeners[y],function(z){i.addEventListener(y,z);});}}i.addEventListener("readystatechange",w);}else{i.onreadystatechange=w;}j(i,"open",x);};F.useFilters=false;function k(x){if(x.readyState!=F.OPENED){throw new Error("INVALID_STATE_ERR - "+x.readyState);}}function m(x){if(x.readyState==F.DONE){throw new Error("Request done");}}function n(x){if(x.async&&x.readyState!=F.HEADERS_RECEIVED){throw new Error("No headers received");}}function o(h){if(typeof h!="string"){var i=new Error("Attempted to respond to fake XMLHttpRequest with "+h+", which is not a string.");i.name="InvalidBodyException";throw i;}}F.parseXML=function parseXML(h){var x;if(typeof DOMParser!="undefined"){var i=new DOMParser();x=i.parseFromString(h,"text/xml");}else{x=new ActiveXObject("Microsoft.XMLDOM");x.async="false";x.loadXML(h);}return x;};F.statusCodes={100:"Continue",101:"Switching Protocols",200:"OK",201:"Created",202:"Accepted",203:"Non-Authoritative Information",204:"No Content",205:"Reset Content",206:"Partial Content",207:"Multi-Status",300:"Multiple Choice",301:"Moved Permanently",302:"Found",303:"See Other",304:"Not Modified",305:"Use Proxy",307:"Temporary Redirect",400:"Bad Request",401:"Unauthorized",402:"Payment Required",403:"Forbidden",404:"Not Found",405:"Method Not Allowed",406:"Not Acceptable",407:"Proxy Authentication Required",408:"Request Timeout",409:"Conflict",410:"Gone",411:"Length Required",412:"Precondition Failed",413:"Request Entity Too Large",414:"Request-URI Too Long",415:"Unsupported Media Type",416:"Requested Range Not Satisfiable",417:"Expectation Failed",422:"Unprocessable Entity",500:"Internal Server Error",501:"Not Implemented",502:"Bad Gateway",503:"Service Unavailable",504:"Gateway Timeout",505:"HTTP Version Not Supported"};function p(h){h.xhr=b;h.extend(F.prototype,h.EventTarget,{async:true,open:function open(i,l,w,x,y){this.method=i;this.url=l;this.async=typeof w=="boolean"?w:true;this.username=x;this.password=y;this.responseText=null;this.responseXML=null;this.requestHeaders={};this.sendFlag=false;if(F.useFilters===true){var z=arguments;var A=f(F.filters,function(B){return B.apply(this,z)});if(A){return F.defake(this,arguments);}}this.readyStateChange(F.OPENED);},readyStateChange:function readyStateChange(i){this.readyState=i;if(typeof this.onreadystatechange=="function"){try{this.onreadystatechange();}catch(e){h.logError("Fake XHR onreadystatechange handler",e);}}this.dispatchEvent(new h.Event("readystatechange"));switch(this.readyState){case F.DONE:this.dispatchEvent(new h.Event("load",false,false,this));this.dispatchEvent(new h.Event("loadend",false,false,this));this.upload.dispatchEvent(new h.Event("load",false,false,this));if(s){this.upload.dispatchEvent(new h.ProgressEvent("progress",{loaded:100,total:100}));this.dispatchEvent(new h.ProgressEvent("progress",{loaded:100,total:100}));}break;}},setRequestHeader:function setRequestHeader(i,l){v(this);if(u[i]||/^(Sec-|Proxy-)/.test(i)){throw new Error("Refused to set unsafe header \""+i+"\"");}if(this.requestHeaders[i]){this.requestHeaders[i]+=","+l;}else{this.requestHeaders[i]=l;}},setResponseHeaders:function setResponseHeaders(i){k(this);this.responseHeaders={};for(var l in i){if(i.hasOwnProperty(l)){this.responseHeaders[l]=i[l];}}if(this.async){this.readyStateChange(F.HEADERS_RECEIVED);}else{this.readyState=F.HEADERS_RECEIVED;}},send:function send(i){v(this);if(!/^(get|head)$/i.test(this.method)){var l=c(this.requestHeaders,"Content-Type");if(this.requestHeaders[l]){var w=this.requestHeaders[l].split(";");this.requestHeaders[l]=w[0]+";charset=utf-8";}else if(!(i instanceof FormData)){this.requestHeaders["Content-Type"]="text/plain;charset=utf-8";}this.requestBody=i;}this.errorFlag=false;this.sendFlag=this.async;this.readyStateChange(F.OPENED);if(typeof this.onSend=="function"){this.onSend(this);}this.dispatchEvent(new h.Event("loadstart",false,false,this));},abort:function abort(){this.aborted=true;this.responseText=null;this.errorFlag=true;this.requestHeaders={};if(this.readyState>F.UNSENT&&this.sendFlag){this.readyStateChange(F.DONE);this.sendFlag=false;}this.readyState=F.UNSENT;this.dispatchEvent(new h.Event("abort",false,false,this));this.upload.dispatchEvent(new h.Event("abort",false,false,this));if(typeof this.onerror==="function"){this.onerror();}},getResponseHeader:function getResponseHeader(i){if(this.readyState<F.HEADERS_RECEIVED){return null;}if(/^Set-Cookie2?$/i.test(i)){return null;}i=c(this.responseHeaders,i);return this.responseHeaders[i]||null;},getAllResponseHeaders:function getAllResponseHeaders(){if(this.readyState<F.HEADERS_RECEIVED){return"";}var i="";for(var l in this.responseHeaders){if(this.responseHeaders.hasOwnProperty(l)&&!/^Set-Cookie2?$/i.test(l)){i+=l+": "+this.responseHeaders[l]+"\r\n";}}return i;},setResponseBody:function setResponseBody(i){m(this);n(this);o(i);var l=this.chunkSize||10;var w=0;this.responseText="";do{if(this.async){this.readyStateChange(F.LOADING);}this.responseText+=i.substring(w,w+l);w+=l;}while(w<i.length);var x=this.getResponseHeader("Content-Type");if(this.responseText&&(!x||/(text\/xml)|(application\/xml)|(\+xml)/.test(x))){try{this.responseXML=F.parseXML(this.responseText);}catch(e){}}this.readyStateChange(F.DONE);},respond:function respond(i,l,w){this.status=typeof i=="number"?i:200;this.statusText=F.statusCodes[this.status];this.setResponseHeaders(l||{});this.setResponseBody(w||"");},uploadProgress:function uploadProgress(i){if(s){this.upload.dispatchEvent(new h.ProgressEvent("progress",i));}},downloadProgress:function downloadProgress(i){if(s){this.dispatchEvent(new h.ProgressEvent("progress",i));}},uploadError:function uploadError(i){if(a){this.upload.dispatchEvent(new h.CustomEvent("error",{detail:i}));}}});h.extend(F,{UNSENT:0,OPENED:1,HEADERS_RECEIVED:2,LOADING:3,DONE:4});h.useFakeXMLHttpRequest=function(){F.restore=function restore(i){if(b.supportsXHR){g.XMLHttpRequest=b.GlobalXMLHttpRequest;}if(b.supportsActiveX){g.ActiveXObject=b.GlobalActiveXObject;}delete F.restore;if(i!==true){delete F.onCreate;}};if(b.supportsXHR){g.XMLHttpRequest=F;}if(b.supportsActiveX){g.ActiveXObject=function ActiveXObject(i){if(i=="Microsoft.XMLHTTP"||/^Msxml2\.XMLHTTP/i.test(i)){return new F();}return new b.GlobalActiveXObject(i);};}return F;};h.FakeXMLHttpRequest=F;}var q=typeof module!=="undefined"&&module.exports&&typeof require=="function";var r=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function t(h,i,l){var w=h("./core");h("../extend");h("./event");h("../log_error");p(w);l.exports=w;}if(r){define(t);}else if(q){t(require,module.exports,module);}else if(typeof sinon==="undefined"){return;}else{p(sinon);}})(typeof global!=="undefined"?global:this);
/**
 * The Sinon "server" mimics a web server that receives requests from
 * sinon.FakeXMLHttpRequest and provides an API to respond to those requests,
 * both synchronously and asynchronously. To respond synchronuously, canned
 * answers have to be provided upfront.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
if(typeof sinon=="undefined"){var sinon={};}(function(){var p=[].push;function F(){}function c(i){F.prototype=i;return new F();}function r(i){var j=i;if(Object.prototype.toString.call(i)!="[object Array]"){j=[200,{},i];}if(typeof j[2]!="string"){throw new TypeError("Fake server response body should be string, but was "+typeof j[2]);}return j;}var w=typeof window!=="undefined"?window.location:{};var a=new RegExp("^"+w.protocol+"//"+w.host);function m(i,j,k){var l=i.method;var n=!l||l.toLowerCase()==j.toLowerCase();var u=i.url;var o=!u||u==k||(typeof u.test=="function"&&u.test(k));return n&&o;}function b(i,j){var k=j.url;if(!/^https?:\/\//.test(k)||a.test(k)){k=k.replace(a,"");}if(m(i,this.getHTTPMethod(j),k)){if(typeof i.response=="function"){var l=i.url;var n=[j].concat(l&&typeof l.exec=="function"?l.exec(k).slice(1):[]);return i.response.apply(i,n);}return true;}return false;}function d(s){s.fakeServer={create:function(){var i=c(this);if(!s.xhr.supportsCORS){this.xhr=s.useFakeXDomainRequest();}else{this.xhr=s.useFakeXMLHttpRequest();}i.requests=[];this.xhr.onCreate=function(x){i.addRequest(x);};return i;},addRequest:function addRequest(x){var i=this;p.call(this.requests,x);x.onSend=function(){i.handleRequest(this);if(i.respondImmediately){i.respond();}else if(i.autoRespond&&!i.responding){setTimeout(function(){i.responding=false;i.respond();},i.autoRespondAfter||10);i.responding=true;}};},getHTTPMethod:function getHTTPMethod(i){if(this.fakeHTTPMethods&&/post/i.test(i.method)){var j=(i.requestBody||"").match(/_method=([^\b;]+)/);return!!j?j[1]:i.method;}return i.method;},handleRequest:function handleRequest(x){if(x.async){if(!this.queue){this.queue=[];}p.call(this.queue,x);}else{this.processRequest(x);}},log:function log(i,j){var k;k="Request:\n"+s.format(j)+"\n\n";k+="Response:\n"+s.format(i)+"\n\n";s.log(k);},respondWith:function respondWith(i,u,j){if(arguments.length==1&&typeof i!="function"){this.response=r(i);return;}if(!this.responses){this.responses=[];}if(arguments.length==1){j=i;u=i=null;}if(arguments.length==2){j=u;u=i;i=null;}p.call(this.responses,{method:i,url:u,response:typeof j=="function"?j:r(j)});},respond:function respond(){if(arguments.length>0){this.respondWith.apply(this,arguments);}var q=this.queue||[];var i=q.splice(0,q.length);var j;while(j=i.shift()){this.processRequest(j);}},processRequest:function processRequest(j){try{if(j.aborted){return;}var k=this.response||[404,{},""];if(this.responses){for(var l=this.responses.length,i=l-1;i>=0;i--){if(b.call(this,this.responses[i],j)){k=this.responses[i].response;break;}}}if(j.readyState!=4){this.log(k,j);j.respond(k[0],k[1],k[2]);}}catch(e){s.logError("Fake server request processing",e);}},restore:function restore(){return this.xhr.restore&&this.xhr.restore.apply(this.xhr,arguments);}};}var f=typeof module!=="undefined"&&module.exports&&typeof require=="function";var g=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function h(i,j,k){var s=i("./core");i("./fake_xdomain_request");i("./fake_xml_http_request");i("../format");d(s);k.exports=s;}if(g){define(h);}else if(f){h(require,module.exports,module);}else{d(sinon);}}());
/**
 * Add-on for sinon.fakeServer that automatically handles a fake timer along with
 * the FakeXMLHttpRequest. The direct inspiration for this add-on is jQuery
 * 1.3.x, which does not use xhr object's onreadystatehandler at all - instead,
 * it polls the object for completion with setInterval. Dispite the direct
 * motivation, there is nothing jQuery-specific in this file, so it can be used
 * in any environment where the ajax implementation depends on setInterval or
 * setTimeout.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
(function(){function m(s){function S(){}S.prototype=s.fakeServer;s.fakeServerWithClock=new S();s.fakeServerWithClock.addRequest=function addRequest(x){if(x.async){if(typeof setTimeout.clock=="object"){this.clock=setTimeout.clock;}else{this.clock=s.useFakeTimers();this.resetClock=true;}if(!this.longestTimeout){var c=this.clock.setTimeout;var b=this.clock.setInterval;var d=this;this.clock.setTimeout=function(f,t){d.longestTimeout=Math.max(t,d.longestTimeout||0);return c.apply(this,arguments);};this.clock.setInterval=function(f,t){d.longestTimeout=Math.max(t,d.longestTimeout||0);return b.apply(this,arguments);};}}return s.fakeServer.addRequest.call(this,x);};s.fakeServerWithClock.respond=function respond(){var r=s.fakeServer.respond.apply(this,arguments);if(this.clock){this.clock.tick(this.longestTimeout||0);this.longestTimeout=0;if(this.resetClock){this.clock.restore();this.resetClock=false;}}return r;};s.fakeServerWithClock.restore=function restore(){if(this.clock){this.clock.restore();}return s.fakeServer.restore.apply(this,arguments);};}var i=typeof module!=="undefined"&&module.exports&&typeof require=="function";var a=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function l(r){var s=r("./core");r("./fake_server");r("./fake_timers");m(s);}if(a){define(l);}else if(i){l(require);}else{m(sinon);}}());
/**
 * Manages fake collections as well as fake utilities such as Sinon's
 * timers and fake XHR implementation in one convenient object.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
(function(){function m(s){var p=[].push;function d(g,h,k,v){if(!v){return;}if(h.injectInto&&!(k in h.injectInto)){h.injectInto[k]=v;g.injectedKeys.push(k);}else{p.call(g.args,v);}}function f(g){var h=s.create(s.sandbox);if(g.useFakeServer){if(typeof g.useFakeServer=="object"){h.serverPrototype=g.useFakeServer;}h.useFakeServer();}if(g.useFakeTimers){if(typeof g.useFakeTimers=="object"){h.useFakeTimers.apply(h,g.useFakeTimers);}else{h.useFakeTimers();}}return h;}s.sandbox=s.extend(s.create(s.collection),{useFakeTimers:function useFakeTimers(){this.clock=s.useFakeTimers.apply(s,arguments);return this.add(this.clock);},serverPrototype:s.fakeServer,useFakeServer:function useFakeServer(){var g=this.serverPrototype||s.fakeServer;if(!g||!g.create){return null;}this.server=g.create();return this.add(this.server);},inject:function(o){s.collection.inject.call(this,o);if(this.clock){o.clock=this.clock;}if(this.server){o.server=this.server;o.requests=this.server.requests;}o.match=s.match;return o;},restore:function(){s.collection.restore.apply(this,arguments);this.restoreContext();},restoreContext:function(){if(this.injectedKeys){for(var i=0,j=this.injectedKeys.length;i<j;i++){delete this.injectInto[this.injectedKeys[i]];}this.injectedKeys=[];}},create:function(g){if(!g){return s.create(s.sandbox);}var h=f(g);h.args=h.args||[];h.injectedKeys=[];h.injectInto=g.injectInto;var j,v,k=h.inject({});if(g.properties){for(var i=0,l=g.properties.length;i<l;i++){j=g.properties[i];v=k[j]||j=="sandbox"&&h;d(h,g,j,v);}}else{d(h,g,"sandbox",v);}return h;},match:s.match});s.sandbox.useFakeXMLHttpRequest=s.sandbox.useFakeServer;return s.sandbox;}var a=typeof module!=="undefined"&&module.exports&&typeof require=="function";var b=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function c(r,d,f){var s=r("./util/core");r("./extend");r("./util/fake_server_with_clock");r("./util/fake_timers");r("./collection");f.exports=m(s);}if(b){define(c);}else if(a){c(require,module.exports,module);}else if(!sinon){return;}else{m(sinon);}}());
/**
 * Test function, sandboxes fakes
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
(function(s){function m(s){var b=Array.prototype.slice;function t(c){var d=typeof c;if(d!="function"){throw new TypeError("sinon.test needs to wrap a test function, got "+d);}function f(){var g=s.getConfig(s.config);g.injectInto=g.injectIntoThis&&this||g.injectInto;var h=s.sandbox.create(g);var j=b.call(arguments);var o=j.length&&j[j.length-1];var k,r;if(typeof o=="function"){j[j.length-1]=function sinonDone(r){if(r){h.restore();throw k;}else{h.verifyAndRestore();}o(r);};}try{r=c.apply(this,j.concat(h.args));}catch(e){k=e;}if(typeof o!="function"){if(r&&typeof r.then==="function"){return r.then(function(r){h.verifyAndRestore();return r;},function(k){h.restore();throw k;});}if(typeof k!=="undefined"){h.restore();throw k;}else{h.verifyAndRestore();}}return r;}if(c.length){return function sinonAsyncSandboxedTest(c){return f.apply(this,arguments);};}return f;}t.config={injectIntoThis:true,injectInto:null,properties:["spy","stub","mock","clock","server","requests"],useFakeTimers:true,useFakeServer:true};s.test=t;return t;}var i=typeof module!=="undefined"&&module.exports&&typeof require=="function";var a=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function l(r,b,c){var s=r("./util/core");r("./sandbox");c.exports=m(s);}if(a){define(l);}else if(i){l(require,module.exports,module);}else if(s){m(s);}}(typeof sinon=="object"&&sinon||null));
/**
 * Test case, sandboxes all test functions
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
(function(s){function c(p,b,t){return function(){if(b){b.apply(this,arguments);}var d,r;try{r=p.apply(this,arguments);}catch(e){d=e;}if(t){t.apply(this,arguments);}if(d){throw d;}return r;};}function m(s){function t(b,p){if(!b||typeof b!="object"){throw new TypeError("sinon.testCase needs an object with test functions");}p=p||"test";var r=new RegExp("^"+p);var d={},f,g,h;var j=b.setUp;var k=b.tearDown;for(f in b){if(b.hasOwnProperty(f)){g=b[f];if(/^(setUp|tearDown)$/.test(f)){continue;}if(typeof g=="function"&&r.test(f)){h=g;if(j||k){h=c(g,j,k);}d[f]=s.test(h);}else{d[f]=b[f];}}}return d;}s.testCase=t;return t;}var i=typeof module!=="undefined"&&module.exports&&typeof require=="function";var a=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function l(r,b,d){var s=r("./util/core");r("./test");d.exports=m(s);}if(a){define(l);}else if(i){l(require,module.exports,module);}else if(!s){return;}else{m(s);}}(typeof sinon=="object"&&sinon||null));
/**
 * Assertions matching the test spy retrieval interface.
 *
 * @author Christian Johansen (christian@cjohansen.no)
 * @license BSD
 *
 * Copyright (c) 2010-2013 Christian Johansen
 */
(function(s,g){var a=Array.prototype.slice;function m(s){var f;function v(){var n;for(var i=0,l=arguments.length;i<l;++i){n=arguments[i];if(!n){f.fail("fake is not a spy");}if(n.proxy){v(n.proxy);}else{if(typeof n!="function"){f.fail(n+" is not a function");}if(typeof n.getCall!="function"){f.fail(n+" is not stubbed");}}}}function h(o,i){o=o||g;var l=o.fail||f.fail;l.call(o,i);}function j(n,i,l){if(arguments.length==2){l=i;i=n;}f[n]=function(o){v(o);var p=a.call(arguments,1);var q=false;if(typeof i=="function"){q=!i(o);}else{q=typeof o[i]=="function"?!o[i].apply(o,p):!o[i];}if(q){h(this,(o.printf||o.proxy.printf).apply(o,[l].concat(p)));}else{f.pass(n);}};}function k(p,i){return!p||/^fail/.test(i)?i:p+i.slice(0,1).toUpperCase()+i.slice(1);}f={failException:"AssertError",fail:function fail(i){var l=new Error(i);l.name=this.failException||f.failException;throw l;},pass:function pass(i){},callOrder:function assertCallOrder(){v.apply(null,arguments);var l="",n="";if(!s.calledInOrder(arguments)){try{l=[].join.call(arguments,", ");var o=a.call(arguments);var i=o.length;while(i){if(!o[--i].called){o.splice(i,1);}}n=s.orderByFirstCall(o).join(", ");}catch(e){}h(this,"expected "+l+" to be "+"called in order but were called as "+n);}else{f.pass("callOrder");}},callCount:function assertCallCount(i,l){v(i);if(i.callCount!=l){var n="expected %n to be called "+s.timesInWords(l)+" but was called %c%C";h(this,i.printf(n));}else{f.pass("callCount");}},expose:function expose(t,i){if(!t){throw new TypeError("target is null or undefined");}var o=i||{};var p=typeof o.prefix=="undefined"&&"assert"||o.prefix;var l=typeof o.includeFail=="undefined"||!!o.includeFail;for(var n in this){if(n!="expose"&&(l||!/^(fail)/.test(n))){t[k(p,n)]=this[n];}}return t;},match:function match(i,l){var n=s.match(l);if(n.test(i)){f.pass("match");}else{var o=["expected value to match","    expected = "+s.format(l),"    actual = "+s.format(i)];h(this,o.join("\n"));}}};j("called","expected %n to have been called at least once but was never called");j("notCalled",function(i){return!i.called;},"expected %n to not have been called but was called %c%C");j("calledOnce","expected %n to be called once but was called %c%C");j("calledTwice","expected %n to be called twice but was called %c%C");j("calledThrice","expected %n to be called thrice but was called %c%C");j("calledOn","expected %n to be called with %1 as this but was called with %t");j("alwaysCalledOn","expected %n to always be called with %1 as this but was called with %t");j("calledWithNew","expected %n to be called with new");j("alwaysCalledWithNew","expected %n to always be called with new");j("calledWith","expected %n to be called with arguments %*%C");j("calledWithMatch","expected %n to be called with match %*%C");j("alwaysCalledWith","expected %n to always be called with arguments %*%C");j("alwaysCalledWithMatch","expected %n to always be called with match %*%C");j("calledWithExactly","expected %n to be called with exact arguments %*%C");j("alwaysCalledWithExactly","expected %n to always be called with exact arguments %*%C");j("neverCalledWith","expected %n to never be called with arguments %*%C");j("neverCalledWithMatch","expected %n to never be called with match %*%C");j("threw","%n did not throw exception%C");j("alwaysThrew","%n did not always throw exception%C");s.assert=f;return f;}var b=typeof module!=="undefined"&&module.exports&&typeof require=="function";var c=typeof define==="function"&&typeof define.amd==="object"&&define.amd;function d(r,f,h){var s=r("./util/core");r("./match");r("./format");h.exports=m(s);}if(c){define(d);}else if(b){d(require,module.exports,module);}else if(!s){return;}else{m(s);}}(typeof sinon=="object"&&sinon||null,typeof window!="undefined"?window:(typeof self!="undefined")?self:global));return sinon;}));
