/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./Calendar','./calendar/Header','./calendar/Month','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/unified/calendar/CalendarDate','./library'],function(q,C,L,D,a,b,H,M,c,d,Y,e,l){"use strict";var f=b.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}}}});f.prototype.init=function(){b.prototype.init.apply(this,arguments);var m=this.getAggregation("monthPicker");m.setColumns(0);m.setMonths(3);m.attachEvent("pageChange",g,this);var y=this.getAggregation("yearPicker");y.setColumns(0);y.setYears(3);y.attachEvent("pageChange",h,this);this._iDaysMonthHead=35;};f.prototype._getDaysLarge=function(){return 10;};f.prototype._createMonth=function(i){var m=new c(i);return m;};f.prototype.setStartDate=function(s){a._checkJSDateObject(s);if(q.sap.equal(this.getStartDate(),s)){return this;}var y=s.getFullYear();a._checkYearInValidRange(y);var o=e.fromLocalJSDate(s,this.getPrimaryCalendarType());if(a._isOutside(o,this._oMinDate,this._oMaxDate)){throw new Error("Date must be in valid range (minDate and maxDate); "+this);}var m=this.getMinDate();if(m&&s.getTime()<m.getTime()){q.sap.log.warning("startDate < minDate -> minDate as startDate set",this);s=new Date(m.getTime());}var i=this.getMaxDate();if(i&&s.getTime()>i.getTime()){q.sap.log.warning("startDate > maxDate -> maxDate as startDate set",this);s=new Date(i.getTime());}this.setProperty("startDate",s,true);o=e.fromLocalJSDate(s,this.getPrimaryCalendarType());this._oStartDate=o;var j=this.getAggregation("month")[0];j.setStartDate(s);this._updateHeader(o);var k=this._getFocusedDate(true).toLocalJSDate();if(!j.checkDateFocusable(k)){this._setFocusedDate(o);j.displayDate(s);}return this;};f.prototype.getStartDate=function(){return this.getProperty("startDate");};f.prototype.setDays=function(i){this.setProperty("days",i,true);i=this._getDays();var o=this.getAggregation("month")[0];o.setDays(i);if(!this.getPickerPopup()){var m=this.getAggregation("monthPicker");var j=Math.ceil(i/3);if(j>12){j=12;}m.setMonths(j);var y=this.getAggregation("yearPicker");var k=Math.floor(i/2);if(k>20){k=20;}y.setYears(k);}var s=this._getStartDate();this._updateHeader(s);if(this.getDomRef()){if(i>this._getDaysLarge()){this.$().addClass("sapUiCalIntLarge");}else{this.$().removeClass("sapUiCalIntLarge");}if(i>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};f.prototype._getDays=function(){var i=this.getDays();if(sap.ui.Device.system.phone&&i>8){return 8;}else{return i;}};f.prototype.setShowDayNamesLine=function(s){this.setProperty("showDayNamesLine",s,true);var o=this.getAggregation("month")[0];o.setShowDayNamesLine(s);return this;};f.prototype._getShowMonthHeader=function(){var i=this._getDays();if(i>this._iDaysMonthHead){return true;}else{return false;}};f.prototype._getFocusedDate=function(F){if(!this._oFocusedDate||F){this._oFocusedDate=null;b.prototype._getFocusedDate.apply(this,arguments);var s=this.getStartDate();var o=this.getAggregation("month")[0];if(!s){this._setStartDate(this._oFocusedDate,false,true);}else if(!o.checkDateFocusable(this._oFocusedDate.toLocalJSDate())){this._oFocusedDate=e.fromLocalJSDate(s,this.getPrimaryCalendarType());}}return this._oFocusedDate;};f.prototype.setMonths=function(m){if(m==1){return this.setProperty("months",m,false);}else{throw new Error("Property months not supported "+this);}};f.prototype.setFirstDayOfWeek=function(F){if(F==-1){return this.setProperty("firstDayOfWeek",F,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};f.prototype.focusDate=function(o){var i=this.getAggregation("month")[0];if(!i.checkDateFocusable(o)){this._focusDateExtend(e.fromLocalJSDate(o,this.getPrimaryCalendarType()),true,true);}b.prototype.focusDate.apply(this,arguments);return this;};f.prototype._focusDateExtend=function(o,O,n){if(O){var i=this._getFocusedDate();var j=this._getStartDate();var k=a._daysBetween(i,j);var N=new e(o,this.getPrimaryCalendarType());N.setDate(N.getDate()-k);this._setStartDate(N,false,true);if(!n){return true;}}return false;};f.prototype._setMinMaxDateExtend=function(o){if(this._oStartDate){if(this._oStartDate.isBefore(this._oMinDate)){q.sap.log.warning("start date < minDate -> minDate will be start date",this);this._setStartDate(new e(this._oMinDate,this.getPrimaryCalendarType()),true,true);}else{var E=new e(this._oStartDate);E.setDate(E.getDate()+this._getDays()-1);if(E.isAfter(this._oMaxDate)){q.sap.log.warning("end date > maxDate -> start date will be changed",this);var s=new e(this._oMaxDate);s.setDate(s.getDate()-this._getDays()+1);this._setStartDate(s,true,true);}}}};f.prototype.setPickerPopup=function(p){this.setProperty("pickerPopup",p,true);var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");if(p){m.setColumns(3);m.setMonths(12);y.setColumns(4);y.setYears(20);}else{m.setColumns(0);m.setMonths(6);y.setColumns(0);y.setYears(6);}return this;};f.prototype._togglePrevNext=function(o,i){if(this._iMode>1||(this._iMode==1&&this.getPickerPopup())){return b.prototype._togglePrevNext.apply(this,arguments);}var y=this._oMaxDate.getYear();var j=this._oMinDate.getYear();var m=this._oMaxDate.getMonth();var k=this._oMinDate.getMonth();var n=this._oMinDate.getDate();var p=this._oMaxDate.getDate();var r=this.getAggregation("header");var s=this._getDays();var t;var S;var E;var u;var v;if(this._iMode==1&&!i){var w=this.getAggregation("monthPicker");var x=w.getMonths();var z=w.getStartMonth();var A=z+x-1;t=o.getYear();if(z==0||(t==j&&z<=k)){r.setEnabledPrevious(false);}else{r.setEnabledPrevious(true);}if(A>10||(t==y&&A>=m)){r.setEnabledNext(false);}else{r.setEnabledNext(true);}return;}S=this._getStartDate();E=new e(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+s-1);if(a._isOutside(o,S,E)){S=new e(o,this.getPrimaryCalendarType());E=new e(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+s-1);}t=S.getYear();u=S.getMonth();v=S.getDate();if(t<j||(t==j&&(!i||u<k||(u==k&&v<=n)))){r.setEnabledPrevious(false);}else{r.setEnabledPrevious(true);}t=E.getYear();u=E.getMonth();v=E.getDate();if(t>y||(t==y&&(!i||u>m||(u==m&&v>=p)))){r.setEnabledNext(false);}else{r.setEnabledNext(true);}};f.prototype._shiftStartFocusDates=function(s,F,i){s.setDate(s.getDate()+i);F.setDate(F.getDate()+i);this._setFocusedDate(F);this._setStartDate(s,true);};f.prototype._handlePrevious=function(E){var F=new e(this._getFocusedDate(),this.getPrimaryCalendarType());var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");var s=new e(this._getStartDate(),this.getPrimaryCalendarType());var i=this._getDays();switch(this._iMode){case 0:this._shiftStartFocusDates(s,F,(i*-1));break;case 1:if(m.getMonths()<12){m.previousPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()-1);var j=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(j){this.fireStartDateChange();}}break;case 2:y.previousPage();this._togglePrevNexYearPicker();break;}};f.prototype._handleNext=function(E){var F=new e(this._getFocusedDate(),this.getPrimaryCalendarType());var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");var s=new e(this._getStartDate(),this.getPrimaryCalendarType());var i=this._getDays();switch(this._iMode){case 0:this._shiftStartFocusDates(s,F,i);break;case 1:if(m.getMonths()<12){m.nextPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()+1);var j=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(j){this.fireStartDateChange();}}break;case 2:y.nextPage();this._togglePrevNexYearPicker();break;}};f.prototype._getDisplayedMonths=function(o){var m=[];var i=o.getMonth();var j=this._getDays();m.push(i);if(j>this._getDaysLarge()){var E=new e(o,this.getPrimaryCalendarType());E.setDate(E.getDate()+j-1);var k=E.getMonth();while(i!=k){i=(i+1)%12;m.push(i);}}return m;};f.prototype._getDisplayedSecondaryMonths=function(p,s){var i=this._getDays();var S=new e(this._getStartDate(),s);var j=S.getMonth();var E=new e(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+i-1);E=new e(E,s);var k=E.getMonth();return{start:j,end:k};};f.prototype._openPickerPopup=function(p){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(_,this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(p);var o=this.getAggregation("header");var i=sap.ui.core.Popup.Dock;this._oPopup.open(0,i.CenterTop,i.CenterBottom,o,null,"flipfit",true);};f.prototype._setStartDate=function(s,S,n){var m=new e(this._oMaxDate,this.getPrimaryCalendarType());m.setDate(m.getDate()-this._getDays()+1);if(m.isBefore(this._oMinDate)){m=new e(this._oMinDate);m.setDate(m.getDate()+this._getDays()-1);}if(s.isBefore(this._oMinDate)){s=new e(this._oMinDate,this.getPrimaryCalendarType());}else if(s.isAfter(m)){s=m;}var o=s.toLocalJSDate();this.setProperty("startDate",o,true);this._oStartDate=s;var i=this.getAggregation("month")[0];i.setStartDate(o);this._updateHeader(s);if(S){var j=this._getFocusedDate().toLocalJSDate();if(!i.checkDateFocusable(j)){this._setFocusedDate(s);i.setDate(o);}else{i.setDate(j);}}if(!n){this.fireStartDateChange();}};f.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();}return this._oStartDate;};function _(E){this._closedPickers();}function g(E){var F=new e(this._getFocusedDate(),this.getPrimaryCalendarType());this._togglePrevNext(F);}function h(E){this._togglePrevNexYearPicker();}return f;},true);
