/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/MonthsRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/unified/calendar/CalendarDate','./library'],function(q,C,L,D,a,H,M,b,Y,c,l){"use strict";var d=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});d.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y"});this._oMinDate=a._minDate();this._oMaxDate=a._maxDate();var A=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});A.attachEvent("pressPrevious",this._handlePrevious,this);A.attachEvent("pressNext",this._handleNext,this);A.attachEvent("pressButton2",r,this);this.setAggregation("header",A);var B=new M(this.getId()+"--MonthsRow");B.attachEvent("focus",t,this);B.attachEvent("select",s,this);B._bNoThemeChange=true;this.setAggregation("monthsRow",B);var E=new Y(this.getId()+"--YP",{columns:0,years:6});E.attachEvent("select",u,this);E.attachEvent("pageChange",z,this);this.setAggregation("yearPicker",E);this._iDaysMonthsHead=15;};d.prototype.exit=function(){if(this._sInvalidateContent){q.sap.clearDelayedCall(this._sInvalidateContent);}};d.prototype.onBeforeRendering=function(){var A=this.getAggregation("monthsRow");var B=this._getFocusedDate();j.call(this);A.displayDate(B.toLocalJSDate());};d.prototype.setStartDate=function(S){a._checkJSDateObject(S);if(q.sap.equal(this.getStartDate(),S)){return this;}var A=S.getFullYear();a._checkYearInValidRange(A);this.setProperty("startDate",S,true);this._oStartDate=c.fromLocalJSDate(S);this._oStartDate.setDate(1);var B=this.getAggregation("monthsRow");B.setStartDate(S);j.call(this);var E=this._getFocusedDate().toLocalJSDate();if(!B.checkDateFocusable(E)){this._setFocusedDate(this._oStartDate);B.displayDate(S);}return this;};d.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=q.sap.delayedCall(0,this,v);}};d.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};d.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var A=this.destroyAggregation("selectedDates");return A;};d.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};d.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var A=this.destroyAggregation("specialDates");return A;};d.prototype.setLocale=function(A){if(this._sLocale!=A){this._sLocale=A;this._oLocaleData=undefined;this.invalidate();}return this;};d.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};d.prototype._getFocusedDate=function(){if(!this._oFocusedDate){g.call(this);}return this._oFocusedDate;};d.prototype._setFocusedDate=function(A){a._checkCalendarDate(A);this._oFocusedDate=new c(A);};d.prototype.focusDate=function(A){var F=false;var B=this.getAggregation("monthsRow");if(A&&!B.checkDateFocusable(A)){w.call(this,c.fromLocalJSDate(A));F=true;}p.call(this,A,false);if(F){this.fireStartDateChange();}return this;};d.prototype.displayDate=function(A){p.call(this,A,true);return this;};d.prototype.setMonths=function(A){this.setProperty("months",A,true);A=this._getMonths();var B=this.getAggregation("monthsRow");B.setMonths(A);if(!B.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var S=e.call(this);this._setFocusedDate(this._oStartDate);B.setDate(S.toLocalJSDate());}if(!this.getPickerPopup()){var E=this.getAggregation("yearPicker");var F=Math.floor(A/2);if(F>20){F=20;}E.setYears(F);}j.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};d.prototype._getMonths=function(){var A=this.getMonths();if(sap.ui.Device.system.phone&&A>6){return 6;}else{return A;}};d.prototype._getLocaleData=function(){if(!this._oLocaleData){var A=this.getLocale();var B=new sap.ui.core.Locale(A);this._oLocaleData=L.getInstance(B);}return this._oLocaleData;};d.prototype.setPickerPopup=function(P){this.setProperty("pickerPopup",P,true);var A=this.getAggregation("yearPicker");if(P){A.setColumns(4);A.setYears(20);}else{A.setColumns(0);A.setYears(6);}return this;};d.prototype.setMinDate=function(A){if(q.sap.equal(A,this.getMinDate())){return this;}if(!A){this._oMinDate=a._minDate();}else{a._checkJSDateObject(A);this._oMinDate=c.fromLocalJSDate(A);this._oMinDate.setDate(1);var B=this._oMinDate.getYear();a._checkYearInValidRange(B);if(this._oMaxDate.isBefore(this._oMinDate)){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(A);this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){q.sap.log.warning("focused date < minDate -> minDate focused",this);this.focusDate(A);}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){q.sap.log.warning("start date < minDate -> minDate set as start date",this);_.call(this,new c(this._oMinDate),true,true);}}this.setProperty("minDate",A,false);var E=this.getAggregation("yearPicker");E._oMinDate.setYear(this._oMinDate.getYear());return this;};d.prototype.setMaxDate=function(A){if(q.sap.equal(A,this.getMaxDate())){return this;}if(!A){this._oMaxDate=a._maxDate();}else{a._checkJSDateObject(A);this._oMaxDate=c.fromLocalJSDate(A);this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));var B=this._oMaxDate.getYear();a._checkYearInValidRange(B);if(this._oMinDate.isAfter(this._oMaxDate)){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(A);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){q.sap.log.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(A);}}if(this._oStartDate){var E=new c(this._oStartDate);E.setDate(1);E.setMonth(E.getMonth()+this._getMonths());E.setDate(0);if(E.isAfter(this._oMaxDate)){var S=new c(this._oMaxDate);S.setDate(1);S.setMonth(S.getMonth()-this._getMonths()+1);if(S.isSameOrAfter(this._oMinDate)){q.sap.log.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,S,true,true);}}}}this.setProperty("maxDate",A,false);var F=this.getAggregation("yearPicker");F._oMaxDate.setYear(this._oMaxDate.getYear());return this;};d.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};d.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};d.prototype.onsapescape=function(E){switch(this._iMode){case 0:this.fireCancel();break;case 1:i.call(this);break;}};d.prototype.onsaptabnext=function(E){var A=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(A.getDomRef("B2"));if(!this._bPoupupMode){var B=this.getAggregation("monthsRow");var F=this.getAggregation("yearPicker");q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}E.preventDefault();}};d.prototype.onsaptabprevious=function(E){var A=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(A.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==A.getId()+"-B2"){var B=this.getAggregation("monthsRow");var F=this.getAggregation("yearPicker");switch(this._iMode){case 0:B._oItemNavigation.focusItem(B._oItemNavigation.getFocusedIndex());break;case 1:F._oItemNavigation.focusItem(F._oItemNavigation.getFocusedIndex());break;}E.preventDefault();}};d.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var A=this.getAggregation("header");var B=this.getAggregation("monthsRow");var F=this.getAggregation("yearPicker");q.sap.focus(A.getDomRef("B2"));if(!this._bPoupupMode){q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};d.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var A=this.getAggregation("monthsRow");var B=this.getAggregation("yearPicker");switch(this._iMode){case 0:q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};d.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var A=this.getAggregation("yearPicker");var B=this._getMonths();var S=new c(e.call(this));switch(this._iMode){case 0:S.setMonth(S.getMonth()-B);F.setMonth(F.getMonth()-B);this._setFocusedDate(F);_.call(this,S,true);break;case 1:A.previousPage();m.call(this);break;}};d.prototype._handleNext=function(E){var F=this._getFocusedDate();var A=this.getAggregation("yearPicker");var B=this._getMonths();var S=new c(e.call(this));switch(this._iMode){case 0:S.setMonth(S.getMonth()+B);F.setMonth(F.getMonth()+B);this._setFocusedDate(F);_.call(this,S,true);break;case 1:A.nextPage();m.call(this);break;}};d.prototype._getShowItemHeader=function(){var A=this.getMonths();if(A>this._iDaysMonthsHead){return true;}else{return false;}};function _(S,A,N){var B=new c(this._oMaxDate);B.setDate(1);B.setMonth(B.getMonth()-this._getMonths()+1);if(B.isBefore(this._oMinDate)){B=new c(this._oMinDate);B.setMonth(B.getMonth()+this._getMonths()-1);}if(S.isBefore(this._oMinDate)){S=new c(this._oMinDate);}else if(S.isAfter(B)){S=B;}S.setDate(1);var E=S.toLocalJSDate();this.setProperty("startDate",E,true);this._oStartDate=S;var F=this.getAggregation("monthsRow");F.setStartDate(E);j.call(this);if(A){var G=this._getFocusedDate().toLocalJSDate();if(!F.checkDateFocusable(G)){this._setFocusedDate(S);F.setDate(E);}else{F.setDate(G);}}if(!N){this.fireStartDateChange();}}function e(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1);}return this._oStartDate;}function f(N){var A=this._getFocusedDate();var B=this.getAggregation("monthsRow");if(!N){B.setDate(A.toLocalJSDate());}else{B.displayDate(A.toLocalJSDate());}j.call(this);}function g(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate());}else{this._oFocusedDate=new c();}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate);}}function h(){var A=this._getFocusedDate();var B=this.getAggregation("yearPicker");if(!this.getPickerPopup()){if(B.getDomRef()){B.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(B);R.flush($[0],false,true);R.destroy();}}else{x.call(this,B);}this.$("contentOver").css("display","");B.setDate(A.toLocalJSDate());if(this._iMode==0){var E=this.getAggregation("monthsRow");q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}m.call(this);this._iMode=1;}function i(N){this._iMode=0;if(!this.getPickerPopup()){var A=this.getAggregation("yearPicker");A.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){f.call(this);var B=this.getAggregation("monthsRow");q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}function j(){n.call(this);k.call(this);}function k(){var A=new c(e.call(this));var B=this._getMonths();var E=A.getYear();var F=this._oMaxDate.getYear();var G=this._oMinDate.getYear();var I=A.getMonth();var J=this._oMaxDate.getMonth();var K=this._oMinDate.getMonth();var N=this.getAggregation("header");if(E<G||(E==G&&I<=K)){N.setEnabledPrevious(false);}else{N.setEnabledPrevious(true);}A.setMonth(A.getMonth()+B-1);E=A.getYear();I=A.getMonth();if(E>F||(E==F&&I>=J)){N.setEnabledNext(false);}else{N.setEnabledNext(true);}}function m(){var A=this.getAggregation("yearPicker");var B=A.getYears();var E=c.fromLocalJSDate(A.getFirstRenderedDate());E.setYear(E.getYear()+Math.floor(B/2));var F=this.getAggregation("header");var G=new c(this._oMaxDate);G.setYear(G.getYear()-Math.ceil(B/2));G.setMonth(11,31);var I=new c(this._oMinDate);I.setYear(I.getYear()+Math.floor(B/2)+1);I.setMonth(0,1);F.setEnabledNext(!E.isAfter(G));F.setEnabledPrevious(!E.isBefore(I));}function n(){var T;var S=e.call(this);var A=this._oYearFormat.format(S.toUTCJSDate(),true);var E=new c(S);E.setMonth(E.getMonth()+this._getMonths()-1);var B=this._oYearFormat.format(E.toUTCJSDate(),true);if(A!=B){var F=this._getLocaleData();var P=F.getIntervalPattern();T=P.replace(/\{0\}/,A).replace(/\{1\}/,B);}else{T=A;}var G=this.getAggregation("header");G.setTextButton2(T);}function o(A,N){var F;var B=false;if(A.isBefore(this._oMinDate)){F=this._oMinDate;B=true;}else if(A.isAfter(this._oMaxDate)){F=this._oMaxDate;B=true;}else{F=A;}this._setFocusedDate(F);if(B||N){w.call(this,F);f.call(this,false);this.fireStartDateChange();}}function p(A,N){if(!A){return;}var B=c.fromLocalJSDate(A);if(this._oFocusedDate&&this._oFocusedDate.isSame(B)){return;}var E=B.getYear();a._checkYearInValidRange(E);if(a._isOutside(B,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(B);if(this.getDomRef()&&this._iMode==0){f.call(this,N);}}function r(E){if(this._iMode!=1){h.call(this);}else{i.call(this);}}function s(E){this.fireSelect();}function t(E){var A=c.fromLocalJSDate(E.getParameter("date"));var N=E.getParameter("notVisible");o.call(this,A,N);}function u(E){var F=new c(this._getFocusedDate());var A=this.getAggregation("yearPicker");var B=c.fromLocalJSDate(A.getDate());B.setMonth(F.getMonth());B.setDate(F.getDate());F=B;o.call(this,F,true);i.call(this);}function v(){this._sInvalidateContent=undefined;var A=this.getAggregation("monthsRow");A._bDateRangeChanged=true;A._bInvalidateSync=true;A.invalidate();A._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}function w(A){var B=this.getAggregation("monthsRow");var S=e.call(this);var E=B._oItemNavigation.getFocusedIndex();S=new c(A);S.setMonth(S.getMonth()-E);_.call(this,S,false,true);}function x(P){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(y,this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(P);var A=this.getAggregation("header");var B=sap.ui.core.Popup.Dock;this._oPopup.open(0,B.CenterTop,B.CenterBottom,A,null,"flipfit",true);}function y(E){switch(this._iMode){case 0:break;case 1:i.call(this);break;}}function z(E){m.call(this);}return d;},true);
