/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library'],function(q,C,D,L,a,b,U,l){"use strict";var c=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:sap.ui.unified.CalendarIntervalType.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:sap.ui.unified.GroupAppointmentsMode.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:sap.ui.unified.CalendarAppointmentVisualization.Standard}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"},_nonWorkingDates:{type:"sap.ui.unified.DateRange",multiple:true,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});c.PCROW_FOREIGN_KEY_NAME="relatedToPCRowDateRange";c.AGGR_NONWORKING_DATES_NAME="_nonWorkingDates";c.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");if(!c._oStaticAppointmentText){c._oStaticAppointmentText=new sap.ui.core.InvisibleText({text:this._oRb.getText("APPOINTMENT")});c._oStaticAppointmentText.toStatic();c._oStaticTentativeText=new sap.ui.core.InvisibleText({text:this._oRb.getText("APPOINTMENT_TENTATIVE")});c._oStaticTentativeText.toStatic();}if(!c._oStaticSelectedText){c._oStaticSelectedText=new sap.ui.core.InvisibleText({text:this._oRb.getText("APPOINTMENT_SELECTED")});c._oStaticSelectedText.toStatic();}this._oFormatAria=sap.ui.core.format.DateFormat.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH:mm:ss a"});this._iHoursMinDelta=1;this._iDaysMinDelta=30;this._iMonthsMinDelta=720;this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);};c.prototype.exit=function(){if(this._sResizeListener){sap.ui.core.ResizeHandler.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};c.prototype.onBeforeRendering=function(){e.call(this);h.call(this);p.call(this);if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};c.prototype.onAfterRendering=function(){r.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=sap.ui.core.ResizeHandler.register(this,this._resizeProxy);}};c.prototype.onThemeChanged=function(E){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var A=this._aVisibleAppointments[i];A.level=-1;}this.handleResize(E);}};c.prototype.invalidate=function(O){if(O&&O instanceof sap.ui.unified.CalendarAppointment){var F=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==O){F=true;break;}}if(F){this._aVisibleAppointments=[];}}C.prototype.invalidate.apply(this,arguments);};c.prototype.setStartDate=function(S){if(!S){S=new Date();}b._checkJSDateObject(S);var Y=S.getFullYear();b._checkYearInValidRange(Y);this.setProperty("startDate",S);return this;};c.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=b._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};c.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};c.prototype.setGroupAppointmentsMode=function(G){this.setProperty("groupAppointmentsMode",G);this._aVisibleAppointments=[];return this;};c.prototype.setAppointmentsReducedHeight=function(A){this.setProperty("appointmentsReducedHeight",A);this._aVisibleAppointments=[];return this;};c.prototype._getAppointmentReducedHeight=function(A){var R=false;if(!D.system.phone&&this.getAppointmentsReducedHeight()&&!A.getText()){R=true;}return R;};c.prototype.onfocusin=function(E){if(q(E.target).hasClass("sapUiCalendarApp")){v.call(this,E.target.id);}else{var V=this._getVisibleAppointments();var F=false;var A;for(var i=0;i<V.length;i++){A=V[i].appointment;if(q.sap.containsOrEquals(A.getDomRef(),E.target)){F=true;A.focus();break;}}if(!F){A=this.getFocusedAppointment();if(A){A.focus();}}}};c.prototype.applyFocusInfo=function(F){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};c.prototype.onsapleft=function(E){if(q(E.target).hasClass("sapUiCalendarApp")){w.call(this,this._bRTL,1);}E.preventDefault();E.stopPropagation();};c.prototype.onsapright=function(E){if(q(E.target).hasClass("sapUiCalendarApp")){w.call(this,!this._bRTL,1);}E.preventDefault();E.stopPropagation();};c.prototype.onsapup=function(E){this.fireLeaveRow({type:E.type});};c.prototype.onsapdown=function(E){this.fireLeaveRow({type:E.type});};c.prototype.onsaphome=function(E){x.call(this,E);E.preventDefault();E.stopPropagation();};c.prototype.onsapend=function(E){x.call(this,E);E.preventDefault();E.stopPropagation();};c.prototype.onsapselect=function(E){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var A=V[i].appointment;if(q.sap.containsOrEquals(A.getDomRef(),E.target)){s.call(this,A,!E.ctrlKey);break;}}E.stopPropagation();E.preventDefault();};c.prototype.ontap=function(E){var i=this.$("Apps").children(".sapUiCalendarRowAppsInt");var I=0;var j=false;for(I=0;I<i.length;I++){var k=i[I];if(q.sap.containsOrEquals(k,E.target)){j=true;break;}}if(j){y.call(this,I,E.target);}else{this.onsapselect(E);}};c.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};c.prototype.handleResize=function(E){if(E&&E.size&&E.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");r.call(this);return this;};c.prototype.updateCurrentTimeVisualization=function(){var N=this.$("Now");var i=b._createUniversalUTCDate(new Date(),undefined,true);var I=this.getIntervals();var j=this.getIntervalType();var S=this._getStartDate();var k=S.getTime();var E=this._oUTCEndDate;var z=E.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=z&&i.getTime()>=k){var B=n.call(this,j,I,S,E,k,i);var T=0;if(this._bRTL){N.css("right",B+"%");}else{N.css("left",B+"%");}N.css("display","");if(this.getUpdateCurrentTime()){switch(j){case sap.ui.unified.CalendarIntervalType.Hour:T=60000;break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:T=1800000;break;default:T=-1;break;}if(T>0){this._sUpdateCurrentTime=q.sap.delayedCall(T,this,this.updateCurrentTimeVisualization);}}}else{N.css("display","none");}return this;};c.prototype.getFocusedAppointment=function(){var A=t.call(this);var G=this.getAggregation("groupAppointments",[]);var j;var i=0;for(i=0;i<G.length;i++){if(G[i].getId()==this._sFocusedAppointmentId){j=G[i];break;}}if(!j){for(i=0;i<A.length;i++){if(A[i].getId()==this._sFocusedAppointmentId){j=A[i];break;}}}return j;};c.prototype.focusAppointment=function(A){if(!A||!(A instanceof sap.ui.unified.CalendarAppointment)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var i=A.getId();if(this._sFocusedAppointmentId!=i){v.call(this,i);}else{A.focus();}return this;};c.prototype.focusNearestAppointment=function(j){b._checkJSDateObject(j);var A=t.call(this);var N;var P;var k;for(var i=0;i<A.length;i++){N=A[i];if(N.getStartDate()>j){if(i>0){P=A[i-1];}else{P=N;}break;}}if(N){if(P&&Math.abs(N.getStartDate()-j)>=Math.abs(P.getStartDate()-j)){k=P;}else{k=N;}this.focusAppointment(k);}return this;};c.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};c.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};c.prototype._getNonWorkingDays=function(){var N=this.getNonWorkingDays();if(!N){var j=d.call(this);var W=j.getWeekendStart();var k=j.getWeekendEnd();N=[];for(var i=0;i<=6;i++){if((W<=k&&i>=W&&i<=k)||(W>k&&(i>=W||i<=k))){N.push(i);}}}else if(!q.isArray(N)){N=[];}return N;};function _(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}function d(){if(!this._oLocaleData){var i=_.call(this);var j=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}function e(){var S=this.getStartDate();var E;var i=this.getIntervals();var I=this.getIntervalType();this._oUTCStartDate=f.call(this,S);switch(I){case sap.ui.unified.CalendarIntervalType.Hour:E=new U(this._oUTCStartDate.getTime());E.setUTCHours(E.getUTCHours()+i);this._iMinDelta=this._iHoursMinDelta;break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:E=new U(this._oUTCStartDate.getTime());E.setUTCDate(E.getUTCDate()+i);this._iMinDelta=this._iDaysMinDelta;break;case sap.ui.unified.CalendarIntervalType.Month:E=new U(this._oUTCStartDate.getTime());E.setUTCMonth(E.getUTCMonth()+i);this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}E.setUTCMilliseconds(-1);this._iRowSize=E.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/i);this._oUTCEndDate=E;}function f(i){var I=this.getIntervalType();var j=b._createUniversalUTCDate(i,undefined,true);switch(I){case sap.ui.unified.CalendarIntervalType.Hour:j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:j.setUTCHours(0);j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);break;case sap.ui.unified.CalendarIntervalType.Month:j.setUTCDate(1);j.setUTCHours(0);j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}return j;}function g(){return D.system.phone||(this.getGroupAppointmentsMode()===sap.ui.unified.GroupAppointmentsMode.Collapsed);}function h(){var O=this._aVisibleAppointments||[];var A=t.call(this);var z;var G;var B;var I=this.getIntervals();var E=this.getIntervalType();var S=this._getStartDate();var F=S.getTime();var H=this._oUTCEndDate;var J=H.getTime();var V=[];var K=false;var i=0;var j=0;var M=g.call(this);this.destroyAggregation("groupAppointments",true);for(i=0;i<A.length;i++){z=A[i];var N=b._createUniversalUTCDate(z.getStartDate(),undefined,true);N.setUTCSeconds(0);N.setUTCMilliseconds(0);var P=z.getEndDate()?b._createUniversalUTCDate(z.getEndDate(),undefined,true):b._createUniversalUTCDate(new Date(864000000000000),undefined,true);P.setUTCSeconds(0);P.setUTCMilliseconds(0);var Q=false;if(N.getTime()<F&&P.getTime()>=F){N=new U(F);Q=true;}if(P.getTime()>J&&N.getTime()<=J){P=new U(J);Q=true;}var R=N.getUTCHours()*60+N.getUTCMinutes();N.setUTCMinutes(N.getUTCMinutes()-(R%this._iMinDelta));var T=(P.getTime()-N.getTime())/60000;if(Q&&T==0){continue;}var W=0;var X=0;var Y=-1;G=undefined;B=undefined;if(N&&N.getTime()<=J&&P&&P.getTime()>=F){if(M&&(E==sap.ui.unified.CalendarIntervalType.Month)&&((P.getTime()-N.getTime())<604800000)){G=m.call(this,N,z,E,I,S,H,F,V);var Z=b._createUniversalUTCDate(G.getEndDate(),undefined,true);if(P.getTime()>Z.getTime()){B=m.call(this,P,z,E,I,S,H,F,V);}}W=n.call(this,E,I,S,H,F,N);X=o.call(this,E,I,S,H,F,P);for(j=0;j<O.length;j++){var $=O[j];if(z==$.appointment){Y=$.level;}}if(G){G._iBegin=W;G._iEnd=X;G._iLevel=Y;if(B){B._iBegin=W;B._iEnd=X;B._iLevel=Y;}continue;}V.push({appointment:z,begin:W,end:X,calculatedEnd:X,level:Y});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==z.getId()){K=true;}}}var a1=this.getAggregation("groupAppointments",[]);if(a1.length>0){for(i=0;i<V.length;i++){z=V[i];if(z.appointment._aAppointments&&z.appointment._aAppointments.length<=1){G=z.appointment;var b1=false;if(G._aAppointments.length==0){b1=true;}else{for(j=0;j<V.length;j++){if(V[j].appointment==G._aAppointments[0]){b1=true;break;}}}if(!b1){for(j=0;j<a1.length;j++){B=a1[j];if(G!=B){for(var k=0;k<B._aAppointments.length;k++){if(G._aAppointments[0]==B._aAppointments[k]){B._aAppointments.splice(k,1);if(B._aAppointments.length==1){this.removeAggregation("groupAppointments",B);B.destroy();a1=this.getAggregation("groupAppointments",[]);}else{B.setProperty("title",B._aAppointments.length,true);}break;}}}}z.begin=G._iBegin;z.end=G._iEnd;z.calculatedEnd=G._iEnd;z.level=G._iLevel;z.appointment=G._aAppointments[0];}else{V.splice(i,1);i--;}this.removeAggregation("groupAppointments",G);G.destroy();a1=this.getAggregation("groupAppointments",[]);}}}if(!K){if(V.length>0){this._sFocusedAppointmentId=V[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=V;return this._aVisibleAppointments;}function m(i,A,I,k,S,E,z,V){var G=this.getAggregation("groupAppointments",[]);var B;var F=d.call(this);var H=F.getFirstDayOfWeek();var J=i.getUTCDay();var K=new U(i.getTime());K.setUTCHours(0);K.setUTCMinutes(0);K.setUTCSeconds(0);K.setUTCMilliseconds(0);if(H<=J){K.setDate(K.getDate()-(J-H));}else{K.setDate(K.getDate()-(7-J-H));}for(var j=0;j<G.length;j++){B=G[j];var M=b._createUniversalUTCDate(B.getStartDate(),undefined,true);if(M.getTime()==K.getTime()){break;}B=undefined;}if(!B){var N=new U(K.getTime());N.setDate(N.getDate()+7);N.setMilliseconds(-1);B=new sap.ui.unified.CalendarAppointment(this.getId()+"-Group"+G.length,{type:A.getType(),startDate:b._createLocalDate(new Date(K.getTime()),true),endDate:b._createLocalDate(new Date(N.getTime()),true)});B._aAppointments=[];this.addAggregation("groupAppointments",B,true);var O=n.call(this,I,k,S,E,z,K);var P=o.call(this,I,k,S,E,z,N);V.push({appointment:B,begin:O,end:P,calculatedEnd:P,level:-1});}B._aAppointments.push(A);if(B.getType()!=sap.ui.unified.CalendarDayType.None&&B.getType()!=A.getType()){B.setType(sap.ui.unified.CalendarDayType.None);}B.setProperty("title",B._aAppointments.length,true);return B;}function n(i,I,S,E,j,A){var B=0;if(i!=sap.ui.unified.CalendarIntervalType.Month){B=100*(A.getTime()-j)/this._iRowSize;}else{var M=new U(A.getTime());M.setUTCDate(1);M.setUTCHours(0);M.setUTCMinutes(0);M.setUTCSeconds(0);M.setUTCMilliseconds(0);var k=new U(M.getTime());k.setUTCMonth(k.getUTCMonth()+1);k.setMilliseconds(-1);var z=k.getTime()-M.getTime();var F=(M.getUTCFullYear()-S.getUTCFullYear())*12+M.getUTCMonth()-S.getUTCMonth();B=(100*F/I)+(100*(A.getTime()-M.getTime())/z)/I;}if(B<0){B=0;}B=Math.round(B*100000)/100000;return B;}function o(i,I,S,E,j,A){var k=0;if(i!=sap.ui.unified.CalendarIntervalType.Month){k=100-(100*(A.getTime()-j)/this._iRowSize);}else{var M=new U(A.getTime());M.setUTCDate(1);M.setUTCHours(0);M.setUTCMinutes(0);M.setUTCSeconds(0);M.setUTCMilliseconds(0);var z=new U(M.getTime());z.setUTCMonth(z.getUTCMonth()+1);z.setMilliseconds(-1);var B=z.getTime()-M.getTime();var F=(M.getUTCFullYear()-S.getUTCFullYear())*12+M.getUTCMonth()-S.getUTCMonth();k=100-((100*F/I)+(100*(A.getTime()-M.getTime())/B)/I);}if(k<0){k=0;}k=Math.round(k*100000)/100000;return k;}function p(){var V=[];if(this.getShowIntervalHeaders()){var A=this.getIntervalHeaders();var k;var I=this.getIntervals();var z=this.getIntervalType();var S=this._getStartDate();var B=S.getTime();var E=this._oUTCEndDate;var F=E.getTime();var i=0;var j=0;for(i=0;i<A.length;i++){k=A[i];var G=b._createUniversalUTCDate(k.getStartDate(),undefined,true);G.setUTCSeconds(0);G.setUTCMilliseconds(0);var H=k.getEndDate()?b._createUniversalUTCDate(k.getEndDate(),undefined,true):b._createUniversalUTCDate(new Date(864000000000000),undefined,true);H.setUTCSeconds(0);H.setUTCMilliseconds(0);if(G&&G.getTime()<=F&&H&&H.getTime()>=B){var J=new U(S.getTime());var K=new U(S.getTime());K.setUTCMinutes(K.getUTCMinutes()-1);var M=-1;var N=-1;for(j=0;j<I;j++){switch(z){case sap.ui.unified.CalendarIntervalType.Hour:K.setUTCHours(K.getUTCHours()+1);if(j>0){J.setUTCHours(J.getUTCHours()+1);}break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:K.setUTCDate(K.getUTCDate()+1);if(j>0){J.setUTCDate(J.getUTCDate()+1);}break;case sap.ui.unified.CalendarIntervalType.Month:K.setUTCDate(1);K.setUTCMonth(K.getUTCMonth()+2);K.setUTCDate(0);if(j>0){J.setUTCMonth(J.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+z+"; "+this);}if(G&&G.getTime()<=J.getTime()&&H&&H.getTime()>=K.getTime()){if(M<0){M=j;}N=j;}}if(M>=0){V.push({interval:M,appointment:k,last:N});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}function r(){var I=this.getIntervals();var k=this.getIntervalType();if(k===sap.ui.unified.CalendarIntervalType.OneMonth&&I===1){return;}var A=this.$("Apps");var R=A.innerWidth();if(R<=0){return;}var $=this.$("DummyApp");var H=$.outerHeight(true);if(H<=0){return;}var M=$.outerWidth();var z=M/R*100;var B=Math.ceil(1000*z)/1000;var E;var F;var S=0;var G=0;var i=0;var J=!D.system.phone&&this.getAppointmentsReducedHeight();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){S=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);}for(i=0;i<this._aVisibleAppointments.length;i++){E=this._aVisibleAppointments[i];F=E.appointment.$();var P=Math.floor(1000*(100-E.calculatedEnd-E.begin))/1000;var K=false;if(P<B){E.end=100-E.begin-z;if(E.end<0){E.end=0;}E.level=-1;K=true;F.addClass("sapUiCalendarAppSmall");}else if(F.hasClass("sapUiCalendarAppSmall")){E.end=E.calculatedEnd;K=true;F.removeClass("sapUiCalendarAppSmall");}if(K){if(this._bRTL){F.css("left",E.end+"%");}else{F.css("right",E.end+"%");}}}for(i=0;i<this._aVisibleAppointments.length;i++){E=this._aVisibleAppointments[i];F=E.appointment.$();var N={};var T=J&&!this._getAppointmentReducedHeight(E.appointment);if(E.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var V=this._aVisibleAppointments[j];if(E!=V&&E.begin<(Math.floor(1000*(100-V.end))/1000)&&(Math.floor(1000*(100-E.end))/1000)>V.begin&&V.level>=0){if(N[V.level]){N[V.level]++;}else{N[V.level]=1;}if(J&&!this._getAppointmentReducedHeight(V.appointment)){if(N[V.level+1]){N[V.level+1]++;}else{N[V.level+1]=1;}}}}E.level=0;while(N[E.level]||(T&&N[E.level+1])){E.level++;}F.attr("data-sap-level",E.level);}F.css("top",(H*E.level+S)+"px");var O=E.level;if(T){O++;}if(G<O){G=O;}}G++;H=H*G+S;if(!this.getHeight()){A.outerHeight(H);}else{var Q=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<Q.length;i++){var W=q(Q[i]);W.outerHeight(H);}}$.css("display","none");}function s(A,R){var i=0;var O;var j;var k;var z;var S=sap.ui.unified.CalendarRow._oStaticSelectedText.getId();if(R){var B=this.getAppointments();var G=this.getAggregation("groupAppointments",[]);q.merge(B,G);for(i=0;i<B.length;i++){O=B[i];if(O.getSelected()){O.setProperty("selected",false,true);O.$().removeClass("sapUiCalendarAppSel");j=O.$().attr("aria-labelledby");k=j?j.replace(S,""):"";O.$().attr("aria-labelledby",k);}}}A.setProperty("selected",true,true);A.$().addClass("sapUiCalendarAppSel");z=A.$().attr("aria-labelledby")+" "+S;A.$().attr("aria-labelledby",z);if(A._aAppointments){for(i=0;i<A._aAppointments.length;i++){O=A._aAppointments[i];O.setProperty("selected",true,true);z=O.$().attr("aria-labelledby")+" "+S;O.$().attr("aria-labelledby",z);}this.fireSelect({appointments:A._aAppointments,multiSelect:!R});}else{this.fireSelect({appointment:A,multiSelect:!R});}}function t(){var A=this.getAppointments();A.sort(function(i,j){var R=i.getStartDate()-j.getStartDate();if(R==0){R=j.getEndDate()-i.getEndDate();}return R;});return A;}function u(I){var G=this.getAggregation("groupAppointments",[]);var k;var F=false;for(var i=0;i<G.length;i++){var z=G[i]._aAppointments;for(var j=0;j<z.length;j++){if(z[j].getId()==I){k=G[i];F=true;break;}}if(F){break;}}return k;}function v(I){if(this._sFocusedAppointmentId!=I){var A=t.call(this);var V=this._aVisibleAppointments;var j;var i=0;j=u.call(this,I);if(j){I=j.getId();j=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==I){j=V[i].appointment;break;}}if(j){var O=this.getFocusedAppointment().$();var $=j.$();this._sFocusedAppointmentId=j.getId();O.attr("tabindex","-1");$.attr("tabindex","0");$.focus();}else{for(i=0;i<A.length;i++){if(A[i].getId()==I){j=A[i];break;}}if(j){this._sFocusedAppointmentId=j.getId();var k=f.call(this,j.getStartDate());this.setStartDate(b._createLocalDate(k,true));if(!q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){q.sap.delayedCall(0,this,function(){this.getFocusedAppointment().focus();});}this.fireStartDateChange();}}}}function w(F,S){var I=this._sFocusedAppointmentId;var A=t.call(this);var G=this.getAggregation("groupAppointments",[]);var j;var k=0;var i=0;for(i=0;i<G.length;i++){if(G[i].getId()==I){var z=G[i]._aAppointments;if(F){I=z[z.length-1].getId();}else{I=z[0].getId();}break;}}for(i=0;i<A.length;i++){if(A[i].getId()==I){k=i;break;}}if(F){k=k+S;}else{k=k-S;}if(k<0){k=0;}else if(k>=A.length){k=A.length-1;}j=A[k];v.call(this,j.getId());}function x(E){var A=t.call(this);var j;var S=new U(this._getStartDate());var k=new U(this._oUTCEndDate);var I=this.getIntervalType();var z;var G;S.setUTCHours(0);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);switch(I){case sap.ui.unified.CalendarIntervalType.Hour:k.setUTCDate(k.getUTCDate()+1);k.setUTCMilliseconds(-1);break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:S.setUTCDate(1);k.setUTCMonth(k.getUTCMonth()+1);k.setUTCDate(1);k.setUTCMilliseconds(-1);break;case sap.ui.unified.CalendarIntervalType.Month:S.setUTCMonth(0);S.setUTCDate(1);k.setUTCFullYear(k.getUTCFullYear()+1);k.setUTCMonth(1);k.setUTCDate(1);k.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}var B=b._createLocalDate(S,true);var F=b._createLocalDate(k,true);for(var i=0;i<A.length;i++){if(A[i].getStartDate()>=B&&A[i].getStartDate()<=F){j=A[i];z=j.getId();if(E.type=="saphome"){break;}}else if(A[i].getStartDate()>F){break;}}G=u.call(this,z);if(G){j=G;z=j.getId();}if(z&&z!=this._sFocusedAppointmentId){v.call(this,z);}else if(E._bPlanningCalendar&&j){j.focus();}else{this.fireLeaveRow({type:E.type});}}function y(i,j){var I=this.getIntervalType();var S=this._getStartDate();var k=new U(S.getTime());var z;var A=false;var B=0;var E=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){A=true;var F=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");E=F.length;for(B=0;B<E;B++){var G=F[B];if(G==j){break;}}}switch(I){case sap.ui.unified.CalendarIntervalType.Hour:k.setUTCHours(k.getUTCHours()+i);if(A){k.setUTCMinutes(k.getUTCMinutes()+B*60/E);z=new U(k.getTime());z.setUTCMinutes(z.getUTCMinutes()+60/E);}else{z=new U(k.getTime());z.setUTCHours(z.getUTCHours()+1);}break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:k.setUTCDate(k.getUTCDate()+i);if(A){k.setUTCHours(k.getUTCHours()+B*24/E);z=new U(k.getTime());z.setUTCHours(z.getUTCHours()+24/E);}else{z=new U(k.getTime());z.setUTCDate(z.getUTCDate()+1);}break;case sap.ui.unified.CalendarIntervalType.Month:k.setUTCMonth(k.getUTCMonth()+i);if(A){k.setUTCDate(k.getUTCDate()+B);z=new U(k.getTime());z.setUTCDate(z.getUTCDate()+1);}else{z=new U(k.getTime());z.setUTCMonth(z.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}z.setUTCMilliseconds(z.getUTCMilliseconds()-1);k=b._createLocalDate(k,true);z=b._createLocalDate(z,true);this.fireIntervalSelect({startDate:k,endDate:z,subInterval:A});}return c;},true);
