/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/unified/Calendar',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/CalendarDate','./library'],function(q,C,L,D,a,H,M,b,Y,c,l){"use strict";
var d=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});
d.prototype.init=function(){this._iBreakPointTablet=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=sap.ui.Device.media._predefinedRangeSets[sap.ui.Device.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());var A=new H(this.getId()+"--Head");A.attachEvent("pressPrevious",this._handlePrevious,this);A.attachEvent("pressNext",this._handleNext,this);A.attachEvent("pressButton1",p,this);A.attachEvent("pressButton2",r,this);this.setAggregation("header",A);var B=this._createMonth(this.getId()+"--Month0");B.attachEvent("focus",this._handleFocus,this);B.attachEvent("select",t,this);B.attachEvent("_renderMonth",s,this);B.attachEvent("_bindMousemove",u,this);B.attachEvent("_unbindMousemove",v,this);B._bNoThemeChange=true;this.addAggregation("month",B);var E=new b(this.getId()+"--MP");E.attachEvent("select",w,this);E._bNoThemeChange=true;this.setAggregation("monthPicker",E);var F=new Y(this.getId()+"--YP");F.attachEvent("select",x,this);this.setAggregation("yearPicker",F);this._resizeProxy=q.proxy(y,this);};
d.prototype.exit=function(){if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}if(this._sResizeListener){sap.ui.core.ResizeHandler.deregister(this._sResizeListener);this._sResizeListener=undefined;}};
d.prototype._createMonth=function(i){var A=new M(i,{width:"100%"});return A;};
d.prototype.onBeforeRendering=function(){var A=this.getAggregation("month");var B;var E=A[0].getDate();var F=this._getFocusedDate();if(A.length>1&&E){B=c.fromLocalJSDate(E,this.getPrimaryCalendarType());}else if(A.length>1){B=z.call(this,this._getFocusedDate());}else{B=F;}for(var i=0;i<A.length;i++){E=new c(B);if(i>0){E.setDate(1);E.setMonth(E.getMonth()+i);}var G=E;if(F.getYear()===E.getYear()&&F.getMonth()===E.getMonth()){G=F;}A[i].displayDate(G.toLocalJSDate());A[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(B);this._iSize=0;};
d.prototype.onAfterRendering=function(E){k.call(this);if(o.call(this)>1||this._bInitMonth){E.size={width:this.getDomRef().offsetWidth};y.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=sap.ui.core.ResizeHandler.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};
d.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=q.sap.delayedCall(0,this,this._invalidateMonth,[O]);}};
d.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
d.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
d.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
d.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
d.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
d.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("disabledDates");return R;};
d.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};
d.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};
d.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
d.prototype._getFocusedDate=function(){if(!this._oFocusedDate){e.call(this);}return this._oFocusedDate;};
d.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new c(i,this.getPrimaryCalendarType());};
d.prototype.focusDate=function(i){n.call(this,i,false);return this;};
d.prototype.displayDate=function(i){n.call(this,i,true);return this;};
d.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=c.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new c(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};
d.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};
d.prototype.setMonths=function(A){this._bDateRangeChanged=undefined;this.setProperty("months",A,false);A=o.call(this);var B=this.getAggregation("month");var i=0;var E;if(B.length<A){for(i=B.length;i<A;i++){E=this._createMonth(this.getId()+"--Month"+i);E.attachEvent("focus",this._handleFocus,this);E.attachEvent("select",t,this);E.attachEvent("_renderMonth",s,this);E.attachEvent("_bindMousemove",u,this);E.attachEvent("_unbindMousemove",v,this);E._bNoThemeChange=true;this.addAggregation("month",E);}}else if(B.length>A){for(i=B.length;i>A;i--){E=this.removeAggregation("month",i-1);E.destroy();}if(A==1){this._bInitMonth=true;}}if(A>1&&B[0].getDate()){B[0].setProperty("date",null,true);}return this;};
d.prototype.setPrimaryCalendarType=function(A){var B=this.getAggregation("month");var R=false;if(B.length>1){R=true;}this.setProperty("primaryCalendarType",A,!R);this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:A});if(this._oFocusedDate){this._oFocusedDate=new c(this._oFocusedDate,A);}this._oMinDate=new c(this._oMinDate,A);this._oMaxDate=new c(this._oMaxDate,A);for(var i=0;i<B.length;i++){var E=B[i];E.setPrimaryCalendarType(A);}var F=this.getAggregation("monthPicker");F.setPrimaryCalendarType(A);var G=this.getAggregation("yearPicker");G.setPrimaryCalendarType(A);if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(this.iMode!=1&&F.getDomRef()){F.$().remove();}if(this.iMode!=2&&G.getDomRef()){G.$().remove();}}return this;};
d.prototype.setSecondaryCalendarType=function(A){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",A,true);this._oYearFormatSecondary=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:A});var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];E.setSecondaryCalendarType(A);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};
d.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};
d.prototype.setMinDate=function(i){if(q.sap.equal(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var A=this._oMinDate.getYear();a._checkYearInValidRange(A);if(this._oMaxDate.isBefore(this._oMinDate)){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("minDate",i,false);var B=this.getAggregation("yearPicker");B._oMinDate.setYear(this._oMinDate.getYear());return this;};
d.prototype.setMaxDate=function(i){if(q.sap.equal(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var A=this._oMaxDate.getYear();a._checkYearInValidRange(A);if(this._oMinDate.isAfter(this._oMaxDate)){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("maxDate",i,false);var B=this.getAggregation("yearPicker");B._oMaxDate.setYear(this._oMaxDate.getYear());return this;};
d.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){q.sap.log.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};
d.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var A=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(A);}return this._oLocaleData;};
d.prototype._getShowMonthHeader=function(){var i=o.call(this);if(i>2){return true;}else{return false;}};
d.prototype.setWidth=function(W){this.setProperty("width",W,true);if(this.getDomRef()){W=this.getWidth();this.$().css("width",W);if(W){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};
d.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};
d.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};
d.prototype.onsapescape=function(E){if(this._iMode==0){this.fireCancel();}this._closedPickers();};
d.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};
d.prototype.onsaphide=d.prototype.onsapshow;
d.prototype.onsaptabnext=function(E){var A=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(A.getDomRef("B1"));if(!this._bPoupupMode){var B=this.getAggregation("month");var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");for(var i=0;i<B.length;i++){var I=B[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}E.preventDefault();}else if(E.target.id==A.getId()+"-B1"){q.sap.focus(A.getDomRef("B2"));E.preventDefault();}};
d.prototype.onsaptabprevious=function(E){var A=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(A.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==A.getId()+"-B1"){var B=this.getAggregation("month");var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");var I;switch(this._iMode){case 0:I=this._getFocusedDate();for(var i=0;i<B.length;i++){var J=B[i];var K=c.fromLocalJSDate(J.getDate(),this.getPrimaryCalendarType());if(I.isSame(K)){J._oItemNavigation.focusItem(J._oItemNavigation.getFocusedIndex());}else{q(J._oItemNavigation.getItemDomRefs()[J._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:F._oItemNavigation.focusItem(F._oItemNavigation.getFocusedIndex());break;case 2:G._oItemNavigation.focusItem(G._oItemNavigation.getFocusedIndex());break;}E.preventDefault();}else if(E.target.id==A.getId()+"-B2"){q.sap.focus(A.getDomRef("B1"));E.preventDefault();}};
d.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var A=this.getAggregation("header");var B=this.getAggregation("month");var F=this.getAggregation("monthPicker");var G=this.getAggregation("yearPicker");q.sap.focus(A.getDomRef("B2"));if(!this._bPoupupMode){for(var i=0;i<B.length;i++){var I=B[i];q(I._oItemNavigation.getItemDomRefs()[I._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(G.getDomRef()){q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};
d.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var A=this.getAggregation("month");var B=this.getAggregation("monthPicker");var F=this.getAggregation("yearPicker");switch(this._iMode){case 0:for(var i=0;i<A.length;i++){var G=A[i];q(G._oItemNavigation.getItemDomRefs()[G._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};
d.prototype.getFocusDomRef=function(){var i=this.getAggregation("month");var A=i[0];return A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()];};
d.prototype.onThemeChanged=function(){if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;var A=this.getAggregation("monthPicker");f.call(this,true);A._bNoThemeChange=false;A.onThemeChanged(arguments);A._bNoThemeChange=true;this._bLongMonth=A._bLongMonth;g.call(this,true);var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];E._bNoThemeChange=false;E.onThemeChanged(arguments);E._bNoThemeChange=true;}var F;if(B.length>1){F=c.fromLocalJSDate(B[0].getDate(),this.getPrimaryCalendarType());}else{F=this._getFocusedDate();}m.call(this,F);k.call(this);};
d.prototype._updateHeader=function(i){m.call(this,i);this._togglePrevNext(i,true);};
d.prototype._togglePrevNext=function(i,A){var B=this._oMaxDate.getYear();var E=this._oMinDate.getYear();var F=this._oMaxDate.getMonth();var G=this._oMinDate.getMonth();var I=this.getAggregation("header");var J=o.call(this);var K=new c(i,this.getPrimaryCalendarType());if(this._iMode==0&&J>1){K=z.call(this,i);K.setMonth(K.getMonth()+J-1);K.setDate(a._daysInMonth(K));}else{K.setDate(a._daysInMonth(K));}var N=K.getYear();var O=K.getMonth();if(N>B||(N==B&&(!A||O>=F))||(this._iMode==1&&this.getPickerPopup&&this.getPickerPopup())){I.setEnabledNext(false);}else{I.setEnabledNext(true);}if(this._iMode==0&&J>1){K.setMonth(K.getMonth()-J+1);K.setDate(1);}else{K.setDate(1);}N=K.getYear();O=K.getMonth();if(N<E||(N==E&&(!A||O<=G))||(this._iMode==1&&this.getPickerPopup&&this.getPickerPopup())){I.setEnabledPrevious(false);}else{I.setEnabledPrevious(true);}};
d.prototype._togglePrevNexYearPicker=function(){var i=this.getAggregation("yearPicker");var A=i.getYears();var B=c.fromLocalJSDate(i.getFirstRenderedDate());B.setYear(B.getYear()+Math.floor(A/2));var E=this.getAggregation("header");var F=new c(this._oMaxDate,this.getPrimaryCalendarType());F.setYear(F.getYear()-Math.ceil(A/2));F.setMonth(11);F.setDate(31);var G=new c(this._oMinDate,this.getPrimaryCalendarType());G.setYear(G.getYear()+Math.floor(A/2)+1);G.setMonth(0);G.setDate(1);E.setEnabledNext(B.isSameOrBefore(F));E.setEnabledPrevious(B.isSameOrAfter(G));};
d.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var i=this.getAggregation("header");var A=this.getAggregation("yearPicker");var B=o.call(this);var G;var I;var N=false;switch(this._iMode){case 0:if(B>1){G=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());G.setDate(1);this._setFocusedDate(G);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);_.call(this,N,true);break;case 1:F.setYear(F.getYear()-1);i.setTextButton2(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){I=new c(F,S);I.setMonth(0);I.setDate(1);i.setAdditionalTextButton2(this._oYearFormatSecondary.format(I.toUTCJSDate(),true));}else{i.setAdditionalTextButton2();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:A.previousPage();this._togglePrevNexYearPicker();break;}};
d.prototype._handleNext=function(E){var F=this._getFocusedDate();var i=this.getAggregation("header");var A=this.getAggregation("yearPicker");var B=o.call(this);var G;var I;switch(this._iMode){case 0:if(B>1){G=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(G);F=this._getFocusedDate();}F.setDate(1);F.setMonth(F.getMonth()+B);_.call(this);break;case 1:F.setYear(F.getYear()+1);i.setTextButton2(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){I=new c(F,S);I.setMonth(0);I.setDate(1);i.setAdditionalTextButton2(this._oYearFormatSecondary.format(I.toUTCJSDate(),true));}else{i.setAdditionalTextButton2();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:A.nextPage();this._togglePrevNexYearPicker();break;}};
d.prototype._getDisplayedMonths=function(A){var B=[];var E=A.getMonth();var F=o.call(this);if(F>1){for(var i=0;i<F;i++){B.push((E+i)%12);}}else{B.push(E);}return B;};
d.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=c.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new c(F,S);var A=F.getMonth();var B=c.fromLocalJSDate(i[i.length-1].getDate(),P);B.setDate(a._daysInMonth(B));B=new c(B,S);var E=B.getMonth();return{start:A,end:E};};
d.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:g.call(this);break;case 2:j.call(this);break;}};
d.prototype._setDisabledMonths=function(i,A){var B=0;var E=11;if(i==this._oMinDate.getYear()){B=this._oMinDate.getMonth();}if(i==this._oMaxDate.getYear()){E=this._oMaxDate.getMonth();}if(!A){A=this.getAggregation("monthPicker");}A.setMinMax(B,E);};
d.prototype._handleFocus=function(E){var i=c.fromLocalJSDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var R=E.getParameter("restoreOldDate");if(R){if(!q.sap.equal(this._getFocusedDate(),i)){_.call(this,false,false,true);}}else{this._focusDate(i,O);}};
d.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};
function _(N,I,A){var B=this._getFocusedDate();var E=this.getAggregation("month");var F=false;var G;var J;var K;var i=0;for(i=0;i<E.length;i++){G=E[i];if(G.checkDateFocusable(B.toLocalJSDate())){F=true;}if(F||E.length==1){if(!N){G.setDate(B.toLocalJSDate());}else{G.displayDate(B.toLocalJSDate());}break;}}if(!F){K=new c(B,this.getPrimaryCalendarType());if(E.length>1){K=z.call(this,K);for(i=0;i<E.length;i++){G=E[i];J=new c(K,this.getPrimaryCalendarType());J.setMonth(K.getMonth()+i);if(!N&&a._isSameMonthAndYear(J,B)){G.setDate(B.toLocalJSDate());}else{G.displayDate(J.toLocalJSDate());}}}this._updateHeader(K);if(!A){this.fireStartDateChange();}}}
function e(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=c.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate,i);}}
function f(N){if(this._iMode==2){j.call(this,true);}var A=this._getFocusedDate();var B=this.getAggregation("monthPicker");if(!this.getPickerPopup||!this.getPickerPopup()){if(B.getDomRef()){B.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(B);R.flush($[0],false,true);R.destroy();}}else{this._openPickerPopup(B);}this.$("contentOver").css("display","");if(!N){B.setMonth(A.getMonth());this._setDisabledMonths(A.getYear(),B);if(this._iMode==0){var E=this.getAggregation("month");for(var i=0;i<E.length;i++){var F=E[i];q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(A,false);}
function g(N){this._iMode=0;if(!this.getPickerPopup||!this.getPickerPopup()){var A=this.getAggregation("monthPicker");A.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){_.call(this);if(o.call(this)>1){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);}
function h(){if(this._iMode==1){g.call(this,true);}var A=this._getFocusedDate();var B=this.getAggregation("yearPicker");if(!this.getPickerPopup||!this.getPickerPopup()){if(B.getDomRef()){B.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(B);R.flush($[0],false,true);R.destroy();}}else{this._openPickerPopup(B);}this.$("contentOver").css("display","");B.setDate(A.toLocalJSDate());var E;if(o.call(this)==1){E=this.getAggregation("month")[0];var F=E.$("days").find(".sapUiCalItem");if(F.length==28){B.$().addClass("sapUiCalYearNoTop");}else{B.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var G=this.getAggregation("month");for(var i=0;i<G.length;i++){E=G[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;}
function j(N){this._iMode=0;if(!this.getPickerPopup||!this.getPickerPopup()){var A=this.getAggregation("yearPicker");A.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){_.call(this);if(o.call(this)>1){var B=this.getAggregation("month");for(var i=0;i<B.length;i++){var E=B[i];q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);}
function k(){if(!this._bNamesLengthChecked){f.call(this,true);g.call(this,true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var A=this.getAggregation("month");var B;if(A.length>1){B=c.fromLocalJSDate(A[0].getDate(),this.getPrimaryCalendarType());}else{B=this._getFocusedDate();}m.call(this,B);}}else if(o.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}
d.prototype._focusDate=function(i,O,N){var F;var A=false;var B=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;A=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;A=true;}else{F=i;}if(this._focusDateExtend){B=this._focusDateExtend(i,O,N);}var I=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(A||O){_.call(this,false,I,N);}if(B){this.fireStartDateChange();}};
d.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var A=this.getAggregation("month");if(A){for(var i=0;i<A.length;i++){var B=A[i];B._bDateRangeChanged=true;B._bInvalidateSync=true;if(A.length>1){B._bNoFocus=true;}B.invalidate(O);B._bInvalidateSync=undefined;}if(A.length>1){this._focusDate(this._getFocusedDate(),true,true);}}this._bDateRangeChanged=undefined;};
function m(i){var A=this.getAggregation("header");var B=this._getLocaleData();var E=[];var F=[];var G=[];var I;var S=false;var T;var P;var J=this.getPrimaryCalendarType();var K=this._getSecondaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){E=B.getMonthsStandAlone("wide",J);}else{S=true;E=B.getMonthsStandAlone("abbreviated",J);F=B.getMonthsStandAlone("wide",J);}if(K){G=B.getMonthsStandAlone("abbreviated",K);var N=this._getDisplayedSecondaryMonths(J,K);if(N.start==N.end){T=G[N.start];}else{P=B.getIntervalPattern();T=P.replace(/\{0\}/,G[N.start]).replace(/\{1\}/,G[N.end]);}}A.setAdditionalTextButton1(T);var O=this._getDisplayedMonths(i);if(O.length>1&&!this._bShowOneMonth){if(!P){P=B.getIntervalPattern();}T=P.replace(/\{0\}/,E[O[0]]).replace(/\{1\}/,E[O[O.length-1]]);if(S){I=P.replace(/\{0\}/,F[O[0]]).replace(/\{1\}/,F[O[O.length-1]]);}}else{T=E[O[0]];if(S){I=F[O[0]];}}A.setTextButton1(T);if(S){A.setAriaLabelButton1(I);}var Q=new c(i,J);Q.setDate(1);A.setTextButton2(this._oYearFormat.format(Q.toUTCJSDate(),true));if(K){Q=new c(Q,K);A.setAdditionalTextButton2(this._oYearFormatSecondary.format(Q.toUTCJSDate(),true));}else{A.setAdditionalTextButton2();}}
function n(i,N){if(!i){return;}var A=c.fromLocalJSDate(i,this.getPrimaryCalendarType());if(this._oFocusedDate&&this._oFocusedDate.isSame(A)){return;}var B=A.getYear();a._checkYearInValidRange(B);if(a._isOutside(A,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(A);if(this.getDomRef()&&this._iMode==0){_.call(this,N,false,true);}}
function o(){if(sap.ui.Device.system.phone){return 1;}else{return this.getMonths();}}
function p(E){if(this._iMode!=1){f.call(this);}else{g.call(this);}}
function r(E){if(this._iMode!=2){h.call(this);}else{j.call(this);}}
function s(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}
function t(E){if(o.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];if(B.getId()!=E.oSource.getId()){B._updateSelection();}}}this.fireSelect();}
function u(E){if(o.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];if(B.getId()!=E.oSource.getId()){B._bindMousemove();}}}}
function v(E){if(o.call(this)>1){var A=this.getAggregation("month");for(var i=0;i<A.length;i++){var B=A[i];if(B.getId()!=E.oSource.getId()){B._unbindMousemove();}}}}
function w(E){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this.getAggregation("monthPicker"),A=i.getMonth();if(this._adjustFocusedDateUponMonthChange){this._adjustFocusedDateUponMonthChange(F,A);}else{F.setMonth(A);if(A!=F.getMonth()){F.setDate(0);}}this._focusDate(F,true);g.call(this);}
function x(E){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());var i=this.getAggregation("yearPicker");var A=c.fromLocalJSDate(i.getDate(),this.getPrimaryCalendarType());var B=i.getYear();var G;if(this._adjustFocusedDateUponYearChange){G=this._adjustFocusedDateUponYearChange(F,B);if(G){F=G;}}else{A.setMonth(F.getMonth());A.setDate(F.getDate());F=A;}this._focusDate(F,true);j.call(this);}
function y(E){var W=E.size.width;if(W<=0){return;}var O=this._iSize;if(W<this._iBreakPointTablet){this._iSize=0;}else if(W<this._iBreakPointDesktop){this._iSize=1;}else if(W<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var A=o.call(this);var B;if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:B=2;break;case 2:B=3;break;case 3:B=4;break;default:B=1;break;}if(A<B){B=A;}if(B>2&&A>B){var F=B;var U=0.0;var G=B;while(F>=2){var I=A%F;if(I==0){G=F;break;}else{var N=I/F;if(N>U){U=N;G=F;}}F--;}B=G;}var J;var K=this.getAggregation("month");if(B>1){J=100/B+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{J="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<K.length;i++){var P=K[i];P.setWidth(J);}}}
function z(i){var F=new c(i,this.getPrimaryCalendarType());F.setDate(1);var A=o.call(this);if(A<=12){var B=i.getMonth();B=B-B%A;if(12%A>0&&B+A>11){B=12-A;}F.setMonth(B);}return F;}
return d;},true);
sap.ui.predefine('sap/ui/unified/CalendarAppointment',['jquery.sap.global','./DateTypeRange','sap/ui/core/format/DateFormat','./library'],function(q,D,a,l){"use strict";
var C=D.extend("sap.ui.unified.CalendarAppointment",{metadata:{library:"sap.ui.unified",properties:{title:{type:"string",group:"Data"},text:{type:"string",group:"Data"},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},tentative:{type:"boolean",group:"Data",defaultValue:false},selected:{type:"boolean",group:"Data",defaultValue:false},key:{type:"string",group:"Data",defaultValue:null},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}}}});
C.prototype.applyFocusInfo=function(f){var p=this.getParent();if(p){p.applyFocusInfo(f);}return this;};
C.prototype._getDateRangeIntersectionText=function(c){var s=this.getStartDate(),e=this.getEndDate()?this.getEndDate():new Date(864000000000000),t,o=new Date(c.getFullYear(),c.getMonth(),c.getDate(),0,0,0),n=new Date(o.getTime()+24*60*60*1000),T=a.getTimeInstance({pattern:"HH:mm"}),r=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(s.getTime()>n.getTime()||e.getTime()<o.getTime()){t="";}else if(s.getTime()<o.getTime()&&e.getTime()>n.getTime()){t=r.getText("PLANNINGCALENDAR_ALLDAY");}else if(s.getTime()<o.getTime()){t=r.getText("PLANNINGCALENDAR_UNTIL",[T.format(e)]);}else if(e.getTime()>n.getTime()){t=T.format(s);}else{t=T.format(s)+" - "+T.format(e);}return t;};
C._getComparer=function(d){var O=24*60*60*1000,c=new Date(d.getFullYear(),d.getMonth(),d.getDate(),0,0,0).getTime(),n=c+O;return function(A,o){var s=A.appointment.getStartDate().getTime(),S=o.appointment.getStartDate().getTime(),e=A.appointment.getEndDate()?A.appointment.getEndDate().getTime():864000000000000,E=o.appointment.getEndDate()?o.appointment.getEndDate().getTime():864000000000000,w=s<=c&&e>=n,W=S<=c&&E>=n,r;if((w&&W)||(!w&&!W)){r=s-S;if(r===0){r=E-e;}}else if(w){r=-1;}else{r=1;}return r;};};
C.prototype.setColor=function(c){if(c&&c.match(/^#[0-9a-f]{6}$/i)){q.sap.log.warning("setColor accepts only full hex color value with pound symbol.");}return this.setProperty("color",c);};
C.prototype._getCSSColorForBackground=function(h){return"rgba("+[parseInt(h.substr(1,2),16),parseInt(h.substr(3,2),16),parseInt(h.substr(5,2),16)].join(",")+", 0.2)";};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarDateInterval',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./Calendar','./calendar/Header','./calendar/Month','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/unified/calendar/CalendarDate','./library'],function(q,C,L,D,a,b,H,M,c,d,Y,e,l){"use strict";
var f=b.extend("sap.ui.unified.CalendarDateInterval",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false}}}});
f.prototype.init=function(){b.prototype.init.apply(this,arguments);var m=this.getAggregation("monthPicker");m.setColumns(0);m.setMonths(3);m.attachEvent("pageChange",g,this);var y=this.getAggregation("yearPicker");y.setColumns(0);y.setYears(3);y.attachEvent("pageChange",h,this);this._iDaysMonthHead=35;};
f.prototype._getDaysLarge=function(){return 10;};
f.prototype._createMonth=function(i){var m=new c(i);return m;};
f.prototype.setStartDate=function(s){a._checkJSDateObject(s);if(q.sap.equal(this.getStartDate(),s)){return this;}var y=s.getFullYear();a._checkYearInValidRange(y);var o=e.fromLocalJSDate(s,this.getPrimaryCalendarType());if(a._isOutside(o,this._oMinDate,this._oMaxDate)){throw new Error("Date must be in valid range (minDate and maxDate); "+this);}var m=this.getMinDate();if(m&&s.getTime()<m.getTime()){q.sap.log.warning("startDate < minDate -> minDate as startDate set",this);s=new Date(m.getTime());}var i=this.getMaxDate();if(i&&s.getTime()>i.getTime()){q.sap.log.warning("startDate > maxDate -> maxDate as startDate set",this);s=new Date(i.getTime());}this.setProperty("startDate",s,true);o=e.fromLocalJSDate(s,this.getPrimaryCalendarType());this._oStartDate=o;var j=this.getAggregation("month")[0];j.setStartDate(s);this._updateHeader(o);var k=this._getFocusedDate(true).toLocalJSDate();if(!j.checkDateFocusable(k)){this._setFocusedDate(o);j.displayDate(s);}return this;};
f.prototype.getStartDate=function(){return this.getProperty("startDate");};
f.prototype.setDays=function(i){this.setProperty("days",i,true);i=this._getDays();var o=this.getAggregation("month")[0];o.setDays(i);if(!this.getPickerPopup()){var m=this.getAggregation("monthPicker");var j=Math.ceil(i/3);if(j>12){j=12;}m.setMonths(j);var y=this.getAggregation("yearPicker");var k=Math.floor(i/2);if(k>20){k=20;}y.setYears(k);}var s=this._getStartDate();this._updateHeader(s);if(this.getDomRef()){if(i>this._getDaysLarge()){this.$().addClass("sapUiCalIntLarge");}else{this.$().removeClass("sapUiCalIntLarge");}if(i>this._iDaysMonthHead){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
f.prototype._getDays=function(){var i=this.getDays();if(sap.ui.Device.system.phone&&i>8){return 8;}else{return i;}};
f.prototype.setShowDayNamesLine=function(s){this.setProperty("showDayNamesLine",s,true);var o=this.getAggregation("month")[0];o.setShowDayNamesLine(s);return this;};
f.prototype._getShowMonthHeader=function(){var i=this._getDays();if(i>this._iDaysMonthHead){return true;}else{return false;}};
f.prototype._getFocusedDate=function(F){if(!this._oFocusedDate||F){this._oFocusedDate=null;b.prototype._getFocusedDate.apply(this,arguments);var s=this.getStartDate();var o=this.getAggregation("month")[0];if(!s){this._setStartDate(this._oFocusedDate,false,true);}else if(!o.checkDateFocusable(this._oFocusedDate.toLocalJSDate())){this._oFocusedDate=e.fromLocalJSDate(s,this.getPrimaryCalendarType());}}return this._oFocusedDate;};
f.prototype.setMonths=function(m){if(m==1){return this.setProperty("months",m,false);}else{throw new Error("Property months not supported "+this);}};
f.prototype.setFirstDayOfWeek=function(F){if(F==-1){return this.setProperty("firstDayOfWeek",F,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};
f.prototype.focusDate=function(o){var i=this.getAggregation("month")[0];if(!i.checkDateFocusable(o)){this._focusDateExtend(e.fromLocalJSDate(o,this.getPrimaryCalendarType()),true,true);}b.prototype.focusDate.apply(this,arguments);return this;};
f.prototype._focusDateExtend=function(o,O,n){if(O){var i=this._getFocusedDate();var j=this._getStartDate();var k=a._daysBetween(i,j);var N=new e(o,this.getPrimaryCalendarType());N.setDate(N.getDate()-k);this._setStartDate(N,false,true);if(!n){return true;}}return false;};
f.prototype._setMinMaxDateExtend=function(o){if(this._oStartDate){if(this._oStartDate.isBefore(this._oMinDate)){q.sap.log.warning("start date < minDate -> minDate will be start date",this);this._setStartDate(new e(this._oMinDate,this.getPrimaryCalendarType()),true,true);}else{var E=new e(this._oStartDate);E.setDate(E.getDate()+this._getDays()-1);if(E.isAfter(this._oMaxDate)){q.sap.log.warning("end date > maxDate -> start date will be changed",this);var s=new e(this._oMaxDate);s.setDate(s.getDate()-this._getDays()+1);this._setStartDate(s,true,true);}}}};
f.prototype.setPickerPopup=function(p){this.setProperty("pickerPopup",p,true);var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");if(p){m.setColumns(3);m.setMonths(12);y.setColumns(4);y.setYears(20);}else{m.setColumns(0);m.setMonths(6);y.setColumns(0);y.setYears(6);}return this;};
f.prototype._togglePrevNext=function(o,i){if(this._iMode>1||(this._iMode==1&&this.getPickerPopup())){return b.prototype._togglePrevNext.apply(this,arguments);}var y=this._oMaxDate.getYear();var j=this._oMinDate.getYear();var m=this._oMaxDate.getMonth();var k=this._oMinDate.getMonth();var n=this._oMinDate.getDate();var p=this._oMaxDate.getDate();var r=this.getAggregation("header");var s=this._getDays();var t;var S;var E;var u;var v;if(this._iMode==1&&!i){var w=this.getAggregation("monthPicker");var x=w.getMonths();var z=w.getStartMonth();var A=z+x-1;t=o.getYear();if(z==0||(t==j&&z<=k)){r.setEnabledPrevious(false);}else{r.setEnabledPrevious(true);}if(A>10||(t==y&&A>=m)){r.setEnabledNext(false);}else{r.setEnabledNext(true);}return;}S=this._getStartDate();E=new e(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+s-1);if(a._isOutside(o,S,E)){S=new e(o,this.getPrimaryCalendarType());E=new e(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+s-1);}t=S.getYear();u=S.getMonth();v=S.getDate();if(t<j||(t==j&&(!i||u<k||(u==k&&v<=n)))){r.setEnabledPrevious(false);}else{r.setEnabledPrevious(true);}t=E.getYear();u=E.getMonth();v=E.getDate();if(t>y||(t==y&&(!i||u>m||(u==m&&v>=p)))){r.setEnabledNext(false);}else{r.setEnabledNext(true);}};
f.prototype._shiftStartFocusDates=function(s,F,i){s.setDate(s.getDate()+i);F.setDate(F.getDate()+i);this._setFocusedDate(F);this._setStartDate(s,true);};
f.prototype._handlePrevious=function(E){var F=new e(this._getFocusedDate(),this.getPrimaryCalendarType());var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");var s=new e(this._getStartDate(),this.getPrimaryCalendarType());var i=this._getDays();switch(this._iMode){case 0:this._shiftStartFocusDates(s,F,(i*-1));break;case 1:if(m.getMonths()<12){m.previousPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()-1);var j=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(j){this.fireStartDateChange();}}break;case 2:y.previousPage();this._togglePrevNexYearPicker();break;}};
f.prototype._handleNext=function(E){var F=new e(this._getFocusedDate(),this.getPrimaryCalendarType());var m=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");var s=new e(this._getStartDate(),this.getPrimaryCalendarType());var i=this._getDays();switch(this._iMode){case 0:this._shiftStartFocusDates(s,F,i);break;case 1:if(m.getMonths()<12){m.nextPage();this._togglePrevNext(F);}else{F.setYear(F.getYear()+1);var j=this._focusDateExtend(F,true,false);this._setFocusedDate(F);this._updateHeader(F);this._setDisabledMonths(F.getYear());if(j){this.fireStartDateChange();}}break;case 2:y.nextPage();this._togglePrevNexYearPicker();break;}};
f.prototype._getDisplayedMonths=function(o){var m=[];var i=o.getMonth();var j=this._getDays();m.push(i);if(j>this._getDaysLarge()){var E=new e(o,this.getPrimaryCalendarType());E.setDate(E.getDate()+j-1);var k=E.getMonth();while(i!=k){i=(i+1)%12;m.push(i);}}return m;};
f.prototype._getDisplayedSecondaryMonths=function(p,s){var i=this._getDays();var S=new e(this._getStartDate(),s);var j=S.getMonth();var E=new e(S,this.getPrimaryCalendarType());E.setDate(E.getDate()+i-1);E=new e(E,s);var k=E.getMonth();return{start:j,end:k};};
f.prototype._openPickerPopup=function(p){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(_,this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(p);var o=this.getAggregation("header");var i=sap.ui.core.Popup.Dock;this._oPopup.open(0,i.CenterTop,i.CenterBottom,o,null,"flipfit",true);};
f.prototype._setStartDate=function(s,S,n){var m=new e(this._oMaxDate,this.getPrimaryCalendarType());m.setDate(m.getDate()-this._getDays()+1);if(m.isBefore(this._oMinDate)){m=new e(this._oMinDate);m.setDate(m.getDate()+this._getDays()-1);}if(s.isBefore(this._oMinDate)){s=new e(this._oMinDate,this.getPrimaryCalendarType());}else if(s.isAfter(m)){s=m;}var o=s.toLocalJSDate();this.setProperty("startDate",o,true);this._oStartDate=s;var i=this.getAggregation("month")[0];i.setStartDate(o);this._updateHeader(s);if(S){var j=this._getFocusedDate().toLocalJSDate();if(!i.checkDateFocusable(j)){this._setFocusedDate(s);i.setDate(o);}else{i.setDate(j);}}if(!n){this.fireStartDateChange();}};
f.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();}return this._oStartDate;};
function _(E){this._closedPickers();}
function g(E){var F=new e(this._getFocusedDate(),this.getPrimaryCalendarType());this._togglePrevNext(F);}
function h(E){this._togglePrevNexYearPicker();}
return f;},true);
sap.ui.predefine('sap/ui/unified/CalendarDateIntervalRenderer',['jquery.sap.global','sap/ui/core/Renderer','./CalendarRenderer'],function(q,R,C){"use strict";var a=R.extend(C);
a.addAttributes=function(r,c){r.addClass("sapUiCalInt");r.addClass("sapUiCalDateInt");var d=c._getDays();if(d>c._getDaysLarge()){r.addClass("sapUiCalIntLarge");}if(d>c._iDaysMonthHead){r.addClass("sapUiCalIntHead");}};
return a;},true);
sap.ui.predefine('sap/ui/unified/CalendarLegend',['jquery.sap.global','sap/ui/core/Control','./library'],function(q,C,l){"use strict";
var a=C.extend("sap.ui.unified.CalendarLegend",{metadata:{library:"sap.ui.unified",properties:{columnWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'120px'}},aggregations:{items:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,singularName:"item"},standardItems:{type:"sap.ui.unified.CalendarLegendItem",multiple:true,visibility:"hidden"}}}});
a.prototype.init=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var i=this.getId();var I=new sap.ui.unified.CalendarLegendItem(i+"-Today",{text:r.getText("LEGEND_TODAY")});this.addAggregation("standardItems",I);I=new sap.ui.unified.CalendarLegendItem(i+"-Selected",{text:r.getText("LEGEND_SELECTED")});this.addAggregation("standardItems",I);I=new sap.ui.unified.CalendarLegendItem(i+"-NormalDay",{text:r.getText("LEGEND_NORMAL_DAY")});this.addAggregation("standardItems",I);I=new sap.ui.unified.CalendarLegendItem(i+"-NonWorkingDay",{text:r.getText("LEGEND_NON_WORKING_DAY")});this.addAggregation("standardItems",I);};
a.prototype.onAfterRendering=function(){if(sap.ui.Device.browser.msie){if(sap.ui.Device.browser.version<10){q(".sapUiUnifiedLegendItem").css("width",this.getColumnWidth()+4+"px").css("display","inline-block");}}};
a.prototype._getItemType=function(i){var I=this.getItems(),t=i.getType(),n,f;if(t&&t!==sap.ui.unified.CalendarDayType.None){return t;}f=this._getUnusedItemTypes();n=I.filter(function(b){return!b.getType()||b.getType()===sap.ui.unified.CalendarDayType.None;}).indexOf(i);if(n<0){q.sap.log.error('Legend item is not in the legend',this);return t;}if(f[n]){t=f[n];}else{t="Type"+(Object.keys(sap.ui.unified.CalendarDayType).length+n-f.length-1);}return t;};
a.prototype._getItemByType=function(t){var I,b=this.getItems(),i;for(i=0;i<b.length;i++){if(this._getItemType(b[i])===t){I=b[i];break;}}return I;};
a.prototype._getUnusedItemTypes=function(){var f=q.extend({},sap.ui.unified.CalendarDayType),I=this.getItems(),t,i;delete f[sap.ui.unified.CalendarDayType.None];delete f[sap.ui.unified.CalendarDayType.NonWorking];for(i=0;i<I.length;i++){t=I[i].getType();if(f[t]){delete f[t];}}return Object.keys(f);};
a.typeARIATexts={};
a.getTypeAriaText=function(t){var r,T;if(t.indexOf("Type")!==0){return;}if(!a.typeARIATexts[t]){r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");T=r.getText("LEGEND_UNNAMED_TYPE",parseInt(t.slice(4),10).toString());a.typeARIATexts[t]=new sap.ui.core.InvisibleText({text:T});a.typeARIATexts[t].toStatic();}return a.typeARIATexts[t];};
return a;},true);
sap.ui.predefine('sap/ui/unified/CalendarLegendItem',['jquery.sap.global','sap/ui/core/Element','./library'],function(q,E,l){"use strict";
var C=E.extend("sap.ui.unified.CalendarLegendItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Misc",defaultValue:null},type:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:sap.ui.unified.CalendarDayType.None},color:{type:"sap.ui.core.CSSColor",group:"Appearance",defaultValue:null}}}});
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarLegendRenderer',['jquery.sap.global'],function(q){"use strict";var C={};
C.render=function(r,l){var s=l.getAggregation("standardItems");var c=l.getItems();var i=0;r.write("<div");r.writeControlData(l);r.addClass("sapUiUnifiedLegend");r.writeClasses();var a=l.getColumnWidth();r.writeAttribute("style","column-width:"+a+";-moz-column-width:"+a+";-webkit-column-width:"+a+";");r.writeStyles();r.write(">");var I=l.getId().length+1;for(i=0;i<s.length;++i){var b="sapUiUnifiedLegend"+s[i].getId().slice(I);this.renderLegendItem(r,b,s[i]);}for(i=0;i<c.length;i++){this.renderLegendItem(r,"sapUiCalLegDayType"+l._getItemType(c[i]).slice(4),c[i]);}r.write("</div>");};
C.renderLegendItem=function(r,c,i){var t=i.getText();var T=i.getTooltip_AsString();var s=i.getColor();r.write("<div");r.writeElementData(i);if(T){r.writeAttributeEscaped('title',T);}r.addClass("sapUiUnifiedLegendItem");r.addClass(c);r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiUnifiedLegendSquare");r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiUnifiedLegendSquareColor");if(s){r.addStyle("background-color",s);r.writeStyles();}r.writeClasses();r.write("></div></div>");r.write("<div");r.writeAttribute("id",i.getId()+"-Text");r.addClass("sapUiUnifiedLegendDescription");r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</div></div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarMonthInterval',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/MonthsRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/unified/calendar/CalendarDate','./library'],function(q,C,L,D,a,H,M,b,Y,c,l){"use strict";
var d=C.extend("sap.ui.unified.CalendarMonthInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:12},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},monthsRow:{type:"sap.ui.unified.calendar.MonthsRow",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});
d.prototype.init=function(){this._iMode=0;this.data("sap-ui-fastnavgroup","true",true);this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y"});this._oMinDate=a._minDate();this._oMaxDate=a._maxDate();var A=new H(this.getId()+"--Head",{visibleButton0:false,visibleButton1:false,visibleButton2:true});A.attachEvent("pressPrevious",this._handlePrevious,this);A.attachEvent("pressNext",this._handleNext,this);A.attachEvent("pressButton2",r,this);this.setAggregation("header",A);var B=new M(this.getId()+"--MonthsRow");B.attachEvent("focus",t,this);B.attachEvent("select",s,this);B._bNoThemeChange=true;this.setAggregation("monthsRow",B);var E=new Y(this.getId()+"--YP",{columns:0,years:6});E.attachEvent("select",u,this);E.attachEvent("pageChange",z,this);this.setAggregation("yearPicker",E);this._iDaysMonthsHead=15;};
d.prototype.exit=function(){if(this._sInvalidateContent){q.sap.clearDelayedCall(this._sInvalidateContent);}};
d.prototype.onBeforeRendering=function(){var A=this.getAggregation("monthsRow");var B=this._getFocusedDate();j.call(this);A.displayDate(B.toLocalJSDate());};
d.prototype.setStartDate=function(S){a._checkJSDateObject(S);if(q.sap.equal(this.getStartDate(),S)){return this;}var A=S.getFullYear();a._checkYearInValidRange(A);this.setProperty("startDate",S,true);this._oStartDate=c.fromLocalJSDate(S);this._oStartDate.setDate(1);var B=this.getAggregation("monthsRow");B.setStartDate(S);j.call(this);var E=this._getFocusedDate().toLocalJSDate();if(!B.checkDateFocusable(E)){this._setFocusedDate(this._oStartDate);B.displayDate(S);}return this;};
d.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=q.sap.delayedCall(0,this,v);}};
d.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
d.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var A=this.destroyAggregation("selectedDates");return A;};
d.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
d.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var A=this.destroyAggregation("specialDates");return A;};
d.prototype.setLocale=function(A){if(this._sLocale!=A){this._sLocale=A;this._oLocaleData=undefined;this.invalidate();}return this;};
d.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
d.prototype._getFocusedDate=function(){if(!this._oFocusedDate){g.call(this);}return this._oFocusedDate;};
d.prototype._setFocusedDate=function(A){a._checkCalendarDate(A);this._oFocusedDate=new c(A);};
d.prototype.focusDate=function(A){var F=false;var B=this.getAggregation("monthsRow");if(A&&!B.checkDateFocusable(A)){w.call(this,c.fromLocalJSDate(A));F=true;}p.call(this,A,false);if(F){this.fireStartDateChange();}return this;};
d.prototype.displayDate=function(A){p.call(this,A,true);return this;};
d.prototype.setMonths=function(A){this.setProperty("months",A,true);A=this._getMonths();var B=this.getAggregation("monthsRow");B.setMonths(A);if(!B.checkDateFocusable(this._getFocusedDate().toLocalJSDate())){var S=e.call(this);this._setFocusedDate(this._oStartDate);B.setDate(S.toLocalJSDate());}if(!this.getPickerPopup()){var E=this.getAggregation("yearPicker");var F=Math.floor(A/2);if(F>20){F=20;}E.setYears(F);}j.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
d.prototype._getMonths=function(){var A=this.getMonths();if(sap.ui.Device.system.phone&&A>6){return 6;}else{return A;}};
d.prototype._getLocaleData=function(){if(!this._oLocaleData){var A=this.getLocale();var B=new sap.ui.core.Locale(A);this._oLocaleData=L.getInstance(B);}return this._oLocaleData;};
d.prototype.setPickerPopup=function(P){this.setProperty("pickerPopup",P,true);var A=this.getAggregation("yearPicker");if(P){A.setColumns(4);A.setYears(20);}else{A.setColumns(0);A.setYears(6);}return this;};
d.prototype.setMinDate=function(A){if(q.sap.equal(A,this.getMinDate())){return this;}if(!A){this._oMinDate=a._minDate();}else{a._checkJSDateObject(A);this._oMinDate=c.fromLocalJSDate(A);this._oMinDate.setDate(1);var B=this._oMinDate.getYear();a._checkYearInValidRange(B);if(this._oMaxDate.isBefore(this._oMinDate)){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(A);this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isBefore(this._oMinDate)){q.sap.log.warning("focused date < minDate -> minDate focused",this);this.focusDate(A);}}if(this._oStartDate&&this._oStartDate.isBefore(this._oMinDate)){q.sap.log.warning("start date < minDate -> minDate set as start date",this);_.call(this,new c(this._oMinDate),true,true);}}this.setProperty("minDate",A,false);var E=this.getAggregation("yearPicker");E._oMinDate.setYear(this._oMinDate.getYear());return this;};
d.prototype.setMaxDate=function(A){if(q.sap.equal(A,this.getMaxDate())){return this;}if(!A){this._oMaxDate=a._maxDate();}else{a._checkJSDateObject(A);this._oMaxDate=c.fromLocalJSDate(A);this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));var B=this._oMaxDate.getYear();a._checkYearInValidRange(B);if(this._oMinDate.isAfter(this._oMaxDate)){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(A);this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}if(this._oFocusedDate){if(this._oFocusedDate.isAfter(this._oMaxDate)){q.sap.log.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(A);}}if(this._oStartDate){var E=new c(this._oStartDate);E.setDate(1);E.setMonth(E.getMonth()+this._getMonths());E.setDate(0);if(E.isAfter(this._oMaxDate)){var S=new c(this._oMaxDate);S.setDate(1);S.setMonth(S.getMonth()-this._getMonths()+1);if(S.isSameOrAfter(this._oMinDate)){q.sap.log.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,S,true,true);}}}}this.setProperty("maxDate",A,false);var F=this.getAggregation("yearPicker");F._oMaxDate.setYear(this._oMaxDate.getYear());return this;};
d.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};
d.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};
d.prototype.onsapescape=function(E){switch(this._iMode){case 0:this.fireCancel();break;case 1:i.call(this);break;}};
d.prototype.onsaptabnext=function(E){var A=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){q.sap.focus(A.getDomRef("B2"));if(!this._bPoupupMode){var B=this.getAggregation("monthsRow");var F=this.getAggregation("yearPicker");q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}E.preventDefault();}};
d.prototype.onsaptabprevious=function(E){var A=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._bPoupupMode){q.sap.focus(A.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==A.getId()+"-B2"){var B=this.getAggregation("monthsRow");var F=this.getAggregation("yearPicker");switch(this._iMode){case 0:B._oItemNavigation.focusItem(B._oItemNavigation.getFocusedIndex());break;case 1:F._oItemNavigation.focusItem(F._oItemNavigation.getFocusedIndex());break;}E.preventDefault();}};
d.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var A=this.getAggregation("header");var B=this.getAggregation("monthsRow");var F=this.getAggregation("yearPicker");q.sap.focus(A.getDomRef("B2"));if(!this._bPoupupMode){q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(F.getDomRef()){q(F._oItemNavigation.getItemDomRefs()[F._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};
d.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var A=this.getAggregation("monthsRow");var B=this.getAggregation("yearPicker");switch(this._iMode){case 0:q(A._oItemNavigation.getItemDomRefs()[A._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 1:q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};
d.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var A=this.getAggregation("yearPicker");var B=this._getMonths();var S=new c(e.call(this));switch(this._iMode){case 0:S.setMonth(S.getMonth()-B);F.setMonth(F.getMonth()-B);this._setFocusedDate(F);_.call(this,S,true);break;case 1:A.previousPage();m.call(this);break;}};
d.prototype._handleNext=function(E){var F=this._getFocusedDate();var A=this.getAggregation("yearPicker");var B=this._getMonths();var S=new c(e.call(this));switch(this._iMode){case 0:S.setMonth(S.getMonth()+B);F.setMonth(F.getMonth()+B);this._setFocusedDate(F);_.call(this,S,true);break;case 1:A.nextPage();m.call(this);break;}};
d.prototype._getShowItemHeader=function(){var A=this.getMonths();if(A>this._iDaysMonthsHead){return true;}else{return false;}};
function _(S,A,N){var B=new c(this._oMaxDate);B.setDate(1);B.setMonth(B.getMonth()-this._getMonths()+1);if(B.isBefore(this._oMinDate)){B=new c(this._oMinDate);B.setMonth(B.getMonth()+this._getMonths()-1);}if(S.isBefore(this._oMinDate)){S=new c(this._oMinDate);}else if(S.isAfter(B)){S=B;}S.setDate(1);var E=S.toLocalJSDate();this.setProperty("startDate",E,true);this._oStartDate=S;var F=this.getAggregation("monthsRow");F.setStartDate(E);j.call(this);if(A){var G=this._getFocusedDate().toLocalJSDate();if(!F.checkDateFocusable(G)){this._setFocusedDate(S);F.setDate(E);}else{F.setDate(G);}}if(!N){this.fireStartDateChange();}}
function e(){if(!this._oStartDate){this._oStartDate=this._getFocusedDate();this._oStartDate.setDate(1);}return this._oStartDate;}
function f(N){var A=this._getFocusedDate();var B=this.getAggregation("monthsRow");if(!N){B.setDate(A.toLocalJSDate());}else{B.displayDate(A.toLocalJSDate());}j.call(this);}
function g(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate());}else{this._oFocusedDate=new c();}this._oFocusedDate.setDate(1);if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate);}}
function h(){var A=this._getFocusedDate();var B=this.getAggregation("yearPicker");if(!this.getPickerPopup()){if(B.getDomRef()){B.$().css("display","");}else{var R=sap.ui.getCore().createRenderManager();var $=this.$("content");R.renderControl(B);R.flush($[0],false,true);R.destroy();}}else{x.call(this,B);}this.$("contentOver").css("display","");B.setDate(A.toLocalJSDate());if(this._iMode==0){var E=this.getAggregation("monthsRow");q(E._oItemNavigation.getItemDomRefs()[E._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}m.call(this);this._iMode=1;}
function i(N){this._iMode=0;if(!this.getPickerPopup()){var A=this.getAggregation("yearPicker");A.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!N){f.call(this);var B=this.getAggregation("monthsRow");q(B._oItemNavigation.getItemDomRefs()[B._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function j(){n.call(this);k.call(this);}
function k(){var A=new c(e.call(this));var B=this._getMonths();var E=A.getYear();var F=this._oMaxDate.getYear();var G=this._oMinDate.getYear();var I=A.getMonth();var J=this._oMaxDate.getMonth();var K=this._oMinDate.getMonth();var N=this.getAggregation("header");if(E<G||(E==G&&I<=K)){N.setEnabledPrevious(false);}else{N.setEnabledPrevious(true);}A.setMonth(A.getMonth()+B-1);E=A.getYear();I=A.getMonth();if(E>F||(E==F&&I>=J)){N.setEnabledNext(false);}else{N.setEnabledNext(true);}}
function m(){var A=this.getAggregation("yearPicker");var B=A.getYears();var E=c.fromLocalJSDate(A.getFirstRenderedDate());E.setYear(E.getYear()+Math.floor(B/2));var F=this.getAggregation("header");var G=new c(this._oMaxDate);G.setYear(G.getYear()-Math.ceil(B/2));G.setMonth(11,31);var I=new c(this._oMinDate);I.setYear(I.getYear()+Math.floor(B/2)+1);I.setMonth(0,1);F.setEnabledNext(!E.isAfter(G));F.setEnabledPrevious(!E.isBefore(I));}
function n(){var T;var S=e.call(this);var A=this._oYearFormat.format(S.toUTCJSDate(),true);var E=new c(S);E.setMonth(E.getMonth()+this._getMonths()-1);var B=this._oYearFormat.format(E.toUTCJSDate(),true);if(A!=B){var F=this._getLocaleData();var P=F.getIntervalPattern();T=P.replace(/\{0\}/,A).replace(/\{1\}/,B);}else{T=A;}var G=this.getAggregation("header");G.setTextButton2(T);}
function o(A,N){var F;var B=false;if(A.isBefore(this._oMinDate)){F=this._oMinDate;B=true;}else if(A.isAfter(this._oMaxDate)){F=this._oMaxDate;B=true;}else{F=A;}this._setFocusedDate(F);if(B||N){w.call(this,F);f.call(this,false);this.fireStartDateChange();}}
function p(A,N){if(!A){return;}var B=c.fromLocalJSDate(A);if(this._oFocusedDate&&this._oFocusedDate.isSame(B)){return;}var E=B.getYear();a._checkYearInValidRange(E);if(a._isOutside(B,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(B);if(this.getDomRef()&&this._iMode==0){f.call(this,N);}}
function r(E){if(this._iMode!=1){h.call(this);}else{i.call(this);}}
function s(E){this.fireSelect();}
function t(E){var A=c.fromLocalJSDate(E.getParameter("date"));var N=E.getParameter("notVisible");o.call(this,A,N);}
function u(E){var F=new c(this._getFocusedDate());var A=this.getAggregation("yearPicker");var B=c.fromLocalJSDate(A.getDate());B.setMonth(F.getMonth());B.setDate(F.getDate());F=B;o.call(this,F,true);i.call(this);}
function v(){this._sInvalidateContent=undefined;var A=this.getAggregation("monthsRow");A._bDateRangeChanged=true;A._bInvalidateSync=true;A.invalidate();A._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}
function w(A){var B=this.getAggregation("monthsRow");var S=e.call(this);var E=B._oItemNavigation.getFocusedIndex();S=new c(A);S.setMonth(S.getMonth()-E);_.call(this,S,false,true);}
function x(P){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(y,this);this._oPopup.onsapescape=function(E){this._oCalendar.onsapescape(E);};}this._oPopup.setContent(P);var A=this.getAggregation("header");var B=sap.ui.core.Popup.Dock;this._oPopup.open(0,B.CenterTop,B.CenterBottom,A,null,"flipfit",true);}
function y(E){switch(this._iMode){case 0:break;case 1:i.call(this);break;}}
function z(E){m.call(this);}
return d;},true);
sap.ui.predefine('sap/ui/unified/CalendarMonthIntervalRenderer',['jquery.sap.global'],function(q){"use strict";var C={};
C.render=function(r,c){c._iMode=0;var i=c.getId();var t=c.getTooltip_AsString();var m=c.getAggregation("monthsRow");r.write("<div");r.writeControlData(c);r.addClass("sapUiCal");r.addClass("sapUiCalInt");r.addClass("sapUiCalMonthInt");if(c._getShowItemHeader()){r.addClass("sapUiCalIntHead");}r.writeAttribute("tabindex","-1");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped('title',t);}var w=c.getWidth();if(w&&w!=''){r.addStyle("width",w);r.writeStyles();}r.writeClasses();r.write(">");var h=c.getAggregation("header");r.renderControl(h);r.write("<div id=\""+i+"-content\" class=\"sapUiCalContent\">");r.renderControl(m);r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>");r.write("</div>");r.write("<button id=\""+i+"-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">");r.write(a.getText("CALENDAR_CANCEL"));r.write("</button>");r.write("<div id=\""+i+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarOneMonthInterval',['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarDateIntervalRenderer','sap/ui/unified/calendar/OneMonthDatesRow'],function(q,C,a,l,b,c,O){"use strict";
var d=b.extend("CalendarOneMonthInterval",{renderer:c});
d.prototype.init=function(){b.prototype.init.apply(this,arguments);this._bShowOneMonth=true;};
d.prototype._createMonth=function(i){return new O(i);};
d.prototype._handleFocus=function(e){var o=!!e.getParameter("_outsideBorder"),D=e.getParameter("date"),f=a.fromLocalJSDate(D),g=a.fromLocalJSDate(this.getStartDate()),i=!C._isSameMonthAndYear(f,g),h,F,s;if(o||i){if(C._isLastDateInMonth(f)){this._oFocusDateOneMonth=f;}else{this._oFocusDateOneMonth=C._getFirstDateOfMonth(f);}h=f.isBefore(g)?-1:1;F=new a(this._getFocusedDate(),this.getPrimaryCalendarType());s=new a(this._getStartDate(),this.getPrimaryCalendarType());b.prototype._shiftStartFocusDates.call(this,F,s,h);}return b.prototype._handleFocus.apply(this,arguments);};
d.prototype._focusDateExtend=function(D,o,n){var e,L;if(!this._oFocusDateOneMonth){return b.prototype._focusDateExtend.apply(this,arguments);}e=this.getAggregation("month")[0];L=this._oFocusDateOneMonth.toLocalJSDate();this._setFocusedDate(this._oFocusDateOneMonth);e._bNoRangeCheck=true;e.setDate(L);e._bNoRangeCheck=false;if(this.getSelectedDates().length){this._setRowsStartDate(this.getSelectedDates()[0].getStartDate());}this._oFocusDateOneMonth=null;return!n;};
d.prototype._setDisplayMode=function(m){this.getAggregation("month")[0].setMode(m);};
d.prototype._shiftStartFocusDates=function(s,f,D){var S=D,o=this.getAggregation("month")[0];if(S!==0){S=S>0?1:-1;}s.setMonth(s.getMonth()+S);f.setYear(s.getYear());f.setMonth(s.getMonth());f.setDate(s.getDate());this._setFocusedDate(f);this._setStartDate(s,true);o.selectDate(s.toLocalJSDate());};
d.prototype._adjustFocusedDateUponMonthChange=function(f,m){f.setMonth(m);if(m!=f.getMonth()){f.setDate(0);}this._adjustSelectedDate(f,true);};
d.prototype._adjustFocusedDateUponYearChange=function(f,y){var Y=this.getAggregation("yearPicker"),D=a.fromLocalJSDate(Y.getDate(),this.getPrimaryCalendarType());D.setMonth(f.getMonth());D.setDate(f.getDate());f=D;this._adjustSelectedDate(f,true);return f;};
d.prototype._adjustSelectedDate=function(D,u){var m=this.getAggregation("month")[0],s;s=u?C._getFirstDateOfMonth(D):D;if(m.getMode&&m.getMode()<2){this._selectDate(s);}};
d.prototype._selectDate=function(D){var m=this.getAggregation("month")[0],L=D.toLocalJSDate();this.removeAllSelectedDates();this.addSelectedDate(new sap.ui.unified.DateRange({startDate:L}));m.selectDate(L);};
d.prototype._dateMatchesVisibleRange=function(D){return C._isSameMonthAndYear(a.fromLocalJSDate(this.getStartDate()),a.fromLocalJSDate(D));};
return d;},true);
sap.ui.predefine('sap/ui/unified/CalendarRenderer',['jquery.sap.global'],function(q){"use strict";var C={};
C.render=function(r,c){c._iMode=0;var I=c.getId();var t=c.getTooltip_AsString();var m=c.getAggregation("month");var w=c.getWidth();r.write("<div");r.writeControlData(c);r.addClass("sapUiCal");if(m.length>1){r.addClass("sapUiCalMulti");}r.writeAttribute("tabindex","-1");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped('title',t);}if(w){r.addClass("sapUiCalWidth");r.addStyle("width",w);r.writeStyles();}if(c._getSecondaryCalendarType()){r.addClass("sapUiCalSecType");}if(this.addAttributes){this.addAttributes(r,c);}r.writeClasses();r.write(">");var h=c.getAggregation("header");r.renderControl(h);r.write("<div id=\""+I+"-content\" class=\"sapUiCalContent\">");for(var i=0;i<m.length;i++){var M=m[i];r.renderControl(M);}r.write("<div id=\""+I+"-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>");if(!c._bNamesLengthChecked){var o=c.getAggregation("monthPicker");r.renderControl(o);}r.write("</div>");r.write("<button id=\""+I+"-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">");r.write(a.getText("CALENDAR_CANCEL"));r.write("</button>");r.write("<div id=\""+I+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarRow',['jquery.sap.global','sap/ui/core/Control','sap/ui/Device','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','./library'],function(q,C,D,L,a,b,U,l){"use strict";
var c=C.extend("sap.ui.unified.CalendarRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},intervals:{type:"int",group:"Appearance",defaultValue:12},intervalType:{type:"sap.ui.unified.CalendarIntervalType",group:"Appearance",defaultValue:sap.ui.unified.CalendarIntervalType.Hour},showSubIntervals:{type:"boolean",group:"Appearance",defaultValue:false},showIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},showEmptyIntervalHeaders:{type:"boolean",group:"Appearance",defaultValue:true},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},checkResize:{type:"boolean",group:"Behavior",defaultValue:true},updateCurrentTime:{type:"boolean",group:"Behavior",defaultValue:true},groupAppointmentsMode:{type:"sap.ui.unified.GroupAppointmentsMode",group:"Appearance",defaultValue:sap.ui.unified.GroupAppointmentsMode.Collapsed},appointmentsReducedHeight:{type:"boolean",group:"Appearance",defaultValue:false},appointmentsVisualization:{type:"sap.ui.unified.CalendarAppointmentVisualization",group:"Appearance",defaultValue:sap.ui.unified.CalendarAppointmentVisualization.Standard}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment"},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},groupAppointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"groupAppointment",visibility:"hidden"},_nonWorkingDates:{type:"sap.ui.unified.DateRange",multiple:true,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},appointments:{type:"sap.ui.unified.CalendarAppointment[]"},multiSelect:{type:"boolean"}}},startDateChange:{},leaveRow:{parameters:{type:{type:"string"}}},intervalSelect:{parameters:{startDate:{type:"object"},endDate:{type:"object"},subInterval:{type:"boolean"}}}}}});
c.PCROW_FOREIGN_KEY_NAME="relatedToPCRowDateRange";c.AGGR_NONWORKING_DATES_NAME="_nonWorkingDates";
c.prototype.init=function(){this._bRTL=sap.ui.getCore().getConfiguration().getRTL();this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");if(!c._oStaticAppointmentText){c._oStaticAppointmentText=new sap.ui.core.InvisibleText({text:this._oRb.getText("APPOINTMENT")});c._oStaticAppointmentText.toStatic();c._oStaticTentativeText=new sap.ui.core.InvisibleText({text:this._oRb.getText("APPOINTMENT_TENTATIVE")});c._oStaticTentativeText.toStatic();}if(!c._oStaticSelectedText){c._oStaticSelectedText=new sap.ui.core.InvisibleText({text:this._oRb.getText("APPOINTMENT_SELECTED")});c._oStaticSelectedText.toStatic();}this._oFormatAria=sap.ui.core.format.DateFormat.getDateTimeInstance({pattern:"EEEE dd/MM/YYYY 'at' HH:mm:ss a"});this._iHoursMinDelta=1;this._iDaysMinDelta=30;this._iMonthsMinDelta=720;this._aVisibleAppointments=[];this._aVisibleIntervalHeaders=[];this.setStartDate(new Date());this._resizeProxy=q.proxy(this.handleResize,this);};
c.prototype.exit=function(){if(this._sResizeListener){sap.ui.core.ResizeHandler.deregister(this._sResizeListener);this._sResizeListener=undefined;}if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};
c.prototype.onBeforeRendering=function(){e.call(this);h.call(this);p.call(this);if(this._sUpdateCurrentTime){q.sap.clearDelayedCall(this._sUpdateCurrentTime);this._sUpdateCurrentTime=undefined;}};
c.prototype.onAfterRendering=function(){r.call(this);this.updateCurrentTimeVisualization();if(this.getCheckResize()&&!this._sResizeListener){this._sResizeListener=sap.ui.core.ResizeHandler.register(this,this._resizeProxy);}};
c.prototype.onThemeChanged=function(E){if(this.getDomRef()){for(var i=0;i<this._aVisibleAppointments.length;i++){var A=this._aVisibleAppointments[i];A.level=-1;}this.handleResize(E);}};
c.prototype.invalidate=function(O){if(O&&O instanceof sap.ui.unified.CalendarAppointment){var F=false;for(var i=0;i<this._aVisibleAppointments.length;i++){if(this._aVisibleAppointments[i].appointment==O){F=true;break;}}if(F){this._aVisibleAppointments=[];}}C.prototype.invalidate.apply(this,arguments);};
c.prototype.setStartDate=function(S){if(!S){S=new Date();}b._checkJSDateObject(S);var Y=S.getFullYear();b._checkYearInValidRange(Y);this.setProperty("startDate",S);return this;};
c.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=b._createUniversalUTCDate(this.getStartDate(),undefined,true);}return this._oUTCStartDate;};
c.prototype.setIntervalType=function(i){this.setProperty("intervalType",i);this._aVisibleAppointments=[];return this;};
c.prototype.setGroupAppointmentsMode=function(G){this.setProperty("groupAppointmentsMode",G);this._aVisibleAppointments=[];return this;};
c.prototype.setAppointmentsReducedHeight=function(A){this.setProperty("appointmentsReducedHeight",A);this._aVisibleAppointments=[];return this;};
c.prototype._getAppointmentReducedHeight=function(A){var R=false;if(!D.system.phone&&this.getAppointmentsReducedHeight()&&!A.getText()){R=true;}return R;};
c.prototype.onfocusin=function(E){if(q(E.target).hasClass("sapUiCalendarApp")){v.call(this,E.target.id);}else{var V=this._getVisibleAppointments();var F=false;var A;for(var i=0;i<V.length;i++){A=V[i].appointment;if(q.sap.containsOrEquals(A.getDomRef(),E.target)){F=true;A.focus();break;}}if(!F){A=this.getFocusedAppointment();if(A){A.focus();}}}};
c.prototype.applyFocusInfo=function(F){if(this._sFocusedAppointmentId){this.getFocusedAppointment().focus();}return this;};
c.prototype.onsapleft=function(E){if(q(E.target).hasClass("sapUiCalendarApp")){w.call(this,this._bRTL,1);}E.preventDefault();E.stopPropagation();};
c.prototype.onsapright=function(E){if(q(E.target).hasClass("sapUiCalendarApp")){w.call(this,!this._bRTL,1);}E.preventDefault();E.stopPropagation();};
c.prototype.onsapup=function(E){this.fireLeaveRow({type:E.type});};
c.prototype.onsapdown=function(E){this.fireLeaveRow({type:E.type});};
c.prototype.onsaphome=function(E){x.call(this,E);E.preventDefault();E.stopPropagation();};
c.prototype.onsapend=function(E){x.call(this,E);E.preventDefault();E.stopPropagation();};
c.prototype.onsapselect=function(E){var V=this._getVisibleAppointments();for(var i=0;i<V.length;i++){var A=V[i].appointment;if(q.sap.containsOrEquals(A.getDomRef(),E.target)){s.call(this,A,!E.ctrlKey);break;}}E.stopPropagation();E.preventDefault();};
c.prototype.ontap=function(E){var i=this.$("Apps").children(".sapUiCalendarRowAppsInt");var I=0;var j=false;for(I=0;I<i.length;I++){var k=i[I];if(q.sap.containsOrEquals(k,E.target)){j=true;break;}}if(j){y.call(this,I,E.target);}else{this.onsapselect(E);}};
c.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
c.prototype.handleResize=function(E){if(E&&E.size&&E.size.width<=0){return this;}var $=this.$("DummyApp");$.css("display","");r.call(this);return this;};
c.prototype.updateCurrentTimeVisualization=function(){var N=this.$("Now");var i=b._createUniversalUTCDate(new Date(),undefined,true);var I=this.getIntervals();var j=this.getIntervalType();var S=this._getStartDate();var k=S.getTime();var E=this._oUTCEndDate;var z=E.getTime();this._sUpdateCurrentTime=undefined;if(i.getTime()<=z&&i.getTime()>=k){var B=n.call(this,j,I,S,E,k,i);var T=0;if(this._bRTL){N.css("right",B+"%");}else{N.css("left",B+"%");}N.css("display","");if(this.getUpdateCurrentTime()){switch(j){case sap.ui.unified.CalendarIntervalType.Hour:T=60000;break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:T=1800000;break;default:T=-1;break;}if(T>0){this._sUpdateCurrentTime=q.sap.delayedCall(T,this,this.updateCurrentTimeVisualization);}}}else{N.css("display","none");}return this;};
c.prototype.getFocusedAppointment=function(){var A=t.call(this);var G=this.getAggregation("groupAppointments",[]);var j;var i=0;for(i=0;i<G.length;i++){if(G[i].getId()==this._sFocusedAppointmentId){j=G[i];break;}}if(!j){for(i=0;i<A.length;i++){if(A[i].getId()==this._sFocusedAppointmentId){j=A[i];break;}}}return j;};
c.prototype.focusAppointment=function(A){if(!A||!(A instanceof sap.ui.unified.CalendarAppointment)){throw new Error("Appointment must be a CalendarAppointment; "+this);}var i=A.getId();if(this._sFocusedAppointmentId!=i){v.call(this,i);}else{A.focus();}return this;};
c.prototype.focusNearestAppointment=function(j){b._checkJSDateObject(j);var A=t.call(this);var N;var P;var k;for(var i=0;i<A.length;i++){N=A[i];if(N.getStartDate()>j){if(i>0){P=A[i-1];}else{P=N;}break;}}if(N){if(P&&Math.abs(N.getStartDate()-j)>=Math.abs(P.getStartDate()-j)){k=P;}else{k=N;}this.focusAppointment(k);}return this;};
c.prototype._getVisibleAppointments=function(){return this._aVisibleAppointments;};
c.prototype._getVisibleIntervalHeaders=function(){return this._aVisibleIntervalHeaders;};
c.prototype._getNonWorkingDays=function(){var N=this.getNonWorkingDays();if(!N){var j=d.call(this);var W=j.getWeekendStart();var k=j.getWeekendEnd();N=[];for(var i=0;i<=6;i++){if((W<=k&&i>=W&&i<=k)||(W>k&&(i>=W||i<=k))){N.push(i);}}}else if(!q.isArray(N)){N=[];}return N;};
function _(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;}
function d(){if(!this._oLocaleData){var i=_.call(this);var j=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(j);}return this._oLocaleData;}
function e(){var S=this.getStartDate();var E;var i=this.getIntervals();var I=this.getIntervalType();this._oUTCStartDate=f.call(this,S);switch(I){case sap.ui.unified.CalendarIntervalType.Hour:E=new U(this._oUTCStartDate.getTime());E.setUTCHours(E.getUTCHours()+i);this._iMinDelta=this._iHoursMinDelta;break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:E=new U(this._oUTCStartDate.getTime());E.setUTCDate(E.getUTCDate()+i);this._iMinDelta=this._iDaysMinDelta;break;case sap.ui.unified.CalendarIntervalType.Month:E=new U(this._oUTCStartDate.getTime());E.setUTCMonth(E.getUTCMonth()+i);this._iMinDelta=this._iMonthsMinDelta;break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}E.setUTCMilliseconds(-1);this._iRowSize=E.getTime()-this._oUTCStartDate.getTime();this._iIntervalSize=Math.floor(this._iRowSize/i);this._oUTCEndDate=E;}
function f(i){var I=this.getIntervalType();var j=b._createUniversalUTCDate(i,undefined,true);switch(I){case sap.ui.unified.CalendarIntervalType.Hour:j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:j.setUTCHours(0);j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);break;case sap.ui.unified.CalendarIntervalType.Month:j.setUTCDate(1);j.setUTCHours(0);j.setUTCMinutes(0);j.setUTCSeconds(0);j.setUTCMilliseconds(0);break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}return j;}
function g(){return D.system.phone||(this.getGroupAppointmentsMode()===sap.ui.unified.GroupAppointmentsMode.Collapsed);}
function h(){var O=this._aVisibleAppointments||[];var A=t.call(this);var z;var G;var B;var I=this.getIntervals();var E=this.getIntervalType();var S=this._getStartDate();var F=S.getTime();var H=this._oUTCEndDate;var J=H.getTime();var V=[];var K=false;var i=0;var j=0;var M=g.call(this);this.destroyAggregation("groupAppointments",true);for(i=0;i<A.length;i++){z=A[i];var N=b._createUniversalUTCDate(z.getStartDate(),undefined,true);N.setUTCSeconds(0);N.setUTCMilliseconds(0);var P=z.getEndDate()?b._createUniversalUTCDate(z.getEndDate(),undefined,true):b._createUniversalUTCDate(new Date(864000000000000),undefined,true);P.setUTCSeconds(0);P.setUTCMilliseconds(0);var Q=false;if(N.getTime()<F&&P.getTime()>=F){N=new U(F);Q=true;}if(P.getTime()>J&&N.getTime()<=J){P=new U(J);Q=true;}var R=N.getUTCHours()*60+N.getUTCMinutes();N.setUTCMinutes(N.getUTCMinutes()-(R%this._iMinDelta));var T=(P.getTime()-N.getTime())/60000;if(Q&&T==0){continue;}var W=0;var X=0;var Y=-1;G=undefined;B=undefined;if(N&&N.getTime()<=J&&P&&P.getTime()>=F){if(M&&(E==sap.ui.unified.CalendarIntervalType.Month)&&((P.getTime()-N.getTime())<604800000)){G=m.call(this,N,z,E,I,S,H,F,V);var Z=b._createUniversalUTCDate(G.getEndDate(),undefined,true);if(P.getTime()>Z.getTime()){B=m.call(this,P,z,E,I,S,H,F,V);}}W=n.call(this,E,I,S,H,F,N);X=o.call(this,E,I,S,H,F,P);for(j=0;j<O.length;j++){var $=O[j];if(z==$.appointment){Y=$.level;}}if(G){G._iBegin=W;G._iEnd=X;G._iLevel=Y;if(B){B._iBegin=W;B._iEnd=X;B._iLevel=Y;}continue;}V.push({appointment:z,begin:W,end:X,calculatedEnd:X,level:Y});if(this._sFocusedAppointmentId&&this._sFocusedAppointmentId==z.getId()){K=true;}}}var a1=this.getAggregation("groupAppointments",[]);if(a1.length>0){for(i=0;i<V.length;i++){z=V[i];if(z.appointment._aAppointments&&z.appointment._aAppointments.length<=1){G=z.appointment;var b1=false;if(G._aAppointments.length==0){b1=true;}else{for(j=0;j<V.length;j++){if(V[j].appointment==G._aAppointments[0]){b1=true;break;}}}if(!b1){for(j=0;j<a1.length;j++){B=a1[j];if(G!=B){for(var k=0;k<B._aAppointments.length;k++){if(G._aAppointments[0]==B._aAppointments[k]){B._aAppointments.splice(k,1);if(B._aAppointments.length==1){this.removeAggregation("groupAppointments",B);B.destroy();a1=this.getAggregation("groupAppointments",[]);}else{B.setProperty("title",B._aAppointments.length,true);}break;}}}}z.begin=G._iBegin;z.end=G._iEnd;z.calculatedEnd=G._iEnd;z.level=G._iLevel;z.appointment=G._aAppointments[0];}else{V.splice(i,1);i--;}this.removeAggregation("groupAppointments",G);G.destroy();a1=this.getAggregation("groupAppointments",[]);}}}if(!K){if(V.length>0){this._sFocusedAppointmentId=V[0].appointment.getId();}else{this._sFocusedAppointmentId=undefined;}}this._aVisibleAppointments=V;return this._aVisibleAppointments;}
function m(i,A,I,k,S,E,z,V){var G=this.getAggregation("groupAppointments",[]);var B;var F=d.call(this);var H=F.getFirstDayOfWeek();var J=i.getUTCDay();var K=new U(i.getTime());K.setUTCHours(0);K.setUTCMinutes(0);K.setUTCSeconds(0);K.setUTCMilliseconds(0);if(H<=J){K.setDate(K.getDate()-(J-H));}else{K.setDate(K.getDate()-(7-J-H));}for(var j=0;j<G.length;j++){B=G[j];var M=b._createUniversalUTCDate(B.getStartDate(),undefined,true);if(M.getTime()==K.getTime()){break;}B=undefined;}if(!B){var N=new U(K.getTime());N.setDate(N.getDate()+7);N.setMilliseconds(-1);B=new sap.ui.unified.CalendarAppointment(this.getId()+"-Group"+G.length,{type:A.getType(),startDate:b._createLocalDate(new Date(K.getTime()),true),endDate:b._createLocalDate(new Date(N.getTime()),true)});B._aAppointments=[];this.addAggregation("groupAppointments",B,true);var O=n.call(this,I,k,S,E,z,K);var P=o.call(this,I,k,S,E,z,N);V.push({appointment:B,begin:O,end:P,calculatedEnd:P,level:-1});}B._aAppointments.push(A);if(B.getType()!=sap.ui.unified.CalendarDayType.None&&B.getType()!=A.getType()){B.setType(sap.ui.unified.CalendarDayType.None);}B.setProperty("title",B._aAppointments.length,true);return B;}
function n(i,I,S,E,j,A){var B=0;if(i!=sap.ui.unified.CalendarIntervalType.Month){B=100*(A.getTime()-j)/this._iRowSize;}else{var M=new U(A.getTime());M.setUTCDate(1);M.setUTCHours(0);M.setUTCMinutes(0);M.setUTCSeconds(0);M.setUTCMilliseconds(0);var k=new U(M.getTime());k.setUTCMonth(k.getUTCMonth()+1);k.setMilliseconds(-1);var z=k.getTime()-M.getTime();var F=(M.getUTCFullYear()-S.getUTCFullYear())*12+M.getUTCMonth()-S.getUTCMonth();B=(100*F/I)+(100*(A.getTime()-M.getTime())/z)/I;}if(B<0){B=0;}B=Math.round(B*100000)/100000;return B;}
function o(i,I,S,E,j,A){var k=0;if(i!=sap.ui.unified.CalendarIntervalType.Month){k=100-(100*(A.getTime()-j)/this._iRowSize);}else{var M=new U(A.getTime());M.setUTCDate(1);M.setUTCHours(0);M.setUTCMinutes(0);M.setUTCSeconds(0);M.setUTCMilliseconds(0);var z=new U(M.getTime());z.setUTCMonth(z.getUTCMonth()+1);z.setMilliseconds(-1);var B=z.getTime()-M.getTime();var F=(M.getUTCFullYear()-S.getUTCFullYear())*12+M.getUTCMonth()-S.getUTCMonth();k=100-((100*F/I)+(100*(A.getTime()-M.getTime())/B)/I);}if(k<0){k=0;}k=Math.round(k*100000)/100000;return k;}
function p(){var V=[];if(this.getShowIntervalHeaders()){var A=this.getIntervalHeaders();var k;var I=this.getIntervals();var z=this.getIntervalType();var S=this._getStartDate();var B=S.getTime();var E=this._oUTCEndDate;var F=E.getTime();var i=0;var j=0;for(i=0;i<A.length;i++){k=A[i];var G=b._createUniversalUTCDate(k.getStartDate(),undefined,true);G.setUTCSeconds(0);G.setUTCMilliseconds(0);var H=k.getEndDate()?b._createUniversalUTCDate(k.getEndDate(),undefined,true):b._createUniversalUTCDate(new Date(864000000000000),undefined,true);H.setUTCSeconds(0);H.setUTCMilliseconds(0);if(G&&G.getTime()<=F&&H&&H.getTime()>=B){var J=new U(S.getTime());var K=new U(S.getTime());K.setUTCMinutes(K.getUTCMinutes()-1);var M=-1;var N=-1;for(j=0;j<I;j++){switch(z){case sap.ui.unified.CalendarIntervalType.Hour:K.setUTCHours(K.getUTCHours()+1);if(j>0){J.setUTCHours(J.getUTCHours()+1);}break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:K.setUTCDate(K.getUTCDate()+1);if(j>0){J.setUTCDate(J.getUTCDate()+1);}break;case sap.ui.unified.CalendarIntervalType.Month:K.setUTCDate(1);K.setUTCMonth(K.getUTCMonth()+2);K.setUTCDate(0);if(j>0){J.setUTCMonth(J.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+z+"; "+this);}if(G&&G.getTime()<=J.getTime()&&H&&H.getTime()>=K.getTime()){if(M<0){M=j;}N=j;}}if(M>=0){V.push({interval:M,appointment:k,last:N});}}}}this._aVisibleIntervalHeaders=V;return this._aVisibleIntervalHeaders;}
function r(){var I=this.getIntervals();var k=this.getIntervalType();if(k===sap.ui.unified.CalendarIntervalType.OneMonth&&I===1){return;}var A=this.$("Apps");var R=A.innerWidth();if(R<=0){return;}var $=this.$("DummyApp");var H=$.outerHeight(true);if(H<=0){return;}var M=$.outerWidth();var z=M/R*100;var B=Math.ceil(1000*z)/1000;var E;var F;var S=0;var G=0;var i=0;var J=!D.system.phone&&this.getAppointmentsReducedHeight();if(this.getShowIntervalHeaders()&&(this.getShowEmptyIntervalHeaders()||this._getVisibleIntervalHeaders().length>0)){S=q(this.$("AppsInt0").children(".sapUiCalendarRowAppsIntHead")[0]).outerHeight(true);}for(i=0;i<this._aVisibleAppointments.length;i++){E=this._aVisibleAppointments[i];F=E.appointment.$();var P=Math.floor(1000*(100-E.calculatedEnd-E.begin))/1000;var K=false;if(P<B){E.end=100-E.begin-z;if(E.end<0){E.end=0;}E.level=-1;K=true;F.addClass("sapUiCalendarAppSmall");}else if(F.hasClass("sapUiCalendarAppSmall")){E.end=E.calculatedEnd;K=true;F.removeClass("sapUiCalendarAppSmall");}if(K){if(this._bRTL){F.css("left",E.end+"%");}else{F.css("right",E.end+"%");}}}for(i=0;i<this._aVisibleAppointments.length;i++){E=this._aVisibleAppointments[i];F=E.appointment.$();var N={};var T=J&&!this._getAppointmentReducedHeight(E.appointment);if(E.level<0){for(var j=0;j<this._aVisibleAppointments.length;j++){var V=this._aVisibleAppointments[j];if(E!=V&&E.begin<(Math.floor(1000*(100-V.end))/1000)&&(Math.floor(1000*(100-E.end))/1000)>V.begin&&V.level>=0){if(N[V.level]){N[V.level]++;}else{N[V.level]=1;}if(J&&!this._getAppointmentReducedHeight(V.appointment)){if(N[V.level+1]){N[V.level+1]++;}else{N[V.level+1]=1;}}}}E.level=0;while(N[E.level]||(T&&N[E.level+1])){E.level++;}F.attr("data-sap-level",E.level);}F.css("top",(H*E.level+S)+"px");var O=E.level;if(T){O++;}if(G<O){G=O;}}G++;H=H*G+S;if(!this.getHeight()){A.outerHeight(H);}else{var Q=this.$("Apps").children(".sapUiCalendarRowAppsInt");for(i=0;i<Q.length;i++){var W=q(Q[i]);W.outerHeight(H);}}$.css("display","none");}
function s(A,R){var i=0;var O;var j;var k;var z;var S=sap.ui.unified.CalendarRow._oStaticSelectedText.getId();if(R){var B=this.getAppointments();var G=this.getAggregation("groupAppointments",[]);q.merge(B,G);for(i=0;i<B.length;i++){O=B[i];if(O.getSelected()){O.setProperty("selected",false,true);O.$().removeClass("sapUiCalendarAppSel");j=O.$().attr("aria-labelledby");k=j?j.replace(S,""):"";O.$().attr("aria-labelledby",k);}}}A.setProperty("selected",true,true);A.$().addClass("sapUiCalendarAppSel");z=A.$().attr("aria-labelledby")+" "+S;A.$().attr("aria-labelledby",z);if(A._aAppointments){for(i=0;i<A._aAppointments.length;i++){O=A._aAppointments[i];O.setProperty("selected",true,true);z=O.$().attr("aria-labelledby")+" "+S;O.$().attr("aria-labelledby",z);}this.fireSelect({appointments:A._aAppointments,multiSelect:!R});}else{this.fireSelect({appointment:A,multiSelect:!R});}}
function t(){var A=this.getAppointments();A.sort(function(i,j){var R=i.getStartDate()-j.getStartDate();if(R==0){R=j.getEndDate()-i.getEndDate();}return R;});return A;}
function u(I){var G=this.getAggregation("groupAppointments",[]);var k;var F=false;for(var i=0;i<G.length;i++){var z=G[i]._aAppointments;for(var j=0;j<z.length;j++){if(z[j].getId()==I){k=G[i];F=true;break;}}if(F){break;}}return k;}
function v(I){if(this._sFocusedAppointmentId!=I){var A=t.call(this);var V=this._aVisibleAppointments;var j;var i=0;j=u.call(this,I);if(j){I=j.getId();j=undefined;}for(i=0;i<V.length;i++){if(V[i].appointment.getId()==I){j=V[i].appointment;break;}}if(j){var O=this.getFocusedAppointment().$();var $=j.$();this._sFocusedAppointmentId=j.getId();O.attr("tabindex","-1");$.attr("tabindex","0");$.focus();}else{for(i=0;i<A.length;i++){if(A[i].getId()==I){j=A[i];break;}}if(j){this._sFocusedAppointmentId=j.getId();var k=f.call(this,j.getStartDate());this.setStartDate(b._createLocalDate(k,true));if(!q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){q.sap.delayedCall(0,this,function(){this.getFocusedAppointment().focus();});}this.fireStartDateChange();}}}}
function w(F,S){var I=this._sFocusedAppointmentId;var A=t.call(this);var G=this.getAggregation("groupAppointments",[]);var j;var k=0;var i=0;for(i=0;i<G.length;i++){if(G[i].getId()==I){var z=G[i]._aAppointments;if(F){I=z[z.length-1].getId();}else{I=z[0].getId();}break;}}for(i=0;i<A.length;i++){if(A[i].getId()==I){k=i;break;}}if(F){k=k+S;}else{k=k-S;}if(k<0){k=0;}else if(k>=A.length){k=A.length-1;}j=A[k];v.call(this,j.getId());}
function x(E){var A=t.call(this);var j;var S=new U(this._getStartDate());var k=new U(this._oUTCEndDate);var I=this.getIntervalType();var z;var G;S.setUTCHours(0);k.setUTCHours(0);k.setUTCMinutes(0);k.setUTCSeconds(0);switch(I){case sap.ui.unified.CalendarIntervalType.Hour:k.setUTCDate(k.getUTCDate()+1);k.setUTCMilliseconds(-1);break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:S.setUTCDate(1);k.setUTCMonth(k.getUTCMonth()+1);k.setUTCDate(1);k.setUTCMilliseconds(-1);break;case sap.ui.unified.CalendarIntervalType.Month:S.setUTCMonth(0);S.setUTCDate(1);k.setUTCFullYear(k.getUTCFullYear()+1);k.setUTCMonth(1);k.setUTCDate(1);k.setUTCMilliseconds(-1);break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}var B=b._createLocalDate(S,true);var F=b._createLocalDate(k,true);for(var i=0;i<A.length;i++){if(A[i].getStartDate()>=B&&A[i].getStartDate()<=F){j=A[i];z=j.getId();if(E.type=="saphome"){break;}}else if(A[i].getStartDate()>F){break;}}G=u.call(this,z);if(G){j=G;z=j.getId();}if(z&&z!=this._sFocusedAppointmentId){v.call(this,z);}else if(E._bPlanningCalendar&&j){j.focus();}else{this.fireLeaveRow({type:E.type});}}
function y(i,j){var I=this.getIntervalType();var S=this._getStartDate();var k=new U(S.getTime());var z;var A=false;var B=0;var E=0;if(q(j).hasClass("sapUiCalendarRowAppsSubInt")){A=true;var F=q(q(j).parent()).children(".sapUiCalendarRowAppsSubInt");E=F.length;for(B=0;B<E;B++){var G=F[B];if(G==j){break;}}}switch(I){case sap.ui.unified.CalendarIntervalType.Hour:k.setUTCHours(k.getUTCHours()+i);if(A){k.setUTCMinutes(k.getUTCMinutes()+B*60/E);z=new U(k.getTime());z.setUTCMinutes(z.getUTCMinutes()+60/E);}else{z=new U(k.getTime());z.setUTCHours(z.getUTCHours()+1);}break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:k.setUTCDate(k.getUTCDate()+i);if(A){k.setUTCHours(k.getUTCHours()+B*24/E);z=new U(k.getTime());z.setUTCHours(z.getUTCHours()+24/E);}else{z=new U(k.getTime());z.setUTCDate(z.getUTCDate()+1);}break;case sap.ui.unified.CalendarIntervalType.Month:k.setUTCMonth(k.getUTCMonth()+i);if(A){k.setUTCDate(k.getUTCDate()+B);z=new U(k.getTime());z.setUTCDate(z.getUTCDate()+1);}else{z=new U(k.getTime());z.setUTCMonth(z.getUTCMonth()+1);}break;default:throw new Error("Unknown IntervalType: "+I+"; "+this);}z.setUTCMilliseconds(z.getUTCMilliseconds()-1);k=b._createLocalDate(k,true);z=b._createLocalDate(z,true);this.fireIntervalSelect({startDate:k,endDate:z,subInterval:A});}
return c;},true);
sap.ui.predefine('sap/ui/unified/CalendarRowRenderer',['jquery.sap.global','sap/ui/core/date/UniversalDate','sap/ui/unified/CalendarAppointment','sap/ui/unified/CalendarRow'],function(q,U,C,a){"use strict";var b={};
b.render=function(r,R){var t=R.getTooltip_AsString();var v=R.getAppointmentsVisualization();var l=R.getLegend();var T=[];if(l){var L=sap.ui.getCore().byId(l);if(L){T=L.getItems();}else{q.sap.log.warning("CalendarLegend "+l+" does not exist!",R);}}r.write("<div");r.writeControlData(R);r.addClass("sapUiCalendarRow");if(!sap.ui.Device.system.phone&&R.getAppointmentsReducedHeight()){r.addClass("sapUiCalendarRowAppsRedHeight");}if(v!=sap.ui.unified.CalendarAppointmentVisualization.Standard){r.addClass("sapUiCalendarRowVis"+v);}if(R._sFocusedAppointmentId){r.writeAttribute("tabindex","-1");}else{r.writeAttribute("tabindex","0");}if(t){r.writeAttributeEscaped("title",t);}var w=R.getWidth();if(w){r.addStyle("width",w);}var h=R.getHeight();if(h){r.addStyle("height",h);}r.writeAccessibilityState(R);r.writeClasses();r.writeStyles();r.write(">");this.renderAppointmentsRow(r,R,T);r.write("</div>");};
b.renderAppointmentsRow=function(r,R,t){var i=R.getId();r.write("<div id=\""+i+"-Apps\" class=\"sapUiCalendarRowApps\">");this.renderAppointments(r,R,t);r.write("</div>");};
b.renderAppointments=function(r,R,t){var A=R._getVisibleAppointments();var I=R._getVisibleIntervalHeaders();var s=R._getStartDate();var n=[];var N=[];var S=0;var c=0;var d=[];var e=0;var f=0;var g=R.getIntervals();var h=R.getIntervalType();var w=100/g;var i=0;var o=new U(s);var F=false;var l=false;switch(h){case sap.ui.unified.CalendarIntervalType.Hour:n=R.getNonWorkingHours()||[];S=s.getUTCHours();c=24;break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:n=R._getNonWorkingDays();N=R.getAggregation("_nonWorkingDates");S=s.getUTCDay();c=7;d=R.getNonWorkingHours()||[];e=s.getUTCHours();f=24;break;case sap.ui.unified.CalendarIntervalType.Month:d=R._getNonWorkingDays();e=s.getUTCDay();f=7;break;default:break;}if(h===sap.ui.unified.CalendarIntervalType.OneMonth&&g===1){this.renderSingleDayInterval(r,R,A,t,I,n,S,c,d,e,f,true,true);}else{for(i=0;i<g;i++){if(l){F=true;}else{F=false;}l=false;switch(h){case sap.ui.unified.CalendarIntervalType.Hour:o.setUTCHours(o.getUTCHours()+1);if(o.getUTCHours()==0){l=true;}break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:o.setUTCDate(o.getUTCDate()+1);if(o.getUTCDate()==1){l=true;}break;case sap.ui.unified.CalendarIntervalType.Month:o.setUTCMonth(o.getUTCMonth()+1);if(o.getUTCMonth()==0){l=true;}break;default:break;}this.renderInterval(r,R,i,w,I,n,N,S,c,d,e,f,F,l);}this.renderIntervalHeaders(r,R,w,I,g);r.write("<div id=\""+R.getId()+"-Now\" class=\"sapUiCalendarRowNow\"></div>");for(i=0;i<A.length;i++){var j=A[i];this.renderAppointment(r,R,j,t);}r.write("<div id=\""+R.getId()+"-DummyApp\" class=\"sapUiCalendarApp sapUiCalendarAppTitleOnly sapUiCalendarAppDummy\"></div>");}};
b.renderInterval=function(r,R,I,w,c,n,N,s,d,e,S,f,F,l){var g=R.getId()+"-AppsInt"+I;var i;var h=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||c.length>0);var m=R.getStartDate().getMonth();var D=new Date(R.getStartDate().getFullYear(),m+1,0).getDate();var o=R.getStartDate();var k;var p;var t;r.write("<div id=\""+g+"\"");r.addClass("sapUiCalendarRowAppsInt");r.addStyle("width",w+"%");if(I>=D&&R.getIntervalType()===sap.ui.unified.CalendarIntervalType.OneMonth){r.addClass("sapUiCalItemOtherMonth");}for(i=0;i<n.length;i++){if((I+s)%d==n[i]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}if(N&&N.length){k=new Date(o.getTime());k.setHours(0,0,0);k.setDate(o.getDate()+I);var u=function(E){return E===k.getDay();};for(i=0;i<N.length;i++){if(N[i].getStartDate()){p=new Date(N[i].getStartDate().getTime());}if(N[i].getEndDate()){t=new Date(N[i].getEndDate().getTime());}else{t=new Date(N[i].getStartDate().getTime());t.setHours(23,59,59);}if(k.getTime()>=p.getTime()&&k.getTime()<=t.getTime()){var A=n.some(u);if(!A){r.addClass("sapUiCalendarRowAppsNoWork");}}}}if(!h){r.addClass("sapUiCalendarRowAppsIntNoHead");}if(F){r.addClass("sapUiCalendarRowAppsIntFirst");}if(l){r.addClass("sapUiCalendarRowAppsIntLast");}r.writeClasses();r.writeStyles();r.write(">");if(h){r.write("<div");r.addClass("sapUiCalendarRowAppsIntHead");r.writeClasses();r.write(">");r.write("</div>");}if(R.getShowSubIntervals()){var v=R.getIntervalType();var x=0;switch(v){case sap.ui.unified.CalendarIntervalType.Hour:x=4;break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:x=24;break;case sap.ui.unified.CalendarIntervalType.Month:var y=R._getStartDate();var z=new U(y);z.setUTCMonth(z.getUTCMonth()+I+1,0);x=z.getUTCDate();z.setUTCDate(1);s=z.getUTCDay();break;default:break;}var B=100/x;for(i=0;i<x;i++){r.write("<div");r.addClass("sapUiCalendarRowAppsSubInt");r.addStyle("width",B+"%");for(var j=0;j<e.length;j++){if((i+S)%f==e[j]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}r.writeStyles();r.writeClasses();r.write(">");r.write("</div>");}}r.write("</div>");};
b.renderIntervalHeaders=function(r,R,w,I,c){var s=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||I.length>0);if(s){for(var i=0;i<I.length;i++){var o=I[i],l,d;if(R._bRTL){d=w*o.interval;l=w*(c-o.last-1);}else{l=w*o.interval;d=w*(c-o.last-1);}this.renderIntervalHeader(r,o,R._bRTL,l,d);}}};
b.renderIntervalHeader=function(r,i,R,l,c){var I=i.appointment.getId();r.write("<div");r.addClass("sapUiCalendarRowAppsIntHead");if(l!==undefined){r.addStyle("left",l+"%");}if(c!==undefined){r.addStyle("right",c+"%");}r.writeElementData(i.appointment);r.addClass("sapUiCalendarRowAppsIntHeadFirst");if(i.appointment.getSelected()){r.addClass("sapUiCalendarRowAppsIntHeadSel");}if(i.appointment.getTentative()){r.addClass("sapUiCalendarRowAppsIntHeadTent");}var t=i.appointment.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}var T=i.appointment.getType();var s=i.appointment.getColor();if(!s&&T&&T!=sap.ui.unified.CalendarDayType.None){r.addClass("sapUiCalendarRowAppsIntHead"+T);}if(s){if(R){r.addStyle("border-right-color",s);}else{r.addStyle("border-left-color",s);}}r.writeStyles();r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiCalendarIntervalHeaderCont");r.writeClasses();if(s){r.addStyle("background-color",i.appointment._getCSSColorForBackground(s));r.writeStyles();}r.write(">");var d=i.appointment.getIcon();if(d){var e=["sapUiCalendarRowAppsIntHeadIcon"];var A={};A["id"]=I+"-Icon";A["title"]=null;r.writeIcon(d,e,A);}var f=i.appointment.getTitle();if(f){r.write("<span");r.writeAttribute("id",I+"-Title");r.addClass("sapUiCalendarRowAppsIntHeadTitle");r.writeClasses();r.write(">");r.writeEscaped(f,true);r.write("</span>");}var g=i.appointment.getText();if(g){r.write("<span");r.writeAttribute("id",I+"-Text");r.addClass("sapUiCalendarRowAppsIntHeadText");r.writeClasses();r.write(">");r.writeEscaped(g,true);r.write("</span>");}r.write("</div>");r.write("</div>");};
b.renderAppointment=function(r,R,A,t,c){var o=A.appointment;var T=o.getTooltip_AsString();var s=o.getType();var d=o.getColor();var e=o.getTitle();var f=o.getText();var I=o.getIcon();var g=o.getId();var m={labelledby:{value:a._oStaticAppointmentText.getId()+" "+g+"-Descr",append:true}};var h=R.getAriaLabelledBy();if(h.length>0){m["labelledby"].value=m["labelledby"].value+" "+h.join(" ");}if(e){m["labelledby"].value=m["labelledby"].value+" "+g+"-Title";}if(f){m["labelledby"].value=m["labelledby"].value+" "+g+"-Text";}r.write("<div");r.writeElementData(o);r.addClass("sapUiCalendarApp");if(o.getSelected()){r.addClass("sapUiCalendarAppSel");m["labelledby"].value=m["labelledby"].value+" "+a._oStaticSelectedText.getId();}if(o.getTentative()){r.addClass("sapUiCalendarAppTent");m["labelledby"].value=m["labelledby"].value+" "+a._oStaticTentativeText.getId();}if(!f){r.addClass("sapUiCalendarAppTitleOnly");}if(I){r.addClass("sapUiCalendarAppWithIcon");}if(!c){if(R._bRTL){r.addStyle("right",A.begin+"%");r.addStyle("left",A.end+"%");}else{r.addStyle("left",A.begin+"%");r.addStyle("right",A.end+"%");}}r.writeAttribute("data-sap-level",A.level);if(R._sFocusedAppointmentId==g){r.writeAttribute("tabindex","0");}else{r.writeAttribute("tabindex","-1");}if(T){r.writeAttributeEscaped("title",T);}if(!d&&s&&s!=sap.ui.unified.CalendarDayType.None){r.addClass("sapUiCalendarApp"+s);}if(d){if(R._bRTL){r.addStyle("border-right-color",d);}else{r.addStyle("border-left-color",d);}}r.writeAccessibilityState(o,m);r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapUiCalendarAppCont");if(d&&R.getAppointmentsVisualization()===sap.ui.unified.CalendarAppointmentVisualization.Filled){r.addStyle("background-color",o._getCSSColorForBackground(d));r.writeStyles();}r.writeClasses();r.write(">");if(I){var j=["sapUiCalendarAppIcon"];var k={};k["id"]=g+"-Icon";k["title"]=null;r.writeIcon(I,j,k);}if(e){r.write("<span");r.writeAttribute("id",g+"-Title");r.addClass("sapUiCalendarAppTitle");r.writeClasses();r.write(">");r.writeEscaped(e,true);r.write("</span>");}if(f){r.write("<span");r.writeAttribute("id",g+"-Text");r.addClass("sapUiCalendarAppText");r.writeClasses();r.write(">");r.writeEscaped(f,true);r.write("</span>");}var l=R._oRb.getText("CALENDAR_START_TIME")+": "+R._oFormatAria.format(o.getStartDate());l=l+"; "+R._oRb.getText("CALENDAR_END_TIME")+": "+R._oFormatAria.format(o.getEndDate());if(T){l=l+"; "+T;}if(s&&s!=sap.ui.unified.CalendarDayType.None){for(var i=0;i<t.length;i++){var n=t[i];if(n.getType()==s){l=l+"; "+n.getText();break;}}}r.write("<span id=\""+g+"-Descr\" class=\"sapUiInvisibleText\">"+l+"</span>");r.write("</div>");r.write("</div>");};
b.renderSingleDayInterval=function(r,R,A,t,I,n,s,N,c,S,d,f,l){var e=1,w=100,g=R.getId()+"-AppsInt"+e,i,h=R.getShowIntervalHeaders()&&(R.getShowEmptyIntervalHeaders()||I.length>0),o=R.getStartDate(),m=o.getMonth(),D=new Date(o.getFullYear(),m+1,0).getDate(),k,p=A.concat(R.getIntervalHeaders().filter(function(B){var E=B.getStartDate().getTime(),F=B.getStartDate().getTime(),G=o.getTime(),H=G+1000*60*60*24;return(E>=G&&E<H)||(F>=G&&F<H);}).map(function(B){return{appointment:B,isHeader:true};})).sort(C._getComparer(o)),u;r.write("<div id=\""+g+"\"");r.addClass("sapUiCalendarRowAppsInt");r.addClass("sapUiCalendarMonthRowAppsS");r.addStyle("width",w+"%");if(e>=D&&R.getIntervalType()===sap.ui.unified.CalendarIntervalType.OneMonth){r.addClass("sapUiCalItemOtherMonth");}for(i=0;i<n.length;i++){if((e+s)%N==n[i]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}if(!h){r.addClass("sapUiCalendarRowAppsIntNoHead");}if(f){r.addClass("sapUiCalendarRowAppsIntFirst");}if(l){r.addClass("sapUiCalendarRowAppsIntLast");}r.writeClasses();r.writeStyles();r.write(">");if(h){r.write("<div");r.addClass("sapUiCalendarRowAppsIntHead");r.writeClasses();r.write(">");r.write("</div>");}for(i=0;i<p.length;i++){u=p[i];r.write("<div class=\"sapUiCalendarAppContainer\">");r.write("<div class=\"sapUiCalendarAppContainerLeft\">");r.write("<div>"+u.appointment._getDateRangeIntersectionText(o)+"</div>");r.write("</div>");r.write("<div class=\"sapUiCalendarAppContainerRight\">");if(u.isHeader){this.renderIntervalHeader(r,u);}else{this.renderAppointment(r,R,u,t,true);}r.write("</div>");r.write("</div>");}if(A.length===0){r.write("<div class=\"sapUiCalendarNoApps\">");k=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("PLANNINGCALENDAR_ROW_NO_APPOINTMENTS");r.write(k);r.write("</div>");}r.write("<div id=\""+R.getId()+"-Now\" class=\"sapUiCalendarRowNow\"></div>");r.write("<div id=\""+R.getId()+"-DummyApp\" class=\"sapUiCalendarApp sapUiCalendarAppTitleOnly sapUiCalendarAppDummy\" style='margin:0; height:0px;'></div>");if(R.getShowSubIntervals()){var v=R.getIntervalType();var x=0;switch(v){case sap.ui.unified.CalendarIntervalType.Hour:x=4;break;case sap.ui.unified.CalendarIntervalType.Day:case sap.ui.unified.CalendarIntervalType.Week:case sap.ui.unified.CalendarIntervalType.OneMonth:x=24;break;case sap.ui.unified.CalendarIntervalType.Month:var y=new U(o);y.setUTCMonth(y.getUTCMonth()+e+1,0);x=y.getUTCDate();y.setUTCDate(1);s=y.getUTCDay();break;default:break;}var z=100/x;for(i=0;i<x;i++){r.write("<div");r.addClass("sapUiCalendarRowAppsSubInt");r.addStyle("width",z+"%");for(var j=0;j<c.length;j++){if((i+S)%d==c[j]){r.addClass("sapUiCalendarRowAppsNoWork");break;}}r.writeStyles();r.writeClasses();r.write(">");r.write("</div>");}}r.write("</div>");};
return b;},true);
sap.ui.predefine('sap/ui/unified/CalendarTimeInterval',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/TimesRow','./calendar/DatesRow','./calendar/MonthPicker','./calendar/YearPicker','sap/ui/core/date/UniversalDate','./library'],function(q,C,L,D,a,H,T,b,M,Y,U,l){"use strict";
var c=C.extend("sap.ui.unified.CalendarTimeInterval",{metadata:{library:"sap.ui.unified",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},startDate:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},pickerPopup:{type:"boolean",group:"Appearance",defaultValue:false},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},timesRow:{type:"sap.ui.unified.calendar.TimesRow",multiple:false,visibility:"hidden"},datesRow:{type:"sap.ui.unified.calendar.Month",multiple:false,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});
c.prototype.init=function(){this._iMode=0;this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y"});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=new U(new Date(Date.UTC(1,0,1)));this._oMinDate.getJSDate().setUTCFullYear(1);this._oMaxDate=new U(new Date(Date.UTC(9999,11,31,23,59,59)));var Q=new H(this.getId()+"--Head",{visibleButton0:true,visibleButton1:true,visibleButton2:true});Q.attachEvent("pressPrevious",this._handlePrevious,this);Q.attachEvent("pressNext",this._handleNext,this);Q.attachEvent("pressButton0",u,this);Q.attachEvent("pressButton1",v,this);Q.attachEvent("pressButton2",w,this);this.setAggregation("header",Q);var R=new T(this.getId()+"--TimesRow");R.attachEvent("focus",y,this);R.attachEvent("select",x,this);R._bNoThemeChange=true;this.setAggregation("timesRow",R);var S=new M(this.getId()+"--MP",{columns:0,months:6});S.attachEvent("select",B,this);S._bNoThemeChange=true;S.attachEvent("pageChange",O,this);this.setAggregation("monthPicker",S);var V=new Y(this.getId()+"--YP",{columns:0,years:6});V.attachEvent("select",E,this);V.attachEvent("pageChange",P,this);this.setAggregation("yearPicker",V);this.setPickerPopup(false);this._iItemsHead=15;};
c.prototype.exit=function(){if(this._sInvalidateContent){q.sap.clearDelayedCall(this._sInvalidateContent);}};
c.prototype.onBeforeRendering=function(){var Q=this.getAggregation("timesRow");var R=this._getFocusedDate();n.call(this);Q.displayDate(a._createLocalDate(R,true));};
c.prototype.setStartDate=function(S){a._checkJSDateObject(S);if(q.sap.equal(this.getStartDate(),S)){return this;}var Q=S.getFullYear();a._checkYearInValidRange(Q);var R=this.getMinDate();if(R&&S.getTime()<R.getTime()){q.sap.log.warning("startDate < minDate -> minDate as startDate set",this);S=new Date(R);}var V=this.getMaxDate();if(V&&S.getTime()>V.getTime()){q.sap.log.warning("startDate > maxDate -> maxDate as startDate set",this);S=new Date(V);}this.setProperty("startDate",S,true);var W=this.getAggregation("timesRow");W.setStartDate(S);this._oUTCStartDate=new U(W._getStartDate().getTime());n.call(this);var X=a._createLocalDate(this._getFocusedDate(),true);if(!W.checkDateFocusable(X)){this._setFocusedDate(this._oUTCStartDate);W.displayDate(S);}return this;};
c.prototype.invalidate=function(Q){if(!this._bDateRangeChanged&&(!Q||!(Q instanceof sap.ui.unified.DateRange))){if(!Q||(!(Q instanceof sap.ui.unified.calendar.DatesRow||Q instanceof sap.ui.unified.calendar.MonthPicker||Q instanceof sap.ui.unified.calendar.YearPicker||Q instanceof sap.ui.unified.calendar.Header))){C.prototype.invalidate.apply(this,arguments);}}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateContent){this._sInvalidateContent=q.sap.delayedCall(0,this,F);}};
c.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
c.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var Q=this.destroyAggregation("selectedDates");return Q;};
c.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
c.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var Q=this.destroyAggregation("specialDates");return Q;};
c.prototype.setIntervalMinutes=function(Q){if(Q>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%Q>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",Q,false);var R=this.getAggregation("timesRow");var S=a._createLocalDate(this._getFocusedDate(),true);if(!R.checkDateFocusable(S)){var V=d.call(this);this._setFocusedDate(V);R.setDate(a._createLocalDate(V,true));}return this;};
c.prototype.setLocale=function(Q){if(this._sLocale!=Q){this._sLocale=Q;this._oLocaleData=undefined;this.invalidate();}return this;};
c.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
c.prototype._getFocusedDate=function(){if(!this._oFocusedDate){f.call(this);}return this._oFocusedDate;};
c.prototype._setFocusedDate=function(Q){if(!(Q instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}this._oFocusedDate=new U(Q.getTime());};
c.prototype.focusDate=function(Q){var R=false;var S=this.getAggregation("timesRow");if(!S.checkDateFocusable(Q)){var V=a._createUniversalUTCDate(Q,undefined,true);G.call(this,V);R=true;}t.call(this,Q,false);if(R){this.fireStartDateChange();}return this;};
c.prototype.displayDate=function(Q){t.call(this,Q,true);return this;};
c.prototype.setItems=function(Q){this.setProperty("items",Q,true);Q=this._getItems();var R=this.getAggregation("timesRow");R.setItems(Q);var S=a._createLocalDate(this._getFocusedDate(),true);if(!R.checkDateFocusable(S)){var V=d.call(this);this._setFocusedDate(V);R.setDate(a._createLocalDate(V,true));}if(!this.getPickerPopup()){var W=this.getAggregation("datesRow");var X=Math.floor(Q*1.5);if(X>31){X=31;}W.setDays(X);var Z=this.getAggregation("monthPicker");var $=Math.floor(Q/2);if($>12){$=12;}Z.setMonths($);var a1=this.getAggregation("yearPicker");var b1=Math.floor(Q/2);if(b1>20){b1=20;}a1.setYears(b1);}n.call(this);if(this.getDomRef()){if(this._getShowItemHeader()){this.$().addClass("sapUiCalIntHead");}else{this.$().removeClass("sapUiCalIntHead");}}return this;};
c.prototype._getItems=function(){var Q=this.getItems();if(sap.ui.Device.system.phone&&Q>6){return 6;}else{return Q;}};
c.prototype._getLocaleData=function(){if(!this._oLocaleData){var Q=this.getLocale();var R=new sap.ui.core.Locale(Q);this._oLocaleData=L.getInstance(R);}return this._oLocaleData;};
c.prototype.setPickerPopup=function(Q){this.setProperty("pickerPopup",Q,true);var R=this.getAggregation("datesRow");var S=this.getAggregation("monthPicker");var V=this.getAggregation("yearPicker");if(R){R.destroy();}if(Q){R=new sap.ui.unified.calendar.Month(this.getId()+"--DatesRow",{selectedDates:[new sap.ui.unified.DateRange(this.getId()+"--Range")]});this.setAggregation("datesRow",R);S.setColumns(3);S.setMonths(12);V.setColumns(4);V.setYears(20);}else{R=new b(this.getId()+"--DatesRow",{days:18,selectedDates:[new sap.ui.unified.DateRange(this.getId()+"--Range")]});this.setAggregation("datesRow",R);S.setColumns(0);S.setMonths(6);V.setColumns(0);V.setYears(6);}R.attachEvent("focus",A,this);R.attachEvent("select",z,this);R._bNoThemeChange=true;R.getIntervalSelection=function(){return this.getProperty("intervalSelection");};R.getSingleSelection=function(){return this.getProperty("singleSelection");};R.getSelectedDates=function(){return this.getAggregation("selectedDates",[]);};R.getSpecialDates=function(){return this.getAggregation("specialDates",[]);};R.getAriaLabelledBy=function(){return this.getAssociation("ariaLabelledBy",[]);};return this;};
c.prototype.setMinDate=function(Q){if(q.sap.equal(Q,this.getMinDate())){return this;}if(!Q){a._updateUTCDate(this._oMinDate.getJSDate(),1,0,1,0,0,0,0);}else{a._checkJSDateObject(Q);this._oMinDate=a._createUniversalUTCDate(Q,undefined,true);var R=this.getAggregation("timesRow");this._oMinDate=R._getIntervalStart(this._oMinDate);var S=this._oMinDate.getUTCFullYear();a._checkYearInValidRange(S);if(this._oMaxDate.getTime()<this._oMinDate.getTime()){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=a._createUniversalUTCDate(Q,undefined,true);a._updateUTCDate(this._oMaxDate,null,this._oMaxDate.getUTCMonth()+1,0,23,59,59,0);this.setProperty("maxDate",a._createLocalDate(this._oMaxDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){q.sap.log.warning("focused date < minDate -> minDate focused",this);this.focusDate(Q);}}if(this._oUTCStartDate&&this._oUTCStartDate.getTime()<this._oMinDate.getTime()){q.sap.log.warning("start date < minDate -> minDate set as start date",this);_.call(this,new U(this._oMinDate.getTime()),true,true);}}this.setProperty("minDate",Q,false);var V=this.getAggregation("yearPicker");V._oMinDate.setYear(this._oMinDate.getUTCFullYear());return this;};
c.prototype.setMaxDate=function(Q){if(q.sap.equal(Q,this.getMaxDate())){return this;}if(!Q){a._updateUTCDate(this._oMaxDate.getJSDate(),9999,11,31,23,59,59,0);}else{a._checkJSDateObject(Q);this._oMaxDate=a._createUniversalUTCDate(Q,undefined,true);var R=this.getAggregation("timesRow");this._oMaxDate=R._getIntervalStart(this._oMaxDate);this._oMaxDate.setUTCMinutes(this._oMaxDate.getUTCMinutes()+this.getIntervalMinutes());this._oMaxDate.setUTCMilliseconds(-1);var S=this._oMaxDate.getUTCFullYear();a._checkYearInValidRange(S);if(this._oMinDate.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=a._createUniversalUTCDate(Q,undefined,true);a._updateUTCDate(this._oMinDate,null,null,1,0,0,0,0);this.setProperty("minDate",a._createLocalDate(this._oMinDate,true),true);}if(this._oFocusedDate){if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){q.sap.log.warning("focused date > maxDate -> maxDate focused",this);this.focusDate(Q);}}if(this._oUTCStartDate){var V=new U(this._oUTCStartDate.getTime());V.setUTCMinutes(V.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));if(V.getTime()>this._oMaxDate.getTime()){var W=new U(this._oMaxDate.getTime());W.setUTCMinutes(W.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(W.getTime()>=this._oMinDate.getTime()){q.sap.log.warning("end date > maxDate -> maxDate set as end date",this);_.call(this,W,true,true);}}}}this.setProperty("maxDate",Q,false);var X=this.getAggregation("yearPicker");X._oMaxDate.setYear(this._oMaxDate.getUTCFullYear());return this;};
c.prototype.onclick=function(Q){if(Q.isMarked("delayedMouseEvent")){return;}if(Q.target.id==this.getId()+"-cancel"){this.onsapescape(Q);}};
c.prototype.onmousedown=function(Q){Q.preventDefault();Q.setMark("cancelAutoClose");};
c.prototype.onsapescape=function(Q){switch(this._iMode){case 0:this.fireCancel();break;case 1:h.call(this);break;case 2:j.call(this);break;case 3:m.call(this);break;}};
c.prototype.onsaptabnext=function(Q){var R=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),Q.target)){q.sap.focus(R.getDomRef("B0"));if(!this._bPoupupMode){var S=this.getAggregation("timesRow");var V=this.getAggregation("monthPicker");var W=this.getAggregation("yearPicker");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(V.getDomRef()){q(V._oItemNavigation.getItemDomRefs()[V._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(W.getDomRef()){q(W._oItemNavigation.getItemDomRefs()[W._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}Q.preventDefault();}else if(Q.target.id==R.getId()+"-B0"){q.sap.focus(R.getDomRef("B1"));Q.preventDefault();}else if(Q.target.id==R.getId()+"-B1"){q.sap.focus(R.getDomRef("B2"));Q.preventDefault();}};
c.prototype.onsaptabprevious=function(Q){var R=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),Q.target)){if(this._bPoupupMode){q.sap.focus(R.getDomRef("B2"));Q.preventDefault();}}else if(Q.target.id==R.getId()+"-B0"){var S=this.getAggregation("timesRow");var V=this.getAggregation("monthPicker");var W=this.getAggregation("yearPicker");switch(this._iMode){case 0:S._oItemNavigation.focusItem(S._oItemNavigation.getFocusedIndex());break;case 2:V._oItemNavigation.focusItem(V._oItemNavigation.getFocusedIndex());break;case 3:W._oItemNavigation.focusItem(W._oItemNavigation.getFocusedIndex());break;}Q.preventDefault();}else if(Q.target.id==R.getId()+"-B2"){q.sap.focus(R.getDomRef("B1"));Q.preventDefault();}else if(Q.target.id==R.getId()+"-B1"){q.sap.focus(R.getDomRef("B0"));Q.preventDefault();}};
c.prototype.onfocusin=function(Q){if(Q.target.id==this.getId()+"-end"){var R=this.getAggregation("header");var S=this.getAggregation("timesRow");var V=this.getAggregation("monthPicker");var W=this.getAggregation("yearPicker");q.sap.focus(R.getDomRef("B2"));if(!this._bPoupupMode){q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");if(V.getDomRef()){q(V._oItemNavigation.getItemDomRefs()[V._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(W.getDomRef()){q(W._oItemNavigation.getItemDomRefs()[W._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this.$("end").attr("tabindex","-1");};
c.prototype.onsapfocusleave=function(Q){if(!Q.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(Q.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){var R=this.getAggregation("timesRow");var S=this.getAggregation("monthPicker");var V=this.getAggregation("yearPicker");switch(this._iMode){case 0:q(R._oItemNavigation.getItemDomRefs()[R._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 2:q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;case 3:q(V._oItemNavigation.getItemDomRefs()[V._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");break;}}}};
c.prototype._handlePrevious=function(Q){var R=this._getFocusedDate();switch(this._iMode){case 0:var S=this._getItems();var V=new U(d.call(this).getTime());var W=this.getIntervalMinutes();V.setUTCMinutes(V.getUTCMinutes()-S*W);R.setUTCMinutes(R.getUTCMinutes()-S*W);this._setFocusedDate(R);_.call(this,V,true);break;case 1:var X=this.getAggregation("datesRow");var Z=a._createUniversalUTCDate(X.getDate());var $=X.getDays();if(Z.getUTCDate()<=$){Z.setUTCDate(1);}else{Z.setUTCDate(Z.getUTCDate()-$);}I.call(this,Z);break;case 2:var a1=this.getAggregation("monthPicker");if(a1.getMonths()<12){a1.previousPage();o.call(this);}else{R.setUTCFullYear(R.getUTCFullYear()-1);G.call(this,R);this._setFocusedDate(R);n.call(this);N.call(this,R.getUTCFullYear(),a1);this.fireStartDateChange();}break;case 3:var b1=this.getAggregation("yearPicker");b1.previousPage();p.call(this);break;}};
c.prototype._handleNext=function(Q){var R=this._getFocusedDate();switch(this._iMode){case 0:var S=this._getItems();var V=new U(d.call(this).getTime());var W=this.getIntervalMinutes();V.setUTCMinutes(V.getUTCMinutes()+S*W);R.setUTCMinutes(R.getUTCMinutes()+S*W);this._setFocusedDate(R);_.call(this,V,true);break;case 1:var X=this.getAggregation("datesRow");var Z=a._createUniversalUTCDate(X.getDate());var $=new U(Z.getTime());$.setUTCDate(1);$.setUTCMonth($.getUTCMonth()+1);$.setUTCDate(0);var a1=X.getDays();if(Z.getUTCDate()+a1>$.getUTCDate()){Z.setUTCDate($.getUTCDate());}else{Z.setUTCDate(Z.getUTCDate()+a1);}I.call(this,Z);break;case 2:var b1=this.getAggregation("monthPicker");if(b1.getMonths()<12){b1.nextPage();o.call(this);}else{R.setUTCFullYear(R.getUTCFullYear()+1);G.call(this,R);this._setFocusedDate(R);n.call(this);N.call(this,R.getUTCFullYear(),b1);this.fireStartDateChange();}break;case 3:var c1=this.getAggregation("yearPicker");c1.nextPage();p.call(this);break;}};
c.prototype._getShowItemHeader=function(){var Q=this.getItems();if(Q>this._iItemsHead){return true;}else{return false;}};
function _(S,Q,R){var V=new U(this._oMaxDate.getTime());V.setUTCMinutes(V.getUTCMinutes()-this.getIntervalMinutes()*(this._getItems()-1));if(V.getTime()<this._oMinDate.getTime()){V=new U(this._oMinDate.getTime());V.setUTCMinutes(V.getUTCMinutes()+this.getIntervalMinutes()*(this._getItems()-1));}if(S.getTime()<this._oMinDate.getTime()){S=new U(this._oMinDate.getTime());}else if(S.getTime()>V.getTime()){S=V;}var W=this.getAggregation("timesRow");var X=a._createLocalDate(S,true);W.setStartDate(X);this._oUTCStartDate=new U(W._getStartDate().getTime());X=a._createLocalDate(this._oUTCStartDate,true);this.setProperty("startDate",X,true);n.call(this);if(Q){var Z=a._createLocalDate(this._getFocusedDate(),true);if(!W.checkDateFocusable(Z)){this._setFocusedDate(S);W.setDate(X);}else{W.setDate(Z);}}if(!R){this.fireStartDateChange();}}
function d(){if(!this._oUTCStartDate){var Q=this.getAggregation("timesRow");Q.setStartDate(a._createLocalDate(this._getFocusedDate(),true));this._oUTCStartDate=new U(Q._getStartDate().getTime());this._setFocusedDate(this._oUTCStartDate);}return this._oUTCStartDate;}
function e(Q){var R=this._getFocusedDate();var S=this.getAggregation("timesRow");if(!Q){S.setDate(a._createLocalDate(R,true));}else{S.displayDate(a._createLocalDate(R,true));}n.call(this);}
function f(){var S=this.getSelectedDates();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=a._createUniversalUTCDate(S[0].getStartDate(),undefined,true);}else{var Q=new Date();this._oFocusedDate=a._createUniversalUTCDate(Q,undefined,true);}if(this._oFocusedDate.getTime()<this._oMinDate.getTime()){this._oFocusedDate=new U(this._oMinDate.getTime());}else if(this._oFocusedDate.getTime()>this._oMaxDate.getTime()){this._oFocusedDate=new U(this._oMaxDate.getTime());}}
function g(){if(this._iMode==3){m.call(this,true);}else if(this._iMode==2){j.call(this,true);}var Q=this._getFocusedDate();var R=this._getItems();var S=this.getAggregation("datesRow");var V=S.getSelectedDates()[0];V.setStartDate(a._createLocalDate(Q,true));if(!this.getPickerPopup()){var W=new U(Q.getTime());W.setUTCDate(1);W.setUTCMonth(W.getUTCMonth()+1);W.setUTCDate(0);var X=W.getUTCDate();var Z=Math.floor(R*1.5);if(Z>X){Z=X;}S.setDays(Z);if(S.getDomRef()){S.$().css("display","");}else{var $=sap.ui.getCore().createRenderManager();var a1=this.$("content");$.renderControl(S);$.flush(a1[0],false,true);$.destroy();}}else{J.call(this,S);}this.$("contentOver").css("display","");I.call(this,Q);if(this._iMode==0){var b1=this.getAggregation("timesRow");q(b1._oItemNavigation.getItemDomRefs()[b1._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=1;}
function h(Q){this._iMode=0;if(!this.getPickerPopup()){var R=this.getAggregation("datesRow");R.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!Q){e.call(this);var S=this.getAggregation("timesRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function i(){if(this._iMode==1){h.call(this,true);}else if(this._iMode==3){m.call(this,true);}var Q=this._getFocusedDate();var R=this.getAggregation("monthPicker");if(!this.getPickerPopup()){if(R.getDomRef()){R.$().css("display","");}else{var S=sap.ui.getCore().createRenderManager();var $=this.$("content");S.renderControl(R);S.flush($[0],false,true);S.destroy();}}else{J.call(this,R);}this.$("contentOver").css("display","");R.setMonth(Q.getUTCMonth());N.call(this,Q.getUTCFullYear(),R);if(this._iMode==0){var V=this.getAggregation("timesRow");q(V._oItemNavigation.getItemDomRefs()[V._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}this._iMode=2;o.call(this);}
function j(Q){this._iMode=0;if(!this.getPickerPopup()){var R=this.getAggregation("monthPicker");R.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!Q){e.call(this);var S=this.getAggregation("timesRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function k(){if(this._iMode==1){h.call(this,true);}else if(this._iMode==2){j.call(this,true);}var Q=this._getFocusedDate();var R=this.getAggregation("yearPicker");if(!this.getPickerPopup()){if(R.getDomRef()){R.$().css("display","");}else{var S=sap.ui.getCore().createRenderManager();var $=this.$("content");S.renderControl(R);S.flush($[0],false,true);S.destroy();}}else{J.call(this,R);}this.$("contentOver").css("display","");R.setDate(Q.getJSDate());if(this._iMode==0){var V=this.getAggregation("timesRow");q(V._oItemNavigation.getItemDomRefs()[V._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}p.call(this);this._iMode=3;}
function m(Q){this._iMode=0;if(!this.getPickerPopup()){var R=this.getAggregation("yearPicker");R.$().css("display","none");}else if(this._oPopup.isOpen()){this._oPopup.close();}this.$("contentOver").css("display","none");if(!Q){e.call(this);var S=this.getAggregation("timesRow");q(S._oItemNavigation.getItemDomRefs()[S._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}
function n(){r.call(this);o.call(this,true);}
function o(Q){var R=new U(d.call(this).getTime());var S=this._getItems();var V=R.getJSDate().getUTCFullYear();var W=this._oMaxDate.getJSDate().getUTCFullYear();var X=this._oMinDate.getJSDate().getUTCFullYear();var Z=R.getJSDate().getUTCMonth();var $=this._oMaxDate.getJSDate().getUTCMonth();var a1=this._oMinDate.getJSDate().getUTCMonth();var b1=R.getJSDate().getUTCDate();var c1=this._oMaxDate.getJSDate().getUTCDate();var d1=this._oMinDate.getJSDate().getUTCDate();var e1=R.getJSDate().getUTCHours();var f1=this._oMaxDate.getJSDate().getUTCHours();var g1=this._oMinDate.getJSDate().getUTCHours();var h1=R.getJSDate().getUTCMinutes();var i1=this._oMaxDate.getJSDate().getUTCMinutes();var j1=this._oMinDate.getJSDate().getUTCMinutes();var k1=this.getAggregation("header");if(this._iMode==2&&!Q){var l1=this.getAggregation("monthPicker");var m1=l1.getMonths();var n1=l1.getStartMonth();var o1=n1+m1-1;if(n1==0||(V==X&&n1<=a1)){k1.setEnabledPrevious(false);}else{k1.setEnabledPrevious(true);}if(o1>10||(V==W&&o1>=$)){k1.setEnabledNext(false);}else{k1.setEnabledNext(true);}return;}if((V<X||(V==X&&(!Q||(Z<a1||(Z==a1&&(b1<d1||(b1==d1&&(e1<g1||(e1==g1&&h1<=j1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){k1.setEnabledPrevious(false);}else{k1.setEnabledPrevious(true);}R.setUTCMinutes(R.getUTCMinutes()+(S)*this.getIntervalMinutes()-1);V=R.getJSDate().getUTCFullYear();Z=R.getJSDate().getUTCMonth();b1=R.getJSDate().getUTCDate();e1=R.getJSDate().getUTCHours();h1=R.getJSDate().getUTCMinutes();if((V>W||(V==W&&(!Q||(Z>$||(Z==$&&(b1>c1||(b1==c1&&(e1>f1||(e1==f1&&h1>=i1)))))))))||((this._iMode==1||this._iMode==2)&&this.getPickerPopup())){k1.setEnabledNext(false);}else{k1.setEnabledNext(true);}}
function p(){var Q=this.getAggregation("yearPicker");var R=Q.getYears();var S=a._createUniversalUTCDate(Q.getFirstRenderedDate());S.setUTCFullYear(S.getUTCFullYear()+Math.floor(R/2));var V=this.getAggregation("header");var W=new U(this._oMaxDate);W.setUTCFullYear(W.getUTCFullYear()-Math.ceil(R/2));W.setUTCMonth(11,31);var X=new U(this._oMinDate);X.setUTCFullYear(X.getUTCFullYear()+Math.floor(R/2)+1);X.setUTCMonth(0,1);if(S.getTime()>W.getTime()){V.setEnabledNext(false);}else{V.setEnabledNext(true);}if(S.getTime()<X.getTime()){V.setEnabledPrevious(false);}else{V.setEnabledPrevious(true);}}
function r(){var Q=this.getAggregation("header");var R;var S=d.call(this);var V=this._getLocaleData();var W=[];var X=[];var Z;var $=false;var a1;if(V.oLocale.sLanguage.toLowerCase()==="ja"||V.oLocale.sLanguage.toLowerCase()==="zh"){a1=sap.ui.core.format.DateFormat.getDateInstance({format:"d"}).format(S,true);}else{a1=(S.getUTCDate()).toString();}Q.setTextButton0(a1);if(this._bLongMonth||!this._bNamesLengthChecked){W=V.getMonthsStandAlone("wide");}else{$=true;W=V.getMonthsStandAlone("abbreviated");X=V.getMonthsStandAlone("wide");}var b1=S.getUTCMonth();R=W[b1];if($){Z=X[W[b1]];}Q.setTextButton1(R);if($){Q.setAriaLabelButton1(Z);}Q.setTextButton2(this._oYearFormat.format(S,true));}
function s(Q,R){var S;var V=false;if(Q.getTime()<this._oMinDate.getTime()){S=this._oMinDate;V=true;}else if(Q.getTime()>this._oMaxDate.getTime()){S=this._oMaxDate;V=true;}else{S=Q;}this._setFocusedDate(S);if(V||R){G.call(this,S);e.call(this,false);this.fireStartDateChange();}}
function t(Q,R){if(Q&&(!this._oFocusedDate||this._oFocusedDate.getTime()!=Q.getTime())){a._checkJSDateObject(Q);Q=a._createUniversalUTCDate(Q,undefined,true);var S=Q.getUTCFullYear();a._checkYearInValidRange(S);if(Q.getTime()<this._oMinDate.getTime()||Q.getTime()>this._oMaxDate.getTime()){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(Q);if(this.getDomRef()&&this._iMode==0){e.call(this,R);}}}
function u(Q){if(this._iMode!=1){g.call(this);}else{h.call(this);}}
function v(Q){if(this._iMode!=2){i.call(this);}else{j.call(this);}}
function w(Q){if(this._iMode!=3){k.call(this);}else{m.call(this);}}
function x(Q){this.fireSelect();}
function y(Q){var R=a._createUniversalUTCDate(Q.getParameter("date"),undefined,true);var S=Q.getParameter("notVisible");s.call(this,R,S);}
function z(Q){var R=new U(this._getFocusedDate().getTime());var S=Q.oSource;var V=S.getSelectedDates()[0];var W=a._createUniversalUTCDate(V.getStartDate());if(!this.getPickerPopup()||W.getUTCMonth()==R.getUTCMonth()){R.setUTCDate(W.getUTCDate());R.setUTCMonth(W.getUTCMonth());R.setUTCFullYear(W.getUTCFullYear());s.call(this,R,true);h.call(this);}}
function A(Q){var R=new U(this._getFocusedDate().getTime());var S=a._createUniversalUTCDate(Q.getParameter("date"),undefined,true);var V=Q.getParameter("otherMonth");if(V&&S.getUTCMonth()==R.getUTCMonth()&&S.getUTCFullYear()==R.getUTCFullYear()){I.call(this,S);}}
function B(Q){var R=new U(this._getFocusedDate().getTime());var S=this.getAggregation("monthPicker");var V=S.getMonth();R.setUTCMonth(V);if(V!=R.getUTCMonth()){R.setUTCDate(0);}s.call(this,R,true);j.call(this);}
function E(Q){var R=new U(this._getFocusedDate().getTime());var S=this.getAggregation("yearPicker");var V=a._createUniversalUTCDate(S.getDate());var W=R.getUTCMonth();V.setUTCMonth(R.getUTCMonth(),R.getUTCDate());V.setUTCHours(R.getUTCHours());V.setUTCMinutes(R.getUTCMinutes());R=V;if(W!=R.getUTCMonth()){R.setUTCDate(0);}s.call(this,R,true);m.call(this);}
function F(){this._sInvalidateContent=undefined;var Q=this.getAggregation("timesRow");Q._bDateRangeChanged=true;Q._bInvalidateSync=true;Q.invalidate();Q._bInvalidateSync=undefined;this._bDateRangeChanged=undefined;}
function G(Q){var R=this.getAggregation("timesRow");var S=d.call(this);var V=R._oItemNavigation.getFocusedIndex();S=new U(Q.getTime());S.setUTCMinutes(S.getUTCMinutes()-V*this.getIntervalMinutes());_.call(this,S,false,true);}
function I(Q){var R=this.getAggregation("datesRow");var S=this.getAggregation("header");if(!this.getPickerPopup()){var V=new U(Q.getTime());V.setUTCDate(1);V.setUTCMonth(V.getUTCMonth()+1);V.setUTCDate(0);var W=R.getDays();var X=new U(Q.getTime());X.setUTCDate(1+(Math.ceil(Q.getUTCDate()/W)-1)*W);if(V.getUTCDate()-X.getUTCDate()<W){X.setUTCDate(V.getUTCDate()-W+1);}R.setStartDate(a._createLocalDate(X,true));var Z=X.getJSDate().getUTCFullYear();var $=this._oMaxDate.getJSDate().getUTCFullYear();var a1=this._oMinDate.getJSDate().getUTCFullYear();var b1=X.getJSDate().getUTCMonth();var c1=this._oMaxDate.getJSDate().getUTCMonth();var d1=this._oMinDate.getJSDate().getUTCMonth();var e1=X.getJSDate().getUTCDate();var f1=this._oMaxDate.getJSDate().getUTCDate();var g1=this._oMinDate.getJSDate().getUTCDate();if(e1<=1||(Z==a1&&b1==d1&&e1<=g1)){S.setEnabledPrevious(false);}else{S.setEnabledPrevious(true);}if((e1+W)>=V.getUTCDate()||(Z==$&&b1==c1&&e1>=f1)){S.setEnabledNext(false);}else{S.setEnabledNext(true);}}else{S.setEnabledPrevious(false);S.setEnabledNext(false);}R.setDate(a._createLocalDate(Q,true));}
function J(Q){if(!this._oPopup){q.sap.require("sap.ui.core.Popup");this._oPopup=new sap.ui.core.Popup();this._oPopup.setAutoClose(true);this._oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.setDurations(0,0);this._oPopup._oCalendar=this;this._oPopup.attachClosed(K,this);this._oPopup.onsapescape=function(V){this._oCalendar.onsapescape(V);};}this._oPopup.setContent(Q);var R=this.getAggregation("header");var S=sap.ui.core.Popup.Dock;this._oPopup.open(0,S.CenterTop,S.CenterBottom,R,null,"flipfit",true);}
function K(Q){switch(this._iMode){case 0:break;case 1:h.call(this);break;case 2:j.call(this);break;case 3:m.call(this);break;}}
function N(Q,R){var S=0;var V=11;if(Q==this._oMinDate.getUTCFullYear()){S=this._oMinDate.getUTCMonth();}if(Q==this._oMaxDate.getUTCFullYear()){V=this._oMaxDate.getUTCMonth();}R.setMinMax(S,V);}
function O(Q){o.call(this);}
function P(Q){p.call(this);}
return c;},true);
sap.ui.predefine('sap/ui/unified/CalendarTimeIntervalRenderer',['jquery.sap.global'],function(q){"use strict";var C={};
C.render=function(r,c){c._iMode=0;var i=c.getId();var t=c.getTooltip_AsString();var T=c.getAggregation("timesRow");r.write("<div");r.writeControlData(c);r.addClass("sapUiCal");r.addClass("sapUiCalInt");r.addClass("sapUiCalTimeInt");if(c._getShowItemHeader()){r.addClass("sapUiCalIntHead");}r.writeAttribute("tabindex","-1");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var A={labelledby:{value:"",append:false}};if(c._bPoupupMode){A["role"]="dialog";}r.writeAccessibilityState(c,A);if(t){r.writeAttributeEscaped('title',t);}var w=c.getWidth();if(w&&w!=''){r.addStyle("width",w);r.writeStyles();}r.writeClasses();r.write(">");var h=c.getAggregation("header");r.renderControl(h);r.write("<div id=\""+i+"-content\" class=\"sapUiCalContent\">");r.renderControl(T);r.write("<div id=\""+i+"-contentOver\" class=\"sapUiCalContentOver\" style=\"display:none;\"></div>");r.write("</div>");r.write("<button id=\""+i+"-cancel\" class=\"sapUiCalCancel\" tabindex=\"-1\">");r.write(a.getText("CALENDAR_CANCEL"));r.write("</button>");r.write("<div id=\""+i+"-end\" tabindex=\"0\" style=\"width:0;height:0;position:absolute;right:0;bottom:0;\"></div>");r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/CalendarWeekInterval',['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarDateIntervalRenderer'],function(q,C,a,l,b,c){"use strict";
var d=b.extend("CalendarWeekInterval",{renderer:c});
d.prototype._getDaysLarge=function(){return 6;};
d.prototype._handleFocus=function(e){var o=!!e.getParameter("_outsideBorder"),D,f,g;if(o){D=e.getParameter("date");this._oFocusDateWeek=a.fromLocalJSDate(D);f=C._getFirstDateOfWeek(this._oFocusDateWeek);g=this.getAggregation("month")[0];if(g.getDomRef()){this._setStartDate(f,false,true);}}return b.prototype._handleFocus.apply(this,arguments);};
d.prototype._adjustFocusedDateUponMonthChange=function(f,i){var n=new a(f),I;n.setDate(1);n.setMonth(n.getMonth()+1);I=this._oPlanningCalendar._dateMatchesVisibleRange(n.toLocalJSDate(),sap.ui.unified.CalendarIntervalType.Week);if(I&&i===n.getMonth()){return;}f.setMonth(i);f.setDate(1);var F=C._getFirstDateOfWeek(f);this._setStartDate(F,false,true);this._oFocusDateWeek=F;f.setYear(F.getYear());f.setMonth(F.getMonth());f.setDate(F.getDate());};
d.prototype._adjustFocusedDateUponYearChange=function(f,i){if(!(f&&f instanceof a)){return;}var w=C._getWeek(f),t=new a(f),n;t.setYear(i);t.setDate(t.getDate()-7);n=C._getWeek(t);if(w.week===52&&C._getNumberOfWeeksForYear(i)<53){w.week=51;}while(w.week!==n.week){t.setDate(t.getDate()+1);n=C._getWeek(t);}f.setYear(t.getYear());f.setMonth(t.getMonth());f.setDate(t.getDate());};
d.prototype._focusDateExtend=function(D,o,n){var e,L;if(!this._oFocusDateWeek){return b.prototype._focusDateExtend.apply(this,arguments);}e=this.getAggregation("month")[0];L=this._oFocusDateWeek.toLocalJSDate();this._setFocusedDate(this._oFocusDateWeek);e.setDate(L);this._oFocusDateWeek=null;return!n;};
d.prototype._dateMatchesVisibleRange=function(D){var i=this.getDays(),o=a.fromLocalJSDate(D),s=a.fromLocalJSDate(this.getStartDate()),e=a.fromLocalJSDate(this.getStartDate());e.setDate(e.getDate()+i);return o.isSameOrAfter(s)&&o.isBefore(e);};
return d;},true);
sap.ui.predefine('sap/ui/unified/ColorPicker',['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/HTML',"sap/ui/core/ResizeHandler","sap/ui/layout/Grid","sap/ui/layout/GridData","sap/ui/layout/VerticalLayout","sap/ui/layout/HorizontalLayout","sap/ui/core/Icon","sap/ui/core/theming/Parameters","sap/ui/core/InvisibleText"],function(q,L,a,H,R,G,b,V,c,I,P,e){"use strict";
var f=a.extend("sap.ui.unified.ColorPicker",{metadata:{library:"sap.ui.unified",properties:{colorString:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.ui.unified.ColorPickerMode",group:"Appearance",defaultValue:sap.ui.unified.ColorPickerMode.HSV}},aggregations:{_grid:{type:"sap.ui.layout.Grid",group:"Appearance",multiple:false,visibility:"hidden"},_invisibleTexts:{type:"sap.ui.core.InvisibleText",multiple:true,visibility:"hidden"}},events:{change:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}},liveChange:{parameters:{r:{type:"int"},g:{type:"int"},b:{type:"int"},h:{type:"int"},s:{type:"int"},v:{type:"int"},l:{type:"int"},hex:{type:"string"},alpha:{type:"string"}}}}}});
var B="",s=sap.ui.resource('sap.ui.unified','img/ColorPicker/Alphaslider_BG.png'),r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),h=L.ColorPickerHelper,F=h.factory,g={};Object.defineProperties(g,{RGB:{value:"RGB"},CPResponsiveClass:{value:"sapUnifiedColorPicker"},CPMatrixClass:{value:"sapUiColorPicker-ColorPickerMatrix"},HSLClass:{value:"sapUiColorPickerHSL"},LabelClass:{value:"sapUiColorPicker-ColorPickerLabels"},UnitLabelClass:{value:"sapUiCPUnitLabel"},HEXClass:{value:"sapUiColorPicker-ColorPickerHexField"},LeftColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsLeft"},RightColumnInputClass:{value:"sapUiColorPicker-ColorPickerInputFieldsRight"},SliderClass:{value:"sapUiColorPicker-ColorPickerSlider"},AlphaSliderClass:{value:"sapUiColorPicker-ColorPickerAlphaSlider"},OutputSelectorClass:{value:"sapUiColorPickerHSL-RB"},OutputSelectorRowClass:{value:"sapUiColorPicker-RBRow"},CPBoxClass:{value:"sapUiColorPicker-ColorPickerBox"},CPCircleClass:{value:"sapUiColorPicker-ColorPickerCircle"},LastColumnClass:{value:"sapUiColorPicker-ColorPickerLastColumn"},HideForHSVClass:{value:"hideForHSV"},HideForHSLClass:{value:"hideForHSL"},OldColorClass:{value:"sapUiColorPicker-ColorPickerOldColor"},NewColorClass:{value:"sapUiColorPicker-ColorPickerNewColor"},SwatchesClass:{value:"sapUiColorPicker-swatches"},ArrowClass:{value:"sapUiColorPicker-Arrow"},Colors:{value:{aliceblue:'f0f8ff',antiquewhite:'faebd7',aqua:'00ffff',aquamarine:'7fffd4',azure:'f0ffff',beige:'f5f5dc',bisque:'ffe4c4',black:'000000',blanchedalmond:'ffebcd',blue:'0000ff',blueviolet:'8a2be2',brown:'a52a2a',burlywood:'deb887',cadetblue:'5f9ea0',chartreuse:'7fff00',chocolate:'d2691e',coral:'ff7f50',cornflowerblue:'6495ed',cornsilk:'fff8dc',crimson:'dc143c',cyan:'00ffff',darkblue:'00008b',darkcyan:'008b8b',darkgoldenrod:'b8860b',darkgray:'a9a9a9',darkgrey:'a9a9a9',darkgreen:'006400',darkkhaki:'bdb76b',darkmagenta:'8b008b',darkolivegreen:'556b2f',darkorange:'ff8c00',darkorchid:'9932cc',darkred:'8b0000',darksalmon:'e9967a',darkseagreen:'8fbc8f',darkslateblue:'483d8b',darkslategray:'2f4f4f',darkslategrey:'2f4f4f',darkturquoise:'00ced1',darkviolet:'9400d3',deeppink:'ff1493',deepskyblue:'00bfff',dimgray:'696969',dimgrey:'696969',dodgerblue:'1e90ff',firebrick:'b22222',floralwhite:'fffaf0',forestgreen:'228b22',fuchsia:'ff00ff',gainsboro:'dcdcdc',ghostwhite:'f8f8ff',gold:'ffd700',goldenrod:'daa520',gray:'808080',grey:'808080',green:'008000',greenyellow:'adff2f',honeydew:'f0fff0',hotpink:'ff69b4',indianred:'cd5c5c',indigo:'4b0082',ivory:'fffff0',khaki:'f0e68c',lavender:'e6e6fa',lavenderblush:'fff0f5',lawngreen:'7cfc00',lemonchiffon:'fffacd',lightblue:'add8e6',lightcoral:'f08080',lightcyan:'e0ffff',lightgoldenrodyellow:'fafad2',lightgray:'d3d3d3',lightgrey:'d3d3d3',lightgreen:'90ee90',lightpink:'ffb6c1',lightsalmon:'ffa07a',lightseagreen:'20b2aa',lightskyblue:'87cefa',lightslategray:'778899',lightslategrey:'778899',lightsteelblue:'b0c4de',lightyellow:'ffffe0',lime:'00ff00',limegreen:'32cd32',linen:'faf0e6',magenta:'ff00ff',maroon:'800000',mediumaquamarine:'66cdaa',mediumblue:'0000cd',mediumorchid:'ba55d3',mediumpurple:'9370db',mediumseagreen:'3cb371',mediumslateblue:'7b68ee',mediumspringgreen:'00fa9a',mediumturquoise:'48d1cc',mediumvioletred:'c71585',midnightblue:'191970',mintcream:'f5fffa',mistyrose:'ffe4e1',moccasin:'ffe4b5',navajowhite:'ffdead',navy:'000080',oldlace:'fdf5e6',olive:'808000',olivedrab:'6b8e23',orange:'ffa500',orangered:'ff4500',orchid:'da70d6',palegoldenrod:'eee8aa',palegreen:'98fb98',paleturquoise:'afeeee',palevioletred:'db7093',papayawhip:'ffefd5',peachpuff:'ffdab9',peru:'cd853f',pink:'ffc0cb',plum:'dda0dd',powderblue:'b0e0e6',purple:'800080',red:'ff0000',rosybrown:'bc8f8f',royalblue:'4169e1',saddlebrown:'8b4513',salmon:'fa8072',sandybrown:'f4a460',seagreen:'2e8b57',seashell:'fff5ee',sienna:'a0522d',silver:'c0c0c0',skyblue:'87ceeb',slateblue:'6a5acd',slategray:'708090',slategrey:'708090',snow:'fffafa',springgreen:'00ff7f',steelblue:'4682b4',tan:'d2b48c',teal:'008080',thistle:'d8bfd8',tomato:'ff6347',turquoise:'40e0d0',violet:'ee82ee',wheat:'f5deb3',white:'ffffff',whitesmoke:'f5f5f5',yellow:'ffff00',yellowgreen:'9acd32',transparent:'00000000'}}});
f.prototype.init=function(){if(sap.ui.Device.browser.firefox){B="-moz-linear-gradient";}else if(sap.ui.Device.browser.msie){B="-ms-linear-gradient";}else if(sap.ui.Device.browser.webkit){B="-webkit-linear-gradient";}else{B="linear-gradient";}this.Color={r:255,g:255,b:255,h:0,s:0,l:100,v:100,a:1,oldA:1,hex:"#ffffff",old:"#ffffff"};this.sHexString="ffffff";this.$CPBox=null;this.$CPCur=null;this.RGB={r:0,g:0,b:0};this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this.data("sap-ui-fastnavgroup","true",true);this.bResponsive=h.isResponsive();this._iCPCursorSize=parseInt(P.get("_sap_ui_unified_ColorPickerCircleSize"),10);this._processChanges=this._processHSVChanges;this._bHSLMode=false;};
var j=a.extend("sap.ui.unified._ColorPickerBox",{
metadata:{events:{select:{parameters:{value:{type:"int"},saturation:{type:"int"}}},resize:{parameters:{size:{type:"int"}}}}},
init:function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();},
exit:function(){if(this._sResizeListener){R.deregister(this._sResizeListener);}},
getWidth:function(){return this.$().width();},
getOffset:function(){return this.$().offset();},
onBeforeRendering:function(){if(this._sResizeListener){R.deregister(this._sResizeListener);}},
onAfterRendering:function(){this._handle=this.$().find("> div."+g.CPCircleClass);this._sResizeListener=R.register(this.getDomRef(),this.handleResize.bind(this));},
handleResize:function(E){this.fireResize({size:E.size.width});},
getHandle:function(){return this._handle;},
ontouchstart:function(E){this.handleTouch(E);},
ontouchend:function(E){this.handleTouch(E);},
ontouchmove:function(E){this.handleTouch(E);},
handleTouch:function(E){var v=this.calculateValuesFromEvent(E);if(v){this.fireSelect(v);}},
calculateValuesFromEvent:function(E){var x=E.offsetX,y=E.offsetY,i,d=i=this.getWidth(),o,O;E.preventDefault&&E.preventDefault();if(!x){o=E.targetTouches?E.targetTouches[0]:E;if(!o||!o.pageX){o=E;if((!o||!o.pageX)&&E.changedTouches){o=E.changedTouches[0];}}if(!o.pageX){return false;}O=this.getOffset();x=o.pageX-O.left;y=o.pageY-O.top;}x=Math.min(Math.max(x,0),d);y=Math.min(Math.max(y,0),i);if(this.bRtl){x=d-x;}return{value:x/d*100,saturation:(1-y/i)*100};},
renderer:function(o,C){o.write("<div");o.addClass(g.CPBoxClass);o.writeControlData(C);o.writeClasses();o.write(">");o.write("<div");o.writeAttribute("id",C.getId()+"-cpCur");o.addClass(g.CPCircleClass);o.writeClasses();o.write("></div>");o.write("</div>");}
});
f.prototype._createRowFromInput=function(i,t,l,u){var T=r.getText(t),o;o=new c({content:[F.createLabel({text:l,tooltip:T,labelFor:i}).addStyleClass(g.LabelClass),i.setTooltip(T)]});if(u){o.addContent(F.createLabel({text:u,labelFor:i}).addStyleClass(g.UnitLabelClass).addStyleClass(g.LabelClass));}return o;};
f.prototype._updateColorStringProperty=function(d,i){var k=this._getCSSColorString();this.setProperty('colorString',k,true);if(i){this.fireLiveChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:k});}if(d){this.fireChange({r:this.Color.r,g:this.Color.g,b:this.Color.b,h:this.Color.h,s:this.Color.s,v:this.Color.v,l:this.Color.l,alpha:this.Color.a,hex:this.Color.hex,formatHSL:this.Color.formatHSL,colorString:k});}};
f.prototype._handleCPBoxSelectEvent=function(E){var v=E.getParameter("value"),d=E.getParameter("saturation");this.oSatField.setValue(d);if(this._bHSLMode){this.oLitField.setValue(v);}else{this.oValField.setValue(v);}this._processChanges();this._updateColorStringProperty(false,true);};
f.prototype._handleCPBoxResizeEvent=function(E){this._iCPBoxSize=E.getParameter("size");this._updateCursorPosition();};
f.prototype._handleCPBoxTouchEndEvent=function(E){this._updateColorStringProperty(true,false);};
f.prototype._createInteractionControls=function(){var i=this.getId(),o,A;this.oCPBox=new j(i+"-cpBox",{select:this._handleCPBoxSelectEvent.bind(this),resize:this._handleCPBoxResizeEvent.bind(this)});this.oCPBox.addDelegate({ontouchend:this._handleCPBoxTouchEndEvent.bind(this)});this.oHexField=F.createInput(i+"-hxF",{value:this.Color.hex.substr(1),change:this._handleHexValueChange.bind(this)}).addStyleClass(g.HEXClass);this.oRedField=F.createInput(i+"-rF",{value:this.Color.r,change:this._handleRedValueChange.bind(this)}).addStyleClass(g.LeftColumnInputClass);this.oGreenField=F.createInput(i+"-gF",{value:this.Color.g,change:this._handleGreenValueChange.bind(this)}).addStyleClass(g.LeftColumnInputClass);this.oBlueField=F.createInput(i+"-bF",{value:this.Color.b,change:this._handleBlueValueChange.bind(this)}).addStyleClass(g.LeftColumnInputClass);this.oHueField=F.createInput(i+"-hF",{value:this.Color.h,change:this._handleHueValueChange.bind(this)}).addStyleClass(g.RightColumnInputClass);this.oSatField=F.createInput(i+"-sF",{value:this.Color.s,change:this._handleSatValueChange.bind(this)}).addStyleClass(g.RightColumnInputClass);this.oLitField=F.createInput(i+"-lF",{value:this.Color.l,change:this._handleLitValueChange.bind(this)}).addStyleClass(g.RightColumnInputClass);this.oAlphaField=F.createInput(i+"-aF",{value:this.Color.a,change:this._handleAlphaValueChange.bind(this)}).addStyleClass(g.RightColumnInputClass);this.oValField=F.createInput(i+"-vF",{value:this.Color.v,change:this._handleValValueChange.bind(this)}).addStyleClass(g.RightColumnInputClass);this.oRGBorHSLRBGroup=F.createRadioButtonGroup({columns:2,buttons:[F.createRadioButtonItem({text:g.RGB}),F.createRadioButtonItem({text:L.ColorPickerMode.HSL})],select:this._handleRGBorHSLValueChange.bind(this),selectedIndex:(this.Color.formatHSL?1:0)}).addStyleClass(g.OutputSelectorClass);o=new e({text:r.getText("COLORPICKER_HUE_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",o,true);this.oSlider=F.createSlider(i+"-hSLD",{max:360,step:1,tooltip:r.getText("COLORPICKER_HUE"),value:parseInt(this.oHueField.getValue(),10)}).addStyleClass(g.SliderClass).addAriaLabelledBy(o);this.oSlider.attachEvent("liveChange","liveChange",this._handleSliderChange.bind(this));this.oSlider.attachEvent("change","change",this._handleSliderChange.bind(this));A=new e({text:r.getText("COLORPICKER_ALPHA_SLIDER")}).toStatic();this.addAggregation("_invisibleTexts",A,true);this.oAlphaSlider=F.createSlider(i+"-aSLD",{max:1,value:1,step:0.01,tooltip:r.getText("COLORPICKER_ALPHA")}).addStyleClass(g.AlphaSliderClass).addAriaLabelledBy(A);this.oAlphaSlider.attachEvent("liveChange","liveChange",this._handleAlphaSliderChange.bind(this));this.oAlphaSlider.attachEvent("change","change",this._handleAlphaSliderChange.bind(this));};
f.prototype._createLayout=function(){var i=this.getId(),o;if(this._bLayoutControlsCreated){return;}this._createInteractionControls();this._oLayoutData={oCPBox:new b({span:"L6 M6 S12"}),icOne:new b({span:"L3 M3 S6"}),icTwo:new b({span:"L3 M3 S6"}),swatches:new b({span:"L3 M3 S12"}),rbg:new b({span:"L6 M8 S12"})};o=new G({containerQuery:true,content:[this.oCPBox.setLayoutData(this._oLayoutData.oCPBox),new V({content:[this._createRowFromInput(this.oRedField,"COLORPICKER_RED","R:"),this._createRowFromInput(this.oGreenField,"COLORPICKER_GREEN","G:"),this._createRowFromInput(this.oBlueField,"COLORPICKER_BLUE","B:"),this._createRowFromInput(this.oHexField,"COLORPICKER_HEX","#:")],layoutData:this._oLayoutData.icOne}),new V({content:[this._createRowFromInput(this.oHueField,"COLORPICKER_HUE","H:"),this._createRowFromInput(this.oSatField,"COLORPICKER_SAT","S:","%"),this._createRowFromInput(this.oLitField,"COLORPICKER_LIGHTNESS","L:","%").addStyleClass(g.HideForHSVClass),this._createRowFromInput(this.oAlphaField,"COLORPICKER_ALPHA","A:").addStyleClass(g.HideForHSVClass),this._createRowFromInput(this.oValField,"COLORPICKER_VALUE","V:").addStyleClass(g.HideForHSLClass)],layoutData:this._oLayoutData.icTwo}).addStyleClass(g.LastColumnClass),new c({content:[new H({content:["<div id='",i,"-ocBox' class='",g.OldColorClass,"'></div>"].join("")}),new I({backgroundColor:"transparent",src:"sap-icon://arrow-right",tooltip:r.getText("COLORPICKER_NEW_OLD_COLOR")}).addStyleClass(g.HideForHSVClass).addStyleClass(g.ArrowClass),new H({content:["<div id='",i,"-ncBox' class='",g.NewColorClass,"'></div>"].join("")})],layoutData:this._oLayoutData.swatches}).addStyleClass(g.SwatchesClass),new c({content:[F.createLabel({text:"Output:",labelFor:this.oRGBorHSLRBGroup}),this.oRGBorHSLRBGroup],layoutData:this._oLayoutData.rbg}).addStyleClass(g.HideForHSVClass).addStyleClass(g.OutputSelectorRowClass),this.oSlider.setLayoutData(new b({span:"L6 M6 S12",linebreak:true})),this.oAlphaSlider.setLayoutData(new b({span:"L6 M6 S12"}))]}).addStyleClass(g.CPMatrixClass);this.setAggregation("_grid",o,true);this._bLayoutControlsCreated=true;this._adaptControlToLibrary();};
f.prototype._adaptControlToLibrary=function(){var o;if(!this._bLayoutControlsCreated){return;}o=this.getAggregation("_grid");if(this.bResponsive){o._setBreakPointTablet(314);o.addStyleClass(g.CPResponsiveClass);}else{o.setProperty("hSpacing",0,true);o.setProperty("vSpacing",0,true);this._oLayoutData.oCPBox.setSpanS(5);this._oLayoutData.icOne.setSpanS(4);this._oLayoutData.icTwo.setSpanS(3);this._oLayoutData.rbg.setSpanS(8);}this._adaptControlToLibrary=q.noop;};
f.prototype._updateControlVisualState=function(){var o=this.getAggregation("_grid");if(!this._bLayoutControlsCreated){return;}if(this.bResponsive){if(this._bHSLMode){o.addStyleClass(g.HSLClass);this._oLayoutData.swatches.setSpanM(4).setLinebreak(true);}else{o.removeStyleClass(g.HSLClass);this._oLayoutData.swatches.setSpanM(3).setLinebreak(false);}}else{if(this._bHSLMode){o.addStyleClass(g.HSLClass);this._oLayoutData.swatches.setSpanS(4).setLinebreak(true);}else{o.removeStyleClass(g.HSLClass);this._oLayoutData.swatches.setSpanS(3).setLinebreak(false);}}};
f.prototype._processChanges=q.noop;
f.prototype.setMode=function(m,S){switch(m){case L.ColorPickerMode.HSL:this._processChanges=this._processHSLChanges;break;case L.ColorPickerMode.HSV:this._processChanges=this._processHSVChanges;break;default:q.sap.log.error("Control must have a valid mode set to work correct");break;}this._bHSLMode=m===L.ColorPickerMode.HSL;return this.setProperty("mode",m,S);};
f.prototype.onBeforeRendering=function(){this._createLayout();this._updateControlVisualState();this._updateColorString();};
f.prototype._updateColorString=function(){this._parseColorString(this.getColorString());this.oHexField.setValue(this.Color.hex.substr(1));this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(this.Color.a);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);this.oRGBorHSLRBGroup.setSelectedIndex(this.Color.formatHSL?1:0);}else{this.oValField.setValue(this.Color.v);this.oSlider.setValue(this.Color.h);this.oAlphaSlider.setValue(this.Color.a);this.oAlphaField.setValue(this.Color.a);}this._updateColorStringProperty(true,true);};
f.prototype.isColor=function(C){return this._parseColorString(C,true);};
f.prototype._handleSliderChange=function(E,d){var i=parseInt(this.oSlider.getValue(),10);this.oHueField.setValue(i);this._processChanges();this._updateColorStringProperty(d==="change",d==="liveChange");};
f.prototype._handleAlphaSliderChange=function(E,d){this.Color.a=this.oAlphaSlider.getValue();if(this._bHSLMode){this.oAlphaField.setValue(this.Color.a);}if(!this.Color.formatHSL){this._processRGBChanges();}else{this._processChanges();}this._updateColorStringProperty(d==="change",d==="liveChange");};
f.prototype._getValueInRange=function(v,m,M){if(isNaN(v)){v=0;}return Math.min(Math.max(v,m),M);};
f.prototype._handleAlphaValueChange=function(){var d=parseFloat(this.oAlphaField.getValue(),10);d=this._getValueInRange(d,0,1);this.Color.a=d;this.oAlphaField.setValue(d);this.oAlphaSlider.setValue(d);if(!this.Color.formatHSL){this._processRGBChanges();}else{this._processChanges();}this._updateColorStringProperty(true,true);};
f.prototype._handleRGBorHSLValueChange=function(){this.Color.formatHSL=(this.oRGBorHSLRBGroup.getSelectedIndex()===1);this._updateColorStringProperty(true,true);};
f.prototype._handleHueValueChange=function(){var d=parseInt(this.oHueField.getValue(),10);d=this._getValueInRange(d,0,360);this.oHueField.setValue(d);this.oSlider.setValue(d);this._processChanges();this._updateColorStringProperty(true,true);};
f.prototype._handleSatValueChange=function(){var d=parseInt(this.oSatField.getValue(),10);d=this._getValueInRange(d,0,100);this.oSatField.setValue(d);this._processChanges();this._updateColorStringProperty(true,true);};
f.prototype._handleValValueChange=function(){var v=parseInt(this.oValField.getValue(),10);v=this._getValueInRange(v,0,100);this.oValField.setValue(v);this._processHSVChanges();this._updateColorStringProperty(true,true);};
f.prototype._handleLitValueChange=function(){var l=parseInt(this.oLitField.getValue(),10);l=this._getValueInRange(l,0,100);this.oLitField.setValue(l);this._processHSLChanges();this._updateColorStringProperty(true,true);};
f.prototype._handleRedValueChange=function(){var d=parseInt(this.oRedField.getValue(),10);d=this._getValueInRange(d,0,255);this.oRedField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
f.prototype._handleGreenValueChange=function(){var d=parseInt(this.oGreenField.getValue(),10);d=this._getValueInRange(d,0,255);this.oGreenField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
f.prototype._handleBlueValueChange=function(){var d=parseInt(this.oBlueField.getValue(),10);d=this._getValueInRange(d,0,255);this.oBlueField.setValue(d);this._processRGBChanges();this._updateColorStringProperty(true,true);};
f.prototype._processHSVChanges=function(){var d=parseInt(this.oHueField.getValue(),10);var i=parseInt(this.oSatField.getValue(),10);var v=parseInt(this.oValField.getValue(),10);this._calculateRGB(d,i,v);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=d;this.Color.s=i;this.Color.v=v;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oValField.setValue(this.Color.v);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};
f.prototype._processHSLChanges=function(){var i=parseInt(this.oHueField.getValue(),10),S=parseInt(this.oSatField.getValue(),10),l=parseInt(this.oLitField.getValue(),10);if(i>360){i%=360;}this._calculateRGB(i,S,l);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this._calculateHEX(this.Color.r,this.Color.g,this.Color.b);this.oHexField.setValue(this.sHexString);this.Color.hex="#"+this.oHexField.getValue();this.Color.h=i;this.Color.s=S;this.Color.l=l;this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oLitField.setValue(this.Color.l);this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateAlphaBackground();this._updateSelColorBackground();};
f.prototype._processRGBChanges=function(){var d=Math.round(parseInt(this.oRedField.getValue(),10)),i=Math.round(parseInt(this.oGreenField.getValue(),10)),k=Math.round(parseInt(this.oBlueField.getValue(),10));this._calculateHEX(d,i,k);this.oHexField.setValue(this.sHexString);if(this._bHSLMode){this._calculateHSL(d,i,k);this.oLitField.setValue(this.Color.l);}else{this._calculateHSV(d,i,k);this.oValField.setValue(this.Color.v);}this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));this.Color.r=d;this.Color.g=i;this.Color.b=k;this.Color.hex="#"+this.oHexField.getValue();this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();};
f.prototype._handleHexValueChange=function(){var d=this.oHexField.getValue().toLowerCase(),i=1,k;if(d.substr(0,1)==='#'){d=d.substr(1);}k=/^([0-9a-fA-F]{8})$/;if(k.test(d)!==false){i=Number((parseInt(d.substr(6,2),16)/255).toFixed(2));d=d.substr(0,6);}k=/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/;if(k.test(d)===false){this.oHexField.setValueState(sap.ui.core.ValueState.Error);this.oSlider.setEnabled(false);this.oAlphaSlider.setEnabled(false);this.oHueField.setEnabled(false);this.oRedField.setEnabled(false);this.oGreenField.setEnabled(false);this.oBlueField.setEnabled(false);this.oSatField.setEnabled(false);if(this._bHSLMode){this.oLitField.setEnabled(false);this.oAlphaField.setEnabled(false);}else{this.oValField.setEnabled(false);}return;}else if(this.oHexField.getValueState()===sap.ui.core.ValueState.Error){this.oHexField.setValueState(sap.ui.core.ValueState.None);this.oSlider.setEnabled(true);this.oAlphaSlider.setEnabled(true);this.oHueField.setEnabled(true);this.oRedField.setEnabled(true);this.oGreenField.setEnabled(true);this.oBlueField.setEnabled(true);this.oSatField.setEnabled(true);if(this._bHSLMode){this.oLitField.setEnabled(true);this.oAlphaField.setEnabled(true);}else{this.oValField.setEnabled(true);}}if(d.length===3){d=d.charAt(0)+d.charAt(0)+d.charAt(1)+d.charAt(1)+d.charAt(2)+d.charAt(2);}this._processHexChanges(d);this.oHexField.setValue(d);this.oRedField.setValue(this.Color.r);this.oGreenField.setValue(this.Color.g);this.oBlueField.setValue(this.Color.b);this.oHueField.setValue(this.Color.h);this.oSatField.setValue(this.Color.s);if(this._bHSLMode){this.oLitField.setValue(this.Color.l);this.oAlphaField.setValue(1);}else{this.oValField.setValue(this.Color.v);}this.oSlider.setValue(parseInt(this.oHueField.getValue(),10));this.oAlphaSlider.setValue(i);this.Color.a=i;if(this._bHSLMode){this.oAlphaField.setValue(i);}this._updateGradientBoxBackground(this.Color.h);this._updateCursorPosition();this._updateSelColorBackground();this._updateColorStringProperty(true,true);};
f.prototype._processHexChanges=function(d){this._convertRGB(d);if(this._bHSLMode){this._calculateHSL(this.Color.r,this.Color.g,this.Color.b);}else{this._calculateHSV(this.Color.r,this.Color.g,this.Color.b);}this.Color.hex="#"+d.toLowerCase();};
f.prototype._updateAlphaBackground=function(){var d=[this.Color.r,this.Color.g,this.Color.b].join(","),n=B+"(left,rgba("+d+",0),rgba("+d+",1)),url("+s+")";if(this.lastAlphaSliderGradient!==n){this.oAlphaSlider.$().find(this.bResponsive?".sapMSliderInner":".sapUiSliBar").css("background-image",n);this.lastAlphaSliderGradient=n;}};
f.prototype._updateCursorPosition=function(){var x,y;if(!this._iCPBoxSize){return;}if(this._bHSLMode){x=Math.round(this.oLitField.getValue()*this._iCPBoxSize/100.0);}else{x=Math.round(this.oValField.getValue()*this._iCPBoxSize/100.0);}if(this.bRtl){x=this._iCPBoxSize-x;}y=Math.round((1-this.oSatField.getValue()/100.0)*this._iCPBoxSize);x=Math.round(Math.max(x,0)-this._iCPCursorSize/2.0-1.0);y=Math.round(Math.max(y,0)-this._iCPCursorSize/2.0-1.0);this.$CPCur.css("left",x).css("top",y);};
f.prototype._calculateRGB=function(d,S,v){var k,l,m,M,x,C,i;if(this._bHSLMode){this._calculateRGBAdvanced(d,S,v);return;}d%=360;d/=60;S/=100;v/=100;C=v*S;x=C*(1-Math.abs(d%2-1));M=v-C;k=0;l=0;m=0;i=Math.floor(d);switch(i){case 0:k=C;l=x;break;case 1:k=x;l=C;break;case 2:l=C;m=x;break;case 3:l=x;m=C;break;case 4:k=x;m=C;break;case 5:k=C;m=x;break;default:k=0;m=0;l=0;break;}this.RGB.r=Math.floor((k+M)*255);this.RGB.g=Math.floor((l+M)*255);this.RGB.b=Math.floor((m+M)*255);};
f.prototype._calculateRGBAdvanced=function(d,S,l){var k,m,n,M,o,x,p,D,i;d=this._getValueInRange(d,0,360);if(S>100){S=1;}else if(S<0){S=0;}else{S=S/100;}if(l>100){l=1;}else if(l<0){l=0;}else{l=l/100;}D=S*(1-Math.abs(2*l-1));p=255*(l-0.5*D);x=D*(1-Math.abs((d/60)%2-1));i=Math.floor(d/60);o=p+255*x;M=p+255*D;switch(i){case 0:k=M;m=o;n=p;break;case 1:k=o;m=M;n=p;break;case 2:k=p;m=M;n=o;break;case 3:k=p;m=o;n=M;break;case 4:k=o;m=p;n=M;break;case 5:k=M;m=p;n=o;break;default:k=0;m=0;n=0;break;}this.RGB.r=Math.round(k);this.RGB.g=Math.round(m);this.RGB.b=Math.round(n);};
f.prototype._getCSSColorString=function(){if(this.Color.formatHSL){if(this.Color.a<1){return"hsla("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%, "+this.Color.a+")";}else{return"hsl("+this.Color.h+","+this.Color.s+"%,"+this.Color.l+"%)";}}if(this.Color.a<1){return"rgba("+this.Color.r+","+this.Color.g+","+this.Color.b+", "+this.Color.a+")";}else{return"rgb("+this.Color.r+","+this.Color.g+","+this.Color.b+")";}};
f.prototype._calculateHEX=function(i,d,k){var l=i.toString(16),m=d.toString(16),n=k.toString(16);if(l.length===1){l='0'+l;}if(m.length===1){m='0'+m;}if(n.length===1){n='0'+n;}this.sHexString=(l+m+n).toLowerCase();};
f.prototype._calculateHSV=function(i,d,k){var m=Math.max(Math.max(i,d),k),l=Math.min(Math.min(i,d),k),n=m-l,v=Math.round(m*100/255),o=m===0.0?0:(100*n/m),p=0;if(o===0){p=0;}else if(i===m){p=60.0*(d-k)/n;}else if(d===m){p=120.0+60.0*(k-i)/n;}else if(k===m){p=240.0+60.0*(i-d)/n;}if(p<0.0){p+=359.9;}p=Math.round(p);o=Math.round(o);this.Color.h=p;this.Color.s=o;this.Color.v=v;};
f.prototype._calculateHSL=function(i,k,l){var m=Math.max(i,k,l),n=Math.min(i,k,l),d=(m-n)/255,o=(m+n)/510,p=1-Math.abs(2*o-1),t=(o===0.0)?0:d/p,u=(p!==0)?t:0,v=0;o=Math.round(o*100);u=Math.round(u*100);if(o===0||u===0||(i+k+l===765)){v=0;}else{var C=m-n;if(m===i){v=((k-l)/C)%6;}if(m===k){v=(l-i)/C+2;}if(m===l){v=(i-k)/C+4;}if(C===0){v=0;}v*=60;if(v<0){v+=360;}}this.Color.h=Math.round(v);this.Color.s=u;this.Color.l=o;};
f.prototype._convertRGB=function(d){this.Color.r=parseInt(d.substr(0,2),16);this.Color.g=parseInt(d.substr(2,2),16);this.Color.b=parseInt(d.substr(4,2),16);};
f.prototype._updateGradientBoxBackground=function(i){if(this._bHSLMode){this._calculateRGBAdvanced(i,100,50);}else{this._calculateRGB(i,100,100);}this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.$CPBox.css('background-color','rgb('+[this.RGB.r,this.RGB.g,this.RGB.b].join(",")+')');};
f.prototype._updateSelColorBackground=function(){this.$("ncBox").css('background-color',this._getCSSColorString());};
f.prototype._parseColorString=function(C,d){var i;if(C.substr(0,1)==='#'){C=C.substr(1);}C=C.trim().toLowerCase();i=this._parseColorName(C);if(i){if(d){return true;}if(i.length===8){this.Color.a=this.Color.oldA=Number((parseInt(i.substr(6,2),16)/255).toFixed(2));i=i.substring(0,6);}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false;}return true;}if(/^([0-9a-fA-F]{3}|[0-9a-fA-F]{6})$/.test(C)){if(d){return true;}if(C.length===3){i=C[0]+C[0]+C[1]+C[1]+C[2]+C[2];}else{i=C;}this._processHexChanges(i);this.Color.old=this.Color.hex;if(this._bHSLMode){this.Color.formatHSL=false;}return true;}if(C.substr(0,3)==='rgb'){return this._parseRGB(C,d);}if(this._bHSLMode){return this._parseHSL(C,d);}else if(C.substr(0,3)==='hsv'){return this._parseHSV(C,d);}return false;};
f.prototype._parseHSV=function(C,d){var i=/^(((\d{1,2})|([1,2]\d{2})|(3[0-5]\d)|(360)),)(((\d{1,2})|(100)),)((\d{1,2})|(100))$/,k,l,S,v;C=C.substr(3).replace("(",'').replace(")",'').split(' ').join('');if(i.test(C)===true){if(d){return true;}k=C.split(",");l=parseInt(k[0],10);S=parseInt(k[1],10);v=parseInt(k[2],10);this._calculateRGB(l,S,v);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=l;this.Color.s=S;this.Color.v=v;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;return true;}return false;};
f.prototype._parseHSL=function(C,d){var i,k=C.substr(0,4),l,m,S,n,A;if(k==="hsla"){l=true;}else if(k==="hsl("){l=false;}else{return false;}C=C.substr(l?4:3).replace("(",'').replace(")",'').split(' ').join('');i=C.split(",");m=parseInt(i[0],10);S=parseFloat(i[1]);n=parseFloat(i[2]);if(l){A=parseFloat(i[3]);}else{if(i[3]&&parseFloat(i[3])>=0){return false;}A=1;}S=(S<1&&S>0)?S*100:S;n=(n<1&&n>0)?n*100:n;if((m>=0&&m<=360)&&(S>=0&&S<=100)&&(n>=0&&n<=100)&&(A>=0&&A<=1)){if(d){return true;}this._calculateRGB(m,S,n);this._calculateHEX(this.RGB.r,this.RGB.g,this.RGB.b);this.Color.r=this.RGB.r;this.Color.g=this.RGB.g;this.Color.b=this.RGB.b;this.Color.h=m;this.Color.s=S;this.Color.l=n;this.Color.hex="#"+this.sHexString;this.Color.old=this.Color.hex;this.Color.a=this.Color.oldA=A;this.Color.formatHSL=true;}else{return false;}return true;};
f.prototype._parseRGB=function(C,d){var v,i,k,l;i=C.substring(0,4);if(i==="rgba"){l=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),)([0]|([0]\.[0-9]+)|(\.[0-9]+)|[1])$/;k=true;}else if(i.substring(0,3)==="rgb"){l=/^(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])),){2}(((\d{1,2})|(1\d{2})|(2[0-4]\d)|(25[0-5])))$/;k=false;}else{return false;}C=C.substr(k?4:3).replace("(",'').replace(")",'').split(' ').join('');if(l.test(C)){if(d){return true;}v=C.split(",");this._calculateHEX(parseInt(v[0],10),parseInt(v[1],10),parseInt(v[2],10));this._processHexChanges(this.sHexString);this.Color.old=this.Color.hex;if(k){this.Color.a=this.Color.oldA=parseFloat(v[3]);}return true;}if(this._bHSLMode){this.Color.formatHSL=false;}return false;};
f.prototype._parseColorName=function(C){return g.Colors[C];};
f.prototype.onAfterRendering=function(){var d=this._getCSSColorString();this.$CPBox=this.oCPBox.$();this.$CPCur=this.oCPBox.getHandle();this.$("ncBox").css('background-color',d);this.$("ocBox").css('background-color',d);this._updateGradientBoxBackground(this.Color.h);this._iCPBoxSize=this.oCPBox.getWidth();this._updateCursorPosition();if(this._bHSLMode){this._updateAlphaBackground();}this.oSlider.iShiftGrip=Math.round(q(this.oSlider.oGrip).outerWidth()/2);this.oAlphaSlider.iShiftGrip=Math.round(q(this.oAlphaSlider.oGrip).outerWidth()/2);};
f.prototype.getRGB=function(){return{r:this.Color.r,g:this.Color.g,b:this.Color.b};};
f.prototype._getConstants=function(){return g;};
return f;},true);
sap.ui.predefine('sap/ui/unified/ColorPickerRenderer',['jquery.sap.global'],function(q){"use strict";var C={};
C.render=function(r,c){r.write("<div");r.writeControlData(c);r.writeClasses();r.write(">");r.renderControl(c.getAggregation("_grid"));r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/ContentSwitcher',['jquery.sap.global','sap/ui/core/Control','./library'],function(q,C,l){"use strict";
var a=C.extend("sap.ui.unified.ContentSwitcher",{metadata:{deprecated:true,library:"sap.ui.unified",properties:{animation:{type:"string",group:"Appearance",defaultValue:'None'},activeContent:{type:"int",group:"Behavior",defaultValue:1}},aggregations:{content1:{type:"sap.ui.core.Control",multiple:true,singularName:"content1"},content2:{type:"sap.ui.core.Control",multiple:true,singularName:"content2"}}}});
(function(w){
a.prototype.init=function(){};
a.prototype.switchContent=function(){this.setActiveContent(this.getActiveContent()==1?2:1);return this;};
a.prototype.onAfterRendering=function(){this._$Contents=[this.$("content1"),this.$("content2")];};
a.prototype._showActiveContent=function(n){if(this._$Contents){this._$Contents[0].toggleClass("sapUiUfdCSwitcherVisible",n===1);this._$Contents[1].toggleClass("sapUiUfdCSwitcherVisible",n===2);}};
a.prototype.setActiveContent=function(n){n=parseInt(n,10);if(isNaN(n)||n<1){n=1;q.sap.log.warning("setActiveContent argument must be either 1 or 2. Active content set to 1.");}else if(n>2){n=2;q.sap.log.warning("setActiveContent argument must be either 1 or 2. Active content set to 2.");}this.setProperty("activeContent",n,true);this._showActiveContent(n);return this;};
a.prototype.setAnimation=function(A,s){if(typeof(A)!=="string"){A=sap.ui.unified.ContentSwitcherAnimation.None;q.sap.log.warning("setAnimation argument must be a string. Animation was set to \""+sap.ui.unified.ContentSwitcherAnimation.None+"\".");}A=A.replace(/[^a-zA-Z0-9]/g,"");var c=this.getProperty("animation");if(A===c){return this;}var d=this.$();if(d[0]){d.toggleClass("sapUiUfdCSwitcherAnimation"+c,false);d.toggleClass("sapUiUfdCSwitcherAnimation"+A,true);}return this.setProperty("animation",A,s);};
})(window);return a;},true);
sap.ui.predefine('sap/ui/unified/ContentSwitcherRenderer',['jquery.sap.global'],function(q){"use strict";var C={};
C.render=function(r,c){var i=c.getId();var a=c.getAnimation();if(!sap.ui.getCore().getConfiguration().getAnimation()){a=sap.ui.unified.ContentSwitcherAnimation.None;}var A=c.getActiveContent();r.write("<div");r.writeControlData(c);r.addClass("sapUiUfdCSwitcher");r.addClass("sapUiUfdCSwitcherAnimation"+q.sap.encodeHTML(a));r.writeClasses();r.write(">");r.write("<section id=\""+i+"-content1\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent1"+(A==1?" sapUiUfdCSwitcherVisible":"")+"\">");this.renderContent(r,c.getContent1());r.write("</section>");r.write("<section id=\""+i+"-content2\" class=\"sapUiUfdCSwitcherContent sapUiUfdCSwitcherContent2"+(A==2?" sapUiUfdCSwitcherVisible":"")+"\">");this.renderContent(r,c.getContent2());r.write("</section>");r.write("</div>");};
C.renderContent=function(r,c){for(var i=0;i<c.length;++i){r.renderControl(c[i]);}};
return C;},true);
sap.ui.predefine('sap/ui/unified/Currency',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/format/NumberFormat'],function(q,C,L,N){"use strict";
var a=C.extend("sap.ui.unified.Currency",{metadata:{library:"sap.ui.unified",properties:{value:{type:"float",group:"Appearance",defaultValue:0},currency:{type:"string",group:"Appearance",defaultValue:null},maxPrecision:{type:"int",group:"Appearance",defaultValue:3},useSymbol:{type:"boolean",group:"Appearance",defaultValue:true}}}});
a.FIGURE_SPACE='\u2007';a.PUNCTUATION_SPACE='\u2008';
a.prototype.init=function(){this._oFormat=N.getCurrencyInstance({showMeasure:false});};
a.prototype.exit=function(){this._oFormat=null;this._$Value=null;this._$Currency=null;this._sLastCurrency=null;this._iLastCurrencyDigits=null;this._bRenderNoValClass=null;};
a.prototype.onAfterRendering=function(){if(this.$()){this._$Value=this.$().find(".sapUiUfdCurrencyValue");this._$Currency=this.$().find(".sapUiUfdCurrencyCurrency");}};
a.prototype.setValue=function(v){if(this.isBound("value")){this._bRenderNoValClass=v==null;if(this.$()){this.$().toggleClass("sapUiUfdCurrencyNoVal",this._bRenderNoValClass);}}this.setProperty("value",v,true);this._renderValue();return this;};
a.prototype.unbindProperty=function(p){C.prototype.unbindProperty.apply(this,arguments);if(p==="value"){this._bRenderNoValClass=false;if(this.$()){this.$().toggleClass("sapUiUfdCurrencyNoVal",false);}}};
a.prototype.setCurrency=function(v){var c,r;this.setProperty("currency",v,true);this._renderCurrency();c=this._oFormat.oLocaleData.getCurrencyDigits(v);if(q.isNumeric(this._iLastCurrencyDigits)&&this._iLastCurrencyDigits!==c){r=true;}this._iLastCurrencyDigits=c;if(this._sLastCurrency==="*"||v==="*"){r=true;}this._sLastCurrency=v;if(r){this._renderValue();if(v==="*"&&this.$()){this._bRenderNoValClass=false;this.$().toggleClass("sapUiUfdCurrencyNoVal",false);}}return this;};
a.prototype.setUseSymbol=function(v){this.setProperty("useSymbol",v,true);this._renderCurrency();return this;};
a.prototype.setMaxPrecision=function(v){this.setProperty("maxPrecision",v,true);this._renderValue();return this;};
a.prototype._renderValue=function(){if(this._$Value){this._$Value.text(this.getFormattedValue());}};
a.prototype._renderCurrency=function(){if(this._$Currency){this._$Currency.text(this._getCurrency());}};
a.prototype._getCurrency=function(){return this.getUseSymbol()?this.getCurrencySymbol():this.getCurrency();};
a.prototype.getFormattedValue=function(){var c=this.getCurrency(),m,p,i,f;if(c==="*"){return"";}i=this._oFormat.oLocaleData.getCurrencyDigits(c);m=this.getMaxPrecision();m=(m<=0&&i>0?m-1:m);p=m-i;f=this._oFormat.format(this.getValue(),c);if(p==m&&m>0){f+=a.PUNCTUATION_SPACE;}if(p>0){f=q.sap.padRight(f,a.FIGURE_SPACE,f.length+p);}else if(p<0){f=f.substr(0,f.length+p);}return f;};
a.prototype.getCurrencySymbol=function(){return this._oFormat.oLocaleData.getCurrencySymbol(this.getCurrency());};
a.prototype.getAccessibilityInfo=function(){if(this._bRenderNoValClass){return{};}return{description:(this.getFormattedValue()||"")+" "+(this.getCurrency()||"").trim()};};
return a;},true);
sap.ui.predefine('sap/ui/unified/CurrencyRenderer',['jquery.sap.global'],function(q){"use strict";var C={};
C.render=function(r,c){var t=c.getTooltip_AsString();r.write("<div");r.writeControlData(c);if(t){r.writeAttributeEscaped("title",t);}r.addClass("sapUiUfdCurrency");if(c._bRenderNoValClass){r.addClass("sapUiUfdCurrencyNoVal");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapUiUfdCurrencyAlign");r.writeClasses();r.write(">");r.write("<span");r.writeAttribute("dir","ltr");r.addClass("sapUiUfdCurrencyValue");r.writeClasses();r.write(">");r.writeEscaped(c.getFormattedValue());r.write("</span>");r.write("<span");r.addClass("sapUiUfdCurrencyCurrency");r.writeClasses();r.write(">");r.writeEscaped(c._getCurrency());r.write("</span>");r.write("</div>");r.write("</div>");};
return C;},true);
sap.ui.predefine('sap/ui/unified/DateRange',['jquery.sap.global','sap/ui/core/Element','./library','sap/ui/unified/calendar/CalendarUtils'],function(q,E,l,C){"use strict";
var D=E.extend("sap.ui.unified.DateRange",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Misc",defaultValue:null},endDate:{type:"object",group:"Misc",defaultValue:null}}}});
D.prototype.setStartDate=function(d){if(d){C._checkJSDateObject(d);var y=d.getFullYear();C._checkYearInValidRange(y);}this.setProperty("startDate",d);return this;};
D.prototype.setEndDate=function(d){if(d){C._checkJSDateObject(d);var y=d.getFullYear();C._checkYearInValidRange(y);}this.setProperty("endDate",d);return this;};
return D;},true);
sap.ui.predefine('sap/ui/unified/DateTypeRange',['jquery.sap.global','./DateRange','./library'],function(q,D,l){"use strict";
var a=D.extend("sap.ui.unified.DateTypeRange",{metadata:{library:"sap.ui.unified",properties:{type:{type:"sap.ui.unified.CalendarDayType",group:"Appearance",defaultValue:sap.ui.unified.CalendarDayType.Type01}}}});
return a;},true);
sap.ui.predefine('sap/ui/unified/FileUploader',['jquery.sap.global','sap/ui/core/Control','./library','sap/ui/core/LabelEnablement'],function(q,C,a,L){"use strict";
var F=C.extend("sap.ui.unified.FileUploader",{metadata:{interfaces:["sap.ui.core.IFormContent"],library:"sap.ui.unified",properties:{value:{type:"string",group:"Data",defaultValue:''},enabled:{type:"boolean",group:"Behavior",defaultValue:true},uploadUrl:{type:"sap.ui.core.URI",group:"Data",defaultValue:''},name:{type:"string",group:"Data",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:''},uploadOnChange:{type:"boolean",group:"Behavior",defaultValue:false},additionalData:{type:"string",group:"Data",defaultValue:null},sameFilenameAllowed:{type:"boolean",group:"Behavior",defaultValue:false},buttonText:{type:"string",group:"Misc",defaultValue:null},fileType:{type:"string[]",group:"Data",defaultValue:null},multiple:{type:"boolean",group:"Behavior",defaultValue:false},maximumFileSize:{type:"float",group:"Data",defaultValue:null},mimeType:{type:"string[]",group:"Data",defaultValue:null},sendXHR:{type:"boolean",group:"Behavior",defaultValue:false},placeholder:{type:"string",group:"Appearance",defaultValue:null},style:{type:"string",group:"Appearance",defaultValue:null},buttonOnly:{type:"boolean",group:"Appearance",defaultValue:false},useMultipart:{type:"boolean",group:"Behavior",defaultValue:true},maximumFilenameLength:{type:"int",group:"Data",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Data",defaultValue:sap.ui.core.ValueState.None},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconHovered:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconSelected:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''},iconFirst:{type:"boolean",group:"Appearance",defaultValue:true},iconOnly:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{parameters:{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"parameter"},headerParameters:{type:"sap.ui.unified.FileUploaderParameter",multiple:true,singularName:"headerParameter"}},events:{change:{parameters:{newValue:{type:"string"},files:{type:"object[]"}}},uploadComplete:{parameters:{fileName:{type:"string"},response:{type:"string"},readyStateXHR:{type:"string"},status:{type:"string"},responseRaw:{type:"string"},headers:{type:"object"},requestHeaders:{type:"object[]"}}},typeMissmatch:{parameters:{fileName:{type:"string"},fileType:{type:"string"},mimeType:{type:"string"}}},fileSizeExceed:{parameters:{fileName:{type:"string"},fileSize:{type:"string"}}},fileAllowed:{},uploadProgress:{parameters:{lengthComputable:{type:"boolean"},loaded:{type:"float"},total:{type:"float"},fileName:{type:"string"},requestHeaders:{type:"object[]"}}},uploadAborted:{parameters:{fileName:{type:"string"},requestHeaders:{type:"object[]"}}},filenameLengthExceed:{parameters:{fileName:{type:"string"}}},uploadStart:{parameters:{fileName:{type:"string"},requestHeaders:{type:"object[]"}}}}}});
F.prototype.init=function(){this.oFilePath=sap.ui.unified.FileUploaderHelper.createTextField(this.getId()+"-fu_input");this.oBrowse=sap.ui.unified.FileUploaderHelper.createButton();this.oFilePath.setParent(this);this.oBrowse.setParent(this);this.oFileUpload=null;this.bMobileLib=this.oBrowse.getMetadata().getName()=="sap.m.Button";if(!this.getIconOnly()){this.oBrowse.setText(this.getBrowseText());}else{this.oBrowse.setTooltip(this.getBrowseText());}if(sap.ui.getCore().getConfiguration().getAccessibility()){if(!F.prototype._sAccText){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");F.prototype._sAccText=r.getText("FILEUPLOAD_ACC");}if(this.oBrowse.addAriaDescribedBy){this.oBrowse.addAriaDescribedBy(this.getId()+"-AccDescr");}}};
F.prototype.setButtonText=function(t){this.setProperty("buttonText",t,false);if(!this.getIconOnly()){this.oBrowse.setText(t||this.getBrowseText());}else{this.oBrowse.setTooltip(t||this.getBrowseText());}return this;};
F.prototype.setIcon=function(i){this.oBrowse.setIcon(i);this.setProperty("icon",i,false);return this;};
F.prototype.setIconHovered=function(i){this.setProperty("iconHovered",i,false);if(this.oBrowse.setIconHovered){this.oBrowse.setIconHovered(i);}return this;};
F.prototype.setIconSelected=function(i){this.setProperty("iconSelected",i,false);if(this.oBrowse.setIconSelected){this.oBrowse.setIconSelected(i);}else{this.oBrowse.setActiveIcon(i);}return this;};
F.prototype.setIconFirst=function(i){this.oBrowse.setIconFirst(i);this.setProperty("iconFirst",i,false);return this;};
F.prototype.setIconOnly=function(i){this.setProperty("iconOnly",i,false);if(i){this.oBrowse.setText("");this.oBrowse.setTooltip(this.getButtonText()||this.getBrowseText());}else{this.oBrowse.setText(this.getButtonText()||this.getBrowseText());this.oBrowse.setTooltip("");}return this;};
F.prototype.getIdForLabel=function(){return this.oBrowse.getId();};
F.prototype.setFileType=function(t){var T=this._convertTypesToArray(t);this.setProperty("fileType",T,false);return this;};
F.prototype.setMimeType=function(t){var T=this._convertTypesToArray(t);this.setProperty("mimeType",T,false);return this;};
F.prototype.setTooltip=function(t){this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(this.oFileUpload){if(typeof t==="string"){q(this.oFileUpload).attr("title",q.sap.encodeHTML(t));this.$().find(".sapUiFupInputMask").attr("title",q.sap.encodeHTML(t));}}return this;};
F.prototype._convertTypesToArray=function(t){if(typeof t==="string"){if(t===""){return[];}else{return t.split(",");}}return t;};
F.prototype.exit=function(){this.oFilePath.destroy();this.oBrowse.destroy();if(this.oIFrameRef){q(this.oIFrameRef).unbind();sap.ui.getCore().getStaticAreaRef().removeChild(this.oIFrameRef);this.oIFrameRef=null;}};
F.prototype.onBeforeRendering=function(){var s=sap.ui.getCore().getStaticAreaRef();q(this.oFileUpload).appendTo(s);q(this.oFileUpload).unbind();};
F.prototype.onAfterRendering=function(){this.prepareFileUploadAndIFrame();this._cacheDOMEls();this._addLabelFeaturesToBrowse();q(this.oFileUpload).change(q.proxy(this.handlechange,this));if(!this.bMobileLib){this.oFilePath.$().attr("tabindex","-1");}else{this.oFilePath.$().find('input').attr("tabindex","-1");}if((!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version==9)){this.oBrowse.$().attr("tabindex","-1");}if(L.isRequired(this)){this.oBrowse.$().attr("aria-required","true");}q.sap.delayedCall(0,this,this._recalculateWidth);this.oFilePath.$().find('input').removeAttr("role").attr("aria-live","polite");if(this.getValueState()==sap.ui.core.ValueState.Error){this.oBrowse.$().attr("aria-invalid","true");}};
F.prototype._cacheDOMEls=function(){this.FUEl=this.getDomRef("fu");this.FUDataEl=this.getDomRef("fu_data");};
F.prototype.onfocusin=function(e){if(!this.oFilePath.shouldValueStateMessageBeOpened||this.oFilePath.shouldValueStateMessageBeOpened()){this.openValueStateMessage();}};
F.prototype.onsapfocusleave=function(e){if(!e.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(e.relatedControlId).getFocusDomRef())){this.closeValueStateMessage();}};
F.prototype._recalculateWidth=function(){if(this.getWidth()){if(this.getButtonOnly()&&this.oBrowse.getDomRef()){this.oBrowse.getDomRef().style.width=this.getWidth();}this._resizeDomElements();}};
F.prototype.getFocusDomRef=function(){return this.$("fu").get(0);};
F.prototype._resizeDomElements=function(){var i=this.getId();this._oBrowseDomRef=this.oBrowse.getDomRef();var $=q(this._oBrowseDomRef);var _=$.parent().outerWidth(true);this._oFilePathDomRef=this.oFilePath.getDomRef();var d=this._oFilePathDomRef;var w=this.getWidth();if(w.substr(-1)=="%"&&d){while(d.id!=i){d.style.width="100%";d=d.parentNode;}d.style.width=w;}else{if(d){d.style.width=w;var b=q(this._oFilePathDomRef);var c=b.outerWidth()-_;if(c<0){this.oFilePath.getDomRef().style.width="0px";if(!sap.ui.Device.browser.internet_explorer){this.oFileUpload.style.width=$.outerWidth(true);}}else{this.oFilePath.getDomRef().style.width=c+"px";}}}};
F.prototype.onresize=function(){this._recalculateWidth();};
F.prototype.onThemeChanged=function(){this._recalculateWidth();};
F.prototype.setEnabled=function(e){var $=q(this.oFileUpload);this.setProperty("enabled",e,true);this.oFilePath.setEnabled(e);this.oBrowse.setEnabled(e);e?$.removeAttr('disabled'):$.attr('disabled','disabled');this.$().toggleClass("sapUiFupDisabled",!e);return this;};
F.prototype.setValueState=function(v){this.setProperty("valueState",v,true);if(this.oFilePath.setValueState){this.oFilePath.setValueState(v);}if(this.oBrowse.getDomRef()){if(v==sap.ui.core.ValueState.Error){this.oBrowse.$().attr("aria-invalid","true");}else{this.oBrowse.$().removeAttr("aria-invalid");}}if(q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){switch(v){case sap.ui.core.ValueState.Error:case sap.ui.core.ValueState.Warning:case sap.ui.core.ValueState.Success:this.openValueStateMessage();break;default:this.closeValueStateMessage();}}return this;};
F.prototype.setUploadUrl=function(v,f){this.setProperty("uploadUrl",v,true);var $=this.$("fu_form");$.attr("action",this.getUploadUrl());return this;};
F.prototype.setPlaceholder=function(p){this.setProperty("placeholder",p,true);this.oFilePath.setPlaceholder(p);return this;};
F.prototype.setStyle=function(s){this.setProperty("style",s,true);if(s){if(s=="Transparent"){if(this.oBrowse.setLite){this.oBrowse.setLite(true);}else{this.oBrowse.setType("Transparent");}}else{if(this.oBrowse.setType){this.oBrowse.setType(s);}else{if(s=="Emphasized"){s="Emph";}this.oBrowse.setStyle(s);}}}return this;};
F.prototype.setValue=function(v,f,s){var o=this.getValue();var b;if((o!=v)||this.getSameFilenameAllowed()){var u=this.getUploadOnChange()&&v;this.setProperty("value",v,u);if(this.oFilePath){this.oFilePath.setValue(v);if(this.oBrowse.getDomRef()&&!s&&q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){this.oBrowse.focus();}}var c=this.getDomRef("fu_form"),d=this.getDomRef("fu_input-inner");if(this.oFileUpload&&c&&!v){c.reset();this.getDomRef("fu_input").value="";if(d){d.value="";}q(this.FUDataEl).val(this.getAdditionalData());}if(f){if(window.File){b=this.FUEl.files;}if(!this.getSameFilenameAllowed()||v){this.fireChange({id:this.getId(),newValue:v,files:b});}}if(u){this.upload();}}return this;};
F.prototype.clear=function(){var u=this.getDomRef("fu_form");if(u){u.reset();}return this.setValue("",false,true);};
F.prototype.ontap=function(){if(this.getEnabled()&&this.getVisible()){this.FUEl.click();}};
F.prototype.onmousedown=function(e){if(!this.bMobileLib){this.oBrowse.onmousedown(e);}};
F.prototype.onmouseup=function(e){if(!this.bMobileLib){this.oBrowse.onmouseup(e);}};
F.prototype.onmouseover=function(e){if(!this.bMobileLib){q(this.oBrowse.getDomRef()).addClass('sapUiBtnStdHover');this.oBrowse.onmouseover(e);}};
F.prototype.onmouseout=function(e){if(!this.bMobileLib){q(this.oBrowse.getDomRef()).removeClass('sapUiBtnStdHover');this.oBrowse.onmouseout(e);}};
F.prototype.setAdditionalData=function(A){this.setProperty("additionalData",A,true);var o=this.FUDataEl;if(o){A=this.getAdditionalData()||"";o.value=A;}return this;};
F.prototype.sendFiles=function(x,I){var t=this;var A=true;for(var i=0;i<x.length;i++){if(!x[i].bPosted){A=false;break;}}if(A){if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){t.setValue("",true);}return;}var X=x[I];var f=X.file.name?X.file.name:"MultipartFile";if((sap.ui.Device.browser.edge||sap.ui.Device.browser.internet_explorer)&&X.file.type&&X.xhr.readyState==1){var c=X.file.type;X.xhr.setRequestHeader("Content-Type",c);X.requestHeaders.push({name:"Content-Type",value:c});}var r=X.requestHeaders;var p=function(P){var o={lengthComputable:!!P.lengthComputable,loaded:P.loaded,total:P.total};t.fireUploadProgress({"lengthComputable":o.lengthComputable,"loaded":o.loaded,"total":o.total,"fileName":f,"requestHeaders":r});};X.xhr.upload.addEventListener("progress",p);X.xhr.onreadystatechange=function(){var R;var s;var h={};var P;var H;var b;var d;d=X.xhr.readyState;var S=X.xhr.status;if(X.xhr.readyState==4){if(X.xhr.responseXML){R=X.xhr.responseXML.documentElement.textContent;}s=X.xhr.response;P=X.xhr.getAllResponseHeaders();if(P){H=P.split("\u000d\u000a");for(var i=0;i<H.length;i++){if(H[i]){b=H[i].indexOf("\u003a\u0020");h[H[i].substring(0,b)]=H[i].substring(b+2);}}}t.fireUploadComplete({"fileName":f,"headers":h,"response":R,"responseRaw":s,"readyStateXHR":d,"status":S,"requestHeaders":r});}t._bUploading=false;};if(X.xhr.readyState===0||X.bPosted){I++;t.sendFiles(x,I);}else{X.xhr.send(X.file);X.bPosted=true;I++;t.sendFiles(x,I);}};
F.prototype.upload=function(){if(!this.getEnabled()){return;}var u=this.getDomRef("fu_form");try{this._bUploading=true;if(this.getSendXHR()&&window.File){var f=this.FUEl.files;this._sendFilesWithXHR(f);}else if(u){u.submit();this._resetValueAfterUploadStart();}}catch(e){q.sap.log.error("File upload failed:\n"+e.message);}};
F.prototype.abort=function(h,v){if(!this.getUseMultipart()){var s=this._aXhr.length-1;for(var i=s;i>-1;i--){if(h&&v){for(var j=0;j<this._aXhr[i].requestHeaders.length;j++){var H=this._aXhr[i].requestHeaders[j].name;var V=this._aXhr[i].requestHeaders[j].value;if(H==h&&V==v){this._aXhr[i].xhr.abort();this.fireUploadAborted({"fileName":this._aXhr[i].fileName,"requestHeaders":this._aXhr[i].requestHeaders});this._aXhr.splice(i,1);q.sap.log.info("File upload aborted.");break;}}}else{this._aXhr[i].xhr.abort();this.fireUploadAborted({"fileName":this._aXhr[i].fileName,"requestHeaders":this._aXhr[i].requestHeaders});this._aXhr.splice(i,1);q.sap.log.info("File upload aborted.");}}}else if(this._uploadXHR&&this._uploadXHR.abort){this._uploadXHR.abort();this.fireUploadAborted({"fileName":null,"requestHeaders":null});q.sap.log.info("File upload aborted.");}};
F.prototype.onkeypress=function(e){this.onkeydown(e);};
F.prototype.onclick=function(e){if(this.getSameFilenameAllowed()&&this.getEnabled()){this.setValue("",true);}if(this.oBrowse.getDomRef()&&q.sap.containsOrEquals(this.getDomRef(),document.activeElement)){this.oBrowse.focus();}};
F.prototype.onkeydown=function(e){if(!this.getEnabled()){return;}if(this.getSameFilenameAllowed()&&this.getUploadOnChange()){this.setValue("",true);}var k=e.keyCode,b=q.sap.KeyCodes;if(k==b.DELETE||k==b.BACKSPACE){if(this.oFileUpload){this.setValue("",true);}}else if(k==b.SPACE||k==b.ENTER){if(!(!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=9)&&this.oFileUpload){this.oFileUpload.click();e.preventDefault();e.stopPropagation();}}else if(k!=b.TAB&&k!=b.SHIFT&&k!=b.F6&&k!=b.PAGE_UP&&k!=b.PAGE_DOWN&&k!=b.END&&k!=b.HOME&&k!=b.ARROW_LEFT&&k!=b.ARROW_UP&&k!=b.ARROW_RIGHT&&k!=b.ARROW_DOWN){e.preventDefault();e.stopPropagation();}};
F.prototype._isFilenameTooLong=function(f){var m=this.getMaximumFilenameLength();if(m!==0&&f.length>m){q.sap.log.info("The filename of "+f+" ("+f.length+" characters)  is longer than the maximum of "+m+" characters.");return true;}return false;};
F.prototype.handlechange=function(e){if(this.oFileUpload&&this.getEnabled()){var f=this.getFileType();var s='';var w,n,i,b;var u=this.getDomRef("fu_form");if(window.File){var c=e.target.files;if(this._areFilesAllowed(c)){this.fireFileAllowed();s=this._generateInputValue(c);}else{u.reset();this.setValue("",true,true);return;}}else if(f&&f.length>0){w=true;n=this.oFileUpload.value||"";i=n.lastIndexOf(".");b=n.substring(i+1);for(var l=0;l<f.length;l++){if(b==f[l]){w=false;}}if(w){q.sap.log.info("File: "+n+" is of type "+b+". Allowed types are: "+f+".");this.fireTypeMissmatch({fileName:n,fileType:b});u.reset();this.setValue("",true,true);return;}if(this._isFilenameTooLong(n)){this.fireFilenameLengthExceed({fileName:n});u.reset();this.setValue("",true,true);return;}if(n){this.fireFileAllowed();}}var v=this.oFileUpload.value||"";var I=v.lastIndexOf("\\");if(I>=0){v=v.substring(I+1);}if(this.getMultiple()){if(!(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=9)){v=s;}}if(v||sap.ui.Device.browser.chrome){this.setValue(v,true);}}};
F.prototype._sendFilesWithXHR=function(f){var b,h,v,x;if(f.length>0){if(this.getUseMultipart()){b=1;}else{b=f.length;}this._aXhr=this._aXhr||[];for(var j=0;j<b;j++){this._uploadXHR=new window.XMLHttpRequest();x={xhr:this._uploadXHR,requestHeaders:[]};this._aXhr.push(x);x.xhr.open("POST",this.getUploadUrl(),true);if(this.getHeaderParameters()){var H=this.getHeaderParameters();for(var i=0;i<H.length;i++){h=H[i].getName();v=H[i].getValue();x.requestHeaders.push({name:h,value:v});}}var s=f[j].name;var r=x.requestHeaders;x.fileName=s;x.file=f[j];this.fireUploadStart({"fileName":s,"requestHeaders":r});for(var k=0;k<r.length;k++){if(x.xhr.readyState===0){break;}h=r[k].name;v=r[k].value;x.xhr.setRequestHeader(h,v);}}if(this.getUseMultipart()){var c=new window.FormData();var n=this.FUEl.name;for(var l=0;l<f.length;l++){c.append(n,f[l]);}c.append("_charset_","UTF-8");var d=this.FUDataEl.name;if(this.getAdditionalData()){var D=this.getAdditionalData();c.append(d,D);}else{c.append(d,"");}if(this.getParameters()){var p=this.getParameters();for(var m=0;m<p.length;m++){var N=p[m].getName();v=p[m].getValue();c.append(N,v);}}x.file=c;this.sendFiles(this._aXhr,0);}else{this.sendFiles(this._aXhr,0);}this._bUploading=false;this._resetValueAfterUploadStart();}return this;};
F.prototype._areFilesAllowed=function(f){var n,w,I,s,t,m=this.getMaximumFileSize(),M=this.getMimeType(),b=this.getFileType();for(var i=0;i<f.length;i++){n=f[i].name;t=f[i].type;if(!t){t="unknown";}var S=((f[i].size/1024)/1024);if(m&&(S>m)){q.sap.log.info("File: "+n+" is of size "+S+" MB which exceeds the file size limit of "+m+" MB.");this.fireFileSizeExceed({fileName:n,fileSize:S});return false;}if(this._isFilenameTooLong(n)){this.fireFilenameLengthExceed({fileName:n});return false;}if(M&&M.length>0){var W=true;for(var j=0;j<M.length;j++){if(t==M[j]||M[j]=="*/*"||t.match(M[j])){W=false;}}if(W){q.sap.log.info("File: "+n+" is of type "+t+". Allowed types are: "+M+".");this.fireTypeMissmatch({fileName:n,mimeType:t});return false;}}if(b&&b.length>0){w=true;I=n.lastIndexOf(".");s=n.substring(I+1);for(var k=0;k<b.length;k++){if(s.toLowerCase()==b[k].toLowerCase()){w=false;}}if(w){q.sap.log.info("File: "+n+" is of type "+s+". Allowed types are: "+b+".");this.fireTypeMissmatch({fileName:n,fileType:s});return false;}}}return true;};
F.prototype._sendFilesFromDragAndDrop=function(f){if(this._areFilesAllowed(f)){this._sendFilesWithXHR(f);}return this;};
F.prototype._generateInputValue=function(f){var s="";for(var i=0;i<f.length;i++){s=s+'"'+f[i].name+'" ';}return s;};
F.prototype.getBrowseText=function(){if(!F.prototype._sBrowseText){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");F.prototype._sBrowseText=r.getText("FILEUPLOAD_BROWSE");}return F.prototype._sBrowseText?F.prototype._sBrowseText:"Browse...";};
F.prototype.getShortenValue=function(){return this.getValue();};
F.prototype.prepareFileUploadAndIFrame=function(){if(!this.oFileUpload){var f=[];f.push('<input ');f.push('type="file" ');f.push('aria-hidden="true" ');if(this.getName()){if(this.getMultiple()){if(!(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=9)){f.push('name="'+this.getName()+'[]" ');}}else{f.push('name="'+this.getName()+'" ');}}else{if(this.getMultiple()){if(!(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=9)){f.push('name="'+this.getId()+'[]" ');}}else{f.push('name="'+this.getId()+'" ');}}f.push('id="'+this.getId()+'-fu" ');if(!(!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version==9)){f.push('tabindex="-1" ');}f.push('size="1" ');if(this.getTooltip_AsString()){f.push('title="'+q.sap.encodeHTML(this.getTooltip_AsString())+'" ');}else if(this.getValue()!==""){f.push('title="'+q.sap.encodeHTML(this.getValue())+'" ');}if(!this.getEnabled()){f.push('disabled="disabled" ');}if(this.getMultiple()){if(!(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=9)){f.push('multiple ');}}if(this.getMimeType()&&window.File){var m=this.getMimeType();var M=m.join(",");f.push('accept="'+M+'" ');}f.push('>');this.oFileUpload=q(f.join("")).prependTo(this.$().find(".sapUiFupInputMask")).get(0);}else{q(this.oFileUpload).prependTo(this.$().find(".sapUiFupInputMask"));}if(!this.oIFrameRef){var i=document.createElement("iframe");i.style.display="none";i.id=this.sId+"-frame";sap.ui.getCore().getStaticAreaRef().appendChild(i);i.contentWindow.name=this.sId+"-frame";var t=this;this._bUploading=false;q(i).load(function(e){if(t._bUploading){q.sap.log.info("File uploaded to "+t.getUploadUrl());var r;try{r=t.oIFrameRef.contentDocument.body.innerHTML;}catch(b){}t.fireUploadComplete({"response":r});t._bUploading=false;}});this.oIFrameRef=i;}};
F.prototype.openValueStateMessage=function(){if(this.oFilePath.openValueStateMessage){this.oFilePath.openValueStateMessage();this.oBrowse.$().addAriaDescribedBy(this.oFilePath.getId()+"-message");}};
F.prototype.closeValueStateMessage=function(){if(this.oFilePath.closeValueStateMessage){this.oFilePath.closeValueStateMessage();this.oBrowse.$().removeAriaDescribedBy(this.oFilePath.getId()+"-message");}};
F.prototype._resetValueAfterUploadStart=function(){q.sap.log.info("File uploading to "+this.getUploadUrl());if(this.getSameFilenameAllowed()&&this.getUploadOnChange()&&this.getUseMultipart()){this.setValue("",true);}};
F.prototype._addLabelFeaturesToBrowse=function(){var $;if(this.oBrowse&&this.oBrowse.$().length){$=this.oBrowse.$();$.attr("type', 'button");$.click(function(e){e.preventDefault();this.ontap();}.bind(this));}};
return F;},true);
sap.ui.predefine('sap/ui/unified/FileUploaderParameter',['jquery.sap.global','sap/ui/core/Element','./library'],function(q,E,l){"use strict";
var F=E.extend("sap.ui.unified.FileUploaderParameter",{metadata:{library:"sap.ui.unified",properties:{name:{type:"string",group:"Data",defaultValue:null},value:{type:"string",group:"Data",defaultValue:null}}}});
return F;},true);
sap.ui.predefine('sap/ui/unified/FileUploaderRenderer',['jquery.sap.global'],function(q){"use strict";var F=function(){};
F.render=function(r,f){var a=sap.ui.getCore().getConfiguration().getAccessibility(),e=f.getEnabled();r.write('<div');r.writeControlData(f);r.addClass("sapUiFup");if(f.getButtonOnly()){r.addClass("sapUiFupButtonOnly");}var c=sap.ui.unified.FileUploaderHelper.addFormClass();if(c){r.addClass(c);}if(!e){r.addClass("sapUiFupDisabled");}r.writeClasses();r.write('>');r.write('<form style="display:inline-block" encType="multipart/form-data" method="post"');r.writeAttribute('id',f.getId()+'-fu_form');r.writeAttributeEscaped('action',f.getUploadUrl());r.writeAttribute('target',f.getId()+'-frame');r.write('>');r.write('<div ');if(!f.bMobileLib){r.write('class="sapUiFupInp"');}if(a){r.writeAttribute("role","textbox");r.writeAttribute("aria-readonly","true");}r.write('>');if(!f.getButtonOnly()){r.write('<div class="sapUiFupGroup" border="0" cellPadding="0" cellSpacing="0"><div><div>');}else{r.write('<div class="sapUiFupGroup" border="0" cellPadding="0" cellSpacing="0"><div><div style="display:none">');}r.renderControl(f.oFilePath);r.write('</div><div>');r.renderControl(f.oBrowse);var A;var t="";if(f.getTooltip()){t=f.getTooltip_AsString();}var p="";if(f.getPlaceholder()){p=f.getPlaceholder();}var v="";if(f.getValue()){v=f.getValue();}var b="";if(f.getButtonText()){b=f.getButtonText();}else{b=f.getBrowseText();}if(!v){A=t+" "+p+" "+b;}else{A=t+" "+v+" "+b;}r.write('<span id="'+f.getId()+'-AccDescr" class="sapUiInvisibleText" aria-hidden="true">');r.writeEscaped(A+" "+f._sAccText);r.write('</span>');r.write('</div></div></div>');var n=f.getName()||f.getId();r.write('<div class="sapUiFupInputMask"');if(t.length){r.writeAttributeEscaped('title',t);}r.write('>');r.write('<input type="hidden" name="_charset_" aria-hidden="true">');r.write('<input type="hidden" id="'+f.getId()+'-fu_data" aria-hidden="true"');r.writeAttributeEscaped('name',n+'-data');r.writeAttributeEscaped('value',f.getAdditionalData()||"");r.write('>');q.each(f.getParameters(),function(i,P){r.write('<input type="hidden" aria-hidden="true" ');r.writeAttributeEscaped('name',P.getName()||"");r.writeAttributeEscaped('value',P.getValue()||"");r.write('>');});r.write('</div>');r.write('</div>');r.write('</form>');r.write('</div>');};
return F;},true);
sap.ui.predefine('sap/ui/unified/MenuItem',['jquery.sap.global','sap/ui/core/IconPool','./MenuItemBase','./library'],function(q,I,M,l){"use strict";
var a=M.extend("sap.ui.unified.MenuItem",{metadata:{library:"sap.ui.unified",properties:{text:{type:"string",group:"Appearance",defaultValue:''},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:''}}}});
I.getIconInfo("","");
a.prototype.render=function(r,i,m,o){var b=r;var s=i.getSubmenu();b.write("<li ");var c="sapUiMnuItm";if(o.iItemNo==1){c+=" sapUiMnuItmFirst";}else if(o.iItemNo==o.iTotalItems){c+=" sapUiMnuItmLast";}if(!m.checkEnabled(i)){c+=" sapUiMnuItmDsbl";}if(i.getStartsSection()){c+=" sapUiMnuItmSepBefore";}b.writeAttribute("class",c);if(i.getTooltip_AsString()){b.writeAttributeEscaped("title",i.getTooltip_AsString());}b.writeElementData(i);if(o.bAccessible){b.writeAccessibilityState(i,{role:"menuitem",disabled:!m.checkEnabled(i),posinset:o.iItemNo,setsize:o.iTotalItems,labelledby:{value:this.getId()+"-txt "+this.getId()+"-scuttxt",append:true}});if(s){b.writeAttribute("aria-haspopup",true);b.writeAttribute("aria-owns",s.getId());}}b.write("><div class=\"sapUiMnuItmL\"></div>");b.write("<div class=\"sapUiMnuItmIco\">");if(i.getIcon()){b.writeIcon(i.getIcon(),null,{title:null});}b.write("</div>");b.write("<div id=\""+this.getId()+"-txt\" class=\"sapUiMnuItmTxt\">");b.writeEscaped(i.getText());b.write("</div>");b.write("<div id=\""+this.getId()+"-scuttxt\" class=\"sapUiMnuItmSCut\"></div>");b.write("<div class=\"sapUiMnuItmSbMnu\">");if(s){b.write("<div class=\"sapUiIconMirrorInRTL\"></div>");}b.write("</div>");b.write("<div class=\"sapUiMnuItmR\"></div>");b.write("</li>");};
a.prototype.hover=function(h,m){this.$().toggleClass("sapUiMnuItmHov",h);};
return a;},true);
sap.ui.predefine('sap/ui/unified/MenuItemBase',['jquery.sap.global','sap/ui/core/Element','./library'],function(q,E,l){"use strict";
var M=E.extend("sap.ui.unified.MenuItemBase",{metadata:{library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},visible:{type:"boolean",group:"Behavior",defaultValue:true},startsSection:{type:"boolean",group:"Behavior",defaultValue:false}},defaultAggregation:"submenu",aggregations:{submenu:{type:"sap.ui.unified.Menu",multiple:false}},events:{select:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
M.prototype.init=function(){};
M.prototype.render=function(r,i,m){var a=r;a.write("<li");a.writeElementData(i);a.write("><div style=\"white-space:nowrap;display:inline-block;padding:1px;color:black;\" id=\""+this.getId()+"-txt\">");a.write(i.getId());if(this.getSubmenu()){a.write("&nbsp;&nbsp;->");}a.write("</div></li>");};
M.prototype.hover=function(h,m){this.$("txt").attr("style",h?"white-space:nowrap;display:inline-block;padding:1px;color:red;":"white-space:nowrap;display:inline-block;padding:1px;color:black;");};
M.prototype.onSubmenuToggle=function(o){this.$().toggleClass("sapUiMnuItmSubMnuOpen",o);};
M.prototype.onAfterRendering=function(){};
M.prototype.onmouseover=function(e){var p=this.getParent();if(p&&p instanceof sap.ui.unified.Menu&&this.getTooltip()instanceof sap.ui.core.TooltipBase){p.onmouseover(e);}};
return M;},true);
sap.ui.predefine('sap/ui/unified/MenuRenderer',['jquery.sap.global'],function(q){"use strict";var M={};
M.render=function(r,m){if(m.oHoveredItem&&m.indexOfItem(m.oHoveredItem)<0){m.oHoveredItem=null;}r.write("<div tabindex=\"-1\" hideFocus=\"true\"");if(m.getTooltip_AsString()){r.writeAttributeEscaped("title",m.getTooltip_AsString());}var a=sap.ui.getCore().getConfiguration().getAccessibility();if(a){r.writeAccessibilityState(m,{role:"menu",disabled:null,labelledby:{value:m.getId()+"-label",append:true}});if(m.oHoveredItem){r.writeAttribute("aria-activedescendant",m.oHoveredItem.getId());}}r.addClass("sapUiMnu");var R=m.getRootMenu();if(R.bUseTopStyle){r.addClass("sapUiMnuTop");}if(R.isCozy()){r.addClass("sapUiSizeCozy");}if(m.bCozySupported){r.addClass("sapUiMnuCozySupport");}r.writeClasses();r.writeControlData(m);r.write(">");M.renderItems(r,m);if(a){r.write("<span id='",m.getId(),"-label' class='sapUiInvisibleText' aria-hidden='true'>");r.writeEscaped(m.getAriaDescription()?m.getAriaDescription():"");r.write("</span>");}r.write("</div>");};
M.renderItems=function(r,m){var I=m.getItems();var a=sap.ui.getCore().getConfiguration().getAccessibility();r.write("<ul class=\"sapUiMnuLst");var h=false;var H=false;for(var b=0;b<I.length;b++){if(I[b].getIcon&&I[b].getIcon()){h=true;}if(I[b].getSubmenu()){H=true;}}if(!h){r.write(" sapUiMnuNoIco");}if(!H){r.write(" sapUiMnuNoSbMnu");}r.write("\">");var n=0;for(var i=0;i<I.length;i++){if(I[i].getVisible()&&I[i].render){n++;}}var c=0;for(var i=0;i<I.length;i++){var o=I[i];if(o.getVisible()&&o.render){c++;if(o.getStartsSection()){r.write("<li ");if(a){r.write("role=\"separator\" ");}r.write("class=\"sapUiMnuDiv\"><div class=\"sapUiMnuDivL\"></div><hr><div class=\"sapUiMnuDivR\"></div></li>");}o.render(r,o,m,{bAccessible:a,iItemNo:c,iTotalItems:n});}}r.write("</ul>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/MenuTextFieldItem',['jquery.sap.global','sap/ui/core/ValueStateSupport','./MenuItemBase','./library'],function(q,V,M,l){"use strict";
var a=M.extend("sap.ui.unified.MenuTextFieldItem",{metadata:{library:"sap.ui.unified",properties:{label:{type:"string",group:"Appearance",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},value:{type:"string",group:"Misc",defaultValue:null},valueState:{type:"sap.ui.core.ValueState",group:"Appearance",defaultValue:sap.ui.core.ValueState.None}}}});
(function(){
a.prototype.render=function(r,i,m,I){var b=r,c=m.checkEnabled(i),d=i.getId();var C="sapUiMnuItm sapUiMnuTfItm";if(I.iItemNo==1){C+=" sapUiMnuItmFirst";}else if(I.iItemNo==I.iTotalItems){C+=" sapUiMnuItmLast";}if(!m.checkEnabled(i)){C+=" sapUiMnuItmDsbl";}if(i.getStartsSection()){C+=" sapUiMnuItmSepBefore";}b.write("<li ");b.writeAttribute("class",C);b.writeElementData(i);if(I.bAccessible){b.writeAttribute("role","menuitem");b.writeAttribute("aria-disabled",!c);b.writeAttribute("aria-posinset",I.iItemNo);b.writeAttribute("aria-setsize",I.iTotalItems);}b.write("><div class=\"sapUiMnuItmL\"></div>");b.write("<div class=\"sapUiMnuItmIco\">");if(i.getIcon()){b.writeIcon(i.getIcon(),null,{title:null});}b.write("</div>");b.write("<div id=\""+d+"-txt\" class=\"sapUiMnuItmTxt\">");b.write("<label id=\""+d+"-lbl\" class=\"sapUiMnuTfItemLbl\">");b.writeEscaped(i.getLabel()||"");b.write("</label>");b.write("<div id=\""+d+"-str\" class=\"sapUiMnuTfItmStretch\"></div>");b.write("<div class=\"sapUiMnuTfItemWrppr\">");b.write("<input id=\""+d+"-tf\" tabindex=\"-1\"");b.writeAttributeEscaped("value",i.getValue()||"");b.writeAttribute("class",c?"sapUiMnuTfItemTf sapUiMnuTfItemTfEnbl":"sapUiMnuTfItemTf sapUiMnuTfItemTfDsbl");if(!c){b.writeAttribute("disabled","disabled");}if(I.bAccessible){b.writeAccessibilityState(i,{role:"textbox",disabled:!c,multiline:false,autocomplete:"none",labelledby:{value:d+"-lbl",append:true}});}b.write("/></div></div>");b.write("<div class=\"sapUiMnuItmR\"></div>");b.write("</li>");};
a.prototype.hover=function(h,m){this.$().toggleClass("sapUiMnuItmHov",h);if(h&&m.checkEnabled(this)){m.closeSubmenu(false,true);this.$("tf").focus();}};
a.prototype.onAfterRendering=function(){this._adaptSizes();this.setValueState(this.getValueState());};
a.prototype.onsapup=function(e){this.getParent().focus();this.getParent().onsapprevious(e);};
a.prototype.onsapdown=function(e){this.getParent().focus();this.getParent().onsapnext(e);};
a.prototype.onsaphome=function(e){if(this._checkCursorPosForNav(false)){this.getParent().focus();this.getParent().onsaphome(e);}};
a.prototype.onsapend=function(e){if(this._checkCursorPosForNav(true)){this.getParent().focus();this.getParent().onsapend(e);}};
a.prototype.onsappageup=function(e){this.getParent().focus();this.getParent().onsappageup(e);};
a.prototype.onsappagedown=function(e){this.getParent().focus();this.getParent().onsappagedown(e);};
a.prototype.onsapescape=function(e){this.getParent().onsapescape(e);};
a.prototype.onkeydown=function(e){e.stopPropagation();};
a.prototype.onclick=function(e){this.getParent().closeSubmenu(false,true);if(!sap.ui.Device.system.desktop&&this.getParent().checkEnabled(this)){this.focus();}e.stopPropagation();};
a.prototype.onkeyup=function(e){if(!q.sap.PseudoEvents.sapenter.fnCheck(e)){return;}var v=this.$("tf").val();this.setValue(v);this.getParent().selectItem(this);e.preventDefault();e.stopPropagation();};
a.prototype.setSubmenu=function(m){q.sap.log.warning("The aggregation 'submenu' is not supported for this type of menu item.","","sap.ui.unified.MenuTextFieldItem");return this;};
a.prototype.setLabel=function(L){this.setProperty("label",L,true);this.$("lbl").text(L);this._adaptSizes();return this;};
a.prototype.setValue=function(v){this.setProperty("value",v,true);this.$("tf").val(v);return this;};
a.prototype.setValueState=function(v){this.setProperty("valueState",v,true);var $=this.$("tf");$.toggleClass("sapUiMnuTfItemTfErr",v==sap.ui.core.ValueState.Error);$.toggleClass("sapUiMnuTfItemTfWarn",v==sap.ui.core.ValueState.Warning);var t=V.enrichTooltip(this,this.getTooltip_AsString());this.$().attr("title",t?t:"");return this;};
a.prototype.getFocusDomRef=function(){var f=this.$("tf");return f.length?f.get(0):null;};
a.prototype._adaptSizes=function(){var $=this.$("tf");var b=this.$("lbl");var o=b.length?b.get(0).offsetLeft:0;if(sap.ui.getCore().getConfiguration().getRTL()){$.parent().css({"width":"auto","right":(this.$().outerWidth(true)-o+(b.outerWidth(true)-b.outerWidth()))+"px"});}else{$.parent().css({"width":"auto","left":(o+b.outerWidth(true))+"px"});}};
a.prototype._checkCursorPosForNav=function(f){var r=sap.ui.getCore().getConfiguration().getRTL();var b=f?r:!r;var $=this.$("tf");var p=$.cursorPos();var L=$.val().length;if(r){p=L-p;}if((!b&&p!=L)||(b&&p!=0)){return false;}return true;};
}());return a;},true);
sap.ui.predefine('sap/ui/unified/Shell',['jquery.sap.global','./ShellHeader','./ShellLayout','./library'],function(q,S,a,l){"use strict";
var b=a.extend("sap.ui.unified.Shell",{metadata:{library:"sap.ui.unified",properties:{icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},showCurtain:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},showCurtainPane:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true},searchVisible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{curtainContent:{type:"sap.ui.core.Control",multiple:true,singularName:"curtainContent"},curtainPaneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"curtainPaneContent"},headItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true,singularName:"headItem"},headEndItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true,singularName:"headEndItem"},search:{type:"sap.ui.core.Control",multiple:false},user:{type:"sap.ui.unified.ShellHeadUserItem",multiple:false}}}});
b.prototype.init=function(){a.prototype.init.apply(this,arguments);this._header=new S(this.getId()+"-header");this.setHeader(this._header);};
b.prototype.exit=function(){a.prototype.exit.apply(this,arguments);this._header.destroy();delete this._header;};
b.prototype._getSearchWidth=function(){if(this._header===this.getHeader()&&this._header.getDomRef()){var s=this._header.$("hdr-center").children();if(s.length){return s.width();}}return-1;};
b.prototype.setIcon=function(i){this.setProperty("icon",i,true);this._header.setLogo(i);return this;};
b.prototype.getIcon=function(){return this._header.getLogo();};
b.prototype.setSearchVisible=function(s){this.setProperty("searchVisible",s,true);this._header.setSearchVisible(s);return this;};
b.prototype.getSearchVisible=function(){return this._header.getSearchVisible();};
b.prototype.setSearch=function(s){this._header.setSearch(s);return this;};
b.prototype.getSearch=function(){return this._header.getSearch();};
b.prototype.setUser=function(u){this._header.setUser(u);return this;};
b.prototype.getUser=function(){return this._header.getUser();};
b.prototype.getHeadItems=function(){return this._header.getHeadItems();};
b.prototype.insertHeadItem=function(h,i){this._header.insertHeadItem(h,i);return this;};
b.prototype.addHeadItem=function(h){this._header.addHeadItem(h);return this;};
b.prototype.removeHeadItem=function(i){return this._header.removeHeadItem(i);};
b.prototype.removeAllHeadItems=function(){return this._header.removeAllHeadItems();};
b.prototype.destroyHeadItems=function(){this._header.destroyHeadItems();return this;};
b.prototype.indexOfHeadtem=function(h){return this._header.indexOfHeadItem(h);};
b.prototype.getHeadEndItems=function(){return this._header.getHeadEndItems();};
b.prototype.insertHeadEndItem=function(h,i){this._header.insertHeadEndItem(h,i);return this;};
b.prototype.addHeadEndItem=function(h){this._header.addHeadEndItem(h);return this;};
b.prototype.removeHeadEndItem=function(i){return this._header.removeHeadEndItem(i);};
b.prototype.removeAllHeadEndItems=function(){return this._header.removeAllHeadEndItems();};
b.prototype.destroyHeadEndItems=function(){this._header.destroyHeadEndItems();return this;};
b.prototype.indexOfHeadEndItem=function(h){return this._header.indexOfHeadEndItem(h);};
b.prototype.setHeader=function(h){return a.prototype.setHeader.apply(this,[h?h:this._header]);};
b.prototype.destroyHeader=function(){if(this.getHeader()===this._header){return this;}return a.prototype.destroyHeader.apply(this,[]);};
return b;},true);
sap.ui.predefine('sap/ui/unified/ShellHeadItem',['jquery.sap.global','sap/ui/core/Element','sap/ui/core/IconPool','./library'],function(q,E,I,l){"use strict";
var S=E.extend("sap.ui.unified.ShellHeadItem",{metadata:{library:"sap.ui.unified",properties:{startsSection:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},showSeparator:{type:"boolean",group:"Appearance",defaultValue:true},selected:{type:"boolean",group:"Appearance",defaultValue:false},toggleEnabled:{type:"boolean",group:"Appearance",defaultValue:true},showMarker:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},icon:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null},visible:{type:"boolean",group:"Appearance",defaultValue:true}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
S.prototype.onclick=function(e){this.firePress();e.preventDefault();};
S.prototype.onsapspace=S.prototype.onclick;S.prototype.onsapenter=S.prototype.onclick;
S.prototype.setStartsSection=function(s){s=!!s;this.setProperty("startsSection",s,true);this.$().toggleClass("sapUiUfdShellHeadItmDelim",s);return this;};
S.prototype.setShowSeparator=function(s){s=!!s;this.setProperty("showSeparator",s,true);this.$().toggleClass("sapUiUfdShellHeadItmSep",s);return this;};
function _(){var t=this.$(),T=this.getToggleEnabled(),s=this.getSelected();if(!t.length){return;}if(T){t.toggleClass("sapUiUfdShellHeadItmSel",s);t.attr("aria-pressed",s);}else{t.removeClass("sapUiUfdShellHeadItmSel");t.removeAttr("aria-pressed");}}
S.prototype.setToggleEnabled=function(e){this.setProperty("toggleEnabled",!!e,true);_.apply(this);return this;};
S.prototype.setSelected=function(s){this.setProperty("selected",!!s,true);_.apply(this);return this;};
S.prototype.setVisible=function(v){this.setProperty("visible",!!v);return this;};
S.prototype.setShowMarker=function(m){m=!!m;this.setProperty("showMarker",m,true);this.$().toggleClass("sapUiUfdShellHeadItmMark",m);return this;};
S.prototype.setIcon=function(i){this.setProperty("icon",i,true);if(this.getDomRef()){this._refreshIcon();}return this;};
S.prototype._refreshIcon=function(){var i=q(this.$().children()[0]);var s=this.getIcon();if(I.isIconURI(s)){var o=I.getIconInfo(s);i.html("").css("style","");if(o){i.text(o.content).attr("role","presentation").attr("aria-label",o.text||o.name).css("font-family","'"+o.fontFamily+"'");}}else{var $=this.$("img-inner");if($.length==0||$.attr("src")!=s){i.css("style","").attr("aria-label",null).html("<img role='presentation' id='"+this.getId()+"-img-inner' src='"+q.sap.encodeHTML(s)+"'/>");}}};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellHeadUserItem',['jquery.sap.global','sap/ui/core/Element','sap/ui/core/IconPool','./library'],function(q,E,I,l){"use strict";
var S=E.extend("sap.ui.unified.ShellHeadUserItem",{metadata:{library:"sap.ui.unified",properties:{username:{type:"string",group:"Appearance",defaultValue:''},showPopupIndicator:{type:"boolean",group:"Accessibility",defaultValue:true},image:{type:"sap.ui.core.URI",group:"Appearance",defaultValue:null}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{press:{}}}});
I.getIconInfo("","");
S.prototype.onclick=function(e){this.firePress();e.preventDefault();};
S.prototype.onsapspace=S.prototype.onclick;S.prototype.onsapenter=S.prototype.onclick;
S.prototype.setImage=function(i){this.setProperty("image",i,true);if(this.getDomRef()){this._refreshImage();}return this;};
S.prototype._refreshImage=function(){var i=this.$("img");var s=this.getImage();if(!s){i.html("").css("style","").css("display","none");}else if(I.isIconURI(s)){var o=I.getIconInfo(s);i.html("").css("style","");if(o){i.text(o.content).attr("role","presentation").attr("aria-label",o.text||o.name).css("font-family","'"+o.fontFamily+"'");}}else{var $=this.$("img-inner");if($.length==0||$.attr("src")!=s){i.css("style","").attr("aria-label",null).html("<img role='presentation' id='"+this.getId()+"-img-inner' src='"+q.sap.encodeHTML(s)+"'/>");}}};
S.prototype._checkAndAdaptWidth=function(s){if(!this.getDomRef()){return false;}var r=this.$(),n=this.$("name");var b=r.width();r.toggleClass("sapUiUfdShellHeadUsrItmLimit",false);var m=240;if(s){m=Math.min(m,0.5*document.documentElement.clientWidth-225);}if(m<n.width()){r.toggleClass("sapUiUfdShellHeadUsrItmLimit",true);}return b!=r.width();};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellHeader',['jquery.sap.global','./library'],function(q,l){"use strict";
var S=sap.ui.core.Control.extend("sap.ui.unified.ShellHeader",{
metadata:{properties:{logo:{type:"sap.ui.core.URI",defaultValue:""},searchVisible:{type:"boolean",defaultValue:true}},aggregations:{headItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true},headEndItems:{type:"sap.ui.unified.ShellHeadItem",multiple:true},search:{type:"sap.ui.core.Control",multiple:false},user:{type:"sap.ui.unified.ShellHeadUserItem",multiple:false}}},
renderer:{render:function(r,h){var i=h.getId();r.write("<div");r.writeControlData(h);r.writeAttribute("class","sapUiUfdShellHeader");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","toolbar");}r.write(">");r.write("<div id='",i,"-hdr-begin' class='sapUiUfdShellHeadBegin'>");this.renderHeaderItems(r,h,true);r.write("</div>");r.write("<div id='",i,"-hdr-center' class='sapUiUfdShellHeadCenter'>");this.renderSearch(r,h);r.write("</div>");r.write("<div id='",i,"-hdr-end' class='sapUiUfdShellHeadEnd'>");this.renderHeaderItems(r,h,false);r.write("</div>");r.write("</div>");},renderSearch:function(r,h){var s=h.getSearch();r.write("<div id='",h.getId(),"-hdr-search'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","search");}r.writeAttribute("class","sapUiUfdShellSearch"+(h.getSearchVisible()?"":" sapUiUfdShellHidden"));r.write("><div>");if(s){r.renderControl(s);}r.write("</div></div>");},renderHeaderItems:function(r,h,b){r.write("<div class='sapUiUfdShellHeadContainer'>");var I=b?h.getHeadItems():h.getHeadEndItems();for(var i=0;i<I.length;i++){r.write("<div tabindex='0'");r.writeElementData(I[i]);r.addClass("sapUiUfdShellHeadItm");if(I[i].getStartsSection()){r.addClass("sapUiUfdShellHeadItmDelim");}if(I[i].getShowSeparator()){r.addClass("sapUiUfdShellHeadItmSep");}if(!I[i].getVisible()){r.addClass("sapUiUfdShellHidden");}if(I[i].getSelected()&&I[i].getToggleEnabled()){r.addClass("sapUiUfdShellHeadItmSel");}if(I[i].getShowMarker()){r.addClass("sapUiUfdShellHeadItmMark");}r.writeClasses();var t=I[i].getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(I[i],{role:"button",selected:null,pressed:I[i].getToggleEnabled()?I[i].getSelected():null});}r.write("><span></span><div class='sapUiUfdShellHeadItmMarker'><div></div></div></div>");}var u=h.getUser();if(!b&&u){r.write("<div tabindex='0'");r.writeElementData(u);r.addClass("sapUiUfdShellHeadUsrItm");if(!u.getShowPopupIndicator()){r.addClass("sapUiUfdShellHeadUsrItmWithoutPopup");}r.writeClasses();var t=u.getTooltip_AsString();if(t){r.writeAttributeEscaped("title",t);}if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(u,{role:"button"});if(u.getShowPopupIndicator()){r.writeAttribute("aria-haspopup","true");}}r.write("><span id='",u.getId(),"-img' aria-hidden='true' class='sapUiUfdShellHeadUsrItmImg'></span>");r.write("<span id='"+u.getId()+"-name' class='sapUiUfdShellHeadUsrItmName'");var U=u.getUsername()||"";r.writeAttributeEscaped("title",U);r.write(">");r.writeEscaped(U);r.write("</span><span class='sapUiUfdShellHeadUsrItmExp' aria-hidden='true'></span></div>");}r.write("</div>");if(b){this._renderLogo(r,h);}},_renderLogo:function(r,h){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),L=a.getText("SHELL_LOGO_TOOLTIP"),i=h._getLogo();r.write("<div class='sapUiUfdShellIco'>");r.write("<img id='",h.getId(),"-icon'");r.writeAttributeEscaped("title",L);r.writeAttributeEscaped("alt",L);r.write("src='");r.writeEscaped(i);r.write("' style='",i?"":"display:none;","'/>");r.write("</div>");}}
});
S.prototype.init=function(){var t=this;this._rtl=sap.ui.getCore().getConfiguration().getRTL();this._handleMediaChange=function(p){if(!t.getDomRef()){return;}t._refresh();};sap.ui.Device.media.attachHandler(this._handleMediaChange,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);this._handleResizeChange=function(p){if(!t.getDomRef()||!t.getUser()){return;}var u=this.getUser();var c=u._checkAndAdaptWidth(!t.$("hdr-search").hasClass("sapUiUfdShellHidden")&&!!t.getSearch());if(c){t._refresh();}};sap.ui.Device.resize.attachHandler(this._handleResizeChange,this);this.data("sap-ui-fastnavgroup","true",true);};
S.prototype.exit=function(){sap.ui.Device.media.detachHandler(this._handleMediaChange,this,sap.ui.Device.media.RANGESETS.SAP_STANDARD);delete this._handleMediaChange;sap.ui.Device.resize.detachHandler(this._handleResizeChange,this);delete this._handleResizeChange;};
S.prototype.onAfterRendering=function(){this._refresh();this.$("hdr-center").toggleClass("sapUiUfdShellAnim",!this._noHeadCenterAnim);};
S.prototype.onThemeChanged=function(){if(this.getDomRef()){this.invalidate();}};
S.prototype._getLogo=function(){var i=this.getLogo();if(!i){q.sap.require("sap.ui.core.theming.Parameters");i=sap.ui.core.theming.Parameters._getThemeImage(null,true);}return i;};
S.prototype._refresh=function(){function u(I){for(var i=0;i<I.length;i++){I[i]._refreshIcon();}}u(this.getHeadItems());u(this.getHeadEndItems());var U=this.getUser(),a=q("html").hasClass("sapUiMedia-Std-Phone"),s=!this.$("hdr-search").hasClass("sapUiUfdShellHidden"),$=this.$("icon");if(U){U._refreshImage();U._checkAndAdaptWidth(s&&!!this.getSearch());}$.parent().toggleClass("sapUiUfdShellHidden",a&&s&&!!this.getSearch());var w=this.$("hdr-end").outerWidth(),b=this.$("hdr-begin").outerWidth(),c=Math.max(w,b),d=(a&&s?b:c)+"px",e=(a&&s?w:c)+"px";this.$("hdr-center").css({"left":this._rtl?e:d,"right":this._rtl?d:e});};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellLayout',['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/theming/Parameters','./SplitContainer','./library','jquery.sap.dom','jquery.sap.script'],function(q,D,C,P,a,S,l){"use strict";
var b=C.extend("sap.ui.unified.ShellLayout",{metadata:{library:"sap.ui.unified",properties:{showPane:{type:"boolean",group:"Appearance",defaultValue:false},headerHiding:{type:"boolean",group:"Appearance",defaultValue:false},headerVisible:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent"},header:{type:"sap.ui.core.Control",multiple:false},canvasSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"},curtainSplitContainer:{type:"sap.ui.unified.SplitContainer",multiple:false,visibility:"hidden"}}}});
b._SIDEPANE_WIDTH_PHONE=208;b._SIDEPANE_WIDTH_TABLET=208;b._SIDEPANE_WIDTH_DESKTOP=240;b._HEADER_ALWAYS_VISIBLE=true;b._HEADER_AUTO_CLOSE=true;b._HEADER_TOUCH_TRESHOLD=15;if(D.browser.chrome&&D.browser.version<36){b._HEADER_TOUCH_TRESHOLD=10;}
b.prototype.init=function(){this._rtl=sap.ui.getCore().getConfiguration().getRTL();this._animation=sap.ui.getCore().getConfiguration().getAnimation();this._showHeader=true;this._showCurtain=false;this._iHeaderHidingDelay=3000;this._useStrongBG=false;this._cont=new S(this.getId()+"-container");this._cont._bRootContent=true;if(sap.ui.getCore().getConfiguration().getAccessibility()){var t=this;this._cont.addEventDelegate({onAfterRendering:function(){t._cont.$("canvas").attr("role","main");t._cont.$("pane").attr("role","complementary");}});}this.setAggregation("canvasSplitContainer",this._cont,true);this._curtCont=new S(this.getId()+"-curt-container");this._curtCont._bRootContent=true;this.setAggregation("curtainSplitContainer",this._curtCont,true);this._setSidePaneWidth();D.media.attachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);D.resize.attachHandler(this._handleResizeChange,this);};
b.prototype.exit=function(){D.media.detachHandler(this._handleMediaChange,this,D.media.RANGESETS.SAP_STANDARD);D.resize.detachHandler(this._handleResizeChange,this);delete this._cont;delete this._curtCont;};
b.prototype.onAfterRendering=function(){var t=this;function h(B){var e=q.event.fix(B);if(q.sap.containsOrEquals(t.getDomRef("hdr"),e.target)){t._timedHideHeader(e.type==="focus");}}if(window.addEventListener&&!b._HEADER_ALWAYS_VISIBLE){var H=this.getDomRef("hdr");H.addEventListener("focus",h,true);H.addEventListener("blur",h,true);}this._refreshAfterRendering();};
b.prototype.onThemeChanged=function(){this._refreshAfterRendering();};
b.prototype.onfocusin=function(e){var i=this.getId();if(e.target.id===i+"-curt-focusDummyOut"){q.sap.focus(this.$("hdrcntnt").firstFocusableDomRef());}else if(e.target.id===i+"-main-focusDummyOut"){q.sap.focus(this.$("curtcntnt").firstFocusableDomRef());}};
(function(){
function _(s){if(s._startY===undefined||s._currY===undefined){return;}var y=s._currY-s._startY;if(Math.abs(y)>b._HEADER_TOUCH_TRESHOLD){s._doShowHeader(y>0);s._startY=s._currY;}}
if(D.support.touch){b._HEADER_ALWAYS_VISIBLE=false;b.prototype.ontouchstart=function(e){this._startY=e.touches[0].pageY;if(this._startY>2*48){this._startY=undefined;}this._currY=this._startY;};b.prototype.ontouchend=function(e){_(this);this._startY=undefined;this._currY=undefined;};b.prototype.ontouchcancel=b.prototype.ontouchend;b.prototype.ontouchmove=function(e){this._currY=e.touches[0].pageY;_(this);};}})();
b.prototype.setHeaderHiding=function(e){e=!!e;return this._mod(function(r){return this.setProperty("headerHiding",e,r);},function(){this._doShowHeader(!e?true:this._showHeader);});};
b.prototype.setHeaderHidingDelay=function(d){this._iHeaderHidingDelay=d;return this;};
b.prototype.getHeaderHidingDelay=function(){return this._iHeaderHidingDelay;};
b.prototype.getShowPane=function(){return this._cont.getShowSecondaryContent();};
b.prototype.setShowPane=function(s){this._cont.setShowSecondaryContent(s);this.setProperty("showPane",!!s,true);return this;};
b.prototype.setShowCurtainPane=function(s){this._curtCont.setShowSecondaryContent(s);return this;};
b.prototype.getShowCurtainPane=function(){return this._curtCont.getShowSecondaryContent();};
b.prototype.setHeaderVisible=function(h){h=!!h;this.setProperty("headerVisible",h,true);this.$().toggleClass("sapUiUfdShellNoHead",!h);return this;};
b.prototype.setShowCurtain=function(s){s=!!s;return this._mod(function(r){this._showCurtain=s;return this;},function(){this.$("main-focusDummyOut").attr("tabindex",s?0:-1);this.$().toggleClass("sapUiUfdShellCurtainHidden",!s).toggleClass("sapUiUfdShellCurtainVisible",s);if(s){var z=P.getNextZIndex();this.$("curt").css("z-index",z+1);this.$("hdr").css("z-index",z+3);this.$("brand").css("z-index",z+7);this.$().toggleClass("sapUiUfdShellCurtainClosed",false);}this._timedCurtainClosed(s);this._doShowHeader(true);});};
b.prototype.getShowCurtain=function(){return this._showCurtain;};
b.prototype.getContent=function(){return this._cont.getContent();};
b.prototype.insertContent=function(c,i){this._cont.insertContent(c,i);return this;};
b.prototype.addContent=function(c){this._cont.addContent(c);return this;};
b.prototype.removeContent=function(i){return this._cont.removeContent(i);};
b.prototype.removeAllContent=function(){return this._cont.removeAllContent();};
b.prototype.destroyContent=function(){this._cont.destroyContent();return this;};
b.prototype.indexOfContent=function(c){return this._cont.indexOfContent(c);};
b.prototype.getPaneContent=function(){return this._cont.getSecondaryContent();};
b.prototype.insertPaneContent=function(c,i){this._cont.insertSecondaryContent(c,i);return this;};
b.prototype.addPaneContent=function(c){this._cont.addSecondaryContent(c);return this;};
b.prototype.removePaneContent=function(i){return this._cont.removeSecondaryContent(i);};
b.prototype.removeAllPaneContent=function(){return this._cont.removeAllSecondaryContent();};
b.prototype.destroyPaneContent=function(){this._cont.destroySecondaryContent();return this;};
b.prototype.indexOfPaneContent=function(c){return this._cont.indexOfSecondaryContent(c);};
b.prototype.setHeader=function(h){this.setAggregation("header",h,true);h=this.getHeader();if(this.getDomRef()){if(!h){this.$("hdrcntnt").html("");}else{var r=sap.ui.getCore().createRenderManager();r.renderControl(h);r.flush(this.getDomRef("hdrcntnt"));r.destroy();}}return this;};
b.prototype.destroyHeader=function(){this.destroyAggregation("header",true);this.$("hdrcntnt").html("");return this;};
b.prototype.getCurtainContent=function(){return this._curtCont.getContent();};
b.prototype.insertCurtainContent=function(c,i){this._curtCont.insertContent(c,i);return this;};
b.prototype.addCurtainContent=function(c){this._curtCont.addContent(c);return this;};
b.prototype.removeCurtainContent=function(i){return this._curtCont.removeContent(i);};
b.prototype.removeAllCurtainContent=function(){return this._curtCont.removeAllContent();};
b.prototype.destroyCurtainContent=function(){this._curtCont.destroyContent();return this;};
b.prototype.indexOfCurtainContent=function(c){return this._curtCont.indexOfCurtainContent(c);};
b.prototype.getCurtainPaneContent=function(){return this._curtCont.getSecondaryContent();};
b.prototype.insertCurtainPaneContent=function(c,i){this._curtCont.insertSecondaryContent(c,i);return this;};
b.prototype.addCurtainPaneContent=function(c){this._curtCont.addSecondaryContent(c);return this;};
b.prototype.removeCurtainPaneContent=function(i){return this._curtCont.removeSecondaryContent(i);};
b.prototype.removeAllCurtainPaneContent=function(){return this._curtCont.removeAllSecondaryContent();};
b.prototype.destroyCurtainPaneContent=function(){this._curtCont.destroySecondaryContent();return this;};
b.prototype.indexOfCurtainPaneContent=function(c){return this._curtCont.indexOfSecondaryContent(c);};
b.prototype._setStrongBackground=function(u){this._useStrongBG=!!u;this.$("strgbg").toggleClass("sapUiStrongBackgroundColor",this._useStrongBG);};
b.prototype._mod=function(m,d){var r=!!this.getDomRef();var c=m.apply(this,[r]);if(r&&d){if(d instanceof sap.ui.unified._ContentRenderer){d.render();}else{d.apply(this);}}return c;};
b.prototype._doShowHeader=function(s){var w=this._showHeader;this._showHeader=this._isHeaderHidingActive()?!!s:true;this.$().toggleClass("sapUiUfdShellHeadHidden",!this._showHeader).toggleClass("sapUiUfdShellHeadVisible",this._showHeader);if(this._showHeader){this._timedHideHeader();}if(w!=this._showHeader&&this._isHeaderHidingActive()){q.sap.delayedCall(500,this,function(){try{var r=document.createEvent("UIEvents");r.initUIEvent("resize",true,false,window,0);window.dispatchEvent(r);}catch(e){q.sap.log.error(e);}});}};
b.prototype._timedHideHeader=function(c){if(this._headerHidingTimer){q.sap.clearDelayedCall(this._headerHidingTimer);this._headerHidingTimer=null;}if(c||!b._HEADER_AUTO_CLOSE||!this._isHeaderHidingActive()||this._iHeaderHidingDelay<=0){return;}this._headerHidingTimer=q.sap.delayedCall(this._iHeaderHidingDelay,this,function(){if(this._isHeaderHidingActive()&&this._iHeaderHidingDelay>0&&!q.sap.containsOrEquals(this.getDomRef("hdr"),document.activeElement)){this._doShowHeader(false);}});};
b.prototype._timedCurtainClosed=function(c){if(this._curtainClosedTimer){q.sap.clearDelayedCall(this._curtainClosedTimer);this._curtainClosedTimer=null;}if(c){return;}var d=parseInt(a.get("_sap_ui_unified_ShellLayout_AnimDuration"),10);if(!this._animation||(D.browser.internet_explorer&&D.browser.version<10)){d=0;}this._curtainClosedTimer=q.sap.delayedCall(d,this,function(){this._curtainClosedTimer=null;this.$("curt").css("z-index","");this.$("hdr").css("z-index","");this.$("brand").css("z-index","");this.$().toggleClass("sapUiUfdShellCurtainClosed",true);});};
b.prototype._isHeaderHidingActive=function(){if(b._HEADER_ALWAYS_VISIBLE||this.getShowCurtain()||!this.getHeaderHiding()||sap.ui.unified._iNumberOfOpenedShellOverlays>0||!this.getHeaderVisible()){return false;}return true;};
b.prototype._refreshCSSWorkaround=function(){if(!D.browser.webkit||!D.support.touch){return;}if(this._cssWorkaroundTimer){q.sap.clearDelayedCall(this._cssWorkaroundTimer);this._cssWorkaroundTimer=null;}this.$("css").remove();this._cssWorkaroundTimer=q.sap.delayedCall(10,this,function(){this._cssWorkaroundTimer=null;q.sap.log.debug("sap.ui.unified.ShellLayout: CSS Workaround applied.");q("head").append("<link type='text/css' rel='stylesheet' id='"+this.getId()+"-css' href='data:text/css;base64,LnNhcFVpVWZkU2hlbGxDaHJvbWVSZXBhaW50e291dGxpbmUtY29sb3I6aW5pdGlhbDt9'/>");this._cssWorkaroundTimer=q.sap.delayedCall(100,this,function(){this.$("css").remove();});});};
b.prototype._setSidePaneWidth=function(r){if(!r){r=D.media.getCurrentRange(D.media.RANGESETS.SAP_STANDARD).name;}var w=b["_SIDEPANE_WIDTH_"+r.toUpperCase()]+"px";this._cont.setSecondaryContentSize(w);this._curtCont.setSecondaryContentSize(w);};
b.prototype._handleMediaChange=function(p){if(!this.getDomRef()){return false;}this._setSidePaneWidth(p.name);};
b.prototype._handleResizeChange=function(p){};
b.prototype._refreshAfterRendering=function(){var d=this.getDomRef();if(!d){return false;}this._repaint(d);this._timedHideHeader();return true;};
b.prototype._repaint=function(d){if(D.browser.webkit){var c=d.style.display;d.style.display="none";d.offsetHeight;d.style.display=c;this._refreshCSSWorkaround();}};
b.prototype._getSearchWidth=function(){return-1;};
return b;},true);
sap.ui.predefine('sap/ui/unified/ShellLayoutRenderer',['jquery.sap.global'],function(q){"use strict";var S={};
S.render=function(r,s){var i=s.getId();r.write("<div");r.writeControlData(s);r.addClass("sapUiUfdShell");if(s._animation){r.addClass("sapUiUfdShellAnim");}if(!s.getHeaderVisible()){r.addClass("sapUiUfdShellNoHead");}r.addClass("sapUiUfdShellHead"+(s._showHeader?"Visible":"Hidden"));if(s.getShowCurtain()){r.addClass("sapUiUfdShellCurtainVisible");}else{r.addClass("sapUiUfdShellCurtainHidden");r.addClass("sapUiUfdShellCurtainClosed");}r.writeClasses();r.write(">");r.write("<hr id='",i,"-brand' class='sapUiUfdShellBrand'/>");r.write("<header id='",i,"-hdr'  class='sapUiUfdShellHead'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","banner");}r.write("><div><div id='",i,"-hdrcntnt' class='sapUiUfdShellCntnt'>");if(s.getHeader()){r.renderControl(s.getHeader());}r.write("</div>","</div>","</header>");r.write("<section id='",i,"-curt' class='sapUiUfdShellCntnt sapUiUfdShellCurtain'>");r.write("<div id='",i,"-curtcntnt' class='sapUiUfdShellCntnt'>");r.renderControl(s._curtCont);r.write("</div>");r.write("<span id='",i,"-curt-focusDummyOut' tabindex='0'></span>");r.write("</section>");r.write("<div id='",i,"-cntnt' class='sapUiUfdShellCntnt sapUiUfdShellCanvas sapUiGlobalBackgroundColor sapUiGlobalBackgroundColorForce'>");r.write("<div id='",i,"-strgbg' class='sapUiUfdShellBG"+(s._useStrongBG?" sapUiStrongBackgroundColor":"")+"'></div>");r.write("<div class='sapUiGlobalBackgroundImage sapUiGlobalBackgroundImageForce sapUiUfdShellBG'></div>");r.renderControl(s._cont);r.write("</div>");r.write("<span id='",i,"-main-focusDummyOut' tabindex='"+(s.getShowCurtain()?0:-1)+"'></span>");r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellOverlay',['jquery.sap.global','sap/ui/Device','sap/ui/core/Control','sap/ui/core/Popup','./Shell','./library','jquery.sap.script'],function(q,D,C,P,S,l){"use strict";
var a=C.extend("sap.ui.unified.ShellOverlay",{metadata:{library:"sap.ui.unified",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},search:{type:"sap.ui.core.Control",multiple:false}},associations:{shell:{type:"sap.ui.unified.ShellLayout",multiple:false},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{closed:{}}}});
a.prototype.open=function(){if(this._getPopup().isOpen()){return;}this._opening=true;this._forceShellHeaderVisible();this._getPopup().setModal(true,P.blStack.length==0&&this._getAnimActive()?"sapUiUfdShellOvrlyBly sapUiUfdShellOvrlyBlyTp":"");this._getPopup().open(0,P.Dock.BeginTop,P.Dock.BeginTop,window,"0 0","none");var s=this.getSearch();if(s){s.focus();}this._opening=false;if(this._getAnimActive()){q.sap.delayedCall(50,this,function(){q.sap.byId("sap-ui-blocklayer-popup").toggleClass("sapUiUfdShellOvrlyBlyTp",false);});}q.sap.delayedCall(this._getAnimDuration(true),this,function(){this.$().toggleClass("sapUiUfdShellOvrlyOpening",false);});};
a.prototype.close=function(){if(!this._getPopup().isOpen()){return;}this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",true).toggleClass("sapUiUfdShellOvrlyClosing",true);this._setSearchWidth();q.sap.delayedCall(Math.max(this._getAnimDuration(false)-this._getBLAnimDuration(),0),this,function(){var b=q.sap.byId("sap-ui-blocklayer-popup");if(P.blStack.length==1&&this._getAnimActive()&&b.hasClass("sapUiUfdShellOvrlyBly")){b.toggleClass("sapUiUfdShellOvrlyBlyTp",true);}});q.sap.delayedCall(this._getAnimDuration(false),this,function(){this._getPopup().close(0);this.$().remove();this._forceShellHeaderVisible();this.fireClosed();});};
a.prototype.setShell=function(s){return this.setAssociation("shell",s,true);};
a.prototype.setSearch=function(s){this.setAggregation("search",s,true);if(!!this.getDomRef()){this._headRenderer.render();}return this;};
a.prototype.insertContent=function(c,i){var r=this.insertAggregation("content",c,i,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
a.prototype.addContent=function(c){var r=this.addAggregation("content",c,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
a.prototype.removeContent=function(i){var r=this.removeAggregation("content",i,true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
a.prototype.removeAllContent=function(){var r=this.removeAllAggregation("content",true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
a.prototype.destroyContent=function(){var r=this.destroyAggregation("content",true);if(!!this.getDomRef()){this._contentRenderer.render();}return r;};
a.prototype.init=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;this._animation=sap.ui.getCore().getConfiguration().getAnimation();this._opening=false;var t=this;this._headRenderer=new sap.ui.unified._ContentRenderer(this,this.getId()+"-hdr-center",function(r){sap.ui.unified.ShellOverlayRenderer.renderSearch(r,t);});this._contentRenderer=new sap.ui.unified._ContentRenderer(this,this.getId()+"-cntnt",function(r){sap.ui.unified.ShellOverlayRenderer.renderContent(r,t);});};
a.prototype.exit=function(){if(this._popup){this._popup.close(0);this._popup.destroy();this._popup=null;}this._getPopup=function(){return null;};this._headRenderer.destroy();delete this._headRenderer;this._contentRenderer.destroy();delete this._contentRenderer;};
a.prototype.onAfterRendering=function(){if(this._opening){this._setSearchWidth();}q.sap.delayedCall(10,this,function(){this.$().toggleClass("sapUiUfdShellOvrlyCntntHidden",false);this.$("search").css("width","");});};
a.prototype.onclick=function(e){if(q(e.target).attr("id")===this.getId()+"-close"){this.close();e.preventDefault();}};
a.prototype.onsapspace=a.prototype.onclick;
a.prototype.onThemeChanged=function(){this._animOpenDuration=-1;this._animCloseDuration=-1;this._animBlockLayerDuration=-1;};
a.prototype.onfocusin=function(e){var f,d;if(e.target.id==this.getId()+"-focfirst"){f=q(":sapTabbable",this.$("inner"));d=f.get(f.length-1);}else if(e.target.id==this.getId()+"-foclast"){f=q(":sapTabbable",this.$("inner"));d=f.get(0);}if(d){q.sap.focus(d);}};
a.prototype._getAnimDurationThemeParam=function(p,c){var v=parseInt(sap.ui.core.theming.Parameters.get(p),10);if(!this._getAnimActive()&&c){v=0;}return v;};
a.prototype._getAnimDuration=function(o){if((o&&this._animOpenDuration==-1)||(!o&&this._animCloseDuration==-1)){var t=o?"Open":"Close";this["_anim"+t+"Duration"]=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_"+t+"AnimOverAll",true);}return o?this._animOpenDuration:this._animCloseDuration;};
a.prototype._getBLAnimDuration=function(){if(this._animBlockLayerDuration==-1){this._animBlockLayerDuration=this._getAnimDurationThemeParam("_sap_ui_unified_ShellOverlay_BlockLayerAnimDuration",true);}return this._animBlockLayerDuration;};
a.prototype._getAnimActive=function(){if(!this._animation||(D.browser.internet_explorer&&D.browser.version<10)){return false;}return true;};
a.prototype._getPopup=function(){if(!this._popup){this._popup=new P(this,true,false,false);this._popup._applyPosition=function(p){this._$().css("left","0").css("top","0");this._oLastPosition=p;this._oLastOfRect=q(window).rect();};this._popup.attachOpened(function(){sap.ui.unified._iNumberOfOpenedShellOverlays++;});this._popup.attachClosed(function(){sap.ui.unified._iNumberOfOpenedShellOverlays--;});}return this._popup;};
a.prototype._getShell=function(){var i=this.getShell();if(!i){return;}var s=sap.ui.getCore().byId(i);if(!s||!(s instanceof sap.ui.unified.ShellLayout)){return;}return s;};
a.prototype._forceShellHeaderVisible=function(){var s=this._getShell();if(s){s._doShowHeader(true);}};
a.prototype._getSearchWidth=function(){var s=this._getShell();return s?s._getSearchWidth():-1;};
a.prototype._setSearchWidth=function(){var w=this._getSearchWidth();if(w<=0){return;}var W=w+"px";if(D.browser.safari){var t=this.$("hdr-center").width();if(t>w){W=Math.round((w*100)/t)+"%";}else{W="100%";}}this.$("search").css("width",W);};
return a;},true);
sap.ui.predefine('sap/ui/unified/ShellOverlayRenderer',['jquery.sap.global'],function(q){"use strict";var S={};
S.render=function(r,c){r.write("<div");r.writeControlData(c);r.addClass("sapUiUfdShellOvrly");if(c._opening){r.addClass("sapUiUfdShellOvrlyCntntHidden");r.addClass("sapUiUfdShellOvrlyOpening");}if(c._getAnimActive()){r.addClass("sapUiUfdShellOvrlyAnim");}r.writeClasses();if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAccessibilityState(c,{role:"dialog"});}r.write("><span id='",c.getId(),"-focfirst' tabIndex='0'></span><div id='",c.getId(),"-inner'>");r.write("<header class='sapUiUfdShellOvrlyHead'>");r.write("<hr class='sapUiUfdShellOvrlyBrand'/>");r.write("<div class='sapUiUfdShellOvrlyHeadCntnt'");if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","toolbar");}r.write("><div id='"+c.getId()+"-hdr-center' class='sapUiUfdShellOvrlyHeadCenter'>");S.renderSearch(r,c);r.write("</div>");var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified"),C=a.getText("SHELL_OVERLAY_CLOSE");r.write("<a tabindex='0' href='#' id='"+c.getId()+"-close' class='sapUiUfdShellOvrlyHeadClose'");r.writeAttributeEscaped("title",C);if(sap.ui.getCore().getConfiguration().getAccessibility()){r.writeAttribute("role","button");}r.write(">");r.writeEscaped(C);r.write("</a></div></header>");r.write("<div id='"+c.getId()+"-cntnt' class='sapUiUfdShellOvrlyCntnt'>");S.renderContent(r,c);r.write("</div>");r.write("</div><span id='",c.getId(),"-foclast' tabIndex='0'></span></div>");};
S.renderSearch=function(r,c){var w=c._getSearchWidth();var s="";if(w>0&&c._opening){s="style='width:"+w+"px'";}r.write("<div id='"+c.getId()+"-search' class='sapUiUfdShellOvrlySearch' "+s+"><div>");var o=c.getSearch();if(o){r.renderControl(o);}r.write("</div></div>");};
S.renderContent=function(r,c){r.write("<div tabindex='-1'>");var C=c.getContent();for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/ShellRenderer',['jquery.sap.global','sap/ui/core/Renderer','./ShellLayoutRenderer'],function(q,R,S){"use strict";var a=R.extend(S);return a;},true);
sap.ui.predefine('sap/ui/unified/SplitContainer',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/theming/Parameters','./library'],function(q,C,P,l){"use strict";
var S=C.extend("sap.ui.unified.SplitContainer",{metadata:{library:"sap.ui.unified",properties:{showSecondaryContent:{type:"boolean",group:"Appearance",defaultValue:null},secondaryContentSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'250px'},secondaryContentWidth:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:'250px',deprecated:true},orientation:{type:"sap.ui.core.Orientation",group:"Appearance",defaultValue:sap.ui.core.Orientation.Horizontal}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},secondaryContent:{type:"sap.ui.core.Control",multiple:true,singularName:"secondaryContent"}}}});
(function(w){
S.prototype.init=function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this._paneRenderer=new sap.ui.unified._ContentRenderer(this,this.getId()+"-panecntnt","secondaryContent");this._canvasRenderer=new sap.ui.unified._ContentRenderer(this,this.getId()+"-canvascntnt","content");this._moveContent=true;};
S.prototype.exit=function(){this._paneRenderer.destroy();delete this._paneRenderer;this._canvasRenderer.destroy();delete this._canvasRenderer;if(this._closeContentDelayId){q.sap.clearDelayedCall(this._closeContentDelayId);delete this._closeContentDelayId;}delete this._contentContainer;delete this._secondaryContentContainer;};
S.prototype.onAfterRendering=function(){this.bRtl=sap.ui.getCore().getConfiguration().getRTL();this._contentContainer=this.$("canvas");this._secondaryContentContainer=this.$("pane");this._applySecondaryContentSize();};
S.prototype._applySecondaryContentSize=function(){if(this.getDomRef()){var v=this.getOrientation()==sap.ui.core.Orientation.Vertical;var s,o;var d,O;var a=this.getSecondaryContentSize();var b=this.getShowSecondaryContent();if(v){s="height";o="width";d="top";O=this.bRtl?"right":"left";}else{s="width";o="height";d=this.bRtl?"right":"left";O="top";}if(this._closeContentDelayId){q.sap.clearDelayedCall(this._closeContentDelayId);delete this._closeContentDelayId;}this._secondaryContentContainer.css(s,a);this._secondaryContentContainer.css(o,"");this._secondaryContentContainer.css(d,b?"0":"-"+a);this._secondaryContentContainer.css(O,"");if(this._moveContent){this._contentContainer.css(d,b?a:"0");}else{this._contentContainer.css(d,"0");}if(!b){var h=parseInt(P.get("_sap_ui_unified_SplitContainer_AnimationDuration"),10);this._closeContentDelayId=q.sap.delayedCall(h,this,function(){this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed",true);});}else{this._secondaryContentContainer.toggleClass("sapUiUfdSplitContSecondClosed",false);}}};
S.prototype._mod=function(m,d){var r=!!this.getDomRef();var a=m.apply(this,[r]);if(r&&d){d.render();}return a;};
S.prototype.setShowSecondaryContent=function(s){var r=this.getDomRef();this.setProperty("showSecondaryContent",!!s,r);this._applySecondaryContentSize();return this;};
S.prototype.setSecondaryContentSize=function(s){this.setProperty("secondaryContentSize",s,true);this._applySecondaryContentSize();return this;};
S.prototype.getSecondaryContentWidth=function(){q.sap.log.warning("SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use "+"\"SecondaryContentSize\" instead.");return this.getSecondaryContentSize.apply(this,arguments);};
S.prototype.setSecondaryContentWidth=function(){q.sap.log.warning("SplitContainer: Use of deprecated property \"SecondaryContentWidth\", please use "+"\"SecondaryContentSize\" instead.");return this.setSecondaryContentSize.apply(this,arguments);};
S.prototype.insertContent=function(c,i){return this._mod(function(r){return this.insertAggregation("content",c,i,r);},this._canvasRenderer);};
S.prototype.addContent=function(c){return this._mod(function(r){return this.addAggregation("content",c,r);},this._canvasRenderer);};
S.prototype.removeContent=function(i){return this._mod(function(r){return this.removeAggregation("content",i,r);},this._canvasRenderer);};
S.prototype.removeAllContent=function(){return this._mod(function(r){return this.removeAllAggregation("content",r);},this._canvasRenderer);};
S.prototype.destroyContent=function(){return this._mod(function(r){return this.destroyAggregation("content",r);},this._canvasRenderer);};
S.prototype.insertSecondaryContent=function(c,i){return this._mod(function(r){return this.insertAggregation("secondaryContent",c,i,r);},this._paneRenderer);};
S.prototype.addSecondaryContent=function(c){return this._mod(function(r){return this.addAggregation("secondaryContent",c,r);},this._paneRenderer);};
S.prototype.removeSecondaryContent=function(i){return this._mod(function(r){return this.removeAggregation("secondaryContent",i,r);},this._paneRenderer);};
S.prototype.removeAllSecondaryContent=function(){return this._mod(function(r){return this.removeAllAggregation("secondaryContent",r);},this._paneRenderer);};
S.prototype.destroySecondaryContent=function(){return this._mod(function(r){return this.destroyAggregation("secondaryContent",r);},this._paneRenderer);};
})(window);return S;},true);
sap.ui.predefine('sap/ui/unified/SplitContainerRenderer',['jquery.sap.global'],function(q){"use strict";var S={};
S.render=function(r,c){var i=c.getId();var v=c.getOrientation()==sap.ui.core.Orientation.Vertical;r.write("<div");r.writeControlData(c);r.addClass("sapUiUfdSpltCont");r.addClass("sapUiUfdSpltCont"+(v?"V":"H"));if(sap.ui.getCore().getConfiguration().getAnimation()){r.addClass("sapUiUfdSpltContAnim");}if(!c.getShowSecondaryContent()){r.addClass("sapUiUfdSpltContPaneHidden");}r.writeClasses();r.write(">");var C=i+"-canvas";r.write("<section id='",C,"' class='sapUiUfdSpltContCanvas'>");this.renderContent(r,C,c.getContent(),c._bRootContent);r.write("</section>");var s=i+"-pane";var w=c.getShowSecondaryContent()?c.getSecondaryContentSize():"0";r.write("<aside id='",s,"' style='width:",w,"'");r.addClass("sapUiUfdSpltContPane");if(!c.getShowSecondaryContent()){r.addClass("sapUiUfdSplitContSecondClosed");}r.writeClasses();r.write(">");this.renderContent(r,s,c.getSecondaryContent(),c._bRootContent);r.write("</aside>");r.write("</div>");};
S.renderContent=function(r,I,c,R){r.write("<div id='",I,"cntnt' class='sapUiUfdSpltContCntnt'");if(R){r.writeAttribute("data-sap-ui-root-content","true");}r.write(">");for(var i=0;i<c.length;i++){r.renderControl(c[i]);}r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/ui/unified/calendar/CalendarDate',['sap/ui/base/Object','sap/ui/core/date/UniversalDate'],function(B,U){"use strict";
var C=B.extend("sap.ui.unified.calendar.CalendarDate",{constructor:function(){var A=arguments,j,n,s;switch(A.length){case 0:n=new Date();return this.constructor(n.getFullYear(),n.getMonth(),n.getDate());case 1:case 2:if(!(A[0]instanceof C)){throw"Invalid arguments: the first argument must be of type sap.ui.unified.calendar.CalendarDate.";}s=A[1]?A[1]:A[0]._oUDate.sCalendarType;j=new Date(A[0].valueOf());j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());j.setHours(j.getUTCHours(),j.getUTCMinutes(),j.getUTCSeconds(),j.getUTCMilliseconds());this._oUDate=c(j,s);break;case 3:case 4:d(A[0],"Invalid year: "+A[0]);d(A[1],"Invalid month: "+A[1]);d(A[2],"Invalid date: "+A[2]);j=new Date(0,0,1);j.setFullYear(A[0],A[1],A[2]);if(A[3]){s=A[3];}this._oUDate=c(j,s);break;default:throw"Invalid arguments. Accepted arguments are: 1) oCalendarDate, (optional)calendarType"+"or 2) year, month, date, (optional) calendarType"+A;}}});
C.prototype.getYear=function(){return this._oUDate.getUTCFullYear();};
C.prototype.setYear=function(y){d(y,"Invalid year: "+y);this._oUDate.setUTCFullYear(y);return this;};
C.prototype.getMonth=function(){return this._oUDate.getUTCMonth();};
C.prototype.setMonth=function(m){d(m,"Invalid month: "+m);this._oUDate.setUTCMonth(m);return this;};
C.prototype.getDate=function(){return this._oUDate.getUTCDate();};
C.prototype.setDate=function(e){d(e,"Invalid date: "+e);this._oUDate.setUTCDate(e);return this;};
C.prototype.getDay=function(){return this._oUDate.getUTCDay();};
C.prototype.getCalendarType=function(){return this._oUDate.sCalendarType;};
C.prototype.isBefore=function(o){b(o);return this.valueOf()<o.valueOf();};
C.prototype.isAfter=function(o){b(o);return this.valueOf()>o.valueOf();};
C.prototype.isSameOrBefore=function(o){b(o);return this.valueOf()<=o.valueOf();};
C.prototype.isSameOrAfter=function(o){b(o);return this.valueOf()>=o.valueOf();};
C.prototype.isSame=function(o){b(o);return this.valueOf()===o.valueOf();};
C.prototype.toLocalJSDate=function(){var l=new Date(this._oUDate.getTime());l.setFullYear(l.getUTCFullYear(),l.getUTCMonth(),l.getUTCDate());l.setHours(0,0,0,0);return l;};
C.prototype.toUTCJSDate=function(){var u=new Date(this._oUDate.getTime());u.setUTCHours(0,0,0,0);return u;};
C.prototype.toString=function(){return this._oUDate.sCalendarType+": "+this.getYear()+"/"+(this.getMonth()+1)+"/"+this.getDate();};
C.prototype.valueOf=function(){return this._oUDate.getTime();};
C.fromLocalJSDate=function(j,s){if(!(j instanceof Date)){throw new Error("Date parameter must be a JavaScript Date object: ["+j+"].");}return new C(j.getFullYear(),j.getMonth(),j.getDate(),s);};
function c(D,s){if(s){return U.getInstance(a(D),s);}else{return new U(a(D).getTime());}}
function a(D){var u=new Date(Date.UTC(0,0,1));u.setUTCFullYear(D.getFullYear(),D.getMonth(),D.getDate());return u;}
function b(o){if(!(o instanceof C)){throw"Invalid calendar date: ["+o+"]. Expected: sap.ui.unified.calendar.CalendarDate";}}
function d(v,m){if(v==undefined||v===Infinity||isNaN(v)){throw m;}}
return C;},true);
sap.ui.predefine('sap/ui/unified/calendar/CalendarUtils',['jquery.sap.global','sap/ui/core/date/UniversalDate','./CalendarDate'],function(q,U,C){"use strict";var a={};a.MAX_MILLISECONDS=8640000000000000;a.HOURS24=1000*3600*24;
a._createLocalDate=function(d,t){var l;if(d){var m;if(d instanceof U){m=d.getJSDate();}else{m=d;}l=new Date(m.getUTCFullYear(),m.getUTCMonth(),m.getUTCDate());if(m.getFullYear()<1000){l.setFullYear(m.getFullYear());}if(t){l.setHours(m.getUTCHours());l.setMinutes(m.getUTCMinutes());l.setSeconds(m.getUTCSeconds());l.setMilliseconds(m.getUTCMilliseconds());}}return l;};
a._createUTCDate=function(d,t){var u;if(d){var m;if(d instanceof U){m=d.getJSDate();}else{m=d;}u=new Date(Date.UTC(m.getFullYear(),m.getMonth(),m.getDate()));if(m.getFullYear()<1000){u.setUTCFullYear(m.getFullYear());}if(t){u.setUTCHours(m.getHours());u.setUTCMinutes(m.getMinutes());u.setUTCSeconds(m.getSeconds());u.setUTCMilliseconds(m.getMilliseconds());}}return u;};
a._createUniversalUTCDate=function(d,c,t){var u;if(c){u=U.getInstance(this._createUTCDate(d,t),c);}else{u=new U(this._createUTCDate(d,t).getTime());}return u;};
a.calculateWeekNumber=function(d,y,l,L){var w=0;var W=0;var f=L.getFirstDayOfWeek();var o=new sap.ui.core.Locale(l);if(o&&(o.getLanguage()=='en'&&o.getRegion()=='US')){var j=new U(d.getTime());j.setUTCFullYear(y,0,1);W=j.getUTCDay();var c=new U(d.getTime());c.setUTCDate(c.getUTCDate()-c.getUTCDay()+W);w=Math.round((c.getTime()-j.getTime())/86400000/7)+1;}else{var t=new U(d.getTime());t.setUTCDate(t.getUTCDate()-f);W=t.getUTCDay();t.setUTCDate(t.getUTCDate()-W+4);var F=new U(t.getTime());F.setUTCMonth(0,1);W=F.getUTCDay();var A=0;if(W>4){A=7;}var b=new U(F.getTime());b.setUTCDate(1-W+4+A);w=Math.round((t.getTime()-b.getTime())/86400000/7)+1;}return w;};
a.getFirstDateOfWeek=function(d){var u=new U(d.getTime()),f,w;w=U.getWeekByDate(u.getCalendarType(),u.getUTCFullYear(),u.getUTCMonth(),u.getUTCDate());if(w.week===0&&sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().getRegion()==="US"){w.year--;w.week=52;}f=U.getFirstDateOfWeek(u.getCalendarType(),w.year,w.week);return new U(Date.UTC(f.year,f.month,f.day,d.getUTCHours(),d.getUTCMinutes(),d.getUTCSeconds())).getJSDate();};
a.getFirstDateOfMonth=function(d){var n=new U(d.getTime());n.setUTCDate(1);return n;};
a._getNumberOfWeeksForYear=function(y){var l=sap.ui.getCore().getConfiguration().getFormatLocale(),L=sap.ui.core.LocaleData.getInstance(new sap.ui.core.Locale(l)),o=new Date(Date.UTC(y,0,1)),i=o.getUTCDay(),n=52;if(L.getFirstDayOfWeek()===0){if(i===5||i===6){n=53;}}else{if(i===3||i===4){n=53;}}return n;};
a.monthsDiffer=function(d,D){return(d.getMonth()!==D.getMonth()||d.getFullYear()!==D.getFullYear());};
a.isDateLastInMonth=function(d){var n=new Date(d.getTime()+24*60*60*1000);return n.getUTCDate()<d.getUTCDate();};
a._updateUTCDate=function(d,y,m,D,h,M,s,i){if(q.isNumeric(y)){d.setUTCFullYear(y);}if(q.isNumeric(m)){d.setUTCMonth(m);}if(q.isNumeric(D)){d.setUTCDate(D);}if(q.isNumeric(h)){d.setUTCHours(h);}if(q.isNumeric(M)){d.setUTCMinutes(M);}if(q.isNumeric(s)){d.setUTCSeconds(s);}if(q.isNumeric(i)){d.setUTCMilliseconds(i);}};
a._checkJSDateObject=function(d){if(!(d instanceof Date)){throw new Error("Date must be a JavaScript date object.");}};
a._checkYearInValidRange=function(y){if(!q.isNumeric(y)||(y<1||y>9999)){throw new Error("Year must be in valid range (between year 0001 and year 9999).");}};
a._isNextMonth=function(d,D){return(d.getMonth()>D.getMonth()&&d.getFullYear()===D.getFullYear())||d.getFullYear()>D.getFullYear();};
a._daysInMonth=function(c){this._checkCalendarDate(c);c=new C(c);c.setDate(1);c.setMonth(c.getMonth()+1);c.setDate(0);return c.getDate();};
a._isLastDateInMonth=function(c){return c.getDate()===a._daysInMonth(c);};
a._getFirstDateOfWeek=function(c){this._checkCalendarDate(c);var j=a.getFirstDateOfWeek(c.toUTCJSDate());j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());return C.fromLocalJSDate(j,c.getCalendarType());};
a._getFirstDateOfMonth=function(c){this._checkCalendarDate(c);var j=a.getFirstDateOfMonth(c.toUTCJSDate()).getJSDate();j.setFullYear(j.getUTCFullYear(),j.getUTCMonth(),j.getUTCDate());return C.fromLocalJSDate(j,c.getCalendarType());};
a._minDate=function(c){return new C(1,0,1,c);};
a._maxDate=function(c){var o=new C(9999,11,1,c);o.setDate(this._daysInMonth(o));return new C(o);};
a._isBetween=function(d,s,e,i){this._checkCalendarDate(d);this._checkCalendarDate(s);this._checkCalendarDate(e);if(i){return d.isSameOrAfter(s)&&d.isSameOrBefore(e);}else{return d.isAfter(s)&&d.isBefore(e);}};
a._daysBetween=function(f,s){this._checkCalendarDate(f);this._checkCalendarDate(s);return Math.ceil((f.valueOf()-s.valueOf())/(this.HOURS24));};
a._isOutside=function(c,s,e){return!this._isBetween(c,s,e,true);};
a._isSameMonthAndYear=function(c,o){this._checkCalendarDate(c);this._checkCalendarDate(o);return c.getYear()===o.getYear()&&c.getMonth()===o.getMonth();};
a._checkCalendarDate=function(c){if(!c||!(c instanceof C)){throw"Invalid calendar date: ["+c+"]. Expected: sap.ui.unified.calendar.CalendarDate";}};
a._getWeek=function(c){this._checkCalendarDate(c);return U.getWeekByDate(c.getCalendarType(),c.getYear(),c.getMonth(),c.getDate());};
return a;},true);
sap.ui.predefine('sap/ui/unified/calendar/DatesRow',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/calendar/Month','sap/ui/unified/library'],function(q,C,L,I,D,a,b,M,l){"use strict";
var c=M.extend("sap.ui.unified.calendar.DatesRow",{metadata:{library:"sap.ui.unified",properties:{startDate:{type:"object",group:"Data"},days:{type:"int",group:"Appearance",defaultValue:7},showDayNamesLine:{type:"boolean",group:"Appearance",defaultValue:true}}}});
c.prototype.init=function(){M.prototype.init.apply(this,arguments);this._iColumns=1;};
c.prototype.setStartDate=function(s){a._checkJSDateObject(s);var y=s.getFullYear();a._checkYearInValidRange(y);this.setProperty("startDate",s,true);this._oStartDate=b.fromLocalJSDate(s,this.getPrimaryCalendarType());if(this.getDomRef()){var o=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(s);this._bNoRangeCheck=false;if(o&&this.checkDateFocusable(o)){this.displayDate(o);}}return this;};
c.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oStartDate;};
c.prototype.setDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){throw new Error("Date must be in visible date range; "+this);}M.prototype.setDate.apply(this,arguments);return this;};
c.prototype.displayDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){throw new Error("Date must be in visible date range; "+this);}M.prototype.displayDate.apply(this,arguments);return this;};
c.prototype.setPrimaryCalendarType=function(s){M.prototype.setPrimaryCalendarType.apply(this,arguments);if(this._oStartDate){this._oStartDate=new b(this._oStartDate,s);}return this;};
c.prototype.setFirstDayOfWeek=function(f){if(f==-1){return this.setProperty("firstDayOfWeek",f,false);}else{throw new Error("Property firstDayOfWeek not supported "+this);}};
c.prototype._handleBorderReached=function(o){var e=o.getParameter("event");var d=this.getDays();var O=this._getDate();var f=new b(O,this.getPrimaryCalendarType());if(e.type){switch(e.type){case"sapnext":case"sapnextmodifiers":f.setDate(f.getDate()+1);break;case"sapprevious":case"sappreviousmodifiers":f.setDate(f.getDate()-1);break;case"sappagedown":f.setDate(f.getDate()+d);break;case"sappageup":f.setDate(f.getDate()-d);break;default:break;}this.fireFocus({date:f.toLocalJSDate(),otherMonth:true,_outsideBorder:true});}};
c.prototype.checkDateFocusable=function(d){a._checkJSDateObject(d);if(this._bNoRangeCheck){return false;}var s=this._getStartDate();var e=new b(s,this.getPrimaryCalendarType());e.setDate(e.getDate()+this.getDays());var o=b.fromLocalJSDate(d,this.getPrimaryCalendarType());return o.isSameOrAfter(s)&&o.isBefore(e);};
c.prototype._renderHeader=function(){var s=this._getStartDate();var S=s.getDay();var o=this._getLocaleData();var w=this.$("Names").children();var W=[];if(this._bLongWeekDays||!this._bNamesLengthChecked){W=o.getDaysStandAlone("abbreviated");}else{W=o.getDaysStandAlone("narrow");}var d=o.getDaysStandAlone("wide");var i=0;for(i=0;i<w.length;i++){var $=q(w[i]);$.text(W[(i+S)%7]);$.attr("aria-label",d[(i+S)%7]);}if(this._getShowHeader()){var e=this.$("Head");if(e.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(r,this,o,s);r.flush(e[0]);r.destroy();}}};
c.prototype._getFirstWeekDay=function(){return this._getStartDate().getDay();};
return c;},true);
sap.ui.predefine('sap/ui/unified/calendar/DatesRowRenderer',['jquery.sap.global','sap/ui/core/Renderer','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','./MonthRenderer'],function(q,R,C,a,M){"use strict";var D=R.extend(M);
D.getStartDate=function(d){return d._getStartDate();};
D.getClass=function(d){var c="sapUiCalDatesRow sapUiCalRow";if(!d.getShowDayNamesLine()){c=c+" sapUiCalNoNameLine";}return c;};
D.renderHeader=function(r,d,o){var l=d._getLocaleData();var i=d.getId();var b=d.getDays();var w="";if(d._getShowHeader()){r.write("<div id=\""+i+"-Head\">");this.renderHeaderLine(r,d,l,o);r.write("</div>");}w=(100/b)+"%";if(d.getShowDayNamesLine()){r.write("<div id=\""+i+"-Names\" style=\"display: inline;\">");this.renderDayNames(r,d,l,o.getDay(),b,false,w);r.write("</div>");}};
D.renderHeaderLine=function(r,d,l,o){var I=d.getId();var b=d.getDays();var c=new a(o,d.getPrimaryCalendarType());var w="";var m=0;var e=[];var i=0;for(i=0;i<b;i++){m=c.getMonth();if(e.length>0&&e[e.length-1].iMonth==m){e[e.length-1].iDays++;}else{e.push({iMonth:m,iDays:1});}c.setDate(c.getDate()+1);}var f=l.getMonthsStandAlone("wide");for(i=0;i<e.length;i++){var g=e[i];w=(100/b*g.iDays)+"%";r.write("<div id=\""+I+"-Head"+i+"\"class=\"sapUiCalHeadText\" style=\"width:"+w+"\">");r.write(f[g.iMonth]);r.write("</div>");}};
D.renderDays=function(r,d,o){var b=d.getDays();var w=(100/b)+"%";var s=d.getShowDayNamesLine();if(!o){o=d._getFocusedDate();}var h=this.getDayHelper(d,o);if(!s){if(d._bLongWeekDays||!d._bNamesLengthChecked){h.aWeekDays=h.oLocaleData.getDaysStandAlone("abbreviated");}else{h.aWeekDays=h.oLocaleData.getDaysStandAlone("narrow");}h.aWeekDaysWide=h.oLocaleData.getDaysStandAlone("wide");}var c=new a(o,d.getPrimaryCalendarType());for(var i=0;i<b;i++){this.renderDay(r,d,c,h,false,false,i,w,!s);c.setDate(c.getDate()+1);}};
return D;},true);
sap.ui.predefine('sap/ui/unified/calendar/Header',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/library'],function(q,C,L,l){"use strict";
var H=C.extend("sap.ui.unified.calendar.Header",{metadata:{library:"sap.ui.unified",properties:{textButton0:{type:"string",group:"Appearance"},additionalTextButton0:{type:"string",group:"Appearance"},ariaLabelButton0:{type:"string",group:"Misc"},visibleButton0:{type:"boolean",group:"Appearance",defaultValue:false},textButton1:{type:"string",group:"Appearance"},additionalTextButton1:{type:"string",group:"Appearance"},ariaLabelButton1:{type:"string",group:"Misc"},visibleButton1:{type:"boolean",group:"Appearance",defaultValue:true},textButton2:{type:"string",group:"Appearance"},additionalTextButton2:{type:"string",group:"Appearance"},ariaLabelButton2:{type:"string",group:"Misc"},visibleButton2:{type:"boolean",group:"Appearance",defaultValue:true},enabledPrevious:{type:"boolean",group:"Behavior",defaultValue:true},enabledNext:{type:"boolean",group:"Behavior",defaultValue:true}},events:{pressPrevious:{},pressNext:{},pressButton0:{},pressButton1:{},pressButton2:{}}}});
H.prototype.setTextButton0=function(t){_.call(this,0,t);return this;};
H.prototype.setAdditionalTextButton0=function(t){a.call(this,0,t);return this;};
H.prototype.setAriaLabelButton0=function(t){b.call(this,0,t);return this;};
H.prototype.setTextButton1=function(t){_.call(this,1,t);return this;};
H.prototype.setAdditionalTextButton1=function(t){a.call(this,1,t);return this;};
H.prototype.setAriaLabelButton1=function(t){b.call(this,1,t);return this;};
H.prototype.setTextButton2=function(t){_.call(this,2,t);return this;};
H.prototype.setAdditionalTextButton2=function(t){a.call(this,2,t);return this;};
H.prototype.setAriaLabelButton2=function(t){b.call(this,2,t);return this;};
H.prototype.setEnabledPrevious=function(e){this.setProperty("enabledPrevious",e,true);if(this.getDomRef()){if(e){this.$("prev").toggleClass("sapUiCalDsbl",false).removeAttr("disabled");}else{this.$("prev").toggleClass("sapUiCalDsbl",true).attr("disabled","disabled");}}return this;};
H.prototype.setEnabledNext=function(e){this.setProperty("enabledNext",e,true);if(this.getDomRef()){if(e){this.$("next").toggleClass("sapUiCalDsbl",false).removeAttr("disabled");}else{this.$("next").toggleClass("sapUiCalDsbl",true).attr("disabled","disabled");}}return this;};
H.prototype.onclick=function(e){if(e.isMarked("delayedMouseEvent")){return;}if(q.sap.containsOrEquals(this.getDomRef("prev"),e.target)&&this.getEnabledPrevious()){this.firePressPrevious();}else if(q.sap.containsOrEquals(this.getDomRef("next"),e.target)&&this.getEnabledNext()){this.firePressNext();}else if(q.sap.containsOrEquals(this.getDomRef("B0"),e.target)){this.firePressButton0();}else if(q.sap.containsOrEquals(this.getDomRef("B1"),e.target)){this.firePressButton1();}else if(q.sap.containsOrEquals(this.getDomRef("B2"),e.target)){this.firePressButton2();}};
H.prototype.onsapnext=function(e){e.preventDefault();};
function _(B,t){this.setProperty("textButton"+B,t,true);if(this.getDomRef()&&this["getVisibleButton"+B]()){if(this.$("B"+B+"-Text").get(0)){this.$("B"+B+"-Text").text(t);}else{this.$("B"+B).text(t);}}}
function a(B,t){var r=false;var o=this["getAdditionalTextButton"+B]();if(o==t){return;}if((!o&&t)||(o&&!t)){r=true;}this.setProperty("additionalTextButton"+B,t,!r);if(!r&&this.getDomRef()&&this["getVisibleButton"+B]()){this.$("B"+B+"-AddText").text(t);}}
function b(B,t){this.setProperty("ariaLabelButton"+B,t,true);if(this.getDomRef()&&this["getVisibleButton"+B]()){if(t){this.$("B"+B).attr("aria-label",t);}else{this.$("B"+B).removeAttr("aria-label");}}}
return H;},true);
sap.ui.predefine('sap/ui/unified/calendar/HeaderRenderer',['jquery.sap.global'],function(q){"use strict";var H={};
H.render=function(r,h){var l=sap.ui.getCore().getConfiguration().getLocale().getLanguage();var t=h.getTooltip_AsString();var I=h.getId();var a={};var L=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_BTN_NEXT");var s=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified").getText("CALENDAR_BTN_PREV");r.write("<div");r.writeControlData(h);r.addClass("sapUiCalHead");r.writeClasses();if(t){r.writeAttributeEscaped('title',t);}r.writeAccessibilityState(h);r.write(">");r.write("<button");r.writeAttributeEscaped('id',I+'-prev');r.writeAttributeEscaped("title",s);r.writeAccessibilityState(null,{label:s});r.addClass("sapUiCalHeadPrev");if(!h.getEnabledPrevious()){r.addClass("sapUiCalDsbl");r.writeAttribute('disabled',"disabled");}r.writeAttribute('tabindex',"-1");r.writeClasses();r.write(">");r.writeIcon("sap-icon://slim-arrow-left",null,{title:null});r.write("</button>");var f=-1;var b=-1;var i=0;var B;for(i=0;i<3;i++){if(h["getVisibleButton"+i]()){if(f<0){f=i;}b=i;}}for(i=0;i<3;i++){if(l.toLowerCase()==="ja"||l.toLowerCase()==="zh"){B=2-i;}else{B=i;}this.renderCalendarButtons(r,h,I,f,b,a,B);}r.write("<button");r.writeAttributeEscaped('id',I+'-next');r.writeAttributeEscaped("title",L);r.writeAccessibilityState(null,{label:L});r.addClass("sapUiCalHeadNext");if(!h.getEnabledNext()){r.addClass("sapUiCalDsbl");r.writeAttribute('disabled',"disabled");}r.writeAttribute('tabindex',"-1");r.writeClasses();r.write(">");r.writeIcon("sap-icon://slim-arrow-right",null,{title:null});r.write("</button>");r.write("</div>");};
H.renderCalendarButtons=function(r,h,I,f,l,a,i){if(h["getVisibleButton"+i]()){r.write("<button");r.writeAttributeEscaped('id',I+'-B'+i);r.addClass("sapUiCalHeadB");r.addClass("sapUiCalHeadB"+i);if(f==i){r.addClass("sapUiCalHeadBFirst");}if(l==i){r.addClass("sapUiCalHeadBLast");}r.writeAttribute('tabindex',"-1");r.writeClasses();if(h["getAriaLabelButton"+i]()){a["label"]=q.sap.encodeHTML(h["getAriaLabelButton"+i]());}r.writeAccessibilityState(null,a);a={};r.write(">");var t=h["getTextButton"+i]()||"";var A=h["getAdditionalTextButton"+i]()||"";if(A){r.write("<span");r.writeAttributeEscaped('id',I+'-B'+i+"-Text");r.addClass("sapUiCalHeadBText");r.writeClasses();r.write(">");r.writeEscaped(t);r.write("</span>");r.write("<span");r.writeAttributeEscaped('id',I+'-B'+i+"-AddText");r.addClass("sapUiCalHeadBAddText");r.writeClasses();r.write(">");r.writeEscaped(A);r.write("</span>");}else{r.writeEscaped(t);}r.write("</button>");}};
return H;},true);
sap.ui.predefine('sap/ui/unified/calendar/Month',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library'],function(q,C,L,I,D,a,b,l){"use strict";
var M=C.extend("sap.ui.unified.calendar.Month",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},otherMonth:{type:"boolean"},restoreOldDate:{type:"boolean"}}}}}});
M.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this.setProperty("secondaryCalendarType",s);this._oFormatYyyymmdd=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd",calendarType:sap.ui.core.CalendarType.Gregorian});this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long",calendarType:s});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._iColumns=7;this._aVisibleDays=[];};
M.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}this._aVisibleDays=null;};
M.prototype.onAfterRendering=function(){_.call(this);n.call(this);};
M.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){this._unbindMousemove(true);var s=h.call(this,this._getDate());if(!s&&this._oMoveSelectedDate){h.call(this,this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;m.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;m.call(this);}}};
M.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateMonth){if(O&&O.sParentAggregationName==="specialDates"){this._bNoFocus=true;}if(this._bInvalidateSync){o.call(this);}else{this._sInvalidateMonth=q.sap.delayedCall(0,this,o,[this]);}}};
M.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var r=this.removeAllAggregation("selectedDates");return r;};
M.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
M.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var r=this.removeAllAggregation("specialDates");return r;};
M.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
M.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var r=this.removeAllAggregation("disabledDates");return r;};
M.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};
M.prototype.setDate=function(i){var p=b.fromLocalJSDate(i,this.getPrimaryCalendarType());f.call(this,p,false);return this;};
M.prototype._setDate=function(i){var p=i.toLocalJSDate();this.setProperty("date",p,true);this._oDate=i;};
M.prototype._getDate=function(){if(!this._oDate){this._oDate=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());}return this._oDate;};
M.prototype.displayDate=function(i){var p=b.fromLocalJSDate(i,this.getPrimaryCalendarType());f.call(this,p,true);return this;};
M.prototype.setPrimaryCalendarType=function(s){this.setProperty("primaryCalendarType",s);this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long",calendarType:s});if(this._oDate){this._oDate=new b(this._oDate,s);}return this;};
M.prototype.setSecondaryCalendarType=function(s){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",s);this.invalidate();this._oFormatSecondaryLong=sap.ui.core.format.DateFormat.getInstance({style:"long",calendarType:s});return this;};
M.prototype._getSecondaryCalendarType=function(){var s;if(this._bSecondaryCalendarTypeSet){s=this.getSecondaryCalendarType();var p=this.getPrimaryCalendarType();if(s==p){s=undefined;}}return s;};
M.prototype._getLocale=function(){var p=this.getParent();if(p&&p.getLocale){return p.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
M.prototype._getLocaleData=function(){var p=this.getParent();if(p&&p._getLocaleData){return p._getLocaleData();}else if(!this._oLocaleData){var s=this._getLocale();var i=new sap.ui.core.Locale(s);this._oLocaleData=L.getInstance(i);}return this._oLocaleData;};
M.prototype._getFormatLong=function(){var s=this._getLocale();if(this._oFormatLong.oLocale.toString()!=s){var i=new sap.ui.core.Locale(s);this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long",calendarType:this.getPrimaryCalendarType()},i);if(this._oFormatSecondaryLong){this._oFormatSecondaryLong=sap.ui.core.format.DateFormat.getInstance({style:"long",calendarType:this._getSecondaryCalendarType()},i);}}return this._oFormatLong;};
M.prototype.getIntervalSelection=function(){var p=this.getParent();if(p&&p.getIntervalSelection){return p.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
M.prototype.getSingleSelection=function(){var p=this.getParent();if(p&&p.getSingleSelection){return p.getSingleSelection();}else{return this.getProperty("singleSelection");}};
M.prototype.getSelectedDates=function(){var p=this.getParent();if(p&&p.getSelectedDates){return p.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
M.prototype.getSpecialDates=function(){var p=this.getParent();if(p&&p.getSpecialDates){return p.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
M.prototype.getDisabledDates=function(){var p=this.getParent();if(p&&p.getDisabledDates){return p.getDisabledDates();}else{return this.getAggregation("disabledDates",[]);}};
M.prototype._getShowHeader=function(){var p=this.getParent();if(p&&p._getShowMonthHeader){return p._getShowMonthHeader();}else{return this.getProperty("showHeader");}};
M.prototype.getAriaLabelledBy=function(){var p=this.getParent();if(p&&p.getAriaLabelledBy){return p.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
M.prototype.getLegend=function(){var p=this.getParent();if(p&&p.getLegend){return p.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};
M.prototype._getFirstDayOfWeek=function(){var p=this.getParent();var F=0;if(p&&p.getFirstDayOfWeek){F=p.getFirstDayOfWeek();}else{F=this.getProperty("firstDayOfWeek");}if(F<0||F>6){var i=this._getLocaleData();F=i.getFirstDayOfWeek();}return F;};
M.prototype._getNonWorkingDays=function(){var p=this.getParent();var N;if(p&&p.getNonWorkingDays){N=p.getNonWorkingDays();}else{N=this.getProperty("nonWorkingDays");}if(N&&!q.isArray(N)){N=[];}return N;};
M.prototype._checkDateSelected=function(p){a._checkCalendarDate(p);var s=0;var S=this.getSelectedDates();var t=p.toUTCJSDate().getTime();var r=this.getPrimaryCalendarType();for(var i=0;i<S.length;i++){var R=S[i];var u=R.getStartDate();var v=0;if(u){u=b.fromLocalJSDate(u,r);v=u.toUTCJSDate().getTime();}var E=R.getEndDate();var w=0;if(E){E=b.fromLocalJSDate(E,r);w=E.toUTCJSDate().getTime();}if(t==v&&!E){s=1;break;}else if(t==v&&E){s=2;if(E&&t==w){s=5;}break;}else if(E&&t==w){s=3;break;}else if(E&&t>v&&t<w){s=4;break;}if(this.getSingleSelection()){break;}}return s;};
M.prototype._getDateType=function(p){a._checkCalendarDate(p);var t;var s=this.getSpecialDates();var T=p.toUTCJSDate().getTime();var r=this.getPrimaryCalendarType();for(var i=0;i<s.length;i++){var R=s[i];var S=R.getStartDate();var u=a.MAX_MILLISECONDS;if(S){S=b.fromLocalJSDate(S,r);u=S.toUTCJSDate().getTime();}var E=R.getEndDate();var v=-a.MAX_MILLISECONDS;if(E){E=b.fromLocalJSDate(E,r);v=E.toUTCJSDate().getTime();}if((T==u&&!E)||(T>=u&&T<=v)){t={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return t;};
M.prototype._checkDateEnabled=function(p){a._checkCalendarDate(p);var E=true;var r=this.getDisabledDates();var t=p.toUTCJSDate().getTime();var s=this.getPrimaryCalendarType();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(t<P._oMinDate.valueOf()||t>P._oMaxDate.valueOf()){return false;}}for(var i=0;i<r.length;i++){var R=r[i];var S=R.getStartDate();var u=0;if(S){S=b.fromLocalJSDate(S,s);u=S.toUTCJSDate().getTime();}var v=R.getEndDate();var w=0;if(v){v=b.fromLocalJSDate(v,s);w=v.toUTCJSDate().getTime();}if(v){if(t>u&&t<w){E=false;break;}}else if(t==u){E=false;break;}}return E;};
M.prototype.setWidth=function(w){this.setProperty("width",w,true);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);}return this;};
M.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){this._unbindMousemove(true);}var t=q(E.target);if(t.hasClass("sapUiCalItemText")){t=t.parent();}if(this._sLastTargetId&&this._sLastTargetId==t.attr("id")){return;}this._sLastTargetId=t.attr("id");if(t.hasClass("sapUiCalItem")){var O=this._getDate();if(!q.sap.containsOrEquals(this.getDomRef(),E.target)){var s=this.getSelectedDates();if(s.length>0&&this.getSingleSelection()){var S=s[0].getStartDate();if(S){S=b.fromLocalJSDate(S,this.getPrimaryCalendarType());}var i=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(t.attr("data-sap-day")));if(i.isSameOrAfter(S)){j.call(this,S,i);}else{j.call(this,i,S);}}}else{var F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(t.attr("data-sap-day"),this.getPrimaryCalendarType()));if(!F.isSame(O)){if(t.hasClass("sapUiCalItemOtherMonth")){this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}else{this._setDate(F);var p=h.call(this,F,true);if(p){this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}this._bMoveChange=true;}}}}};
M.prototype.onmouseup=function(E){if(this._bMouseMove){this._unbindMousemove(true);var F=this._getDate();var p=this._oItemNavigation.getItemDomRefs();for(var i=0;i<p.length;i++){var $=q(p[i]);if(!$.hasClass("sapUiCalItemOtherMonth")){if($.attr("data-sap-day")==this._oFormatYyyymmdd.format(F.toUTCJSDate(),true)){$.focus();break;}}}if(this._bMoveChange){var s=h.call(this,F);if(!s&&this._oMoveSelectedDate){h.call(this,this._oMoveSelectedDate);}this._bMoveChange=false;this._bMousedownChange=false;this._oMoveSelectedDate=undefined;m.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;m.call(this);}};
M.prototype.onsapselect=function(E){var s=h.call(this,this._getDate());if(s){m.call(this);}E.stopPropagation();E.preventDefault();};
M.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
M.prototype.onsappageupmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y-10);}else{F.setYear(y-1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};
M.prototype.onsappagedownmodifiers=function(E){var F=new b(this._getDate(),this.getPrimaryCalendarType());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y+10);}else{F.setYear(y+1);}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});E.preventDefault();};
M.prototype._updateSelection=function(){var s=this.getSelectedDates();if(s.length>0){var i=this.getPrimaryCalendarType();var p=s.map(function(S){var r=S.getStartDate();if(r){return b.fromLocalJSDate(r,i);}});var E=s[0].getEndDate();if(E){E=b.fromLocalJSDate(E,i);}j.call(this,p,E);}};
M.prototype._bindMousemove=function(F){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;if(F){this.fireEvent("_bindMousemove");}};
M.prototype._unbindMousemove=function(F){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;this._sLastTargetId=undefined;if(F){this.fireEvent("_unbindMousemove");}};
M.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var w=this.$().find(".sapUiCalWH");var p=this._getLocaleData();var s=this._getFirstWeekDay();var r=p.getDaysStandAlone("abbreviated",this.getPrimaryCalendarType());for(var i=0;i<w.length;i++){var W=w[i];q(W).text(r[(i+s)%7]);}n.call(this);};
M.prototype._handleBorderReached=function(i){var E=i.getParameter("event");var p=0;var O=this._getDate();var F=new b(O,this.getPrimaryCalendarType());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_DOWN){F.setDate(F.getDate()+7);}else{F.setDate(F.getDate()+1);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_UP){F.setDate(F.getDate()-7);}else{F.setDate(F.getDate()-1);}break;case"sappagedown":p=F.getMonth()+1;F.setMonth(p);if(p%12!=F.getMonth()){while(p!=F.getMonth()){F.setDate(F.getDate()-1);}}break;case"sappageup":p=F.getMonth()-1;F.setMonth(p);if(p<0){p=11;}if(p!=F.getMonth()){while(p!=F.getMonth()){F.setDate(F.getDate()-1);}}break;default:break;}this.fireFocus({date:F.toLocalJSDate(),otherMonth:true});}};
M.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);var p=this._getDate();var r=b.fromLocalJSDate(i,this.getPrimaryCalendarType());return a._isSameMonthAndYear(r,p);};
M.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
M.prototype._renderHeader=function(){if(this._getShowHeader()){var i=this._getDate();var p=this._getLocaleData();var r=p.getMonthsStandAlone("wide",this.getPrimaryCalendarType());this.$("Head").text(r[i.getMonth()]);}};
M.prototype._getFirstWeekDay=function(){return this._getFirstDayOfWeek();};
M.prototype._isMonthNameLong=function(w){var i;var W;for(i=0;i<w.length;i++){W=w[i];if(Math.abs(W.clientWidth-W.scrollWidth)>1){return true;}}return false;};
M.prototype._getVisibleDays=function(s,i){var N,p,r,t,F,u,y;if(!s){return this._aVisibleDays;}this._aVisibleDays=[];u=this._getFirstDayOfWeek();F=new b(s,this.getPrimaryCalendarType());F.setDate(1);t=F.getDay()-u;if(t<0){t=7+t;}if(t>0){F.setDate(1-t);}p=new b(F);N=(s.getMonth()+1)%12;do{y=p.getYear();r=new b(p,this.getPrimaryCalendarType());if(i&&y<1){r._bBeforeFirstYear=true;this._aVisibleDays.push(r);}else if(y>0&&y<10000){this._aVisibleDays.push(r);}p.setDate(p.getDate()+1);}while(p.getMonth()!==N||p.getDay()!==u);return this._aVisibleDays;};
function _(){var y=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true);var p=0;var r=this.$("days").get(0);var s=this.$("days").find(".sapUiCalItem");for(var i=0;i<s.length;i++){var $=q(s[i]);if($.attr("data-sap-day")===y){p=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,c,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,d,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,this._handleBorderReached,this);this.addDelegate(this._oItemNavigation);if(this._iColumns>1){this._oItemNavigation.setHomeEndColumnMode(true,true);}this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this._iColumns,true);}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(s);this._oItemNavigation.setFocusedIndex(p);this._oItemNavigation.setPageSize(s.length);}
function c(p){var r=p.getParameter("index");var E=p.getParameter("event");if(!E){return;}var O=this._getDate();var F=new b(O,this.getPrimaryCalendarType());var s=false;var t=true;var u=this._oItemNavigation.getItemDomRefs();var i=0;var $=q(u[r]);var v;if($.hasClass("sapUiCalItemOtherMonth")){if(E.type=="saphomemodifiers"&&(E.metaKey||E.ctrlKey)){F.setDate(1);this._focusDate(F);}else if(E.type=="sapendmodifiers"&&(E.metaKey||E.ctrlKey)){for(i=u.length-1;i>0;i--){v=q(u[i]);if(!v.hasClass("sapUiCalItemOtherMonth")){F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(v.attr("data-sap-day")),this.getPrimaryCalendarType());break;}}this._focusDate(F);}else{s=true;F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),this.getPrimaryCalendarType());if(!F){F=new b(O);}this._focusDate(O);if(E.type=="mousedown"||(this._sTouchstartYyyyMMdd&&E.type=="focusin"&&this._sTouchstartYyyyMMdd==$.attr("data-sap-day"))){t=false;this.fireFocus({date:O.toLocalJSDate(),otherMonth:false,restoreOldDate:true});}if(E.originalEvent&&E.originalEvent.type=="touchstart"){this._sTouchstartYyyyMMdd=$.attr("data-sap-day");}else{this._sTouchstartYyyyMMdd=undefined;}}}else{if(q(E.target).hasClass("sapUiCalWeekNum")){this._focusDate(F);}else{F=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day")),this.getPrimaryCalendarType());this._setDate(F);}this._sTouchstartYyyyMMdd=undefined;}if(E.type=="mousedown"&&this.getIntervalSelection()){this._sLastTargetId=$.attr("id");}if(t){this.fireFocus({date:F.toLocalJSDate(),otherMonth:s});}if(E.type=="mousedown"){e.call(this,E,F,r);}}
function d(i){var p=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();if(this.getIntervalSelection()){var r=this._oItemNavigation.getItemDomRefs();this._sLastTargetId=r[p].id;}e.call(this,E,F,p);}}
function e(E,F,i){if(E.button){return;}var s=h.call(this,F);if(s){this._bMousedownChange=true;}if(this._bMouseMove){this._unbindMousemove(true);this._bMoveChange=false;this._oMoveSelectedDate=undefined;}else if(s&&this.getIntervalSelection()&&this.$().is(":visible")){this._bindMousemove(true);this._oMoveSelectedDate=new b(F,this.getPrimaryCalendarType());}E.preventDefault();E.setMark("cancelAutoClose");}
function f(i,N){a._checkCalendarDate(i);var y=i.getYear();a._checkYearInValidRange(y);var F=true;if(!this.getDate()||!i.isSame(b.fromLocalJSDate(this.getDate(),i.getCalendarType()))){var p=new b(i);F=this.checkDateFocusable(i.toLocalJSDate());this.setProperty("date",i.toLocalJSDate(),true);this._oDate=p;}if(this.getDomRef()){if(F){this._focusDate(this._oDate,true,N);}else{g.call(this,N);}}}
M.prototype._focusDate=function(p,s,S){if(!s){this.setDate(p.toLocalJSDate());}var y=this._oFormatYyyymmdd.format(p.toUTCJSDate(),true);var r=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<r.length;i++){$=q(r[i]);if($.attr("data-sap-day")==y){if(document.activeElement!=r[i]){if(S){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}};
function g(N){var p=this.getRenderer().getStartDate(this);var $=this.$("days");var r;var s;var i=0;var t=0;if(this._sLastTargetId){r=this._oItemNavigation.getItemDomRefs();for(i=0;i<r.length;i++){s=q(r[i]);if(s.attr("id")==this._sLastTargetId){t=i;break;}}}if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderDays(R,this,p);R.flush($[0]);R.destroy();}this._renderHeader();this.fireEvent("_renderMonth",{days:$.find(".sapUiCalItem").length});_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}if(this._sLastTargetId){r=this._oItemNavigation.getItemDomRefs();if(t<=r.length-1){s=q(r[t]);this._sLastTargetId=s.attr("id");}}}
function h(p,r){if(!this._checkDateEnabled(p)){return false;}var s=this.getSelectedDates();var t;var u=this._oItemNavigation.getItemDomRefs();var $;var y;var i=0;var P=this.getParent();var A=this;var S;var v=this.getPrimaryCalendarType();if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(s.length>0){t=s[0];S=t.getStartDate();if(S){S=b.fromLocalJSDate(S,v);}}else{t=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",t,true);}if(this.getIntervalSelection()&&(!t.getEndDate()||r)&&S){var E;if(p.isBefore(S)){E=S;S=p;if(!r){t.setProperty("startDate",S.toLocalJSDate(),true);t.setProperty("endDate",E.toLocalJSDate(),true);}}else if(p.isSameOrAfter(S)){E=p;if(!r){t.setProperty("endDate",E.toLocalJSDate(),true);}}j.call(this,S,E);}else{j.call(this,p);t.setProperty("startDate",p.toLocalJSDate(),true);t.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var w=this._checkDateSelected(p);if(w>0){for(i=0;i<s.length;i++){S=s[i].getStartDate();if(S&&p.isSame(b.fromLocalJSDate(S,v))){A.removeAggregation("selectedDates",i,true);break;}}}else{t=new sap.ui.unified.DateRange({startDate:p.toLocalJSDate()});A.addAggregation("selectedDates",t,true);}y=this._oFormatYyyymmdd.format(p.toUTCJSDate(),true);for(i=0;i<u.length;i++){$=q(u[i]);if($.attr("data-sap-day")==y){if(w>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}
function j(s,E){if(!Array.isArray(s)){s=[s];}var p=this._oItemNavigation.getItemDomRefs();var $;var i=0;var S=false;var r=false;if(!E){var t=s.map(function(v){return this._oFormatYyyymmdd.format(v.toUTCJSDate(),true);},this);for(i=0;i<p.length;i++){$=q(p[i]);S=false;r=false;if(t.indexOf($.attr("data-sap-day"))>-1){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");S=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}k.call(this,$,S,r);}}else{var u;for(i=0;i<p.length;i++){$=q(p[i]);S=false;r=false;u=b.fromLocalJSDate(this._oFormatYyyymmdd.parse($.attr("data-sap-day"),sap.ui.core.CalendarType.Gregorian));if(u.isSame(s[0])){$.addClass("sapUiCalItemSelStart");S=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&u.isSame(E)){$.addClass("sapUiCalItemSelEnd");r=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&a._isBetween(u,s[0],E)){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&u.isSame(E)){$.addClass("sapUiCalItemSelEnd");r=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}k.call(this,$,S,r);}}}
function k($,s,E){if(!this.getIntervalSelection()){return;}var p="";var r=[];var t=this.getId();var u=false;p=$.attr("aria-describedby");if(p){r=p.split(" ");}var S=-1;var v=-1;for(var i=0;i<r.length;i++){var w=r[i];if(w==(t+"-Start")){S=i;}if(w==(t+"-End")){v=i;}}if(S>=0&&!s){r.splice(S,1);u=true;if(v>S){v--;}}if(v>=0&&!E){r.splice(v,1);u=true;}if(S<0&&s){r.push(t+"-Start");u=true;}if(v<0&&E){r.push(t+"-End");u=true;}if(u){p=r.join(" ");$.attr("aria-describedby",p);}}
function m(){if(this._bMouseMove){this._unbindMousemove(true);}this.fireSelect();}
function n(){if(!this._bNamesLengthChecked){var w;var W=this.$().find(".sapUiCalWH");var t=this._isMonthNameLong(W);var i=0;if(t){this._bLongWeekDays=false;var p=this._getLocaleData();var s=this._getFirstWeekDay();var r=p.getDaysStandAlone("narrow",this.getPrimaryCalendarType());for(i=0;i<W.length;i++){w=W[i];q(w).text(r[(i+s)%7]);}}else{this._bLongWeekDays=true;}this._bNamesLengthChecked=true;}}
function o(){this._sInvalidateMonth=undefined;g.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthPicker',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/library'],function(q,C,L,I,l){"use strict";
var M=C.extend("sap.ui.unified.calendar.MonthPicker",{metadata:{library:"sap.ui.unified",properties:{month:{type:"int",group:"Data",defaultValue:0},months:{type:"int",group:"Appearance",defaultValue:12},columns:{type:"int",group:"Appearance",defaultValue:3},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"}},events:{select:{},pageChange:{}}}});
M.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this._iMinMonth=0;this._iMaxMonth=11;};
M.prototype.onAfterRendering=function(){_.call(this);g.call(this);};
M.prototype.setMonth=function(m){this.setProperty("month",m,true);m=this.getProperty("month");if(m<0||m>11){throw new Error("Property month must be between 0 and 11; "+this);}if(this.getDomRef()){if(this.getMonths()<12){var s=this.getStartMonth();if(m>=s&&m<=s+this.getMonths()-1){f.call(this,m,true);this._oItemNavigation.focusItem(m-s);}else{h.call(this,m);}}else{f.call(this,m,true);this._oItemNavigation.focusItem(m);}}return this;};
M.prototype._getLocale=function(){var p=this.getParent();if(p&&p._getLocale){return p._getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
M.prototype._getLocaleData=function(){var p=this.getParent();if(p&&p._getLocaleData){return p._getLocaleData();}else if(!this._oLocaleData){var s=this._getLocale();var o=new sap.ui.core.Locale(s);this._oLocaleData=L.getInstance(o);}return this._oLocaleData;};
M.prototype.onsapspace=function(E){E.preventDefault();};
M.prototype.onsapselect=function(E){var i=this._oItemNavigation.getFocusedIndex();var m=i+this.getStartMonth();if(m>=this._iMinMonth&&m<=this._iMaxMonth){f.call(this,m);this.fireSelect();}};
M.prototype.onmouseup=function(E){if(this._bMousedownChange){this._bMousedownChange=false;this.fireSelect();}};
M.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;var m=this._oItemNavigation.getItemDomRefs();this._bLongMonth=false;var o=this._getLocaleData();var b=o.getMonthsStandAlone("wide",this.getPrimaryCalendarType());for(var i=0;i<m.length;i++){var $=q(m[i]);$.text(b[i]);}g.call(this);};
M.prototype.nextPage=function(){var s=this.getStartMonth();var i=this._oItemNavigation.getFocusedIndex();var m=i+s;var b=this.getMonths();m=m+b;if(m>11){m=11;}h.call(this,m);return this;};
M.prototype.previousPage=function(){var s=this.getStartMonth();var i=this._oItemNavigation.getFocusedIndex();var m=i+s;var b=this.getMonths();m=m-b;if(m<0){m=0;}h.call(this,m);return this;};
M.prototype.setMinMax=function(m,b){if(m==this._iMinMonth&&b==this._iMaxMonth){return this;}m=parseInt(m,10);if(isNaN(m)||m<0||m>11){m=0;}b=parseInt(b,10);if(isNaN(b)||b<0||b>11){b=11;}if(m<=b){this._iMinMonth=m;this._iMaxMonth=b;}else{this._iMaxMonth=m;this._iMinMonth=b;}if(this.getDomRef()){var j=this._oItemNavigation.getItemDomRefs();var k=this.getId().length+2;for(var i=0;i<j.length;i++){var D=q(j[i]);var n=parseInt(D.attr("id").slice(k),10);if(n<this._iMinMonth||n>this._iMaxMonth){D.addClass("sapUiCalItemDsbl");D.attr("aria-disabled",true);}else{D.removeClass("sapUiCalItemDsbl");D.removeAttr("aria-disabled");}}}return this;};
M.prototype.getStartMonth=function(){if(this.getMonths()<12){var F=this._oItemNavigation.getItemDomRefs()[0];return parseInt(F.id.slice(this.getId().length+2),10);}else{return 0;}};
function _(){var r=this.getDomRef();var D=this.$().find(".sapUiCalItem");var i=this.getColumns();var m=this.getMonths();var b=true;if(m<12){b=false;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,a,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,c,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,e,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(D);this._oItemNavigation.setCycling(b);this._oItemNavigation.setColumns(i,!b);var j=this.getMonth()-this.getStartMonth();this._oItemNavigation.setFocusedIndex(j);this._oItemNavigation.setPageSize(D.length);}
function a(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){d.call(this,E,i);}}
function c(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){d.call(this,E,i);}}
function d(E,i){if(E.button){return;}var m=i+this.getStartMonth();if(m>=this._iMinMonth&&m<=this._iMaxMonth){f.call(this,m);this._bMousedownChange=true;}E.preventDefault();E.setMark("cancelAutoClose");}
function e(o){var E=o.getParameter("event");if(E.type){var s=this.getStartMonth();var i=this._oItemNavigation.getFocusedIndex();var m=i+s;var b=this.getMonths();switch(E.type){case"sapnext":case"sapnextmodifiers":if(m<11){m++;h.call(this,m,true);}break;case"sapprevious":case"sappreviousmodifiers":if(m>0){m--;h.call(this,m,true);}break;case"sappagedown":if(m<12-b){m=m+b;h.call(this,m,true);}break;case"sappageup":if(m>b){m=m-b;h.call(this,m,true);}break;default:break;}}}
function f(m,n){var D=this._oItemNavigation.getItemDomRefs();var $;var s=this.getId()+"-m"+m;for(var i=0;i<D.length;i++){$=q(D[i]);if($.attr("id")==s){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}else{$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}}if(!n){this.setProperty("month",m,true);}}
function g(){if(!this._bNamesLengthChecked){var i=0;var m=this._oItemNavigation.getItemDomRefs();var t=false;var j=this.getMonths();var B=Math.ceil(12/j);var k=j-1;for(var b=0;b<B;b++){if(j<12){h.call(this,k);k=k+j;if(k>11){k=11;}}for(i=0;i<m.length;i++){var o=m[i];if(Math.abs(o.clientWidth-o.scrollWidth)>1){t=true;break;}}if(t){break;}}if(j<12){k=this.getMonth();h.call(this,k);}if(t){this._bLongMonth=false;var n=this._getLocaleData();var s=this.getPrimaryCalendarType();var p=n.getMonthsStandAlone("abbreviated",s);var r=n.getMonthsStandAlone("wide",s);for(i=0;i<m.length;i++){var $=q(m[i]);$.text(p[i]);$.attr("aria-label",r[i]);}}else{this._bLongMonth=true;}this._bNamesLengthChecked=true;}}
function h(m,F){var b=this._oItemNavigation.getItemDomRefs();if(b.legth>11){return;}var j=b.length;var s=Math.floor(m/j)*j;if(s+j>12){s=12-j;}var o=this._getLocaleData();var k=[];var n=[];var p=this.getPrimaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){k=o.getMonthsStandAlone("wide",p);}else{k=o.getMonthsStandAlone("abbreviated",p);n=o.getMonthsStandAlone("wide",p);}var S=this.getMonth();for(var i=0;i<b.length;i++){var r=i+s;var D=q(b[i]);D.text(k[i+s]);D.attr("id",this.getId()+"-m"+(i+s));if(!this._bLongMonth){D.attr("aria-label",n[i+s]);}if(r==S){D.addClass("sapUiCalItemSel");D.attr("aria-selected","true");}else{D.removeClass("sapUiCalItemSel");D.attr("aria-selected","false");}if(r<this._iMinMonth||r>this._iMaxMonth){D.addClass("sapUiCalItemDsbl");D.attr("aria-disabled",true);}else{D.removeClass("sapUiCalItemDsbl");D.removeAttr("aria-disabled");}}this._oItemNavigation.focusItem(m-s);if(F){this.firePageChange();}}
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthPickerRenderer',['jquery.sap.global'],function(q){"use strict";var M={};
M.render=function(r,m){var a=m.getMonth();var b=m.getMonths();var s=0;var c=m.getColumns();var t=m.getTooltip_AsString();var l=m._getLocaleData();var I=m.getId();var w="";var d=[];var e=[];var C=m.getPrimaryCalendarType();if(m._bLongMonth||!m._bNamesLengthChecked){d=l.getMonthsStandAlone("wide",C);}else{d=l.getMonthsStandAlone("abbreviated",C);e=l.getMonthsStandAlone("wide",C);}r.write("<div");r.writeControlData(m);r.addClass("sapUiCalMonthPicker");r.writeClasses();if(t){r.writeAttributeEscaped('title',t);}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:"false"});r.write(">");var A;if(b>12){b=12;}else if(b<12){s=Math.floor(a/b)*b;if(s+b>12){s=12-b;}}if(c>0){w=(100/c)+"%";}else{w=(100/b)+"%";}for(var i=0;i<b;i++){var f=i+s;A={role:"gridcell"};if(!m._bLongMonth&&m._bNamesLengthChecked){A["label"]=e[f];}if(c>0&&i%c==0){r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.write(">");}r.write("<div");r.writeAttribute("id",I+"-m"+(f));r.addClass("sapUiCalItem");if(f==a){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(f<m._iMinMonth||f>m._iMaxMonth){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.addStyle("width",w);r.writeClasses();r.writeStyles();r.writeAccessibilityState(null,A);r.write(">");r.write(d[f]);r.write("</div>");if(c>0&&((i+1)%c==0)){r.write("</div>");}}r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthRenderer',['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/CalendarLegend'],function(q,C,a,b){"use strict";var M={};
M.render=function(r,m){var d=this.getStartDate(m);var t=m.getTooltip_AsString();var c=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");var i=m.getId();var A={value:i+"-Descr",append:true};var w=m.getWidth();r.write("<div");r.writeControlData(m);r.addClass(this.getClass(m));if(m._getSecondaryCalendarType()){r.addClass("sapUiCalMonthSecType");}r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}if(m._getShowHeader()){A.value=A.value+" "+i+"-Head";}if(w){r.addStyle("width",w);r.writeStyles();}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+c.getText("CALENDAR_DIALOG")+"</span>");if(m.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+c.getText("CALENDAR_START_DATE")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+c.getText("CALENDAR_END_DATE")+"</span>");}this.renderMonth(r,m,d);r.write("</div>");};
M.getStartDate=function(m){return m._getDate();};
M.getClass=function(m){var c="sapUiCalMonthView",s=m.getPrimaryCalendarType(),S=m.getShowWeekNumbers();if(s==sap.ui.core.CalendarType.Islamic||!S){c=c+" sapUiCalNoWeekNum";}return c;};
M.renderMonth=function(r,m,d){var i=m.getId();this.renderHeader(r,m,d);r.write("<div id=\""+i+"-days\" class=\"sapUiCalItems\">");this.renderDays(r,m,d);r.write("</div>");};
M.renderHeader=function(r,m,d){var l=m._getLocaleData();var f=m._getFirstDayOfWeek();var i=m.getId();var c=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");this.renderHeaderLine(r,m,l,d);r.write("<div");r.writeAttribute("id",i+"-CW");r.addStyle("display","none");r.writeStyles();r.writeAccessibilityState(null,{role:"columnheader"});r.write(">");r.write(c.getText("CALENDAR_WEEK"));r.write("</div>");r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.write(">");this.renderDayNames(r,m,l,f,7,true,undefined);r.write("</div>");};
M.renderHeaderLine=function(r,m,l,d){C._checkCalendarDate(d);if(m._getShowHeader()){var i=m.getId();var c=m.getPrimaryCalendarType();var e=l.getMonthsStandAlone("wide",c);r.write("<div id=\""+i+"-Head\"class=\"sapUiCalHeadText\" >");r.write(e[d.getMonth()]);r.write("</div>");}};
M.renderDayNames=function(r,m,l,s,d,D,w){var f=m._getFirstDayOfWeek();var I=m.getId();var c="";var e=m.getPrimaryCalendarType();var W=[];if(m._bLongWeekDays||!m._bNamesLengthChecked){W=l.getDaysStandAlone("abbreviated",e);}else{W=l.getDaysStandAlone("narrow",e);}var g=l.getDaysStandAlone("wide",e);for(var i=0;i<d;i++){r.write("<div");r.addClass("sapUiCalWH");if(D){c=I+"-WH"+((i+f)%7);}else{c=I+"-WH"+i;}r.writeAttribute("id",c);if(i==0){r.addClass("sapUiCalFirstWDay");}if(w){r.addStyle("width",w);}r.writeAccessibilityState(null,{role:"columnheader",label:g[(i+s)%7]});r.writeClasses();r.writeStyles();r.write(">");r.write(W[(i+s)%7]);r.write("</div>");}};
M.renderDays=function(r,m,d){var w,D,l,h,i,t,s;C._checkCalendarDate(d);if(!d){d=m._getFocusedDate();}t=d.toUTCJSDate().getTime();if(!t&&t!==0){throw new Error("Date is invalid "+m);}h=this.getDayHelper(m,d);D=m._getVisibleDays(d,true);s=m.getShowWeekNumbers();w=m.getPrimaryCalendarType()!==sap.ui.core.CalendarType.Islamic&&s;l=D.length;for(i=0;i<l;i++){this.renderDay(r,m,D[i],h,true,w,-1);}};
M.getDayHelper=function(m,d){var l,L,o=m._getLocaleData(),h={sLocale:m._getLocale(),oLocaleData:o,iMonth:d.getMonth(),iYear:d.getYear(),iFirstDayOfWeek:m._getFirstDayOfWeek(),iWeekendStart:o.getWeekendStart(),iWeekendEnd:o.getWeekendEnd(),aNonWorkingDays:m._getNonWorkingDays(),sToday:o.getRelativeDay(0),oToday:a.fromLocalJSDate(new Date(),m.getPrimaryCalendarType()),sId:m.getId(),oFormatLong:m._getFormatLong(),sSecondaryCalendarType:m._getSecondaryCalendarType(),oLegend:undefined};L=m.getLegend();if(L&&typeof L==="string"){l=sap.ui.getCore().byId(L);if(l){if(!(l instanceof b)){throw new Error(l+" is not an sap.ui.unified.CalendarLegend. "+m);}h.oLegend=l;}else{q.sap.log.warning("CalendarLegend "+L+" does not exist!",m);}}return h;};
M.renderDay=function(r,m,d,h,o,w,n,W,D){C._checkCalendarDate(d);var s=new a(d,h.sSecondaryCalendarType),A={role:"gridcell",selected:false,label:"",describedby:""},B=d._bBeforeFirstYear;var y=m._oFormatYyyymmdd.format(d.toUTCJSDate(),true);var c=d.getDay();var S=m._checkDateSelected(d);var t=m._getDateType(d);var e=m._checkDateEnabled(d);var i=0;if(B){e=false;}var f=0;if(w){f=C.calculateWeekNumber(d.toUTCJSDate(),h.iYear,h.sLocale,h.oLocaleData);A["describedby"]=h.sId+"-CW"+" "+h.sId+"-WNum-"+f;}if(!D){var g="";if(n<0){g=h.sId+"-WH"+c;}else{g=h.sId+"-WH"+n;}A["describedby"]=A["describedby"]+" "+g;}r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");r.addClass("sapUiCalWDay"+c);if(W){r.addStyle("width",W);}if(c==h.iFirstDayOfWeek){r.addClass("sapUiCalFirstWDay");}if(o&&h.iMonth!=d.getMonth()){r.addClass("sapUiCalItemOtherMonth");A["disabled"]=true;}if(d.isSame(h.oToday)){r.addClass("sapUiCalItemNow");A["label"]=h.sToday+" ";}if(S>0){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(S==2){r.addClass("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(S==3){r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(S==4){r.addClass("sapUiCalItemSelBetween");}else if(S==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}if(t&&t.type!=sap.ui.unified.CalendarDayType.None){if(t.type===sap.ui.unified.CalendarDayType.NonWorking){r.addClass("sapUiCalItemWeekEnd");}else{r.addClass("sapUiCalItem"+t.type);if(t.tooltip){r.writeAttributeEscaped('title',t.tooltip);}}}if(m.getParent()&&m.getParent().getMetadata().getName()==="CalendarOneMonthInterval"&&d.getMonth()!==m.getStartDate().getMonth()){r.addClass("sapUiCalItemOtherMonth");}if(!e){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}if(h.aNonWorkingDays){for(i=0;i<h.aNonWorkingDays.length;i++){if(c==h.aNonWorkingDays[i]){r.addClass("sapUiCalItemWeekEnd");break;}}}else if((c>=h.iWeekendStart&&c<=h.iWeekendEnd)||(h.iWeekendEnd<h.iWeekendStart&&(c>=h.iWeekendStart||c<=h.iWeekendEnd))){r.addClass("sapUiCalItemWeekEnd");}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-day",y);if(D){A["label"]=A["label"]+h.aWeekDaysWide[c]+" ";}A["label"]=A["label"]+h.oFormatLong.format(d.toUTCJSDate(),true);if(t&&t.type!=sap.ui.unified.CalendarDayType.None){var T,j;if(h.oLegend){var l=h.oLegend._getItemByType(t.type);if(l){T=l.getId()+"-Text";}}if(!T){j=b.getTypeAriaText(t.type);if(j){T=j.getId();}}if(T){A["describedby"]+=" "+T;}}if(h.sSecondaryCalendarType){A["label"]=A["label"]+" "+m._oFormatSecondaryLong.format(s.toUTCJSDate(),true);}r.writeAccessibilityState(null,A);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");if(!B){r.write(d.getDate());}r.write("</span>");if(w&&c==h.iFirstDayOfWeek){r.write("<span");r.writeAttribute("id",h.sId+"-WNum-"+f);r.addClass("sapUiCalWeekNum");r.writeClasses();r.writeAccessibilityState(null,{role:"rowheader",desribedby:h.sId+"-CW"});r.write(">");r.write(f);r.write("</span>");}if(D){r.write("<span");r.addClass("sapUiCalDayName");r.writeClasses();r.write(">");r.write(h.aWeekDays[c]);r.write("</span>");}if(h.sSecondaryCalendarType){r.write("<span");r.addClass("sapUiCalItemSecText");r.writeClasses();r.write(">");r.write(s.getDate());r.write("</span>");}r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthsRow',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library'],function(q,C,L,I,D,a,c,l){"use strict";
var M=C.extend("sap.ui.unified.calendar.MonthsRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},months:{type:"int",group:"Appearance",defaultValue:12},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});
M.prototype.init=function(){this._oFormatYyyymm=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd",calendarType:sap.ui.core.CalendarType.Gregorian});this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({pattern:"MMMM y"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};
M.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateMonths){q.sap.clearDelayedCall(this._sInvalidateMonths);}};
M.prototype.onAfterRendering=function(){_.call(this);s.call(this);};
M.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){v.call(this,true);n.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;r.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;r.call(this);}}};
M.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateMonths){if(this._bInvalidateSync){t.call(this);}else{this._sInvalidateMonths=q.sap.delayedCall(0,this,t);}}};
M.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
M.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var b=this.destroyAggregation("selectedDates");return b;};
M.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
M.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var b=this.destroyAggregation("specialDates");return b;};
M.prototype.setDate=function(b){h.call(this,c.fromLocalJSDate(b),false);return this;};
M.prototype._setDate=function(b){var i=b.toLocalJSDate();this.setProperty("date",i,true);this._oDate=b;};
M.prototype._getDate=function(){if(!this._oDate){this._oDate=new c();}return this._oDate;};
M.prototype.setStartDate=function(S){a._checkJSDateObject(S);var b,y,O;y=S.getFullYear();a._checkYearInValidRange(y);b=c.fromLocalJSDate(S);this.setProperty("startDate",S,true);this._oStartDate=b;this._oStartDate.setDate(1);if(this.getDomRef()){O=this._getDate().toLocalJSDate();this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.setDate(O);}}return this;};
M.prototype._getStartDate=function(){if(!this._oStartDate){this._oStartDate=new c();this._oStartDate.setDate(1);}return this._oStartDate;};
M.prototype.displayDate=function(b){h.call(this,c.fromLocalJSDate(b),true);return this;};
M.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
M.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var b=this._getLocale();var i=new sap.ui.core.Locale(b);this._oLocaleData=L.getInstance(i);}return this._oLocaleData;};
M.prototype._getFormatLong=function(){var b=this._getLocale();if(this._oFormatLong.oLocale.toString()!=b){var i=new sap.ui.core.Locale(b);this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long"},i);}return this._oFormatLong;};
M.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
M.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
M.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
M.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
M.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};
M.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
M.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};
M.prototype._checkDateSelected=function(b){var R,S,E,T,w=0,x=0,y=0,i,z,A;a._checkCalendarDate(b);z=this.getSelectedDates();A=new c(b);A.setDate(1);T=A.toUTCJSDate().getTime();for(i=0;i<z.length;i++){R=z[i];S=R.getStartDate();w=0;if(S){S=c.fromLocalJSDate(S);S.setDate(1);w=S.toUTCJSDate().getTime();}E=R.getEndDate();x=0;if(E){E=c.fromLocalJSDate(E);E.setDate(1);x=E.toUTCJSDate().getTime();}if(T==w&&!E){y=1;break;}else if(T==w&&E){y=2;if(E&&T==x){y=5;}break;}else if(E&&T==x){y=3;break;}else if(E&&T>w&&T<x){y=4;break;}if(this.getSingleSelection()){break;}}return y;};
M.prototype._getDateType=function(b){a._checkCalendarDate(b);var T,R,i,S,w=0,E,x=0,y,z=this.getSpecialDates(),A=new c(b);A.setDate(1);y=A.toUTCJSDate().getTime();for(i=0;i<z.length;i++){R=z[i];S=R.getStartDate();w=0;if(S){S=c.fromLocalJSDate(S);S.setDate(1);w=S.toUTCJSDate().getTime();}E=R.getEndDate();x=0;if(E){E=c.fromLocalJSDate(E);E.setDate(a._daysInMonth(E));x=E.toUTCJSDate().getTime();}if((y==w&&!E)||(y>=w&&y<=x)){T={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return T;};
M.prototype._checkMonthEnabled=function(b){a._checkCalendarDate(b);var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(a._isOutside(b,P._oMinDate,P._oMaxDate)){return false;}}return true;};
M.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){v.call(this,true);}var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(T.hasClass("sapUiCalItem")){var O=this._getDate();var F=c.fromLocalJSDate(this._oFormatYyyymm.parse(T.attr("data-sap-month")));F.setDate(1);if(!F.isSame(O)){this._setDate(F);n.call(this,F,true);this._bMoveChange=true;}}};
M.prototype.onmouseup=function(E){if(this._bMouseMove){v.call(this,true);var F=this._getDate();var b=this._oItemNavigation.getItemDomRefs();for(var i=0;i<b.length;i++){var $=q(b[i]);if($.attr("data-sap-month")==this._oFormatYyyymm.format(F.toUTCJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var T=q(E.target);if(T.hasClass("sapUiCalItemText")){T=T.parent();}if(T.hasClass("sapUiCalItem")){F=c.fromLocalJSDate(this._oFormatYyyymm.parse(T.attr("data-sap-month")));F.setDate(1);}n.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;r.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;r.call(this);}};
M.prototype.onsapselect=function(E){var S=n.call(this,this._getDate());if(S){r.call(this);}E.stopPropagation();E.preventDefault();};
M.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
M.prototype.onsappageupmodifiers=function(E){var F=new c(this._getDate());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y-10);}else{var i=this.getMonths();if(i<=12){F.setYear(y-1);}else{F.setMonth(F.getMonth()-i);}}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});E.preventDefault();};
M.prototype.onsappagedownmodifiers=function(E){var F=new c(this._getDate());var y=F.getYear();if(E.metaKey||E.ctrlKey){F.setYear(y+10);}else{var i=this.getMonths();if(i<=12){F.setYear(y+1);}else{F.setMonth(F.getMonth()+i);}}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});E.preventDefault();};
M.prototype.onThemeChanged=function(){if(this._bNoThemeChange){return;}this._bNamesLengthChecked=undefined;this._bLongWeekDays=undefined;var b=this._getLocaleData();var w=b.getMonthsStandAlone("wide");var x=this.$("months").children();var y=this._getStartDate().getMonth();for(var i=0;i<x.length;i++){var $=q(q(x[i]).children(".sapUiCalItemText"));$.text(w[(i+y)%12]);}s.call(this);};
M.prototype.checkDateFocusable=function(b){a._checkJSDateObject(b);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new c(S);E.setDate(1);E.setMonth(E.getMonth()+this.getMonths());var i=c.fromLocalJSDate(b);return i.isSameOrAfter(S)&&i.isBefore(E);};
M.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
function _(){var b=this._getDate();var y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);var w=0;var R=this.$("months").get(0);var x=this.$("months").children(".sapUiCalItem");for(var i=0;i<x.length;i++){var $=q(x[i]);if($.attr("data-sap-month")===y){w=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,d,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,e,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,f,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(x);this._oItemNavigation.setFocusedIndex(w);this._oItemNavigation.setPageSize(x.length);}
function d(b){var i=b.getParameter("index");var E=b.getParameter("event");if(!E){return;}var O=this._getDate();var F=new c(O);var w=this._oItemNavigation.getItemDomRefs();var $=q(w[i]);F=c.fromLocalJSDate(this._oFormatYyyymm.parse($.attr("data-sap-month")));F.setDate(1);this._setDate(F);this.fireFocus({date:F.toLocalJSDate(),notVisible:false});if(E.type=="mousedown"){g.call(this,E,F,i);}}
function e(b){var i=b.getParameter("index");var E=b.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();g.call(this,E,F,i);}}
function f(b){var E=b.getParameter("event");var i=this.getMonths();var O=this._getDate();var F=new c(O);if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setMonth(F.getMonth()+1);break;case"sapprevious":case"sappreviousmodifiers":F.setMonth(F.getMonth()-1);break;case"sappagedown":F.setMonth(F.getMonth()+i);break;case"sappageup":F.setMonth(F.getMonth()-i);break;default:break;}this.fireFocus({date:F.toLocalJSDate(),notVisible:true});}}
function g(E,F,i){if(E.button){return;}var S=n.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){v.call(this,true);this._bMoveChange=false;}else if(S&&this.getIntervalSelection()&&this.$().is(":visible")){u.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}
function h(b,N){a._checkCalendarDate(b);var y=b.getYear();a._checkYearInValidRange(y);var F=true;if(!this.getDate()||!b.isSame(c.fromLocalJSDate(this.getDate()))){var i=new c(b);i.setDate(1);F=this.checkDateFocusable(b.toLocalJSDate());if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",b.toLocalJSDate(),true);this._oDate=i;}if(this.getDomRef()){if(F){j.call(this,this._oDate,N);}else{k.call(this,N);}}}
function j(b,N){var y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);var w=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<w.length;i++){$=q(w[i]);if($.attr("data-sap-month")==y){if(document.activeElement!=w[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}
function k(N){var b=this._getStartDate();var $=this.$("months");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderMonths(R,this,b);R.flush($[0]);R.destroy();}m.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}
function m(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var b=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,b,S);R.flush($[0]);R.destroy();}}}
function n(b,w){if(!this._checkMonthEnabled(b)){return false;}var S=this.getSelectedDates();var x;var y=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var A=this;var z;if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){x=S[0];z=x.getStartDate();if(z){z=c.fromLocalJSDate(z);z.setDate(1);}}else{x=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",x,true);}if(this.getIntervalSelection()&&(!x.getEndDate()||w)&&z){var E;if(b.isBefore(z)){E=z;z=b;if(!w){x.setProperty("startDate",z.toLocalJSDate(),true);x.setProperty("endDate",E.toLocalJSDate(),true);}}else if(b.isSameOrAfter(z)){E=b;if(!w){x.setProperty("endDate",E.toLocalJSDate(),true);}}o.call(this,z,E);}else{o.call(this,b);x.setProperty("startDate",b.toLocalJSDate(),true);x.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var B=this._checkDateSelected(b);if(B>0){for(i=0;i<S.length;i++){z=S[i].getStartDate();if(z){z=c.fromLocalJSDate(z);z.setDate(1);if(b.isSame(z)){A.removeAggregation("selectedDates",i,true);break;}}}}else{x=new sap.ui.unified.DateRange({startDate:b.toLocalJSDate()});A.addAggregation("selectedDates",x,true);}Y=this._oFormatYyyymm.format(b.toUTCJSDate(),true);for(i=0;i<y.length;i++){$=q(y[i]);if($.attr("data-sap-month")==Y){if(B>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}
function o(S,E){var b=this._oItemNavigation.getItemDomRefs();var $;var i=0;var w=false;var x=false;if(!E){var y=this._oFormatYyyymm.format(S.toUTCJSDate(),true);for(i=0;i<b.length;i++){$=q(b[i]);w=false;x=false;if($.attr("data-sap-month")==y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");w=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}p.call(this,$,w,x);}}else{var z;for(i=0;i<b.length;i++){$=q(b[i]);w=false;x=false;z=c.fromLocalJSDate(this._oFormatYyyymm.parse($.attr("data-sap-month")));z.setDate(1);if(z.isSame(S)){$.addClass("sapUiCalItemSelStart");w=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&z.isSame(E)){$.addClass("sapUiCalItemSelEnd");x=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&a._isBetween(z,S,E)){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&z.isSame(E)){$.addClass("sapUiCalItemSelEnd");x=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}p.call(this,$,w,x);}}}
function p($,S,E){if(!this.getIntervalSelection()){return;}var b="";var w=[];var x=this.getId();var y=false;b=$.attr("aria-describedby");if(b){w=b.split(" ");}var z=-1;var A=-1;for(var i=0;i<w.length;i++){var B=w[i];if(B==(x+"-Start")){z=i;}if(B==(x+"-End")){A=i;}}if(z>=0&&!S){w.splice(z,1);y=true;if(A>z){A--;}}if(A>=0&&!E){w.splice(A,1);y=true;}if(z<0&&S){w.push(x+"-Start");y=true;}if(A<0&&E){w.push(x+"-End");y=true;}if(y){b=w.join(" ");$.attr("aria-describedby",b);}}
function r(){if(this._bMouseMove){v.call(this,true);}this.fireSelect();}
function s(){if(!this._bNamesLengthChecked){var i=0;var w=this.$("months").children();var T=false;var x=this.getMonths();var B=Math.ceil(12/x);var y=0;var z=this._getLocaleData();var A=z.getMonthsStandAlone("wide");var $;for(var b=0;b<B;b++){if(x<12){for(i=0;i<w.length;i++){$=q(q(w[i]).children(".sapUiCalItemText"));$.text(A[(i+y)%12]);}y=y+x;if(y>11){y=11;}}for(i=0;i<w.length;i++){var E=w[i];if(Math.abs(E.clientWidth-E.scrollWidth)>1){T=true;break;}}if(T){break;}}if(x<12){y=this._getStartDate().getMonth();for(i=0;i<w.length;i++){$=q(q(w[i]).children(".sapUiCalItemText"));$.text(A[(i+y)%12]);}}if(T){this._bLongMonth=false;var F=z.getMonthsStandAlone("abbreviated");y=this._getStartDate().getMonth();for(i=0;i<w.length;i++){$=q(q(w[i]).children(".sapUiCalItemText"));$.text(F[(i+y)%12]);}}else{this._bLongMonth=true;}this._bNamesLengthChecked=true;}}
function t(){this._sInvalidateMonths=undefined;k.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}
function u(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}
function v(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/MonthsRowRenderer',['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate'],function(q,C,a){"use strict";var M={};
M.render=function(r,m){var d=m._getStartDate();var t=m.getTooltip_AsString();var i=m.getId();var A={value:i+"-Descr",append:true};r.write("<div");r.writeControlData(m);r.addClass("sapUiCalMonthsRow");r.addClass("sapUiCalRow");r.writeClasses();if(t){r.writeAttributeEscaped("title",t);}if(m._getShowHeader()){A.value=A.value+" "+i+"-Head";}r.writeAccessibilityState(m,{role:"grid",readonly:"true",multiselectable:!m.getSingleSelection()||m.getIntervalSelection(),labelledby:A});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+m._rb.getText("CALENDAR_DIALOG")+"</span>");if(m.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+m._rb.getText("CALENDAR_START_MONTH")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+m._rb.getText("CALENDAR_END_MONTH")+"</span>");}this.renderRow(r,m,d);r.write("</div>");};
M.renderRow=function(r,m,d){var i=m.getId();this.renderHeader(r,m,d);r.write("<div id=\""+i+"-months\" class=\"sapUiCalItems\">");this.renderMonths(r,m,d);r.write("</div>");};
M.renderHeader=function(r,m,d){C._checkCalendarDate(d);if(m._getShowHeader()){var l=m._getLocaleData();var i=m.getId();r.write("<div id=\""+i+"-Head\">");this.renderHeaderLine(r,m,l,d);r.write("</div>");}};
M.renderHeaderLine=function(r,m,l,d){C._checkCalendarDate(d);var I=m.getId();var b=m.getMonths();var o=new a(d);var w="";var y=0;var Y=[];var i=0;for(i=0;i<b;i++){y=o.getYear();if(Y.length>0&&Y[Y.length-1].iYear==y){Y[Y.length-1].iMonths++;}else{Y.push({iYear:y,iMonths:1});}o.setMonth(o.getMonth()+1);}for(i=0;i<Y.length;i++){var c=Y[i];w=(100/b*c.iMonths)+"%";r.write("<div id=\""+I+"-Head"+i+"\"class=\"sapUiCalHeadText\" style=\"width:"+w+"\">");r.write(c.iYear);r.write("</div>");}};
M.renderMonths=function(r,m,d){var h=this.getHelper(m,d);var b=m.getMonths();var w=(100/b)+"%";var o=new a(d);o.setDate(1);for(var i=0;i<b;i++){this.renderMonth(r,m,o,h,w);o.setMonth(o.getMonth()+1);}};
M.getHelper=function(m,d){C._checkCalendarDate(d);var h={};h.sLocale=m._getLocale();h.oLocaleData=m._getLocaleData();h.oToday=new a();h.sCurrentMonth=m._rb.getText("CALENDAR_CURRENT_MONTH");h.sId=m.getId();h.oFormatLong=m._getFormatLong();if(m._bLongMonth||!m._bNamesLengthChecked){h.aMonthNames=h.oLocaleData.getMonthsStandAlone("wide");}else{h.aMonthNames=h.oLocaleData.getMonthsStandAlone("abbreviated");h.aMonthNamesWide=h.oLocaleData.getMonthsStandAlone("wide");}var l=m.getLegend();if(l){var L=sap.ui.getCore().byId(l);if(L){if(!(L instanceof sap.ui.unified.CalendarLegend)){throw new Error(L+" is not an sap.ui.unified.CalendarLegend. "+m);}h.aTypes=L.getItems();}else{q.sap.log.warning("CalendarLegend "+l+" does not exist!",m);}}else{h.aTypes=[];}return h;};
M.renderMonth=function(r,m,d,h,w){C._checkCalendarDate(d);var A={role:"gridcell",selected:false,label:"",describedby:""};if(!m._bLongMonth&&m._bNamesLengthChecked){A["label"]=h.aMonthNamesWide[d.getMonth()];}var y=m._oFormatYyyymm.format(d.toUTCJSDate(),true);var s=m._checkDateSelected(d);var t=m._getDateType(d);var e=m._checkMonthEnabled(d);r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");if(w){r.addStyle("width",w);}if(C._isSameMonthAndYear(d,h.oToday)){r.addClass("sapUiCalItemNow");A["label"]=h.sCurrentMonth+" ";}if(s>0){r.addClass("sapUiCalItemSel");A["selected"]=true;}if(s==2){r.addClass("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(s==3){r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(s==4){r.addClass("sapUiCalItemSelBetween");}else if(s==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}if(t&&t.type!=sap.ui.unified.CalendarDayType.None){r.addClass("sapUiCalItem"+t.type);if(t.tooltip){r.writeAttributeEscaped('title',t.tooltip);}}if(!e){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-month",y);A["label"]=A["label"]+h.oFormatLong.format(d.toUTCJSDate(),true);if(t&&t.type!=sap.ui.unified.CalendarDayType.None){for(var i=0;i<h.aTypes.length;i++){var l=h.aTypes[i];if(l.getType()==t.type){A["label"]=A["label"]+"; "+l.getText();break;}}}r.writeAccessibilityState(null,A);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");r.write(h.aMonthNames[d.getMonth()]);r.write("</span>");r.write("</div>");};
return M;},true);
sap.ui.predefine('sap/ui/unified/calendar/OneMonthDatesRow',['jquery.sap.global','sap/ui/unified/calendar/DatesRow','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/unified/library'],function(q,D,C,a,l){"use strict";
var O=D.extend("sap.ui.unified.calendar.OneMonthDatesRow",{metadata:{library:"sap.ui.unified"}});
O.prototype.init=function(){D.prototype.init.apply(this,arguments);this.iMode=2;};
O.prototype.setMode=function(m){var s=this.getSelectedDates(),S,c=this.iMode!==m;this.iMode=m;if(c&&s.length){if(this.iMode<2){S=this.getStartDate();}s[0].setProperty('startDate',S,true);}return this;};
O.prototype.getMode=function(){return this.iMode;};
O.prototype.selectDate=function(d){if(this.iMode<2&&this.getSelectedDates().length){this.getSelectedDates()[0].setStartDate(d);}return this;};
O.prototype.setDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){return this;}D.prototype.setDate.apply(this,arguments);return this;};
O.prototype.displayDate=function(d){if(!this._bNoRangeCheck&&!this.checkDateFocusable(d)){return this;}D.prototype.displayDate.apply(this,arguments);return this;};
O.prototype.onsaphome=function(e){var c=a.fromLocalJSDate(this.getStartDate());i(e);this._setDate(c);this._focusDate(c);this.fireFocus({date:c.toLocalJSDate(),otherMonth:false});};
O.prototype.onsapend=function(e){var s=this.getStartDate(),L;L=a.fromLocalJSDate(s);L.setDate(C._daysInMonth(L));i(e);this._setDate(L);this._focusDate(L);this.fireFocus({date:L.toLocalJSDate(),otherMonth:false});};
function i(e){e.stopPropagation();e.preventDefault();e.stopImmediatePropagation(true);}
return O;},true);
sap.ui.predefine('sap/ui/unified/calendar/OneMonthDatesRowRenderer',['jquery.sap.global','sap/ui/core/Renderer','sap/ui/unified/calendar/CalendarUtils','./MonthRenderer','./DatesRowRenderer'],function(q,R,C,M,D){"use strict";var O=R.extend(D);
O.getClass=function(d){if(d.iMode<2){return M.getClass(d);}else{return D.getClass(d);}};
O.renderDays=function(r,d,o){if(d.iMode<2){M.renderDays(r,d,o);}else{D.renderDays(r,d,o);}};
return O;},true);
sap.ui.predefine('sap/ui/unified/calendar/TimesRow',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library'],function(q,C,L,I,D,a,U,l){"use strict";
var T=C.extend("sap.ui.unified.calendar.TimesRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});
T.prototype.init=function(){this._oFormatYyyyMMddHHmm=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMddHHmm",calendarType:sap.ui.core.CalendarType.Gregorian});this._oFormatLong=sap.ui.core.format.DateFormat.getDateTimeInstance({style:"long/short"});this._oFormatDate=sap.ui.core.format.DateFormat.getDateInstance({style:"medium"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};
T.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateTimes){q.sap.clearDelayedCall(this._sInvalidateTimes);}};
T.prototype.onAfterRendering=function(){_.call(this);};
T.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){s.call(this,true);k.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;o.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;o.call(this);}}};
T.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateTimes){if(this._bInvalidateSync){p.call(this);}else{this._sInvalidateTimes=q.sap.delayedCall(0,this,p);}}};
T.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};
T.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};
T.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};
T.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};
T.prototype.setIntervalMinutes=function(M){if(M>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%M>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",M,false);this._oFormatTime=undefined;return this;};
T.prototype.setDate=function(i){f.call(this,i,false);return this;};
T.prototype._setDate=function(i){var t=a._createLocalDate(i,true);this.setProperty("date",t,true);this._oUTCDate=i;};
T.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date(),undefined,true);}return this._oUTCDate;};
T.prototype.setStartDate=function(S){a._checkJSDateObject(S);var y=S.getFullYear();a._checkYearInValidRange(y);var u=a._createUniversalUTCDate(S,undefined,true);this.setProperty("startDate",S,true);this._oUTCStartDate=this._getIntervalStart(u);if(this.getDomRef()){var O=a._createLocalDate(this._getDate(),true);this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.displayDate(O);}}return this;};
T.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(new Date(),undefined,true);this._oUTCStartDate=this._getIntervalStart(this._oUTCStartDate);}return this._oUTCStartDate;};
T.prototype.displayDate=function(i){f.call(this,i,true);return this;};
T.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};
T.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var t=new sap.ui.core.Locale(i);this._oLocaleData=L.getInstance(t);}return this._oLocaleData;};
T.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var t=new sap.ui.core.Locale(i);this._oFormatLong=sap.ui.core.format.DateFormat.getInstance({style:"long/short"},t);}return this._oFormatLong;};
T.prototype._getFormatTime=function(){var i=this._getLocale();if(!this._oFormatTime||this._oFormatTime.oLocale.toString()!=i){var t=new sap.ui.core.Locale(i);var u=this.getIntervalMinutes();var v=this._getLocaleData();var P;this._oFormatTimeAmPm=undefined;if(u%60==0){P=v.getPreferredHourSymbol();if(v.getTimePattern("short").search("a")>=0){this._oFormatTimeAmPm=sap.ui.core.format.DateFormat.getTimeInstance({pattern:"a"},t);}}else{P=v.getTimePattern("short");P=P.replace("HH","H");P=P.replace("hh","h");if(P.search("a")>=0){this._oFormatTimeAmPm=sap.ui.core.format.DateFormat.getTimeInstance({pattern:"a"},t);P=P.replace("a","").trim();}}this._oFormatTime=sap.ui.core.format.DateFormat.getTimeInstance({pattern:P},t);}return this._oFormatTime;};
T.prototype._getFormatDate=function(){var i=this._getLocale();if(this._oFormatDate.oLocale.toString()!=i){var t=new sap.ui.core.Locale(i);this._oFormatDate=sap.ui.core.format.DateFormat.getDateInstance({style:"medium"},t);}return this._oFormatDate;};
T.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};
T.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};
T.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};
T.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};
T.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};
T.prototype.getIntervalMinutes=function(){var P=this.getParent();if(P&&P.getIntervalMinutes){return P.getIntervalMinutes();}else{return this.getProperty("intervalMinutes");}};
T.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};
T.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};
T.prototype._checkDateSelected=function(t){if(!(t instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var S=0;var u=this.getSelectedDates();var M=new U(t.getTime());M=this._getIntervalStart(M);var v=M.getTime();for(var i=0;i<u.length;i++){var R=u[i];var w=R.getStartDate();var x=0;if(w){w=a._createUniversalUTCDate(w,undefined,true);w=this._getIntervalStart(w);x=w.getTime();}var E=R.getEndDate();var y=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);y=E.getTime();}if(v==x&&!E){S=1;break;}else if(v==x&&E){S=2;if(E&&v==y){S=5;}break;}else if(E&&v==y){S=3;break;}else if(E&&v>x&&v<y){S=4;break;}if(this.getSingleSelection()){break;}}return S;};
T.prototype._getDateType=function(t){if(!(t instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var u;var S=this.getSpecialDates();var M=new U(t.getTime());M=this._getIntervalStart(M);var v=M.getTime();for(var i=0;i<S.length;i++){var R=S[i];var w=R.getStartDate();var x=0;if(w){w=a._createUniversalUTCDate(w,undefined,true);w=this._getIntervalStart(w);x=w.getTime();}var E=R.getEndDate();var y=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);E.setUTCMinutes(E.getUTCMinutes()+this.getIntervalMinutes()-1);y=E.getTime();}else if(w.getUTCHours()==0&&w.getUTCMinutes()==0&&w.getUTCSeconds()==0&&w.getUTCMilliseconds()==0){E=new U(w.getTime());E.setUTCDate(E.getUTCDate()+1);y=E.getTime();}if((v==x&&!E)||(v>=x&&v<=y)){u={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return u;};
T.prototype._checkTimeEnabled=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var t=i.getTime();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(t<P._oMinDate.getTime()||t>P._oMaxDate.getTime()){return false;}}return true;};
T.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){s.call(this,true);}var t=q(E.target);if(t.hasClass("sapUiCalItemText")){t=t.parent();}if(t.hasClass("sapUiCalItem")){var O=this._getDate();var F=new U(this._oFormatYyyyMMddHHmm.parse(t.attr("data-sap-time"),true).getTime());if(F.getTime()!=O.getTime()){this._setDate(F);k.call(this,F,true);this._bMoveChange=true;}}};
T.prototype.onmouseup=function(E){if(this._bMouseMove){s.call(this,true);var F=this._getDate();var t=this._oItemNavigation.getItemDomRefs();for(var i=0;i<t.length;i++){var $=q(t[i]);if($.attr("data-sap-time")==this._oFormatYyyyMMddHHmm.format(F.getJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var u=q(E.target);if(u.hasClass("sapUiCalItemText")){u=u.parent();}if(u.hasClass("sapUiCalItem")){F=new U(this._oFormatYyyyMMddHHmm.parse(u.attr("data-sap-time"),true).getTime());}k.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;o.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;o.call(this);}};
T.prototype.onsapselect=function(E){var S=k.call(this,this._getDate());if(S){o.call(this);}E.stopPropagation();E.preventDefault();};
T.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};
T.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i-7);}else{F.setUTCDate(i-1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};
T.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i+7);}else{F.setUTCDate(i+1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};
T.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new U(S.getTime());E.setUTCMinutes(E.getUTCMinutes()+this.getItems()*this.getIntervalMinutes());var u=a._createUniversalUTCDate(i,undefined,true);if(u.getTime()>=S.getTime()&&u.getTime()<E.getTime()){return true;}else{return false;}};
T.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};
T.prototype._getIntervalStart=function(i){var t=i.getTime();var S=new U(i.getTime());S.setUTCHours(0);S.setUTCMinutes(0);S.setUTCSeconds(0);S.setUTCMilliseconds(0);var M=this.getIntervalMinutes();while(S.getTime()<=t){S.setUTCMinutes(S.getUTCMinutes()+M);}var u=new U(S.getTime());u.setUTCMinutes(u.getUTCMinutes()-M);return u;};
function _(){var t=this._getDate();var y=this._oFormatYyyyMMddHHmm.format(t.getJSDate(),true);var u=0;var R=this.$("times").get(0);var v=this.$("times").children(".sapUiCalItem");for(var i=0;i<v.length;i++){var $=q(v[i]);if($.attr("data-sap-time")===y){u=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,b,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,c,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,d,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(v);this._oItemNavigation.setFocusedIndex(u);this._oItemNavigation.setPageSize(v.length);}
function b(i){var t=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}var O=this._getDate();var F=new U(O.getTime());var u=this._oItemNavigation.getItemDomRefs();var $=q(u[t]);F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());this._setDate(F);this.fireFocus({date:a._createLocalDate(F,true),notVisible:false});if(E.type=="mousedown"){e.call(this,E,F,t);}}
function c(i){var t=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();e.call(this,E,F,t);}}
function d(i){var E=i.getParameter("event");var t=this.getItems();var M=this.getIntervalMinutes();var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setUTCMinutes(F.getUTCMinutes()+M);break;case"sapprevious":case"sappreviousmodifiers":F.setUTCMinutes(F.getUTCMinutes()-M);break;case"sappagedown":F.setUTCMinutes(F.getUTCMinutes()+M*t);break;case"sappageup":F.setUTCMinutes(F.getUTCMinutes()-M*t);break;default:break;}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});}}
function e(E,F,i){if(E.button){return;}var S=k.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){s.call(this,true);this._bMoveChange=false;}else if(this.getIntervalSelection()&&this.$().is(":visible")){r.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}
function f(i,N){a._checkJSDateObject(i);var y=i.getFullYear();a._checkYearInValidRange(y);var F=true;if(!q.sap.equal(this.getDate(),i)){var u=a._createUniversalUTCDate(i,undefined,true);u=this._getIntervalStart(u);F=this.checkDateFocusable(i);if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",i,true);this._oUTCDate=u;}if(this.getDomRef()){if(F){g.call(this,this._oUTCDate,N);}else{h.call(this,N);}}}
function g(t,N){var y=this._oFormatYyyyMMddHHmm.format(t.getJSDate(),true);var u=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<u.length;i++){$=q(u[i]);if($.attr("data-sap-time")==y){if(document.activeElement!=u[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}
function h(N){var i=this._getStartDate();var $=this.$("times");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderTimes(R,this,i);R.flush($[0]);R.destroy();}j.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}
function j(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var i=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,i,S);R.flush($[0]);R.destroy();}}}
function k(t,M){if(!this._checkTimeEnabled(t)){return false;}var S=this.getSelectedDates();var u;var v=this._oItemNavigation.getItemDomRefs();var $;var y;var i=0;var P=this.getParent();var A=this;var w;if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){u=S[0];w=u.getStartDate();if(w){w=a._createUniversalUTCDate(w,undefined,true);w=this._getIntervalStart(w);}}else{u=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",u,true);}if(this.getIntervalSelection()&&(!u.getEndDate()||M)&&w){var E;if(t.getTime()<w.getTime()){E=w;w=t;if(!M){u.setProperty("startDate",a._createLocalDate(new Date(w.getTime()),true),true);u.setProperty("endDate",a._createLocalDate(new Date(E.getTime()),true),true);}}else if(t.getTime()>=w.getTime()){E=t;if(!M){u.setProperty("endDate",a._createLocalDate(new Date(E.getTime()),true),true);}}m.call(this,w,E);}else{m.call(this,t);u.setProperty("startDate",a._createLocalDate(new Date(t.getTime()),true),true);u.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var x=this._checkDateSelected(t);if(x>0){for(i=0;i<S.length;i++){w=S[i].getStartDate();if(w){w=a._createUniversalUTCDate(w,undefined,true);w=this._getIntervalStart(w);if(t.getTime()==w.getTime()){A.removeAggregation("selectedDates",i,true);break;}}}}else{u=new sap.ui.unified.DateRange({startDate:a._createLocalDate(new Date(t.getTime()),true)});A.addAggregation("selectedDates",u,true);}y=this._oFormatYyyyMMddHHmm.format(t.getJSDate(),true);for(i=0;i<v.length;i++){$=q(v[i]);if($.attr("data-sap-time")==y){if(x>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}
function m(S,E){var t=this._oItemNavigation.getItemDomRefs();var $;var i=0;var u=false;var v=false;if(!E){var y=this._oFormatYyyyMMddHHmm.format(S.getJSDate(),true);for(i=0;i<t.length;i++){$=q(t[i]);u=false;v=false;if($.attr("data-sap-time")==y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");u=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}n.call(this,$,u,v);}}else{var w;for(i=0;i<t.length;i++){$=q(t[i]);u=false;v=false;w=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(w.getTime()==S.getTime()){$.addClass("sapUiCalItemSelStart");u=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&w.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");v=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&w.getTime()>S.getTime()&&w.getTime()<E.getTime()){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&w.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");v=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}n.call(this,$,u,v);}}}
function n($,S,E){if(!this.getIntervalSelection()){return;}var t="";var u=[];var v=this.getId();var w=false;t=$.attr("aria-describedby");if(t){u=t.split(" ");}var x=-1;var y=-1;for(var i=0;i<u.length;i++){var z=u[i];if(z==(v+"-Start")){x=i;}if(z==(v+"-End")){y=i;}}if(x>=0&&!S){u.splice(x,1);w=true;if(y>x){y--;}}if(y>=0&&!E){u.splice(y,1);w=true;}if(x<0&&S){u.push(v+"-Start");w=true;}if(y<0&&E){u.push(v+"-End");w=true;}if(w){t=u.join(" ");$.attr("aria-describedby",t);}}
function o(){if(this._bMouseMove){s.call(this,true);}this.fireSelect();}
function p(){this._sInvalidateTimes=undefined;h.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}
function r(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}
function s(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}
return T;},true);
sap.ui.predefine('sap/ui/unified/calendar/TimesRowRenderer',['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate'],function(q,C,U){"use strict";var T={};
T.render=function(r,t){var d=t._getStartDate();var s=t.getTooltip_AsString();var i=t.getId();var a={value:i+"-Descr",append:true};r.write("<div");r.writeControlData(t);r.addClass("sapUiCalTimesRow");r.addClass("sapUiCalRow");r.writeClasses();if(s){r.writeAttributeEscaped("title",s);}if(t._getShowHeader()){a.value=a.value+" "+i+"-Head";}r.writeAccessibilityState(t,{role:"grid",readonly:"true",multiselectable:!t.getSingleSelection()||t.getIntervalSelection(),labelledby:a});r.write(">");r.write("<span id=\""+i+"-Descr\" style=\"display: none;\">"+t._rb.getText("CALENDAR_DIALOG")+"</span>");if(t.getIntervalSelection()){r.write("<span id=\""+i+"-Start\" style=\"display: none;\">"+t._rb.getText("CALENDAR_START_TIME")+"</span>");r.write("<span id=\""+i+"-End\" style=\"display: none;\">"+t._rb.getText("CALENDAR_END_TIME")+"</span>");}this.renderRow(r,t,d);r.write("</div>");};
T.renderRow=function(r,t,d){var i=t.getId();this.renderHeader(r,t,d);r.write("<div id=\""+i+"-times\" class=\"sapUiCalItems\">");this.renderTimes(r,t,d);r.write("</div>");};
T.renderHeader=function(r,t,d){if(t._getShowHeader()){var l=t._getLocaleData();var i=t.getId();r.write("<div id=\""+i+"-Head\">");this.renderHeaderLine(r,t,l,d);r.write("</div>");}};
T.renderHeaderLine=function(r,t,l,d){var f=t._getFormatDate();var I=t.getId();var a=t.getItems();var o=t._getIntervalStart(d);var m=t.getIntervalMinutes();var w="";var D=0;var b=[];var i=0;for(i=0;i<a;i++){D=f.format(o,true);if(b.length>0&&b[b.length-1].sDay==D){b[b.length-1].iItems++;}else{b.push({sDay:D,iItems:1});}o.setUTCMinutes(o.getUTCMinutes()+m);}for(i=0;i<b.length;i++){var c=b[i];w=(100/a*c.iItems)+"%";r.write("<div id=\""+I+"-Head"+i+"\"class=\"sapUiCalHeadText\" style=\"width:"+w+"\">");r.write(c.sDay);r.write("</div>");}};
T.renderTimes=function(r,t,d){var h=this.getHelper(t,d);var I=t.getItems();var w=(100/I)+"%";var o=t._getIntervalStart(d);var O="";var a="";for(var i=0;i<I;i++){if(h.oFormatTimeAmPm){a=h.oFormatTimeAmPm.format(o,true);if(O==a){a="";}else{O=a;}}this.renderTime(r,t,o,h,w,a);o.setUTCMinutes(o.getUTCMinutes()+h.iMinutes);}};
T.getHelper=function(t,d){var h={};h.sLocale=t._getLocale();h.oLocaleData=t._getLocaleData();h.oNow=C._createUniversalUTCDate(new Date(),undefined,true);h.sCurrentTime=t._rb.getText("CALENDAR_CURRENT_TIME");h.sId=t.getId();h.oFormatLong=t._getFormatLong();h.oFormatTime=t._getFormatTime();h.oFormatTimeAmPm=t._oFormatTimeAmPm;h.iMinutes=t.getIntervalMinutes();var l=t.getLegend();if(l){var L=sap.ui.getCore().byId(l);if(L){if(!(L instanceof sap.ui.unified.CalendarLegend)){throw new Error(L+" is not an sap.ui.unified.CalendarLegend. "+t);}h.aTypes=L.getItems();}else{q.sap.log.warning("CalendarLegend "+l+" does not exist!",t);}}else{h.aTypes=[];}return h;};
T.renderTime=function(r,t,d,h,w,a){var A={role:"gridcell",selected:false,label:"",describedby:""};var y=t._oFormatYyyyMMddHHmm.format(d.getJSDate(),true);var s=t._checkDateSelected(d);var o=t._getDateType(d);var e=t._checkTimeEnabled(d);r.write("<div");r.writeAttribute("id",h.sId+"-"+y);r.addClass("sapUiCalItem");if(w){r.addStyle("width",w);}var n=new U(d.getTime());n.setUTCMinutes(n.getUTCMinutes()+h.iMinutes);if(d.getTime()<=h.oNow.getTime()&&n.getTime()>h.oNow.getTime()){r.addClass("sapUiCalItemNow");A["label"]=h.sCurrentTime+" ";}if(s>0){r.addClass("sapUiCalItemSel");A["selected"]=true;}if(s==2){r.addClass("sapUiCalItemSelStart");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";}else if(s==3){r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-End";}else if(s==4){r.addClass("sapUiCalItemSelBetween");}else if(s==5){r.addClass("sapUiCalItemSelStart");r.addClass("sapUiCalItemSelEnd");A["describedby"]=A["describedby"]+" "+h.sId+"-Start";A["describedby"]=A["describedby"]+" "+h.sId+"-End";}if(o&&o.type!=sap.ui.unified.CalendarDayType.None){r.addClass("sapUiCalItem"+o.type);if(o.tooltip){r.writeAttributeEscaped('title',o.tooltip);}}if(!e){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-time",y);A["label"]=A["label"]+h.oFormatLong.format(d,true);if(o&&o.type!=sap.ui.unified.CalendarDayType.None){for(var i=0;i<h.aTypes.length;i++){var l=h.aTypes[i];if(l.getType()==o.type){A["label"]=A["label"]+"; "+l.getText();break;}}}r.writeAccessibilityState(null,A);r.writeClasses();r.writeStyles();r.write(">");r.write("<span");r.addClass("sapUiCalItemText");r.writeClasses();r.write(">");r.write(h.oFormatTime.format(d,true));if(a){r.write("<span");r.addClass("sapUiCalItemTextAmPm");r.writeClasses();r.write(">");r.write(a);r.write("</span>");}r.write("</span>");r.write("</div>");};
return T;},true);
sap.ui.predefine('sap/ui/unified/calendar/YearPicker',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/model/type/Date','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','sap/ui/core/date/UniversalDate','sap/ui/unified/library'],function(q,C,I,D,a,b,U,l){"use strict";
var Y=C.extend("sap.ui.unified.calendar.YearPicker",{metadata:{library:"sap.ui.unified",properties:{year:{type:"int",group:"Data",defaultValue:2000},years:{type:"int",group:"Appearance",defaultValue:20},columns:{type:"int",group:"Appearance",defaultValue:4},date:{type:"object",group:"Data"},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance"}},events:{select:{},pageChange:{}}}});
Y.prototype.init=function(){var s=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",s);this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:s});this._oFormatYyyymmdd=sap.ui.core.format.DateFormat.getInstance({pattern:"yyyyMMdd",calendarType:sap.ui.core.CalendarType.Gregorian});this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());};
Y.prototype.onAfterRendering=function(){_.call(this);};
Y.prototype.setYear=function(y){this.setProperty("year",y,true);y=this.getProperty("year");var o=b.fromLocalJSDate(new Date(),this.getPrimaryCalendarType());o.setDate(1);o.setMonth(0);o.setYear(y);this.setDate(o.toLocalJSDate());return this;};
Y.prototype.setDate=function(o){var i,y,k,F;o&&a._checkJSDateObject(o);y=o.getFullYear();a._checkYearInValidRange(y);i=b.fromLocalJSDate(o,this.getPrimaryCalendarType());i.setMonth(0);i.setDate(1);this.setProperty("date",o,true);this.setProperty("year",i.getYear(),true);this._oDate=i;if(this.getDomRef()){k=this.getYears();F=new b(this._oDate,this.getPrimaryCalendarType());F.setYear(F.getYear()-Math.floor(k/2));j.call(this,F,Math.floor(k/2));}return this;};
Y.prototype._getDate=function(){if(!this._oDate){var y=this.getYear();this._oDate=new b(y,0,1,this.getPrimaryCalendarType());}return this._oDate;};
Y.prototype.setPrimaryCalendarType=function(s){this.setProperty("primaryCalendarType",s);this._oYearFormat=sap.ui.core.format.DateFormat.getDateInstance({format:"y",calendarType:s});if(this._oDate){this._oDate=new b(this._oDate,s);this._oDate.setMonth(0);this._oDate.setDate(1);}this._oMinDate=new b(this._oMinDate,s);this._oMaxDate=new b(this._oMaxDate,s);return this;};
Y.prototype.nextPage=function(){h.call(this,true,this._oItemNavigation.getFocusedIndex());return this;};
Y.prototype.previousPage=function(){h.call(this,false,this._oItemNavigation.getFocusedIndex());return this;};
Y.prototype.onsapspace=function(E){E.preventDefault();};
Y.prototype.onsapselect=function(E){var i=this._oItemNavigation.getFocusedIndex();var s=g.call(this,i);if(s){this.fireSelect();}};
Y.prototype.onmouseup=function(E){if(this._bMousedownChange){this._bMousedownChange=false;this.fireSelect();}};
Y.prototype.getFirstRenderedDate=function(){var F;if(this.getDomRef()){var i=this._oItemNavigation.getItemDomRefs();F=this._oFormatYyyymmdd.parse(q(i[0]).attr("data-sap-year-start"),true);}return F;};
Y.prototype._checkFirstDate=function(o){var y=this.getYears();var m=new b(this._oMaxDate,this.getPrimaryCalendarType());m.setYear(m.getYear()-y+1);if(o.isAfter(m)&&o.getYear()!=m.getYear()){o=new b(m,this.getPrimaryCalendarType());o.setMonth(0);o.setDate(1);}else if(o.isBefore(this._oMinDate)&&o.getYear()!=this._oMinDate.getYear()){o=new b(this._oMinDate,this.getPrimaryCalendarType());o.setMonth(0);o.setDate(1);}return o;};
Y.prototype._checkDateEnabled=function(o){var E=true;if((o.isAfter(this._oMaxDate)&&o.getYear()!=this._oMaxDate.getYear())||(o.isBefore(this._oMinDate)&&o.getYear()!=this._oMinDate.getYear())){E=false;}return E;};
function _(){var y=this.getYears();var i=this._getDate().getYear();var m=this._oMinDate.getYear();var M=this._oMaxDate.getYear();var r=this.getDomRef();var k=this.$().find(".sapUiCalItem");var n=Math.floor(y/2);if(i>M-Math.floor(y/2)){n=n+i-M+Math.floor(y/2);}else if(i<=m+Math.floor(y/2)){n=i-m;}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,c,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,d,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,f,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setHomeEndColumnMode(true,true);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});}this._oItemNavigation.setRootDomRef(r);this._oItemNavigation.setItemDomRefs(k);this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(this.getColumns(),true);this._oItemNavigation.setFocusedIndex(n);this._oItemNavigation.setPageSize(k.length);}
function c(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){e.call(this,E,i);}}
function d(o){var i=o.getParameter("index");var E=o.getParameter("event");if(!E){return;}if(E.type=="mousedown"){e.call(this,E,i);}}
function e(E,i){if(E.button){return;}var s=g.call(this,i);if(s){this._bMousedownChange=true;}E.preventDefault();E.setMark("cancelAutoClose");}
function f(o){var E=o.getParameter("event");if(E.type){var y=this.getYears();var i=this.getColumns();if(i==0){i=y;}switch(E.type){case"sapnext":case"sapnextmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_DOWN&&i<y){h.call(this,true,this._oItemNavigation.getFocusedIndex()-y+i,true);}else{h.call(this,true,0,true);}break;case"sapprevious":case"sappreviousmodifiers":if(E.keyCode==q.sap.KeyCodes.ARROW_UP&&i<y){h.call(this,false,y-i+this._oItemNavigation.getFocusedIndex(),true);}else{h.call(this,false,y-1,true);}break;case"sappagedown":h.call(this,true,this._oItemNavigation.getFocusedIndex(),true);break;case"sappageup":h.call(this,false,this._oItemNavigation.getFocusedIndex(),true);break;default:break;}}}
function g(k){var m=this._oItemNavigation.getItemDomRefs();var $=q(m[k]);if($.hasClass("sapUiCalItemDsbl")){return false;}var y=$.attr("data-sap-year-start");var o=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(y));var s=this.getId()+"-y"+y;for(var i=0;i<m.length;i++){$=q(m[i]);if($.attr("id")==s){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}else{$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}}this.setProperty("date",o.toLocalJSDate(),true);this.setProperty("year",o.getYear(),true);return true;}
function h(F,s,i){var k=this._oItemNavigation.getItemDomRefs();var o=b.fromLocalJSDate(this._oFormatYyyymmdd.parse(q(k[0]).attr("data-sap-year-start")),this.getPrimaryCalendarType());var y=this.getYears();if(F){var m=new b(this._oMaxDate,this.getPrimaryCalendarType());m.setYear(m.getYear()-y+1);if(o.isBefore(m)){o.setYear(o.getYear()+y);if(o.isAfter(m)){s=s+(o.getYear()-m.getYear());if(s>y-1){s=y-1;}o=this._oMaxDate;o.setMonth(0);o.setDate(1);}}else{return;}}else{if(o.isAfter(this._oMinDate)){o.setYear(o.getYear()-y);if(o.isBefore(this._oMinDate)){s=s-(this._oMinDate.getYear()-o.getYear());if(s<0){s=0;}o=new b(this._oMinDate,this.getPrimaryCalendarType());}}else{return;}}j.call(this,o,s);if(i){this.firePageChange();}}
function j(F,s){var k=this._oFormatYyyymmdd.format(this._getDate().toUTCJSDate(),true);var E=false;var o=this._checkFirstDate(F);var S;if(!o.isSame(F)){S=new b(F,this.getPrimaryCalendarType());S.setYear(S.getYear()+s);F=o;E=true;}var m=this._oItemNavigation.getItemDomRefs();var n=new b(F,this.getPrimaryCalendarType());for(var i=0;i<m.length;i++){var y=this._oFormatYyyymmdd.format(n.toUTCJSDate(),true);var $=q(m[i]);$.attr("id",this.getId()+"-y"+y);$.text(this._oYearFormat.format(U.getInstance(n.toUTCJSDate(),n.getCalendarType()),true));$.attr("data-sap-year-start",y);if($.hasClass("sapUiCalItemSel")&&y!=k){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else if(!$.hasClass("sapUiCalItemSel")&&y==k){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}var p=true;if(E){p=this._checkDateEnabled(n);if(n.isSame(S)){s=i;}}if(p){$.removeClass("sapUiCalItemDsbl");$.removeAttr("aria-disabled");}else{$.addClass("sapUiCalItemDsbl");$.attr("aria-disabled",true);}n.setYear(n.getYear()+1);}this._oItemNavigation.focusItem(s);}
return Y;},true);
sap.ui.predefine('sap/ui/unified/calendar/YearPickerRenderer',['jquery.sap.global','sap/ui/unified/calendar/CalendarDate','sap/ui/core/date/UniversalDate'],function(q,C,U){"use strict";var Y={};
Y.render=function(r,y){var t=y.getTooltip_AsString();var I=y.getId();var c=y._getDate();var a=c.getYear();var b=y.getYears();var d=y.getColumns();var w="";r.write("<div");r.writeControlData(y);r.addClass("sapUiCalYearPicker");r.writeClasses();if(t){r.writeAttributeEscaped('title',t);}r.writeAccessibilityState(y,{role:"grid",readonly:"true",multiselectable:"false"});r.write(">");var D=new C(c,y.getPrimaryCalendarType());D.setYear(D.getYear()-Math.floor(b/2));var e=false;var f=y._checkFirstDate(D);if(!f.isSame(D)){D=f;e=true;}if(d>0){w=(100/d)+"%";}else{w=(100/b)+"%";}for(var i=0;i<b;i++){var s=y._oFormatYyyymmdd.format(D.toUTCJSDate(),true);var A={role:"gridcell"};var E=true;if(e){E=y._checkDateEnabled(D);}if(d>0&&i%d==0){r.write("<div");r.writeAccessibilityState(null,{role:"row"});r.write(">");}r.write("<div");r.writeAttribute("id",I+"-y"+s);r.addClass("sapUiCalItem");if(D.getYear()==a){r.addClass("sapUiCalItemSel");A["selected"]=true;}else{A["selected"]=false;}if(!E){r.addClass("sapUiCalItemDsbl");A["disabled"]=true;}r.writeAttribute("tabindex","-1");r.writeAttribute("data-sap-year-start",s);r.addStyle("width",w);r.writeClasses();r.writeStyles();r.writeAccessibilityState(null,A);r.write(">");r.write(y._oYearFormat.format(U.getInstance(D.toUTCJSDate(),D.getCalendarType()),true));r.write("</div>");D.setYear(D.getYear()+1);if(d>0&&((i+1)%d==0)){r.write("</div>");}}r.write("</div>");};
return Y;},true);
sap.ui.predefine('sap/ui/unified/library',['jquery.sap.global','sap/ui/core/library'],function(q){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.unified",version:"1.48.6",dependencies:["sap.ui.core"],types:["sap.ui.unified.CalendarDayType","sap.ui.unified.GroupAppointmentsMode","sap.ui.unified.ContentSwitcherAnimation","sap.ui.unified.ColorPickerMode"],interfaces:[],controls:["sap.ui.unified.calendar.DatesRow","sap.ui.unified.calendar.Header","sap.ui.unified.calendar.Month","sap.ui.unified.calendar.MonthPicker","sap.ui.unified.calendar.MonthsRow","sap.ui.unified.calendar.TimesRow","sap.ui.unified.calendar.YearPicker","sap.ui.unified.Calendar","sap.ui.unified.CalendarDateInterval","sap.ui.unified.CalendarWeekInterval","sap.ui.unified.CalendarMonthInterval","sap.ui.unified.CalendarTimeInterval","sap.ui.unified.CalendarLegend","sap.ui.unified.CalendarRow","sap.ui.unified.ContentSwitcher","sap.ui.unified.ColorPicker","sap.ui.unified.Currency","sap.ui.unified.FileUploader","sap.ui.unified.Menu","sap.ui.unified.Shell","sap.ui.unified.ShellLayout","sap.ui.unified.ShellOverlay","sap.ui.unified.SplitContainer"],elements:["sap.ui.unified.CalendarAppointment","sap.ui.unified.CalendarLegendItem","sap.ui.unified.DateRange","sap.ui.unified.DateTypeRange","sap.ui.unified.FileUploaderParameter","sap.ui.unified.MenuItem","sap.ui.unified.MenuItemBase","sap.ui.unified.MenuTextFieldItem","sap.ui.unified.ShellHeadItem","sap.ui.unified.ShellHeadUserItem"]});sap.ui.unified.CalendarDayType={None:"None",NonWorking:"NonWorking",Type01:"Type01",Type02:"Type02",Type03:"Type03",Type04:"Type04",Type05:"Type05",Type06:"Type06",Type07:"Type07",Type08:"Type08",Type09:"Type09",Type10:"Type10"};sap.ui.unified.CalendarIntervalType={Hour:"Hour",Day:"Day",Month:"Month",Week:"Week",OneMonth:"One Month"};sap.ui.unified.GroupAppointmentsMode={Collapsed:"Collapsed",Expanded:"Expanded"};sap.ui.unified.CalendarAppointmentVisualization={Standard:"Standard",Filled:"Filled"};sap.ui.unified.ContentSwitcherAnimation={None:"None",Fade:"Fade",ZoomIn:"ZoomIn",ZoomOut:"ZoomOut",Rotate:"Rotate",SlideRight:"SlideRight",SlideOver:"SlideOver"};sap.ui.unified.ColorPickerMode={HSV:"HSV",HSL:"HSL"};
sap.ui.base.Object.extend("sap.ui.unified._ContentRenderer",{
constructor:function(c,C,o,a){sap.ui.base.Object.apply(this);this._id=C;this._cntnt=o;this._ctrl=c;this._rm=sap.ui.getCore().createRenderManager();this._cb=a||function(){};},
destroy:function(){this._rm.destroy();delete this._rm;delete this._id;delete this._cntnt;delete this._cb;delete this._ctrl;if(this._rerenderTimer){q.sap.clearDelayedCall(this._rerenderTimer);delete this._rerenderTimer;}sap.ui.base.Object.prototype.destroy.apply(this,arguments);},
render:function(){if(!this._rm){return;}if(this._rerenderTimer){q.sap.clearDelayedCall(this._rerenderTimer);}this._rerenderTimer=q.sap.delayedCall(0,this,function(){var $=q.sap.byId(this._id);var d=$.length>0;if(d){if(typeof(this._cntnt)==="string"){var c=this._ctrl.getAggregation(this._cntnt,[]);for(var i=0;i<c.length;i++){this._rm.renderControl(c[i]);}}else{this._cntnt(this._rm);}this._rm.flush($[0]);}this._cb(d);});}
});
sap.ui.unified._iNumberOfOpenedShellOverlays=0;if(!sap.ui.unified.ColorPickerHelper){sap.ui.unified.ColorPickerHelper={isResponsive:function(){return false;},factory:{createLabel:function(){throw new Error("no Label control available");},createInput:function(){throw new Error("no Input control available");},createSlider:function(){throw new Error("no Slider control available");},createRadioButtonGroup:function(){throw new Error("no RadioButtonGroup control available");},createRadioButtonItem:function(){throw new Error("no RadioButtonItem control available");}},bFinal:false};}if(!sap.ui.unified.FileUploaderHelper){sap.ui.unified.FileUploaderHelper={createTextField:function(i){throw new Error("no TextField control available!");},setTextFieldContent:function(t,w){throw new Error("no TextField control available!");},createButton:function(){throw new Error("no Button control available!");},addFormClass:function(){return null;},bFinal:false};}sap.ui.unified.calendar=sap.ui.unified.calendar||{};return sap.ui.unified;});
sap.ui.predefine('sap/ui/unified/Menu',['jquery.sap.global','sap/ui/core/Control','sap/ui/Device','sap/ui/core/Popup','./MenuItemBase','./library','jquery.sap.script'],function(q,C,D,P,M,l){"use strict";
var a=C.extend("sap.ui.unified.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.ui.unified",properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true},ariaDescription:{type:"string",group:"Accessibility",defaultValue:null},maxVisibleItems:{type:"int",group:"Behavior",defaultValue:0},pageSize:{type:"int",group:"Behavior",defaultValue:5}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.unified.MenuItemBase",multiple:true,singularName:"item"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{itemSelect:{parameters:{item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
(function(w){a.prototype.bCozySupported=true;a._DELAY_SUBMENU_TIMER=300;a._DELAY_SUBMENU_TIMER_EXT=400;
a.prototype.init=function(){var t=this;this.bOpen=false;this.oOpenedSubMenu=null;this.oHoveredItem=null;this.oPopup=null;this.fAnyEventHandlerProxy=q.proxy(function(e){var r=this.getRootMenu();if(r!=this||!this.bOpen||!this.getDomRef()||(e.type!="mousedown"&&e.type!="touchstart")){return;}r.handleOuterEvent(this.getId(),e);},this);this.fOrientationChangeHandler=function(){t.close();};this.bUseTopStyle=false;};
a.prototype.exit=function(){if(this.oPopup){this.oPopup.detachClosed(this._menuClosed,this);this.oPopup.destroy();delete this.oPopup;}q.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).unbind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this._resetDelayedRerenderItems();};
a.prototype.invalidate=function(o){if(o instanceof M&&this.getDomRef()){this._delayedRerenderItems();}else{C.prototype.invalidate.apply(this,arguments);}};
a.prototype.onBeforeRendering=function(){this._resetDelayedRerenderItems();};
a.prototype.onAfterRendering=function(){if(this.$().parent().attr("id")!="sap-ui-static"){q.sap.log.error("sap.ui.unified.Menu: The Menu is popup based and must not be rendered directly as content of the page.");this.close();this.$().remove();}var I=this.getItems();for(var i=0;i<I.length;i++){if(I[i].onAfterRendering&&I[i].getDomRef()){I[i].onAfterRendering();}}if(this.oHoveredItem){this.oHoveredItem.hover(true,this);}b(this);};
a.prototype.onThemeChanged=function(){if(this.getDomRef()&&this.getPopup().getOpenState()===sap.ui.core.OpenState.OPEN){b(this);this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}};
a.prototype.setPageSize=function(S){return this.setProperty("pageSize",S,true);};
a.prototype.addItem=function(i){this.addAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};
a.prototype.insertItem=function(i,e){this.insertAggregation("items",i,e,!!this.getDomRef());this._delayedRerenderItems();return this;};
a.prototype.removeItem=function(i){this.removeAggregation("items",i,!!this.getDomRef());this._delayedRerenderItems();return this;};
a.prototype.removeAllItems=function(){var r=this.removeAllAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return r;};
a.prototype.destroyItems=function(){this.destroyAggregation("items",!!this.getDomRef());this._delayedRerenderItems();return this;};
a.prototype._delayedRerenderItems=function(){if(!this.getDomRef()){return;}this._resetDelayedRerenderItems();this._discardOpenSubMenuDelayed();this._itemRerenderTimer=q.sap.delayedCall(0,this,function(){var o=this.getDomRef();if(o){var r=sap.ui.getCore().createRenderManager();sap.ui.unified.MenuRenderer.renderItems(r,this);r.flush(o);r.destroy();this.onAfterRendering();this.getPopup()._applyPosition(this.getPopup()._oLastPosition);}});};
a.prototype._resetDelayedRerenderItems=function(){if(this._itemRerenderTimer){q.sap.clearDelayedCall(this._itemRerenderTimer);delete this._itemRerenderTimer;}};
a.prototype.open=function(W,o,m,e,f,g,h){if(this.bOpen){return;}s(this,true);this.oOpenerRef=o;this.bIgnoreOpenerDOMRef=false;this.getPopup().open(0,m,e,f,g||"0 0",h||"_sapUiCommonsMenuFlip _sapUiCommonsMenuFlip",true);this.bOpen=true;D.resize.attachHandler(this._handleResizeChange,this);var i=this.getDomRef();q(i).attr("tabIndex",0).focus();if(W){this.setHoveredItem(this.getNextSelectableItem(-1));}q.sap.bindAnyEvent(this.fAnyEventHandlerProxy);if(sap.ui.Device.support.orientation&&this.getRootMenu()===this){q(w).bind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=true;}};
a.prototype._handleResizeChange=function(){this.getPopup()._applyPosition(this.getPopup()._oLastPosition);};
a.prototype.openAsContextMenu=function(e,o){var x=e.pageX-q(o.getDomRef()).offset().left,y=e.pageY-q(o.getDomRef()).offset().top,r=sap.ui.getCore().getConfiguration().getRTL(),f=sap.ui.core.Popup.Dock;if(r){x=o.getDomRef().clientWidth-x;}this.open(true,o,f.BeginTop,f.BeginTop,o,x+" "+y,'flip');};
a.prototype.close=function(){if(!this.bOpen||a._dbg){return;}this._discardOpenSubMenuDelayed();s(this,false);delete this._bFixed;q.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);if(this._bOrientationChangeBound){q(w).unbind("orientationchange",this.fOrientationChangeHandler);this._bOrientationChangeBound=false;}this.bOpen=false;this.closeSubmenu();this.setHoveredItem();q(this.getDomRef()).attr("tabIndex",-1);this.getPopup().close(0);D.resize.detachHandler(this._handleResizeChange,this);this._resetDelayedRerenderItems();this.$().remove();this.bOutput=false;if(this.isSubMenu()){this.getParent().getParent().oOpenedSubMenu=null;}};
a.prototype._menuClosed=function(){if(this.oOpenerRef){if(!this.bIgnoreOpenerDOMRef){try{this.oOpenerRef.focus();}catch(e){q.sap.log.warning("Menu.close cannot restore the focus on opener "+this.oOpenerRef+", "+e);}}this.oOpenerRef=undefined;}};
a.prototype.onclick=function(e){this.selectItem(this.getItemByDomRef(e.target),false,!!(e.metaKey||e.ctrlKey));e.preventDefault();e.stopPropagation();};
a.prototype.onsapnext=function(e){if(e.keyCode!=q.sap.KeyCodes.ARROW_DOWN){if(this.oHoveredItem&&this.oHoveredItem.getSubmenu()&&this.checkEnabled(this.oHoveredItem)){this.openSubmenu(this.oHoveredItem,true);}return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;this.setHoveredItem(this.getNextSelectableItem(i));e.preventDefault();e.stopPropagation();};
a.prototype.onsapprevious=function(e){if(e.keyCode!=q.sap.KeyCodes.ARROW_UP){if(this.isSubMenu()){this.close();}e.preventDefault();e.stopPropagation();return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;this.setHoveredItem(this.getPreviousSelectableItem(i));e.preventDefault();e.stopPropagation();};
a.prototype.onsaphome=function(e){this.setHoveredItem(this.getNextSelectableItem(-1));e.preventDefault();e.stopPropagation();};
a.prototype.onsapend=function(e){this.setHoveredItem(this.getPreviousSelectableItem(this.getItems().length));e.preventDefault();e.stopPropagation();};
a.prototype.onsappagedown=function(e){if(this.getPageSize()<1){this.onsapend(e);return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;i+=this.getPageSize();if(i>=this.getItems().length){this.onsapend(e);return;}this.setHoveredItem(this.getNextSelectableItem(i-1));e.preventDefault();e.stopPropagation();};
a.prototype.onsappageup=function(e){if(this.getPageSize()<1){this.onsaphome(e);return;}var i=this.oHoveredItem?this.indexOfAggregation("items",this.oHoveredItem):-1;i-=this.getPageSize();if(i<0){this.onsaphome(e);return;}this.setHoveredItem(this.getPreviousSelectableItem(i+1));e.preventDefault();e.stopPropagation();};
a.prototype.onsapselect=function(e){this._sapSelectOnKeyDown=true;e.preventDefault();e.stopPropagation();};
a.prototype.onkeyup=function(e){if(!this._sapSelectOnKeyDown){return;}else{this._sapSelectOnKeyDown=false;}if(!q.sap.PseudoEvents.sapselect.fnCheck(e)){return;}this.selectItem(this.oHoveredItem,true,false);e.preventDefault();e.stopPropagation();};
a.prototype.onsapbackspace=function(e){if(q(e.target).prop("tagName")!="INPUT"){e.preventDefault();}};
a.prototype.onsapbackspacemodifiers=a.prototype.onsapbackspace;
a.prototype.onsapescape=function(e){this.close();e.preventDefault();e.stopPropagation();};
a.prototype.onsaptabnext=a.prototype.onsapescape;a.prototype.onsaptabprevious=a.prototype.onsapescape;
a.prototype.onmouseover=function(e){if(!sap.ui.Device.system.desktop){return;}var i=this.getItemByDomRef(e.target);if(!this.bOpen||!i||i==this.oHoveredItem){return;}if(this.oOpenedSubMenu&&q.sap.containsOrEquals(this.oOpenedSubMenu.getDomRef(),e.target)){return;}this.setHoveredItem(i);if(q.sap.checkMouseEnterOrLeave(e,this.getDomRef())){if(!D.browser.msie&&!D.browser.edge){this.getDomRef().focus();}}this._openSubMenuDelayed(i);};
a.prototype._openSubMenuDelayed=function(i){if(!i){return;}this._discardOpenSubMenuDelayed();this._delayedSubMenuTimer=q.sap.delayedCall(i.getSubmenu()&&this.checkEnabled(i)?a._DELAY_SUBMENU_TIMER:a._DELAY_SUBMENU_TIMER_EXT,this,function(){this.closeSubmenu();if(!i.getSubmenu()||!this.checkEnabled(i)){return;}this.setHoveredItem(i);this.openSubmenu(i,false,true);});};
a.prototype._discardOpenSubMenuDelayed=function(i){if(this._delayedSubMenuTimer){q.sap.clearDelayedCall(this._delayedSubMenuTimer);this._delayedSubMenuTimer=null;}};
a.prototype.onmouseout=function(e){if(!sap.ui.Device.system.desktop){return;}if(q.sap.checkMouseEnterOrLeave(e,this.getDomRef())){if(!this.oOpenedSubMenu||!(this.oOpenedSubMenu.getParent()===this.oHoveredItem)){this.setHoveredItem(null);}this._discardOpenSubMenuDelayed();}};
a.prototype.onsapfocusleave=function(e){if(this.oOpenedSubMenu||!this.bOpen){return;}this.getRootMenu().handleOuterEvent(this.getId(),e);};
a.prototype.handleOuterEvent=function(m,e){var i=false,t=this.getPopup().touchEnabled;this.bIgnoreOpenerDOMRef=false;if(e.type=="mousedown"||e.type=="touchstart"){if(t&&(e.isMarked("delayedMouseEvent")||e.isMarked("cancelAutoClose"))){return;}var f=this;while(f&&!i){if(q.sap.containsOrEquals(f.getDomRef(),e.target)){i=true;}f=f.oOpenedSubMenu;}}else if(e.type=="sapfocusleave"){if(t){return;}if(e.relatedControlId){var f=this;while(f&&!i){if((f.oOpenedSubMenu&&f.oOpenedSubMenu.getId()==e.relatedControlId)||q.sap.containsOrEquals(f.getDomRef(),q.sap.byId(e.relatedControlId).get(0))){i=true;}f=f.oOpenedSubMenu;}}if(!i){this.bIgnoreOpenerDOMRef=true;}}if(!i){this.close();}};
a.prototype.getItemByDomRef=function(o){var I=this.getItems(),L=I.length;for(var i=0;i<L;i++){var e=I[i],f=e.getDomRef();if(q.sap.containsOrEquals(f,o)){return e;}}return null;};
a.prototype.selectItem=function(i,W,e){if(!i||!(i instanceof M&&this.checkEnabled(i))){return;}var S=i.getSubmenu();if(!S){this.getRootMenu().close();}else{if(!sap.ui.Device.system.desktop&&this.oOpenedSubMenu===S){this.closeSubmenu();}else{this.openSubmenu(i,W);}}i.fireSelect({item:i,ctrlKey:e});this.getRootMenu().fireItemSelect({item:i});};
a.prototype.isSubMenu=function(){return this.getParent()&&this.getParent().getParent&&this.getParent().getParent()instanceof a;};
a.prototype.getRootMenu=function(){var t=this;while(t.isSubMenu()){t=t.getParent().getParent();}return t;};
a.prototype.getMenuLevel=function(){var L=1;var t=this;while(t.isSubMenu()){t=t.getParent().getParent();L++;}return L;};
a.prototype.getPopup=function(){if(!this.oPopup){this.oPopup=new P(this,false,true,false);this.oPopup.setDurations(0,0);this.oPopup.attachClosed(this._menuClosed,this);}return this.oPopup;};
a.prototype.setHoveredItem=function(i){if(this.oHoveredItem){this.oHoveredItem.hover(false,this);}if(!i){this.oHoveredItem=null;q(this.getDomRef()).removeAttr("aria-activedescendant");return;}this.oHoveredItem=i;i.hover(true,this);this._setActiveDescendant(this.oHoveredItem);this.scrollToItem(this.oHoveredItem);};
a.prototype._setActiveDescendant=function(i){if(sap.ui.getCore().getConfiguration().getAccessibility()&&i){var t=this;t.$().removeAttr("aria-activedescendant");setTimeout(function(){if(t.oHoveredItem===i){t.$().attr("aria-activedescendant",t.oHoveredItem.getId());}},10);}};
a.prototype.openSubmenu=function(i,W,e){var S=i.getSubmenu();if(!S){return;}if(this.oOpenedSubMenu&&this.oOpenedSubMenu!==S){this.closeSubmenu();}if(this.oOpenedSubMenu){this.oOpenedSubMenu._bFixed=(e&&this.oOpenedSubMenu._bFixed)||(!e&&!this.oOpenedSubMenu._bFixed);this.oOpenedSubMenu._bringToFront();}else{this.oOpenedSubMenu=S;var f=P.Dock;S.open(W,this,f.BeginTop,f.EndTop,i,"0 0");}};
a.prototype.closeSubmenu=function(i,I){if(this.oOpenedSubMenu){if(i&&this.oOpenedSubMenu._bFixed){return;}if(I){this.oOpenedSubMenu.bIgnoreOpenerDOMRef=true;}this.oOpenedSubMenu.close();this.oOpenedSubMenu=null;}};
a.prototype.scrollToItem=function(i){var m=this.getDomRef(),I=i?i.getDomRef():null;if(!I||!m){return;}var e=m.scrollTop,f=I.offsetTop,g=q(m).height(),h=q(I).height();if(e>f){m.scrollTop=f;}else if((f+h)>(e+g)){m.scrollTop=Math.ceil(f+h-g);}};
a.prototype._bringToFront=function(){q.sap.byId(this.getPopup().getId()).mousedown();};
a.prototype.checkEnabled=function(i){return i&&i.getEnabled()&&this.getEnabled();};
a.prototype.getNextSelectableItem=function(I){var o=null;var e=this.getItems();for(var i=I+1;i<e.length;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=0;i<=I;i++){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};
a.prototype.getPreviousSelectableItem=function(I){var o=null;var e=this.getItems();for(var i=I-1;i>=0;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}if(!o){for(var i=e.length-1;i>=I;i--){if(e[i].getVisible()&&this.checkEnabled(e[i])){o=e[i];break;}}}return o;};
a.prototype.setRootMenuTopStyle=function(u){this.getRootMenu().bUseTopStyle=u;a.rerenderMenu(this.getRootMenu());};
a.rerenderMenu=function(m){var I=m.getItems();for(var i=0;i<I.length;i++){var S=I[i].getSubmenu();if(S){a.rerenderMenu(S);}}m.invalidate();m.rerender();};
a.prototype.focus=function(){if(this.bOpen){C.prototype.focus.apply(this,arguments);this._setActiveDescendant(this.oHoveredItem);}};
a.prototype.isCozy=function(){if(!this.bCozySupported){return false;}if(this.hasStyleClass("sapUiSizeCozy")){return true;}if(c(this.oOpenerRef)){return true;}if(c(this.getParent())){return true;}return false;};
function c(r){if(!r){return false;}r=r.$?r.$():q(r);return r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy").hasClass("sapUiSizeCozy");}
function s(m,o){var p=m.getParent();if(p&&p instanceof M){p.onSubmenuToggle(o);}}
function b(m){var e=m.getMaxVisibleItems(),f=document.documentElement.clientHeight-10,$=m.$();if(e>0){var I=m.getItems();for(var i=0;i<I.length;i++){if(I[i].getDomRef()){f=Math.min(f,I[i].$().outerHeight(true)*e);break;}}}if($.outerHeight(true)>f){$.css("max-height",f+"px").toggleClass("sapUiMnuScroll",true);}else{$.css("max-height","").toggleClass("sapUiMnuScroll",false);}}
/*!
	 * The following code is taken from
	 * jQuery UI 1.10.3 - 2013-11-18
	 * jquery.ui.position.js
	 *
	 * http://jqueryui.com
	 * Copyright 2013 jQuery Foundation and other contributors; Licensed MIT
	 */

function _(e){var f=q(w);e.within={element:f,isWindow:true,offset:f.offset()||{left:0,top:0},scrollLeft:f.scrollLeft(),scrollTop:f.scrollTop(),width:f.width(),height:f.height()};e.collisionPosition={marginLeft:0,marginTop:0};return e;}
var d={fit:{left:function(p,e){var f=e.within,g=f.isWindow?f.scrollLeft:f.offset.left,o=f.width,h=p.left-e.collisionPosition.marginLeft,i=g-h,j=h+e.collisionWidth-o-g,n;if(e.collisionWidth>o){if(i>0&&j<=0){n=p.left+i+e.collisionWidth-o-g;p.left+=i-n;}else if(j>0&&i<=0){p.left=g;}else{if(i>j){p.left=g+o-e.collisionWidth;}else{p.left=g;}}}else if(i>0){p.left+=i;}else if(j>0){p.left-=j;}else{p.left=Math.max(p.left-h,p.left);}},top:function(p,e){var f=e.within,g=f.isWindow?f.scrollTop:f.offset.top,o=e.within.height,h=p.top-e.collisionPosition.marginTop,i=g-h,j=h+e.collisionHeight-o-g,n;if(e.collisionHeight>o){if(i>0&&j<=0){n=p.top+i+e.collisionHeight-o-g;p.top+=i-n;}else if(j>0&&i<=0){p.top=g;}else{if(i>j){p.top=g+o-e.collisionHeight;}else{p.top=g;}}}else if(i>0){p.top+=i;}else if(j>0){p.top-=j;}else{p.top=Math.max(p.top-h,p.top);}}},flip:{left:function(p,e){var f=e.within,g=f.offset.left+f.scrollLeft,o=f.width,h=f.isWindow?f.scrollLeft:f.offset.left,i=p.left-e.collisionPosition.marginLeft,j=i-h,k=i+e.collisionWidth-o-h,m=e.my[0]==="left"?-e.elemWidth:e.my[0]==="right"?e.elemWidth:0,n=e.at[0]==="left"?e.targetWidth:e.at[0]==="right"?-e.targetWidth:0,r=-2*e.offset[0],t,u;if(j<0){t=p.left+m+n+r+e.collisionWidth-o-g;if(t<0||t<Math.abs(j)){p.left+=m+n+r;}}else if(k>0){u=p.left-e.collisionPosition.marginLeft+m+n+r-h;if(u>0||Math.abs(u)<k){p.left+=m+n+r;}}},top:function(p,e){var f=e.within,g=f.offset.top+f.scrollTop,o=f.height,h=f.isWindow?f.scrollTop:f.offset.top,i=p.top-e.collisionPosition.marginTop,j=i-h,k=i+e.collisionHeight-o-h,t=e.my[1]==="top",m=t?-e.elemHeight:e.my[1]==="bottom"?e.elemHeight:0,n=e.at[1]==="top"?e.targetHeight:e.at[1]==="bottom"?-e.targetHeight:0,r=-2*e.offset[1],u,v;if(j<0){v=p.top+m+n+r+e.collisionHeight-o-g;if((p.top+m+n+r)>j&&(v<0||v<Math.abs(j))){p.top+=m+n+r;}}else if(k>0){u=p.top-e.collisionPosition.marginTop+m+n+r-h;if((p.top+m+n+r)>k&&(u>0||Math.abs(u)<k)){p.top+=m+n+r;}}}},flipfit:{left:function(){d.flip.left.apply(this,arguments);d.fit.left.apply(this,arguments);},top:function(){d.flip.top.apply(this,arguments);d.fit.top.apply(this,arguments);}}};q.ui.position._sapUiCommonsMenuFlip={left:function(p,e){if(q.ui.position.flipfit){q.ui.position.flipfit.left.apply(this,arguments);return;}e=_(e);d.flipfit.left.apply(this,arguments);},top:function(p,e){if(q.ui.position.flipfit){q.ui.position.flipfit.top.apply(this,arguments);return;}e=_(e);d.flipfit.top.apply(this,arguments);}};})(window);return a;},true);
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/unified/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/unified/manifest.json":'{\n  "_version": "1.2.0",\n  "sap.app": {\n    "_version": "1.2.0",\n    "id": "sap.ui.unified",\n    "type": "library",\n    "embeds": [],\n    "applicationVersion": {\n      "version": "1.48.6"\n    },\n    "title": "Unified controls intended for both, mobile and desktop scenarios",\n    "description": "Unified controls intended for both, mobile and desktop scenarios",\n    "ach": "CA-UI5-CTR",\n    "resources": "resources.json",\n    "offline": true\n  },\n  "sap.ui": {\n    "_version": "1.1.0",\n    "technology": "UI5",\n    "supportedThemes": [\n      "base",\n      "sap_hcb"\n    ]\n  },\n  "sap.ui5": {\n    "_version": "1.1.0",\n    "dependencies": {\n      "minUI5Version": "1.48",\n      "libs": {\n        "sap.ui.core": {\n          "minVersion": "1.48.6"\n        }\n      }\n    }\n  }\n}'
}});
//# sourceMappingURL=library-preload.js.map