/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/IconPool"],function(q,l,C,I){"use strict";var A=C.extend("sap.f.Avatar",{metadata:{library:"sap.f",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},displayShape:{type:"sap.f.AvatarShape",group:"Appearance",defaultValue:sap.f.AvatarShape.Circle},displaySize:{type:"sap.f.AvatarSize",group:"Appearance",defaultValue:sap.f.AvatarSize.S},customDisplaySize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"3rem"},customFontSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"1.125rem"},imageFitType:{type:"sap.f.AvatarImageFitType",group:"Appearance",defaultValue:sap.f.AvatarImageFitType.Cover}},aggregations:{detailBox:{type:'sap.m.LightBox',multiple:false,bindable:"bindable"}},events:{press:{}}}});A.DEFAULT_CIRCLE_PLACEHOLDER="sap-icon://person-placeholder";A.DEFAULT_SQUARE_PLACEHOLDER="sap-icon://product";A.prototype.init=function(){this._sActualType=null;this._bIsDefaultIcon=true;};A.prototype.exit=function(){if(this._icon){this._icon.destroy();}if(this._fnLightBoxOpen){this._fnLightBoxOpen=null;}};A.prototype.setDetailBox=function(L){if(L){this._fnLightBoxOpen=L.open.bind(L);this.attachPress(this._fnLightBoxOpen);}else if(this._fnLightBoxOpen){C.prototype.detachEvent.call(this,"press",this._fnLightBoxOpen);this._fnLightBoxOpen=null;}return this.setAggregation("detailBox",L);};A.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};A.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");if(this.getDecorative()){this.$().attr("role","presentation");}else{this.$().removeAttr("role");}}return this;};A.prototype.ontap=function(e){this.firePress({});};A.prototype.onkeyup=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){this.firePress({});e.stopPropagation();}};A.prototype._areInitialsValid=function(i){var v=/^[a-zA-Z]{1,2}$/;if(!v.test(i)){q.sap.log.warning("Initials should consist of only 1 or 2 latin letters",this);this._sActualType=sap.f.AvatarType.Icon;this._bIsDefaultIcon=true;return false;}return true;};A.prototype._validateSrc=function(s){if(I.isIconURI(s)){this._sActualType=sap.f.AvatarType.Icon;this._bIsDefaultIcon=false;}else{this._sActualType=sap.f.AvatarType.Image;}return this;};A.prototype._getActualDisplayType=function(){var s=this.getSrc(),i=this.getInitials();if(s){this._validateSrc(s);}else if(i&&this._areInitialsValid(i)){this._sActualType=sap.f.AvatarType.Initials;}else{q.sap.log.warning("No src and initials were provided",this);this._sActualType=sap.f.AvatarType.Icon;this._bIsDefaultIcon=true;}return this._sActualType;};A.prototype._getDefaultIconPath=function(d){var D=null;if(d===sap.f.AvatarShape.Circle){D=A.DEFAULT_CIRCLE_PLACEHOLDER;}else if(d===sap.f.AvatarShape.Square){D=A.DEFAULT_SQUARE_PLACEHOLDER;}return D;};A.prototype._getIcon=function(){var s=this.getSrc(),d=this.getDisplayShape();if(this._bIsDefaultIcon){s=this._getDefaultIconPath(d);}if(!this._icon){this._icon=I.createControlByURI({alt:"Image placeholder",src:s});}else if(this._icon.getSrc()!==s){this._icon.setSrc(s);}return this._icon;};A.prototype.getAccessibilityInfo=function(){var h=this.hasListeners("press");if(!h){return null;}return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),focusable:h};};return A;},true);
