/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ListItemBase','./library','./FormattedText'],function(q,L,l,F){"use strict";var a=L.extend("sap.m.FeedListItem",{metadata:{library:"sap.m",properties:{icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},activeIcon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},info:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},senderActive:{type:"boolean",group:"Behavior",defaultValue:true},iconActive:{type:"boolean",group:"Behavior",defaultValue:true},iconDensityAware:{type:"boolean",defaultValue:true},showIcon:{type:"boolean",group:"Behavior",defaultValue:true},convertLinksToAnchorTags:{type:"sap.m.LinkConversion",group:"Behavior",defaultValue:sap.m.LinkConversion.None},convertedLinksDefaultTarget:{type:"string",group:"Behavior",defaultValue:"_blank"},maxCharacters:{type:"int",group:"Behavior",defaultValue:null}},defaultAggregation:"_text",aggregations:{"_text":{type:"sap.m.FormattedText",multiple:false,visibility:"hidden"}},events:{senderPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}},iconPress:{parameters:{domRef:{type:"string"},getDomRef:{type:"function"}}}}}});a._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");a._nMaxCharactersMobile=300;a._nMaxCharactersDesktop=500;a._sTextShowMore=a._oRb.getText("TEXT_SHOW_MORE");a._sTextShowLess=a._oRb.getText("TEXT_SHOW_LESS");a.prototype.init=function(){L.prototype.init.apply(this);this.setAggregation("_text",new F(this.getId()+"-formattedText"),true);};a.prototype.onBeforeRendering=function(){this.$("realtext").find('a[target="_blank"]').off("click");var f=this.getAggregation("_text");f.setProperty("convertLinksToAnchorTags",this.getConvertLinksToAnchorTags(),true);f.setProperty("convertedLinksDefaultTarget",this.getConvertedLinksDefaultTarget(),true);if(this.getConvertLinksToAnchorTags()===l.LinkConversion.None){f.setHtmlText(this.getText());}else{f.setProperty("htmlText",this.getText(),true);}this._sFullText=f._getDisplayHtml().replace(/\n/g,"<br>");this._sShortText=this._getCollapsedText();};a.prototype.onAfterRendering=function(){if(this._checkTextIsExpandable()){var i="#"+this.getId()+"-realtext",r;do{r=q(i+" *:empty").remove();}while(r.length>0);this._sShortText=q(i).html();}var R=this.$("realtext");F.prototype.onAfterRendering.apply({$:function(){return R;}});};a.prototype.exit=function(){this.$("realtext").find('a[target="_blank"]').off("click");if(this._oLinkControl){this._oLinkControl.destroy();}if(this._oImageControl){this._oImageControl.destroy();}if(this._oLinkExpandCollapse){this._oLinkExpandCollapse.destroy();}L.prototype.exit.apply(this);};a.prototype.ontap=function(e){if(e.srcControl){if((!this.getIconActive()&&this._oImageControl&&e.srcControl.getId()===this._oImageControl.getId())||(!this.getSenderActive()&&this._oLinkControl&&e.srcControl.getId()===this._oLinkControl.getId())||(!this._oImageControl||(e.srcControl.getId()!==this._oImageControl.getId())&&(!this._oLinkControl||(e.srcControl.getId()!==this._oLinkControl.getId()))&&(!this._oLinkExpandCollapse||(e.srcControl.getId()!==this._oLinkExpandCollapse.getId())))){L.prototype.ontap.apply(this,[e]);}}};a.prototype.onfocusin=function(e){if(this._oImageControl){var $=this.$("icon");if(e.target.id===this.getId()){$.removeAttr("alt");}else{$.attr("alt"," ");}}};a.prototype._getImageControl=function(){var i=this.getIcon();var I=i?i:sap.ui.core.IconPool.getIconURI("person-placeholder");var s=this.getId()+'-icon';var p={src:I,alt:encodeURI(this.getSender()),densityAware:this.getIconDensityAware(),decorative:false,useIconTooltip:false};var c;if(this.getIconActive()){c=['sapMFeedListItemImage'];}else{c=['sapMFeedListItemImageInactive'];}var t=this;this._oImageControl=sap.m.ImageHelper.getImageControl(s,this._oImageControl,this,p,c);if(this.getIconActive()){this._oImageControl.attachPress(function(){t.fireIconPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});});}return this._oImageControl;};a.prototype._getLinkSender=function(w){if(!this._oLinkControl){q.sap.require("sap.m.Link");var t=this;this._oLinkControl=new sap.m.Link({press:function(){t.fireSenderPress({domRef:this.getDomRef(),getDomRef:this.getDomRef.bind(this)});}});this._oLinkControl.setParent(this,null,true);}if(w){this._oLinkControl.setProperty("text",this.getSender()+a._oRb.getText("COLON"),true);}else{this._oLinkControl.setProperty("text",this.getSender(),true);}this._oLinkControl.setProperty("enabled",this.getSenderActive(),true);return this._oLinkControl;};a.prototype._activeHandlingInheritor=function(){var A=this.getActiveIcon();if(this._oImageControl&&A){this._oImageControl.setSrc(A);}};a.prototype._inactiveHandlingInheritor=function(){var s=this.getIcon()?this.getIcon():sap.ui.core.IconPool.getIconURI("person-placeholder");if(this._oImageControl){this._oImageControl.setSrc(s);}};a.prototype._getCollapsedText=function(){this._nMaxCollapsedLength=this.getMaxCharacters();if(this._nMaxCollapsedLength===0){if(sap.ui.Device.system.phone){this._nMaxCollapsedLength=a._nMaxCharactersMobile;}else{this._nMaxCollapsedLength=a._nMaxCharactersDesktop;}}var p=this._convertHtmlToPlainText(this._sFullText);var t=null;if(p&&p.length>this._nMaxCollapsedLength){var c=p.substring(0,this._nMaxCollapsedLength);var n=c.lastIndexOf(" ");if(n>0){c=c.substr(0,n);}if(p.length===this._sFullText.length){t=c;}else{t=this._convertPlainToHtmlText(c);}}return t;};a.prototype._toggleTextExpanded=function(){var $=this.$("realtext");var b=this.$("threeDots");if(this._bTextExpanded){$.html(this._sShortText.replace(/&#xa;/g,"<br>"));b.text(" ... ");this._oLinkExpandCollapse.setText(a._sTextShowMore);this._bTextExpanded=false;}else{$.html(this._sFullText.replace(/&#xa;/g,"<br>"));b.text("  ");this._oLinkExpandCollapse.setText(a._sTextShowLess);this._bTextExpanded=true;}};a.prototype._getLinkExpandCollapse=function(){if(!this._oLinkExpandCollapse){q.sap.require("sap.m.Link");this._oLinkExpandCollapse=new sap.m.Link({text:a._sTextShowMore,press:q.proxy(function(){this._toggleTextExpanded();},this)});this._bTextExpanded=false;this._oLinkExpandCollapse.setParent(this,null,true);}return this._oLinkExpandCollapse;};a.prototype._convertHtmlToPlainText=function(h){var r=/(<([^>]+)>)/ig;return h.replace(r,"");};a.prototype._convertPlainToHtmlText=function(b){var f=this._sFullText;var r=/(<([^>]+)>)/ig;var e=f.split(r);var t="";for(var i=0;i<e.length;i++){if(e[i].length===0){continue;}if(b.length>0&&e[i].indexOf(b.trim())!==-1){e[i]=b;}if(/^<.+>$/.test(e[i])){t=t+e[i];e[i+1]="";continue;}if(b.indexOf(e[i].trim())===-1){continue;}else{b=b.replace(e[i],"");}t=t+e[i];}return t;};a.prototype._checkTextIsExpandable=function(){return this._sShortText!==null;};a.prototype.setType=function(t){if(t===sap.m.ListType.Navigation){this.setProperty("type",sap.m.ListType.Active);}else{this.setProperty("type",t);}return this;};a.prototype.setUnread=function(v){this.setProperty("unread",false);return this;};return a;},true);
