/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/Object','sap/ui/core/format/NumberFormat'],function(q,B,N){"use strict";var G=B.extend("sap.m.GrowingEnablement",{constructor:function(c){B.apply(this);this._oControl=c;this._oControl.bUseExtendedChangeDetection=true;this._oControl.addDelegate(this);var r=this._oControl.getItems(true).length;this._iRenderedDataItems=r;this._iLimit=r;this._bLoading=false;this._sGroupingPath="";this._bDataRequested=false;this._oContainerDomRef=null;this._iTriggerTimer=0;this._aChunk=[];this._oRM=null;},destroy:function(){if(this._oTrigger){this._oTrigger.destroy();this._oTrigger=null;}if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}if(this._oRM){this._oRM.destroy();this._oRM=null;}this._oControl.$("triggerList").remove();this._oControl.bUseExtendedChangeDetection=false;this._oControl.removeDelegate(this);this._oContainerDomRef=null;this._oControl=null;},render:function(r){r.write("<div");r.addClass("sapMListUl");r.addClass("sapMGrowingList");r.writeAttribute("id",this._oControl.getId()+"-triggerList");r.addStyle("display","none");r.writeClasses();r.writeStyles();r.write(">");r.renderControl(this._getTrigger());r.write("</div>");},onAfterRendering:function(){var c=this._oControl;if(c.getGrowingScrollToLoad()){var s=sap.m.getScrollDelegate(c);if(s){this._oScrollDelegate=s;s.setGrowingList(this.onScrollToLoad.bind(this),c.getGrowingDirection());}}else if(this._oScrollDelegate){this._oScrollDelegate.setGrowingList(null);this._oScrollDelegate=null;}this._updateTriggerDelayed(false);},setTriggerText:function(t){this._oControl.$("triggerText").text(t);},reset:function(){this._iLimit=0;},shouldReset:function(c){var C=sap.ui.model.ChangeReason;return c==C.Sort||c==C.Filter||c==C.Context;},getInfo:function(){return{total:this._oControl.getMaxItemsCount(),actual:this._iRenderedDataItems};},onScrollToLoad:function(){if(!this._bLoading&&this._oControl.getGrowingDirection()==sap.m.ListGrowingDirection.Upwards){var s=this._oScrollDelegate;this._oScrollPosition={left:s.getScrollLeft(),top:s.getScrollHeight()};}this.requestNewPage();},requestNewPage:function(){if(!this._oControl||this._bLoading){return;}var b=this._oControl.getBinding("items");if(b&&!b.isLengthFinal()||this._iLimit<this._oControl.getMaxItemsCount()){this._iLimit+=this._oControl.getGrowingThreshold();this._updateTriggerDelayed(true);this.updateItems("Growing");}},_onBeforePageLoaded:function(c){this._bLoading=true;this._oControl.onBeforePageLoaded(this.getInfo(),c);},_onAfterPageLoaded:function(c){this._bLoading=false;this._updateTriggerDelayed(false);this._oControl.onAfterPageLoaded(this.getInfo(),c);},_getTrigger:function(){var t=this._oControl.getId()+"-trigger",T=this._oControl.getGrowingTriggerText();T=T||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LOAD_MORE_DATA");this._oControl.addNavSection(t);if(this._oTrigger){this.setTriggerText(T);return this._oTrigger;}this._oTrigger=new sap.m.CustomListItem({id:t,busyIndicatorDelay:0,type:sap.m.ListType.Active,content:new sap.ui.core.HTML({content:'<div class="sapMGrowingListTrigger">'+'<div class="sapMSLITitleDiv sapMGrowingListTriggerText">'+'<span class="sapMSLITitle" id="'+t+'Text">'+q.sap.encodeHTML(T)+'</span>'+'</div>'+'<div class="sapMGrowingListDescription sapMSLIDescription" id="'+t+'Info"></div>'+'</div>'})}).setParent(this._oControl,null,true).attachPress(this.requestNewPage,this).addEventDelegate({onsapenter:function(e){this.requestNewPage();e.preventDefault();},onsapspace:function(e){this.requestNewPage();e.preventDefault();},onAfterRendering:function(e){this._oTrigger.$().attr({"tabindex":0,"role":"button","aria-labelledby":t+"Text"+" "+t+"Info"});}},this);this._oTrigger.getList=function(){};this._oTrigger.TagName="div";return this._oTrigger;},_getListItemInfo:function(){return("[ "+this._iRenderedDataItems+" / "+N.getFloatInstance().format(this._oControl.getMaxItemsCount())+" ]");},_getGroupingPath:function(b){var s=b.aSorters||[];var S=s[0]||{};return(S.fnGroup)?S.sPath||"":"";},_getDomIndex:function(i){if(typeof i!="number"){return i;}if(this._oControl.hasPopin&&this._oControl.hasPopin()){return(i*2);}return i;},_getHasScrollbars:function(){if(!this._oScrollDelegate){return false;}if(this._iRenderedDataItems>=40){return true;}return this._oScrollDelegate.getMaxScrollTop()>this._oControl.$("triggerList").outerHeight();},destroyListItems:function(s){this._oControl.destroyItems(s);this._iRenderedDataItems=0;this._aChunk=[];},addListItem:function(c,b,s){var C=this._oControl,o=b.binding,i=this.createListItem(c,b);if(o.isGrouped()){var I=C.getItems(true),l=I[I.length-1],m=b.model,g=o.getGroup(i.getBindingContext(m));if(l&&l.isGroupHeader()){C.removeAggregation("items",l,true);this._fnAppendGroupItem=this.appendGroupItem.bind(this,g,l,s);l=I[I.length-1];}if(!l||g.key!==o.getGroup(l.getBindingContext(m)).key){var a=(b.groupHeaderFactory)?b.groupHeaderFactory(g):null;if(C.getGrowingDirection()==sap.m.ListGrowingDirection.Upwards){this.applyPendingGroupItem();this._fnAppendGroupItem=this.appendGroupItem.bind(this,g,a,s);}else{this.appendGroupItem(g,a,s);}}}C.addAggregation("items",i,s);if(s){this._aChunk.push(i);}},applyPendingGroupItem:function(){if(this._fnAppendGroupItem){this._fnAppendGroupItem();this._fnAppendGroupItem=undefined;}},appendGroupItem:function(g,o,s){o=this._oControl.addItemGroup(g,o,s);if(s){this._aChunk.push(o);}},createListItem:function(c,b){this._iRenderedDataItems++;var i=b.factory(sap.ui.base.ManagedObjectMetadata.uid("clone"),c);return i.setBindingContext(c,b.model);},updateItemsBindingContext:function(C,m){if(!C.length){return;}var I=this._oControl.getItems(true);for(var i=0,c=0,o;i<I.length;i++){o=I[i];if(!o.isGroupHeader()){o.setBindingContext(C[c++],m);}}},applyChunk:function(I,d){this.applyPendingGroupItem();var l=this._aChunk.length;if(!l){return;}if(this._oControl.getGrowingDirection()==sap.m.ListGrowingDirection.Upwards){this._aChunk.reverse();if(I===true){I=0;}else if(typeof I=="number"){I=this._iRenderedDataItems-l-I;}}d=d||this._oContainerDomRef;this._oRM=this._oRM||sap.ui.getCore().createRenderManager();for(var i=0;i<l;i++){this._oRM.renderControl(this._aChunk[i]);}this._oRM.flush(d,false,this._getDomIndex(I));this._aChunk=[];},addListItems:function(c,b,s){for(var i=0;i<c.length;i++){this.addListItem(c[i],b,s);}},rebuildListItems:function(c,b,s){this.destroyListItems(s);this.addListItems(c,b,s);if(s){var h=this._oContainerDomRef.contains(document.activeElement);this.applyChunk(false);h&&this._oControl.focus();}else{this.applyPendingGroupItem();}},insertListItem:function(c,b,i){var I=this.createListItem(c,b);this._oControl.insertAggregation("items",I,i,true);this._aChunk.push(I);},deleteListItem:function(i){this._oControl.getItems(true)[i].destroy(true);this._iRenderedDataItems--;},refreshItems:function(c){if(!this._bDataRequested){this._bDataRequested=true;this._onBeforePageLoaded(c);}if(!this._iLimit||this.shouldReset(c)||!this._oControl.getItems(true).length){this._iLimit=this._oControl.getGrowingThreshold();}this._oControl.getBinding("items").getContexts(0,this._iLimit);},updateItems:function(c){var C=this._oControl,b=C.getBinding("items"),o=C.getBindingInfo("items"),I=C.getItems(true);if(!this._iLimit||this.shouldReset(c)||!I.length){this._iLimit=C.getGrowingThreshold();}if(this._bDataRequested){this._bDataRequested=false;}else{this._onBeforePageLoaded(c);}var a=b.getContexts(0,this._iLimit)||[];if(a.dataRequested){this._bDataRequested=true;if(a.diff&&!a.diff.length){return;}}this._oContainerDomRef=C.getItemsContainerDomRef();var d=a.diff,f=false,v;if(!a.length){this.destroyListItems();}else if(!this._oContainerDomRef){this.rebuildListItems(a,o);}else if(!d||!I.length&&d.length){this.rebuildListItems(a,o,true);}else if(b.isGrouped()||C.checkGrowingFromScratch()){if(this._sGroupingPath!=this._getGroupingPath(b)){f=true;}else{for(var i=0;i<d.length;i++){var D=d[i],e=a[D.index];if(D.type=="delete"){f=true;break;}else if(D.index!=this._iRenderedDataItems){f=true;break;}else{this.addListItem(e,o,true);v=true;}}}}else{if(this._sGroupingPath){C.removeGroupHeaders(true);}v=-1;var l=-1;for(var i=0;i<d.length;i++){var D=d[i],g=D.index,e=a[g];if(D.type=="delete"){if(v!=-1){this.applyChunk(v);l=-1;v=-1;}this.deleteListItem(g);}else{if(v==-1){v=g;}else if(l>-1&&g!=l+1){this.applyChunk(v);v=g;}this.insertListItem(e,o,g);l=g;}}}if(f){this.rebuildListItems(a,o,true);}else if(this._oContainerDomRef&&d&&d.length){this.updateItemsBindingContext(a,o.model);this.applyChunk(v);}this._oContainerDomRef=null;this._sGroupingPath=this._getGroupingPath(b);if(!this._bDataRequested){this._onAfterPageLoaded(c);}},_updateTriggerDelayed:function(l){if(this._oControl.getGrowingScrollToLoad()){this._iTriggerTimer&&window.cancelAnimationFrame(this._iTriggerTimer);this._iTriggerTimer=window.requestAnimationFrame(this._updateTrigger.bind(this,l));}else{this._updateTrigger(l);}},_updateTrigger:function(l){var t=this._oTrigger,c=this._oControl;if(!t||!c||!c.shouldRenderItems()){return;}var b=c.getBinding("items");if(!b){return;}t.setBusy(l);t.$().toggleClass("sapMGrowingListBusyIndicatorVisible",l);if(l){t.setActive(false);c.$("triggerList").css("display","");}else{var i=c.getItems(true),I=i.length,a=b.getLength()||0,L=b.isLengthFinal(),h=c.getGrowingScrollToLoad();if(!I||!this._iLimit||(L&&this._iLimit>=a)||(h&&this._getHasScrollbars())){c.$("triggerList").css("display","none");if(document.activeElement===t.getDomRef()){c.$().focus();}}else{if(L){c.$("triggerInfo").css("display","block").text(this._getListItemInfo());}t.$().removeClass("sapMGrowingListBusyIndicatorVisible");c.$("triggerList").css("display","");}if(h&&this._oScrollPosition===undefined&&c.getGrowingDirection()==sap.m.ListGrowingDirection.Upwards){this._oScrollPosition={left:0,top:0};}if(I>0&&this._oScrollPosition){var s=this._oScrollDelegate,S=this._oScrollPosition;s.scrollTo(S.left,s.getScrollHeight()-S.top);this._oScrollPosition=null;}}}});return G;},true);
