/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2017 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Icon'],function(q,l,C,I,a){"use strict";var L=C.extend("sap.m.ListItemBase",{metadata:{library:"sap.m",properties:{type:{type:"sap.m.ListType",group:"Misc",defaultValue:sap.m.ListType.Inactive},visible:{type:"boolean",group:"Appearance",defaultValue:true},unread:{type:"boolean",group:"Misc",defaultValue:false},selected:{type:"boolean",defaultValue:false},counter:{type:"int",group:"Misc",defaultValue:null},highlight:{type:"sap.ui.core.MessageType",group:"Appearance",defaultValue:"None"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{tap:{deprecated:true},detailTap:{deprecated:true},press:{},detailPress:{}},designTime:true}});L.getAccessibilityText=function(c,d){if(!c||!c.bOutput||!c.getVisible||!c.getVisible()){return"";}var A;if(c.getAccessibilityInfo){A=c.getAccessibilityInfo();}if(!A||!c.getAccessibilityInfo){A=this.getDefaultAccessibilityInfo(c.getDomRef());}A=q.extend({type:"",description:"",children:[]},A);var b=sap.ui.getCore().getLibraryResourceBundle("sap.m"),t=A.type+" "+A.description+" ",T=c.getTooltip_AsString();if(A.enabled===false){t+=b.getText("CONTROL_DISABLED")+" ";}if(A.editable===false){t+=b.getText("CONTROL_READONLY")+" ";}if(!A.type&&T&&t.indexOf(T)==-1){t=T+" "+t;}A.children.forEach(function(o){t+=L.getAccessibilityText(o)+" ";});t=t.trim();if(d&&!t){t=b.getText("CONTROL_EMPTY");}return t;};L.getDefaultAccessibilityInfo=function(d){if(!d){return null;}var N=window.Node,b=window.NodeFilter,t=document.createTreeWalker(d,b.SHOW_TEXT+b.SHOW_ELEMENT,function(n){if(n.type===N.ELEMENT_NODE){if(n.classList.contains("sapUiInvisibleText")){return b.FILTER_SKIP;}if(n.getAttribute("aria-hidden")=="true"||n.style.visibility=="hidden"||n.style.display=="none"){return b.FILTER_REJECT;}return b.FILTER_SKIP;}return b.FILTER_ACCEPT;},false);var T=[];while(t.nextNode()){var n=t.currentNode;if(n.nodeType===N.TEXT_NODE){var s=(n.nodeValue||"").trim();if(s){T.push(s);}}}return{description:T.join(" ")};};L.prototype.DetailIconURI=I.getIconURI("edit");L.prototype.DeleteIconURI=I.getIconURI("sys-cancel");L.prototype.NavigationIconURI=I.getIconURI("slim-arrow-right");L.prototype.TagName="li";L.prototype.init=function(){this._active=false;this._bGroupHeader=false;this._bNeedsHighlight=false;};L.prototype.onAfterRendering=function(){this.informList("DOMUpdate",true);this._checkHighlight();};L.prototype.getBindingContextPath=function(m){var o=this.getList();if(o&&!m){m=(o.getBindingInfo("items")||{}).model;}var c=this.getBindingContext(m);if(c){return c.getPath();}};L.prototype.isSelectedBoundTwoWay=function(){var b=this.getBinding("selected");if(b&&b.getBindingMode()==sap.ui.model.BindingMode.TwoWay){return true;}};L.prototype.getList=function(){var p=this.getParent();if(p instanceof sap.m.ListBase){return p;}};L.prototype.getListProperty=function(p,f){var o=this.getList();if(o){p=q.sap.charToUpperCase(p);return o["get"+p]();}return f;};L.prototype.informList=function(e,p,P){var o=this.getList();if(o){var m="onItem"+e;if(o[m]){o[m](this,p,P);}}};L.prototype.informSelectedChange=function(s){var o=this.getList();if(o){o.onItemSelectedChange(this,s);this.bSelectedDelayed=undefined;}else{this.bSelectedDelayed=s;}};L.prototype.getAccessibilityType=function(b){return b.getText("ACC_CTR_TYPE_OPTION");};L.prototype.getAccessibilityDescription=function(b){var o=[],t=sap.m.ListType,T=this.getType(),h=this.getHighlight(),s=this.getTooltip_AsString();if(this.getSelected()){o.push(b.getText("LIST_ITEM_SELECTED"));}if(h!="None"){o.push(b.getText("LIST_ITEM_STATE_"+h.toUpperCase()));}if(this.getUnread()&&this.getListProperty("showUnread")){o.push(b.getText("LIST_ITEM_UNREAD"));}if(this.getCounter()){o.push(b.getText("LIST_ITEM_COUNTER",this.getCounter()));}if(T==t.Navigation){o.push(b.getText("LIST_ITEM_NAVIGATION"));}else{if(T==t.Detail||T==t.DetailAndActive){o.push(b.getText("LIST_ITEM_DETAIL"));}if(T==t.Active||T==t.DetailAndActive){o.push(b.getText("LIST_ITEM_ACTIVE"));}}if(this.getContentAnnouncement){o.push((this.getContentAnnouncement(b)||"").trim());}if(s){o.push(s);}return o.join(" ");};L.prototype.getAccessibilityInfo=function(){var b=sap.ui.getCore().getLibraryResourceBundle("sap.m");return{type:this.getAccessibilityType(b),description:this.getAccessibilityDescription(b),focusable:true};};L.prototype.getMode=function(){return this.getListProperty("mode","");};L.prototype.updateAccessibilityState=function(A){var t=this.$();if(!t.length){return;}var i=t.parent().children(".sapMLIB");t.attr(q.extend({"aria-setsize":i.length,"aria-posinset":i.index(t)+1},A));};L.prototype.getDeleteControl=function(){if(this._oDeleteControl){return this._oDeleteControl;}this._oDeleteControl=new a({id:this.getId()+"-imgDel",src:this.DeleteIconURI,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_DELETE"),noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBIconDel").attachPress(function(e){this.informList("Delete");},this);return this._oDeleteControl;};L.prototype.getDetailControl=function(){if(this._oDetailControl){return this._oDetailControl;}this._oDetailControl=new a({id:this.getId()+"-imgDet",src:this.DetailIconURI,tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_ITEM_EDIT"),noTabStop:true}).setParent(this,null,true).attachPress(function(){this.fireDetailTap();this.fireDetailPress();},this).addStyleClass("sapMLIBType sapMLIBIconDet");return this._oDetailControl;};L.prototype.getNavigationControl=function(){if(this._oNavigationControl){return this._oNavigationControl;}this._oNavigationControl=new a({id:this.getId()+"-imgNav",src:this.NavigationIconURI,useIconTooltip:false,noTabStop:true}).setParent(this,null,true).addStyleClass("sapMLIBType sapMLIBImgNav");return this._oNavigationControl;};L.prototype.getSingleSelectControl=function(){if(this._oSingleSelectControl){return this._oSingleSelectControl;}this._oSingleSelectControl=new sap.m.RadioButton({id:this.getId()+"-selectSingle",groupName:this.getListProperty("id")+"_selectGroup",activeHandling:false,selected:this.getSelected()}).setParent(this,null,true).setTabIndex(-1).attachSelect(function(e){var s=e.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oSingleSelectControl;};L.prototype.getMultiSelectControl=function(){if(this._oMultiSelectControl){return this._oMultiSelectControl;}this._oMultiSelectControl=new sap.m.CheckBox({id:this.getId()+"-selectMulti",activeHandling:false,selected:this.getSelected()}).setParent(this,null,true).setTabIndex(-1).attachSelect(function(e){var s=e.getParameter("selected");this.setSelected(s);this.informList("Select",s);},this);return this._oMultiSelectControl;};L.prototype.getModeControl=function(u){var m=this.getMode(),b=sap.m.ListMode;if(!m||m==b.None){return;}if(m==b.Delete){return this.getDeleteControl();}var s=null;if(m==b.MultiSelect){s=this.getMultiSelectControl();}else{s=this.getSingleSelectControl();}if(s&&u){s.setSelected(this.getSelected());}return s;};L.prototype.getTypeControl=function(){var t=this.getType(),T=sap.m.ListType;if(t==T.Detail||t==T.DetailAndActive){return this.getDetailControl();}if(t==T.Navigation){return this.getNavigationControl();}};L.prototype.destroyControls=function(c){c.forEach(function(s){s="_o"+s+"Control";if(this[s]){this[s].destroy("KeepDom");this[s]=null;}},this);};L.prototype.isActionable=function(){return this.getListProperty("includeItemInSelection")||this.getMode()==sap.m.ListMode.SingleSelectMaster||(this.getType()!=sap.m.ListType.Inactive&&this.getType()!=sap.m.ListType.Detail);};L.prototype.exit=function(){this._oLastFocused=null;this._checkHighlight(false);this.setActive(false);this.destroyControls(["Delete","SingleSelect","MultiSelect","Detail","Navigation"]);};L.prototype.isSelectable=function(){var m=this.getMode();return!(m==sap.m.ListMode.None||m==sap.m.ListMode.Delete);};L.prototype.getSelected=function(){if(this.isSelectable()){return this.getProperty("selected");}return false;};L.prototype.isSelected=L.prototype.getSelected;L.prototype.setSelected=function(s,d){s=this.validateProperty("selected",s);if(!this.isSelectable()||s==this.getSelected()){return this;}if(!d){this.informSelectedChange(s);}var S=this.getModeControl();if(S){S.setSelected(s);}this.updateSelectedDOM(s,this.$());this.setProperty("selected",s,true);return this;};L.prototype.updateSelectedDOM=function(s,t){t.toggleClass("sapMLIBSelected",s);t.attr("aria-selected",s);};L.prototype.setParent=function(p){C.prototype.setParent.apply(this,arguments);if(!p){this._bGroupHeader=false;return;}this.informList("Inserted",this.bSelectedDelayed);return this;};L.prototype.setBindingContext=function(){C.prototype.setBindingContext.apply(this,arguments);this.informList("BindingContextSet");return this;};L.prototype.isGroupHeader=function(){return this._bGroupHeader;};L.prototype.isIncludedIntoSelection=function(){var m=this.getMode(),M=sap.m.ListMode;return(m==M.SingleSelectMaster||(this.getListProperty("includeItemInSelection")&&(m==M.SingleSelectLeft||m==M.SingleSelect||m==M.MultiSelect)));};L.prototype._checkHighlight=function(n){if(n==undefined){n=(this.getVisible()&&this.getHighlight()!="None");}if(this._bNeedsHighlight!=n){this._bNeedsHighlight=n;this.informList("HighlightChange",n);}};L.prototype.hasActiveType=function(){var t=sap.m.ListType,T=this.getType();return(T==t.Active||T==t.Navigation||T==t.DetailAndActive);};L.prototype.setActive=function(A){if(A==this._active){return this;}if(A&&this.getListProperty("activeItem")){return this;}var t=this.$();this._active=A;this._activeHandling(t);if(this.getType()==sap.m.ListType.Navigation){this._activeHandlingNav(t);}if(A){this._activeHandlingInheritor(t);}else{this._inactiveHandlingInheritor(t);}this.informList("ActiveChange",A);};L.prototype.ontap=function(e){if(this._eventHandledByControl){return;}if(this.isIncludedIntoSelection()){if(this.getMode()==sap.m.ListMode.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}}else if(this.hasActiveType()){window.clearTimeout(this._timeoutIdStart);window.clearTimeout(this._timeoutIdEnd);this.setActive(true);if(sap.ui.Device.os.ios){this.focus();}q.sap.delayedCall(180,this,function(){this.setActive(false);});q.sap.delayedCall(0,this,function(){this.fireTap();this.firePress();});}this.informList("Press",e.srcControl);};L.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();var t=e.targetTouches[0];this._touchedY=t.clientY;this._touchedX=t.clientX;if(this._eventHandledByControl||e.touches.length!=1||!this.hasActiveType()){return;}this._timeoutIdStart=q.sap.delayedCall(100,this,function(){this.setActive(true);e.setMarked();});};L.prototype.ontouchmove=function(e){if((this._active||this._timeoutIdStart)&&(Math.abs(this._touchedY-e.targetTouches[0].clientY)>10||Math.abs(this._touchedX-e.targetTouches[0].clientX)>10)){clearTimeout(this._timeoutIdStart);this._timeoutIdStart=null;this._timeoutIdEnd=null;this.setActive(false);}};L.prototype.ontouchend=function(e){if(e.targetTouches.length==0&&this.hasActiveType()){this._timeoutIdEnd=q.sap.delayedCall(100,this,function(){this.setActive(false);});}};L.prototype.ontouchcancel=L.prototype.ontouchend;L.prototype._activeHandlingNav=function(){};L.prototype._activeHandlingInheritor=function(){};L.prototype._inactiveHandlingInheritor=function(){};L.prototype._activeHandling=function(t){t.toggleClass("sapMLIBActive",this._active);if(sap.ui.Device.system.Desktop&&this.isActionable()){t.toggleClass("sapMLIBHoverable",!this._active);}};L.prototype.onsapspace=function(e){if(e.srcControl!==this){return;}e.preventDefault();if(e.isMarked()||!this.isSelectable()){return;}if(this.getMode()==sap.m.ListMode.MultiSelect){this.setSelected(!this.getSelected());this.informList("Select",this.getSelected());}else if(!this.getSelected()){this.setSelected(true);this.informList("Select",true);}e.setMarked();};L.prototype.onsapenter=function(e){var o=this.getList();if(e.isMarked()||!o){return;}var k=sap.m.ListKeyboardMode;if(e.srcControl!==this&&o.getKeyboardMode()==k.Edit){o.setKeyboardMode(k.Navigation);this._switchFocus(e);return;}if(e.srcControl!==this){return;}if(this.isIncludedIntoSelection()){this.onsapspace(e);}else if(this.hasActiveType()){e.setMarked();this.setActive(true);q.sap.delayedCall(180,this,function(){this.setActive(false);});q.sap.delayedCall(0,this,function(){this.fireTap();this.firePress();});}o.onItemPress(this,e.srcControl);};L.prototype.onsapdelete=function(e){if(e.isMarked()||e.srcControl!==this||this.getMode()!=sap.m.ListMode.Delete){return;}this.informList("Delete");e.preventDefault();e.setMarked();};L.prototype._switchFocus=function(e){var o=this.getList();if(!o){return;}var t=this.getTabbables();if(e.srcControl!==this){o._iLastFocusPosOfItem=t.index(e.target);this.focus();}else if(t.length){var f=o._iLastFocusPosOfItem||0;f=t[f]?f:-1;t.eq(f).focus();}e.preventDefault();e.setMarked();};L.prototype.onkeydown=function(e){if(e.isMarked()){return;}var k=q.sap.KeyCodes;if(e.which==k.F7){this._switchFocus(e);return;}if(e.which==k.F2){if(e.srcControl===this&&this.getType().indexOf("Detail")==0&&this.hasListeners("detailPress")||this.hasListeners("detailTap")){this.fireDetailTap();this.fireDetailPress();e.preventDefault();e.setMarked();}else{var o=this.getList();if(o){this.$().prop("tabIndex",-1);var K=sap.m.ListKeyboardMode;o.setKeyboardMode(o.getKeyboardMode()==K.Edit?K.Navigation:K.Edit);this._switchFocus(e);}}}};L.prototype.getTabbables=function(){return this.$().find(":sapTabbable");};L.prototype.onsaptabnext=function(e){var o=this.getList();if(!o||e.isMarked()||o.getKeyboardMode()==sap.m.ListKeyboardMode.Edit){return;}var b=this.getTabbables().get(-1)||this.getDomRef();if(e.target===b){o.forwardTab(true);e.setMarked();}};L.prototype.onsaptabprevious=function(e){var o=this.getList();if(!o||e.isMarked()||o.getKeyboardMode()==sap.m.ListKeyboardMode.Edit){return;}if(e.target===this.getDomRef()){o.forwardTab(false);e.setMarked();}};L.prototype.onfocusin=function(e){var o=this.getList();if(!o||e.isMarked()){return;}if(e.srcControl===this){o.onItemFocusIn(this);return;}if(o.getKeyboardMode()==sap.m.ListKeyboardMode.Edit||!q(e.target).is(":sapFocusable")){return;}q.sap.delayedCall(0,o,"setItemFocusable",[this]);e.setMarked();};L.prototype.onsapup=function(e){if(e.isMarked()||e.srcControl===this||this.getListProperty("keyboardMode")===sap.m.ListKeyboardMode.Navigation){return;}this.informList("ArrowUpDown",e);};L.prototype.onsapdown=L.prototype.onsapup;return L;},true);
